/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile.output;

import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.output.ProfileFormat;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLTable;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class ProfilePDFFormat
implements ProfileFormat {
    private static final int PIXELS_PER_BORDER = 6;
    private static final Logger logger = Logger.getLogger(ProfilePDFFormat.class);
    private static final int STACK_TRACE_LENGTH = 4;
    private int totalColumn;
    private final String[] headings = new String[]{"Column Name", "Data Type", "Null Count", "% null", "Unique Count", "% unique", "Min Length", "Max Length", "Avg Length", "Min Value", "Max Value", "Avg Value", "Top N Values", "Count"};
    private List<String> columnsToTruncate = new ArrayList<String>();
    private double truncateLength = -1.0;

    public ProfilePDFFormat() {
        this.totalColumn = this.headings.length;
        this.columnsToTruncate.add("Min Value");
        this.columnsToTruncate.add("Max Value");
        this.columnsToTruncate.add("Top N Values");
    }

    @Override
    public void format(OutputStream out, List<ProfileResult> profileResults) throws DocumentException, IOException, SQLException, SQLObjectException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        boolean minRowsTogether = true;
        int mtop = 50;
        int mbot = 50;
        int mlft = 50;
        int mrgt = 50;
        final Rectangle pagesize = PageSize.LETTER.rotate();
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
        float fsize = 6.0f;
        final BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        document.addTitle("Table Profiling Report");
        document.addSubject("Tables: " + profileResults);
        document.addAuthor(System.getProperty("user.name"));
        document.addCreator("Power*Architect version " + (Object)((Object)ArchitectVersion.APP_FULL_VERSION));
        document.open();
        float pos = pagesize.height() - 50.0f;
        final PdfContentByte cb = writer.getDirectContent();
        final PdfTemplate nptemplate = cb.createTemplate(50.0f, 50.0f);
        writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

            public void onEndPage(PdfWriter writer, Document document) {
                int pageN = writer.getPageNumber();
                String text = "Page " + pageN + " of ";
                float len = bf.getWidthPoint(text, 4.0f);
                cb.beginText();
                cb.setFontAndSize(bf, 4.0f);
                cb.setTextMatrix(pagesize.width() / 2.0f - len / 2.0f, 25.0f);
                cb.showText(text);
                cb.endText();
                cb.addTemplate(nptemplate, pagesize.width() / 2.0f - len / 2.0f + len, 25.0f);
            }

            public void onCloseDocument(PdfWriter writer, Document document) {
                nptemplate.beginText();
                nptemplate.setFontAndSize(bf, 4.0f);
                nptemplate.showText(String.valueOf(writer.getPageNumber() - 1));
                nptemplate.endText();
            }
        });
        document.add((Element)new Paragraph("SQL Power Architect Profiling Report"));
        document.add((Element)new Paragraph("Generated " + new Date() + " by " + System.getProperty("user.name")));
        float[] widths = new float[this.totalColumn];
        LinkedList<ProfileTableStructure> profiles = new LinkedList<ProfileTableStructure>();
        Font f = new Font(bf, 6.0f);
        DDLGenerator ddlg = null;
        PdfPTable pdfTable = null;
        for (ProfileResult result : profileResults) {
            if (result instanceof TableProfileResult) {
                TableProfileResult tableResult = (TableProfileResult)result;
                pdfTable = new PdfPTable(widths.length);
                pdfTable.setWidthPercentage(100.0f);
                ProfileTableStructure oneProfile = this.makeNextTable(tableResult, pdfTable, bf, 6.0f, widths);
                profiles.add(oneProfile);
                ddlg = tableResult.getDDLGenerator();
                continue;
            }
            if (!(result instanceof ColumnProfileResult)) continue;
            ColumnProfileResult columnResult = (ColumnProfileResult)result;
            TableProfileResult tResult = columnResult.getParent();
            this.addBodyRow(tResult, columnResult, ddlg, pdfTable, bf, f, 6.0f, widths);
        }
        double allowedTableSize = pagesize.width() - 50.0f - 50.0f;
        double totalWidths = 0.0;
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.columnsToTruncate.contains(this.headings[i])) continue;
            int n = i;
            widths[n] = widths[n] + 6.0f;
            totalWidths += (double)widths[i];
        }
        this.truncateLength = (allowedTableSize - totalWidths - (double)(6 * this.columnsToTruncate.size())) / (double)this.columnsToTruncate.size();
        logger.debug((Object)("Truncate length is " + this.truncateLength));
        widths = new float[this.totalColumn];
        profiles = new LinkedList();
        for (ProfileResult result : profileResults) {
            if (result instanceof TableProfileResult) {
                TableProfileResult tableResult = (TableProfileResult)result;
                pdfTable = new PdfPTable(widths.length);
                pdfTable.setWidthPercentage(100.0f);
                ProfileTableStructure oneProfile = this.makeNextTable(tableResult, pdfTable, bf, 6.0f, widths);
                profiles.add(oneProfile);
                ddlg = tableResult.getDDLGenerator();
                continue;
            }
            if (!(result instanceof ColumnProfileResult)) continue;
            ColumnProfileResult columnResult = (ColumnProfileResult)result;
            TableProfileResult tResult = columnResult.getParent();
            this.addBodyRow(tResult, columnResult, ddlg, pdfTable, bf, f, 6.0f, widths);
        }
        int i = 0;
        while (i < this.headings.length) {
            int n = i++;
            widths[n] = widths[n] + 6.0f;
        }
        pos = writer.getVerticalPosition(true) - 6.0f;
        logger.debug((Object)("Starting at pos=" + pos));
        boolean newPageInd = true;
        for (ProfileTableStructure profile : profiles) {
            int startrow;
            pdfTable = profile.getMainTable();
            pdfTable.setTotalWidth(pagesize.width() - 50.0f - 50.0f);
            pdfTable.setWidths(widths);
            this.resetHeaderWidths(profile, widths);
            int endrow = startrow = pdfTable.getHeaderRows();
            if (endrow == pdfTable.size()) {
                pos = pdfTable.writeSelectedRows(0, pdfTable.getHeaderRows(), 50.0f, pos, cb);
                continue;
            }
            while (endrow < pdfTable.size()) {
                float endpos = pos - this.calcHeaderHeight(pdfTable);
                while (endpos - pdfTable.getRowHeight(endrow) >= 33.0f && endrow < pdfTable.size()) {
                    endpos -= pdfTable.getRowHeight(endrow);
                    ++endrow;
                }
                if (endrow < pdfTable.size() && endrow + 1 >= pdfTable.size()) {
                    endrow = endrow + 1 == pdfTable.size() && endpos - pdfTable.getRowHeight(endrow) > 10.0f ? pdfTable.size() : pdfTable.size() - 1;
                }
                if (endrow == pdfTable.size() || endrow - startrow >= 1) {
                    pos = pdfTable.writeSelectedRows(0, pdfTable.getHeaderRows(), 50.0f, pos, cb);
                    pos = pdfTable.writeSelectedRows(startrow, endrow, 50.0f, pos, cb);
                    startrow = endrow;
                    newPageInd = false;
                } else {
                    if (newPageInd) {
                        throw new IllegalStateException("PDF Page is not large engouh to display 1 row(s)");
                    }
                    endrow = startrow;
                }
                if (endrow == pdfTable.size()) continue;
                document.newPage();
                pos = pagesize.height() - 50.0f;
                newPageInd = true;
            }
        }
        document.close();
    }

    private float calcHeaderHeight(PdfPTable table) {
        int hrows = table.getHeaderRows();
        float height = 0.0f;
        for (int i = 0; i < hrows; ++i) {
            height += table.getRowHeight(i);
        }
        return height;
    }

    protected ProfileTableStructure makeNextTable(TableProfileResult result, PdfPTable table, BaseFont bf, float fsize, float[] widths) throws DocumentException, IOException, SQLObjectException, SQLException, InstantiationException, IllegalAccessException {
        logger.debug((Object)"Making next table");
        float titleFSize = fsize * 1.5f;
        float colHeadingFSize = fsize;
        ProfileTableStructure profile = new ProfileTableStructure(table);
        this.addHeaderRow(result, profile, bf, titleFSize, colHeadingFSize, widths);
        logger.debug((Object)"Finished body rows");
        table.setWidths(widths);
        return profile;
    }

    private void addHeaderRow(TableProfileResult result, ProfileTableStructure profile, BaseFont bf, float titleFSize, float colHeadingFSize, float[] widths) throws DocumentException, IOException, SQLObjectException {
        int ncols = this.headings.length;
        Font titleFont = new Font(bf, titleFSize, 1);
        Font colHeadingFont = new Font(bf, colHeadingFSize);
        PdfPTable table = profile.getMainTable();
        SQLTable sqlTable = (SQLTable)result.getProfiledObject();
        PdfPTable infoTable = new PdfPTable(2);
        StringBuffer heading = new StringBuffer();
        heading.append("Connection: ").append(sqlTable.getParentDatabase().getName()).append("\n");
        heading.append("Table: ").append(SQLObjectUtils.toQualifiedName((SQLObject)sqlTable, SQLDatabase.class));
        if (result.getException() != null) {
            heading.append("\nProfiling Error");
            if (result.getException() != null) {
                heading.append(":\n").append(result.getException());
                StackTraceElement[] stackTrace = result.getException().getStackTrace();
                for (int i = 0; i < 4 && i < stackTrace.length; ++i) {
                    StackTraceElement element = stackTrace[i];
                    heading.append("\n   ").append(element.getFileName()).append(".").append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getLineNumber()).append(")");
                }
                if (stackTrace.length > 4) {
                    heading.append("\n   ... ").append(stackTrace.length).append(" more");
                }
            }
        } else {
            PdfPCell infoCell = new PdfPCell(new Phrase("Row Count:", colHeadingFont));
            infoCell.setBorder(0);
            infoCell.setHorizontalAlignment(2);
            infoTable.addCell(infoCell);
            infoCell = new PdfPCell(new Phrase(String.valueOf(result.getRowCount()), colHeadingFont));
            infoCell.setBorder(0);
            infoTable.addCell(infoCell);
            infoCell = new PdfPCell(new Phrase("Create Date:", colHeadingFont));
            infoCell.setBorder(0);
            infoCell.setHorizontalAlignment(2);
            infoTable.addCell(infoCell);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            infoCell = new PdfPCell(new Phrase(df.format(new Date(result.getCreateStartTime())), colHeadingFont));
            infoCell.setBorder(0);
            infoTable.addCell(infoCell);
            infoCell = new PdfPCell(new Phrase("Elapsed:", colHeadingFont));
            infoCell.setBorder(0);
            infoCell.setHorizontalAlignment(2);
            infoTable.addCell(infoCell);
            infoCell = new PdfPCell(new Phrase(result.getTimeToCreate() + "ms", colHeadingFont));
            infoCell.setBorder(0);
            infoTable.addCell(infoCell);
        }
        PdfPCell hcell = new PdfPCell(new Phrase(heading.toString(), titleFont));
        hcell.setColspan(ncols - 3);
        hcell.setBorder(0);
        hcell.setVerticalAlignment(6);
        table.addCell(hcell);
        hcell = new PdfPCell(infoTable);
        hcell.setColspan(3);
        hcell.setBorder(0);
        table.addCell(hcell);
        if (sqlTable.getColumns().size() > 0) {
            int colNo = 0;
            Phrase colTitle = new Phrase("Column Name", colHeadingFont);
            PdfPCell cell = new PdfPCell(colTitle);
            cell.setBorder(3);
            cell.setBorderWidth(2.0f);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            colTitle = new Phrase("Data Type", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setBorder(3);
            cell.setBorderWidth(2.0f);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setHorizontalAlignment(1);
            table.addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            colTitle = new Phrase("NULL", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setColspan(2);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableNullColumn().addCell(cell);
            colTitle = new Phrase("#", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableNullColumn().addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("%", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableNullColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            cell = new PdfPCell(profile.getInnerTableNullColumn());
            cell.setColspan(2);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setBorderWidth(2.0f);
            cell.setBorder(3);
            table.addCell(cell);
            colTitle = new Phrase("Unique", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            cell.setColspan(2);
            profile.getInnerTableUniqueColumn().addCell(cell);
            colTitle = new Phrase("#", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableUniqueColumn().addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("%", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableUniqueColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            cell = new PdfPCell(profile.getInnerTableUniqueColumn());
            cell.setColspan(2);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setBorder(3);
            cell.setBorderWidth(2.0f);
            table.addCell(cell);
            colTitle = new Phrase("Length", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            cell.setColspan(3);
            profile.getInnerTableLengthColumn().addCell(cell);
            colTitle = new Phrase("Min", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableLengthColumn().addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("Max", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableLengthColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("Avg", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableLengthColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            cell = new PdfPCell(profile.getInnerTableLengthColumn());
            cell.setColspan(3);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setBorderWidth(2.0f);
            cell.setBorder(3);
            table.addCell(cell);
            colTitle = new Phrase("Value", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            cell.setColspan(3);
            profile.getInnerTableValueColumn().addCell(cell);
            colTitle = new Phrase("Min", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableValueColumn().addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("Max", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableValueColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("Avg", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableValueColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            cell = new PdfPCell(profile.getInnerTableValueColumn());
            cell.setColspan(3);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setBorderWidth(2.0f);
            cell.setBorder(3);
            table.addCell(cell);
            colTitle = new Phrase("Top N", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            cell.setColspan(2);
            profile.getInnerTableTopNColumn().addCell(cell);
            colTitle = new Phrase("Values", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableTopNColumn().addCell(cell);
            widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            colTitle = new Phrase("#", colHeadingFont);
            cell = new PdfPCell(colTitle);
            cell.setHorizontalAlignment(1);
            profile.getInnerTableTopNColumn().addCell(cell);
            widths[++colNo] = Math.max(widths[colNo], bf.getWidthPoint(colTitle.content(), colHeadingFSize));
            ++colNo;
            cell = new PdfPCell(profile.getInnerTableTopNColumn());
            cell.setColspan(2);
            cell.setBackgroundColor(new Color(200, 200, 200));
            cell.setBorderWidth(2.0f);
            cell.setBorder(3);
            table.addCell(cell);
        } else {
            hcell = new PdfPCell(new Phrase("No Column Found in the table", titleFont));
            hcell.setColspan(ncols);
            hcell.setBorder(2);
            hcell.setVerticalAlignment(0);
            table.addCell(hcell);
        }
        table.setHeaderRows(2);
    }

    private void resetHeaderWidths(ProfileTableStructure profile, float[] widths) throws DocumentException {
        this.resetTableHeaderWidths(profile.getInnerTableNullColumn(), widths, 2, 3);
        this.resetTableHeaderWidths(profile.getInnerTableUniqueColumn(), widths, 4, 5);
        this.resetTableHeaderWidths(profile.getInnerTableLengthColumn(), widths, 6, 8);
        this.resetTableHeaderWidths(profile.getInnerTableValueColumn(), widths, 9, 11);
        this.resetTableHeaderWidths(profile.getInnerTableTopNColumn(), widths, 12, 13);
    }

    private void resetTableHeaderWidths(PdfPTable table, float[] widths, int start, int end) throws DocumentException {
        float[] headerWidths = new float[end - start + 1];
        for (int i = start; i <= end; ++i) {
            headerWidths[i - start] = widths[i];
        }
        if (table != null) {
            table.setWidths(headerWidths);
        }
    }

    private void addBodyRow(TableProfileResult tProfile, ColumnProfileResult result, DDLGenerator ddlg, PdfPTable table, BaseFont bf, Font f, float fsize, float[] widths) throws DocumentException, IOException, SQLObjectException, SQLException {
        SQLColumn col = (SQLColumn)result.getProfiledObject();
        int rowCount = -1;
        if (tProfile != null && tProfile.getException() == null) {
            rowCount = tProfile.getRowCount();
        }
        List<ColumnValueCount> topTen = null;
        boolean errorColumnProfiling = false;
        Exception columnException = null;
        if (result != null && result.getException() == null) {
            topTen = result.getValueCount();
        } else {
            errorColumnProfiling = true;
            if (result != null && result.getException() != null) {
                columnException = result.getException();
                logger.debug((Object)("Exception " + columnException + " on column " + col.getName()));
            }
        }
        DecimalFormat pctFormat = new DecimalFormat("0%");
        DecimalFormat df = new DecimalFormat("#,##0.00");
        df.setMaximumFractionDigits(col.getScale());
        df.setMinimumFractionDigits(col.getScale());
        DecimalFormat adf = new DecimalFormat("#,##0.00");
        adf.setMaximumFractionDigits(Math.max(2, col.getScale()));
        adf.setMinimumFractionDigits(Math.max(2, col.getScale()));
        DecimalFormat aldf = new DecimalFormat("#,##0.0");
        aldf.setMaximumFractionDigits(1);
        aldf.setMinimumFractionDigits(0);
        boolean errorSpanRemaining = false;
        for (int colNo = 0; colNo < this.totalColumn; ++colNo) {
            PdfPCell cell;
            StringBuffer sb;
            int alignment;
            String contents;
            if (this.headings[colNo].equalsIgnoreCase("table name")) {
                String fqTableName = SQLObjectUtils.toQualifiedName((SQLObject)col.getParent(), SQLDatabase.class);
                if (tProfile == null || tProfile.getException() != null) {
                    contents = fqTableName + "\nProfiling Error:\n";
                    if (tProfile != null && tProfile.getException() != null) {
                        contents = contents + tProfile.getException();
                        errorSpanRemaining = true;
                    }
                } else {
                    contents = fqTableName;
                }
                alignment = 0;
            } else if (this.headings[colNo].equalsIgnoreCase("row count")) {
                contents = String.valueOf(rowCount);
                alignment = 2;
            } else if (this.headings[colNo].equalsIgnoreCase("column name")) {
                contents = col.getName();
                alignment = 0;
            } else if (this.headings[colNo].equalsIgnoreCase("data type")) {
                contents = ddlg.columnType(col);
                alignment = 0;
            } else if (this.headings[colNo].equalsIgnoreCase("null count")) {
                if (errorColumnProfiling) {
                    if (result == null) {
                        contents = "Column Profiling Not Found\n";
                    } else {
                        contents = "Column Profiling Error:\n";
                        if (columnException != null) {
                            contents = contents + columnException;
                            errorSpanRemaining = true;
                        }
                    }
                    alignment = 0;
                } else {
                    contents = col.isDefinitelyNullable() ? String.valueOf(result.getNullCount()) : "---";
                    alignment = 2;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("% null")) {
                if (errorColumnProfiling) continue;
                if (col.isDefinitelyNullable()) {
                    if (rowCount <= 0) {
                        contents = "N/A";
                        alignment = 1;
                    } else {
                        contents = pctFormat.format((double)result.getNullCount() / (double)rowCount);
                        alignment = 2;
                    }
                } else {
                    contents = "---";
                    alignment = 1;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Unique Count")) {
                if (errorColumnProfiling) continue;
                contents = String.valueOf(result.getDistinctValueCount());
                alignment = 2;
            } else if (this.headings[colNo].equalsIgnoreCase("% unique")) {
                if (errorColumnProfiling) continue;
                if (rowCount == 0) {
                    contents = "N/A";
                    alignment = 1;
                } else {
                    contents = pctFormat.format((double)result.getDistinctValueCount() / (double)rowCount);
                    alignment = 2;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Min Length")) {
                if (!errorColumnProfiling) {
                    contents = String.valueOf(result.getMinLength());
                    alignment = 2;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Max Length")) {
                if (!errorColumnProfiling) {
                    contents = String.valueOf(result.getMaxLength());
                    alignment = 2;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("avg Length")) {
                if (!errorColumnProfiling) {
                    contents = aldf.format(result.getAvgLength());
                    alignment = 2;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Min value")) {
                if (!errorColumnProfiling) {
                    if (result.getMinValue() == null) {
                        alignment = 1;
                        contents = "";
                    } else if (result.getMinValue() instanceof Number) {
                        alignment = 2;
                        contents = df.format((Number)result.getMinValue());
                    } else {
                        alignment = 0;
                        contents = String.valueOf(result.getMinValue());
                    }
                    alignment = 0;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Max value")) {
                if (!errorColumnProfiling) {
                    if (result.getMaxValue() == null) {
                        alignment = 1;
                        contents = "";
                    } else if (result.getMaxValue() instanceof Number) {
                        alignment = 2;
                        contents = df.format((Number)result.getMaxValue());
                    } else {
                        alignment = 0;
                        contents = String.valueOf(result.getMaxValue());
                    }
                    alignment = 0;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("avg value")) {
                if (!errorColumnProfiling) {
                    if (result.getAvgValue() == null) {
                        alignment = 1;
                        contents = "";
                    } else if (result.getAvgValue() instanceof Number) {
                        alignment = 2;
                        contents = adf.format((Number)result.getAvgValue());
                    } else {
                        alignment = 0;
                        contents = String.valueOf(result.getAvgValue());
                    }
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Top N Values")) {
                if (!errorColumnProfiling && topTen != null) {
                    sb = new StringBuffer();
                    for (ColumnValueCount cvc : topTen) {
                        sb.append(cvc.getValue()).append("\n");
                    }
                    contents = sb.toString();
                    alignment = 0;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else if (this.headings[colNo].equalsIgnoreCase("Count")) {
                if (!errorColumnProfiling) {
                    sb = new StringBuffer();
                    for (ColumnValueCount cvc : topTen) {
                        sb.append(cvc.getCount()).append("\n");
                    }
                    contents = sb.toString();
                    alignment = 2;
                } else {
                    contents = "";
                    alignment = 0;
                }
            } else {
                throw new IllegalStateException("I don't know about column " + colNo);
            }
            StringBuffer truncContents = new StringBuffer(contents.length());
            for (String contentLine : contents.split("\n")) {
                String newLine;
                if (this.truncateLength >= 0.0 && !errorSpanRemaining) {
                    if ((double)bf.getWidthPoint(contentLine, fsize) < this.truncateLength) {
                        newLine = contentLine + "\n";
                    } else {
                        int stringPosition;
                        double currentLength = bf.getWidthPoint("...", fsize);
                        for (stringPosition = 0; stringPosition < contentLine.length() && !(currentLength > this.truncateLength); ++stringPosition) {
                            currentLength = bf.getWidthPoint(contentLine.substring(0, stringPosition) + "...", fsize);
                            ++stringPosition;
                        }
                        newLine = contentLine.substring(0, stringPosition - 1) + "...\n";
                    }
                } else {
                    newLine = contentLine + "\n";
                }
                truncContents.append(newLine);
                if (errorSpanRemaining) continue;
                widths[colNo] = Math.max(widths[colNo], bf.getWidthPoint(newLine, fsize));
                logger.debug((Object)("width is now " + widths[colNo] + " for column " + colNo));
            }
            if (this.headings[colNo].equalsIgnoreCase("Top N Values") || this.headings[colNo].equalsIgnoreCase("Count")) {
                cell = new PdfPCell((Phrase)new Paragraph(truncContents.toString(), f));
                cell.setNoWrap(true);
            } else if (this.headings[colNo].equalsIgnoreCase("null count") && errorColumnProfiling) {
                cell = new PdfPCell((Phrase)new Paragraph(truncContents.toString(), f));
                cell.setColspan(4);
            } else {
                Phrase phr = new Phrase(truncContents.toString(), f);
                cell = new PdfPCell(phr);
            }
            cell.setHorizontalAlignment(alignment);
            if (errorSpanRemaining) {
                cell.setColspan(this.totalColumn - colNo);
            }
            table.addCell(cell);
            if (errorSpanRemaining) break;
        }
    }

    private class ProfileTableStructure {
        private PdfPTable innerTableNullColumn = null;
        private PdfPTable innerTableUniqueColumn = null;
        private PdfPTable innerTableLengthColumn = null;
        private PdfPTable innerTableValueColumn = null;
        private PdfPTable innerTableTopNColumn = null;
        private PdfPTable mainTable = null;

        public ProfileTableStructure(PdfPTable mainTable) {
            this.mainTable = mainTable;
            this.innerTableNullColumn = new PdfPTable(2);
            this.innerTableUniqueColumn = new PdfPTable(2);
            this.innerTableLengthColumn = new PdfPTable(3);
            this.innerTableValueColumn = new PdfPTable(3);
            this.innerTableTopNColumn = new PdfPTable(2);
        }

        public PdfPTable getInnerTableLengthColumn() {
            return this.innerTableLengthColumn;
        }

        public void setInnerTableLengthColumn(PdfPTable innerTableLengthColumn) {
            this.innerTableLengthColumn = innerTableLengthColumn;
        }

        public PdfPTable getInnerTableNullColumn() {
            return this.innerTableNullColumn;
        }

        public void setInnerTableNullColumn(PdfPTable innerTableNullColumn) {
            this.innerTableNullColumn = innerTableNullColumn;
        }

        public PdfPTable getInnerTableTopNColumn() {
            return this.innerTableTopNColumn;
        }

        public void setInnerTableTopNColumn(PdfPTable innerTableTopNColumn) {
            this.innerTableTopNColumn = innerTableTopNColumn;
        }

        public PdfPTable getInnerTableUniqueColumn() {
            return this.innerTableUniqueColumn;
        }

        public void setInnerTableUniqueColumn(PdfPTable innerTableUniqueColumn) {
            this.innerTableUniqueColumn = innerTableUniqueColumn;
        }

        public PdfPTable getInnerTableValueColumn() {
            return this.innerTableValueColumn;
        }

        public void setInnerTableValueColumn(PdfPTable innerTableValueColumn) {
            this.innerTableValueColumn = innerTableValueColumn;
        }

        public PdfPTable getMainTable() {
            return this.mainTable;
        }

        public void setMainTable(PdfPTable mainTable) {
            this.mainTable = mainTable;
        }
    }
}

