/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11SupportedOperatingClassesElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 2089786652681023988L;
    private final byte currentOperatingClass;
    private final byte[] operatingClasses;

    public static Dot11SupportedOperatingClassesElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11SupportedOperatingClassesElement(rawData, offset, length);
    }

    private Dot11SupportedOperatingClassesElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.SUPPORTED_OPERATING_CLASSES);
        int infoLen = this.getLengthAsInt();
        if (infoLen < 1) {
            throw new IllegalRawDataException("The length must be more than 0 but is actually: " + infoLen);
        }
        this.currentOperatingClass = rawData[offset + 2];
        this.operatingClasses = infoLen == 1 ? new byte[0] : ByteArrays.getSubArray(rawData, offset + 3, infoLen - 1);
    }

    private Dot11SupportedOperatingClassesElement(Builder builder2) {
        super(builder2);
        if (builder2.operatingClasses.length > 254) {
            throw new IllegalArgumentException("Too long operatingClasses: " + ByteArrays.toHexString(builder2.operatingClasses, " "));
        }
        this.currentOperatingClass = builder2.currentOperatingClass;
        this.operatingClasses = ByteArrays.clone(builder2.operatingClasses);
    }

    public byte getCurrentOperatingClass() {
        return this.currentOperatingClass;
    }

    public int getCurrentOperatingClassAsInt() {
        return this.currentOperatingClass & 0xFF;
    }

    public byte[] getOperatingClasses() {
        return ByteArrays.clone(this.operatingClasses);
    }

    @Override
    public int length() {
        return 3 + this.operatingClasses.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        rawData[2] = this.currentOperatingClass;
        System.arraycopy(this.operatingClasses, 0, rawData, 3, this.operatingClasses.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.currentOperatingClass;
        result = 31 * result + Arrays.hashCode(this.operatingClasses);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11SupportedOperatingClassesElement other = (Dot11SupportedOperatingClassesElement)obj;
        if (this.currentOperatingClass != other.currentOperatingClass) {
            return false;
        }
        return Arrays.equals(this.operatingClasses, other.operatingClasses);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Supported Operating Classes:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Current Operating Class: ").append(this.getCurrentOperatingClassAsInt()).append(ls);
        for (byte cls : this.operatingClasses) {
            sb.append(indent).append("  Operating Class: ").append(cls & 0xFF).append(ls);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private byte currentOperatingClass;
        private byte[] operatingClasses;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.SUPPORTED_OPERATING_CLASSES.value()));
        }

        private Builder(Dot11SupportedOperatingClassesElement elem) {
            super(elem);
            this.currentOperatingClass = elem.currentOperatingClass;
            this.operatingClasses = elem.operatingClasses;
        }

        public Builder currentOperatingClass(byte currentOperatingClass) {
            this.currentOperatingClass = currentOperatingClass;
            return this;
        }

        public Builder operatingClasses(byte[] operatingClasses) {
            this.operatingClasses = operatingClasses;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11SupportedOperatingClassesElement build() {
            if (this.operatingClasses == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("operatingClasses: ").append(this.operatingClasses);
                throw new NullPointerException(sb.toString());
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)(this.operatingClasses.length + 1));
            }
            return new Dot11SupportedOperatingClassesElement(this);
        }
    }
}

