/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.inputevt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.xml.namespace.QName;
import org.jitsi.xmpp.extensions.inputevt.RemoteControlExtensionProvider;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;

public class RemoteControlExtension
implements ExtensionElement {
    private final ComponentEvent event;
    private final Dimension videoPanelSize;
    public static final QName QNAME = new QName("http://jitsi.org/protocol/inputevt", "remote-control");

    public RemoteControlExtension() {
        this.videoPanelSize = null;
        this.event = null;
    }

    public RemoteControlExtension(Dimension videoPanelSize) {
        this.videoPanelSize = videoPanelSize;
        this.event = null;
    }

    public RemoteControlExtension(ComponentEvent event) {
        this.event = event;
        this.videoPanelSize = null;
    }

    public RemoteControlExtension(InputEvent event, Dimension videoPanelSize) {
        this.videoPanelSize = videoPanelSize;
        this.event = event;
    }

    public ComponentEvent getEvent() {
        return this.event;
    }

    @Override
    public String getElementName() {
        return "remote-control";
    }

    @Override
    public String getNamespace() {
        return "http://jitsi.org/protocol/inputevt";
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        String ret = null;
        if (this.event == null) {
            return null;
        }
        if (this.event instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)this.event;
            switch (e.getID()) {
                case 503: 
                case 506: {
                    if (this.videoPanelSize == null) break;
                    Point p = e.getPoint();
                    double x = p.getX() / (double)this.videoPanelSize.width;
                    double y = p.getY() / (double)this.videoPanelSize.height;
                    ret = RemoteControlExtensionProvider.getMouseMovedXML(x, y);
                    break;
                }
                case 507: {
                    MouseWheelEvent ew = (MouseWheelEvent)e;
                    ret = RemoteControlExtensionProvider.getMouseWheelXML(ew.getWheelRotation());
                    break;
                }
                case 501: {
                    ret = RemoteControlExtensionProvider.getMousePressedXML(e.getModifiersEx());
                    break;
                }
                case 502: {
                    ret = RemoteControlExtensionProvider.getMouseReleasedXML(e.getModifiersEx());
                    break;
                }
            }
        } else if (this.event instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)this.event;
            char key = e.getKeyChar();
            int keycode = key != '\uffff' ? e.getKeyChar() : e.getKeyCode();
            if (keycode == 0) {
                return null;
            }
            switch (e.getID()) {
                case 401: {
                    ret = RemoteControlExtensionProvider.getKeyPressedXML(keycode);
                    break;
                }
                case 402: {
                    ret = RemoteControlExtensionProvider.getKeyReleasedXML(keycode);
                    break;
                }
                case 400: {
                    ret = RemoteControlExtensionProvider.getKeyTypedXML(keycode);
                    break;
                }
            }
        }
        return ret;
    }
}

