/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.OptionalAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.message.ChannelData;
import org.ice4j.message.Indication;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.CredentialsManager;
import org.ice4j.security.LongTermCredential;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.ChannelDataEventHandler;
import org.ice4j.stack.EventDispatcher;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.NetAccessManager;
import org.ice4j.stack.PacketLogger;
import org.ice4j.stack.PeerUdpMessageEventHandler;
import org.ice4j.stack.RawMessage;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunClientTransaction;
import org.ice4j.stack.StunServerTransaction;
import org.ice4j.stack.TransactionID;
import org.jitsi.utils.concurrent.ExecutorFactory;

public class StunStack
implements MessageEventHandler {
    private static final Logger logger = Logger.getLogger(StunStack.class.getName());
    private static Mac mac;
    private static final ScheduledExecutorService tasksScheduler;
    private final NetAccessManager netAccessManager;
    private final CredentialsManager credentialsManager = new CredentialsManager();
    private final Hashtable<TransactionID, StunClientTransaction> clientTransactions = new Hashtable();
    private ExpiredServerTransactionsCollector expiredTransactionsCollector = new ExpiredServerTransactionsCollector();
    private final Hashtable<TransactionID, StunServerTransaction> serverTransactions = new Hashtable();
    private final EventDispatcher eventDispatcher = new EventDispatcher();
    private static PacketLogger packetLogger;

    public void addSocket(IceSocketWrapper sock) {
        this.netAccessManager.addSocket(sock);
    }

    public void addSocket(IceSocketWrapper sock, TransportAddress remoteAddress) {
        this.netAccessManager.addSocket(sock, remoteAddress);
    }

    public void removeSocket(TransportAddress localAddr) {
        this.removeSocket(localAddr, null);
    }

    public void removeSocket(TransportAddress localAddr, TransportAddress remoteAddr) {
        this.cancelTransactionsForAddress(localAddr, remoteAddr);
        this.netAccessManager.removeSocket(localAddr, remoteAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StunClientTransaction getClientTransaction(byte[] transactionID) {
        Hashtable<TransactionID, StunClientTransaction> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            Collection<StunClientTransaction> cTrans = this.clientTransactions.values();
            for (StunClientTransaction tran : cTrans) {
                if (!tran.getTransactionID().equals(transactionID)) continue;
                return tran;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StunServerTransaction getServerTransaction(byte[] transactionID) {
        Hashtable<TransactionID, StunServerTransaction> hashtable = this.serverTransactions;
        synchronized (hashtable) {
            long now = System.currentTimeMillis();
            Iterator<StunServerTransaction> i = this.serverTransactions.values().iterator();
            while (i.hasNext()) {
                StunServerTransaction serverTransaction = i.next();
                if (serverTransaction.isExpired(now)) {
                    i.remove();
                    continue;
                }
                if (!serverTransaction.getTransactionID().equals(transactionID)) continue;
                return serverTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StunServerTransaction getServerTransaction(TransactionID transactionID) {
        StunServerTransaction serverTransaction;
        Hashtable<TransactionID, StunServerTransaction> hashtable = this.serverTransactions;
        synchronized (hashtable) {
            serverTransaction = this.serverTransactions.get(transactionID);
        }
        if (serverTransaction != null && serverTransaction.isExpired()) {
            serverTransaction = null;
        }
        return serverTransaction;
    }

    public void cancelTransaction(TransactionID transactionID) {
        StunClientTransaction clientTransaction = this.clientTransactions.get(transactionID);
        if (clientTransaction != null) {
            clientTransaction.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTransactionsForAddress(TransportAddress localAddr, TransportAddress remoteAddr) {
        LinkedList<StunClientTransaction> clientTransactionsToCancel = null;
        Hashtable<TransactionID, StunClientTransaction> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            Iterator<StunClientTransaction> clientTransactionsIter = this.clientTransactions.values().iterator();
            while (clientTransactionsIter.hasNext()) {
                StunClientTransaction stunClientTransaction = clientTransactionsIter.next();
                if (!stunClientTransaction.getLocalAddress().equals(localAddr) || remoteAddr != null && !remoteAddr.equals(stunClientTransaction.getRemoteAddress())) continue;
                clientTransactionsIter.remove();
                if (clientTransactionsToCancel == null) {
                    clientTransactionsToCancel = new LinkedList<StunClientTransaction>();
                }
                clientTransactionsToCancel.add(stunClientTransaction);
            }
        }
        if (clientTransactionsToCancel != null) {
            for (StunClientTransaction tran : clientTransactionsToCancel) {
                tran.cancel();
            }
        }
        LinkedList<StunServerTransaction> serverTransactionsToExpire = null;
        Hashtable<TransactionID, StunServerTransaction> hashtable2 = this.serverTransactions;
        synchronized (hashtable2) {
            Iterator<StunServerTransaction> iterator2 = this.serverTransactions.values().iterator();
            while (iterator2.hasNext()) {
                StunServerTransaction tran = iterator2.next();
                TransportAddress listenAddr = tran.getLocalListeningAddress();
                TransportAddress sendingAddr = tran.getSendingAddress();
                if (!listenAddr.equals(localAddr) && (sendingAddr == null || !sendingAddr.equals(localAddr)) || remoteAddr != null && !remoteAddr.equals(tran.getRequestSourceAddress())) continue;
                iterator2.remove();
                if (serverTransactionsToExpire == null) {
                    serverTransactionsToExpire = new LinkedList<StunServerTransaction>();
                }
                serverTransactionsToExpire.add(tran);
            }
        }
        if (serverTransactionsToExpire != null) {
            for (StunServerTransaction stunServerTransaction : serverTransactionsToExpire) {
                stunServerTransaction.expire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StunStack(PeerUdpMessageEventHandler peerUdpMessageEventHandler, ChannelDataEventHandler channelDataEventHandler) {
        Class<StunStack> clazz = StunStack.class;
        synchronized (StunStack.class) {
            if (mac == null) {
                try {
                    mac = Mac.getInstance("HmacSHA1");
                }
                catch (NoSuchAlgorithmException nsaex) {
                    nsaex.printStackTrace();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.netAccessManager = new NetAccessManager(this, peerUdpMessageEventHandler, channelDataEventHandler);
            return;
        }
    }

    public StunStack() {
        this(null, null);
    }

    NetAccessManager getNetAccessManager() {
        return this.netAccessManager;
    }

    public void sendChannelData(ChannelData channelData, TransportAddress sendTo, TransportAddress sendThrough) throws StunException {
        try {
            this.getNetAccessManager().sendMessage(channelData, sendThrough, sendTo);
        }
        catch (StunException stex) {
            throw stex;
        }
        catch (IllegalArgumentException iaex) {
            throw new StunException(2, "Failed to send STUN indication: " + channelData, iaex);
        }
        catch (IOException ioex) {
            throw new StunException(4, "Failed to send STUN indication: " + channelData, ioex);
        }
    }

    public void sendUdpMessage(RawMessage udpMessage, TransportAddress sendTo, TransportAddress sendThrough) throws StunException {
        try {
            this.getNetAccessManager().sendMessage(udpMessage.getBytes(), sendThrough, sendTo);
        }
        catch (IllegalArgumentException iaex) {
            throw new StunException(2, "Failed to send STUN indication: " + udpMessage, iaex);
        }
        catch (IOException ioex) {
            throw new StunException(4, "Failed to send STUN indication: " + udpMessage, ioex);
        }
    }

    public void sendIndication(Indication indication, TransportAddress sendTo, TransportAddress sendThrough) throws StunException {
        if (indication.getTransactionID() == null) {
            indication.setTransactionID(TransactionID.createNewTransactionID().getBytes());
        }
        try {
            this.getNetAccessManager().sendMessage(indication, sendThrough, sendTo);
        }
        catch (IllegalArgumentException iaex) {
            throw new StunException(2, "Failed to send STUN indication: " + indication, iaex);
        }
        catch (IOException ioex) {
            throw new StunException(4, "Failed to send STUN indication: " + indication, ioex);
        }
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, TransportAddress sendThrough, ResponseCollector collector) throws IOException, IllegalArgumentException {
        return this.sendRequest(request, sendTo, sendThrough, collector, TransactionID.createNewTransactionID());
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, TransportAddress sendThrough, ResponseCollector collector, TransactionID transactionID) throws IllegalArgumentException, IOException {
        return this.sendRequest(request, sendTo, sendThrough, collector, transactionID, -1, -1, -1);
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, TransportAddress sendThrough, ResponseCollector collector, TransactionID transactionID, int originalWaitInterval, int maxWaitInterval, int maxRetransmissions) throws IllegalArgumentException, IOException {
        StunClientTransaction clientTransaction = new StunClientTransaction(this, request, sendTo, sendThrough, collector, transactionID);
        if (originalWaitInterval > 0) {
            clientTransaction.originalWaitInterval = originalWaitInterval;
        }
        if (maxWaitInterval > 0) {
            clientTransaction.maxWaitInterval = maxWaitInterval;
        }
        if (maxRetransmissions >= 0) {
            clientTransaction.maxRetransmissions = maxRetransmissions;
        }
        this.clientTransactions.put(clientTransaction.getTransactionID(), clientTransaction);
        clientTransaction.sendRequest();
        return clientTransaction.getTransactionID();
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, DatagramSocket sendThrough, ResponseCollector collector) throws IOException, IllegalArgumentException {
        TransportAddress sendThroughAddr = new TransportAddress(sendThrough.getLocalAddress(), sendThrough.getLocalPort(), Transport.UDP);
        return this.sendRequest(request, sendTo, sendThroughAddr, collector);
    }

    public void sendResponse(byte[] transactionID, Response response, TransportAddress sendThrough, TransportAddress sendTo) throws StunException, IOException, IllegalArgumentException {
        TransactionID tid = TransactionID.createTransactionID(this, transactionID);
        StunServerTransaction sTran = this.getServerTransaction(tid);
        if (sTran == null) {
            throw new StunException(3, "The transaction specified in the response (tid=" + tid.toString() + ") object does not exist.");
        }
        if (sTran.isRetransmitting()) {
            throw new StunException(5, "The transaction specified in the response (tid=" + tid.toString() + ") has already seen a previous response. Response was:\n" + sTran.getResponse());
        }
        sTran.sendResponse(response, sendThrough, sendTo);
    }

    public void addIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.eventDispatcher.addIndicationListener(localAddr, indicationListener);
    }

    public void addOldIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.eventDispatcher.addOldIndicationListener(localAddr, indicationListener);
    }

    public void addRequestListener(RequestListener requestListener) {
        this.eventDispatcher.addRequestListener(requestListener);
    }

    public void removeIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
    }

    public void removeRequestListener(RequestListener listener) {
        this.eventDispatcher.removeRequestListener(listener);
    }

    public void addRequestListener(TransportAddress localAddress, RequestListener listener) {
        this.eventDispatcher.addRequestListener(localAddress, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClientTransaction(StunClientTransaction tran) {
        Hashtable<TransactionID, StunClientTransaction> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            this.clientTransactions.remove(tran.getTransactionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServerTransaction(StunServerTransaction tran) {
        Hashtable<TransactionID, StunServerTransaction> hashtable = this.serverTransactions;
        synchronized (hashtable) {
            this.serverTransactions.remove(tran.getTransactionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageEvent(StunMessageEvent ev) {
        Message msg = ev.getMessage();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Received a message on " + ev.getLocalAddress() + " of type:" + msg.getMessageType());
        }
        if (msg instanceof Request) {
            logger.finest("parsing request");
            TransactionID serverTid = ev.getTransactionID();
            StunServerTransaction sTran = this.getServerTransaction(serverTid);
            if (sTran != null) {
                logger.finest("found an existing transaction");
                try {
                    sTran.retransmitResponse();
                    logger.finest("Response retransmitted");
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Failed to retransmit a stun response", ex);
                }
                if (!Boolean.getBoolean("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS")) {
                    return;
                }
            } else {
                logger.finest("existing transaction not found");
                sTran = new StunServerTransaction(this, serverTid, ev.getLocalAddress(), ev.getRemoteAddress());
                try {
                    sTran.start();
                }
                catch (OutOfMemoryError t2) {
                    logger.info("STUN transaction thread start failed:" + t2);
                    return;
                }
                Hashtable<TransactionID, StunServerTransaction> t2 = this.serverTransactions;
                synchronized (t2) {
                    this.serverTransactions.put(serverTid, sTran);
                    this.expiredTransactionsCollector.schedule();
                }
            }
            try {
                this.validateRequestAttributes(ev);
            }
            catch (Exception exc) {
                logger.log(Level.FINE, "Failed to validate msg, removing transaction: " + ev, exc);
                this.removeServerTransaction(sTran);
                return;
            }
            try {
                this.eventDispatcher.fireMessageEvent(ev);
            }
            catch (Throwable t3) {
                logger.log(Level.INFO, "Received an invalid request.", t3);
                Throwable cause = t3.getCause();
                if (t3 instanceof StunException && ((StunException)t3).getID() == 5 || cause instanceof StunException && ((StunException)cause).getID() == 5) {
                    return;
                }
                Response error = t3 instanceof IllegalArgumentException ? this.createCorrespondingErrorResponse(msg.getMessageType(), '\u0190', t3.getMessage(), new char[0]) : this.createCorrespondingErrorResponse(msg.getMessageType(), '\u01f4', "Oops! Something went wrong on our side :(", new char[0]);
                try {
                    this.sendResponse(serverTid.getBytes(), error, ev.getLocalAddress(), ev.getRemoteAddress());
                }
                catch (Exception exc) {
                    logger.log(Level.FINE, "Couldn't send a server error response", exc);
                }
            }
        } else if (msg instanceof Response) {
            TransactionID tid = ev.getTransactionID();
            StunClientTransaction tran = this.clientTransactions.remove(tid);
            if (tran != null) {
                tran.handleResponse(ev);
            } else {
                logger.fine("Dropped response - no matching client tran found for tid " + tid + "\nall tids in stock were " + this.clientTransactions.keySet());
            }
        } else if (msg instanceof Indication) {
            this.eventDispatcher.fireMessageEvent(ev);
        }
    }

    public CredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        ArrayList<StunServerTransaction> serverTransactionsToExpire;
        ArrayList<StunClientTransaction> clientTransactionsToCancel;
        this.eventDispatcher.removeAllListeners();
        Hashtable<TransactionID, StunClientTransaction> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            clientTransactionsToCancel = new ArrayList<StunClientTransaction>(this.clientTransactions.values());
            this.clientTransactions.clear();
        }
        for (StunClientTransaction tran : clientTransactionsToCancel) {
            tran.cancel();
        }
        this.expiredTransactionsCollector.cancel();
        Hashtable<TransactionID, StunServerTransaction> hashtable2 = this.serverTransactions;
        synchronized (hashtable2) {
            serverTransactionsToExpire = new ArrayList<StunServerTransaction>(this.serverTransactions.values());
            this.serverTransactions.clear();
        }
        for (StunServerTransaction tran : serverTransactionsToExpire) {
            tran.expire();
        }
        this.netAccessManager.stop();
    }

    private void validateRequestAttributes(StunMessageEvent evt) throws IllegalArgumentException, StunException, IOException {
        Message request = evt.getMessage();
        UsernameAttribute unameAttr = (UsernameAttribute)request.getAttribute('\u0006');
        String username = null;
        if (unameAttr != null && !this.validateUsername(username = LongTermCredential.toString(unameAttr.getUsername()))) {
            Response error = this.createCorrespondingErrorResponse(request.getMessageType(), '\u0191', "unknown user " + username, new char[0]);
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Non-recognized username: " + username);
        }
        MessageIntegrityAttribute msgIntAttr = (MessageIntegrityAttribute)request.getAttribute('\b');
        if (msgIntAttr != null) {
            if (unameAttr == null) {
                Response error = this.createCorrespondingErrorResponse(request.getMessageType(), '\u0190', "missing username", new char[0]);
                this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
                throw new IllegalArgumentException("Missing USERNAME in the presence of MESSAGE-INTEGRITY: ");
            }
            if (!this.validateMessageIntegrity(msgIntAttr, username, true, evt.getRawMessage())) {
                Response error = this.createCorrespondingErrorResponse(request.getMessageType(), '\u0191', "Wrong MESSAGE-INTEGRITY value", new char[0]);
                this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
                throw new IllegalArgumentException("Wrong MESSAGE-INTEGRITY value.");
            }
        } else if (Boolean.getBoolean("org.ice4j.REQUIRE_MESSAGE_INTEGRITY")) {
            Response error = this.createCorrespondingErrorResponse(request.getMessageType(), '\u0191', "Missing MESSAGE-INTEGRITY.", new char[0]);
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Missing MESSAGE-INTEGRITY.");
        }
        List<Attribute> allAttributes = request.getAttributes();
        StringBuffer sBuff = new StringBuffer();
        for (Attribute attr : allAttributes) {
            if (!(attr instanceof OptionalAttribute) || attr.getAttributeType() >= '\u8000') continue;
            sBuff.append(attr.getAttributeType());
        }
        if (sBuff.length() > 0) {
            Response error = this.createCorrespondingErrorResponse(request.getMessageType(), '\u01a4', "unknown attribute ", sBuff.toString().toCharArray());
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Unknown attribute(s).");
        }
    }

    public boolean validateMessageIntegrity(MessageIntegrityAttribute msgInt, String username, boolean shortTermCredentialMechanism, RawMessage message) {
        byte[] expectedMsgIntHmacSha1Content;
        byte[] key;
        int colon = -1;
        if (username == null || username.length() < 1 || shortTermCredentialMechanism && (colon = username.indexOf(":")) < 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with an improperly formatted username");
            }
            return false;
        }
        if (shortTermCredentialMechanism) {
            username = username.substring(0, colon);
        }
        if ((key = this.getCredentialsManager().getLocalKey(username)) == null) {
            return false;
        }
        byte[] binMsg = new byte[msgInt.getLocationInMessage()];
        System.arraycopy(message.getBytes(), 0, binMsg, 0, binMsg.length);
        char messageLength = (char)(binMsg.length + 4 + msgInt.getDataLength() - 20);
        binMsg[2] = (byte)(messageLength >> 8);
        binMsg[3] = (byte)(messageLength & 0xFF);
        try {
            expectedMsgIntHmacSha1Content = MessageIntegrityAttribute.calculateHmacSha1(binMsg, 0, binMsg.length, key);
        }
        catch (IllegalArgumentException iaex) {
            expectedMsgIntHmacSha1Content = null;
        }
        byte[] msgIntHmacSha1Content = msgInt.getHmacSha1Content();
        if (!Arrays.equals(expectedMsgIntHmacSha1Content, msgIntHmacSha1Content)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with a wrong MESSAGE-INTEGRITY HMAC-SHA1 signature: expected: " + StunStack.toHexString(expectedMsgIntHmacSha1Content) + ", received: " + StunStack.toHexString(msgIntHmacSha1Content));
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Successfully verified msg integrity");
        }
        return true;
    }

    private static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hexStringBuilder = new StringBuilder(2 * bytes.length);
        char[] hexes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            hexStringBuilder.append(hexes[(b & 0xF0) >> 4]);
            hexStringBuilder.append(hexes[b & 0xF]);
        }
        return hexStringBuilder.toString();
    }

    private boolean validateUsername(String username) {
        int colon = username.indexOf(":");
        if (username.length() < 1 || colon < 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with an improperly formatted username");
            }
            return false;
        }
        String lfrag = username.substring(0, colon);
        return this.getCredentialsManager().checkLocalUserName(lfrag);
    }

    public static PacketLogger getPacketLogger() {
        return packetLogger;
    }

    public static void setPacketLogger(PacketLogger packetLogger) {
        StunStack.packetLogger = packetLogger;
    }

    public static boolean isPacketLoggerEnabled() {
        return packetLogger != null && packetLogger.isEnabled();
    }

    public Response createCorrespondingErrorResponse(char requestType, char errorCode, String reasonPhrase, char ... unknownAttributes) {
        if (requestType == '\u0001') {
            if (unknownAttributes != null) {
                return MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase, unknownAttributes);
            }
            return MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase);
        }
        return null;
    }

    public static void logPacketToPcap(DatagramPacket p, boolean isSent, InetAddress interfaceAddress, int interfacePort) {
        if (interfaceAddress != null && StunStack.isPacketLoggerEnabled()) {
            InetAddress[] addr = new InetAddress[]{interfaceAddress, p.getAddress()};
            int[] port2 = new int[]{interfacePort, p.getPort()};
            int fromIndex = isSent ? 0 : 1;
            int toIndex = isSent ? 1 : 0;
            StunStack.getPacketLogger().logPacket(addr[fromIndex].getAddress(), port2[fromIndex], addr[toIndex].getAddress(), port2[toIndex], p.getData(), isSent);
        }
    }

    static {
        tasksScheduler = ExecutorFactory.createSingleThreadScheduledExecutor("ice4j.StunStack-", 60, TimeUnit.SECONDS);
    }

    private final class ExpiredServerTransactionsCollector {
        private final Runnable collector = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Hashtable<TransactionID, StunServerTransaction> hashtable = StunStack.this.serverTransactions;
                    synchronized (hashtable) {
                        int transactionsBeforeCollection = StunStack.this.serverTransactions.size();
                        long now = System.currentTimeMillis();
                        Iterator<StunServerTransaction> i = StunStack.this.serverTransactions.values().iterator();
                        while (i.hasNext()) {
                            StunServerTransaction serverTransaction = i.next();
                            if (serverTransaction == null) {
                                i.remove();
                                continue;
                            }
                            if (!serverTransaction.isExpired(now)) continue;
                            i.remove();
                            serverTransaction.expire();
                        }
                        logger.fine("Non-expired server transactions count " + StunStack.this.serverTransactions.size() + ", transactions before collection " + transactionsBeforeCollection);
                        if (StunStack.this.serverTransactions.isEmpty()) {
                            ExpiredServerTransactionsCollector.this.cancel();
                            logger.finest("Cancel expired collector due to no more server transactions");
                        }
                    }
                }
                catch (Throwable t2) {
                    logger.log(Level.FINE, "Failed to expire server transactions", t2);
                }
            }
        };
        private ScheduledFuture<?> scheduledCollectorFuture;

        private ExpiredServerTransactionsCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule() {
            Hashtable<TransactionID, StunServerTransaction> hashtable = StunStack.this.serverTransactions;
            synchronized (hashtable) {
                if (this.scheduledCollectorFuture == null || this.scheduledCollectorFuture.isDone()) {
                    this.scheduledCollectorFuture = tasksScheduler.scheduleWithFixedDelay(this.collector, 16000L, 16000L, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Hashtable<TransactionID, StunServerTransaction> hashtable = StunStack.this.serverTransactions;
            synchronized (hashtable) {
                if (this.scheduledCollectorFuture != null) {
                    this.scheduledCollectorFuture.cancel(false);
                    this.scheduledCollectorFuture = null;
                }
            }
        }
    }
}

