/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSingletonIterator;

public class OpBackReference
extends Operation {
    int groupNr;

    OpBackReference(int groupNr) {
        this.groupNr = groupNr;
    }

    @Override
    public int matchesEmptyString() {
        return 0;
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        int s = matcher.startBackref[this.groupNr];
        int e = matcher.endBackref[this.groupNr];
        if (s == -1 || e == -1) {
            return EmptyIntIterator.getInstance();
        }
        if (s == e) {
            return new IntSingletonIterator(position);
        }
        int l = e - s;
        UnicodeString search = matcher.search;
        if ((long)(position + l - 1) >= search.length()) {
            return EmptyIntIterator.getInstance();
        }
        if (matcher.program.flags.isCaseIndependent()) {
            for (int i = 0; i < l; ++i) {
                if (matcher.equalCaseBlind(search.codePointAt(position + i), search.codePointAt(s + i))) continue;
                return EmptyIntIterator.getInstance();
            }
        } else {
            for (int i = 0; i < l; ++i) {
                if (search.codePointAt(position + i) == search.codePointAt(s + i)) continue;
                return EmptyIntIterator.getInstance();
            }
        }
        return new IntSingletonIterator(position + l);
    }

    @Override
    public String display() {
        return "\\" + this.groupNr;
    }
}

