/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.layoutrules;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.util.geom.StrictDimension;

public class ReplacedContentSequenceElement
implements InlineSequenceElement {
    private RenderableReplacedContent node;
    private long width;

    public ReplacedContentSequenceElement(RenderableReplacedContent renderableReplacedContent) {
        this.node = renderableReplacedContent;
        StrictDimension strictDimension = renderableReplacedContent.getContentSize();
        if (RenderLength.AUTO.equals(renderableReplacedContent.getRequestedWidth())) {
            if (RenderLength.AUTO.equals(renderableReplacedContent.getRequestedHeight())) {
                this.width = strictDimension.getWidth();
            } else if (strictDimension.getHeight() > 0L) {
                RenderLength renderLength = renderableReplacedContent.getComputedLayoutProperties().getBlockContextWidth();
                long l = renderableReplacedContent.getRequestedHeight().resolve(renderLength.resolve(0L));
                this.width = l * strictDimension.getWidth() / strictDimension.getHeight();
            } else {
                this.width = 0L;
            }
        } else {
            RenderLength renderLength = renderableReplacedContent.getComputedLayoutProperties().getBlockContextWidth();
            this.width = renderableReplacedContent.getRequestedWidth().resolve(renderLength.resolve(0L));
        }
    }

    @Override
    public long getMinimumWidth() {
        return this.width;
    }

    @Override
    public long getMaximumWidth() {
        return Math.max(this.width, this.node.getMaximumBoxWidth());
    }

    @Override
    public RenderNode getNode() {
        return this.node;
    }

    @Override
    public boolean isPreserveWhitespace() {
        return false;
    }
}

