/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.rows;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.util.LongList;

public class TableRow {
    private Border border;
    private long preferredSize;
    private long validateSize;
    private LongList preferredSizes;
    private long validatedLeadingSize;
    private LongList validatedTrailingSize;

    public TableRow() {
        this(Border.createEmptyBorder());
    }

    public TableRow(Border border) {
        this.border = border;
        this.preferredSizes = new LongList(10);
        this.validatedLeadingSize = 0L;
        this.validatedTrailingSize = new LongList(10);
    }

    public long getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(long l) {
        this.preferredSize = l;
    }

    public long getPreferredSize(int n) {
        int n2 = n - 1;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.preferredSizes.size() <= n2) {
            return 0L;
        }
        return this.preferredSizes.get(n2);
    }

    public int getMaximumRowSpan() {
        return this.preferredSizes.size();
    }

    public void updateDefinedSize(int n, long l) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        int n2 = n - 1;
        if (n2 >= this.preferredSizes.size() || this.preferredSizes.get(n2) < l) {
            this.preferredSizes.set(n2, l);
        }
    }

    public long getValidatedLeadingSize() {
        return this.validatedLeadingSize;
    }

    public long getValidatedTrailingSize(int n) {
        if (n > this.validatedTrailingSize.size()) {
            return 0L;
        }
        return this.validatedTrailingSize.get(n - 1);
    }

    public void setValidatedTralingSize(int n, long l) {
        this.validatedTrailingSize.set(n - 1, l);
    }

    public int getMaxValidatedRowSpan() {
        return this.validatedTrailingSize.size();
    }

    public void updateValidatedSize(int n, long l, long l2) {
        int n2 = n - 1;
        if (this.validatedLeadingSize < l) {
            this.validatedLeadingSize = l;
        }
        if (n2 >= this.validatedTrailingSize.size() || this.validatedTrailingSize.get(n2) < l2) {
            this.validatedTrailingSize.set(n2, l2);
        }
    }

    public long getValidateSize() {
        return this.validateSize;
    }

    public void setValidateSize(long l) {
        this.validateSize = l;
    }

    public void clear() {
        this.validatedTrailingSize.clear();
        this.validateSize = 0L;
    }

    public void clearSizes() {
        this.preferredSizes.clear();
        this.preferredSize = 0L;
    }
}

