/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.SpacerRenderNode;

public class TableColumnNode
extends SpacerRenderNode {
    private BoxDefinition definition;
    private int colspan;

    public TableColumnNode(BoxDefinition boxDefinition) {
        super(0L, 0L, true);
        this.definition = boxDefinition;
        this.colspan = 1;
    }

    public TableColumnNode(BoxDefinition boxDefinition, LayoutContext layoutContext) {
        super(0L, 0L, true);
        this.definition = boxDefinition;
        CSSValue cSSValue = layoutContext.getValue(TableStyleKeys.COL_SPAN);
        this.colspan = (int)CSSValueResolverUtility.getNumericValue(cSSValue, 1.0);
    }

    public int getColspan() {
        return this.colspan;
    }

    public BoxDefinition getBoxDefinition() {
        return this.definition;
    }
}

