/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderFactory;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxDefinitionFactory;
import org.jfree.layouting.renderer.model.DefaultBoxDefinition;

public class DefaultBoxDefinitionFactory
implements BoxDefinitionFactory {
    private BorderFactory borderFactory;

    public DefaultBoxDefinitionFactory(BorderFactory borderFactory) {
        this.borderFactory = borderFactory;
    }

    @Override
    public BoxDefinition createBlockBoxDefinition(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        Border border = this.borderFactory.createBorder(layoutContext, outputProcessorMetaData);
        DefaultBoxDefinition defaultBoxDefinition = new DefaultBoxDefinition();
        defaultBoxDefinition.setBorder(border);
        CSSValue cSSValue = layoutContext.getValue(BorderStyleKeys.BACKGROUND_COLOR);
        if (cSSValue instanceof CSSColorValue) {
            defaultBoxDefinition.setBackgroundColor((CSSColorValue)cSSValue);
        } else {
            defaultBoxDefinition.setBackgroundColor(CSSSystemColors.TRANSPARENT);
        }
        this.fillHorizontalPadding(defaultBoxDefinition, layoutContext, outputProcessorMetaData);
        defaultBoxDefinition.setPreferredWidth(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.WIDTH), layoutContext, outputProcessorMetaData, true, true));
        defaultBoxDefinition.setMarginLeft(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_LEFT), layoutContext, outputProcessorMetaData, true, true));
        defaultBoxDefinition.setMarginRight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_RIGHT), layoutContext, outputProcessorMetaData, true, true));
        this.fillVerticalModel(defaultBoxDefinition, layoutContext, outputProcessorMetaData);
        return defaultBoxDefinition;
    }

    @Override
    public BoxDefinition createInlineBoxDefinition(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        Border border = this.borderFactory.createBorder(layoutContext, outputProcessorMetaData);
        DefaultBoxDefinition defaultBoxDefinition = new DefaultBoxDefinition();
        defaultBoxDefinition.setBorder(border);
        CSSValue cSSValue = layoutContext.getValue(BorderStyleKeys.BACKGROUND_COLOR);
        if (cSSValue instanceof CSSColorValue) {
            defaultBoxDefinition.setBackgroundColor((CSSColorValue)cSSValue);
        } else {
            defaultBoxDefinition.setBackgroundColor(CSSSystemColors.TRANSPARENT);
        }
        this.fillHorizontalPadding(defaultBoxDefinition, layoutContext, outputProcessorMetaData);
        defaultBoxDefinition.setPreferredWidth(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.WIDTH), layoutContext, outputProcessorMetaData, true, true));
        defaultBoxDefinition.setMarginLeft(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_LEFT), layoutContext, outputProcessorMetaData, false, true));
        defaultBoxDefinition.setMarginRight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_RIGHT), layoutContext, outputProcessorMetaData, false, true));
        this.fillVerticalModel(defaultBoxDefinition, layoutContext, outputProcessorMetaData);
        return defaultBoxDefinition;
    }

    private void fillVerticalModel(DefaultBoxDefinition defaultBoxDefinition, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        defaultBoxDefinition.setPaddingTop(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.PADDING_TOP), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setPaddingBottom(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.PADDING_BOTTOM), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setMarginTop(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_TOP), layoutContext, outputProcessorMetaData, false, true));
        defaultBoxDefinition.setMarginBottom(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MARGIN_BOTTOM), layoutContext, outputProcessorMetaData, false, true));
        defaultBoxDefinition.setPreferredHeight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.HEIGHT), layoutContext, outputProcessorMetaData, true, true));
    }

    private void fillHorizontalPadding(DefaultBoxDefinition defaultBoxDefinition, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        defaultBoxDefinition.setPaddingLeft(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.PADDING_LEFT), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setPaddingRight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.PADDING_RIGHT), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setMaximumWidth(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MAX_WIDTH), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setMaximumHeight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MAX_HEIGHT), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setMinimumWidth(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MIN_WIDTH), layoutContext, outputProcessorMetaData, false, false));
        defaultBoxDefinition.setMinimumHeight(DefaultBoxDefinitionFactory.computeWidth(layoutContext.getValue(BoxStyleKeys.MIN_HEIGHT), layoutContext, outputProcessorMetaData, false, false));
    }

    public static RenderLength computeWidth(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData, boolean bl, boolean bl2) {
        RenderLength renderLength;
        if (bl && CSSAutoValue.getInstance().equals(cSSValue)) {
            return RenderLength.AUTO;
        }
        if (!(cSSValue instanceof CSSNumericValue)) {
            return RenderLength.EMPTY;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (cSSNumericValue.getValue() < 0.0 && bl2) {
            return RenderLength.convertToInternal(cSSValue, layoutContext, outputProcessorMetaData);
        }
        if (cSSNumericValue.getValue() > 0.0 && (renderLength = RenderLength.convertToInternal(cSSValue, layoutContext, outputProcessorMetaData)).getValue() > 0L) {
            return renderLength;
        }
        return RenderLength.EMPTY;
    }
}

