/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.counters.numeric;

import java.util.HashSet;
import org.jfree.layouting.layouter.counters.CounterStyle;

public abstract class NumericCounterStyle
implements CounterStyle {
    private HashSet replacements;
    private int base;
    private transient ReplacementDefinition[] cachedDefinitions;
    private String suffix;

    protected NumericCounterStyle(int n, String string) {
        this.base = n;
        this.suffix = string;
        this.replacements = new HashSet();
    }

    public final void setReplacementChar(char c, char c2) {
        this.replacements.add(new ReplacementDefinition(c, c2));
        this.cachedDefinitions = null;
    }

    @Override
    public final String getCounterValue(int n) {
        if (this.cachedDefinitions == null) {
            this.cachedDefinitions = this.replacements.toArray(new ReplacementDefinition[this.replacements.size()]);
        }
        String string = Integer.toString(n, this.base);
        for (int i = 0; i < this.cachedDefinitions.length; ++i) {
            ReplacementDefinition replacementDefinition = this.cachedDefinitions[i];
            string = string.replace(replacementDefinition.getOriginal(), replacementDefinition.getReplacement());
        }
        return string;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    private static final class ReplacementDefinition {
        private char original;
        private char replacement;

        private ReplacementDefinition(char c, char c2) {
            this.original = c;
            this.replacement = c2;
        }

        public char getOriginal() {
            return this.original;
        }

        public char getReplacement() {
            return this.replacement;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ReplacementDefinition replacementDefinition = (ReplacementDefinition)object;
            return this.original == replacementDefinition.original;
        }

        public int hashCode() {
            return this.original;
        }
    }
}

