/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.io.Serializable;
import org.jfree.layouting.input.style.keys.border.BackgroundAttachment;
import org.jfree.layouting.input.style.keys.border.BackgroundClip;
import org.jfree.layouting.input.style.keys.border.BackgroundOrigin;
import org.jfree.layouting.input.style.keys.border.BackgroundRepeat;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.util.ObjectList;
import org.jfree.layouting.util.geom.StrictDimension;
import org.pentaho.reporting.libraries.resourceloader.Resource;

public class BackgroundSpecification
implements Serializable {
    public static final CSSValuePair EMPTY_BACKGROUND_REPEAT = new CSSValuePair(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT);
    private ObjectList backgroundImages;
    private ObjectList backgroundRepeats;
    private ObjectList backgroundSizes;
    private ObjectList backgroundAttachment;
    private ObjectList backgroundPositions;
    private ObjectList backgroundOrigin;
    private ObjectList backgroundClip;

    public Resource getBackgroundImage(int n) {
        if (this.backgroundImages == null) {
            return null;
        }
        Resource resource = (Resource)this.backgroundImages.get(n % this.backgroundImages.size());
        if (resource == null) {
            return null;
        }
        return resource;
    }

    public int getBackgroundImageCount() {
        if (this.backgroundImages == null) {
            return 0;
        }
        return this.backgroundImages.size();
    }

    public void setBackgroundImage(int n, Resource resource) {
        if (this.backgroundImages == null) {
            this.backgroundImages = new ObjectList();
        }
        this.backgroundImages.set(n, resource);
    }

    public CSSValuePair getBackgroundRepeat(int n) {
        if (this.backgroundRepeats == null) {
            return EMPTY_BACKGROUND_REPEAT;
        }
        CSSValuePair cSSValuePair = (CSSValuePair)this.backgroundRepeats.get(n % this.backgroundRepeats.size());
        if (cSSValuePair == null) {
            return EMPTY_BACKGROUND_REPEAT;
        }
        return cSSValuePair;
    }

    public int getBackgroundRepeatCount() {
        if (this.backgroundRepeats == null) {
            return 0;
        }
        return this.backgroundRepeats.size();
    }

    public void setBackgroundRepeat(int n, CSSValuePair cSSValuePair) {
        if (this.backgroundRepeats == null) {
            this.backgroundRepeats = new ObjectList();
        }
        this.backgroundRepeats.set(n, cSSValuePair);
    }

    public StrictDimension getBackgroundSize(int n) {
        if (this.backgroundSizes == null) {
            return new StrictDimension();
        }
        StrictDimension strictDimension = (StrictDimension)this.backgroundSizes.get(n % this.backgroundSizes.size());
        if (strictDimension == null) {
            return new StrictDimension();
        }
        return (StrictDimension)strictDimension.clone();
    }

    public int getBackgroundSizesCount() {
        if (this.backgroundSizes == null) {
            return 0;
        }
        return this.backgroundSizes.size();
    }

    public void setBackgroundSizes(int n, StrictDimension strictDimension) {
        if (this.backgroundSizes == null) {
            this.backgroundSizes = new ObjectList();
        }
        if (strictDimension == null) {
            this.backgroundSizes.set(n, null);
        } else {
            this.backgroundSizes.set(n, strictDimension.clone());
        }
    }

    public CSSValuePair getBackgroundPosition(int n) {
        if (this.backgroundPositions == null) {
            return null;
        }
        CSSValuePair cSSValuePair = (CSSValuePair)this.backgroundPositions.get(n % this.backgroundPositions.size());
        if (cSSValuePair == null) {
            return null;
        }
        return cSSValuePair;
    }

    public int getBackgroundPositionsCount() {
        if (this.backgroundPositions == null) {
            return 0;
        }
        return this.backgroundPositions.size();
    }

    public void setBackgroundPosition(int n, CSSValuePair cSSValuePair) {
        if (this.backgroundPositions == null) {
            this.backgroundPositions = new ObjectList();
        }
        if (cSSValuePair == null) {
            this.backgroundPositions.set(n, null);
        } else {
            this.backgroundPositions.set(n, cSSValuePair);
        }
    }

    public CSSConstant getBackgroundOrigin(int n) {
        if (this.backgroundOrigin == null) {
            return BackgroundOrigin.PADDING;
        }
        CSSConstant cSSConstant = (CSSConstant)this.backgroundOrigin.get(n % this.backgroundOrigin.size());
        if (cSSConstant == null) {
            return BackgroundOrigin.PADDING;
        }
        return cSSConstant;
    }

    public int getBackgroundOriginCount() {
        if (this.backgroundOrigin == null) {
            return 0;
        }
        return this.backgroundOrigin.size();
    }

    public void setBackgroundOrigin(int n, CSSConstant cSSConstant) {
        if (this.backgroundOrigin == null) {
            this.backgroundOrigin = new ObjectList();
        }
        if (cSSConstant == null) {
            this.backgroundOrigin.set(n, null);
        } else {
            this.backgroundOrigin.set(n, cSSConstant);
        }
    }

    public CSSConstant getBackgroundClip(int n) {
        if (this.backgroundClip == null) {
            return BackgroundClip.BORDER;
        }
        CSSConstant cSSConstant = (CSSConstant)this.backgroundClip.get(n % this.backgroundClip.size());
        if (cSSConstant == null) {
            return BackgroundClip.BORDER;
        }
        return cSSConstant;
    }

    public int getBackgroundClipCount() {
        if (this.backgroundClip == null) {
            return 0;
        }
        return this.backgroundClip.size();
    }

    public void setBackgroundClip(int n, CSSConstant cSSConstant) {
        if (this.backgroundClip == null) {
            this.backgroundClip = new ObjectList();
        }
        if (cSSConstant == null) {
            this.backgroundClip.set(n, null);
        } else {
            this.backgroundClip.set(n, cSSConstant);
        }
    }

    public CSSConstant getBackgroundAttachment(int n) {
        if (this.backgroundAttachment == null) {
            return BackgroundAttachment.SCROLL;
        }
        CSSConstant cSSConstant = (CSSConstant)this.backgroundAttachment.get(n % this.backgroundAttachment.size());
        if (cSSConstant == null) {
            return BackgroundAttachment.SCROLL;
        }
        return cSSConstant;
    }

    public int getBackgroundAttachmentCount() {
        if (this.backgroundAttachment == null) {
            return 0;
        }
        return this.backgroundAttachment.size();
    }

    public void setBackgroundAttachment(int n, CSSConstant cSSConstant) {
        if (this.backgroundAttachment == null) {
            this.backgroundAttachment = new ObjectList();
        }
        if (cSSConstant == null) {
            this.backgroundAttachment.set(n, null);
        } else {
            this.backgroundAttachment.set(n, cSSConstant);
        }
    }
}

