/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.box;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayModel;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.w3c.css.sac.LexicalUnit;

public class DisplayReadHandler
implements CSSCompoundValueReadHandler {
    private HashMap values = new HashMap();

    public DisplayReadHandler() {
        this.values.put("inline", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.INLINE));
        this.values.put("inline-block", new DisplayMapEntry(DisplayModel.BLOCK_INSIDE, DisplayRole.INLINE));
        this.values.put("inline-table", new DisplayMapEntry(DisplayModel.TABLE, DisplayRole.INLINE));
        this.values.put("ruby", new DisplayMapEntry(DisplayModel.RUBY, DisplayRole.INLINE));
        this.values.put("block", new DisplayMapEntry(DisplayModel.BLOCK_INSIDE, DisplayRole.BLOCK));
        this.values.put("table", new DisplayMapEntry(DisplayModel.TABLE, DisplayRole.BLOCK));
        this.values.put("list-item", new DisplayMapEntry(DisplayModel.BLOCK_INSIDE, DisplayRole.LIST_ITEM));
        this.values.put("run-in", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.RUN_IN));
        this.values.put("compact", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.COMPACT));
        this.values.put("table-cell", new DisplayMapEntry(DisplayModel.BLOCK_INSIDE, DisplayRole.TABLE_CELL));
        this.values.put("table-caption", new DisplayMapEntry(DisplayModel.BLOCK_INSIDE, DisplayRole.TABLE_CAPTION));
        this.values.put("table-row-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_ROW_GROUP));
        this.values.put("table-header-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_HEADER_GROUP));
        this.values.put("table-footer-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_FOOTER_GROUP));
        this.values.put("table-column", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_COLUMN));
        this.values.put("table-column-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_COLUMN_GROUP));
        this.values.put("table-row", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.TABLE_ROW));
        this.values.put("ruby-base", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.RUBY_BASE));
        this.values.put("ruby-text", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.RUBY_TEXT));
        this.values.put("ruby-base-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.RUBY_BASE_GROUP));
        this.values.put("ruby-text-group", new DisplayMapEntry(DisplayModel.INLINE_INSIDE, DisplayRole.RUBY_TEXT_GROUP));
        this.values.put("absolute", new DisplayMapEntry(DisplayModel.ABSOLUTE, DisplayRole.ABSOLUTE));
    }

    @Override
    public Map createValues(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != 35) {
            return null;
        }
        HashMap<StyleKey, CSSConstant> hashMap = new HashMap<StyleKey, CSSConstant>();
        String string = lexicalUnit.getStringValue().toLowerCase();
        if ("none".equals(string)) {
            hashMap.put(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.NONE);
            return hashMap;
        }
        DisplayMapEntry displayMapEntry = (DisplayMapEntry)this.values.get(string);
        if (displayMapEntry == null) {
            return null;
        }
        hashMap.put(BoxStyleKeys.DISPLAY_ROLE, displayMapEntry.getRole());
        hashMap.put(BoxStyleKeys.DISPLAY_MODEL, displayMapEntry.getModel());
        return hashMap;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_ROLE, BoxStyleKeys.DISPLAY_MODEL};
    }

    private static class DisplayMapEntry {
        private CSSConstant model;
        private CSSConstant role;

        private DisplayMapEntry(CSSConstant cSSConstant, CSSConstant cSSConstant2) {
            this.model = cSSConstant;
            this.role = cSSConstant2;
        }

        public CSSConstant getModel() {
            return this.model;
        }

        public CSSConstant getRole() {
            return this.role;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DisplayMapEntry displayMapEntry = (DisplayMapEntry)object;
            if (!this.model.equals(displayMapEntry.model)) {
                return false;
            }
            return this.role.equals(displayMapEntry.role);
        }

        public int hashCode() {
            int n = this.model.hashCode();
            n = 29 * n + this.role.hashCode();
            return n;
        }
    }
}

