/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.util.Arrays;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeList {
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private LinkedMap entryList = new LinkedMap();
    private AttributeEntry lookupKey = new AttributeEntry(null, "lookup", "value");
    private transient AttributeEntry[] arrayCache;

    public Iterator iterator() {
        return Arrays.asList(this.entryList.values()).iterator();
    }

    public AttributeEntry[] toArray() {
        if (this.arrayCache == null) {
            this.arrayCache = (AttributeEntry[])this.entryList.values((Object[])new AttributeEntry[this.entryList.size()]);
        }
        return (AttributeEntry[])this.arrayCache.clone();
    }

    public void setAttribute(String namespace, String name, String value) {
        if (value == null) {
            this.removeAttribute(namespace, name);
            return;
        }
        AttributeEntry entry = new AttributeEntry(namespace, name, value);
        this.arrayCache = null;
        this.entryList.put((Object)entry, (Object)entry);
    }

    public String getAttribute(String namespace, String name) {
        return this.getAttribute(namespace, name, null);
    }

    public String getAttribute(String namespace, String name, String defaultValue) {
        this.lookupKey.update(namespace, name, "");
        AttributeEntry entry = (AttributeEntry)this.entryList.get((Object)this.lookupKey);
        if (entry != null) {
            return entry.getValue();
        }
        return defaultValue;
    }

    public void removeAttribute(String namespace, String name) {
        this.lookupKey.update(namespace, name, "");
        this.entryList.remove((Object)this.lookupKey);
        this.arrayCache = null;
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public void addNamespaceDeclaration(String prefix, String namespaceUri) {
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (prefix == null || "".equals(prefix)) {
            this.setAttribute(XMLNS_NAMESPACE, "", namespaceUri);
        } else {
            this.setAttribute(XMLNS_NAMESPACE, prefix, namespaceUri);
        }
    }

    public void removeNamespaceDeclaration(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            this.removeAttribute(XMLNS_NAMESPACE, "");
        } else {
            this.removeAttribute(XMLNS_NAMESPACE, prefix);
        }
    }

    public boolean isNamespacePrefixDefined(String prefix) {
        return this.getAttribute(XMLNS_NAMESPACE, prefix) != null;
    }

    public boolean isNamespaceUriDefined(String uri) {
        if (this.entryList.isEmpty()) {
            return false;
        }
        AttributeEntry[] objects = this.toArray();
        for (int i = 0; i < objects.length; ++i) {
            AttributeEntry ae = objects[i];
            if (!ObjectUtilities.equal((Object)ae.getValue(), (Object)uri) || !XMLNS_NAMESPACE.equals(ae.getNamespace())) continue;
            return true;
        }
        return false;
    }

    public static class AttributeEntry {
        private String namespace;
        private String name;
        private String value;

        public AttributeEntry(String namespace, String name, String value) {
            if (name == null) {
                throw new NullPointerException("Name must not be null. [" + name + ", " + value + ']');
            }
            if (value == null) {
                throw new NullPointerException("Value must not be null. [" + name + ", " + value + ']');
            }
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeEntry that = (AttributeEntry)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + this.name.hashCode();
            return result;
        }

        protected void update(String namespace, String name, String value) {
            if (name == null) {
                throw new NullPointerException("Name must not be null. [" + name + ", " + value + ']');
            }
            if (value == null) {
                throw new NullPointerException("Value must not be null. [" + name + ", " + value + ']');
            }
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

