/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.AbstractLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.FormattedTextElement;

public class VariablesDeclarationLayoutController
extends AbstractLayoutController {
    private boolean processed;

    private OfficeRepeatingStructureLayoutController getRepeatingParent() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            if (!(layoutController instanceof OfficeRepeatingStructureLayoutController)) continue;
            return (OfficeRepeatingStructureLayoutController)layoutController;
        }
        return null;
    }

    @Override
    public LayoutController advance(ReportTarget reportTarget) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        if (this.processed) {
            throw new IllegalStateException("Already processed.");
        }
        VariablesDeclarationLayoutController variablesDeclarationLayoutController = (VariablesDeclarationLayoutController)this.clone();
        variablesDeclarationLayoutController.processed = true;
        OfficeRepeatingStructureLayoutController officeRepeatingStructureLayoutController = this.getRepeatingParent();
        if (officeRepeatingStructureLayoutController == null) {
            return variablesDeclarationLayoutController;
        }
        VariablesCollection variablesCollection = officeRepeatingStructureLayoutController.getVariablesCollection();
        if (variablesCollection.getVariablesCount() == 0) {
            return variablesDeclarationLayoutController;
        }
        Element element = (Element)this.getNode();
        AttributeMap attributeMap = element.getAttributeMap();
        reportTarget.startElement(attributeMap);
        FormattedTextElement[] formattedTextElementArray = variablesCollection.getVariables();
        for (int i = 0; i < formattedTextElementArray.length; ++i) {
            FormattedTextElement formattedTextElement = formattedTextElementArray[i];
            String string = variablesCollection.getNamePrefix() + (i + 1);
            AttributeMap attributeMap2 = this.generateVariableSetSection(formattedTextElement);
            attributeMap2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", (Object)string);
            reportTarget.startElement(attributeMap2);
            reportTarget.endElement(attributeMap2);
        }
        reportTarget.endElement(attributeMap);
        return variablesDeclarationLayoutController;
    }

    private AttributeMap generateVariableSetSection(FormattedTextElement formattedTextElement) throws DataSourceException {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"variable-set");
        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "display", (Object)"none");
        FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
        Object object = LayoutControllerUtil.evaluateExpression(this.getFlowController(), formattedTextElement, formulaExpression);
        String string = FormatValueUtility.applyValueForVariable(object, attributeMap);
        if (string == null) {
            string = "" + object;
        }
        if (object instanceof java.sql.Date) {
            Date date = (Date)object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy;MM;dd");
            string = "Date(" + simpleDateFormat.format(date) + ")";
        }
        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "formula", (Object)("ooow:" + string));
        return attributeMap;
    }

    @Override
    public boolean isAdvanceable() {
        return !this.processed;
    }

    @Override
    public LayoutController join(FlowController flowController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        throw new UnsupportedOperationException("Join is not supported in this layout controller");
    }
}

