/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class AndFunction
implements Function {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -3737884974501253814L;

    @Override
    public String getCanonicalName() {
        return "AND";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int length = parameters.getParameterCount();
        if (length < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int i = 0; i < length; ++i) {
            Object value = parameters.getValue(i);
            Type type1 = parameters.getType(i);
            Boolean condition = context.getTypeRegistry().convertToLogical(type1, value);
            if (condition == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (!Boolean.FALSE.equals(condition)) continue;
            return RETURN_FALSE;
        }
        return RETURN_TRUE;
    }
}

