/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.util.logging.Logger;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsErrFunction
implements Function {
    private static final Logger logger = Logger.getLogger(IsErrFunction.class.getName());
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 6749192734608313367L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            Type type = parameters.getType(0);
            Object value = parameters.getValue(0);
            if (ErrorType.TYPE.equals(type) && value instanceof ErrorValue) {
                logger.warning("Passing errors around is deprecated. Throw exceptions instead.");
                ErrorValue na = (ErrorValue)value;
                if (na.getErrorCode() == 522) {
                    return RETURN_FALSE;
                }
                return RETURN_TRUE;
            }
        }
        catch (EvaluationException e) {
            if (e.getErrorValue().getErrorCode() == 522) {
                return RETURN_FALSE;
            }
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    @Override
    public String getCanonicalName() {
        return "ISERR";
    }
}

