/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.Base64;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TypedPropertyReadHandler
extends PropertyReadHandler {
    private boolean plainContent;
    private String encoding;
    private String className;
    private BeanUtility beanUtility;
    private String expressionName;
    private CharacterEntityParser entityParser;

    public TypedPropertyReadHandler(BeanUtility beanUtility, String string, CharacterEntityParser characterEntityParser) {
        if (beanUtility == null) {
            throw new NullPointerException("Expression must not be null");
        }
        if (characterEntityParser == null) {
            throw new NullPointerException("EntityParser must not be null");
        }
        this.expressionName = string;
        this.beanUtility = beanUtility;
        this.entityParser = characterEntityParser;
        this.plainContent = true;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        try {
            if (this.plainContent) {
                String string = this.getResult();
                if ("base64".equals(this.encoding)) {
                    byte[] byArray = Base64.decode((char[])string.trim().toCharArray());
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Object object = objectInputStream.readObject();
                    this.beanUtility.setProperty(this.getName(), object);
                } else if (this.className != null) {
                    ClassLoader classLoader = ObjectUtilities.getClassLoader(TypedPropertyReadHandler.class);
                    Class<?> clazz = classLoader.loadClass(this.className);
                    this.beanUtility.setPropertyAsString(this.getName(), clazz, this.entityParser.decodeEntities(string));
                } else {
                    this.beanUtility.setPropertyAsString(this.getName(), this.entityParser.decodeEntities(string));
                }
            }
        }
        catch (BeanException beanException) {
            beanException.printStackTrace();
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)((Object)beanException), this.getLocator());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)classNotFoundException, this.getLocator());
        }
        catch (IOException iOException) {
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)iOException, this.getLocator());
        }
    }

    protected void startParsing(Attributes attributes) throws SAXException {
        super.startParsing(attributes);
        this.className = attributes.getValue(this.getUri(), "class");
        this.encoding = attributes.getValue(this.getUri(), "encoding");
        if (this.encoding == null) {
            this.encoding = "text";
        } else if (!"text".equals(this.encoding) && !"base64".equals(this.encoding)) {
            DebugLog.log((Object)"Invalid value for attribute 'encoding'. Defaulting to 'text'");
            this.encoding = "text";
        }
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if (!this.isSameNamespace(string)) {
            return null;
        }
        if ("property".equals(string2)) {
            this.plainContent = false;
            String string3 = attributes.getValue(string, "name");
            if (string3 == null) {
                throw new ParseException("Required attribute 'name' is missing", this.getLocator());
            }
            try {
                Class clazz = this.beanUtility.getPropertyType(string3);
                Object t = clazz.newInstance();
                BeanUtility beanUtility = new BeanUtility(t);
                return new TypedPropertyReadHandler(beanUtility, this.expressionName, this.entityParser);
            }
            catch (BeanException beanException) {
                throw new ParseException("Property '" + string3 + "' for expression '" + this.className + "' is not valid. The specified class was not found.", (Exception)((Object)beanException), this.getRootHandler().getDocumentLocator());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParseException("Property '" + string3 + "' for expression '" + this.className + "' is not valid. The specified class was not found.", (Exception)illegalAccessException, this.getRootHandler().getDocumentLocator());
            }
            catch (InstantiationException instantiationException) {
                throw new ParseException("Property '" + string3 + "' for expression '" + this.className + "' is not valid. The specified class cannot be instantiated.", (Exception)instantiationException, this.getRootHandler().getDocumentLocator());
            }
            catch (IntrospectionException introspectionException) {
                throw new ParseException("Property '" + string3 + "' for expression '" + this.className + "' is not valid. Introspection failed for this expression.", (Exception)introspectionException, this.getRootHandler().getDocumentLocator());
            }
        }
        return null;
    }
}

