/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.ExpressionDataRow;
import org.jfree.report.data.FastGlobalView;
import org.jfree.report.data.ImportedVariablesDataRow;
import org.jfree.report.data.MasterDataRowChangeEvent;
import org.jfree.report.data.ParameterDataRow;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.ReportContext;

public final class GlobalMasterRow {
    private ReportDataRow reportDataRow;
    private ParameterDataRow parameterDataRow;
    private ExpressionDataRow expressionDataRow;
    private GlobalMasterRow parentDataRow;
    private FastGlobalView globalView;
    private ImportedVariablesDataRow importedDataRow;

    private GlobalMasterRow() {
    }

    public static GlobalMasterRow createReportRow(ReportContext reportContext) {
        GlobalMasterRow globalMasterRow = new GlobalMasterRow();
        globalMasterRow.globalView = new FastGlobalView();
        globalMasterRow.expressionDataRow = new ExpressionDataRow(globalMasterRow, reportContext, 10);
        return globalMasterRow;
    }

    public static GlobalMasterRow createReportRow(GlobalMasterRow globalMasterRow, ReportContext reportContext) {
        GlobalMasterRow globalMasterRow2 = GlobalMasterRow.createReportRow(reportContext);
        globalMasterRow2.parentDataRow = globalMasterRow;
        return globalMasterRow2;
    }

    public ExpressionDataRow getExpressionDataRow() {
        return this.expressionDataRow;
    }

    public ReportDataRow getReportDataRow() {
        return this.reportDataRow;
    }

    public void setReportDataRow(ReportDataRow reportDataRow) throws DataSourceException {
        int n;
        int n2;
        if (this.reportDataRow != null) {
            n2 = this.reportDataRow.getColumnCount();
            for (n = n2 - 1; n >= 0; --n) {
                String string = this.reportDataRow.getColumnName(n);
                if (string == null) continue;
                this.globalView.removeColumn(string);
            }
        }
        this.reportDataRow = reportDataRow;
        if (reportDataRow != null) {
            n2 = reportDataRow.getReportData().isReadable() ? 1 : 0;
            n = reportDataRow.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = reportDataRow.getColumnName(i);
                if (string == null) continue;
                if (n2 != 0) {
                    Object object = reportDataRow.get(i);
                    this.globalView.putField(string, object, false);
                    continue;
                }
                this.globalView.putField(string, null, false);
            }
        }
    }

    public ParameterDataRow getParameterDataRow() {
        return this.parameterDataRow;
    }

    public void setParameterDataRow(ParameterDataRow parameterDataRow) throws DataSourceException {
        String string;
        int n;
        int n2;
        if (this.parameterDataRow != null) {
            n2 = this.parameterDataRow.getColumnCount();
            for (n = n2 - 1; n >= 0; --n) {
                string = this.parameterDataRow.getColumnName(n);
                if (string == null) continue;
                this.globalView.removeColumn(string);
            }
        }
        this.parameterDataRow = parameterDataRow;
        if (parameterDataRow != null) {
            n2 = parameterDataRow.getColumnCount();
            for (n = 0; n < n2; ++n) {
                string = parameterDataRow.getColumnName(n);
                if (string == null) continue;
                Object object = parameterDataRow.get(n);
                this.globalView.putField(string, object, false);
            }
        }
    }

    public GlobalMasterRow getParentDataRow() {
        return this.parentDataRow;
    }

    public ImportedVariablesDataRow getImportedDataRow() {
        return this.importedDataRow;
    }

    public void setExportedDataRow(ImportedVariablesDataRow importedVariablesDataRow) throws DataSourceException {
        String string;
        int n;
        int n2;
        if (importedVariablesDataRow != null) {
            n2 = importedVariablesDataRow.getColumnCount();
            for (n = n2 - 1; n >= 0; --n) {
                string = importedVariablesDataRow.getColumnName(n);
                if (string == null) continue;
                this.globalView.removeColumn(string);
            }
        }
        this.importedDataRow = importedVariablesDataRow;
        if (importedVariablesDataRow != null) {
            n2 = importedVariablesDataRow.getColumnCount();
            for (n = 0; n < n2; ++n) {
                string = importedVariablesDataRow.getColumnName(n);
                if (string == null) continue;
                Object object = importedVariablesDataRow.get(n);
                this.globalView.putField(string, object, false);
            }
        }
    }

    public GlobalMasterRow derive() throws DataSourceException {
        return this.derive(null);
    }

    private GlobalMasterRow derive(GlobalMasterRow globalMasterRow) throws DataSourceException {
        GlobalMasterRow globalMasterRow2 = new GlobalMasterRow();
        globalMasterRow2.parameterDataRow = this.parameterDataRow;
        globalMasterRow2.reportDataRow = this.reportDataRow;
        globalMasterRow2.expressionDataRow = this.expressionDataRow.derive(globalMasterRow2);
        globalMasterRow2.globalView = this.globalView.derive();
        if (this.parentDataRow != null) {
            globalMasterRow2.parentDataRow = this.parentDataRow.derive(globalMasterRow);
        }
        globalMasterRow2.importedDataRow = this.importedDataRow;
        return globalMasterRow2;
    }

    public GlobalMasterRow advance() throws DataSourceException {
        return this.advance(false, null);
    }

    private GlobalMasterRow advance(boolean bl, GlobalMasterRow globalMasterRow) throws DataSourceException {
        GlobalMasterRow globalMasterRow2 = new GlobalMasterRow();
        globalMasterRow2.globalView = this.globalView.advance();
        globalMasterRow2.parameterDataRow = this.parameterDataRow;
        globalMasterRow2.reportDataRow = !bl && this.reportDataRow != null ? this.reportDataRow.advance() : this.reportDataRow;
        globalMasterRow2.updateGlobalView();
        if (this.expressionDataRow != null) {
            globalMasterRow2.expressionDataRow = this.expressionDataRow.advance(globalMasterRow2, bl);
        }
        if (this.parentDataRow != null) {
            globalMasterRow2.parentDataRow = this.parentDataRow.advance(true, globalMasterRow2);
        }
        if (this.importedDataRow != null) {
            if (globalMasterRow == null) {
                throw new NullPointerException();
            }
            globalMasterRow2.importedDataRow = this.importedDataRow.advance(globalMasterRow);
            globalMasterRow2.updateImportedParameterView();
        }
        return globalMasterRow2;
    }

    private void updateImportedParameterView() throws DataSourceException {
        if (this.importedDataRow == null) {
            return;
        }
        int n = this.importedDataRow.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.importedDataRow.getColumnName(i);
            if (string == null) continue;
            Object object = this.importedDataRow.get(i);
            this.globalView.putField(string, object, true);
        }
    }

    private void updateGlobalView() throws DataSourceException {
        Object object;
        String string;
        int n;
        int n2;
        if (this.parameterDataRow != null) {
            n2 = this.parameterDataRow.getColumnCount();
            for (n = 0; n < n2; ++n) {
                string = this.parameterDataRow.getColumnName(n);
                if (string == null) continue;
                object = this.parameterDataRow.get(n);
                this.globalView.putField(string, object, true);
            }
        }
        if (this.reportDataRow != null) {
            n2 = this.reportDataRow.getColumnCount();
            for (n = 0; n < n2; ++n) {
                string = this.reportDataRow.getColumnName(n);
                if (string == null) continue;
                object = this.reportDataRow.get(n);
                this.globalView.putField(string, object, true);
            }
        }
    }

    public boolean isAdvanceable() throws DataSourceException {
        if (this.reportDataRow == null) {
            return false;
        }
        return this.reportDataRow.isAdvanceable();
    }

    public DataRow getGlobalView() {
        return this.globalView;
    }

    public void dataRowChanged(MasterDataRowChangeEvent masterDataRowChangeEvent) throws DataSourceException {
        int n = masterDataRowChangeEvent.getType();
        if (n == 1) {
            this.globalView.putField(masterDataRowChangeEvent.getColumnName(), masterDataRowChangeEvent.getColumnValue(), false);
        } else if (n == 3) {
            this.globalView.putField(masterDataRowChangeEvent.getColumnName(), masterDataRowChangeEvent.getColumnValue(), true);
        } else if (n == 2) {
            this.globalView.removeColumn(masterDataRowChangeEvent.getColumnName());
        }
    }
}

