/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.imageio;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.AbstractFactoryModule;

public class ImageIOFactoryModule
extends AbstractFactoryModule {
    private static final int[] EMPTY_FINGERPRINT = new int[0];
    private static final String[] EMPTY_FILETYPE = new String[0];

    private Image createImage(byte[] imageData) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(imageData));
    }

    @Override
    public int canHandleResource(ResourceManager caller, ResourceData data) throws ResourceCreationException, ResourceLoadingException {
        try {
            byte[] resource = data.getResource(caller);
            if (this.createImage(resource) != null) {
                return 2000;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        Image image;
        long version = data.getVersion(caller);
        byte[] resource = data.getResource(caller);
        try {
            image = this.createImage(resource);
        }
        catch (IOException e) {
            throw new ResourceCreationException("Failed to load the image.", e);
        }
        if (image == null) {
            throw new ResourceCreationException("Failed to load the image. ImageIO#read returned null");
        }
        return new SimpleResource(data.getKey(), image, Image.class, version);
    }

    @Override
    protected String[] getMimeTypes() {
        return EMPTY_FILETYPE;
    }

    @Override
    protected String[] getFileExtensions() {
        return EMPTY_FILETYPE;
    }

    @Override
    protected int[] getFingerPrint() {
        return EMPTY_FINGERPRINT;
    }

    @Override
    public int getHeaderFingerprintSize() {
        return 0;
    }
}

