/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.Cookie;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.SessionConfig;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationSessionCookieConfig
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager(ApplicationSessionCookieConfig.class);
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = false;
    private static final boolean DEFAULT_SECURE = false;
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String name;
    private StandardContext context;

    public ApplicationSessionCookieConfig(StandardContext context) {
        this.context = context;
    }

    public String getComment() {
        return null;
    }

    public String getDomain() {
        return this.getAttribute("Domain");
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute("Max-Age");
        if (maxAge == null) {
            return -1;
        }
        return Integer.parseInt(maxAge);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.getAttribute("Path");
    }

    public boolean isHttpOnly() {
        String httpOnly = this.getAttribute("HttpOnly");
        if (httpOnly == null) {
            return false;
        }
        return Boolean.parseBoolean(httpOnly);
    }

    public boolean isSecure() {
        String secure = this.getAttribute("Secure");
        if (secure == null) {
            return false;
        }
        return Boolean.parseBoolean(secure);
    }

    public void setComment(String comment) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"comment", this.context.getPath()}));
        }
    }

    public void setDomain(String domain) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"domain name", this.context.getPath()}));
        }
        this.setAttribute("Domain", domain);
    }

    public void setHttpOnly(boolean httpOnly) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"HttpOnly", this.context.getPath()}));
        }
        this.setAttribute("HttpOnly", Boolean.toString(httpOnly));
    }

    public void setMaxAge(int maxAge) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"max age", this.context.getPath()}));
        }
        this.setAttribute("Max-Age", Integer.toString(maxAge));
    }

    public void setName(String name) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"name", this.context.getPath()}));
        }
        this.name = name;
    }

    public void setPath(String path) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"path", this.context.getPath()}));
        }
        this.setAttribute("Path", path);
    }

    public void setSecure(boolean secure) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{"secure", this.context.getPath()}));
        }
        this.setAttribute("Secure", Boolean.toString(secure));
    }

    public void setAttribute(String name, String value) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", new Object[]{name, this.context.getPath()}));
        }
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static Cookie createSessionCookie(Context context, String sessionId, boolean secure) {
        SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
        Cookie cookie = new Cookie(SessionConfig.getSessionCookieName(context), sessionId);
        cookie.setMaxAge(scc.getMaxAge());
        if (context.getSessionCookieDomain() == null) {
            if (scc.getDomain() != null) {
                cookie.setDomain(scc.getDomain());
            }
        } else {
            cookie.setDomain(context.getSessionCookieDomain());
        }
        if (scc.isSecure() || secure) {
            cookie.setSecure(true);
        }
        if (scc.isHttpOnly() || context.getUseHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setAttribute("Partitioned", Boolean.toString(context.getUsePartitioned()));
        cookie.setPath(SessionConfig.getSessionCookiePath(context));
        block11: for (Map.Entry attribute : scc.getAttributes().entrySet()) {
            switch ((String)attribute.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": {
                    continue block11;
                }
            }
            cookie.setAttribute((String)attribute.getKey(), (String)attribute.getValue());
        }
        return cookie;
    }
}

