/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeExtendable;
import org.jkiss.dbeaver.model.navigator.registry.DBNModelExtenderDescriptor;
import org.jkiss.utils.CommonUtils;

public class DBNRegistry {
    private static final Log log = Log.getLog(DBNRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.navigator";
    private static DBNRegistry instance = null;
    private final List<DBNModelExtenderDescriptor> modelExtenders = new ArrayList<DBNModelExtenderDescriptor>();
    private DBNModelExtenderDescriptor defaultApplication;

    public static synchronized DBNRegistry getInstance() {
        if (instance == null) {
            instance = new DBNRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DBNRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (ext.getName().equals("extender")) {
                DBNModelExtenderDescriptor app = new DBNModelExtenderDescriptor(ext);
                this.modelExtenders.add(app);
            }
            ++n2;
        }
    }

    public void extendNode(DBNNodeExtendable parentNode) {
        if (this.modelExtenders.isEmpty()) {
            return;
        }
        ArrayList extraNodes = null;
        for (DBNModelExtenderDescriptor med : this.modelExtenders) {
            try {
                DBNNode[] enList = med.getInstance().getExtraNodes((DBNNode)((Object)parentNode));
                if (enList == null) continue;
                if (extraNodes == null) {
                    extraNodes = new ArrayList();
                }
                Collections.addAll(extraNodes, enList);
            }
            catch (DBException e) {
                log.debug("Error getting model extenders", e);
            }
        }
        if (!CommonUtils.isEmpty(extraNodes)) {
            for (DBNNode eNode : extraNodes) {
                parentNode.addExtraNode(eNode);
            }
        }
    }
}

