/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class OracleExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<DBSCatalog, OracleSchema> {
    private static final Log log = Log.getLog(OracleExecutionContext.class);
    private String activeSchemaName;

    OracleExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)super.getDataSource();
    }

    @NotNull
    public OracleExecutionContext getContextDefaults() {
        return this;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public DBSCatalog getDefaultCatalog() {
        return null;
    }

    public OracleSchema getDefaultSchema() {
        try {
            return this.activeSchemaName == null ? null : this.getDataSource().getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.activeSchemaName);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DBSCatalog catalog, OracleSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, OracleSchema schema) throws DBCException {
        OracleSchema oldSelectedEntity = this.getDefaultSchema();
        if (schema == null || oldSelectedEntity == schema) {
            return;
        }
        this.setCurrentSchema(monitor, schema);
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)schema);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema");){
                DBPConnectionBootstrap bootstrap;
                if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultSchemaName())) {
                    this.setCurrentSchema(monitor, bootstrap.getDefaultSchemaName());
                }
                this.activeSchemaName = OracleUtils.getCurrentSchema(session);
                if (this.activeSchemaName != null && this.activeSchemaName.isEmpty()) {
                    this.activeSchemaName = null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        return true;
    }

    void setCurrentSchema(DBRProgressMonitor monitor, OracleSchema object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        this.setCurrentSchema(monitor, object.getName());
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, String activeSchemaName) throws DBCException {
        OracleSchema oldDefaultSchema = this.getDefaultSchema();
        if (oldDefaultSchema == null || !oldDefaultSchema.getName().equals(activeSchemaName)) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                    OracleUtils.setCurrentSchema(session, activeSchemaName);
                    this.activeSchemaName = activeSchemaName;
                    OracleSchema newDefaultSchema = this.getDefaultSchema();
                    DBUtils.fireObjectSelectionChange((DBSObject)oldDefaultSchema, (DBSObject)newDefaultSchema);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
    }
}

