/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionWizard;

public class NewConnectionDialog
extends ActiveWizardDialog {
    private static final int TEST_BUTTON_ID = 2000;
    private static volatile NewConnectionDialog dialogInstance;
    private Button testButton;

    private NewConnectionDialog(IWorkbenchWindow window, ConnectionWizard wizard) {
        super(window, (IWizard)wizard);
        this.setAdaptContainerSizeToPages(true);
    }

    protected boolean isModalWizard() {
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.testButton = this.createButton(parent, 2000, CoreMessages.dialog_connection_button_test, false);
        this.testButton.setEnabled(false);
        this.testButton.moveAbove((Control)this.getButton(14));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.testConnection();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        ConnectionWizard wizard = (ConnectionWizard)this.getWizard();
        ConnectionPageSettings settings = wizard.getPageSettings();
        this.testButton.setEnabled(settings != null && settings.isPageComplete());
        super.updateButtons();
    }

    private void testConnection() {
        ConnectionWizard wizard = (ConnectionWizard)this.getWizard();
        wizard.testConnection();
    }

    public int open() {
        if (DBWorkbench.getPlatform().getWorkspace().getActiveProject() == null) {
            DBWorkbench.getPlatformUI().showError("No active project", "No active project, can't create new connection.\nActivate or create new project.");
            return 1;
        }
        try {
            return super.open();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Internal error", "Internal error when opening new connection wizard", (Throwable)e);
            return 1;
        }
    }

    public static boolean openNewConnectionDialog(IWorkbenchWindow window) {
        return NewConnectionDialog.openNewConnectionDialog(window, null);
    }

    public static boolean openNewConnectionDialog(IWorkbenchWindow window, DBPDriver initialDriver) {
        if (dialogInstance != null) {
            dialogInstance.getShell().forceActive();
            return true;
        }
        dialogInstance = new NewConnectionDialog(window, new NewConnectionWizard(initialDriver));
        try {
            boolean bl = dialogInstance.open() == 0;
            return bl;
        }
        finally {
            dialogInstance = null;
        }
    }
}

