/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionWizard;
import org.jkiss.utils.CommonUtils;

public class EditConnectionDialog
extends MultiPageWizardDialog {
    private static final Map<DBPDataSourceContainer, EditConnectionDialog> openDialogs = Collections.synchronizedMap(new IdentityHashMap());
    private static final int TEST_BUTTON_ID = 2000;
    private static String lastActivePage;
    private Button testButton;
    private String defaultPageName;

    private EditConnectionDialog(IWorkbenchWindow window, ConnectionWizard wizard) {
        super(window, (IWizard)wizard);
    }

    public ConnectionWizard getWizard() {
        return (ConnectionWizard)super.getWizard();
    }

    protected boolean isModalWizard() {
        return false;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.EditConnectionDialog");
    }

    protected Control createContents(Composite parent) {
        Tree pagesTree;
        TreeItem[] items;
        Control contents = super.createContents(parent);
        String activePage = this.defaultPageName;
        if (CommonUtils.isEmpty((String)activePage)) {
            activePage = lastActivePage;
        }
        if (!CommonUtils.isEmpty((String)activePage)) {
            String finalActivePage = activePage;
            UIUtils.asyncExec(() -> this.getWizard().openSettingsPage(finalActivePage));
        }
        if ((items = (pagesTree = this.getPagesTree()).getItems()).length > 0) {
            items[0].setExpanded(true);
        }
        return contents;
    }

    protected boolean isAutoLayoutAvailable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.testButton = this.createButton(parent, 2000, "   " + CoreMessages.dialog_connection_button_test + "   ", false);
        this.testButton.setEnabled(false);
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.testConnection();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        if (this.getCurrentPage() != null) {
            lastActivePage = this.getCurrentPage().getName();
        }
        return super.close();
    }

    public void updateButtons() {
        if (this.testButton != null) {
            ConnectionPageSettings settings = this.getWizard().getPageSettings();
            this.testButton.setEnabled(settings != null && settings.isPageComplete());
        }
        super.updateButtons();
    }

    private void testConnection() {
        this.getWizard().testConnection();
    }

    public static boolean openEditConnectionDialog(IWorkbenchWindow window, DBPDataSourceContainer dataSource, String defaultPageName) {
        EditConnectionDialog dialog = openDialogs.get(dataSource);
        if (dialog != null) {
            if (defaultPageName != null) {
                dialog.showPage(defaultPageName);
            }
            dialog.getShell().forceActive();
            return true;
        }
        EditConnectionWizard wizard = new EditConnectionWizard((DataSourceDescriptor)dataSource);
        dialog = new EditConnectionDialog(window, wizard);
        dialog.defaultPageName = defaultPageName;
        openDialogs.put(dataSource, dialog);
        try {
            boolean bl = dialog.open() == 0;
            return bl;
        }
        finally {
            openDialogs.remove(dataSource);
        }
    }
}

