/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.IndiPanel;
import ancestris.modules.editors.standard.tools.AssoWrapper55;
import ancestris.modules.editors.standard.tools.AssoWrapper7;
import ancestris.modules.editors.standard.tools.EventWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Entity;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import java.util.List;
import javax.swing.DefaultListModel;
import org.openide.util.NbBundle;

public abstract class AssoWrapper {
    protected Indi targetIndi = null;
    protected TargetIndiInfo targetIndiInfo = new TargetIndiInfo();
    protected Entity beneficiaryEntity = null;
    protected Property beneficiaryEventProperty = null;
    protected String roleOfTargetEntityForBeneficiary = "";
    protected EventWrapper beneficiaryEventWrapper = null;
    protected String targetEventDescription = "";
    private static Indi voidIndi = null;
    protected PropertyAssociation propertyAssociation = null;

    public static List<AssoWrapper> getList(Indi indi, List<EventWrapper> eventSet) {
        Grammar grammar = indi.getGedcom().getGrammar();
        if (grammar == Grammar.V70) {
            return AssoWrapper7.getList(indi, eventSet);
        }
        return AssoWrapper55.getList(indi, eventSet);
    }

    public static DefaultListModel<AssoWrapper> getListModel(Indi indi) {
        Grammar grammar = indi.getGedcom().getGrammar();
        if (grammar == Grammar.V70) {
            return AssoWrapper7.getListModel(indi);
        }
        return AssoWrapper55.getListModel(indi);
    }

    public static AssoWrapper createEmpty(Grammar grammar) {
        if (grammar == Grammar.V70) {
            return new AssoWrapper7(null, null);
        }
        return new AssoWrapper55(null, null);
    }

    private Indi getVoidIndi() {
        if (voidIndi == null) {
            voidIndi = new Indi("INDI", "VOID");
        }
        return voidIndi;
    }

    public AssoWrapper(PropertyAssociation property, List<EventWrapper> eventSet) {
        EventWrapper event;
        if (property == null) {
            return;
        }
        this.propertyAssociation = property;
        if (!(this.propertyAssociation.getWitness() instanceof Indi)) {
            return;
        }
        this.targetIndi = (Indi)this.propertyAssociation.getWitness();
        if (this.targetIndi == null && this.propertyAssociation.getValue().equals("@VOID@")) {
            this.targetIndi = this.getVoidIndi();
        }
        this.beneficiaryEntity = this.propertyAssociation.getBeneficiary();
        this.roleOfTargetEntityForBeneficiary = this.propertyAssociation.getRole();
        this.targetEventDescription = this.propertyAssociation.getDisplayValue(true);
        this.beneficiaryEventProperty = this.propertyAssociation.getEvent(true);
        this.beneficiaryEventWrapper = event = AssoWrapper.getEventWherePropIs(this.beneficiaryEventProperty, eventSet);
        this.targetIndiInfo = new TargetIndiInfo(this.targetIndi, event);
    }

    public Indi getTargetIndi() {
        return this.targetIndi;
    }

    public void setTargetIndi(Indi indi) {
        this.targetIndi = indi;
        this.targetIndiInfo.setInfo(indi);
    }

    public TargetIndiInfo getTargetIndiInfo() {
        return this.targetIndiInfo;
    }

    public Property getBeneficiaryEventProperty() {
        return this.beneficiaryEventProperty;
    }

    public void setBeneficiaryEventProperty(Property property) {
        this.beneficiaryEventProperty = property;
    }

    public EventWrapper getBeneficiaryEventWrapper() {
        return this.beneficiaryEventWrapper;
    }

    public void setBeneficiaryEventWrapper(EventWrapper event) {
        this.beneficiaryEventWrapper = event;
    }

    public String getRoleOfTargetEntityForBeneficiary() {
        return this.roleOfTargetEntityForBeneficiary;
    }

    public void setRoleOfTargetEntityForBeneficiary(String role) {
        this.roleOfTargetEntityForBeneficiary = role;
    }

    public String getOccupation(Indi indi, EventWrapper event) {
        Property occu = indi.getPropertyAtDate("INDI:OCCU", event != null ? event.date : null);
        return occu == null ? "" : occu.getDisplayValue();
    }

    public String toString() {
        String altTxt;
        String txt = this.targetIndiInfo != null ? this.targetIndiInfo.displayName : "";
        String string = altTxt = this.roleOfTargetEntityForBeneficiary != null ? this.roleOfTargetEntityForBeneficiary : "";
        if (txt.isBlank() && NbBundle.getMessage(IndiPanel.class, (String)"No_Association_Text").equals(altTxt)) {
            return altTxt;
        }
        return txt;
    }

    public boolean equals(AssoWrapper object) {
        return this.propertyAssociation != null && this.propertyAssociation.equals(object.propertyAssociation);
    }

    protected abstract boolean isGrammar7();

    public abstract void update();

    public abstract void remove();

    protected boolean isToBeUpdated() {
        String targetId;
        if (this.targetIndiInfo.hasChanged || this.targetIndiInfo.occupationDateUpdate) {
            return true;
        }
        if (!this.targetIndi.getFirstName().equals(this.targetIndiInfo.firstname)) {
            return true;
        }
        if (!this.targetIndi.getLastName().equals(this.targetIndiInfo.lastname)) {
            return true;
        }
        if (this.targetIndi.getSex() != this.targetIndiInfo.sex) {
            return true;
        }
        String newOccu = this.targetIndiInfo.occupation.trim();
        if (!newOccu.isEmpty()) {
            Property[] occuProps = this.targetIndi.getProperties("OCCU");
            boolean found = false;
            for (Property p : occuProps) {
                String occuStr = "";
                if (p != null) {
                    occuStr = p.getDisplayValue().trim();
                }
                if (!occuStr.equals(newOccu)) continue;
                found = true;
            }
            if (!found) {
                return true;
            }
        }
        if (this.beneficiaryEntity == null || this.targetIndi == null || this.targetIndi.getGedcom() == null || this.propertyAssociation == null) {
            return true;
        }
        String val = this.propertyAssociation.getValue();
        String string = targetId = this.isGrammar7() ? this.targetIndi.getId() : this.beneficiaryEntity.getId();
        if (!val.equals("@" + targetId + "@")) {
            return true;
        }
        if (this.isGrammar7()) {
            String phrase;
            if (this.beneficiaryEventWrapper.eventProperty != this.propertyAssociation.getParent()) {
                return true;
            }
            PropertyChoiceRole p = (PropertyChoiceRole)this.propertyAssociation.getProperty("ROLE");
            String role = p != null ? p.getDisplayValue() : "";
            String string2 = phrase = p != null ? p.getPhrase() : "";
            if (!this.roleOfTargetEntityForBeneficiary.equals(role) && !this.roleOfTargetEntityForBeneficiary.equals(phrase)) {
                return true;
            }
        } else {
            String role;
            TagPath oldAnchor;
            TagPath newAnchor = this.getAnchor(this.beneficiaryEventWrapper.eventProperty);
            PropertyRelationship p = (PropertyRelationship)this.propertyAssociation.getProperty("RELA");
            TagPath tagPath = oldAnchor = p != null ? p.getAnchor() : null;
            if (oldAnchor == null || !oldAnchor.equals((Object)newAnchor)) {
                return true;
            }
            String string3 = role = p != null ? p.getDisplayValue() : "";
            if (!this.roleOfTargetEntityForBeneficiary.equals(role)) {
                return true;
            }
        }
        return false;
    }

    protected TagPath getAnchor(Property property) {
        if (property == null) {
            return null;
        }
        TagPath result = property.getPath(false);
        return property.getEntity().getProperty(result) == property ? result : property.getPath(true);
    }

    protected void putProperty(Property property, String tag, String value) {
        Property prop = property.getProperty(tag, true);
        if (prop != null) {
            Utils.setDistinctValue(prop, value);
        } else {
            property.addProperty(tag, value);
        }
    }

    protected void removeLink(PropertyAssociation pa) {
        PropertyXRef target = pa.getTarget();
        if (target == null) {
            return;
        }
        Property targetParent = target.getParent();
        pa.unlink();
        targetParent.delProperty((Property)target);
    }

    protected void updateProperty(Property property, String tag, String newValue, boolean updateDate, Property sourceEvent) {
        if (newValue.isEmpty()) {
            return;
        }
        PropertyDate sourceDate = sourceEvent != null ? (PropertyDate)sourceEvent.getProperty("DATE") : null;
        String newDate = sourceDate != null ? sourceDate.getValue() : "";
        Property foundProperty = property.getPropertyAtDate("INDI:" + tag, sourceDate);
        String oldValue = foundProperty != null ? foundProperty.getValue() : "";
        PropertyDate pDate = foundProperty != null ? (PropertyDate)foundProperty.getProperty("DATE") : null;
        boolean overlap = true;
        boolean propertyChange = !newValue.equals(oldValue);
        PointInTime pStart = null;
        PointInTime pEnd = null;
        PointInTime sourceStart = null;
        PointInTime sourceEnd = null;
        try {
            pStart = pDate.getStart();
            pEnd = pDate.getEnd();
            if (pEnd == null || pEnd.isEmpty()) {
                pEnd = pStart;
            }
            sourceStart = sourceDate.getStart();
            sourceEnd = sourceDate.getEnd();
            if (sourceEnd == null || sourceEnd.isEmpty()) {
                sourceEnd = sourceStart;
            }
            overlap = sourceStart.compareTo(pStart) >= 0 && sourceStart.compareTo(pEnd) <= 0 || sourceEnd.compareTo(pStart) >= 0 && sourceEnd.compareTo(pEnd) <= 0 || pStart.compareTo(sourceStart) >= 0 && pStart.compareTo(sourceEnd) <= 0 || pEnd.compareTo(sourceStart) >= 0 && pEnd.compareTo(sourceEnd) <= 0;
        }
        catch (Exception e) {
            overlap = true;
        }
        if (!overlap && propertyChange) {
            foundProperty = null;
        }
        if (foundProperty == null) {
            Property prop = property.addProperty(tag, newValue);
            if (updateDate && !newDate.isEmpty()) {
                prop.addProperty("DATE", newDate);
            }
        } else {
            if (propertyChange) {
                foundProperty.setValue(newValue);
            }
            if (updateDate && !newDate.isEmpty()) {
                if (pDate == null) {
                    foundProperty.addProperty("DATE", newDate);
                } else if (!overlap) {
                    if (sourceEnd.compareTo(pStart) < 0) {
                        pDate.setValue(PropertyDate.FROM_TO, sourceStart, pEnd, "");
                    } else {
                        pDate.setValue(PropertyDate.FROM_TO, pStart, sourceEnd, "");
                    }
                }
            }
        }
    }

    public static AssoWrapper clone(AssoWrapper asso, Grammar grammar) {
        AssoWrapper assoCopy = AssoWrapper.createEmpty(grammar);
        assoCopy.propertyAssociation = asso.propertyAssociation;
        assoCopy.roleOfTargetEntityForBeneficiary = asso.roleOfTargetEntityForBeneficiary;
        assoCopy.targetIndi = asso.targetIndi;
        assoCopy.targetIndiInfo = asso.targetIndiInfo;
        assoCopy.targetIndiInfo.setInfo(asso.targetIndiInfo);
        assoCopy.beneficiaryEntity = asso.beneficiaryEntity;
        assoCopy.beneficiaryEventWrapper = asso.beneficiaryEventWrapper;
        assoCopy.targetEventDescription = asso.targetEventDescription;
        return assoCopy;
    }

    protected static EventWrapper getEventWherePropIs(Property eventProp, List<EventWrapper> eventSet) {
        if (eventSet == null) {
            return null;
        }
        for (EventWrapper event : eventSet) {
            if (event.eventProperty != eventProp) continue;
            return event;
        }
        if (eventProp instanceof Entity) {
            Entity entity = (Entity)eventProp;
            return new EventWrapper(entity);
        }
        return null;
    }

    protected class TargetIndiInfo {
        public boolean hasChanged = false;
        public String lastname = "";
        public String fullSurname = "";
        public String firstname = "";
        public int sex = 0;
        public String occupation = "";
        public boolean occupationDateUpdate = false;
        public String displayName = "";

        public TargetIndiInfo() {
        }

        public TargetIndiInfo(Indi indi, EventWrapper event) {
            if (indi == null) {
                return;
            }
            this.setInfo(indi);
            this.occupation = AssoWrapper.this.getOccupation(indi, event);
            this.occupationDateUpdate = false;
        }

        public final void setInfo(Indi indi) {
            this.lastname = indi.getLastName();
            this.fullSurname = indi.getFullSurname();
            this.firstname = indi.getFirstName();
            this.sex = indi.getSex();
            String name = indi.getDisplayTitle(false);
            this.displayName = AssoWrapper.this.roleOfTargetEntityForBeneficiary + (String)(!name.isEmpty() ? " | " + name : "");
        }

        public void setInfo(TargetIndiInfo info) {
            this.hasChanged = info.hasChanged;
            this.lastname = info.lastname;
            this.firstname = info.firstname;
            this.fullSurname = info.fullSurname;
            this.sex = info.sex;
            this.occupation = info.occupation;
            this.occupationDateUpdate = info.occupationDateUpdate;
        }

        public boolean isEmptyName() {
            return this.lastname.trim().isEmpty() || this.firstname.trim().isEmpty();
        }
    }
}

