/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.renderer.DPI;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JComponent;

public class ScreenResolutionScale
extends JComponent {
    private DPI dpi = new DPI(Toolkit.getDefaultToolkit().getScreenResolution(), Toolkit.getDefaultToolkit().getScreenResolution());
    private static final float DPI2CM = 0.39370078f;

    public ScreenResolutionScale(DPI dpi) {
        this.setDPI(dpi);
        this.addMouseMotionListener(new MouseGlue());
    }

    public DPI getDPI() {
        return this.dpi;
    }

    public void setDPI(DPI set) {
        this.dpi = set;
    }

    @Override
    protected void paintComponent(Graphics graphcs) {
        graphcs.setColor(Color.white);
        graphcs.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphcs.setColor(Color.black);
        graphcs.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintLabel(graphcs);
        this.paintScale(graphcs);
    }

    private void paintScale(Graphics graphcs) {
        UnitGraphics gw = new UnitGraphics(graphcs, 0.39370078f * (float)this.dpi.horizontal(), 0.39370078f * (float)this.dpi.vertical());
        gw.setAntialiasing(true);
        gw.setFont(new Font("Arial", 0, 10));
        Rectangle2D clip = gw.getClip();
        int X = 1;
        do {
            gw.setColor(Color.gray);
            for (double x = 0.1; x < 0.9; x += 0.1) {
                gw.draw((double)X - x, 0.0, (double)X - x, 0.1);
            }
            gw.setColor(Color.black);
            gw.draw(X, 0.0, (double)X, 0.4);
            gw.draw("" + X, (double)X, 1.0, 0.0, 0.0);
        } while ((double)X++ < clip.getMaxX());
        int Y = 1;
        do {
            gw.setColor(Color.gray);
            for (double y = 0.1; y < 0.9; y += 0.1) {
                gw.draw(0.0, (double)Y - y, 0.1, (double)Y - y);
            }
            gw.setColor(Color.black);
            gw.draw(0.0, (double)Y, 0.4, (double)Y);
            gw.draw("" + Y, 1.0, (double)Y, 0.0, 0.0);
        } while ((double)Y++ < clip.getMaxY());
    }

    private void paintLabel(Graphics graphcs) {
        graphcs.setColor(Color.black);
        FontMetrics fm = graphcs.getFontMetrics();
        int fh = fm.getHeight();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String[] txt = new String[]{nf.format(this.dpi.horizontal()), "by", nf.format(this.dpi.vertical()), "DPI"};
        for (int i = 0; i < txt.length; ++i) {
            graphcs.drawString(txt[i], this.getWidth() / 2 - fm.stringWidth(txt[i]) / 2, this.getHeight() / 2 - txt.length * fh / 2 + i * fh + fh);
        }
        graphcs.drawString("cm", 16, 16 + fm.getAscent());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(3 * this.dpi.horizontal(), 3 * this.dpi.vertical());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(64, 64);
    }

    private class MouseGlue
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean axis;
        private Point startPos = new Point();
        private Point startDPI = new Point();

        private MouseGlue() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.startPos.x = e.getPoint().x;
            this.startPos.y = e.getPoint().y;
            this.startDPI.x = ScreenResolutionScale.this.dpi.horizontal();
            this.startDPI.y = ScreenResolutionScale.this.dpi.vertical();
            this.axis = this.startPos.x > this.startPos.y;
            ScreenResolutionScale.this.setCursor(Cursor.getPredefinedCursor(this.axis ? 11 : 9));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            float x = e.getPoint().x;
            float y = e.getPoint().y;
            ScreenResolutionScale.this.dpi = this.axis ? new DPI((int)Math.max(10.0f, (float)this.startDPI.x * (x / (float)this.startPos.x)), ScreenResolutionScale.this.dpi.vertical()) : new DPI(ScreenResolutionScale.this.dpi.horizontal(), (int)Math.max(10.0f, (float)this.startDPI.y * (y / (float)this.startPos.y)));
            ScreenResolutionScale.this.repaint();
        }
    }
}

