/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.pajek;

import java.util.ArrayList;

class EdgeMatrix {
    protected boolean[][] mat;
    protected int curLine = 0;

    public EdgeMatrix(int size) {
        this.mat = new boolean[size][size];
    }

    public int size() {
        return this.mat.length;
    }

    public boolean hasEdge(int line, int col) {
        return this.mat[line][col];
    }

    public void set(int line, int col, boolean value) {
        this.mat[line][col] = value;
    }

    public void addLine(ArrayList<String> line) {
        if (this.curLine < this.mat.length) {
            if (line.size() == this.mat.length) {
                int i = 0;
                while (i < this.mat.length) {
                    this.mat[this.curLine][i] = line.get(i).equals("1");
                    ++i;
                }
                ++this.curLine;
            } else if (line.size() == this.mat.length * this.mat.length) {
                int n = this.mat.length * this.mat.length;
                this.curLine = -1;
                int i = 0;
                while (i < n) {
                    if (i % this.mat.length == 0) {
                        ++this.curLine;
                    }
                    this.mat[this.curLine][i - this.curLine * this.mat.length] = line.get(i).equals("1");
                    ++i;
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        while (line < this.mat.length) {
            int col = 0;
            while (col < this.mat.length) {
                buffer.append(String.format("%s ", this.mat[line][col] ? "1" : "0"));
                ++col;
            }
            buffer.append(String.format("%n", new Object[0]));
            ++line;
        }
        return buffer.toString();
    }
}

