/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class WebCitiesDetails
extends WebSection {
    private final Comparator<Property> sortEvents = (prop1, prop2) -> {
        if (prop1 == null && prop2 != null) {
            return -1;
        }
        if (prop1 != null && prop2 == null) {
            return 1;
        }
        if (prop1 == null && prop2 == null) {
            return 0;
        }
        String fullname1 = this.getFullname((Property)prop1);
        String fullname2 = this.getFullname((Property)prop2);
        if (fullname1 == null && fullname2 != null) {
            return -1;
        }
        if (fullname1 != null && fullname2 == null) {
            return 1;
        }
        if (fullname1 == null && fullname2 == null) {
            return 0;
        }
        if (fullname1.compareTo(fullname2) != 0) {
            return fullname1.compareTo(fullname2);
        }
        PropertyDate date1 = this.getDate((Property)prop1);
        PropertyDate date2 = this.getDate((Property)prop2);
        if (date1 == null && date2 != null) {
            return -1;
        }
        if (date1 != null && date2 == null) {
            return 1;
        }
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1.compareTo((Property)date2) != 0) {
            return date1.compareTo((Property)date2);
        }
        Entity ent1 = prop1.getEntity();
        Entity ent2 = prop2.getEntity();
        if (ent1 == null && ent2 != null) {
            return -1;
        }
        if (ent1 != null && ent2 == null) {
            return 1;
        }
        if (ent1 == null && ent2 == null) {
            return 0;
        }
        if (ent1.toString().compareTo(ent2.toString()) != 0) {
            return ent1.toString().compareTo(ent2.toString());
        }
        return ent1.getId().compareTo(ent2.getId());
    };

    public WebCitiesDetails(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Citiesdetails"), "citiesdetails", "citiesdetails_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection);
        this.calcPages();
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        List<String> cities = this.wh.getCities(this.wh.gedcom);
        Object fileStr = "";
        File file = null;
        PrintWriter out = null;
        Object cityfile = "";
        int cpt = 0;
        int nbCities = cities.size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbCities / this.nbPerPage + 1;
        for (String city : cities) {
            previousPage = (currentPage = ++cpt / this.nbPerPage + 1) == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            cityfile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (((String)fileStr).compareTo((String)cityfile) != 0) {
                if (out != null) {
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 1, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    out.close();
                    this.wh.log.write((String)fileStr + this.trs("EXEC_DONE"));
                }
                fileStr = cityfile;
                file = this.wh.getFileForName(dir, (String)cityfile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Citiesdetails", this);
            }
            this.exportLinks(out, (String)cityfile, 1, previousPage, nextPage, lastPage);
            this.exportCityDetails(out, city, this.wh.getCityDisplayName(city));
        }
        if (out != null) {
            this.exportLinks(out, (String)cityfile, 1, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write((String)fileStr + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    private void exportCityDetails(PrintWriter out, String city, String cityDislplayName) {
        out.println("<h2 class=\"unk\"><a id=\"" + this.htmlAnchorText(city) + "\"></a>" + this.htmlText(cityDislplayName) + "</h2>");
        List<Property> listProps = this.wh.getCitiesProps(city);
        Collections.sort(listProps, this.sortEvents);
        String lastFullname = "";
        boolean first = true;
        for (Property prop : listProps) {
            if (prop == null || prop.getValue().length() == 0) continue;
            String fullname = this.getFullname(prop);
            boolean change = false;
            if (fullname.compareTo(lastFullname) != 0) {
                change = true;
            }
            lastFullname = fullname;
            if (change) {
                if (!first) {
                    out.println("<span class=\"spacer\">&nbsp;</span></div>");
                    out.println("<div class=\"spacer\">&nbsp;</div>");
                    out.println("</div>");
                }
                out.println("<div class=\"citycont\">");
                out.println("<div class=\"citycont1\">");
                first = false;
                if (prop instanceof PropertyPlace) {
                    this.displayPlace(out, city, prop);
                }
                this.displayHeader(out);
            }
            this.displayEvent(out, prop);
        }
        out.println("<span class=\"spacer\">&nbsp;</span></div>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    public String getFullname(Property prop) {
        return prop instanceof PropertyPlace ? prop.toString().trim() : "";
    }

    public String getCity(Property prop) {
        return prop instanceof PropertyPlace ? ((PropertyPlace)prop).getCity().trim() : "";
    }

    public String getCountry(Property prop) {
        String ctry = "";
        if (prop instanceof PropertyPlace) {
            String[] dataBits = prop.toString().split("\\,", -1);
            ctry = dataBits[dataBits.length - 1].trim();
        }
        return ctry;
    }

    public PropertyDate getDate(Property prop) {
        Property date = null;
        if (prop instanceof PropertyPlace) {
            Property parent = prop.getParent();
            if (parent != null) {
                date = parent.getProperty("DATE");
            }
        } else {
            Property parent = prop.getParent();
            Property gparent = null;
            if (parent != null) {
                gparent = parent.getParent();
            }
            if (gparent != null) {
                date = gparent.getProperty("DATE");
            }
        }
        if (date instanceof PropertyDate) {
            return (PropertyDate)date;
        }
        return null;
    }

    private void displayPlace(PrintWriter out, String city, Property prop) {
        out.println("<p class=\"cityloc\"><span class=\"gras\">" + this.htmlText(this.trs("place_loc")) + "</span>");
        this.displayLink2Map(out, prop, city);
        out.println("</p>");
        out.println("<span class=\"cityloc1\">");
        String[] dataBits = prop.toString().split("\\,", -1);
        for (int i = 0; i < dataBits.length; ++i) {
            if (dataBits[i].length() <= 0) continue;
            out.println(this.htmlText(dataBits[i]));
            out.println("<br />");
        }
        out.println("</span></div>");
    }

    private void displayLink2Map(PrintWriter out, Property prop, String city) {
        if (this.wp.param_media_GeneMap.equals("1")) {
            out.println("&nbsp;<a href=\"../map/map" + (this.wp.param_PHP_Support.equals("1") ? ".php" : ".html") + "?" + this.htmlAnchorText(this.getFullname(prop)) + "\"><img src=\"../" + this.themeDir + "/map.gif\" alt=\"" + this.htmlText(city) + "\" title=\"" + this.htmlText(this.trs("map_of", city)) + "\"/></a>");
        }
    }

    private void displayHeader(PrintWriter out) {
        out.println("<div class=\"citycont2\">");
        out.println("<p class=\"cityevt\"><span class=\"gras\">" + this.htmlText(this.trs("place_event")) + "</span></p>");
    }

    private void displayEvent(PrintWriter out, Property prop) {
        Property parent = prop.getParent();
        Property event = null;
        if (parent == null) {
            return;
        }
        event = prop instanceof PropertyPlace ? parent : parent.getParent();
        if (event == null) {
            return;
        }
        out.println("<span class=\"cityevt1\">" + this.wrapEventDate(this.getDate(prop)) + "</span>");
        out.println("<span class=\"cityevt2\">" + this.wrapPropertyName(event) + "</span>");
        out.println("<span class=\"cityevt3\">" + this.wrapEntity(prop.getEntity()) + "</span>");
        out.println("<span class=\"spacer\">&nbsp;</span>");
    }

    private void calcPages() {
        Object cityfile = "";
        Object fileStr = "";
        int cpt = 0;
        for (String city : this.wh.getCities(this.wh.gedcom)) {
            if (((String)fileStr).compareTo((String)(cityfile = this.sectionPrefix + String.format(this.formatNbrs, ++cpt / this.nbPerPage + 1) + this.sectionSuffix)) != 0) {
                fileStr = cityfile;
            }
            this.cityPage.put(this.htmlAnchorText(city), cityfile);
        }
    }

    public Map<String, String> getPagesMap() {
        return this.cityPage;
    }
}

