/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.GedcomCompareTopComponent;
import ancestris.modules.gedcomcompare.communication.Comm;
import ancestris.modules.gedcomcompare.options.GedcomCompareOptionsPanel;
import ancestris.modules.gedcomcompare.tools.ComparedGedcom;
import ancestris.modules.gedcomcompare.tools.ComparisonFrame;
import ancestris.modules.gedcomcompare.tools.DataFrame;
import ancestris.modules.gedcomcompare.tools.ProfilePanel;
import ancestris.modules.gedcomcompare.tools.STFactory;
import ancestris.modules.gedcomcompare.tools.STMap;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class LocalGedcomFrame
extends DataFrame
implements ComparedGedcom {
    private String uniqueID;
    private final Gedcom gedcom;
    private STMap stMap;
    private int nbIndis;
    private int nbFams;
    private int nbEvens;
    private int nbSTs;
    private boolean busyGedcom = false;
    private int connections;
    private Date startDate;
    private Date endDate;
    private JLabel iconEvenLabel;
    private JLabel iconFamLabel;
    private JLabel iconIndiLabel;
    private JLabel iconSTLabel;
    private JPanel jPanel1;
    private JCheckBox openCheckBox;
    private JCheckBox privateCheckBox;
    private JCheckBox readyCheckBox;
    private JLabel visibleEvenLabel;
    private JLabel visibleFamLabel;
    private JLabel visibleIndiLabel;
    private JLabel visibleSTLabel;
    private final GedcomChanged gedcomChanged = new GedcomChanged();

    public LocalGedcomFrame(GedcomCompareTopComponent gctc, final Gedcom gedcom, int type) {
        super(gedcom.getDisplayName());
        JButton menuButton;
        MouseListener[] mls;
        this.owner = gctc;
        this.gedcom = gedcom;
        this.stMap = null;
        this.type = type;
        this.uniqueID = UUID.randomUUID().toString();
        this.connections = 0;
        this.startDate = new Date();
        this.endDate = new Date();
        this.busyGedcom = true;
        this.initComponents();
        JPopupMenu popup = new JPopupMenu();
        AbstractAction a = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_ShowProfile"), this.getPhotoIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITL_ProfilePanel", (Object)NbBundle.getMessage(this.getClass(), (String)"TITL_ProfilePanel_Myself")), (JComponent)new ProfilePanel(LocalGedcomFrame.this.owner.getMyProfile(), LocalGedcomFrame.this.owner.getMyProfile(), LocalGedcomFrame.this.connections, LocalGedcomFrame.this.startDate, LocalGedcomFrame.this.endDate)).setMessageType(-1).setResizable(false).setOptionType(10).show();
            }
        };
        popup.add(new JMenuItem(a));
        AbstractAction b = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACT_RefreshMap"), new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcomcompare/resources/geost.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalGedcomFrame.this.prepareGedcom();
                LocalGedcomFrame.this.owner.mainHasChanged(gedcom);
            }
        };
        popup.add(new JMenuItem(b));
        this.setComponentPopupMenu(popup);
        JComponent pane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
        if (pane.getComponent(0) instanceof JButton && (mls = (menuButton = (JButton)pane.getComponent(0)).getMouseListeners()).length > 1 && mls[1] instanceof MouseAdapter) {
            menuButton.removeMouseListener(mls[1]);
        }
        super.updateColor();
        this.setReady(false);
        this.setOpen(false);
        this.setPrivate(false);
        this.updateInfo();
        gedcom.addGedcomListener((GedcomListener)this.gedcomChanged);
        this.busyGedcom = false;
    }

    public final void updateInfo() {
        this.nbIndis = this.getNbEntities("INDI");
        this.nbFams = this.getNbEntities("FAM");
        this.nbEvens = this.getNbEvens();
        this.nbSTs = this.getNbSTs();
        this.visibleIndiLabel.setText("" + this.nbIndis);
        this.visibleFamLabel.setText("" + this.nbFams);
        this.visibleEvenLabel.setText("" + this.nbEvens);
        this.visibleSTLabel.setText("" + this.nbSTs);
        this.owner.updateIcon();
        this.openCheckBox.setVisible(false);
        this.privateCheckBox.setVisible(this.isMain());
        this.openCheckBox.setEnabled(this.owner.isSharingOn());
        this.privateCheckBox.setEnabled(this.owner.isSharingOn());
        this.owner.updateStatsDisplay();
    }

    private int getNbEntities(String tag) {
        if (this.gedcom == null || this.gedcom.getName() == null) {
            return 0;
        }
        return this.gedcom.getEntities(tag).size();
    }

    private int getNbEvens() {
        if (this.stMap != null) {
            return this.stMap.getEventNb();
        }
        return 0;
    }

    private int getNbSTs() {
        if (this.stMap != null) {
            return this.stMap.keySet().size();
        }
        return 0;
    }

    private void initComponents() {
        this.iconIndiLabel = new JLabel();
        this.visibleIndiLabel = new JLabel();
        this.iconFamLabel = new JLabel();
        this.visibleFamLabel = new JLabel();
        this.iconEvenLabel = new JLabel();
        this.visibleEvenLabel = new JLabel();
        this.iconSTLabel = new JLabel();
        this.visibleSTLabel = new JLabel();
        this.readyCheckBox = new JCheckBox();
        this.openCheckBox = new JCheckBox();
        this.privateCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setBorder(new SoftBevelBorder(0));
        this.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.toolTipText"));
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/gedcom.png")));
        this.setRequestFocusEnabled(false);
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                LocalGedcomFrame.this.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.iconIndiLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconIndiLabel.setHorizontalAlignment(0);
        this.iconIndiLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconIndiLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconIndiLabel.text"));
        this.iconIndiLabel.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconIndiLabel.toolTipText"));
        this.iconIndiLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleIndiLabel.setFont(this.visibleIndiLabel.getFont().deriveFont((float)this.visibleIndiLabel.getFont().getSize() - 1.0f));
        this.visibleIndiLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleIndiLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.visibleIndiLabel.text"));
        this.visibleIndiLabel.setHorizontalTextPosition(4);
        this.iconFamLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconFamLabel.setHorizontalAlignment(0);
        this.iconFamLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconFamLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconFamLabel.text"));
        this.iconFamLabel.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconFamLabel.toolTipText"));
        this.iconFamLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleFamLabel.setFont(this.visibleFamLabel.getFont().deriveFont((float)this.visibleFamLabel.getFont().getSize() - 1.0f));
        this.visibleFamLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleFamLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.visibleFamLabel.text"));
        this.visibleFamLabel.setHorizontalTextPosition(4);
        this.iconEvenLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconEvenLabel.setHorizontalAlignment(2);
        this.iconEvenLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/even.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconEvenLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconEvenLabel.text"));
        this.iconEvenLabel.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconEvenLabel.toolTipText"));
        this.iconEvenLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleEvenLabel.setFont(this.visibleEvenLabel.getFont().deriveFont((float)this.visibleEvenLabel.getFont().getSize() - 1.0f));
        this.visibleEvenLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleEvenLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.visibleEvenLabel.text"));
        this.visibleEvenLabel.setHorizontalTextPosition(4);
        this.iconSTLabel.setFont(new Font("DejaVu Sans", 0, 11));
        this.iconSTLabel.setHorizontalAlignment(0);
        this.iconSTLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/geost.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconSTLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconSTLabel.text"));
        this.iconSTLabel.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.iconSTLabel.toolTipText"));
        this.iconSTLabel.setPreferredSize(new Dimension(50, 14));
        this.visibleSTLabel.setFont(this.visibleSTLabel.getFont().deriveFont((float)this.visibleSTLabel.getFont().getSize() - 1.0f));
        this.visibleSTLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.visibleSTLabel, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.visibleSTLabel.text"));
        this.visibleSTLabel.setHorizontalTextPosition(4);
        this.readyCheckBox.setFont(this.readyCheckBox.getFont().deriveFont((float)this.readyCheckBox.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.readyCheckBox, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.readyCheckBox.text"));
        this.readyCheckBox.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.readyCheckBox.toolTipText"));
        this.readyCheckBox.setContentAreaFilled(false);
        this.readyCheckBox.setHorizontalAlignment(4);
        this.readyCheckBox.setHorizontalTextPosition(10);
        this.readyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalGedcomFrame.this.readyCheckBoxActionPerformed(evt);
            }
        });
        this.openCheckBox.setFont(this.openCheckBox.getFont().deriveFont((float)this.openCheckBox.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.openCheckBox, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.openCheckBox.text"));
        this.openCheckBox.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.openCheckBox.toolTipText"));
        this.openCheckBox.setContentAreaFilled(false);
        this.openCheckBox.setHorizontalAlignment(4);
        this.openCheckBox.setHorizontalTextPosition(10);
        this.openCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalGedcomFrame.this.openCheckBoxActionPerformed(evt);
            }
        });
        this.privateCheckBox.setFont(this.privateCheckBox.getFont().deriveFont((float)this.privateCheckBox.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.privateCheckBox, (String)NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.privateCheckBox.text"));
        this.privateCheckBox.setToolTipText(NbBundle.getMessage(LocalGedcomFrame.class, (String)"LocalGedcomFrame.privateCheckBox.toolTipText"));
        this.privateCheckBox.setContentAreaFilled(false);
        this.privateCheckBox.setHorizontalAlignment(4);
        this.privateCheckBox.setHorizontalTextPosition(10);
        this.privateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalGedcomFrame.this.privateCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(43, 1));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 43, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconIndiLabel, -2, 14, -2).addComponent(this.iconFamLabel, -2, 14, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visibleIndiLabel).addComponent(this.visibleFamLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconEvenLabel, -2, 14, -2).addComponent(this.iconSTLabel, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.visibleSTLabel, GroupLayout.Alignment.TRAILING).addComponent(this.visibleEvenLabel, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.openCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.readyCheckBox, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.privateCheckBox, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.iconSTLabel, -2, -1, -2).addComponent(this.visibleSTLabel).addComponent(this.readyCheckBox).addComponent(this.iconIndiLabel, -2, -1, -2).addComponent(this.visibleIndiLabel)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.visibleFamLabel).addComponent(this.openCheckBox).addComponent(this.iconFamLabel, -2, -1, -2).addComponent(this.iconEvenLabel, -2, -1, -2).addComponent(this.visibleEvenLabel)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.privateCheckBox).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void privateCheckBoxActionPerformed(ActionEvent evt) {
        this.setPrivate(this.isPrivate());
    }

    private void readyCheckBoxActionPerformed(ActionEvent evt) {
        this.prepareGedcom();
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        if (!this.isMain()) {
            this.focusOther();
        }
    }

    private void openCheckBoxActionPerformed(ActionEvent evt) {
        this.setOpen(this.owner.isSharingOn());
    }

    public void close() {
        this.gedcom.removeGedcomListener((GedcomListener)this.gedcomChanged);
    }

    @Override
    public String getID() {
        return this.uniqueID;
    }

    @Override
    public STMap getMap() {
        return this.stMap;
    }

    @Override
    public String getUserName() {
        return super.getTitle();
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    @Override
    public void setMain(boolean set) {
        super.setMain(set);
        this.openCheckBox.setVisible(false);
        this.privateCheckBox.setVisible(this.isMain());
        this.owner.updateStatsDisplay();
        this.owner.mainHasChanged(this.gedcom);
    }

    public final void setReady(boolean set) {
        ComparisonFrame cf;
        this.readyCheckBox.setSelected(set);
        this.readyCheckBox.setIcon(set ? this.owner.SELECTEDON_ICON : null);
        if (set && (cf = this.owner.getComparisonFrame(this)) != null) {
            cf.launchCompare(true);
        }
        this.updateInfo();
        this.owner.updateStatsDisplay();
        this.owner.rearrangeWindows(false);
        if (Logger.getLogger("ancestris.gedcomcompare").isLoggable(Level.FINE)) {
            STFactory.printMiniSTMap(this.stMap);
        }
    }

    public final void setOpen(boolean set) {
        this.openCheckBox.setSelected(set);
        this.openCheckBox.setIcon(set ? this.owner.SELECTEDON_ICON : null);
        this.setPrivate(set);
        this.updateInfo();
        this.updatePhoto(set);
    }

    public void updatePhoto(boolean set) {
        if (set) {
            this.setFrameIcon(this.getPhotoIcon());
        } else {
            this.setFrameIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/gedcom.png")));
        }
    }

    private ImageIcon getPhotoIcon() {
        return GedcomCompareOptionsPanel.getPhoto(0, this.owner.getMyProfile().photoBytes);
    }

    public final void setPrivate(boolean set) {
        this.privateCheckBox.setSelected(set);
        this.privateCheckBox.setSelectedIcon(set ? this.owner.PRIVATEON_ICON : null);
        if (this.owner.getCommHandler() != null) {
            this.owner.getCommHandler().resetPrivacy();
        }
        this.owner.updateStatsDisplay();
    }

    public boolean isReady() {
        return this.readyCheckBox.isSelected();
    }

    public boolean isOpen() {
        return this.openCheckBox.isSelected();
    }

    public boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    public void prepareGedcom() {
        this.setReady(false);
        Map map = GeoPlacesList.getInstance((Gedcom)this.gedcom).getPlaces(true, this.okWhenDone(), this.cancelWhenDone());
        if (map == null) {
            this.readyCheckBox.setIcon(this.owner.ROTATING_ICON);
            return;
        }
        this.stMap = STFactory.buildSTMap(map, this.owner.getConsole());
        this.setReady(true);
    }

    private Callable okWhenDone() {
        Callable<Object> ret = () -> {
            Map map = GeoPlacesList.getInstance((Gedcom)this.gedcom).getPlaces(true, null, null);
            if (map != null) {
                this.stMap = STFactory.buildSTMap(map, this.owner.getConsole());
                this.setReady(true);
            } else {
                this.setReady(false);
            }
            this.updateInfo();
            return null;
        };
        return ret;
    }

    private Callable cancelWhenDone() {
        Callable<Object> ret = () -> {
            this.setReady(false);
            return null;
        };
        return ret;
    }

    public String[] getSummary(int length) {
        String[] ret = new String[length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = "-";
        }
        ret[0] = this.isPrivate() ? "1" : "0";
        ret[1] = "" + this.gedcom.getIndis().size();
        ret[2] = "" + this.gedcom.getFamilies().size();
        ret[3] = "" + this.stMap.keySet().size();
        ret[4] = "" + this.stMap.getEventNb();
        String[] keys = this.stMap.getTopSpaceKeys(Comm.COMM_NBST);
        for (int i = 0; i < keys.length; ++i) {
            ret[5 + i] = keys[i];
        }
        ret[5 + Comm.COMM_NBST] = "0";
        ret[5 + Comm.COMM_NBST + 1] = "0";
        ret[5 + Comm.COMM_NBST + 2] = "0";
        return ret;
    }

    public int getNbOfPublicIndis() {
        return this.nbIndis;
    }

    public int getNbOfPublicFams() {
        return this.nbFams;
    }

    public int getNbOfSTs() {
        return this.nbSTs;
    }

    public String[] getSTs() {
        String[] nulRet = new String[]{""};
        return this.stMap != null ? this.stMap.getTopSpaceKeys(Comm.COMM_NBST) : nulRet;
    }

    public void addConnection() {
        if (this.connections == 0) {
            this.startDate = new Date();
        }
        ++this.connections;
        this.endDate = new Date();
    }

    private void updateMe() {
        if (this.busyGedcom) {
            return;
        }
        this.busyGedcom = true;
        Timer timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Timer)e.getSource()).stop();
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        LocalGedcomFrame.this.updateInfo();
                        LocalGedcomFrame.this.busyGedcom = false;
                    }
                });
            }
        });
        timer.start();
    }

    private class GedcomChanged
    extends GedcomListenerAdapter {
        private GedcomChanged() {
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            LocalGedcomFrame.this.updateMe();
        }
    }
}

