/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import javafx.scene.web.WebView;
import org.netbeans.html.boot.fx.AbstractFXPresenter;
import org.netbeans.html.boot.fx.FXBrwsr;

public final class FXGCPresenter
extends AbstractFXPresenter {
    @Override
    void waitFinished() {
        FXBrwsr.waitFinished();
    }

    @Override
    WebView findView(URL resource) {
        return FXBrwsr.findWebView(resource, this);
    }

    @Override
    Object emitJavaObject(Object[] pojo, int hash, int id) {
        WeakReference<Object> ref = new WeakReference<Object>(pojo[0]);
        boolean nonNull = ref.get() != null;
        FXGCPresenter.assertGC(ref);
        Object r = ref.get();
        if (r == null && nonNull) {
            throw new NullPointerException("Value has been GCed to null for " + hash + " and " + id);
        }
        return r;
    }

    private static boolean isGone(Reference<?> ref) {
        return ref.get() == null;
    }

    private static void assertGC(Reference<Object> ref) {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 3; ++i) {
            if (FXGCPresenter.isGone(ref)) {
                return;
            }
            try {
                System.gc();
                System.runFinalization();
                continue;
            }
            catch (Error err) {
                LOG.log(Level.INFO, "Problems during GCing attempt of " + ref.get(), err);
            }
        }
        long took = System.currentTimeMillis() - l;
        LOG.log(Level.FINE, "Good: No GC of {1} for {0} ms.", new Object[]{took, ref.get()});
    }

    static {
        try {
            try {
                Class<?> clazz = Class.forName("javafx.application.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                File f = new File(System.getProperty("java.home"), "lib/jfxrt.jar");
                if (f.exists()) {
                    Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    m.setAccessible(true);
                    URL l = f.toURI().toURL();
                    m.invoke((Object)ClassLoader.getSystemClassLoader(), l);
                }
            }
        }
        catch (Exception ex) {
            throw new LinkageError("Can't add jfxrt.jar on the classpath", ex);
        }
    }
}

