/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.FamMatcher;
import ancestris.modules.gedcom.matchers.FamMatcherOptions;
import ancestris.modules.gedcom.matchers.IndiMatcher;
import ancestris.modules.gedcom.matchers.IndiMatcherOptions;
import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.MediaMatcher;
import ancestris.modules.gedcom.matchers.MediaMatcherOptions;
import ancestris.modules.gedcom.matchers.NoteMatcher;
import ancestris.modules.gedcom.matchers.NoteMatcherOptions;
import ancestris.modules.gedcom.matchers.PotentialMatch;
import ancestris.modules.gedcom.matchers.RepositoryMatcher;
import ancestris.modules.gedcom.matchers.RepositoryMatcherOptions;
import ancestris.modules.gedcom.matchers.SourceMatcher;
import ancestris.modules.gedcom.matchers.SourceMatcherOptions;
import ancestris.modules.gedcom.matchers.SubmitterMatcher;
import ancestris.modules.gedcom.matchers.SubmitterMatcherOptions;
import ancestris.modules.gedcom.searchduplicates.DuplicateResultCreator;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;

public class SearchDuplicatesPlugin
extends AncestrisPlugin
implements Runnable {
    private static final Logger LOG = Logger.getLogger(SearchDuplicatesPlugin.class.getName());
    private final Gedcom gedcom;
    private final TreeMap<String, EntityMatcher> entitiesMatchers = new TreeMap<String, EntityMatcher>(){
        {
            this.put("INDI", new IndiMatcher());
            this.put("FAM", new FamMatcher());
            this.put("NOTE", new NoteMatcher());
            this.put("SOUR", new SourceMatcher());
            this.put("REPO", new RepositoryMatcher());
            this.put("SUBM", new SubmitterMatcher());
            this.put("OBJE", new MediaMatcher());
        }
    };
    private final List<String> entities2Ckeck;
    private final Map<String, ? extends MatcherOptions> selectedOptions;
    private ProgressHandle progressHandle;

    public SearchDuplicatesPlugin() {
        this.gedcom = null;
        this.entities2Ckeck = null;
        this.selectedOptions = null;
    }

    public SearchDuplicatesPlugin(Gedcom leftGedcom, List<String> entities2Ckeck, Map<String, ? extends MatcherOptions> selectedOptions, ProgressHandle progressHandle) {
        this.gedcom = leftGedcom;
        this.entities2Ckeck = entities2Ckeck;
        this.selectedOptions = selectedOptions;
        this.progressHandle = progressHandle;
    }

    @Override
    public void run() {
        LinkedList<PotentialMatch<? extends Entity>> matchesLinkedList = new LinkedList<PotentialMatch<? extends Entity>>();
        HashMap<String, Integer> duplicatesHashMap = new HashMap<String, Integer>();
        if (this.gedcom == null) {
            return;
        }
        int num = 0;
        for (String tag : this.entities2Ckeck) {
            num += this.gedcom.getEntities(tag).size();
        }
        this.progressHandle.start();
        this.progressHandle.switchToDeterminate(num);
        try {
            num = 0;
            for (String tag : this.entities2Ckeck) {
                ArrayList entities = new ArrayList(this.gedcom.getEntities(tag));
                LOG.log(Level.FINE, "Checking: {0}", tag);
                switch (tag) {
                    case "INDI": {
                        this.entitiesMatchers.get(tag).setOptions((IndiMatcherOptions)this.selectedOptions.get("INDI"));
                        break;
                    }
                    case "FAM": {
                        this.entitiesMatchers.get(tag).setOptions((FamMatcherOptions)this.selectedOptions.get("FAM"));
                        break;
                    }
                    case "NOTE": {
                        this.entitiesMatchers.get(tag).setOptions((NoteMatcherOptions)this.selectedOptions.get("NOTE"));
                        break;
                    }
                    case "REPO": {
                        this.entitiesMatchers.get(tag).setOptions((RepositoryMatcherOptions)this.selectedOptions.get("REPO"));
                        break;
                    }
                    case "SOUR": {
                        this.entitiesMatchers.get(tag).setOptions((SourceMatcherOptions)this.selectedOptions.get("SOUR"));
                        break;
                    }
                    case "SUBM": {
                        this.entitiesMatchers.get(tag).setOptions((SubmitterMatcherOptions)this.selectedOptions.get("SUBM"));
                        break;
                    }
                    case "OBJE": {
                        this.entitiesMatchers.get(tag).setOptions((MediaMatcherOptions)this.selectedOptions.get("OBJE"));
                        break;
                    }
                }
                List potentialMatches = this.entitiesMatchers.get(tag).getPotentialMatches(entities, this.progressHandle, num);
                num += entities.size();
                for (PotentialMatch e : potentialMatches) {
                    String idRight;
                    String idLeft = ((Entity)e.getLeft()).getId();
                    if (idLeft.compareToIgnoreCase(idRight = ((Entity)e.getRight()).getId()) <= 0) continue;
                    e.swap();
                }
                matchesLinkedList.addAll(potentialMatches);
                duplicatesHashMap.put(tag, potentialMatches.size());
            }
            Collections.sort(matchesLinkedList, new Comparator<PotentialMatch<? extends Entity>>(){

                @Override
                public int compare(PotentialMatch<? extends Entity> e1, PotentialMatch<? extends Entity> e2) {
                    if (e2.getCertainty() - e1.getCertainty() != 0) {
                        return e2.getCertainty() - e1.getCertainty();
                    }
                    return e1.getLeft().toString(true).toLowerCase().compareTo(e2.getLeft().toString(true).toLowerCase());
                }
            });
            SwingUtilities.invokeLater(new DuplicateResultCreator(this.gedcom, matchesLinkedList));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.FINE, "the task was CANCELLED");
        }
    }
}

