/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.PathData;
import ancestris.util.TimingUtility;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.PropertyFile;
import genj.io.input.FileInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SearchLocalFilePanel
extends JPanel {
    private String currentPath = "";
    private PathData pd = null;
    private DefaultListModel<File> filesModel = null;
    private Set<String> filesNames = null;
    private DefaultListModel<String> pathsModel = null;
    private boolean isBusy = false;
    private JList filesList;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator2;
    private JTextField jTextField1;
    private JList pathsList;

    public SearchLocalFilePanel(PathData pd, String currentPath) {
        this.pd = pd;
        this.currentPath = currentPath;
        this.filesModel = new DefaultListModel();
        this.filesNames = new TreeSet<String>();
        this.pathsModel = new DefaultListModel();
        this.getFiles();
        this.initComponents();
        this.filesList.setCellRenderer(new FileCellRenderer());
        this.jTextField1.setText(currentPath);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                SearchLocalFilePanel.this.recalc();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.filesList = new JList();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.pathsList = new JList();
        this.jSeparator2 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel1.text"));
        this.jLabel2.setForeground(new Color(0, 102, 51));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel2.text"));
        this.jLabel3.setForeground(new Color(204, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel3.text"));
        this.filesList.setModel(this.filesModel);
        this.jScrollPane1.setViewportView(this.filesList);
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel4.text"));
        this.jTextField1.setEditable(false);
        this.jTextField1.setText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jTextField1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLocalFilePanel.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton2.text"));
        this.jButton2.setToolTipText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton2.toolTipText"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLocalFilePanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton3.text"));
        this.jButton3.setToolTipText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton3.toolTipText"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLocalFilePanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel5.text"));
        this.pathsList.setModel(this.pathsModel);
        this.pathsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchLocalFilePanel.this.pathsListMouseClicked(evt);
            }
        });
        this.pathsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SearchLocalFilePanel.this.pathsListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.pathsList);
        this.jLabel6.setForeground(new Color(204, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel7.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jButton2)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jTextField1).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jSeparator2).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel6))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 303, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jTextField1.setText(this.currentPath);
        this.recalc();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jTextField1.setText((String)this.pathsList.getSelectedValue());
        this.recalc();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        File file;
        String defaultDir = this.jTextField1.getText();
        if (defaultDir.isEmpty()) {
            defaultDir = System.getProperty("user.home");
        }
        if ((file = new FileChooserBuilder(SearchLocalFilePanel.class).setDirectoriesOnly(false).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"FileChooserButton")).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter(null).setAcceptAllFileFilterUsed(true).setFileHiding(true).setParent((Component)this).setDefaultPreviewer().setSelectedFile(new File(defaultDir)).setDefaultWorkingDirectory(new File(defaultDir)).showOpenDialog()) != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.jTextField1.setText(file.getAbsolutePath());
            this.recalc();
        }
    }

    private void pathsListValueChanged(ListSelectionEvent evt) {
        this.updateSelection();
    }

    private void pathsListMouseClicked(MouseEvent evt) {
        JList list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            this.jTextField1.setText((String)this.pathsList.getSelectedValue());
            this.recalc();
        }
    }

    private void getFiles() {
        this.filesModel.clear();
        for (PropertyFile file : this.pd.getFiles()) {
            String value;
            File f = null;
            f = file.getInput().isPresent() ? ((FileInput)file.getInput().get()).getFile() : ((value = file.getValue()).endsWith(File.separator) ? new File("") : new File(value));
            this.filesModel.addElement(f);
            this.filesNames.add(f.getName());
        }
    }

    private void updateSelection() {
        boolean selection = !this.pathsList.isSelectionEmpty();
        this.jButton2.setToolTipText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton2.toolTipText", (Object)(selection ? (String)this.pathsList.getSelectedValue() : "")));
        this.jButton2.setEnabled(selection);
    }

    public String getNewPath() {
        String path = this.jTextField1.getText();
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    private void recalc() {
        if (this.isBusy) {
            return;
        }
        this.isBusy = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        File dir = new File(this.jTextField1.getText());
        this.jLabel6.setVisible(!dir.exists());
        int total = this.filesModel.getSize();
        int found = 0;
        for (int i = 0; i < this.filesModel.getSize(); ++i) {
            File f = this.filesModel.get(i);
            found += this.testFound(f) ? 1 : 0;
        }
        int unfound = total - found;
        this.jLabel1.setText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel1.text", (Object)total));
        this.jLabel2.setText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel2.text", (Object)found));
        this.jLabel2.setVisible(found > 0);
        this.jLabel3.setText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel3.text", (Object)unfound));
        this.jLabel3.setVisible(unfound > 0);
        this.jScrollPane1.repaint();
        this.pathsModel.clear();
        Set<String> paths = this.findPaths(this.jTextField1.getText());
        for (String path : paths) {
            this.pathsModel.addElement(path);
        }
        this.pathsList.setModel(this.pathsModel);
        this.jButton1.setToolTipText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jButton1.toolTipText", (Object)this.currentPath));
        this.updateSelection();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.isBusy = false;
    }

    private boolean testFound(File fSource) {
        File fTested = new File(this.jTextField1.getText() + File.separator + fSource.getName());
        return fTested.isFile() && fTested.exists();
    }

    private Set<String> findPaths(String root) {
        TreeSet<String> ret = new TreeSet<String>();
        File dir = null;
        File currentDir = new File(root);
        Stack<File> dirs = new Stack<File>();
        dirs.push(currentDir);
        TimingUtility.getInstance().reset();
        int timeout = 5000;
        int time = 0;
        int nbDirs = 0;
        try {
            do {
                if ((dir = (File)dirs.pop()) == null || !dir.canRead() || dir.isHidden()) continue;
                ++nbDirs;
                for (File f : dir.listFiles()) {
                    if (f.isDirectory()) {
                        dirs.push(f);
                        continue;
                    }
                    for (String name : this.filesNames) {
                        if (!f.getName().equals(name)) continue;
                        ret.add(f.getParentFile().getCanonicalPath());
                    }
                }
                time = Integer.valueOf(TimingUtility.getInstance().getTime());
            } while (!dirs.isEmpty() && time < timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jLabel7.setText(NbBundle.getMessage(SearchLocalFilePanel.class, (String)"SearchLocalFilePanel.jLabel7.text", (Object)nbDirs));
        return ret;
    }

    private class FileCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private Color foreground_found = new Color(55, 107, 53);
        private Color foreground_unfound = new Color(200, 0, 0);

        public FileCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null || !(value instanceof File)) {
                return this;
            }
            if (!isSelected) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(list.getBackground());
            }
            File fSource = (File)value;
            this.setForeground(SearchLocalFilePanel.this.testFound(fSource) ? this.foreground_found : this.foreground_unfound);
            this.setText(fSource.getName());
            this.setIcon(null);
            return this;
        }
    }
}

