/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.modules.editors.LanguagesConstants;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyRole;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.values.MediaTypeEnum;
import genj.gedcom.values.RoleEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.openide.util.Exceptions;

public class GedcomSevenConverter {
    private static final String DOC_TAG = "https://docs.ancestris.org/books/user-guide/page/tags#bkmrk-ancestris-tags";
    private final Gedcom gedcom;
    private Exception error = null;
    Grammar fromGrammar = null;
    Grammar toGrammar = null;
    boolean isConvertible = false;
    boolean upgrade = false;
    boolean isMediaConvert = true;
    boolean isGedcom7 = false;
    private final List<Property> invalidPropsInvalidTags;
    private final List<Property> invalidPropsMultipleTags;
    private final Map<Property, String[]> invalidPropsMissingTags;

    public GedcomSevenConverter(Gedcom gedcom, Grammar fromGrammar, Grammar toGrammar, List<Property> invalidPropsInvalidTags, List<Property> invalidPropsMultipleTags, Map<Property, String[]> invalidPropsMissingTags) {
        this.gedcom = gedcom;
        this.fromGrammar = fromGrammar;
        this.toGrammar = toGrammar;
        this.invalidPropsInvalidTags = invalidPropsInvalidTags;
        this.invalidPropsMultipleTags = invalidPropsMultipleTags;
        this.invalidPropsMissingTags = invalidPropsMissingTags;
        if (Grammar.v70.equals(toGrammar)) {
            this.upgrade = true;
        }
    }

    public boolean convert() {
        if (this.upgrade) {
            this.upgrade();
        } else {
            this.downgrade();
        }
        this.getAnomalies(true);
        return true;
    }

    private void upgrade() {
        Entity header = this.gedcom.getFirstEntity("HEAD");
        this.addtagSchema("_DABOVILLE", header);
        this.addtagSchema("_SOSA", header);
        this.addtagSchema("_SOSADABOVILLE", header);
        this.addtagSchema(PrivacyPolicy.TAG_MARKING_PRIVATE, header);
        header.delProperties("FILE");
        header.delProperties("CHAR");
        header.delProperties("GEDC:FORM");
        Property langue = header.getProperty("LANG");
        langue.setValue(LanguagesConstants.getConvertedLanguage("5.5.1", langue.getValue()));
        this.gedcom.setLanguage(langue.getValue());
        try {
            this.adjustIdCharacters();
            this.changeNotes();
            this.changeSources();
            this.changeMedia();
            this.changeAsso();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void changeAsso() throws GedcomException {
        String rela = "";
        ArrayList assos = new ArrayList();
        assos.addAll(this.gedcom.getPropertiesByClass(PropertyAssociation.class));
        for (PropertyAssociation prop : assos) {
            Indi indiRela = (Indi)prop.getEntity();
            if (prop.getTarget() == null) continue;
            Property propCible = prop.getTarget().getParent();
            Property relaProp = prop.getProperty("RELA");
            boolean hasAnchor = false;
            if (relaProp != null) {
                rela = relaProp.getDisplayValue();
                boolean bl = hasAnchor = ((PropertyRelationship)relaProp).getAnchor() != null;
            }
            if (hasAnchor) {
                prop.getParent().delProperty((Property)prop);
                Property asso = propCible.addPropertyXref("ASSO", indiRela.getId(), -1);
                if (asso instanceof PropertyAssociation) {
                    ((PropertyAssociation)asso).link();
                }
                asso.addProperty("ROLE", rela);
                PropertyRole pRole = (PropertyRole)asso.getProperty("ROLE");
                this.adjustRole(pRole);
                continue;
            }
            prop.delProperty(relaProp);
            prop.addProperty("ROLE", rela);
            PropertyRole pRole = (PropertyRole)prop.getProperty("ROLE");
            this.adjustRole(pRole);
        }
    }

    private void adjustRole(PropertyRole pRole) {
        String currentValue = pRole.getValue();
        for (RoleEnum role : RoleEnum.values()) {
            if (!role.getDisplayValue().equals(currentValue)) continue;
            pRole.setValue(role.name());
            return;
        }
        pRole.setValue(RoleEnum.OTHER.name());
        pRole.addProperty("PHRASE", currentValue);
    }

    private void changeMedia() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        for (Entity ent : allEnts) {
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("OBJE"));
            for (Property p : allProps) {
                if (p instanceof PropertyMedia) continue;
                Media newMedia = (Media)this.gedcom.createEntity("OBJE");
                Property parent = p.getParent();
                for (Property child : p.getProperties()) {
                    GedcomUtilities.movePropertyRecursively((Property)child, (Property)newMedia);
                }
                parent.addMedia(newMedia);
                parent.delProperty(p);
            }
        }
        for (Entity ent : this.gedcom.getEntities("OBJE")) {
            Property pTitle;
            Property pFile = ent.getProperty("FILE");
            String fValue = pFile.getValue();
            pFile.setValue(this.adjustFileName(fValue));
            Property pForm = pFile.getProperty("FORM");
            pForm.setValue(this.getMimeType(pForm.getValue()));
            Property pMediaType = pForm.getProperty("MEDI");
            if (pMediaType != null) {
                this.adjustMediaType(pMediaType);
            }
            if ((pTitle = ent.getProperty("TITL")) == null) continue;
            for (PropertyForeignXRef fxref : ent.getProperties(PropertyForeignXRef.class)) {
                PropertyXRef pMedia = fxref.getTarget();
                pMedia.addProperty("TITL", pTitle.getValue());
            }
            ent.delProperty(pTitle);
        }
    }

    private String adjustFileName(String fValue) {
        String retour = fValue;
        if (retour.contains("://")) {
            return retour;
        }
        if (retour.startsWith("\\\\")) {
            return "file:" + this.escapePath(retour.replace('\\', '/'));
        }
        if (retour.matches("[A-Za-z]:\\\\.*")) {
            return "file:///" + retour.charAt(0) + ":/" + this.escapePath(retour.substring(3).replace('\\', '/'));
        }
        if (retour.startsWith("/")) {
            return "file://" + this.escapePath(retour);
        }
        return this.escapePath(retour.replace('\\', '/'));
    }

    private String escapePath(String url) {
        String retour = url;
        retour = retour.replace("%", "%25");
        retour = retour.replace(":", "%3A");
        retour = retour.replace("?", "%3F");
        retour = retour.replace("#", "%23");
        retour = retour.replace("[", "%5B");
        retour = retour.replace("]", "%5D");
        retour = retour.replace("@", "%40");
        return retour;
    }

    private void adjustMediaType(Property pMediaType) {
        String currentValue = pMediaType.getValue();
        for (MediaTypeEnum mediaType : MediaTypeEnum.values()) {
            if (!mediaType.getDisplayValue().equals(currentValue)) continue;
            pMediaType.setValue(mediaType.name());
            return;
        }
        pMediaType.setValue(MediaTypeEnum.OTHER.name());
        pMediaType.addProperty("PHRASE", currentValue);
    }

    private String getMimeType(String value) {
        try {
            MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
            for (MediaType mt : allTypes.getMediaTypeRegistry().getTypes()) {
                MimeType mit = allTypes.getRegisteredMimeType(mt.toString());
                if (!mit.getExtension().equals("." + value)) continue;
                return mit.getName();
            }
        }
        catch (MimeTypeException e) {
            return value;
        }
        return value;
    }

    private void changeSources() throws GedcomException {
        ArrayList allEnts = new ArrayList();
        allEnts.addAll(this.gedcom.getEntities());
        allEnts.remove(this.gedcom.getFirstEntity("HEAD"));
        for (Entity ent : allEnts) {
            ArrayList allProps = new ArrayList();
            allProps.addAll(ent.getAllProperties("SOUR"));
            for (Property p : allProps) {
                if (p instanceof PropertySource) continue;
                Source newSource = (Source)this.gedcom.createEntity("SOUR");
                Property parent = p.getParent();
                for (Property child : p.getProperties()) {
                    GedcomUtilities.movePropertyRecursively((Property)child, (Property)newSource);
                }
                Property text = newSource.getProperty("TEXT");
                if (text != null) {
                    text.setValue(p.getValue() + "\n" + text.getValue());
                } else {
                    newSource.addProperty("TEXT", p.getValue());
                }
                parent.addSource(newSource);
                parent.delProperty(p);
            }
        }
    }

    private void changeNotes() throws GedcomException {
        ArrayList notes = new ArrayList();
        notes.addAll(this.gedcom.getEntities("NOTE"));
        for (Note note : notes) {
            List refs = note.getProperties(PropertyForeignXRef.class);
            SNote snote = (SNote)this.gedcom.createEntity("SNOTE");
            GedcomUtilities.copyPropertiesRecursively((Property)note, (Property)snote, (boolean)true);
            for (PropertyForeignXRef pfxref : refs) {
                Entity e = pfxref.getTargetEntity();
                e.addSNote(snote);
            }
            this.gedcom.deleteEntity((Entity)note);
        }
    }

    private void addtagSchema(String tag, Entity header) {
        int nbTag = this.gedcom.getPropertyCount(tag);
        if (nbTag != 0) {
            Property schma = this.addScheme(header);
            schma.addProperty("TAG", tag + " " + DOC_TAG);
        }
    }

    private Property addScheme(Entity header) {
        Property[] schmas = header.getProperties("SCHMA");
        if (schmas.length == 0) {
            header.addProperty("SCHMA", null);
        }
        schmas = header.getProperties("SCHMA");
        return schmas[0];
    }

    private void adjustIdCharacters() throws GedcomException {
        Pattern pattern = Pattern.compile("^[0-9A-Z_]+$");
        Pattern unallowed = Pattern.compile("[^0-9A-Z_]");
        for (Entity ent : this.gedcom.getEntities()) {
            Matcher match;
            String id = ent.getId();
            if ("VOID".equals(id)) {
                ent.setId("_VOID");
            }
            if (!(match = pattern.matcher(id)).matches()) {
                ent.setId(unallowed.matcher(id.toUpperCase()).replaceAll("_"));
            }
            this.replaceUTags(ent);
            this.changeReferenceNumber(ent);
        }
    }

    private void changeReferenceNumber(Entity e) {
        Property exid;
        Property parent;
        ArrayList afnList = new ArrayList();
        afnList.addAll(e.getAllProperties("AFN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/AFN");
            parent.delProperty(p);
        }
        afnList.clear();
        afnList.addAll(e.getAllProperties("RIN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/RIN");
            parent.delProperty(p);
        }
        afnList.clear();
        afnList.addAll(e.getAllProperties("RFN"));
        for (Property p : afnList) {
            parent = p.getParent();
            exid = parent.addProperty("EXID", p.getValue());
            exid.addProperty("TYPE", "https://gedcom.io/terms/v7/RFN");
            parent.delProperty(p);
        }
    }

    private void replaceUTags(Entity e) {
        for (Property p : e.getAllProperties("_TIME")) {
            Property parent = p.getParent();
            Property date = parent.getProperty("DATE");
            date.addProperty("TIME", p.getValue());
            parent.delProperty(p);
        }
    }

    private void downgrade() {
        Entity header = this.gedcom.getFirstEntity("HEAD");
        Property[] schmas = header.getProperties("SCHMA");
        if (schmas.length != 0) {
            header.delProperties("SCHMA");
        }
        header.addProperty("FILE", this.gedcom.getName());
        header.addProperty("CHAR", "UTF-8");
        Property langue = header.getProperty("LANG");
        String[] value = langue.getValue().split("_");
        String convertedLanguage = LanguagesConstants.getConvertedLanguage("7.0.5", value[0]);
        if (!"".equals(convertedLanguage)) {
            langue.setValue(convertedLanguage);
            this.gedcom.setLanguage(langue.getValue());
        }
        try {
            this.removeSnote();
            this.downgradeMedia();
            this.downgradeAsso();
            this.adjustEntity();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void adjustEntity() {
        for (Entity e : this.gedcom.getEntities()) {
            for (Property p : e.getAllProperties("TIME")) {
                if (this.toGrammar.isValid(p.getPath())) continue;
                Property parent = p.getParent();
                parent.addProperty("_TIME", p.getValue());
                parent.delProperty(p);
            }
            ArrayList exidList = new ArrayList();
            exidList.addAll(e.getAllProperties("EXID"));
            for (Property p : exidList) {
                Property uExid;
                Property parent = p.getParent();
                Property type = p.getProperty("TYPE");
                if (type == null) {
                    uExid = parent.addProperty("_EXID", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/AFN")) {
                    parent.addProperty("AFN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/RIN")) {
                    parent.addProperty("RIN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                if (type.getValue().contains("https://gedcom.io/terms/v7/RFN")) {
                    parent.addProperty("RFN", p.getValue());
                    parent.delProperty(p);
                    continue;
                }
                uExid = parent.addProperty("_EXID", p.getValue());
                uExid.addProperty("_TYPE", type.getValue());
                parent.delProperty(p);
            }
        }
    }

    private void downgradeAsso() throws GedcomException {
        ArrayList assos = new ArrayList();
        assos.addAll(this.gedcom.getPropertiesByClass(PropertyAssociation.class));
        for (PropertyAssociation prop : assos) {
            Property parent;
            String roleValue = "";
            Property pRole = prop.getProperty("ROLE");
            if (pRole != null) {
                String value = pRole.getValue();
                RoleEnum rEnum = RoleEnum.valueOf((String)value);
                switch (rEnum) {
                    case OTHER: {
                        Property phrase = pRole.getProperty("PHRASE");
                        roleValue = phrase.getValue();
                        prop.addProperty("RELA", roleValue);
                        break;
                    }
                    default: {
                        roleValue = rEnum.getDisplayValue();
                        prop.addProperty("RELA", roleValue);
                    }
                }
                prop.delProperty(pRole);
            }
            if ((parent = prop.getParent()) instanceof Indi) continue;
            Property cible = prop.getTargetParent();
            TagPath anchor = parent.getPath(true);
            parent.delProperty((Property)prop);
            Property assoCible = cible.addPropertyXref("ASSO", parent.getEntity().getId(), -1);
            assoCible.addProperty("RELA", roleValue + " @#" + anchor.toString() + "@");
            if (!(assoCible instanceof PropertyAssociation)) continue;
            ((PropertyAssociation)assoCible).link();
        }
    }

    private void downgradeMedia() {
        block3: for (Entity ent : this.gedcom.getEntities("OBJE")) {
            Property pFile = ent.getProperty("FILE");
            pFile.setValue(this.downgradeFileName(pFile.getValue()));
            Property pForm = pFile.getProperty("FORM");
            pForm.setValue(this.getExtensionFromMType(pForm.getValue()));
            Property pMediaType = pForm.getProperty("MEDI");
            if (pMediaType == null) continue;
            String value = pMediaType.getValue();
            MediaTypeEnum mtEnum = MediaTypeEnum.valueOf((String)value);
            switch (mtEnum) {
                case OTHER: {
                    Property pPhrase = pMediaType.getProperty("PHRASE");
                    pMediaType.setValue(pPhrase.getValue());
                    continue block3;
                }
            }
            pMediaType.setValue(mtEnum.getDisplayValue());
        }
    }

    private String downgradeFileName(String fValue) {
        String retour = fValue;
        if (retour.contains("file:///")) {
            return this.unescapePath(retour.substring(8));
        }
        if (retour.contains("http://") || retour.contains("https://") || retour.contains("HTTP://") || retour.contains("HTTPS://")) {
            return retour;
        }
        return this.unescapePath(retour);
    }

    private String unescapePath(String url) {
        String retour = url;
        retour = retour.replace("%40", "@");
        retour = retour.replace("%5D", "]");
        retour = retour.replace("%5B", "[");
        retour = retour.replace("%23", "#");
        retour = retour.replace("%3F", "?");
        retour = retour.replace("%3A", ":");
        retour = retour.replace("%25", "%");
        return retour;
    }

    private void removeSnote() throws GedcomException {
        ArrayList notes = new ArrayList();
        notes.addAll(this.gedcom.getEntities("SNOTE"));
        for (SNote snote : notes) {
            List refs = snote.getProperties(PropertyForeignXRef.class);
            Note note = (Note)this.gedcom.createEntity("NOTE");
            GedcomUtilities.copyPropertiesRecursively((Property)snote, (Property)note, (boolean)true);
            for (PropertyForeignXRef pfxref : refs) {
                Entity e = pfxref.getTargetEntity();
                e.addNote(note);
            }
            this.gedcom.deleteEntity((Entity)snote);
        }
    }

    private String getExtensionFromMType(String value) {
        try {
            MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
            MimeType mit = allTypes.getRegisteredMimeType(value);
            String extension = mit.getExtension();
            return extension.substring(1);
        }
        catch (MimeTypeException e) {
            return "WEB";
        }
    }

    private void getAnomalies(boolean allowUndescore) {
        ArrayList<Property> listOfProperties = new ArrayList<Property>();
        List allEntities = this.gedcom.getEntities();
        for (Entity entity : allEntities) {
            if (entity.getTag().equals("HEAD")) continue;
            this.getPropertiesRecursively((Property)entity, listOfProperties);
        }
        this.invalidPropsInvalidTags.clear();
        this.invalidPropsMultipleTags.clear();
        this.invalidPropsMissingTags.clear();
        for (Property property : listOfProperties) {
            String[] missingTags;
            if (this.isInvalidTagPath(this.toGrammar, property, allowUndescore)) {
                this.invalidPropsInvalidTags.add(property);
            }
            if (this.isMultipleSingleton(this.toGrammar, property)) {
                this.invalidPropsMultipleTags.add(property);
            }
            if ((missingTags = this.getMissingKidTags(this.toGrammar, property)).length == 0) continue;
            this.invalidPropsMissingTags.put(property, missingTags);
        }
    }

    public void getPropertiesRecursively(Property parent, List<Property> props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            props.add(child);
            this.getPropertiesRecursively(child, props);
        }
    }

    private boolean isInvalidTagPath(Grammar toGrammar, Property property, boolean allowUndescore) {
        if (property instanceof PropertyXRef) {
            return false;
        }
        if (allowUndescore && property.getTag().startsWith("_")) {
            return false;
        }
        return !toGrammar.isValid(property.getPath());
    }

    private boolean isMultipleSingleton(Grammar toGrammar, Property property) {
        return toGrammar.getMeta(property.getPath()).isSingleton() && property.getParent().getProperties(property.getTag()).length > 1;
    }

    private String[] getMissingKidTags(Grammar toGrammar, Property parent) {
        MetaProperty[] metas;
        ArrayList<String> listOfTags = new ArrayList<String>();
        MetaProperty meta = toGrammar.getMeta(parent.getPath());
        for (MetaProperty metaChild : metas = meta.getNestedChildren()) {
            String tag = metaChild.getTag();
            if (!metaChild.isRequired() || parent.getProperty(tag) != null) continue;
            listOfTags.add(tag);
        }
        return listOfTags.toArray(new String[listOfTags.size()]);
    }
}

