/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.EntityChildren;
import ancestris.explorer.ExplorerNode;
import ancestris.explorer.GedcomEntities;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.awt.Image;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

class EntitiesNode
extends AbstractNode
implements ExplorerNode {
    private GedcomEntities entities;
    private Gedcom gedcom;

    public EntitiesNode(Gedcom gedcom, GedcomEntities entities) {
        super((Children)new EntityChildren(entities), Lookups.singleton((Object)entities));
        this.entities = entities;
        this.gedcom = gedcom;
        this.updateDisplay();
        this.setIconBaseWithExtension(entities.getImage().toString());
    }

    public Image getIcon(int type) {
        return this.entities.getImage();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean isContext) {
        return new Action[0];
    }

    @Override
    public Context getContext() {
        return this.gedcom == null ? null : new Context(this.gedcom);
    }

    public void updateDisplay() {
        this.setDisplayName(this.entities.getTitle());
    }
}

