/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.table;

import genj.util.Registry;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class EditorTable
extends JTable {
    private static final Logger LOGGER = Logger.getLogger(EditorTable.class.getName(), null);
    private Registry mRegistry = null;
    private String mTableId;

    public EditorTable() {
    }

    public EditorTable(TableModel dm) {
        super(dm);
    }

    public void setID(String tableId) {
        LOGGER.log(Level.FINE, "setID: {0}", tableId);
        this.mRegistry = Registry.get(EditorTable.class);
        this.mTableId = tableId;
        for (int index = 0; index < this.columnModel.getColumnCount(); ++index) {
            int columnSize = this.mRegistry.get(this.mTableId + ".column" + index + ".size", 100);
            this.columnModel.getColumn(index).setPreferredWidth(columnSize);
            LOGGER.log(Level.FINE, "setID: table id {0} column index {1} size {2}", new Object[]{tableId, index, columnSize});
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (this.getRowSorter() == null) {
            this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
            rowSorter = this.getRowSorter();
        }
        rowSorter.addRowSorterListener(new EditorTableRowSorterListener());
        this.getColumnModel().addColumnModelListener(new EditorTableTableColumnModelListener());
    }

    private class EditorTableRowSorterListener
    implements RowSorterListener {
        private EditorTableRowSorterListener() {
        }

        @Override
        public void sorterChanged(RowSorterEvent rse) {
            block3: {
                RowSorterEvent.Type type;
                block2: {
                    type = rse.getType();
                    if (!type.equals((Object)RowSorterEvent.Type.SORTED)) break block2;
                    List<RowSorter.SortKey> sortKeys = ((RowSorter)rse.getSource()).getSortKeys();
                    int index = 0;
                    for (RowSorter.SortKey key : sortKeys) {
                        EditorTable.this.mRegistry.put(EditorTable.this.mTableId + ".column" + key.getColumn() + ".sortIndex", index++);
                        EditorTable.this.mRegistry.put(EditorTable.this.mTableId + ".column" + key.getColumn() + ".sortOrder", key.getSortOrder().toString());
                        LOGGER.log(Level.INFO, "sorterChanged SORTED: index {0} order {1}", new Object[]{key.getColumn(), key.getSortOrder().toString()});
                    }
                    break block3;
                }
                if (!type.equals((Object)RowSorterEvent.Type.SORT_ORDER_CHANGED)) break block3;
                List<RowSorter.SortKey> sortKeys = ((RowSorter)rse.getSource()).getSortKeys();
                int index = 0;
                for (RowSorter.SortKey key : sortKeys) {
                    EditorTable.this.mRegistry.put(EditorTable.this.mTableId + ".column" + key.getColumn() + ".sortIndex", index++);
                    EditorTable.this.mRegistry.put(EditorTable.this.mTableId + ".column" + key.getColumn() + ".sortOrder", key.getSortOrder().toString());
                    LOGGER.log(Level.INFO, "sorterChanged SORT_ORDER_CHANGED: index {0} order {1}", new Object[]{key.getColumn(), key.getSortOrder().toString()});
                }
            }
        }
    }

    private class EditorTableTableColumnModelListener
    implements TableColumnModelListener {
        private EditorTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
            LOGGER.log(Level.FINE, "columnAdded: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
            LOGGER.log(Level.FINE, "columnRemoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMoved(TableColumnModelEvent tcme) {
            LOGGER.log(Level.FINE, "columnMoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            LOGGER.log(Level.FINE, "columnMarginChanged: {0}", ce.toString());
            for (int index = 0; index < EditorTable.this.columnModel.getColumnCount(); ++index) {
                int preferredWidth = EditorTable.this.columnModel.getColumn(index).getPreferredWidth();
                LOGGER.log(Level.FINE, "columnMarginChanged: table id {0} column index {1} size {2}", new Object[]{EditorTable.this.mTableId, index, preferredWidth});
                EditorTable.this.mRegistry.put(EditorTable.this.mTableId + ".column" + index + ".size", preferredWidth);
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }
}

