/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_a11y_HTMLLinkAccessible_h__
#define mozilla_a11y_HTMLLinkAccessible_h__

#include "HyperTextAccessibleWrap.h"

namespace mozilla {
namespace a11y {

class HTMLLinkAccessible : public HyperTextAccessibleWrap {
 public:
  HTMLLinkAccessible(nsIContent* aContent, DocAccessible* aDoc);

  NS_INLINE_DECL_REFCOUNTING_INHERITED(HTMLLinkAccessible,
                                       HyperTextAccessibleWrap)

  // LocalAccessible
  virtual void Value(nsString& aValue) const override;
  virtual a11y::role NativeRole() const override;
  virtual uint64_t NativeState() const override;
  virtual uint64_t NativeLinkState() const override;
  virtual uint64_t NativeInteractiveState() const override;

  // ActionAccessible
  virtual uint8_t ActionCount() const override;
  virtual void ActionNameAt(uint8_t aIndex, nsAString& aName) override;
  virtual bool DoAction(uint8_t aIndex) const override;

  // HyperLinkAccessible
  virtual bool IsLink() const override;
  virtual already_AddRefed<nsIURI> AnchorURIAt(
      uint32_t aAnchorIndex) const override;

  /**
   * Returns true if the link has href attribute.
   */
  bool IsLinked() const;

 protected:
  virtual ~HTMLLinkAccessible() {}

  enum { eAction_Jump = 0 };
};

inline HTMLLinkAccessible* LocalAccessible::AsHTMLLink() {
  return IsHTMLLink() ? static_cast<HTMLLinkAccessible*>(this) : nullptr;
}

}  // namespace a11y
}  // namespace mozilla

#endif
