##
# \file
#
# \author W T Schueller
#
# \brief The parser
#
# The parser returns a syntax tree as a list of nodes.
# A node is a list of two items: name and contents.
# The following nodes are supported:
# <TABLE>
# <TR><TD>\b Name   </TD><TD>\b contents        </TD><TD>\b Description                 </TD></TD>
# <TR><TD>script    </TD><TD>list_of_nodes      </TD><TD>Top level root node            </TD></TR>
# <TR><TD>command   </TD><TD>list_of_nodes      </TD><TD>A command                      </TD></TR>
# <TR><TD>word      </TD><TD>list_of_nodes      </TD><TD>A word or argument             </TD></TR>
# <TR><TD>comment   </TD><TD>string             </TD><TD>A comment                      </TD></TR>
# <TR><TD>cmdsep    </TD><TD>string             </TD><TD>A command separator            </TD></TR>
# <TR><TD>wordsep   </TD><TD>string             </TD><TD>A word separator               </TD></TR>
# <TR><TD>string    </TD><TD>string             </TD><TD>A string literal, may contain parenthesised index</TD></TR>
# <TR><TD>"string"  </TD><TD>string             </TD><TD>A quoted string                </TD></TR>
# <TR><TD>[script]  </TD><TD>list_of_nodes      </TD><TD>A script enclosed in brackets  </TD></TR>
# <TR><TD>{string}  </TD><TD>string             </TD><TD>A string enclosed in braces    </TD></TR>
# <TR><TD>{script}  </TD><TD>list_of_nodes      </TD><TD>A script enclosed in braces    </TD></TR>
# <TR><TD>{list}    </TD><TD>list_of_nodes      </TD><TD>A list enclosed in braces      </TD></TR>
# </TABLE>
#
namespace eval yy {

######
# Begin autogenerated taccle (version 1.1) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

proc YYABORT {} {
    return -code return 1
}

proc YYACCEPT {} {
    return -code return 0
}

proc yyclearin {} {
    upvar yytoken t
    set t ""
}

proc yyerror {s} {
    puts stderr $s
}

proc yysetupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc yyunsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set yytable {
  47:272,target 14
  6:260,target 15
  6:259,target 15
  33:261,target 24
  48:0 reduce
  26:257 reduce
  45:263,target 21
  15:257,target 1
  26:258 reduce
  26:259 reduce
  26:260 reduce
  26:261 reduce
  26:262 reduce
  1:258,target 9
  12:265,target 5
  26:263 reduce
  26:264 reduce
  27:259,target 36
  27:260,target 36
  26:265 reduce
  40:262,target 27
  39:262,target 6
  33:0,target 24
  36:269,target 12
  36:270,target 13
  22:258,target 2
  7:260,target 13
  7:259,target 13
  21:0 reduce
  34:261,target 25
  46:263,target 26
  16:257,target 4
  2:258,target 7
  13:265,target 10
  28:259,target 33
  28:260,target 33
  41:262,target 29
  32:257 reduce
  32:258 reduce
  32:259 reduce
  32:260 reduce
  32:261 reduce
  23:258,target 38
  32:262 reduce
  32:263 reduce
  32:264 reduce
  32:265 reduce
  8:260,target 4
  8:259,target 3
  35:261,target 22
  29:0,target 39
  30:0,target 40
  35:0 reduce
  47:263,target 7
  17:257,target 12
  3:258,target 8
  14:265,target 30
  29:259,target 39
  29:260,target 39
  30:259,target 40
  30:260,target 40
  0:266,target 9
  9:0 accept
  42:262,target 30
  38:270,target 13
  38:269,target 12
  24:258,target 37
  36:261,target 5
  37:257 reduce
  37:258 reduce
  48:263,target 31
  37:260 shift
  37:259 reduce
  18:257,target 17
  37:261 shift
  37:262 shift
  37:263 shift
  37:264 shift
  4:258,target 32
  15:265,target 31
  37:265 reduce
  31:259,target 16
  31:260,target 16
  26:0,target 35
  43:262,target 28
  39:270,target 13
  39:269,target 12
  10:264,target 8
  25:258,target 34
  37:261,target 41
  19:257,target 19
  20:257,target 20
  5:258,target 14
  16:265,target 4
  32:259,target 23
  32:260,target 23
  44:262,target 6
  43:257 reduce
  43:258 reduce
  43:260 reduce
  43:259 reduce
  43:261 reduce
  43:262 reduce
  0:257,target 1
  11:264,target 3
  43:263 reduce
  13:257 reduce
  26:258,target 35
  43:264 reduce
  13:258 reduce
  43:265 reduce
  13:259 reduce
  13:260 shift
  13:261 shift
  13:262 shift
  38:261,target 5
  13:263 shift
  2:257 reduce
  13:264 shift
  23:0,target 38
  2:258 reduce
  13:265 reduce
  8:267,target 15
  2:260 reduce
  2:259 reduce
  2:261 reduce
  2:262 reduce
  21:257,target 18
  2:263 reduce
  2:264 reduce
  2:265 reduce
  6:258,target 15
  17:265,target 12
  33:259,target 24
  33:260,target 24
  45:262,target 21
  1:257,target 9
  12:264,target 5
  27:258,target 36
  40:261,target 27
  39:261,target 5
  48:257 reduce
  48:258 reduce
  48:260 reduce
  48:259 reduce
  36:268,target 11
  48:261 reduce
  22:257,target 1
  48:262 reduce
  48:263 reduce
  18:257 reduce
  48:264 reduce
  18:258 reduce
  48:265 reduce
  7:258,target 13
  18:259 reduce
  18:260 reduce
  18:265,target 17
  18:261 reduce
  34:259,target 25
  34:260,target 25
  18:262 reduce
  18:263 reduce
  7:257 reduce
  18:264 reduce
  19:0,target 19
  20:0,target 20
  7:258 reduce
  18:265 reduce
  46:262,target 26
  7:260 reduce
  7:259 reduce
  7:261 reduce
  7:262 reduce
  7:263 reduce
  7:264 reduce
  2:257,target 7
  13:264,target 22
  7:265 reduce
  28:258,target 33
  10:272,target 14
  41:261,target 29
  23:257,target 38
  8:258,target 2
  19:265,target 19
  20:265,target 20
  35:259,target 22
  35:260,target 22
  23:0 reduce
  47:262,target 6
  5:0,target 14
  44:270,target 13
  44:269,target 12
  3:257,target 8
  14:264,target 29
  24:257 reduce
  24:258 reduce
  29:258,target 39
  30:258,target 40
  24:259 reduce
  24:260 reduce
  24:261 reduce
  24:262 reduce
  24:263 reduce
  42:261,target 30
  16:0,target 4
  24:264 reduce
  24:265 reduce
  38:268,target 16
  24:257,target 37
  21:265,target 18
  36:259,target 3
  36:260,target 4
  48:262,target 31
  37:0 reduce
  4:257,target 32
  15:264,target 8
  31:258,target 16
  1:265,target 9
  43:261,target 28
  2:0,target 7
  39:268,target 16
  10:263,target 7
  25:257,target 34
  29:257 reduce
  30:257 reduce
  29:258 reduce
  30:258 reduce
  29:259 reduce
  29:260 reduce
  30:259 reduce
  30:260 reduce
  29:261 reduce
  30:261 reduce
  37:260,target 40
  37:259,target 11
  29:262 reduce
  30:262 reduce
  29:263 reduce
  30:263 reduce
  13:0,target 10
  29:264 reduce
  30:264 reduce
  29:265 reduce
  30:265 reduce
  10:0 reduce
  5:257,target 14
  16:264,target 4
  32:258,target 23
  2:265,target 7
  44:261,target 5
  11:263,target 3
  26:257,target 35
  23:265,target 38
  38:260,target 4
  38:259,target 3
  24:0 reduce
  35:257 reduce
  47:270,target 13
  47:269,target 12
  6:257,target 15
  17:264,target 36
  35:258 reduce
  41:0,target 29
  33:258,target 24
  35:259 reduce
  35:260 reduce
  35:261 reduce
  35:262 reduce
  3:265,target 8
  35:263 reduce
  10:0,target 1
  35:264 reduce
  45:261,target 21
  35:265 reduce
  12:263,target 5
  27:257,target 36
  24:265,target 37
  40:260,target 27
  40:259,target 27
  39:260,target 4
  39:259,target 3
  36:267,target 39
  7:257,target 13
  18:264,target 17
  34:258,target 25
  4:265,target 32
  15:272,target 14
  46:261,target 26
  13:263,target 21
  41:257 reduce
  28:257,target 33
  41:258 reduce
  41:260 reduce
  41:259 reduce
  37:0,target 11
  41:261 reduce
  41:262 reduce
  25:265,target 34
  41:263 reduce
  41:260,target 29
  41:259,target 29
  11:257 reduce
  41:264 reduce
  11:258 reduce
  41:265 reduce
  11:259 reduce
  11:260 reduce
  11:261 reduce
  11:262 reduce
  11:263 reduce
  0:257 shift
  11:264 reduce
  0:258 shift
  11:265 reduce
  0:259 shift
  0:260 shift
  8:257,target 1
  0:261 shift
  19:264,target 19
  20:264,target 20
  0:262 shift
  11:0 reduce
  35:258,target 22
  0:263 shift
  0:264 shift
  5:265,target 14
  0:266 goto
  47:261,target 5
  0:267 goto
  0:268 goto
  0:269 goto
  0:270 goto
  44:268,target 11
  0:272 goto
  14:263,target 28
  29:257,target 39
  30:257,target 40
  0:264,target 8
  26:265,target 35
  42:260,target 30
  42:259,target 30
  46:257 reduce
  46:258 reduce
  46:260 reduce
  46:259 reduce
  21:264,target 18
  34:0,target 25
  46:261 reduce
  36:258,target 2
  46:262 reduce
  46:263 reduce
  16:257 reduce
  46:264 reduce
  6:265,target 15
  16:258 reduce
  46:265 reduce
  16:259 reduce
  16:260 reduce
  25:0 reduce
  48:261,target 31
  16:261 reduce
  16:262 reduce
  16:263 reduce
  5:257 reduce
  16:264 reduce
  5:258 reduce
  15:263,target 7
  16:265 reduce
  5:260 reduce
  5:259 reduce
  31:257,target 16
  5:261 reduce
  5:262 reduce
  5:263 reduce
  1:264,target 9
  0:0 reduce
  5:264 reduce
  27:265,target 36
  43:260,target 28
  43:259,target 28
  5:265 reduce
  10:262,target 6
  22:264,target 8
  37:258,target 11
  7:265,target 13
  40:0 reduce
  16:263,target 4
  32:257,target 23
  31:0,target 16
  2:264,target 7
  22:257 shift
  28:265,target 33
  44:260,target 4
  44:259,target 3
  22:258 shift
  22:259 shift
  22:260 shift
  22:261 shift
  22:262 shift
  11:262,target 3
  22:263 shift
  22:264 shift
  22:267 goto
  22:268 goto
  23:264,target 38
  38:258,target 2
  22:269 goto
  22:270 goto
  22:272 goto
  12:0 reduce
  47:268,target 16
  17:263,target 35
  33:257,target 24
  3:264,target 8
  29:265,target 39
  30:265,target 40
  45:260,target 21
  45:259,target 21
  0:272,target 14
  12:262,target 5
  27:0,target 36
  24:264,target 37
  40:258,target 27
  39:258,target 2
  27:257 reduce
  27:258 reduce
  27:259 reduce
  27:260 reduce
  27:261 reduce
  27:262 reduce
  27:263 reduce
  27:264 reduce
  27:265 reduce
  18:263,target 17
  26:0 reduce
  34:257,target 25
  4:264,target 32
  31:265,target 16
  46:260,target 26
  46:259,target 26
  1:0 reduce
  13:262,target 20
  10:269,target 12
  10:270,target 13
  25:264,target 34
  41:258,target 29
  22:272,target 14
  19:263,target 19
  20:263,target 20
  24:0,target 37
  35:257,target 22
  5:264,target 14
  33:257 reduce
  41:0 reduce
  32:265,target 23
  33:258 reduce
  47:260,target 4
  47:259,target 3
  33:259 reduce
  33:260 reduce
  33:261 reduce
  33:262 reduce
  33:263 reduce
  44:267,target 47
  14:262,target 27
  33:264 reduce
  33:265 reduce
  0:263,target 7
  26:264,target 35
  42:258,target 30
  21:263,target 18
  36:257,target 1
  9:0,target 0
  13:0 reduce
  6:264,target 15
  17:271,target 37
  33:265,target 24
  48:260,target 31
  48:259,target 31
  15:262,target 6
  21:0,target 18
  1:263,target 9
  27:264,target 36
  43:258,target 28
  38:257 shift
  38:258 shift
  38:260 shift
  38:259 shift
  38:261 shift
  38:262 shift
  10:261,target 5
  38:263 shift
  38:264 shift
  38:265 shift
  22:263,target 7
  38:268 goto
  37:257,target 11
  38:270 goto
  38:269 goto
  38:272 goto
  7:264,target 13
  34:265,target 25
  27:0 reduce
  16:262,target 4
  2:263,target 7
  6:0,target 15
  28:264,target 33
  44:258,target 2
  2:0 reduce
  11:261,target 3
  48:0,target 31
  17:0,target 12
  23:263,target 38
  38:257,target 1
  44:257 shift
  44:258 shift
  8:264,target 8
  44:260 shift
  44:259 shift
  35:265,target 22
  44:261 shift
  44:262 shift
  44:263 shift
  14:257 shift
  44:264 shift
  14:258 reduce
  14:259 shift
  14:260 shift
  17:262,target 34
  42:0 reduce
  14:261 shift
  44:267 goto
  14:262 shift
  44:268 goto
  14:263 shift
  44:270 goto
  44:269 goto
  3:263,target 8
  3:257 reduce
  14:264 shift
  3:258 reduce
  14:265 shift
  29:264,target 39
  30:264,target 40
  45:258,target 21
  44:272 goto
  3:260 reduce
  3:259 reduce
  3:261 reduce
  3:262 reduce
  3:263 reduce
  3:264 reduce
  12:261,target 5
  3:265 reduce
  24:263,target 37
  40:257,target 27
  39:257,target 1
  3:0,target 8
  45:0,target 21
  14:0 reduce
  18:262,target 17
  14:0,target 6
  4:263,target 32
  15:269,target 12
  15:270,target 13
  31:264,target 16
  46:258,target 26
  13:261,target 19
  19:257 reduce
  20:257 reduce
  19:258 reduce
  20:258 reduce
  19:259 reduce
  19:260 reduce
  20:259 reduce
  20:260 reduce
  19:261 reduce
  20:261 reduce
  10:268,target 16
  19:262 reduce
  20:262 reduce
  19:263 reduce
  20:263 reduce
  25:263,target 34
  41:257,target 29
  8:257 shift
  19:264 reduce
  20:264 reduce
  8:258 shift
  19:265 reduce
  20:265 reduce
  8:260 shift
  8:259 shift
  8:261 shift
  37:265,target 11
  8:262 shift
  8:263 shift
  8:264 shift
  8:267 goto
  19:262,target 19
  20:262,target 20
  8:268 goto
  8:270 goto
  8:269 goto
  28:0 reduce
  8:272 goto
  5:263,target 14
  0:0,target 2
  32:264,target 23
  47:258,target 2
  42:0,target 30
  14:261,target 26
  3:0 reduce
  0:262,target 6
  11:0,target 3
  26:263,target 35
  42:257,target 30
  38:265,target 45
  25:257 reduce
  8:272,target 14
  25:258 reduce
  25:259 reduce
  25:260 reduce
  21:262,target 18
  25:261 reduce
  25:262 reduce
  25:263 reduce
  25:264 reduce
  6:263,target 15
  25:265 reduce
  33:264,target 24
  48:258,target 31
  43:0 reduce
  15:261,target 5
  1:262,target 9
  27:263,target 36
  43:257,target 28
  40:265,target 27
  39:265,target 46
  10:259,target 3
  10:260,target 4
  22:262,target 6
  7:263,target 13
  34:264,target 25
  31:257 reduce
  16:261,target 4
  31:258 reduce
  31:259 reduce
  31:260 reduce
  31:261 reduce
  31:262 reduce
  2:262,target 7
  31:263 reduce
  28:263,target 33
  31:264 reduce
  44:257,target 1
  31:265 reduce
  41:265,target 29
  11:259,target 3
  11:260,target 3
  23:262,target 38
  8:263,target 7
  35:264,target 22
  29:0 reduce
  30:0 reduce
  35:0,target 22
  17:261,target 33
  3:262,target 8
  29:263,target 39
  30:263,target 40
  45:257,target 21
  4:0 reduce
  0:269,target 12
  0:270,target 13
  42:265,target 30
  12:259,target 5
  12:260,target 5
  36:257 shift
  36:258 shift
  36:259 shift
  36:260 shift
  36:261 shift
  24:262,target 37
  36:262 shift
  36:263 shift
  36:264 shift
  36:267 goto
  36:264,target 8
  36:268 goto
  36:269 goto
  36:270 goto
  36:272 goto
  18:261,target 17
  4:262,target 32
  15:268,target 16
  31:263,target 16
  46:257,target 26
  43:265,target 28
  13:259,target 10
  13:260,target 18
  32:0,target 23
  25:262,target 34
  22:269,target 12
  22:270,target 13
  37:264,target 44
  42:257 reduce
  42:258 reduce
  42:260 reduce
  42:259 reduce
  19:261,target 19
  20:261,target 20
  42:261 reduce
  16:0 reduce
  42:262 reduce
  42:263 reduce
  12:257 shift
  42:264 reduce
  5:262,target 14
  12:258 reduce
  42:265 reduce
  12:259 reduce
  12:260 reduce
  32:263,target 23
  47:257,target 1
  12:261 reduce
  12:262 reduce
  12:263 reduce
  1:257 reduce
  12:264 reduce
  1:258 reduce
  12:265 reduce
  14:260,target 25
  14:259,target 24
  1:259 reduce
  1:260 reduce
  1:261 reduce
  1:262 reduce
  0:261,target 5
  1:263 reduce
  1:264 reduce
  26:262,target 35
  1:265 reduce
  38:264,target 8
  28:0,target 33
  21:261,target 18
  6:262,target 15
  31:0 reduce
  33:263,target 24
  48:257,target 31
  47:257 shift
  45:265,target 21
  15:259,target 3
  15:260,target 4
  47:258 shift
  47:260 shift
  47:259 shift
  47:261 shift
  47:262 shift
  5:0 reduce
  1:261,target 9
  47:263 shift
  17:257 reduce
  27:262,target 36
  47:264 shift
  17:258 reduce
  47:265 shift
  17:259 reduce
  17:260 shift
  17:261 shift
  17:262 shift
  47:268 goto
  40:264,target 27
  39:264,target 8
  10:258,target 2
  17:263 shift
  47:270 goto
  47:269 goto
  6:257 reduce
  17:264 shift
  6:258 reduce
  17:265 reduce
  47:272 goto
  6:260 reduce
  6:259 reduce
  6:261 reduce
  36:272,target 14
  6:262 reduce
  22:261,target 5
  6:263 reduce
  6:264 reduce
  17:271 goto
  6:265 reduce
  7:262,target 13
  34:263,target 25
  45:0 reduce
  46:265,target 26
  16:259,target 4
  16:260,target 4
  25:0,target 34
  2:261,target 7
  28:262,target 33
  41:264,target 29
  11:258,target 3
  23:261,target 38
  23:257 reduce
  23:258 reduce
  8:262,target 6
  23:259 reduce
  23:260 reduce
  23:261 reduce
  35:263,target 22
  23:262 reduce
  17:0 reduce
  23:263 reduce
  23:264 reduce
  23:265 reduce
  47:265,target 48
  17:259,target 12
  17:260,target 32
  3:261,target 8
  29:262,target 39
  30:262,target 40
  0:268,target 11
  42:264,target 30
  12:258,target 5
  38:272,target 14
  24:261,target 37
  36:263,target 7
  48:265,target 31
  18:259,target 17
  18:260,target 17
  32:0 reduce
  4:261,target 32
  28:257 reduce
  28:258 reduce
  31:262,target 16
  28:259 reduce
  28:260 reduce
  28:261 reduce
  28:262 reduce
  28:263 reduce
  43:264,target 28
  6:0 reduce
  13:258,target 10
  28:264 reduce
  28:265 reduce
  39:272,target 14
  7:0,target 13
  25:261,target 34
  22:268,target 11
  37:263,target 43
  18:0,target 17
  19:259,target 19
  19:260,target 19
  20:259,target 20
  20:260,target 20
  5:261,target 14
  46:0 reduce
  32:262,target 23
  44:264,target 8
  14:258,target 6
  0:259,target 3
  0:260,target 4
  26:261,target 35
  34:257 reduce
  34:258 reduce
  34:259 reduce
  34:260 reduce
  34:261 reduce
  38:263,target 7
  34:262 reduce
  34:263 reduce
  34:264 reduce
  8:270,target 13
  8:269,target 12
  34:265 reduce
  21:259,target 18
  21:260,target 18
  4:0,target 32
  18:0 reduce
  6:261,target 15
  33:262,target 24
  46:0,target 26
  45:264,target 21
  15:258,target 2
  1:259,target 9
  1:260,target 9
  27:261,target 36
  40:263,target 27
  39:263,target 7
  10:257,target 1
  22:259,target 3
  22:260,target 4
  40:257 reduce
  39:257 shift
  40:258 reduce
  39:258 shift
  7:261,target 13
  40:260 reduce
  40:259 reduce
  39:260 shift
  39:259 shift
  34:262,target 25
  40:261 reduce
  39:261 shift
  40:262 reduce
  39:262 shift
  33:0 reduce
  40:263 reduce
  39:263 shift
  10:257 shift
  40:264 reduce
  39:264 shift
  10:258 shift
  46:264,target 26
  40:265 reduce
  39:265 shift
  10:259 shift
  10:260 shift
  16:258,target 4
  10:261 shift
  10:262 shift
  39:268 goto
  1:0,target 9
  10:263 shift
  39:270 goto
  39:269 goto
  2:260,target 7
  2:259,target 7
  10:264 shift
  28:261,target 33
  39:272 goto
  7:0 reduce
  10:268 goto
  43:0,target 28
  10:269 goto
  10:270 goto
  41:263,target 29
  11:257,target 3
  10:272 goto
  12:0,target 5
  23:259,target 38
  23:260,target 38
  8:261,target 5
  35:262,target 22
  47:264,target 8
  17:258,target 12
  44:272,target 14
  3:260,target 8
  3:259,target 8
  45:257 reduce
  29:261,target 39
  30:261,target 40
  45:258 reduce
  45:260 reduce
  45:259 reduce
  45:261 reduce
  0:267,target 10
  45:262 reduce
  45:263 reduce
  42:263,target 30
  12:257,target 17
  15:257 shift
  45:264 reduce
  15:258 shift
  45:265 reduce
  15:259 shift
  15:260 shift
  15:261 shift
  15:262 shift
  15:263 shift
  24:259,target 37
  24:260,target 37
  4:257 reduce
  15:264 shift
  4:258 reduce
  15:265 shift
  4:260 reduce
  4:259 reduce
  4:261 reduce
  4:262 reduce
  15:268 goto
  36:262,target 6
  40:0,target 27
  4:263 reduce
  15:269 goto
  15:270 goto
  4:264 reduce
  4:265 reduce
  15:272 goto
  19:0 reduce
  20:0 reduce
  48:264,target 31
  18:258,target 17
  4:260,target 32
  4:259,target 32
  31:261,target 16
  43:263,target 28
  13:257,target 10
  25:259,target 34
  25:260,target 34
  22:267,target 38
  37:262,target 42
  21:257 reduce
  21:258 reduce
  21:259 reduce
  21:260 reduce
  19:258,target 19
  20:258,target 20
  21:261 reduce
  21:262 reduce
  21:263 reduce
  21:264 reduce
  34:0 reduce
  5:260,target 14
  5:259,target 14
  21:265 reduce
  32:261,target 23
  44:263,target 7
  14:257,target 23
  0:258,target 2
  11:265,target 3
  26:259,target 35
  26:260,target 35
  38:262,target 6
  8:268,target 11
  21:258,target 18
}

array set yyrules {
  9,l 268
  11,l 269
  32,l 272
  6,l 268
  28,l 271
  3,l 267
  25,l 271
  0,l 273
  22,l 271
  18,l 270
  40,l 272
  39,l 272
  15,l 270
  36,l 272
  12,l 269
  33,l 272
  7,l 268
  29,l 271
  30,l 271
  4,l 267
  26,l 271
  1,l 266
  23,l 271
  19,l 270
  20,l 270
  16,l 270
  37,l 272
  13,l 270
  34,l 272
  8,l 268
  10,l 269
  31,l 271
  5,l 268
  27,l 271
  2,l 266
  24,l 271
  21,l 270
  17,l 270
  38,l 272
  14,l 270
  35,l 272
}

array set yyrules {
  12,dc 2
  26,dc 3
  3,dc 1
  18,dc 2
  33,dc 2
  9,dc 1
  11,dc 3
  25,dc 1
  2,dc 0
  40,dc 2
  39,dc 2
  17,dc 2
  32,dc 1
  8,dc 1
  10,dc 1
  24,dc 1
  1,dc 1
  38,dc 2
  16,dc 3
  31,dc 4
  7,dc 1
  23,dc 1
  0,dc 1
  37,dc 2
  15,dc 1
  29,dc 2
  30,dc 2
  6,dc 1
  22,dc 1
  36,dc 2
  14,dc 1
  28,dc 2
  5,dc 1
  21,dc 4
  35,dc 2
  13,dc 1
  27,dc 2
  4,dc 2
  19,dc 2
  20,dc 2
  34,dc 2
}

array set yyrules {
  7,line 83
  37,line 125
  4,line 75
  34,line 122
  1,line 68
  31,line 115
  27,line 111
  24,line 108
  21,line 103
  17,line 99
  14,line 96
  11,line 91
  9,line 85
  40,line 128
  39,line 127
  6,line 82
  36,line 124
  3,line 74
  33,line 121
  29,line 113
  30,line 114
  26,line 110
  23,line 107
  19,line 101
  20,line 102
  16,line 98
  13,line 95
  10,line 90
  8,line 84
  38,line 126
  5,line 81
  35,line 123
  2,line 69
  32,line 120
  28,line 112
  25,line 109
  22,line 106
  18,line 100
  15,line 97
  12,line 92
}

proc yyparse {} {
    set yystate_stack {0}
    set yyvalue_stack {{}}
    set yytoken ""
    set yyaccepted 0
    variable yylval
    variable yytable
    variable yyrules
    while {$yyaccepted == 0} {
        set yystate [lindex $yystate_stack end]
        if {$yytoken == ""} {
            set yylval ""
            set yytoken [yylex]
            set yybuflval $yylval
        }
        if {![info exists yytable($yystate:$yytoken)]} {
            # pop off states until error token accepted
            while {[llength $yystate_stack] > 0 && \
                       ![info exists yytable($yystate:error)]} {
                set yystate_stack [lrange $yystate_stack 0 end-1]
                set yyvalue_stack [lrange $yyvalue_stack 0 \
                                       [expr {[llength $yystate_stack] - 1}]]
                set yystate [lindex $yystate_stack end]
            }
            if {[llength $yystate_stack] == 0} {
                yyerror "parse error"
                return 1
            }
            lappend yystate_stack [set yystate $yytable($yystate:error,target)]
            lappend yyvalue_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists yytable($yystate:$yytoken)]} {
                if {$yytoken == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set ::yylval {}
                set yytoken [yylex]
                set yybuflval $::yylval
            }
            continue
        }
        switch -- $yytable($yystate:$yytoken) {
            shift {
                lappend yystate_stack $yytable($yystate:$yytoken,target)
                lappend yyvalue_stack $yybuflval
                set yytoken ""
            }
            reduce {
                set yyrule $yytable($yystate:$yytoken,target)
                set yyl $yyrules($yyrule,l)
                if {[info exists yyrules($yyrule,e)]} {
                    set yydc $yyrules($yyrule,e)
                } else {
                    set yydc $yyrules($yyrule,dc)
                }
                set yystackpointer [expr {[llength $yystate_stack]-$yydc}]
                yysetupvalues $yyvalue_stack $yystackpointer $yydc
                set _ $1
                set yylval [lindex $yyvalue_stack end]
                switch -- $yyrule {
                    1 {  return [ list "script" $1 ]  }
                    2 {  return [ list "script" [ list ] ]  }
                    3 {  set _ [ list $1 ]  }
                    4 {  lappend _ $2  }
                    5 {  set _ [ list "command" $1 ]  }
                    6 {  set _ [ list "comment" $1 ]  }
                    7 {  set _ [ list "cmdsep"  $1 ]  }
                    8 {  set _ [ list "cmdsep"  $1 ]  }
                    9 {  set _ [ list "cmdsep" $1 ]  }
                    10 {  set _ [ list [ list "word" $1 ] ]  }
                    11 {  lappend _ [ list "wordsep" $2 ] [ list "word" $3 ]  }
                    12 {  lappend _ [ list "wordsep" $2 ]  }
                    13 {  set _ [ list [ list "string" $1 ] ]  }
                    14 {  set _ [ list [ list "\"string\"" $1 ] ]  }
                    15 {  set _ [ list [ list "\{string\}" $1 ] ]  }
                    16 {  set _ [ list [ list "\[script\]" $2 ] ]  }
                    17 {  lappend _ [ list "string" $2 ]  }
                    18 {  lappend _ [ list "string" $2 ]  }
                    19 {  lappend _ [ list "\"string\"" $2 ]  }
                    20 {  lappend _ [ list "\{string\}" $2 ]  }
                    21 {  lappend _ [ list "\[script\]" $3 ]  }
                    22 {  set _ [ list [ list "string" $1 ] ]  }
                    23 {  set _ [ list [ list "string" $1 ] ]  }
                    24 {  set _ [ list [ list "\"string\"" $1 ] ]  }
                    25 {  set _ [ list [ list "\{string\}" $1 ] ]  }
                    26 {  set _ [ list [ list "\[script\]" $2 ] ]  }
                    27 {  lappend _ [ list "string" $2 ]  }
                    28 {  lappend _ [ list "string" $2 ]  }
                    29 {  lappend _ [ list "\"string\"" $2 ]  }
                    30 {  lappend _ [ list "\{string\}" $2 ]  }
                    31 {  lappend _ [ list "\[script\]" $3 ]  }
                    32 {  set _ $1  }
                    33 {  append _ $2  }
                    34 {  append _ $2  }
                    35 {  append _ $2  }
                    36 {  append _ $2  }
                    37 {  append _ $2  }
                    38 {  append _ $2  }
                    39 {  append _ $2  }
                    40 {  append _ $2  }
                }
                yyunsetupvalues $yydc
                # pop off tokens from the stack if normal rule
                if {![info exists yyrules($yyrule,e)]} {
                    incr yystackpointer -1
                    set yystate_stack [lrange $yystate_stack 0 $yystackpointer]
                    set yyvalue_stack [lrange $yyvalue_stack 0 $yystackpointer]
                }
                # now do the goto transition
                lappend yystate_stack $yytable([lindex $yystate_stack end]:$yyl,target)
                lappend yyvalue_stack $_
            }
            accept {
                set yyaccepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $yytable($yystate:$yytoken)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

# \brief error procedure
#
# \param msg error message
#
proc yyerror { msg } {
    variable yylineno
    variable yytext
    error "Error: $msg at line $yylineno: $yytext"
}
##
# \brief Parser wrapper, includes refine pass
#
# \param string string to parse
#
# \return list of nodes
#
proc parse { string } {
    return [ refine [ parsepass $string ] ]
}
##
# \brief Parser wrapper, single pass
#
# \param string string to parse
#
# \return list of nodes
#
proc parsepass { string } {
    reset $string
    set r [ catch { yyparse } nodes ]
    if { $r != 0 } then {
        puts stderr $nodes
        set nodes [ list "string" $string ]
    }
    return $nodes
}
##
# \brief generate tcl code from syntax tree
#
# Debug function. Should produce the original input.
#
# \param tree syntax tree (see \ref parser.tcl)
#
# \return output string
#
proc deparse { tree } {
    set r ""
    switch -exact -- [ lindex $tree 0 ] {
        "script" -
        "command" -
        "word" {
            foreach i [ lindex $tree 1 ] {
                append r [ deparse $i ]
            }
        }
        "\{list\}" -
        "\{script\}" -
        "\[script\]" {
            append r [ string index [ lindex $tree 0 ] 0 ]
            foreach i [ lindex $tree 1 ] {
                append r [ deparse $i ]
            }
            append r [ string index [ lindex $tree 0 ] end ]
        }
        "\{script\}" {
            append r "\{"
            foreach i [ lindex $tree 1 ] {
                append r [ deparse $i ]
            }
            append r "\}"
        }
        default {
            append r [ lindex $tree 1 ]
        }
    }
    return $r
}
##
# \brief reparse the portions of the tree that are tcl scripts
#
# This function handles the recursion into the parser.
#
# \param tree syntax tree (see \ref parser.tcl)
#
# \return refined syntax tree
#
proc refine { tree } {
    #
    # shortcuts
    set nodes [ lindex $tree 1 ]
    #
    switch -exact -- [ lindex $tree 0 ] {
        "script" -
        "\[script\]" {
            set r [ list ]
            foreach i $nodes {
                lappend r [ refine $i ]
            }
            set r [ list [ lindex $tree 0 ] $r ]
        }
        "command" {
            set nnodes [ llength $nodes ]
            #
            # trailing white space
            for { set i 0 } { $i < $nnodes } { incr i } {
                set t [ lindex $nodes $i 0 ]
                if { $t ne "wordsep" && $t ne "cmdsep" } then {
                    break
                }
            }
            # the switch selects according to the first two words
            # and the total number of non separator words
            # also, we need the index of the last argument later
            # note: there may be a word separator at the end
            set c 0
            set li $i
            for { set j $i } { $j < $nnodes } { incr j } {
                set t [ lindex $nodes $j 0 ]
                if { $t ne "wordsep" && $t ne "cmdsep" } then {
                    incr c
                    set li $j
                }
            }
            set w1 [ deparse [ lindex $nodes $i ] ]
            set w2 [ deparse [ lindex $nodes [ expr { $i + 2 } ] ] ]
            #
            # the following switch should consider only the very first word
            regexp {([a-z]+)} $w1 dummy w1
            regexp {([a-z]+)} $w2 dummy w2
            #
            # start with the original tree
            set r $tree
            switch -glob -- "$c $w1 $w2" {
                "4 namespace eval" -
                "* foreach *" -
                "3 while *" -
                "4 proc *" {
                    lset r 1 $li [ refine [ lindex $tree 1 $li ] ]
                }
                "5 for *" {
                    incr i 2
                    lset r 1 $i [ refine [ lindex $tree 1 $i ] ]
                    incr i 4
                    lset r 1 $i [ refine [ lindex $tree 1 $i ] ]
                    incr i 2
                    lset r 1 $i [ refine [ lindex $tree 1 $i ] ]
                }
                "* if *" {
                    incr i 2
                    # a flag indicates, if the next argument is an expression or a script 
                    set expression 1
                    for { } { $i < $nnodes } { incr i } {
                        if { [ lindex $nodes $i 0 ] eq "wordsep" } then {
                            continue
                        }
                        switch -exact -- [ deparse [ lindex $nodes $i ] ] {
                            "then" {
                                set expression 0
                            }
                            "else" {
                                set expression 0
                            }
                            "elseif" {
                                set expression 1
                            }
                            default {
                                if { !$expression } then {
                                    lset r 1 $i [ refine [ lindex $tree 1 $i ] ]
                                } else {
                                    set expression 0
                                }
                            }
                        }
                    }
                }
                "* switch *" {
                    ##
                    # \todo
                    # We support only the form: 
                    # <br><tt>switch ?options? string {pattern body ?pattern body ...?}</tt><br>
                    # not the form:
                    # <br><tt>switch ?options? string pattern body ?pattern body ...?</tt>.<br>
                    # The latter is difficult because we don't know for sure what argument is and
                    # option an which one is string/pattern/body. Suppose somebody does something
                    # like <br><tt>switch $option1 $option2 $switchvalue pattern body pattern body ...</tt>
                    #
                    set body [ deparse [ lindex $tree 1 $li ] ]
                    if { [ string index $body 0 ] eq "\{" } then {
                        set body [ string range $body 1 end-1 ]
                        #
                        # to preserve the original whitespaces we
                        # parse the body again and again to produce
                        # a list of patterns, scripts and word separators
                        #
                        set l [ list ]
                        while { [ string length $body ] > 0 } {
                            #
                            # the pattern may start with a hash, the dummy prefix
                            # ensures correct interpretation as an argument
                            #
                            set t [ parsepass "dummy $body" ]
                            if { [ lindex $t 0 ] ne "script" } then {
                                #
                                # something wrong, parse failed
                                set l [ list ]
                                break
                            }
                            if { [ llength [ lindex $t 1 0 1 ] ] == 1 } then {
                                lappend l [ list "wordsep" [ string range [ lindex $t 1 1 1 ] 1 end ] ]
                                lset t 1 [ lrange [ lindex $t 1 ] 2 end ]
                            } else {
                                set l [ concat $l [ lrange [ lindex $t 1 0 1 ] 2 end ] ]
                                lset t 1 [ lrange [ lindex $t 1 ] 1 end ]
                            }
                            set body [ deparse $t ]
                        }
                        # now we are ready to parse every second argument as a script
                        #
                        set ispattern 1
                        for { set j 0 } { $j < [ llength $l ] } { incr j } {
                            if { [ lindex $l $j 0 ] eq "wordsep" } then {
                                continue
                            }
                            if { $ispattern } then {
                                set ispattern 0
                                lset l $j [ list "string" [ deparse [ lindex $l $j ] ] ]
                            } else {
                                lset l $j [ refine [ lindex $l $j ] ]
                                set ispattern 1
                            }
                        }
                        if { [ llength $l ] > 0 } then {
                            lset r 1 $li [ list "\{list\}" $l ]
                        }
                    }
                }
                default {
                }
            }
        }
        "word" {
            # if we get here then because of we want to reparse an argument
            # the usual procedure does not dig into commands, only in case
            # of well known script arguments
            set body [ deparse $tree ]
            switch -exact -- [ string index $body 0 ] {
                "\[" -
                "\"" {
                    set r $tree
                }
                "\{" {
                    set t [ parse [ string range $body 1 end-1 ] ]
                    if { [ lindex $t 0 ] eq "script" } then {
                        set r [ list "\{script\}" [ lindex $t 1 ] ]
                    } else {
                        set r $tree
                    }
                }
                default {
                    set t [ parse $body ]
                    if { [ lindex $t 0 ] eq "script" } then {
                        set r $t
                    } else {
                        set r $tree
                    }
                }
            }
        }
        default {
            set r $tree
        }
    }
    return $r
}
# end of namespace eval yy
}
