/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.plugin.tx;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.plugin.tx.AopMode;
import org.springframework.config.java.plugin.tx.GeneralizedAopNamespaceUtils;
import org.springframework.config.java.plugin.tx.TxAnnotationDrivenDeclaration;
import org.springframework.config.java.plugin.tx.TxNamespaceUtils;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class GeneralizedAnnotationDrivenBeanDefinitionParser {
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    public static final String TRANSACTION_ADVISOR_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAdvisor";
    public static final String TRANSACTION_ASPECT_BEAN_NAME = "org.springframework.transaction.config.internalTransactionAspect";
    private static final String TRANSACTION_ASPECT_CLASS_NAME = "org.springframework.transaction.aspectj.AnnotationTransactionAspect";

    public BeanDefinition parseDeclaration(TxAnnotationDrivenDeclaration txDec, BeanDefinitionRegistry registry) {
        if (txDec.mode == AopMode.ASPECTJ) {
            this.registerTransactionAspect(txDec, registry);
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(txDec, registry);
        }
        return null;
    }

    private void registerTransactionAspect(TxAnnotationDrivenDeclaration txDec, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(TRANSACTION_ASPECT_BEAN_NAME)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(TRANSACTION_ASPECT_CLASS_NAME);
            def.setFactoryMethodName("aspectOf");
            GeneralizedAnnotationDrivenBeanDefinitionParser.registerTransactionManager(txDec, (BeanDefinition)def);
            registry.registerBeanDefinition(TRANSACTION_ASPECT_BEAN_NAME, (BeanDefinition)def);
        }
    }

    private static void registerTransactionManager(TxAnnotationDrivenDeclaration txDec, BeanDefinition def) {
        def.getPropertyValues().addPropertyValue(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, (Object)new RuntimeBeanReference(txDec.transactionManagerName));
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(TxAnnotationDrivenDeclaration txDec, BeanDefinitionRegistry registry) {
            GeneralizedAopNamespaceUtils.registerAutoProxyCreatorIfNecessary(registry, txDec);
            if (!registry.containsBeanDefinition(GeneralizedAnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME)) {
                RootBeanDefinition interceptorDef = new RootBeanDefinition(TransactionInterceptor.class);
                interceptorDef.setRole(2);
                GeneralizedAnnotationDrivenBeanDefinitionParser.registerTransactionManager(txDec, (BeanDefinition)interceptorDef);
                Class<?> sourceClass = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
                interceptorDef.getPropertyValues().addPropertyValue("transactionAttributeSource", (Object)new RootBeanDefinition(sourceClass));
                RootBeanDefinition advisorDef = new RootBeanDefinition(TransactionAttributeSourceAdvisor.class);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().addPropertyValue("transactionInterceptor", (Object)interceptorDef);
                if (txDec.isExplicitlyOrdered()) {
                    advisorDef.getPropertyValues().addPropertyValue("order", txDec.getOrder());
                }
                registry.registerBeanDefinition(GeneralizedAnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME, (BeanDefinition)advisorDef);
            }
        }
    }
}

