/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.lang.reflect.Field;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotation;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationArrayVisitor;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationUtils;
import org.springframework.util.ClassUtils;

class MutableAnnotationVisitor
implements AnnotationVisitor {
    protected final MutableAnnotation mutableAnno;

    public MutableAnnotationVisitor(MutableAnnotation mutableAnno) {
        this.mutableAnno = mutableAnno;
    }

    public AnnotationVisitor visitArray(String attribName) {
        return new MutableAnnotationArrayVisitor(this.mutableAnno, attribName);
    }

    public void visit(String attribName, Object attribValue) {
        Class<?> attribReturnType = this.mutableAnno.getAttributeType(attribName);
        if (attribReturnType.equals(Class.class)) {
            try {
                Class<?> classVal = ClassUtils.getDefaultClassLoader().loadClass(((Type)attribValue).getClassName());
                this.mutableAnno.setAttributeValue(attribName, classVal);
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.mutableAnno.setAttributeValue(attribName, attribValue);
    }

    public void visitEnum(String attribName, String enumTypeDescriptor, String strEnumValue) {
        Class<?> enumClass;
        String enumClassName = AsmUtils.convertTypeDescriptorToClassName(enumTypeDescriptor);
        try {
            enumClass = ClassUtils.getDefaultClassLoader().loadClass(enumClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Object enumValue = Enum.valueOf(enumClass, strEnumValue);
        this.mutableAnno.setAttributeValue(attribName, enumValue);
    }

    public AnnotationVisitor visitAnnotation(String attribName, String attribAnnoTypeDescriptor) {
        try {
            String annoTypeName = AsmUtils.convertTypeDescriptorToClassName(attribAnnoTypeDescriptor);
            Class<?> annoType = ClassUtils.getDefaultClassLoader().loadClass(annoTypeName);
            Object annoValue = MutableAnnotationUtils.createMutableAnnotation(annoType);
            Field annoAttrib = this.mutableAnno.getClass().getField(attribName);
            annoAttrib.set(this.mutableAnno, annoValue);
            return new MutableAnnotationVisitor((MutableAnnotation)annoValue);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void visitEnd() {
    }
}

