/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.util.ClassUtils;

public class AsmUtils {
    public static final EmptyVisitor EMPTY_VISITOR = new EmptyVisitor();
    private static final Log log = LogFactory.getLog(AsmUtils.class);

    public static String convertClassNameToInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String convertTypeDescriptorToClassName(String typeDescriptor) {
        String internalName = typeDescriptor.startsWith("[[") ? typeDescriptor.substring(3) : (typeDescriptor.startsWith("[") ? typeDescriptor.substring(2) : typeDescriptor.substring(1));
        String className = internalName.replace('/', '.');
        if (className.endsWith(";")) {
            className = className.substring(0, internalName.length() - 1);
        }
        return className;
    }

    public static String getReturnTypeFromMethodDescriptor(String methodDescriptor) {
        String returnTypeDescriptor = methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
        return AsmUtils.convertTypeDescriptorToClassName(returnTypeDescriptor);
    }

    public static InputStream getClassAsStream(String pathToClass) {
        String classFileName = String.valueOf(pathToClass) + ".class";
        InputStream is = ClassUtils.getDefaultClassLoader().getResourceAsStream(classFileName);
        if (is == null) {
            throw new RuntimeException(new FileNotFoundException("Class file [" + classFileName + "] not found"));
        }
        return is;
    }

    public static ClassReader newClassReader(String pathToClass) {
        InputStream is = AsmUtils.getClassAsStream(pathToClass);
        return AsmUtils.newClassReader(is);
    }

    public static ClassReader newClassReader(byte[] bytes) {
        return new ClassReader(bytes);
    }

    public static ClassReader newClassReader(InputStream is) {
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        catch (IOException ex) {
            throw new RuntimeException("An unexpected exception occurred while creating ASM ClassReader: " + ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                log.error((Object)"Ignoring exception thrown while closing InputStream", (Throwable)ex);
            }
        }
    }
}

