/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.context;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.ClassPathScanningConfigurationProvider;
import org.springframework.config.java.context.ConfigurableJavaConfigApplicationContext;
import org.springframework.config.java.context.DefaultBeanFactoryProvider;
import org.springframework.config.java.internal.factory.TypeSafeBeanFactoryUtils;
import org.springframework.config.java.internal.process.InternalConfigurationPostProcessor;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext
implements ConfigurableJavaConfigApplicationContext {
    private Log log = LogFactory.getLog(this.getClass());
    private final ClassPathScanningConfigurationProvider scanner = new ClassPathScanningConfigurationProvider((ResourceLoader)this);
    private ArrayList<Class<?>> configClasses = new ArrayList();
    private ArrayList<String> basePackages = new ArrayList();

    protected void prepareRefresh() {
        super.prepareRefresh();
        this.initConfigLocations();
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        InternalConfigurationPostProcessor bfpp = new InternalConfigurationPostProcessor((AbstractApplicationContext)this, null, new DefaultBeanFactoryProvider());
        bfpp.postProcessBeanFactory(beanFactory);
        super.invokeBeanFactoryPostProcessors(beanFactory);
    }

    protected void initConfigLocations() {
        Assert.notEmpty((Object[])this.getConfigLocations(), (String)"Zero configLocations present. Was the 'contextConfigLocations' context-param set properly in web.xml?");
        this.log.trace((Object)("JavaConfigWebApplicationContext.initConfigLocations(): number of locations: " + this.getConfigLocations().length));
        String[] stringArray = this.getConfigLocations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.log.trace((Object)("JavaConfigWebApplicationContext.initConfigLocations(): now initializing location: " + location));
            try {
                Class<?> cz = ClassUtils.getDefaultClassLoader().loadClass(location);
                if (cz.isAnnotationPresent(Configuration.class)) {
                    this.configClasses.add(cz);
                } else {
                    String message = "[%s] is not a valid configuration class. Perhaps you forgot to annotate your bean creation methods with @Bean?";
                    this.log.warn((Object)String.format(message, cz));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.info((Object)String.format("location [%s] does not appear to be a class.  Adding to list of base packages to scan.", location));
                this.basePackages.add(location);
            }
            ++n2;
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException, BeansException {
        for (Class<?> configClass : this.configClasses) {
            this.loadBeanDefinitionForConfigurationClass(beanFactory, configClass);
        }
        for (String basePackage : this.basePackages) {
            this.loadBeanDefinitionsForBasePackage(beanFactory, basePackage);
        }
    }

    private void loadBeanDefinitionForConfigurationClass(DefaultListableBeanFactory beanFactory, Class<?> configClass) {
        String configBeanName = configClass.getName();
        RootBeanDefinition configBeanDef = new RootBeanDefinition();
        configBeanDef.setBeanClassName(configBeanName);
        configBeanDef.addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
        beanFactory.registerBeanDefinition(configBeanName, (BeanDefinition)configBeanDef);
    }

    private void loadBeanDefinitionsForBasePackage(DefaultListableBeanFactory beanFactory, String basePackage) {
        for (BeanDefinition beanDef : this.scanner.findCandidateComponents(basePackage)) {
            String configBeanName = beanDef.getBeanClassName();
            ((AbstractBeanDefinition)beanDef).addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
            beanFactory.registerBeanDefinition(configBeanName, beanDef);
        }
    }

    @Override
    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type);
    }

    @Override
    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type, beanName);
    }

    @Override
    public void addConfigClass(Class<?> cls) {
        String[] configLocations = this.getConfigLocations();
        int nLocations = configLocations == null ? 0 : configLocations.length;
        String[] newConfigLocations = new String[nLocations + 1];
        int i = 0;
        while (i < nLocations) {
            newConfigLocations[i] = configLocations[i];
            ++i;
        }
        newConfigLocations[newConfigLocations.length - 1] = cls.getName();
        this.setConfigLocations(newConfigLocations);
    }

    @Override
    public void addBasePackage(String basePackage) {
        throw new UnsupportedOperationException();
    }
}

