/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.where;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.filters.where.PropertyResolverAdapter;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class PropertyResolverHelper {
    private final List<PropertyResolverAdapter> propertyResolverAdapters = new ArrayList<PropertyResolverAdapter>();
    public static PropertyResolverHelper INSTANCE = new PropertyResolverHelper();

    private PropertyResolverHelper() {
    }

    public void add(PropertyResolverAdapter one) {
        this.propertyResolverAdapters.add(one);
    }

    public PropertyResolverAdapter findFor(Object target) {
        for (PropertyResolverAdapter e : this.propertyResolverAdapters) {
            if (!e.support(target)) continue;
            return e;
        }
        return null;
    }

    static {
        INSTANCE.add(new PropertyResolverAdapter(){
            private final LValue lValue = new LValue(){};

            @Override
            public Object getItemProperty(TemplateContext context, Object input, Object property) {
                LiquidSupport evaluated = context.renderSettings.evaluate(context.parseSettings.mapper, input);
                return evaluated.toLiquid().get(this.lValue.asString(property, context));
            }

            @Override
            public boolean support(Object target) {
                return target instanceof Inspectable;
            }
        });
        INSTANCE.add(new PropertyResolverAdapter(){

            @Override
            public Object getItemProperty(TemplateContext context, Object input, Object property) {
                return ((Map)input).get(property);
            }

            @Override
            public boolean support(Object target) {
                return target instanceof Map;
            }
        });
    }
}

