/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.html.Disposable;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashMap;

public class HeaderIdGenerator
implements HtmlIdGenerator,
Disposable {
    HashMap<String, Integer> headerBaseIds = new HashMap();
    boolean resolveDupes;
    String toDashChars;
    String nonDashChars;
    boolean noDupedDashes;
    boolean nonAsciiToLowercase;

    @Override
    public void dispose() {
        this.headerBaseIds = null;
    }

    @Override
    public void generateIds(Document document) {
        this.resolveDupes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.getFrom((DataHolder)document);
        this.toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom((DataHolder)document);
        this.nonDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.getFrom((DataHolder)document);
        this.noDupedDashes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.getFrom((DataHolder)document);
        this.nonAsciiToLowercase = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE.getFrom((DataHolder)document);
        new AnchorRefTargetBlockVisitor(){

            @Override
            protected void visit(AnchorRefTarget node) {
                if (node.getAnchorRefId().isEmpty()) {
                    String text = node.getAnchorRefText();
                    String refId = null;
                    refId = HeaderIdGenerator.this.generateId(text);
                    if (refId != null) {
                        node.setAnchorRefId(refId);
                    }
                }
            }
        }.visit((Node)document);
    }

    String generateId(String text) {
        if (!text.isEmpty()) {
            String baseRefId = HeaderIdGenerator.generateId(text, this.toDashChars, this.nonDashChars, this.noDupedDashes, this.nonAsciiToLowercase);
            if (this.resolveDupes) {
                if (this.headerBaseIds.containsKey(baseRefId)) {
                    int index = this.headerBaseIds.get(baseRefId);
                    this.headerBaseIds.put(baseRefId, ++index);
                    baseRefId = baseRefId + "-" + index;
                } else {
                    this.headerBaseIds.put(baseRefId, 0);
                }
            }
            return baseRefId;
        }
        return null;
    }

    @Override
    public String getId(Node node) {
        return node instanceof AnchorRefTarget ? ((AnchorRefTarget)node).getAnchorRefId() : null;
    }

    @Override
    public String getId(CharSequence text) {
        return this.generateId(text.toString());
    }

    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes, boolean nonAsciiToLowercase) {
        return HeaderIdGenerator.generateId(headerText, toDashChars, null, noDupedDashes, nonAsciiToLowercase);
    }

    @Deprecated
    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes) {
        return HeaderIdGenerator.generateId(headerText, toDashChars, null, noDupedDashes, true);
    }

    public static String generateId(CharSequence headerText, String toDashChars, String nonDashChars, boolean noDupedDashes, boolean nonAsciiToLowercase) {
        int iMax = headerText.length();
        StringBuilder baseRefId = new StringBuilder(iMax);
        if (toDashChars == null) {
            toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom(null);
        }
        if (nonDashChars == null) {
            nonDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.getFrom(null);
        }
        for (int i = 0; i < iMax; ++i) {
            char c = headerText.charAt(i);
            if (HeaderIdGenerator.isAlphabetic(c)) {
                if (!(nonAsciiToLowercase || c >= 'A' && c <= 'Z')) {
                    baseRefId.append(c);
                    continue;
                }
                baseRefId.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isDigit(c)) {
                baseRefId.append(c);
                continue;
            }
            if (nonDashChars.indexOf(c) != -1) {
                baseRefId.append(c);
                continue;
            }
            if (toDashChars.indexOf(c) == -1 || noDupedDashes && (c != '-' || baseRefId.length() != 0) && (baseRefId.length() == 0 || baseRefId.charAt(baseRefId.length() - 1) == '-')) continue;
            baseRefId.append('-');
        }
        return baseRefId.toString();
    }

    public static boolean isAlphabetic(char c) {
        return (1086 >> Character.getType((int)c) & 1) != 0;
    }

    public static class Factory
    implements HeaderIdGeneratorFactory,
    HtmlIdGeneratorFactory {
        @Override
        public HtmlIdGenerator create(LinkResolverContext context) {
            return new HeaderIdGenerator();
        }

        @Override
        public HtmlIdGenerator create() {
            return new HeaderIdGenerator();
        }
    }
}

