/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApproximateNumeric<Type>
extends Numeric<Type>
implements ScalaObject {
    private final int nativeTypeId;

    public ApproximateNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    @Override
    public String sqlString() {
        block5: {
            String string;
            int n = this.precisionRadix();
            int n2 = this.precision();
            switch (n) {
                default: {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
                }
                case 10: {
                    string = new StringBuilder().append((Object)"FLOAT (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)")").toString();
                    break;
                }
                case 2: {
                    if (n2 == 64) {
                        string = "REAL";
                        break;
                    }
                    if (n2 != 128) break block5;
                    string = "DOUBLE PRECISION";
                }
            }
            return string;
        }
        throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
    }

    @Override
    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

