/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArray {
    protected static final int BYTE_BLOCK_BITS = 8;
    protected static final int BYTE_BLOCK_SIZE = 256;
    protected static final int BYTE_BLOCK_MASK = 255;
    protected byte[][] data = new byte[][]{new byte[256]};
    protected int pos = 0;
    protected boolean frozen = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ByteArray() {
    }

    public ByteArray(InputStream stream, int size) throws IOException {
        int block = 0;
        while (size > 0) {
            int sizeToRead = Math.min(256, size);
            stream.read(this.data[block], 0, sizeToRead);
            if ((size -= sizeToRead) > 0) {
                this.addNewBlock();
            }
            ++block;
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public int nextBytePosition() {
        return this.pos;
    }

    public int getSize() {
        return this.pos;
    }

    protected void addNewBlock() {
        int nextBlockPos = this.pos >>> 8;
        if (nextBlockPos == this.data.length) {
            byte[][] newData = new byte[this.data.length * 2][];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if (!$assertionsDisabled && this.data[nextBlockPos] != null) {
            throw new AssertionError((Object)(this.pos + " " + nextBlockPos));
        }
        this.data[nextBlockPos] = new byte[256];
    }

    protected void addByte(int b) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        if ((this.pos & 0xFF) == 0 && this.pos > 0) {
            this.addNewBlock();
        }
        int currPos = this.pos++;
        this.data[currPos >>> 8][currPos & 0xFF] = (byte)b;
    }

    public void addU1(int i) {
        if (!$assertionsDisabled && i > 255) {
            throw new AssertionError(i);
        }
        this.addByte(i);
    }

    public void addU2(int i) {
        if (!$assertionsDisabled && i > 65535) {
            throw new AssertionError(i);
        }
        this.addByte(i >>> 8);
        this.addByte(i & 0xFF);
    }

    public void addU4(int i) {
        this.addByte(i >>> 24);
        this.addByte(i >>> 16 & 0xFF);
        this.addByte(i >>> 8 & 0xFF);
        this.addByte(i & 0xFF);
    }

    public void putByte(int targetPos, int b) {
        if (!$assertionsDisabled && this.frozen) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetPos >= this.pos) {
            throw new AssertionError((Object)(targetPos + " >= " + this.pos));
        }
        this.data[targetPos >>> 8][targetPos & 0xFF] = (byte)b;
    }

    public void putU2(int targetPos, int i) {
        if (!$assertionsDisabled && i >= 65535) {
            throw new AssertionError(i);
        }
        this.putByte(targetPos, i >>> 8);
        this.putByte(targetPos + 1, i & 0xFF);
    }

    public void putU4(int targetPos, int i) {
        this.putByte(targetPos, i >>> 24);
        this.putByte(targetPos + 1, i >>> 16 & 0xFF);
        this.putByte(targetPos + 2, i >>> 8 & 0xFF);
        this.putByte(targetPos + 3, i & 0xFF);
    }

    public int getU1(int sourcePos) {
        if (!$assertionsDisabled && sourcePos >= this.pos) {
            throw new AssertionError((Object)(sourcePos + " >= " + this.pos));
        }
        return this.data[sourcePos >>> 8][sourcePos & 0xFF] & 0xFF;
    }

    public int getU2(int sourcePos) {
        return this.getU1(sourcePos) << 8 | this.getU1(sourcePos + 1);
    }

    public int getU4(int sourcePos) {
        return this.getU2(sourcePos) << 16 | this.getU2(sourcePos + 2);
    }

    public int getS1(int sourcePos) {
        if (!$assertionsDisabled && sourcePos >= this.pos) {
            throw new AssertionError((Object)(sourcePos + " >= " + this.pos));
        }
        return this.data[sourcePos >>> 8][sourcePos & 0xFF];
    }

    public int getS2(int sourcePos) {
        return this.getS1(sourcePos) << 8 | this.getU1(sourcePos + 1);
    }

    public int getS4(int sourcePos) {
        return this.getS2(sourcePos) << 16 | this.getU2(sourcePos + 2);
    }

    public void writeTo(OutputStream stream) throws IOException {
        if (!this.frozen) {
            this.freeze();
        }
        for (int i = 0; i < this.data.length && this.data[i] != null; ++i) {
            int len = Math.min(256, this.pos - (i << 8));
            stream.write(this.data[i], 0, len);
        }
    }

    static {
        $assertionsDisabled = !ByteArray.class.desiredAssertionStatus();
    }
}

