#![warn(clippy::filter_next)]
#![allow(clippy::useless_vec)]

/// Checks implementation of `FILTER_NEXT` lint.
fn main() {
    let v = vec![3, 2, 1, 0, -1, -2, -3];

    // Single-line case.
    let _ = v.iter().filter(|&x| *x < 0).next();
    //~^ filter_next

    let _ = v.iter().filter(|&x| *x < 0).next_back();
    //~^ filter_next
}

#[clippy::msrv = "1.27"]
fn msrv_1_27() {
    let _ = vec![1].into_iter().filter(|&x| x < 0).next_back();
    //~^ filter_next
}

#[clippy::msrv = "1.26"]
fn msrv_1_26() {
    let _ = vec![1].into_iter().filter(|&x| x < 0).next_back();
}
