private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_0_0 {
	meta:
		name = "TActionBarAccessibility.accDoDefaultAction"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accDoDefaultAction 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_1_0 {
	meta:
		name = "TActionBarAccessibility.accHitTest"
		size = 320
		refs = "0024 VariantInit 003b _Dn_TActionBarItem 0040 @IsClass 0061 TControl.ScreenToClient 007a TCollectionItem.GetIndex 0086 @OleVarFromInt 0099 _Dn_TActionClientItem 00da TWinControl.ControlAtPos 0108 TControl.GetBoundsRect 0113 PtInRect"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 8B 7D 14 8B 5D 08 8B C7 85 FF 74 0D 33 D2 89 57 0C 89 57 08 89 57 04 89 17 57 E8 ?? ?? ?? ?? 66 C7 07 03 00 33 F6 C7 45 FC 01 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4C 8B 45 0C 89 45 EC 8B 45 10 89 45 F0 8D 4D F4 8D 55 EC 8B 43 0C 8B 40 0C E8 ?? ?? ?? ?? 8B 43 0C 8B 70 0C 85 F6 0F 84 C1 00 00 00 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC E9 A0 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 58 8B 43 0C 83 78 44 00 74 4F 8B 45 0C 89 45 E4 8B 45 10 89 45 E8 6A 00 6A 00 8D 4D DC 8D 55 E4 8B 43 0C 8B 70 18 8B C6 E8 ?? ?? ?? ?? 8D 55 DC 8B C6 B1 01 E8 ?? ?? ?? ?? 8B F0 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 36 85 F6 74 2B 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 8D 45 CC 8D 55 F4 E8 ?? ?? ?? ?? 84 C0 74 12 8B C7 33 D2 B1 01 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 07 C7 45 FC 01 00 00 00 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_2_0 {
	meta:
		name = "TActionBarAccessibility.accLocation"
		size = 288
		refs = "0019 @VarAddRef 0021 TActionBarAccessibility.accLocation 0038 @OleVarFromInt 0043 @VarCmpEQ 0050 _Dn_TActionBarItem 0055 @IsClass 006b TActionClient.GetItems 0077 @VarCopy 0091 @VarSub 0099 @VarToInteger 00a1 TActionClients.GetActionClient 00bf TControl.ClientToScreen 00f7 OleVariant 0101 @FinalizeArray 0109 @VarClr 010f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 1C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 E8 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 E8 8D 45 1C E8 ?? ?? ?? ?? 75 1E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 8B 5F 0C EB 46 8B 5F 44 EB 41 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 1C 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 C8 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C8 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8B 58 44 85 DB 74 39 8D 55 B8 8B C3 8B 08 FF 51 54 8D 55 B8 8D 4D F8 8B C3 E8 ?? ?? ?? ?? 8B 45 0C 8B 55 F8 89 10 8B 45 10 8B 55 FC 89 10 8B 45 14 8B 53 48 89 10 8B 45 18 8B 53 4C 89 10 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 1C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 5F 5E 5B 8B E5 5D C2 24 00 }
	condition:
		$1
}

rule function_3_0 {
	meta:
		name = "TActionBarAccessibility.accNavigate"
		size = 90
		refs = "0008 @VarAddRef 0027 TActionBarAccessibility.accNavigate 0047 @VarClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 8B 45 20 8B 55 20 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_4_0 {
	meta:
		name = "TActionBarAccessibility.Get_accFocus"
		size = 35
		altNames = "TActionBarAccessibility.Get_accSelection"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 55 0C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A B8 03 00 02 80 5D C2 08 00 }
	condition:
		$1
}

rule function_5_0 {
	meta:
		name = "TActionBarAccessibility.Create"
		size = 78
		refs = "000e @ClassCreate 002c @IntfCopy 0037 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 89 4F 10 8B 75 08 89 77 0C 8D 46 34 8B D7 85 D2 74 03 83 EA EC E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_6_0 {
	meta:
		name = "TActionBarAccessibility.GetIDsOfNames"
		size = 12
		altNames = "TBaseDebugScriptSite.GetDeferredText TBaseDebugScriptSite.GetScriptTextAttributes TEventDispatch.GetIDsOfNames TLocalAppServer.GetIDsOfNames TMSDOMEventHandler.GetIDsOfNames TOleControl.GetIDsOfNames TSOAPAppServerAdapter.GetIDsOfNames TServerEventDispatch.GetIDsOfNames"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 18 00 }
	condition:
		$1
}

rule function_7_0 {
	meta:
		name = "CmpUnimplemented"
		size = 12
		altNames = "TActionBarAccessibility.GetTypeInfo TActiveXControl.InitFromData TActiveXControl.SetData TDataDispatch.GetTypeInfo TDataObject.SetData TLocalAppServer.GetTypeInfo TMSDOMEventHandler.GetTypeInfo TObjectDispatch.GetTypeInfo TSOAPAppServerAdapter.GetTypeInfo"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_8_0 {
	meta:
		name = "TActionBarAccessibility.GetTypeInfoCount"
		size = 12
		altNames = "TActiveScriptSite.GetLCID TActiveXControl.ContextSensitiveHelp TActiveXControl.GetSizeMax TActiveXControl.QueryGetData TActiveXControl.SetColorScheme TActiveXControl.Unfreeze TDownLoadURL.GetPriority TDownLoadURL.OnLowResource TLocalAppServer.GetTypeInfoCount TMSDOMEventHandler.GetTypeInfoCount TObjectDispatch.GetTypeInfoCount TOleControl.LockInPlaceActive TOleControl.OnFocus TOleControl.SetBorderSpace TOleLinkStub.GetUpdateOptions TOleLinkStub.SetSourceDisplayName TOleLinkStub.SetUpdateOptions TOleLinkStub.Update TPropertyPageImpl.EditProperty TPropertyPageImpl.Help TSOAPAppServerAdapter.GetTypeInfoCount UniUnimplemented"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_9_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChild"
		size = 298
		refs = "0018 @VarAddRef 002b TActionBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0079 @VarCmpGT 0083 @IntfClear 00a0 @VarCopy 00ba @VarSub 00c2 @VarToInteger 00ca TActionClients.GetActionClient 00d4 _DV_TActionBarAccessibility 00d9 TActionBarAccessibility.Create 00ea @IntfCopy 0102 OleVariant 010c @FinalizeArray 0114 @VarClr 011a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 98 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accChild"
		size = 298
		refs = "0018 @VarAddRef 002b TActionMenuBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0079 @VarCmpGT 0083 @IntfClear 00a0 @VarCopy 00ba @VarSub 00c2 @VarToInteger 00ca TActionClients.GetActionClient 00d4 _DV_TActionMenuBarAccessibility 00d9 TActionBarAccessibility.Create 00ea @IntfCopy 0102 OleVariant 010c @FinalizeArray 0114 @VarClr 011a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 98 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_10_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChildCount"
		size = 31
		refs = "000a TActionClient.GetItems"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 0C E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B 55 0C 89 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDefaultAction"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accDefaultAction 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelp"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accHelp 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDescription"
		size = 361
		refs = "0019 @VarAddRef 002c TActionBarAccessibility.Get_accDescription 0043 @OleVarFromInt 004e @VarCmpEQ 005b _Dn_TActionBarItem 0060 @IsClass 0075 GetLongHint 0080 @WStrFromUStr 00a8 TActionClient.GetItems 00b4 @VarCopy 00ce @VarSub 00d6 @VarToInteger 00de TActionClients.GetActionClient 00e3 TActionClientItem.GetAction 012b OleVariant 0135 @FinalizeArray 0142 @UStrArrayClr 014a @VarClr 0158 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 50 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8D 55 EC 8B 47 0C 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 77 8D 55 E8 8B 47 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 1C E8 ?? ?? ?? ?? EB 59 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 C4 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C4 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 7C 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 C0 8B 45 C0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelpTopic"
		size = 186
		refs = "0021 @VarAddRef 0029 TActionBarAccessibility.Get_accHelpTopic 0037 @WStrClr 004c @OleVarFromInt 0057 @VarCmpEQ 0062 _Dn_TActionClientItem 0067 @IsClass 0073 TActionClientItem.GetAction 009b @VarClr 00a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 75 20 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C E8 ?? ?? ?? ?? 33 C0 89 06 BF 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 10 E8 ?? ?? ?? ?? 75 2D 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1B 8B 43 0C E8 ?? ?? ?? ?? 85 C0 74 0F 8B 43 0C E8 ?? ?? ?? ?? 8B 40 74 89 06 33 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C7 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "TActionBarAccessibility.Get_accKeyboardShortcut"
		size = 441
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accKeyboardShortcut 0044 @OleVarFromInt 004f @VarCmpEQ 0060 _Dn_TActionBarItem 0065 @IsClass 0071 @WStrClr 007d TActionClientItem.GetAction 008c TActionClientItem.GetCaption 0097 GetHotkey 00a2 @WStrFromUStr 00bb ShortCutToText 00ec TActionClient.GetItems 00f8 @VarCopy 0112 @VarSub 011a @VarToInteger 0122 TActionClients.GetActionClient 0173 OleVariant 017d @FinalizeArray 0185 @UStrClr 0192 @UStrArrayClr 019a @VarClr 01a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B 45 1C E8 ?? ?? ?? ?? E9 E7 00 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 23 8D 55 E8 8B 43 0C E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 22 8B 43 0C E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 7D 33 F6 EB 79 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 CC E8 ?? ?? ?? ?? 8D 45 BC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 BC 8D 45 CC E8 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "TActionBarAccessibility.Get_accName"
		size = 423
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accName 0041 @OleVarFromInt 004c @VarCmpEQ 0059 _Dn_TActionClientItem 005e @IsClass 006c TActionClientItem.GetCaption 0077 StripHotkey 0082 @WStrFromUStr 008f _Dn_TActionBarItem 00a7 TControl.GetText 00b4 TActionClient.GetItems 00d1 @VarCmpGT 00ee @VarCopy 0108 @VarSub 0110 @VarToInteger 0118 TActionClients.GetActionClient 014c OleVariant 0156 @FinalizeArray 0163 @UStrArrayClr 016b @VarClr 0173 @UStrClr 0196 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 0A 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 5E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 25 8D 55 E8 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? E9 AF 00 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 9A 00 00 00 8D 55 E4 8B 47 0C E8 ?? ?? ?? ?? E9 8A 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 78 08 8D 45 D4 8B D7 B1 FC E8 ?? ?? ?? ?? 8D 55 D4 8D 45 0C E8 ?? ?? ?? ?? 7E 07 BE 01 00 00 00 EB 5C 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 BC E8 ?? ?? ?? ?? 8D 45 AC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 AC 8D 45 BC E8 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8D 55 CC E8 ?? ?? ?? ?? 8B 45 CC 8D 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 8B 45 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB AB 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "TActionBarAccessibility.Get_accParent"
		size = 50
		refs = "0026 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 00 00 00 8B 73 10 85 F6 74 0D 8B 45 0C 8B 56 34 E8 ?? ?? ?? ?? 33 C0 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "TActionBarAccessibility.Get_accRole"
		size = 244
		refs = "0013 @VarAddRef 0032 TActionBarAccessibility.Get_accRole 0043 VariantInit 0057 @OleVarFromInt 0062 @VarCmpEQ 006d _Dn_TActionBarItem 0072 @IsClass 0095 _Dn_TCustomActionMainMenuBar 00d5 @VarClr 00e3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 52 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 3E 8B 43 0C 8B 78 44 85 FF 74 1E 8B 47 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 0B 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "TActionBarAccessibility.accSelect"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accSelect 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "TActionBarAccessibility.Get_accState"
		size = 650
		refs = "0019 @VarAddRef 0038 TActionBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00c5 IsVisible 00dc IsEnabled 00f4 IsChecked 0111 TActionClient.GetItems 011d @VarCopy 0137 @VarSub 013f @VarToInteger 0149 TActionClients.GetActionClient 0198 TActionClient.GetHasItems 01a2 HasPopup 0261 OleVariant 026b @FinalizeArray 0273 @VarClr 0279 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 12 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 75 0A BF 57 00 07 80 E9 98 01 00 00 8B 45 1C C7 40 08 84 00 10 00 0F B6 46 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 4C 0F B6 40 69 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 49 01 00 00 8B 45 1C C7 40 08 84 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 D0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 D0 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 B0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 B0 8D 45 C0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 A0 E8 ?? ?? ?? ?? 8D 45 90 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 90 8D 45 A0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 80 E8 ?? ?? ?? ?? 8D 85 70 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 70 FF FF FF 8D 45 80 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 DC 00 00 00 84 C0 74 07 8B 45 1C 83 48 08 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 70 FF FF FF 8B 15 ?? ?? ?? ?? B9 09 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "TActionBarAccessibility.Get_accValue"
		size = 86
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accValue 0029 @WStrClr 0043 @VarClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "TActionBarAccessibility.Invoke"
		size = 12
		altNames = "TLocalAppServer.Invoke TSOAPAppServerAdapter.Invoke"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 24 00 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "TActionBarAccessibility.Set_accName"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accName 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "TActionBarAccessibility.Set_accValue"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accValue 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accDescription"
		size = 232
		refs = "0014 @VarAddRef 0027 TActionMenuBarAccessibility.Get_accDescription 003a @WStrClr 0046 @OleVarFromInt 0051 @VarCmpEQ 005e TActionClientItem.GetCaption 006b @UStrCat 0076 @WStrFromUStr 00a7 @UStrClr 00af @VarClr 00bd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8B 45 1C E8 ?? ?? ?? ?? 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 23 8D 55 EC 8B 43 0C E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E8 8B 45 E8 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C6 5E 5B 8B E5 5D C2 18 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 20 00 6D 00 65 00 6E 00 75 00 00 00 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accRole"
		size = 202
		refs = "0012 @VarAddRef 0031 TActionMenuBarAccessibility.Get_accRole 0042 VariantInit 0056 @OleVarFromInt 0061 @VarCmpEQ 006c _Dn_TActionBarItem 0071 @IsClass 00ac @VarClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 2A 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_29_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accState"
		size = 772
		refs = "0019 @VarAddRef 0038 TActionMenuBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00bb IsVisible 00d2 IsEnabled 00ec IsChecked 0109 TActionClientItem.GetAction 0153 TActionClient.GetItems 0170 @VarCmpGT 0190 @VarCopy 01aa @VarSub 01b2 @VarToInteger 01bc TActionClients.GetActionClient 01c9 MessageBeep 0258 TActionClient.GetHasItems 0262 HasPopup 02db OleVariant 02e5 @FinalizeArray 02ed @VarClr 02f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 14 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 DB 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 74 51 8B 45 1C C7 40 08 04 00 10 00 0F B6 46 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 92 DC 00 00 00 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 CB 01 00 00 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 85 C0 0F 84 B1 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 0F B6 80 86 00 00 00 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 0F B6 40 6A 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 77 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0A BF 57 00 07 80 E9 46 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 83 78 44 00 75 07 6A 00 E8 ?? ?? ?? ?? 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 B0 E8 ?? ?? ?? ?? 8D 45 A0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 A0 8D 45 B0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 90 E8 ?? ?? ?? ?? 8D 45 80 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 80 8D 45 90 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8D 85 60 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 60 FF FF FF 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 8B 15 ?? ?? ?? ?? B9 0A 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "ABAccessibility"
		size = 8
		refs = "0002 _DV_3"
		altNames = "ActnPopup ApacheHTTP ApacheTwoHTTP AspTlb AutoDisp Contnrs DBXDataExpressMetaDataProvider DBXDataStoreMetaDataReader DBXDataStoreMetaDataWriter DBXFirebirdMetaDataWriter DBXInformixMetaDataWriter DBXInterbaseMetaDataWriter DBXMessageHandlerJSonClient DBXMessageHandlerJSonCommon DBXMetaDataCommandFactory DBXMetaDataReader DBXMsSqlMetaDataWriter DBXMySqlMetaDataWriter DBXReaderTableStorage DBXSybaseASAMetaDataWriter DBXSybaseASEMetaDataWriter DBXTypedTableStorage DSProd DSTCPServerTransport DbgSiteAS IBConnectionBroker IBEvents IBUpdateSQLEditor ImgList IndySockTransport IsapiHTTP MPlayer Masks MidasCon PagItems Printers SConnect SOAPAttach SOAPHTTPPasInv SOAPHTTPTrans ScktMain SimpleDS SockAppReg SqlEdit SqlReg TabNotBk TeeDBEdit TeeEdiGene TeeNavigator TeePenDlg WSILIntf XMLBrokr XMLIniFile XMLIntf XMLSchemaTags frmIBFilterFieldEditorU msxml"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1459_0 {
	meta:
		name = "ADOConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1896_0 {
	meta:
		name = "ADOInt"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "AccCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "AclAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "ActivDbgLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "ActiveX"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "ActnColorMaps"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "ActnCtrls"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1338_0 {
	meta:
		name = "ActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1444_0 {
	meta:
		name = "AdaptReq"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1448_0 {
	meta:
		name = "AddConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1457_0 {
	meta:
		name = "AdoConEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2166_0 {
	meta:
		name = "AscrLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2293_0 {
	meta:
		name = "AutoAdap"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2948_0 {
	meta:
		name = "BDE"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2630_0 {
	meta:
		name = "BandActn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2955_0 {
	meta:
		name = "BrkrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3056_0 {
	meta:
		name = "ButtonGroup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3495_0 {
	meta:
		name = "CGIHTTP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5059_0 {
	meta:
		name = "COMAdmin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3192_0 {
	meta:
		name = "Calendar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_3595_0 {
	meta:
		name = "Character"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4924_0 {
	meta:
		name = "ClassRegistry"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5028_0 {
	meta:
		name = "CmAdmCtl"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5057_0 {
	meta:
		name = "ColorGrd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5062_0 {
	meta:
		name = "ComApp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5064_0 {
	meta:
		name = "ComConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7235_0 {
	meta:
		name = "ComStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7237_0 {
	meta:
		name = "ComSvcs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7042_0 {
	meta:
		name = "CommCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7072_0 {
	meta:
		name = "CommDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7198_0 {
	meta:
		name = "CompProd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_7239_0 {
	meta:
		name = "Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8346_0 {
	meta:
		name = "CopyPrsr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8348_0 {
	meta:
		name = "Cpl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8515_0 {
	meta:
		name = "CtlConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8649_0 {
	meta:
		name = "D2D1"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10067_0 {
	meta:
		name = "DBActns"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10294_0 {
	meta:
		name = "DBAdapt"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10321_0 {
	meta:
		name = "DBBdeWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10334_0 {
	meta:
		name = "DBByteBuffer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10402_0 {
	meta:
		name = "DBCGrids"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10448_0 {
	meta:
		name = "DBChart"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10754_0 {
	meta:
		name = "DBClient"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10756_0 {
	meta:
		name = "DBClientActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10769_0 {
	meta:
		name = "DBClientActns"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10853_0 {
	meta:
		name = "DBCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10855_0 {
	meta:
		name = "DBCommonTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10873_0 {
	meta:
		name = "DBConnAdmin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10875_0 {
	meta:
		name = "DBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11327_0 {
	meta:
		name = "DBDrvEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11620_0 {
	meta:
		name = "DBGrids"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11797_0 {
	meta:
		name = "DBOleCtl"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11816_0 {
	meta:
		name = "DBOleEdt"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11838_0 {
	meta:
		name = "DBPlatform"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12534_0 {
	meta:
		name = "DBWeb"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12610_0 {
	meta:
		name = "DBXClient"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_12616_0 {
	meta:
		name = "DBXClientResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13885_0 {
	meta:
		name = "DBXCommonResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14017_0 {
	meta:
		name = "DBXCommonTable"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14157_0 {
	meta:
		name = "DBXCustomDataGenerator"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14359_0 {
	meta:
		name = "DBXDBMetaData"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14506_0 {
	meta:
		name = "DBXDBReaders"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14343_0 {
	meta:
		name = "DBXDb2MetaDataReader"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14351_0 {
	meta:
		name = "DBXDb2MetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14721_0 {
	meta:
		name = "DBXDelegate"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14852_0 {
	meta:
		name = "DBXDynalinkNative"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14855_0 {
	meta:
		name = "DBXEntReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14916_0 {
	meta:
		name = "DBXFirebirdMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15033_0 {
	meta:
		name = "DBXInformixMetaDataReader"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15109_0 {
	meta:
		name = "DBXInterbaseMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15304_0 {
	meta:
		name = "DBXJSON"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15489_0 {
	meta:
		name = "DBXJSONReflect"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15915_0 {
	meta:
		name = "DBXMessageHandlerCommon"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16043_0 {
	meta:
		name = "DBXMessageHandlerJSonServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16079_0 {
	meta:
		name = "DBXMessageHandlerServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16112_0 {
	meta:
		name = "DBXMetaDataCommand"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16137_0 {
	meta:
		name = "DBXMetaDataError"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16139_0 {
	meta:
		name = "DBXMetaDataNames"
		size = 8
		refs = "0002 _DV_74"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16250_0 {
	meta:
		name = "DBXMetaDataProvider"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16497_0 {
	meta:
		name = "DBXMetaDataUtil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16627_0 {
	meta:
		name = "DBXMetaDataWriter"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16702_0 {
	meta:
		name = "DBXMsSqlMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16868_0 {
	meta:
		name = "DBXMySqlMetaDataReader"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16956_0 {
	meta:
		name = "DBXOracleMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16966_0 {
	meta:
		name = "DBXOracleMetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17081_0 {
	meta:
		name = "DBXPlatform"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17156_0 {
	meta:
		name = "DBXReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17211_0 {
	meta:
		name = "DBXSqlScanner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17458_0 {
	meta:
		name = "DBXStream"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17531_0 {
	meta:
		name = "DBXStreamPlatform"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17469_0 {
	meta:
		name = "DBXStreamer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17583_0 {
	meta:
		name = "DBXSybaseASAMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17667_0 {
	meta:
		name = "DBXSybaseASEMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17690_0 {
	meta:
		name = "DBXTableFactory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17716_0 {
	meta:
		name = "DBXTestResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18065_0 {
	meta:
		name = "DBXTransport"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18089_0 {
	meta:
		name = "DBXTransportFilter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17132_0 {
	meta:
		name = "DBXpress"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17139_0 {
	meta:
		name = "DBXpressWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18592_0 {
	meta:
		name = "DDEml"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19266_0 {
	meta:
		name = "DSClientProviderResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19346_0 {
	meta:
		name = "DSCommonProxy"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19635_0 {
	meta:
		name = "DSCommonServer"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19719_0 {
	meta:
		name = "DSCommonTable"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19744_0 {
	meta:
		name = "DSConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19769_0 {
	meta:
		name = "DSCreators"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19867_0 {
	meta:
		name = "DSHTTP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19933_0 {
	meta:
		name = "DSHTTPCommon"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20005_0 {
	meta:
		name = "DSHTTPWebBroker"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20008_0 {
	meta:
		name = "DSIndy10ServerTransportReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20021_0 {
	meta:
		name = "DSNames"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20070_0 {
	meta:
		name = "DSProviderClientReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20096_0 {
	meta:
		name = "DSProxy"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20271_0 {
	meta:
		name = "DSReflect"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20335_0 {
	meta:
		name = "DSServerMethodsClassGen"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20341_0 {
	meta:
		name = "DSServerMethodsFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20369_0 {
	meta:
		name = "DSServerReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20371_0 {
	meta:
		name = "DSServerResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20469_0 {
	meta:
		name = "DSSource"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20510_0 {
	meta:
		name = "DSStandAloneCreators"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20522_0 {
	meta:
		name = "DSStandAloneForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20538_0 {
	meta:
		name = "DSStandAloneReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20561_0 {
	meta:
		name = "DSTransport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20573_0 {
	meta:
		name = "DSUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20575_0 {
	meta:
		name = "DSWebBrokerFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20598_0 {
	meta:
		name = "DSWebBrokerReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20633_0 {
	meta:
		name = "DUnitAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20639_0 {
	meta:
		name = "DUnitMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8687_0 {
	meta:
		name = "DataBkr"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8845_0 {
	meta:
		name = "DateUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11358_0 {
	meta:
		name = "DbExcept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14200_0 {
	meta:
		name = "DbxDataGenerator"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14508_0 {
	meta:
		name = "DbxDefaultTestDriverUnits"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17192_0 {
	meta:
		name = "DbxSqlEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_17714_0 {
	meta:
		name = "DbxTest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18611_0 {
	meta:
		name = "Diagnostics"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19082_0 {
	meta:
		name = "DirOutln"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19006_0 {
	meta:
		name = "Direct2D"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19084_0 {
	meta:
		name = "Dlgs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19264_0 {
	meta:
		name = "DrTable"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20669_0 {
	meta:
		name = "Dwmapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20671_0 {
	meta:
		name = "DxgiFormat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20686_0 {
	meta:
		name = "EditChar"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20700_0 {
	meta:
		name = "EncdDecd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20788_0 {
	meta:
		name = "ExtActns"
		size = 8
		refs = "0002 _DV_72"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21448_0 {
	meta:
		name = "FileCtrl"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21479_0 {
	meta:
		name = "FldEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23721_0 {
	meta:
		name = "GIFConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25237_0 {
	meta:
		name = "GUITestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22184_0 {
	meta:
		name = "Gauges"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22384_0 {
	meta:
		name = "Generics.Collections"
		size = 8
		refs = "0002 _DV_82"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22835_0 {
	meta:
		name = "Generics.Defaults"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22855_0 {
	meta:
		name = "GestureConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22962_0 {
	meta:
		name = "GestureCtrls"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23203_0 {
	meta:
		name = "GestureMgr"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25098_0 {
	meta:
		name = "Grids"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25505_0 {
	meta:
		name = "HTTPApp"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25659_0 {
	meta:
		name = "HTTPD"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25824_0 {
	meta:
		name = "HTTPD2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25886_0 {
	meta:
		name = "HTTPParse"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25971_0 {
	meta:
		name = "HTTPProd"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25975_0 {
	meta:
		name = "HTTPSOAPToPasBind"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26003_0 {
	meta:
		name = "HTTPUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25267_0 {
	meta:
		name = "HelpIntfs"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26028_0 {
	meta:
		name = "IBBatchMove"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26062_0 {
	meta:
		name = "IBBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26091_0 {
	meta:
		name = "IBConnectionBrokerEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26093_0 {
	meta:
		name = "IBConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26117_0 {
	meta:
		name = "IBCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26691_0 {
	meta:
		name = "IBDBReg"
		size = 8
		refs = "0002 _DV_64"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26693_0 {
	meta:
		name = "IBDCLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26479_0 {
	meta:
		name = "IBDatabase"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26498_0 {
	meta:
		name = "IBDatabaseEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26561_0 {
	meta:
		name = "IBDatabaseINI"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26538_0 {
	meta:
		name = "IBDatabaseInfo"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26695_0 {
	meta:
		name = "IBErrorCodes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26792_0 {
	meta:
		name = "IBEventsEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26796_0 {
	meta:
		name = "IBEvnts"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26799_0 {
	meta:
		name = "IBExternals"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26843_0 {
	meta:
		name = "IBExtract"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26885_0 {
	meta:
		name = "IBFilterSummary"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26887_0 {
	meta:
		name = "IBGeneratorEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26898_0 {
	meta:
		name = "IBHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26941_0 {
	meta:
		name = "IBInstallHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27080_0 {
	meta:
		name = "IBProc32"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27121_0 {
	meta:
		name = "IBQuery"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27129_0 {
	meta:
		name = "IBRestoreEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27573_0 {
	meta:
		name = "IBSQL"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27181_0 {
	meta:
		name = "IBScript"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27192_0 {
	meta:
		name = "IBSecurityEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27204_0 {
	meta:
		name = "IBServiceEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27361_0 {
	meta:
		name = "IBServices"
		size = 8
		refs = "0002 _DV_62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27674_0 {
	meta:
		name = "IBStoredProc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27756_0 {
	meta:
		name = "IBTable"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27774_0 {
	meta:
		name = "IBTransactionEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27789_0 {
	meta:
		name = "IBUpdateSQL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27879_0 {
	meta:
		name = "IBVclReg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27881_0 {
	meta:
		name = "IBVisualConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27883_0 {
	meta:
		name = "IBXConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27888_0 {
	meta:
		name = "IBXMLHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28812_0 {
	meta:
		name = "IOUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27952_0 {
	meta:
		name = "ImageHlp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28110_0 {
	meta:
		name = "Imm"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28225_0 {
	meta:
		name = "IniFiles"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28362_0 {
	meta:
		name = "IntfInfo"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28364_0 {
	meta:
		name = "InvConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28572_0 {
	meta:
		name = "InvRules"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28370_0 {
	meta:
		name = "Invoker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28814_0 {
	meta:
		name = "Isapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28816_0 {
	meta:
		name = "Isapi2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28886_0 {
	meta:
		name = "JConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29156_0 {
	meta:
		name = "Keyboard"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29377_0 {
	meta:
		name = "KeyboardTypes"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29603_0 {
	meta:
		name = "KnownFolders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29667_0 {
	meta:
		name = "LZExpand"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29654_0 {
	meta:
		name = "ListActns"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29973_0 {
	meta:
		name = "MConnect"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30967_0 {
	meta:
		name = "MMSystem"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31290_0 {
	meta:
		name = "MSHTML"
		size = 8
		refs = "0002 _DV_221"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29669_0 {
	meta:
		name = "Manipulations"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29684_0 {
	meta:
		name = "Mapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29739_0 {
	meta:
		name = "Mask"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29772_0 {
	meta:
		name = "MaskUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29921_0 {
	meta:
		name = "Math"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30198_0 {
	meta:
		name = "Messages"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30323_0 {
	meta:
		name = "MidComp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30325_0 {
	meta:
		name = "MidConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30762_0 {
	meta:
		name = "MidProd"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30200_0 {
	meta:
		name = "Midas"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31292_0 {
	meta:
		name = "MsInkAut"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31294_0 {
	meta:
		name = "MsInkAut15"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31596_0 {
	meta:
		name = "MtsRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31575_0 {
	meta:
		name = "Mtsobj"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31606_0 {
	meta:
		name = "Mtx"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31621_0 {
	meta:
		name = "Nb30"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31657_0 {
	meta:
		name = "Ns30Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31693_0 {
	meta:
		name = "Ns35Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31729_0 {
	meta:
		name = "Ns36Fix"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32006_0 {
	meta:
		name = "Nsapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33360_0 {
	meta:
		name = "OPConvert"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32031_0 {
	meta:
		name = "ObjAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32054_0 {
	meta:
		name = "ObjBrkr"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32075_0 {
	meta:
		name = "ObjComAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32077_0 {
	meta:
		name = "ObjectArray"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32753_0 {
	meta:
		name = "Ole2"
		size = 8
		refs = "0002 _DV_17"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32837_0 {
	meta:
		name = "OleConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32943_0 {
	meta:
		name = "OleCtl"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33303_0 {
	meta:
		name = "OleDB"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33330_0 {
	meta:
		name = "OleDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33362_0 {
	meta:
		name = "OpConvertOptions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34254_0 {
	meta:
		name = "Outline"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34406_0 {
	meta:
		name = "PenWin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34669_0 {
	meta:
		name = "PrivateHeap"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34671_0 {
	meta:
		name = "PropKey"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34739_0 {
	meta:
		name = "PropSys"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34965_0 {
	meta:
		name = "Provider"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34991_0 {
	meta:
		name = "PsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36218_0 {
	meta:
		name = "RTLConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35114_0 {
	meta:
		name = "RegStr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35112_0 {
	meta:
		name = "Registry"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35130_0 {
	meta:
		name = "ReqFiles"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35145_0 {
	meta:
		name = "ReqImpl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36018_0 {
	meta:
		name = "RibbonActnCtrls"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36098_0 {
	meta:
		name = "RibbonConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36117_0 {
	meta:
		name = "RibbonGalleryBar"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36182_0 {
	meta:
		name = "RibbonStyleActnCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36185_0 {
	meta:
		name = "RichEdit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36216_0 {
	meta:
		name = "Rio"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36220_0 {
	meta:
		name = "RtsCom"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38596_0 {
	meta:
		name = "SHDocVw"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38885_0 {
	meta:
		name = "SHFolder"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39637_0 {
	meta:
		name = "SMINTF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39700_0 {
	meta:
		name = "SOAPAttachIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39739_0 {
	meta:
		name = "SOAPConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39778_0 {
	meta:
		name = "SOAPDm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39789_0 {
	meta:
		name = "SOAPDomConv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39795_0 {
	meta:
		name = "SOAPEnv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39816_0 {
	meta:
		name = "SOAPHTTPClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39821_0 {
	meta:
		name = "SOAPHTTPDisp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39899_0 {
	meta:
		name = "SOAPLinked"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39912_0 {
	meta:
		name = "SOAPPasInv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37297_0 {
	meta:
		name = "ScktCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37446_0 {
	meta:
		name = "ScktComp"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37770_0 {
	meta:
		name = "ScreenTips"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37865_0 {
	meta:
		name = "ScrptMgr"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38254_0 {
	meta:
		name = "Series"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39546_0 {
	meta:
		name = "ShLwApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38328_0 {
	meta:
		name = "ShadowWnd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38696_0 {
	meta:
		name = "ShellAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38598_0 {
	meta:
		name = "ShellAnimations"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38698_0 {
	meta:
		name = "ShellConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39095_0 {
	meta:
		name = "ShlObj"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39564_0 {
	meta:
		name = "SimpleDSReg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39586_0 {
	meta:
		name = "SiteConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39635_0 {
	meta:
		name = "SiteProd"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_39962_0 {
	meta:
		name = "SockAppNotify"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40096_0 {
	meta:
		name = "SockHTTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40119_0 {
	meta:
		name = "SockRequestInterpreter"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40142_0 {
	meta:
		name = "SockTransport"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40191_0 {
	meta:
		name = "Spin"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40193_0 {
	meta:
		name = "SqlConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40840_0 {
	meta:
		name = "StdActnMenus"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40944_0 {
	meta:
		name = "StdActns"
		size = 8
		refs = "0002 _DV_83"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41351_0 {
	meta:
		name = "StdCtrls"
		size = 8
		refs = "0002 _DV_72"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41361_0 {
	meta:
		name = "StdVCL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41428_0 {
	meta:
		name = "StrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41363_0 {
	meta:
		name = "StructuredQuery"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41365_0 {
	meta:
		name = "StructuredQueryCondition"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41497_0 {
	meta:
		name = "SvrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41576_0 {
	meta:
		name = "SvrHTTPIndy"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41578_0 {
	meta:
		name = "SvrInfoConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41628_0 {
	meta:
		name = "SvrSockRequest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41703_0 {
	meta:
		name = "SysConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41737_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43589_0 {
	meta:
		name = "TConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42672_0 {
	meta:
		name = "TEncoding.Create@"
		size = 8
		refs = "0002 TEncoding.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42671_0 {
	meta:
		name = "TLanguages.Create@"
		size = 8
		refs = "0002 TLanguages.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43568_0 {
	meta:
		name = "Tabs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47075_0 {
	meta:
		name = "TeExport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44157_0 {
	meta:
		name = "TeeAxMaxMin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44152_0 {
	meta:
		name = "TeeAxisIncr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44229_0 {
	meta:
		name = "TeeBrushDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44310_0 {
	meta:
		name = "TeeChartGrid"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44371_0 {
	meta:
		name = "TeeCustomShapeEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44440_0 {
	meta:
		name = "TeeData"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44524_0 {
	meta:
		name = "TeeDraw3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44551_0 {
	meta:
		name = "TeeEdi3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44625_0 {
	meta:
		name = "TeeEdiAxis"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44646_0 {
	meta:
		name = "TeeEdiFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44730_0 {
	meta:
		name = "TeeEdiGrad"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44762_0 {
	meta:
		name = "TeeEdiLege"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44778_0 {
	meta:
		name = "TeeEdiPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44802_0 {
	meta:
		name = "TeeEdiPane"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44891_0 {
	meta:
		name = "TeeEdiSeri"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45000_0 {
	meta:
		name = "TeeEdiTitl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45023_0 {
	meta:
		name = "TeeEdiWall"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45256_0 {
	meta:
		name = "TeeFiltersEditor"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45280_0 {
	meta:
		name = "TeeFormatting"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45307_0 {
	meta:
		name = "TeeFuncEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45350_0 {
	meta:
		name = "TeeGalleryAlternate"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45535_0 {
	meta:
		name = "TeeLisB"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46529_0 {
	meta:
		name = "TeePrevi"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46565_0 {
	meta:
		name = "TeePreviewPanel"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46849_0 {
	meta:
		name = "TeeSelectList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46867_0 {
	meta:
		name = "TeeShadowEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_46945_0 {
	meta:
		name = "TeeSourceEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47035_0 {
	meta:
		name = "TeeSymbolEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47100_0 {
	meta:
		name = "TestExtensions"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47354_0 {
	meta:
		name = "TextTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47405_0 {
	meta:
		name = "ThemedActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47457_0 {
	meta:
		name = "Themes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47509_0 {
	meta:
		name = "TimeSpan"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47532_0 {
	meta:
		name = "TlHelp32"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47557_0 {
	meta:
		name = "ToolWin"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47559_0 {
	meta:
		name = "TpcShrd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47723_0 {
	meta:
		name = "TypInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47579_0 {
	meta:
		name = "Types"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47729_0 {
	meta:
		name = "UDDIHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47802_0 {
	meta:
		name = "UrlMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48538_0 {
	meta:
		name = "VDBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47931_0 {
	meta:
		name = "ValEdit"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48138_0 {
	meta:
		name = "VarHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54006_0 {
	meta:
		name = "WSDLBind"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54018_0 {
	meta:
		name = "WSDLIntf"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54098_0 {
	meta:
		name = "WSDLItems"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54117_0 {
	meta:
		name = "WSDLNode"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_48540_0 {
	meta:
		name = "WbmConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49261_0 {
	meta:
		name = "WebAuto"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49271_0 {
	meta:
		name = "WebBroker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49284_0 {
	meta:
		name = "WebBrokerSOAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49286_0 {
	meta:
		name = "WebCat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49350_0 {
	meta:
		name = "WebCntxt"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49460_0 {
	meta:
		name = "WebComp"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49462_0 {
	meta:
		name = "WebConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49505_0 {
	meta:
		name = "WebContnrs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49659_0 {
	meta:
		name = "WebDisp"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49694_0 {
	meta:
		name = "WebFact"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49994_0 {
	meta:
		name = "WebForm"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49996_0 {
	meta:
		name = "WebLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50099_0 {
	meta:
		name = "WebModu"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50101_0 {
	meta:
		name = "WebNode"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50382_0 {
	meta:
		name = "WebScript_TLB"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50446_0 {
	meta:
		name = "WebServExp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50488_0 {
	meta:
		name = "WebSess"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50682_0 {
	meta:
		name = "WebSnapObjs"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50709_0 {
	meta:
		name = "WebUsers"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50733_0 {
	meta:
		name = "WideSqlEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50887_0 {
	meta:
		name = "WideStrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53543_0 {
	meta:
		name = "WinInet"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53618_0 {
	meta:
		name = "WinSock"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53846_0 {
	meta:
		name = "WinSpool"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53898_0 {
	meta:
		name = "WinSvc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50896_0 {
	meta:
		name = "Wincodec"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53555_0 {
	meta:
		name = "Winsafer"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54289_0 {
	meta:
		name = "XMLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54535_0 {
	meta:
		name = "XMLDoc"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54953_0 {
	meta:
		name = "XMLSchema"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55076_0 {
	meta:
		name = "XPActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55078_0 {
	meta:
		name = "XPMan"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55316_0 {
	meta:
		name = "XSLProd"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55032_0 {
	meta:
		name = "Xmlxform"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55380_0 {
	meta:
		name = "ZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55382_0 {
	meta:
		name = "ZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_2950_0 {
	meta:
		name = "bdeconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11774_0 {
	meta:
		name = "dblookup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22125_0 {
	meta:
		name = "frmIBAvailableFieldsU"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28339_0 {
	meta:
		name = "inquire_v1"
		size = 8
		refs = "0002 _DV_94"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32765_0 {
	meta:
		name = "oleacc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34605_0 {
	meta:
		name = "pnglang"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55002_0 {
	meta:
		name = "xmlutil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "ValidProgID"
		size = 368
		refs = "000e ValidProgID 003a @InternalUStrFromLStr 0092 @UStrCopy 009f AnsiCompareStr 00d0 CompareText 00e4 UpperCase 00f1 Pos 0111 @UStrArrayClr 0117 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 85 C0 74 1C 8B D0 83 EA 0A 66 83 3A 02 74 11 8B 45 08 8B 50 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 83 F8 07 7E 60 8B 45 08 8B 40 FC 85 C0 74 1C 8B D0 83 EA 0A 66 83 3A 02 74 11 8B 45 08 8B 50 FC 8B 45 08 83 C0 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 F8 50 8B D3 83 EA 06 8B 45 08 8B 40 FC B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8B D8 EB 02 B3 01 8D 45 F4 50 8B 45 08 8B 40 FC B9 03 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 02 33 DB 8D 55 FC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 07 00 00 00 2E 00 45 00 6E 00 63 00 6F 00 64 00 65 00 00 00 B0 04 02 00 FF FF FF FF 03 00 00 00 58 00 4D 00 4C 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 53 00 49 00 47 00 4E 00 45 00 44 00 00 00 00 00 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "GetActiveScriptParse"
		size = 804
		refs = "0039 GetActiveScriptParse 004f @IntfClear 005e CLSID_StdComponentCategoryMgr 0064 CoCreateInstance 0081 CATID_ActiveScriptParse 0091 OleCheck 00af ClassIDToProgID 00b5 ValidProgID 00d4 @HandleAnyException 00ea @UStrFromWArray 00fb StringToGUID 0114 sInvalidEntryInCategories 0119 LoadResString 012c @DoneExcept 015f RegOpenKey 01a3 GUIDToString 01cb Format 01d9 @UStrToPWChar 01e3 RegQueryValue 0249 RegEnumKey 0267 RegCloseKey 026d @HandleFinally 028c @UStrArrayClr 0294 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 B0 FD FF FF 53 56 57 33 D2 89 95 B0 FD FF FF 89 95 B4 FD FF FF 89 95 B8 FD FF FF 89 95 BC FD FF FF 89 55 FC 89 55 F8 89 55 F4 89 55 F0 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 8B 10 FF 52 44 8D 45 F4 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 01 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A9 00 00 00 80 0F 85 DD 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 6A 00 6A 00 68 ?? ?? ?? ?? 6A 01 8B 45 F4 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? E9 96 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8D 45 D0 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 0B 8B 55 FC 8B 45 EC 8B 08 FF 51 38 33 C0 5A 59 59 64 89 10 EB 5D E9 ?? ?? ?? ?? 8D 85 BC FD FF FF 8D 95 D0 FD FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B 85 BC FD FF FF 8D 95 C0 FD FF FF E8 ?? ?? ?? ?? 8D 85 C0 FD FF FF 8D 55 FC E8 ?? ?? ?? ?? 8D 95 B8 FD FF FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 B8 FD FF FF 8B 45 EC 8B 08 FF 51 38 E8 ?? ?? ?? ?? 8D 45 E8 50 8D 45 D0 50 6A 01 8B 45 F8 50 8B 00 FF 50 0C 85 C0 0F 84 4F FF FF FF E9 23 01 00 00 8D 45 E0 50 68 ?? ?? ?? ?? 68 00 00 00 80 E8 ?? ?? ?? ?? 85 C0 0F 84 08 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB E9 B7 00 00 00 8D 45 F0 50 8D 85 D0 FD FF FF 89 85 C0 FD FF FF C6 85 C4 FD FF FF 0A 8D 95 B4 FD FF FF B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 B4 FD FF FF 89 85 C8 FD FF FF C6 85 CC FD FF FF 11 8D 95 C0 FD FF FF B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E4 50 6A 00 8B 45 F0 E8 ?? ?? ?? ?? 50 8B 45 E0 50 E8 ?? ?? ?? ?? 85 C0 75 4B 8D 85 B0 FD FF FF 8D 95 D0 FD FF FF B9 00 01 00 00 E8 ?? ?? ?? ?? 8B 85 B0 FD FF FF 8D 95 C0 FD FF FF E8 ?? ?? ?? ?? 8D 85 C0 FD FF FF 8D 55 FC E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 84 C0 74 0B 8B 55 FC 8B 45 EC 8B 08 FF 51 38 43 68 00 02 00 00 8D 85 D0 FD FF FF 50 53 8B 45 E0 50 E8 ?? ?? ?? ?? 85 C0 0F 84 2B FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E0 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 B0 FD FF FF BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 5F 5E 5B 8B E5 5D C3 00 13 E0 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 43 00 4C 00 53 00 49 00 44 00 00 00 B0 04 02 00 FF FF FF FF 1C 00 00 00 25 00 73 00 5C 00 49 00 6D 00 70 00 6C 00 65 00 6D 00 65 00 6E 00 74 00 65 00 64 00 20 00 43 00 61 00 74 00 65 00 67 00 6F 00 72 00 69 00 65 00 73 00 5C 00 25 00 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "TActiveScriptLanguages.Create"
		size = 110
		refs = "000a @ClassCreate 0014 ProgIDList 001e _Dn_TStringList 0023 TStringList.Create 0032 GetActiveScriptParse 0050 TAbstractActiveScriptLanguages.Create 005b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 83 3D ?? ?? ?? ?? 00 75 28 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 10 FF 92 A0 00 00 00 A1 ?? ?? ?? ?? 89 46 04 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "TAbstractWebPageInfo.GetFactory"
		size = 4
		altNames = "TAbstractWebPageModuleFactory.GetWebPageInfo TActionBarItem.GetActionBars TActionClient.GetOwningCollection TActionClientItem.GetActionClients TActionListItem.Owner TActiveScriptLanguages.List TBaseWebModuleFactory.GetComponentClass TButtonCategory.GetCategories TCollectionItem.GetOwner TComponent.GetOwner TDBXBaseMetaDataReader.GetContext TDBXBaseMetaDataWriter.GetContext TDBXCommandHandler.GetCommandHandle TDBXDataGeneratorColumn.GetMetaDataColumn TDBXInt32Object.IntValue TDBXLocalChannel.GetChannelInfo TDBXMetaDataProvider.GetWriter TDBXServerCallback.GetConnectionHandler TDBXSocketChannel.GetChannelInfo TDefaultWebModuleFactory.GetComponentClass TGrpButtonItem.GetCollection TJSONConverter.GetSerializedData TParameter.GetParameters TRttiInstanceFieldClassic.GetHandle TRttiInstanceFieldEx.GetHandle TRttiInstanceMethodClassic.GetHandle TRttiInstanceMethodEx.GetHandle TRttiInstancePropertyClassic.GetHandle TRttiInstancePropertyEx.GetHandle TRttiIntfMethod.GetHandle TRttiPackage.GetHandle TRttiRecordField.GetHandle TRttiType.GetHandle TSQLVAR_V1.GetSQLVAR TSQLVAR_V2.GetSQLVAR TScriptError.GetLine TScriptObjectFactories.GetObjectList TWebComponentList.GetOwner TWebContext.GetWebModules TWebDesignContext.GetSession"
	strings:
		$1 = { 8B 40 04 C3 }
	condition:
		$1
}

rule function_98_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 ProgIDList 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16968_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXOracleMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_45037_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_3 0009 _DV_TEMFExportFormat 000e UnRegisterTeeExportFormat"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_44980_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 TeeOnShowEditor 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_44207_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_3 0009 _DV_TBMPExportFormat 000e UnRegisterTeeExportFormat"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_36017_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_15 0009 FFadeManager 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_34659_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_3 0009 FPrinter 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_34092_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 ConverterRegistry 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17686_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXSybaseASEMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17599_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXSybaseASAMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4955_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_3 0009 FClipboard 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16888_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXMySqlMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16715_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXMsSqlMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16633_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXMetaDataWriterFactory 000e TDBXMetaDataWriterFactory.FreeWriterRegistry"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15125_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXInterbaseMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15047_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXInformixMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14932_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXFirebirdMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14353_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXDb2MetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14291_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TDBXDataStoreMetaDataCommandFactory 000e TDBXMetaDataCommandFactory.UnRegisterMetaDataCommandFactory"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14025_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 _DV_TTransportCompressionFilter 000e TTransportFilterFactory.UnregisterFilter"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11655_0 {
	meta:
		name = "Finalization"
		size = 19
		refs = "0002 _DV_2 0009 InputReqClass 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43346_0 {
	meta:
		name = "TEncoding.Destroy@"
		size = 19
		refs = "0002 TEncoding.$ClassInitFlag 0009 _DV_TEncoding 000e TEncoding.FreeEncodings"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29147_0 {
	meta:
		name = "TKeyboardLayouts.Destroy@"
		size = 19
		refs = "0002 TKeyboardLayouts.$ClassInitFlag 0009 TKeyboardLayouts.FKeyboardLayouts 000e TObject.Free"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 75 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_99_0 {
	meta:
		name = "ActiveScriptCat"
		size = 23
		refs = "0002 _DV_2 000a ActiveScriptLanguagesClass 0010 _DV_TActiveScriptLanguages"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_2308_0 {
	meta:
		name = "AutoAdapAS"
		size = 23
		refs = "0002 _DV_1 000a DispatcherClass 0010 _DV_TEnumDispatcherAS"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_3219_0 {
	meta:
		name = "CaptionedDockTree"
		size = 23
		refs = "0002 _DV_3 000a DefaultDockTreeClass 0010 _DV_TCaptionedDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_10314_0 {
	meta:
		name = "DBAdaptImg"
		size = 23
		refs = "0002 _DV_3 000a DataSetAdapterImageFieldClass 0010 _DV_TDataSetAdapterImageField"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_19141_0 {
	meta:
		name = "DockTabSet"
		size = 23
		refs = "0002 _DV_6 000a DefaultDockTreeClass 0010 _DV_TCaptionedTabDockTree"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 0D A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "Succeeded"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 94 C0 C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "Failed"
		size = 9
	strings:
		$1 = { A9 00 00 00 80 0F 95 C0 C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "HResultCode"
		size = 6
		altNames = "ResultCode"
	strings:
		$1 = { 25 FF FF 00 00 C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "HResultFacility"
		size = 9
		altNames = "ResultFacility"
	strings:
		$1 = { C1 E8 10 25 FF 1F 00 00 C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "ResultSeverity"
		size = 4
	strings:
		$1 = { C1 E8 1F C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "MakeResult"
		size = 13
	strings:
		$1 = { C1 E0 1F C1 E2 10 0B C2 0B C8 8B C1 C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "LHashValOfName"
		size = 10
		refs = "0005 LHashValOfNameSys"
	strings:
		$1 = { 52 50 6A 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "LANGIDFROMLCID"
		size = 5
		altNames = "WHashValOfLHashVal"
	strings:
		$1 = { 66 25 FF FF C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "IsHashValCompatible"
		size = 17
	strings:
		$1 = { 25 00 00 FF 00 81 E2 00 00 FF 00 3B C2 0F 94 C0 C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "EventRefFromWpLp"
		size = 4
		altNames = "GetBValue GetMValue HiWord PROPSETHDR_OSVER_KIND WSAGetAsyncError WSAGetSelectError mci_HMS_Second mci_MSF_Frame mci_TMSF_Second"
	strings:
		$1 = { C1 E8 10 C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "ErrCat"
		size = 7
		altNames = "HiByte PROPSETHDR_OSVER_MINOR mci_HMS_Minute mci_MSF_Second mci_TMSF_Minute"
	strings:
		$1 = { 0F B7 C0 C1 E8 08 C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "TStandardColorMap.SetColor"
		size = 53
		refs = "0013 GetHighLightColor 002e TCustomActionBarColorMap.SetColor"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 44 74 1E BA 13 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 43 70 BA 0A 00 00 00 8B C6 E8 ?? ?? ?? ?? 89 43 64 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TStandardColorMap.UpdateColors"
		size = 245
		refs = "0007 TCustomActionBarColorMap.UpdateColors 001f SystemParametersInfo 00a9 GetHighLightColor"
	strings:
		$1 = { 53 51 8B D8 8B C3 E8 ?? ?? ?? ?? 33 C0 89 04 24 6A 00 8D 44 24 04 50 6A 00 68 22 10 00 00 E8 ?? ?? ?? ?? C7 43 3C 0F 00 00 FF C7 43 38 0F 00 00 FF C7 43 40 08 00 00 FF BA 0F 00 00 FF 8B C3 8B 08 FF 51 34 83 3C 24 00 74 09 C7 43 78 04 00 00 FF EB 07 C7 43 78 0F 00 00 FF C7 43 4C 11 00 00 FF C7 43 50 14 00 00 FF C7 43 48 00 00 00 20 BA 08 00 00 FF 8B C3 8B 08 FF 51 38 C7 43 7C 14 00 00 FF C7 83 80 00 00 00 16 00 00 FF C7 83 84 00 00 00 10 00 00 FF C7 83 88 00 00 00 15 00 00 FF BA 13 00 00 00 8B 43 44 E8 ?? ?? ?? ?? 89 43 70 C7 43 58 00 00 00 20 C7 43 60 00 00 00 20 83 3C 24 00 74 09 C7 43 6C 1D 00 00 FF EB 07 C7 43 6C 0D 00 00 FF C7 43 68 0E 00 00 FF C7 43 5C 10 00 00 FF BA 12 00 00 00 8B 43 44 E8 ?? ?? ?? ?? 89 43 64 5A 5B C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TXPColorMap.UpdateColors"
		size = 191
		refs = "0006 TCustomActionBarColorMap.UpdateColors 0083 GetHighLightColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 0F 00 00 FF 8B C3 8B 08 FF 51 34 C7 43 78 05 00 00 FF C7 43 3C 31 69 C6 00 C7 43 38 0F 00 00 FF C7 43 40 08 00 00 FF C7 43 4C 11 00 00 FF C7 43 50 14 00 00 FF C7 43 48 80 80 80 00 BA 08 00 00 FF 8B C3 8B 08 FF 51 38 C7 43 7C FF FF FF 00 C7 83 80 00 00 00 8A 86 7A 00 C7 83 84 00 00 00 FF FF FF 00 C7 83 88 00 00 00 8A 86 7A 00 BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 70 C7 43 58 00 00 00 20 C7 43 60 00 00 00 20 C7 43 6C C6 D3 EF 00 33 C0 89 43 68 C7 43 5C 15 00 00 FF BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 64 5B C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TTwilightColorMap.UpdateColors"
		size = 143
		refs = "0006 TCustomActionBarColorMap.UpdateColors"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 51 34 33 C0 89 43 78 C7 43 4C 11 00 00 FF 33 C0 89 43 50 C7 43 48 15 00 00 FF BA FF FF FF 00 8B C3 8B 08 FF 51 38 33 C0 89 43 7C C7 83 80 00 00 00 15 00 00 FF 33 C0 89 83 84 00 00 00 C7 83 88 00 00 00 15 00 00 FF 33 C0 89 43 70 C7 43 58 00 00 00 20 C7 43 60 FF FF FF 00 C7 43 38 15 00 00 FF 33 C0 89 43 40 C7 43 6C 15 00 00 FF 33 C0 89 43 68 33 C0 89 43 5C 33 C0 89 43 64 5B C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TThemedColorMap.UpdateColors"
		size = 545
		refs = "0008 TCustomActionBarColorMap.UpdateColors 0082 GetHighLightColor 00bd ThemeServices 00c4 TThemeServices.GetTheme 00da GetThemeColor"
	strings:
		$1 = { 53 56 51 8B D8 8B C3 E8 ?? ?? ?? ?? BA 1E 00 00 FF 8B C3 8B 08 FF 51 34 C7 43 78 04 00 00 FF C7 43 3C 64 64 64 00 C7 43 38 1D 00 00 FF C7 43 40 08 00 00 FF C7 43 4C 11 00 00 FF C7 43 50 F4 F7 FC 00 C7 43 48 80 80 80 00 33 D2 8B C3 8B 08 FF 51 38 C7 43 7C F4 F7 FC 00 C7 83 80 00 00 00 64 64 64 00 C7 83 84 00 00 00 F4 F7 FC 00 C7 83 88 00 00 00 64 64 64 00 BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 70 C7 43 58 00 00 00 20 C7 43 60 00 00 00 20 C7 43 6C 1D 00 00 FF 33 C0 89 43 68 C7 43 5C 15 00 00 FF BA 0F 00 00 00 B8 0F 00 00 FF E8 ?? ?? ?? ?? 89 43 64 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F0 85 F6 74 40 54 68 DF 0E 00 00 6A 01 6A 01 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 3C 54 68 DB 0E 00 00 6A 01 6A 01 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 0A 8B 14 24 8B C3 8B 08 FF 51 38 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 F9 00 00 00 54 68 DB 0E 00 00 6A 02 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 40 54 68 DB 0E 00 00 6A 03 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 4C 54 68 DD 0E 00 00 6A 03 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 50 54 68 DD 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 7C 54 68 DF 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 09 8B 04 24 89 83 80 00 00 00 54 68 DD 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 09 8B 04 24 89 83 84 00 00 00 54 68 DF 0E 00 00 6A 00 6A 09 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 09 8B 04 24 89 83 88 00 00 00 54 68 DB 0E 00 00 6A 02 6A 0E 56 A1 ?? ?? ?? ?? 8B 00 FF D0 85 C0 75 06 8B 04 24 89 43 68 5A 5E 5B C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "TCustomButtonControl.Create"
		size = 80
		refs = "000a @ClassCreate 0017 TCustomActionControl.Create 001c TCustomButtonControl.Create 0038 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 46 50 C6 86 F5 01 00 00 01 C6 86 F6 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 80 00 04 00 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "TCustomButtonControl.CalcBounds"
		size = 23
		refs = "0006 TCustomActionControl.CalcBounds 0011 TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 48 42 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "TCustomButtonControl.Click"
		size = 24
		refs = "0012 TCustomActionControl.Click"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 F4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1308_0 {
	meta:
		name = "TCustomMenuButton.Keyed"
		size = 24
		refs = "0012 TCustomActionControl.Keyed"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 F4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "TCustomButtonControl.CMEnabledChanged"
		size = 22
		refs = "0006 TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 94 00 00 00 5B C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "TCustomButtonControl.CMTextChanged"
		size = 90
		refs = "0017 TCustomActionControl.GetActionBar 0039 TControl.SetWidth 0047 TControl.SetHeight 0053 TCustomActionControl.CMTextChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 74 3A 8B C3 E8 ?? ?? ?? ?? 85 C0 74 20 8B C3 E8 ?? ?? ?? ?? 0F B6 80 8F 02 00 00 2C 02 73 0E BA 08 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 18 BA 06 00 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "TCustomButtonControl.CMMouseEnter"
		size = 67
		refs = "0006 TControl.CMMouseEnter 0028 GetCapture"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE F5 01 00 00 00 74 2E 80 BE F3 01 00 00 00 75 25 8B C6 8B 10 FF 52 5C 84 C0 74 1A E8 ?? ?? ?? ?? 85 C0 75 11 C6 86 F3 01 00 00 01 8B C6 8B 10 FF 92 94 00 00 00 5E C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "TCustomButtonControl.CMMouseLeave"
		size = 77
		refs = "0006 TControl.CMMouseLeave"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE F5 01 00 00 00 74 38 8B C6 8B 10 FF 52 5C 84 C0 74 2D C6 86 F3 01 00 00 00 8B C6 8B 10 FF 92 DC 00 00 00 84 C0 75 07 C6 86 F6 01 00 00 00 C6 86 F2 01 00 00 00 8B C6 8B 10 FF 92 94 00 00 00 5E C3 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "TCustomButtonControl.DrawBackground"
		size = 99
		refs = "0036 GetHighLightColor 0048 AllocPatternBitmap 0051 TBrush.SetBitmap 005a TCustomActionControl.DrawBackground"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B C3 8B 10 FF 92 DC 00 00 00 84 C0 74 3F 80 BB F3 01 00 00 00 75 36 8B 83 A8 01 00 00 8B 40 48 8B 40 10 8B 78 14 8B C7 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 A8 01 00 00 8B 70 48 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B D5 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "TCustomButtonControl.Loaded"
		size = 47
		refs = "0007 TControl.Loaded 0028 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 4C 85 C0 74 16 8B C3 8B 10 FF 52 4C 8B D0 B1 01 8B C3 66 BE F0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "TCustomButtonControl.MouseDown"
		size = 92
		refs = "001f TControl.MouseDown 0040 TCustomButtonControl.SetState"
	strings:
		$1 = { 55 8B EC 51 53 56 66 89 4D FE 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 2E 8B C6 8B 10 FF 52 5C 84 C0 74 23 80 BE F1 01 00 00 00 75 13 B2 02 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 90 00 00 00 C6 86 F2 01 00 00 01 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "TCustomButtonControl.MouseMove"
		size = 167
		refs = "001c TControl.MouseMove 0043 TControl.GetClientWidth 0052 TControl.GetClientHeight 009b TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 66 89 55 FE 8B D8 8B 7D 08 57 8B CE 0F B7 55 FE 8B C3 E8 ?? ?? ?? ?? 80 BB F2 01 00 00 00 74 66 80 BB F1 01 00 00 00 75 06 C6 45 FD 00 EB 04 C6 45 FD 03 85 F6 7C 2D 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 22 85 FF 7C 1E 8B C3 E8 ?? ?? ?? ?? 3B F8 7F 13 80 BB F1 01 00 00 00 74 06 C6 45 FD 03 EB 04 C6 45 FD 02 0F B6 45 FD 3A 83 F6 01 00 00 74 26 0F B6 45 FD 88 83 F6 01 00 00 8B C3 8B 10 FF 92 90 00 00 00 EB 10 80 BB F3 01 00 00 00 75 07 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "TCustomButtonControl.MouseUp"
		size = 331
		refs = "0023 TControl.MouseUp 0042 TControl.GetClientWidth 0051 TControl.GetClientHeight 006f TActionClientItem.GetAction 0075 _Dn_TCustomAction 007a @IsClass 00f8 TCustomButtonControl.SetDown 0138 @CallDynaInst 013f TCustomButtonControl.UpdateTracking"
	strings:
		$1 = { 55 8B EC 51 53 56 57 66 89 4D FD 88 55 FF 8B D8 8B 7D 08 8B 75 0C 56 57 0F B7 4D FD 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 80 BB F2 01 00 00 00 0F 84 0F 01 00 00 C6 83 F2 01 00 00 00 85 F6 7C 1A 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 0F 85 FF 7C 0B 8B C3 E8 ?? ?? ?? ?? 3B F8 7E 04 33 C0 EB 02 B0 01 88 45 FC 8B B3 B4 01 00 00 85 F6 74 79 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 63 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 83 78 6C 00 74 25 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 80 B8 95 00 00 00 00 74 3E 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 80 78 69 00 74 2D C6 83 F6 01 00 00 00 C6 83 F3 01 00 00 00 80 7D FC 00 74 5F 0F B6 83 F6 01 00 00 04 FE 2C 02 72 52 8B C3 8B 10 FF 92 90 00 00 00 EB 46 80 7D FC 00 74 26 0F B6 93 F1 01 00 00 80 F2 01 8B C3 E8 ?? ?? ?? ?? 80 BB F1 01 00 00 00 74 26 8B C3 8B 10 FF 92 94 00 00 00 EB 1A 80 BB F1 01 00 00 00 74 07 C6 83 F6 01 00 00 03 8B C3 8B 10 FF 92 94 00 00 00 80 7D FC 00 74 0B 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "TCustomButtonControl.Paint"
		size = 101
		refs = "0009 TCustomActionControl.Paint 002a TPen.SetWidth"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 75 45 8B 83 A8 01 00 00 8B 40 44 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 51 54 54 8B C3 8B 10 FF 92 DC 00 00 00 84 C0 75 0D 80 BB F6 01 00 00 02 74 04 33 C9 EB 02 B1 01 8B C3 5A 8B 18 FF 93 00 01 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TCustomButtonControl.SetActionClient"
		size = 60
		refs = "000b TCustomActionControl.SetActionClient"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 5C 84 C0 74 12 85 F6 74 0E 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 74 04 33 D2 EB 02 B2 01 8B C3 8B 08 FF 51 74 5E 5B C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "TCustomButtonControl.SetAllowAllUp"
		size = 15
	strings:
		$1 = { 3A 90 F0 01 00 00 74 06 88 90 F0 01 00 00 C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "TCustomButtonControl.SetDown"
		size = 106
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 E0 00 00 00 84 C0 75 02 33 DB 3A 9E F1 01 00 00 74 49 80 BE F1 01 00 00 00 74 09 80 BE F0 01 00 00 00 74 37 88 9E F1 01 00 00 84 DB 74 1C 80 BE F6 01 00 00 00 75 0A 8B C6 8B 10 FF 92 90 00 00 00 C6 86 F6 01 00 00 03 EB 11 C6 86 F6 01 00 00 00 8B C6 8B 10 FF 92 94 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "TCustomButtonControl.SetFlat"
		size = 23
	strings:
		$1 = { 3A 90 F5 01 00 00 74 0E 88 90 F5 01 00 00 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "TCustomButtonControl.SetSelected"
		size = 19
		refs = "0006 TCustomActionControl.SetSelected"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 F3 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "TCustomButtonControl.SetState"
		size = 23
	strings:
		$1 = { 3A 90 F6 01 00 00 74 0E 88 90 F6 01 00 00 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "TCustomButtonControl.SetBounds"
		size = 36
		refs = "0011 TControl.SetBounds"
	strings:
		$1 = { 55 8B EC 56 8B F0 8B 45 0C 50 8B 45 08 50 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 A4 00 00 00 5E 5D C2 08 00 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "TCustomButtonControl.UpdateTracking"
		size = 105
		refs = "0023 GetCursorPos 002c FindDragTarget 004e TControl.Perform"
	strings:
		$1 = { 53 56 83 C4 F8 8B F0 F6 46 1C 08 75 57 80 BE F5 01 00 00 00 74 4E 8B C6 8B 10 FF 52 5C 84 C0 74 43 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 3B F0 0F 94 C3 80 F3 01 88 9E F3 01 00 00 84 DB 74 12 6A 00 33 C9 BA 14 B0 00 00 8B C6 E8 ?? ?? ?? ?? EB 10 6A 00 33 C9 BA 13 B0 00 00 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "TCustomButtonControl.WMLButtonDblClk"
		size = 32
		refs = "0006 TControl.WMLButtonDblClk 001a @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE F1 01 00 00 00 74 0B 8B C6 66 BE EB FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "TCustomButtonControl.SetGlyphLayout"
		size = 24
		refs = "0006 TCustomActionControl.SetGlyphLayout 0012 TCustomActionControl.SetSpacing"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? BA 04 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "TCustomButtonControl.DrawLargeGlyph"
		size = 85
		refs = "004a TCustomActionControl.DrawLargeGlyph"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 8B D8 8B 04 24 89 44 24 08 8B 44 24 04 89 44 24 0C F6 43 1C 10 75 1F 80 BB F6 01 00 00 02 74 0E 8B C3 8B 10 FF 92 DC 00 00 00 84 C0 74 08 FF 44 24 08 FF 44 24 0C 8D 54 24 08 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "TCustomButtonControl.CMDialogChar"
		size = 12
		altNames = "TCustomForm.CMUIActivate"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 5E C3 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "TCustomUtilityButton.Create"
		size = 142
		refs = "000e @ClassCreate 001c TCustomButtonControl.Create 003d _Dn_TTimer 0042 TTimer.Create 0053 TTimer.SetEnabled 0059 TCustomUtilityButton.OnDelay 0060 TTimer.SetOnTimer 006c TTimer.SetInterval 0079 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 14 02 00 00 00 C7 83 F8 01 00 00 02 00 00 00 C6 83 15 02 00 00 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 00 02 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? BA EE 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "TCustomUtilityButton.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomActionControl.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 00 02 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "TCustomUtilityButton.Click"
		size = 29
		altNames = "TWinControl.DoExit"
	strings:
		$1 = { 53 66 83 B8 0A 02 00 00 00 74 10 8B D8 8B D0 8B 83 0C 02 00 00 FF 93 08 02 00 00 5B C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "TCustomUtilityButton.CMMouseEnter"
		size = 34
		refs = "0006 TCustomButtonControl.CMMouseEnter 001c TTimer.SetEnabled"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 14 02 00 00 00 74 0D B2 01 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "TCustomUtilityButton.CMMouseLeave"
		size = 25
		refs = "0006 TCustomButtonControl.CMMouseLeave 0013 TTimer.SetEnabled"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 D2 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "TCustomUtilityButton.DrawArrows"
		size = 302
		refs = "0037 Offset 0104 DrawArrow 0123 DrawChevron"
	strings:
		$1 = { 53 56 57 83 C4 E8 33 D2 33 C9 0F B6 98 FC 01 00 00 80 EB 02 72 65 80 EB 02 0F 83 BC 00 00 00 8B 58 48 D1 FB 79 03 83 D3 00 8B B0 F8 01 00 00 2B DE 83 E1 7F 03 1C 8D ?? ?? ?? ?? 8B CB 8B 78 4C D1 FF 79 03 83 D7 00 D1 FE 79 03 83 D6 00 2B FE 80 FA 02 0F 94 C2 83 E2 7F 03 3C 95 ?? ?? ?? ?? 8B D7 89 4C 24 08 89 54 24 0C 8B 54 24 08 89 14 24 8B 54 24 0C 89 54 24 04 EB 60 8B 48 48 D1 F9 79 03 83 D1 00 8B B0 F8 01 00 00 8B DE D1 FB 79 03 83 D3 00 2B CB 80 FA 02 0F 94 C3 83 E3 7F 03 0C 9D ?? ?? ?? ?? 80 FA 02 0F 94 C2 83 E2 7F 8B 14 95 ?? ?? ?? ?? 8B 58 4C D1 FB 79 03 83 D3 00 2B DE 03 D3 89 4C 24 10 89 54 24 14 8B 54 24 10 89 14 24 8B 54 24 14 89 54 24 04 0F B6 90 15 02 00 00 80 EA 01 72 04 74 21 EB 3C 8B 90 F8 01 00 00 52 8D 4C 24 04 0F B6 90 FC 01 00 00 8B 80 A8 01 00 00 E8 ?? ?? ?? ?? EB 1D 8B 90 F8 01 00 00 52 8D 4C 24 04 0F B6 90 FC 01 00 00 8B 80 A8 01 00 00 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "TCustomUtilityButton.MouseDown"
		size = 59
		refs = "001b TTimer.SetEnabled 0030 TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 66 89 4D FE 8B DA 8B F0 84 DB 75 0D 33 D2 8B 86 00 02 00 00 E8 ?? ?? ?? ?? 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "TCustomUtilityButton.OnDelay"
		size = 62
		refs = "0012 TTimer.SetEnabled 002c TTimer.SetInterval 0037 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 0F B6 93 14 02 00 00 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 80 BB 14 02 00 00 00 74 11 8B 93 10 02 00 00 8B 83 00 02 00 00 E8 ?? ?? ?? ?? 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TCustomUtilityButton.SetArrowSize"
		size = 23
	strings:
		$1 = { 3B 90 F8 01 00 00 74 0E 89 90 F8 01 00 00 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TCustomUtilityButton.SetArrowType"
		size = 23
	strings:
		$1 = { 3A 90 15 02 00 00 74 0E 88 90 15 02 00 00 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TCustomUtilityButton.SetDirection"
		size = 23
	strings:
		$1 = { 3A 90 FC 01 00 00 74 0E 88 90 FC 01 00 00 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TCustomUtilityButton.Paint"
		size = 51
		refs = "0006 TCustomButtonControl.Paint 000d TCustomActionControl.GetActionBar 0012 TCustomActionBar.GetColorMap 0023 TPen.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 54 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 04 01 00 00 5B C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TCustomToolScrollBtn.CalcBounds"
		size = 67
		refs = "0006 TCustomActionControl.GetActionBar 0026 TControl.SetHeight 0034 TControl.SetWidth 003d TCustomButtonControl.CalcBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 2C 8B C3 E8 ?? ?? ?? ?? 0F B6 40 5D 48 2C 02 73 0E BA 0D 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 15 BA 0B 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TCustomToolScrollBtn.Create"
		size = 69
		refs = "000a @ClassCreate 0017 TCustomUtilityButton.Create 0022 SMoreButtons 0027 LoadResString 0032 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TCustomToolScrollBtn.DrawArrows"
		size = 314
		refs = "0085 TCustomActionControl.GetActionBar 008a TCustomActionBar.GetColorMap 009b TPen.SetColor 00c5 _DV_TCustomActionToolBar 00ca @IsClass 00d5 TCustomActionToolBar.GetHiddenCount 00f6 DrawChevron 0121 ArrowDirection 0130 DrawArrow"
	strings:
		$1 = { 53 56 83 C4 E0 8B D8 0F B6 83 FC 01 00 00 2C 02 72 31 2C 02 73 61 8B 43 48 D1 F8 79 03 83 D0 00 2B 83 F8 01 00 00 89 44 24 08 C7 44 24 0C 03 00 00 00 8B 44 24 08 89 04 24 8B 44 24 0C 89 44 24 04 EB 34 8B 43 48 D1 F8 79 03 83 D0 00 8B 93 F8 01 00 00 D1 FA 79 03 83 D2 00 2B C2 89 44 24 10 C7 44 24 14 03 00 00 00 8B 44 24 10 89 04 24 8B 44 24 14 89 44 24 04 8B C3 8B 10 FF 52 5C 84 C0 74 1F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 54 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 4C 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B 73 34 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 28 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 1D 8B 83 F8 01 00 00 50 8D 4C 24 04 0F B6 93 FC 01 00 00 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B 43 48 D1 F8 79 03 83 D0 00 2B 83 F8 01 00 00 89 44 24 18 8B 43 4C 83 E8 08 89 44 24 1C 6A 02 0F B6 43 5D 0F B6 90 ?? ?? ?? ?? 8D 4C 24 1C 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 83 C4 20 5E 5B C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TCustomDropDownButton.CalcBounds"
		size = 34
		refs = "0006 TCustomButtonControl.CalcBounds 001c TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 08 01 00 00 8B D0 03 53 48 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TCustomDropDownButton.Click"
		size = 38
		refs = "0020 TCustomButtonControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 10 01 00 00 84 C0 74 0C 8B C3 8B 10 FF 92 14 01 00 00 5B C3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TCustomDropDownButton.CMMouseleave"
		size = 19
		refs = "0006 TCustomButtonControl.CMMouseLeave"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 83 F8 01 00 00 00 5B C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TCustomDropDownButton.DrawDropDownArrow"
		size = 157
		refs = "0015 TCustomActionControl.GetActionBar 001a TCustomActionBar.GetColorMap 002b TPen.SetColor 0063 TControl.GetClientWidth 0072 TControl.GetClientHeight 0094 DrawArrow"
	strings:
		$1 = { 53 56 83 C4 F8 8B D8 8B C3 8B 10 FF 52 5C 84 C0 74 1F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 54 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 4C 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 08 01 00 00 D1 F8 79 03 83 D0 00 50 8B C3 E8 ?? ?? ?? ?? 8B F0 58 2B F0 83 EE 03 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 48 89 34 24 89 44 24 04 6A 02 8D 4C 24 04 B2 03 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TCustomDropDownButton.DrawFrame"
		size = 104
		refs = "0035 TCustomButtonControl.DrawFrame"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B D9 8B F0 83 6C 24 08 09 84 DB 74 0E 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 04 33 C9 EB 02 B1 01 8B D4 8B C6 E8 ?? ?? ?? ?? 8B 44 24 08 89 04 24 83 44 24 08 09 84 DB 75 0D 80 BE F8 01 00 00 00 75 04 33 C9 EB 02 B1 01 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TCustomDropDownButton.DropDownClick"
		size = 274
		refs = "001d _Dn_TCustomActionPopupMenu 0022 @AsClass 002d TCustomDropDownButton.DropDownClick 0068 TControl.ClientToScreen 0096 TCustomButtonControl.SetFlat 009e TCustomActionControl.GetActionBar 00a3 TCustomActionBar.GetColorMap 00c4 TCustomActionPopupMenu.Popup 00eb @HandleFinally 0102 TObject.Free"
	strings:
		$1 = { 55 8B EC 83 C4 E8 89 45 FC 8B 45 FC 8B 10 FF 92 0C 01 00 00 33 C9 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 90 B4 01 00 00 8B 45 F8 8B 08 FF 91 40 01 00 00 8B 45 FC 8B 40 40 89 45 E8 8B 45 FC 8B 40 4C 40 89 45 EC 8D 4D F0 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 89 90 28 03 00 00 8B 45 FC C6 80 F8 01 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 8B 08 FF 91 48 01 00 00 8B 45 FC 8B 55 F0 2B 50 40 8B 4D F4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 F8 01 00 00 00 B2 01 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B E5 5D C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "PICEmptyString"
		size = 6
		altNames = "TCustomDropDownButton.GetDropDownButtonWidth _DF_."
	strings:
		$1 = { B8 09 00 00 00 C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TCustomDropDownButton.GetPopupClass"
		size = 51
		refs = "0007 TCustomActionControl.GetActionBar 0015 _Dn_TActionBarStyleEx 001a @AsClass"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 6C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 51 0C 5E 5B C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TCustomDropDownButton.MouseDown"
		size = 93
		refs = "001f TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 56 66 89 4D FE 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 07 C6 86 F6 01 00 00 00 8B C6 8B 10 FF 92 10 01 00 00 84 C0 74 04 84 DB 74 04 33 C0 EB 02 B0 01 88 86 F8 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TCustomDropDownButton.MouseOverDropDown"
		size = 103
		refs = "000b Mouse 0012 TMouse.GetCursorPos 001f TControl.ScreenToClient 0027 TControl.GetClientHeight 003f TControl.GetClientWidth 0054 Rect 005e PtInRect"
	strings:
		$1 = { 53 83 C4 E0 8B D8 8D 54 24 08 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8D 54 24 08 8B CC 8B C3 E8 ?? ?? ?? ?? 54 8B C3 E8 ?? ?? ?? ?? 50 8D 44 24 18 50 8B C3 8B 10 FF 92 08 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 5A 2B C2 50 8B C3 E8 ?? ?? ?? ?? 8B C8 33 D2 58 E8 ?? ?? ?? ?? 8D 44 24 14 5A E8 ?? ?? ?? ?? 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TCustomDropDownButton.Paint"
		size = 22
		refs = "0006 TCustomButtonControl.Paint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 04 01 00 00 5B C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TCustomActionCombo.BeginAutoDrag"
		size = 18
		refs = "000c @CallDynaInst"
	strings:
		$1 = { 56 8B 80 18 03 00 00 66 BE EE FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "TCustomActionCombo.DesignWndProc"
		size = 24
		refs = "0006 TControl.DesignWndProc"
	strings:
		$1 = { 53 8B DA 8B D3 E8 ?? ?? ?? ?? 8B 13 81 EA 01 02 00 00 75 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "TCustomActionCombo.DragDrop"
		size = 37
	strings:
		$1 = { 55 8B EC 53 56 57 8B FA 8B F0 8B 45 08 50 8B D7 8B 86 18 03 00 00 8B 18 FF 93 A8 00 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TCustomActionCombo.DragOver"
		size = 121
		refs = "0023 TControl.DragOver 003a _Dn_TActionDragObject 003f @IsClass 004b _Dn_TActionItemDragObject 005c _Dn_TCategoryDragObject"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 86 18 03 00 00 83 B8 B4 01 00 00 00 74 11 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 26 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 07 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "TCustomComboControl.Create"
		size = 150
		refs = "000e @ClassCreate 001c TCustomActionControl.Create 0025 _DV_TCustomActionCombo 002a TCustomComboBoxEx.Create 003b TWinControl.SetTabStop 004b TControl.SetWidth 0061 TCustomComboControl.ComboClick 0081 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 F0 01 00 00 8B C6 33 D2 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 BA 64 00 00 00 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 89 98 14 01 00 00 C7 80 10 01 00 00 ?? ?? ?? ?? 89 98 18 03 00 00 F6 40 1C 10 74 07 B2 01 8B 08 FF 51 70 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TCustomComboControl.Destroy"
		size = 56
		refs = "0003 @BeforeDestruction 001a TObject.Free 0026 TCustomActionControl.Destroy 0031 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 86 F0 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "TCustomComboControl.CalcBounds"
		size = 78
		refs = "0006 TCustomActionControl.CalcBounds 0011 TWinControl.HandleAllocated 0036 TControl.SetWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 33 8B C3 8B 10 FF 92 AC 00 00 00 84 C0 74 15 8B 83 F0 01 00 00 8B 50 48 03 53 48 8B C3 E8 ?? ?? ?? ?? EB 10 8B 83 F0 01 00 00 8B 50 48 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TCustomComboControl.Click"
		size = 30
		refs = "0018 TCustomActionControl.Click"
		altNames = "TRibbonCustomControl.Click"
	strings:
		$1 = { 53 8B D8 F6 43 1C 10 74 0C B2 01 8B C3 8B 08 FF 91 F4 00 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TCustomComboControl.CMVisiblechanged"
		size = 27
		refs = "0006 TControl.CMVisibleChanged 0015 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 0F B6 53 59 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TCustomComboControl.ComboClick"
		size = 48
		refs = "0007 TCustomActionControl.GetActionBar 0029 @CallDynaInst"
		altNames = "TRibbonComboControl.ComboClick"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 0B 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TCustomActionCombo.ComboWndProc"
		size = 57
		refs = "000f TControl.GetDragMode 002e TCustomCombo.ComboWndProc"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 01 75 0C 8B 06 05 00 FF FF FF 83 E8 0A 72 0F 8B 45 08 50 8B D6 8B CF 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "TCustomComboControl.Paint"
		size = 49
		refs = "0007 TCustomActionControl.Paint 0018 TWinControl.HandleAllocated"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B B3 F0 01 00 00 85 F6 74 19 8B C6 E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 F0 01 00 00 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "TCustomComboControl.SetActionClient"
		size = 68
		refs = "000c TCustomActionControl.SetActionClient 0024 TActionClientItem.GetAction 003c TControl.SetAction"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 F6 74 2C 8B 83 F0 01 00 00 8B 10 FF 52 4C 8B F8 8B C6 E8 ?? ?? ?? ?? 3B F8 74 14 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 83 F0 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "TCustomComboControl.SetBounds"
		size = 181
		refs = "0018 TControl.SetBounds"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B FA 8B F0 8B 45 0C 50 8B 45 08 50 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 86 F0 01 00 00 85 C0 74 7D 8B 56 4C D1 FA 79 03 83 D2 00 03 56 44 8B 40 4C D1 F8 79 03 83 D0 00 2B D0 89 55 FC 8B C6 8B 10 FF 92 AC 00 00 00 84 C0 74 32 8B 86 F0 01 00 00 8B 40 48 50 8B 86 F0 01 00 00 8B 40 4C 50 8B 96 E4 01 00 00 03 D7 83 C2 05 8B 4D FC 8B 86 F0 01 00 00 8B 18 FF 93 98 00 00 00 EB 21 8B 46 48 50 8B 86 F0 01 00 00 8B 40 4C 50 8B 4D FC 8B D7 8B 86 F0 01 00 00 8B 18 FF 93 98 00 00 00 8B C6 8B 10 FF 92 A4 00 00 00 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TCustomComboControl.SetDragMode"
		size = 31
		refs = "000b TControl.SetDragMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D3 8B 86 F0 01 00 00 8B 08 FF 51 70 5E 5B C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TCustomComboControl.SetParent"
		size = 35
		refs = "001c TControl.SetParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 F0 01 00 00 85 C0 74 07 8B D6 8B 08 FF 51 78 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TCustomActionDockBar.Create"
		size = 117
		refs = "000a @ClassCreate 0017 TCustomActionBar.Create 0020 TControl.SetAlign 0062 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 8B 00 00 00 01 C6 86 F0 02 00 00 00 33 C0 89 86 F8 02 00 00 C6 86 E8 02 00 00 00 C7 86 F4 02 00 00 7D 00 00 00 33 C0 89 86 00 03 00 00 33 C0 89 86 04 03 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "TCustomActionDockBar.CalcDockedWidth"
		size = 59
		refs = "0010 TCustomActionBar.FindFirstVisibleItem 002b TCustomActionBar.FindNextVisibleItem"
	strings:
		$1 = { 53 56 57 8B F0 8B BE C0 02 00 00 03 FF 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 1B 8B 43 44 03 78 48 03 BE 90 02 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 E5 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TCustomActionDockBar.CustomAlignPosition"
		size = 417
		refs = "0020 TCustomActionDockBar.ScrollButtonsVisible 0041 TCustomActionBar.CustomAlignPosition 004e _Dn_TCustomActionControl 0053 @IsClass 0068 TControl.GetClientHeight 0087 TControl.GetClientWidth 00af Rect 0112 TCustomActionBar.GetItems"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B 75 08 8D 7D E8 A5 A5 A5 A5 89 4D F8 8B FA 8B D8 8B 75 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 75 22 8B 45 18 50 8B 45 14 50 8B 45 10 50 56 8D 45 E8 50 8B 4D F8 8B D7 8B C3 E8 ?? ?? ?? ?? E9 4E 01 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 39 01 00 00 83 7D EC 00 75 76 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 50 8D 45 D8 50 B2 01 8B C3 8B 08 FF 91 14 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 14 01 00 00 03 83 C0 02 00 00 8B 93 BC 02 00 00 59 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D8 A5 A5 A5 A5 5F 5E 83 BB F8 02 00 00 00 7E 12 8B 83 04 03 00 00 8B 40 4C 03 83 90 02 00 00 01 46 04 8B 45 EC 3B 83 F8 02 00 00 0F 8C A5 00 00 00 8B 46 04 8B 55 18 89 02 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 8B 55 18 8B 12 03 57 4C 3B C2 7D 04 B0 01 EB 3A 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 48 3B 45 EC 74 25 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 8B 93 00 03 00 00 2B 42 4C 8B 55 18 8B 12 03 57 4C 3B C2 0F 9C C0 EB 02 33 C0 84 C0 74 0B 8B 45 18 C7 00 01 00 00 80 EB 1A 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 48 3B 45 EC 0F 94 C0 88 83 F0 02 00 00 8B 06 8B 55 F8 89 02 8B 46 08 8B 55 14 89 02 8B 47 4C 03 83 90 02 00 00 01 46 04 EB 09 8B 45 18 C7 00 01 00 00 80 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TCustomActionDockBar.Dock"
		size = 136
		refs = "0015 TControl.Dock 0031 TActionBarItem.SetAutoSize 0075 TControl.SetWidth 007e TControl.SetHeight"
	strings:
		$1 = { 56 57 83 C4 F0 8B F1 8D 3C 24 A5 A5 A5 A5 8B F0 8B CC 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 60 84 C0 74 1C 8B 86 78 02 00 00 85 C0 74 07 B2 01 E8 ?? ?? ?? ?? 33 D2 8B C6 8B 08 FF 51 70 EB 42 33 D2 8B C6 8B 08 FF 51 70 8B 86 78 02 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 88 01 00 00 8B 96 C0 02 00 00 03 D2 3B C2 74 09 8B D0 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TCustomActionDockBar.CreateControls"
		size = 46
		refs = "0006 TCustomActionBar.CreateControls"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB E8 02 00 00 00 74 09 80 BB 8F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C3 8B 08 FF 91 80 01 00 00 5B C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TCustomActionDockBar.CreateScrollButtons"
		size = 319
		refs = "0014 TObject.Free 0037 _Dn_TActionBarStyleEx 003c @AsClass 006a TControl.SetAlign 007a TControl.SetHeight 008e TCustomUtilityButton.SetDirection 00a7 TControl.SetVisible 00bd TCustomActionDockBar.ScrollDownClickHandler 0137 TCustomActionDockBar.ScrollUpClickHandler"
	strings:
		$1 = { 53 56 57 8B D8 8D 83 00 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 6C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 14 8B F0 8B CB B2 01 8B C6 FF 50 2C 8B F8 89 BB 00 03 00 00 8B D3 8B C7 8B 08 FF 51 78 B2 02 8B 83 00 03 00 00 E8 ?? ?? ?? ?? BA 0D 00 00 00 8B 83 00 03 00 00 E8 ?? ?? ?? ?? 8B 83 00 03 00 00 C6 80 14 02 00 00 01 B2 03 E8 ?? ?? ?? ?? 8B 83 00 03 00 00 8B 93 F4 02 00 00 89 90 10 02 00 00 33 D2 E8 ?? ?? ?? ?? 8B 83 00 03 00 00 89 98 0C 02 00 00 C7 80 08 02 00 00 ?? ?? ?? ?? 8B CB B2 01 8B C6 FF 50 2C 8B F8 89 BB 04 03 00 00 8B D3 8B C7 8B 08 FF 51 78 B2 01 8B 83 04 03 00 00 E8 ?? ?? ?? ?? BA 0D 00 00 00 8B 83 04 03 00 00 E8 ?? ?? ?? ?? 8B 83 04 03 00 00 C6 80 14 02 00 00 01 B2 02 E8 ?? ?? ?? ?? 8B 83 04 03 00 00 8B 93 F4 02 00 00 89 90 10 02 00 00 33 D2 E8 ?? ?? ?? ?? 8B 83 04 03 00 00 89 98 0C 02 00 00 C7 80 08 02 00 00 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "TCustomActionDockBar.DoEndDock"
		size = 41
		refs = "000d TControl.DoEndDock 0018 TObject.Free"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B 83 EC 02 00 00 E8 ?? ?? ?? ?? 33 C0 89 83 EC 02 00 00 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TCustomActionDockBar.DoStartDock"
		size = 44
		refs = "000c TControl.DoStartDock 0015 _Dn_TToolDockObject 001a TToolDockObject.Create"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 BB EC 02 00 00 89 3E 5F 5E 5B C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TCustomActionDockBar.DoScrollDown"
		size = 22
		refs = "0011 TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 80 B8 F0 02 00 00 00 75 0C 8B 90 F8 02 00 00 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TCustomActionDockBar.DoScrollUp"
		size = 13
		refs = "0008 TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 8B 90 F8 02 00 00 4A E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TCustomActionDockBar.GetSiteInfo"
		size = 96
		refs = "0024 TWinControl.GetSiteInfo 0031 _Dn_TCustomActionControl 0036 @IsClass 0042 _Dn_TSpeedButton"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 75 0C 8D 7D F0 A5 A5 89 4D F8 8B F2 8B 5D 08 8D 55 F0 52 53 8B 4D F8 8B D6 E8 ?? ?? ?? ?? 80 3B 00 74 22 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 03 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TCustomActionDockBar.Loaded"
		size = 53
		refs = "0008 TWinControl.GetControlCount 001b TWinControl.GetControl 0022 TControl.SetHostDockSite 002d TCustomActionBar.Loaded"
	strings:
		$1 = { 53 56 57 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 17 46 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 47 4E 75 EC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "TCustomActionDockBar.MakeLastItemVisible"
		size = 86
		refs = "000c @DynArrayHigh 0015 TCustomActionBar.GetItems 001c TActionClients.GetActionClient 0035 TControl.GetClientHeight 004e TCustomActionDockBar.SetVisibleIndex"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 FC 02 00 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 78 4C 8B 83 FC 02 00 00 03 3C B0 EB 01 4E 8B C3 E8 ?? ?? ?? ?? 8B 93 FC 02 00 00 8B CF 2B 0C B2 3B C1 7F E9 8D 56 01 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "TCustomActionDockBar.GenerateControlHeightLookup"
		size = 174
		refs = "0009 TCustomActionBar.HasItems 0018 TCustomActionBar.GetItems 0030 :TCustomActionDockBar.:1 0035 @DynArraySetLength 005f TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 94 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 56 8D 83 FC 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 ED 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 40 47 33 F6 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 25 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 40 4C 8B 93 FC 02 00 00 89 2C B2 03 83 90 02 00 00 03 E8 46 4F 75 C3 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B 93 FC 02 00 00 89 6C 82 FC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "TCustomActionDockBar.Resize"
		size = 31
		refs = "0006 TCustomActionBar.Resize 000f TWinControl.AlignControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 33 D2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 84 01 00 00 5B C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TCustomActionDockBar.ScrollButtonsVisible"
		size = 48
	strings:
		$1 = { 83 B8 00 03 00 00 00 74 21 83 B8 04 03 00 00 00 74 18 8B 90 00 03 00 00 80 7A 59 00 75 0F 8B 80 04 03 00 00 80 78 59 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TCustomActionDockBar.ScrollDownClickHandler"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 74 01 00 00 C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TCustomActionDockBar.ScrollUpClickHandler"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 78 01 00 00 C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TCustomActionDockBar.SetAllowScrolling"
		size = 53
	strings:
		$1 = { 56 8B F0 3A 96 E8 02 00 00 74 28 88 96 E8 02 00 00 80 BE E8 02 00 00 00 74 09 80 BE 8F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 80 01 00 00 5E C3 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TCustomActionDockBar.SetOrientation"
		size = 46
		refs = "0006 TCustomActionBar.SetOrientation"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 80 BE E8 02 00 00 00 74 09 80 BE 8F 02 00 00 02 74 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 80 01 00 00 5E C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TCustomActionDockBar.SetupScrolling"
		size = 106
		refs = "0036 :TCustomActionDockBar.:1 003b @DynArraySetLength 0051 TObject.Free"
	strings:
		$1 = { 56 8B F0 84 D2 74 20 8B C6 8B 10 FF 92 70 01 00 00 8B C6 8B 10 FF 92 7C 01 00 00 8B C6 8B 10 FF 92 84 01 00 00 5E C3 6A 00 8D 86 FC 02 00 00 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8D 86 04 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 00 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TCustomActionDockBar.SetVisibleIndex"
		size = 38
		refs = "0016 TWinControl.AlignControl"
	strings:
		$1 = { 56 8B F0 3B 96 F8 02 00 00 74 19 89 96 F8 02 00 00 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 84 01 00 00 5E C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TCustomActionDockBar.ShowScrollButtons"
		size = 106
		refs = "000a @DynArrayHigh 0014 TCustomActionBar.GetItems 004f TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B 83 FC 02 00 00 E8 ?? ?? ?? ?? 40 7E 57 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B 93 FC 02 00 00 8B 44 82 FC 8B 93 BC 02 00 00 03 D2 8B 4B 4C 2B CA 3B C1 7E 09 80 BB F0 02 00 00 00 74 04 33 D2 EB 02 B2 01 8B 83 00 03 00 00 E8 ?? ?? ?? ?? 83 BB F8 02 00 00 00 0F 9F C2 8B 83 04 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TCustomActionToolBar.Create"
		size = 140
		refs = "000a @ClassCreate 0017 TCustomActionDockBar.Create 0020 TControl.SetAlign 002c TControl.SetHeight 0038 TCustomActionBar.SetHorzMargin 003f TCustomActionToolBar.Create 0046 TToolWindow.SetEdgeBorders 004f TToolWindow.SetEdgeInner 0058 TToolWindow.SetEdgeOuter 0061 TCustomActionBar.SetHorzSeparator 006a TCustomActionBar.SetVertSeparator 0075 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? BA 1D 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "TCustomActionToolBar.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 0012 TObject.Free 003a TCustomActionBar.Destroy 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 14 03 00 00 E8 ?? ?? ?? ?? 83 BE 1C 03 00 00 00 74 13 8D 86 1C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TCustomActionToolBar.AutoSizingChanged"
		size = 159
		refs = "0007 TCustomActionBar.AutoSizingChanged 000e TCustomActionBar.GetAutoSizing 0031 TControl.SetVisible 0042 TOrderedList.Count 0059 TObject.Free 0098 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C3 8B 10 FF 92 9C 01 00 00 5E 5B C3 8B 83 14 03 00 00 8B 10 FF 52 04 B2 01 E8 ?? ?? ?? ?? 8B B3 14 03 00 00 85 F6 74 0B 8B C6 E8 ?? ?? ?? ?? 85 C0 7F D9 8D 83 14 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 15 8D 83 1C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? EB 11 8B 83 1C 03 00 00 85 C0 74 07 33 D2 8B 08 FF 51 74 8B C3 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TCustomActionToolBar.CalcButtonWidth"
		size = 72
	strings:
		$1 = { 53 56 57 55 8B F8 83 CD FF 8B C7 8B 10 FF 92 30 01 00 00 8B F0 4E 85 F6 7C 27 46 33 DB 8B D3 8B C7 8B 08 FF 91 24 01 00 00 3B 68 48 7D 0F 8B D3 8B C7 8B 08 FF 91 24 01 00 00 8B 68 48 43 4E 75 DC 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TCustomActionToolBar.CalcDockedWidth"
		size = 25
		refs = "0006 TCustomActionDockBar.CalcDockedWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 93 1C 03 00 00 85 D2 74 03 03 42 48 5B C3 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TCustomActionToolBar.CreateControl"
		size = 122
		refs = "000a TCustomActionBar.CreateControl 001c TCustomActionControl.SetSpacing 0037 Rect 0040 TCustomActionControl.SetMargins 0063 TActionClient.GetItems 006e TCustomActionControl.SetSmallIcon"
	strings:
		$1 = { 56 57 83 C4 F0 8B F8 8B C7 E8 ?? ?? ?? ?? 8B F0 85 F6 74 5E BA 03 00 00 00 8B C6 E8 ?? ?? ?? ?? 6A 04 8D 44 24 04 50 B9 04 00 00 00 BA 04 00 00 00 B8 04 00 00 00 E8 ?? ?? ?? ?? 8B D4 8B C6 E8 ?? ?? ?? ?? 8B 87 78 02 00 00 85 C0 74 24 0F B6 50 3D 8B C6 8B 08 FF 91 F0 00 00 00 8B 87 78 02 00 00 E8 ?? ?? ?? ?? 0F B6 50 29 8B C6 E8 ?? ?? ?? ?? 8B C6 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TCustomActionToolBar.CreateControls"
		size = 41
		refs = "0012 TObject.Free 0023 TCustomActionDockBar.CreateControls"
	strings:
		$1 = { 53 8B D8 8D 83 1C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 9C 01 00 00 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TCustomActionToolBar.DisableHiding"
		size = 7
	strings:
		$1 = { FF 80 08 03 00 00 C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TCustomActionBar.GetControlClass"
		size = 27
		altNames = "TCustomActionToolBar.GetControlClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 8B CE 8B D3 8B 18 FF 13 5E 5B C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TCustomActionToolBar.DoDropCategory"
		size = 132
		refs = "0022 TCustomActionBar.FindNearestControl 003a TCollectionItem.GetIndex 0045 TActionDragObject.GetActionCount 0059 TActionDragObject.GetAction 0065 TActionClient.GetItems 006d TCollection.Insert 0073 TActionClientItem.SetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 55 FC 8B F8 33 C0 89 45 F8 89 4D F0 8B 45 08 89 45 F4 8D 55 F0 8B C7 E8 ?? ?? ?? ?? 85 C0 74 17 83 B8 B4 01 00 00 00 74 0E 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 2B 43 33 F6 8B D6 8B 45 FC E8 ?? ?? ?? ?? 50 8B 87 78 02 00 00 E8 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 46 4B 75 D8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TCustomActionToolBar.DoScrollBtnClick"
		size = 624
		refs = "0016 TActionClient.GetItems 001f _Dn_TCustomizeActionClientItem 0024 TActionClientItem.Create 0071 TActionClients.GetActionClient 007c TList.IndexOf 008c TActionClients.Add 0095 TCustomActionToolBar.DoScrollBtnClick 00c4 TActionClientItem.SetUsageCount 00fc _Dn_TCustomizeActionToolBar 0101 @AsClass 010b TCustomActionBar.GetColorMap 0161 TWinControl.AlignControl 01a8 TControl.ClientToScreen 0214 TCustomActionPopupMenu.Popup 022f TObject.Free 0259 @CallDynaInst 025f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 89 45 FC 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 D2 8B 45 F8 8B 08 FF 51 2C 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 7C 46 33 DB 8B 45 FC 8B B8 14 03 00 00 85 FF 74 68 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 50 44 8B 47 04 E8 ?? ?? ?? ?? 40 74 45 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 0F B6 15 ?? ?? ?? ?? 8B C7 8B 08 FF 51 24 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 08 83 CA FF 8B C7 E8 ?? ?? ?? ?? 43 4E 75 87 8B 45 FC 8B 10 FF 92 94 01 00 00 8B 4D FC B2 01 FF 50 2C 8B D8 8B 45 FC 89 98 18 03 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 48 01 00 00 8B 45 FC 8B 80 18 03 00 00 89 83 3C 03 00 00 8B 45 FC 8B 80 1C 03 00 00 89 83 28 03 00 00 8B 55 FC 8B C3 8B 08 FF 51 78 8B 55 F8 8B C3 8B 08 FF 91 40 01 00 00 B2 01 8B C3 8B 08 FF 91 A4 01 00 00 8B C3 33 D2 E8 ?? ?? ?? ?? 8B 45 FC 0F B6 80 8F 02 00 00 2C 02 72 63 74 39 FE C8 0F 85 8E 00 00 00 8B 45 FC 8B 80 1C 03 00 00 8B 50 40 89 55 E8 8B 40 44 8B 55 FC 8B 92 18 03 00 00 2B 42 4C 89 45 EC 8D 4D F0 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? EB 5D 8B 45 FC 8B 80 1C 03 00 00 8B 50 40 89 55 E0 8B 50 44 03 50 4C 89 55 E4 8D 4D F0 8D 55 E0 8B 45 FC E8 ?? ?? ?? ?? EB 35 8B 45 FC 8B 80 1C 03 00 00 8B 50 40 8B 4D FC 8B 89 18 03 00 00 2B 51 48 03 50 48 89 55 D8 8B 50 44 03 50 4C 89 55 DC 8D 4D F0 8D 55 D8 8B 45 FC E8 ?? ?? ?? ?? 8B 4D F4 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 18 03 00 00 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 18 03 00 00 8B 45 F8 8B 40 44 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 66 BE D0 FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 5F 5E 5B 8B E5 5D C3 07 00 00 00 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TCustomActionToolBar.DrawBackground"
		size = 321
		refs = "000a TCustomActionBar.DrawBackground 0023 TCustomActionBar.GetAutoSizing"
	strings:
		$1 = { 53 56 57 55 51 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 30 01 00 00 85 C0 0F 84 1B 01 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 0C 01 00 00 8B C6 8B 10 FF 92 64 01 00 00 8B F8 8B C6 8B 10 FF 92 08 01 00 00 8B D8 85 FF 0F 84 EC 00 00 00 85 DB 0F 84 E4 00 00 00 83 7F 44 00 0F 84 DA 00 00 00 83 7B 44 00 0F 84 D0 00 00 00 8B 47 44 8B 40 44 8B 53 44 3B 42 44 0F 84 BE 00 00 00 80 BE C4 02 00 00 00 74 55 0F B6 86 8F 02 00 00 2C 02 73 4A 8B BE B8 02 00 00 4F 85 FF 7E 3F C7 04 24 01 00 00 00 8B 86 BC 02 00 00 03 C0 8B D0 8B 4B 44 03 51 4C 83 C0 02 8B 4B 44 03 41 4C 8B 0C 24 49 0F AF C1 03 D0 42 B9 02 00 00 00 8B C6 8B 28 FF 95 8C 01 00 00 FF 04 24 4F 75 C8 80 BE D0 02 00 00 00 74 57 0F B6 86 8F 02 00 00 04 FE 2C 02 73 4A 8B BE B4 02 00 00 4F 85 FF 7E 3F C7 04 24 01 00 00 00 8B 86 C0 02 00 00 03 C0 8B D0 8B 4B 44 03 51 48 83 C0 02 8B 4B 44 03 41 48 8B 0C 24 49 0F AF C1 03 D0 42 B9 02 00 00 00 8B C6 8B 28 FF 95 8C 01 00 00 FF 04 24 4F 75 C8 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TCustomActionToolBar.DrawSeparator"
		size = 345
		refs = "003a TControl.GetClientHeight 0093 TControl.GetClientWidth 00c3 TPen.SetWidth 00ca TCustomActionBar.GetColorMap 00d5 TPen.SetColor 0100 TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 57 55 83 C4 D0 8B F9 8B DA 8B F0 0F B6 86 8F 02 00 00 04 FE 2C 02 73 41 8B EB 4D 89 6C 24 10 8B C7 48 89 44 24 14 8B 44 24 10 89 04 24 8B 44 24 14 89 44 24 04 8B C6 E8 ?? ?? ?? ?? 2B C7 40 89 6C 24 18 89 44 24 1C 8B 44 24 18 89 44 24 08 8B 44 24 1C 89 44 24 0C EB 59 33 D2 8B C6 8B 08 FF 91 14 01 00 00 03 C7 89 44 24 20 8B EB 4D 89 6C 24 24 8B 44 24 20 89 04 24 8B 44 24 24 89 44 24 04 B2 01 8B C6 8B 08 FF 91 14 01 00 00 50 8B C6 E8 ?? ?? ?? ?? 2B C7 5A 2B C2 89 44 24 28 89 6C 24 2C 8B 44 24 28 89 44 24 08 8B 44 24 2C 89 44 24 0C 8B 9E 84 02 00 00 BA 01 00 00 00 8B 43 44 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 50 5C 8B 43 44 E8 ?? ?? ?? ?? 8B 4C 24 04 8B 3C 24 8B D7 8B C3 8B 28 FF 55 5C 8B 4C 24 0C 8B 54 24 08 8B C3 8B 28 FF 55 58 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 44 E8 ?? ?? ?? ?? 3B 7C 24 08 75 1F 8B F7 46 8B D6 8B 4C 24 04 8B C3 8B 38 FF 57 5C 8B D6 8B 4C 24 0C 8B C3 8B 18 FF 53 58 EB 1E 8B 4C 24 04 41 8B D7 8B C3 8B 30 FF 56 5C 8B 4C 24 0C 41 8B 54 24 08 8B C3 8B 18 FF 53 58 83 C4 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TCustomActionToolBar.EnableHiding"
		size = 30
		refs = "0019 TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 83 B8 08 03 00 00 00 7E 14 FF 88 08 03 00 00 83 B8 08 03 00 00 00 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TCustomActionToolBar.GetHiddenCount"
		size = 24
		refs = "000f TOrderedList.Count"
	strings:
		$1 = { 33 D2 8B 88 14 03 00 00 85 C9 74 09 8B C1 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "HideItem"
		size = 537
		refs = "004a TControl.GetBoundsRect 0107 TControl.GetClientWidth 01cb TControl.GetClientHeight"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B D8 33 C0 85 DB 0F 84 FF 01 00 00 8B 55 08 8B 52 FC 3B 93 B4 01 00 00 0F 85 A0 00 00 00 8B 55 08 8B 52 F8 0F B6 92 8F 02 00 00 80 EA 01 72 0C 74 22 FE CA 74 54 FE CA 74 35 EB 64 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 3B 42 E8 0F 9D C0 EB 4C 8B 55 08 8B 52 F0 8B 45 08 8B 40 E8 2B D0 8B 4D 08 03 D0 3B 53 40 0F 9D C0 EB 31 8B 55 08 8B 52 F4 8B 45 08 8B 40 EC 2B D0 8B 4D 08 03 D0 3B 53 44 0F 9D C0 EB 16 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 55 08 3B 42 EC 0F 9D C0 84 C0 74 0C 8B 83 B4 01 00 00 80 78 30 00 75 07 33 C0 E9 54 01 00 00 B0 01 E9 4D 01 00 00 8B 55 08 8B 52 F8 0F B6 92 8F 02 00 00 80 EA 01 72 17 74 7D FE CA 0F 84 E2 00 00 00 FE CA 0F 84 A5 00 00 00 E9 24 01 00 00 8B 45 08 8B 40 F8 B2 01 8B 08 FF 91 14 01 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 40 F8 2B B0 C0 02 00 00 58 2B F0 8B 45 08 8B 40 F0 8B 55 08 2B 42 E8 2B F0 8D 55 F0 8B 45 08 8B 40 FC 8B 40 44 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 08 8B 52 F8 03 82 90 02 00 00 03 43 48 3B F0 0F 9C C0 E9 BC 00 00 00 8B 55 08 8B 52 FC 8B 52 44 8B 52 40 8B 4D 08 8B 49 F8 2B 91 90 02 00 00 8B 4D 08 8B 49 F0 8B 45 08 8B 40 E8 2B C8 8B 75 08 03 C8 2B D1 3B 53 48 0F 9C C0 E9 84 00 00 00 8B 55 08 8B 52 FC 8B 52 44 8B 52 44 8B 4D 08 8B 49 F8 2B 91 90 02 00 00 8B 4D 08 8B 49 F4 8B 45 08 8B 40 EC 2B C8 8B 75 08 03 C8 2B D1 3B 53 4C 0F 9C C0 EB 4F 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B 40 F8 2B B0 90 02 00 00 8B 45 08 8B 40 F8 2B B0 BC 02 00 00 8B 45 08 8B 40 F4 8B 55 08 2B 42 EC 2B F0 8D 55 F0 8B 45 08 8B 40 FC 8B 40 44 E8 ?? ?? ?? ?? 8B 45 FC 03 43 4C 3B F0 0F 9C C0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TCustomActionToolBar.HideUnusedItems"
		size = 564
		refs = "000f TCustomActionBar.GetAutoSizing 003e TControl.GetBoundsRect 0051 Rect 0059 TCustomActionBar.FindLastVisibleItem 0072 HideItem 0089 TActionClient.GetItems 0099 TCustomActionBar.FindLeastUsedItem 00ba TCustomActionBar.FindFirstVisibleItem 00d6 _DV_TItemsStack 00db TOrderedList.Create 0104 TCustomActionToolBar.HideUnusedItems 0118 TOrderedList.Push 0122 TControl.SetVisible 013f TOrderedList.Count 01e5 TObject.Free 0203 TCustomActionToolBar.GetHiddenCount"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 89 45 F8 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 0F 85 0F 02 00 00 8B 45 F8 83 B8 08 03 00 00 00 0F 8F FF 01 00 00 8B 45 F8 8B 98 1C 03 00 00 85 DB 74 0C 8D 55 E8 8B C3 E8 ?? ?? ?? ?? EB 11 6A 00 8D 45 E8 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 7F 01 00 00 55 8B 45 FC 8B 40 44 E8 ?? ?? ?? ?? 59 84 C0 0F 84 AC 00 00 00 8B 45 F8 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 80 78 2A 00 74 0E B2 01 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 EB 03 8B 5D FC 85 DB 0F 84 3D 01 00 00 80 7B 30 00 0F 84 33 01 00 00 8B 45 F8 E8 ?? ?? ?? ?? 3B 45 FC 0F 84 22 01 00 00 8B 45 F8 83 B8 14 03 00 00 00 75 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 82 14 03 00 00 8B 45 F8 8B 10 FF 92 9C 01 00 00 8B 45 F8 F6 40 1C 10 74 0F 8B 73 44 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 8B 45 F8 8B 80 14 03 00 00 8B 53 44 E8 ?? ?? ?? ?? 33 D2 8B 43 44 E8 ?? ?? ?? ?? E9 BE 00 00 00 8B 45 F8 8B 98 14 03 00 00 85 DB 0F 84 AD 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 8E 9E 00 00 00 55 8B 45 F8 8B 80 14 03 00 00 8B 10 FF 52 08 E8 ?? ?? ?? ?? 59 84 C0 0F 85 81 00 00 00 8B 45 F8 F6 40 1C 10 74 1C 8B 45 F8 8B 80 14 03 00 00 8B 10 FF 52 08 8B D8 8B 43 50 0B 05 ?? ?? ?? ?? 89 43 50 8B 45 F8 8B 80 14 03 00 00 8B 10 FF 52 08 8B 80 B4 01 00 00 80 78 30 00 74 15 8B 45 F8 8B 80 14 03 00 00 8B 10 FF 52 04 B2 01 E8 ?? ?? ?? ?? 8B 45 F8 8B 98 14 03 00 00 85 DB 74 20 8B C3 E8 ?? ?? ?? ?? 85 C0 75 15 8B 45 F8 05 14 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 45 F8 8B 98 1C 03 00 00 85 DB 74 34 8B 45 F8 F6 40 1C 10 75 1E 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 7F 16 8B 45 F8 8B 80 7C 02 00 00 83 B8 90 00 00 00 00 75 04 33 D2 EB 02 B2 01 8B C3 8B 08 FF 51 74 5E 5B 8B E5 5D C3 00 04 00 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TCustomActionToolBar.ScrollBtnClick"
		size = 27
	strings:
		$1 = { 83 B8 18 03 00 00 00 75 11 83 B8 78 02 00 00 00 74 08 8B 10 FF 92 98 01 00 00 C3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TCustomActionToolBar.SetOrientation"
		size = 215
		refs = "000e TCustomActionToolBar.DisableHiding 0016 TCustomActionToolBar.SetOrientation 003f TControl.SetVisible 004d TOrderedList.Count 0066 TObject.Free 0070 TCustomActionDockBar.SetOrientation 008e ArrowDirection 0093 TCustomUtilityButton.SetDirection 00a4 BtnAlignment 00b2 TControl.SetAlign 00c7 TCustomActionToolBar.EnableHiding 00cd @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 83 B8 14 03 00 00 00 74 29 EB 15 8B 45 FC 8B 80 14 03 00 00 8B 10 FF 52 04 B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 14 03 00 00 E8 ?? ?? ?? ?? 85 C0 7F D9 8B 45 FC 05 14 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 1C 03 00 00 85 C0 74 35 8B 55 FC 0F B6 92 8F 02 00 00 0F B6 92 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 0F B6 80 8F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B 45 FC 8B 80 1C 03 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "TCustomActionToolBar.SetupDropDownBtn"
		size = 244
		refs = "0007 TCustomActionBar.GetAutoSizing 004d SMoreButtons 0052 LoadResString 0060 ArrowDirection 0067 TCustomUtilityButton.SetDirection 0075 BtnAlignment 007c TControl.SetAlign 0089 TCustomActionToolBar.GetHiddenCount 00bb TControl.SetParentColor 00c6 TActionClient.HasBackground 00cf TCustomActionControl.SetTransparent 00ed TCustomActionToolBar.ScrollBtnClick"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 85 DE 00 00 00 83 BB 1C 03 00 00 00 0F 85 D1 00 00 00 83 BB 78 02 00 00 00 0F 84 C4 00 00 00 8B C3 8B 10 FF 92 90 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 1C 03 00 00 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 83 8F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 83 8F 02 00 00 0F B6 90 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? F6 46 1C 10 75 1A 8B C3 E8 ?? ?? ?? ?? 85 C0 7F 13 8B 83 7C 02 00 00 83 B8 90 00 00 00 00 75 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 51 74 8B D3 8B C6 8B 08 FF 51 78 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 83 1C 03 00 00 8B 10 FF 92 F8 00 00 00 89 9E 0C 02 00 00 C7 86 08 02 00 00 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TCustomActionToolBar.Reset"
		size = 143
		refs = "000b TCustomActionToolBar.DisableHiding 0013 TCustomActionToolBar.Reset 003c TControl.SetVisible 004a TOrderedList.Count 0063 TObject.Free 006b TCustomActionBar.Reset 0080 TCustomActionToolBar.EnableHiding 0086 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 83 B8 14 03 00 00 00 74 3E EB 15 8B 45 FC 8B 80 14 03 00 00 8B 10 FF 52 04 B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 14 03 00 00 E8 ?? ?? ?? ?? 85 C0 7F D9 8B 45 FC 05 14 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TCustomActionToolBar.CMColorchanged"
		size = 54
		refs = "0006 TWinControl.CMColorChanged 0015 ColorAdjustLuma"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 33 C9 BA AB FF FF FF 8B 43 6C E8 ?? ?? ?? ?? 89 83 0C 03 00 00 33 C9 BA 55 00 00 00 8B 43 6C E8 ?? ?? ?? ?? 89 83 10 03 00 00 5B C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TCustomActionToolBar.SetBounds"
		size = 44
		refs = "0011 TCustomActionBar.SetBounds 0018 TCustomActionBar.GetAutoSizing 0023 TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 0C 50 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "TCustomActionToolBar.DragDrop"
		size = 74
		refs = "0015 TCustomActionBar.DragDrop 0034 TCustomActionBar.GetAutoSizing 003f TCustomActionToolBar.HideUnusedItems"
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B D8 8B 45 08 50 8B 4D FC 8B C3 E8 ?? ?? ?? ?? 8B 43 48 50 8B 43 4C 50 8B 4B 44 8B 53 40 8B C3 8B 30 FF 96 98 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TCustomActionToolBar.GetPopupClass"
		size = 33
		refs = "000f _Dn_TActionBarStyleEx 0014 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 0C 5B C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TCustomActionToolBar.GetScrollBtnClass"
		size = 31
		refs = "000f _Dn_TActionBarStyleEx 0014 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 14 5B C3 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "RegisterActions"
		size = 53
		refs = "0006 RegisterActionsProc 001b SInvalidActionRegistration 0022 _Dn_Exception 0027 Exception.CreateRes 002c @RaiseExcept"
	strings:
		$1 = { 55 8B EC 53 83 3D ?? ?? ?? ?? 00 74 0C 8B 5D 08 53 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "UnRegisterActions"
		size = 40
		refs = "0002 UnRegisterActionsProc 0012 SInvalidActionUnregistration 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "CreateAction"
		size = 40
		refs = "0002 CreateActionProc 0012 SInvalidActionCreation 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4042_0 {
	meta:
		name = "RegisterNoIcon"
		size = 40
		refs = "0002 RegisterNoIconProc 0012 SRegisterError 0019 _DV_EComponentError 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_49359_0 {
	meta:
		name = "RegisterWebComponents"
		size = 40
		refs = "0002 RegisterWebComponentsProc 0012 sInvalidWebComponentsRegistration 0019 _Dn_Exception 001e Exception.CreateRes 0023 @RaiseExcept"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "EnumRegisteredActions"
		size = 53
		refs = "0005 EnumRegisteredActionsProc 001c SInvalidActionEnumeration 0023 _Dn_Exception 0028 Exception.CreateRes 002d @RaiseExcept"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_49361_0 {
	meta:
		name = "EnumRegisteredWebComponents"
		size = 53
		refs = "0005 EnumRegisteredWebComponentsProc 001c sInvalidWebComponentsEnumeration 0023 _Dn_Exception 0028 Exception.CreateRes 002d @RaiseExcept"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 74 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 17 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "TContainedAction.Destroy"
		size = 51
		refs = "0003 @BeforeDestruction 0015 TCustomActionList.RemoveAction 0021 TBasicAction.Destroy 002c @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 5C 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TContainedAction.GetIndex"
		size = 21
		refs = "000c TList.IndexOf"
	strings:
		$1 = { 8B 50 5C 85 D2 74 0A 8B 52 34 92 E8 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TContainedAction.GetParentComponent"
		size = 16
		refs = "000b TComponent.GetParentComponent"
	strings:
		$1 = { 8B 50 5C 85 D2 74 03 8B C2 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TContainedAction.HasParent"
		size = 15
		refs = "000a TComponent.HasParent"
	strings:
		$1 = { 83 78 5C 00 74 03 B0 01 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TContainedAction.ReadState"
		size = 49
		refs = "000c TComponent.ReadState 0017 _DV_TCustomActionList 001c @IsClass 0029 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 2C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5141_0 {
	meta:
		name = "TTabSheet.ReadState"
		size = 49
		refs = "000c TWinControl.ReadState 0017 _DV_TPageControl 001c @IsClass 0029 TTabSheet.SetPageControl"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 7E 2C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TContainedAction.SetIndex"
		size = 71
		refs = "000a TContainedAction.GetIndex 0030 TList.Delete 003f TList.Insert"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7C 31 8B 53 5C 8B 7A 34 8B 57 08 85 F6 7D 02 33 F6 3B D6 7F 03 8B F2 4E 3B C6 74 17 8B D7 92 E8 ?? ?? ?? ?? 8B 43 5C 8B 40 34 8B CB 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TContainedAction.SetCategory"
		size = 43
		refs = "000c @UStrEqual 0018 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 58 E8 ?? ?? ?? ?? 74 16 8D 43 58 8B D6 E8 ?? ?? ?? ?? 8B 43 5C 85 C0 74 05 8B 10 FF 52 34 5E 5B C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TContainedAction.SetActionList"
		size = 40
		refs = "0014 TCustomActionList.RemoveAction 0021 TCustomActionList.AddAction"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 5C 3B F0 74 18 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 85 F6 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TContainedAction.SetParentComponent"
		size = 41
		refs = "0010 _DV_TCustomActionList 0015 @IsClass 0022 TContainedAction.SetActionList"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 01 75 1A 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TContainedAction.Execute"
		size = 85
		refs = "0015 @CallDynaInst 001e Application 0027 TApplication.ExecuteAction 0032 TBasicAction.Execute 0044 SendAppMessage"
	strings:
		$1 = { 53 56 57 8B D8 8B 7B 5C 85 FF 74 11 8B D3 8B C7 66 BE F3 FF E8 ?? ?? ?? ?? 84 C0 75 32 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? 84 C0 75 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 15 8B CB 33 D2 B8 40 B0 00 00 E8 ?? ?? ?? ?? 48 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TContainedAction.Update"
		size = 80
		refs = "0019 Application 0022 TApplication.UpdateAction 002d TBasicAction.Update 003f SendAppMessage"
	strings:
		$1 = { 53 56 8B D8 8B 73 5C 85 F6 74 0D 8B D3 8B C6 8B 08 FF 51 30 84 C0 75 33 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? 84 C0 75 21 8B C3 E8 ?? ?? ?? ?? 84 C0 75 16 8B CB 33 D2 B8 3F B0 00 00 E8 ?? ?? ?? ?? 48 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TActionListEnumerator.Create"
		size = 67
		refs = "000b @ClassCreate 001a TObject.Create 002f @AfterConstruction"
		altNames = "TCollectionEnumerator.Create TComponentEnumerator.Create TFavoriteLinkItemsEnumerator.Create TFieldsEnumerator.Create TInterfaceListEnumerator.Create TKeyTipListEnumerator.Create TListEnumerator.Create TListItemsEnumerator.Create TMenuItemEnumerator.Create TStringsEnumerator.Create TTaskDialogButtonsEnumerator.Create TToolBarEnumerator.Create TTreeNodesEnumerator.Create TWideStringsEnumerator.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? C7 47 04 FF FF FF FF 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TActionListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TCustomActionList.GetAction"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4178_0 {
	meta:
		name = "TCollectionEnumerator.GetCurrent"
		size = 12
		refs = "0007 TCollection.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4666_0 {
	meta:
		name = "TComponentEnumerator.GetCurrent"
		size = 12
		refs = "0007 TComponent.GetComponent"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18737_0 {
	meta:
		name = "TFavoriteLinkItemsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TFavoriteLinkItems.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8965_0 {
	meta:
		name = "TFieldsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TFields.GetField"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35783_0 {
	meta:
		name = "TKeyTipListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TKeyTipList.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4073_0 {
	meta:
		name = "TListEnumerator.GetCurrent"
		size = 12
		refs = "0007 TList.Get"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5848_0 {
	meta:
		name = "TListItemsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TListItems.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30009_0 {
	meta:
		name = "TMenuItemEnumerator.GetCurrent"
		size = 12
		refs = "0007 TMenuItem.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18816_0 {
	meta:
		name = "TTaskDialogButtonsEnumerator.GetCurrent"
		size = 12
		refs = "0007 TTaskDialogButtons.GetItem"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6115_0 {
	meta:
		name = "TToolBarEnumerator.GetCurrent"
		size = 12
		refs = "0007 TToolBar.GetButton"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5399_0 {
	meta:
		name = "TTreeNodesEnumerator.GetCurrent"
		size = 12
		refs = "0007 TTreeNodes.GetNodeFromIndex"
	strings:
		$1 = { 8B 50 04 8B 40 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TActionListEnumerator.MoveNext"
		size = 27
		refs = "0007 TCustomActionList.GetActionCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4179_0 {
	meta:
		name = "TCollectionEnumerator.MoveNext"
		size = 27
		refs = "0007 TCollection.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4667_0 {
	meta:
		name = "TComponentEnumerator.MoveNext"
		size = 27
		refs = "0007 TComponent.GetComponentCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_8966_0 {
	meta:
		name = "TFieldsEnumerator.MoveNext"
		size = 27
		refs = "0007 TFields.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_4117_0 {
	meta:
		name = "TInterfaceListEnumerator.MoveNext"
		size = 27
		refs = "0007 TInterfaceList.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_35784_0 {
	meta:
		name = "TKeyTipListEnumerator.MoveNext"
		size = 27
		refs = "0007 TKeyTipList.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_5849_0 {
	meta:
		name = "TListItemsEnumerator.MoveNext"
		size = 27
		refs = "0007 TListItems.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_30010_0 {
	meta:
		name = "TMenuItemEnumerator.MoveNext"
		size = 27
		refs = "0007 TMenuItem.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_6116_0 {
	meta:
		name = "TToolBarEnumerator.MoveNext"
		size = 27
		refs = "0007 TToolBar.GetButtonCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_5400_0 {
	meta:
		name = "TTreeNodesEnumerator.MoveNext"
		size = 27
		refs = "0007 TTreeNodes.GetCount"
	strings:
		$1 = { 53 8B D8 8B 43 08 E8 ?? ?? ?? ?? 48 3B 43 04 0F 9F C0 84 C0 74 03 FF 43 04 5B C3 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "TCustomActionList.Create"
		size = 108
		refs = "000e @ClassCreate 001c TComponent.Create 0023 _Dn_TList 0028 TObject.Create 0032 _Dn_TChangeLink 0046 TCustomActionList.ImageListChange 0057 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 34 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 38 89 5E 0C C7 46 08 ?? ?? ?? ?? C6 43 58 00 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TCustomActionList.Destroy"
		size = 86
		refs = "0004 @BeforeDestruction 0010 TObject.Free 0019 TList.Last 0043 TComponent.Destroy 004e @ClassDestroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B 47 38 E8 ?? ?? ?? ?? EB 0C 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 77 34 83 7E 08 00 7F EB 8D 47 34 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TCustomActionList.GetChildren"
		size = 71
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 89 55 F8 89 45 FC 8B 45 FC 8B 40 34 8B 58 08 4B 85 DB 7C 23 43 33 F6 8B 45 FC 8B 40 34 8B 40 04 8B 04 B0 8B 50 04 3B 55 F8 75 08 8B D0 8B 45 0C FF 55 08 46 4B 75 E0 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TCustomActionList.SetChildOrder"
		size = 47
		refs = "000f TList.IndexOf 001b _DV_TContainedAction 0020 @AsClass 0027 TContainedAction.SetIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 34 E8 ?? ?? ?? ?? 85 C0 7C 14 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TCustomActionList.GetAction"
		size = 19
		refs = "000c TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 34 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TCustomActionList.GetActionCount"
		size = 7
		altNames = "TMultiCaster.GetCount TWebContainedContainerComponent.GetWebComponents TWebContainerComponent.GetWebComponents"
	strings:
		$1 = { 8B 40 34 8B 40 08 C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "TCustomActionList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TActionListEnumerator 000a TActionListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_32808_0 {
	meta:
		name = "TAutoObject.CreateAutoDispatch"
		size = 15
		refs = "0005 _DV_TAutoDispatch 000a TAutoDispatch.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4191_0 {
	meta:
		name = "TCollection.GetEnumerator"
		size = 15
		refs = "0005 _DV_TCollectionEnumerator 000a TCollectionEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11410_0 {
	meta:
		name = "TColumn.CreateTitle"
		size = 15
		refs = "0005 _DV_TColumnTitle 000a TColumnTitle.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4691_0 {
	meta:
		name = "TComponent.GetEnumerator"
		size = 15
		refs = "0005 _DV_TComponentEnumerator 000a TComponentEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_48580_0 {
	meta:
		name = "TCustomAdapter.CreateErrorsList"
		size = 15
		refs = "0005 _DV_TAdapterErrorsList 000a TAdapterErrorsList.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11515_0 {
	meta:
		name = "TCustomDBGrid.CreateDataLink"
		size = 15
		refs = "0005 _DV_TGridDataLink 000a TGridDataLink.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11516_0 {
	meta:
		name = "TCustomDBGrid.CreateEditor"
		size = 15
		refs = "0005 _DV_TDBGridInplaceEdit 000a TDBGridInplaceEdit.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_24890_0 {
	meta:
		name = "TCustomGrid.CreateEditor"
		size = 15
		refs = "0005 _DV_TInplaceEdit 000a TInplaceEdit.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5325_0 {
	meta:
		name = "TCustomHeaderControl.CreateSections"
		size = 15
		refs = "0005 _DV_THeaderSections 000a THeaderSections.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5935_0 {
	meta:
		name = "TCustomListView.CreateListItems"
		size = 15
		refs = "0005 _DV_TListItems 000a TListItems.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5251_0 {
	meta:
		name = "TCustomStatusBar.CreatePanels"
		size = 15
		refs = "0005 _DV_TStatusPanels 000a TStatusPanels.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5518_0 {
	meta:
		name = "TCustomTreeView.CreateNodes"
		size = 15
		refs = "0005 _DV_TTreeNodes 000a TTreeNodes.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13597_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXParameter"
		size = 15
		refs = "0005 _DV_TDBXParameter 000a TDBXParameter.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13598_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXProperties"
		size = 15
		refs = "0005 _DV_TDBXProperties 000a TDBXProperties.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13599_0 {
	meta:
		name = "TDBXDriverHelp.CreateTDBXValueType"
		size = 15
		refs = "0005 _DV_TDBXValueType 000a TDBXValueType.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17022_0 {
	meta:
		name = "TDBXObjectStore.Keys"
		size = 15
		refs = "0005 _Dn_TStringsEnumerator 000a TStringsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22997_0 {
	meta:
		name = "TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TPairEnumerator 000a TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23289_0 {
	meta:
		name = "TDictionary<Controls.TControl,GestureMgr.TGestureCollection>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<Controls.TControl,GestureMgr.TGestureCollection>.TPairEnumerator 000a TDictionary<Controls.TControl,GestureMgr.TGestureCollection>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15524_0 {
	meta:
		name = "TDictionary<System.Integer,System.Integer>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.Integer,System.Integer>.TPairEnumerator 000a TDictionary<System.Integer,System.Integer>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_36833_0 {
	meta:
		name = "TDictionary<System.Pointer,Rtti.TRttiObject>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.Pointer,Rtti.TRttiObject>.TPairEnumerator 000a TDictionary<System.Pointer,Rtti.TRttiObject>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15584_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TConverterEvent>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TPairEnumerator 000a TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15785_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TReverterEvent>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TPairEnumerator 000a TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15725_0 {
	meta:
		name = "TDictionary<System.string,System.TObject>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.string,System.TObject>.TPairEnumerator 000a TDictionary<System.string,System.TObject>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_36775_0 {
	meta:
		name = "TDictionary<System.string,TypInfo.PTypeInfo>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<System.string,TypInfo.PTypeInfo>.TPairEnumerator 000a TDictionary<System.string,TypInfo.PTypeInfo>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20175_0 {
	meta:
		name = "TDictionary<ToolsAPI.IOTAProject,System.Integer>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<ToolsAPI.IOTAProject,System.Integer>.TPairEnumerator 000a TDictionary<ToolsAPI.IOTAProject,System.Integer>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_36713_0 {
	meta:
		name = "TDictionary<TypInfo.PTypeInfo,System.string>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TDictionary<TypInfo.PTypeInfo,System.string>.TPairEnumerator 000a TDictionary<TypInfo.PTypeInfo,System.string>.TPairEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43366_0 {
	meta:
		name = "TEncoding.GetEncoding"
		size = 15
		refs = "0005 _DV_TMBCSEncoding 000a TMBCSEncoding.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18741_0 {
	meta:
		name = "TFavoriteLinkItems.GetEnumerator"
		size = 15
		refs = "0005 _DV_TFavoriteLinkItemsEnumerator 000a TFavoriteLinkItemsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_8981_0 {
	meta:
		name = "TFields.GetEnumerator"
		size = 15
		refs = "0005 _DV_TFieldsEnumerator 000a TFieldsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4127_0 {
	meta:
		name = "TInterfaceList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TInterfaceListEnumerator 000a TInterfaceListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4086_0 {
	meta:
		name = "TList.GetEnumerator"
		size = 15
		refs = "0005 _DV_TListEnumerator 000a TListEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23357_0 {
	meta:
		name = "TList<Controls.TControl>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Controls.TControl>.TEnumerator 000a TList<Controls.TControl>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23642_0 {
	meta:
		name = "TList<Controls.TCustomGestureCollectionItem>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Controls.TCustomGestureCollectionItem>.TEnumerator 000a TList<Controls.TCustomGestureCollectionItem>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23249_0 {
	meta:
		name = "TList<Controls.TCustomGestureManager>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Controls.TCustomGestureManager>.TEnumerator 000a TList<Controls.TCustomGestureManager>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13866_0 {
	meta:
		name = "TList<DBXCommon.TDBXScheduler.TDBXSchedulerRec>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<DBXCommon.TDBXScheduler.TDBXSchedulerRec>.TEnumerator 000a TList<DBXCommon.TDBXScheduler.TDBXSchedulerRec>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19049_0 {
	meta:
		name = "TList<Direct2D.TDirect2DGraphicsObject>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Direct2D.TDirect2DGraphicsObject>.TEnumerator 000a TList<Direct2D.TDirect2DGraphicsObject>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23690_0 {
	meta:
		name = "TList<Gestures.TGesturePoint>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Gestures.TGesturePoint>.TEnumerator 000a TList<Gestures.TGesturePoint>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29199_0 {
	meta:
		name = "TList<Keyboard.TCustomKeyboardButton>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Keyboard.TCustomKeyboardButton>.TEnumerator 000a TList<Keyboard.TCustomKeyboardButton>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29247_0 {
	meta:
		name = "TList<Keyboard.TCustomTouchKeyboard.TChangeState>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Keyboard.TCustomTouchKeyboard.TChangeState>.TEnumerator 000a TList<Keyboard.TCustomTouchKeyboard.TChangeState>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29295_0 {
	meta:
		name = "TList<KeyboardTypes.TKeyData>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<KeyboardTypes.TKeyData>.TEnumerator 000a TList<KeyboardTypes.TKeyData>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29516_0 {
	meta:
		name = "TList<KeyboardTypes.TKeyboardLanguage>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<KeyboardTypes.TKeyboardLanguage>.TEnumerator 000a TList<KeyboardTypes.TKeyboardLanguage>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29420_0 {
	meta:
		name = "TList<KeyboardTypes.TVirtualKey>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<KeyboardTypes.TVirtualKey>.TEnumerator 000a TList<KeyboardTypes.TVirtualKey>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29564_0 {
	meta:
		name = "TList<KeyboardTypes.TVirtualKeyLayout>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<KeyboardTypes.TVirtualKeyLayout>.TEnumerator 000a TList<KeyboardTypes.TVirtualKeyLayout>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_29468_0 {
	meta:
		name = "TList<KeyboardTypes.TVirtualKeys>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<KeyboardTypes.TVirtualKeys>.TEnumerator 000a TList<KeyboardTypes.TVirtualKeys>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_37147_0 {
	meta:
		name = "TList<Rtti.TRttiField>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Rtti.TRttiField>.TEnumerator 000a TList<Rtti.TRttiField>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_37196_0 {
	meta:
		name = "TList<Rtti.TRttiManagedField>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Rtti.TRttiManagedField>.TEnumerator 000a TList<Rtti.TRttiManagedField>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_37098_0 {
	meta:
		name = "TList<Rtti.TRttiMethod>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Rtti.TRttiMethod>.TEnumerator 000a TList<Rtti.TRttiMethod>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_37049_0 {
	meta:
		name = "TList<Rtti.TRttiProperty>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Rtti.TRttiProperty>.TEnumerator 000a TList<Rtti.TRttiProperty>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_26774_0 {
	meta:
		name = "TList<System.AnsiString>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<System.AnsiString>.TEnumerator 000a TList<System.AnsiString>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_36990_0 {
	meta:
		name = "TList<System.TCustomAttribute>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<System.TCustomAttribute>.TEnumerator 000a TList<System.TCustomAttribute>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_23067_0 {
	meta:
		name = "TList<Types.TPoint>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TList<Types.TPoint>.TEnumerator 000a TList<Types.TPoint>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5856_0 {
	meta:
		name = "TListItems.GetEnumerator"
		size = 15
		refs = "0005 _DV_TListItemsEnumerator 000a TListItemsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10263_0 {
	meta:
		name = "TLocateParamsList.Add"
		size = 15
		refs = "0005 _DV_TLocateParams 000a TLocateParams.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30109_0 {
	meta:
		name = "TMenu.CreateMenuItem"
		size = 15
		refs = "0005 _DV_TMenuItem 000a TMenuItem.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_30030_0 {
	meta:
		name = "TMenuItem.GetEnumerator"
		size = 15
		refs = "0005 _DV_TMenuItemEnumerator 000a TMenuItemEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_40036_0 {
	meta:
		name = "TServerSocketThread.CreateThread"
		size = 15
		refs = "0005 _DV_TClientSocketThread 000a TClientSocketThread.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15658_0 {
	meta:
		name = "TStack<DBXJSON.TJSONAncestor>.GetEnumerator"
		size = 15
		refs = "0005 _DV_TStack<DBXJSON.TJSONAncestor>.TEnumerator 000a TStack<DBXJSON.TJSONAncestor>.TEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4237_0 {
	meta:
		name = "TStrings.GetEnumerator"
		size = 15
		refs = "0005 _DV_TStringsEnumerator 000a TStringsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18822_0 {
	meta:
		name = "TTaskDialogButtons.GetEnumerator"
		size = 15
		refs = "0005 _DV_TTaskDialogButtonsEnumerator 000a TTaskDialogButtonsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_6141_0 {
	meta:
		name = "TToolBar.GetEnumerator"
		size = 15
		refs = "0005 _DV_TToolBarEnumerator 000a TToolBarEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5424_0 {
	meta:
		name = "TTreeNodes.GetEnumerator"
		size = 15
		refs = "0005 _DV_TTreeNodesEnumerator 000a TTreeNodesEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50768_0 {
	meta:
		name = "TWideStrings.GetEnumerator"
		size = 15
		refs = "0005 _DV_TWideStringsEnumerator 000a TWideStringsEnumerator.Create"
	strings:
		$1 = { 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TCustomActionList.SetAction"
		size = 30
		refs = "000f TList.Get"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B 43 34 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TCustomActionList.SetImages"
		size = 51
		refs = "0011 TCustomImageList.UnRegisterChanges 0022 TCustomImageList.RegisterChanges 002c TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 3C 85 C0 74 08 8B 53 38 E8 ?? ?? ?? ?? 8B C6 89 43 3C 85 C0 74 12 8B 53 38 E8 ?? ?? ?? ?? 8B D3 8B 43 3C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TCustomActionList.ImageListChange"
		size = 11
	strings:
		$1 = { 3B 50 3C 75 05 8B 10 FF 52 34 C3 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TCustomActionList.Notification"
		size = 77
		refs = "0010 TComponent.Notification 0033 _DV_TContainedAction 0038 @IsClass 0045 TCustomActionList.RemoveAction"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 30 3B 7E 3C 75 0B 33 D2 8B C6 8B 08 FF 51 38 EB 20 83 7E 34 00 74 1A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TCustomActionList.AddAction"
		size = 31
		refs = "000c TList.Add 0018 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 34 E8 ?? ?? ?? ?? 89 5E 5C 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TCustomActionList.RemoveAction"
		size = 39
		refs = "000e TList.RemoveItem 001b TComponent.RemoveFreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 33 C9 8B 43 34 E8 ?? ?? ?? ?? 85 C0 7C 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 5C 5E 5B C3 }
	condition:
		$1
}

rule function_639_0 {
	meta:
		name = "TCustomActionList.Change"
		size = 102
		refs = "0041 _Dn_TForm 0046 @IsClass"
	strings:
		$1 = { 53 56 57 8B D8 66 83 7B 42 00 74 08 8B D3 8B 43 44 FF 53 40 8B 43 34 8B 70 08 4E 85 F6 7C 15 46 33 FF 8B 43 34 8B 40 04 8B 04 B8 8B 10 FF 52 34 47 4E 75 EE F6 43 1C 10 74 28 8B 73 04 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 83 BE BC 02 00 00 00 74 0B 8B 86 BC 02 00 00 8B 10 FF 52 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "TCustomActionList.IsShortCut"
		size = 164
		refs = "0012 IsAltGRPressed 001e KeyDataToShiftState 002b ShortCut 0057 _DV_TCustomAction 005c @IsClass 0079 TCustomAction.GetSecondaryShortCuts 0080 TShortCutList.IndexOfShortCut"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B DA 89 04 24 C6 44 24 04 00 E8 ?? ?? ?? ?? 84 C0 75 7E 8B 43 08 E8 ?? ?? ?? ?? 8B F0 0F B7 43 04 8B D6 E8 ?? ?? ?? ?? 8B E8 66 85 ED 74 62 8B 04 24 8B 40 34 8B 70 08 4E 85 F6 7C 54 46 33 FF 8B 04 24 8B 40 34 8B 40 04 8B 1C B8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 66 3B AB 84 00 00 00 74 1A 83 BB 90 00 00 00 00 74 1E 8B C3 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 40 74 0D 8B C3 8B 10 FF 52 54 88 44 24 04 EB 04 47 4E 75 AF 0F B6 44 24 04 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "TCustomActionList.ExecuteAction"
		size = 30
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 4A 00 74 0A 8B CC 8B D8 8B 43 4C FF 53 48 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TCustomActionList.UpdateAction"
		size = 30
	strings:
		$1 = { 53 51 C6 04 24 00 66 83 78 52 00 74 0A 8B CC 8B D8 8B 43 54 FF 53 50 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "TCustomActionList.SetState"
		size = 163
		refs = "0060 TCustomAction.SetEnabled"
	strings:
		$1 = { 53 56 57 55 51 88 14 24 8B D8 0F B6 43 58 3A 04 24 0F 84 86 00 00 00 88 44 24 01 0F B6 04 24 88 43 58 3C 01 74 77 8B 43 34 8B 70 08 4E 85 F6 7C 5D 46 33 ED 8B 43 34 8B 40 04 8B 3C A8 0F B6 04 24 2C 01 72 06 FE C8 74 24 EB 3F 85 FF 74 15 80 7C 24 01 02 75 0E 0F B6 97 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C7 8B 10 FF 52 48 EB 1D 85 FF 74 19 80 3C 24 02 75 13 0F B6 47 6A 88 87 94 00 00 00 B2 01 8B C7 E8 ?? ?? ?? ?? 45 4E 75 A6 66 83 7B 62 00 74 08 8B D3 8B 43 64 FF 53 60 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "TActionLink.IsCaptionLinked"
		size = 19
		refs = "0008 _DV_TCustomAction 000d @IsClass"
		altNames = "TActionLink.IsCheckedLinked TActionLink.IsEnabledLinked TActionLink.IsGroupIndexLinked TActionLink.IsHelpContextLinked TActionLink.IsHelpLinked TActionLink.IsHintLinked TActionLink.IsImageIndexLinked TActionLink.IsShortCutLinked TActionLink.IsVisibleLinked"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7485_0 {
	meta:
		name = "TControlActionLink.IsDropdownMenuLinked"
		size = 19
		refs = "0008 _DV_TCustomControlAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7487_0 {
	meta:
		name = "TControlActionLink.IsEnableDropdownLinked"
		size = 19
		refs = "0008 _DV_TCustomControlAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_29644_0 {
	meta:
		name = "TListActionLink.IsActiveLinked"
		size = 19
		refs = "0008 _DV_TCustomListAction 000d @IsClass"
	strings:
		$1 = { 53 8B D8 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TCustomAction.Create"
		size = 82
		refs = "000a @ClassCreate 0017 TBasicAction.Create 003f @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 6A 01 C7 86 80 00 00 00 FF FF FF FF C6 86 86 00 00 00 01 33 C0 89 86 90 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TCustomAction.Destroy"
		size = 87
		refs = "0003 @BeforeDestruction 0012 TObject.Free 0045 TContainedAction.Destroy 0050 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 98 00 00 00 E8 ?? ?? ?? ?? 8B 86 9C 00 00 00 E8 ?? ?? ?? ?? 83 BE 90 00 00 00 00 74 13 8D 86 90 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "TCustomAction.AssignTo"
		size = 266
		refs = "000b _DV_TCustomAction 0010 @IsClass 0028 TCustomAction.SetAutoCheck 0032 TCustomAction.SetCaption 003d TCustomAction.SetChecked 0048 TCustomAction.SetEnabled 0052 TCustomAction.SetGroupIndex 0071 TCustomAction.SetHelpType 007b TCustomAction.SetHint 0088 TCustomAction.SetImageIndex 008f TCustomAction.GetSecondaryShortCuts 0098 TCustomAction.SetSecondaryShortCuts 00a6 TCustomAction.SetShortCut 00b4 TCustomAction.SetVisible 0102 TPersistent.AssignTo"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 E1 00 00 00 0F B6 93 95 00 00 00 8B FE 8B C7 E8 ?? ?? ?? ?? 8B 53 64 8B C7 E8 ?? ?? ?? ?? 0F B6 53 69 8B C7 E8 ?? ?? ?? ?? 0F B6 53 6A 8B C7 E8 ?? ?? ?? ?? 8B 53 6C 8B C7 E8 ?? ?? ?? ?? 8B 53 74 8B C7 8B 08 FF 51 4C 8B 53 78 8B C7 8B 08 FF 51 50 0F B6 53 70 8B C7 E8 ?? ?? ?? ?? 8B 53 7C 8B C7 E8 ?? ?? ?? ?? 8B 93 80 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 0F B7 93 84 00 00 00 8B C7 E8 ?? ?? ?? ?? 0F B6 93 86 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 43 0C 89 47 0C FF 73 44 FF 73 40 8B C7 8B 10 FF 52 38 8B 83 88 00 00 00 89 87 88 00 00 00 8B 83 8C 00 00 00 89 87 8C 00 00 00 8B 43 48 89 47 48 8B 43 4C 89 47 4C 8B 43 38 89 47 38 8B 43 3C 89 47 3C EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TCustomAction.SetAutoCheck"
		size = 94
		refs = "0024 TList.Get 002a _DV_TActionLink 002f @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 9D 95 00 00 00 74 49 8B 45 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 48 46 4F 75 D2 88 9D 95 00 00 00 8B C5 8B 10 FF 52 34 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TCustomAction.SetCaption"
		size = 95
		refs = "0010 @UStrEqual 002f _DV_TActionLink 0034 @AsClass 004f @UStrAsg"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 8B 53 64 E8 ?? ?? ?? ?? 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 4C 47 4E 75 DC 8D 43 64 8B 14 24 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "TCustomAction.SetChecked"
		size = 261
		refs = "0024 TCustomAction.SetChecked 0059 _DV_TActionLink 005e @AsClass 0090 TCustomActionList.GetActionCount 00a7 TCustomActionList.GetAction 00b6 _DV_TCustomAction 00bb @IsClass 00f9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 8B 45 FC 80 78 68 00 0F 85 E6 00 00 00 8B 45 FC C6 40 68 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 3A 58 69 0F 84 A9 00 00 00 8B 45 FC 8B 40 50 8B 78 08 4F 85 FF 7C 29 47 33 F6 8B 45 FC 8B 40 50 8B 40 04 8B 04 B0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 8B D3 8B 08 FF 51 50 46 4F 75 DA 8B 45 FC 88 58 69 8B 45 FC 83 78 6C 00 7E 5B 8B 45 FC 80 78 69 00 74 52 8B 45 FC 8B 40 5C E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 40 47 33 F6 8B 45 FC 8B 40 5C 8B D6 E8 ?? ?? ?? ?? 8B D8 3B 5D FC 74 25 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B 43 6C 8B 55 FC 3B 42 6C 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 46 4F 75 C3 8B 45 FC 8B 10 FF 52 34 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 40 68 00 C3 E9 ?? ?? ?? ?? EB F1 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TCustomAction.SetEnabled"
		size = 122
		refs = "004d _DV_TActionLink 0052 @AsClass"
	strings:
		$1 = { 53 56 57 51 88 14 24 8B D8 0F B6 04 24 3A 43 6A 74 63 8B 43 5C 85 C0 74 1B 0F B6 50 58 80 FA 01 75 09 0F B6 04 24 88 43 6A EB 4A 80 FA 02 75 04 C6 04 24 01 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B6 14 24 8B 08 FF 51 54 47 4E 75 DB 0F B6 04 24 88 43 6A 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TCustomAction.SetGroupIndex"
		size = 85
		refs = "0030 _DV_TActionLink 0035 @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 43 6C 74 3F 8B 04 24 89 43 6C 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 58 47 4E 75 DC 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TCustomAction.SetHelpType"
		size = 88
		refs = "0021 TList.Get 0027 _DV_TActionLink 002c @IsClass"
	strings:
		$1 = { 53 56 57 55 8B DA 8B E8 3A 5D 70 74 46 8B 45 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 45 50 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 64 46 4F 75 D2 88 5D 70 8B C5 8B 10 FF 52 34 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TCustomAction.SetHelpKeyword"
		size = 102
		refs = "000e @UStrEqual 0028 TList.Get 002e _DV_TActionLink 0033 @IsClass 0056 @UStrAsg"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B C5 8B 53 78 E8 ?? ?? ?? ?? 74 4D 8B 43 50 8B 78 08 4F 85 FF 7C 31 47 33 F6 8B D6 8B 43 50 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B D6 8B 43 50 E8 ?? ?? ?? ?? 8B D5 8B 08 FF 51 60 46 4F 75 D2 8D 43 78 8B D5 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 34 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TCustomAction.SetHelpContext"
		size = 85
		refs = "002a _DV_TActionLink 002f @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 43 74 74 3F 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 5C 47 4E 75 DC 8B 04 24 89 43 74 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TCustomAction.SetHint"
		size = 95
		refs = "0010 @UStrEqual 002f _DV_TActionLink 0034 @AsClass 004f @UStrAsg"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 8B 53 7C E8 ?? ?? ?? ?? 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 68 47 4E 75 DC 8D 43 7C 8B 14 24 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_678_0 {
	meta:
		name = "TCustomAction.SetImageIndex"
		size = 91
		refs = "002d _DV_TActionLink 0032 @AsClass"
	strings:
		$1 = { 53 56 57 51 89 14 24 8B D8 8B 04 24 3B 83 80 00 00 00 74 42 8B 43 50 8B 70 08 4E 85 F6 7C 27 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 08 8B 14 24 8B 08 FF 51 6C 47 4E 75 DC 8B 04 24 89 83 80 00 00 00 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TCustomAction.SetShortCut"
		size = 97
		refs = "0030 _DV_TActionLink 0035 @AsClass"
	strings:
		$1 = { 53 56 57 51 66 89 14 24 8B D8 0F B7 04 24 66 3B 83 84 00 00 00 74 45 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B7 14 24 8B 08 FF 51 70 47 4E 75 DB 0F B7 04 24 66 89 83 84 00 00 00 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TCustomAction.SetVisible"
		size = 94
		refs = "002e _DV_TActionLink 0033 @AsClass"
	strings:
		$1 = { 53 56 57 51 88 14 24 8B D8 0F B6 04 24 3A 83 86 00 00 00 74 44 8B 43 50 8B 70 08 4E 85 F6 7C 28 46 33 FF 8B 43 50 8B 40 04 8B 04 B8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 0F B6 14 24 8B 08 FF 51 74 47 4E 75 DB 0F B6 04 24 88 83 86 00 00 00 8B C3 8B 10 FF 52 34 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TCustomAction.SetName"
		size = 76
		refs = "000e @UStrEqual 002e TComponent.SetName 0044 TCustomAction.SetCaption"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 46 08 8B 56 64 E8 ?? ?? ?? ?? 75 0D 8B 5E 04 85 DB 74 0A F6 43 1C 01 74 04 33 C0 EB 02 B0 01 8B D8 8B D7 8B C6 E8 ?? ?? ?? ?? 84 DB 74 12 8B 46 50 83 78 08 00 75 09 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TCustomAction.DoHint"
		size = 39
	strings:
		$1 = { 53 51 C6 04 24 01 66 83 B8 8A 00 00 00 00 74 10 8B CC 8B D8 8B 83 8C 00 00 00 FF 93 88 00 00 00 0F B6 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "TCustomAction.Execute"
		size = 97
		refs = "0044 TCustomAction.SetChecked 0051 TContainedAction.Execute"
	strings:
		$1 = { 53 8B D8 33 C0 8B 53 5C 85 D2 74 06 80 7A 58 00 75 4D 8B C3 8B 10 FF 52 48 80 7B 6A 00 74 29 80 BB 95 00 00 00 00 74 20 80 7B 69 00 74 0C 80 7B 69 00 74 14 83 7B 6C 00 75 0E 0F B6 53 69 80 F2 01 8B C3 E8 ?? ?? ?? ?? 80 7B 6A 00 74 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TCustomAction.GetSecondaryShortCuts"
		size = 38
		refs = "000f _DV_TShortCutList 0014 TStringList.Create"
	strings:
		$1 = { 53 8B D8 83 BB 90 00 00 00 00 75 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 00 00 00 8B 83 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_9788_0 {
	meta:
		name = "TDataSet.GetNestedDataSets"
		size = 38
		refs = "000f _Dn_TList 0014 TObject.Create"
	strings:
		$1 = { 53 8B D8 83 BB 90 00 00 00 00 75 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 00 00 00 8B 83 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TCustomAction.SetSecondaryShortCuts"
		size = 49
		refs = "0012 _DV_TShortCutList 0017 TStringList.Create"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 BB 90 00 00 00 00 75 12 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 90 00 00 00 8B D6 8B 83 90 00 00 00 8B 08 FF 51 08 5E 5B C3 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "TCustomAction.IsSecondaryShortCutsStored"
		size = 35
	strings:
		$1 = { 53 56 8B D8 8B B3 90 00 00 00 85 F6 74 0B 8B C6 8B 10 FF 52 14 85 C0 7F 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TCustomAction.HandleShortCut"
		size = 12
		refs = "0006 @CallDynaInst"
	strings:
		$1 = { 56 66 BE F0 FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TShortCutList.Add"
		size = 43
		refs = "000c TStringList.Add 0015 TextToShortCut"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 0F B7 C8 8B D7 8B C3 8B 18 FF 53 24 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TShortCutList.GetShortCuts"
		size = 18
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 18 5E 5B C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TAction.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TCustomAction.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 60 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TShortCutList.IndexOfShortCut"
		size = 65
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 C7 04 24 FF FF FF FF 8B C7 8B 10 FF 52 14 8B F0 4E 85 F6 7C 1A 46 33 DB 8B D3 8B C7 8B 08 FF 51 18 66 3B E8 75 05 89 1C 24 EB 04 43 4E 75 E9 8B 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "ActnList"
		size = 42
		refs = "0002 _DV_9 000b _Dn_TControl 0010 _DV_TCustomActionList 0015 GroupDescendentsWith 0020 _DV_TContainedAction"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 20 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TXToolDockForm.CMDialogChar"
		size = 54
		refs = "0008 Application 002e TWinControl.CMDialogChar"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 A1 ?? ?? ?? ?? 8B 00 8B 78 44 85 FF 74 0E 8B D3 A1 ?? ?? ?? ?? 8B C7 8B 08 FF 51 EC 83 7B 0C 00 75 09 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "NotifyDesigner"
		size = 39
		refs = "0002 ActionBarDesigner"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1D 85 C0 74 0D 85 C0 74 15 80 B8 8C 02 00 00 00 74 0C 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 14 C3 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TCustomActionManager.Create"
		size = 360
		refs = "0018 @ClassCreate 0025 TCustomActionManager.Create 0034 TCustomActionList.Create 004a TCustomActionManager.CreateActionBars 0054 _Dn_TStringList 0059 TStringList.Create 0069 cDefaultSchedule 009c TStrings.GetName 00a9 TStrings.GetValue 00b1 StrToInt 00cc _Dn_TChangeLink 00d1 TObject.Create 00e3 TCustomActionManager.ImageListChange 0139 @UStrArrayClr 013f @HandleFinally 014e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 DB 89 5D F0 89 5D EC 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? F7 D0 22 46 24 88 46 24 8B C6 E8 ?? ?? ?? ?? 89 46 6C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E AC 00 00 00 8B C3 8B 15 ?? ?? ?? ?? 8B 08 FF 51 2C 8B 86 AC 00 00 00 8B 10 FF 52 14 48 85 C0 7C 47 40 89 45 F4 C7 45 F8 00 00 00 00 8B 9E AC 00 00 00 8D 4D EC 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 4D F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B C8 8B 55 F8 8B C3 8B 18 FF 53 24 FF 45 F8 FF 4D F4 75 C4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 98 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 80 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E A0 00 00 00 89 73 0C C7 43 08 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 01 00 00 00 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TCustomActionManager.Destroy"
		size = 189
		refs = "0005 @BeforeDestruction 001c TObject.Free 007a TActionBars.GetActionBar 00a9 TCustomActionList.Destroy 00b4 @ClassDestroy"
	strings:
		$1 = { 53 56 57 55 E8 ?? ?? ?? ?? 8B DA 8B E8 8D 85 98 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 85 80 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 85 A0 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 85 AC 00 00 00 E8 ?? ?? ?? ?? 8B 45 6C E8 ?? ?? ?? ?? 8B 85 90 00 00 00 85 C0 74 2F 8B 40 08 8B 70 08 4E 85 F6 7C 19 46 33 FF 8B 85 90 00 00 00 8B D7 E8 ?? ?? ?? ?? 33 D2 89 50 0C 47 4E 75 EA 8B 85 90 00 00 00 E8 ?? ?? ?? ?? 8B 85 8C 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C5 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C5 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TCustomActionManager.AddAction"
		size = 91
		refs = "001a TCollection.Add 0023 TCollectionItem.GetIndex 003b TActionClientItem.SetAction 0042 TActionClientItem.GetParentItem 0047 TActionClient.GetOwningCollection 004e TActionClientsCollection.InternalRethinkHotkeys"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F1 8B FA 33 DB 85 F6 74 42 83 7E 04 00 74 3C 8B 46 04 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 8B D0 0F B6 45 08 03 D0 8B C3 8B 08 FF 51 14 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "AddActions"
		size = 222
		refs = "0015 @UStrAddRef 001d AddActions 002d @DynArrayLength 003b TCustomActionList.GetActionCount 004d TActionArray 0052 @DynArraySetLength 006f TCustomActionList.GetAction 007a AnsiCompareText 00c8 @UStrClr 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D FC 8B FA 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 00 E8 ?? ?? ?? ?? 89 45 F4 85 FF 74 7F 8B C7 E8 ?? ?? ?? ?? 03 45 F4 50 8B 45 F8 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 36 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 40 58 8B 55 FC E8 ?? ?? ?? ?? 85 C0 75 17 8B D3 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 8B 12 8B 4D F4 89 04 8A FF 45 F4 43 4E 75 CD 8B 45 F4 50 8B 45 F8 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "TCustomActionManager.AddCategory"
		size = 358
		refs = "001a @UStrAddRef 0022 TCustomActionManager.AddCategory 0044 AddActions 004b TCustomActionManager.GetLinkedActionLists 0069 TActionListCollection.GetListItem 0086 @CallDynaInst 00a9 TActionClientItem.SetCaption 00bf TCollectionItem.GetIndex 00d7 @DynArrayLength 00e9 TActionClient.GetItems 00ee TActionClients.Add 00f9 TActionClientItem.SetAction 0119 @HandleAnyException 0121 TObject.Free 0126 @RaiseAgain 012b @DoneExcept 0141 TActionArray 0146 @DynArrayClear 014e @UStrClr 0154 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D F8 89 4D F4 89 55 FC 8B F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F0 83 7D F4 00 0F 84 F4 00 00 00 8D 45 F8 8B 4D FC 8B D7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B D8 4B 85 DB 7C 23 43 33 F6 8B C7 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 50 0C 8D 45 F8 8B 4D FC E8 ?? ?? ?? ?? 46 4B 75 E0 8B C7 66 BE ED FF E8 ?? ?? ?? ?? 33 C9 B2 01 FF 50 1C 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 F4 8B 50 04 8B 45 F0 8B 08 FF 51 10 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 0F B6 45 08 03 D0 8B 45 F0 8B 08 FF 51 14 8B 45 F8 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1F 43 33 F6 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B 14 B2 E8 ?? ?? ?? ?? 46 4B 75 E4 8B 45 F0 8B 40 44 B2 01 8B 08 FF 51 74 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 8B 45 F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "TCustomActionManager.AddSeparator"
		size = 116
		refs = "0010 TActionClientItem.GetActionClients 001d _DV_TActionClientItem 0022 TActionClientItem.Create 0029 TCustomActionManager.AddSeparator 0030 TActionClientItem.SetCaption 0037 TActionClientItem.GetParentItem 003c TActionClient.GetItems 004c TCollectionItem.GetIndex"
	strings:
		$1 = { 53 56 57 8B D9 8B F2 33 FF 85 F6 74 51 8B C6 E8 ?? ?? ?? ?? 85 C0 74 46 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 BA ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 10 8B C6 E8 ?? ?? ?? ?? 8B D0 0F B6 C3 03 D0 8B C7 8B 08 FF 51 14 8B C7 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 7C 00 00 00 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "TCustomActionManager.Assign"
		size = 245
		refs = "000f TCustomActionManager.Assign 001e TPersistent.Assign 0026 _DV_TCustomActionManager 002b @IsClass 0072 TCustomActionManager.GetFileName 007c TCustomActionManager.SetFileName 00c1 TCustomActionManager.GetLinkedActionLists 00e4 @UStrClr 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D7 8B C6 E8 ?? ?? ?? ?? 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 8B 57 6C 8B 46 6C 8B 08 FF 51 08 8B 86 84 00 00 00 85 C0 74 0B 8B 97 84 00 00 00 8B 08 FF 51 08 8B 86 9C 00 00 00 85 C0 74 0B 8B 97 9C 00 00 00 8B 08 FF 51 08 8D 55 FC 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 3C 85 C0 74 08 8B 57 3C 8B 08 FF 51 08 8B 86 A4 00 00 00 85 C0 74 0B 8B 97 A4 00 00 00 8B 08 FF 51 08 8B 97 AC 00 00 00 8B 86 AC 00 00 00 8B 08 FF 51 08 83 BF 8C 00 00 00 00 74 15 8B C7 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 59 5D C3 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "TCustomActionManager.CompareAction"
		size = 48
		refs = "000b _DV_TActionClientItem 0010 @IsClass 001d TActionClientItem.GetAction"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B FE 8B C7 E8 ?? ?? ?? ?? 3B 43 68 75 06 89 BB 88 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "TCustomActionManager.CompareCaption"
		size = 111
		refs = "0010 TCustomActionManager.CompareCaption 001e _DV_TActionClientItem 0023 @IsClass 0033 TActionClientItem.GetCaption 003e AnsiCompareText 005d @UStrClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8D 55 FC 8B FE 8B C7 E8 ?? ?? ?? ?? 8B 45 FC 8B 53 70 E8 ?? ?? ?? ?? 85 C0 75 06 89 BB 88 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TCustomActionManager.CreateActionBars"
		size = 37
		refs = "000b @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 66 BE EF FF E8 ?? ?? ?? ?? 50 8B C3 66 BE F0 FF E8 ?? ?? ?? ?? 8B CB B2 01 FF 50 28 5E 5B C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "TCustomActionManager.DeleteActionItems"
		size = 68
		refs = "0027 TCustomActionManager.FindItemByAction 0030 TObject.Free"
	strings:
		$1 = { 55 8B EC 51 53 56 8B D9 85 DB 78 07 8B 34 9A 4B 56 79 F9 8B D4 89 45 FC 8B F1 85 F6 7C 1C 46 8B DA 8B 13 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E7 8B 75 F4 8B 5D F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "StyleNameStored"
		size = 60
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 FC 8B 40 20 85 C0 74 1A 8B 55 08 8B 52 F8 8B 92 E0 00 00 00 8B 4D 08 3B 90 E0 00 00 00 0F 95 C0 5D C3 8B 45 08 8B 40 F8 83 B8 E0 00 00 00 00 0F 95 C0 5D C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "TCustomActionManager.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TCustomActionManager.ReadStyleProp 0026 TCustomActionManager.WriteStyleProp 002c StyleNameStored 0034 TCustomActionManager.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_35215_0 {
	meta:
		name = "TCustomRibbon.DefineProperties"
		size = 104
		refs = "0014 TWinControl.DefineProperties 001d TCustomRibbon.ReadStyleProp 0026 TCustomRibbon.WriteStyleProp 002c StyleNameStored 0034 TCustomRibbon.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_1322_0 {
	meta:
		name = "TPopupActionBar.DefineProperties"
		size = 104
		refs = "0014 TComponent.DefineProperties 001d TPopupActionBar.ReadStyleProp 0026 TPopupActionBar.WriteStyleProp 002c StyleNameStored 0034 TPopupActionBar.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 09 00 00 00 53 00 74 00 79 00 6C 00 65 00 4E 00 61 00 6D 00 65 00 00 00 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "TCustomActionManager.DeleteItem"
		size = 103
		refs = "000e @UStrAddRef 0016 TCustomActionManager.DeleteItem 002f @UStrAsg 0039 TCustomActionManager.FindItemByCaption 0042 TObject.Free 0057 @UStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 83 88 00 00 00 8D 43 70 8B 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TCustomActionManager.FindClient"
		size = 31
	strings:
		$1 = { 53 85 D2 74 10 66 83 78 7A 00 74 09 83 B8 88 00 00 00 00 75 08 8B D8 8B 43 7C FF 53 78 5B C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TCustomActionManager.FindItem"
		size = 35
		refs = "000d TCustomActionManager.FindClient 0017 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 33 C0 89 83 88 00 00 00 53 68 ?? ?? ?? ?? 8B 43 6C 8B D0 E8 ?? ?? ?? ?? 8B 83 88 00 00 00 5B C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TCustomActionManager.FindItemByAction"
		size = 19
		refs = "0006 TCustomActionManager.CompareAction 000e TCustomActionManager.FindItem"
	strings:
		$1 = { 89 40 7C C7 40 78 ?? ?? ?? ?? 89 50 68 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "TCustomActionManager.FindItemByCaption"
		size = 97
		refs = "000e @UStrAddRef 0016 TCustomActionManager.FindItemByCaption 0026 TCustomActionManager.CompareCaption 0031 @UStrAsg 0038 TCustomActionManager.FindItem 004f @UStrClr 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 89 5B 7C C7 43 78 ?? ?? ?? ?? 8D 43 70 8B 55 FC E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "TCustomActionManager.FindActionClient"
		size = 164
		refs = "002f TActionClientsCollection.GetActionClient 0035 _DV_TActionClientItem 003a @IsClass 004c TActionClientItem.GetAction 006d TActionClient.GetHasItems 007f TActionClient.GetItems 008d TCustomActionManager.FindActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 ED 85 F6 75 06 8B 04 24 8B 70 6C 8B 46 08 8B 78 08 4F 85 FF 7C 74 47 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 44 24 04 75 0D 8B D3 8B C6 E8 ?? ?? ?? ?? 8B E8 EB 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 22 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B 54 24 04 8B 04 24 E8 ?? ?? ?? ?? 8B E8 85 ED 75 04 43 4F 75 8F 8B C5 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "TCustomActionManager.FindActionBar"
		size = 138
		refs = "002f TActionClientsCollection.GetActionClient 0053 TActionClient.GetHasItems 0065 TActionClient.GetItems 0073 TCustomActionManager.FindActionBar"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 ED 85 F6 75 06 8B 04 24 8B 70 6C 8B 46 08 8B 78 08 4F 85 FF 7C 5A 47 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 0C 3B 44 24 04 75 0D 8B D3 8B C6 E8 ?? ?? ?? ?? 8B E8 EB 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 22 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B 54 24 04 8B 04 24 E8 ?? ?? ?? ?? 8B E8 85 ED 75 04 43 4F 75 A9 8B C5 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "TCustomActionManager.LoadFromFile"
		size = 292
		refs = "001a TCustomActionManager.LoadFromFile 002c _Dn_TFileStream 0031 TFileStream.Create 005a TCustomActionManager.LoadFromStream 0069 @HandleAnyException 0076 TObject.Free 0082 SErrorLoadingFile 0087 LoadResString 00a0 Format 00b9 MessageDlgPosHelp 00c6 @UStrToPWChar 00cc DeleteFile 00d1 @DoneExcept 00f1 @HandleFinally 010d @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 C9 89 4D F4 89 4D F0 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 20 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 6D E9 ?? ?? ?? ?? 8B 45 F8 33 D2 89 55 F8 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F0 50 8B 45 FC 89 45 E8 C6 45 EC 11 8D 55 E8 33 C9 58 E8 ?? ?? ?? ?? 8B 45 F4 6A 00 6A FF 6A FF 6A 00 0F B7 0D ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 83 F8 06 75 0E 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 33 D2 89 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 03 00 00 00 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "TCustomActionManager.LoadFromStream"
		size = 274
		refs = "0011 _Dn_TMemoryStream 0016 TObject.Create 002b TCustomActionManager.LoadFromStream 0043 TObject.Free 004b TCustomActionManager.CreateActionBars 007b TMemoryStream.LoadFromStream 0087 TStream.SetPosition 0092 TStream.ReadComponent 009a TComponent.Loaded 00a8 TCustomActionManager.SetupActionBars 00b3 TActionBars.Loaded 00c2 @HandleAnyException 00db @RaiseAgain 00e0 @DoneExcept 0105 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F2 89 45 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC C6 80 A8 00 00 00 01 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 90 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 90 00 00 00 8B 45 FC 8B 50 6C 8B C3 8B 08 FF 51 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 F8 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 50 6C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 23 E9 ?? ?? ?? ?? 8B 45 FC 8B 90 90 00 00 00 8B 45 FC 8B 40 6C 8B 08 FF 51 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 A8 00 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E6 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "TCustomActionManager.Loaded"
		size = 215
		refs = "0009 TComponent.Loaded 001d TCustomActionManager.CreateActionBars 0040 FileExists 0051 TCustomActionManager.LoadFromFile 005d TCustomActionManager.SetupActionBars 0084 TActionBars.GetActionBar 009c TCustomActionBar.GetColorMap"
	strings:
		$1 = { 53 56 57 55 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB A8 00 00 00 00 0F 85 B8 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 89 B3 90 00 00 00 8B 53 6C 8B C6 8B 08 FF 51 08 F6 43 1C 10 75 1E 8B 83 94 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 0F 8B 93 94 00 00 00 8B C3 E8 ?? ?? ?? ?? EB 0A 8B 53 6C 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 06 8B 43 6C FF 40 28 8B 43 6C 8B 40 08 8B 78 08 4F 85 FF 7C 57 47 33 F6 8B D6 8B 43 6C E8 ?? ?? ?? ?? 83 78 0C 00 74 40 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C E8 ?? ?? ?? ?? 8B E8 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 3B A8 E0 02 00 00 75 17 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 33 D2 8B 08 FF 91 48 01 00 00 46 4F 75 AC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "TCustomActionManager.LoadMenu"
		size = 178
		refs = "0013 TMenuItem.GetCount 002a TActionClients.Add 0035 TMenuItem.GetItem 003f TActionClientItem.SetCaption 004d TMenuItem.GetAction 0056 TActionClientItem.SetAction 005d TActionClientItem.GetAction 0070 TContainedAction.SetActionList 0093 TActionClient.GetItems 009f TCustomActionManager.LoadMenu"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F9 89 54 24 04 89 04 24 8B C7 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C 89 00 00 00 45 33 F6 8B 44 24 04 E8 ?? ?? ?? ?? 8B D8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B 50 34 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 14 24 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 1D 8B D6 8B C7 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 44 24 04 59 E8 ?? ?? ?? ?? 46 4D 0F 85 7A FF FF FF 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "TCustomActionManager.Notification"
		size = 573
		refs = "0019 TCustomActionList.Notification 001e Application 005b TCustomActionManager.SaveToFile 007d TCustomActionManager.SetLargeImages 008e TCustomActionManager.SetLargeDisabledImages 009f TCustomActionManager.SetDisabledImages 00b1 _Dn_TContainedAction 00b6 @IsClass 00c9 TCustomActionManager.FindActionClient 00d2 _Dn_TList 00d7 TObject.Create 00e2 TCustomActionManager.Notification 00f3 TActionClientItem.GetActionClients 012b TList.Add 0132 TCollectionItem.GetIndex 0140 TCollection.Delete 0176 TList.Get 0189 TWinControl.EnableAlign 0195 TObject.Free 019b @HandleFinally 01a5 _DV_TCustomActionBar 01bc TCustomActionManager.FindActionBar 01e7 _Dn_TCustomActionList 0218 TActionListCollection.GetListItem"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 88 4D FF 8B F2 8B D8 0F B6 4D FF 8B D6 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 80 B8 A4 00 00 00 00 74 16 8B 83 94 00 00 00 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 9F C0 EB 02 33 C0 84 C0 74 1D 80 BB B0 00 00 00 00 75 14 8B 93 94 00 00 00 8B C3 E8 ?? ?? ?? ?? C6 83 B0 00 00 00 01 80 7D FF 01 0F 85 C6 01 00 00 3B B3 A4 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 3B B3 9C 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? 3B B3 84 00 00 00 75 09 33 D2 8B C3 E8 ?? ?? ?? ?? F6 43 1C 08 0F 85 89 01 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 DF 00 00 00 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 74 65 8B C7 E8 ?? ?? ?? ?? 8B 40 20 83 78 0C 00 74 2F 8B C7 E8 ?? ?? ?? ?? 8B 40 20 8B 40 0C 89 45 F4 8B 45 F4 66 FF 80 AC 01 00 00 8B C7 E8 ?? ?? ?? ?? 8B 40 20 8B 50 0C 8B 45 F8 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 33 C9 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 75 9B 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 8B 58 08 4B 85 DB 7C 24 43 33 FF 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 85 C0 74 0F 8B D7 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 47 4B 75 DF 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C1 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 31 8B 4B 6C 8B FE 8B D7 8B C3 E8 ?? ?? ?? ?? 85 C0 74 05 33 D2 89 50 0C 8B 8B 90 00 00 00 8B D7 8B C3 E8 ?? ?? ?? ?? 85 C0 74 5A 33 D2 89 50 0C EB 53 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 42 83 BB 8C 00 00 00 00 74 39 8B 83 8C 00 00 00 8B 40 08 8B 78 08 4F 83 FF 00 7C 27 8B 83 8C 00 00 00 8B D7 E8 ?? ?? ?? ?? 3B 70 0C 75 0F 8B 83 8C 00 00 00 8B D7 E8 ?? ?? ?? ?? EB 06 4F 83 FF FF 75 D9 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "TCustomActionManager.SaveToFile"
		size = 255
		refs = "0014 TCustomActionManager.SaveToFile 0040 ExpandFileName 004a _Dn_TFileStream 004f TFileStream.Create 0078 TCustomActionManager.SaveToStream 0087 @HandleAnyException 008c @DoneExcept 00a1 TObject.Free 00a7 @HandleFinally 00c0 SUnableToSaveSettings 00c5 LoadResString 00cd ShowMessage 00ec @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C3 8B 08 FF 51 3C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 00 FF 00 00 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 EB 1F E9 ?? ?? ?? ?? 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "TCustomActionManager.SaveToStream"
		size = 114
		refs = "000d _Dn_TMemoryStream 0012 TObject.Create 001d TCustomActionManager.SaveToStream 002d TStream.WriteComponent 0039 TStream.SetPosition 004c TStream.CopyFrom 0061 TObject.Free 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 12 52 50 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_23192_0 {
	meta:
		name = "TGestureManager.SaveToStream"
		size = 114
		refs = "000d _Dn_TMemoryStream 0012 TObject.Create 001d TGestureManager.SaveToStream 002d TStream.WriteComponent 0039 TStream.SetPosition 004c TStream.CopyFrom 0061 TObject.Free 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 6A 00 6A 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 12 52 50 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "TCustomActionManager.SetupActionBars"
		size = 172
		refs = "0027 TActionClientsCollection.GetActionClient 0036 TActionClientsCollection.InternalRethinkHotkeys 006a @CallDynaInst 009b TControl.SetVisible"
	strings:
		$1 = { 53 56 57 55 8B DA 8B 43 08 8B 40 08 85 C0 0F 84 93 00 00 00 8B E8 4D 85 ED 0F 8C 88 00 00 00 45 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 83 78 0C 00 74 6E B2 01 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 50 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 5A 8B 08 FF 91 40 01 00 00 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 66 BE D0 FF E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 68 8B D7 8B C3 E8 ?? ?? ?? ?? 0F B6 40 30 50 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 5A E8 ?? ?? ?? ?? 47 4D 0F 85 7B FF FF FF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "TCustomActionManager.SetActionBars"
		size = 13
		altNames = "TIBTransaction.SetTRParams"
	strings:
		$1 = { 56 8B F0 8B 46 6C 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "TCustomActionManager.SetDisabledImages"
		size = 224
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0078 TActionBars.GetActionBar 007d TActionClient.GetItems 00a3 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 84 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 80 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 84 00 00 00 85 C0 74 18 8B 93 80 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 84 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7C 8B 43 6C 8B 40 08 8B 40 08 48 85 C0 7C 6E 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 F8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 99 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "TCustomActionManager.SetLargeDisabledImages"
		size = 224
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0078 TActionBars.GetActionBar 007d TActionClient.GetItems 00a3 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 9C 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 98 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 9C 00 00 00 85 C0 74 18 8B 93 98 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 9C 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7C 8B 43 6C 8B 40 08 8B 40 08 48 85 C0 7C 6E 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 F8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 99 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "TCustomActionManager.SetImages"
		size = 163
		refs = "001b TCustomActionList.SetImages 003d TActionBars.GetActionBar 0042 TActionClient.GetItems 0068 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 51 8B F8 3B 57 3C 74 06 F6 47 1C 08 74 04 33 DB EB 02 B3 01 8B C7 E8 ?? ?? ?? ?? 84 DB 74 7A 8B 47 6C 8B 40 08 8B 40 08 48 85 C0 7C 6C 40 89 04 24 33 ED 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 44 46 33 DB 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B 47 6C 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 F8 00 00 00 43 4E 75 BF 45 FF 0C 24 75 9A 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "PrioritySort"
		size = 112
		refs = "0014 PrioritySort 0026 TStrings.GetName 003f AnsiCompareText 005b @UStrArrayClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 4D F8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "TCustomActionManager.SetPrioritySchedule"
		size = 400
		refs = "001b TCustomActionManager.SetPrioritySchedule 003d Trim 005b SRestoreDefaultSchedule 0060 LoadResString 0079 MessageDlgPosHelp 008b cDefaultSchedule 00ae TStrings.GetName 00b6 StrToInt 00cf TStrings.GetValue 00ec PrioritySort 016b @UStrArrayClr 017e @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 FC 8B 80 AC 00 00 00 8B 08 FF 51 1C 8B 45 F0 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 89 45 EC 8B 45 EC 85 C0 74 05 83 E8 04 8B 00 85 C0 75 4F 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 6A 00 6A FF 6A FF 6A 00 0F B7 0D ?? ?? ?? ?? B2 03 E8 ?? ?? ?? ?? 48 75 16 8B 45 FC 8B 80 AC 00 00 00 8B 15 ?? ?? ?? ?? 8B 08 FF 51 2C EB 55 8B 45 FC 8B 80 AC 00 00 00 8B 10 FF 52 44 EB 45 8D 4D E4 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 E8 ?? ?? ?? ?? 8D 4D DC 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 4D E0 8B C3 E8 ?? ?? ?? ?? 8B 45 E0 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 AC 00 00 00 8B D3 8B 08 FF 51 08 BA ?? ?? ?? ?? 8B 45 FC 8B 80 AC 00 00 00 8B 08 FF 91 A4 00 00 00 8B 45 FC 8B 80 AC 00 00 00 8B 10 FF 52 14 48 85 C0 7C 41 40 89 45 F8 33 F6 8B 45 FC 8B 98 AC 00 00 00 8D 4D D4 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 55 D4 8D 4D D8 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 E8 ?? ?? ?? ?? 8B C8 8B D6 8B C3 8B 18 FF 53 24 46 FF 4D F8 75 C5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 06 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 8B E5 5D C3 00 00 0C 00 00 00 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "TCustomActionManager.GetUsage"
		size = 112
	strings:
		$1 = { 53 56 57 55 8B FA 8B F0 83 7F 48 FF 74 13 8B 86 AC 00 00 00 8B 10 FF 52 14 85 C0 74 04 33 C0 EB 02 B0 01 84 C0 75 44 8B 46 6C 8B 68 28 2B 6F 60 33 DB EB 01 43 8B 86 AC 00 00 00 8B 10 FF 52 14 3B D8 7D 05 3B 5F 48 7C EB 8B 86 AC 00 00 00 8B 10 FF 52 14 3B D8 75 01 4B 8B D3 8B 86 AC 00 00 00 8B 08 FF 51 18 3B E8 0F 9C C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TCustomActionManager.IsPriorityScheduleStored"
		size = 91
		refs = "000c TCustomActionManager.IsPriorityScheduleStored 0028 cDefaultSchedule 002d AnsiCompareText 0049 @UStrClr 004f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 83 AC 00 00 00 8B 08 FF 51 1C 8B 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "TCustomActionManager.ResetActionBar"
		size = 97
		refs = "0016 TActionBars.GetActionBar 002a TActionClient.SetActionBar 0037 TCollection.GetItem"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 83 BB 90 00 00 00 00 74 4D 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 78 0C 8B D6 8B 43 6C E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B D6 8B 83 90 00 00 00 E8 ?? ?? ?? ?? 50 8B D6 8B 43 6C E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "TCustomActionManager.ResetClientUsageData"
		size = 52
		refs = "000b _DV_TActionClientItem 0010 @IsClass 001f TActionClientItem.SetUsageCount 002c TActionClientItem.SetLastSession"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 33 D2 8B FB 8B C7 E8 ?? ?? ?? ?? 8B 46 6C 8B 50 28 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "TCustomActionManager.ResetUsageData"
		size = 19
		refs = "0002 TCustomActionManager.ResetClientUsageData 000e TActionClientsCollection.IterateClients"
	strings:
		$1 = { 50 68 ?? ?? ?? ?? 8B 50 6C 8B CA 8B C1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "TCustomActionManager.SetLargeImages"
		size = 224
		refs = "002f TCustomImageList.UnRegisterChanges 0046 TCustomImageList.RegisterChanges 0053 TComponent.FreeNotification 0078 TActionBars.GetActionBar 007d TActionClient.GetItems 00a3 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B D8 8B 83 A4 00 00 00 3B F0 74 06 F6 43 1C 08 74 04 33 D2 EB 02 B2 01 88 14 24 85 C0 74 0B 8B 93 A0 00 00 00 E8 ?? ?? ?? ?? 8B C6 89 83 A4 00 00 00 85 C0 74 18 8B 93 A0 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 A4 00 00 00 E8 ?? ?? ?? ?? 80 3C 24 00 74 7C 8B 43 6C 8B 40 08 8B 40 08 48 85 C0 7C 6E 40 89 44 24 04 33 ED 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 44 47 33 F6 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 21 8B D5 8B 43 6C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 F8 00 00 00 46 4F 75 BF 45 FF 4C 24 04 75 99 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "TCustomActionManager.SetLinkedActionLists"
		size = 57
		refs = "0010 _DV_TActionListItem 001a _DV_TActionListCollection 001f TOwnedCollection.Create"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 BB 8C 00 00 00 00 75 1A A1 ?? ?? ?? ?? 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 8C 00 00 00 8B D6 8B 83 8C 00 00 00 8B 08 FF 51 08 5E 5B C3 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "TCustomActionManager.Change"
		size = 30
		refs = "0006 TCustomActionList.Change 0018 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 6C 85 C0 74 0B 6A 00 6A 00 8B D0 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "TCustomActionManager.GetActionClientsClass"
		size = 59
		refs = "0004 _DV_TActionClients"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 D2 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 D4 00 00 00 FF 93 D0 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TCustomActionManager.GetCommandPropertiesClass"
		size = 60
		refs = "0004 _DV_TButtonProperties"
	strings:
		$1 = { 53 51 8B 0D ?? ?? ?? ?? 89 0C 24 66 83 B8 EA 00 00 00 00 74 13 54 8B D8 8B CA 8B D0 8B 83 EC 00 00 00 FF 93 E8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TCustomActionManager.GetActionClientItemClass"
		size = 59
		refs = "0004 _DV_TActionClientItem"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 CA 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 CC 00 00 00 FF 93 C8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TCustomActionManager.GetActionBarsClass"
		size = 51
		refs = "0004 _DV_TActionBars"
	strings:
		$1 = { 53 56 8B 1D ?? ?? ?? ?? 66 83 B8 C2 00 00 00 00 74 12 8B F0 8B CB 8B D0 8B 86 C4 00 00 00 FF 96 C0 00 00 00 85 DB 75 06 8B 1D ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TCustomActionManager.GetActionBarItemClass"
		size = 59
		refs = "0004 _DV_TActionBarItem"
	strings:
		$1 = { 53 51 8B 15 ?? ?? ?? ?? 89 14 24 66 83 B8 BA 00 00 00 00 74 12 8B CC 8B D8 8B D0 8B 83 BC 00 00 00 FF 93 B8 00 00 00 83 3C 24 00 75 08 A1 ?? ?? ?? ?? 89 04 24 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TCustomActionManager.IsLinkedActionListsStored"
		size = 29
		refs = "000a TCustomActionManager.GetLinkedActionLists"
	strings:
		$1 = { 83 B8 8C 00 00 00 00 74 11 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 0F 9F C0 C3 33 C0 C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "TCustomActionManager.ImageListChange"
		size = 6
		altNames = "TWinControlActionLink.IsHelpContextLinked"
	strings:
		$1 = { 8B 10 FF 52 34 C3 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "TCustomActionManager.IsActionBarsStored"
		size = 14
	strings:
		$1 = { 8B 40 6C 8B 40 08 83 78 08 00 0F 9F C0 C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TCustomActionManager.GetFileName"
		size = 22
		refs = "000f @UStrAsg"
		altNames = "TQuerySelectOptions.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 93 94 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TCustomActionManager.SetFileName"
		size = 95
		refs = "000e @UStrAddRef 0016 TCustomActionManager.SetFileName 002a @UStrEqual 003a @UStrAsg 004f @UStrClr 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 93 94 00 00 00 E8 ?? ?? ?? ?? 74 0E 8D 83 94 00 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TCustomActionManager.GetLinkedActionLists"
		size = 46
		refs = "000d _DV_TActionListItem 0017 _DV_TActionListCollection 001c TOwnedCollection.Create"
	strings:
		$1 = { 53 8B D8 83 BB 8C 00 00 00 00 75 1A A1 ?? ?? ?? ?? 50 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 8C 00 00 00 8B 83 8C 00 00 00 5B C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TCustomActionManager.ReadStyleProp"
		size = 223
		refs = "0017 TCustomActionManager.ReadStyleProp 0027 TReader.ReadString 0047 ActionBarStyles 0058 TActionBarStyleList.GetStyle 0062 TCustomActionManager.SetStyle 0071 @HandleAnyException 007f ApplicationHandleException 008b ExceptObject 009f ExceptAddr 00ab ShowException 00b2 @RaiseAgain 00b7 @DoneExcept 00cc @UStrClr 00d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D FC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 86 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC A1 ?? ?? ?? ?? 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 4B E9 ?? ?? ?? ?? 8B 45 F8 F6 40 1C 10 74 33 A1 ?? ?? ?? ?? 66 83 78 02 00 74 14 E8 ?? ?? ?? ?? 8B D0 8B 1D ?? ?? ?? ?? 8B 43 04 FF 13 EB 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TCustomActionManager.WriteStyleProp"
		size = 112
		refs = "0013 TCustomActionManager.WriteStyleProp 002e ActionBarStyles 0033 TActionBarStyleList.GetStyle 004a TWriter.WriteString 005f @UStrClr 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 89 55 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 90 E0 00 00 00 85 D2 74 04 8B DA EB 0E 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8D 55 F8 8B C3 8B 08 FF 51 08 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "TCustomActionManager.HasLinkedActionLists"
		size = 11
	strings:
		$1 = { 83 B8 8C 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "TCustomActionManager.AfterConstruction"
		size = 58
		refs = "0006 TObject.AfterConstruction 0018 DefaultActnBarStyle 001d ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 74 28 F6 43 1C 01 75 22 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 E0 00 00 00 5B C3 }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "TCustomActionManager.SetStyle"
		size = 213
		refs = "0033 TActionBars.GetActionBar 0060 TCustomActionBar.GetColorMap 00cc NotifyDesigner"
	strings:
		$1 = { 53 56 57 55 8B D8 3B 93 E0 00 00 00 0F 84 BE 00 00 00 89 93 E0 00 00 00 8B 43 6C 8B 40 08 8B 78 08 4F 85 FF 0F 8C 81 00 00 00 47 33 F6 8B D6 8B 43 6C E8 ?? ?? ?? ?? 83 78 0C 00 74 6A 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 92 68 01 00 00 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C E8 ?? ?? ?? ?? 8B E8 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 3B A8 E0 02 00 00 75 17 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 33 D2 8B 08 FF 91 48 01 00 00 8B D6 8B 43 6C E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 92 90 00 00 00 46 4F 75 82 66 83 BB DA 00 00 00 00 74 0E 8B D3 8B 83 DC 00 00 00 FF 93 D8 00 00 00 F6 43 1C 10 74 07 33 C0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TCustomActionManager.SetState"
		size = 142
		refs = "0013 TCustomActionList.SetState 0022 TCollection.GetEnumerator 002d TCustomActionManager.SetState 0046 TCollection.GetItem 005c TCollectionEnumerator.MoveNext 0083 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 88 55 FF 8B D8 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 8B 83 8C 00 00 00 85 C0 74 68 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 1F 8B 45 F8 8B 50 04 8B 45 F8 8B 40 08 E8 ?? ?? ?? ?? 8B D8 8B 43 0C 0F B6 55 FF 8B 08 FF 51 3C 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 75 D5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 0A B2 01 8B 45 F8 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "TActionListItem.Assign"
		size = 198
		refs = "0016 TActionListItem.Assign 0026 TPersistent.Assign 002e _DV_TActionListItem 0033 @IsClass 0063 TActionListItem.SetActionList 006d TActionListItem.GetCaption 007b @UStrAsg 009d @HandleFinally 00b4 @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 68 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B 56 0C 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 83 C0 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TActionListItem.GetCaption"
		size = 75
		refs = "000e @UStrAsg 003d SNoName 0042 LoadResString"
	strings:
		$1 = { 53 56 57 51 8B F2 8B D8 8B C6 8B 53 10 E8 ?? ?? ?? ?? 8B 06 89 04 24 8B 04 24 85 C0 74 05 83 E8 04 8B 00 85 C0 75 1F 8B 7B 0C 85 FF 74 0C 8B C6 8B 57 08 E8 ?? ?? ?? ?? EB 0C 8B D6 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "TActionListItem.GetDisplayName"
		size = 36
		refs = "0011 TActionListItem.GetCaption 001d TCollectionItem.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 0C 00 74 0C 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "TActionListItem.SetActionList"
		size = 172
		refs = "0010 TActionListItem.SetActionList 001d TActionListItem.Owner 0022 TActionListCollection.GetActionManager 002e SCircularReferencesNotAllowed 0033 LoadResString 003d _Dn_Exception 0042 Exception.Create 0047 @RaiseExcept 0067 TComponent.RemoveFreeNotification 0085 TComponent.FreeNotification 009a @UStrClr 00a0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B F0 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7B 0C 3B F7 74 37 85 FF 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B FE 89 7B 0C 85 FF 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "TActionListCollection.GetActionManager"
		size = 12
		refs = "0006 TCollection.Owner"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1907_0 {
	meta:
		name = "FormatClearStr"
		size = 12
		refs = "0006 @LStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "TActionBars.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "TActionClients.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3383_0 {
	meta:
		name = "TButtonItem.GetNotifyTarget"
		size = 12
		refs = "0006 TButtonItem.GetCategoryButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9663_0 {
	meta:
		name = "TCheckConstraints.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7284_0 {
	meta:
		name = "TClassList.Last"
		size = 12
		refs = "0006 TList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_20910_0 {
	meta:
		name = "TColumnCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6455_0 {
	meta:
		name = "TComboExItems.Add"
		size = 12
		refs = "0006 TListControlItems.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7271_0 {
	meta:
		name = "TComponentList.Last"
		size = 12
		refs = "0006 TList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_20913_0 {
	meta:
		name = "TControlCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25383_0 {
	meta:
		name = "TCookieCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6278_0 {
	meta:
		name = "TCoolBands.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11462_0 {
	meta:
		name = "TDBGridColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_17299_0 {
	meta:
		name = "TDBXJSonStreamReader.ReadShort"
		size = 12
		refs = "0006 TDBXJSonStreamReader.ReadInt"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_20051_0 {
	meta:
		name = "TDSPlatform.DefaultPackageName"
		size = 12
		refs = "0006 @WStrClr"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11783_0 {
	meta:
		name = "TDataBindings.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21497_0 {
	meta:
		name = "TFMTBcdData.GetAsSmallInt"
		size = 12
		refs = "0006 TFMTBcdData.GetAsInteger"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18740_0 {
	meta:
		name = "TFavoriteLinkItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8931_0 {
	meta:
		name = "TFieldDefs.AddFieldDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18732_0 {
	meta:
		name = "TFileTypeItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_23154_0 {
	meta:
		name = "TGestureStreamList.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3043_0 {
	meta:
		name = "TGrpButtonItem.GetNotifyTarget"
		size = 12
		refs = "0006 TGrpButtonItem.GetButtonGroup"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3046_0 {
	meta:
		name = "TGrpButtonItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12465_0 {
	meta:
		name = "THTMLTableColumns.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_9595_0 {
	meta:
		name = "TIndexDefs.AddIndexDef"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1107_0 {
	meta:
		name = "TMenuStack.Peek"
		size = 12
		refs = "0006 TOrderedList.PeekItem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_7255_0 {
	meta:
		name = "TObjectList.Last"
		size = 12
		refs = "0006 TList.Last"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_20906_0 {
	meta:
		name = "TRowCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36420_0 {
	meta:
		name = "TRttiContext.Create"
		size = 12
		refs = "0006 @IntfClear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36421_0 {
	meta:
		name = "TRttiContext.Free"
		size = 12
		refs = "0006 @IntfClear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36643_0 {
	meta:
		name = "TRttiInstanceFieldClassic.GetParent"
		size = 12
		refs = "0006 TRttiMember.GetParent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37700_0 {
	meta:
		name = "TScreenTipsCollection.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5210_0 {
	meta:
		name = "TStatusPanels.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18819_0 {
	meta:
		name = "TTaskDialogButtons.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_25426_0 {
	meta:
		name = "TWebActionItems.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5796_0 {
	meta:
		name = "TWorkAreas.Add"
		size = 12
		refs = "0006 TCollection.Add"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "TActionBars.GetActionBar"
		size = 18
		refs = "000b TCollection.GetItem"
		altNames = "TActionClients.GetActionClient TActionClientsCollection.GetActionClient TActionListCollection.GetListItem TAggregates.GetItem TCellCollection.GetItem TChartCustomAxes.Get TCheckConstraints.GetItem TControlCollection.GetItem TCookieCollection.GetCookie TCoolBands.GetItem TCustomGestureCollection.GetItem TDBGridColumns.GetColumn TDataBindings.GetItem TDependencies.GetItem TFavoriteLinkItems.GetItem TFieldDefs.GetFieldDef TFileTypeItems.GetItem TFilterItems.Get TGestureStreamList.GetItem TGrpButtonItems.GetItem THTMLTableColumns.GetColumn THeaderSections.GetItem TIndexDefs.GetIndexDef TListColumns.GetItem TListControlItems.GetListItem TListGroups.GetItem TParameters.GetItem TScreenTipsCollection.GetItem TSeriesGroups.Get TServerCollection.GetItem TStatusPanels.GetItem TTaskDialogButtons.GetItem TWebActionItems.GetActionItem TWebUserItems.GetUserItem TWorkAreas.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43170_0 {
	meta:
		name = "AnsiLowerCaseFileName"
		size = 18
		refs = "000b AnsiLowerCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42640_0 {
	meta:
		name = "AnsiToUtf8"
		size = 18
		refs = "000b UTF8Encode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43171_0 {
	meta:
		name = "AnsiUpperCaseFileName"
		size = 18
		refs = "000b AnsiUpperCase"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3552_0 {
	meta:
		name = "ConvertFromUtf32"
		size = 18
		refs = "000b TCharacter.ConvertFromUtf32"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1999_0 {
	meta:
		name = "ExcludeTrailingBackslash"
		size = 18
		refs = "000b ExcludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23461_0 {
	meta:
		name = "GetSysErrorMessage"
		size = 18
		refs = "000b SysErrorMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1997_0 {
	meta:
		name = "IncludeTrailingBackslash"
		size = 18
		refs = "000b IncludeTrailingPathDelimiter"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42327_0 {
	meta:
		name = "LoadResStringU"
		size = 18
		refs = "000b LoadResString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42781_0 {
	meta:
		name = "LoadStr"
		size = 18
		refs = "000b FindStringResource"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10770_0 {
	meta:
		name = "MetaDataFromUnicode"
		size = 18
		refs = "000b UTF8Encode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49978_0 {
	meta:
		name = "TAdapterDataDisplay.GetAdapterModeOfAdapter"
		size = 18
		refs = "000b GetAdapterModeOfAdapterInParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48694_0 {
	meta:
		name = "TAdapterNamedField.GetDefaultDisplayLabel"
		size = 18
		refs = "000b TAdapterNamedField.GetVariableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46388_0 {
	meta:
		name = "TAxisItems.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48744_0 {
	meta:
		name = "TBaseAdapterAction.GetDefaultDisplayLabel"
		size = 18
		refs = "000b TBaseAdapterAction.GetActionName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48736_0 {
	meta:
		name = "TBaseAdapterAction.GetVariableName"
		size = 18
		refs = "000b TBaseAdapterAction.ImplGetVariableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_48737_0 {
	meta:
		name = "TBaseAdapterAction.ImplGetVariableName"
		size = 18
		refs = "000b TBaseAdapterAction.GetActionName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7280_0 {
	meta:
		name = "TClassList.GetItems"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6457_0 {
	meta:
		name = "TComboExItems.GetComboItem"
		size = 18
		refs = "000b TListControlItems.GetListItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_49979_0 {
	meta:
		name = "TCustomAdapterActionButton.GetAdapterModeOfAdapter"
		size = 18
		refs = "000b GetAdapterModeOfAdapterInParent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_40973_0 {
	meta:
		name = "TCustomLabel.GetLabelText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29693_0 {
	meta:
		name = "TCustomMaskEdit.GetEditText"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_55313_0 {
	meta:
		name = "TCustomXSLPageProducer.GetProducerTemplateFileName"
		size = 18
		refs = "000b TXMLDocument.GetFileName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11684_0 {
	meta:
		name = "TDBLookupCombo.GetDisplayValue"
		size = 18
		refs = "000b TControl.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14527_0 {
	meta:
		name = "TDBXDelegateConnection.GetErrorEvent"
		size = 18
		refs = "000b TDBXConnection.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17804_0 {
	meta:
		name = "TDBXTraceCommand.GetCommandType"
		size = 18
		refs = "000b TDBXDelegateCommand.GetCommandType"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17805_0 {
	meta:
		name = "TDBXTraceCommand.GetErrorEvent"
		size = 18
		refs = "000b TDBXDelegateCommand.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17802_0 {
	meta:
		name = "TDBXTraceCommand.GetText"
		size = 18
		refs = "000b TDBXDelegateCommand.GetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17775_0 {
	meta:
		name = "TDBXTraceConnection.GetErrorEvent"
		size = 18
		refs = "000b TDBXDelegateConnection.GetErrorEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_17781_0 {
	meta:
		name = "TDBXTraceConnection.GetTraceInfoEvent"
		size = 18
		refs = "000b TDBXDelegateConnection.GetTraceInfoEvent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23021_0 {
	meta:
		name = "TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23016_0 {
	meta:
		name = "TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TValueEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<Classes.TComponent,GestureCtrls.TGestureProviderChangeEvent>.TValueEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23313_0 {
	meta:
		name = "TDictionary<Controls.TControl,GestureMgr.TGestureCollection>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<Controls.TControl,GestureMgr.TGestureCollection>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15546_0 {
	meta:
		name = "TDictionary<System.Integer,System.Integer>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.Integer,System.Integer>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36857_0 {
	meta:
		name = "TDictionary<System.Pointer,Rtti.TRttiObject>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.Pointer,Rtti.TRttiObject>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15592_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TKeyEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TKeyEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15608_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,DBXJSONReflect.TConverterEvent>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15791_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TKeyEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TKeyEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15807_0 {
	meta:
		name = "TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,DBXJSONReflect.TReverterEvent>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15731_0 {
	meta:
		name = "TDictionary<System.string,System.TObject>.TKeyEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,System.TObject>.TKeyEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_15747_0 {
	meta:
		name = "TDictionary<System.string,System.TObject>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,System.TObject>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36781_0 {
	meta:
		name = "TDictionary<System.string,TypInfo.PTypeInfo>.TKeyEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,TypInfo.PTypeInfo>.TKeyEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36795_0 {
	meta:
		name = "TDictionary<System.string,TypInfo.PTypeInfo>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<System.string,TypInfo.PTypeInfo>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20183_0 {
	meta:
		name = "TDictionary<ToolsAPI.IOTAProject,System.Integer>.TKeyEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<ToolsAPI.IOTAProject,System.Integer>.TKeyEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20199_0 {
	meta:
		name = "TDictionary<ToolsAPI.IOTAProject,System.Integer>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<ToolsAPI.IOTAProject,System.Integer>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36737_0 {
	meta:
		name = "TDictionary<TypInfo.PTypeInfo,System.string>.TPairEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<TypInfo.PTypeInfo,System.string>.TPairEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36732_0 {
	meta:
		name = "TDictionary<TypInfo.PTypeInfo,System.string>.TValueEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TDictionary<TypInfo.PTypeInfo,System.string>.TValueEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9030_0 {
	meta:
		name = "TField.GetDisplayLabel"
		size = 18
		refs = "000b TField.GetDisplayName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37836_0 {
	meta:
		name = "TFunction.GetBody"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37837_0 {
	meta:
		name = "TFunction.GetFunctionName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37833_0 {
	meta:
		name = "TFunctions.FindFunctionName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23967_0 {
	meta:
		name = "TGIFExtensionList.GetExtension"
		size = 18
		refs = "000b TGIFList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_24119_0 {
	meta:
		name = "TGIFImageList.GetFrame"
		size = 18
		refs = "000b TGIFList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37843_0 {
	meta:
		name = "THTMLBlock.GetBlockName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37842_0 {
	meta:
		name = "THTMLBlock.GetHTML"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37839_0 {
	meta:
		name = "THTMLBlocks.FindBlockName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27115_0 {
	meta:
		name = "TIBQuery.PSGetTableNameW"
		size = 18
		refs = "000b TIBCustomDataSet.PSGetTableNameW"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7328_0 {
	meta:
		name = "TIntegerBucketList.GetData"
		size = 18
		refs = "000b TCustomBucketList.GetData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7329_0 {
	meta:
		name = "TIntegerBucketList.Remove"
		size = 18
		refs = "000b TCustomBucketList.Remove"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23692_0 {
	meta:
		name = "TList<Gestures.TGesturePoint>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<Gestures.TGesturePoint>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29249_0 {
	meta:
		name = "TList<Keyboard.TCustomTouchKeyboard.TChangeState>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<Keyboard.TCustomTouchKeyboard.TChangeState>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29518_0 {
	meta:
		name = "TList<KeyboardTypes.TKeyboardLanguage>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<KeyboardTypes.TKeyboardLanguage>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29422_0 {
	meta:
		name = "TList<KeyboardTypes.TVirtualKey>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<KeyboardTypes.TVirtualKey>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_26776_0 {
	meta:
		name = "TList<System.AnsiString>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<System.AnsiString>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_23069_0 {
	meta:
		name = "TList<Types.TPoint>.TEnumerator.DoGetCurrent"
		size = 18
		refs = "000b TList<Types.TPoint>.TEnumerator.GetCurrent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_10410_0 {
	meta:
		name = "TListOfDataSources.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1110_0 {
	meta:
		name = "TMenuList.GetMenu"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7324_0 {
	meta:
		name = "TObjectBucketList.GetData"
		size = 18
		refs = "000b TCustomBucketList.GetData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7325_0 {
	meta:
		name = "TObjectBucketList.Remove"
		size = 18
		refs = "000b TCustomBucketList.Remove"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7251_0 {
	meta:
		name = "TObjectList.GetItem"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7304_0 {
	meta:
		name = "TObjectQueue.Push"
		size = 18
		refs = "000b TOrderedList.Push"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7300_0 {
	meta:
		name = "TObjectStack.Push"
		size = 18
		refs = "000b TOrderedList.Push"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_33153_0 {
	meta:
		name = "TOleControl.GetByteProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_33183_0 {
	meta:
		name = "TOleControl.GetShortIntProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_33189_0 {
	meta:
		name = "TOleControl.GetWordProp"
		size = 18
		refs = "000b TOleControl.GetIntegerProp"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_34444_0 {
	meta:
		name = "TPNGList.GetItem"
		size = 18
		refs = "000b TPNGPointerList.GetItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_40366_0 {
	meta:
		name = "TSQLConnection.GetDataSet"
		size = 18
		refs = "000b TCustomConnection.GetDataSet"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37705_0 {
	meta:
		name = "TScreenTipsCollection.Insert"
		size = 18
		refs = "000b TCollection.Insert"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37849_0 {
	meta:
		name = "TScriptBlock.GetBlockName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37848_0 {
	meta:
		name = "TScriptBlock.GetScript"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37845_0 {
	meta:
		name = "TScriptBlocks.FindBlockName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50247_0 {
	meta:
		name = "TScriptFile.GetLongName"
		size = 18
		refs = "000b TScriptFile.GetApplicationName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_50249_0 {
	meta:
		name = "TScriptFile.GetShortName"
		size = 18
		refs = "000b TScriptFile.GetApplicationName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12368_0 {
	meta:
		name = "TStoredProc.PSGetTableName"
		size = 18
		refs = "000b TDataSet.PSGetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19231_0 {
	meta:
		name = "TTableList.GetItems"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_45100_0 {
	meta:
		name = "TTeeExportFormats.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44062_0 {
	meta:
		name = "TTeeFilter.Description"
		size = 18
		refs = "000b TObject.ClassName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46561_0 {
	meta:
		name = "TTeePanelsList.Get"
		size = 18
		refs = "000b TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47475_0 {
	meta:
		name = "TTimeSpan.&op_Explicit"
		size = 18
		refs = "000b TTimeSpan.ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47494_0 {
	meta:
		name = "TTimeSpan.&op_Implicit"
		size = 18
		refs = "000b TTimeSpan.ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47500_0 {
	meta:
		name = "TTimeSpan.&op_UnaryNegation"
		size = 18
		refs = "000b TTimeSpan.Negate"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36298_0 {
	meta:
		name = "TValue.&op_Implicit"
		size = 18
		refs = "000b TValue.From<System.string>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36304_0 {
	meta:
		name = "TValue.&op_Implicit"
		size = 18
		refs = "000b TValue.From<System.Boolean>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36299_0 {
	meta:
		name = "TValue.&op_Implicit"
		size = 18
		refs = "000b TValue.From<System.Integer>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36325_0 {
	meta:
		name = "TValue.AsInterface"
		size = 18
		refs = "000b TValue.AsType<System.IInterface>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36326_0 {
	meta:
		name = "TValue.AsString"
		size = 18
		refs = "000b TValue.AsType<System.string>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36327_0 {
	meta:
		name = "TValue.AsVariant"
		size = 18
		refs = "000b TValue.AsType<System.Variant>"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37854_0 {
	meta:
		name = "TVar.GetScript"
		size = 18
		refs = "000b TNameContentScriptObject.GetContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37855_0 {
	meta:
		name = "TVar.GetVarName"
		size = 18
		refs = "000b TNameContentScriptObject.GetName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37851_0 {
	meta:
		name = "TVars.FindVarName"
		size = 18
		refs = "000b TScriptObjectContainer.FindNameObject"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5800_0 {
	meta:
		name = "TWorkAreas.Insert"
		size = 18
		refs = "000b TCollection.Insert"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54271_0 {
	meta:
		name = "TXMLBroker.SubmitFormVarName"
		size = 18
		refs = "000b TXMLBroker.HTMLSubmitFormName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_55252_0 {
	meta:
		name = "TXSBaseDuration.NativeToXSAsDateTime"
		size = 18
		refs = "000b TXSBaseCustomDateTime.NativeToXS"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46566_0 {
	meta:
		name = "TeeStr"
		size = 18
		refs = "000b IntToStr"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3591_0 {
	meta:
		name = "ToLower"
		size = 18
		refs = "000b TCharacter.ToLower"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3593_0 {
	meta:
		name = "ToUpper"
		size = 18
		refs = "000b TCharacter.ToUpper"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42254_0 {
	meta:
		name = "UTF8ShortStringToString"
		size = 18
		refs = "000b UTF8ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42637_0 {
	meta:
		name = "UTF8ToString"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42632_0 {
	meta:
		name = "UTF8ToWideString"
		size = 18
		refs = "000b UTF8Decode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42641_0 {
	meta:
		name = "Utf8ToAnsi"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "TActionListCollection.SetListItem"
		size = 29
		refs = "000e TActionListCollection.GetListItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12117_0 {
	meta:
		name = "TBDEDataSet.SetIndexField"
		size = 29
		refs = "000e TBDEDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_25385_0 {
	meta:
		name = "TCookieCollection.SetCookie"
		size = 29
		refs = "000e TCookieCollection.GetCookie"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1820_0 {
	meta:
		name = "TCustomADODataSet.SetIndexField"
		size = 29
		refs = "000e TCustomADODataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_10618_0 {
	meta:
		name = "TCustomClientDataSet.SetIndexField"
		size = 29
		refs = "000e TCustomClientDataSet.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_11472_0 {
	meta:
		name = "TDBGridColumns.SetColumn"
		size = 29
		refs = "000e TDBGridColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8976_0 {
	meta:
		name = "TFields.SetField"
		size = 29
		refs = "000e TFields.GetField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12470_0 {
	meta:
		name = "THTMLTableColumns.SetColumn"
		size = 29
		refs = "000e THTMLTableColumns.GetColumn"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_27727_0 {
	meta:
		name = "TIBTable.SetIndexField"
		size = 29
		refs = "000e TIBTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_5861_0 {
	meta:
		name = "TListItems.SetItem"
		size = 29
		refs = "000e TListItems.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_40544_0 {
	meta:
		name = "TSQLTable.SetIndexField"
		size = 29
		refs = "000e TSQLTable.GetIndexField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_25432_0 {
	meta:
		name = "TWebActionItems.SetActionItem"
		size = 29
		refs = "000e TWebActionItems.GetActionItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_50696_0 {
	meta:
		name = "TWebUserItems.SetUserItem"
		size = 29
		refs = "000e TWebUserItems.GetUserItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 8B 08 FF 51 08 5F 5E 5B C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "TActionClientsCollection.GetActionManager"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TActionManager 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3411_0 {
	meta:
		name = "TButtonCategories.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TButtonCategory 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3388_0 {
	meta:
		name = "TButtonCollection.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TButtonItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1307_0 {
	meta:
		name = "TCustomMenuButton.GetMenu"
		size = 23
		refs = "0006 TCustomActionControl.GetActionBar 000c _DV_TCustomActionMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1187_0 {
	meta:
		name = "TCustomMenuExpandBtn.GetMenu"
		size = 23
		refs = "0006 TCustomActionControl.GetActionBar 000c _DV_TCustomActionMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36087_0 {
	meta:
		name = "TOptionItems.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TOptionItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36088_0 {
	meta:
		name = "TOptionItems.GetApplicationMenu"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TRibbonApplicationMenuBar 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1572_0 {
	meta:
		name = "TParameters.AddParameter"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TParameter 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35452_0 {
	meta:
		name = "TRibbonTabs.Add"
		size = 23
		refs = "0006 TCollection.Add 000c _DV_TRibbonTabItem 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35459_0 {
	meta:
		name = "TRibbonTabs.GetRibbon"
		size = 23
		refs = "0006 TCollection.Owner 000c _DV_TCustomRibbon 0011 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "IfHotkeyAvailable"
		size = 46
		refs = "000b AnsiPos 0025 @UStrDelete"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 11 8B 55 08 83 C2 FC B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_30090_0 {
	meta:
		name = "IfHotkeyAvailable"
		size = 46
		refs = "000b Pos 0025 @UStrDelete"
	strings:
		$1 = { 55 8B EC 53 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 85 C0 0F 95 C3 84 DB 74 11 8B 55 08 83 C2 FC B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "CopyToBest"
		size = 129
		refs = "0078 @UStrLAsg"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 45 08 8B 50 F4 8B 45 08 8B 40 F8 8B 08 FF 51 08 8B 45 08 8B 40 F4 8B 10 FF 52 14 8B 55 08 89 42 F0 8B 45 08 8B 40 EC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 31 46 33 DB 8B 45 08 8B 40 EC 8B D3 8B 08 FF 51 18 50 8B 45 08 8B 40 EC 8B D3 8B 08 FF 51 18 8B 50 20 8B 45 08 8B 40 F8 59 8B 38 FF 57 3C 43 4E 75 D2 8B 45 08 83 C0 E8 8B 55 08 8B 52 FC E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "InsertHotkeyFarEastFormat"
		size = 468
		refs = "001d InsertHotkeyFarEastFormat 0041 @InternalUStrFromLStr 0061 TCharacter.GetUnicodeCategory 00b8 @UStrCopy 00c5 @UStrEqual 0127 @UStrCatN 0160 @UStrInsert 017a @UStrArrayClr 0180 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 89 5D F0 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 00 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 8B D8 85 DB 7E 23 BF 01 00 00 00 8B 06 0F B7 44 78 FE E8 ?? ?? ?? ?? 3C 07 74 04 3C 0F 75 06 C6 45 F7 01 EB 04 47 4B 75 E2 80 7D F7 00 0F 84 CE 00 00 00 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 F0 50 8B D3 83 EA 03 42 8B 06 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 62 8B 06 85 C0 74 14 8B D0 83 EA 0A 66 83 3A 02 74 09 8B 16 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 EC 50 8B CB 83 E9 03 8B 06 BA 01 00 00 00 E8 ?? ?? ?? ?? FF 75 EC 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B C6 BA 06 00 00 00 E8 ?? ?? ?? ?? EB 37 FF 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC 68 ?? ?? ?? ?? 8B C6 BA 05 00 00 00 E8 ?? ?? ?? ?? EB 15 83 7D F8 00 74 0F 8B D6 8B 4D F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 03 00 00 00 2E 00 2E 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 28 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 26 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 29 00 00 00 }
	condition:
		$1
}

rule function_772_0 {
	meta:
		name = "TActionClientsCollection.InternalRethinkHotkeys"
		size = 1444
		refs = "002c TActionClientsCollection.InternalRethinkHotkeys 0054 ValidMenuHotkeys 005b @UStrLAsg 0062 _Dn_TStringList 0067 TStringList.Create 00d2 TActionClientsCollection.GetActionClient 00f4 @UStrEqual 0125 GetHotkey 0130 UpperCase 0141 TCollection.GetItem 016c AnsiPos 0179 IfHotkeyAvailable 01a3 StripHotkey 01ac @UStrAsg 0264 @InternalUStrFromLStr 028e @UStrCopy 02ac SysLocale 02bf InsertHotkeyFarEastFormat 02d0 @UStrInsert 02fe @EnsureUnicodeString 0303 @UStrLen 032b CopyToBest 048a @UStrDelete 04c1 TObject.Free 04df @HandleFinally 0556 @UStrArrayClr 056b @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 B4 53 56 33 C9 89 4D B4 89 4D B8 89 4D BC 89 4D C0 89 4D E4 89 4D E0 89 4D DC 89 4D FC 89 4D E8 89 45 D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 D7 00 8B 45 D8 80 78 1C 00 0F 84 F9 04 00 00 84 D2 0F 84 96 04 00 00 8D 45 FC 8B 15 ?? ?? ?? ?? 8B 12 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 D0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C0 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 D8 8B 40 08 8B 40 08 48 85 C0 0F 8C 20 01 00 00 40 89 45 C4 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 80 78 30 00 0F 84 F4 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 D6 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 78 20 00 0F 84 C1 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 8D 55 C0 E8 ?? ?? ?? ?? 8B 45 C0 8D 55 E4 E8 ?? ?? ?? ?? 83 7D E4 00 75 26 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 48 20 33 D2 8B 45 D0 8B 18 FF 53 64 EB 74 8B 15 ?? ?? ?? ?? 8B 12 8B 45 E4 E8 ?? ?? ?? ?? 85 C0 74 60 55 8B 45 E4 E8 ?? ?? ?? ?? 59 84 C0 75 52 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 C0 20 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 20 8D 55 BC E8 ?? ?? ?? ?? 8B 55 BC 58 E8 ?? ?? ?? ?? 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 50 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 48 20 33 D2 8B 45 D0 8B 18 FF 53 64 FF 45 CC FF 4D C4 0F 85 EB FE FF FF 8D 45 DC 8B 55 FC E8 ?? ?? ?? ?? 8B 45 D0 8B 10 FF 52 14 48 85 C0 0F 8C 92 01 00 00 40 89 45 C4 8D 45 FC 8B 55 DC E8 ?? ?? ?? ?? 8B 55 D0 8B 45 EC 8B 08 FF 51 08 8B 45 F4 8B 10 FF 52 44 8B 45 EC 8B 10 FF 52 14 48 83 F8 00 0F 8C EC 00 00 00 89 45 CC 8D 4D E0 8B 55 CC 8B 45 EC 8B 18 FF 53 0C BB 01 00 00 00 E9 AF 00 00 00 8B 75 E0 85 F6 74 18 8B C6 83 E8 0A 66 83 38 02 74 0D 8D 45 E0 8B 55 E0 E8 ?? ?? ?? ?? 8B F0 66 81 7C 5E FE 00 D8 72 0C 66 81 7C 5E FE FF DF 77 03 43 EB 7A 8D 45 B8 50 B9 01 00 00 00 8B D3 8B 45 E0 E8 ?? ?? ?? ?? 8B 45 B8 8D 55 E4 E8 ?? ?? ?? ?? 55 8B 45 E4 E8 ?? ?? ?? ?? 59 84 C0 74 4E A1 ?? ?? ?? ?? 80 78 0C 00 74 0F 8D 45 E0 8B CB 8B 55 E4 E8 ?? ?? ?? ?? EB 0F 8D 55 E0 8B CB B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 CC 8B 45 EC 8B 08 FF 51 18 8B C8 8B 55 E0 8B 45 F4 8B 18 FF 53 3C 8B 55 CC 8B 45 EC 8B 08 FF 51 48 EB 16 43 8D 45 E0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B D8 0F 8E 3C FF FF FF FF 4D CC 83 7D CC FF 0F 85 17 FF FF FF 8B 45 F4 8B 10 FF 52 14 3B 45 F0 7E 07 55 E8 ?? ?? ?? ?? 59 8B 45 EC 8B 10 FF 52 14 85 C0 7E 52 8B 45 EC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 3A 46 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 EC 8B 08 FF 51 18 8B D0 8B 45 D0 8B 08 FF 51 5C 8B D8 8B 45 D0 8B 10 FF 52 14 8B C8 49 8B D3 8B 45 D0 8B 18 FF 53 78 FF 45 CC 4E 75 CE FF 4D C4 0F 85 72 FE FF FF 83 7D F0 00 75 07 55 E8 ?? ?? ?? ?? 59 8B 45 F8 8B 10 FF 52 14 85 C0 0F 9F 45 D7 8B 45 F8 8B 10 FF 52 14 48 85 C0 0F 8C F6 00 00 00 40 89 45 C4 C7 45 CC 00 00 00 00 8D 4D E0 8B 55 CC 8B 45 F8 8B 18 FF 53 0C A1 ?? ?? ?? ?? 80 78 0C 00 0F 84 AC 00 00 00 8B 55 E0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 97 00 00 00 83 7D E8 00 0F 84 8D 00 00 00 8B 55 E0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 7C 8B 45 E8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 E8 8B 55 E8 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8D 45 B4 50 B9 01 00 00 00 8B D3 8B 45 E8 E8 ?? ?? ?? ?? 8B 55 B4 8D 45 E0 33 C9 E8 ?? ?? ?? ?? 8B 45 E8 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 E8 8B 55 E8 E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 8D 55 E8 B9 01 00 00 00 92 E8 ?? ?? ?? ?? 8B 55 CC 8B 45 F8 8B 08 FF 51 18 83 C0 20 8B 55 E0 E8 ?? ?? ?? ?? FF 45 CC FF 4D C4 0F 85 15 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 D0 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 8B 45 D8 8B 40 08 8B 40 08 48 85 C0 7C 4D 40 89 45 C4 C7 45 CC 00 00 00 00 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 83 78 2C 00 74 29 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 2C 80 78 1C 00 74 15 8B 55 CC 8B 45 D8 E8 ?? ?? ?? ?? 8B 40 2C B2 01 E8 ?? ?? ?? ?? FF 45 CC FF 4D C4 75 BE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 B4 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D6 0F B6 45 D7 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 26 00 00 00 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "TActionClientsCollection.Create"
		size = 67
		refs = "000d @ClassCreate 001e TOwnedCollection.Create 002d @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 1C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "TActionClientsCollection.AfterConstruction"
		size = 16
		refs = "0006 TObject.AfterConstruction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_1880_0 {
	meta:
		name = "TADOBlobStream.Truncate"
		size = 16
		refs = "0006 TMemoryStream.Clear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_1879_0 {
	meta:
		name = "TADOBlobStream.Write"
		size = 16
		refs = "0006 TMemoryStream.Write"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_10726_0 {
	meta:
		name = "TClientBlobStream.Truncate"
		size = 16
		refs = "0006 TMemoryStream.Clear"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_10725_0 {
	meta:
		name = "TClientBlobStream.Write"
		size = 16
		refs = "0006 TMemoryStream.Write"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? C6 43 24 01 5B C3 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "UpdateActionBar"
		size = 56
		refs = "0007 TActionClient.GetItems 0031 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 74 20 8B C3 E8 ?? ?? ?? ?? 8B 50 20 85 D2 74 12 83 7A 0C 00 74 0C 8B 42 0C 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "TActionClientsCollection.IterateClients"
		size = 289
		refs = "002f TActionClientsCollection.GetActionClient 0034 TActionClient.GetHasItems 0074 TActionClient.GetItems 007e TActionClientsCollection.IterateClients 008c UpdateActionBar"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 8B F2 89 45 FC 85 F6 0F 84 04 01 00 00 8B 46 08 8B 40 08 48 85 C0 0F 8C F5 00 00 00 40 89 45 F8 33 DB 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 56 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 FF 75 0C FF 75 08 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 7D 8B D3 8B C6 E8 ?? ?? ?? ?? 83 78 0C 00 74 38 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 36 66 83 7D 0A 00 74 13 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 0C FF 55 08 EB 0E 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 30 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 43 FF 4D F8 0F 85 11 FF FF FF 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "TActionClientsCollection.SetAutoHotKeys"
		size = 16
		refs = "000b TActionClientsCollection.InternalRethinkHotkeys"
	strings:
		$1 = { 3A 50 1C 74 0A 88 50 1C B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "TActionClient.Create"
		size = 96
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 003a TActionClient.Create 0048 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 38 C6 46 14 00 C6 46 30 01 C6 46 28 01 C7 46 24 00 00 00 20 C6 46 14 00 0F B6 05 ?? ?? ?? ?? 88 46 31 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 07 00 00 00 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "TActionClient.Destroy"
		size = 121
		refs = "0004 @BeforeDestruction 0019 TObject.Free 0039 TActionClient.ClearActionBar 0056 TActionClient.FreeChildren 0064 TCollectionItem.Destroy 0071 @ClassDestroy"
	strings:
		$1 = { 53 56 51 E8 ?? ?? ?? ?? 88 14 24 8B D8 8D 43 1C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 73 0C 85 F6 74 12 F6 46 1C 08 75 0C 8B C6 33 D2 8B 08 FF 91 40 01 00 00 8B C3 E8 ?? ?? ?? ?? 83 7B 10 00 74 10 8D 43 10 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 0F B6 14 24 80 E2 FC 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 7E 07 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "TActionClient.AreContextItemsStored"
		size = 90
	strings:
		$1 = { 8B 50 1C 85 D2 74 50 8B 4A 08 83 79 08 00 7E 04 B1 01 EB 07 0F B6 4A 1C 80 F1 01 84 C9 74 04 B1 01 EB 07 80 7A 28 01 0F 95 C1 84 C9 74 04 B1 01 EB 07 0F B6 4A 24 80 F1 01 84 C9 74 04 B1 01 EB 07 0F B6 4A 2A 80 F1 01 84 C9 74 04 B0 01 EB 09 0F B6 42 29 34 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "TActionClient.Assign"
		size = 239
		refs = "000f _DV_TActionClient 0014 @IsClass 0035 TActionClient.Assign 0056 TActionClient.GetContextItems 0065 TActionClient.HasBackground 0070 TActionClient.GetBackground 008b TActionClient.SetBackgroundLayout 00a5 TActionClient.GetItems 00b8 TActionClient.SetActionBar 00da @HandleFinally 00e6 TPersistent.Assign"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 C0 00 00 00 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B 56 24 8B 45 FC 8B 08 FF 51 28 83 7E 1C 00 74 10 8B 45 FC E8 ?? ?? ?? ?? 8B 56 1C 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 84 C0 74 16 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 0F B6 56 14 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 30 8B 45 FC 8B 08 FF 51 2C 83 7E 2C 00 74 10 8B 45 FC E8 ?? ?? ?? ?? 8B 56 2C 8B 08 FF 51 08 8B 56 0C 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "TActionClient.ClearActionBar"
		size = 6
		altNames = "TTreeNodes.ClearCache"
	strings:
		$1 = { 33 D2 89 50 0C C3 }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "TActionClient.FreeChildren"
		size = 84
		refs = "0026 TActionClients.GetActionClient 003b TActionClient.FreeChildren 0047 TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B 53 2C 85 D2 74 44 8B 42 08 8B 40 08 85 C0 7E 2D 8B F8 4F 85 FF 7C 26 47 33 F6 8B D6 8B 43 2C E8 ?? ?? ?? ?? 83 78 2C 00 74 0F 8B D6 8B 43 2C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4F 75 DD 8B 43 2C E8 ?? ?? ?? ?? 33 C0 89 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "TActionClient.GetBackground"
		size = 29
		refs = "000c _Dn_TPicture 0011 TPicture.Create"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B 43 10 5B C3 }
	condition:
		$1
}

rule function_44066_0 {
	meta:
		name = "TTeeFilter.GetRegion"
		size = 29
		refs = "000c _DV_TFilterRegion 0011 TObject.Create"
	strings:
		$1 = { 53 8B D8 83 7B 10 00 75 0F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 10 8B 43 10 5B C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "TActionClient.GetContextItems"
		size = 49
		refs = "000a _DV_TActionClientItem 0012 TActionClient.GetOwningCollection 0017 TActionClientsCollection.GetActionManager 0020 _DV_TActionClients 0025 TActionClients.Create"
	strings:
		$1 = { 53 8B D8 83 7B 1C 00 75 23 A1 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 1C 8B 43 1C 5B C3 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "TActionClient.GetHasItems"
		size = 21
	strings:
		$1 = { 8B 50 2C 85 D2 74 0B 8B 42 08 83 78 08 00 0F 9F C0 C3 33 C0 C3 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "TActionClientItem.GetParentItem"
		size = 30
		refs = "0006 TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0C 8B C3 E8 ?? ?? ?? ?? 8B 40 20 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "TActionClient.GetItems"
		size = 153
		refs = "0012 TActionClient.GetOwningCollection 0022 TActionClientsCollection.GetActionManager 003f @CallDynaInst 006a _DV_TActionClientItem 0080 _DV_TActionClients 0085 TActionClients.Create"
	strings:
		$1 = { 53 56 57 8B D8 83 7B 2C 00 0F 85 83 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 4F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 3F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 8B C7 66 BE ED FF E8 ?? ?? ?? ?? 50 8B C7 66 BE EE FF E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 28 89 43 2C EB 23 A1 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 2C 8B 43 2C 89 58 20 8B 43 2C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "TActionClient.HasBackground"
		size = 39
		altNames = "TActionClient.IsBackgroundStored"
	strings:
		$1 = { 53 56 8B D8 8B 73 10 85 F6 74 12 83 7E 0C 00 74 0C 8B 46 0C 8B 10 FF 52 20 84 C0 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "TActionClient.HasVisibleItems"
		size = 114
		refs = "000b TActionClient.GetItems 0029 TActionClients.GetActionClient 002e TActionClientItem.Unused 005d TActionClient.HasVisibleItems"
	strings:
		$1 = { 53 56 57 55 8B F0 33 DB 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 4F 47 33 ED 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 18 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 80 78 30 00 74 04 B3 01 EB 19 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 02 B3 01 45 4F 75 B4 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "TActionClient.IsChildItem"
		size = 83
		refs = "0014 TActionClient.GetItems 0024 TActionClient.GetOwningCollection"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 85 F6 74 10 85 F6 74 10 8B C6 E8 ?? ?? ?? ?? 3B 47 04 75 04 B3 01 EB 2C 8B C7 E8 ?? ?? ?? ?? 8B 78 20 85 FF 74 1E 8B C6 E8 ?? ?? ?? ?? 3B 47 04 75 04 B3 01 EB 0E 8B C7 E8 ?? ?? ?? ?? 8B 78 20 85 FF 75 E2 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_795_0 {
	meta:
		name = "TActionClient.IsItemsStored"
		size = 90
	strings:
		$1 = { 8B 50 2C 85 D2 74 50 8B 4A 08 83 79 08 00 7E 04 B1 01 EB 07 0F B6 4A 1C 80 F1 01 84 C9 74 04 B1 01 EB 07 80 7A 28 01 0F 95 C1 84 C9 74 04 B1 01 EB 07 0F B6 4A 24 80 F1 01 84 C9 74 04 B1 01 EB 07 0F B6 4A 2A 80 F1 01 84 C9 74 04 B0 01 EB 09 0F B6 42 29 34 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "TActionClient.SetActionBar"
		size = 247
		refs = "0017 TActionClient.SetActionBar 0030 TActionClient.GetOwningCollection 004b SAssignSubItemError 0050 LoadResString 005a _Dn_Exception 005f Exception.Create 0064 @RaiseExcept 00a1 TActionClientsCollection.GetActionManager 00e4 @UStrClr 00ea @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D F8 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 46 0C 3B 45 FC 0F 84 A6 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 41 8B 7B 20 85 FF 74 34 83 7F 0C 00 74 23 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8B C7 E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 85 DB 75 BF 8B 46 0C 85 C0 74 11 83 B8 78 02 00 00 00 74 08 8B 10 FF 92 F4 00 00 00 83 7D FC 00 74 34 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 40 1C 01 75 22 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 B8 A8 00 00 00 00 75 0D 8B D6 8B 45 FC 8B 08 FF 91 40 01 00 00 8B 45 FC 89 46 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "TActionClient.SetItems"
		size = 30
		refs = "0010 TObject.Free"
	strings:
		$1 = { 85 D2 75 11 83 C0 2C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 8B 40 2C 8B 08 FF 51 08 C3 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "TActionClient.SetBackground"
		size = 128
		refs = "0018 TActionClient.GetHasItems 0028 TCustomActionBar.GetItems 0047 TActionClients.GetActionClient 005f TCustomActionControl.SetTransparent 006d TWinControl.AlignControl"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B D3 8B 46 10 8B 08 FF 51 08 85 DB 74 67 8B C6 E8 ?? ?? ?? ?? 84 C0 74 5C 8B 46 0C 85 C0 74 55 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B D8 4B 85 DB 7C 2E 43 33 FF 8B 46 0C E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 0F B6 56 14 80 C2 FD 80 EA 02 0F 92 C2 80 F2 01 E8 ?? ?? ?? ?? 47 4B 75 D5 8B 46 0C 33 D2 E8 ?? ?? ?? ?? 8B 46 0C 8B 10 FF 92 90 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "TActionClient.SetBackgroundLayout"
		size = 153
		refs = "0017 TActionClient.HasBackground 0022 TActionClient.GetHasItems 002d TActionClient.GetItems 004b TActionClients.GetActionClient 0075 TCustomActionControl.SetTransparent"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F0 3A 5E 14 0F 84 83 00 00 00 88 5E 14 8B C6 E8 ?? ?? ?? ?? 84 C0 74 5E 8B C6 E8 ?? ?? ?? ?? 84 C0 74 53 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 3F 47 33 ED 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 83 78 44 00 74 24 8B C6 E8 ?? ?? ?? ?? 8B D5 E8 ?? ?? ?? ?? 8B 40 44 8B D3 80 C2 FD 80 EA 02 0F 92 C2 80 F2 01 E8 ?? ?? ?? ?? 45 4F 75 C4 8B 46 0C 85 C0 74 10 8B 10 FF 52 68 8B 46 0C 8B 10 FF 92 90 00 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_801_0 {
	meta:
		name = "TActionClient.SetChangesAllowed"
		size = 26
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 04 24 3A 43 31 74 07 0F B6 04 24 88 43 31 5A 5B C3 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "TActionClient.SetColor"
		size = 20
	strings:
		$1 = { 56 8B F0 3B 56 24 74 0A 89 56 24 8B C6 8B 10 FF 52 20 5E C3 }
	condition:
		$1
}

rule function_803_0 {
	meta:
		name = "TActionClient.SetContextItems"
		size = 4
		altNames = "TDBXContext.SetTraceLevel TDBXDelegateTable.SetTable TDBXDriverHelp.SetMetaDataReader TDirect2DFont.SetHeight TParamStreamObject.SetKnownSize TProxyModuleNotifier.SetNotifierIndex TSeriesPointer.ChangeHorizSize TStreamLoader.SetTimeout"
	strings:
		$1 = { 89 50 1C C3 }
	condition:
		$1
}

rule function_804_0 {
	meta:
		name = "TActionClient.SetVisible"
		size = 16
		refs = "000b NotifyDesigner"
	strings:
		$1 = { 3A 50 30 74 0A 88 50 30 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "TActionBarItem.ColorChanged"
		size = 38
		refs = "0017 TControl.SetParentColor 0021 TControl.SetColor"
	strings:
		$1 = { 8B 50 0C 85 D2 74 1E 8B 48 24 81 F9 00 00 00 20 75 0B 8B C2 B2 01 E8 ?? ?? ?? ?? EB 08 8B C1 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "TActionBarItem.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TActionClient.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 3C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "TActionBarItem.GetDisplayName"
		size = 84
		refs = "0014 TActionBarItem.GetDisplayName 0019 @UStrCat3 0024 TCollectionItem.GetDisplayName"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B 7B 0C 85 FF 74 11 8B 4F 08 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 09 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 0C 00 00 00 41 00 63 00 74 00 69 00 6F 00 6E 00 42 00 61 00 72 00 20 00 2D 00 3E 00 00 00 00 00 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TActionBarItem.Refresh"
		size = 23
	strings:
		$1 = { 56 8B 70 0C 85 F6 74 0D F6 46 1C 01 75 07 8B C6 8B 10 FF 52 68 5E C3 }
	condition:
		$1
}

rule function_810_0 {
	meta:
		name = "TActionBarItem.SetAutoSize"
		size = 28
	strings:
		$1 = { 56 8B F0 3A 56 3C 74 12 88 56 3C 8B 46 0C 85 C0 74 08 8B 10 FF 92 F0 00 00 00 5E C3 }
	condition:
		$1
}

rule function_811_0 {
	meta:
		name = "TActionBarItem.SetGlyphLayout"
		size = 272
		refs = "0037 TActionBarItem.SetGlyphLayout 0045 TActionClient.GetItems 0064 TActionClients.GetActionClient 00a2 TWinControl.EnableAlign 00b1 @CallDynaInst 00b7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B DA 89 45 FC 8B 45 FC 3A 58 3D 0F 84 F2 00 00 00 8B 45 FC 88 58 3D 8B 45 FC 8B 40 0C 85 C0 0F 84 91 00 00 00 66 FF 80 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 38 46 33 FF 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 83 78 44 00 74 1C 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 8B D3 8B 08 FF 91 F0 00 00 00 47 4E 75 CB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 0C E8 ?? ?? ?? ?? 8B 45 FC 8B 40 0C 66 BE D0 FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 38 46 33 FF 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 83 78 44 00 74 1C 8B 45 FC E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B 40 44 8B D3 8B 08 FF 91 F0 00 00 00 47 4E 75 CB 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "TActionBarItem.SetVisible"
		size = 28
		refs = "0006 TActionClient.SetVisible 0016 TControl.SetVisible"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 85 C0 74 09 0F B6 53 30 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "TActionBars.Create"
		size = 86
		refs = "000d @ClassCreate 001e TActionClientsCollection.Create 002c TActionBars.SetShowHints 0035 TActionBars.SetHintShortCuts 0040 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 89 46 28 B2 01 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "TActionBars.DoShowHint"
		size = 44
		refs = "000a _DV_TActionBarItem 000f @IsClass 0025 TControl.SetShowHint"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 12 83 7B 0C 00 74 0C 8B 43 0C 0F B6 56 2C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "TActionBars.GetHintShortCuts"
		size = 25
		refs = "0004 Application"
	strings:
		$1 = { 33 C0 8B 15 ?? ?? ?? ?? 83 3A 00 74 0B A1 ?? ?? ?? ?? 8B 00 0F B6 40 7C C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TActionBars.Loaded"
		size = 105
		refs = "001e TActionBars.GetActionBar 0027 _Dn_TCustomActionDockBar 002c @IsClass"
	strings:
		$1 = { 53 56 57 51 89 04 24 8B 04 24 8B 40 08 8B 78 08 4F 85 FF 7C 4F 47 33 F6 8B D6 8B 04 24 E8 ?? ?? ?? ?? 8B 40 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 8B D6 8B 04 24 E8 ?? ?? ?? ?? 8B 58 0C 8B C3 8B 10 FF 92 88 01 00 00 50 8B 43 4C 50 8B 4B 44 8B 53 40 8B C3 8B 18 FF 93 98 00 00 00 46 4F 75 B4 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TActionBars.Notify"
		size = 55
		refs = "000b TCollection.Notify 0018 _DV_TActionBarItem 001d @IsClass"
	strings:
		$1 = { 53 56 8B D9 8B F2 8B CB 8B D6 E8 ?? ?? ?? ?? 80 FB 02 75 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 46 0C 85 C0 74 08 33 D2 89 90 78 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TActionBars.SetShowHints"
		size = 22
		refs = "000a TActionBars.DoShowHint 0011 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 3A 50 2C 74 10 88 50 2C 50 68 ?? ?? ?? ?? 8B D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TActionBars.SetHintShortCuts"
		size = 21
		refs = "0001 Application"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 38 00 74 0A A1 ?? ?? ?? ?? 8B 00 88 50 7C C3 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TActionClients.Create"
		size = 79
		refs = "000d @ClassCreate 001e TActionClientsCollection.Create 0039 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 45 08 50 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 28 01 C6 46 29 01 C6 46 2A 01 C6 46 1C 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TActionClients.Assign"
		size = 90
		refs = "000c TCollection.Assign 0014 _DV_TActionClients 0019 @IsClass 002a TActionClientsCollection.SetAutoHotKeys 003c TActionClients.SetHideUnused 0047 TActionClients.SetCaptionOptions 0052 TActionClients.SetSmallIcons"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B FE 0F B6 57 1C 8B C3 E8 ?? ?? ?? ?? 0F B6 47 24 88 43 24 0F B6 57 2A 8B C3 E8 ?? ?? ?? ?? 0F B6 57 28 8B C3 E8 ?? ?? ?? ?? 0F B6 57 29 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TActionClients.DoHideUnused"
		size = 56
		refs = "000b _DV_TActionClientItem 0010 @IsClass 0027 TActionClient.GetItems 0030 TActionClients.SetHideUnused"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B F3 C6 46 40 01 83 7E 2C 00 74 10 8B C6 E8 ?? ?? ?? ?? 0F B6 57 2A E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TActionClients.DoShowCaptions"
		size = 37
		refs = "0007 _DV_TActionClientItem 000c @IsClass"
	strings:
		$1 = { 53 8B DA 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 43 44 85 C0 74 08 8B 10 FF 92 F8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TActionClients.Notify"
		size = 364
		refs = "0010 TCollection.Notify 0030 _DV_TActionClient 0035 @AsClass 004b TActionClient.GetOwningCollection 0052 TActionClientsCollection.InternalRethinkHotkeys 0084 TWinControl.HandleAllocated 00a5 _DV_TActionClientItem 00aa @IsClass 00bb TActionClientItem.GetParentItem 00fc TWinControl.GetHandle 0102 PostMessage 010b TActionClient.FreeChildren"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 EB 01 72 13 0F 84 82 00 00 00 FE CB 0F 84 E1 00 00 00 E9 3C 01 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5E 20 85 DB 0F 84 24 01 00 00 85 DB 74 0E 8B C3 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 33 DB 8B 56 20 8B 42 0C 85 C0 74 04 8B D8 EB 09 8B 42 18 85 C0 74 02 8B D8 83 7E 0C 00 0F 85 EF 00 00 00 85 DB 0F 84 E7 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 D8 00 00 00 8B D7 8B C3 8B 08 FF 91 5C 01 00 00 E9 C7 00 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 B2 00 00 00 8B DF 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 A1 00 00 00 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 0F 84 90 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 84 C0 74 7D 6A 00 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 60 8B C7 E8 ?? ?? ?? ?? 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 48 8B DF 8B C3 E8 ?? ?? ?? ?? 85 C0 74 3B 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 74 2E 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 84 C0 74 1B 6A 00 6A 00 6A 05 8B C3 E8 ?? ?? ?? ?? 8B 40 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TActionClients.SetCaptionOptions"
		size = 139
		refs = "0033 TActionClients.SetCaptionOptions 0042 TActionClients.DoShowCaptions 004d TActionClientsCollection.IterateClients 0068 TWinControl.EnableAlign 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 3A 50 28 74 79 8B 45 FC 88 50 28 8B 45 FC 8B 40 20 85 C0 74 55 83 78 0C 00 74 4F 8B 40 0C 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 50 68 ?? ?? ?? ?? 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B 45 FC 50 68 ?? ?? ?? ?? 8B 55 FC 8B 45 FC E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TActionClients.SetHideUnused"
		size = 41
		refs = "000e TActionClientsCollection.GetActionManager 001a TActionClients.DoHideUnused 0023 TActionClientsCollection.IterateClients"
	strings:
		$1 = { 53 8B D8 3A 53 2A 74 1F 88 53 2A 8B C3 E8 ?? ?? ?? ?? F6 40 1C 01 75 0F 53 68 ?? ?? ?? ?? 8B D3 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TActionClients.SetSmallIcons"
		size = 139
		refs = "0033 TActionClients.SetSmallIcons 0046 TActionClients.ToggleSmallIcons 006f TWinControl.EnableAlign 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 3A 50 29 74 79 8B 45 FC 88 50 29 8B 45 FC 8B 40 20 85 C0 74 5C 83 78 0C 00 74 56 8B 40 0C 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CA 8B 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C 8B 10 FF 52 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 20 8B 40 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 8B CA 8B 45 FC 8B 55 FC E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TActionClients.ToggleSmallIcons"
		size = 139
		refs = "0023 TActionClients.GetActionClient 003c TCustomActionControl.SetSmallIcon 004a TActionClient.GetHasItems 005c TActionClient.GetItems 0063 TActionClients.SetSmallIcons 007d TActionClients.ToggleSmallIcons"
	strings:
		$1 = { 53 56 57 55 51 8B D9 8B F2 89 04 24 85 F6 74 75 8B 46 08 8B 78 08 4F 85 FF 7C 6A 47 33 ED 8B D5 8B C6 E8 ?? ?? ?? ?? 83 78 44 00 74 13 8B D5 8B C6 E8 ?? ?? ?? ?? 8B 40 44 8B D3 E8 ?? ?? ?? ?? 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2F 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B D5 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B CB 8B 04 24 E8 ?? ?? ?? ?? 45 4F 75 99 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_834_0 {
	meta:
		name = "TActionClients.VisibleCount"
		size = 49
		refs = "001b TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B F8 33 ED 8B 47 08 8B 58 08 4B 85 DB 7C 17 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 80 78 30 00 74 01 45 46 4B 75 EC 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "TActionClientLink.AssignClient"
		size = 25
		refs = "000a _DV_TActionClientItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_3424_0 {
	meta:
		name = "TButtonItemActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TBaseButtonItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_7482_0 {
	meta:
		name = "TControlActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TControl 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_29986_0 {
	meta:
		name = "TMenuActionLink.AssignClient"
		size = 25
		refs = "000a _DV_TMenuItem 000f @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "TActionClientLink.DoShowHint"
		size = 252
		refs = "0019 TActionClientLink.DoShowHint 002c _Dn_TCustomAction 0031 @IsClass 0043 @CallDynaInst 004c Application 0085 ShortCutToText 00a1 Format 00ab @UStrAsg 00c0 @UStrClr 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D F8 89 4D E4 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 01 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 76 8B D7 8B 43 10 66 BE EF FF E8 ?? ?? ?? ?? 84 C0 74 64 A1 ?? ?? ?? ?? 8B 00 80 78 7C 00 74 57 8B 43 10 66 83 B8 84 00 00 00 00 74 4A 83 3F 00 74 45 8D 45 F8 50 8B 07 89 45 E8 C6 45 EC 11 8D 55 E4 8B 43 10 0F B7 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 07 00 00 00 25 00 73 00 20 00 28 00 25 00 73 00 29 00 00 00 }
	condition:
		$1
}

rule function_7483_0 {
	meta:
		name = "TControlActionLink.DoShowHint"
		size = 252
		refs = "0019 TControlActionLink.DoShowHint 002c _Dn_TCustomAction 0031 @IsClass 0043 @CallDynaInst 004c Application 0085 ShortCutToText 00a1 Format 00ab @UStrAsg 00c0 @UStrClr 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D F8 89 4D E4 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 01 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 76 8B D7 8B 43 10 66 BE EF FF E8 ?? ?? ?? ?? 84 C0 74 64 A1 ?? ?? ?? ?? 8B 00 80 78 7C 00 74 57 8B 43 10 66 83 B8 84 00 00 00 00 74 4A 83 3F 00 74 45 8D 45 F8 50 8B 07 89 45 E8 C6 45 EC 11 8D 55 E4 8B 43 10 0F B7 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 C6 45 F4 11 8D 55 E8 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 07 00 00 00 25 00 73 00 20 00 28 00 25 00 73 00 29 00 00 00 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "TActionClientLink.IsCaptionLinked"
		size = 194
		refs = "0011 TActionClientLink.IsCaptionLinked 001e TActionLink.IsCaptionLinked 002d TActionClientItem.GetCaption 003a _Dn_TCustomAction 003f @AsClass 0048 @UStrEqual 0076 StripHotkey 00ae @UStrArrayClr 00b4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 84 C0 74 28 8D 55 FC 8B 46 18 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 46 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 58 E8 ?? ?? ?? ?? 74 04 33 DB EB 02 B3 01 84 DB 75 40 8B 46 18 8B 40 04 80 78 1C 00 74 34 8D 55 F4 8B 46 18 E8 ?? ?? ?? ?? 8B 45 F4 8D 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 46 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 64 58 E8 ?? ?? ?? ?? 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "TActionClientLink.IsEnabledLinked"
		size = 63
		refs = "0006 TActionLink.IsEnabledLinked 0028 _Dn_TCustomAction 002d @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 29 8B 43 18 83 78 44 00 74 20 8B 43 18 8B 40 44 8B 10 FF 52 5C 50 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 3A 50 6A 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "TActionClientLink.IsHelpContextLinked"
		size = 47
		refs = "0006 TActionLink.IsHelpContextLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 19 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 74 8B 53 18 3B 42 68 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "TActionClientLink.IsHintLinked"
		size = 67
		refs = "0006 TActionLink.IsHintLinked 001c _Dn_TCustomAction 0021 @AsClass 0035 @UStrEqual"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 2D 8B 43 18 83 78 44 00 74 24 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 7C 8B 43 18 8B 40 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_841_0 {
	meta:
		name = "TActionClientLink.IsImageIndexLinked"
		size = 67
		refs = "0006 TActionLink.IsImageIndexLinked 001c _Dn_TCustomAction 0021 @AsClass 0035 @UStrEqual"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 2D 8B 43 18 83 78 44 00 74 24 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 7C 8B 43 18 8B 40 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_842_0 {
	meta:
		name = "TActionClientLink.IsOnExecuteLinked"
		size = 51
		refs = "0006 TBasicActionLink.IsOnExecuteLinked"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 8B 43 18 83 78 44 00 74 14 8B 43 18 8B 40 44 8B 80 10 01 00 00 8B 53 10 3B 42 40 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_843_0 {
	meta:
		name = "TActionClientLink.IsShortCutLinked"
		size = 52
		refs = "0006 TActionLink.IsShortCutLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1E 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8B 53 18 66 3B 42 4C 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_844_0 {
	meta:
		name = "TActionClientLink.IsVisibleLinked"
		size = 51
		refs = "0006 TActionLink.IsVisibleLinked 0013 _Dn_TCustomAction 0018 @AsClass"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1D 8B 43 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 80 86 00 00 00 8B 53 18 3A 42 30 74 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_845_0 {
	meta:
		name = "TActionClientLink.SetCaption"
		size = 30
		refs = "0017 TActionClientItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3430_0 {
	meta:
		name = "TButtonItemActionLink.SetCaption"
		size = 30
		refs = "0017 TBaseItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7492_0 {
	meta:
		name = "TControlActionLink.SetCaption"
		size = 30
		refs = "0017 TControl.SetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29999_0 {
	meta:
		name = "TMenuActionLink.SetCaption"
		size = 30
		refs = "0017 TMenuItem.SetCaption"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 20 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_846_0 {
	meta:
		name = "TActionClientLink.SetChecked"
		size = 46
		refs = "0006 TActionLink.SetChecked"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 24 84 C0 74 17 8B 43 18 83 78 44 00 74 0E 8B 43 18 8B 40 44 8B 10 FF 92 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_847_0 {
	meta:
		name = "TActionClientLink.SetEnabled"
		size = 33
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 52 28 84 C0 74 0D 8B 46 18 8B 40 44 8B D3 8B 08 FF 51 74 5E 5B C3 }
	condition:
		$1
}

rule function_848_0 {
	meta:
		name = "TActionClientLink.SetHelpContext"
		size = 26
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 30 84 C0 74 06 8B 43 18 89 70 68 5E 5B C3 }
	condition:
		$1
}

rule function_849_0 {
	meta:
		name = "TActionClientLink.SetHint"
		size = 38
		refs = "001f @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 38 84 C0 74 12 8B 43 18 8B 40 44 05 80 00 00 00 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_850_0 {
	meta:
		name = "TActionClientLink.SetImageIndex"
		size = 30
		refs = "0017 TActionClientItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3432_0 {
	meta:
		name = "TButtonItemActionLink.SetImageIndex"
		size = 30
		refs = "0017 TBaseButtonItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_30004_0 {
	meta:
		name = "TMenuActionLink.SetImageIndex"
		size = 30
		refs = "0017 TMenuItem.SetImageIndex"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_851_0 {
	meta:
		name = "TActionClientLink.SetOnExecute"
		size = 46
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 8B 10 FF 52 08 84 C0 74 18 8B 43 18 8B 40 44 8B 55 08 89 90 10 01 00 00 8B 55 0C 89 90 14 01 00 00 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_852_0 {
	meta:
		name = "TActionClientLink.SetShortCut"
		size = 30
		refs = "0017 TActionClientItem.SetShortCut"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 40 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_30005_0 {
	meta:
		name = "TMenuActionLink.SetShortCut"
		size = 30
		refs = "0017 TMenuItem.SetShortCut"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 8B 10 FF 52 40 84 C0 74 0A 8B D6 8B 43 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_853_0 {
	meta:
		name = "TActionClientLink.SetVisible"
		size = 30
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 52 44 84 C0 74 0A 8B D3 8B 46 18 8B 08 FF 51 2C 5E 5B C3 }
	condition:
		$1
}

rule function_855_0 {
	meta:
		name = "TCaptionAttributes.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
		altNames = "TChartTheme.Create TCommandProperties.Create TConnectionData.Create TDBXByteReader.Create TDBXChannelInfo.Create TDBXInt32Object.Create TDBXJSonServerProtocolHandler.Create TDBXPropertiesItem.Create TDSAdapterClass.Create TDSHTTPContextIndy.Create TDSJSONProtocolHandlerFactory.Create TDefaultWebModuleFactory.Create TDictionary<T>.TKeyCollection.Create TDictionary<T>.TValueCollection.Create TGIFItem.Create THTMLTagAttributes.Create THandleStream.Create TItemProp.Create TLayoutWebContent.Create TListItems.Create TLocalWebModuleContext.Create TParaAttributes.Create TSizeConstraints.Create TTreeNodes.Create TWebDisplay.Create TXMLData.Create"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 04 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_856_0 {
	meta:
		name = "TCommandProperties.DoChanged"
		size = 24
	strings:
		$1 = { 53 66 83 78 0A 00 74 0E 8B D8 0F B6 48 10 8B D0 8B 43 0C FF 53 08 5B C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "TCommandProperties.GetControl"
		size = 7
	strings:
		$1 = { 8B 40 04 8B 40 44 C3 }
	condition:
		$1
}

rule function_858_0 {
	meta:
		name = "TCommandProperties.InvalidateControl"
		size = 54
		refs = "0009 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 85 C0 74 22 84 DB 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 F8 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_859_0 {
	meta:
		name = "TButtonProperties.Assign"
		size = 79
		refs = "000b TCommandProperties.Assign 0013 _DV_TButtonProperties 0018 @IsClass 0027 TButtonProperties.SetButtonSize 0032 TButtonProperties.SetButtonType 003d TButtonProperties.SetGroupPosition 0048 TButtonProperties.SetTextAssociation"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2C 0F B6 56 18 8B C3 E8 ?? ?? ?? ?? 0F B6 56 19 8B C3 E8 ?? ?? ?? ?? 0F B6 56 1A 8B C3 E8 ?? ?? ?? ?? 0F B6 56 1B 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_860_0 {
	meta:
		name = "TButtonProperties.Create"
		size = 69
		refs = "000a @ClassCreate 0017 TCommandProperties.Create 0032 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 19 00 C6 46 18 00 C6 46 1A 00 C6 46 1B 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_861_0 {
	meta:
		name = "TButtonProperties.SetButtonSize"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 18 74 22 88 56 18 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5E C3 }
	condition:
		$1
}

rule function_862_0 {
	meta:
		name = "TButtonProperties.SetButtonType"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 19 74 22 88 56 19 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5E C3 }
	condition:
		$1
}

rule function_863_0 {
	meta:
		name = "TButtonProperties.SetGroupPosition"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 1A 74 1F 88 53 1A 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_864_0 {
	meta:
		name = "TButtonProperties.SetTextAssociation"
		size = 44
		refs = "000e TCommandProperties.GetControl 001e TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 3A 56 1B 74 22 88 56 1B 8B C6 E8 ?? ?? ?? ?? 85 C0 74 14 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5E C3 }
	condition:
		$1
}

rule function_865_0 {
	meta:
		name = "TGalleryProperties.Assign"
		size = 78
		refs = "000b TButtonProperties.Assign 0013 _DV_TGalleryProperties 0018 @IsClass 0023 TGalleryProperties.GetGalleryType 002c TGalleryProperties.SetGalleryType 0033 TGalleryProperties.GetItemsPerRow 003c TGalleryProperties.SetItemsPerRow 0047 TGalleryProperties.SetShowRichContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2B 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B6 56 28 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_866_0 {
	meta:
		name = "TGalleryProperties.Create"
		size = 64
		refs = "000a @ClassCreate 0017 TButtonProperties.Create 002d @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 24 04 00 00 00 C6 46 20 01 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_867_0 {
	meta:
		name = "TDBXJSonStreamReader.GetBooleanValue"
		size = 5
		altNames = "TDirect2DPen.GetStyle TGalleryProperties.GetGalleryType"
	strings:
		$1 = { 0F B6 40 20 C3 }
	condition:
		$1
}

rule function_868_0 {
	meta:
		name = "TDBXParamsTable.GetStorage"
		size = 4
		altNames = "TDBXReaderTableStorage.GetStorage TGalleryProperties.GetItemsPerRow TStringList.GetCapacity TTestResult.RunCount TWideStringList.GetCapacity TXMLNode.GetHostNode"
	strings:
		$1 = { 8B 40 24 C3 }
	condition:
		$1
}

rule function_869_0 {
	meta:
		name = "TGalleryProperties.SetGalleryType"
		size = 9
	strings:
		$1 = { 3A 50 20 74 03 88 50 20 C3 }
	condition:
		$1
}

rule function_870_0 {
	meta:
		name = "TGalleryProperties.SetItemsPerRow"
		size = 22
		refs = "000e TCommandProperties.GetControl"
	strings:
		$1 = { 53 8B D8 3B 53 24 74 0C 89 53 24 8B C3 E8 ?? ?? ?? ?? 85 C0 5B C3 }
	condition:
		$1
}

rule function_871_0 {
	meta:
		name = "TChartPen.SetVisible"
		size = 14
		altNames = "TGalleryProperties.SetShowRichContent"
	strings:
		$1 = { 3A 50 28 74 08 88 50 28 8B 10 FF 52 0C C3 }
	condition:
		$1
}

rule function_872_0 {
	meta:
		name = "TMenuProperties.Assign"
		size = 76
		refs = "000b TControlProperties.Assign 0013 _DV_TMenuProperties 0018 @IsClass 0026 TMenuProperties.SetContent 0030 TMenuProperties.SetFont 003a TMenuProperties.SetHeight 0045 TMenuProperties.SetShowRichContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 29 8B 56 30 8B C3 E8 ?? ?? ?? ?? 8B 56 34 8B C3 E8 ?? ?? ?? ?? 8B 56 3C 8B C3 E8 ?? ?? ?? ?? 0F B6 56 38 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_873_0 {
	meta:
		name = "TMenuProperties.Create"
		size = 83
		refs = "000a @ClassCreate 0017 TControlProperties.Create 001e _Dn_TFont 0023 TFont.Create 002d _Dn_TStringList 0032 TStringList.Create 0040 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 34 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 30 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_874_0 {
	meta:
		name = "TMenuProperties.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 000f TObject.Free 0023 TPersistent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 34 E8 ?? ?? ?? ?? 8B 46 30 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_875_0 {
	meta:
		name = "TMenuProperties.SetContent"
		size = 13
	strings:
		$1 = { 56 8B F0 8B 46 30 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_876_0 {
	meta:
		name = "TCustomWebUserList.SetItems"
		size = 13
		altNames = "TIBDataSetUpdateObject.SetRefreshSQL TMenuProperties.SetFont TSimpleObjectBroker.SetServers"
	strings:
		$1 = { 56 8B F0 8B 46 34 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_877_0 {
	meta:
		name = "TMenuProperties.SetHeight"
		size = 79
		refs = "0010 TCommandProperties.GetControl 002f TCustomActionControl.GetActionBar 0048 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C2 89 43 3C 3B D0 74 3F 8B C3 E8 ?? ?? ?? ?? 85 C0 74 34 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 F8 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_878_0 {
	meta:
		name = "TMenuProperties.SetShowRichContent"
		size = 18
	strings:
		$1 = { 3A 50 38 74 0C 88 50 38 C6 40 10 02 8B 10 FF 52 0C C3 }
	condition:
		$1
}

rule function_879_0 {
	meta:
		name = "TTextProperties.Assign"
		size = 66
		refs = "000b TCheckBoxProperties.Assign 0013 _DV_TTextProperties 0018 @IsClass 0034 TTextProperties.SetFont"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1F 0F B6 46 20 88 43 20 0F B6 46 21 88 43 21 8B 56 24 8B C3 E8 ?? ?? ?? ?? 0F B6 46 28 88 43 28 5E 5B C3 }
	condition:
		$1
}

rule function_880_0 {
	meta:
		name = "TTextProperties.Create"
		size = 97
		refs = "000e @ClassCreate 001c TCheckBoxProperties.Create 0027 _Dn_TFont 002c TFont.Create 003b TTextProperties.FontChangeHandler 004c @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 43 20 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 73 24 89 5E 0C C7 46 08 ?? ?? ?? ?? C6 43 28 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_881_0 {
	meta:
		name = "TTextProperties.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TPersistent.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8857_0 {
	meta:
		name = "EUpdateError.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b Exception.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12447_0 {
	meta:
		name = "THTMLTableColumn.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TCollectionItem.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9637_0 {
	meta:
		name = "TMasterDataLink.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TDataLink.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_5664_0 {
	meta:
		name = "TRichEditStrings.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TStrings.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25410_0 {
	meta:
		name = "TWebActionItem.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TCollectionItem.Destroy 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 24 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_882_0 {
	meta:
		name = "TTextProperties.FontChangeHandler"
		size = 39
		refs = "000d TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 C6 43 28 00 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_883_0 {
	meta:
		name = "TTextProperties.SetAlignment"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 20 74 1F 88 53 20 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_884_0 {
	meta:
		name = "TTextProperties.SetEllipsisPosition"
		size = 43
		refs = "0011 TCommandProperties.GetControl"
	strings:
		$1 = { 53 56 8B D8 3A 53 21 74 1F 88 53 21 8B F3 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_885_0 {
	meta:
		name = "TButtonCategory.SetItems"
		size = 13
		altNames = "TScreenTipItem.SetDisabledDescription TTextProperties.SetFont"
	strings:
		$1 = { 56 8B F0 8B 46 24 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_886_0 {
	meta:
		name = "TTextProperties.SetParentFont"
		size = 49
		refs = "0021 TCustomActionControl.GetActionBar 002b TTextProperties.SetFont"
	strings:
		$1 = { 53 8B D8 3A 53 28 74 27 88 53 28 80 7B 28 00 74 1E 8B 43 04 83 78 44 00 74 15 8B 43 04 8B 40 44 E8 ?? ?? ?? ?? 8B 50 64 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_887_0 {
	meta:
		name = "TControlProperties.Assign"
		size = 59
		refs = "000b TCheckBoxProperties.Assign 0013 _DV_TControlProperties 0018 @IsClass 0034 TControlProperties.SetText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 8B C6 8B 50 20 89 53 20 8B 50 28 89 53 28 8B 50 24 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_888_0 {
	meta:
		name = "TControlProperties.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCheckBoxProperties.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 28 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_890_0 {
	meta:
		name = "TControlProperties.DoSetWidth"
		size = 77
		refs = "0007 TCheckBoxProperties.DoSetWidth 000e TCommandProperties.GetControl 002d TCustomActionControl.GetActionBar 0046 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 34 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 F8 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 15 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 BE D0 FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_891_0 {
	meta:
		name = "TControlProperties.SetContainedControl"
		size = 4
		altNames = "TDBXReaderValue.SetHandle TDockZone.SetZoneLimit"
	strings:
		$1 = { 89 50 20 C3 }
	condition:
		$1
}

rule function_892_0 {
	meta:
		name = "TControlProperties.SetLabelWidth"
		size = 14
	strings:
		$1 = { 3B 50 28 74 08 89 50 28 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_893_0 {
	meta:
		name = "TControlProperties.SetText"
		size = 40
		refs = "000c @UStrEqual 0018 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 24 8B D6 E8 ?? ?? ?? ?? 74 13 8D 43 24 8B D6 E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 51 18 5E 5B C3 }
	condition:
		$1
}

rule function_894_0 {
	meta:
		name = "TComboBoxProperties.Create"
		size = 57
		refs = "000a @ClassCreate 0017 TControlProperties.Create 0026 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 46 30 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_895_0 {
	meta:
		name = "TActionClientItem.Create"
		size = 137
		refs = "000a @ClassCreate 001e TActionClient.Create 0052 @UStrAsg 0063 _DV_TButtonProperties 0068 TButtonProperties.Create 0076 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 C7 46 24 00 00 00 20 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 5C FF FF FF FF 33 C0 89 46 50 C6 46 55 01 C6 46 65 01 C6 46 56 01 C6 46 40 01 33 C0 89 46 48 33 C0 89 46 60 C6 46 6C 00 8D 46 70 33 D2 E8 ?? ?? ?? ?? C6 46 74 00 C6 46 75 00 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 78 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_896_0 {
	meta:
		name = "TActionClientItem.Destroy"
		size = 85
		refs = "0003 @BeforeDestruction 0017 TObject.Free 0043 TActionClient.Destroy 004e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 3C 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 46 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 46 78 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_897_0 {
	meta:
		name = "TActionClientItem.ActionChange"
		size = 306
		refs = "0012 TActionClientItem.ActionChange 0020 _Dn_TCustomAction 0025 @IsClass 006f @UStrAsg 00a3 TActionClientItem.GetCaption 00b3 TActionClientItem.SetCaption 00ca TActionClientItem.SetImageIndex 00e3 TActionClientItem.SetShortCut 0120 @UStrClr 0126 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 DE 00 00 00 83 7E 44 00 74 62 84 DB 74 0C 8B 46 44 8B 10 FF 52 5C 3C 01 75 0C 0F B6 57 6A 8B 46 44 8B 08 FF 51 74 84 DB 74 0C 8B 46 44 83 B8 80 00 00 00 00 75 10 8B 46 44 05 80 00 00 00 8B 57 7C E8 ?? ?? ?? ?? 84 DB 74 0D 8B 46 44 66 83 B8 12 01 00 00 00 75 15 8B 46 44 8B 57 40 89 90 10 01 00 00 8B 57 44 89 90 14 01 00 00 84 DB 74 10 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 83 7D FC 00 75 0A 8B 57 64 8B C6 E8 ?? ?? ?? ?? 84 DB 74 06 83 7E 5C 00 75 0D 8B 97 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 DB 74 07 66 83 7E 4C 00 75 0E 0F B7 97 84 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 DB 74 06 80 7E 30 01 75 0E 0F B6 97 86 00 00 00 8B C6 8B 08 FF 51 2C 84 DB 74 06 83 7E 68 00 75 06 8B 47 74 89 46 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_898_0 {
	meta:
		name = "TActionClientItem.Assign"
		size = 416
		refs = "0016 TActionClientItem.Assign 0026 TActionClient.Assign 002e _DV_TActionClientItem 0033 @IsClass 0063 TActionClientItem.GetAction 006d TActionClientItem.SetAction 0077 TActionClientItem.GetCaption 0082 TActionClientItem.SetCaption 0096 TActionClientItem.SetImageIndex 00a1 TActionClientItem.SetMergeIndex 00ac TActionClientItem.SetLastSession 00b8 TActionClientItem.SetShowCaption 00c4 TActionClientItem.SetShowGlyph 00d0 TActionClientItem.SetShowShortCut 00dc TActionClientItem.SetShortCut 00e7 TActionClientItem.SetUsageCount 00f3 TActionClientItem.SetDefault 0101 @UStrAsg 010d TActionClientItem.SetNewCol 0119 TActionClientItem.SetNewRow 0125 TActionClientItem.SetCommandStyle 0130 TActionClientItem.SetCommandProperties 0146 TActionClient.GetItems 0177 @HandleFinally 018e @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 3E 01 00 00 8B 45 FC 8B 70 04 85 F6 74 07 8B C6 8B 10 FF 52 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B F3 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? 8D 55 F8 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 46 68 8B 55 FC 89 42 68 8B 56 5C 8B 45 FC E8 ?? ?? ?? ?? 8B 56 50 8B 45 FC E8 ?? ?? ?? ?? 8B 56 60 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 55 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 65 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 56 8B 45 FC E8 ?? ?? ?? ?? 0F B7 56 4C 8B 45 FC E8 ?? ?? ?? ?? 8B 56 48 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 6C 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 70 8B 56 70 E8 ?? ?? ?? ?? 0F B6 56 75 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 74 8B 45 FC E8 ?? ?? ?? ?? 0F B6 56 76 8B 45 FC E8 ?? ?? ?? ?? 8B 56 78 8B 45 FC E8 ?? ?? ?? ?? 8B 46 7C 8B 55 FC 89 42 7C 83 7E 2C 00 74 16 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 40 04 85 C0 74 05 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_899_0 {
	meta:
		name = "TActionClientItem.ColorChanged"
		size = 56
		refs = "001d TControl.SetParentColor 0028 TCustomActionControl.SetTransparent 0032 TControl.SetColor"
	strings:
		$1 = { 53 8B 50 44 85 D2 74 2E 8B 48 24 8B D9 81 EB FF FF FF 1F 74 0E 4B 75 16 8B C2 B2 01 E8 ?? ?? ?? ?? EB 13 8B C2 B2 01 E8 ?? ?? ?? ?? EB 08 8B C1 92 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_900_0 {
	meta:
		name = "TActionClientItem.DoActionChange"
		size = 35
		refs = "0009 TActionClientItem.GetAction 001c @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3B F0 75 0F B1 01 8B D6 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_903_0 {
	meta:
		name = "TActionClientItem.GetAction"
		size = 15
	strings:
		$1 = { 33 D2 8B 48 3C 85 C9 74 03 8B 51 10 8B C2 C3 }
	condition:
		$1
}

rule function_904_0 {
	meta:
		name = "TActionClientItem.GetCaption"
		size = 168
		refs = "000b ActionBarDesigner 002e TActionClientItem.GetAction 0045 TCollectionItem.GetIndex 0059 TActionClientItem.GetCaption 005e Format 006a @UStrAsg"
	strings:
		$1 = { 53 56 83 C4 F8 8B F2 8B D8 83 3D ?? ?? ?? ?? 00 74 13 8B 43 20 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 94 C0 EB 02 33 C0 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 34 01 EB 02 33 C0 84 C0 74 23 56 8B C3 E8 ?? ?? ?? ?? 89 44 24 04 C6 44 24 08 00 8D 54 24 04 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A 8B C6 8B 53 20 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 00 B0 04 02 00 FF FF FF FF 12 00 00 00 41 00 63 00 74 00 69 00 6F 00 6E 00 43 00 6C 00 69 00 65 00 6E 00 74 00 49 00 74 00 65 00 6D 00 25 00 64 00 00 00 00 00 }
	condition:
		$1
}

rule function_905_0 {
	meta:
		name = "TActionClientItem.GetDisplayName"
		size = 175
		refs = "0015 TActionClientItem.GetDisplayName 0024 TCollectionItem.GetDisplayName 002e TActionClientItem.GetCaption 0056 TActionClientItem.GetAction 005c _Dn_TCustomAction 0061 @IsClass 0088 @UStrAsg 009d @UStrClr 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D FC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B C3 E8 ?? ?? ?? ?? 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 89 45 F8 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 0B 8B D6 8B C3 E8 ?? ?? ?? ?? EB 39 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 23 8B C3 E8 ?? ?? ?? ?? 8B D8 8B 43 64 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 0A 8B C6 8B 53 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_906_0 {
	meta:
		name = "TActionClientItem.HasGlyph"
		size = 169
		refs = "0012 TActionClient.GetOwningCollection 001d TActionClientItem.GetActionClients 002f TActionClientsCollection.GetActionManager 0062 TActionClientItem.GetAction 0093 TCustomImageList.GetCount"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 33 F6 80 7F 65 00 74 50 8B C7 E8 ?? ?? ?? ?? 85 C0 74 45 8B C7 E8 ?? ?? ?? ?? 80 78 29 00 74 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 70 3C EB 4C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 A4 00 00 00 85 F6 75 36 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 70 3C EB 25 8B C7 E8 ?? ?? ?? ?? 85 C0 74 1A 8B C7 E8 ?? ?? ?? ?? 83 78 5C 00 74 0D 8B C7 E8 ?? ?? ?? ?? 8B 40 5C 8B 70 3C 85 F6 74 1B 8B 5F 5C 83 FB FF 7E 0B 8B C6 E8 ?? ?? ?? ?? 3B D8 7C 04 33 C0 EB 02 B0 01 8B D8 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_907_0 {
	meta:
		name = "TActionClientItem.InitiateAction"
		size = 15
	strings:
		$1 = { 8B 50 3C 85 D2 74 07 8B C2 8B 10 FF 52 1C C3 }
	condition:
		$1
}

rule function_908_0 {
	meta:
		name = "TActionClientItem.IsCaptionStored"
		size = 131
		refs = "000c TActionClientItem.IsCaptionStored 0019 TActionClientItem.GetAction 002a _Dn_TCustomAction 002f @IsClass 003d TActionClientItem.GetCaption 0051 AnsiCompareText 0071 @UStrClr 0077 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 74 3D 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 27 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B C3 E8 ?? ?? ?? ?? 8B 50 64 58 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 8B D8 EB 02 B3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_909_0 {
	meta:
		name = "TActionClientItem.Refresh"
		size = 18
	strings:
		$1 = { 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 F8 00 00 00 C3 }
	condition:
		$1
}

rule function_910_0 {
	meta:
		name = "TActionClientItem.ResetUsageData"
		size = 177
		refs = "0015 TActionClientItem.GetActionClients 001a TActionClientsCollection.GetActionManager 0040 TActionClient.GetOwningCollection 005a _DV_TActionBars 005f @IsClass 0079 _DV_TActionClientItem 009b TActionClientItem.SetLastSession"
	strings:
		$1 = { 53 56 57 8B F8 83 7F 48 FF 74 07 FF 47 48 C6 47 40 01 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 6C 8B 40 28 89 47 60 8B C7 E8 ?? ?? ?? ?? 8B 58 20 85 DB 74 78 8B C7 E8 ?? ?? ?? ?? 8B 40 20 E8 ?? ?? ?? ?? 8B F0 EB 0A 8B 46 20 E8 ?? ?? ?? ?? 8B F0 85 F6 74 11 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 E1 85 F6 74 06 8B 46 28 89 47 60 85 DB 74 38 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 8B F3 C6 46 40 01 83 7E 48 FF 74 03 FF 46 48 8B 57 60 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 58 20 85 DB 75 C8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_911_0 {
	meta:
		name = "TActionClientItem.SetAction"
		size = 276
		refs = "000f TObject.Free 0020 TActionClientItem.GetAction 004f @CallDynaInst 0070 TActionClientItem.DoActionChange 007d TActionClientItem.GetActionClients 0082 TActionClientsCollection.GetActionManager 00af TComponent.FreeNotification"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 85 FF 75 12 8B 43 3C E8 ?? ?? ?? ?? 33 C0 89 43 3C E9 F3 00 00 00 8B C3 E8 ?? ?? ?? ?? 3B F8 0F 84 E4 00 00 00 83 7B 44 00 74 10 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 83 7B 3C 00 75 15 8B C3 66 BE FC FF E8 ?? ?? ?? ?? 8B CB B2 01 FF 50 14 89 43 3C 8B D7 8B 43 3C 8B 08 FF 51 0C 8B 43 3C 89 58 0C C7 40 08 ?? ?? ?? ?? F6 47 1C 01 75 19 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 B8 A8 00 00 00 00 75 04 33 C9 EB 02 B1 01 8B D7 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 8B 43 04 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 78 20 00 74 50 8B C3 E8 ?? ?? ?? ?? 8B 40 20 83 78 0C 00 74 19 8B C3 E8 ?? ?? ?? ?? 8B 40 20 8B 40 0C 8B D3 8B 08 FF 91 5C 01 00 00 EB 27 8B C3 E8 ?? ?? ?? ?? 8B 40 20 83 78 18 00 74 17 8B C3 E8 ?? ?? ?? ?? 8B 40 20 8B 40 18 8B D3 8B 08 FF 91 5C 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_912_0 {
	meta:
		name = "TActionClientItem.SetCaption"
		size = 152
		refs = "000d @UStrEqual 0019 @UStrAsg 0020 TActionClientItem.GetAction 002b TActionClientItem.SetCaption 0056 TActionClientItem.SetAction 005f TActionClientItem.SetShortCut 006d TControl.SetText"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B 47 20 8B D6 E8 ?? ?? ?? ?? 74 5E 8D 47 20 8B D6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 75 1C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 12 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 04 33 DB EB 02 B3 01 88 5F 54 84 DB 74 12 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 47 44 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 5F 5E 5B C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 7C 00 00 00 }
	condition:
		$1
}

rule function_913_0 {
	meta:
		name = "TActionClientItem.SetControl"
		size = 74
		refs = "0017 TObject.Free 0027 TActionClientItem.GetAction 0036 @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 44 74 3C 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C6 89 43 44 85 C0 74 23 8B C3 E8 ?? ?? ?? ?? 8B D0 B1 01 8B C3 66 BE FD FF E8 ?? ?? ?? ?? 8B D3 8B 43 44 8B 08 FF 91 EC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_914_0 {
	meta:
		name = "TActionClientItem.SetDefault"
		size = 96
		refs = "0016 TActionClientItem.GetActionClients 0034 TCollection.GetItem 0045 TActionClientItem.SetDefault"
	strings:
		$1 = { 53 56 57 8B D8 3A 53 6C 74 52 8B C2 88 43 6C 84 C0 74 3A 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 26 46 33 FF 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 80 78 6C 00 74 0B 3B D8 74 07 33 D2 E8 ?? ?? ?? ?? 47 4E 75 DD 8B 43 44 85 C0 74 08 8B 10 FF 92 90 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_915_0 {
	meta:
		name = "TActionClientItem.SetImageIndex"
		size = 39
	strings:
		$1 = { 53 8B D8 3B 53 5C 74 1D 89 53 5C 8B 43 44 85 C0 74 13 8B 10 FF 92 F8 00 00 00 8B 43 44 8B 10 FF 92 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_916_0 {
	meta:
		name = "TActionClientItem.SetIndex"
		size = 35
		refs = "0006 TCollectionItem.SetIndex 001d NotifyDesigner"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 46 44 85 C0 74 08 8B 10 FF 92 E8 00 00 00 8B 46 0C E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_917_0 {
	meta:
		name = "TActionClientItem.SetLastSession"
		size = 13
	strings:
		$1 = { 3B 50 60 74 07 89 50 60 C6 40 40 01 C3 }
	condition:
		$1
}

rule function_918_0 {
	meta:
		name = "TActionClientItem.SetMergeIndex"
		size = 142
		refs = "0010 TCollectionItem.GetIndex 0024 TActionClientItem.GetActionClients 002a TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 3B 6B 50 77 27 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1C 8B C3 E8 ?? ?? ?? ?? 48 50 8B C3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 83 78 50 00 75 55 8B C3 E8 ?? ?? ?? ?? 8B F0 46 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B FE 8B F0 4E 2B F7 7C 32 46 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B C8 8B 41 50 3B 43 50 75 05 89 69 50 EB 10 8B 43 50 2B 41 50 99 33 C2 2B C2 03 C5 89 41 50 47 4E 75 CF 89 6B 50 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_919_0 {
	meta:
		name = "TActionClientItem.SetNewCol"
		size = 49
		refs = "0016 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 56 8B F0 3A 56 75 74 25 88 56 75 8B 5E 44 85 DB 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 8B 46 44 E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_920_0 {
	meta:
		name = "TActionClientItem.SetNewRow"
		size = 49
		refs = "0016 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 56 8B F0 3A 56 74 74 25 88 56 74 8B 5E 44 85 DB 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 8B 46 44 E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_921_0 {
	meta:
		name = "TActionClientItem.SetShortCut"
		size = 97
		refs = "000f TActionClientItem.SetShortCut 0029 ShortCutToText 0034 @UStrAsg 0050 @UStrClr 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 3B 5E 4C 74 20 66 89 5E 4C 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8D 46 58 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_922_0 {
	meta:
		name = "TActionClientItem.SetShowCaption"
		size = 88
		refs = "000f TActionClientItem.GetActionClients 0014 TActionClientsCollection.GetActionManager 0037 TComponent.GetComponentCount"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 3A 5E 55 74 48 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 40 1C 01 75 2C 8B C6 8B 10 FF 52 34 84 C0 75 21 84 DB 75 16 8B 7E 44 85 FF 74 0B 8B C7 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 02 B0 01 88 46 55 EB 03 88 5E 55 8B C6 8B 10 FF 52 30 5F 5E 5B C3 }
	condition:
		$1
}

rule function_923_0 {
	meta:
		name = "TActionClientItem.SetShowShortCut"
		size = 41
		refs = "0023 TWinControl.AlignControl"
	strings:
		$1 = { 53 8B D8 3A 53 56 74 1F 88 53 56 8B 43 44 85 C0 74 15 8B 10 FF 92 F8 00 00 00 8B 43 44 8B 40 34 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_924_0 {
	meta:
		name = "TActionClientItem.SetUsageCount"
		size = 40
	strings:
		$1 = { 81 FA FF FF FF 7F 75 07 33 D2 89 50 48 EB 03 89 50 48 C6 40 40 01 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 90 00 00 00 C3 }
	condition:
		$1
}

rule function_925_0 {
	meta:
		name = "TActionClientItem.SetVisible"
		size = 122
		refs = "002c TControl.SetVisible 0043 _DV_TXToolDockForm 0048 @IsClass"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 3A 5E 30 75 0C 8B 46 44 85 C0 74 63 3A 58 59 74 5E 88 5E 30 8B 46 44 85 C0 74 0E 3A 58 59 74 09 0F B6 56 30 E8 ?? ?? ?? ?? 8B 7E 0C 85 FF 74 3F 3A 5F 59 74 2A 8B 5F 34 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B C3 33 D2 E8 ?? ?? ?? ?? EB 0B 0F B6 56 30 8B C7 E8 ?? ?? ?? ?? 8B 46 0C F6 40 1C 10 75 07 8B C6 8B 10 FF 52 30 5F 5E 5B C3 }
	condition:
		$1
}

rule function_926_0 {
	meta:
		name = "TActionClientItem.SetChangesAllowed"
		size = 76
		refs = "000e TActionClient.SetChangesAllowed 0015 TActionClientItem.GetParentItem 001b _DV_TActionClientItem 0020 @IsClass 002b TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 51 88 14 24 8B D8 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B C3 E8 ?? ?? ?? ?? 8B 40 20 0F B6 40 31 3A 43 31 76 0E 8B C3 E8 ?? ?? ?? ?? 0F B6 53 31 88 50 31 5A 5B C3 }
	condition:
		$1
}

rule function_927_0 {
	meta:
		name = "TActionClientItem.SetShowGlyph"
		size = 26
	strings:
		$1 = { 3A 50 65 74 14 88 50 65 8B 50 44 85 D2 74 0A 8B C2 8B 10 FF 92 F8 00 00 00 C3 }
	condition:
		$1
}

rule function_928_0 {
	meta:
		name = "TActionClientItem.SetCollection"
		size = 58
		refs = "0019 TObject.Free 0029 @CallDynaInst 0032 TCollectionItem.SetCollection"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 83 7B 44 00 74 20 8D 43 44 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 43 0C 85 C0 74 09 66 BE D0 FF E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_929_0 {
	meta:
		name = "TActionClientItem.SetCommandProperties"
		size = 146
		refs = "0011 TActionClientItem.SetCommandProperties 0023 TObject.Free 002c _DV_TCommandProperties 0031 TCommandProperties.Create 0040 TObject.ClassName 005a @UStrEqual 0080 @UStrArrayClr 0086 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 F6 75 1B 8B 43 78 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 43 78 EB 30 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B 43 78 8B 00 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 75 0A 8B D6 8B 43 78 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_930_0 {
	meta:
		name = "TActionClientItem.SetCommandStyle"
		size = 350
		refs = "0032 TActionClientItem.SetCommandStyle 0063 _DV_TGalleryProperties 0068 TGalleryProperties.Create 0079 _DV_TButtonProperties 007e TButtonProperties.Create 008f _DV_TMenuProperties 0094 TMenuProperties.Create 00a2 _DV_TTextProperties 00a7 TTextProperties.Create 00b5 _DV_TControlProperties 00ba TControlProperties.Create 00c8 _DV_TComboBoxProperties 00cd TComboBoxProperties.Create 00db _DV_TCheckBoxProperties 00e0 TCheckBoxProperties.Create 00ec TActionClientItem.GetActionClients 00f1 TActionClientsCollection.GetActionManager 00fc @CallDynaInst 011f TObject.Free 0130 TCustomActionControl.GetActionBar 0141 TWinControl.GetAlignDisabled"
	strings:
		$1 = { 53 56 57 55 8B DA 8B F8 3A 5F 76 0F 84 48 01 00 00 8B 47 78 85 C0 74 09 8B E8 33 C0 89 47 78 EB 02 33 ED 0F B6 C3 83 F8 09 0F 87 DF 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 E9 9A 00 00 00 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 E9 84 00 00 00 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 71 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 5E 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 4B 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 38 8B CF B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 47 78 EB 25 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D7 66 BE EC FF E8 ?? ?? ?? ?? 8B F0 8B CF B2 01 8B C6 FF 50 10 89 47 78 85 ED 74 0A 8B D5 8B 47 78 8B 08 FF 51 08 8B C5 E8 ?? ?? ?? ?? 88 5F 76 8B 5F 44 85 DB 74 2C 8B C3 E8 ?? ?? ?? ?? 85 C0 74 21 8B 47 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 10 8B 47 44 E8 ?? ?? ?? ?? 8B 10 FF 92 68 01 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_931_0 {
	meta:
		name = "CheckControl"
		size = 27
	strings:
		$1 = { 80 78 30 00 74 0F 83 78 44 00 74 09 8B 40 44 80 78 59 00 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_932_0 {
	meta:
		name = "TActionClientItem.Unused"
		size = 353
		refs = "0018 TActionClientItem.GetActionClients 0031 TActionClientsCollection.GetActionManager 0044 TCollectionItem.GetIndex 006d TActionClients.GetActionClient 0138 TActionClient.GetItems 0149 TActionClient.HasVisibleItems"
	strings:
		$1 = { 53 56 57 55 51 8B F0 0F B6 5E 64 80 7E 40 00 0F 84 44 01 00 00 8B C6 E8 ?? ?? ?? ?? 80 78 2A 00 75 07 33 DB E9 30 01 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 80 7E 54 00 0F 84 E2 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 4F 83 FF 00 7C 55 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 44 8B C6 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 80 78 54 00 75 2E 8B C6 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D0 8B C5 8B 08 FF 51 40 8B D8 80 F3 01 84 DB 75 06 4F 83 FF FF 75 AB 84 DB 0F 84 A9 00 00 00 8B 46 04 8B 40 08 8B 40 08 48 85 C0 0F 8C 97 00 00 00 40 89 04 24 8B C6 E8 ?? ?? ?? ?? 8B 56 04 8B 52 08 8B 52 08 4A 3B C2 7D 44 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 80 78 54 00 75 62 8B C6 E8 ?? ?? ?? ?? 40 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D0 8B C5 8B 08 FF 51 40 8B D8 80 F3 01 84 DB 75 3A FF 0C 24 75 A2 EB 33 8B D6 8B C5 8B 08 FF 51 40 8B D8 80 F3 01 84 DB 74 1D 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 0C 8B C6 E8 ?? ?? ?? ?? 8B D8 80 F3 01 C6 46 40 00 88 5E 64 8B C3 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_933_0 {
	meta:
		name = "TActionClientItem.IsHelpContextStored"
		size = 32
	strings:
		$1 = { 53 56 8B D8 8B 73 3C 85 F6 74 10 8B C6 8B 10 FF 52 30 84 C0 74 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_934_0 {
	meta:
		name = "TActionDragObject.Create"
		size = 72
		refs = "000a @ClassCreate 0017 TObject.Create 001e _Dn_TList 0035 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 48 C6 46 4C 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_935_0 {
	meta:
		name = "TActionDragObject.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 000f TObject.Free 001b TObject.Destroy 0026 @ClassDestroy"
		altNames = "TDragDockObject.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 46 48 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_936_0 {
	meta:
		name = "TActionDragObject.AddAction"
		size = 9
		refs = "0004 TList.Add"
		altNames = "TActionDragObject.AddActionClass"
	strings:
		$1 = { 8B 40 48 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_938_0 {
	meta:
		name = "TActionDragObject.GetAction"
		size = 50
		refs = "0012 TList.Get 0019 ActionBarDesigner"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 4C 00 74 19 8B D6 8B 43 48 E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 0C 5E 5B C3 8B D6 8B 43 48 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_939_0 {
	meta:
		name = "TActionDragObject.GetActionCount"
		size = 7
	strings:
		$1 = { 8B 40 48 8B 40 08 C3 }
	condition:
		$1
}

rule function_940_0 {
	meta:
		name = "TCategoryDragObject.Create"
		size = 124
		refs = "000e @ClassCreate 001d @UStrAddRef 0025 TCategoryDragObject.Create 0034 TActionDragObject.Create 003f @UStrAsg 0054 @UStrClr 005a @HandleFinally 0067 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 50 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_941_0 {
	meta:
		name = "TActionItemDragObject.Finished"
		size = 190
		refs = "0021 TDragObject.Finished 004c TControl.ScreenToClient 0071 PtInRect 0083 _DV_TControlProperties 0088 @IsClass 00a2 TObject.Free 00b1 NotifyDesigner"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 89 4D FC 8B FA 8B D8 8B 45 0C 50 0F B6 45 08 50 8B 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 43 48 8B 70 44 85 F6 0F 84 82 00 00 00 3B F7 74 7E 8B 45 FC 89 45 EC 8B 45 0C 89 45 F0 8D 4D F4 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 80 7B 20 00 74 58 80 7D 08 00 75 52 8D 55 DC 8B 43 48 8B 40 44 8B 08 FF 51 54 8D 45 DC 8D 55 F4 E8 ?? ?? ?? ?? 84 C0 75 35 8B 43 48 8B 70 78 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 16 83 7E 20 00 74 10 8D 46 20 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 43 48 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_942_0 {
	meta:
		name = "ColorProc"
		size = 73
		refs = "000e _Dn_TCustomActionPopupMenu 0013 @IsClass 0021 TControl.SetColor 0034 TWinControl.HandleAllocated"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 DB 74 3C 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 56 78 8B C3 E8 ?? ?? ?? ?? EB 0A 8B 56 44 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 90 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_943_0 {
	meta:
		name = "FontColorProc"
		size = 27
		refs = "0016 TFont.SetColor"
	strings:
		$1 = { 85 C0 74 16 8B 48 64 8B 49 18 3B 4A 54 74 0B 8B 40 64 8B 52 54 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_944_0 {
	meta:
		name = "TCustomActionBarColorMap.Add"
		size = 63
		refs = "0010 TList.IndexOf 001d TList.Add 0026 TComponent.FreeNotification 002f ColorProc 0038 FontColorProc"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 32 8B D6 8B 43 34 E8 ?? ?? ?? ?? 40 75 25 8B D6 8B 43 34 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_945_0 {
	meta:
		name = "TCustomActionBarColorMap.Create"
		size = 75
		refs = "000a @ClassCreate 0017 TComponent.Create 001e _Dn_TList 0023 TObject.Create 0038 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 34 8B C6 8B 10 FF 52 3C 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_946_0 {
	meta:
		name = "TCustomActionBarColorMap.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0017 TObject.Free 0023 TComponent.Destroy 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8D 46 34 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_947_0 {
	meta:
		name = "TCustomActionBarColorMap.GetDisabledColor"
		size = 24
	strings:
		$1 = { 8B 50 48 F6 40 1C 10 75 0C 81 78 48 FF FF FF 1F 75 03 8B 50 44 8B C2 C3 }
	condition:
		$1
}

rule function_948_0 {
	meta:
		name = "TCustomActionBarColorMap.GetUnusedColor"
		size = 28
		refs = "0014 GetHighLightColor"
	strings:
		$1 = { 8B 50 64 81 FA 00 00 00 20 75 0E BA 13 00 00 00 8B 40 44 E8 ?? ?? ?? ?? C3 8B C2 C3 }
	condition:
		$1
}

rule function_949_0 {
	meta:
		name = "TCustomActionBarColorMap.Notification"
		size = 70
		refs = "0010 TComponent.Notification 001c _DV_TCustomActionBar 0021 @IsClass 002f TList.IndexOf 003e TList.Delete"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? FE CB 75 2A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 19 8B D7 8B 46 34 E8 ?? ?? ?? ?? 83 F8 FF 74 0A 8B D0 8B 46 34 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_950_0 {
	meta:
		name = "TCustomActionBarColorMap.Remove"
		size = 51
		refs = "0014 TList.IndexOf 0023 TList.Delete 002c TComponent.RemoveFreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 74 26 8B 43 34 85 C0 74 16 8B D6 E8 ?? ?? ?? ?? 83 F8 FF 74 0A 8B D0 8B 43 34 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_951_0 {
	meta:
		name = "TCustomActionBarColorMap.SetColor"
		size = 102
		refs = "000c ColorProc 0016 TCustomActionBarColorMap.UpdateActionBars 002c GetHighLightColor 0045 GetShadowColor"
	strings:
		$1 = { 53 8B D8 3B 53 44 74 5C 89 53 44 B8 ?? ?? ?? ?? 8B CA 8B D3 92 E8 ?? ?? ?? ?? 81 7B 64 00 00 00 20 75 10 BA 13 00 00 00 8B 43 44 E8 ?? ?? ?? ?? 89 43 64 81 7B 4C 00 00 00 20 75 10 BA CE FF FF FF 8B 43 44 E8 ?? ?? ?? ?? 89 43 4C 66 83 BB 92 00 00 00 00 74 0E 8B D3 8B 83 94 00 00 00 FF 93 90 00 00 00 5B C3 }
	condition:
		$1
}

rule function_952_0 {
	meta:
		name = "TCustomActionBarColorMap.SetFontColor"
		size = 81
		refs = "0020 GetShadowColor 0039 GetHighLightColor 0041 FontColorProc 004a TCustomActionBarColorMap.UpdateActionBars"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 54 74 43 89 73 54 81 7B 4C 00 00 00 20 75 10 BA CE FF FF FF 8B 43 44 E8 ?? ?? ?? ?? 89 43 4C 81 7B 50 00 00 00 20 75 10 BA 13 00 00 00 8B 43 44 E8 ?? ?? ?? ?? 89 43 50 BA ?? ?? ?? ?? 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_953_0 {
	meta:
		name = "TCustomActionBarColorMap.UpdateColors"
		size = 6
	strings:
		$1 = { 33 D2 89 50 74 C3 }
	condition:
		$1
}

rule function_954_0 {
	meta:
		name = "TCustomActionBarColorMap.UpdateActionBars"
		size = 45
		refs = "001c TList.Get"
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B 43 34 8B 70 08 4E 85 F6 7C 15 46 33 FF 8B D7 8B 43 34 E8 ?? ?? ?? ?? 8B D3 FF D5 47 4E 75 EE 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_955_0 {
	meta:
		name = "TCustomActionBarColorMap.Assign"
		size = 218
		refs = "000b _DV_TCustomActionBarColorMap 0010 @IsClass 0043 TCustomActionBarColorMap.GetDisabledColor 00b7 TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 BA 00 00 00 8B FE 8B 47 38 89 43 38 8B 47 3C 89 43 3C 8B 47 40 89 43 40 8B 57 44 8B C3 8B 08 FF 51 34 8B 47 74 89 43 74 8B C7 E8 ?? ?? ?? ?? 89 43 48 8B 47 4C 89 43 4C 8B 47 50 89 43 50 8B 57 54 8B C3 8B 08 FF 51 38 8B 47 7C 89 43 7C 8B 87 80 00 00 00 89 83 80 00 00 00 8B 87 84 00 00 00 89 83 84 00 00 00 8B 87 88 00 00 00 89 83 88 00 00 00 8B 47 70 89 43 70 8B 47 58 89 43 58 8B 47 60 89 43 60 8B 47 78 89 43 78 8B 47 6C 89 43 6C 8B 47 68 89 43 68 8B 47 5C 89 43 5C 8B C7 E8 ?? ?? ?? ?? 89 43 64 8B 87 90 00 00 00 89 83 90 00 00 00 8B 87 94 00 00 00 89 83 94 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_956_0 {
	meta:
		name = "TCustomActionBar.Create"
		size = 208
		refs = "000e @ClassCreate 001c TToolWindow.Create 002a TCustomActionBar.SetupDefaultColorMap 004d _Dn_TControlCanvas 0052 TCanvas.Create 0063 TControlCanvas.SetControl 006c TCustomActionBar.Create 007b TControl.SetHeight 0087 TControl.SetWidth 0090 TWinControl.SetDoubleBuffered 00b6 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? C6 83 8C 02 00 00 01 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 48 01 00 00 33 C0 89 83 7C 02 00 00 33 C0 89 83 78 02 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 84 02 00 00 8B C6 8B D3 E8 ?? ?? ?? ?? 8B 43 50 0B 05 ?? ?? ?? ?? 89 43 50 BA 32 00 00 00 8B C3 E8 ?? ?? ?? ?? BA 96 00 00 00 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? C7 83 BC 02 00 00 01 00 00 00 33 C0 89 83 C0 02 00 00 C6 83 80 02 00 00 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 00 E8 00 00 00 }
	condition:
		$1
}

rule function_957_0 {
	meta:
		name = "TCustomActionBar.Destroy"
		size = 76
		refs = "0003 @BeforeDestruction 0010 TCustomActionBar.SetActionManager 001b TObject.Free 003a TWinControl.Destroy 0045 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 86 84 02 00 00 E8 ?? ?? ?? ?? 8D 86 E0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_958_0 {
	meta:
		name = "TCustomActionBar.AlignControls"
		size = 44
		refs = "0026 TWinControl.AlignControls"
	strings:
		$1 = { 53 C7 80 B4 02 00 00 01 00 00 00 C7 80 B8 02 00 00 01 00 00 00 33 DB 89 98 D8 02 00 00 33 DB 89 98 D4 02 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_960_0 {
	meta:
		name = "TCustomActionBar.BackgroundSize"
		size = 29
	strings:
		$1 = { 83 C4 F8 33 C0 89 04 24 33 C0 89 44 24 04 8B 04 24 89 02 8B 44 24 04 89 42 04 59 5A C3 }
	condition:
		$1
}

rule function_961_0 {
	meta:
		name = "TCustomActionBar.CalcInsertPosition"
		size = 231
		refs = "002c TCollectionItem.GetIndex 0060 TControl.GetBoundsRect 0099 TCustomActionBar.GetItems 00c1 TCustomActionBar.HasItems"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 4D FC 8B F2 8B D8 85 F6 0F 84 A6 00 00 00 83 BE B4 01 00 00 00 0F 84 99 00 00 00 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 3B 46 40 7D 0C 0F B6 83 8F 02 00 00 84 C0 75 01 4F 8B 45 08 3B 46 44 7D 0C 0F B6 83 8F 02 00 00 2C 02 75 01 4F 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 3B 45 FC 7D 0C 0F B6 83 8F 02 00 00 84 C0 75 01 47 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 45 F8 3B 45 08 7D 0C 0F B6 83 8F 02 00 00 2C 02 75 01 47 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 3B C7 7D 0F 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 85 FF 7D 22 33 FF EB 1E 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 EB 02 33 FF 8B C7 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_962_0 {
	meta:
		name = "TCustomActionBar.Clear"
		size = 145
		refs = "0022 TCustomActionBar.Clear 004d TObject.Free 0061 TActionClient.ClearActionBar 0081 TWinControl.EnableAlign 0087 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC 83 B8 78 02 00 00 00 74 79 8B 45 FC 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 30 01 00 00 8B D8 4B 83 FB 00 7C 18 8B D3 8B 45 FC 8B 08 FF 91 24 01 00 00 E8 ?? ?? ?? ?? 4B 83 FB FF 75 E8 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC 33 D2 89 90 78 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_963_0 {
	meta:
		name = "TCustomActionBar.CMEnabledchanged"
		size = 27
		refs = "000b TWinControl.CMEnabledChanged 0014 TWinControl.Broadcast"
		altNames = "TToolBar.CMEnabledChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_12828_0 {
	meta:
		name = "TDBXDriverRegistry.GetRegisteredDriverNames"
		size = 27
		refs = "000b TDBXDriverRegistry.GetRegisteredDriverLoaderNames 0014 TDBXDriverRegistry.GetRegisteredDriverClassNames"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_46325_0 {
	meta:
		name = "TSeriesPointer.SetSize"
		size = 27
		refs = "000b TSeriesPointer.SetHorizSize 0014 TSeriesPointer.SetVertSize"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43930_0 {
	meta:
		name = "TTeeShadow.SetSize"
		size = 27
		refs = "000b TTeeShadow.SetHorizSize 0014 TTeeShadow.SetVertSize"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_7920_0 {
	meta:
		name = "TWinControl.CMSysFontChanged"
		size = 27
		refs = "000b TControl.CMSysFontChanged 0014 TWinControl.Broadcast"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_964_0 {
	meta:
		name = "TCustomActionBar.CreateControl"
		size = 309
		refs = "0023 TObject.Free 002c TActionClientItem.SetControl 003a @CallDynaInst 0054 TCustomActionBar.CreateControl 0088 ControlDragMode 009a TControl.SetAlign 00f8 @HandleAnyException 0105 @RaiseAgain 010a @DoneExcept 011f TWinControl.EnableAlign 0125 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B DA 89 45 FC 33 C0 89 45 F8 85 DB 0F 84 10 01 00 00 8B 43 44 85 C0 74 0E E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 8B D3 8B 45 FC 66 BE B0 FF E8 ?? ?? ?? ?? 85 C0 0F 84 E5 00 00 00 8B 55 FC 66 FF 82 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 4D FC B2 01 FF 50 2C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 20 01 00 00 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 45 F8 8B 08 FF 51 70 B2 06 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC 89 90 B0 01 00 00 8B 55 FC 8B 45 F8 8B 08 FF 51 78 8B 45 FC 0F B6 50 61 8B 45 F8 8B 08 FF 91 80 00 00 00 8B D3 8B 45 F8 8B 08 FF 91 EC 00 00 00 8B 45 F8 8B 80 B4 01 00 00 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 8B 10 FF 52 68 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_965_0 {
	meta:
		name = "TCustomActionBar.CreateControls"
		size = 254
		refs = "002a TCustomActionBar.CreateControls 005f @TryFinallyExit 007b TActionClients.GetActionClient 009f TActionClient.HasBackground 00c4 TCustomActionControl.SetTransparent 00eb TWinControl.EnableAlign 00f1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 8B 45 FC 83 B8 78 02 00 00 00 0F 84 DB 00 00 00 8B 45 FC 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 DC 02 00 00 00 74 0E 8B 45 FC 8B 80 78 02 00 00 8B 78 1C EB 0C 8B 45 FC 8B 80 78 02 00 00 8B 78 2C 85 FF 75 0A E8 ?? ?? ?? ?? E9 8F 00 00 00 8B 47 08 8B 58 08 4B 85 DB 7C 67 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 91 5C 01 00 00 89 45 F8 83 7D F8 00 74 41 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 13 8B 45 FC 8B 80 78 02 00 00 0F B6 40 14 04 FD 2C 02 73 04 33 D2 EB 02 B2 01 8B 45 F8 E8 ?? ?? ?? ?? 8D 55 F8 8B 45 FC 8B 08 FF 91 FC 00 00 00 46 4B 75 9C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_966_0 {
	meta:
		name = "TCustomActionBar.CustomAlignInsertBefore"
		size = 317
		refs = "000e _DV_TCustomActionControl 0015 @IsClass 0050 TCollectionItem.GetIndex 0105 TSizeConstraints.SetConstraints"
	strings:
		$1 = { 53 56 57 55 8B F9 8B F2 8B E8 8B C6 8B 1D ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 84 C0 74 0D 8B C7 8B D3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 8B D8 84 DB 0F 84 FC 00 00 00 8B 9E B4 01 00 00 85 DB 74 26 83 BF B4 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? 50 8B 87 B4 01 00 00 E8 ?? ?? ?? ?? 5A 3B D0 0F 9C C0 8B D8 EB 02 33 DB 80 7E 59 00 74 14 8B 46 4C 3B 85 D4 02 00 00 7E 09 8B 46 4C 89 85 D4 02 00 00 80 7E 59 00 74 14 8B 46 48 3B 85 D8 02 00 00 7E 09 8B 46 48 89 85 D8 02 00 00 80 7F 59 00 74 14 8B 47 4C 3B 85 D4 02 00 00 7E 09 8B 47 4C 89 85 D4 02 00 00 80 7F 59 00 74 14 8B 47 48 3B 85 D8 02 00 00 7E 09 8B 47 48 89 85 D8 02 00 00 8B C5 8B 10 FF 52 60 84 C0 74 57 0F B6 85 8F 02 00 00 2C 02 72 21 2C 02 73 48 8B 8D BC 02 00 00 03 C9 03 8D D4 02 00 00 BA 02 00 00 00 8B 45 70 E8 ?? ?? ?? ?? EB 2B B2 02 8B C5 8B 08 FF 91 14 01 00 00 8B C8 8B 85 C0 02 00 00 03 C0 03 85 D8 02 00 00 03 C8 BA 03 00 00 00 8B 45 70 E8 ?? ?? ?? ?? 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_967_0 {
	meta:
		name = "TCustomActionBar.CustomAlignPosition"
		size = 1200
		refs = "0021 _DV_TCustomActionControl 0026 @IsClass 0059 TControl.GetClientHeight 0078 TControl.GetClientWidth 00a0 Rect 00e5 TCustomActionBar.GetAutoSizing 0167 SepSize"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 8B 75 08 8D 7D E4 A5 A5 A5 A5 89 4D F8 8B FA 8B D8 8B 75 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 75 04 00 00 89 7D F4 8B 45 E4 83 78 08 01 75 12 8B 47 48 89 83 D8 02 00 00 8B 47 4C 89 83 D4 02 00 00 83 7D E8 00 75 5B 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 50 8D 45 D4 50 B2 01 8B C3 8B 08 FF 91 14 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 14 01 00 00 03 83 C0 02 00 00 8B 93 BC 02 00 00 59 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D4 A5 A5 A5 A5 5F 5E 0F B6 83 8F 02 00 00 2C 01 72 1B 0F 84 F8 00 00 00 FE C8 0F 84 0D 02 00 00 FE C8 0F 84 F6 02 00 00 E9 D0 03 00 00 8B C3 8B 10 FF 52 60 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 83 7D E8 00 0F 84 92 00 00 00 8B 46 08 2B 06 8B 55 F4 8B 52 48 03 93 C0 02 00 00 3B C2 7D 7D 8B C3 E8 ?? ?? ?? ?? 2B 46 04 2B 83 BC 02 00 00 50 8D 45 D4 50 B2 01 8B C3 8B 08 FF 91 14 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 C0 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 14 01 00 00 03 83 C0 02 00 00 8B 93 BC 02 00 00 03 D2 0F B6 8B C4 02 00 00 03 14 8D ?? ?? ?? ?? 8B 4E 04 03 8B D4 02 00 00 03 D1 59 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D4 A5 A5 A5 A5 5E FF 83 B8 02 00 00 8B 46 04 8B 55 18 89 02 8B 06 8B 55 F8 89 02 8B 45 10 8B 93 D4 02 00 00 89 10 8B 45 F4 8B 40 48 03 83 90 02 00 00 01 06 E9 ED 02 00 00 8B C3 8B 10 FF 52 60 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 94 00 00 00 83 7D E8 00 0F 84 8A 00 00 00 8B 46 08 2B 06 8B 55 F4 3B 42 48 7D 7D 8B C3 E8 ?? ?? ?? ?? 2B 46 04 2B 83 BC 02 00 00 50 8D 45 D4 50 B2 01 8B C3 8B 08 FF 91 14 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 2B 83 C0 02 00 00 5A 2B C2 50 33 D2 8B C3 8B 08 FF 91 14 01 00 00 03 83 C0 02 00 00 8B 93 BC 02 00 00 03 D2 0F B6 8B C4 02 00 00 03 14 8D ?? ?? ?? ?? 8B 4E 04 03 8B D4 02 00 00 03 D1 59 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D4 A5 A5 A5 A5 5E FF 83 B8 02 00 00 8B 46 04 8B 55 18 89 02 8B 45 E8 85 C0 75 27 8B 56 08 8B 45 F4 8B 40 48 2B D0 2B 93 C0 02 00 00 8B 4D F8 89 11 03 83 BC 02 00 00 03 83 90 02 00 00 29 46 08 EB 29 8B 4E 08 8B 55 F4 8B 52 48 2B CA 8B 7D F8 89 0F 8B 4D E4 8B 49 08 49 3B C1 75 05 29 56 08 EB 09 03 93 90 02 00 00 29 56 08 8B 45 10 8B 93 D4 02 00 00 89 10 E9 D0 01 00 00 8B C3 8B 10 FF 52 60 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 81 00 00 00 83 7D E8 00 74 7B 8B 46 0C 2B 46 04 8B 55 F4 3B 42 4C 7D 6D 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 50 8D 45 D4 50 B2 01 8B C3 8B 08 FF 91 14 01 00 00 50 8B C3 E8 ?? ?? ?? ?? 8B C8 2B 8B C0 02 00 00 58 2B C8 8B 06 03 83 D8 02 00 00 8B 93 C0 02 00 00 03 D2 03 C2 0F B6 93 C4 02 00 00 03 04 95 ?? ?? ?? ?? 8B 93 BC 02 00 00 E8 ?? ?? ?? ?? 56 8B FE 8D 75 D4 A5 A5 A5 A5 5E FF 83 B4 02 00 00 83 7D E8 00 75 0D 8B 45 18 8B 93 BC 02 00 00 89 10 EB 08 8B 46 04 8B 55 18 89 02 B2 02 8B C3 8B 08 FF 91 14 01 00 00 03 83 D8 02 00 00 89 46 08 8B 06 8B 55 F8 89 02 8B 45 14 8B 93 D8 02 00 00 89 10 8B 45 F4 8B 40 4C 03 83 90 02 00 00 01 46 04 E9 DF 00 00 00 8B C3 8B 10 FF 52 60 84 C0 75 0B 8B C3 E8 ?? ?? ?? ?? 84 C0 74 77 83 7D E8 00 74 71 8B 46 0C 2B 46 04 8B 55 F4 3B 42 4C 7D 63 8B C3 E8 ?? ?? ?? ?? 2B 83 BC 02 00 00 50 8D 45 D4 50 33 D2 8B C3 8B 08 FF 91 14 01 00 00 03 83 C0 02 00 00 8B 4E 08 2B 8B D8 02 00 00 8B 93 C0 02 00 00 03 D2 2B CA 0F B6 93 C4 02 00 00 2B 0C 95 ?? ?? ?? ?? 8B 93 BC 02 00 00 E8 ?? ?? ?? ?? 56 57 8B FE 8D 75 D4 A5 A5 A5 A5 5F 5E FF 83 B4 02 00 00 83 7D E8 00 75 17 8B C3 E8 ?? ?? ?? ?? 2B 47 4C 2B 83 C0 02 00 00 8B 55 18 89 02 EB 11 8B 46 0C 2B 47 4C 2B 83 90 02 00 00 8B 55 18 89 02 8B 56 08 8B 83 D8 02 00 00 2B D0 8B 4D F8 89 11 8B 55 14 89 02 8B 45 F4 8B 40 4C 03 83 90 02 00 00 29 46 0C 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_968_0 {
	meta:
		name = "TCustomActionBar.DrawBackground"
		size = 372
		refs = "001a TActionClient.HasBackground 003c TCustomActionBar.DrawBackground 005b TActionClient.GetBackground 0107 TControl.GetClientWidth 0123 TControl.GetClientHeight"
	strings:
		$1 = { 53 56 57 55 83 C4 E0 8B F0 8B 9E 78 02 00 00 85 DB 0F 84 55 01 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 46 01 00 00 8B 9E 78 02 00 00 0F B6 43 14 83 F8 04 0F 87 33 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 50 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 30 8B 56 48 2B D0 33 C9 8B 86 84 02 00 00 8B 18 FF 53 3C E9 E3 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 50 33 C9 33 D2 8B 86 84 02 00 00 8B 18 FF 53 3C E9 C4 00 00 00 8D 54 24 10 8B C6 8B 08 FF 51 54 8D 44 24 10 50 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B 48 0C 8B 86 84 02 00 00 5A 8B 18 FF 93 80 00 00 00 E9 92 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 30 89 44 24 04 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 8B 10 FF 52 24 89 44 24 08 8B C6 E8 ?? ?? ?? ?? 99 F7 7C 24 04 85 C0 7C 58 40 89 44 24 0C C7 04 24 00 00 00 00 8B C6 E8 ?? ?? ?? ?? 99 F7 7C 24 08 8B D8 85 DB 7C 31 43 33 FF 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B 40 0C 50 8B 4C 24 0C 0F AF CF 8B 54 24 08 0F AF 54 24 04 8B 86 84 02 00 00 8B 28 FF 55 3C 47 4B 75 D2 FF 04 24 FF 4C 24 0C 75 B4 83 C4 20 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_969_0 {
	meta:
		name = "TCustomActionBar.DragOver"
		size = 109
		refs = "0023 TControl.DragOver 0034 _DV_TActionDragObject 0039 @IsClass 0045 _DV_TActionItemDragObject"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 8C 02 00 00 00 74 2D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 46 48 3B 83 78 02 00 00 75 04 33 C0 EB 02 B0 01 88 07 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_970_0 {
	meta:
		name = "TCustomActionBar.DragDrop"
		size = 321
		refs = "001a TControl.DragDrop 002e _DV_TActionDragBaseClass 0033 @AsClass 0040 TCustomActionBar.SetActionManager 004b TActionBars.Add 0075 TCustomActionBar.DragDrop 0083 _DV_TCategoryDragObject 0088 @IsClass 00a9 _DV_TActionDragObject 00cf _DV_TActionItemDragObject 0106 TActionClient.GetItems 010d TActionClientsCollection.InternalRethinkHotkeys 0123 TWinControl.EnableAlign 012d TWinControl.AlignControl 0133 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F9 8B F2 89 45 FC 8B 45 08 50 8B CF 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 78 02 00 00 00 75 3D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 53 40 8B 45 FC E8 ?? ?? ?? ?? 8B 43 40 8B 40 6C E8 ?? ?? ?? ?? 8B 55 FC 89 82 78 02 00 00 8B 45 FC 8B 80 78 02 00 00 8B 55 FC 89 50 0C 8B 45 FC 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 60 01 00 00 EB 4A 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 15 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 00 01 00 00 EB 24 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 13 8B 45 08 50 8B CF 8B D6 8B 45 FC 8B 18 FF 93 04 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 78 02 00 00 E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 78 02 00 00 8B 10 FF 52 30 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C3 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_971_0 {
	meta:
		name = "TCustomActionBar.DoGetControlClass"
		size = 56
	strings:
		$1 = { 53 56 51 8B F2 8B D8 8B D6 8B C3 8B 08 FF 91 2C 01 00 00 89 04 24 66 83 BB A2 02 00 00 00 74 11 54 8B CE 8B D3 8B 83 A4 02 00 00 FF 93 A0 02 00 00 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_972_0 {
	meta:
		name = "TCustomActionBar.DoControlCreated"
		size = 31
	strings:
		$1 = { 53 66 83 B8 9A 02 00 00 00 74 12 8B CA 8B D8 8B D0 8B 83 9C 02 00 00 FF 93 98 02 00 00 5B C3 }
	condition:
		$1
}

rule function_973_0 {
	meta:
		name = "TCustomActionBar.FindAccelItem"
		size = 188
		refs = "0018 TCustomActionBar.FindAccelItem 003e TCustomActionBar.GetItems 0046 TActionClients.GetActionClient 007a TActionClientItem.GetCaption 0086 IsAccel 00a7 @UStrClr 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 66 89 55 FE 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 10 FF 92 30 01 00 00 8B F8 4F 85 FF 7C 61 47 C7 45 F8 00 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 80 78 28 00 74 35 8B 43 44 8B 40 34 80 B8 EA 01 00 00 00 74 26 80 7B 30 00 74 20 80 7B 55 00 74 1A 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 55 F4 0F B7 45 FE E8 ?? ?? ?? ?? 84 C0 75 08 FF 45 F8 4F 75 A7 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_974_0 {
	meta:
		name = "TCustomActionBar.FindFirst"
		size = 54
		refs = "000f TCustomActionBar.HasItems 001a TWinControl.GetControlCount 0025 TCustomActionBar.GetItems 002c TActionClients.GetActionClient"
	strings:
		$1 = { 53 8B D8 83 BB 78 02 00 00 00 74 26 8B C3 E8 ?? ?? ?? ?? 84 C0 74 1B 8B C3 E8 ?? ?? ?? ?? 85 C0 7E 10 8B C3 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_975_0 {
	meta:
		name = "TCustomActionBar.FindItemAt"
		size = 39
		refs = "0008 TWinControl.ControlAtPos 0012 _DV_TCustomActionControl 0017 @IsClass"
	strings:
		$1 = { 53 6A 00 6A 00 B1 01 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 04 8B C3 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_976_0 {
	meta:
		name = "TCustomActionBar.FindItemCaption"
		size = 153
		refs = "0017 TCustomActionBar.FindItemCaption 004a TControl.GetText 0055 AnsiCompareText 0083 @UStrClr 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F8 8B C7 8B 10 FF 92 30 01 00 00 8B F0 4E 85 F6 7C 3B 46 33 DB 8B D3 8B C7 8B 08 FF 91 24 01 00 00 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 8B 55 FC E8 ?? ?? ?? ?? 85 C0 75 11 8B D3 8B C7 8B 08 FF 91 24 01 00 00 89 45 F8 EB 04 43 4E 75 C8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_977_0 {
	meta:
		name = "TCustomActionBar.FindLast"
		size = 64
		refs = "0010 TCustomActionBar.HasItems 001b TCustomActionBar.GetItems 0034 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 8B D8 83 BB 78 02 00 00 00 74 2E 8B C3 E8 ?? ?? ?? ?? 84 C0 74 23 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B D0 4A 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_978_0 {
	meta:
		name = "TCustomActionBar.FindLeastUsedItem"
		size = 299
		refs = "0068 TCustomActionBar.GetItems 006f TActionClients.GetActionClient 011c TCustomActionBar.FindLastVisibleItem"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 88 14 24 8B D8 8B C3 8B 10 FF 92 64 01 00 00 8B F8 85 FF 0F 84 02 01 00 00 EB 10 33 C9 8B D7 8B C3 8B 30 FF 96 10 01 00 00 8B F8 85 FF 74 0F 83 7F 44 00 74 09 8B 47 44 80 78 59 00 74 DD 33 C0 89 44 24 04 8B C3 8B 10 FF 92 30 01 00 00 8B E8 4D 85 ED 0F 8E B5 00 00 00 BE 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 44 00 74 1A 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 59 3A 04 24 75 7A 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 85 C0 74 68 8B D6 8B C3 8B 08 FF 91 24 01 00 00 85 C0 74 58 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 93 7C 02 00 00 8B 52 6C 8B 52 28 2B 50 60 3B 54 24 04 7C 35 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B F8 8B D6 8B C3 8B 08 FF 91 24 01 00 00 8B 80 B4 01 00 00 8B 93 7C 02 00 00 8B 52 6C 8B 52 28 2B 50 60 89 54 24 04 46 4D 0F 85 50 FF FF FF 85 FF 75 09 8B C3 E8 ?? ?? ?? ?? 8B F8 8B C7 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_979_0 {
	meta:
		name = "TCustomActionBar.FindLastVisibleItem"
		size = 64
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 92 08 01 00 00 8B D8 EB 10 33 C9 8B D3 8B C7 8B 18 FF 93 10 01 00 00 8B D8 85 DB 74 13 83 7B 44 00 74 E6 8B 73 44 85 F6 74 06 80 7E 59 00 74 D9 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_980_0 {
	meta:
		name = "TCustomActionBar.FindFirstVisibleItem"
		size = 60
	strings:
		$1 = { 53 56 57 8B F8 8B C7 8B 10 FF 92 64 01 00 00 8B F0 EB 10 33 C9 8B D6 8B C7 8B 18 FF 93 0C 01 00 00 8B F0 85 F6 74 0F 83 7E 44 00 74 09 8B 46 44 80 78 59 00 74 DD 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_981_0 {
	meta:
		name = "PointToRow"
		size = 154
	strings:
		$1 = { 55 8B EC 83 C4 F8 56 57 8B F0 8D 7D F8 A5 A5 B8 01 00 00 00 8B 55 08 8B 52 FC 83 BA B8 02 00 00 01 7E 31 8B 45 08 8B 40 FC 8B 10 FF 92 18 01 00 00 8B 55 08 8B 52 FC 8B 8A B8 02 00 00 99 F7 F9 8B D0 B8 01 00 00 00 EB 01 40 8B CA 0F AF C8 3B 4D FC 7C F5 8B 55 08 8B 52 FC 83 BA B4 02 00 00 01 7E 31 8B 45 08 8B 40 FC 8B 10 FF 92 1C 01 00 00 8B 55 08 8B 52 FC 8B 8A B4 02 00 00 99 F7 F9 8B D0 B8 01 00 00 00 EB 01 40 8B CA 0F AF C8 3B 4D F8 7C F5 5F 5E 59 59 5D C3 }
	condition:
		$1
}

rule function_982_0 {
	meta:
		name = "TCustomActionBar.FindNearestControl"
		size = 513
		refs = "001a TWinControl.ControlAtPos 0024 _DV_TCustomActionControl 0029 @IsClass 0049 PointToRow 006f TCustomActionBar.GetItems 0076 TActionClients.GetActionClient 00b7 TControl.GetBoundsRect"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B F2 89 45 FC 6A 00 6A 00 8B D6 B1 01 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 89 5D F8 E9 BE 01 00 00 33 C0 89 45 F8 C7 45 F4 FF FF FF 7F 55 8B C6 E8 ?? ?? ?? ?? 59 89 45 EC 8B 45 FC 8B 10 FF 92 30 01 00 00 48 85 C0 0F 8C 92 01 00 00 40 89 45 E8 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 0F 84 69 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 80 78 59 00 0F 84 4D 01 00 00 55 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 59 3B 45 EC 0F 85 20 01 00 00 8B 3E 8B 46 04 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 40 3B 06 7E 15 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 78 40 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 44 3B 46 04 7E 18 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 40 44 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E0 3B 06 7D 1D 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 7D E0 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E4 3B 46 04 7D 20 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8D 55 D8 E8 ?? ?? ?? ?? 8B 45 E4 89 45 F0 8B 06 2B C7 8B 16 2B D7 F7 EA 8B 56 04 2B 55 F0 8B 4E 04 2B 4D F0 0F AF D1 03 C2 3B 45 F4 7D 18 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 89 45 F8 43 FF 4D E8 0F 85 74 FE FF FF 8B 45 F8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_983_0 {
	meta:
		name = "TCustomActionBar.FindNextVisibleItem"
		size = 66
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 C9 8B D6 8B C7 8B 18 FF 93 0C 01 00 00 8B F0 EB 10 33 C9 8B D6 8B C7 8B 18 FF 93 0C 01 00 00 8B F0 85 F6 74 0F 83 7E 44 00 74 09 8B 46 44 80 78 59 00 74 DD 8B C6 5F 5E 5B C3 }
	condition:
		$1
}

rule function_984_0 {
	meta:
		name = "TCustomActionBar.FindNext"
		size = 154
		refs = "0015 TCustomActionBar.HasItems 0020 TCollectionItem.GetIndex 0029 TCustomActionBar.GetItems 0053 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 51 88 0C 24 8B EA 8B F8 33 F6 85 ED 74 6E 8B C7 E8 ?? ?? ?? ?? 84 C0 74 1E 8B C5 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 48 3B D8 0F 9C C0 EB 02 33 C0 84 C0 74 1A 8B C5 E8 ?? ?? ?? ?? 40 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F0 EB 37 80 3C 24 00 74 31 8B C7 8B 10 FF 92 30 01 00 00 48 7E 24 8B C7 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B F0 EB 12 80 3C 24 00 74 0C 8B C7 8B 10 FF 92 64 01 00 00 8B F0 8B C6 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_985_0 {
	meta:
		name = "TCustomActionBar.FindPrevious"
		size = 129
		refs = "0013 TCollectionItem.GetIndex 0027 TCustomActionBar.GetItems 002d TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 57 55 8B D9 8B EA 8B F0 33 FF 85 ED 74 5A 8B C5 E8 ?? ?? ?? ?? 85 C0 7E 1A 8B C5 E8 ?? ?? ?? ?? 48 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F8 EB 45 84 DB 74 41 8B C6 8B 10 FF 92 30 01 00 00 48 7E 34 8B C6 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B D0 4A 8B C3 E8 ?? ?? ?? ?? 8B F8 EB 10 84 DB 74 0C 8B C6 8B 10 FF 92 08 01 00 00 8B F8 8B C7 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_986_0 {
	meta:
		name = "TCustomActionBar.GetActionControl"
		size = 49
		refs = "001b TCustomActionBar.GetItems 0022 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 22 8B C3 8B 10 FF 92 30 01 00 00 3B F0 7D 14 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_987_0 {
	meta:
		name = "TCustomActionBar.GetBannerWidth"
		size = 111
		refs = "0026 TActionClient.GetBackground 002b TPicture.GetBitmap"
	strings:
		$1 = { 56 57 8B F0 33 C0 8B BE 78 02 00 00 85 FF 74 5C 80 EA 01 72 08 74 1F FE CA 74 34 EB 4F 80 7F 14 03 75 49 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 EB 36 80 7F 14 04 75 30 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 EB 1D 0F B6 57 14 80 C2 FD 80 EA 02 73 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 30 5F 5E C3 }
	condition:
		$1
}

rule function_989_0 {
	meta:
		name = "TCustomActionBar.GetItems"
		size = 44
		refs = "0018 TActionClient.GetContextItems 0023 TActionClient.GetItems"
	strings:
		$1 = { 33 D2 8B 88 78 02 00 00 85 C9 74 1D 80 B8 DC 02 00 00 00 74 0B 8B C1 E8 ?? ?? ?? ?? 8B D0 EB 09 8B C1 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_990_0 {
	meta:
		name = "TCustomActionBar.HasItems"
		size = 58
		refs = "0031 TActionClient.GetHasItems"
	strings:
		$1 = { 33 D2 8B 88 78 02 00 00 85 C9 74 2B 80 B8 DC 02 00 00 00 74 19 8B 51 1C 85 D2 74 0C 8B 42 08 83 78 08 00 0F 9F C0 EB 02 33 C0 8B D0 EB 09 8B C1 E8 ?? ?? ?? ?? 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_991_0 {
	meta:
		name = "TCustomActionBar.ItemCount"
		size = 42
		refs = "000f TCustomActionBar.HasItems 001a TCustomActionBar.GetItems"
	strings:
		$1 = { 53 8B D8 83 BB 78 02 00 00 00 74 1A 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_992_0 {
	meta:
		name = "TCustomActionBar.Loaded"
		size = 59
		refs = "0006 TControl.Loaded 0019 TCustomActionBar.SetActionManager 0029 TCustomActionBar.SetupDefaultColorMap"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 7C 02 00 00 85 C0 74 09 8B D0 8B C3 E8 ?? ?? ?? ?? 83 BB 88 02 00 00 00 75 13 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 48 01 00 00 5B C3 }
	condition:
		$1
}

rule function_993_0 {
	meta:
		name = "TCustomActionBar.Notification"
		size = 82
		refs = "0010 TWinControl.Notification"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? FE CB 75 36 3B BE 7C 02 00 00 75 14 8B C6 8B 10 FF 92 F4 00 00 00 33 C0 89 86 7C 02 00 00 EB 1A 3B BE 88 02 00 00 75 12 F6 46 1C 08 75 0C 33 D2 8B C6 8B 08 FF 91 48 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_994_0 {
	meta:
		name = "TCustomActionBar.Paint"
		size = 39
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 34 01 00 00 66 83 BB AA 02 00 00 00 74 0E 8B D3 8B 83 AC 02 00 00 FF 93 A8 02 00 00 5B C3 }
	condition:
		$1
}

rule function_995_0 {
	meta:
		name = "TCustomActionBar.PaintWindow"
		size = 169
		refs = "0014 TCustomCanvas.Lock 001c TCustomActionBar.PaintWindow 0032 TCanvas.SetHandle 004e TControlCanvas.UpdateTextFlags 007c @HandleFinally 0099 TCustomCanvas.Unlock"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 84 02 00 00 8B D3 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 38 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 33 D2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 5B 59 5D C3 }
	condition:
		$1
}

rule function_996_0 {
	meta:
		name = "TCustomActionBar.SetActionClient"
		size = 124
		refs = "0046 TControl.SetColor 004d TActionClient.GetOwningCollection 0052 TActionClientsCollection.GetActionManager 005b TCustomActionBar.SetActionManager"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B B3 78 02 00 00 74 6B 8B C3 8B 10 FF 92 F4 00 00 00 8B C6 89 83 78 02 00 00 85 C0 75 0D 8B C3 8B 10 FF 92 90 00 00 00 5E 5B C3 8B 83 78 02 00 00 8B 40 24 3D 00 00 00 20 74 09 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 89 B3 78 02 00 00 8B C3 8B 10 FF 92 F0 00 00 00 8B C3 8B 10 FF 92 F8 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_997_0 {
	meta:
		name = "TCustomActionBar.SetDesignMode"
		size = 604
		refs = "0030 TCustomActionBar.GetItems 0043 TCustomActionBar.SetDesignMode 009a TCustomActionBar.GetAutoSizing 012d TControl.SetHeight 013c TControl.SetWidth 016b TActionClients.GetActionClient 018e TControl.SetVisible 01f0 ControlDragMode 021a TActionClientItem.GetAction"
	strings:
		$1 = { 56 57 55 83 C4 F4 8B F0 3A 96 8D 02 00 00 0F 84 3D 02 00 00 88 96 8D 02 00 00 F6 46 1C 10 0F 85 2D 02 00 00 83 BE 78 02 00 00 00 74 0D 8B C6 E8 ?? ?? ?? ?? 80 78 24 00 74 12 8B 86 78 02 00 00 0F B6 15 ?? ?? ?? ?? 3A 50 31 75 2F 80 BE 8D 02 00 00 00 74 18 8B C6 8B 10 FF 52 5C 88 86 8E 02 00 00 33 D2 8B C6 8B 08 FF 51 74 EB 0E 0F B6 96 8E 02 00 00 8B C6 8B 08 FF 51 74 8B C6 8B 10 FF 92 20 01 00 00 84 C0 74 47 8B C6 8B 10 FF 92 20 01 00 00 84 C0 74 0B 8B C6 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 86 E4 02 00 00 8B 46 48 89 44 24 04 8B 46 4C 89 44 24 08 8B 44 24 04 89 86 C8 02 00 00 8B 44 24 08 89 86 CC 02 00 00 8B C6 8B 10 FF 92 20 01 00 00 84 C0 75 09 80 BE E4 02 00 00 00 74 0E 8B C6 8B 10 FF 92 30 01 00 00 85 C0 7F 04 33 D2 EB 02 B2 01 8B C6 8B 08 FF 91 44 01 00 00 8B C6 8B 10 FF 92 20 01 00 00 84 C0 75 2D 0F B6 86 8F 02 00 00 2C 02 72 06 2C 02 72 11 EB 1C 8B 96 CC 02 00 00 8B C6 E8 ?? ?? ?? ?? EB 0D 8B 96 C8 02 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B E8 4D 85 ED 0F 8C F9 00 00 00 45 C7 04 24 00 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 14 24 E8 ?? ?? ?? ?? 8B F8 8B 47 44 85 C0 0F 84 CB 00 00 00 80 BE 8D 02 00 00 00 74 79 80 78 59 00 75 07 B2 01 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 3A 47 31 74 12 8B 86 78 02 00 00 0F B6 15 ?? ?? ?? ?? 3A 50 31 75 04 33 D2 EB 02 B2 01 8B 47 44 8B 08 FF 51 74 8B C6 8B 10 FF 92 20 01 00 00 84 C0 74 0C 8B 86 78 02 00 00 F6 40 31 02 75 10 8B 86 78 02 00 00 F6 40 31 04 75 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 47 44 8B 08 FF 51 70 EB 49 33 D2 8B 08 FF 51 70 0F B6 47 30 84 C0 75 0A 8B D0 8B 47 44 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 74 0E 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 52 48 EB 0A B2 01 8B 47 44 8B 08 FF 51 74 33 D2 8B 47 44 8B 08 FF 91 F4 00 00 00 FF 04 24 4D 0F 85 0F FF FF FF 83 C4 0C 5D 5F 5E C3 00 00 00 00 }
	condition:
		$1
}

rule function_998_0 {
	meta:
		name = "TCustomActionBar.SetOrientation"
		size = 148
		refs = "003a TCustomActionBar.SetOrientation 0083 TWinControl.EnableAlign 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC 3A 90 8F 02 00 00 74 7B 8B 45 FC 88 90 8F 02 00 00 8B 45 FC 8B 10 FF 92 30 01 00 00 85 C0 7E 63 8B 45 FC 66 FF 80 AC 01 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 30 01 00 00 8B D8 4B 85 DB 7C 1C 43 33 F6 8B D6 8B 45 FC 8B 08 FF 91 24 01 00 00 8B 10 FF 92 F8 00 00 00 46 4B 75 E7 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_999_0 {
	meta:
		name = "TCustomActionBar.SetSpacing"
		size = 22
		refs = "0011 TWinControl.AlignControl"
	strings:
		$1 = { 3B 90 90 02 00 00 74 0D 89 90 90 02 00 00 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1000_0 {
	meta:
		name = "TCustomActionBar.SetActionManager"
		size = 59
		refs = "0017 TComponent.RemoveFreeNotification 0034 TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 7C 02 00 00 3B F0 74 28 85 C0 74 11 8B D3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 F4 00 00 00 8B C6 89 83 7C 02 00 00 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1001_0 {
	meta:
		name = "TCustomActionBar.SetPersistentHotKeys"
		size = 20
		refs = "000f TControl.Refresh"
	strings:
		$1 = { 3A 90 B0 02 00 00 74 0B 88 90 B0 02 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1002_0 {
	meta:
		name = "TCustomActionBar.DoDropActions"
		size = 167
		refs = "0020 TCustomActionBar.FindNearestControl 002b TCustomActionBar.CalcInsertPosition 0035 TActionDragObject.GetActionCount 005b TActionClient.GetItems 0062 TCollection.Insert 0070 TActionDragObject.GetAction 0083 TActionClients.GetActionClient 0089 TActionClientItem.SetAction 0091 TCollectionItem.GetIndex"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 89 55 FC 8B F0 8B 7D 08 89 5D EC 89 7D F0 57 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B D0 8B CB 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 61 8B 45 FC E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 52 47 C7 45 F8 00 00 00 00 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 89 45 F4 8B 55 F8 8B 45 FC E8 ?? ?? ?? ?? 50 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B D8 43 FF 45 F8 4F 75 B6 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1003_0 {
	meta:
		name = "TCustomActionBar.DoDropCategory"
		size = 312
		refs = "0021 TCustomActionBar.FindNearestControl 002d TCustomActionBar.CalcInsertPosition 0037 TCustomActionBar.GetItems 003e TCollection.Insert 004a TActionClientItem.SetCaption 0051 TActionDragObject.GetActionCount 0060 TCollectionItem.GetIndex 006f TActionClients.GetActionClient 00a4 TActionClient.GetItems 00b1 _DV_TActionClientItem 00b6 @AsClass 00c2 TActionDragObject.GetAction 00cc TActionClientItem.SetAction 00dd TActionClientItem.SetLastSession 00fe TActionClientItem.GetAction 0109 TActionClient.GetHasItems 0119 TActionClients.VisibleCount"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B D9 8B FA 89 45 FC 8B 75 08 89 5D EC 89 75 F0 56 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B CB 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B F0 8B 57 50 8B C6 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 D2 00 00 00 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 57 50 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 48 85 C0 7C 60 40 89 45 F8 33 DB 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 F4 E8 ?? ?? ?? ?? 8B 47 40 8B 40 6C 8B 50 28 8B 45 F4 E8 ?? ?? ?? ?? 43 FF 4D F8 75 A6 8B 46 44 8B 10 FF 92 F8 00 00 00 B2 01 8B C6 8B 08 FF 51 2C 8B C6 E8 ?? ?? ?? ?? 85 C0 75 1F 8B C6 E8 ?? ?? ?? ?? 84 C0 74 10 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7F 04 33 D2 EB 02 B2 01 8B 46 44 8B 08 FF 51 74 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1004_0 {
	meta:
		name = "TCustomActionBar.FindPreviousVisibleItem"
		size = 51
	strings:
		$1 = { 53 56 8B F0 33 C9 8B C6 8B 18 FF 93 10 01 00 00 8B D8 EB 10 33 C9 8B D3 8B C6 8B 18 FF 93 10 01 00 00 8B D8 85 DB 74 06 80 7B 30 00 74 E6 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1005_0 {
	meta:
		name = "TCustomActionBar.SetBiDiMode"
		size = 83
		refs = "0013 TControl.SetBiDiMode"
	strings:
		$1 = { 53 56 51 8B DA 8B F0 0F B6 46 61 88 04 24 8B D3 8B C6 E8 ?? ?? ?? ?? 3A 1C 24 74 33 0F B6 86 8F 02 00 00 04 FE 2C 02 72 26 80 EB 01 72 07 80 EB 03 72 10 EB 1A 33 D2 8B C6 8B 08 FF 91 50 01 00 00 EB 0C B2 01 8B C6 8B 08 FF 91 50 01 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1006_0 {
	meta:
		name = "TCustomActionBar.GetBarHeight"
		size = 180
	strings:
		$1 = { 53 56 8B D8 8B 73 4C 8B C3 8B 10 FF 92 30 01 00 00 85 C0 0F 84 96 00 00 00 0F B6 43 5D 04 FD 2C 03 0F 82 88 00 00 00 8B 83 BC 02 00 00 8B F0 03 F6 8B 93 B8 02 00 00 8B CA 49 0F AF F1 8B 8B D4 02 00 00 0F AF CA 03 C8 03 F1 03 F0 80 BB C4 02 00 00 00 74 14 83 BB B8 02 00 00 01 7E 0B 8B 83 B8 02 00 00 48 03 C0 03 F0 F6 83 70 02 00 00 02 74 1A 0F B6 83 71 02 00 00 48 2C 02 73 01 46 0F B6 83 72 02 00 00 48 2C 02 73 01 46 F6 83 70 02 00 00 08 74 1A 0F B6 83 71 02 00 00 48 2C 02 73 01 46 0F B6 83 72 02 00 00 48 2C 02 73 01 46 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1007_0 {
	meta:
		name = "TCustomActionBar.GetBarWidth"
		size = 201
		refs = "001c TCustomActionBar.GetAutoSizing"
	strings:
		$1 = { 53 56 8B D8 8B 73 48 8B C3 8B 10 FF 92 30 01 00 00 85 C0 0F 84 AB 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 9C 00 00 00 0F B6 43 5D 48 2C 02 0F 82 8F 00 00 00 2C 02 0F 84 87 00 00 00 8B 83 C0 02 00 00 8B F0 03 F6 8B 93 B4 02 00 00 8B CA 49 0F AF F1 8B 8B D8 02 00 00 0F AF CA 03 C8 03 F1 03 F0 80 BB D0 02 00 00 00 74 13 83 BB B4 02 00 00 01 7E 0A 8B 83 B4 02 00 00 03 C0 03 F0 F6 83 70 02 00 00 01 74 1A 0F B6 83 71 02 00 00 48 2C 02 73 01 46 0F B6 83 72 02 00 00 48 2C 02 73 01 46 F6 83 70 02 00 00 04 74 0D 0F B6 83 71 02 00 00 48 2C 02 73 01 46 0F B6 83 72 02 00 00 48 2C 02 73 01 46 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1008_0 {
	meta:
		name = "TCustomActionBar.GetDesignMode"
		size = 34
	strings:
		$1 = { 80 B8 8C 02 00 00 00 75 03 33 C0 C3 F6 40 1C 10 75 0D 80 B8 8D 02 00 00 00 75 04 33 C0 EB 02 B0 01 C3 }
	condition:
		$1
}

rule function_1009_0 {
	meta:
		name = "TCustomActionBar.SetHorzMargin"
		size = 39
		refs = "0016 TWinControl.AlignControl 0021 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 3B 96 C0 02 00 00 74 1A 89 96 C0 02 00 00 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 66 BE EF FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1010_0 {
	meta:
		name = "TCustomActionBar.SetVertMargin"
		size = 39
		refs = "0016 TWinControl.AlignControl 0021 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 3B 96 BC 02 00 00 74 1A 89 96 BC 02 00 00 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 66 BE EF FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1011_0 {
	meta:
		name = "TCustomActionBar.SetHorzSeparator"
		size = 39
		refs = "0016 TWinControl.AlignControl 0021 @CallDynaInst"
		altNames = "TCustomActionBar.SetVertSeparator"
	strings:
		$1 = { 56 8B F0 3A 96 C4 02 00 00 74 1A 88 96 C4 02 00 00 8B C6 33 D2 E8 ?? ?? ?? ?? 8B C6 66 BE EF FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1013_0 {
	meta:
		name = "TCustomActionBar.CMResetBar"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 3C 01 00 00 C3 }
	condition:
		$1
}

rule function_1014_0 {
	meta:
		name = "TCustomActionBar.CMThemeChanged"
		size = 27
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 8B 08 FF 91 48 01 00 00 8B C3 8B 10 FF 92 68 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1015_0 {
	meta:
		name = "TCustomActionBar.CMSysFontChanged"
		size = 46
		refs = "0011 @CallDynaInst"
	strings:
		$1 = { 53 56 8B D8 F6 43 1C 01 75 21 8B C3 66 BE EF FF E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 91 48 01 00 00 8B C3 8B 10 FF 92 68 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1016_0 {
	meta:
		name = "TCustomActionBar.Reset"
		size = 128
		refs = "002f TCustomActionBar.Reset 003d TCollectionItem.GetIndex 004d TCustomActionManager.ResetActionBar 0070 TWinControl.EnableAlign 0076 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 83 B8 7C 02 00 00 00 74 67 8B 45 FC 66 FF 80 AC 01 00 00 8B 45 FC 8B 80 78 02 00 00 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 80 7C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 8B 08 FF 91 40 01 00 00 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 59 59 5D C3 }
	condition:
		$1
}

rule function_1019_0 {
	meta:
		name = "TCustomActionBar.VisibleChanging"
		size = 127
		refs = "0012 TCustomActionBar.VisibleChanging 001f TControl.VisibleChanging 0040 SCannotHideActionBand 0045 LoadResString 004f _Dn_Exception 0054 Exception.CreateFmt 0059 @RaiseExcept 006e @UStrClr 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 80 BB 80 02 00 00 00 75 31 8B 43 08 89 45 F8 C6 45 FC 11 8D 45 F8 50 6A 00 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F4 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1020_0 {
	meta:
		name = "TCustomActionBar.WMContextMenu"
		size = 147
		refs = "000c TWinControl.WMContextMenu 001b TActionClient.GetContextItems 002c TCustomActionBar.GetPopupMenuClass 003a _Dn_TCustomActionPopupMenu 003f @AsClass 004d Application 005c TWinControl.SetParentWindow 0084 TCustomActionPopupMenu.Popup 008b TObject.Free"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 85 C0 74 75 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 66 8B C3 E8 ?? ?? ?? ?? 8B 4B 04 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 C6 86 DC 02 00 00 01 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 8B 08 FF 51 78 8B 93 78 02 00 00 8B C6 8B 08 FF 91 40 01 00 00 0F BF 4F 0A 0F BF 57 08 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1021_0 {
	meta:
		name = "TCustomActionBar.GetAutoSizing"
		size = 43
		refs = "000e _DV_TActionBarItem 0013 @IsClass"
	strings:
		$1 = { 53 56 8B D8 8B B3 78 02 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 80 7E 3C 00 75 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1022_0 {
	meta:
		name = "TCustomActionBar.SetAutoSizing"
		size = 54
		refs = "0011 _DV_TActionBarItem 0016 @IsClass 0023 TActionBarItem.SetAutoSize 002e @CallDynaInst"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B B7 78 02 00 00 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C7 66 BE EF FF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1023_0 {
	meta:
		name = "TCustomActionBar.DoDropItem"
		size = 273
		refs = "0022 TCustomActionBar.FindNearestControl 0041 TCustomActionBar.GetItems 005f TControl.GetBoundsRect 0084 TCollectionItem.GetIndex 0092 TActionClientItem.GetActionClients"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 89 4D FC 8B F2 8B F8 8B 45 FC 89 45 F0 8B 45 08 89 45 F4 8D 55 F0 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 46 48 8B 40 44 85 C0 74 08 3B C3 0F 84 CE 00 00 00 85 DB 75 16 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 48 8B 08 FF 51 10 E9 A7 00 00 00 33 C0 89 45 F8 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 3B 45 FC 7C 12 8D 55 CC 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 3B 45 08 7D 2C 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 89 45 EC 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 48 3B 45 EC 7E 07 C7 45 F8 01 00 00 00 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 45 DC 3B 45 FC 7F 12 8D 55 CC 8B C3 E8 ?? ?? ?? ?? 8B 45 D0 3B 45 08 7E 05 33 C0 89 45 F8 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 48 8B 08 FF 51 10 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 03 55 F8 8B 46 48 8B 08 FF 51 14 8B 56 48 8B C7 8B 08 FF 91 5C 01 00 00 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1024_0 {
	meta:
		name = "TCustomActionBar.RecreateControls"
		size = 103
		refs = "0010 TActionClient.GetItems 0032 TActionClients.GetActionClient 003a TObject.Free"
	strings:
		$1 = { 53 56 57 8B D8 8B 83 78 02 00 00 85 C0 74 54 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 7C 38 47 33 F6 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 33 D2 89 50 44 46 4F 75 CB 8B C3 8B 10 FF 92 F8 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1025_0 {
	meta:
		name = "TCustomActionBar.SetBounds"
		size = 179
		refs = "0017 TWinControl.GetAlignDisabled 0027 _DV_TActionBarItem 002c @IsClass 00a6 TWinControl.SetBounds"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D F8 89 55 FC 8B D8 8B 75 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 75 79 8B 83 78 02 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 64 0F B6 43 5D 48 2C 02 72 11 8B C3 8B 10 FF 52 60 84 C0 74 13 80 7B 5D 00 75 0D 8B C3 8B 10 FF 92 18 01 00 00 89 45 08 0F B6 43 5D 04 FD 2C 02 72 11 8B C3 8B 10 FF 52 60 84 C0 74 14 80 7B 5D 00 75 0E 8B C3 8B 10 FF 92 1C 01 00 00 8B F8 EB 02 8B FE 8B C3 8B 10 FF 52 60 84 C0 75 07 3B 7B 48 74 02 8B F7 56 8B 45 08 50 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 59 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1026_0 {
	meta:
		name = "TCustomActionBar.WMPaint"
		size = 52
		refs = "000d TCustomActionBar.WMPaint 001c TWinControl.WMPaint"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 55 01 75 21 A1 ?? ?? ?? ?? 0B 43 54 89 43 54 8B D6 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? F7 D0 23 43 54 89 43 54 5E 5B C3 00 01 00 00 }
	condition:
		$1
}

rule function_1027_0 {
	meta:
		name = "TCustomActionBar.SetColorMap"
		size = 127
		refs = "0017 TCustomActionBarColorMap.Remove 002a TCustomActionBar.SetupDefaultColorMap 003d TCustomActionBarColorMap.Add 004d TControl.SetColor 005e TWinControl.HandleAllocated 0072 TWinControl.GetHandle 0078 SendMessage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 88 02 00 00 3B F0 74 6C 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B C6 89 83 88 02 00 00 85 C0 75 0D 8B C3 E8 ?? ?? ?? ?? 89 83 88 02 00 00 8B D3 8B 83 88 02 00 00 E8 ?? ?? ?? ?? 8B 83 88 02 00 00 8B 50 44 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 8B C3 E8 ?? ?? ?? ?? 84 C0 74 16 6A 00 6A 01 68 85 00 00 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1028_0 {
	meta:
		name = "TCustomActionBar.GetDefaultColorMapClass"
		size = 22
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 8B D3 8B 08 FF 51 04 5B C3 }
	condition:
		$1
}

rule function_1029_0 {
	meta:
		name = "TCustomActionBar.SetupDefaultColorMap"
		size = 140
		refs = "0013 TObject.Free 0031 TCustomActionBar.SetupDefaultColorMap 0045 TComponent.SetSubComponent 0052 TCustomActionBarColorMap.Add"
	strings:
		$1 = { 53 56 8B D8 8D 83 E0 02 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 28 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 E0 02 00 00 BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 18 B2 01 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8B D3 8B 83 E0 02 00 00 E8 ?? ?? ?? ?? 8B 83 E0 02 00 00 5E 5B C3 00 B0 04 02 00 FF FF FF FF 0F 00 00 00 44 00 65 00 66 00 61 00 75 00 6C 00 74 00 43 00 6F 00 6C 00 6F 00 72 00 4D 00 61 00 70 00 00 00 }
	condition:
		$1
}

rule function_1030_0 {
	meta:
		name = "TCustomActionBar.NCPaint"
		size = 1776
		refs = "0014 TCustomActionBar.NCPaint 004f TCustomActionBar.GetColorMap 00b6 GetHighLightColor 00ce GetShadowColor 02dc TWinControl.GetHandle 02e2 GetClientRect 02f4 GetWindowRect 030a MapWindowPoints 031c OffsetRect 0332 ExcludeClipRect 0352 TCanvas.GetHandle 0373 TCanvas.SetHandle 0389 TPen.SetWidth 03e7 TPen.SetColor 06dc @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 8B FA 89 45 FC 8B 45 FC 0F B6 15 ?? ?? ?? ?? 3A 90 70 02 00 00 0F 84 BE 06 00 00 8B 45 FC 0F B6 80 72 02 00 00 8B C8 8B 55 FC 0F B6 92 71 02 00 00 02 CA 03 C0 02 C8 8D 04 52 02 C8 80 E9 03 88 4D EF 8B 45 FC E8 ?? ?? ?? ?? 8B 58 44 8B 45 FC E8 ?? ?? ?? ?? 8B 70 44 0F B6 45 EF 83 F8 0B 0F 87 34 02 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 FA 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 E9 C5 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? BA E2 FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA E7 FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 58 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 E9 F5 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F0 E9 92 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA CE FF FF FF E8 ?? ?? ?? ?? 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 BA 13 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 EB 32 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 89 45 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 40 44 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 58 44 8B 45 FC E8 ?? ?? ?? ?? 8B 70 44 8D 45 DC 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 45 CC 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 02 8D 45 CC 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 8B 4D D0 F7 D9 8B 55 CC F7 DA 8D 45 DC E8 ?? ?? ?? ?? 8B 45 E8 50 8B 45 E4 50 8B 45 E0 50 8B 45 DC 50 57 E8 ?? ?? ?? ?? 8B 4D D0 F7 D9 8B 55 CC F7 DA 8D 45 CC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 84 02 00 00 8B D7 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 8B 40 44 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC F6 80 70 02 00 00 02 75 3E 8B 45 FC F6 80 70 02 00 00 01 0F 84 AB 00 00 00 8B 45 FC 0F B6 80 72 02 00 00 48 2C 02 72 1F 8B 45 FC 80 B8 72 02 00 00 00 0F 85 8C 00 00 00 8B 45 FC 0F B6 80 71 02 00 00 48 2C 02 73 7D 8B 45 FC 8B 80 84 02 00 00 8B 40 44 8B 55 F4 E8 ?? ?? ?? ?? 8B 45 FC F6 80 70 02 00 00 02 74 29 8B 45 FC 8B 80 84 02 00 00 8B 4D D0 8B 55 D4 8B 38 FF 57 5C 8B 55 CC 4A 8B 45 FC 8B 80 84 02 00 00 8B 4D D0 8B 38 FF 57 58 8B 45 FC F6 80 70 02 00 00 01 74 28 8B 45 FC 8B 80 84 02 00 00 8B 4D D0 8B 55 CC 8B 38 FF 57 5C 8B 45 FC 8B 80 84 02 00 00 8B 4D D8 8B 55 CC 8B 38 FF 57 58 8B 45 FC F6 80 70 02 00 00 02 75 36 8B 45 FC F6 80 70 02 00 00 01 0F 84 AB 00 00 00 8B 45 FC 0F B6 80 72 02 00 00 48 2C 02 0F 83 98 00 00 00 8B 45 FC 0F B6 80 71 02 00 00 48 2C 02 0F 83 85 00 00 00 8B 45 FC 8B 80 84 02 00 00 8B 40 44 8B D3 E8 ?? ?? ?? ?? 8B 45 FC F6 80 70 02 00 00 02 74 2C 8B 4D D0 41 8B 55 D4 4A 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 5C 8B 4D D0 41 8B 55 CC 42 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 58 8B 45 FC F6 80 70 02 00 00 01 74 2E 8B 4D D0 41 8B 55 CC 42 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 5C 8B 4D D8 83 E9 02 8B 55 CC 42 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 58 8B 45 FC F6 80 70 02 00 00 08 75 42 8B 45 FC F6 80 70 02 00 00 04 0F 84 B5 00 00 00 8B 45 FC 0F B6 80 72 02 00 00 48 2C 02 72 23 8B 45 FC 80 B8 72 02 00 00 00 0F 85 96 00 00 00 8B 45 FC 0F B6 80 71 02 00 00 48 2C 02 0F 83 83 00 00 00 8B 45 FC 8B 80 84 02 00 00 8B 40 44 8B 55 F0 E8 ?? ?? ?? ?? 8B 45 FC F6 80 70 02 00 00 04 74 2B 8B 55 D4 4A 8B 45 FC 8B 80 84 02 00 00 8B 4D D0 8B 18 FF 53 5C 8B 4D D8 49 8B 55 D4 4A 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 58 8B 45 FC F6 80 70 02 00 00 08 74 2C 8B 4D D8 49 8B 55 D4 4A 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 5C 8B 4D D8 49 8B 55 CC 4A 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 58 8B 45 FC F6 80 70 02 00 00 08 75 36 8B 45 FC F6 80 70 02 00 00 04 0F 84 B4 00 00 00 8B 45 FC 0F B6 80 72 02 00 00 48 2C 02 0F 83 A1 00 00 00 8B 45 FC 0F B6 80 71 02 00 00 48 2C 02 0F 83 8E 00 00 00 8B 45 FC 8B 80 84 02 00 00 8B 40 44 8B D6 E8 ?? ?? ?? ?? 8B 45 FC F6 80 70 02 00 00 04 74 32 8B 4D D0 41 8B 55 D4 83 EA 02 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 5C 8B 4D D8 83 E9 02 8B 55 D4 83 EA 02 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 58 8B 45 FC F6 80 70 02 00 00 08 74 31 8B 4D D8 83 E9 02 8B 55 D4 83 EA 02 8B 45 FC 8B 80 84 02 00 00 8B 18 FF 53 5C 8B 4D D8 83 E9 02 8B 45 FC 8B 80 84 02 00 00 8B 55 CC 8B 18 FF 53 58 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1031_0 {
	meta:
		name = "TCustomActionBar.CMWinINIChange"
		size = 24
		refs = "0006 TWinControl.CMWinIniChange 000d TCustomActionBar.GetColorMap"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 52 3C 5E C3 }
	condition:
		$1
}

rule function_1033_0 {
	meta:
		name = "TCustomActionBar.GetColorMap"
		size = 42
		refs = "0011 TCustomActionBar.SetupDefaultColorMap 0021 TControl.SetColor"
	strings:
		$1 = { 53 56 8B D8 8B B3 88 02 00 00 85 F6 75 0D 8B C3 E8 ?? ?? ?? ?? 8B B3 E0 02 00 00 8B 56 44 8B C3 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1034_0 {
	meta:
		name = "TCustomActionBar.CMMouseLeave"
		size = 66
		refs = "0009 TControl.CMMouseLeave 0039 TWinControl.Broadcast"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 20 01 00 00 84 C0 74 22 C7 04 24 11 B4 00 00 33 C0 89 44 24 04 33 C0 89 44 24 08 33 C0 89 44 24 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1035_0 {
	meta:
		name = "TCustomActionBar.DesignWndProc"
		size = 51
		refs = "0013 Mouse 001a TMouse.GetIsDragging"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 8B 06 2D 14 B0 00 00 75 1B A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 0B 8B D6 8B C7 8B 08 FF 51 EC B3 01 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1036_0 {
	meta:
		name = "TCustomActionBar.Style"
		size = 39
		refs = "001d ActionBarStyles 0022 TActionBarStyleList.GetStyle"
	strings:
		$1 = { 8B 90 7C 02 00 00 85 D2 74 10 83 BA E0 00 00 00 00 74 07 8B 82 E0 00 00 00 C3 33 D2 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1037_0 {
	meta:
		name = "TCustomActionControl.Create"
		size = 168
		refs = "0011 @ClassCreate 001e TGraphicControl.Create 0027 TCustomActionControl.Create 0036 TControl.SetHeight 0042 TControl.SetWidth 0052 TControl.SetParentShowHint 006c Rect 008d @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 BA 16 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 16 00 00 00 8B C6 E8 ?? ?? ?? ?? C6 86 B9 01 00 00 00 B2 01 8B C6 E8 ?? ?? ?? ?? 6A 04 8D 45 F0 50 B9 04 00 00 00 BA 04 00 00 00 B8 04 00 00 00 E8 ?? ?? ?? ?? 56 8D BE C4 01 00 00 8D 75 F0 A5 A5 A5 A5 5E C6 86 EC 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 8B E5 5D C3 04 00 00 00 }
	condition:
		$1
}

rule function_1038_0 {
	meta:
		name = "TCustomActionControl.Destroy"
		size = 57
		refs = "0003 @BeforeDestruction 0027 TGraphicControl.Destroy 0032 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 B4 01 00 00 85 C0 74 0A 3B 70 44 75 05 33 D2 89 50 44 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1039_0 {
	meta:
		name = "TCustomActionControl.BeginAutoDrag"
		size = 36
		refs = "0010 Mouse 001e TControl.BeginDrag"
	strings:
		$1 = { 53 8B D8 B2 01 8B C3 8B 08 FF 91 F4 00 00 00 A1 ?? ?? ?? ?? 8B 00 8B 48 08 33 D2 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1040_0 {
	meta:
		name = "TCustomActionControl.CaptionLength"
		size = 72
		refs = "001d TCustomActionControl.HasGlyph 002c TActionClientItem.GetActionClients"
		altNames = "TRibbonBaseButtonControl.CaptionLength"
	strings:
		$1 = { 53 8B D8 83 BB B4 01 00 00 00 74 0E 8B C3 8B 10 FF 92 AC 00 00 00 84 C0 75 1C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 80 78 28 02 75 0E 8B 83 E4 01 00 00 2B 83 DC 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_1041_0 {
	meta:
		name = "TCustomActionControl.CaptionHeight"
		size = 72
		refs = "001d TCustomActionControl.HasGlyph 002c TActionClientItem.GetActionClients"
		altNames = "TRibbonBaseButtonControl.CaptionHeight"
	strings:
		$1 = { 53 8B D8 83 BB B4 01 00 00 00 74 0E 8B C3 8B 10 FF 92 AC 00 00 00 84 C0 75 1C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 80 78 28 02 75 0E 8B 83 E8 01 00 00 2B 83 E0 01 00 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_1042_0 {
	meta:
		name = "TCustomActionControl.ActualSpacing"
		size = 48
		refs = "0018 TCustomActionControl.CaptionLength"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8D 3C 24 A5 A5 8B D8 83 3C 24 00 74 0B 8B C3 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 06 8B 83 D8 01 00 00 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_35634_0 {
	meta:
		name = "TRibbonBaseButtonControl.ActualSpacing"
		size = 48
		refs = "0018 TRibbonBaseButtonControl.CaptionLength"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8D 3C 24 A5 A5 8B D8 83 3C 24 00 74 0B 8B C3 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 06 8B 83 D8 01 00 00 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1043_0 {
	meta:
		name = "TCustomActionControl.CalcLayout"
		size = 643
		refs = "0036 TCustomActionControl.UpdateTextBounds 009d TCustomActionControl.ActualSpacing 00b0 TCustomActionControl.CaptionHeight 00ce OffsetRect 01d8 TCustomActionControl.CaptionLength"
	strings:
		$1 = { 53 56 57 55 83 C4 D0 8B D8 83 BB B4 01 00 00 00 0F 84 65 02 00 00 8B D4 8B C3 8B 08 FF 91 D0 00 00 00 8B 83 A8 01 00 00 8B 40 40 8B 53 64 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 8B 73 48 8B 7B 4C 0F B6 83 B9 01 00 00 8B D0 80 EA 02 72 0E 80 EA 02 0F 82 EA 00 00 00 E9 1F 02 00 00 84 C0 75 77 8B 83 C4 01 00 00 89 44 24 08 8B C7 D1 F8 79 03 83 D0 00 8B 54 24 04 D1 FA 79 03 83 D2 00 2B C2 89 44 24 0C 8B 44 24 08 89 83 BC 01 00 00 8B 44 24 0C 89 83 C0 01 00 00 8B D4 8B C3 E8 ?? ?? ?? ?? 8B 93 C4 01 00 00 03 14 24 03 C2 50 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B CF D1 F9 79 03 83 D1 00 2B C8 8D 83 DC 01 00 00 5A E8 ?? ?? ?? ?? E9 A4 01 00 00 2B B3 CC 01 00 00 2B 34 24 89 74 24 10 8B C7 D1 F8 79 03 83 D0 00 8B 54 24 04 D1 FA 79 03 83 D2 00 2B C2 89 44 24 14 8B 44 24 10 89 83 BC 01 00 00 8B 44 24 14 89 83 C0 01 00 00 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B CF D1 F9 79 03 83 D1 00 2B C8 8D 83 DC 01 00 00 8B 93 C4 01 00 00 E8 ?? ?? ?? ?? E9 3A 01 00 00 3C 02 0F 85 C2 00 00 00 8B C3 8B 10 FF 92 AC 00 00 00 84 C0 74 39 8B C6 D1 F8 79 03 83 D0 00 8B 14 24 D1 FA 79 03 83 D2 00 2B C2 89 44 24 18 8B 83 C8 01 00 00 89 44 24 1C 8B 44 24 18 89 83 BC 01 00 00 8B 44 24 1C 89 83 C0 01 00 00 EB 45 8B C6 D1 F8 79 03 83 D0 00 8B 14 24 D1 FA 79 03 83 D2 00 2B C2 89 44 24 20 D1 FF 79 03 83 D7 00 8B 44 24 04 D1 F8 79 03 83 D0 00 2B F8 89 7C 24 24 8B 44 24 20 89 83 BC 01 00 00 8B 44 24 24 89 83 C0 01 00 00 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B D6 D1 FA 79 03 83 D2 00 2B D0 8B 8B C0 01 00 00 03 4C 24 04 03 8B D8 01 00 00 8D 83 DC 01 00 00 E8 ?? ?? ?? ?? EB 70 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B FE D1 FF 79 03 83 D7 00 8B D7 2B D0 8D 83 DC 01 00 00 8B 8B C8 01 00 00 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 8B E8 8B C3 E8 ?? ?? ?? ?? 03 83 E0 01 00 00 03 E8 8B C5 8B 14 24 D1 FA 79 03 83 D2 00 2B FA 89 7C 24 28 89 44 24 2C 8B 44 24 28 89 83 BC 01 00 00 8B 44 24 2C 89 83 C0 01 00 00 83 C4 30 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1044_0 {
	meta:
		name = "TCustomActionControl.CMFontChanged"
		size = 31
		refs = "0006 TControl.CMFontChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB B4 01 00 00 00 74 0A 8B C3 8B 10 FF 92 F8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1045_0 {
	meta:
		name = "TCustomActionControl.Click"
		size = 92
		refs = "0016 TCustomActionControl.GetActionBar 0029 TCustomActionControl.ResetUsageData"
	strings:
		$1 = { 53 8B D8 8B 83 B4 01 00 00 85 C0 74 4D 83 78 3C 00 74 47 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 94 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 10 8B 83 B4 01 00 00 8B 40 3C 8B D3 8B 08 FF 51 18 5B C3 }
	condition:
		$1
}

rule function_1046_0 {
	meta:
		name = "TCustomActionControl.DesignWndProc"
		size = 147
		refs = "006f TActionClientItem.GetAction 0085 ActionBarDesigner"
	strings:
		$1 = { 53 56 8B F0 33 C0 8B 0A 81 F9 04 02 00 00 7D 14 83 E9 7B 74 2C 81 C1 7B FE FF FF 83 E9 03 72 36 74 40 EB 6C 81 C1 FC FD FF FF 83 E9 02 72 12 81 C1 F3 51 FF FF 83 E9 02 72 1C 83 E9 1A 74 17 EB 4F 8B 96 B4 01 00 00 85 D2 74 45 83 7A 1C 00 74 3F B0 01 5E 5B C3 8B C6 8B 08 FF 51 EC B0 01 5E 5B C3 8B 9E B4 01 00 00 85 DB 74 22 8B C3 E8 ?? ?? ?? ?? 85 C0 74 17 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 A1 ?? ?? ?? ?? 8B 08 FF 51 10 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1047_0 {
	meta:
		name = "TCustomActionControl.DrawBackground"
		size = 401
		refs = "0015 TCustomActionControl.GetActionBar 004f TActionClient.HasBackground 0093 ThemeServices 0098 TThemeServices.GetThemesEnabled 00ac TCustomActionBar.GetColorMap 00e1 TControl.GetBoundsRect 00fb TCanvas.GetHandle 0108 TWinControl.GetHandle 0115 TThemeServices.DrawParentBackground 0125 TFont.SetHandle 0146 TBrush.GetBitmap 016c BrushStyle 017a TBrush.SetStyle"
	strings:
		$1 = { 56 57 83 C4 F0 8B FA 8B F0 80 BE D4 01 00 00 00 75 29 8B C6 E8 ?? ?? ?? ?? 85 C0 74 1E 83 BE B4 01 00 00 00 74 15 8B C6 E8 ?? ?? ?? ?? F6 40 52 04 0F 95 C0 3C 01 0F 94 C0 EB 02 33 C0 84 C0 74 4B 8B C6 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 31 8B C6 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 17 8B C6 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 0F B6 40 14 04 FD 2C 02 73 04 33 C0 EB 06 B0 01 EB 02 33 C0 84 C0 74 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 C0 84 C0 74 23 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 44 8B 96 A8 01 00 00 8B 52 48 8B 52 10 3B 42 14 0F 94 C0 EB 02 33 C0 84 C0 74 09 F6 46 52 04 0F 95 C0 EB 02 33 C0 84 C0 74 60 8B D4 8B C6 E8 ?? ?? ?? ?? 6A 00 0F B6 86 EC 01 00 00 50 8D 44 24 08 50 8B 86 A8 01 00 00 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A 59 E8 ?? ?? ?? ?? 8B 86 A8 01 00 00 8B 40 40 33 D2 E8 ?? ?? ?? ?? 8B 86 A8 01 00 00 8B 40 40 8B 56 64 8B 08 FF 51 08 EB 4F 8B 86 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 85 C0 75 30 80 BE EC 01 00 00 00 74 09 80 BE D4 01 00 00 00 74 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 86 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 8B D7 8B 86 A8 01 00 00 8B 08 FF 51 4C 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_1048_0 {
	meta:
		name = "TCustomActionControl.DrawGlyph"
		size = 131
		refs = "000b TCustomActionControl.HasGlyph 007a TCustomImageList.Draw"
	strings:
		$1 = { 53 56 57 51 8B FA 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 6B 8B 83 B4 01 00 00 8B 40 5C 50 8D 4C 24 04 33 D2 8B C3 8B 30 FF 96 D8 00 00 00 8B F0 85 F6 74 4B 80 3C 24 00 75 21 8B C3 8B 10 FF 52 5C 84 C0 74 0C 8B 83 B4 01 00 00 83 78 5C FF 75 0A F6 43 1C 10 75 04 33 C0 EB 02 B0 01 8B 57 04 52 8B 93 B4 01 00 00 8B 52 5C 52 6A 03 6A 00 50 8B 0F 8B 93 A8 01 00 00 8B C6 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1049_0 {
	meta:
		name = "TCustomActionControl.DrawLargeGlyph"
		size = 862
		refs = "0015 TCustomActionControl.HasGlyph 002a _Dn_TCustomAction 002f @IsClass 0073 _Dn_TBitmap 0078 TBitmap.Create 0083 TCustomActionControl.DrawLargeGlyph 00c4 TBitmap.GetCanvas 00d1 TBrush.SetColor 0110 Rect 0128 TCanvas.CopyRect 0167 TCanvas.GetHandle 0179 TCustomImageList.GetHandle 017f ImageList_DrawEx 01cf TBitmap.SetTransparentColor 0260 TActionClientItem.GetParentItem 0265 TActionClient.HasBackground 02dc ImageStates 0307 TBrush.GetHandle 0319 DrawState 032e TObject.Free 0334 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 8B F2 8D 7D F8 A5 A5 8B F0 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 36 03 00 00 8B C6 8B 10 FF 52 4C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 1C 03 00 00 8B 86 B4 01 00 00 8B 40 5C 50 8D 4D E7 B2 01 8B C6 8B 18 FF 93 D8 00 00 00 8B D8 C7 45 DC 20 00 00 00 C7 45 E0 20 00 00 00 8B 45 DC 89 45 E8 8B 45 E0 89 45 EC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 38 8B 45 F0 8B 08 FF 51 44 8B 53 34 8B 45 F0 8B 08 FF 51 38 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 48 BA FF FF FF 00 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 5C 84 C0 74 4E 8B 45 F0 E8 ?? ?? ?? ?? 8D 55 CC 8B 08 FF 51 10 8D 45 CC 50 8B 45 F0 8B 10 FF 52 24 50 8D 45 BC 50 8B 45 F0 8B 10 FF 52 30 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 BC 50 8B 45 F0 E8 ?? ?? ?? ?? 8B 8E A8 01 00 00 5A E8 ?? ?? ?? ?? EB 22 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 CC 8B 08 FF 51 10 8D 45 CC 50 8B 45 F0 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 4C 6A 01 6A FF 6A FF 6A 00 6A 00 6A 00 6A 00 8B 45 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 86 B4 01 00 00 8B 40 5C 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 5D E8 8B D3 8B 45 F4 8B 08 FF 51 44 8B 55 EC 8B 45 F4 8B 08 FF 51 38 8B 45 EC 50 8D 45 CC 50 8B CB 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 45 CC 50 8B 45 F4 E8 ?? ?? ?? ?? 8B 4D F0 5A 8B 38 FF 97 80 00 00 00 BA FF FF FF 00 8B 45 F4 E8 ?? ?? ?? ?? B2 01 8B 45 F4 8B 08 FF 51 40 8B D3 8B 45 F0 8B 08 FF 51 44 8B 55 EC 8B 45 F0 8B 08 FF 51 38 8B 45 F0 E8 ?? ?? ?? ?? 8B 40 48 8B 96 A8 01 00 00 8B 52 48 8B 52 10 8B 52 14 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 55 CC 8B 08 FF 51 10 8D 45 CC 50 8B 45 F0 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 4C 8B 45 F4 50 8B 45 F0 E8 ?? ?? ?? ?? 33 C9 33 D2 8B 18 FF 53 3C 8B C6 8B 10 FF 52 5C 84 C0 75 06 F6 46 1C 10 74 7C 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 34 8B 7D FC 8B C7 03 45 EC 50 8D 45 CC 50 8B 5D F8 8B CB 03 4D E8 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 CC 8B 86 A8 01 00 00 8B 4D F4 8B 18 FF 93 80 00 00 00 EB 7C 8B 7D FC 8B C7 03 45 EC 50 8D 45 CC 50 8B 5D F8 8B CB 03 4D E8 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 CC 8B 86 A8 01 00 00 8B 4D F0 8B 18 FF 93 80 00 00 00 EB 48 0F B6 45 E7 8B 04 85 ?? ?? ?? ?? 83 C8 04 50 6A 00 6A 00 8B 45 FC 50 8B 45 F8 50 6A 00 8B 45 F4 8B 10 FF 52 70 50 6A 00 8B 86 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 50 8B 86 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1050_0 {
	meta:
		name = "TCustomActionControl.DrawSeparator"
		size = 612
		refs = "000d TCustomActionControl.GetActionBar 002e TControl.GetClientWidth 0066 TControl.GetClientHeight 00e6 TPen.SetWidth 011c TActionClientItem.Unused 012c TCustomActionBar.GetColorMap 0139 GetShadowColor 0143 TPen.SetColor 01d8 GetHighLightColor"
	strings:
		$1 = { 53 56 57 83 C4 C0 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 44 02 00 00 8B C3 E8 ?? ?? ?? ?? 0F B6 80 8F 02 00 00 2C 02 73 5C 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 89 44 24 10 8B C6 48 89 44 24 14 8B 44 24 10 89 04 24 8B 44 24 14 89 44 24 04 8B C3 E8 ?? ?? ?? ?? 8B F8 D1 FF 79 03 83 D7 00 8B C3 E8 ?? ?? ?? ?? 2B C6 40 89 7C 24 18 89 44 24 1C 8B 44 24 18 89 44 24 08 8B 44 24 1C 89 44 24 0C EB 50 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 89 74 24 20 89 44 24 24 8B 44 24 20 89 04 24 8B 44 24 24 89 44 24 04 8B C3 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 8B 53 48 2B D6 89 54 24 28 89 44 24 2C 8B 44 24 28 89 44 24 08 8B 44 24 2C 89 44 24 0C 8B B3 A8 01 00 00 BA 01 00 00 00 8B 46 44 E8 ?? ?? ?? ?? 80 BB D4 01 00 00 00 74 1C F6 43 1C 10 74 16 8D 54 24 30 8B C3 8B 08 FF 51 54 8D 54 24 30 8B C6 8B 08 FF 51 4C 8B BB B4 01 00 00 85 FF 74 30 8B C7 E8 ?? ?? ?? ?? 84 C0 74 25 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 70 BA CE FF FF FF E8 ?? ?? ?? ?? 8B D0 8B 46 44 E8 ?? ?? ?? ?? EB 30 8B 7B 6C 81 FF 0F 00 00 FF 75 0F BA 10 00 00 FF 8B 46 44 E8 ?? ?? ?? ?? EB 16 BA CE FF FF FF 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 46 44 E8 ?? ?? ?? ?? 8B 4C 24 04 8B 14 24 8B C6 8B 38 FF 57 5C 8B 4C 24 0C 8B 54 24 08 8B C6 8B 38 FF 57 58 8B BB B4 01 00 00 85 FF 74 48 8B C7 E8 ?? ?? ?? ?? 84 C0 74 3D 81 7B 6C 0F 00 00 FF 75 0F BA 14 00 00 FF 8B 46 44 E8 ?? ?? ?? ?? EB 54 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 70 BA 13 00 00 00 E8 ?? ?? ?? ?? 8B D0 8B 46 44 E8 ?? ?? ?? ?? EB 2F 81 7B 6C 0F 00 00 FF 75 0F BA 14 00 00 FF 8B 46 44 E8 ?? ?? ?? ?? EB 17 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 70 8B 46 44 E8 ?? ?? ?? ?? 8B 5C 24 08 8B 3C 24 3B DF 75 1F 8B DF 43 8B D3 8B 4C 24 04 8B C6 8B 38 FF 57 5C 8B D3 8B 4C 24 0C 8B C6 8B 18 FF 53 58 EB 1C 8B 4C 24 04 41 8B D7 8B C6 8B 38 FF 57 5C 8B 4C 24 0C 41 8B D3 8B C6 8B 18 FF 53 58 83 C4 40 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1051_0 {
	meta:
		name = "TCustomActionControl.DrawText"
		size = 156
		refs = "0015 @UStrAddRef 001d TCustomActionControl.DrawText 002e TCanvas.GetHandle 004d @InternalUStrFromLStr 006b @UStrToPWChar 0072 DrawText 0087 @UStrClr 008d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 89 4D F0 89 55 F8 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B F0 8B 45 08 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 08 8B 55 08 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 83 EB 04 8B 1B 8B 7D F0 8B 3F 57 8B 45 F8 50 53 8B 45 08 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1052_0 {
	meta:
		name = "TCustomActionControl.DrawShadowedText"
		size = 303
		refs = "001b @UStrAddRef 0023 TCustomActionControl.DrawShadowedText 003b OffsetRect 004c TFont.SetColor 0057 TCanvas.GetHandle 0076 @InternalUStrFromLStr 0092 @UStrToPWChar 0099 DrawText 011a @UStrClr 0120 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B F2 8D 7D EC A5 A5 A5 A5 89 4D FC 8B D8 8B 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 83 A8 01 00 00 8B 40 40 8B 55 08 E8 ?? ?? ?? ?? 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 10 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 10 8B 55 10 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 8B 45 FC 50 8D 45 EC 50 56 8B 45 10 E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 8D 45 EC 83 C9 FF 83 CA FF E8 ?? ?? ?? ?? 8B 83 A8 01 00 00 8B 40 40 8B 55 0C E8 ?? ?? ?? ?? 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 10 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 10 8B 55 10 E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 8B 45 FC 50 8D 45 EC 50 56 8B 45 10 E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1053_0 {
	meta:
		name = "TCustomActionControl.IsGrouped"
		size = 46
		refs = "000c _Dn_TCustomAction 0011 @IsClass"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 4C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B C3 8B 10 FF 52 4C 83 78 6C 00 7F 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_1054_0 {
	meta:
		name = "TCustomActionControl.Paint"
		size = 947
		refs = "0017 TCustomActionControl.Paint 003b BrushStyle 0049 TBrush.SetStyle 009f TBrush.SetColor 00a8 TCustomActionControl.GetActionBar 00ad TCustomActionBar.GetColorMap 00f9 TCustomActionBar.HasItems 0109 TCustomActionBar.GetItems 0146 TCustomActionControl.HasGlyph 0157 TControl.DrawTextBiDiModeFlags 0199 TFont.SetColor 019e ThemeServices 01a3 TThemeServices.GetThemesEnabled 0274 TControl.GetText 0313 OffsetRect 0346 TPen.SetColor 0359 TPen.SetWidth 035e Mouse 0365 TMouse.GetIsDragging 0386 TCustomActionControl.DrawDragDropPoint 03a0 @UStrArrayClr 03a6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 D2 89 55 D4 89 55 D8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 8B 08 FF 51 54 F6 43 1C 10 74 1E 0F B6 83 EC 01 00 00 0F B6 90 ?? ?? ?? ?? 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? EB 30 80 BB EC 01 00 00 00 74 09 80 BB D4 01 00 00 00 74 04 33 C0 EB 02 B0 01 83 E0 7F 0F B6 90 ?? ?? ?? ?? 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 85 C0 74 1C 81 78 24 00 00 00 20 74 13 8B 50 24 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 44 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 8D 55 EC 8B C3 8B 08 FF 91 C0 00 00 00 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 74 14 BA 02 00 00 00 8B C3 8B 08 FF 91 CC 00 00 00 E9 DB 01 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 34 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 78 29 00 74 12 8D 93 BC 01 00 00 8B C3 8B 08 FF 91 B8 00 00 00 EB 10 8D 93 BC 01 00 00 8B C3 8B 08 FF 91 BC 00 00 00 8B C3 8B 10 FF 92 AC 00 00 00 84 C0 75 0F 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 85 7A 01 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 0D 00 01 00 00 89 45 FC 8D B3 DC 01 00 00 8D 7D DC A5 A5 A5 A5 8B 83 A8 01 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 54 8B 83 A8 01 00 00 8B 40 40 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B 83 A8 01 00 00 8B 40 40 8B 53 64 8B 08 FF 51 08 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 6D 8B C3 8B 10 FF 52 5C 84 C0 75 14 8B C3 8B 10 FF 52 5C 84 C0 75 57 80 BB D4 01 00 00 00 74 4E 80 BB D4 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 68 8B 83 A8 01 00 00 8B 40 40 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 5C 84 C0 75 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 4C 8B 83 A8 01 00 00 8B 40 40 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 1F 8B C3 8B 10 FF 52 5C 84 C0 75 14 8B C3 8B 10 FF 52 5C 84 C0 75 29 80 BB D4 01 00 00 00 74 20 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 50 8D 4D FC 8D 55 DC 8B C3 8B 30 FF 96 C4 00 00 00 EB 3E 8D 55 D4 8B C3 E8 ?? ?? ?? ?? 8B 45 D4 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 4C 50 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 50 50 8B 4D FC 8D 55 DC 8B C3 8B 30 FF 96 C8 00 00 00 80 BB D4 01 00 00 00 0F 84 A1 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 92 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 74 7F 8D 55 EC 8B C3 8B 08 FF 51 54 8D 45 EC B9 01 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? FF 4D F4 FF 4D F8 8B 83 A8 01 00 00 8B 40 48 B2 01 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 74 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B 83 A8 01 00 00 8B 40 44 BA 02 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 75 0D 8D 55 EC 8B C3 8B 08 FF 91 B4 00 00 00 80 BB B8 01 00 00 00 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1055_0 {
	meta:
		name = "TBaseAdapterAction.GetIsAdapterActionList"
		size = 6
		altNames = "TCustomActionControl.PositionChanged TCustomAdapter.HasViewAccess TDBXTimeValue.GetAsTime TDBXValue.GetAsTime TWebDataInput.RestoreDefaults"
	strings:
		$1 = { 8B 10 FF 52 68 C3 }
	condition:
		$1
}

rule function_1057_0 {
	meta:
		name = "TCustomActionControl.SetTransparent"
		size = 64
		refs = "0016 TCustomActionControl.SetTransparent"
	strings:
		$1 = { 53 8B D8 3A 93 EC 01 00 00 74 2E 88 93 EC 01 00 00 84 D2 74 0F A1 ?? ?? ?? ?? F7 D0 23 43 50 89 43 50 EB 0B A1 ?? ?? ?? ?? 0B 43 50 89 43 50 8B C3 8B 10 FF 92 90 00 00 00 5B C3 00 40 00 00 00 }
	condition:
		$1
}

rule function_1058_0 {
	meta:
		name = "TCustomActionControl.FindImageList"
		size = 284
		refs = "0019 TActionClient.GetOwningCollection 001e TActionClientsCollection.GetActionManager 0074 TActionClientItem.GetAction 00c5 TCustomActionControl.GetActionBar 00de TCustomImageList.GetCount"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D F8 8B D8 84 D2 74 45 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 9C 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B8 A4 00 00 00 85 FF 75 71 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 3C EB 5C 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B0 84 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 24 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 83 78 5C 00 74 13 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 8B 78 3C EB 13 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 3C 8B C3 8B 10 FF 52 5C 84 C0 75 29 85 F6 74 25 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 12 83 7D 08 FF 7C 0C 8B C6 E8 ?? ?? ?? ?? 3B 45 08 7F 24 85 FF 74 16 83 7D 08 FF 7C 10 8B C7 E8 ?? ?? ?? ?? 3B 45 08 7E 04 8B C7 EB 02 33 C0 8B 55 F8 C6 02 00 EB 08 8B C6 8B 55 F8 C6 02 01 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1059_0 {
	meta:
		name = "TCustomActionControl.FindImageList"
		size = 28
	strings:
		$1 = { 53 56 57 51 8B F9 8B F0 57 8D 4C 24 04 8B C6 8B 18 FF 93 D8 00 00 00 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1060_0 {
	meta:
		name = "TCustomActionControl.GetImageSize"
		size = 369
		refs = "0023 TCustomActionControl.HasGlyph 0046 TActionClientItem.GetActionClients 005b TActionClientItem.GetAction 00c8 TActionClient.GetOwningCollection 00cd TActionClientsCollection.GetActionManager"
	strings:
		$1 = { 53 56 83 C4 E0 8B F2 8B D8 33 C0 89 04 24 33 C0 89 44 24 04 8B 04 24 89 06 8B 44 24 04 89 46 04 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 3C 01 00 00 8B 83 B4 01 00 00 80 78 65 00 0F 84 2C 01 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 80 78 29 00 0F 84 B7 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 5E 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 83 78 5C 00 0F 84 F3 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 83 78 3C 00 0F 84 DB 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 5C 8B 40 3C 8B 50 38 89 54 24 08 8B 40 34 89 44 24 0C 8B 44 24 08 89 06 8B 44 24 0C 89 46 04 E9 AA 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 78 3C 00 0F 84 90 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 3C 8B 50 38 89 54 24 10 8B 40 34 89 44 24 14 8B 44 24 10 89 06 8B 44 24 14 89 46 04 EB 60 C7 44 24 18 20 00 00 00 C7 44 24 1C 20 00 00 00 8B 44 24 18 89 06 8B 44 24 1C 89 46 04 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 A4 00 00 00 00 74 2A 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 80 A4 00 00 00 8B 50 34 3B 56 04 7E 03 89 56 04 8B 50 38 3B 16 7E 02 89 16 83 C4 20 5E 5B C3 }
	condition:
		$1
}

rule function_1061_0 {
	meta:
		name = "TCustomActionControl.SetActionClient"
		size = 240
		refs = "000f TCustomActionControl.SetActionClient 002e TActionClient.SetActionBar 006f TCustomActionControl.SetTransparent 0078 TControl.SetParentColor 00a0 TControl.SetColor 00ab TControl.SetVisible 00b9 TActionClientItem.GetCaption 00c3 TControl.SetText 00d8 @UStrClr 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 B4 01 00 00 3B F0 0F 84 A0 00 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 89 B3 B4 01 00 00 8B C3 8B 10 FF 52 4C 85 C0 74 0B A1 ?? ?? ?? ?? 0B 43 50 89 43 50 85 F6 74 75 8B 83 B4 01 00 00 8B 40 24 8B D0 81 EA FF FF FF 1F 74 05 4A 74 16 EB 1F B2 01 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? EB 26 B2 01 8B C3 E8 ?? ?? ?? ?? EB 1B 3D 00 00 00 20 75 0B B2 01 8B C3 E8 ?? ?? ?? ?? EB 09 8B D0 8B C3 E8 ?? ?? ?? ?? 0F B6 56 30 8B C3 E8 ?? ?? ?? ?? 8D 55 FC 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 00 80 00 00 }
	condition:
		$1
}

rule function_1062_0 {
	meta:
		name = "TCustomActionControl.SetSelected"
		size = 206
		refs = "000f TCustomActionControl.SetSelected 0032 TCustomActionControl.UpdateSelection 004b TActionClientItem.GetAction 0065 GetLongHint 006d Application 0074 TApplication.SetHint 0082 TApplication.CancelHint 0091 TCollectionItem.GetIndex 009d TWinControl.GetHandle 00a8 NotifyWinEvent 00bd @UStrClr 00c3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3A 9E D4 01 00 00 0F 84 87 00 00 00 88 9E D4 01 00 00 84 DB 74 07 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 90 00 00 00 84 DB 74 42 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 27 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 7C 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? EB 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 DB 74 22 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 40 50 6A FC 8B 46 34 E8 ?? ?? ?? ?? 50 68 05 80 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1063_0 {
	meta:
		name = "TCustomActionControl.UpdateSelection"
		size = 48
		refs = "0028 TWinControl.Broadcast"
	strings:
		$1 = { 83 C4 F0 8B 50 34 85 D2 74 22 C7 04 24 02 B4 00 00 33 C9 89 4C 24 04 89 44 24 08 33 C9 89 4C 24 0C 8B CC 8B C2 8B D1 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_1064_0 {
	meta:
		name = "TCustomActionControl.CMItemSelected"
		size = 75
		refs = "0022 TCustomActionControl.GetActionBar 0031 ActionBarDesigner"
	strings:
		$1 = { 56 57 8B FA 8B F0 3B 77 08 0F 94 C2 8B C6 8B 08 FF 91 F4 00 00 00 80 BE D4 01 00 00 00 74 29 8B C6 E8 ?? ?? ?? ?? 80 B8 8C 02 00 00 00 74 19 83 3D ?? ?? ?? ?? 00 74 10 8B 96 B4 01 00 00 A1 ?? ?? ?? ?? 8B 08 FF 51 20 5F 5E C3 }
	condition:
		$1
}

rule function_1065_0 {
	meta:
		name = "TCustomActionControl.SetMargins"
		size = 87
	strings:
		$1 = { 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B 14 24 3B 90 C4 01 00 00 75 24 8B 54 24 04 3B 90 D0 01 00 00 75 18 8B 54 24 08 3B 90 CC 01 00 00 75 0C 8B 54 24 0C 3B 90 D0 01 00 00 74 14 8B F4 8D B8 C4 01 00 00 A5 A5 A5 A5 8B 10 FF 92 F8 00 00 00 83 C4 10 5F 5E C3 }
	condition:
		$1
}

rule function_1066_0 {
	meta:
		name = "TCustomActionControl.SetSpacing"
		size = 56
		refs = "0014 TCustomActionControl.GetActionBar 0024 TWinControl.GetAlignDisabled"
	strings:
		$1 = { 53 8B D8 3B 93 D8 01 00 00 74 2B 89 93 D8 01 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 1A 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 F8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1067_0 {
	meta:
		name = "TCustomActionControl.SetGlyphLayout"
		size = 88
		refs = "0022 Rect"
	strings:
		$1 = { 53 56 83 C4 E8 8B DA 8B F0 3A 9E B9 01 00 00 74 41 8B 46 4C 50 8D 44 24 0C 50 8B 4E 48 33 D2 33 C0 E8 ?? ?? ?? ?? 33 C0 89 04 24 33 C0 89 44 24 04 88 9E B9 01 00 00 8B C6 8B 10 FF 92 F8 00 00 00 8B C6 8B 10 FF 52 68 8B C6 8B 10 FF 92 90 00 00 00 83 C4 18 5E 5B C3 }
	condition:
		$1
}

rule function_1068_0 {
	meta:
		name = "TCustomActionControl.Keyed"
		size = 42
		refs = "0007 TCustomActionControl.ResetUsageData 001d TWinControl.GetHandle 0023 PostMessage"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 73 34 85 F6 74 15 53 6A 00 68 04 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1069_0 {
	meta:
		name = "TCategoryButtons.WMEraseBkgnd"
		size = 8
		altNames = "TChartGalleryPanel.WMGetDlgCode TControl.CMHitTest TCustomActionControl.CMDesignHitTest TCustomRibbon.WMEraseBkgnd TCustomRibbon.WMGetDlgCode TCustomTeeNavigator.WMGetDlgCode TDBCtrlGrid.WMEraseBkgnd TDBCtrlPanel.WMEraseBkgnd TDBNavigator.WMGetDlgCode TMediaPlayer.WMGetDlgCode TPopupGrid.CMHintShow TRibbonSpinButton.WMGetDlgCode TSpinButton.WMGetDlgCode TTabbedNotebook.WMGetDlgCode"
	strings:
		$1 = { C7 42 0C 01 00 00 00 C3 }
	condition:
		$1
}

rule function_1070_0 {
	meta:
		name = "TCustomActionControl.CMHintShow"
		size = 54
	strings:
		$1 = { 53 56 57 55 8B EA 8B D8 8B B3 B4 01 00 00 85 F6 74 1F 83 7E 3C 00 74 19 8B 7D 08 8D 57 38 8B 46 3C 8B 08 FF 51 78 84 C0 75 07 C7 45 0C 01 00 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1071_0 {
	meta:
		name = "TCustomActionControl.DrawDesignFocus"
		size = 12
		refs = "0007 TCustomCanvas.Rectangle"
	strings:
		$1 = { 8B 80 A8 01 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1072_0 {
	meta:
		name = "TCustomActionControl.ResetUsageData"
		size = 95
		refs = "000d TCustomActionControl.GetActionBar 0035 TActionClient.GetHasItems 0058 TActionClientItem.ResetUsageData"
	strings:
		$1 = { 53 56 8B D8 F6 43 1C 10 75 52 8B C3 E8 ?? ?? ?? ?? 85 C0 74 13 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 34 8B B3 B4 01 00 00 85 F6 74 2A 8B C6 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C3 8B 10 FF 52 5C 84 C0 74 14 83 BB B4 01 00 00 00 74 0B 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1073_0 {
	meta:
		name = "TCustomActionControl.DragDrop"
		size = 52
		refs = "0017 TControl.DragDrop"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 8B 45 08 50 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 45 08 50 8B CF 8B D6 8B C3 8B 18 FF 93 A8 00 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1074_0 {
	meta:
		name = "TCustomActionControl.DragOver"
		size = 428
		refs = "0023 TControl.DragOver 0033 TCustomActionControl.GetActionBar 0044 _DV_TActionDragObject 0049 @IsClass 0055 _DV_TActionItemDragObject 0066 _DV_TCategoryDragObject 00b6 TActionClient.IsChildItem 011b TCustomActionBar.FindNextVisibleItem 0140 TCustomActionBar.FindPreviousVisibleItem 01a0 TCustomActionControl.SetDropPoint"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B F2 8B D8 8B 7D 08 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D6 8B C3 E8 ?? ?? ?? ?? 83 BB B4 01 00 00 00 74 43 8B C3 E8 ?? ?? ?? ?? 80 B8 8C 02 00 00 00 74 33 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 26 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 15 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 88 07 80 3F 00 74 3E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2D 83 7E 48 00 0F 95 C0 34 01 88 07 80 3F 00 75 1D 8B 46 48 3B 83 B4 01 00 00 74 12 8B 56 48 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 34 01 88 07 80 3F 00 0F 84 DD 00 00 00 0F B6 45 0C 84 C0 74 08 2C 02 0F 85 CD 00 00 00 33 F6 8B C3 E8 ?? ?? ?? ?? 0F B6 80 8F 02 00 00 2C 01 72 0F 74 36 FE C8 74 57 FE C8 74 78 E9 96 00 00 00 8B 43 48 D1 F8 79 03 83 D0 00 3B 45 FC 0F 8D 83 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 93 B4 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 6D 8B 43 48 D1 F8 79 03 83 D0 00 3B 45 FC 7E 5E 8B C3 E8 ?? ?? ?? ?? 8B 93 B4 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 48 8B 43 4C D1 F8 79 03 83 D0 00 3B 45 10 7D 39 8B C3 E8 ?? ?? ?? ?? 8B 93 B4 01 00 00 E8 ?? ?? ?? ?? 8B F0 EB 23 8B 43 4C D1 F8 79 03 83 D0 00 3B 45 10 7E 14 8B C3 E8 ?? ?? ?? ?? 8B 93 B4 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 75 06 8B B3 B4 01 00 00 8B 46 44 B2 01 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1075_0 {
	meta:
		name = "TCustomActionControl.DrawDragDropPoint"
		size = 301
		refs = "000f TBrush.SetStyle 0016 TCustomActionControl.GetActionBar 001b TCustomActionBar.GetColorMap 002c TPen.SetColor 005f TCanvas.GetHandle 0065 PatBlt 0071 TControl.GetClientHeight 00e7 TControl.GetClientWidth"
	strings:
		$1 = { 53 8B D8 8B 83 A8 01 00 00 8B 40 48 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 74 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 0F B6 80 8F 02 00 00 2C 02 72 09 2C 02 72 79 E9 E0 00 00 00 68 49 00 5A 00 6A 02 6A 06 6A 00 6A 00 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 8B C3 E8 ?? ?? ?? ?? 83 E8 04 50 6A 02 6A 02 6A 02 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 8B C3 E8 ?? ?? ?? ?? 50 6A 06 8B C3 E8 ?? ?? ?? ?? 83 E8 02 50 6A 00 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 68 49 00 5A 00 6A 06 6A 02 6A 00 6A 00 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 6A 02 8B C3 E8 ?? ?? ?? ?? 83 E8 06 50 6A 02 6A 02 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 49 00 5A 00 6A 06 6A 02 6A 00 8B C3 E8 ?? ?? ?? ?? 83 E8 04 50 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1076_0 {
	meta:
		name = "TCustomActionControl.DoStartDrag"
		size = 64
		refs = "0009 _DV_TActionItemDragObject 000e TObject.Create 0026 TActionClientItem.GetActionClients 002b TActionClientsCollection.GetActionManager 0039 TControl.DoStartDrag"
	strings:
		$1 = { 53 56 8B F2 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 06 8B 06 8B 93 B4 01 00 00 89 50 48 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 16 89 42 40 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1077_0 {
	meta:
		name = "TCustomActionControl.HasGlyph"
		size = 49
	strings:
		$1 = { 53 8B D8 33 C0 83 BB B4 01 00 00 00 74 21 8B 83 B4 01 00 00 8B 10 FF 52 34 84 C0 74 0C 8B 83 B4 01 00 00 80 78 65 00 75 04 33 C0 EB 02 B0 01 5B C3 }
	condition:
		$1
}

rule function_1078_0 {
	meta:
		name = "TCustomActionControl.WMSetText"
		size = 31
		refs = "0019 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 8B 86 B0 01 00 00 85 C0 74 09 66 BE D0 FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1079_0 {
	meta:
		name = "TCustomActionControl.GetSeparator"
		size = 19
	strings:
		$1 = { 33 D2 8B 88 B4 01 00 00 85 C9 74 04 0F B6 51 54 8B C2 C3 }
	condition:
		$1
}

rule function_1080_0 {
	meta:
		name = "TCustomActionControl.GetShowCaption"
		size = 64
		refs = "0014 TActionClientItem.GetActionClients"
	strings:
		$1 = { 53 56 57 8B F0 B3 01 8B BE B4 01 00 00 85 FF 74 29 8B C7 E8 ?? ?? ?? ?? 0F B6 40 28 2C 01 72 08 74 0A FE C8 74 12 EB 12 33 DB EB 0E 8B 86 B4 01 00 00 0F B6 58 55 EB 02 B3 01 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1081_0 {
	meta:
		name = "TCustomActionControl.GetShowShortCut"
		size = 41
	strings:
		$1 = { 33 D2 83 B8 B4 01 00 00 00 74 1B 8B 90 B4 01 00 00 80 7A 56 00 74 07 66 83 7A 4C 00 75 04 33 C0 EB 02 B0 01 8B D0 8B C2 C3 }
	condition:
		$1
}

rule function_1082_0 {
	meta:
		name = "TCustomActionControl.IsChecked"
		size = 60
		refs = "0014 TActionClientItem.GetAction 001a _Dn_TCustomAction 001f @IsClass"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 8B B7 B4 01 00 00 85 F6 74 25 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B 87 B4 01 00 00 E8 ?? ?? ?? ?? 0F B6 58 69 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1083_0 {
	meta:
		name = "TCustomActionControl.GetAction"
		size = 21
		refs = "000d TActionClientItem.GetAction"
	strings:
		$1 = { 8B 90 B4 01 00 00 85 D2 74 08 8B C2 E8 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule function_1084_0 {
	meta:
		name = "TCustomActionControl.InitiateAction"
		size = 24
	strings:
		$1 = { 56 57 8B F0 8B BE B4 01 00 00 85 FF 74 07 8B C7 8B 10 FF 52 38 5F 5E C3 }
	condition:
		$1
}

rule function_1085_0 {
	meta:
		name = "TCustomActionControl.GetActionBar"
		size = 19
		refs = "0008 _DV_TCustomActionBar 000d @AsClass"
	strings:
		$1 = { 53 8B D8 8B 43 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1086_0 {
	meta:
		name = "TCustomActionControl.CMTextChanged"
		size = 33
		refs = "000d TCustomActionControl.GetActionBar"
	strings:
		$1 = { 56 8B F0 8B C6 8B 08 FF 51 F0 8B C6 E8 ?? ?? ?? ?? 85 C0 74 0A 8B C6 8B 10 FF 92 F8 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1087_0 {
	meta:
		name = "TCustomActionControl.UpdateTextBounds"
		size = 242
		refs = "0017 TCustomActionControl.UpdateTextBounds 002e Rect 004f TCanvas.GetHandle 005f TActionClientItem.GetCaption 007d @UStrToPWChar 0084 DrawText 009d TControl.GetText 00d7 @UStrClr 00e5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 D2 89 55 E4 89 55 EC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8D 45 F0 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 8D 75 F0 8D BB DC 01 00 00 A5 A5 A5 A5 83 BB B4 01 00 00 00 74 42 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B F0 8D 55 EC 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 7D EC 8D 83 DC 01 00 00 8B D8 68 00 04 00 00 53 6A FF 89 7D E8 8B 45 E8 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? EB 3C 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B F0 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 7D E4 8D 83 DC 01 00 00 8B D8 68 00 04 00 00 53 6A FF 89 7D E8 8B 45 E8 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1088_0 {
	meta:
		name = "TCustomActionControl.CalcBounds"
		size = 270
		refs = "0035 TCustomActionControl.UpdateTextBounds 005a TCustomActionControl.ActualSpacing 006e TCustomActionControl.CaptionLength 007d TCustomActionControl.CaptionHeight"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F0 83 BE B4 01 00 00 00 0F 84 F3 00 00 00 8B D4 8B C6 8B 08 FF 91 D0 00 00 00 8B 86 A8 01 00 00 8B 40 40 8B 56 64 8B 08 FF 51 08 8B C6 E8 ?? ?? ?? ?? 8B 5E 48 8B 46 4C 0F B6 96 B9 01 00 00 80 EA 02 72 0A 80 EA 02 72 49 E9 86 00 00 00 8B D4 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 86 C4 01 00 00 03 04 24 03 D8 8B C6 E8 ?? ?? ?? ?? 03 D8 03 9E CC 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 54 24 04 3B C2 7D 02 8B C2 03 86 C8 01 00 00 03 86 D0 01 00 00 EB 42 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 86 C4 01 00 00 03 04 24 03 D8 03 9E CC 01 00 00 8B D4 8B C6 E8 ?? ?? ?? ?? 8B F8 8B 86 C8 01 00 00 03 44 24 04 03 F8 8B C6 E8 ?? ?? ?? ?? 03 F8 8B C7 03 86 D0 01 00 00 3B 5E 48 75 05 3B 46 4C 74 23 53 50 8B 4E 44 8B 56 40 8B C6 8B 18 FF 93 98 00 00 00 8B C6 8B 10 FF 92 A4 00 00 00 8B C6 8B 10 FF 52 68 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1089_0 {
	meta:
		name = "TCustomActionControl.DoDragDrop"
		size = 616
		refs = "0022 TActionClientItem.GetActionClients 0047 TActionClients.GetActionClient 0080 _DV_TActionDragObject 0085 @IsClass 0095 TCustomActionControl.GetActionBar 00a9 TCustomActionBar.GetItems 00b6 TCustomActionControl.DoDragDrop 00ca @AsClass 00d5 TActionDragObject.GetActionCount 00f4 TCollection.Insert 0111 TActionClientItem.SetLastSession 011b TActionDragObject.GetAction 0124 TActionClientItem.SetAction 015e TWinControl.EnableAlign 0164 @HandleFinally 016f _DV_TActionItemDragObject 01de TCollectionItem.GetIndex 0217 ActionBarDesigner 0237 NotifyDesigner 025b TWinControl.Broadcast"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 55 F8 89 45 FC 33 C0 89 45 F4 8B 45 FC 8B 80 B4 01 00 00 85 C0 74 5A E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 48 46 33 DB 8B 45 FC 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 83 78 44 00 74 26 8B 45 FC 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 80 B8 B8 01 00 00 00 74 05 89 5D F4 EB 04 43 4E 75 BB 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D9 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 66 FF 80 AC 01 00 00 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 56 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 E8 ?? ?? ?? ?? 8B F8 8B 45 FC E8 ?? ?? ?? ?? 8B 80 7C 02 00 00 8B 40 6C 8B 50 28 8B C7 E8 ?? ?? ?? ?? 8B D3 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B 55 F4 8B C7 8B 08 FF 51 14 43 4E 75 AD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 52 24 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D9 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 AE 00 00 00 8B 45 FC 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 8B 5D F8 8B 53 48 3B 42 04 74 41 8B 45 FC 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 43 48 8B 08 FF 51 10 8B 43 48 8B 55 F4 8B 08 FF 51 14 8B 45 FC E8 ?? ?? ?? ?? 8B 80 7C 02 00 00 8B 40 6C 8B 50 28 8B 43 48 E8 ?? ?? ?? ?? EB 54 8B 43 48 E8 ?? ?? ?? ?? 8B F0 8B 45 FC 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 3B F0 7D 03 FF 4D F4 8B 43 48 8B 55 F4 8B 08 FF 51 14 8B 45 FC E8 ?? ?? ?? ?? 80 B8 8C 02 00 00 00 74 19 83 3D ?? ?? ?? ?? 00 74 10 8B 45 F8 8B 50 48 A1 ?? ?? ?? ?? 8B 08 FF 51 20 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E0 11 B4 00 00 33 C0 89 45 E4 33 C0 89 45 E8 33 C0 89 45 EC 8D 55 E0 8B 45 FC 8B 40 34 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1090_0 {
	meta:
		name = "TCustomActionControl.SetSmallIcon"
		size = 36
	strings:
		$1 = { 56 8B F0 3A 96 D5 01 00 00 74 17 88 96 D5 01 00 00 8B C6 8B 10 FF 92 F8 00 00 00 8B C6 8B 10 FF 52 68 5E C3 }
	condition:
		$1
}

rule function_1091_0 {
	meta:
		name = "TCustomActionControl.WMContextMenu"
		size = 188
		refs = "000f TControl.WMContextMenu 0022 TActionClient.GetContextItems 0037 TCustomActionControl.GetActionBar 003c TCustomActionBar.GetPopupMenuClass 004a _Dn_TCustomActionPopupMenu 004f @AsClass 005a TCustomActionControl.WMContextMenu 0096 TCustomActionPopupMenu.Popup 00ab TObject.Free 00b1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 85 C0 0F 84 96 00 00 00 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 0F 8E 83 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4B 04 B2 01 FF 50 2C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC C6 80 DC 02 00 00 01 8B 53 34 8B 45 FC 8B 08 FF 51 78 8B 93 B4 01 00 00 8B 45 FC 8B 08 FF 91 40 01 00 00 0F BF 4E 0A 0F BF 56 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1092_0 {
	meta:
		name = "TCustomActionControl.SetDropPoint"
		size = 78
		refs = "003b TWinControl.Broadcast"
	strings:
		$1 = { 53 83 C4 F0 8B D8 3A 93 B8 01 00 00 74 3B 88 93 B8 01 00 00 84 D2 74 27 83 7B 34 00 74 21 C7 04 24 11 B4 00 00 33 C0 89 44 24 04 89 5C 24 08 33 C0 89 44 24 0C 8B D4 8B 43 34 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1093_0 {
	meta:
		name = "TCustomActionControl.CMItemDropPoint"
		size = 22
		refs = "0011 TCustomActionControl.SetDropPoint"
	strings:
		$1 = { 3B 42 08 74 10 80 B8 B8 01 00 00 00 74 07 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1094_0 {
	meta:
		name = "TActionBarStyleList.GetStyle"
		size = 124
		refs = "000c TActionBarStyleList.GetStyle 0018 ActionBarStyles 0023 SActionBarStyleMissing 0028 LoadResString 0032 _Dn_Exception 0037 Exception.Create 003c @RaiseExcept 004e _DV_TActionBarStyle 0053 @AsClass 006a @UStrClr 0070 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 75 21 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 A1 ?? ?? ?? ?? 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_1095_0 {
	meta:
		name = "TCheckBoxProperties.Assign"
		size = 41
		refs = "000b TCommandProperties.Assign 0013 _DV_TCheckBoxProperties 0018 @IsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 46 18 89 43 18 5E 5B C3 }
	condition:
		$1
}

rule function_1096_0 {
	meta:
		name = "TCheckBoxProperties.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCommandProperties.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3364_0 {
	meta:
		name = "TBaseButtonItem.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13427_0 {
	meta:
		name = "TDBXByteArrayValue.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_29606_0 {
	meta:
		name = "TListControlItem.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C7 46 18 FF FF FF FF 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1097_0 {
	meta:
		name = "TCheckBoxProperties.DoSetWidth"
		size = 31
		refs = "0006 TCommandProperties.GetControl"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0F 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 F8 00 00 00 5B C3 }
	condition:
		$1
}

rule function_1098_0 {
	meta:
		name = "TCheckBoxProperties.SetWidth"
		size = 14
	strings:
		$1 = { 3B 50 18 74 08 89 50 18 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1099_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_13 001a cDefaultSchedule 001f @UStrClr 0024 ActionBarDesigner 0029 @IntfClear 002e DefaultActnBarStyle 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1881_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_31 001a GlobalMalloc 001f @IntfClear 002e SIsAutoInc 0033 @WStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_39692_0 {
	meta:
		name = "Finalization"
		size = 78
		refs = "0007 Finalization 0013 _DV_3 001a EOL 001f @LStrClr 002e EMPTY_STR 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 1E B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1100_0 {
	meta:
		name = "ActnMan"
		size = 88
		refs = "0007 ActnMan 0013 _DV_13 001d ActionBarStyles 0023 _Dn_TControl 0028 _DV_TCustomActionBarColorMap 002d GroupDescendentsWith 0038 _DV_TActionClient 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 73 27 33 C0 A3 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_1104_0 {
	meta:
		name = "GetShadow"
		size = 76
		refs = "0016 CheckWin32Version 002d SystemParametersInfo"
	strings:
		$1 = { 53 51 8B D8 C7 04 24 FF FF FF FF BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 24 6A 00 8D 44 24 04 50 6A 00 68 24 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 0D 83 3C 24 01 1B C0 40 88 83 A4 03 00 00 0F B6 83 A4 03 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1105_0 {
	meta:
		name = "TMenuStack.Create"
		size = 60
		refs = "000b @ClassCreate 001a TOrderedList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_40557_0 {
	meta:
		name = "TConnectionData.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_15875_0 {
	meta:
		name = "TDBXCommandHandler.Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_23965_0 {
	meta:
		name = "TGIFExtensionList.Create"
		size = 60
		refs = "000b @ClassCreate 001a TGIFList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_24117_0 {
	meta:
		name = "TGIFImageList.Create"
		size = 60
		refs = "000b @ClassCreate 001a TGIFList.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 08 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1106_0 {
	meta:
		name = "TDBXArrayList.GetValue"
		size = 19
		refs = "000c TList.Get"
		altNames = "TGIFList.GetItem THeaderList.GetHeader TLocateParamsList.GetItem TMenuStack.GetBars TNotifyList.GetItem TScriptEnginesList.GetItem TScriptObjectFactories.GetFactory"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16160_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetCatalogName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16166_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetForeignKeyName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetForeignKeyName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16162_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetSchemaName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16164_0 {
	meta:
		name = "TDBXMetaDataForeignKey.GetTableName"
		size = 19
		refs = "000c TDBXForeignKeysTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16172_0 {
	meta:
		name = "TDBXMetaDataIndex.GetCatalogName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16178_0 {
	meta:
		name = "TDBXMetaDataIndex.GetIndexName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetIndexName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16174_0 {
	meta:
		name = "TDBXMetaDataIndex.GetSchemaName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16176_0 {
	meta:
		name = "TDBXMetaDataIndex.GetTableName"
		size = 19
		refs = "000c TDBXIndexesTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16226_0 {
	meta:
		name = "TDBXMetaDataTable.GetCatalogName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetCatalogName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16228_0 {
	meta:
		name = "TDBXMetaDataTable.GetSchemaName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetSchemaName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_16230_0 {
	meta:
		name = "TDBXMetaDataTable.GetTableName"
		size = 19
		refs = "000c TDBXTablesTableStorage.GetTableName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19954_0 {
	meta:
		name = "TDSHTTPNativeClient.GetResponseText"
		size = 19
		refs = "000c TIdCustomHTTP.GetResponseText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19981_0 {
	meta:
		name = "TDSHTTPResponseWebBroker.GetContentText"
		size = 19
		refs = "000c TWebResponse.GetUnicodeContent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2313_0 {
	meta:
		name = "TWebDispatch.GetPathInfo"
		size = 19
		refs = "000c TWebPathInfo.GetPathInfo"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1108_0 {
	meta:
		name = "TMenuStack.Pop"
		size = 160
		refs = "0020 TObject.Free 0053 TOrderedList.Count 005f _DV_TCustomActionPopupMenu 0064 @IsClass 006f TMenuStack.Peek 0084 @AsClass"
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 52 04 89 04 24 8B 43 08 F6 40 1C 10 74 0F 8B 04 24 33 D2 89 14 24 E8 ?? ?? ?? ?? EB 74 8B 04 24 8B 80 78 02 00 00 85 C0 74 67 33 D2 89 50 18 8B 04 24 33 D2 89 90 74 03 00 00 33 D2 8B 04 24 8B 08 FF 91 40 01 00 00 8B C3 E8 ?? ?? ?? ?? 48 75 33 8B 43 08 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 21 8B C3 E8 ?? ?? ?? ?? 05 6C 03 00 00 50 8B 44 24 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 89 02 EB 0D 8B 04 24 33 D2 89 14 24 E8 ?? ?? ?? ?? 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1109_0 {
	meta:
		name = "TMenuStack.Push"
		size = 5
		altNames = "TSiteModuleHelper.FindVariable"
	strings:
		$1 = { 8B 08 FF 11 C3 }
	condition:
		$1
}

rule function_1111_0 {
	meta:
		name = "TInternalMDIAction.Destroy"
		size = 52
		refs = "0003 @BeforeDestruction 0016 TObject.Free 0022 TCustomAction.Destroy 002d @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 A8 00 00 00 85 C0 74 05 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1112_0 {
	meta:
		name = "TInternalMDIAction.ExecuteTarget"
		size = 148
		refs = "0023 TWinControl.GetHandle 003a GetParent 0040 SendMessage 004d TCustomForm.Close 008e ShowWindow"
	strings:
		$1 = { 53 8B D8 0F B6 83 B0 00 00 00 2C 01 72 0C 74 36 FE C8 74 3F FE C8 74 67 EB 78 6A 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 68 22 02 00 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 5B C3 6A 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 68 23 02 00 00 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 6A 06 8B 83 A0 00 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1114_0 {
	meta:
		name = "TInternalMDIAction.UpdateTarget"
		size = 8
		refs = "0003 TCustomAction.SetEnabled"
		altNames = "TSendMail.UpdateTarget"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_37411_0 {
	meta:
		name = "TAbstractSocket.Open"
		size = 8
		refs = "0003 TAbstractSocket.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22021_0 {
	meta:
		name = "TApplication.NormalizeAllTopMosts"
		size = 8
		refs = "0003 TApplication.DoNormalizeTopMosts"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_43673_0 {
	meta:
		name = "TChartPen.Show"
		size = 8
		refs = "0003 TChartPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1224_0 {
	meta:
		name = "TCustomAddRemoveItem.SetEnabled"
		size = 8
		refs = "0003 TControl.SetEnabled"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_10124_0 {
	meta:
		name = "TCustomDataSetAdapter.RestoreDefaultAdapterMode"
		size = 8
		refs = "0003 TCustomDataSetAdapter.SetInDefaultMode"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35526_0 {
	meta:
		name = "TCustomRibbonGroup.SetAutoSizing"
		size = 8
		refs = "0003 TCustomActionBar.SetAutoSizing"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_46644_0 {
	meta:
		name = "TCustomTeePanel.PrintLandscape"
		size = 8
		refs = "0003 TCustomTeePanel.PrintOrientation"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28575_0 {
	meta:
		name = "TDirectory.CheckGetAttributesParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28576_0 {
	meta:
		name = "TDirectory.CheckGetCreationTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28577_0 {
	meta:
		name = "TDirectory.CheckGetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28582_0 {
	meta:
		name = "TDirectory.CheckGetLastAccessTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28583_0 {
	meta:
		name = "TDirectory.CheckGetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28584_0 {
	meta:
		name = "TDirectory.CheckGetLastWriteTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28585_0 {
	meta:
		name = "TDirectory.CheckGetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28590_0 {
	meta:
		name = "TDirectory.CheckSetAttributesParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28591_0 {
	meta:
		name = "TDirectory.CheckSetCreationTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28592_0 {
	meta:
		name = "TDirectory.CheckSetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28593_0 {
	meta:
		name = "TDirectory.CheckSetCurrentDirectoryParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28594_0 {
	meta:
		name = "TDirectory.CheckSetLastAccessTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28595_0 {
	meta:
		name = "TDirectory.CheckSetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28596_0 {
	meta:
		name = "TDirectory.CheckSetLastWriteTimeParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28597_0 {
	meta:
		name = "TDirectory.CheckSetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TDirectory.InternalCheckDirPathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21476_0 {
	meta:
		name = "TFieldEditForm.UpButtonClick"
		size = 8
		refs = "0003 TFieldEditForm.MoveDstSelected"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28680_0 {
	meta:
		name = "TFile.CheckDecryptParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28682_0 {
	meta:
		name = "TFile.CheckEncryptParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28683_0 {
	meta:
		name = "TFile.CheckGetAttributesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28684_0 {
	meta:
		name = "TFile.CheckGetCreationTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28685_0 {
	meta:
		name = "TFile.CheckGetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28686_0 {
	meta:
		name = "TFile.CheckGetLastAccessTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28687_0 {
	meta:
		name = "TFile.CheckGetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28688_0 {
	meta:
		name = "TFile.CheckGetLastWriteTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28689_0 {
	meta:
		name = "TFile.CheckGetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28692_0 {
	meta:
		name = "TFile.CheckOpenReadParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28693_0 {
	meta:
		name = "TFile.CheckOpenTextParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28694_0 {
	meta:
		name = "TFile.CheckOpenWriteParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28695_0 {
	meta:
		name = "TFile.CheckReadAllBytesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28699_0 {
	meta:
		name = "TFile.CheckSetAttributesParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28700_0 {
	meta:
		name = "TFile.CheckSetCreationTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28701_0 {
	meta:
		name = "TFile.CheckSetCreationTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28702_0 {
	meta:
		name = "TFile.CheckSetLastAccessTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28703_0 {
	meta:
		name = "TFile.CheckSetLastAccessTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28704_0 {
	meta:
		name = "TFile.CheckSetLastWriteTimeParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28705_0 {
	meta:
		name = "TFile.CheckSetLastWriteTimeUtcParameters"
		size = 8
		refs = "0003 TFile.InternalCheckFilePathParam"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_45221_0 {
	meta:
		name = "TFiltersEditor.ImageResize"
		size = 8
		refs = "0003 TFiltersEditor.Preview"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27087_0 {
	meta:
		name = "TIBQuery.Prepare"
		size = 8
		refs = "0003 TIBQuery.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27483_0 {
	meta:
		name = "TIBSQL.Close"
		size = 8
		refs = "0003 TIBSQL.InternalClose"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27493_0 {
	meta:
		name = "TIBSQL.FreeHandle"
		size = 8
		refs = "0003 TIBSQL.InternalFreeHandle"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27648_0 {
	meta:
		name = "TIBStoredProc.Prepare"
		size = 8
		refs = "0003 TIBStoredProc.SetPrepared"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_27430_0 {
	meta:
		name = "TIBXSQLVAR.Clear"
		size = 8
		refs = "0003 TIBXSQLVAR.SetIsNull"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_34127_0 {
	meta:
		name = "TOutlineNode.Expand"
		size = 8
		refs = "0003 TOutlineNode.SetExpandedState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_28810_0 {
	meta:
		name = "TPath.IsPathRooted"
		size = 8
		refs = "0003 TPath.DoIsPathRooted"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12395_0 {
	meta:
		name = "TQuery.CreateHandle"
		size = 8
		refs = "0003 TQuery.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4440_0 {
	meta:
		name = "TReader.ReadListBegin"
		size = 8
		refs = "0003 TReader.CheckValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_46394_0 {
	meta:
		name = "TSeriesGroup.Hide"
		size = 8
		refs = "0003 TSeriesGroup.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11963_0 {
	meta:
		name = "TSession.Open"
		size = 8
		refs = "0003 TSession.SetActive"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_15654_0 {
	meta:
		name = "TStack<DBXJSON.TJSONAncestor>.Pop"
		size = 8
		refs = "0003 TStack<DBXJSON.TJSONAncestor>.DoPop"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12342_0 {
	meta:
		name = "TStoredProc.CreateHandle"
		size = 8
		refs = "0003 TStoredProc.CreateCursor"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_46721_0 {
	meta:
		name = "TTeeCustomShapeBrushPen.Show"
		size = 8
		refs = "0003 TTeeCustomShapeBrushPen.SetVisible"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_35982_0 {
	meta:
		name = "TTimerSpeedButton.CMMouseenter"
		size = 8
		refs = "0003 TTimerSpeedButton.SetMouseInControl"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_5357_0 {
	meta:
		name = "TTreeNode.GetDropTarget"
		size = 8
		refs = "0003 TTreeNode.GetState"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_4508_0 {
	meta:
		name = "TWriter.WriteListBegin"
		size = 8
		refs = "0003 TWriter.WriteValue"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_48378_0 {
	meta:
		name = "VarIsArray"
		size = 8
		refs = "0003 VarIsArray"
	strings:
		$1 = { B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1115_0 {
	meta:
		name = "UpdateMDIMenuButtons"
		size = 205
		refs = "0012 GetParent 001f FindControl 0027 MenuList 0042 TMenuList.GetMenu 0049 GetParentForm 0062 _DV_TCustomActionMainMenuBar 0067 @IsClass 0082 _Dn_TForm 0092 TCustomForm.get_MDIChildCount 00a6 TCustomActionMainMenuBar.MDIChildRestored 00b9 TCustomActionMainMenuBar.GetActiveMDIChild"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 45 08 8B 40 10 8B 40 0C 50 E8 ?? ?? ?? ?? 85 C0 0F 84 A9 00 00 00 E8 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 8B 78 08 4F 85 FF 0F 8C 90 00 00 00 47 33 DB 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 8B F0 3B 75 FC 75 6B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 50 8B 45 08 8B 40 10 81 78 08 21 02 00 00 75 2E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C6 E8 ?? ?? ?? ?? 48 75 13 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 08 43 4F 0F 85 73 FF FF FF 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1116_0 {
	meta:
		name = "CallWindowHook"
		size = 153
		refs = "0030 UpdateMDIMenuButtons 0038 ActiveMenu 003e _DV_TCustomActionPopupMenu 0043 @IsClass 0073 UpdateActnMenusProc 008a MenuCallWndHook 0090 CallNextHookEx"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 85 DB 75 75 8B 45 10 8B 40 08 83 F8 1A 7F 0C 74 59 83 E8 05 74 11 48 74 17 EB 5E 2D 21 02 00 00 74 05 83 E8 08 75 52 55 E8 ?? ?? ?? ?? 59 EB 49 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 83 3D ?? ?? ?? ?? 00 74 2C A1 ?? ?? ?? ?? 80 B8 90 03 00 00 00 75 1E A1 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 EB 0F 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? 8B 45 10 50 8B 45 0C 50 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_1117_0 {
	meta:
		name = "AddMenuToList"
		size = 62
		refs = "0005 MenuList 000f _DV_TMenuList 0014 TObject.Create 0029 TList.IndexOf 0038 TList.Add"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 75 11 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 DB 74 1B 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 75 0C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1118_0 {
	meta:
		name = "RemoveMenuFromList"
		size = 53
		refs = "0002 MenuList 0013 TList.RemoveItem 0030 TObject.Free"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 2B 8B 15 ?? ?? ?? ?? 33 C9 92 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 78 08 00 75 12 A1 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1119_0 {
	meta:
		name = "TMenuList.Notify"
		size = 100
		refs = "0014 GetCurrentThreadId 001c CallWindowHook 0024 SetWindowsHookEx 0029 MenuCallWndHook 004a UnhookWindowsHookEx 005c TList.Notify"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 84 DB 75 22 83 7E 08 01 75 1C E8 ?? ?? ?? ?? 50 6A 00 B8 ?? ?? ?? ?? 50 6A 04 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 26 80 FB 02 75 21 83 7E 08 00 75 1B 83 3D ?? ?? ?? ?? 00 74 12 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1120_0 {
	meta:
		name = "TCustomActionMenuBar.Create"
		size = 202
		refs = "000e @ClassCreate 001c TCustomActionDockBar.Create 002c TToolWindow.SetEdgeOuter 004b AddMenuToList 0068 Screen 0081 _Dn_TTimer 0086 TTimer.Create 0097 TTimer.SetEnabled 009d TCustomActionMenuBar.ActionIdleTimerProc 00a8 TTimer.SetOnTimer 00b5 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 0D 03 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? C7 86 38 03 00 00 A0 0F 00 00 C6 86 40 03 00 00 01 C6 86 0C 03 00 00 01 8B C6 E8 ?? ?? ?? ?? C7 86 50 03 00 00 96 00 00 00 C6 86 68 03 00 00 01 C6 86 69 03 00 00 01 A1 ?? ?? ?? ?? 8B 00 8B 90 84 00 00 00 8B 46 64 8B 08 FF 51 08 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 9E 08 03 00 00 8B C3 33 D2 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8B 86 08 03 00 00 E8 ?? ?? ?? ?? 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1121_0 {
	meta:
		name = "TCustomActionMenuBar.Destroy"
		size = 92
		refs = "0003 @BeforeDestruction 000e RemoveMenuFromList 0033 TObject.Free 004a TCustomActionBar.Destroy 0055 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 24 03 00 00 85 C0 74 08 33 D2 89 90 74 03 00 00 8D 86 6C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 86 08 03 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1122_0 {
	meta:
		name = "DefaultSystemAnimation"
		size = 319
		refs = "0018 SystemParametersInfo 001d AnimateWindowProc 0081 HideShow 009f TWinControl.GetHandle 00c4 TControl.GetBoundsRect 00d5 TControl.ClientToScreen 0105 UnfoldAnimationStyle"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 6A 00 8B 45 08 83 C0 FC 50 6A 00 68 02 10 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 0F 84 10 01 00 00 8B 45 08 8B 40 F8 8B 80 24 03 00 00 80 B8 0C 03 00 00 00 75 0D 8B 45 08 80 78 F7 00 0F 85 EE 00 00 00 8B 45 08 83 78 FC 00 0F 84 E1 00 00 00 6A 00 8B 45 08 83 C0 FC 50 6A 00 68 12 10 00 00 E8 ?? ?? ?? ?? 8B 45 08 83 78 FC 00 74 3B 8B 45 08 0F B6 40 F7 8B 04 85 ?? ?? ?? ?? 0D 00 00 08 00 50 8B 45 08 8B 40 F8 8B 80 50 03 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 E9 88 00 00 00 8D 55 E8 8B 45 08 8B 40 F8 8B 98 28 03 00 00 8B C3 E8 ?? ?? ?? ?? 8D 55 E8 8D 4D F8 8B 45 08 8B 43 34 E8 ?? ?? ?? ?? 8B 45 08 8B 55 F8 89 50 EC 8B 55 FC 89 50 F0 8B 45 08 8B 40 F8 8B 40 44 8B 55 08 8B 52 F0 83 EA 05 3B C2 0F 9C C0 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 08 0F B6 52 F7 0B 04 95 ?? ?? ?? ?? 50 8B 45 08 8B 40 F8 8B 80 50 03 00 00 50 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1123_0 {
	meta:
		name = "DoAnimation"
		size = 312
		refs = "0017 AnimateWindowProc 005b TControl.ClientToScreen 0092 _DV_TCustomMenuItem 0097 @IsClass 00cd TControl.GetBoundsRect 0112 HideShow 0123 TWinControl.GetHandle"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 8B F0 8D 7D F8 A5 A5 8B 75 08 83 C6 F8 A1 ?? ?? ?? ?? 83 38 00 74 11 8B 06 8B 80 24 03 00 00 80 B8 0C 03 00 00 00 75 0D 8B 45 08 80 78 F7 00 0F 85 F3 00 00 00 8B 06 8B 98 28 03 00 00 8B 43 40 8B 53 44 89 45 F0 89 55 F4 8D 4D E0 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 55 E0 89 50 EC 8B 55 E4 89 50 F0 8B 06 80 B8 0D 03 00 00 03 75 0D 8B 45 08 80 78 F7 00 0F 84 AB 00 00 00 8B 06 8B 98 28 03 00 00 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 28 8B 43 40 8B 53 34 03 42 40 8B 4B 44 03 4A 44 8B D1 89 45 E8 89 55 EC 8B 45 08 8B 55 E8 89 50 EC 8B 55 EC 89 50 F0 EB 27 8D 55 D0 8B C3 E8 ?? ?? ?? ?? 8D 55 D0 8D 4D E0 8B 43 34 E8 ?? ?? ?? ?? 8B 45 08 8B 55 E0 89 50 EC 8B 55 E4 89 50 F0 8B 45 08 8B 40 F0 8B 16 8B 52 44 83 C2 02 3B C2 0F 9F C0 83 E0 7F 8B 44 85 F8 8B 55 08 0F B6 52 F7 0B 04 95 ?? ?? ?? ?? 50 8B 06 8B 80 50 03 00 00 50 8B 06 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF D0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1124_0 {
	meta:
		name = "TCustomActionMenuBar.Animate"
		size = 176
		refs = "004f DefaultSystemAnimation 0058 UnfoldAnimationStyle 005d DoAnimation 007c SlideAnimationStyle 00a2 FadeAnimationStyle"
	strings:
		$1 = { 55 8B EC 83 C4 EC 88 55 F7 89 45 F8 8B 45 F8 8B 10 FF 92 20 01 00 00 84 C0 0F 85 8D 00 00 00 8B 45 F8 8B 80 3C 03 00 00 80 B8 1B 03 00 00 00 75 7B 8B 45 F8 0F B6 80 0D 03 00 00 FE C8 74 0E FE C8 74 13 FE C8 74 1D FE C8 74 55 EB 5F 55 E8 ?? ?? ?? ?? 59 EB 56 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 48 8B 45 F8 83 B8 50 03 00 00 64 7E 22 8B 45 F8 83 A8 50 03 00 00 64 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 F8 83 80 50 03 00 00 64 EB 1A 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0C 55 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B E5 5D C3 }
	condition:
		$1
}

rule function_1125_0 {
	meta:
		name = "TCustomActionMenuBar.CleanupStack"
		size = 52
		refs = "0011 TMenuStack.Peek"
	strings:
		$1 = { 53 56 8B D8 8B B3 84 03 00 00 85 F6 74 23 8B C6 E8 ?? ?? ?? ?? 80 B8 1A 03 00 00 00 75 13 8B 83 84 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1126_0 {
	meta:
		name = "TCustomActionMenuBar.ClearSubMenus"
		size = 65
		refs = "001d TOrderedList.Count 002f TMenuStack.Peek"
	strings:
		$1 = { 53 56 8B F0 80 BE 1A 03 00 00 00 74 31 83 BE 84 03 00 00 00 74 28 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7E 16 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 4B 75 EA 5E 5B C3 }
	condition:
		$1
}

rule function_1127_0 {
	meta:
		name = "TCustomActionMenuBar.CloseMenu"
		size = 149
		refs = "001a TCustomActionMenuBar.SetMouseControl 0050 TMenuStack.Peek 0068 TCustomActionMenuBar.GetSelected 008d TMenuStack.Pop"
	strings:
		$1 = { 53 56 57 8B F0 8B 86 3C 03 00 00 85 C0 74 0F 33 D2 89 90 10 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B 86 24 03 00 00 85 C0 74 07 C6 80 0C 03 00 00 00 C6 86 1A 03 00 00 00 8B 9E 3C 03 00 00 85 DB 74 51 83 BB 84 03 00 00 00 74 48 8B 83 84 03 00 00 E8 ?? ?? ?? ?? 8B BE 3C 03 00 00 3B C7 75 28 C6 86 1A 03 00 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 74 21 8B C6 E8 ?? ?? ?? ?? 8B 40 44 33 D2 8B 08 FF 91 F4 00 00 00 EB 0B 8B 87 84 03 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1128_0 {
	meta:
		name = "TCustomActionMenuBar.CMItemClicked"
		size = 50
		refs = "001b TWinControl.GetHandle 0021 PostMessage"
		altNames = "TCustomActionMenuBar.CMItemKeyed"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 BB 1A 03 00 00 00 75 20 8B 46 08 50 6A 00 8B 06 50 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 C0 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1129_0 {
	meta:
		name = "TCustomActionMenuBar.CMEnterMenuLoop"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 C0 01 00 00 C3 }
	condition:
		$1
}

rule function_1131_0 {
	meta:
		name = "TCustomActionMenuBar.CreateControl"
		size = 112
		refs = "0007 TCustomActionBar.CreateControl 0012 TControl.SetShowHint 001b TActionClientItem.SetShowCaption 003b TActionClientItem.GetAction 0046 TActionClient.GetHasItems 0051 TActionClient.GetItems 0056 TActionClients.VisibleCount"
	strings:
		$1 = { 53 56 8B F2 8B D6 E8 ?? ?? ?? ?? 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 75 3E 8B C3 8B 10 FF 52 5C 84 C0 74 26 8B C6 E8 ?? ?? ?? ?? 85 C0 75 1F 8B C6 E8 ?? ?? ?? ?? 84 C0 74 10 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7F 04 33 D2 EB 02 B2 01 8B C3 8B 08 FF 51 74 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1132_0 {
	meta:
		name = "TCustomActionMenuBar.CreatePopup"
		size = 649
		refs = "0041 TOrderedList.Count 0057 TMenuStack.Peek 0084 TActionClient.GetItems 0089 TActionClients.VisibleCount 00ca TCustomActionMenuBar.CreatePopup 00d8 TCustomActionBar.GetColorMap 00f8 TControl.SetColor 0147 TCustomActionMenuBar.SetParentMenu 01aa TCustomActionBar.FindFirstVisibleItem 01e7 Application 01f7 TWinControl.SetParentWindow 0223 TWinControl.EnableAlign 0229 @HandleFinally 0233 TControl.Show 023c _DV_TCustomMenuButton 0241 @IsClass 027c TTimer.SetEnabled"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 89 4D F8 8B F2 89 45 FC 33 C0 89 45 F4 8B 45 FC 80 B8 1A 03 00 00 00 0F 84 5B 02 00 00 85 F6 0F 84 53 02 00 00 83 7D F8 00 0F 84 49 02 00 00 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 33 02 00 00 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 80 28 03 00 00 3B 45 F8 0F 84 16 02 00 00 8B 45 F8 83 B8 B4 01 00 00 00 0F 84 06 02 00 00 8B 45 F8 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 EB 01 00 00 8B 55 F8 8B 45 FC 8B 08 FF 91 9C 01 00 00 8B 45 FC 33 D2 89 90 10 03 00 00 8B 45 FC 8B 10 FF 92 B0 01 00 00 89 45 F4 8B 45 F4 66 FF 80 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B 45 F4 8B 08 FF 91 48 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 50 78 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 3C 03 00 00 8B 55 F4 89 82 3C 03 00 00 8B 45 FC 0F B6 80 8C 02 00 00 8B 55 F4 88 82 8C 02 00 00 8B 45 F8 8B 80 B4 01 00 00 8B 55 F4 89 50 18 8B 45 FC 8B 50 64 8B 45 F4 8B 40 64 8B 08 FF 51 08 8B D6 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 C6 80 1A 03 00 00 01 8B 45 F4 8B 55 F8 89 90 28 03 00 00 8B 45 F8 8B 80 B4 01 00 00 0F B6 58 30 8B D0 8B 45 F4 8B 08 FF 91 40 01 00 00 8B 45 F8 8B 80 B4 01 00 00 8B D3 8B 08 FF 51 2C 8B 45 FC 80 B8 19 03 00 00 00 75 33 8B 45 FC 8B 10 FF 92 20 01 00 00 84 C0 75 24 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 74 18 8B 45 F8 8B 80 B4 01 00 00 E8 ?? ?? ?? ?? 80 78 2A 00 74 04 33 DB EB 02 B3 01 8B 45 F4 88 98 19 03 00 00 84 DB 74 0D 33 D2 8B 45 F4 8B 08 FF 91 A4 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 20 01 00 00 8B D0 8B 45 F4 8B 08 FF 91 4C 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 45 F8 8B 10 FF 92 90 00 00 00 8B 45 F4 80 B8 18 03 00 00 00 74 0C 8B 45 F4 80 B8 19 03 00 00 00 74 04 33 D2 EB 02 B2 01 8B 45 FC 8B 80 78 03 00 00 E8 ?? ?? ?? ?? 8B 45 F4 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1133_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemSelected"
		size = 183
		refs = "000a _DV_TCustomMenuItem 000f @IsClass 003c TTimer.SetEnabled 004d TMenuStack.Peek 0070 TCustomActionMenuBar.GetSelected 0079 TCustomActionBar.FindFirstVisibleItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 3C 03 00 00 89 B0 10 03 00 00 EB 08 33 C0 89 83 10 03 00 00 8B 83 3C 03 00 00 8B 80 88 03 00 00 B2 01 E8 ?? ?? ?? ?? 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 80 B8 18 03 00 00 00 74 5A 8B 83 3C 03 00 00 8B 80 78 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 74 13 8B 83 3C 03 00 00 8B 80 78 03 00 00 C7 40 0C 01 00 00 00 8B C3 8B 10 FF 92 20 01 00 00 8B D0 80 F2 01 8B 83 3C 03 00 00 8B 80 78 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1134_0 {
	meta:
		name = "TCustomActionMenuBar.ExecAction"
		size = 92
		refs = "0020 sndPlaySound 0027 TCustomActionMenuBar.ExecAction"
	strings:
		$1 = { 53 8B D8 85 D2 74 39 F6 43 1C 10 75 33 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 25 6A 02 6A 00 E8 ?? ?? ?? ?? 6A 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 8C 03 00 00 8B 40 3C 33 D2 8B 08 FF 51 18 5B C3 00 00 4D 00 65 00 6E 00 75 00 43 00 6F 00 6D 00 6D 00 61 00 6E 00 64 00 00 00 }
	condition:
		$1
}

rule function_1135_0 {
	meta:
		name = "TCustomActionMenuBar.DoGetPopupClass"
		size = 49
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 92 A8 01 00 00 89 04 24 66 83 BB 4A 03 00 00 00 74 10 8B CC 8B D3 8B 83 4C 03 00 00 FF 93 48 03 00 00 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_1136_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemClicked"
		size = 437
		refs = "0014 _DV_TCustomMenuButton 0019 @IsClass 0024 TCustomActionMenuBar.ClearSubMenus 0041 TActionClient.GetHasItems 0065 TMenuStack.Pop 0070 TMenuStack.Peek 00a5 TCustomActionMenuBar.GetSelected 00b2 TCustomActionMenuBar.ProcessMessages 00e4 TOrderedList.Count 0153 SystemParametersInfo 018d TMenuStack.GetBars 0194 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 55 51 8B DA 8B F0 33 FF 3B 73 04 75 2A 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 11 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 33 C0 89 86 10 03 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 E3 00 00 00 83 BE 10 03 00 00 00 74 31 EB 11 8B 86 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B 96 10 03 00 00 3B 42 34 75 D9 33 C0 89 86 10 03 00 00 80 7B 59 00 75 15 8B 86 84 03 00 00 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 A4 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B E8 8B 86 3C 03 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 3B E8 0F 85 E8 00 00 00 83 BE 84 03 00 00 00 0F 84 DB 00 00 00 8B 43 34 3B 86 3C 03 00 00 75 31 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 48 7E 23 EB 13 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 48 7F DF 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B CB 8B C6 8B 18 FF 93 8C 01 00 00 C6 86 0C 03 00 00 00 EB 7D 8B BB B4 01 00 00 8B C6 8B 10 FF 92 20 01 00 00 84 C0 75 69 6A 00 8D 44 24 04 50 6A 00 68 14 10 00 00 E8 ?? ?? ?? ?? 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 48 7E 37 83 3C 24 00 74 31 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B D8 83 EB 02 85 DB 7E 1D BD 01 00 00 00 8B D5 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 45 4B 75 E8 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 BC 01 00 00 8B C7 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1137_0 {
	meta:
		name = "TCustomActionMenuBar.DoItemKeyed"
		size = 137
		refs = "0018 TCustomActionMenuBar.DoItemKeyed 0040 TMenuStack.Peek 0045 TCustomActionBar.FindFirstVisibleItem 007b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 56 89 45 FC 8B 45 FC C6 80 1B 03 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 08 FF 91 90 01 00 00 89 45 F8 83 7D F8 00 75 2C 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 83 7E 44 00 74 0D 8B 46 44 B2 01 8B 08 FF 91 F4 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 1B 03 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 8B 45 F8 5E 59 59 5D C3 }
	condition:
		$1
}

rule function_1139_0 {
	meta:
		name = "TCustomActionMenuBar.IsDesignMsg"
		size = 191
		refs = "0016 Mouse 001d TMouse.GetIsDragging 0072 TWinControl.GetHandle 0079 GetForegroundWindow"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B C3 8B 10 FF 92 20 01 00 00 84 C0 74 10 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 02 B0 01 84 C0 0F 84 88 00 00 00 83 BB 14 03 00 00 00 75 14 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 84 C0 74 0C 81 7E 04 02 02 00 00 0F 95 C0 EB 59 83 BB 20 03 00 00 00 74 16 8B 83 20 03 00 00 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 3B F8 75 04 33 C0 EB 02 B0 01 F6 43 1C 10 74 15 84 C0 74 09 81 7E 04 03 B4 00 00 75 04 33 C0 EB 1D B0 01 EB 19 8B 83 3C 03 00 00 85 C0 74 09 80 B8 1A 03 00 00 00 74 04 33 C0 EB 02 B0 01 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1140_0 {
	meta:
		name = "TCustomActionMenuBar.DoMenuDelay"
		size = 227
		refs = "000f TTimer.SetEnabled 004f TMenuStack.Pop 0060 TOrderedList.Count 0074 TMenuStack.Peek 0085 GetCursorPos 009b TControl.ScreenToClient 00af TControl.GetBoundsRect 00b9 PtInRect"
	strings:
		$1 = { 53 83 C4 E0 8B D8 33 D2 8B 83 88 03 00 00 E8 ?? ?? ?? ?? 83 BB 10 03 00 00 00 0F 84 BE 00 00 00 8B 83 10 03 00 00 83 78 34 00 0F 84 AE 00 00 00 8B 80 B4 01 00 00 83 78 18 00 0F 85 9E 00 00 00 EB 11 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 48 7E 1C 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 93 10 03 00 00 3B 42 34 75 BF 54 E8 ?? ?? ?? ?? 8B 83 84 03 00 00 E8 ?? ?? ?? ?? 8D 4C 24 08 8B D4 E8 ?? ?? ?? ?? 8D 44 24 08 50 8D 54 24 14 8B 83 10 03 00 00 E8 ?? ?? ?? ?? 8D 44 24 14 5A E8 ?? ?? ?? ?? 84 C0 74 1D 8B 83 84 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B 8B 10 03 00 00 8B C3 8B 18 FF 93 8C 01 00 00 83 C4 20 5B C3 }
	condition:
		$1
}

rule function_1141_0 {
	meta:
		name = "TCustomActionMenuBar.DoneMenuLoop"
		size = 163
		refs = "0008 TCustomActionMenuBar.SetMouseControl 001b TObject.Free 0022 ActiveMenu 0030 ActionBarDesigner 0051 ShowCaret 0095 TWinControl.GetHandle 009d NotifyWinEvent"
	strings:
		$1 = { 53 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 83 6C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 BB 8C 02 00 00 00 74 18 A1 ?? ?? ?? ?? 83 38 00 74 0E A1 ?? ?? ?? ?? 8B 00 33 D2 8B 08 FF 51 18 C6 83 0C 03 00 00 01 6A 00 E8 ?? ?? ?? ?? 8D 83 88 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 84 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 78 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1142_0 {
	meta:
		name = "TCustomActionMenuBar.DoPopup"
		size = 31
	strings:
		$1 = { 53 66 83 B8 32 03 00 00 00 74 12 8B D8 8B CA 8B D0 8B 83 34 03 00 00 FF 93 30 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1143_0 {
	meta:
		name = "TCustomActionMenuBar.Expand"
		size = 202
		refs = "0034 TCustomActionBar.HasItems 004e TCustomActionMenuBar.Expand 005c TCustomActionBar.GetItems 007b TActionClients.GetActionClient 0098 TControl.SetVisible 00b9 TWinControl.EnableAlign 00bf @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B 45 FC C6 80 19 03 00 00 01 84 D2 74 0F 8B 45 FC 8B 80 3C 03 00 00 88 90 19 03 00 00 8B 45 FC C6 80 18 03 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 84 C0 0F 84 85 00 00 00 8B 45 FC 66 FF 80 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 33 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 0F B6 40 30 50 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 5A E8 ?? ?? ?? ?? 43 4E 75 D0 8B 45 FC 8B 10 FF 52 68 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1144_0 {
	meta:
		name = "TCustomActionMenuBar.ExpandTimer"
		size = 110
		refs = "000c TTimer.SetEnabled 001d TMenuStack.Peek 004a TCustomButtonControl.SetFlat"
	strings:
		$1 = { 56 8B F0 33 D2 8B 86 78 03 00 00 E8 ?? ?? ?? ?? 8B 86 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 80 B8 18 03 00 00 00 74 42 8B 86 78 03 00 00 83 78 0C 01 75 1A 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B 80 9C 03 00 00 33 D2 E8 ?? ?? ?? ?? EB 1C C6 86 19 03 00 00 01 8B 86 84 03 00 00 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 A4 01 00 00 5E C3 }
	condition:
		$1
}

rule function_1145_0 {
	meta:
		name = "TCustomActionMenuBar.GetDesignMode"
		size = 47
		refs = "0006 TCustomActionBar.GetDesignMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 75 1F 83 BB 24 03 00 00 00 74 16 3B 9B 24 03 00 00 74 0E 8B 83 24 03 00 00 8B 10 FF 92 20 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1146_0 {
	meta:
		name = "TCustomActionMenuBar.GetMouseHoverItem"
		size = 183
		refs = "0030 TOrderedList.Count 0045 WindowFromPoint 0054 TMenuStack.GetBars 0059 TWinControl.GetHandle 007f TControl.ScreenToClient 008c TWinControl.ControlAtPos 009c _Dn_TCustomActionControl 00a1 @IsClass"
	strings:
		$1 = { 53 56 57 55 83 C4 D8 8B F2 8D 7C 24 04 B9 07 00 00 00 F3 A5 33 D2 89 14 24 33 FF 8B B0 3C 03 00 00 85 F6 0F 84 83 00 00 00 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B D8 4B 83 FB 00 7C 5C FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 8B E8 8B D3 8B 86 84 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B E8 75 31 8B D3 8B 86 84 03 00 00 E8 ?? ?? ?? ?? 8B F8 6A 00 6A 00 8D 4C 24 28 8D 54 24 20 8B C7 E8 ?? ?? ?? ?? 8D 54 24 28 B1 01 8B C7 E8 ?? ?? ?? ?? 8B F8 4B 83 FB FF 75 A4 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 03 89 3C 24 8B 04 24 83 C4 28 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1147_0 {
	meta:
		name = "TCustomActionMenuBar.GetPopupClass"
		size = 59
		refs = "0025 ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 85 C0 74 13 8B C3 8B 10 FF 92 6C 01 00 00 8B D3 8B 08 FF 51 0C 5B C3 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 0C 5B C3 }
	condition:
		$1
}

rule function_1148_0 {
	meta:
		name = "TCustomActionMenuBar.GetSelected"
		size = 96
	strings:
		$1 = { 53 56 57 55 8B F0 33 ED 8B C6 8B 10 FF 92 30 01 00 00 8B F8 4F 85 FF 7C 40 47 33 DB 8B D3 8B C6 8B 08 FF 91 24 01 00 00 85 C0 74 29 8B D3 8B C6 8B 08 FF 91 24 01 00 00 80 B8 D4 01 00 00 00 74 14 8B D3 8B C6 8B 08 FF 91 24 01 00 00 8B A8 B4 01 00 00 EB 04 43 4F 75 C3 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1149_0 {
	meta:
		name = "TCustomActionMenuBar.InitMenuLoop"
		size = 374
		refs = "000c Mouse 0013 TMouse.GetCursorPos 005d SystemParametersInfo 007e GetParentForm 0093 _Dn_TTimer 0098 TTimer.Create 00a6 TCustomActionMenuBar.DoMenuDelay 00ad TTimer.SetOnTimer 00bb TTimer.SetInterval 00c8 TTimer.SetEnabled 00d1 _DV_TMenuStack 00d6 TMenuStack.Create 00e7 TMenuStack.Push 0119 TCustomActionMenuBar.ExpandTimer 012e HideCaret 0134 ActiveMenu 0142 ActionBarDesigner 0164 TWinControl.GetHandle 016c NotifyWinEvent"
	strings:
		$1 = { 53 56 83 C4 F4 8B D8 8D 54 24 04 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 44 24 04 89 83 7C 03 00 00 8B 44 24 08 89 83 80 03 00 00 33 C0 89 83 8C 03 00 00 C6 83 19 03 00 00 00 33 C0 89 83 10 03 00 00 F6 43 1C 10 74 09 C7 04 24 01 00 00 00 EB 19 6A 00 8D 44 24 04 50 6A 00 6A 6A E8 ?? ?? ?? ?? 83 3C 24 00 75 03 FF 04 24 F6 43 1C 10 75 1E 80 BB 69 03 00 00 00 74 15 B2 01 8B C3 E8 ?? ?? ?? ?? 85 C0 74 08 8B 10 FF 92 E8 00 00 00 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 88 03 00 00 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 14 24 8B 83 88 03 00 00 E8 ?? ?? ?? ?? 33 D2 8B 83 88 03 00 00 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 84 03 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 78 03 00 00 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 93 38 03 00 00 8B C6 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C6 83 1A 03 00 00 01 6A 00 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 80 BB 8C 02 00 00 00 74 1C A1 ?? ?? ?? ?? 83 38 00 74 12 A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 8B 08 FF 51 18 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 04 E8 ?? ?? ?? ?? 83 C4 0C 5E 5B C3 }
	condition:
		$1
}

rule function_1150_0 {
	meta:
		name = "TCustomActionMenuBar.MouseActivate"
		size = 55
		refs = "001e TControl.MouseActivate"
	strings:
		$1 = { 55 8B EC 51 53 66 89 4D FE 8B D8 8B 45 10 50 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B C3 E8 ?? ?? ?? ?? 84 C0 75 0B 80 BB 69 03 00 00 00 75 02 B0 03 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1151_0 {
	meta:
		name = "TCustomActionMenuBar.NewPopup"
		size = 153
		refs = "0014 TMenuStack.Peek 0047 TObject.Free 0079 @CallDynaInst 008f TMenuStack.Push"
	strings:
		$1 = { 53 56 57 8B F8 33 DB 8B 87 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 83 B8 6C 03 00 00 00 74 4D 8B 87 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 98 6C 03 00 00 8D 83 9C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C6 83 18 03 00 00 00 C6 83 19 03 00 00 00 68 96 00 00 00 6A 32 33 C9 33 D2 8B C3 8B 30 FF 96 98 00 00 00 85 DB 75 14 8B C7 66 BE AF FF E8 ?? ?? ?? ?? 8B CF B2 01 FF 50 2C 8B D8 8B D3 8B 87 84 03 00 00 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1152_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMouseMsg"
		size = 293
		refs = "000f TCustomActionMenuBar.GetMouseHoverItem 0048 Mouse 004f TMouse.GetIsDragging 0062 WindowFromPoint 0075 TMenuStack.Peek 007a TWinControl.GetHandle 008b GetParentForm 00a7 TControl.ScreenToClient 00b4 TWinControl.ControlAtPos 00c2 _Dn_TCustomActionBar 00c7 @IsClass 00d3 _Dn_TCustomActionControl 00fe _DV_TCustomActionPopupMenu 011b DispatchMessage"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 85 FE 00 00 00 8B 46 04 2D 00 02 00 00 74 22 48 0F 84 C4 00 00 00 83 C0 FE 83 E8 02 0F 82 B8 00 00 00 48 83 E8 02 0F 82 AE 00 00 00 E9 D2 00 00 00 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 0F 84 BE 00 00 00 FF 76 18 FF 76 14 E8 ?? ?? ?? ?? 8B F8 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B F8 0F 84 93 00 00 00 B2 01 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 80 00 00 00 6A 01 6A 00 8D 4C 24 08 8D 56 14 8B C3 E8 ?? ?? ?? ?? 8D 54 24 08 33 C9 8B C7 E8 ?? ?? ?? ?? 8B F8 85 FF 74 5B 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 11 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 39 8B 83 3C 03 00 00 8B 10 FF 92 BC 01 00 00 EB 29 F6 43 1C 10 75 15 8B 83 3C 03 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B 83 3C 03 00 00 8B 10 FF 92 BC 01 00 00 56 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1153_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMenuLoop"
		size = 1100
		refs = "0033 TCustomActionMenuBar.ProcessMenuLoop 0047 PeekMessage 006e _DV_TCustomActionPopupMenu 0073 @IsClass 008b Application 0092 TApplication.IsKeyMsg 00a4 TCustomActionMenuBar.IsDesignMsg 00ae TranslateMessage 00b4 DispatchMessage 0164 KeyboardStateToShiftState 0182 TMenuStack.Peek 0187 TCustomActionMenuBar.GetSelected 01ae Screen 01ea TApplication.HelpCommand 01fd TApplication.HelpContext 020a Mouse 0211 TMouse.GetCursorPos 021c WindowFromPoint 0221 FindControl 0234 TControl.ScreenToClient 0244 TWinControl.ControlAtPos 024e _Dn_TMenuResizeActionControl 027f TCustomActionMenuBar.ProcessMessages 0378 PointsEqual 039a TCustomActionMenuBar.DoItemSelected 03e1 PostQuitMessage 03f7 TCustomActionMenuBar.CleanupStack 0403 TCustomActionMenuBar.Idle 0431 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 89 45 FC 8D 7D CC 33 C0 89 45 F8 8B 45 FC 80 B8 1A 03 00 00 00 0F 85 13 04 00 00 8B 45 FC 8B 10 FF 92 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 6A 01 6A 00 6A 00 6A 00 57 E8 ?? ?? ?? ?? 85 C0 0F 84 AA 03 00 00 8B 45 FC C6 80 90 03 00 00 00 83 7F 04 7B 75 1C 8B 45 FC 8B 80 3C 03 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 85 88 03 00 00 8B 45 FC F6 40 1C 10 74 16 8B D7 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 0F 85 69 03 00 00 8B D7 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 11 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 4A 03 00 00 8B 47 04 8B D0 81 FA 00 01 00 00 7D 44 81 FA A1 00 00 00 7F 22 0F 84 2E 01 00 00 83 EA 10 0F 84 AD 01 00 00 83 EA 02 0F 84 E8 02 00 00 83 EA 3B 74 74 E9 F3 02 00 00 81 EA A4 00 00 00 0F 84 8E 01 00 00 83 EA 03 0F 84 85 01 00 00 E9 D9 02 00 00 81 FA 02 B4 00 00 7F 35 0F 84 77 02 00 00 81 C2 00 FF FF FF 83 EA 0A 0F 82 87 01 00 00 81 C2 0A FF FF FF 83 EA 0F 0F 82 11 02 00 00 81 EA 12 AE 00 00 0F 84 48 01 00 00 E9 9C 02 00 00 81 EA 03 B4 00 00 0F 84 62 02 00 00 4A 0F 84 42 02 00 00 E9 84 02 00 00 E8 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 66 3B D0 0F 85 7B 02 00 00 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 60 02 00 00 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 58 68 85 DB 75 10 A1 ?? ?? ?? ?? 8B 00 8B 40 68 8B 98 68 01 00 00 8B 45 FC 8B 10 FF 92 BC 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 68 F6 80 98 02 00 00 08 74 18 A1 ?? ?? ?? ?? 8B 00 8B CB BA 08 00 00 00 E8 ?? ?? ?? ?? E9 00 02 00 00 A1 ?? ?? ?? ?? 8B 00 8B D3 E8 ?? ?? ?? ?? E9 ED 01 00 00 8D 55 F0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? FF 75 F4 FF 75 F0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 30 8D 4D E8 8D 55 F0 8B C6 E8 ?? ?? ?? ?? 6A 00 6A 00 8D 55 E8 33 C9 8B C6 E8 ?? ?? ?? ?? 8B D8 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 02 33 DB 84 DB 75 0B 8B 45 FC 8B 10 FF 92 BC 01 00 00 8B 45 FC 88 98 90 03 00 00 8B 45 FC 8B 80 3C 03 00 00 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 65 01 00 00 8B 45 FC 8B 10 FF 92 BC 01 00 00 8B 45 FC 8B 80 3C 03 00 00 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 41 01 00 00 8B 45 FC 80 B8 B0 02 00 00 00 75 0D B2 01 8B 45 FC 8B 08 FF 91 54 01 00 00 81 7F 04 04 01 00 00 75 2C 83 7F 08 12 75 26 8B 45 FC 8B 10 FF 92 BC 01 00 00 8B 45 FC C6 80 70 03 00 00 01 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? E9 F3 00 00 00 83 7F 08 70 75 28 E8 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 66 3B D0 0F 85 D8 00 00 00 8B 45 FC 8B 10 FF 92 20 01 00 00 84 C0 0F 85 C5 00 00 00 8D 5F 04 8B 45 FC 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 EC E9 A8 00 00 00 3D 0A 02 00 00 0F 84 B1 00 00 00 3D 00 02 00 00 75 27 8D 55 C4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8D 55 C4 8B 45 FC 05 7C 03 00 00 E8 ?? ?? ?? ?? 84 C0 0F 85 83 00 00 00 8B D7 8B 45 FC 8B 08 FF 91 B8 01 00 00 EB 60 8B 57 0C 8B 45 FC E8 ?? ?? ?? ?? EB 53 8B 57 0C 8B 45 FC 8B 08 FF 91 94 01 00 00 8B 55 FC 89 82 8C 03 00 00 EB 3A 8B 57 0C 8B 45 FC 8B 08 FF 91 90 01 00 00 8B 55 FC 89 82 8C 03 00 00 EB 21 8B 45 FC C6 80 1A 03 00 00 00 8B 47 08 50 E8 ?? ?? ?? ?? EB 0C 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? EB 0A 8B D7 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 1A 03 00 00 00 0F 85 26 FC FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 98 01 00 00 C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 04 00 00 00 }
	condition:
		$1
}

rule function_1154_0 {
	meta:
		name = "SkipItems"
		size = 190
		refs = "0014 TCustomActionMenuBar.GetSelected"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 88 45 FF B3 01 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 89 06 E9 8C 00 00 00 80 7D FF 00 74 16 8B 16 8B 45 08 8B 40 FC B1 01 8B 18 FF 93 0C 01 00 00 89 06 EB 14 8B 16 8B 45 08 8B 40 FC B1 01 8B 18 FF 93 10 01 00 00 89 06 83 3E 00 74 51 8B 06 83 78 44 00 74 49 8B 45 08 8B 40 FC F6 40 1C 10 75 4B 8B 45 08 8B 40 FC 8B 10 FF 92 20 01 00 00 84 C0 74 10 8B 06 8B 40 44 8B 10 FF 52 5C 84 C0 75 2B EB 1B 8B 06 80 78 54 00 75 13 8B 06 8B 40 44 80 78 59 00 74 08 8B 06 80 78 76 02 75 0E 83 3E 00 0F 95 C3 84 DB 0F 85 6C FF FF FF 83 3E 00 0F 95 C0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1155_0 {
	meta:
		name = "CheckChangesAllowed"
		size = 135
		refs = "0015 CheckChangesAllowed 002b TActionClientItem.GetCaption 0043 SMoveNotAllowed 0048 LoadResString 0052 _Dn_Exception 0057 Exception.CreateFmt 005c @RaiseExcept 0076 @UStrArrayClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 33 D2 89 55 F4 89 55 F0 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 F6 43 31 02 75 3B 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 89 45 F8 C6 45 FC 11 8D 45 F8 50 6A 00 8D 55 F0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1156_0 {
	meta:
		name = "EnsureNextItemVisible"
		size = 146
		refs = "0049 TCustomActionDockBar.SetVisibleIndex 0068 TCustomActionDockBar.MakeLastItemVisible 0075 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F8 8B 45 08 8B 40 FC 80 B8 E8 02 00 00 00 74 76 8B 07 8B 40 44 81 78 44 01 00 00 80 75 68 8B 45 08 80 78 FB 00 74 21 8B 45 08 8B 40 FC 8B 98 00 03 00 00 80 7B 59 00 75 3F 8B 45 08 8B 40 FC 33 D2 E8 ?? ?? ?? ?? EB 30 8B 45 08 8B 40 FC 8B 98 04 03 00 00 80 7B 59 00 75 1E 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? EB 11 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 80 7B 59 00 74 0E 8B 07 8B 40 44 81 78 44 01 00 00 80 74 E1 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1157_0 {
	meta:
		name = "TCustomActionMenuBar.Select"
		size = 316
		refs = "0015 SkipItems 0032 TMenuStack.Peek 004f KeyboardStateToShiftState 0056 TCustomActionMenuBar.Select 006d TCustomActionMenuBar.GetSelected 0082 CheckChangesAllowed 0092 TCollectionItem.GetIndex 00af EnsureNextItemVisible 00be TCustomActionMenuBar.SelectItem 00d6 TActionClientItem.GetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F4 88 55 FB 89 45 FC 55 8D 55 F4 0F B6 45 FB E8 ?? ?? ?? ?? 59 84 C0 0F 84 12 01 00 00 8B 45 FC 8B 80 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 3B 45 FC 0F 85 85 00 00 00 8B 45 FC 8B 10 FF 92 20 01 00 00 84 C0 74 5C E8 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 66 3B D0 75 4B 83 7D F4 00 0F 84 CB 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 85 C0 0F 84 BB 00 00 00 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 8B 08 FF 51 14 E9 8A 00 00 00 55 8D 45 F4 E8 ?? ?? ?? ?? 59 8B 45 F4 8B 50 44 8B 45 FC E8 ?? ?? ?? ?? EB 70 8B 45 F4 8B 40 44 8B 40 34 3B 45 FC 75 54 8B 45 F4 E8 ?? ?? ?? ?? 85 C0 74 48 8B 45 FC 8B 80 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? C6 80 1A 03 00 00 00 8B 45 FC 8B 80 3C 03 00 00 33 D2 89 90 10 03 00 00 55 8D 45 F4 E8 ?? ?? ?? ?? 59 8B 45 F4 8B 40 44 B2 01 8B 08 FF 91 F4 00 00 00 EB 0E 8B 45 F4 8B 40 44 8B 10 FF 92 FC 00 00 00 8B E5 5D C3 04 00 00 00 }
	condition:
		$1
}

rule function_1158_0 {
	meta:
		name = "TCustomActionMenuBar.SelectItem"
		size = 21
	strings:
		$1 = { 56 8B F2 85 F6 74 0C B2 01 8B C6 8B 08 FF 91 F4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1159_0 {
	meta:
		name = "TCustomActionMenuBar.SetDesignMode"
		size = 42
		refs = "0023 TCustomActionBar.SetDesignMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 20 01 00 00 3A D8 74 0A 8B C6 8B 10 FF 92 BC 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1160_0 {
	meta:
		name = "TCustomActionMenuBar.SetParentMenu"
		size = 109
	strings:
		$1 = { 56 57 8B F0 3B 96 24 03 00 00 74 5E 8B FA 89 BE 24 03 00 00 85 FF 74 52 89 B7 74 03 00 00 0F B6 97 B0 02 00 00 8B C6 8B 08 FF 91 54 01 00 00 8B 86 24 03 00 00 66 83 B8 A2 02 00 00 00 74 18 8B 90 A0 02 00 00 89 96 A0 02 00 00 8B 90 A4 02 00 00 89 96 A4 02 00 00 8B 86 24 03 00 00 0F B6 80 0D 03 00 00 88 86 0D 03 00 00 5F 5E C3 }
	condition:
		$1
}

rule function_1161_0 {
	meta:
		name = "TCustomActionMenuBar.SetPersistentHotKeys"
		size = 98
		refs = "0017 TCustomActionBar.SetPersistentHotKeys 0031 TOrderedList.Count 004b TList.Get"
	strings:
		$1 = { 53 56 57 51 8B D8 3A 93 B0 02 00 00 0F 95 C0 22 C2 88 04 24 8B C3 E8 ?? ?? ?? ?? 80 3C 24 00 74 3C 83 BB 84 03 00 00 00 74 33 8B 83 84 03 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 21 46 33 FF 8B 83 84 03 00 00 8B 40 04 8B D7 E8 ?? ?? ?? ?? B2 01 8B 08 FF 91 54 01 00 00 47 4E 75 E2 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1162_0 {
	meta:
		name = "TCustomActionMenuBar.SetParent"
		size = 27
		refs = "0006 TWinControl.SetParent 000f GetParentForm"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? B2 01 8B C3 E8 ?? ?? ?? ?? 89 83 20 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1163_0 {
	meta:
		name = "TCustomActionMenuBar.TrackMenu"
		size = 314
		refs = "004d TCustomActionMenuBar.TrackMenu 007e TActionClientItem.GetAction 0084 _Dn_TCustomAction 0089 @IsClass 00d3 TActionClientItem.ResetUsageData 012f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 45 FC 8B 45 FC 80 B8 1A 03 00 00 00 0F 85 1B 01 00 00 8B 45 FC 8B 55 FC 89 90 3C 03 00 00 C6 45 FB 01 8B 45 FC 66 83 B8 5A 03 00 00 00 74 12 8B 5D FC 8B 55 FC 8B 83 5C 03 00 00 FF 93 58 03 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 92 B4 01 00 00 8B 45 FC 83 B8 8C 03 00 00 00 74 3B 8B 45 FC 8B 98 8C 03 00 00 85 DB 74 2A 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 8B 45 FC 8B 80 8C 03 00 00 E8 ?? ?? ?? ?? 80 78 6A 00 74 04 33 C0 EB 02 B0 01 88 45 FB 8B 45 FC 8B 10 FF 92 20 01 00 00 84 C0 75 40 8B 45 FC 83 B8 8C 03 00 00 00 74 34 8B 45 FC 8B 80 8C 03 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 9C 00 00 00 8B 45 FC 8B 80 8C 03 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 08 FF 91 A0 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 66 83 B8 62 03 00 00 00 74 16 8B 5D FC 0F B6 4D FB 8B 55 FC 8B 83 64 03 00 00 FF 93 60 03 00 00 C3 E9 ?? ?? ?? ?? EB D5 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1164_0 {
	meta:
		name = "TCustomActionMenuBar.WndProc"
		size = 179
		refs = "004b IID_IAccessible 0051 LresultFromObject 0060 _Dn_TActionMenuBarAccessibility 0065 TActionBarAccessibility.Create 00ab TWinControl.WndProc"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B 03 83 E8 14 74 77 83 E8 29 74 0E 83 E8 47 0F 84 83 00 00 00 E9 85 00 00 00 83 7B 08 FC 75 7F 83 BE 78 02 00 00 00 74 76 8B BE 78 02 00 00 83 7F 34 00 74 1E 8B 86 78 02 00 00 8B 40 34 50 8B 43 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C EB 55 57 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 03 83 E8 F8 50 8B 43 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 43 0C EB 2A 80 BE 60 02 00 00 00 74 18 8B 43 04 3B 43 08 74 10 C7 43 0C 01 00 00 00 EB 10 C7 43 0C 01 00 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1165_0 {
	meta:
		name = "TCustomActionMenuBar.WMKeyDown"
		size = 832
		refs = "0017 TCustomActionMenuBar.WMKeyDown 0026 TWinControl.WMKeyDown 0060 KeyboardStateToShiftState 0090 TMenuStack.Peek 0097 TCustomActionBar.FindAccelItem 0115 @CallDynaInst 0133 TCustomActionBar.FindFirstVisibleItem 013d TCustomActionMenuBar.SelectItem 0149 TCustomActionBar.FindLastVisibleItem 015f TCustomActionMenuBar.GetSelected 019c DragDone 01a6 Mouse 01ad TMouse.GetIsDragging 01b6 CancelDrag 0202 SDeleteNotAllowed 0207 LoadResString 0211 _Dn_Exception 0216 Exception.Create 021b @RaiseExcept 0222 TActionClient.GetHasItems 0234 TActionClientItem.GetCaption 024a SDeleteItemWithSubItems 025a Format 0273 MessageDlgPosHelp 0281 TCollectionItem.GetIndex 02c1 TActionClient.GetItems 02c9 TCollection.Delete 02f5 TWinControl.GetHandle 02fb PostMessage 0302 NotifyDesigner 031c @UStrArrayClr 032f @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D3 8B C6 E8 ?? ?? ?? ?? 80 BE 1A 03 00 00 00 0F 84 CF 02 00 00 83 BE 3C 03 00 00 00 74 6C 0F B7 43 04 83 C0 D0 66 83 E8 0A 72 12 83 C0 F9 66 83 E8 1A 72 09 83 C0 FB 66 83 E8 0A 73 4D E8 ?? ?? ?? ?? A8 04 75 44 0F B7 43 04 0F B7 F8 8B D0 83 C2 A0 66 83 EA 0A 73 09 0F B7 F8 83 C7 30 83 EF 60 8B 86 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 8B F8 85 FF 74 0B 8B 47 44 8B 10 FF 92 FC 00 00 00 0F B7 43 04 83 C0 F3 83 F8 21 0F 87 4A 02 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 05 00 00 00 00 00 00 00 00 00 00 00 00 00 06 00 00 00 00 00 00 00 04 03 00 01 00 02 00 00 00 00 00 07 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 D2 8B C6 66 BE AE FF E8 ?? ?? ?? ?? E9 E8 01 00 00 B2 01 8B C6 66 BE AE FF E8 ?? ?? ?? ?? E9 D6 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 50 44 8B C6 E8 ?? ?? ?? ?? E9 C0 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 50 44 8B C6 E8 ?? ?? ?? ?? E9 AA 01 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 84 9B 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 FC 00 00 00 E9 84 01 00 00 8B C6 8B 10 FF 92 20 01 00 00 84 C0 74 15 83 BE 14 03 00 00 00 74 0C 33 C0 E8 ?? ?? ?? ?? E9 61 01 00 00 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 84 C0 74 0A E8 ?? ?? ?? ?? E9 47 01 00 00 8B C6 8B 10 FF 92 BC 01 00 00 E9 38 01 00 00 8B C6 8B 10 FF 92 20 01 00 00 84 C0 0F 84 26 01 00 00 8B C6 E8 ?? ?? ?? ?? 85 C0 0F 84 17 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 F6 47 31 04 75 21 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 84 C0 74 54 8D 45 F4 50 8D 55 E8 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 89 45 EC C6 45 F0 11 8D 45 EC 50 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E4 33 C9 5A E8 ?? ?? ?? ?? 8B 45 F4 6A 00 6A FF 6A FF 6A 00 0F B7 0D ?? ?? ?? ?? B2 03 E8 ?? ?? ?? ?? 48 0F 85 88 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 45 FC 8B C6 8B 10 FF 92 30 01 00 00 48 3B 45 FC 75 12 33 C9 8B D7 8B C6 8B 18 FF 93 10 01 00 00 8B F8 EB 10 33 C9 8B D7 8B C6 8B 18 FF 93 0C 01 00 00 8B F8 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B 55 FC E8 ?? ?? ?? ?? 85 FF 74 0F 8B 47 44 B2 01 8B 08 FF 91 F4 00 00 00 EB 1F 8B 86 28 03 00 00 50 6A 00 68 02 B4 00 00 8B 86 3C 03 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5F 5E 5B 8B E5 5D C3 0C 00 00 00 }
	condition:
		$1
}

rule function_1166_0 {
	meta:
		name = "TCustomActionMenuBar.WMMouseActivate"
		size = 34
		refs = "000b TWinControl.WMMouseActivate"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 1A 03 00 00 00 74 07 C7 46 0C 03 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1167_0 {
	meta:
		name = "TCustomActionMenuBar.WMSysKeyDown"
		size = 308
		refs = "000b TWinControl.WMSysKeyDown 0021 TCustomActionMenuBar.WMKeyDown 004a TCustomActionMenuBar.GetSelected 005e TActionClient.GetHasItems 00bd TCustomActionBar.FindNextVisibleItem 00cc TCustomActionBar.FindFirstVisibleItem 00f9 TCustomActionBar.FindPreviousVisibleItem 0108 TCustomActionBar.FindLastVisibleItem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 80 BB 1A 03 00 00 00 0F 84 15 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 0F B7 46 04 66 83 E8 12 0F 84 F0 00 00 00 66 83 E8 13 0F 84 AA 00 00 00 66 83 E8 02 0F 85 EA 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 DB 00 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B C3 E8 ?? ?? ?? ?? 83 78 18 00 75 38 8B C3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 84 C0 75 0E 8B C3 8B 10 FF 92 20 01 00 00 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 FC 00 00 00 E9 86 00 00 00 8B B3 3C 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B 8B 83 3C 03 00 00 E8 ?? ?? ?? ?? 85 C0 74 5D 83 78 44 00 74 57 8B 40 44 8B 10 FF 92 FC 00 00 00 EB 4A 8B B3 3C 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 85 C0 75 0B 8B 83 3C 03 00 00 E8 ?? ?? ?? ?? 85 C0 74 21 83 78 44 00 74 1B 8B 40 44 8B 10 FF 92 FC 00 00 00 EB 0E 8B 83 3C 03 00 00 8B 10 FF 92 BC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1168_0 {
	meta:
		name = "TCustomActionMenuBar.SetAnimateDuration"
		size = 22
	strings:
		$1 = { 85 D2 7F 0B C7 80 50 03 00 00 01 00 00 00 C3 89 90 50 03 00 00 C3 }
	condition:
		$1
}

rule function_1169_0 {
	meta:
		name = "IsScreenFont"
		size = 394
		refs = "000e IsScreenFont 0025 TFont.GetName 0031 Screen 0047 @UStrEqual 00b7 TFont.GetPitch 013e TFont.GetSize 0177 @UStrArrayClr 017d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 08 8B 40 FC 8B 40 64 E8 ?? ?? ?? ?? 8B 45 F8 50 8D 55 F4 A1 ?? ?? ?? ?? 8B 00 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 58 E8 ?? ?? ?? ?? 75 32 8B 45 08 8B 40 FC 8B 40 64 8B 40 10 0F B6 58 1D A1 ?? ?? ?? ?? 8B 00 8B 80 84 00 00 00 8B 40 10 0F B6 40 1D 88 45 FF 0F B6 45 FF 3A C3 0F 94 C0 EB 02 33 C0 84 C0 74 22 8B 45 08 8B 40 FC 8B 40 64 8B 40 18 8B 15 ?? ?? ?? ?? 8B 12 8B 92 84 00 00 00 3B 42 18 0F 94 C0 EB 02 33 C0 84 C0 74 29 8B 45 08 8B 40 FC 8B 40 64 E8 ?? ?? ?? ?? 8B D8 A1 ?? ?? ?? ?? 8B 00 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 3A D8 0F 94 C0 EB 02 33 C0 84 C0 74 22 8B 45 08 8B 40 FC 8B 40 64 8B 40 1C 8B 15 ?? ?? ?? ?? 8B 12 8B 92 84 00 00 00 3B 42 1C 0F 94 C0 EB 02 33 C0 84 C0 74 2A 8B 45 08 8B 40 FC 8B 40 64 8B 40 10 8B 40 14 8B 15 ?? ?? ?? ?? 8B 12 8B 92 84 00 00 00 8B 52 10 8B 52 14 3B D0 0F 94 C0 EB 02 33 C0 84 C0 74 29 8B 45 08 8B 40 FC 8B 40 64 E8 ?? ?? ?? ?? 8B D8 A1 ?? ?? ?? ?? 8B 00 8B 80 84 00 00 00 E8 ?? ?? ?? ?? 3B D8 0F 94 C0 EB 02 33 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1170_0 {
	meta:
		name = "TCustomActionMenuBar.CMFontchanged"
		size = 48
		refs = "000c TWinControl.CMFontChanged 0012 IsScreenFont 0028 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 56 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B 55 FC 88 82 68 03 00 00 8B 45 FC 66 BE EF FF E8 ?? ?? ?? ?? 5E 59 5D C3 }
	condition:
		$1
}

rule function_1171_0 {
	meta:
		name = "TCustomActionMenuBar.Notification"
		size = 86
		refs = "0010 TCustomActionBar.Notification 001d _Dn_TCustomActionControl 0022 @IsClass"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? 80 FB 01 75 39 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 28 8B 87 B4 01 00 00 3B 86 8C 03 00 00 75 0A 33 C0 89 86 8C 03 00 00 EB 10 3B BE 1C 03 00 00 75 08 33 C0 89 86 1C 03 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1172_0 {
	meta:
		name = "TCustomActionMenuBar.DoMouseIdle"
		size = 21
		refs = "0005 GetCursorPos 000e FindDragTarget"
	strings:
		$1 = { 83 C4 F8 54 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 59 5A C3 }
	condition:
		$1
}

rule function_1173_0 {
	meta:
		name = "TCustomActionMenuBar.DoActionIdle"
		size = 110
		refs = "0004 Screen 000b TScreen.GetCustomFormCount 0023 TScreen.GetCustomForms 002c TWinControl.HandleAllocated 0037 TWinControl.GetHandle 003d IsWindowVisible 004e IsWindowEnabled 0062 TControl.Perform"
	strings:
		$1 = { 53 56 57 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 54 46 33 FF A1 ?? ?? ?? ?? 8B 00 8B D7 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 32 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 21 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 10 6A 00 33 C9 BA 45 B0 00 00 8B C3 E8 ?? ?? ?? ?? 47 4E 75 AF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1174_0 {
	meta:
		name = "TCustomActionMenuBar.ActionIdleTimerProc"
		size = 87
		refs = "000c TCustomActionMenuBar.ActionIdleTimerProc 001f TTimer.SetEnabled 0026 TCustomActionMenuBar.DoActionIdle 0035 @HandleAnyException 003b Application 0049 TApplication.HandleException 004e @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 08 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1E E9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1175_0 {
	meta:
		name = "TCustomActionMenuBar.Idle"
		size = 401
		refs = "0015 TCustomActionMenuBar.Idle 0020 Application 0043 TApplication.CancelHint 004b TCustomActionMenuBar.GetSelected 005c TActionClientItem.GetAction 0078 GetLongHint 0087 TApplication.SetHint 00f1 TCustomActionMenuBar.DoActionIdle 010d TTimer.SetInterval 011d TTimer.SetEnabled 012c @HandleAnyException 013b TApplication.HandleException 0140 @DoneExcept 0145 GetCurrentThreadId 014b MainThreadID 0156 CheckSynchronize 0169 WaitMessage 017e @UStrClr 0184 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 80 B8 88 00 00 00 00 74 18 8B 45 FC 83 B8 1C 03 00 00 00 75 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 85 C0 74 3A 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 29 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 7C 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? EB 0C A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? C6 45 FB 01 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 A1 ?? ?? ?? ?? 8B 00 66 83 B8 32 01 00 00 00 74 1A 8B 1D ?? ?? ?? ?? 8B 1B 8D 4D FB 8B 55 FC 8B 83 34 01 00 00 FF 93 30 01 00 00 80 7D FB 00 74 45 A1 ?? ?? ?? ?? 8B 00 8B 90 C0 00 00 00 85 D2 7F 0A 8B 45 FC E8 ?? ?? ?? ?? EB 2A 8B 45 FC 8B 80 08 03 00 00 80 78 48 00 75 1B 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 80 08 03 00 00 B2 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 3B 02 75 0F 33 C0 E8 ?? ?? ?? ?? 84 C0 74 04 C6 45 FB 00 80 7D FB 00 74 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1176_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMessage"
		size = 106
		refs = "0007 Application 0019 PeekMessage 002e TApplication.IsHintMsg 003b TApplication.IsMDIMsg 005a TranslateMessage 0060 DispatchMessage"
	strings:
		$1 = { 53 56 57 8B F2 8B 3D ?? ?? ?? ?? 8B 3F 33 DB 6A 01 6A 00 6A 00 6A 00 56 E8 ?? ?? ?? ?? 85 C0 74 43 B3 01 83 7E 04 12 74 3B 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 2E 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 21 8B 46 04 3D 00 01 00 00 72 0B 3D 09 01 00 00 77 04 33 DB EB 0C 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1177_0 {
	meta:
		name = "TCustomActionMenuBar.ProcessMessages"
		size = 24
		refs = "000b TCustomActionMenuBar.ProcessMessage"
	strings:
		$1 = { 53 83 C4 E4 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 F3 83 C4 1C 5B C3 }
	condition:
		$1
}

rule function_22052_0 {
	meta:
		name = "TApplication.ProcessMessages"
		size = 24
		refs = "000b TApplication.ProcessMessage"
	strings:
		$1 = { 53 83 C4 E4 8B D8 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 F3 83 C4 1C 5B C3 }
	condition:
		$1
}

rule function_1178_0 {
	meta:
		name = "TCustomActionMenuBar.Style"
		size = 34
		refs = "001c TCustomActionBar.Style"
	strings:
		$1 = { 56 8B B0 3C 03 00 00 85 F6 74 10 3B F0 74 0C 8B C6 8B 10 FF 92 6C 01 00 00 5E C3 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1179_0 {
	meta:
		name = "TCustomActionMenuBar.SetUseSystemFont"
		size = 44
		refs = "0016 Screen"
	strings:
		$1 = { 56 8B F0 3A 96 68 03 00 00 74 1F 88 96 68 03 00 00 84 D2 74 15 A1 ?? ?? ?? ?? 8B 00 8B 90 84 00 00 00 8B 46 64 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1180_0 {
	meta:
		name = "TCustomActionMenuBar.Loaded"
		size = 42
		refs = "0006 TCustomActionDockBar.Loaded 0014 Screen"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 68 03 00 00 00 74 15 A1 ?? ?? ?? ?? 8B 00 8B 90 84 00 00 00 8B 43 64 8B 08 FF 51 08 5B C3 }
	condition:
		$1
}

rule function_1181_0 {
	meta:
		name = "TCustomActionMenuBar.RecreateControls"
		size = 31
		refs = "0012 TObject.Free 0019 TCustomActionBar.RecreateControls"
	strings:
		$1 = { 53 8B D8 8D 83 6C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1182_0 {
	meta:
		name = "TCustomActionMenuBar.SetMouseControl"
		size = 49
		refs = "0017 TComponent.RemoveFreeNotification 002a TComponent.FreeNotification"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 1C 03 00 00 3B F0 74 1E 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 8B C6 89 83 1C 03 00 00 85 C0 74 07 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1183_0 {
	meta:
		name = "TCustomMenuExpandBtn.Create"
		size = 132
		refs = "000a @ClassCreate 0017 TCustomUtilityButton.Create 0020 TControl.SetAlign 0033 TCustomUtilityButton.SetArrowSize 003e SExpand 0043 LoadResString 004c TCustomUtilityButton.SetArrowType 0055 TCustomUtilityButton.SetDirection 005e TCustomMenuExpandBtn.Create 006c @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? B2 06 8B C6 E8 ?? ?? ?? ?? C6 86 14 02 00 00 01 BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 03 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 04 00 00 }
	condition:
		$1
}

rule function_1184_0 {
	meta:
		name = "TCustomMenuExpandBtn.DragOver"
		size = 13
	strings:
		$1 = { 55 8B EC 8B 45 08 C6 00 00 5D C2 0C 00 }
	condition:
		$1
}

rule function_1185_0 {
	meta:
		name = "TCustomMenuExpandBtn.DrawBackground"
		size = 115
		refs = "0010 OffsetRect 001a InflateRect 002a TCustomMenuExpandBtn.GetMenu 002f TCustomActionBar.GetColorMap 0034 TCustomActionBarColorMap.GetUnusedColor 0044 TBrush.SetColor 006c TCustomButtonControl.DrawBackground"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 B9 01 00 00 00 33 D2 E8 ?? ?? ?? ?? 6A FC 6A FE 56 E8 ?? ?? ?? ?? 80 BB F3 01 00 00 00 74 23 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? EB 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 44 8B 83 A8 01 00 00 8B 40 48 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1186_0 {
	meta:
		name = "TCustomMenuExpandBtn.DrawFrame"
		size = 65
		refs = "001d OffsetRect 002b InflateRect 0036 TCustomButtonControl.DrawFrame"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F2 8D 3C 24 A5 A5 A5 A5 8B D9 8B F0 8B C4 B9 01 00 00 00 33 D2 E8 ?? ?? ?? ?? 6A FC 6A FE 8D 44 24 08 50 E8 ?? ?? ?? ?? 8B CB 8B D4 8B C6 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1188_0 {
	meta:
		name = "TCustomActionPopupMenu.Create"
		size = 216
		refs = "000b @ClassCreate 001c TCustomActionMenuBar.Create 0025 TCustomActionPopupMenu.Create 0031 TControl.SetVisible 003a TControl.SetAlign 004f TWinControl.SetBorderWidth 005d TToolWindow.SetEdgeBorders 0066 TToolWindow.SetEdgeInner 006f TToolWindow.SetEdgeOuter 0078 TCustomActionBar.SetVertMargin 0081 TCustomActionBar.SetHorzMargin 0092 _Dn_TCustomActionBar 0097 @IsClass 00a8 TCustomActionBar.SetActionManager 00b1 TCustomActionPopupMenu.SetShadow 00bc @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8B 47 50 0B 05 ?? ?? ?? ?? 89 47 50 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? B2 02 8B C7 8B 08 FF 91 50 01 00 00 33 D2 8B C7 E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? 33 D2 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 8B 08 FF 51 6C 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B 96 7C 02 00 00 8B C7 E8 ?? ?? ?? ?? B2 01 8B C7 E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 00 04 00 00 0F 00 00 00 }
	condition:
		$1
}

rule function_1189_0 {
	meta:
		name = "TCustomActionPopupMenu.Destroy"
		size = 80
		refs = "0003 @BeforeDestruction 001f TControl.SetVisible 0032 TObject.Free 003e TCustomActionMenuBar.Destroy 0049 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 78 02 00 00 85 C0 74 05 33 D2 89 50 18 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 86 9C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1190_0 {
	meta:
		name = "TCustomActionPopupMenu.AddEdges"
		size = 340
		refs = "0027 TCustomActionBar.FindPreviousVisibleItem 0036 TCustomActionBar.FindNextVisibleItem 0043 TActionClientItem.Unused 0052 TCustomActionPopupMenu.AddEdges 00ce TCustomMenuItem.SetEdges 00ea _DV_TCustomMenuItem 00ef @IsClass"
	strings:
		$1 = { 53 56 57 55 51 8B DA 8B F0 85 DB 0F 84 31 01 00 00 83 BB B4 01 00 00 00 0F 84 24 01 00 00 8B 93 B4 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B F8 8B 93 B4 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B E8 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 85 00 00 00 0F B6 05 ?? ?? ?? ?? 88 04 24 80 BE 19 03 00 00 00 74 2E 85 FF 74 0B 8B C7 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C6 8B 10 FF 92 64 01 00 00 3B 83 B4 01 00 00 74 0D 0F B6 05 ?? ?? ?? ?? 0A 04 24 88 04 24 80 BE 19 03 00 00 00 74 2E 85 ED 74 0B 8B C5 E8 ?? ?? ?? ?? 84 C0 75 1F 8B C6 8B 10 FF 92 08 01 00 00 3B 83 B4 01 00 00 74 0D 0F B6 05 ?? ?? ?? ?? 0A 04 24 88 04 24 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? EB 6E 85 FF 74 33 8B C7 E8 ?? ?? ?? ?? 84 C0 74 28 8B 5F 44 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 0F B6 93 F0 01 00 00 0A 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 ED 74 33 8B C5 E8 ?? ?? ?? ?? 84 C0 74 28 8B 5D 44 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 14 0F B6 93 F0 01 00 00 0A 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 00 00 00 00 02 00 00 00 08 00 00 00 }
	condition:
		$1
}

rule function_1191_0 {
	meta:
		name = "TCustomActionPopupMenu.CMMouseLeave"
		size = 70
		refs = "0006 TCustomActionBar.CMMouseLeave 001b TCustomActionMenuBar.GetSelected"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 92 20 01 00 00 84 C0 75 2C 8B C6 E8 ?? ?? ?? ?? 85 C0 74 21 8B C6 E8 ?? ?? ?? ?? 83 78 18 00 75 14 8B C6 E8 ?? ?? ?? ?? 8B 40 44 33 D2 8B 08 FF 91 F4 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1192_0 {
	meta:
		name = "TCustomActionPopupMenu.CMVisibleChanged"
		size = 46
		refs = "0027 TWinControl.CMVisibleChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 7B 59 00 74 0C 8B C3 8B 10 FF 92 C8 01 00 00 EB 0A 8B C3 8B 10 FF 92 D0 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1193_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateControl"
		size = 87
		refs = "0007 TCustomActionMenuBar.CreateControl 0011 _DV_TCustomMenuItem 0016 @IsClass 003a TActionClientItem.Unused 004e TControl.SetVisible"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B D6 8B C3 8B 08 FF 91 C4 01 00 00 80 BB 19 03 00 00 00 75 1F 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 10 C6 83 18 03 00 00 01 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1194_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateControls"
		size = 48
		refs = "0006 TCustomActionDockBar.CreateControls 001f TCustomActionBar.FindFirstVisibleItem 002a TCustomActionPopupMenu.SetupExpandBtn"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 80 BB 19 03 00 00 00 75 1B 80 BB 18 03 00 00 00 74 12 8B C3 E8 ?? ?? ?? ?? 85 C0 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1195_0 {
	meta:
		name = "TCustomActionPopupMenu.CreateParams"
		size = 127
		refs = "000b TWinControl.CreateParams 0014 _Dn_TCustomForm 0019 @IsClass 0050 CheckWin32Version 005b GetShadow"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 43 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 1D 8B 46 04 25 FF FF FF BF 0D 00 00 00 80 0D 00 00 00 04 0D 00 00 00 02 83 C8 00 89 46 04 C7 46 24 09 08 00 00 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 12 8B C3 E8 ?? ?? ?? ?? 84 C0 74 07 81 4E 24 00 00 02 00 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 04 83 4E 08 08 5E 5B C3 }
	condition:
		$1
}

rule function_1197_0 {
	meta:
		name = "TCustomActionPopupMenu.ExecAction"
		size = 25
		refs = "0009 TControl.Hide 0012 TCustomActionMenuBar.ExecAction"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4610_0 {
	meta:
		name = "ObjectResourceToText"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 ObjectBinaryToText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_3286_0 {
	meta:
		name = "TCategoryButtons.DoStartDrag"
		size = 25
		refs = "0009 TCategoryButtons.GenerateDragImage 0012 TControl.DoStartDrag"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11125_0 {
	meta:
		name = "TDBImage.WMLButtonDblClk"
		size = 25
		refs = "0009 TDBImage.LoadPicture 0012 TControl.WMLButtonDblClk"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11274_0 {
	meta:
		name = "TDBLookupComboBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupComboBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_11243_0 {
	meta:
		name = "TDBLookupListBox.WMCancelMode"
		size = 25
		refs = "0009 TDBLookupListBox.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_14239_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchSchemas"
		size = 25
		refs = "0009 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 0012 TDBXBaseMetaDataReader.FetchSchemas"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28746_0 {
	meta:
		name = "TFile.ReadAllBytes"
		size = 25
		refs = "0009 TFile.CheckReadAllBytesParameters 0012 TFile.DoReadAllBytes"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25086_0 {
	meta:
		name = "TInplaceEditList.WMCancelMode"
		size = 25
		refs = "0009 TInplaceEditList.StopTracking 0012 TControl.WMCancelMode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_38207_0 {
	meta:
		name = "TPieSeries.WriteData"
		size = 25
		refs = "0009 TPieSeries.RemoveOtherSlice 0012 TChartSeries.WriteData"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_4328_0 {
	meta:
		name = "TStream.ReadComponentRes"
		size = 25
		refs = "0009 TStream.ReadResHeader 0012 TStream.ReadComponent"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_47540_0 {
	meta:
		name = "TToolWindow.CMBorderChanged"
		size = 25
		refs = "0009 TWinControl.RecreateWnd 0012 TWinControl.CMBorderChanged"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1198_0 {
	meta:
		name = "TCustomActionPopupMenu.Expand"
		size = 320
		refs = "0023 TCustomActionPopupMenu.Expand 003d TControl.SetVisible 0052 TCustomActionMenuBar.Expand 005a TCustomActionBar.GetItems 0079 TActionClients.GetActionClient 0097 _DV_TCustomMenuItem 009c @IsClass 00f0 TWinControl.EnableAlign 011e TWinControl.GetHandle 0124 SendMessage 0135 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B 45 FC C6 80 19 03 00 00 01 8B 45 FC 66 FF 80 AC 01 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 9C 03 00 00 85 C0 74 07 33 D2 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 D0 01 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F0 4E 85 F6 7C 74 46 33 DB 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 80 78 30 00 74 58 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 37 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 50 44 8B 45 FC 8B 08 FF 91 C4 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 F8 00 00 00 43 4E 75 8F 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 8B 80 28 03 00 00 85 C0 74 10 8B C8 8B 50 04 8B 45 FC 8B 18 FF 93 D4 01 00 00 6A 00 6A 01 68 85 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 C8 01 00 00 C3 E9 ?? ?? ?? ?? EB B1 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1199_0 {
	meta:
		name = "TCustomActionPopupMenu.ExpandClick"
		size = 57
		refs = "0012 TMenuStack.Pop 0023 TMenuStack.Peek"
	strings:
		$1 = { 53 8B D8 EB 11 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 8B 83 3C 03 00 00 8B 80 84 03 00 00 E8 ?? ?? ?? ?? 3B D8 75 DA B2 01 8B C3 8B 08 FF 91 A4 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1200_0 {
	meta:
		name = "TCustomActionPopupMenu.Popup"
		size = 148
		refs = "0018 Application 0027 TWinControl.SetParentWindow 0034 TCustomActionBar.FindFirstVisibleItem 006d TCustomActionBar.GetColorMap 0082 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 8B 10 FF 92 30 01 00 00 85 C0 74 79 A1 ?? ?? ?? ?? 8B 00 8B 90 70 01 00 00 8B C3 E8 ?? ?? ?? ?? 89 9B 3C 03 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0C 33 D2 8B C3 8B 08 FF 91 A4 01 00 00 8B 43 48 50 8B 43 4C 50 8B CF 8B D6 8B C3 8B 30 FF 96 98 00 00 00 B2 01 8B C3 8B 08 FF 91 54 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 48 01 00 00 B2 01 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 C0 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1201_0 {
	meta:
		name = "MonitorSize"
		size = 9
	strings:
		$1 = { 85 C0 7E 02 03 D0 8B C2 C3 }
	condition:
		$1
}

rule function_1202_0 {
	meta:
		name = "TCustomActionPopupMenu.PositionPopup"
		size = 832
		refs = "002c Screen 0035 TScreen.MonitorFromPoint 004b TMonitor.GetLeft 0054 TMonitor.GetWidth 0096 TMonitor.GetWorkareaRect 0143 TControl.ClientToScreen 0176 TControl.GetBoundsRect 01a2 SystemParametersInfo 020a TScreen.MonitorFromRect 0247 MonitorSize 0271 _DV_TCustomMenuItem 0276 @IsClass 02a8 TMonitor.GetHeight 02b4 TMonitor.GetTop 02e4 _DV_TCustomMenuButton"
	strings:
		$1 = { 53 56 57 55 83 C4 A0 8B F9 8B EA 8B D8 85 ED 74 08 85 FF 0F 85 00 01 00 00 8B 43 40 89 44 24 10 8B 43 44 89 44 24 14 8D 54 24 10 A1 ?? ?? ?? ?? 8B 00 33 C9 E8 ?? ?? ?? ?? 8B F0 8B 7B 40 89 3C 24 8B 43 44 89 44 24 04 8B C6 E8 ?? ?? ?? ?? 8B E8 8B C6 E8 ?? ?? ?? ?? 03 E8 03 7B 48 3B EF 7D 18 8B C6 E8 ?? ?? ?? ?? 8B F8 8B C6 E8 ?? ?? ?? ?? 03 F8 2B 7B 48 89 3C 24 8B C6 E8 ?? ?? ?? ?? 3B 43 40 7E 0A 8B C6 E8 ?? ?? ?? ?? 89 04 24 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 7C 24 3C 8D 54 24 48 8B C6 E8 ?? ?? ?? ?? 03 7C 24 54 8B 43 44 03 43 4C 3B F8 7D 0A 8B 43 44 2B 43 4C 89 44 24 04 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 44 24 3C 3B 43 44 7E 13 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 44 24 3C 89 44 24 04 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 44 24 3C 3B 44 24 04 0F 8E 1D 02 00 00 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 44 24 3C 89 44 24 04 E9 05 02 00 00 0F B6 85 8F 02 00 00 2C 01 72 04 74 23 EB 47 8B 47 40 40 89 44 24 18 8B 47 44 03 47 4C 89 44 24 1C 8B CC 8D 54 24 18 8B C5 E8 ?? ?? ?? ?? EB 45 8B 47 40 2B 43 48 03 47 48 89 44 24 20 8B 47 44 03 47 4C 89 44 24 24 8B CC 8D 54 24 20 8B C5 E8 ?? ?? ?? ?? EB 1F 8D 54 24 38 8B C7 E8 ?? ?? ?? ?? 8D 54 24 38 8B CC 8B 47 34 E8 ?? ?? ?? ?? 8B 47 48 01 04 24 C7 44 24 08 FF FF FF FF 6A 00 8D 44 24 0C 50 6A 00 6A 1B E8 ?? ?? ?? ?? 8D 54 24 38 8B C7 E8 ?? ?? ?? ?? 8D 54 24 38 8D 4C 24 58 8B 47 34 E8 ?? ?? ?? ?? 8B 44 24 58 89 44 24 28 8B 44 24 5C 89 44 24 2C 8D 54 24 38 8B C7 E8 ?? ?? ?? ?? 8D 54 24 40 8D 4C 24 58 8B 47 34 E8 ?? ?? ?? ?? 8B 44 24 58 89 44 24 30 8B 44 24 5C 89 44 24 34 8D 54 24 28 A1 ?? ?? ?? ?? 8B 00 33 C9 E8 ?? ?? ?? ?? 8B F0 8B C6 E8 ?? ?? ?? ?? 3B 04 24 7E 0A 8B C6 E8 ?? ?? ?? ?? 89 04 24 8D 54 24 38 8B C6 E8 ?? ?? ?? ?? 8B 44 24 38 89 44 24 0C 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 44 24 0C E8 ?? ?? ?? ?? 8B 14 24 03 53 48 3B C2 7D 50 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 44 24 0C E8 ?? ?? ?? ?? 2B 43 48 89 04 24 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 27 8B C6 E8 ?? ?? ?? ?? 03 44 24 0C 2B 45 40 03 45 48 8B 14 24 03 53 48 3B C2 7D 0C 8B 45 40 2B 43 48 83 C0 02 89 04 24 8B C6 E8 ?? ?? ?? ?? 3B 43 4C 7D 0D 8B C6 E8 ?? ?? ?? ?? 89 44 24 04 EB 60 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 6C 24 04 8B D5 03 53 4C 3B C2 7D 3E 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 20 8B C6 E8 ?? ?? ?? ?? D1 F8 79 03 83 D0 00 3B 44 24 2C 7D 19 2B 6F 4C 2B 6B 4C 89 6C 24 04 EB 0D 2B 6B 4C 03 6F 4C 83 C5 03 89 6C 24 04 8B 43 48 50 8B 43 4C 50 8B 4C 24 0C 8B 54 24 08 8B C3 8B 18 FF 93 98 00 00 00 83 C4 60 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1203_0 {
	meta:
		name = "TCustomActionPopupMenu.SetupExpandBtn"
		size = 176
		refs = "002f TControl.SetAlign 004b TCustomUtilityButton.SetArrowSize 0056 SExpand 005b LoadResString 0064 TCustomUtilityButton.SetArrowType 006d TCustomUtilityButton.SetDirection 0078 TActionClient.HasBackground 0099 TCustomActionControl.SetTransparent 00a9 TCustomActionPopupMenu.ExpandClick"
	strings:
		$1 = { 53 56 8B D8 83 BB 9C 03 00 00 00 0F 85 9C 00 00 00 8B C3 8B 10 FF 92 CC 01 00 00 8B CB B2 01 FF 50 2C 8B F0 89 B3 9C 03 00 00 B2 06 8B C6 E8 ?? ?? ?? ?? C6 86 14 02 00 00 01 8B D3 8B C6 8B 08 FF 51 78 BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 8D 96 80 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 03 8B C6 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 84 C0 74 10 8B 83 78 02 00 00 0F B6 40 14 04 FD 2C 02 73 04 33 D2 EB 02 B2 01 8B C6 E8 ?? ?? ?? ?? 89 9E 0C 02 00 00 C7 86 08 02 00 00 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1204_0 {
	meta:
		name = "TCustomActionPopupMenu.SetOrientation"
		size = 46
		refs = "000e @CallDynaInst 0026 TCustomActionDockBar.SetOrientation"
	strings:
		$1 = { 53 56 57 8B DA 8B F8 8B C7 66 BE AD FF E8 ?? ?? ?? ?? 8B D3 80 FA 07 77 06 83 E2 7F 0F A3 D0 73 09 8B D3 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1205_0 {
	meta:
		name = "TCustomActionPopupMenu.WMKeyDown"
		size = 688
		refs = "0055 TCustomActionMenuBar.GetSelected 0069 TCollectionItem.GetIndex 0071 TCustomActionBar.GetItems 0077 TCollection.Insert 007e TCustomActionPopupMenu.WMKeyDown 0085 TActionClientItem.SetCaption 008f TControl.SetVisible 0107 TActionClient.GetHasItems 0124 TActionClientItem.GetAction 012d KeyboardStateToShiftState 013d TActionClient.GetItems 0142 TActionClients.Add 020a TCustomActionBar.FindLastVisibleItem 0226 @CallDynaInst 022d TCustomActionBar.FindFirstVisibleItem 0237 TCustomActionMenuBar.SelectItem 028e NotifyDesigner 0297 TCustomActionMenuBar.WMKeyDown"
	strings:
		$1 = { 53 56 57 55 8B F2 8B F8 0F B7 46 04 83 F8 28 7F 1D 0F 84 CF 01 00 00 83 E8 25 0F 84 85 00 00 00 83 E8 02 0F 84 B9 00 00 00 E9 64 02 00 00 83 E8 2D 0F 84 06 02 00 00 83 E8 40 0F 85 52 02 00 00 8B C7 8B 10 FF 92 20 01 00 00 84 C0 0F 84 40 02 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 31 02 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B E8 BA ?? ?? ?? ?? 8B C5 E8 ?? ?? ?? ?? 8B 45 44 B2 01 E8 ?? ?? ?? ?? 8B 45 44 B2 01 8B 08 FF 91 F4 00 00 00 E9 ED 01 00 00 8B 87 74 03 00 00 85 C0 74 19 C6 80 1A 03 00 00 00 33 C0 89 87 74 03 00 00 33 C0 89 46 0C E9 CA 01 00 00 8B 87 24 03 00 00 85 C0 0F 84 BC 01 00 00 8B D6 8B 08 FF 51 EC E9 B0 01 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 DB 00 00 00 8B C7 8B 10 FF 92 20 01 00 00 84 C0 74 59 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 49 8B C7 E8 ?? ?? ?? ?? 80 78 54 00 75 3C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 2C E8 ?? ?? ?? ?? A8 04 74 23 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 90 00 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 45 8B C7 E8 ?? ?? ?? ?? 83 78 18 00 75 38 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 84 C0 75 0E 8B C7 8B 10 FF 92 20 01 00 00 84 C0 74 17 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 FC 00 00 00 E9 E5 00 00 00 83 BF 84 03 00 00 00 0F 85 D8 00 00 00 8B D6 8B 87 3C 03 00 00 8B 08 FF 51 EC E9 C6 00 00 00 8B 87 3C 03 00 00 3B F8 0F 84 B8 00 00 00 8B D6 8B 08 FF 51 EC E9 AC 00 00 00 66 83 7E 04 28 0F 85 A1 00 00 00 80 BF 18 03 00 00 00 0F 84 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D8 8B C7 E8 ?? ?? ?? ?? 3B D8 74 09 E8 ?? ?? ?? ?? A8 04 74 77 8B 87 9C 03 00 00 66 BE EC FF E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 50 44 8B C7 E8 ?? ?? ?? ?? EB 5E F6 47 1C 10 74 58 8B C7 E8 ?? ?? ?? ?? 85 C0 74 4D 8B C7 E8 ?? ?? ?? ?? 8B E8 8B C5 E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? A8 01 74 01 43 8B 87 78 02 00 00 E8 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 8B E8 8B 45 44 B2 01 8B 08 FF 91 F4 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1206_0 {
	meta:
		name = "TCustomActionPopupMenu.WMPrint"
		size = 31
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 F0 8B 56 04 8B C3 8B 08 FF 91 EC 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1207_0 {
	meta:
		name = "TCustomActionPopupMenu.WMPrintClient"
		size = 184
		refs = "0016 TCanvas.GetHandle 0021 TCustomActionPopupMenu.WMPrintClient 0038 TCanvas.SetHandle 0040 TCustomActionBar.GetColorMap 0054 TBrush.SetColor 005f TControl.GetBoundsRect 007a TWinControl.WMPrintClient 0089 TWinControl.PaintTo 00ad @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 8B DA 89 45 FC 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 53 04 8B 45 FC 8B 80 84 02 00 00 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 50 44 8B 45 FC 8B 80 84 02 00 00 8B 40 48 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8D 55 E8 8B 45 FC 8B 80 84 02 00 00 8B 08 FF 51 4C 8B D3 8B 45 FC E8 ?? ?? ?? ?? 6A 00 8B 53 04 33 C9 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 80 84 02 00 00 8B 55 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E7 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1208_0 {
	meta:
		name = "TCustomActionPopupMenu.ValidOrientations"
		size = 12
		refs = "0003 TCustomActionPopupMenu.ValidOrientations"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 0C 00 00 00 }
	condition:
		$1
}

rule function_42022_0 {
	meta:
		name = "GetMinimumBlockAlignment"
		size = 8
		refs = "0003 MinimumBlockAlignment"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18593_0 {
	meta:
		name = "TDesignerDebugScriptSite.BreakOnFirstStatement"
		size = 8
		refs = "0003 SetBreak"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1209_0 {
	meta:
		name = "TCustomActionPopupMenu.VisibleChanging"
		size = 372
		refs = "0008 TCustomActionBar.VisibleChanging 001b TWinControl.HandleAllocated 0026 TWinControl.GetHandle 002c IsWindowVisible 004b NotifyWinEvent 0071 TCustomActionBar.FindFirstVisibleItem 0085 TControl.SetVisible 008c TCustomActionBar.FindLastVisibleItem 00c9 TCustomActionBar.GetItems 00d0 TActionClients.GetActionClient 0100 TWinControl.HandleNeeded 010b @CallDynaInst 0133 TCustomActionMenuBar.Animate 014b sndPlaySound 0152 TCustomActionPopupMenu.VisibleChanging"
	strings:
		$1 = { 53 56 57 8B D8 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 52 80 7B 59 00 74 39 8B C3 E8 ?? ?? ?? ?? 84 C0 74 41 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 30 3B 9B 3C 03 00 00 74 28 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 07 E8 ?? ?? ?? ?? EB 13 6A 00 6A FD 8B C3 E8 ?? ?? ?? ?? 50 6A 06 E8 ?? ?? ?? ?? 80 7B 59 00 0F 85 ED 00 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 80 78 54 00 74 0A 33 D2 8B 40 44 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 10 80 78 54 00 74 0A 33 D2 8B 40 44 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 42 8B C3 8B 10 FF 92 30 01 00 00 8B F8 4F 85 FF 7C 31 47 33 F6 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 83 78 3C 00 74 16 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 3C 8B 10 FF 52 1C 46 4F 75 D2 83 BB 78 02 00 00 00 74 5E 8B C3 E8 ?? ?? ?? ?? 8B C3 66 BE EF FF E8 ?? ?? ?? ?? 8B 8B 28 03 00 00 8B 93 24 03 00 00 8B C3 8B 30 FF 96 D4 01 00 00 83 BB 24 03 00 00 00 74 09 B2 01 8B C3 E8 ?? ?? ?? ?? F6 43 1C 10 75 1E 83 BB 3C 03 00 00 00 74 15 6A 02 6A 00 E8 ?? ?? ?? ?? 6A 13 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 00 4D 00 65 00 6E 00 75 00 50 00 6F 00 70 00 75 00 70 00 00 00 }
	condition:
		$1
}

rule function_1210_0 {
	meta:
		name = "TCustomActionPopupMenu.CloseMenu"
		size = 74
		refs = "000b TControl.SetVisible 001b Mouse 0022 TMouse.GetCursorPos 0042 TCustomActionMenuBar.CloseMenu"
	strings:
		$1 = { 53 83 C4 F8 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 83 BB 3C 03 00 00 00 74 27 8B D4 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B 83 3C 03 00 00 8B 14 24 89 90 7C 03 00 00 8B 54 24 04 89 90 80 03 00 00 8B C3 E8 ?? ?? ?? ?? 59 5A 5B C3 }
	condition:
		$1
}

rule function_1211_0 {
	meta:
		name = "TCustomActionPopupMenu.GetClientRect"
		size = 32
		refs = "000b TWinControl.GetClientRect"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 33 D2 8B C3 8B 08 FF 91 14 01 00 00 01 06 5E 5B C3 }
	condition:
		$1
}

rule function_1213_0 {
	meta:
		name = "TCustomActionPopupMenu.CanAutoSize"
		size = 38
		refs = "000c TWinControl.CanAutoSize"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D8 B2 01 8B C7 8B 08 FF 91 14 01 00 00 01 06 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1214_0 {
	meta:
		name = "TCustomActionPopupMenu.DisplayShadow"
		size = 132
		refs = "000e CheckWin32Version 0019 GetShadow 003f _Dn_TShadowWindow 0044 TShadowWindow.CreateShadow 0071 TShadowWindow.SetControl"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 6C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 61 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 53 83 BB A0 03 00 00 00 75 2C 6A 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 A0 03 00 00 6A 01 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 98 03 00 00 8B 83 A0 03 00 00 85 C0 74 14 8B D3 E8 ?? ?? ?? ?? 8B D3 8B 83 98 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1215_0 {
	meta:
		name = "TCustomActionPopupMenu.HideShadow"
		size = 55
		refs = "000e CheckWin32Version 0026 TControl.Hide"
	strings:
		$1 = { 53 8B D8 BA 01 00 00 00 B8 05 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 1F 83 BB A0 03 00 00 00 74 16 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 8B 83 98 03 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1216_0 {
	meta:
		name = "TCustomActionPopupMenu.SetColorMap"
		size = 40
		refs = "0006 TCustomActionBar.SetColorMap 000d TCustomActionBar.GetColorMap 0022 TControl.SetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 74 11 8B C3 E8 ?? ?? ?? ?? 8B 50 78 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1217_0 {
	meta:
		name = "TCustomActionPopupMenu.Notification"
		size = 61
		refs = "0010 TCustomActionMenuBar.Notification 0023 _Dn_TControl 0028 @IsClass 0035 TControl.SetVisible"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F0 8B CB 8B D7 8B C6 E8 ?? ?? ?? ?? F6 46 1C 08 75 1F 80 FB 01 75 1A 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 09 33 D2 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1218_0 {
	meta:
		name = "TCustomActionPopupMenu.SetShadow"
		size = 20
		refs = "000f TWinControl.RecreateWnd"
	strings:
		$1 = { 3A 90 A4 03 00 00 74 0B 88 90 A4 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1219_0 {
	meta:
		name = "TCustomActionPopupMenu.DrawBackground"
		size = 64
		refs = "0009 TCustomActionBar.DrawBackground 0010 TCustomActionBar.GetColorMap 0021 TBrush.SetColor"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 50 78 8B 83 84 02 00 00 8B 40 48 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 51 54 8B D4 8B 83 84 02 00 00 8B 08 FF 51 4C 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1220_0 {
	meta:
		name = "TCustomActionPopupMenu.NewPopup"
		size = 34
		refs = "0007 TCustomActionMenuBar.NewPopup 0010 GetShadow 0019 TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1221_0 {
	meta:
		name = "TCustomAddRemoveItem.CalcBounds"
		size = 120
		refs = "000b TCustomMenuItem.CalcBounds 0018 TControl.SetWidth 005f OffsetRect"
	strings:
		$1 = { 53 56 57 83 C4 E8 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 53 48 83 C2 12 8B C3 E8 ?? ?? ?? ?? 8B 83 BC 01 00 00 83 C0 12 89 04 24 8B 83 C0 01 00 00 89 44 24 04 8B 04 24 89 83 BC 01 00 00 8B 44 24 04 89 83 C0 01 00 00 8D B3 DC 01 00 00 8D 7C 24 08 A5 A5 A5 A5 8D 44 24 08 33 C9 BA 12 00 00 00 E8 ?? ?? ?? ?? 8D 74 24 08 8D BB DC 01 00 00 A5 A5 A5 A5 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1222_0 {
	meta:
		name = "TCustomAddRemoveItem.IsActionVisible"
		size = 124
		refs = "001e TCustomActionControl.GetActionBar 0029 TActionClient.GetItems 0042 TActionClients.GetActionClient 0047 TActionClientItem.GetAction"
	strings:
		$1 = { 53 56 57 55 51 8B E8 C6 04 24 00 8B 85 F4 01 00 00 8B 80 3C 03 00 00 8B 80 28 03 00 00 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B F8 8B 47 08 8B 70 08 4E 85 F6 7C 38 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 85 B4 01 00 00 E8 ?? ?? ?? ?? 5A 3B D0 75 12 8B D3 8B C7 E8 ?? ?? ?? ?? 0F B6 40 30 88 04 24 EB 04 43 4E 75 CB 0F B6 04 24 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1223_0 {
	meta:
		name = "TCustomAddRemoveItem.MouseUp"
		size = 46
		refs = "001a TCustomMenuItem.MouseUp"
	strings:
		$1 = { 55 8B EC 51 53 66 89 4D FE 8B D8 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_35873_0 {
	meta:
		name = "TRibbonComboControl.MouseDown"
		size = 46
		refs = "001a TCustomButtonControl.MouseDown"
	strings:
		$1 = { 55 8B EC 51 53 66 89 4D FE 8B D8 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1225_0 {
	meta:
		name = "TCustomizeActionToolBar.Create"
		size = 82
		refs = "000b @ClassCreate 001c TCustomActionPopupMenu.Create 0024 _Dn_TCustomActionToolBar 0029 @IsClass 003e @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 89 B7 B4 03 00 00 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1226_0 {
	meta:
		name = "TCustomizeActionToolBar.Destroy"
		size = 48
		refs = "0003 @BeforeDestruction 0012 TObject.Free 001e TCustomActionPopupMenu.Destroy 0029 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B 86 AC 03 00 00 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1227_0 {
	meta:
		name = "TCustomizeActionToolBar.CanAutoSize"
		size = 51
		refs = "000f TCustomActionPopupMenu.CanAutoSize 0022 TOrderedList.Count"
	strings:
		$1 = { 53 56 57 51 89 0C 24 8B F8 8B 0C 24 8B C7 E8 ?? ?? ?? ?? 8B D8 8B B7 84 03 00 00 85 F6 74 0D 8B C6 E8 ?? ?? ?? ?? 85 C0 7E 02 33 DB 8B C3 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1229_0 {
	meta:
		name = "TCustomizeActionToolBar.CMItemSelected"
		size = 9
	strings:
		$1 = { 8B 10 FF 92 BC 01 00 00 C3 }
	condition:
		$1
}

rule function_1230_0 {
	meta:
		name = "TCustomizeActionToolBar.GetActionControl"
		size = 53
		refs = "001f TActionClient.GetItems 0026 TActionClients.GetActionClient"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 F6 7C 26 8B C3 8B 10 FF 92 30 01 00 00 3B F0 7D 18 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8B 40 44 5E 5B C3 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1231_0 {
	meta:
		name = "TCustomizeActionToolBar.ItemCount"
		size = 27
		refs = "000d TActionClient.GetItems"
	strings:
		$1 = { 8B 90 78 02 00 00 85 D2 74 0E 8B C2 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 C3 33 C0 C3 }
	condition:
		$1
}

rule function_1232_0 {
	meta:
		name = "FindItem"
		size = 123
		refs = "0024 TCustomActionControl.GetActionBar 002f TActionClient.GetItems 0048 TActionClients.GetActionClient 004d TActionClientItem.GetAction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 33 C0 89 45 F8 8B 45 08 8B 40 FC 8B 80 3C 03 00 00 8B 80 28 03 00 00 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B F8 8B 47 08 8B 70 08 4E 85 F6 7C 31 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 5A 3B D0 75 0E 8B D3 8B C7 E8 ?? ?? ?? ?? 89 45 F8 EB 04 43 4E 75 D2 8B 45 F8 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1233_0 {
	meta:
		name = "TCustomizeActionToolBar.DoItemClicked"
		size = 319
		refs = "002d @IsClass 0041 FindItem 0066 TControl.SetVisible 0073 TCollectionItem.GetIndex 0088 TCustomActionControl.GetActionBar 0093 TActionClient.GetItems 0099 TCollection.Insert 00a6 TActionClientItem.GetAction 00af TActionClientItem.SetAction 00bf TWinControl.AlignControl 0120 TWinControl.GetHandle 0126 PostMessage 0132 TCustomActionMenuBar.DoItemClicked"
	strings:
		$1 = { 55 8B EC 51 53 56 8B DA 89 45 FC 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 0F 85 CE 00 00 00 8B 45 FC 8B 10 FF 92 DC 01 00 00 8B D0 8B C3 E8 ?? ?? ?? ?? 84 C0 0F 84 B2 00 00 00 55 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 59 8B F0 85 F6 74 20 0F B6 56 30 80 F2 01 8B C6 8B 08 FF 51 2C 80 7E 30 00 75 53 8B 46 44 33 D2 E8 ?? ?? ?? ?? EB 47 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 3C 03 00 00 8B 80 28 03 00 00 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B F0 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 B4 03 00 00 33 D2 E8 ?? ?? ?? ?? 8B 45 FC 8B B0 B4 03 00 00 8B C6 8B 50 48 52 8B 50 4C 52 8B D6 8B 48 44 8B 40 40 92 8B 18 FF 93 98 00 00 00 33 DB EB 4D 8B 45 FC 8B 80 B0 03 00 00 3B 83 B4 01 00 00 75 30 8B 45 FC 8B 10 FF 92 BC 01 00 00 8B 9B B4 01 00 00 6A 00 6A 00 68 09 B4 00 00 8B 45 FC 8B 80 B4 03 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 0C 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B D8 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1234_0 {
	meta:
		name = "TCustomizeActionToolBar.GetSubMenuControlClass"
		size = 94
		refs = "000d _Dn_TActionClientItem 0012 @IsClass 001d TActionClientItem.GetParentItem 0043 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3E 8B C6 E8 ?? ?? ?? ?? 3B 83 A8 03 00 00 75 11 8B C3 8B 10 FF 92 DC 01 00 00 8B 55 08 89 02 EB 1E 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 91 2C 01 00 00 8B 55 08 89 02 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1235_0 {
	meta:
		name = "TCustomizeActionToolBar.NewPopup"
		size = 54
		refs = "0007 TCustomActionPopupMenu.NewPopup 0024 GetShadow 002d TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 89 9E A4 02 00 00 8B 03 8B 80 E0 01 00 00 89 86 A0 02 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1236_0 {
	meta:
		name = "AddSeparator"
		size = 48
		refs = "0002 TActionClients.Add 0009 AddSeparator 0010 TActionClientItem.SetCaption 001a TActionClientItem.SetUsageCount"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 CA FF 8B C3 E8 ?? ?? ?? ?? 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1237_0 {
	meta:
		name = "AddItems"
		size = 172
		refs = "003e TActionClients.GetActionClient 0043 TActionClientItem.GetAction 0070 TActionClients.Add 008f TActionClient.SetItems 0099 TActionClientItem.SetUsageCount"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 89 4D F8 89 55 FC 8B F8 8B 45 F8 85 C0 0F 8C 89 00 00 00 40 89 45 EC C7 45 F4 00 00 00 00 C6 45 F3 00 8B 47 08 8B 58 08 4B 85 DB 7C 31 43 33 F6 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 3B D0 75 06 C6 45 F3 01 EB 04 46 4B 75 D2 80 7D F3 00 75 30 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B D0 8B C3 8B 08 FF 51 08 33 D2 8B C3 E8 ?? ?? ?? ?? 83 CA FF 8B C3 E8 ?? ?? ?? ?? FF 45 F4 FF 4D EC 75 82 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1238_0 {
	meta:
		name = "TCustomizeActionToolBar.DoAddCustomizeItems"
		size = 506
		refs = "0019 TCustomizeActionToolBar.DoAddCustomizeItems 0058 TCollectionItem.GetIndex 006b TCollection.FindItemID 007c TActionClient.GetItems 0092 AddSeparator 009e TActionClients.Add 00ac SAddRemoveButtons 00b1 LoadResString 00bf TActionClientItem.SetCaption 00f2 AddItems 0103 TCustomActionControl.GetActionBar 015d _Dn_TCustomAction 0162 TCustomAction.Create 0172 SResetActionToolBar 0181 TCustomAction.SetCaption 01c3 TActionClientItem.SetAction 01cd TActionClientItem.SetUsageCount 01e7 @UStrArrayClr 01ed @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 C9 89 4D E4 89 4D E8 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 FF 0F 84 A6 01 00 00 83 BB B4 03 00 00 00 0F 84 99 01 00 00 33 F6 8B 83 B4 03 00 00 8B 90 7C 02 00 00 83 BA 90 00 00 00 00 74 22 8B F0 8B 86 78 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 86 7C 02 00 00 8B 80 90 00 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 58 01 00 00 8B C7 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 0C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 A8 03 00 00 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 89 45 F4 8B C6 E8 ?? ?? ?? ?? 89 45 F8 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B C8 49 8B 55 F8 8B 45 F4 E8 ?? ?? ?? ?? 8B 83 3C 03 00 00 8B 80 28 03 00 00 E8 ?? ?? ?? ?? 8B 80 78 02 00 00 89 45 FC 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 89 45 EC 8B 45 FC E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B C8 83 E9 02 8B 55 F0 8B 45 EC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 79 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 AC 03 00 00 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 8B C6 E8 ?? ?? ?? ?? 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 0C 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 B0 03 00 00 8B 93 AC 03 00 00 8B C6 E8 ?? ?? ?? ?? 83 CA FF 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1239_0 {
	meta:
		name = "TCustomizeActionToolBar.SetActionClient"
		size = 45
		refs = "0017 TCustomActionBar.SetActionClient 0022 TActionClient.GetItems"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 91 D8 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 83 78 02 00 00 E8 ?? ?? ?? ?? C6 40 24 00 5E 5B C3 }
	condition:
		$1
}

rule function_1240_0 {
	meta:
		name = "TCustomizeActionToolBar.GetAddRemoveItemClass"
		size = 59
		refs = "0025 ActionBarStyles 002e TActionBarStyleList.GetStyle"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 92 6C 01 00 00 85 C0 74 13 8B C3 8B 10 FF 92 6C 01 00 00 8B D3 8B 08 FF 51 10 5B C3 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 10 5B C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "TCustomizeActionLink.SetEnabled"
		size = 20
	strings:
		$1 = { 8B 50 18 8B 52 44 85 D2 74 09 8B C2 B2 01 8B 08 FF 51 74 C3 }
	condition:
		$1
}

rule function_1243_0 {
	meta:
		name = "TCustomMDIMenuButton.Paint"
		size = 101
		refs = "0011 MouseStyles 0020 ButtonStyles 0035 PushStyles 0056 TCanvas.GetHandle 005c DrawFrameControl"
	strings:
		$1 = { 53 83 C4 F0 8B D8 0F B6 83 C9 01 00 00 0F B7 04 45 ?? ?? ?? ?? 0F B6 93 D0 01 00 00 66 0B 04 55 ?? ?? ?? ?? 80 BB CA 01 00 00 02 0F 94 C2 83 E2 7F 66 0B 04 55 ?? ?? ?? ?? 0F B7 C0 50 6A 01 8D 54 24 08 8B C3 8B 08 FF 51 54 8D 44 24 08 50 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1244_0 {
	meta:
		name = "TCustomActionMainMenuBar.Create"
		size = 244
		refs = "0010 @ClassCreate 001d TCustomActionMenuBar.Create 0026 TCustomActionMainMenuBar.Create 0037 TToolWindow.SetEdgeBorders 0040 TToolWindow.SetEdgeInner 0049 TToolWindow.SetEdgeOuter 005b SystemParametersInfo 0064 TControl.SetAlign 0088 TCustomActionBar.SetHorzMargin 0094 TControl.SetHeight 009d TWinControl.SetTabStop 00ae TCustomActionMainMenuBar.MainWndHook 00be Application 00cc SendMessage 00d7 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 46 50 0B 05 ?? ?? ?? ?? 89 46 50 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? B2 02 8B C6 E8 ?? ?? ?? ?? 6A 00 8D 45 FC 50 6A 00 68 0A 10 00 00 E8 ?? ?? ?? ?? B2 01 8B C6 E8 ?? ?? ?? ?? 83 7D FC 01 1B D2 42 8B C6 8B 08 FF 91 54 01 00 00 C6 86 80 02 00 00 00 BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? BA 1D 00 00 00 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 9E 03 00 00 01 89 75 F4 C7 45 F0 ?? ?? ?? ?? 8D 45 F0 50 6A 00 68 20 B0 00 00 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 00 00 00 00 01 00 }
	condition:
		$1
}

rule function_1245_0 {
	meta:
		name = "TCustomActionMainMenuBar.Destroy"
		size = 82
		refs = "0006 @BeforeDestruction 0015 TCustomActionMainMenuBar.MainWndHook 0024 Application 0032 SendMessage 003e TCustomActionMenuBar.Destroy 0049 @ClassDestroy"
	strings:
		$1 = { 53 56 83 C4 F8 E8 ?? ?? ?? ?? 8B DA 8B F0 89 74 24 04 C7 04 24 ?? ?? ?? ?? 8B C4 50 6A 01 68 20 B0 00 00 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1246_0 {
	meta:
		name = "TCustomActionMainMenuBar.Clear"
		size = 90
		refs = "000c TCustomActionMainMenuBar.Clear 0020 @UStrLAsg 0027 TCustomActionBar.Clear 0035 @UStrAsg 004a @UStrClr 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 93 A0 03 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8D 83 A0 03 00 00 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1247_0 {
	meta:
		name = "TCustomActionMainMenuBar.CloseMenu"
		size = 19
		refs = "0006 TCustomActionMenuBar.ClearSubMenus 000d TCustomActionMenuBar.CloseMenu"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37963_0 {
	meta:
		name = "TAreaSeries.GalleryChanged3D"
		size = 19
		refs = "0006 TCustomChartSeries.GalleryChanged3D 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37981_0 {
	meta:
		name = "TAreaSeries.PrepareForGallery"
		size = 19
		refs = "0006 TChartSeries.PrepareForGallery 000d TAreaSeries.SetGalleryFormat"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_45399_0 {
	meta:
		name = "TChartGalleryPanel.Resize"
		size = 19
		refs = "0006 TControl.Resize 000d TChartGalleryPanel.ResizeCharts"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3896_0 {
	meta:
		name = "TCheckListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_3893_0 {
	meta:
		name = "TCheckListBox.CreateWnd"
		size = 19
		refs = "0006 TCustomListBox.CreateWnd 000d TCheckListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47973_0 {
	meta:
		name = "TComplexData.DoArcCot"
		size = 19
		refs = "0006 TComplexData.DoInverse 000d TComplexData.DoArcTan"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47981_0 {
	meta:
		name = "TComplexData.DoSecH"
		size = 19
		refs = "0006 TComplexData.DoCosH 000d TComplexData.DoInverse"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6352_0 {
	meta:
		name = "TCoolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6305_0 {
	meta:
		name = "TCoolBar.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCoolBar.UpdateBands"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_41218_0 {
	meta:
		name = "TCustomCheckBox.Click"
		size = 19
		refs = "0006 TControl.Changed 000d TControl.Click"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11618_0 {
	meta:
		name = "TCustomDBGrid.TopLeftChanged"
		size = 19
		refs = "0006 TCustomDBGrid.InvalidateTitles 000d TCustomGrid.TopLeftChanged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11607_0 {
	meta:
		name = "TCustomDBGrid.WMIMEStartComp"
		size = 19
		refs = "0006 TWinControl.WMIMEStartComp 000d TCustomGrid.ShowEditor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10119_0 {
	meta:
		name = "TCustomDataSetAdapter.AddDefaultFields"
		size = 19
		refs = "0006 AddDefaultDataSetFields 000d TCustomDataSetAdapter.CreateDataLink"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24955_0 {
	meta:
		name = "TCustomGrid.CMCtl3DChanged"
		size = 19
		refs = "0006 TWinControl.CMCtl3DChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24960_0 {
	meta:
		name = "TCustomGrid.ColWidthsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24961_0 {
	meta:
		name = "TCustomGrid.RowHeightsChanged"
		size = 19
		refs = "0006 TCustomGrid.UpdateScrollRange 000d TCustomGrid.UpdateEdit"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24951_0 {
	meta:
		name = "TCustomGrid.WMCancelMode"
		size = 19
		refs = "0006 TControl.WMCancelMode 000d TCustomGrid.CancelMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21303_0 {
	meta:
		name = "TCustomLinkLabel.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21302_0 {
	meta:
		name = "TCustomLinkLabel.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TCustomLinkLabel.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_41300_0 {
	meta:
		name = "TCustomListBox.WMSize"
		size = 19
		refs = "0006 TWinControl.WMSize 000d TCustomListBox.SetColumnWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21020_0 {
	meta:
		name = "TCustomRadioGroup.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21010_0 {
	meta:
		name = "TCustomRadioGroup.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21021_0 {
	meta:
		name = "TCustomRadioGroup.WMSize"
		size = 19
		refs = "0006 TCustomGroupBox.WMSize 000d TCustomRadioGroup.ArrangeButtons"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35406_0 {
	meta:
		name = "TCustomRibbonQuickAccessToolbar.CreateControls"
		size = 19
		refs = "0006 TCustomActionToolBar.CreateControls 000d TCustomRibbonQuickAccessToolbar.DoUpdateQATWidth"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37669_0 {
	meta:
		name = "TCustomScreenTipsManager.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TCustomScreenTipsManager.ValidateAllocatedActions"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_38815_0 {
	meta:
		name = "TCustomShellComboBox.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellComboBox.ClearItems 000d TCustomComboBoxEx.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_38837_0 {
	meta:
		name = "TCustomShellComboBox.Loaded"
		size = 19
		refs = "0006 TCustomCombo.Loaded 000d TCustomShellComboBox.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_38846_0 {
	meta:
		name = "TCustomShellListView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellListView.ClearItems 000d TCustomListView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_38775_0 {
	meta:
		name = "TCustomShellTreeView.DestroyWnd"
		size = 19
		refs = "0006 TCustomShellTreeView.ClearItems 000d TCustomTreeView.DestroyWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_38806_0 {
	meta:
		name = "TCustomShellTreeView.Loaded"
		size = 19
		refs = "0006 TCustomTreeView.Loaded 000d TCustomShellTreeView.CreateRoot"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_41337_0 {
	meta:
		name = "TCustomStaticText.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_41339_0 {
	meta:
		name = "TCustomStaticText.Loaded"
		size = 19
		refs = "0006 TControl.Loaded 000d TCustomStaticText.AdjustBounds"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5241_0 {
	meta:
		name = "TCustomStatusBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5244_0 {
	meta:
		name = "TCustomStatusBar.CMSysColorChange"
		size = 19
		refs = "0006 TWinControl.CMSysColorChange 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5245_0 {
	meta:
		name = "TCustomStatusBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TCustomStatusBar.SyncToSystemFont"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8174_0 {
	meta:
		name = "TCustomTransparentControl.Invalidate"
		size = 19
		refs = "0006 TCustomTransparentControl.InvalidateControlsUnderneath 000d TWinControl.Invalidate"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5543_0 {
	meta:
		name = "TCustomTreeView.DoEnter"
		size = 19
		refs = "0006 TCustomTreeView.InvalidateSelectionsRects 000d TWinControl.DoEnter"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5544_0 {
	meta:
		name = "TCustomTreeView.DoExit"
		size = 19
		refs = "0006 TWinControl.DoExit 000d TCustomTreeView.InvalidateSelectionsRects"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11339_0 {
	meta:
		name = "TDBChartEditor.CBSourcesChange"
		size = 19
		refs = "0006 TBaseSourceEditor.CBSourcesChange 000d TDBChartEditor.SetFields"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10981_0 {
	meta:
		name = "TDBComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TDBComboBox.SetEditReadOnly"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11700_0 {
	meta:
		name = "TDBLookupCombo.CMFontChanged"
		size = 19
		refs = "0006 TCustomEdit.CMFontChanged 000d TDBLookupCombo.GetMinHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11220_0 {
	meta:
		name = "TDBLookupListBox.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TDBLookupListBox.UpdateScrollBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14238_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchDataTypes"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchDataTypes"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14252_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchReservedWords"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchReservedWords"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14251_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchRoles"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchRoles"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_14250_0 {
	meta:
		name = "TDBXDataStoreCustomMetaDataReader.FetchUsers"
		size = 19
		refs = "0006 TDBXDataStoreCustomMetaDataReader.FailIfVersion7 000d TDBXBaseMetaDataReader.FetchUsers"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21385_0 {
	meta:
		name = "TDirectoryListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TDirectoryListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21380_0 {
	meta:
		name = "TDirectoryListBox.DblClick"
		size = 19
		refs = "0006 TControl.DblClick 000d TDirectoryListBox.OpenCurrent"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21413_0 {
	meta:
		name = "TFileListBox.CMFontChanged"
		size = 19
		refs = "0006 TWinControl.CMFontChanged 000d TFileListBox.ResetItemHeight"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_21421_0 {
	meta:
		name = "TFilterComboBox.CreateWnd"
		size = 19
		refs = "0006 TCustomComboBox.CreateWnd 000d TFilterComboBox.BuildList"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_24165_0 {
	meta:
		name = "TGIFRenderer.HaltAnimation"
		size = 19
		refs = "0006 TCustomGIFRenderer.HaltAnimation 000d TGIFRenderer.StopAnimationTimer"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26363_0 {
	meta:
		name = "TIBDatabase.DBParamsChanging"
		size = 19
		refs = "0006 TIBDatabase.EnsureInactive 000d TIBDatabase.CheckInactive"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_27085_0 {
	meta:
		name = "TIBQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_27326_0 {
	meta:
		name = "TIBSecurityService.Loaded"
		size = 19
		refs = "0006 TIBCustomService.Loaded 000d TIBSecurityService.ClearParams"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_27640_0 {
	meta:
		name = "TIBStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TIBStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26448_0 {
	meta:
		name = "TIBTransaction.TRParamsChanging"
		size = 19
		refs = "0006 TIBTransaction.EnsureNotInTransaction 000d TIBTransaction.CheckNotInTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_31000_0 {
	meta:
		name = "TMediaPlayer.Updated"
		size = 19
		refs = "0006 TComponent.Updated 000d TMediaPlayer.Adjust"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_42218_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 19
		refs = "0006 TObject.CleanupInstance 000d @FreeMem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5157_0 {
	meta:
		name = "TPageControl.Loaded"
		size = 19
		refs = "0006 TCustomTabControl.Loaded 000d TPageControl.UpdateTabHighlights"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37950_0 {
	meta:
		name = "TPointSeries.Assign"
		size = 19
		refs = "0006 TCustomSeries.Assign 000d TPointSeries.SetFixed"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_34658_0 {
	meta:
		name = "TPrinter.Refresh"
		size = 19
		refs = "0006 TPrinter.FreeFonts 000d TPrinter.FreePrinters"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12373_0 {
	meta:
		name = "TQuery.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TQuery.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36026_0 {
	meta:
		name = "TRibbonApplicationPopupMenu.CreateWnd"
		size = 19
		refs = "0006 TWinControl.CreateWnd 000d TRibbonApplicationPopupMenu.CreateWindowRegion"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_35964_0 {
	meta:
		name = "TRibbonSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TRibbonSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37745_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseLeave"
		size = 19
		refs = "0006 TControl.CMMouseLeave 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_37744_0 {
	meta:
		name = "TScreenTipsWindow.CMMouseenter"
		size = 19
		refs = "0006 TControl.CMMouseEnter 000d TScreenTipsWindow.HideHint"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_40172_0 {
	meta:
		name = "TSpinEdit.CreateWnd"
		size = 19
		refs = "0006 TCustomEdit.CreateWnd 000d TSpinEdit.SetEditRect"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12340_0 {
	meta:
		name = "TStoredProc.Disconnect"
		size = 19
		refs = "0006 TDataSet.Close 000d TStoredProc.UnPrepare"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_46292_0 {
	meta:
		name = "TTeeSeriesSource.Loaded"
		size = 19
		refs = "0006 TComponent.Loaded 000d TTeeSeriesSource.Refresh"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6198_0 {
	meta:
		name = "TToolBar.CMColorChanged"
		size = 19
		refs = "0006 TWinControl.CMColorChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_6201_0 {
	meta:
		name = "TToolBar.CMSysFontChanged"
		size = 19
		refs = "0006 TWinControl.CMSysFontChanged 000d TWinControl.RecreateWnd"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_47907_0 {
	meta:
		name = "TValueListStrings.Clear"
		size = 19
		refs = "0006 TStringList.Clear 000d TValueListStrings.FreeItemProps"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_54753_0 {
	meta:
		name = "TXMLTypedSchemaItem.SetRefItem"
		size = 19
		refs = "0006 TXMLSchemaItem.SetRefItem 000d TXMLTypedSchemaItem.RemoveTypeInfo"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1248_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMKeyDown"
		size = 355
		refs = "004e @CallDynaInst 006f TCustomActionMenuBar.GetSelected 0091 TActionClient.GetHasItems 009a KeyboardStateToShiftState 00ae TActionClient.GetItems 00b3 TActionClients.Add 00ba NotifyDesigner 015a TCustomActionMenuBar.WMKeyDown"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 0F B6 87 8F 02 00 00 8B D0 80 EA 02 72 0E 80 EA 02 0F 82 EA 00 00 00 E9 31 01 00 00 0F B7 55 04 66 83 EA 25 74 29 66 FF CA 74 39 66 FF CA 74 0A 66 FF CA 74 2F E9 13 01 00 00 84 C0 0F 94 C2 8B C7 66 BE AE FF E8 ?? ?? ?? ?? E9 FE 00 00 00 84 C0 0F 95 C2 8B C7 66 BE AE FF E8 ?? ?? ?? ?? E9 E9 00 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 84 DA 00 00 00 8B C7 8B 10 FF 92 20 01 00 00 84 C0 74 35 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 25 E8 ?? ?? ?? ?? A8 04 0F 84 B8 00 00 00 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 83 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 48 44 8B D7 8B C7 8B 18 FF 93 8C 01 00 00 8B F0 8B C6 8B 10 FF 92 64 01 00 00 8B 40 44 B2 01 8B 08 FF 91 F4 00 00 00 66 C7 45 04 00 00 EB 55 0F B7 45 04 66 83 E8 25 74 35 66 83 E8 02 75 3C 8B C7 E8 ?? ?? ?? ?? 85 C0 74 31 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 21 8B C7 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 FC 00 00 00 EB 0D B2 01 8B C7 66 BE AE FF E8 ?? ?? ?? ?? 8B D5 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1250_0 {
	meta:
		name = "TCustomActionMainMenuBar.CreateControl"
		size = 55
		refs = "000c TCustomActionMenuBar.CreateControl 0023 @AsClass 002d TCustomActionControl.SetSpacing"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 8B D6 8B C3 8B 08 FF 91 2C 01 00 00 8B D0 8B C7 E8 ?? ?? ?? ?? BA 02 00 00 00 E8 ?? ?? ?? ?? 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1251_0 {
	meta:
		name = "TCustomActionMainMenuBar.DesignWndProc"
		size = 96
		refs = "000b TCustomActionBar.DesignWndProc 004e ActionBarDesigner"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 84 C0 75 4A 81 3B 00 01 00 00 75 42 8B 53 04 83 EA 1B 74 08 83 C2 F6 83 EA 04 73 32 83 7B 04 1B 75 2A 80 BE 1A 03 00 00 00 74 21 8B C6 8B 10 FF 92 BC 01 00 00 80 BE 8C 02 00 00 00 74 0E A1 ?? ?? ?? ?? 8B 00 8B D6 8B 08 FF 51 20 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_1252_0 {
	meta:
		name = "TCustomActionMainMenuBar.DoneMenuLoop"
		size = 51
		refs = "0007 TCustomActionMenuBar.DoneMenuLoop 001a SystemParametersInfo"
	strings:
		$1 = { 53 51 8B D8 8B C3 E8 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 00 68 0A 10 00 00 E8 ?? ?? ?? ?? 83 3C 24 00 75 0C 33 D2 8B C3 8B 08 FF 91 54 01 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1253_0 {
	meta:
		name = "TCustomActionMainMenuBar.GetActiveMDIChild"
		size = 197
		refs = "003a TCustomActionMainMenuBar.GetActiveMDIChild 0054 TCustomForm.get_MDIChildCount 0067 TCustomForm.get_MDIChildren 0087 TCustomActionMainMenuBar.MDIChildMaximized 009b TCustomActionMainMenuBar.MDIChildRestored 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC 8B 45 FC 80 B8 9C 03 00 00 00 0F 85 A2 00 00 00 8B 45 FC 83 B8 20 03 00 00 00 0F 84 92 00 00 00 8B 45 FC C6 80 9C 03 00 00 01 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B B8 20 03 00 00 C6 45 FB 00 8B C7 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 32 46 33 DB 8B D3 8B C7 E8 ?? ?? ?? ?? 80 B8 9A 02 00 00 02 75 19 C6 45 FB 01 8B D3 8B C7 E8 ?? ?? ?? ?? 8B D0 8B 45 FC E8 ?? ?? ?? ?? EB 04 43 4E 75 D1 80 7D FB 00 75 08 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC C6 80 9C 03 00 00 00 C3 E9 ?? ?? ?? ?? EB EE 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1254_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMNCHitTest"
		size = 39
		refs = "000b TWinControl.WMNCHitTest"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 20 01 00 00 84 C0 74 07 C7 46 0C 01 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1255_0 {
	meta:
		name = "TCustomActionMainMenuBar.ProcessMouseMsg"
		size = 95
		refs = "000b TCustomActionMenuBar.ProcessMouseMsg 0023 TCustomActionMenuBar.GetMouseHoverItem 003e @CallDynaInst"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 8B 46 04 2D 01 02 00 00 74 05 83 E8 03 75 3E 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 74 19 3B 58 04 75 2C 80 B8 D4 01 00 00 00 74 23 66 BE EC FF E8 ?? ?? ?? ?? EB 18 8B C3 8B 10 FF 92 20 01 00 00 84 C0 75 0A 8B C3 8B 10 FF 92 BC 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1256_0 {
	meta:
		name = "TCustomActionMainMenuBar.CMWininichange"
		size = 40
		refs = "0006 TCustomActionBar.CMWinINIChange 0012 Screen"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 68 A1 ?? ?? ?? ?? 8B 00 8B 90 84 00 00 00 8B 46 64 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1257_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetDesignMode"
		size = 39
		refs = "0017 TCustomActionMenuBar.ClearSubMenus 0020 TCustomActionMenuBar.SetDesignMode"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 8B 10 FF 92 20 01 00 00 3A D8 74 07 8B C6 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1258_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetInActive"
		size = 29
	strings:
		$1 = { 56 8B F0 3A 96 9D 03 00 00 74 10 88 96 9D 03 00 00 8B C6 8B 10 FF 92 90 00 00 00 5E C3 }
	condition:
		$1
}

rule function_1259_0 {
	meta:
		name = "TCustomActionMainMenuBar.CMEnabledchanged"
		size = 31
		refs = "0006 TCustomActionBar.CMEnabledchanged 0019 TCustomActionMainMenuBar.SetInActive"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 5C 8B D0 80 F2 01 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1260_0 {
	meta:
		name = "TCustomActionMainMenuBar.NewPopup"
		size = 32
		refs = "0007 TCustomActionMenuBar.NewPopup 0017 TCustomActionPopupMenu.SetShadow"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 0F B6 93 9E 03 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1261_0 {
	meta:
		name = "TCustomActionMainMenuBar.Notification"
		size = 156
		refs = "0012 TCustomActionMainMenuBar.Notification 0023 TCustomActionMenuBar.Notification 0030 _Dn_TCustomButtonControl 0035 @IsClass 0050 TActionClientItem.GetCaption 005e @UStrEqual 006d @UStrAsg 008a @UStrClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B D6 8B C7 E8 ?? ?? ?? ?? 80 FB 01 75 4D 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 3C 83 BE B4 01 00 00 00 74 33 8D 55 FC 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 97 A0 03 00 00 E8 ?? ?? ?? ?? 75 15 8D 87 A0 03 00 00 33 D2 E8 ?? ?? ?? ?? 33 C0 89 87 B4 03 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1262_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetupWindowMenu"
		size = 43
		refs = "0015 TCustomActionBar.FindItemCaption"
	strings:
		$1 = { 53 8B D8 83 BB 78 02 00 00 00 74 1D 8B 93 A0 03 00 00 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0C 8B 80 B4 01 00 00 89 83 B4 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1263_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetWindowMenu"
		size = 50
		refs = "000f @UStrEqual 001e @UStrAsg 002b TCustomActionMainMenuBar.SetupWindowMenu"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 83 A0 03 00 00 8B D6 E8 ?? ?? ?? ?? 74 1A 8D 83 A0 03 00 00 8B D6 E8 ?? ?? ?? ?? F6 43 1C 01 75 07 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1264_0 {
	meta:
		name = "FindChildAction"
		size = 116
		refs = "001b TCustomActionList.GetActionCount 0038 TCustomActionList.GetAction 0059 _DV_TInternalMDIAction 005e @AsClass"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F8 33 C0 89 45 FC 8B 45 08 8B 40 FC 8B 80 98 03 00 00 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 45 46 33 DB 8B 45 08 8B 40 FC 8B 80 98 03 00 00 8B D3 E8 ?? ?? ?? ?? 3B B8 A0 00 00 00 75 23 8B 45 08 8B 40 FC 8B 80 98 03 00 00 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC EB 04 43 4E 75 BE 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1265_0 {
	meta:
		name = "TCustomActionMainMenuBar.RefreshMDIMenu"
		size = 548
		refs = "0018 TCustomActionMainMenuBar.RefreshMDIMenu 0069 TCustomActionMainMenuBar.GetActiveMDIChild 007f _Dn_TActionList 0084 TCustomActionList.Create 009b TActionClient.GetItems 00a0 TActionClients.Add 00b7 TActionClientItem.SetCaption 00c7 TCustomForm.get_MDIChildCount 00e0 TObject.Free 0100 TCustomForm.get_MDIChildren 0105 FindChildAction 011d TControl.GetText 0127 TCustomAction.SetCaption 013c _DV_TInternalMDIAction 0141 TWindowAction.Create 015a TContainedAction.SetActionList 0163 TCustomAction.SetGroupIndex 0175 TWindowAction.SetForm 01bf TActionClientItem.SetAction 01cd TActionClientItem.SetUsageCount 01da TCustomAction.SetChecked 01fe @UStrArrayClr 0204 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 D2 89 55 F0 89 55 F4 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 98 20 03 00 00 F6 43 1C 08 0F 85 B3 01 00 00 80 BB 9E 02 00 00 02 0F 85 A6 01 00 00 8B 45 FC 8B 10 FF 92 20 01 00 00 84 C0 0F 85 93 01 00 00 8B 45 FC 83 B8 B4 03 00 00 00 0F 84 83 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 83 B8 98 03 00 00 00 75 42 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 82 98 03 00 00 8B 45 FC 8B 80 B4 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC 89 98 B0 03 00 00 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B B8 20 03 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 15 8B 45 FC 05 B0 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 48 85 C0 0F 8C F4 00 00 00 40 89 45 F8 33 F6 55 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B D8 85 DB 74 20 8B D6 8B C7 E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 E8 ?? ?? ?? ?? E9 A1 00 00 00 8B 45 FC 8B 88 98 03 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C6 83 B0 00 00 00 00 8B 45 FC 8B 90 98 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B D7 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C7 E8 ?? ?? ?? ?? 8D 55 F0 E8 ?? ?? ?? ?? 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 B4 03 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 A8 00 00 00 8B 45 FC 89 83 AC 00 00 00 8B D3 8B 83 A8 00 00 00 E8 ?? ?? ?? ?? 83 CA FF 8B 83 A8 00 00 00 E8 ?? ?? ?? ?? 85 F6 75 09 B2 01 8B C3 E8 ?? ?? ?? ?? 46 FF 4D F8 0F 85 12 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1266_0 {
	meta:
		name = "SetupMDIButton"
		size = 492
		refs = "0010 _DV_TCustomMDIMenuButton 0015 TSpeedButton.Create 0020 TControl.SetVisible 0041 TControl.SetTop 0048 GetSystemMetrics 0051 TControl.SetWidth 0061 TControl.SetHeight 0074 _DV_TInternalMDIAction 0079 TWindowAction.Create 0082 TControl.SetAction 00a5 SetupMDIButton 00ac TControl.SetAnchors 00e7 TControl.SetLeft 01a1 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 8B 45 08 8B 48 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 50 FC 8B C6 8B 08 FF 51 78 8B 45 08 8B 40 FC 8B 90 BC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? 6A 36 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 6A 37 E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 88 9E D0 01 00 00 8B 45 08 8B 48 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C6 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 0F B6 80 8F 02 00 00 2C 01 72 0B 0F 84 9B 00 00 00 E9 F1 00 00 00 0F B6 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 86 D0 01 00 00 2C 01 72 0B 74 33 FE C8 74 55 E9 CD 00 00 00 8B 45 08 8B 40 FC 8B 50 48 8B 46 48 8D 04 40 2B D0 8B 45 08 8B 40 FC 2B 90 BC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? E9 A3 00 00 00 8B 45 08 8B 40 FC 8B 50 48 8B 46 48 03 C0 2B D0 8B 45 08 8B 40 FC 2B 90 BC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? EB 7D 8B 45 08 8B 40 FC 8B 50 48 2B 56 48 8B 45 08 8B 40 FC 2B 90 BC 02 00 00 4A 8B C6 E8 ?? ?? ?? ?? EB 5B 0F B6 86 D0 01 00 00 2C 01 72 08 74 21 FE C8 74 36 EB 48 8B 56 48 03 D2 8B 45 08 8B 40 FC 03 90 BC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? EB 2D 8B 56 48 8B 45 08 8B 40 FC 03 90 BC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? EB 14 8B 45 08 8B 40 FC 8B 90 BC 02 00 00 42 8B C6 E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 4C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 96 D0 01 00 00 80 EA 01 72 08 74 0F FE CA 74 14 EB 19 C6 80 B0 00 00 00 03 EB 10 C6 80 B0 00 00 00 02 EB 07 C6 80 B0 00 00 00 01 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 8B C6 5E 5B 5D C3 00 00 00 06 00 00 00 }
	condition:
		$1
}

rule function_1267_0 {
	meta:
		name = "TCustomActionMainMenuBar.MDIChildMaximized"
		size = 164
		refs = "0024 SetupMDIButton 0067 TWindowAction.SetForm"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC F6 43 1C 08 0F 85 8C 00 00 00 8B 45 FC 83 B8 A8 03 00 00 00 75 36 55 33 C0 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 A4 03 00 00 55 B0 01 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 A8 03 00 00 55 B0 02 E8 ?? ?? ?? ?? 59 8B 55 FC 89 82 AC 03 00 00 8B 45 FC 8B 80 A4 03 00 00 8B 10 FF 52 4C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 A8 03 00 00 8B 10 FF 52 4C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 AC 03 00 00 8B 10 FF 52 4C 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 90 00 00 00 5B 59 5D C3 }
	condition:
		$1
}

rule function_1268_0 {
	meta:
		name = "TCustomActionMainMenuBar.MDIChildRestored"
		size = 62
		refs = "0012 TObject.Free"
	strings:
		$1 = { 53 8B D8 8D 83 A4 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 A8 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 83 AC 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1269_0 {
	meta:
		name = "TCustomActionMainMenuBar.CustomAlignPosition"
		size = 131
		refs = "0050 TControl.GetBoundsRect 0076 TCustomActionDockBar.CustomAlignPosition"
	strings:
		$1 = { 55 8B EC 83 C4 D8 53 56 57 8B 75 08 8D 7D E8 A5 A5 A5 A5 89 4D F8 89 55 FC 8B D8 8B 75 0C 8B BB A4 03 00 00 85 FF 74 34 8B 46 08 3B 47 40 7E 2C 0F B6 83 8F 02 00 00 2C 01 72 04 74 0D EB 1D 8B 47 40 83 E8 02 89 46 08 EB 12 8D 55 D8 8B C7 E8 ?? ?? ?? ?? 8B 45 E0 83 C0 02 89 06 8B 45 18 50 8B 45 14 50 8B 45 10 50 56 8D 45 E8 50 8B 4D F8 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule function_1270_0 {
	meta:
		name = "TCustomActionMainMenuBar.CreateControls"
		size = 47
		refs = "0006 TCustomActionDockBar.CreateControls 0029 TCustomActionMainMenuBar.SetupWindowMenu"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 83 BB 78 02 00 00 00 74 1A 8B 83 A0 03 00 00 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1271_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysCommand"
		size = 271
		refs = "000c GetParentForm 0012 Screen 001e Application 0084 GetCapture 009a TCustomActionBar.FindAccelItem 00c4 TCustomActionBar.FindFirstVisibleItem 00f3 TWinControl.GetHandle 00f9 PostMessage"
	strings:
		$1 = { 56 57 55 8B FA 8B F0 B2 01 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 12 3B 42 74 74 14 A1 ?? ?? ?? ?? 8B 00 83 B8 C4 00 00 00 00 0F 85 DA 00 00 00 80 BE 1A 03 00 00 00 0F 85 CD 00 00 00 8B C6 8B 10 FF 52 5C 84 C0 0F 84 BE 00 00 00 80 BE EA 01 00 00 00 0F 84 B1 00 00 00 8B 47 04 25 F0 FF 00 00 3D 00 F1 00 00 0F 85 9E 00 00 00 66 83 7F 08 20 0F 84 93 00 00 00 66 83 7F 08 2D 0F 84 88 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 7F 0F B7 47 08 66 85 C0 74 23 8B D0 8B C6 E8 ?? ?? ?? ?? 8B E8 85 ED 74 59 8B 45 44 8B 10 FF 92 FC 00 00 00 C7 47 0C 01 00 00 00 EB 45 80 BE 70 03 00 00 00 75 3C 8B C6 E8 ?? ?? ?? ?? 8B E8 B2 01 8B C6 8B 08 FF 91 54 01 00 00 85 ED 74 0D 8B 45 44 B2 01 8B 08 FF 91 F4 00 00 00 6A 00 6A 00 68 10 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 86 70 03 00 00 00 C7 47 0C 01 00 00 00 5D 5F 5E C3 }
	condition:
		$1
}

rule function_1272_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysKeyDown"
		size = 20
		refs = "000f TCustomActionMenuBar.WMSysKeyDown"
	strings:
		$1 = { 66 83 7A 04 12 0F 94 C1 88 88 70 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1273_0 {
	meta:
		name = "TCustomActionMainMenuBar.WMSysKeyUp"
		size = 20
		refs = "000f TWinControl.WMSysKeyUp"
	strings:
		$1 = { 66 83 7A 04 12 0F 94 C1 88 88 70 03 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1274_0 {
	meta:
		name = "TCustomActionMainMenuBar.MainWndHook"
		size = 84
		refs = "0036 ActionBarDesigner 004b TCustomActionMainMenuBar.SetInActive"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 06 05 00 50 FF FF 83 E8 02 73 3D C6 83 70 03 00 00 00 80 BB 1A 03 00 00 00 74 0A 8B C3 8B 10 FF 92 BC 01 00 00 80 BB 8C 02 00 00 00 74 0A A1 ?? ?? ?? ?? 83 38 00 75 10 81 3E 01 B0 00 00 0F 94 C2 8B C3 E8 ?? ?? ?? ?? 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_1275_0 {
	meta:
		name = "TCustomActionMainMenuBar.SetShadows"
		size = 33
		refs = "001c TObject.Free"
	strings:
		$1 = { 3A 90 9E 03 00 00 74 18 88 90 9E 03 00 00 05 6C 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1276_0 {
	meta:
		name = "TCustomActionMainMenuBar.TrackMenu"
		size = 103
		refs = "000b TCustomActionMainMenuBar.RefreshMDIMenu 0013 TCustomActionMainMenuBar.TrackMenu 0021 TCustomActionMenuBar.TrackMenu 0043 TObject.Free 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 05 98 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B 45 FC 05 B0 03 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CE 59 5D C3 }
	condition:
		$1
}

rule function_1277_0 {
	meta:
		name = "TCustomMenuItem.Create"
		size = 168
		refs = "0011 @ClassCreate 0022 TCustomActionControl.Create 0027 TCustomMenuItem.Create 0046 Rect 0050 TCustomActionControl.SetMargins 005c TCustomActionControl.SetSpacing 0064 _DV_TCustomActionMenuBar 0069 @IsClass 007a GetSystemMetrics 008b @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 8B CE 33 D2 8B C7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? F7 D0 23 47 50 89 47 50 6A 00 8D 45 F0 50 B9 0A 00 00 00 33 D2 B8 02 00 00 00 E8 ?? ?? ?? ?? 8D 55 F0 8B C7 E8 ?? ?? ?? ?? BA 0A 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 89 B7 F4 01 00 00 6A 0F E8 ?? ?? ?? ?? 89 87 0C 02 00 00 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 8B E5 5D C3 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_1278_0 {
	meta:
		name = "TCustomMenuButton.Destroy"
		size = 78
		refs = "0004 @BeforeDestruction 001b _DV_TCustomActionMenuBar 0020 @IsClass 003b TCustomActionControl.Destroy 0046 @ClassDestroy"
		altNames = "TCustomMenuItem.Destroy"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B DA 8B F8 8B B7 B4 01 00 00 85 F6 74 1D 8B 46 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 8B 46 18 8B 10 FF 92 BC 01 00 00 8B D3 80 E2 FC 8B C7 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1279_0 {
	meta:
		name = "TCustomMenuItem.DrawSubMenuGlyph"
		size = 227
		refs = "0018 TActionClient.GetHasItems 002b TActionClient.GetItems 0030 TActionClients.VisibleCount 004e TCustomActionControl.GetActionBar 0053 TCustomActionBar.GetColorMap 005e TPen.SetColor 0088 TBrush.SetColor 00da DrawArrow"
	strings:
		$1 = { 53 56 83 C4 F8 8B D8 8B B3 B4 01 00 00 85 F6 0F 84 C9 00 00 00 8B C6 E8 ?? ?? ?? ?? 84 C0 0F 84 BA 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 A2 00 00 00 8B B3 A8 01 00 00 80 BB D4 01 00 00 00 74 19 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 68 8B 46 44 E8 ?? ?? ?? ?? EB 17 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 54 8B 46 44 E8 ?? ?? ?? ?? 8B 46 44 8B 40 10 8B 50 14 8B 46 48 E8 ?? ?? ?? ?? 80 BB D4 01 00 00 00 74 1C 8B 83 F4 01 00 00 E8 ?? ?? ?? ?? 8B 50 68 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B 43 48 83 E8 0B 89 04 24 8B 43 4C D1 F8 79 03 83 D0 00 83 E8 03 89 44 24 04 6A 03 8D 4C 24 04 B2 01 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1280_0 {
	meta:
		name = "TCustomMenuItem.Paint"
		size = 94
		refs = "0006 TCustomActionControl.Paint 0011 TActionClient.GetHasItems 0026 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 84 C0 74 0A 8B C3 8B 10 FF 92 04 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 74 1C 8B C3 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 74 13 80 BB D4 01 00 00 00 75 0A 8B C3 8B 10 FF 92 08 01 00 00 5B C3 }
	condition:
		$1
}

rule function_1281_0 {
	meta:
		name = "TCustomMenuItem.DrawUnusedEdges"
		size = 201
		refs = "001d TCustomActionControl.GetActionBar 0022 TCustomActionBar.GetColorMap 0033 TPen.SetColor 0072 TCustomActionBarColorMap.GetUnusedColor"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B D8 8B D4 8B C3 8B 08 FF 51 54 F6 83 F0 01 00 00 02 74 42 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 5C 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B 74 24 04 8B CE 8B 14 24 8B 83 A8 01 00 00 8B 38 FF 57 5C 8B CE 8B 54 24 08 8B 83 A8 01 00 00 8B 30 FF 56 58 F6 83 F0 01 00 00 08 74 47 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 83 A8 01 00 00 8B 40 44 E8 ?? ?? ?? ?? 8B 74 24 0C 4E 8B CE 8B 14 24 8B 83 A8 01 00 00 8B 38 FF 57 5C 8B CE 8B 54 24 08 8B 83 A8 01 00 00 8B 30 FF 56 58 F6 83 F0 01 00 00 04 74 0D F6 83 F0 01 00 00 02 74 04 FF 44 24 04 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1282_0 {
	meta:
		name = "TCustomMenuItem.Click"
		size = 54
	strings:
		$1 = { 8B 90 F4 01 00 00 8B 92 3C 03 00 00 8B 92 20 03 00 00 85 D2 74 1F 8B 80 F4 01 00 00 8B 80 3C 03 00 00 80 B8 69 03 00 00 00 74 0A 8B C2 8B 10 FF 92 E8 00 00 00 C3 }
	condition:
		$1
}

rule function_1283_0 {
	meta:
		name = "TCustomMenuItem.Keyed"
		size = 105
		refs = "0020 _Dn_TCustomAction 0025 @IsClass 0046 TCustomAction.SetChecked 005c TWinControl.GetHandle 0062 PostMessage"
	strings:
		$1 = { 53 56 8B D8 B2 01 8B C3 8B 08 FF 91 F4 00 00 00 C6 83 F8 01 00 00 00 8B C3 8B 10 FF 52 4C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C3 8B 10 FF 52 4C 83 78 6C 00 7E 10 80 B8 95 00 00 00 00 75 07 B2 01 E8 ?? ?? ?? ?? 8B 73 34 85 F6 74 15 53 6A 00 68 04 B4 00 00 8B C6 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1284_0 {
	meta:
		name = "TCustomMenuItem.SetEdges"
		size = 146
		refs = "005e TCustomActionControl.GetActionBar 0063 TCustomActionBar.FindLastVisibleItem 0080 TControl.SetHeight"
	strings:
		$1 = { 53 56 51 88 14 24 8B D8 0F B6 04 24 3A 83 F0 01 00 00 74 7A 8B 73 4C F6 04 24 02 74 0C F6 83 F0 01 00 00 02 75 03 46 EB 10 F6 04 24 02 75 0A F6 83 F0 01 00 00 02 74 01 4E F6 04 24 08 74 0C F6 83 F0 01 00 00 08 75 03 46 EB 10 F6 04 24 08 75 0A F6 83 F0 01 00 00 08 74 01 4E 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 06 3B 58 44 75 01 46 0F B6 04 24 88 83 F0 01 00 00 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 90 00 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1285_0 {
	meta:
		name = "TCustomMenuItem.CMMouseEnter"
		size = 96
		refs = "0006 TControl.CMMouseEnter 000d TControl.GetDragMode"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 3C 01 74 49 C6 83 F8 01 00 00 01 B2 01 8B C3 8B 08 FF 91 F4 00 00 00 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 75 28 8B C3 8B 10 FF 52 5C 84 C0 75 1D 83 BB F4 01 00 00 00 74 14 8B 83 F4 01 00 00 8B 80 3C 03 00 00 33 D2 89 90 10 03 00 00 5B C3 }
	condition:
		$1
}

rule function_1286_0 {
	meta:
		name = "TCustomMenuItem.CMTextchanged"
		size = 108
		refs = "000e TCustomMenuItem.CMTextchanged 001b TCustomActionControl.CMTextChanged 0025 TControl.GetText 0030 StripHotkey 003e @UStrAsg 0053 @UStrClr 0061 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8D 83 10 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1287_0 {
	meta:
		name = "TCustomMenuItem.SetSelected"
		size = 125
		refs = "0018 TActionClientItem.GetParentItem 001e _Dn_TActionClientItem 0023 @IsClass 003b _DV_TCustomMenuItem 0065 TCustomActionControl.SetSelected 0076 TCustomActionMenuBar.DoItemSelected"
	strings:
		$1 = { 53 56 8B DA 8B F0 84 DB 75 07 C6 86 F8 01 00 00 00 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 35 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 44 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 18 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B 40 44 B2 01 8B 08 FF 91 F4 00 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 86 F4 01 00 00 85 C0 74 07 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1288_0 {
	meta:
		name = "TCustomMenuItem.DragDrop"
		size = 86
		refs = "000d TCustomActionControl.DragDrop 0014 TCustomActionControl.GetActionBar 001a _DV_TCustomActionMenuBar 001f @IsClass 003f Application 004d SetFocus"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B 45 08 50 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2A 8B C3 E8 ?? ?? ?? ?? 8B 90 3C 03 00 00 85 D2 74 19 83 7A 34 00 74 13 A1 ?? ?? ?? ?? 8B 00 8B 80 70 01 00 00 50 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1289_0 {
	meta:
		name = "TCustomMenuItem.DragOver"
		size = 233
		refs = "0017 _Dn_TActionItemDragObject 001c @IsClass 003a _DV_TCustomActionMenuBar 00a5 TCustomActionControl.DragOver 00b1 TCustomActionControl.GetActionBar"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 6F 8B 43 48 3B 86 B4 01 00 00 75 2F 8B 86 B4 01 00 00 8B 40 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 17 8B 86 B4 01 00 00 8B 40 18 89 45 F8 8B 45 F8 8B 10 FF 92 BC 01 00 00 8B 86 F4 01 00 00 8B 80 3C 03 00 00 8B 80 10 03 00 00 85 C0 74 1F 8B 80 B4 01 00 00 3B 43 48 75 14 8B 86 F4 01 00 00 8B 80 3C 03 00 00 33 D2 89 90 10 03 00 00 8B 45 10 50 0F B6 45 0C 50 57 8B 4D FC 8B D3 8B C6 E8 ?? ?? ?? ?? 80 3F 00 74 32 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B C6 E8 ?? ?? ?? ?? 80 B8 1A 03 00 00 00 74 0C B2 01 8B C6 8B 08 FF 91 F4 00 00 00 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1290_0 {
	meta:
		name = "TCustomMenuItem.CalcBounds"
		size = 448
		refs = "002a TCustomMenuItem.CalcBounds 0035 TFont.SetStyle 003c TCustomActionControl.CalcBounds 00de OffsetRect 0102 Rect 012c TCanvas.GetHandle 015a @UStrToPWChar 0161 DrawText"
	strings:
		$1 = { 53 56 57 55 83 C4 CC 8B D8 8B 83 B4 01 00 00 85 C0 74 26 80 78 6C 00 74 20 8B 73 64 8B 46 10 0F B6 40 1D 88 44 24 08 0F B6 15 ?? ?? ?? ?? 0A 54 24 08 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 8B 08 FF 91 D0 00 00 00 8B B3 0C 02 00 00 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 74 14 8B 83 0C 02 00 00 B9 03 00 00 00 99 F7 F9 8B F0 03 F6 EB 0E 8B 44 24 04 83 F8 10 7E 05 8B F0 83 C6 04 83 BB B4 01 00 00 00 0F 84 22 01 00 00 8B 04 24 83 F8 10 7F 07 BF 18 00 00 00 EB 05 8B F8 83 C7 06 56 57 8D B3 DC 01 00 00 8D 7C 24 1C A5 A5 A5 A5 5F 5E 8B CE D1 F9 79 03 83 D1 00 8B 83 E8 01 00 00 D1 F8 79 03 83 D0 00 2B C8 49 BA 18 00 00 00 2B 93 DC 01 00 00 8D 44 24 14 E8 ?? ?? ?? ?? 56 57 8D 74 24 1C 8D BB DC 01 00 00 A5 A5 A5 A5 5F 5E 6A 00 8D 44 24 28 50 33 C9 33 D2 33 C0 E8 ?? ?? ?? ?? 56 57 8D 74 24 2C 8D BB FC 01 00 00 A5 A5 A5 A5 5F 5E 8B 83 B4 01 00 00 66 83 78 4C 00 74 6E 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B E8 8B 83 B4 01 00 00 8B 40 58 89 44 24 0C 8D 83 FC 01 00 00 89 44 24 10 68 00 04 00 00 8B 44 24 14 50 6A FF 8B 44 24 18 E8 ?? ?? ?? ?? 50 55 E8 ?? ?? ?? ?? 8B 83 E0 01 00 00 89 83 00 02 00 00 8B 83 E8 01 00 00 89 83 08 02 00 00 8B 83 E4 01 00 00 03 83 04 02 00 00 03 C7 03 83 D8 01 00 00 EB 0C 8B 83 E4 01 00 00 03 83 DC 01 00 00 50 56 8B 4B 44 8B 53 40 8B C3 8B 18 FF 93 98 00 00 00 83 C4 34 5D 5F 5E 5B C3 00 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_1291_0 {
	meta:
		name = "TCustomMenuItem.CalcLayout"
		size = 90
		refs = "0009 TCustomActionControl.CalcLayout"
	strings:
		$1 = { 53 83 C4 F0 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 54 24 08 8B C3 8B 08 FF 91 D0 00 00 00 8B 44 24 0C D1 F8 79 03 83 D0 00 50 8B 43 4C D1 F8 79 03 83 D0 00 5A 2B C2 40 8B 93 C4 01 00 00 89 14 24 89 44 24 04 8B 04 24 89 83 BC 01 00 00 8B 44 24 04 89 83 C0 01 00 00 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_1293_0 {
	meta:
		name = "TCustomMenuItem.DrawShadowedText"
		size = 272
		refs = "001d @UStrAddRef 0025 TCustomMenuItem.DrawShadowedText 0034 _Dn_TCustomActionBar 0039 @IsClass 0044 TCustomActionControl.GetActionBar 005b @UStrLAsg 0070 TCustomActionBar.GetColorMap 0088 TCustomActionControl.DrawShadowedText 00a2 TControl.DrawTextBiDiModeFlags 00cb OffsetRect 00fb @UStrClr 0101 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8B 7D 08 8B 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 80 B8 B0 02 00 00 00 75 0E 8D 45 10 8B 93 10 02 00 00 E8 ?? ?? ?? ?? 80 BB D4 01 00 00 00 74 0F 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 78 58 8B 45 10 50 8B 45 0C 50 57 8B CE 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 B0 00 00 00 84 C0 74 50 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B F0 56 57 8D B3 FC 01 00 00 8D 7D E0 A5 A5 A5 A5 5F 5E 8B 53 48 83 EA 15 2B 93 04 02 00 00 8D 45 E0 33 C9 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 8B 40 58 50 8B 45 0C 50 57 8B CE 8D 55 E0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1294_0 {
	meta:
		name = "TCustomMenuItem.DrawText"
		size = 225
		refs = "0013 @UStrAddRef 001b TCustomMenuItem.DrawText 002a _Dn_TCustomActionBar 002f @IsClass 003a TCustomActionControl.GetActionBar 0051 @UStrLAsg 0060 TCustomActionControl.DrawText 007a TControl.DrawTextBiDiModeFlags 00a1 OffsetRect 00cc @UStrClr 00d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F1 8B FA 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B C3 E8 ?? ?? ?? ?? 80 B8 B0 02 00 00 00 75 0E 8D 45 08 8B 93 10 02 00 00 E8 ?? ?? ?? ?? 8B 45 08 50 8B CE 8B D7 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 B0 00 00 00 84 C0 74 49 BA 02 00 00 00 8B C3 E8 ?? ?? ?? ?? 89 06 56 8D B3 FC 01 00 00 8D 7D F0 A5 A5 A5 A5 5E 8B 53 48 83 EA 15 2B 93 04 02 00 00 8D 45 F0 33 C9 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 8B 40 58 50 8B CE 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1295_0 {
	meta:
		name = "TCustomMenuItem.PositionChanged"
		size = 55
		refs = "0007 TCustomActionControl.PositionChanged"
	strings:
		$1 = { 56 57 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 86 B4 01 00 00 85 C0 74 04 C6 40 40 01 8B BE F4 01 00 00 80 BF 19 03 00 00 00 75 0C B2 01 8B C7 8B 08 FF 91 A4 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule function_1296_0 {
	meta:
		name = "TCustomMenuItem.DoDragDrop"
		size = 557
		refs = "001e TCollectionItem.GetIndex 002c _Dn_TCategoryDragObject 0031 @IsClass 0041 TCustomActionControl.GetActionBar 005b TActionClient.GetItems 006d @AsClass 0089 @CallDynaInst 00b0 TCustomMenuItem.DoDragDrop 00d1 TActionClientItem.SetUsageCount 00df TActionClientItem.SetCaption 00fb TActionClientItem.SetLastSession 011a TActionDragObject.GetActionCount 0160 TActionDragObject.GetAction 0169 TActionClientItem.SetAction 01c7 @HandleFinally 01fb TWinControl.EnableAlign 0208 NotifyDesigner 0220 TCustomActionControl.DoDragDrop"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F1 8B DA 89 45 FC 8B 45 FC 8B 80 B4 01 00 00 85 C0 74 09 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D7 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 66 FF 80 AC 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B 10 FF 52 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 8B 98 7C 02 00 00 8B C3 66 BE ED FF E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 1C 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F0 8B 50 50 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 80 7C 02 00 00 8B 40 6C 8B 50 28 8B 45 F8 E8 ?? ?? ?? ?? 8B D7 8B 45 F8 8B 08 FF 51 14 8B 45 F8 E8 ?? ?? ?? ?? 8B 10 FF 52 20 8B 45 F0 E8 ?? ?? ?? ?? 8B F8 4F 85 FF 7C 5B 47 C7 45 F4 00 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 98 7C 02 00 00 8B C3 66 BE ED FF E8 ?? ?? ?? ?? 50 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 B2 01 58 FF 50 1C 8B D8 8B 55 F4 8B 45 F0 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 8B 50 60 8B C3 E8 ?? ?? ?? ?? FF 45 F4 4F 75 AD 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F8 8B 08 FF 91 5C 01 00 00 8B 45 F0 E8 ?? ?? ?? ?? 85 C0 0F 9F C2 8B 45 F8 8B 40 44 8B 08 FF 51 74 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 80 78 02 00 00 E8 ?? ?? ?? ?? 8B 10 FF 52 24 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C6 8B 45 08 50 8B CE 8B D3 8B 45 FC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1297_0 {
	meta:
		name = "TCustomMenuItem.MouseUp"
		size = 139
		refs = "001a TControl.MouseUp 0037 _Dn_TCustomAction 003c @IsClass 005d TCustomAction.SetChecked 007b TWinControl.GetHandle 0081 PostMessage"
	strings:
		$1 = { 55 8B EC 51 53 66 89 4D FE 8B D8 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B C3 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 85 C0 74 06 83 78 18 00 75 57 8B C3 8B 10 FF 52 4C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1D 8B C3 8B 10 FF 52 4C 83 78 6C 00 7E 10 80 B8 95 00 00 00 00 75 07 B2 01 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 E4 00 00 00 84 C0 75 16 53 6A 00 68 03 B4 00 00 8B 43 34 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1298_0 {
	meta:
		name = "TCustomMenuItem.MouseMove"
		size = 26
		refs = "0011 TControl.MouseMove"
	strings:
		$1 = { 55 8B EC 51 66 89 55 FE 8B 55 08 52 0F B7 55 FE E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1299_0 {
	meta:
		name = "TCustomMenuButton.Create"
		size = 60
		refs = "000a @ClassCreate 0017 TCustomButtonControl.Create 0029 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? C6 86 F8 01 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1301_0 {
	meta:
		name = "TCustomMenuButton.BeginAutoDrag"
		size = 32
		refs = "0012 @CallDynaInst 0019 TCustomActionControl.BeginAutoDrag"
	strings:
		$1 = { 53 56 8B D8 C6 83 F9 01 00 00 01 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1302_0 {
	meta:
		name = "TCustomMenuButton.Click"
		size = 221
		refs = "0011 TActionClientItem.GetAction 0028 TCustomActionControl.GetActionBar 003b TCustomActionControl.ResetUsageData 0044 TCustomButtonControl.Click 0061 TCustomMenuButton.GetMenu 00d0 TWinControl.GetHandle 00d6 PostMessage"
	strings:
		$1 = { 53 56 8B F0 8B 9E B4 01 00 00 85 DB 74 33 8B C3 E8 ?? ?? ?? ?? 85 C0 74 28 B2 01 8B C6 8B 08 FF 91 F4 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 10 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 80 BE F9 01 00 00 00 0F 84 85 00 00 00 83 BE B4 01 00 00 00 74 7C 8B C6 E8 ?? ?? ?? ?? 80 B8 1A 03 00 00 00 74 31 80 BE D4 01 00 00 00 74 15 80 BE D4 01 00 00 00 74 1F 8B 86 B4 01 00 00 83 78 18 00 75 13 8B C6 E8 ?? ?? ?? ?? 8B D6 8B 08 FF 91 90 01 00 00 EB 3B 80 BE F8 01 00 00 00 74 18 C6 86 F8 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 EB 1A 56 6A 00 68 03 B4 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1303_0 {
	meta:
		name = "TCustomMenuButton.CMMouseEnter"
		size = 90
		refs = "0006 TCustomButtonControl.CMMouseEnter 000d TCustomMenuButton.GetMenu 001d TCustomActionControl.GetActionBar 0054 @CallDynaInst"
	strings:
		$1 = { 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 80 B8 1B 03 00 00 00 75 3E 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 20 01 00 00 84 C0 75 2B 80 BE D4 01 00 00 00 75 22 8B C6 E8 ?? ?? ?? ?? 80 B8 1A 03 00 00 00 74 12 C6 86 F9 01 00 00 01 8B C6 66 BE EC FF E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1304_0 {
	meta:
		name = "TCustomMenuButton.DoDragDrop"
		size = 119
		refs = "0010 _Dn_TCategoryDragObject 0015 @IsClass 0027 TCustomActionControl.GetActionBar 0047 TCustomActionControl.DoDragDrop 0054 _DV_TCustomActionMenuBar"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1F 8B 46 44 03 45 08 50 8B C6 E8 ?? ?? ?? ?? 8B 4E 40 03 CF 8B D3 8B 18 FF 93 60 01 00 00 EB 0F 8B 45 08 50 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1305_0 {
	meta:
		name = "TCustomMenuButton.DragOver"
		size = 174
		refs = "0023 TCustomActionControl.DragOver 002f TCustomActionControl.GetActionBar 0035 _DV_TCustomActionMenuBar 003a @IsClass 0046 _Dn_TActionItemDragObject 0087 TCustomActionMenuBar.ClearSubMenus 00a2 @CallDynaInst"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B FA 8B D8 8B 75 08 8B 45 10 50 0F B6 45 0C 50 56 8B 4D FC 8B D7 8B C3 E8 ?? ?? ?? ?? 80 3E 00 74 7A 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 64 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 38 8B 47 48 3B 83 B4 01 00 00 75 2D 8B C3 E8 ?? ?? ?? ?? 85 C0 74 22 8B C3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 BB D4 01 00 00 00 75 12 C6 83 F9 01 00 00 01 8B C3 66 BE EC FF E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1306_0 {
	meta:
		name = "TCustomMenuButton.DrawText"
		size = 258
		refs = "0017 @UStrAddRef 001f TCustomMenuButton.DrawText 0030 @UStrLAsg 003b _DV_TCustomActionMainMenuBar 0040 @IsClass 0058 StripHotkey 007c TCustomActionControl.GetActionBar 0081 TCustomActionBar.GetColorMap 0092 TFont.SetColor 00c8 TCustomActionControl.DrawText 00dd @UStrClr 00f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 89 4D F8 8B FA 8B D8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B 55 08 E8 ?? ?? ?? ?? 8B 73 34 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 74 80 BE B0 02 00 00 00 75 16 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8D 45 FC E8 ?? ?? ?? ?? 80 BE 9D 03 00 00 00 74 26 80 BB F3 01 00 00 00 75 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 4C 8B 83 A8 01 00 00 8B 40 40 E8 ?? ?? ?? ?? 80 BB D4 01 00 00 00 74 1D 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 50 40 8B 83 A8 01 00 00 8B 40 40 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 4D F8 8B D7 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 8D 45 08 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1309_0 {
	meta:
		name = "TCustomMenuButton.MouseDown"
		size = 190
		refs = "001f TCustomButtonControl.MouseDown 0026 TCustomMenuButton.GetMenu 0058 ActiveMenu 0087 TWinControl.GetHandle 008d PostMessage"
	strings:
		$1 = { 55 8B EC 51 53 56 66 89 4D FE 8B DA 8B F0 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 0F B6 80 1A 03 00 00 88 86 F8 01 00 00 8B C3 2C 01 72 04 74 54 EB 76 80 BE F8 01 00 00 00 75 6D B2 01 8B C6 8B 08 FF 91 F4 00 00 00 83 3D ?? ?? ?? ?? 00 74 18 8B 46 04 3B 05 ?? ?? ?? ?? 74 0D A1 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 56 6A 00 68 03 B4 00 00 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB 24 8B C6 E8 ?? ?? ?? ?? 80 B8 1A 03 00 00 00 74 14 80 FB 01 75 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1310_0 {
	meta:
		name = "TCustomMenuButton.MouseUp"
		size = 77
		refs = "0026 TCustomButtonControl.MouseUp 003a TCustomMenuButton.GetMenu"
	strings:
		$1 = { 55 8B EC 51 53 56 66 89 4D FE 8B DA 8B F0 C6 86 F9 01 00 00 00 8B 45 0C 50 8B 45 08 50 0F B7 4D FE 8B D3 8B C6 E8 ?? ?? ?? ?? 84 DB 75 18 80 BE F8 01 00 00 00 74 0F 8B C6 E8 ?? ?? ?? ?? 8B 10 FF 92 BC 01 00 00 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_1311_0 {
	meta:
		name = "TCustomMenuButton.Paint"
		size = 46
		refs = "0021 TCustomButtonControl.Paint"
	strings:
		$1 = { 53 56 8B F0 0F B6 9E F6 01 00 00 8B 86 B4 01 00 00 83 78 18 00 74 07 C6 86 F6 01 00 00 02 8B C6 E8 ?? ?? ?? ?? 88 9E F6 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1312_0 {
	meta:
		name = "TCustomMenuButton.CMDialogChar"
		size = 114
		refs = "000c TCustomButtonControl.CMDialogChar 0016 GetParentForm 002a TCustomActionControl.GetActionBar 0033 TCustomActionBar.FindAccelItem 0058 TCustomMenuButton.GetMenu 005d TWinControl.GetHandle 0063 PostMessage"
	strings:
		$1 = { 53 56 57 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? B2 01 8B 43 34 E8 ?? ?? ?? ?? 85 C0 74 50 80 B8 9E 02 00 00 02 75 47 8B C3 E8 ?? ?? ?? ?? 0F B7 56 04 E8 ?? ?? ?? ?? 8B F8 85 FF 74 31 8B 47 44 B2 01 8B 08 FF 91 F4 00 00 00 8B 47 44 50 6A 00 68 03 B4 00 00 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C7 46 0C 01 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1313_0 {
	meta:
		name = "RegisterActnBarStyle"
		size = 148
		refs = "000e RegisterActnBarStyle 0019 ActionBarStyles 0025 _Dn_TActionBarStyleList 002a TStringList.Create 0083 @UStrArrayClr 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 38 00 75 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 40 75 1B 8D 55 F8 8B C3 8B 08 FF 51 08 8B 55 F8 A1 ?? ?? ?? ?? 8B 00 8B CB 8B 18 FF 53 3C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1314_0 {
	meta:
		name = "UnRegisterActnBarStyle"
		size = 76
		refs = "0004 ActionBarStyles 0046 TObject.Free"
	strings:
		$1 = { 56 8B F0 A1 ?? ?? ?? ?? 8B 00 8B D6 8B 08 FF 51 5C 83 F8 FF 74 0E 8B 15 ?? ?? ?? ?? 8B 12 92 8B 08 FF 51 48 A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 14 85 C0 75 16 A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 33 C9 89 0A E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1316_0 {
	meta:
		name = "ActnMenus"
		size = 31
		refs = "0002 _DV_51 000c UpdateActnMenusProc 0013 MenuCallWndHook 001a MenuList"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 73 15 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1317_0 {
	meta:
		name = "SetOwner"
		size = 75
		refs = "001a TComponent.InsertComponent 0021 TMenuItem.GetCount 0038 TMenuItem.GetItem 003d SetOwner"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F8 83 7F 04 00 75 10 8B 45 08 8B 40 FC 8B 40 04 8B D7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 4B 85 DB 7C 1A 43 33 F6 8B 45 08 50 8B D6 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 46 4B 75 E9 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1318_0 {
	meta:
		name = "InitMenuItems"
		size = 51
		refs = "0016 SetOwner 0024 TMenuItem.Add"
	strings:
		$1 = { 55 8B EC 51 53 56 89 45 FC 8B F1 85 F6 7C 1F 46 8B DA 55 8B 03 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 40 38 8B 13 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E4 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1319_0 {
	meta:
		name = "NewPopupMenu"
		size = 72
		refs = "0010 _DV_TPopupActionBar 0015 TPopupActionBar.Create 003b InitMenuItems"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B F2 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D6 8B C3 8B 08 FF 51 18 0F B6 45 10 88 43 69 0F B6 45 FF 88 43 68 8B 55 0C 8B 4D 08 8B C3 E8 ?? ?? ?? ?? 8B C3 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_30182_0 {
	meta:
		name = "NewPopupMenu"
		size = 72
		refs = "0010 _DV_TPopupMenu 0015 TPopupMenu.Create 003b InitMenuItems"
	strings:
		$1 = { 55 8B EC 51 53 56 88 4D FF 8B F2 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D6 8B C3 8B 08 FF 51 18 0F B6 45 10 88 43 69 0F B6 45 FF 88 43 68 8B 55 0C 8B 4D 08 8B C3 E8 ?? ?? ?? ?? 8B C3 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1320_0 {
	meta:
		name = "TPopupActionBar.Create"
		size = 142
		refs = "000a @ClassCreate 0017 TPopupMenu.Create 0020 _Dn_TActionManager 0025 TCustomActionManager.Create 003c ActionBarStyles 0047 DefaultActnBarStyle 0063 TActionBarStyleList.GetStyle 0070 TCustomActionManager.SetStyle 007b @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 86 80 00 00 00 F6 46 1C 10 75 3F F6 46 1C 01 75 39 A1 ?? ?? ?? ?? 83 38 00 74 2F 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D0 8B 86 80 00 00 00 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1321_0 {
	meta:
		name = "StyleNameStored"
		size = 134
		refs = "0017 TPopupActionBar.GetStyle 0034 ActionBarStyles 003f DefaultActnBarStyle 005b TActionBarStyleList.GetStyle"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 20 00 74 23 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 20 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 5B 5D C3 A1 ?? ?? ?? ?? 83 38 00 74 36 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 EB 10 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B 5D C3 }
	condition:
		$1
}

rule function_35214_0 {
	meta:
		name = "StyleNameStored"
		size = 134
		refs = "0017 TCustomRibbon.GetStyle 0034 ActionBarStyles 003f DefaultActnBarStyle 005b TActionBarStyleList.GetStyle"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 83 78 20 00 74 23 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B 40 20 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 5B 5D C3 A1 ?? ?? ?? ?? 83 38 00 74 36 8B 15 ?? ?? ?? ?? 8B 12 A1 ?? ?? ?? ?? 8B 00 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 3B D8 0F 95 C0 EB 10 8B 45 08 8B 40 F8 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5B 5D C3 }
	condition:
		$1
}

rule function_1323_0 {
	meta:
		name = "TPopupActionBar.GetMenuActive"
		size = 11
	strings:
		$1 = { 83 B8 84 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_1324_0 {
	meta:
		name = "TPopupActionBar.GetStyle"
		size = 13
	strings:
		$1 = { 8B 80 80 00 00 00 8B 80 E0 00 00 00 C3 }
	condition:
		$1
}

rule function_1325_0 {
	meta:
		name = "TPopupActionBar.Popup"
		size = 704
		refs = "001a TPopupActionBar.Popup 0047 TPopupMenu.SetPopupPoint 0065 TMenuItem.GetCount 007c TMenuItem.GetItem 0090 TMenuItem.RethinkHotkeys 009b TMenuItem.RethinkLines 00a4 _DV_TCustomActionPopupMenuEx 00a9 TXPStylePopupMenu.Create 00d1 TCollection.Clear 0131 TActionBars.Add 0143 TActionClient.SetActionBar 0159 TActionBarItem.SetAutoSize 0196 SActionManagerNotAssigned 019b LoadResString 01a5 _Dn_Exception 01aa Exception.CreateFmt 01af @RaiseExcept 01b7 TPopupActionBar.GetStyle 0205 TActionClient.GetItems 022d TCustomActionPopupMenuEx.LoadMenu 0252 TCustomActionPopupMenu.Popup 0267 TObject.Free 026d @HandleFinally 02ae @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 33 DB 89 5D DC 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 B8 84 00 00 00 00 0F 85 69 02 00 00 8B 45 F8 89 45 E8 8B 45 F4 89 45 EC 8D 55 E8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 FC 8B 08 FF 51 40 8B 45 FC 8B 58 38 F6 43 1C 10 75 27 8B C3 E8 ?? ?? ?? ?? 48 85 C0 7C 1B 40 89 C3 33 F6 8B 45 FC 8B 40 38 8B D6 E8 ?? ?? ?? ?? 8B 10 FF 52 44 46 4B 75 EA 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 38 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 82 84 00 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 8B 80 80 00 00 00 8B 40 6C E8 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 C6 80 8C 02 00 00 00 C6 80 0D 03 00 00 00 8B 55 FC 89 90 B0 03 00 00 8B 55 FC 8B 8A 88 00 00 00 89 88 A0 02 00 00 8B 8A 8C 00 00 00 89 88 A4 02 00 00 8B 45 FC 8B 50 48 8B 45 FC 8B 80 80 00 00 00 8B 08 FF 51 38 8B 45 FC 8B 80 80 00 00 00 8B 40 6C E8 ?? ?? ?? ?? 8B D8 8B 45 FC 8B 90 84 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 43 0C B2 02 8B 08 FF 91 50 01 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 B2 01 8B 08 FF 51 6C 8B 45 FC 8B 80 84 00 00 00 83 B8 78 02 00 00 00 75 34 8B 45 FC 8B 40 08 89 45 E0 C6 45 E4 11 8D 45 E0 50 6A 00 8D 55 DC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D DC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 92 84 00 00 00 8B 08 FF 51 04 33 C9 B2 01 FF 50 2C 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 80 84 00 00 00 8B 55 F0 8B 08 FF 91 48 01 00 00 8B 45 FC 8B 80 84 00 00 00 8B 80 78 02 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 98 84 00 00 00 8B 83 78 02 00 00 E8 ?? ?? ?? ?? 8B D0 8B 45 FC 8B 48 38 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 80 84 00 00 00 8B 10 FF 92 68 01 00 00 8B 45 FC 8B 80 84 00 00 00 8B 4D F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 05 84 00 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1326_0 {
	meta:
		name = "TPopupActionBar.ReadStyleProp"
		size = 227
		refs = "0017 TPopupActionBar.ReadStyleProp 0027 TReader.ReadString 0044 ActionBarStyles 005c TActionBarStyleList.GetStyle 0066 TPopupActionBar.SetStyle 0075 @HandleAnyException 0083 ApplicationHandleException 008f ExceptObject 00a3 ExceptAddr 00af ShowException 00b6 @RaiseAgain 00bb @DoneExcept 00d0 @UStrClr 00d6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C9 89 4D FC 8B DA 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 0F 84 8A 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 8B 00 8B 55 FC 8B 08 FF 51 54 8B D0 A1 ?? ?? ?? ?? 8B 00 E8 ?? ?? ?? ?? 8B D0 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 4B E9 ?? ?? ?? ?? 8B 45 F8 F6 40 1C 10 74 33 A1 ?? ?? ?? ?? 66 83 78 02 00 74 14 E8 ?? ?? ?? ?? 8B D0 8B 1D ?? ?? ?? ?? 8B 43 04 FF 13 EB 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1327_0 {
	meta:
		name = "TPopupActionBar.SetStyle"
		size = 12
		refs = "0007 TCustomActionManager.SetStyle"
	strings:
		$1 = { 8B 80 80 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_3789_0 {
	meta:
		name = "TCustomChartLegend.SetSymbolWidth"
		size = 12
		refs = "0007 TLegendSymbol.SetWidth"
	strings:
		$1 = { 8B 80 80 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1328_0 {
	meta:
		name = "TPopupActionBar.WriteStyleProp"
		size = 117
		refs = "000f TPopupActionBar.WriteStyleProp 001c TPopupActionBar.GetStyle 0030 ActionBarStyles 0039 TActionBarStyleList.GetStyle 004f TWriter.WriteString 0064 @UStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0B 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 10 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_35309_0 {
	meta:
		name = "TCustomRibbon.WriteStyleProp"
		size = 117
		refs = "000f TCustomRibbon.WriteStyleProp 001c TCustomRibbon.GetStyle 0030 ActionBarStyles 0039 TActionBarStyleList.GetStyle 004f TWriter.WriteString 0064 @UStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0B 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 10 A1 ?? ?? ?? ?? 8B 00 33 D2 E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 8B 08 FF 51 08 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1329_0 {
	meta:
		name = "TCustomActionPopupMenuEx.DoPopup"
		size = 124
		refs = "000c TCustomActionMenuBar.DoPopup 0017 TActionClient.GetItems 001e TActionClients.GetActionClient 0057 TCollection.Clear 0074 TCustomActionPopupMenuEx.LoadMenu"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 83 78 38 00 75 50 8B 83 B4 01 00 00 8B 40 38 66 83 B8 8A 00 00 00 00 74 10 8B F8 8B D0 8B 87 8C 00 00 00 FF 97 88 00 00 00 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 8B 83 B4 01 00 00 8B 48 38 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1330_0 {
	meta:
		name = "TCustomActionPopupMenuEx.ExecAction"
		size = 38
		refs = "0016 PopupList 0021 PostMessage"
	strings:
		$1 = { 6A 00 8B 80 8C 03 00 00 8B 40 38 0F B7 40 50 50 68 11 01 00 00 A1 ?? ?? ?? ?? 8B 00 8B 40 10 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1332_0 {
	meta:
		name = "TCustomActionPopupMenuEx.LoadMenu"
		size = 776
		refs = "0017 TActionClientsCollection.SetAutoHotKeys 001e TMenuItem.GetCount 0035 TActionClients.Add 0040 TMenuItem.GetItem 004a TActionClientItem.SetCaption 0064 TMenuItem.GetAction 006d TActionClientItem.SetAction 0095 TActionClient.GetItems 00d9 TCustomActionPopupMenuEx.LoadMenu 00de @UStrEqual 00f9 _DV_TMenuAction 00fe TMenuAction.Create 010e TActionClientItem.GetAction 0122 TContainedAction.SetActionList 0171 TCustomAction.SetAutoCheck 018c TCustomAction.SetGroupIndex 01c7 TCustomAction.SetImageIndex 01e2 TCustomAction.SetVisible 01fd TCustomAction.SetChecked 0217 TCustomAction.SetCaption 0232 TCustomAction.SetShortCut 024d TCustomAction.SetEnabled 0260 TActionClientItem.SetImageIndex 0274 TActionClientItem.SetShortCut 0288 TActionClientItem.SetDefault"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F1 89 54 24 04 89 04 24 33 D2 8B 44 24 04 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B E8 4D 85 ED 0F 8C C4 02 00 00 45 33 DB 8B 44 24 04 E8 ?? ?? ?? ?? 8B F8 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 34 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 89 47 38 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 20 8B D3 8B C6 E8 ?? ?? ?? ?? 80 78 3E 00 74 11 8B C7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 E9 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 83 78 34 00 0F 84 D6 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 C0 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 34 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 A4 01 00 00 8B D3 8B C6 E8 ?? ?? ?? ?? 50 8B 4C 24 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B 14 24 8B 92 B0 03 00 00 8B 92 80 00 00 00 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? FF 70 0C 8B C7 E8 ?? ?? ?? ?? 5A 89 50 0C 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 54 50 8B C7 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 4C 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 80 A8 00 00 00 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 3F 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? FF B0 8C 00 00 00 FF B0 88 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B 10 FF 52 38 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 40 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 3E 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 38 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 34 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 40 60 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 40 39 50 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 40 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 50 60 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 50 3A 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 34 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B7 50 60 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 40 54 89 47 68 8B D3 8B C6 E8 ?? ?? ?? ?? 8B 50 40 8B C7 E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 0F B6 50 3E 8B C7 8B 08 FF 51 2C 43 4D 0F 85 3F FD FF FF 59 5A 5D 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1333_0 {
	meta:
		name = "TMenuAction.Create"
		size = 68
		refs = "000d @ClassCreate 001a TCustomAction.Create 002e @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B 45 08 89 86 A0 00 00 00 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_1334_0 {
	meta:
		name = "TMenuAction.Execute"
		size = 43
	strings:
		$1 = { 53 56 B3 01 8B 90 A0 00 00 00 85 D2 74 18 66 83 BA 8A 00 00 00 00 74 0E 8B F2 8B 86 8C 00 00 00 FF 96 88 00 00 00 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_1339_0 {
	meta:
		name = "FindDefaultComponentOwnerPageName"
		size = 176
		refs = "0016 FindDefaultComponentOwnerPageName 0026 @UStrAsg 0037 @IntfClear 004c Supports 0055 WebContext 0093 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 8B 5E 04 85 DB 75 02 8B DE 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 85 C0 74 03 83 E8 D0 E8 ?? ?? ?? ?? 84 C0 74 28 E8 ?? ?? ?? ?? 8B F0 8B 03 89 45 F0 8D 4D F4 8B 55 F0 8B C6 8B 18 FF 53 50 84 C0 74 0B 8B 55 F8 8B 45 F4 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 61 1F 8D 60 23 F2 74 45 89 F7 F2 9A 73 37 2F FC }
	condition:
		$1
}

rule function_1340_0 {
	meta:
		name = "ExtractStringValue"
		size = 184
		refs = "000f @UStrAddRef 0017 ExtractStringValue 002a AnsiPos 004d @InternalUStrFromLStr 0074 @UStrCopy 007f @UStrSetLength 0094 @UStrClr 009a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 2D 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 3B D8 0F 9C C0 EB 02 33 C0 84 C0 74 13 56 8D 53 01 B9 FF FF FF 7F 8B 45 FC E8 ?? ?? ?? ?? EB 09 8B C6 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3D 00 00 00 }
	condition:
		$1
}

rule function_1341_0 {
	meta:
		name = "RaiseActionDoesNotProvideResponse"
		size = 84
		refs = "0009 RaiseActionDoesNotProvideResponse 0017 sActionDoesNotProvideResponse 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1343_0 {
	meta:
		name = "RaiseActionCantRedirectToBlankURL"
		size = 84
		refs = "0009 RaiseActionCantRedirectToBlankURL 0017 sActionCantRedirectToBlankURL 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1342_0 {
	meta:
		name = "RaiseCantResponseToUnknownHTTPMethod"
		size = 84
		refs = "0009 RaiseCantResponseToUnknownHTTPMethod 0017 sActionCantRespondToUnkownHTTPMethod 001c LoadResString 0026 _DV_EAdapterRequestException 002b Exception.Create 0030 @RaiseExcept 0045 @UStrClr 004b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 59 5D C3 }
	condition:
		$1
}

rule function_1344_0 {
	meta:
		name = "TestRedirectOptions"
		size = 46
		refs = "0025 RaiseCantResponseToUnknownHTTPMethod"
	strings:
		$1 = { 53 51 88 04 24 33 DB FE CA 74 07 80 EA 02 74 0B EB 12 F6 04 24 02 0F 95 C3 EB 0E F6 04 24 01 0F 95 C3 EB 05 E8 ?? ?? ?? ?? 8B C3 5A 5B C3 }
	condition:
		$1
}

rule function_1345_0 {
	meta:
		name = "TAdapterRequestParamsImpl.AssignTo"
		size = 15
	strings:
		$1 = { 56 8B F0 8B C2 8B 56 04 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1346_0 {
	meta:
		name = "TAdapterRequestParamsImpl.Create"
		size = 135
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TAdapterRequestParamsImpl.Create 0034 TObject.Create 003f @IntfCopy 005f @IntfClear 0065 @HandleFinally 0072 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 08 8B 55 FC E8 ?? ?? ?? ?? 8B 46 08 8B 10 FF 52 14 89 46 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1347_0 {
	meta:
		name = "TAdapterModes.GetAdapterCount"
		size = 9
		altNames = "TAdapterRequestParamsImpl.GetParamCount TAllocatedActions.GetCount TGeneratedFunctions.GetItemCount"
	strings:
		$1 = { 8B 40 04 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1348_0 {
	meta:
		name = "TAdapterModes.GetAdapterName"
		size = 25
		refs = "0011 TStrings.GetName"
		altNames = "TAdapterRequestParamsImpl.GetParamName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1351_0 {
	meta:
		name = "TAdapterRequestParamsImpl.ValueOfParam"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_29372_0 {
	meta:
		name = "TVirtualKeys.GetItem"
		size = 25
		refs = "0011 TList<KeyboardTypes.TVirtualKey>.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 04 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1349_0 {
	meta:
		name = "TAdapterRequestParamsImpl.GetParamValue"
		size = 93
		refs = "0018 TAdapterRequestParamsImpl.GetParamValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1399_0 {
	meta:
		name = "TAdapterModes.GetAdapterMode"
		size = 93
		refs = "0018 TAdapterModes.GetAdapterMode 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B 43 04 8B 18 FF 53 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1350_0 {
	meta:
		name = "TAdapterRequestParamsImpl.IndexOfParam"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 46 04 8B 08 FF 51 54 5F 5E C3 }
	condition:
		$1
}

rule function_1352_0 {
	meta:
		name = "AddValues"
		size = 904
		refs = "0017 AddValues 0046 TStrings.GetName 005c @UStrCopy 0069 SameText 007f @UStrDelete 00c6 ExtractStringValue 00e1 @UStrLAsg 0106 @UStrEqual 014d _Dn_TStringList 0152 TStringList.Create 015b TList.Add 0215 TList.Get 0323 @UStrArrayClr 032b @UStrClr 0331 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 8B 10 FF 52 14 8B F8 4F 85 FF 0F 8C 4E 01 00 00 47 33 F6 8D 4D FC 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8D 45 E0 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 E0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 17 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? E9 8E 00 00 00 8D 45 DC 50 B9 06 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 DC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 38 8D 4D D4 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 D4 8D 55 D8 E8 ?? ?? ?? ?? 8B 55 D8 8B 45 08 8B 40 F8 8B 40 04 8B 08 FF 51 38 8D 45 FC 33 D2 E8 ?? ?? ?? ?? EB 2F 8D 45 D0 50 B9 02 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 0A 8D 45 FC 33 D2 E8 ?? ?? ?? ?? 83 7D FC 00 74 61 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 40 75 4D 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 38 8B 45 08 8B 40 F8 8B 58 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 58 14 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 46 4F 0F 85 B5 FE FF FF 8B 45 08 8B 40 FC 8B 10 FF 52 14 8B F8 4F 85 FF 0F 8C 72 01 00 00 47 33 F6 8D 4D FC 8B 45 08 8B 40 FC 8B D6 E8 ?? ?? ?? ?? 8D 45 CC 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 CC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 72 8D 45 FC B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 8B D8 83 FB FF 0F 84 02 01 00 00 8B 45 08 8B 40 F8 8B 40 14 89 45 F8 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 89 45 F4 8D 4D C4 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 C4 8D 55 C8 E8 ?? ?? ?? ?? 8B 55 C8 8B 45 F4 8B 08 FF 51 38 E9 BE 00 00 00 8B 45 08 8B 40 F8 8B 40 0C 8B 55 FC 8B 08 FF 51 54 8B D8 83 FB FF 0F 84 A2 00 00 00 8B 45 08 8B 40 FC 8B D6 8B 08 FF 51 18 85 C0 74 52 8B 45 08 8B 40 F8 8B 40 10 89 45 F0 8B D3 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 8D 4D BC 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 BC 8D 55 C0 E8 ?? ?? ?? ?? 8B 45 C0 50 8B 45 08 8B 40 FC 8B D6 8B 08 FF 51 18 8B C8 8B 45 EC 5A 8B 18 FF 53 3C EB 3F 8B 45 08 8B 40 F8 8B 40 10 89 45 E8 8B D3 8B 45 E8 E8 ?? ?? ?? ?? 89 45 E4 8D 4D B4 8B 45 08 8B 40 FC 8B D6 8B 18 FF 53 0C 8B 45 B4 8D 55 B8 E8 ?? ?? ?? ?? 8B 55 B8 8B 45 E4 8B 08 FF 51 38 46 4F 0F 85 91 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 B4 BA 0C 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 6F 00 76 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 5F 00 5F 00 6B 00 65 00 79 00 2E 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 5F 00 5F 00 00 00 00 00 }
	condition:
		$1
}

rule function_1353_0 {
	meta:
		name = "TActionFieldValuesImpl.Create"
		size = 174
		refs = "000f @ClassCreate 0021 TObject.Create 0028 _Dn_TStringList 002d TStringList.Create 0060 _Dn_TObjectList 0065 TObjectList.Create 008b AddValues 0098 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 89 45 F8 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 04 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 0C B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 10 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 14 83 7D FC 00 74 07 55 E8 ?? ?? ?? ?? 59 8B 45 F8 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1354_0 {
	meta:
		name = "TActionFieldValueImpl.GetFileCount"
		size = 7
		altNames = "TActionFieldValuesImpl.GetFieldCount TScriptProducer.GetHTMLItemCount TTestResult.FailureCount"
	strings:
		$1 = { 8B 40 10 8B 40 08 C3 }
	condition:
		$1
}

rule function_1355_0 {
	meta:
		name = "TActionFieldValuesImpl.GetFieldName"
		size = 25
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 0C 8B 18 FF 53 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1356_0 {
	meta:
		name = "TActionFieldValuesImpl.AddValue"
		size = 77
		refs = "0021 _Dn_TStringList 0026 TStringList.Create 0030 TList.Add"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 0C 8B 08 FF 51 54 85 C0 7D 36 8B D6 8B 43 0C 8B 08 FF 51 38 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 10 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 43 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1357_0 {
	meta:
		name = "TActionFieldValuesImpl.IndexOfField"
		size = 19
	strings:
		$1 = { 56 57 8B FA 8B F0 8B D7 8B 46 0C 8B 08 FF 51 54 5F 5E C3 }
	condition:
		$1
}

rule function_1358_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 320
		refs = "001f TActionFieldValuesImpl.CreateValue 0042 _Dn_TInterfaceList 0047 TInterfaceList.Create 0058 @IntfCopy 0087 TList.Get 00a5 _DV_TActionFieldValueImpl 00aa TActionFieldValueImpl.Create 00c0 @IntfCast 00ef @IntfClear 010c @UStrClr 0122 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B2 00 00 00 83 7B 1C 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 1C E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 1C 8B 08 FF 51 20 8D 4D F0 8B D6 8B 43 1C 8B 38 FF 57 0C 83 7D F0 00 75 50 8B D6 8B 43 10 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 50 8D 4D E8 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D E8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC 8B D6 8B 43 1C 8B 38 FF 57 18 8D 4D E4 8B D6 8B 43 1C 8B 18 FF 53 0C 8B 55 E4 8B 45 F8 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1359_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1360_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 44
		refs = "000a TActionFieldValuesImpl.IndexOfField 001b TActionFieldValuesImpl.CreateOrigValue 0024 @IntfClear"
	strings:
		$1 = { 53 56 57 8B F9 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 85 F6 7C 0D 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1361_0 {
	meta:
		name = "TActionFieldValuesImpl.CreateOrigValue"
		size = 320
		refs = "001f TActionFieldValuesImpl.CreateOrigValue 0042 _Dn_TInterfaceList 0047 TInterfaceList.Create 0058 @IntfCopy 0087 TList.Get 00a5 _DV_TActionFieldValueImpl 00aa TActionFieldValueImpl.Create 00c0 @IntfCast 00ef @IntfClear 010c @UStrClr 0122 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 0C 8B 10 FF 52 14 3B F0 0F 8D B2 00 00 00 83 7B 18 00 75 2F B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8D 43 18 E8 ?? ?? ?? ?? 8B 43 0C 8B 10 FF 52 14 8B D0 8B 43 18 8B 08 FF 51 20 8D 4D F0 8B D6 8B 43 18 8B 38 FF 57 0C 83 7D F0 00 75 50 8B D6 8B 43 14 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 50 8D 4D E8 8B D6 8B 43 0C 8B 38 FF 57 0C 8B 4D E8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F8 8D 45 EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D EC 8B D6 8B 43 18 8B 38 FF 57 18 8D 4D E4 8B D6 8B 43 18 8B 18 FF 53 0C 8B 55 E4 8B 45 F8 E8 ?? ?? ?? ?? EB 08 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 00 56 E5 D4 C5 74 A4 D4 11 A4 FA 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1362_0 {
	meta:
		name = "TActionFieldValuesImpl.GetValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateValue"
		altNames = "TActionFieldValuesImpl.ValueOfField"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_8604_0 {
	meta:
		name = "D2D_MATRIX_3X2_F.&op_Multiply"
		size = 24
		refs = "0010 TD2DMatrix3x2FHelper.SetProduct"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_47693_0 {
	meta:
		name = "GetStrProp"
		size = 24
		refs = "0010 GetUnicodeStrProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_16994_0 {
	meta:
		name = "SubString"
		size = 24
		refs = "0010 TDBXStringBuffer.Substring"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1365_0 {
	meta:
		name = "TActionFieldValuesImpl.GetOrigValue"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1363_0 {
	meta:
		name = "TActionFieldValuesImpl.OrigValueOfField"
		size = 24
		refs = "0010 TActionFieldValuesImpl.CreateOrigValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_48764_0 {
	meta:
		name = "TBaseAdapterAction.GetInputStyle"
		size = 24
		refs = "0010 TBaseAdapterAction.GetDisplayStyle"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_17078_0 {
	meta:
		name = "TBaseFilterProperties.GetName"
		size = 24
		refs = "0010 TStrings.GetName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_17079_0 {
	meta:
		name = "TBaseFilterProperties.GetValue"
		size = 24
		refs = "0010 TStrings.GetValueFromIndex"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_55301_0 {
	meta:
		name = "TCustomXSLPageProducer.ProduceContentFromString"
		size = 24
		refs = "0010 TCustomXSLPageProducer.ContentFromString"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_17017_0 {
	meta:
		name = "TDBXStringStore.GetString"
		size = 24
		refs = "0010 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_50591_0 {
	meta:
		name = "THTMLItemsObj.Item"
		size = 24
		refs = "0010 THTMLItemsObj.GetItem"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7327_0 {
	meta:
		name = "TIntegerBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_7323_0 {
	meta:
		name = "TObjectBucketList.Add"
		size = 24
		refs = "0010 TCustomBucketList.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_33187_0 {
	meta:
		name = "TOleControl.GetVariantProp"
		size = 24
		refs = "0010 TOleControl.GetOleVariantProp"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_50521_0 {
	meta:
		name = "TSessionObj.Values"
		size = 24
		refs = "0010 TSessionObj.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_47468_0 {
	meta:
		name = "TTimeSpan.&op_Addition"
		size = 24
		refs = "0010 TTimeSpan.Add"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_47504_0 {
	meta:
		name = "TTimeSpan.&op_Subtraction"
		size = 24
		refs = "0010 TTimeSpan.Subtract"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1366_0 {
	meta:
		name = "TActionFieldValuesImpl.Destroy"
		size = 77
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0046 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 8B 46 14 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1367_0 {
	meta:
		name = "TBasicActionRequestImpl.Create"
		size = 328
		refs = "0019 @ClassCreate 0028 @IntfAddRef 0030 TBasicActionRequestImpl.Create 003f TAbstractAdapterRequest.Create 004a @IntfCopy 0054 _DV_TAdapterRequestParamsImpl 0059 TAdapterRequestParamsImpl.Create 0064 @IntfClear 0073 Supports 008d @UStrAsg 00b0 TAbstractAdapterRequest.GetRequest 00b8 PageNameOfRequest 00fd @UStrArrayClr 0113 @HandleFinally 0120 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 84 C0 74 2C 8D 55 F4 8B 45 F8 8B 08 FF 51 0C 8B 55 F4 8D 46 14 E8 ?? ?? ?? ?? 8D 55 F0 8B 45 F8 8B 08 FF 51 10 8B 55 F0 8D 46 18 E8 ?? ?? ?? ?? 83 7E 14 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 46 14 E8 ?? ?? ?? ?? 83 7E 18 00 75 1A 8B C6 E8 ?? ?? ?? ?? 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8D 46 18 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 00 F4 78 D9 14 E9 D1 D4 11 A5 32 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1368_0 {
	meta:
		name = "TActiveScriptSite.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0026 @ClassDestroy"
		altNames = "TBasicActionRequestImpl.Destroy TBasicImageRequestImpl.Destroy TConnectionAdmin.Destroy TMimeAttachHandlerImpl.Destroy TWebRequestFile.Destroy TWebSessionIDsImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_38260_0 {
	meta:
		name = "TSessionItem.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TCollectionItem.Destroy 001b TObject.Free 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1369_0 {
	meta:
		name = "TBasicActionRequestImpl.GetActionName"
		size = 19
		altNames = "TBasicImageRequestImpl.GetImageName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 10 8B 08 FF 51 10 5E 5B C3 }
	condition:
		$1
}

rule function_1370_0 {
	meta:
		name = "TAdapterDispatchParams.GetFailurePage"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TBaseWebPageInfo.GetPageTitle TBasicActionRequestImpl.GetFailurePage THeaderInfo.GetEncodingStyle TRttiInstMethParameter.GetName TRttiIntfMethParameter.GetName TStreamLoader.GetPassword TXMLDataSet.GetDataSetField"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 18 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1371_0 {
	meta:
		name = "TBasicActionRequestImpl.GetHandled"
		size = 5
		altNames = "TDBXMySqlCustomMetaDataReader.IsDefaultCharSetUnicode TDSMethod.IsPublicMethod TWebServerResponse.Sent"
	strings:
		$1 = { 0F B6 40 1C C3 }
	condition:
		$1
}

rule function_1372_0 {
	meta:
		name = "TActionFieldValueImpl.GetFieldName"
		size = 19
		refs = "000c @UStrAsg"
		altNames = "TActionLink.GetFailurePage TAdapterDispatchParams.GetSuccessPage TBaseWebPageInfo.GetPageDescription TBasicActionRequestImpl.GetSuccessPage TComServer.GetHelpFileName THeaderInfo.GetUse TNameContentScriptObject.GetContent TScriptError.GetFileName TStreamLoader.GetUserName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20327_0 {
	meta:
		name = "TClassCreator.GetOwner"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37775_0 {
	meta:
		name = "TScriptManager.GetXMLDocuments"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_37812_0 {
	meta:
		name = "TXMLDocument.GetRowSets"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 14 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1373_0 {
	meta:
		name = "TBasicActionRequestImpl.SetHandled"
		size = 4
		altNames = "TWebServExp.SetBindingType"
	strings:
		$1 = { 88 50 1C C3 }
	condition:
		$1
}

rule function_1374_0 {
	meta:
		name = "TSingleRecordActionRequestImpl.Create"
		size = 532
		refs = "001c @ClassCreate 002d @IntfAddRef 0035 TSingleRecordActionRequestImpl.Create 0048 TBasicActionRequestImpl.Create 004f _Dn_TStringList 0054 TStringList.Create 006d TAbstractAdapterRequest.GetRequest 0072 TWebRequest.GetQueryFields 0089 TWebRequest.GetContentFields 00a0 TWebRequest.GetFiles 0128 Format 015d _DV_TActionFieldValuesImpl 0162 TActionFieldValuesImpl.Create 017d TObject.Free 0183 @HandleFinally 0196 _DV_TAdapterModes 019b TAdapterModes.Create 01bb @LStrArrayClr 01c3 @UStrClr 01cb @IntfClear 01e1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 D4 53 56 57 33 DB 89 5D EC 89 5D D8 89 5D D4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 88 55 F7 89 45 F8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC 33 D2 8B 45 F8 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B 45 F0 8B 08 FF 51 40 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 AB 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 10 FF 12 8B F0 4E 85 F6 0F 8C 8F 00 00 00 46 33 DB 8D 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D8 8B 08 FF 11 8B 45 D8 89 45 DC C6 45 E0 0B 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 D4 8B 08 FF 51 04 8B 45 D4 89 45 E4 C6 45 E8 0B 8D 55 DC B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 F8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8B C8 8B 45 F0 5A 8B 38 FF 57 3C 43 4E 0F 85 74 FF FF FF 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 2C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F8 89 42 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B 45 F8 80 7D F7 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 F8 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 }
	condition:
		$1
}

rule function_1375_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0013 TBasicActionRequestImpl.Destroy 001b TObject.Free 002e @ClassDestroy"
		altNames = "TSingleRecordActionRequestImpl.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 2C E8 ?? ?? ?? ?? 8B 46 30 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1376_0 {
	meta:
		name = "TBasicActionResponseImpl.Create"
		size = 68
		refs = "000b @ClassCreate 001a TAbstractAdapterResponse.Create 0030 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 20 C6 47 0C 02 C6 47 0E 03 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1377_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCacheMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetExecuteStatus TDefaultDBScreenApplication.GetCursor"
	strings:
		$1 = { 0F B6 40 0C C3 }
	condition:
		$1
}

rule function_1378_0 {
	meta:
		name = "TBaseWebPageModuleFactory.GetCreateMode"
		size = 5
		altNames = "TBasicActionResponseImpl.GetHandled"
	strings:
		$1 = { 0F B6 40 0D C3 }
	condition:
		$1
}

rule function_1379_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRespondWith"
		size = 5
		altNames = "TIBSQLMonitorHook.GetEnabled"
	strings:
		$1 = { 0F B6 40 0E C3 }
	condition:
		$1
}

rule function_1380_0 {
	meta:
		name = "TBasicActionResponseImpl.SetExecuteStatus"
		size = 133
		refs = "000e TBasicActionResponseImpl.SetExecuteStatus 001e TBasicActionResponseImpl.GetRespondWith 0034 TBasicActionResponseImpl.GetFailurePage 0041 TBasicActionResponseImpl.RespondWithFailurePage 004d TBasicActionResponseImpl.GetSuccessPage 005a TBasicActionResponseImpl.RespondWithSuccessPage 0074 @UStrArrayClr 007a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 88 53 0C 8B C3 E8 ?? ?? ?? ?? 3C 03 75 38 0F B6 43 0C FE C8 75 19 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 83 7D FC 00 74 20 8B C3 E8 ?? ?? ?? ?? EB 17 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 83 7D F8 00 74 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1381_0 {
	meta:
		name = "TBasicActionResponseImpl.SetHandled"
		size = 4
	strings:
		$1 = { 88 50 0D C3 }
	condition:
		$1
}

rule function_1382_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithComponentPage"
		size = 8
	strings:
		$1 = { 89 50 1C C6 40 0E 02 C3 }
	condition:
		$1
}

rule function_1383_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithPage"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 10 8B D6 E8 ?? ?? ?? ?? C6 43 0E 00 5E 5B C3 }
	condition:
		$1
}

rule function_1384_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithURL"
		size = 23
		refs = "000c @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 18 8B D6 E8 ?? ?? ?? ?? C6 43 0E 01 5E 5B C3 }
	condition:
		$1
}

rule function_1385_0 {
	meta:
		name = "RespondWithPage"
		size = 188
		refs = "000b WebContext 002e TBasicActionResponseImpl.GetRedirectOptions 0034 TestRedirectOptions 0041 _Dn_TStringList 0046 TStringList.Create 0051 RespondWithPage 006a TAbstractAdapterResponse.GetResponse 0076 RedirectToPageName 008b TObject.Free 0091 @HandleFinally 00ae DispatchPageName"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F0 33 DB E8 ?? ?? ?? ?? 8B 10 FF 52 04 85 C0 74 22 E8 ?? ?? ?? ?? 8B 10 FF 52 04 0F B6 40 08 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B D8 84 DB 74 59 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 05 ?? ?? ?? ?? 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B C8 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D0 0F B6 0D ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 5E 5B 59 5D C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_1386_0 {
	meta:
		name = "TBasicActionResponseImpl.HandleResponse"
		size = 241
		refs = "0010 TBasicActionResponseImpl.HandleResponse 001e TBasicActionResponseImpl.GetRespondWith 0039 RaiseActionDoesNotProvideResponse 004d FindDefaultComponentOwnerPageName 0055 RespondWithPage 0066 RaiseActionCantRedirectToBlankURL 006e TAbstractAdapterResponse.GetResponse 008e SafeRedirect 00ac @LStrFromUStr 00d9 @LStrClr 00e1 @UStrClr 00e7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 2C 01 0F 82 91 00 00 00 74 30 FE C8 74 12 FE C8 0F 85 90 00 00 00 E8 ?? ?? ?? ?? E9 86 00 00 00 55 8D 55 F8 8B 45 FC 8B 40 1C E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 6C 8B 45 FC 83 78 18 00 75 05 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B 40 08 85 C0 7E 15 8B 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 52 18 E8 ?? ?? ?? ?? EB 34 8B 45 FC E8 ?? ?? ?? ?? 50 8D 45 F4 8B 55 FC 8B 52 18 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 58 8B 08 FF 51 38 EB 0D 55 8B 45 FC 8B 40 10 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 }
	condition:
		$1
}

rule function_1387_0 {
	meta:
		name = "TBasicActionResponseImpl.GetRedirectOptions"
		size = 7
	strings:
		$1 = { 0F B6 50 14 8B C2 C3 }
	condition:
		$1
}

rule function_1388_0 {
	meta:
		name = "TBasicActionResponseImpl.SetRedirectOptions"
		size = 13
	strings:
		$1 = { 51 88 14 24 0F B6 14 24 88 50 14 5A C3 }
	condition:
		$1
}

rule function_1389_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithFailurePage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithFailurePage 001c TBasicActionResponseImpl.GetFailurePage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.FailureRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1390_0 {
	meta:
		name = "TBasicActionResponseImpl.RespondWithSuccessPage"
		size = 91
		refs = "000c TBasicActionResponseImpl.RespondWithSuccessPage 001c TBasicActionResponseImpl.GetSuccessPage 0026 TBasicActionResponseImpl.RespondWithPage 002d TBasicActionResponseImpl.SuccessRedirect 0036 TBasicActionResponseImpl.SetRedirectOptions 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1391_0 {
	meta:
		name = "TBasicActionResponseImpl.FailureRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.FailureRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 10 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_1392_0 {
	meta:
		name = "TBasicActionResponseImpl.SuccessRedirect"
		size = 136
		refs = "000c TBasicActionResponseImpl.SuccessRedirect 0026 @IntfClear 0033 Supports 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 20 8B 40 10 8B 10 FF 52 18 50 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 FC 8B 10 FF 52 0C 8B D8 EB 07 0F B6 1D ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 00 03 7D D2 79 0B D5 D4 11 A5 34 00 C0 4F 6B B8 53 00 00 00 00 }
	condition:
		$1
}

rule function_1393_0 {
	meta:
		name = "TBasicActionResponseImpl.GetFailurePage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetFailurePage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1394_0 {
	meta:
		name = "TBasicActionResponseImpl.GetSuccessPage"
		size = 19
		refs = "000c TBasicActionRequestImpl.GetSuccessPage"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1395_0 {
	meta:
		name = "GetModes"
		size = 224
		refs = "0014 GetModes 003d TStrings.GetName 004f @UStrCopy 005c SameText 00b2 @UStrArrayClr 00b8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 10 FF 52 14 8B F0 4E 85 F6 7C 6F 46 33 DB 8D 45 F8 50 8D 4D F4 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 34 8D 45 F0 50 8D 4D EC 8B D3 8B 45 FC 8B 38 FF 57 0C 8B 45 EC B9 FF FF FF 7F BA 06 00 00 00 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 08 8B 40 FC 8B 40 04 8B 08 FF 51 38 43 4E 75 94 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 04 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 61 00 6D 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1396_0 {
	meta:
		name = "TAdapterModes.Create"
		size = 111
		refs = "000e @ClassCreate 001f TObject.Create 0026 _Dn_TStringList 002b TStringList.Create 0039 TWebRequest.GetQueryFields 003e GetModes 0047 TWebRequest.GetContentFields 0059 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 89 45 FC 33 D2 8B 45 FC E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 04 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 55 8B C6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 45 FC 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1400_0 {
	meta:
		name = "TAdapterModes.FindAdapterMode"
		size = 260
		refs = "0021 TAdapterModes.FindAdapterMode 0033 @IntfClear 0041 Supports 0075 TStrings.GetName 0080 @UStrEqual 009d ExtractStringValue 00a8 @UStrAsg 00cc @UStrArrayClr 00d4 @UStrClr 00e2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 89 4D F0 8B DA 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 EF 00 8D 45 FC E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 6D 8D 55 F8 8B 45 FC 8B 08 FF 51 0C 8B 45 F4 8B 40 04 8B 10 FF 52 14 8B F0 4E 85 F6 7C 50 46 33 DB 8D 4D E8 8B 45 F4 8B 40 04 8B D3 E8 ?? ?? ?? ?? 8B 45 E8 8B 55 F8 E8 ?? ?? ?? ?? 75 2C 8D 4D E0 8B 45 F4 8B 40 04 8B D3 8B 30 FF 56 0C 8B 45 E0 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F0 E8 ?? ?? ?? ?? C6 45 EF 01 EB 04 43 4E 75 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 EF 5E 5B 8B E5 5D C3 00 00 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1401_0 {
	meta:
		name = "TAbstractWebPageModuleFactory.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0026 @ClassDestroy"
		altNames = "TAdapterActionFieldValuesList.Destroy TAdapterModes.Destroy TLocateParamsList.Destroy TNotifyList.Destroy TScriptObjectFactories.Destroy TWebNotifyContainer.Destroy TWebRequestFiles.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2310_0 {
	meta:
		name = "TWebDispatch.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TPersistent.Destroy 001b TObject.Free 0026 @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 04 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1402_0 {
	meta:
		name = "TBasicImageRequestImpl.Create"
		size = 142
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TBasicImageRequestImpl.Create 0034 TAbstractAdapterRequest.Create 003f @IntfCopy 0049 _DV_TAdapterRequestParamsImpl 004e TAdapterRequestParamsImpl.Create 0066 @IntfClear 006c @HandleFinally 0079 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 10 8B 55 FC E8 ?? ?? ?? ?? 8B 4D FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1405_0 {
	meta:
		name = "TBasicImageResponseImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractAdapterResponse.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19377_0 {
	meta:
		name = "DSAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19457_0 {
	meta:
		name = "DSMetadata.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50321_0 {
	meta:
		name = "TAbstractActiveScriptLanguages.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17073_0 {
	meta:
		name = "TBaseTransportFilterItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9358_0 {
	meta:
		name = "TBinaryField.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TField.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4963_0 {
	meta:
		name = "TCOMAdminCatalog.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5010_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4995_0 {
	meta:
		name = "TCOMAdminCatalogObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20317_0 {
	meta:
		name = "TClassCreator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4922_0 {
	meta:
		name = "TClassRegistryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23795_0 {
	meta:
		name = "TColorLookup.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_41571_0 {
	meta:
		name = "TConnectionIntercept.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdBaseComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5661_0 {
	meta:
		name = "TConversion.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_41071_0 {
	meta:
		name = "TCustomComboBoxStrings.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10453_0 {
	meta:
		name = "TCustomRemoteServer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10328_0 {
	meta:
		name = "TDBByteBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13181_0 {
	meta:
		name = "TDBXAnsiMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14092_0 {
	meta:
		name = "TDBXAnsiStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13162_0 {
	meta:
		name = "TDBXAnsiStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14087_0 {
	meta:
		name = "TDBXBlobSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14081_0 {
	meta:
		name = "TDBXBooleanSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12565_0 {
	meta:
		name = "TDBXClientDriverLoader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TClassRegistryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13481_0 {
	meta:
		name = "TDBXClosedByteReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13570_0 {
	meta:
		name = "TDBXConnectionBuilder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15881_0 {
	meta:
		name = "TDBXConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14158_0 {
	meta:
		name = "TDBXDataExpressMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXMetaDataProvider.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16118_0 {
	meta:
		name = "TDBXDataExpressProviderContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14056_0 {
	meta:
		name = "TDBXDataGeneratedRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14096_0 {
	meta:
		name = "TDBXDataGeneratorException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14097_0 {
	meta:
		name = "TDBXDateSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14104_0 {
	meta:
		name = "TDBXDecimalSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14109_0 {
	meta:
		name = "TDBXDoubleSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14114_0 {
	meta:
		name = "TDBXInt16SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14119_0 {
	meta:
		name = "TDBXInt32SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14124_0 {
	meta:
		name = "TDBXInt64SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14129_0 {
	meta:
		name = "TDBXInt8SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13614_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16184_0 {
	meta:
		name = "TDBXMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14735_0 {
	meta:
		name = "TDBXMethodTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13915_0 {
	meta:
		name = "TDBXNoOpRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXStreamerRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20057_0 {
	meta:
		name = "TDBXServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17160_0 {
	meta:
		name = "TDBXSocketChannel.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_16996_0 {
	meta:
		name = "TDBXStringBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13282_0 {
	meta:
		name = "TDBXStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWideStringValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13931_0 {
	meta:
		name = "TDBXTableRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14134_0 {
	meta:
		name = "TDBXTimeSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14141_0 {
	meta:
		name = "TDBXTimestampSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12932_0 {
	meta:
		name = "TDBXTransaction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12775_0 {
	meta:
		name = "TDBXValueType.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13275_0 {
	meta:
		name = "TDBXWideMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14152_0 {
	meta:
		name = "TDBXWideStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13253_0 {
	meta:
		name = "TDBXWideStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12949_0 {
	meta:
		name = "TDBXWritableValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13719_0 {
	meta:
		name = "TDBXWritableValueList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_29955_0 {
	meta:
		name = "TDCOMConnection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDispatchConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19374_0 {
	meta:
		name = "TDSCustomAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19277_0 {
	meta:
		name = "TDSCustomProxyWriter.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19491_0 {
	meta:
		name = "TDSCustomServerClass.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19833_0 {
	meta:
		name = "TDSHTTPService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSHTTPServerTransport.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19466_0 {
	meta:
		name = "TDSSecurity.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19479_0 {
	meta:
		name = "TDSServerCommandHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19488_0 {
	meta:
		name = "TDSServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19546_0 {
	meta:
		name = "TDSServerMethod.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19565_0 {
	meta:
		name = "TDSServerMethodProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19613_0 {
	meta:
		name = "TDSVoidConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28545_0 {
	meta:
		name = "TDataContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_2294_0 {
	meta:
		name = "TEnumDispatcherAS.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomEnumDispatcher.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17075_0 {
	meta:
		name = "TFactoryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24450_0 {
	meta:
		name = "TGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27300_0 {
	meta:
		name = "TIBValidationService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIBControlAndQueryService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28830_0 {
	meta:
		name = "TISAPIFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28365_0 {
	meta:
		name = "TInterfaceInvoker.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38413_0 {
	meta:
		name = "TInternetExplorer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15233_0 {
	meta:
		name = "TJSONNumber.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONString.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15200_0 {
	meta:
		name = "TJSONPair.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_15220_0 {
	meta:
		name = "TJSONString.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_39880_0 {
	meta:
		name = "TLogLinkedWebNode.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TLinkedWebNode.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50673_0 {
	meta:
		name = "TModuleObj.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponentsEnumerator.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38554_0 {
	meta:
		name = "TShellNameSpace.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38524_0 {
	meta:
		name = "TShellUIHelper.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_38502_0 {
	meta:
		name = "TShellWindows.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_4310_0 {
	meta:
		name = "TStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_45089_0 {
	meta:
		name = "TTeeExportFormat.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_18030_0 {
	meta:
		name = "TTransportFilter.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TFactoryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47580_0 {
	meta:
		name = "TTypeTranslator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_30695_0 {
	meta:
		name = "TWebButton.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebContainedComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_49204_0 {
	meta:
		name = "TWebComponentsStub.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TScriptComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50689_0 {
	meta:
		name = "TWebUserItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50837_0 {
	meta:
		name = "TWideStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_54444_0 {
	meta:
		name = "TXMLDocument.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_55141_0 {
	meta:
		name = "TXSBaseDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_55245_0 {
	meta:
		name = "TXSBaseDuration.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TXSBaseCustomDateTime.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_55209_0 {
	meta:
		name = "TXSDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TRemotable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1406_0 {
	meta:
		name = "TActionFieldValueImpl.Create"
		size = 242
		refs = "0016 @ClassCreate 0025 TActionFieldValueImpl.Create 0035 @UStrAsg 003e _Dn_TObjectList 0043 TObjectList.Create 004d _Dn_TStringList 0052 TStringList.Create 008f TList.Add 00c4 @UStrClr 00ca @HandleFinally 00d9 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FF 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 46 14 8B D3 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 10 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 0C 83 7D 08 00 74 54 8B 45 08 8B 10 FF 52 14 48 85 C0 7C 47 40 89 45 F8 33 DB 8B D3 8B 45 08 8B 08 FF 51 18 85 C0 74 15 8B D3 8B 45 08 8B 08 FF 51 18 8B 56 10 92 E8 ?? ?? ?? ?? EB 18 8D 4D F4 8B D3 8B 45 08 8B 38 FF 57 0C 8B 55 F4 8B 46 0C 8B 08 FF 51 38 43 FF 4D F8 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1407_0 {
	meta:
		name = "TActionFieldValueImpl.Destroy"
		size = 53
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 002e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 10 E8 ?? ?? ?? ?? 8B 46 0C E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1409_0 {
	meta:
		name = "TActionFieldValueImpl.GetFile"
		size = 30
		refs = "000c TList.Get 0012 _Dn_TAbstractWebRequestFile 0017 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 10 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1411_0 {
	meta:
		name = "TActionFieldValueImpl.GetValue"
		size = 93
		refs = "0018 TActionFieldValueImpl.GetValue 0036 @VarFromUStr 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B 43 0C 8B 18 FF 53 0C 8B 55 F4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1412_0 {
	meta:
		name = "TActionFieldValueImpl.GetValueCount"
		size = 9
		altNames = "TWebPageInfoWrapper.GetPageIsPublished TXMLNodeList.GetCount"
	strings:
		$1 = { 8B 40 0C 8B 10 FF 52 14 C3 }
	condition:
		$1
}

rule function_1413_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.Create"
		size = 164
		refs = "000e @ClassCreate 001d @IntfAddRef 0025 TMultiRecordActionRequestImpl.Create 0037 TBasicActionRequestImpl.Create 003e TAbstractAdapterRequest.GetRequest 0047 _DV_TAdapterActionFieldValuesList 004c TAdapterActionFieldValuesList.Create 005f _DV_TAdapterModes 0064 TAdapterModes.Create 007c @IntfClear 0082 @HandleFinally 008f @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D FC 8B DA 8B F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 4D FC 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 2C 8B C6 E8 ?? ?? ?? ?? 8B C8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1415_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.GetFieldValues"
		size = 17
		refs = "0006 TMultiRecordActionRequestImpl.GetFieldValuesList 000b TEnumActionFieldValueRecordsImpl.GetCurrentFieldValues"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_42054_0 {
	meta:
		name = "ChDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b ChDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_42063_0 {
	meta:
		name = "MkDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b MkDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_42076_0 {
	meta:
		name = "RmDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b RmDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_49172_0 {
	meta:
		name = "TCustomAdapterGotoPageAction.GetItemCount"
		size = 17
		refs = "0006 TCustomPagedAdapterAction.GetAdapter 000b TDefaultFieldsPagedAdapter.GetPageCount"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15883_0 {
	meta:
		name = "TDBXConnectionHandler.GetCommandHandle"
		size = 17
		refs = "0006 TDBXConnectionHandler.InvalidOperationError 000b @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_15884_0 {
	meta:
		name = "TDBXConnectionHandler.SetCommandHandle"
		size = 17
		refs = "0006 TDBXConnectionHandler.InvalidOperationError 000b @RaiseExcept"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_18927_0 {
	meta:
		name = "TDirect2DFont.GetColor"
		size = 17
		refs = "0006 TDirect2DFont.GetBrush 000b TDirect2DBrush.GetColor"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_8923_0 {
	meta:
		name = "TFieldDef.AddChild"
		size = 17
		refs = "0006 TFieldDef.GetChildDefs 000b TFieldDefs.AddFieldDef"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_26284_0 {
	meta:
		name = "TIBCustomDataSet.PSInTransaction"
		size = 17
		refs = "0006 TIBCustomDataSet.GetTransaction 000b TIBTransaction.GetInTransaction"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5819_0 {
	meta:
		name = "TListItem.GetHandle"
		size = 17
		refs = "0006 TListItem.GetListView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_28799_0 {
	meta:
		name = "TPath.IsExtendedPrefixed"
		size = 17
		refs = "0006 TPath.GetExtendedPrefix 000b TPath.PrefixExtendsPath"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36452_0 {
	meta:
		name = "TRttiType.GetIsManaged"
		size = 17
		refs = "0006 TRttiType.GetHandle 000b IsManaged"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_36465_0 {
	meta:
		name = "TRttiType.GetTypeData"
		size = 17
		refs = "0006 TRttiType.GetHandle 000b GetTypeData"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_5331_0 {
	meta:
		name = "TTreeNode.GetHandle"
		size = 17
		refs = "0006 TTreeNode.GetTreeView 000b TWinControl.GetHandle"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1416_0 {
	meta:
		name = "MoveValues"
		size = 132
		refs = "0022 TList.Get 002b TList.Add 0060 TList.ExtractItem"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 4D FC 8B DA 8B F0 8B 7D 08 8B 43 0C 8B 55 FC 8B 08 FF 51 38 8B D7 8B 46 10 E8 ?? ?? ?? ?? 8B 53 10 92 E8 ?? ?? ?? ?? 8B D7 8B 46 14 E8 ?? ?? ?? ?? 8B 53 14 92 E8 ?? ?? ?? ?? 8B D7 8B 46 0C 8B 08 FF 51 48 8B D7 8B 46 10 E8 ?? ?? ?? ?? 8B D8 8B D3 8B 46 10 33 C9 E8 ?? ?? ?? ?? 8B D7 8B 46 14 E8 ?? ?? ?? ?? 8B D8 8B D3 8B 46 14 33 C9 E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1417_0 {
	meta:
		name = "NameAndIndex"
		size = 192
		refs = "0012 NameAndIndex 0021 @UStrAsg 0033 Pos 005a @UStrCopy 0062 StrToInt 0072 @UStrDelete 0081 @HandleAnyException 0086 @DoneExcept 009b @UStrClr 00a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B D6 E8 ?? ?? ?? ?? C7 07 FF FF FF FF 8B 13 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 7E 4D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 56 01 8B 03 B9 FF FF FF 7F E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 89 07 8B C3 B9 FF FF FF 7F 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1418_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.Create"
		size = 459
		refs = "0016 @ClassCreate 0026 TEnumActionFieldValueRecordsImpl.Create 0035 _Dn_TObjectList 003a TObjectList.Create 004d @UStrAsg 008b _Dn_TStrings 0090 TObject.InheritsFrom 00bb _Dn_TStringList 00c0 TStringList.Create 00e7 @AsClass 012f _DV_TActionFieldValuesImpl 0134 TActionFieldValuesImpl.Create 0140 TList.Add 0155 TObject.Free 015b @HandleFinally 019b @UStrClr 01b1 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B D9 88 55 FB 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 89 42 08 8B 45 FC 83 C0 04 8B D3 E8 ?? ?? ?? ?? 83 7D 08 00 0F 84 14 01 00 00 8B 45 08 8B 10 FF 52 14 85 C0 0F 8E 04 01 00 00 33 D2 8B 45 08 8B 08 FF 51 18 85 C0 0F 84 F2 00 00 00 33 D2 8B 45 08 8B 08 FF 51 18 8B 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 D3 00 00 00 8B 45 08 8B 10 FF 52 14 48 85 C0 0F 8C DD 00 00 00 40 89 45 EC C7 45 F4 00 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 55 F4 8B 45 08 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B C6 8B 10 FF 52 14 48 85 C0 7C 30 40 89 45 E8 33 DB 8D 4D E4 8B D3 8B C6 8B 38 FF 57 0C 8B 45 E4 50 8B D3 8B C6 8B 08 FF 51 18 8B C8 8B 45 F0 5A 8B 38 FF 57 3C 43 FF 4D E8 75 D6 8B 4D F0 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 52 08 92 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 FF 45 F4 FF 4D EC 0F 85 4B FF FF FF EB 1B 8B 4D 08 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 52 08 92 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 80 7D FB 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 FC 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1419_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.Destroy"
		size = 45
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001b TObject.Free 0026 @ClassDestroy"
		altNames = "TLocateParams.Destroy TScriptGlobalObjects.Destroy TWebModuleFactoryList.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 8B 46 08 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1420_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.FindPopulatedRecord"
		size = 72
		refs = "001a TList.Get 0020 _DV_TActionFieldValuesImpl 0025 @AsClass 002e TActionFieldValuesImpl.GetFieldCount"
	strings:
		$1 = { 53 56 57 55 8B F8 8B 47 08 8B 70 08 4E 85 F6 7C 30 46 33 DB 8B 47 08 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E8 8B C5 E8 ?? ?? ?? ?? 85 C0 7E 07 89 5F 0C B0 01 EB 06 43 4E 75 D3 33 C0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1421_0 {
	meta:
		name = "TCollection.GetCount"
		size = 7
		altNames = "TEnumActionFieldValueRecordsImpl.GetRecordCount TJSONNumber.EstimatedByteSize TWebComponentList.GetCount TWebModuleFactoryList.GetItemCount TWebModuleList.GetItemCount"
	strings:
		$1 = { 8B 40 08 8B 40 08 C3 }
	condition:
		$1
}

rule function_1422_0 {
	meta:
		name = "TAbstractTest.GetEnabled"
		size = 5
		altNames = "TDBXConnection.GetIsOpen TDBXDataExpressProviderContext.GetMarkerIncludedInParameterName TDSClass.IsArrayParameter TEnumActionFieldValueRecordsImpl.GetInIterator TGIFGraphicControlExtension.GetTransparentColorIndex THeaderInfo.GetRequired TParamObject.GetDataType"
	strings:
		$1 = { 0F B6 40 10 C3 }
	condition:
		$1
}

rule function_1423_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetCurrentFieldValues"
		size = 46
		refs = "0017 TList.Get 001d _DV_TActionFieldValuesImpl 0022 @AsClass"
	strings:
		$1 = { 53 56 57 8B D8 8B 73 08 8B 46 08 8B 7B 0C 3B C7 7E 16 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1424_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetEOF"
		size = 13
	strings:
		$1 = { 8B 50 08 8B 52 08 3B 50 0C 0F 9E C0 C3 }
	condition:
		$1
}

rule function_1425_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetFirstRecord"
		size = 22
		refs = "000b TEnumActionFieldValueRecordsImpl.GetEOF"
	strings:
		$1 = { 53 8B D8 33 C0 89 43 0C 8B C3 E8 ?? ?? ?? ?? 34 01 88 43 10 5B C3 }
	condition:
		$1
}

rule function_1426_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetNextRecord"
		size = 20
		refs = "0009 TEnumActionFieldValueRecordsImpl.GetEOF"
	strings:
		$1 = { 53 8B D8 FF 43 0C 8B C3 E8 ?? ?? ?? ?? 34 01 88 43 10 5B C3 }
	condition:
		$1
}

rule function_1427_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.EndIterator"
		size = 10
	strings:
		$1 = { C6 40 10 00 33 D2 89 50 0C C3 }
	condition:
		$1
}

rule function_1428_0 {
	meta:
		name = "TEnumActionFieldValueRecordsImpl.GetRecord"
		size = 19
	strings:
		$1 = { 8B 48 08 3B 51 08 0F 9C C1 84 C9 74 03 89 50 0C 8B C1 C3 }
	condition:
		$1
}

rule function_1429_0 {
	meta:
		name = "TActionFieldValuesImpl.ExpandRecordKeys"
		size = 105
		refs = "000d TActionFieldValuesImpl.ExpandRecordKeys 0043 ExtractParamNameValues 0058 @UStrClr 005e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 04 8B 10 FF 52 14 85 C0 7E 24 8B 43 08 8B 10 FF 52 14 85 C0 75 18 8D 4D FC 33 D2 8B 43 04 8B 30 FF 56 0C 8B 45 FC 8B 53 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1430_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyCount"
		size = 20
		refs = "0006 TActionFieldValuesImpl.ExpandRecordKeys"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 43 08 8B 10 FF 52 14 5B C3 }
	condition:
		$1
}

rule function_1431_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyName"
		size = 25
		refs = "0011 TStrings.GetName"
		altNames = "TLocateParams.GetParamName"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_12744_0 {
	meta:
		name = "TDBXProperties.GetValue"
		size = 25
		refs = "0011 TStrings.GetValue"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B CF 8B D6 8B 43 08 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1432_0 {
	meta:
		name = "TActionFieldValuesImpl.GetRecordKeyValue"
		size = 93
		refs = "0018 TActionFieldValuesImpl.GetRecordKeyValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B 43 08 8B 18 FF 53 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_10276_0 {
	meta:
		name = "TLocateParams.GetParamValue"
		size = 93
		refs = "0018 TLocateParams.GetParamValue 0036 ExtractStringValue 004b @UStrClr 0051 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 DB 89 5D F4 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 4D F4 8B D6 8B 43 08 8B 18 FF 53 0C 8B 45 F4 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1433_0 {
	meta:
		name = "NewStrings"
		size = 36
		refs = "0007 _Dn_TStringList 000c TStringList.Create 001b TList.Add"
	strings:
		$1 = { 55 8B EC 53 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 08 8B 40 FC 8B D3 E8 ?? ?? ?? ?? 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_1434_0 {
	meta:
		name = "FindAdapterStrings"
		size = 94
		refs = "0020 NewStrings 0051 _Dn_TStrings 0056 @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 8B F0 8B 45 08 8B 40 F8 8B D6 8B 08 FF 51 54 8B D8 83 FB FF 75 27 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B C8 8B 45 08 8B 40 F8 8B D6 8B 18 FF 53 3C 8B 45 08 8B 40 F8 8B 10 FF 52 14 8B D8 4B 8B 45 08 8B 40 F8 8B D3 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1435_0 {
	meta:
		name = "FindAdapterRecordStrings"
		size = 108
		refs = "0034 NewStrings 005a _Dn_TStrings 005f @AsClass"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 85 F6 7C 57 8B C3 8B 10 FF 52 14 85 C0 7E 2B 33 D2 8B C3 8B 08 FF 51 18 85 C0 75 1E 8B C3 8B 10 FF 52 44 EB 15 8B 45 08 50 E8 ?? ?? ?? ?? 59 8B C8 33 D2 8B C3 8B 38 FF 57 3C 8B C3 8B 10 FF 52 14 3B F0 7D E0 8B D6 8B C3 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 8B C3 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1436_0 {
	meta:
		name = "ExtractRecordIndex"
		size = 188
		refs = "0014 ExtractRecordIndex 002d Pos 0054 @UStrCopy 005c StrToInt 006d @UStrDelete 007c @HandleAnyException 0081 @DoneExcept 0096 @UStrClr 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 FC FF FF FF FF 8B 16 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7E 4E 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 50 8D 53 01 8B 06 B9 FF FF FF 7F E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 89 45 FC 8B C6 B9 FF FF FF 7F 8B D3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 FC 5F 5E 5B 59 59 5D C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2E 00 00 00 }
	condition:
		$1
}

rule function_1437_0 {
	meta:
		name = "ExtractAdapterName"
		size = 84
		refs = "000c @UStrAsg 0013 ExtractAdapterName 0018 Pos 002e @UStrCopy 003c @UStrDelete"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B C7 33 D2 E8 ?? ?? ?? ?? 8B 16 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 7E 1E 57 8B CB 49 8B 06 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C6 8B CB BA 01 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B C3 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 }
	condition:
		$1
}

rule function_1438_0 {
	meta:
		name = "TAdapterActionFieldValuesList.Create"
		size = 1244
		refs = "001f @ClassCreate 0030 TAdapterActionFieldValuesList.Create 0040 TObject.Create 0049 _Dn_TObjectList 004e TObjectList.Create 0079 NewStrings 0085 TWebRequest.GetQueryFields 0097 TWebRequest.GetContentFields 00a9 TWebRequest.GetFiles 011e Format 0179 @UStrLAsg 0186 TStrings.GetName 019c @UStrCopy 01a9 SameText 01bf @UStrDelete 01ce ExtractAdapterName 01d6 ExtractRecordIndex 0254 @UStrEqual 028b FindAdapterStrings 0294 FindAdapterRecordStrings 02c7 ExtractStringValue 02f9 @UStrCat3 038b _DV_TEnumActionFieldValueRecordsImpl 0390 TEnumActionFieldValueRecordsImpl.Create 039c TList.Add 03c0 _Dn_TStrings 03c5 @AsClass 0407 TObject.Free 040d @HandleFinally 0429 @UStrArrayClr 0436 @LStrArrayClr 043e @UStrClr 0461 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 B9 0C 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 4D E0 88 55 E7 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B 45 E8 E8 ?? ?? ?? ?? B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 89 42 04 B1 01 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 55 E8 ?? ?? ?? ?? 59 89 45 DC 8B 45 E0 E8 ?? ?? ?? ?? 8B D0 8B 45 DC 8B 08 FF 51 40 8B 45 E0 E8 ?? ?? ?? ?? 8B D0 8B 45 DC 8B 08 FF 51 40 8B 45 E0 E8 ?? ?? ?? ?? 85 C0 0F 84 8F 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? 8B 10 FF 12 8B F0 4E 85 F6 7C 7C 46 33 DB 8D 45 D0 50 8B 45 E0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 BC 8B 08 FF 11 8B 45 BC 89 45 C0 C6 45 C4 0B 8B 45 E0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8D 55 B8 8B 08 FF 51 04 8B 45 B8 89 45 C8 C6 45 CC 0B 8D 55 C0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D0 50 8B 45 E0 E8 ?? ?? ?? ?? 8B D3 8B 08 FF 51 04 8B C8 8B 45 DC 5A 8B 38 FF 57 3C 43 4E 75 87 55 E8 ?? ?? ?? ?? 59 89 45 F8 8B 45 DC 8B 10 FF 52 14 8B F0 4E 85 F6 0F 8C 17 02 00 00 46 33 DB C6 45 DB 00 C6 45 DA 00 C6 45 D9 00 83 CF FF 8D 45 F0 33 D2 E8 ?? ?? ?? ?? 8D 4D F4 8B D3 8B 45 DC E8 ?? ?? ?? ?? 8D 45 B4 50 B9 05 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 B4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 30 8D 45 F4 B9 05 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? C6 45 DB 01 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B F8 E9 92 00 00 00 8D 45 B0 50 B9 06 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 B0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 2D C6 45 DA 01 8D 45 F4 B9 06 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B F8 EB 3E 8D 45 AC 50 B9 02 00 00 00 BA 01 00 00 00 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 AC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 19 C6 45 D9 01 8D 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8B F8 0F B6 45 DB 0A 45 DA 75 0A 80 7D D9 00 0F 84 EA 00 00 00 55 8B 45 F0 E8 ?? ?? ?? ?? 59 55 8B D7 E8 ?? ?? ?? ?? 59 89 45 D4 0F B6 45 DB 0A 45 D9 74 5A 8D 45 EC 50 8B 45 F4 89 45 C0 C6 45 C4 11 8D 4D A4 8B D3 8B 45 DC 8B 38 FF 57 0C 8B 45 A4 8D 55 A8 E8 ?? ?? ?? ?? 8B 45 A8 89 45 C8 C6 45 CC 11 8D 55 C0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D DB 00 74 6C 8D 45 EC BA ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? EB 5A 8D 45 EC 50 8B 45 F0 89 45 C0 C6 45 C4 11 8D 4D 9C 8B D3 8B 45 DC 8B 38 FF 57 0C 8B 45 9C 8D 55 A0 E8 ?? ?? ?? ?? 8B 45 A0 89 45 C8 C6 45 CC 11 8D 55 C0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7D DA 00 74 12 8D 45 EC 50 BA ?? ?? ?? ?? 8B 4D EC 58 E8 ?? ?? ?? ?? 8B D3 8B 45 DC 8B 08 FF 51 18 8B C8 8B 55 EC 8B 45 D4 8B 38 FF 57 3C 43 4E 0F 85 EC FD FF FF 8B 45 F8 8B 10 FF 52 14 85 C0 75 1E 6A 00 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 8B 52 04 92 E8 ?? ?? ?? ?? EB 54 8B 45 F8 8B 10 FF 52 14 8B F0 4E 85 F6 7C 45 46 33 DB 8B D3 8B 45 F8 8B 08 FF 51 18 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 4D 98 8B D3 8B 45 F8 8B 38 FF 57 0C 8B 4D 98 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 8B 52 04 92 E8 ?? ?? ?? ?? 43 4E 75 BE 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 98 BA 08 00 00 00 E8 ?? ?? ?? ?? 8D 45 B8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 EC BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C9 8B 45 E8 80 7D E7 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B 45 E8 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 25 00 73 00 3D 00 25 00 73 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 5F 00 5F 00 6F 00 76 00 2E 00 00 00 B0 04 02 00 FF FF FF FF 06 00 00 00 5F 00 5F 00 6B 00 65 00 79 00 2E 00 00 00 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 5F 00 5F 00 00 00 00 00 }
	condition:
		$1
}

rule function_1440_0 {
	meta:
		name = "TAdapterActionFieldValuesList.GetCurrentFieldValuesList"
		size = 46
		refs = "0017 TList.Get 001d _DV_TEnumActionFieldValueRecordsImpl 0022 @AsClass"
	strings:
		$1 = { 53 56 57 8B D8 8B 73 04 8B 46 08 8B 7B 08 3B C7 7E 16 8B D7 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1441_0 {
	meta:
		name = "TMultiRecordActionRequestImpl.GetFieldValuesList"
		size = 9
		refs = "0004 TAdapterActionFieldValuesList.GetCurrentFieldValuesList"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50598_0 {
	meta:
		name = "TStringsObj.SetCommaText"
		size = 9
		refs = "0004 TStrings.SetCommaText"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_50600_0 {
	meta:
		name = "TStringsObj.SetValues"
		size = 9
		refs = "0004 TStrings.SetValue"
	strings:
		$1 = { 8B 40 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1442_0 {
	meta:
		name = "TAdapterActionFieldValuesList.LocateActionFieldValuesOfAdapter"
		size = 216
		refs = "0019 TAdapterActionFieldValuesList.LocateActionFieldValuesOfAdapter 002b @IntfClear 0040 Supports 0067 TList.Get 006d _DV_TEnumActionFieldValueRecordsImpl 0072 @AsClass 0083 SameText 00b1 @UStrClr 00b7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D FC 89 4D F8 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F7 00 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 85 C0 74 03 83 E8 D0 E8 ?? ?? ?? ?? 84 C0 74 50 8D 55 FC 8B 45 F8 8B 08 FF 51 0C 8B 47 04 8B 70 08 4E 85 F6 7C 3A 46 33 DB 8B 47 04 8B D3 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 8B 40 04 8B 55 FC E8 ?? ?? ?? ?? 84 C0 74 09 C6 45 F7 01 89 5F 08 EB 04 43 4E 75 C9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 0F B6 45 F7 5F 5E 5B 8B E5 5D C3 48 5B B1 ED 96 F3 D3 11 A4 2A 00 C0 4F 6B B8 53 }
	condition:
		$1
}

rule function_1445_0 {
	meta:
		name = "GetNewConnectionName"
		size = 373
		refs = "001e GetNewConnectionName 002d _DV_TNewConnectionForm 0032 TCustomForm.Create 009b TCustomForm.GetLeft 00ab TCustomForm.SetLeft 00b2 TCustomForm.GetTop 00bf TCustomForm.SetTop 00de TControl.GetText 0104 @UStrAsg 013b TObject.Free 0141 @HandleFinally 015d @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 33 DB 89 5D E4 89 5D E8 89 5D EC 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 8B 80 98 03 00 00 8B 80 AC 02 00 00 8B D6 8B 08 FF 51 08 8B 45 F0 8B 80 98 03 00 00 8B 80 AC 02 00 00 33 D2 8B 08 FF 51 48 8B 55 F8 8B 12 8B 45 F0 8B B0 98 03 00 00 8B 86 AC 02 00 00 8B 08 FF 51 54 8B D0 8B C6 8B 08 FF 91 F0 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B D0 81 C2 82 00 00 00 8B 45 F0 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 83 C2 32 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 F0 8B 10 FF 92 10 01 00 00 48 75 55 8D 55 EC 8B 45 F0 8B 80 9C 03 00 00 E8 ?? ?? ?? ?? 83 7D EC 00 74 3E C6 45 F7 01 8D 55 E8 8B 45 F0 8B 80 9C 03 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 08 E8 ?? ?? ?? ?? 8D 55 E4 8B 45 F0 8B 80 98 03 00 00 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F8 E8 ?? ?? ?? ?? EB 04 C6 45 F7 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 0F B6 45 F7 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1446_0 {
	meta:
		name = "TConnEditForm.HelpButtonClick"
		size = 21
		refs = "0002 Application 0010 TApplication.HelpContext"
		altNames = "TDataBindForm.HelpBtnClick TDriverSettingsForm.HelpBtnClick TFieldEditForm.HelpBtnClick TIBUpdateSQLEditForm.HelpButtonClick TMessageForm.HelpButtonClick TNewConnectionForm.HelpBtnClick TNewDataSnapStandaloneAppForm.HelpButtonClick TSQLEditForm.HelpButtonClick TSelectDirDlg.HelpButtonClick TWideSQLEditForm.HelpButtonClick"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 8B 12 8B 80 68 01 00 00 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1449_0 {
	meta:
		name = "EditConnectionString"
		size = 432
		refs = "0023 EditConnectionString 0033 Application 003c _DV_TConnEditForm 0041 TCustomForm.Create 005e SEditConnectionStringTitle 0063 LoadResString 0079 DotSep 00a6 Format 00b1 TControl.SetText 00c2 GetPropInfo 00d2 GetUnicodeStrProp 00dd @WStrFromUStr 00eb TConnEditForm.Edit 00f6 @WStrEqual 0103 @UStrFromWStr 010f SetUnicodeStrProp 0128 TObject.Free 012e @HandleFinally 0145 @UStrClr 0152 @UStrArrayClr 0167 @WStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 C0 53 56 57 33 D2 89 55 C0 89 55 E8 89 55 E4 89 55 FC 89 55 F8 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 F3 00 8B 0D ?? ?? ?? ?? 8B 09 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 8D 55 E4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E4 50 8B 43 04 8B 40 08 89 45 C4 C6 45 C8 11 A1 ?? ?? ?? ?? 8B 00 89 45 CC C6 45 D0 11 8B 43 08 89 45 D4 C6 45 D8 11 B8 ?? ?? ?? ?? 89 45 DC C6 45 E0 11 8D 55 C4 B9 03 00 00 00 58 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 EC E8 ?? ?? ?? ?? 8B 03 83 C0 B8 8B 00 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 4D F4 8B FB 8B C7 8B D6 E8 ?? ?? ?? ?? 8D 45 F8 8B 55 F4 E8 ?? ?? ?? ?? 8D 4D FC 8B 55 F8 8B 45 EC E8 ?? ?? ?? ?? 8B 45 FC 8B 55 F8 E8 ?? ?? ?? ?? 74 1B 8D 45 C0 8B 55 FC E8 ?? ?? ?? ?? 8B 4D C0 8B C7 8B D6 E8 ?? ?? ?? ?? C6 45 F3 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CE 0F B6 45 F3 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 10 00 00 00 43 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 69 00 6F 00 6E 00 53 00 74 00 72 00 69 00 6E 00 67 00 00 00 00 00 }
	condition:
		$1
}

rule function_1450_0 {
	meta:
		name = "TConnEditForm.Edit"
		size = 712
		refs = "0021 @WStrAddRef 0029 TConnEditForm.Edit 0039 @WStrAsg 0056 Pos 006f @WStrCopy 007a @UStrFromWStr 0085 ExtractFilePath 0091 DataLinkDir 009e @UStrCat 00a7 @UStrEqual 00b4 ExtractFileName 00c2 TControl.SetText 0106 TConnEditForm.SourceButtonClick 0137 TControl.GetText 0141 @WStrFromUStr 01b0 @UStrCatN 01dc @UStrCat3 01ef @WStrClr 0204 @UStrClr 0221 @UStrArrayClr 0269 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 07 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 8B F1 89 55 FC 8B D8 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 8B 55 FC E8 ?? ?? ?? ?? B2 01 8B 83 98 03 00 00 8B 08 FF 91 F0 00 00 00 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 75 7B 8D 45 F4 50 B9 04 01 00 00 BA 0B 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8D 45 F8 E8 ?? ?? ?? ?? 8D 55 F0 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F0 50 8D 45 EC E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 58 E8 ?? ?? ?? ?? 75 1B 8D 55 E8 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 E8 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? EB 39 8B 55 F8 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? EB 29 8D 45 E4 8B 55 FC E8 ?? ?? ?? ?? 8B 55 E4 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? B2 01 8B 83 9C 03 00 00 8B 08 FF 91 F0 00 00 00 33 D2 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 10 01 00 00 48 0F 85 D8 00 00 00 8B 83 9C 03 00 00 8B 10 FF 92 EC 00 00 00 84 C0 74 1D 8D 55 E0 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 8B 55 E0 8B C6 E8 ?? ?? ?? ?? E9 A9 00 00 00 8D 55 DC 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 83 7D DC 00 0F 84 8A 00 00 00 8D 55 D4 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 8B 45 D4 8D 55 D8 E8 ?? ?? ?? ?? 83 7D D8 00 75 3F 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? FF 75 CC 68 ?? ?? ?? ?? 8D 55 C8 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? FF 75 C8 8D 45 D0 BA 04 00 00 00 E8 ?? ?? ?? ?? 8B 55 D0 8B C6 E8 ?? ?? ?? ?? EB 33 8D 55 C0 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 8B 45 C0 50 8D 45 C4 BA ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 55 C4 8B C6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 C4 E8 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 BA 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB 91 5E 5B 8B E5 5D C3 00 00 00 14 00 00 00 46 00 49 00 4C 00 45 00 20 00 4E 00 41 00 4D 00 45 00 3D 00 00 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 5C 00 00 00 B0 04 02 00 FF FF FF FF 0A 00 00 00 46 00 49 00 4C 00 45 00 20 00 4E 00 41 00 4D 00 45 00 3D 00 00 00 00 00 }
	condition:
		$1
}

rule function_1451_0 {
	meta:
		name = "TConnEditForm.FormCreate"
		size = 36
		refs = "000b TControl.SetHelpContext 001e GetDataLinkFiles"
	strings:
		$1 = { 53 8B D8 BA 86 6A 00 00 8B C3 E8 ?? ?? ?? ?? 8B 83 A0 03 00 00 8B 80 AC 02 00 00 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1453_0 {
	meta:
		name = "TConnEditForm.BrowseClick"
		size = 151
		refs = "0010 TConnEditForm.BrowseClick 0024 TControl.GetText 002f @WStrFromUStr 003a TWinControl.GetHandle 0043 PromptDataLinkFile 004e @UStrFromWStr 005c TControl.SetText 0071 @UStrClr 007e @WStrArrayClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 5A E8 ?? ?? ?? ?? 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 A0 03 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1454_0 {
	meta:
		name = "TConnEditForm.BuildClick"
		size = 151
		refs = "0010 TConnEditForm.BuildClick 0024 TControl.GetText 002f @WStrFromUStr 003a TWinControl.GetHandle 0043 PromptDataSource 004e @UStrFromWStr 005c TControl.SetText 0071 @UStrClr 007e @WStrArrayClr 008c @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8B C3 E8 ?? ?? ?? ?? 8D 4D F8 5A E8 ?? ?? ?? ?? 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 83 A8 03 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1455_0 {
	meta:
		name = "TConnEditForm.SourceButtonClick"
		size = 213
		refs = "0032 EnabledColor 0039 TControl.SetColor 00be TCustomForm.SetActiveControl"
	strings:
		$1 = { 53 56 8B D8 8B 83 98 03 00 00 8B 10 FF 92 EC 00 00 00 8B D0 8B 83 A0 03 00 00 8B 08 FF 51 74 8B B3 A0 03 00 00 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 14 85 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 83 A0 03 00 00 8B 10 FF 52 5C 8B D0 8B 83 A4 03 00 00 8B 08 FF 51 74 8B 83 9C 03 00 00 8B 10 FF 92 EC 00 00 00 8B D0 8B 83 A8 03 00 00 8B 08 FF 51 74 8B B3 A8 03 00 00 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 14 85 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 83 A8 03 00 00 8B 10 FF 52 5C 8B D0 8B 83 AC 03 00 00 8B 08 FF 51 74 8B 83 A0 03 00 00 8B 10 FF 52 5C 84 C0 74 10 8B 93 A0 03 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B 93 A8 03 00 00 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1460_0 {
	meta:
		name = "CreateADOObject"
		size = 100
		refs = "0010 @IntfClear 0016 CreateADOObject 0020 CoCreateInstance 0032 SADOCreateError 0039 _Dn_Exception 003e Exception.CreateRes 0043 @RaiseExcept 004a OleCheck"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 D9 7D FE 8B C6 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 05 6A 00 53 E8 ?? ?? ?? ?? DB E2 D9 6D FE 3D 54 01 04 80 75 19 8B 0D ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 5E 5B 59 5D C3 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_1461_0 {
	meta:
		name = "ADOTypeToFieldType"
		size = 550
		refs = "001e ADOTypeToFieldType"
	strings:
		$1 = { 55 8B EC 83 F8 48 0F 8F 1A 01 00 00 0F 84 EE 01 00 00 83 F8 40 0F 87 05 02 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3D 89 00 00 00 7F 3D 0F 84 95 00 00 00 83 C0 80 83 F8 08 0F 87 E1 00 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3D CA 00 00 00 7F 1D 74 65 2D 8A 00 00 00 74 7A 48 0F 84 83 00 00 00 83 E8 3D 74 4A 48 74 53 E9 92 00 00 00 2D CB 00 00 00 74 4B 48 74 54 48 74 49 E9 80 00 00 00 33 C0 EB 7E B0 02 EB 7A B0 03 EB 76 B0 19 EB 72 B0 04 EB 6E B0 06 EB 6A B0 08 EB 66 B0 05 EB 62 B0 09 EB 5E B0 0A EB 5A B0 0B EB 56 B0 17 EB 52 B0 01 EB 4E B0 26 EB 4A B0 18 EB 46 B0 10 EB 42 B0 27 EB 3E B0 0F EB 3A B0 0C EB 36 B0 0D EB 32 B0 1D EB 2E B0 20 EB 2A B0 21 EB 26 B0 22 EB 22 B0 23 EB 1E 80 7D 08 00 74 12 83 F9 04 7F 05 83 FA 13 7E 04 B0 25 EB 0A B0 08 EB 06 B0 06 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule function_1462_0 {
	meta:
		name = "FieldTypeToADOType"
		size = 498
		refs = "0012 FieldTypeToADOType 01a1 SNoMatchingADOType 01a6 LoadResString 01b3 FieldTypeNames 01c8 DatabaseErrorFmt 01df @UStrClr 01e5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 D2 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 C3 83 F8 27 0F 87 73 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 DB E9 F8 00 00 00 BB C8 00 00 00 E9 EE 00 00 00 BB CA 00 00 00 E9 E4 00 00 00 BB 02 00 00 00 E9 DA 00 00 00 BB 03 00 00 00 E9 D0 00 00 00 BB 12 00 00 00 E9 C6 00 00 00 BB 0B 00 00 00 E9 BC 00 00 00 BB 05 00 00 00 E9 B2 00 00 00 BB 06 00 00 00 E9 A8 00 00 00 BB 85 00 00 00 E9 9E 00 00 00 BB 86 00 00 00 E9 94 00 00 00 BB 87 00 00 00 E9 8A 00 00 00 BB 80 00 00 00 E9 80 00 00 00 BB CC 00 00 00 EB 79 BB C9 00 00 00 EB 72 BB CB 00 00 00 EB 6B BB CD 00 00 00 EB 64 BB 81 00 00 00 EB 5D BB 82 00 00 00 EB 56 BB 14 00 00 00 EB 4F BB 0C 00 00 00 EB 48 BB 0D 00 00 00 EB 41 BB 09 00 00 00 EB 3A BB 48 00 00 00 EB 33 6A 00 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 0F B6 C3 8B 15 ?? ?? ?? ?? 8B 04 82 89 45 F4 C6 45 F8 11 8D 55 F4 33 C9 58 E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1463_0 {
	meta:
		name = "StringToVarArray"
		size = 237
		refs = "001f @UStrAddRef 0027 StringToVarArray 004a @InternalUStrFromLStr 0075 VarArrayCreate 0080 @OleVarFromVar 0088 VarArrayLock 00a2 Move 00b7 VarArrayUnlock 00bd @HandleFinally 00d4 @VarClr 00dc @UStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 33 C9 89 4D E8 89 4D EC 89 4D F0 89 4D F4 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 85 C0 74 05 83 E8 04 8B 00 8B D8 8D 45 E8 50 33 C0 89 45 E0 8B C3 48 89 45 E4 8D 45 E0 66 B9 11 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 55 E8 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D0 8B 45 FC 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1464_0 {
	meta:
		name = "VarDataSize"
		size = 92
		refs = "0007 VarIsNull 0018 VarIsArray 0028 VarArrayHighBound"
	strings:
		$1 = { 53 51 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 06 83 C8 FF 5A 5B C3 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0F 8B C3 BA 01 00 00 00 E8 ?? ?? ?? ?? 40 EB 2A 66 83 3B 08 75 1F 8D 43 08 8B 00 89 04 24 8B 04 24 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 75 0A 83 C8 FF EB 05 B8 10 00 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1465_0 {
	meta:
		name = "OleEnumToOrd"
		size = 59
	strings:
		$1 = { 55 8B EC 53 56 57 8B DA 85 DB 78 07 8B 34 98 4B 56 79 F9 8B C4 8B F2 85 F6 7C 0E 46 33 FF 3B 08 74 0A 47 83 C0 04 4E 75 F5 8B FA 47 8B C7 8B 7D F4 8B 75 F8 8B 5D FC 8B E5 5D C3 }
	condition:
		$1
}

rule function_1466_0 {
	meta:
		name = "GetStates"
		size = 104
		refs = "0009 GetStates 0013 ObjectStateValues"
	strings:
		$1 = { 53 56 57 51 8B F8 0F B6 05 ?? ?? ?? ?? 88 04 24 B3 01 BE ?? ?? ?? ?? 85 3E 74 1D 8B C3 3C 07 77 17 83 E0 7F 8B D4 8B CA 83 E1 03 2B D1 03 C9 03 C9 03 C9 03 C1 0F AB 02 43 83 C6 04 80 FB 05 75 D6 0F B6 05 ?? ?? ?? ?? 3A 04 24 75 0A 0F B6 05 ?? ?? ?? ?? 88 04 24 0F B6 04 24 5A 5F 5E 5B C3 00 00 00 00 01 00 00 00 }
	condition:
		$1
}

rule function_1467_0 {
	meta:
		name = "ExecuteOptionsToOrd"
		size = 68
		refs = "000b ExecuteOptionsToOrd 0017 ExecuteOptionValues"
	strings:
		$1 = { 53 56 51 88 04 24 33 F6 0F B6 05 ?? ?? ?? ?? 3A 04 24 74 26 33 C0 BA ?? ?? ?? ?? 8B C8 80 F9 07 77 0A 83 E1 7F 0F B6 1C 24 0F A3 CB 73 04 8B 0A 03 F1 40 83 C2 04 3C 04 75 E1 8B C6 5A 5E 5B C3 00 00 00 00 }
	condition:
		$1
}

rule function_1468_0 {
	meta:
		name = "OrdToExecuteOptions"
		size = 84
		refs = "0009 OrdToExecuteOptions 0017 ExecuteOptionValues"
	strings:
		$1 = { 53 56 57 51 8B F8 0F B6 05 ?? ?? ?? ?? 88 04 24 85 FF 74 31 33 DB BE ?? ?? ?? ?? 85 3E 74 1D 8B C3 3C 07 77 17 83 E0 7F 8B D4 8B CA 83 E1 03 2B D1 03 C9 03 C9 03 C9 03 C1 0F AB 02 43 83 C6 04 80 FB 04 75 D6 0F B6 04 24 5A 5F 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1469_0 {
	meta:
		name = "ExtractFieldName"
		size = 81
		refs = "0012 @WStrLen 002c @WStrCopy"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B F0 8B 1F EB 01 43 8B C6 E8 ?? ?? ?? ?? 3B D8 7F 08 66 83 7C 5E FE 3B 75 EC 55 8B CB 2B 0F 8B 17 8B C6 E8 ?? ?? ?? ?? 8B C6 85 C0 74 07 83 E8 04 8B 00 D1 E8 3B C3 7C 09 66 83 7C 5E FE 3B 75 01 43 89 1F 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1470_0 {
	meta:
		name = "GetFilterStr"
		size = 696
		refs = "0027 @VarAddRef 002f GetFilterStr 003d @WStrClr 004a @WStrLAsg 0055 @WStrFromUStr 0062 Pos 0083 WideFormat 0096 VarIsNull 00a2 VarIsClear 00b3 @VarFromUStr 0100 @VarCmpNE 010d @VarCopy 0119 @VarFromWChar 0124 @VarAdd 0147 @VarToUStr 01a4 VarToWideStr 01e3 @UStrClr 01ec Variant 01f6 @FinalizeArray 0206 @VarClr 0213 @WStrArrayClr 0219 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 10 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D E0 A5 A5 A5 A5 8B D9 8B F0 8D 45 E0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F8 8B 56 3C E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 28 8D 45 DC 50 8B 45 F8 89 45 D4 C6 45 D8 0F 8D 55 D4 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 DC 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 84 C0 75 0C 8D 45 E0 E8 ?? ?? ?? ?? 84 C0 74 12 8D 45 E0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 BC 00 00 00 0F B6 46 44 FE C8 74 27 04 F8 2C 03 72 0F 04 F5 2C 02 72 1B 2C 0D 74 17 E9 9F 00 00 00 8D 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 8D 00 00 00 84 DB 74 51 8D 45 C4 33 D2 E8 ?? ?? ?? ?? 8D 55 C4 8D 45 E0 E8 ?? ?? ?? ?? 74 3A 8D 55 E0 8D 45 B4 E8 ?? ?? ?? ?? 8D 45 A4 66 BA 2A 00 E8 ?? ?? ?? ?? 8D 55 A4 8D 45 B4 E8 ?? ?? ?? ?? 8D 55 B4 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 A0 8D 55 E0 E8 ?? ?? ?? ?? 8B 55 A0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 0F 8D 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8D 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 50 8B 45 F8 89 45 80 C6 45 84 0F 8B 45 FC 89 45 88 C6 45 8C 0F 8B 45 F4 89 45 90 C6 45 94 0F 8D 95 7C FF FF FF 8D 45 E0 E8 ?? ?? ?? ?? 8B 85 7C FF FF FF 89 45 98 C6 45 9C 0F 8D 55 80 B9 03 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 7C FF FF FF E8 ?? ?? ?? ?? 8D 45 A0 E8 ?? ?? ?? ?? 8D 45 A4 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B5 5F 5E 5B 8B E5 5D C2 04 00 02 00 00 00 3D 00 00 00 02 00 00 00 20 00 00 00 08 00 00 00 5B 00 25 00 73 00 5D 00 00 00 00 00 B0 04 02 00 FF FF FF FF 04 00 00 00 4E 00 75 00 6C 00 6C 00 00 00 00 00 02 00 00 00 23 00 00 00 0C 00 00 00 20 00 6C 00 69 00 6B 00 65 00 20 00 00 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 27 00 00 00 02 00 00 00 27 00 00 00 1C 00 00 00 28 00 25 00 73 00 25 00 73 00 25 00 73 00 25 00 73 00 25 00 32 00 3A 00 73 00 29 00 00 00 00 00 }
	condition:
		$1
}

rule function_1471_0 {
	meta:
		name = "PropertyExists"
		size = 202
		refs = "0017 PropertyExists 002c @CheckAutoResult 003d @WStrClr 0046 @IntfClear 0053 @OleVarFromInt 0082 @WStrEqual 00a5 @VarClr 00bb @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 56 8B 06 FF 50 1C E8 ?? ?? ?? ?? 8B 5D FC 4B 83 FB 00 7C 59 8D 45 F8 E8 ?? ?? ?? ?? 50 8D 45 F4 E8 ?? ?? ?? ?? 50 8D 45 E4 8B D3 B1 FC E8 ?? ?? ?? ?? FF 75 F0 FF 75 EC FF 75 E8 FF 75 E4 56 8B 06 FF 50 28 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 45 F8 8B D7 E8 ?? ?? ?? ?? 75 04 B3 01 EB 08 4B 83 FB FF 75 A7 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1472_0 {
	meta:
		name = "FieldListCheckSum"
		size = 66
		refs = "000c TFields.GetCount 0020 TFields.GetField"
	strings:
		$1 = { 53 56 57 55 8B F8 33 ED 8B 47 34 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 24 46 33 DB 8B 47 34 8B D3 E8 ?? ?? ?? ?? 8B CB 81 E1 0F 00 00 80 79 05 49 83 C9 F0 41 D3 E8 03 E8 43 4E 75 DF 8B C5 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1473_0 {
	meta:
		name = "CreateUDLFile"
		size = 296
		refs = "0021 CreateUDLFile 002f CLSID_DATALINKS 0034 CreateComObject 0044 @IntfCast 0068 Format 0073 @WStrFromUStr 007d @WStrToPWChar 0094 OleCheck 00a9 @UStrClr 00b1 @IntfClear 00c1 @WStrClr 00c7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 33 DB 89 5D F0 89 5D F4 89 5D FC 89 5D F8 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F4 8D 45 F8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 50 89 75 E0 C6 45 E4 0F 89 7D E8 C6 45 EC 0F 8D 55 E0 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 F0 8D 45 FC E8 ?? ?? ?? ?? 6A 01 8B 45 FC E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5F 5E 5B 8B E5 5D C3 B1 CC 06 22 C1 19 D1 11 89 E0 00 C0 4F D7 A8 29 B0 04 02 00 FF FF FF FF 1A 00 00 00 50 00 72 00 6F 00 76 00 69 00 64 00 65 00 72 00 3D 00 25 00 73 00 3B 00 44 00 61 00 74 00 61 00 20 00 53 00 6F 00 75 00 72 00 63 00 65 00 3D 00 25 00 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_1474_0 {
	meta:
		name = "GetProviderNames"
		size = 624
		refs = "0018 GetProviderNames 0026 CLASS_Recordset 002b CreateADOObject 003b @IntfCast 0053 CLSID_OLEDB_ENUMERATOR 0058 CreateComObject 0070 @IntfClear 008a OleCheck 009c @CheckAutoResult 00a5 _DV_TADODataSet 00aa TCustomADODataSet.Create 00c6 TCustomADODataSet.SetRecordset 00ce TDataSet.First 00db TDataSet.FieldByName 00f4 TWideStrings.BeginUpdate 0123 @WStrFromUStr 0136 TDataSet.Next 0157 TWideStrings.EndUpdate 015d @HandleFinally 0174 TObject.Free 0191 @UStrClr 0199 @WStrClr 01a2 IInterface 01ac @FinalizeArray"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 53 56 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 8D 45 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC 8B 55 F0 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 E0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E0 8D 45 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 50 6A 00 6A 00 68 ?? ?? ?? ?? 6A 00 8B 45 F4 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 45 F8 50 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F0 8B 45 E8 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B F0 BA ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 8B D8 8B 45 EC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 32 8B C3 8B 10 FF 52 64 48 75 20 8D 55 D8 8B C6 8B 08 FF 51 78 8B 55 D8 8D 45 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 EC 8B 08 FF 51 38 8B 45 E8 E8 ?? ?? ?? ?? 8B 45 E8 80 B8 A5 00 00 00 00 74 C2 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B5 5E 5B 8B E5 5D C3 00 00 56 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 83 02 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 1E 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D 7C 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D B0 04 02 00 FF FF FF FF 0C 00 00 00 53 00 4F 00 55 00 52 00 43 00 45 00 53 00 5F 00 4E 00 41 00 4D 00 45 00 00 00 00 00 B0 04 02 00 FF FF FF FF 0C 00 00 00 53 00 4F 00 55 00 52 00 43 00 45 00 53 00 5F 00 54 00 59 00 50 00 45 00 00 00 00 00 }
	condition:
		$1
}

rule function_1475_0 {
	meta:
		name = "GetProviderNames"
		size = 293
		refs = "0019 GetProviderNames 0026 _Dn_TWideStringList 002b TWideStringList.Create 004c TStrings.BeginUpdate 0054 TWideStrings.GetEnumerator 0086 @WStrLAsg 0091 @UStrFromWStr 00a4 TWideStringsEnumerator.MoveNext 00cb @HandleFinally 00d5 TStrings.EndUpdate 00ea TObject.Free 0107 @UStrClr 0114 @WStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 D2 89 55 E8 89 55 FC 89 55 F8 89 45 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 35 8D 4D F8 8B 45 EC 8B 50 04 8B 45 EC 8B 40 08 8B 18 FF 53 0C 8D 45 FC 8B 55 F8 E8 ?? ?? ?? ?? 8D 45 E8 8B 55 FC E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 38 8B 45 EC E8 ?? ?? ?? ?? 84 C0 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D EC 00 74 0A B2 01 8B 45 EC 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1476_0 {
	meta:
		name = "PromptDataSource"
		size = 360
		refs = "001e @WStrAddRef 0026 PromptDataSource 0036 @WStrAsg 003e CLSID_DATALINKS 0043 CreateComObject 0053 @IntfCast 005d @WStrEqual 0070 @WStrToPWChar 00e6 @WStrFromPWChar 00fc IInterface 0106 @FinalizeArray 010e @IntfClear 0126 @WStrClr 012c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B D9 89 55 FC 8B F0 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 55 FC E8 ?? ?? ?? ?? 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? 74 1F 8D 45 F0 50 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 6A 00 8B 45 F8 50 8B 00 FF 50 0C 8D 55 E4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E4 8D 45 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 02 56 6A 00 8B 45 F4 50 8B 00 FF 50 0C A9 00 00 00 80 0F 94 C0 84 C0 74 22 33 C0 89 45 EC 8D 45 EC 50 6A 01 8B 45 F0 50 8B 45 F8 50 8B 00 FF 50 10 8B C3 8B 55 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C5 5E 5B 8B E5 5D C3 B1 CC 06 22 C1 19 D1 11 89 E0 00 C0 4F D7 A8 29 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 B0 CC 06 22 C1 19 D1 11 89 E0 00 C0 4F D7 A8 29 }
	condition:
		$1
}

rule function_1477_0 {
	meta:
		name = "PromptDataLinkFile"
		size = 292
		refs = "001e @WStrAddRef 0026 PromptDataLinkFile 0036 @WStrAsg 003e CLSID_DATALINKS 0043 CreateComObject 0053 @IntfCast 005d @WStrEqual 006a @UStrFromWStr 0075 ExtractFilePath 0080 @WStrFromUStr 008d @WStrLAsg 00bb @WStrFromPWChar 00d5 @UStrArrayClr 00dd @IntfClear 00f2 @WStrArrayClr 00f8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B D9 89 55 FC 8B F0 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 55 FC E8 ?? ?? ?? ?? 8D 55 EC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? 74 21 8D 45 E4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 E4 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 FC 50 8B 45 F8 50 6A 00 56 8B 45 F4 50 8B 00 FF 50 10 A9 00 00 00 80 0F 94 C0 84 C0 74 0A 8B C3 8B 55 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CE 5E 5B 8B E5 5D C3 B0 CC 06 22 C1 19 D1 11 89 E0 00 C0 4F D7 A8 29 0A 00 00 00 2A 00 2E 00 75 00 64 00 6C 00 00 00 }
	condition:
		$1
}

rule function_1478_0 {
	meta:
		name = "DataLinkDir"
		size = 412
		refs = "0018 DataLinkDir 0027 @UStrAsg 003e RegOpenKeyEx 0074 RegQueryValueEx 008e @UStrFromWArray 00a0 @UStrCat3 00b6 RegCloseKey 00bc @HandleFinally 00d6 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 E8 FD FF FF 53 33 D2 89 95 E8 FD FF FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 33 D2 E8 ?? ?? ?? ?? 8D 45 FC 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 7C 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 F8 0A 02 00 00 8D 45 F8 50 8D 85 EE FD FF FF 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 85 C0 75 28 8D 85 E8 FD FF FF 8D 95 EE FD FF FF B9 05 01 00 00 E8 ?? ?? ?? ?? 8B 95 E8 FD FF FF 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E8 FD FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 8B E5 5D C3 00 53 00 4F 00 46 00 54 00 57 00 41 00 52 00 45 00 5C 00 4D 00 69 00 63 00 72 00 6F 00 73 00 6F 00 66 00 74 00 5C 00 57 00 69 00 6E 00 64 00 6F 00 77 00 73 00 5C 00 43 00 75 00 72 00 72 00 65 00 6E 00 74 00 56 00 65 00 72 00 73 00 69 00 6F 00 6E 00 00 00 43 00 6F 00 6D 00 6D 00 6F 00 6E 00 46 00 69 00 6C 00 65 00 73 00 44 00 69 00 72 00 00 00 00 00 B0 04 02 00 FF FF FF FF 19 00 00 00 5C 00 53 00 79 00 73 00 74 00 65 00 6D 00 5C 00 4F 00 4C 00 45 00 20 00 44 00 42 00 5C 00 44 00 61 00 74 00 61 00 20 00 4C 00 69 00 6E 00 6B 00 73 00 00 00 }
	condition:
		$1
}

rule function_1479_0 {
	meta:
		name = "GetDataLinkFiles"
		size = 388
		refs = "0025 @UStrAddRef 0031 TSearchRec 0036 @InitializeRecord 003e GetDataLinkFiles 004f TWideStrings.BeginUpdate 0076 DataLinkDir 0089 @UStrCat3 009f FindFirst 00bf @WStrFromUStr 00db FindNext 00ec FindClose 0104 TWideStrings.EndUpdate 010a @HandleFinally 0131 @WStrClr 013c @UStrClr 014d @FinalizeRecord"
	strings:
		$1 = { 55 8B EC 81 C4 7C FD FF FF 53 33 C9 89 8D 7C FD FF FF 89 8D 80 FD FF FF 89 55 FC 89 85 84 FD FF FF 8B 45 FC E8 ?? ?? ?? ?? 8D 85 88 FD FF FF 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 85 84 FD FF FF E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 85 84 FD FF FF 8B 10 FF 52 48 83 7D FC 00 75 08 8D 45 FC E8 ?? ?? ?? ?? 8D 85 80 FD FF FF B9 ?? ?? ?? ?? 8B 55 FC E8 ?? ?? ?? ?? 8B 85 80 FD FF FF 8D 8D 88 FD FF FF BA FF 01 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 75 3C F6 85 98 FD FF FF 10 75 22 8D 85 7C FD FF FF 8B 95 9C FD FF FF E8 ?? ?? ?? ?? 8B 95 7C FD FF FF 8B 85 84 FD FF FF 8B 08 FF 51 38 8D 85 88 FD FF FF E8 ?? ?? ?? ?? 8B D8 85 DB 74 C4 8D 85 88 FD FF FF E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 85 84 FD FF FF E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 85 84 FD FF FF 8B 10 FF 52 14 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 7C FD FF FF E8 ?? ?? ?? ?? 8D 85 80 FD FF FF E8 ?? ?? ?? ?? 8D 85 88 FD FF FF 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C9 8B C3 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 06 00 00 00 5C 00 2A 00 2E 00 75 00 64 00 6C 00 00 00 00 00 }
	condition:
		$1
}

rule function_1480_0 {
	meta:
		name = "GetDataLinkFiles"
		size = 327
		refs = "001c @UStrAddRef 0024 GetDataLinkFiles 0031 _Dn_TWideStringList 0036 TWideStringList.Create 005a TWideStrings.BeginUpdate 0062 TWideStrings.GetEnumerator 0094 @WStrLAsg 009f @UStrFromWStr 00b2 TWideStringsEnumerator.MoveNext 00d9 @HandleFinally 00e3 TWideStrings.EndUpdate 00f8 TObject.Free 011f @UStrClr 012c @WStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 33 C9 89 4D E4 89 4D F8 89 4D F4 89 55 FC 89 45 F0 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 45 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 89 45 E8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 35 8D 4D F4 8B 45 E8 8B 50 04 8B 45 E8 8B 40 08 8B 18 FF 53 0C 8D 45 F8 8B 55 F4 E8 ?? ?? ?? ?? 8D 45 E4 8B 55 F8 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F0 8B 08 FF 51 38 8B 45 E8 E8 ?? ?? ?? ?? 84 C0 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D E8 00 74 0A B2 01 8B 45 E8 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 8B 45 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F0 8B 10 FF 52 14 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F4 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1481_0 {
	meta:
		name = "ApplicationHandleException"
		size = 29
		refs = "0003 ApplicationHandleException"
		altNames = "TCustomClientDataSet.InternalHandleException"
	strings:
		$1 = { 53 8B 15 ?? ?? ?? ?? 66 83 7A 02 00 74 0D 8B 1D ?? ?? ?? ?? 8B D0 8B 43 04 FF 13 5B C3 }
	condition:
		$1
}

rule function_1482_0 {
	meta:
		name = "TADOConnection.Create"
		size = 288
		refs = "0013 @ClassCreate 001f TADOConnection.Create 002e TCustomConnection.Create 0036 CLASS_Connection 003b CreateADOObject 004b @IntfCast 0076 TADOConnection.ConnectionPoint 0084 OleCheck 008b _Dn_TList 0090 TObject.Create 00a7 TADOConnection.SetCursorLocation 00c3 @IntfClear 00cc IInterface 00d6 @FinalizeArray 00dc @HandleFinally 00e9 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8D 46 74 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 46 78 50 8D 45 F8 8B D6 85 D2 74 06 81 EA 20 FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 8D 55 F4 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 70 C6 46 40 01 C6 86 8D 00 00 00 04 B2 01 8B C6 E8 ?? ?? ?? ?? C6 86 94 00 00 00 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 8B E5 5D C3 00 50 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_1483_0 {
	meta:
		name = "TADOConnection.Destroy"
		size = 181
		refs = "000d @BeforeDestruction 001a TADOConnection.Destroy 0027 TComponent.Destroying 002e TCustomConnection.Close 0035 TADOConnection.ClearRefs 0045 TObject.Free 0059 TADOConnection.ConnectionPoint 0067 OleCheck 0074 @IntfClear 0082 TCustomConnection.Destroy 009d @HandleFinally 00ac @ClassDestroy"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8D 43 70 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 83 7B 78 00 7E 1C 8B 43 78 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 89 43 78 8D 43 74 E8 ?? ?? ?? ?? 0F B6 55 FF 80 E2 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 80 7D FF 00 7E 07 8B C3 E8 ?? ?? ?? ?? 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1484_0 {
	meta:
		name = "TADOConnection.Loaded"
		size = 66
		refs = "000e TADOConnection.Loaded 001c TCustomConnection.Loaded 002b @HandleAnyException 0033 ApplicationHandleException 0038 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 12 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1656_0 {
	meta:
		name = "TCustomADODataSet.Loaded"
		size = 66
		refs = "000e TCustomADODataSet.Loaded 001c TDataSet.Loaded 002b @HandleAnyException 0033 ApplicationHandleException 0038 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 12 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1485_0 {
	meta:
		name = "TADOConnection.CheckActive"
		size = 30
		refs = "0011 TCustomConnection.Open"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 3C 84 C0 75 0E 8B C3 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 58 5B C3 }
	condition:
		$1
}

rule function_1486_0 {
	meta:
		name = "TADOConnection.CheckInactive"
		size = 29
		refs = "0017 TCustomConnection.Close"
		altNames = "TRDSConnection.CheckInactive"
	strings:
		$1 = { 53 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 0D F6 43 1C 10 74 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1487_0 {
	meta:
		name = "TADOConnection.ClearRefs"
		size = 72
		refs = "0011 TList.Get 0018 TADOCommand.SetConnection 002c TADOConnection.GetADODataSet"
	strings:
		$1 = { 53 56 8B D8 83 7B 70 00 74 30 EB 10 33 D2 8B C6 E8 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 8B 73 70 83 7E 08 00 7F E7 EB 13 33 D2 8B C3 E8 ?? ?? ?? ?? 33 D2 8B 08 FF 91 C4 02 00 00 8B C3 8B 10 FF 52 44 85 C0 7F E2 5E 5B C3 }
	condition:
		$1
}

rule function_1488_0 {
	meta:
		name = "TADOConnection.BeginTrans"
		size = 31
		refs = "000f @CheckAutoResult"
	strings:
		$1 = { 53 51 8B D8 54 8B 43 74 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 8B 04 24 89 83 90 00 00 00 5A 5B C3 }
	condition:
		$1
}

rule function_1489_0 {
	meta:
		name = "TADOConnection.CommitTrans"
		size = 41
		refs = "000d @CheckAutoResult"
	strings:
		$1 = { 56 8B F0 8B 46 74 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 83 BE 90 00 00 00 00 7E 06 FF 8E 90 00 00 00 8B C6 8B 10 FF 52 54 5E C3 }
	condition:
		$1
}

rule function_1490_0 {
	meta:
		name = "TADOConnection.RollbackTrans"
		size = 41
		refs = "000d @CheckAutoResult"
	strings:
		$1 = { 56 8B F0 8B 46 74 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 83 BE 90 00 00 00 00 7E 06 FF 8E 90 00 00 00 8B C6 8B 10 FF 52 54 5E C3 }
	condition:
		$1
}

rule function_1491_0 {
	meta:
		name = "TADOConnection.Cancel"
		size = 18
		refs = "000d @CheckAutoResult"
	strings:
		$1 = { 8B 40 74 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1492_0 {
	meta:
		name = "TADOConnection.WaitForConnectComplete"
		size = 51
		refs = "000d DBApplication 0026 @CheckAutoResult"
	strings:
		$1 = { 53 51 8B D8 83 7B 74 00 74 26 EB 0C A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 10 54 8B 43 74 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 83 3C 24 02 74 DC 5A 5B C3 }
	condition:
		$1
}

rule function_1493_0 {
	meta:
		name = "TADOConnection.DoConnect"
		size = 161
		refs = "000c TADOConnection.DoConnect 0020 ConnectOptionValues 0037 @WStrClr 0046 @CheckAutoResult 0065 @WStrEqual 0097 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 83 8C 00 00 00 8B 04 85 ?? ?? ?? ?? 50 8B 83 88 00 00 00 50 8B 83 84 00 00 00 50 8D 45 FC E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 43 74 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 8B 83 80 00 00 00 33 D2 E8 ?? ?? ?? ?? 74 15 8B 83 80 00 00 00 50 8B 43 74 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1494_0 {
	meta:
		name = "TADOConnection.DoDisconnect"
		size = 45
		refs = "000e TADOConnection.RollbackTrans 0015 TADOConnection.GetInTransaction 0027 @CheckAutoResult"
	strings:
		$1 = { 53 8B D8 83 7B 74 00 74 22 EB 07 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 75 EE 8B 43 74 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1495_0 {
	meta:
		name = "TADOConnection.CheckDisconnect"
		size = 92
		refs = "001c TADOConnection.GetInTransaction 0040 TADOConnection.GetADODataSet 0054 TCustomConnection.Close"
	strings:
		$1 = { 53 56 57 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 48 80 BB 94 00 00 00 00 75 3F 8B C3 E8 ?? ?? ?? ?? 84 C0 75 34 F6 43 1C 01 75 2E 8B C3 8B 10 FF 52 44 8B F0 4E 85 F6 7C 19 46 33 FF 8B D7 8B C3 E8 ?? ?? ?? ?? 80 B8 A1 00 00 00 00 75 0B 47 4E 75 EA 8B C3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1496_0 {
	meta:
		name = "TADOConnection.Execute"
		size = 143
		refs = "001a TADOConnection.Execute 0027 TADOConnection.CheckActive 002f @IntfClear 0039 ExecuteOptionsToOrd 0043 @VarClr 0053 @CheckAutoResult 005b @VarToInteger 0080 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 50 0F B6 45 08 E8 ?? ?? ?? ?? 40 50 8D 45 F0 E8 ?? ?? ?? ?? 50 56 8B 43 74 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 89 07 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1497_0 {
	meta:
		name = "TADOConnection.Execute"
		size = 132
		refs = "0018 TADOConnection.Execute 0025 TADOConnection.CheckActive 002d @IntfClear 0037 ExecuteOptionsToOrd 0041 CommandTypeValues 004a @VarClr 005a @CheckAutoResult 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 50 0F B6 45 0C E8 ?? ?? ?? ?? 0F B6 D3 03 04 95 ?? ?? ?? ?? 50 8D 45 F0 E8 ?? ?? ?? ?? 50 56 8B 47 74 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1498_0 {
	meta:
		name = "TADOConnection.Open"
		size = 119
		refs = "0018 @WStrAsg 002f TADOConnection.Open 0059 @WStrClr 006c @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 8B DA 89 45 FC 8B 45 FC 05 84 00 00 00 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 05 88 00 00 00 8B D6 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B 45 FC 8B 08 FF 51 4C 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 05 84 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 05 88 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1499_0 {
	meta:
		name = "TADOConnection.OpenSchema"
		size = 161
		refs = "0019 TADOConnection.OpenSchema 0026 TADOConnection.CheckActive 003d @IntfClear 006c @CheckAutoResult 0077 TCustomADODataSet.SetRecordset 0092 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 89 4D F8 8B DA 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 80 FB 27 75 05 83 CE FF EB 05 8B F3 83 E6 7F 8D 45 F4 E8 ?? ?? ?? ?? 50 8B 45 0C FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 F8 FF 70 0C FF 70 08 FF 70 04 FF 30 56 8B 47 74 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1500_0 {
	meta:
		name = "TADOConnection.GetProcedureNames"
		size = 276
		refs = "0013 TADOConnection.GetProcedureNames 0020 TADOConnection.CheckActive 0029 _DV_TADODataSet 002e TCustomADODataSet.Create 0044 EmptyParam 0058 TADOConnection.OpenSchema 0065 TDataSet.FieldByName 007e @WStrFromUStr 0090 TDataSet.Next 00b1 TObject.Free 00b7 @HandleFinally 00ce @UStrClr 00d6 @WStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? B2 10 8B C3 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B D8 EB 27 8D 55 F4 8B C3 8B 08 FF 51 78 8B 55 F4 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 8B 08 FF 51 38 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC 80 B8 A5 00 00 00 00 74 CD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 0E 00 00 00 50 00 52 00 4F 00 43 00 45 00 44 00 55 00 52 00 45 00 5F 00 4E 00 41 00 4D 00 45 00 00 00 00 00 }
	condition:
		$1
}

rule function_1501_0 {
	meta:
		name = "TADOConnection.GetProcedureNames"
		size = 297
		refs = "001b TADOConnection.GetProcedureNames 0028 _Dn_TWideStringList 002d TWideStringList.Create 0050 TStrings.BeginUpdate 0058 TWideStrings.GetEnumerator 008a @WStrLAsg 0095 @UStrFromWStr 00a8 TWideStringsEnumerator.MoveNext 00cf @HandleFinally 00d9 TStrings.EndUpdate 00ee TObject.Free 010b @UStrClr 0118 @WStrArrayClr"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 C9 89 4D E8 89 4D FC 89 4D F8 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 35 8D 4D F8 8B 45 EC 8B 50 04 8B 45 EC 8B 40 08 8B 18 FF 53 0C 8D 45 FC 8B 55 F8 E8 ?? ?? ?? ?? 8D 45 E8 8B 55 FC E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F4 8B 08 FF 51 38 8B 45 EC E8 ?? ?? ?? ?? 84 C0 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D EC 00 74 0A B2 01 8B 45 EC 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1502_0 {
	meta:
		name = "TADOConnection.GetFieldNames"
		size = 636
		refs = "0022 TADOConnection.GetFieldNames 002f TADOConnection.CheckActive 0037 @IntfClear 003d EmptyParam 0050 Null 007d @VarFromWStr 009a VarArrayOf 00a5 @OleVarFromVar 00c4 @CheckAutoResult 00cc TWideStrings.BeginUpdate 00f2 @VarClr 010f @OleVarFromUStr 0174 VarToWideStr 01cb TWideStrings.EndUpdate 01d1 @HandleFinally 0217 @WStrClr 0223 Variant 022d @FinalizeArray"
	strings:
		$1 = { 55 8B EC 51 B9 16 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 45 98 E8 ?? ?? ?? ?? 56 8D 75 98 8D 7D A8 A5 A5 A5 A5 5E 8D 45 88 E8 ?? ?? ?? ?? 56 8D 75 88 8D 7D B8 A5 A5 A5 A5 5E 8D 85 78 FF FF FF 8B D6 E8 ?? ?? ?? ?? 8D B5 78 FF FF FF 8D 7D C8 A5 A5 A5 A5 8D 45 A8 8D 4D D8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 55 D8 8D 45 E8 E8 ?? ?? ?? ?? FF 75 F4 FF 75 F0 FF 75 EC FF 75 E8 6A 04 8B 43 74 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 48 E9 AC 00 00 00 8D 85 64 FF FF FF E8 ?? ?? ?? ?? 50 8D 85 60 FF FF FF E8 ?? ?? ?? ?? 50 8D 85 50 FF FF FF BA ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 5C FF FF FF FF B5 58 FF FF FF FF B5 54 FF FF FF FF B5 50 FF FF FF 8D 85 4C FF FF FF E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 85 4C FF FF FF 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 85 60 FF FF FF 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 8D 85 64 FF FF FF 8D 95 74 FF FF FF E8 ?? ?? ?? ?? 8B 95 74 FF FF FF 8B 45 F8 8B 08 FF 51 38 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 8D 85 48 FF FF FF 50 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 BD 48 FF FF FF 00 0F 84 31 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 4C FF FF FF E8 ?? ?? ?? ?? 8D 85 50 FF FF FF E8 ?? ?? ?? ?? 8D 85 60 FF FF FF E8 ?? ?? ?? ?? 8D 85 64 FF FF FF E8 ?? ?? ?? ?? 8D 85 74 FF FF FF E8 ?? ?? ?? ?? 8D 85 78 FF FF FF 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB 93 5F 5E 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 0B 00 00 00 43 00 4F 00 4C 00 55 00 4D 00 4E 00 5F 00 4E 00 41 00 4D 00 45 00 00 00 }
	condition:
		$1
}

rule function_1503_0 {
	meta:
		name = "TADOConnection.GetFieldNames"
		size = 322
		refs = "001e TADOConnection.GetFieldNames 002b _Dn_TWideStringList 0030 TWideStringList.Create 004b @WStrFromUStr 0060 TStrings.BeginUpdate 0068 TWideStrings.GetEnumerator 009a @WStrLAsg 00a5 @UStrFromWStr 00b8 TWideStringsEnumerator.MoveNext 00df @HandleFinally 00e9 TStrings.EndUpdate 00fe TObject.Free 011b @UStrClr 0123 @WStrClr 0130 @WStrArrayClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 8B D6 E8 ?? ?? ?? ?? 8B 55 E8 8B 4D F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 EB 35 8D 4D F8 8B 45 EC 8B 50 04 8B 45 EC 8B 40 08 8B 18 FF 53 0C 8D 45 FC 8B 55 F8 E8 ?? ?? ?? ?? 8D 45 E4 8B 55 FC E8 ?? ?? ?? ?? 8B 55 E4 8B 45 F4 8B 08 FF 51 38 8B 45 EC E8 ?? ?? ?? ?? 84 C0 75 BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D EC 00 74 0A B2 01 8B 45 EC 8B 08 FF 51 FC C3 E9 ?? ?? ?? ?? EB E8 8B 45 F4 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1504_0 {
	meta:
		name = "TADOConnection.GetTableNames"
		size = 544
		refs = "001e TADOConnection.GetTableNames 002b TADOConnection.CheckActive 0034 _DV_TADODataSet 0039 TCustomADODataSet.Create 004f EmptyParam 0063 TADOConnection.OpenSchema 0070 TDataSet.FieldByName 008a TWideStrings.BeginUpdate 00b7 @WStrFromUStr 00c4 @WStrEqual 0111 TDataSet.Next 0132 TWideStrings.EndUpdate 0138 @HandleFinally 014f TObject.Free 016c @UStrClr 0174 @WStrClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B D9 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 33 C9 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 50 8B 45 F0 50 8B 0D ?? ?? ?? ?? B2 14 8B C6 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8B F0 BA ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 10 FF 52 48 EB 6F 8D 55 EC 8B C6 8B 08 FF 51 78 8B 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 22 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 13 84 DB 74 30 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 21 8D 55 E4 8B 45 F4 8B 08 FF 51 78 8B 55 E4 8D 45 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 F8 8B 08 FF 51 38 8B 45 F0 E8 ?? ?? ?? ?? 8B 45 F0 80 B8 A5 00 00 00 00 74 85 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 0A 00 00 00 54 00 41 00 42 00 4C 00 45 00 5F 00 54 00 59 00 50 00 45 00 00 00 00 00 B0 04 02 00 FF FF FF FF 0A 00 00 00 54 00 41 00 42 00 4C 00 45 00 5F 00 4E 00 41 00 4D 00 45 00 00 00 00 00 0A 00 00 00 54 00 41 00 42 00 4C 00 45 00 00 00 08 00 00 00 56 00 49 00 45 00 57 00 00 00 00 00 18 00 00 00 53 00 59 00 53 00 54 00 45 00 4D 00 20 00 54 00 41 00 42 00 4C 00 45 00 00 00 00 00 }
	condition:
		$1
}

rule function_1505_0 {
	meta:
		name = "TADOConnection.GetTableNames"
		size = 99
		refs = "0010 _Dn_TWideStringList 0015 TWideStringList.Create 0020 TADOConnection.GetTableNames 0051 TObject.Free 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B D9 8B F2 8B F8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B 55 FC 8B C7 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1506_0 {
	meta:
		name = "TADOConnection.ConnectionPoint"
		size = 132
		refs = "000f TADOConnection.ConnectionPoint 001d @IntfClear 0030 OleCheck 003d DIID_ConnectionEvents 0067 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 43 74 50 8B 00 FF 10 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 84 B2 96 B1 B4 BA 1A 10 B6 9C 00 AA 00 34 1D 07 }
	condition:
		$1
}

rule function_1507_0 {
	meta:
		name = "TADOConnection.BeginTransComplete"
		size = 124
		refs = "0012 TADOConnection.BeginTransComplete 0029 EventStatusValues 0033 OleEnumToOrd 006e @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 14 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB 9A 00 00 00 00 74 3A 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8B 45 10 50 8D 45 FF 50 8B 4D 0C 8B D3 8B 83 9C 00 00 00 FF 93 98 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 14 00 }
	condition:
		$1
}

rule function_1508_0 {
	meta:
		name = "TADOConnection.CommitTransComplete"
		size = 120
		refs = "0012 TADOConnection.CommitTransComplete 0029 EventStatusValues 0033 OleEnumToOrd 006a @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB AA 00 00 00 00 74 36 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8D 45 FF 50 8B 4D 0C 8B D3 8B 83 AC 00 00 00 FF 93 A8 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_1509_0 {
	meta:
		name = "TADOConnection.ConnectComplete"
		size = 120
		refs = "0012 TADOConnection.ConnectComplete 0029 EventStatusValues 0033 OleEnumToOrd 006a @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB A2 00 00 00 00 74 36 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8D 45 FF 50 8B 4D 0C 8B D3 8B 83 A4 00 00 00 FF 93 A0 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_1510_0 {
	meta:
		name = "TADOConnection.Disconnect"
		size = 174
		refs = "0011 TADOConnection.Disconnect 002b EventStatusValues 0035 OleEnumToOrd 0076 TADOConnection.GetADODataSet 007f TCustomADODataSet.GetRecordsetState 008a TDataSet.Close 00a0 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 0C FF 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 66 83 B8 BA 00 00 00 00 74 36 8B 0B B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8D 4D FF 8B 75 08 8B 55 08 8B 86 BC 00 00 00 FF 96 B8 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 03 8B 45 08 8B 10 FF 52 44 8B F0 4E 85 F6 7C 25 46 33 FF 8B D7 8B 45 08 E8 ?? ?? ?? ?? 8B D8 8B C3 E8 ?? ?? ?? ?? A8 01 74 07 8B C3 E8 ?? ?? ?? ?? 47 4E 75 DE 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_1511_0 {
	meta:
		name = "CheckForAsyncExecute"
		size = 180
		refs = "000b CheckForAsyncExecute 003b @CheckAutoResult 0063 TADOConnection.GetADODataSet 007a TCustomADODataSet.GetExecuteOptions 0085 TDataSet.OpenCursorComplete 009a @HandleAnyException 00a5 ApplicationHandleException 00aa @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 83 78 10 00 75 71 8B 45 08 83 78 1C 00 74 68 8D 45 FC 50 8B 45 08 8B 40 1C 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? F6 45 FC 01 74 4A 8B 45 08 8B 40 08 8B 10 FF 52 44 8B F0 4E 85 F6 7C 38 46 33 FF 8B 45 08 8B 40 08 8B D7 E8 ?? ?? ?? ?? 8B D8 8B 83 78 01 00 00 8B 55 08 3B 42 1C 75 14 8B C3 E8 ?? ?? ?? ?? A8 01 74 09 8B C3 E8 ?? ?? ?? ?? EB 04 47 4E 75 CB 33 C0 5A 59 59 64 89 10 EB 15 E9 ?? ?? ?? ?? 8B 45 08 8B 40 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1512_0 {
	meta:
		name = "TADOConnection.ExecuteComplete"
		size = 145
		refs = "0011 TADOConnection.ExecuteComplete 002b EventStatusValues 0035 OleEnumToOrd 0070 CheckForAsyncExecute 0083 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 5D 14 FF 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 66 83 B8 D2 00 00 00 00 74 46 8B 0B B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8B 45 10 50 8D 45 FF 50 8B 45 18 50 8B 45 1C 50 8B 75 08 8B 4D 0C 8B 55 08 8B 86 D4 00 00 00 FF 96 D0 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 03 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 1C 00 }
	condition:
		$1
}

rule function_1513_0 {
	meta:
		name = "TADOConnection.InfoMessage"
		size = 120
		refs = "0012 TADOConnection.InfoMessage 0029 EventStatusValues 0033 OleEnumToOrd 006a @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB C2 00 00 00 00 74 36 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8D 45 FF 50 8B 4D 0C 8B D3 8B 83 C4 00 00 00 FF 93 C0 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_1514_0 {
	meta:
		name = "TADOConnection.RollbackTransComplete"
		size = 120
		refs = "0012 TADOConnection.RollbackTransComplete 0029 EventStatusValues 0033 OleEnumToOrd 006a @HandleAutoException"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB B2 00 00 00 00 74 36 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8D 45 FF 50 8B 4D 0C 8B D3 8B 83 B4 00 00 00 FF 93 B0 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_1515_0 {
	meta:
		name = "ExtractUserID"
		size = 224
		refs = "0015 @UStrAddRef 001d ExtractUserID 002e AnsiUpperCase 003b Pos 0058 @UStrCopy 0080 @UStrAsg 009a @UStrArrayClr 00a0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 57 8B F2 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F8 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F8 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 83 C3 08 83 FB 08 7E 32 8D 45 F4 50 B9 FF 00 00 00 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 4F 56 8B CF 8B D3 8B 45 FC E8 ?? ?? ?? ?? EB 09 8B C6 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 08 00 00 00 55 00 53 00 45 00 52 00 20 00 49 00 44 00 3D 00 00 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3B 00 00 00 }
	condition:
		$1
}

rule function_1516_0 {
	meta:
		name = "GetUserName"
		size = 340
		refs = "0017 @UStrAddRef 001f GetUserName 003b @UStrCopy 0048 CompareText 0054 CLSID_DATALINKS 0059 CreateComObject 0069 @IntfCast 008a @WStrFromUStr 0096 @WStrToPWChar 00b7 @UStrFromPWChar 00c1 ExtractUserID 00e7 @UStrArrayClr 00ef @IntfClear 00f7 @UStrClr 00ff @WStrClr 0115 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 51 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC 50 B9 0A 00 00 00 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 77 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F8 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E4 50 B9 04 01 00 00 BA 0B 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E4 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 F4 E8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 00 FF 50 1C A9 00 00 00 80 0F 94 C0 84 C0 74 21 8D 45 E0 8B 55 F0 E8 ?? ?? ?? ?? 8B 45 E0 8B D3 E8 ?? ?? ?? ?? EB 0A 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C3 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 0A 00 00 00 46 00 49 00 4C 00 45 00 20 00 4E 00 41 00 4D 00 45 00 3D 00 00 00 00 00 B1 CC 06 22 C1 19 D1 11 89 E0 00 C0 4F D7 A8 29 }
	condition:
		$1
}

rule function_1517_0 {
	meta:
		name = "TADOConnection.WillConnect"
		size = 371
		refs = "0019 TADOConnection.WillConnect 0033 EventStatusValues 003d OleEnumToOrd 004a ConnectOptionValues 00a4 @WStrEqual 00b0 @UStrFromWStr 00c8 GetUserName 00cd LoginDialogExProc 00f5 @WStrFromUStr 014a @HandleAutoException 0157 @UStrArrayClr"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB CA 00 00 00 00 74 6C 8B 4D 1C 8B 09 B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 F7 8B 4D 18 8B 09 B8 ?? ?? ?? ?? BA 01 00 00 00 E8 ?? ?? ?? ?? 88 45 F6 56 8B 45 14 50 8D 45 F6 50 8D 45 F7 50 8B 4D 0C 8B D3 8B 83 CC 00 00 00 FF 93 C8 00 00 00 0F B6 45 F7 8B 04 85 ?? ?? ?? ?? 8B 55 1C 89 02 0F B6 45 F6 8B 04 85 ?? ?? ?? ?? 8B 55 18 89 02 80 7B 40 00 74 70 8B 06 33 D2 E8 ?? ?? ?? ?? 75 0A 8D 45 F8 8B 16 E8 ?? ?? ?? ?? 8D 45 F0 8B 55 0C 8B 12 E8 ?? ?? ?? ?? 8B 45 F0 8D 55 F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 38 00 74 39 6A 00 8B 3D ?? ?? ?? ?? 8B 3F 8D 4D FC 8D 55 F8 8B 43 08 FF D7 84 C0 74 17 8B C6 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 14 8B 55 FC E8 ?? ?? ?? ?? EB 09 8B 45 1C C7 00 04 00 00 00 66 83 7B 6A 00 74 26 8D 45 EC 8B 55 14 8B 12 E8 ?? ?? ?? ?? 8B 45 EC 50 8D 45 E8 8B 16 E8 ?? ?? ?? ?? 8B 4D E8 8B D3 8B 43 6C FF 53 68 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8D 45 E8 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule function_1518_0 {
	meta:
		name = "ExtractCommandType"
		size = 37
		refs = "0006 CommandTypeValues"
	strings:
		$1 = { 55 8B EC 33 D2 B8 ?? ?? ?? ?? 8B 4D 08 8B 49 18 8B 09 23 08 75 0B 42 83 C0 04 80 FA 06 75 EB B2 01 8B C2 5D C3 }
	condition:
		$1
}

rule function_1519_0 {
	meta:
		name = "TADOConnection.WillExecute"
		size = 277
		refs = "0014 TADOConnection.WillExecute 002f CursorTypeValues 0039 OleEnumToOrd 0046 LockTypeValues 0059 ExtractCommandType 0067 OrdToExecuteOptions 0074 EventStatusValues 00d4 ExecuteOptionsToOrd 00df CommandTypeValues 0106 @HandleAutoException"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B 75 10 8B 5D 08 53 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 BB DA 00 00 00 00 0F 84 CC 00 00 00 8B 0E B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FF 8B 4D 14 8B 09 B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FE 55 E8 ?? ?? ?? ?? 59 88 45 FB 8B 45 18 8B 00 E8 ?? ?? ?? ?? 88 45 FC 8B 4D 1C 8B 09 B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 88 45 FD 8D 45 FF 50 8D 45 FE 50 8D 45 FB 50 8D 45 FC 50 8D 45 FD 50 8B 45 20 50 8B 45 24 50 8B 4D 0C 8B D3 8B 83 DC 00 00 00 FF 93 D8 00 00 00 0F B6 45 FF 8B 04 85 ?? ?? ?? ?? 89 06 0F B6 45 FE 8B 04 85 ?? ?? ?? ?? 8B 55 14 89 02 0F B6 45 FC E8 ?? ?? ?? ?? 0F B6 55 FB 03 04 95 ?? ?? ?? ?? 8B 55 18 89 02 0F B6 45 FD 8B 04 85 ?? ?? ?? ?? 8B 55 1C 89 02 33 C0 5A 59 59 64 89 10 58 33 DB EB 05 E9 ?? ?? ?? ?? 8B C3 5F 5E 5B 59 59 5D C2 24 00 }
	condition:
		$1
}

rule function_1520_0 {
	meta:
		name = "TADOConnection.GetAttributes"
		size = 108
		refs = "0009 TADOConnection.GetAttributes 001f @CheckAutoResult 002e XactAttributeValues"
	strings:
		$1 = { 53 56 57 83 C4 F8 0F B6 15 ?? ?? ?? ?? 88 14 24 8D 54 24 04 52 8B 40 74 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 8B 7C 24 04 85 FF 74 31 33 DB BE ?? ?? ?? ?? 85 3E 74 1D 8B C3 3C 07 77 17 83 E0 7F 8B D4 8B CA 83 E1 03 2B D1 03 C9 03 C9 03 C9 03 C1 0F AB 02 43 83 C6 04 80 FB 02 75 D6 0F B6 04 24 59 5A 5F 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1521_0 {
	meta:
		name = "TADOConnection.SetAttributes"
		size = 84
		refs = "000e TADOConnection.SetAttributes 001a XactAttributeValues 0046 @CheckAutoResult"
	strings:
		$1 = { 53 56 57 51 88 14 24 8B F8 33 F6 0F B6 05 ?? ?? ?? ?? 3A 04 24 74 24 33 C0 BA ?? ?? ?? ?? 8B C8 80 F9 07 77 0A 83 E1 7F 0F B6 1C 24 0F A3 CB 73 02 03 32 40 83 C2 04 3C 02 75 E3 56 8B 47 74 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_1522_0 {
	meta:
		name = "TADOConnection.GetCommandTimeout"
		size = 21
		refs = "000c @CheckAutoResult"
	strings:
		$1 = { 51 54 8B 40 74 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_1523_0 {
	meta:
		name = "TADOConnection.SetCommandTimeout"
		size = 16
		refs = "000b @CheckAutoResult"
	strings:
		$1 = { 52 8B 40 74 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1524_0 {
	meta:
		name = "TADOConnection.GetConnected"
		size = 51
		refs = "001f @CheckAutoResult"
	strings:
		$1 = { 53 51 8B D8 8B C3 8B 10 FF 52 58 83 7B 74 00 74 18 54 8B 43 74 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? F6 04 24 01 75 05 33 C0 5A 5B C3 B0 01 5A 5B C3 }
	condition:
		$1
}

rule function_1525_0 {
	meta:
		name = "TADOConnection.SetConnectionObject"
		size = 204
		refs = "0013 TADOConnection.SetConnectionObject 0020 TADOConnection.CheckInactive 0032 TADOConnection.ConnectionPoint 0040 OleCheck 004a @IntfCopy 0067 @IntfCast 0098 @IntfClear 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 85 F6 74 5F 8B 43 78 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 8D 43 74 8B D6 E8 ?? ?? ?? ?? 8D 43 78 50 8D 45 F8 8B D3 85 D2 74 06 81 EA 20 FF FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 }
	condition:
		$1
}

rule function_1526_0 {
	meta:
		name = "TADOConnection.GetConnectionString"
		size = 61
		refs = "001d @WStrAsg 0027 @WStrClr 0036 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 1C 04 74 18 8B C3 8B 10 FF 52 3C 84 C0 74 0D 8B C6 8B 53 7C E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1527_0 {
	meta:
		name = "TADOConnection.SetConnectionString"
		size = 113
		refs = "000f TADOConnection.SetConnectionString 001f TADOConnection.GetConnectionString 0029 @WStrEqual 0032 TADOConnection.CheckInactive 0041 @CheckAutoResult 004b @WStrAsg 0060 @WStrClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 74 20 8B C3 E8 ?? ?? ?? ?? 56 8B 43 74 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8D 43 7C 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1528_0 {
	meta:
		name = "TADOConnection.GetConnectionTimeout"
		size = 21
		refs = "000c @CheckAutoResult"
	strings:
		$1 = { 51 54 8B 40 74 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_1529_0 {
	meta:
		name = "TADOConnection.SetConnectionTimeout"
		size = 42
		refs = "0009 TADOConnection.GetConnectionTimeout 0014 TADOConnection.CheckInactive 0023 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 3B F0 74 16 8B C3 E8 ?? ?? ?? ?? 56 8B 43 74 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1530_0 {
	meta:
		name = "TADOConnection.SetConnectOptions"
		size = 30
		refs = "0011 TADOConnection.CheckInactive"
	strings:
		$1 = { 53 56 8B DA 8B F0 3A 9E 8C 00 00 00 74 0D 8B C6 E8 ?? ?? ?? ?? 88 9E 8C 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1531_0 {
	meta:
		name = "TADOConnection.GetCursorLocation"
		size = 40
		refs = "000f @CheckAutoResult 0017 CursorLocationValues 0021 OleEnumToOrd"
	strings:
		$1 = { 53 51 8B D8 54 8B 43 74 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 8B 0C 24 B8 ?? ?? ?? ?? BA 01 00 00 00 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1532_0 {
	meta:
		name = "TADOConnection.SetCursorLocation"
		size = 26
		refs = "0006 CursorLocationValues 0015 @CheckAutoResult"
	strings:
		$1 = { 83 E2 7F 8B 14 95 ?? ?? ?? ?? 52 8B 40 74 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1533_0 {
	meta:
		name = "TADOConnection.RegisterClient"
		size = 75
		refs = "0014 TCustomConnection.RegisterClient 001c _DV_TADOCommand 0021 @IsClass 002e _DV_TCustomADODataSet 0041 TList.Add"
	strings:
		$1 = { 55 8B EC 53 56 8B DA 8B F0 FF 75 0C FF 75 08 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1C 8B 43 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 0A 8B D3 8B 46 70 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1534_0 {
	meta:
		name = "TADOConnection.UnRegisterClient"
		size = 65
		refs = "000b TCustomConnection.UnRegisterClient 0013 _DV_TADOCommand 0018 @IsClass 0025 _DV_TCustomADODataSet 003a TList.RemoveItem"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8B 43 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 0C 8B D3 33 C9 8B 46 70 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1535_0 {
	meta:
		name = "TADOConnection.GetCommand"
		size = 19
		refs = "000c TList.Get"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 43 70 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1536_0 {
	meta:
		name = "TADOConnection.GetCommandCount"
		size = 7
	strings:
		$1 = { 8B 40 70 8B 40 08 C3 }
	condition:
		$1
}

rule function_1537_0 {
	meta:
		name = "TADOConnection.GetADODataSet"
		size = 29
		refs = "0011 _DV_TCustomADODataSet 0016 @AsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 8B 08 FF 51 40 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1538_0 {
	meta:
		name = "TADOConnection.IsDefaultDatabaseStored"
		size = 21
		refs = "000c @WStrEqual"
	strings:
		$1 = { 53 8B D8 8B 83 80 00 00 00 33 D2 E8 ?? ?? ?? ?? 0F 95 C0 5B C3 }
	condition:
		$1
}

rule function_1539_0 {
	meta:
		name = "TADOConnection.GetDefaultDatabase"
		size = 97
		refs = "0019 TADOConnection.GetDefaultDatabase 0026 @WStrClr 0035 @CheckAutoResult 0044 @HandleAnyException 0049 @DoneExcept 0058 @WStrAsg"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F2 8B D8 8B C3 8B 10 FF 52 3C 84 C0 74 3A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 19 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0D 8B C6 8B 93 80 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_1540_0 {
	meta:
		name = "TADOConnection.SetDefaultDatabase"
		size = 120
		refs = "000f TADOConnection.SetDefaultDatabase 001f TADOConnection.GetDefaultDatabase 0029 @WStrEqual 0038 @WStrAsg 0052 @CheckAutoResult 0067 @WStrClr 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 74 27 8D 83 80 00 00 00 8B D6 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 52 3C 84 C0 74 0F 56 8B 43 74 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1541_0 {
	meta:
		name = "TADOConnection.GetErrors"
		size = 31
		refs = "0009 @IntfClear 0018 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1542_0 {
	meta:
		name = "TADOConnection.GetInTransaction"
		size = 11
	strings:
		$1 = { 83 B8 90 00 00 00 00 0F 9F C0 C3 }
	condition:
		$1
}

rule function_1543_0 {
	meta:
		name = "TADOConnection.GetIsolationLevel"
		size = 69
		refs = "0010 @CheckAutoResult 0024 IsolationLevelValues 0037 OleEnumToOrd"
	strings:
		$1 = { 53 56 51 8B D8 54 8B 43 74 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 8B 34 24 0F B6 83 8D 00 00 00 0F B6 D0 3B 34 95 ?? ?? ?? ?? 74 17 B8 ?? ?? ?? ?? 8B CE BA 08 00 00 00 E8 ?? ?? ?? ?? 88 83 8D 00 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1544_0 {
	meta:
		name = "TADOConnection.SetIsolationLevel"
		size = 40
		refs = "000c IsolationLevelValues 001b @CheckAutoResult"
	strings:
		$1 = { 53 56 8B DA 8B F0 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 8B 46 74 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 88 9E 8D 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1545_0 {
	meta:
		name = "TADOConnection.GetMode"
		size = 40
		refs = "000f @CheckAutoResult 0017 ConnectModeValues 0021 OleEnumToOrd"
	strings:
		$1 = { 53 51 8B D8 54 8B 43 74 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 8B 0C 24 B8 ?? ?? ?? ?? BA 07 00 00 00 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1546_0 {
	meta:
		name = "TADOConnection.SetMode"
		size = 52
		refs = "0009 TADOConnection.GetMode 0014 TADOConnection.CheckInactive 001e ConnectModeValues 002d @CheckAutoResult"
	strings:
		$1 = { 53 56 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 3A D8 74 20 8B C6 E8 ?? ?? ?? ?? 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 8B 46 74 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1547_0 {
	meta:
		name = "TADOConnection.GetProperties"
		size = 31
		refs = "0009 @IntfClear 0018 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1548_0 {
	meta:
		name = "TADOConnection.GetProvider"
		size = 34
		refs = "0009 @WStrClr 001b @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1549_0 {
	meta:
		name = "TADOConnection.SetProvider"
		size = 106
		refs = "000f TADOConnection.SetProvider 001f TADOConnection.GetProvider 0029 @WStrEqual 0032 TADOConnection.CheckInactive 0044 @CheckAutoResult 0059 @WStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 74 19 8B C3 E8 ?? ?? ?? ?? 56 8B 43 74 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1550_0 {
	meta:
		name = "TADOConnection.IsProviderStored"
		size = 180
		refs = "000e TADOConnection.IsProviderStored 0029 TADOConnection.GetProvider 0036 @WStrEqual 0073 @WStrArrayClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 3C 84 C0 74 1E 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 95 C0 8B D8 EB 1C 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5B 59 59 5D C3 00 00 12 00 00 00 4D 00 53 00 44 00 41 00 53 00 51 00 4C 00 2E 00 31 00 00 00 0E 00 00 00 4D 00 53 00 44 00 41 00 53 00 51 00 4C 00 00 00 }
	condition:
		$1
}

rule function_1551_0 {
	meta:
		name = "TADOConnection.GetState"
		size = 39
		refs = "0013 @CheckAutoResult 001b GetStates"
	strings:
		$1 = { 53 56 51 8B F0 54 8B 46 74 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 8B 04 24 E8 ?? ?? ?? ?? 8B D8 8B C3 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1552_0 {
	meta:
		name = "TADOConnection.GetVersion"
		size = 31
		refs = "0009 @WStrClr 0018 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1553_0 {
	meta:
		name = "TADOConnection.SetKeepConnection"
		size = 26
	strings:
		$1 = { 56 8B F0 3A 96 94 00 00 00 74 0D 88 96 94 00 00 00 8B C6 8B 10 FF 52 54 5E C3 }
	condition:
		$1
}

rule function_1554_0 {
	meta:
		name = "TRDSConnection.Create"
		size = 116
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 001c TRDSConnection.Create 0023 TRDSConnection.SetServerName 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 00 00 00 2A 00 00 00 52 00 44 00 53 00 53 00 65 00 72 00 76 00 65 00 72 00 2E 00 44 00 61 00 74 00 61 00 46 00 61 00 63 00 74 00 6F 00 72 00 79 00 00 00 }
	condition:
		$1
}

rule function_34534_0 {
	meta:
		name = "TChunkgAMA.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TChunk.Create 0023 TChunkgAMA.SetValue 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 01 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23808_0 {
	meta:
		name = "TGrayScaleLookup.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TColorLookup.Create 0023 TColorLookup.SetColors 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 00 01 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23806_0 {
	meta:
		name = "TGrayWindowsLookup.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TSlowColorLookup.Create 0023 TColorLookup.SetColors 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 04 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23810_0 {
	meta:
		name = "TMonochromeLookup.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TColorLookup.Create 0023 TColorLookup.SetColors 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 02 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23804_0 {
	meta:
		name = "TNetscapeColorLookup.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TColorLookup.Create 0023 TColorLookup.SetColors 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA D8 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35924_0 {
	meta:
		name = "TRibbonGripItem.Create"
		size = 65
		refs = "000a @ClassCreate 0017 TCustomActionControl.Create 0023 TControl.SetHeight 002e @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? BA 0A 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1555_0 {
	meta:
		name = "TRDSConnection.Destroy"
		size = 66
		refs = "0003 @BeforeDestruction 000e TComponent.Destroying 0015 TCustomConnection.Close 001c TRDSConnection.ClearRefs 0024 @IntfClear 0030 TCustomConnection.Destroy 003b @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8D 46 70 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1557_0 {
	meta:
		name = "TRDSConnection.ClearRefs"
		size = 68
		refs = "001e _DV_TADODataSet 0023 @IsClass 0037 TADODataSet.SetRDSConnection"
	strings:
		$1 = { 53 56 8B F0 8B C6 8B 10 FF 52 44 8B D8 4B 83 FB 00 7C 2E 8B D3 8B C6 8B 08 FF 51 40 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 10 8B D3 8B C6 8B 08 FF 51 40 33 D2 E8 ?? ?? ?? ?? 4B 83 FB FF 75 D2 5E 5B C3 }
	condition:
		$1
}

rule function_1558_0 {
	meta:
		name = "TRDSConnection.DoConnect"
		size = 188
		refs = "0011 TRDSConnection.DoConnect 0025 CLASS_DataSpace 002a CreateADOObject 003a @IntfCast 004f @CheckAutoResult 0057 @VarClr 007c @VarCopy 0099 @IntfClear 009f @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 70 00 75 1D 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8D 43 70 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 83 90 00 00 00 50 8B 43 70 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 50 8B 43 74 50 8B 43 78 50 8B 43 70 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8D 55 EC 8D 83 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 00 00 56 C5 96 BD A3 65 D0 11 98 3A 00 C0 4F C2 9E 34 }
	condition:
		$1
}

rule function_1559_0 {
	meta:
		name = "TRDSConnection.DoDisconnect"
		size = 11
		refs = "0006 @VarClear"
	strings:
		$1 = { 05 80 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1560_0 {
	meta:
		name = "TRDSConnection.GetConnected"
		size = 18
		refs = "000a VarIsClear"
	strings:
		$1 = { 53 8B D8 8D 83 80 00 00 00 E8 ?? ?? ?? ?? 34 01 5B C3 }
	condition:
		$1
}

rule function_1561_0 {
	meta:
		name = "GetFromDataFactory"
		size = 168
		refs = "0011 GetFromDataFactory 0041 @DispInvoke 004f @VarToIntf 005e @IntfCast 0073 @VarClr 007b @IntfClear 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 00 8B 45 08 8B 40 F8 50 8B 45 08 83 C0 FC 50 68 ?? ?? ?? ?? 8B 45 08 8B 40 F4 05 80 00 00 00 50 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 18 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 01 03 00 88 08 03 51 75 65 72 79 00 56 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_1562_0 {
	meta:
		name = "GetFromProperty"
		size = 332
		refs = "0025 tagEXCEPINFO 002a @InitializeRecord 0032 GetFromProperty 004c @VarToIntf 005c @IntfCast 006b @FillChar 007f GUID_NULL 008e OleCheck 00c2 DispatchInvokeError 00f2 IInterface 00fc @FinalizeArray 010a @FinalizeRecord 0112 @VarClr 011a @IntfClear 0120 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 AC 53 33 D2 89 55 AC 89 55 B0 89 55 E8 89 55 EC 89 55 F0 89 55 F4 89 55 FC 8B D8 8D 45 C8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 B0 8B 55 08 8B 52 F4 81 C2 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 B0 8D 45 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 B4 33 C9 BA 10 00 00 00 E8 ?? ?? ?? ?? 8D 45 C4 50 6A 00 6A 01 8B 45 08 83 C0 F8 50 A1 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 14 E8 ?? ?? ?? ?? 6A 00 8D 45 C8 50 8D 45 E8 50 8D 45 B4 50 6A 02 68 00 04 00 00 A1 ?? ?? ?? ?? 50 8B 45 C4 50 8B 45 FC 50 8B 00 FF 50 18 85 C0 74 08 8D 55 C8 E8 ?? ?? ?? ?? 8D 45 AC 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 AC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C7 5B 8B E5 5D C3 00 00 04 02 00 00 00 00 00 C0 00 00 00 00 00 00 46 56 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_1563_0 {
	meta:
		name = "TRDSConnection.GetRecordset"
		size = 178
		refs = "001f @WStrAddRef 0027 TRDSConnection.GetRecordset 0041 TCustomConnection.Open 0056 GetFromProperty 0061 @IntfCopy 006c GetFromDataFactory 008d _Recordset 0097 @FinalizeArray 009f @WStrClr 00a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 33 DB 89 5D EC 89 5D F0 89 4D FC 89 55 F8 89 45 F4 8B 5D 08 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 8B 10 FF 52 3C 84 C0 75 08 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 80 B8 94 00 00 00 00 74 16 55 8D 45 F0 E8 ?? ?? ?? ?? 59 8B 55 F0 8B C3 E8 ?? ?? ?? ?? EB 14 55 8D 45 EC E8 ?? ?? ?? ?? 59 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1564_0 {
	meta:
		name = "TRDSConnection.SetComputerName"
		size = 26
		refs = "0009 TRDSConnection.CheckInactive 0013 @WStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 43 74 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_9096_0 {
	meta:
		name = "TField.SetLookupResultField"
		size = 26
		refs = "0009 TField.CheckInactive 0013 @UStrAsg"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8D 43 74 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1565_0 {
	meta:
		name = "TRDSConnection.SetServerName"
		size = 200
		refs = "0013 TRDSConnection.SetServerName 0020 TRDSConnection.CheckInactive 002a @WStrAsg 0037 UpperCase 0045 @UStrFromWStr 0059 Pos 007d @UStrArrayClr 0083 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 43 78 8B D6 E8 ?? ?? ?? ?? 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8D 45 F4 8B D6 E8 ?? ?? ?? ?? 8B 45 F4 8D 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 48 0F 95 C0 88 83 94 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 15 00 00 00 52 00 44 00 53 00 53 00 65 00 72 00 76 00 65 00 72 00 2E 00 44 00 61 00 74 00 61 00 46 00 61 00 63 00 74 00 6F 00 72 00 79 00 00 00 }
	condition:
		$1
}

rule function_1566_0 {
	meta:
		name = "TParameters.Create_Parameter"
		size = 177
		refs = "0020 TParameters.Create_Parameter 002e @IntfClear 0037 Null 0042 @OleVarFromVar 005d ValidDirectionValues 0068 DataTypeValues 0071 TParameters.GetCommand 007f @CheckAutoResult 0094 @VarClr 00a2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 8D 45 E0 E8 ?? ?? ?? ?? 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 0F B6 45 10 8B 04 85 ?? ?? ?? ?? 50 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 56 8B C7 E8 ?? ?? ?? ?? 8B 40 34 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1567_0 {
	meta:
		name = "TParameters.Refresh"
		size = 120
		refs = "000e TParameters.GetCommand 0022 TParameters.Refresh 003f TParameters.InternalRefresh 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? B1 01 BA 04 00 00 00 8B 18 FF 53 40 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 D2 8B 08 FF 51 34 8B 45 FC E8 ?? ?? ?? ?? 88 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C9 BA 04 00 00 00 8B 18 FF 53 40 C3 E9 ?? ?? ?? ?? EB E4 0F B6 45 FB 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1568_0 {
	meta:
		name = "RefreshFromOleDB"
		size = 804
		refs = "0017 RefreshFromOleDB 0025 @IntfClear 0031 TParameters.GetCommand 0041 @IntfCast 004f @CheckAutoResult 0117 IntToStr 0127 @UStrCat3 0132 @WStrFromUStr 013e @WStrFromPWChar 0184 EmptyParam 0202 TParameters.AddParameter 020d @IntfCopy 0242 GlobalMalloc 0263 @HandleFinally 027f @UStrArrayClr 02b7 @WStrClr"
	strings:
		$1 = { 55 8B EC B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 D8 E8 ?? ?? ?? ?? 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 50 34 8D 45 D4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 D4 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 8B 55 D8 8D 45 F4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 10 6A 00 6A 00 6A 00 8B 45 F0 50 8B 00 FF 50 14 83 7D F0 00 0F 84 D7 01 00 00 33 C0 89 45 E4 33 C0 89 45 E0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 10 83 7D EC 00 74 0B 6A 00 8B 45 EC 50 8B 00 FF 50 0C 8D 45 E0 50 8D 45 E4 50 8D 45 E8 50 8B 45 F0 50 8B 00 FF 50 0C 85 C0 0F 85 2D 01 00 00 8B 45 E8 48 85 C0 0F 8C 21 01 00 00 40 89 45 DC 33 F6 8D 04 76 8B 55 E4 8D 1C C2 8B 7B 08 85 FF 75 28 8D 55 CC 8D 46 01 E8 ?? ?? ?? ?? 8B 4D CC 8D 45 D0 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 D0 8D 45 FC E8 ?? ?? ?? ?? EB 0A 8D 45 FC 8B D7 E8 ?? ?? ?? ?? 66 81 7B 14 80 00 75 06 66 C7 43 14 CC 00 66 81 7B 14 81 00 75 06 66 C7 43 14 C8 00 66 81 7B 14 82 00 75 06 66 C7 43 14 CA 00 8B 3B 83 E7 0F 85 FF 75 05 BF 01 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 43 10 50 57 0F B7 43 14 50 8B 45 FC 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 40 34 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 0F B6 43 16 50 8B 45 F8 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8D 04 76 8B 55 E4 0F B6 44 C2 17 50 8B 45 F8 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 8B 03 83 E0 F0 50 8B 45 F8 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C0 0C 8B 55 F8 E8 ?? ?? ?? ?? 46 FF 4D DC 0F 85 E5 FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D EC 00 74 09 8B 45 EC 50 8B 00 FF 50 10 83 7D E4 00 74 0F 8B 45 E4 50 A1 ?? ?? ?? ?? 50 8B 00 FF 50 14 83 7D E0 00 74 0F 8B 45 E0 50 A1 ?? ?? ?? ?? 50 8B 00 FF 50 14 C3 E9 ?? ?? ?? ?? EB BF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B3 5F 5E 5B 8B E5 5D C3 00 00 17 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 63 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D 64 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D 26 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D B0 04 02 00 FF FF FF FF 05 00 00 00 50 00 61 00 72 00 61 00 6D 00 00 00 }
	condition:
		$1
}

rule function_1569_0 {
	meta:
		name = "RefreshFromADO"
		size = 619
		refs = "0017 RefreshFromADO 0028 TParameters.GetCommand 0033 @IntfCopy 0049 @IntfClear 0058 @CheckAutoResult 00b3 @OleVarFromInt 00f2 EmptyParam 0147 @WStrClr 01e1 TParameters.AddParameter 0203 @HandleAnyException 0208 @DoneExcept 022d @VarClr 024e _Parameter 0258 @FinalizeArray 025e @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 07 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 50 34 8D 45 F4 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 45 F4 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 45 F0 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8D 45 EC 50 8D 45 E8 E8 ?? ?? ?? ?? 50 8B 45 F4 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 45 E8 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D EC 4B 85 DB 0F 8C 59 01 00 00 43 33 F6 8D 45 F8 E8 ?? ?? ?? ?? 50 8D 45 D8 8B D6 B1 FC E8 ?? ?? ?? ?? FF 75 E4 FF 75 E0 FF 75 DC FF 75 D8 8D 45 D4 E8 ?? ?? ?? ?? 50 8B 45 F4 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 45 D4 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 45 EC 50 8B 45 F8 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 EC 50 8D 45 D0 50 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 8B 45 D0 50 8D 45 CC 50 8B 45 F8 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 CC 50 8D 45 C8 E8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 45 C8 50 8B 45 F4 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 8D 45 C4 50 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B6 45 C4 50 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8D 45 C4 50 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 0F B6 45 C4 50 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 8D 45 EC 50 8B 45 F8 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 8B 45 EC 50 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 83 C0 0C 8B 55 FC E8 ?? ?? ?? ?? 46 4B 0F 85 AA FE FF FF 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1570_0 {
	meta:
		name = "TParameters.InternalRefresh"
		size = 123
		refs = "0015 TParameters.InternalRefresh 0023 TCollection.Clear 002b TParameters.GetCommand 0030 TADOCommand.GetCommandType 003a RefreshFromOleDB 0043 RefreshFromADO 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 8B 10 FF 52 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3C 01 75 09 55 E8 ?? ?? ?? ?? 59 EB 07 55 E8 ?? ?? ?? ?? 59 8B 45 FC 8B 40 08 83 78 08 00 0F 9F 45 FB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 52 24 C3 E9 ?? ?? ?? ?? EB F0 0F B6 45 FB 59 59 5D C3 }
	condition:
		$1
}

rule function_1571_0 {
	meta:
		name = "TParameters.Update"
		size = 5
	strings:
		$1 = { C6 40 1C 01 C3 }
	condition:
		$1
}

rule function_1573_0 {
	meta:
		name = "TParameters.AppendParameters"
		size = 396
		refs = "0019 TParameters.AppendParameters 0051 TParameters.Create_Parameter 0060 TParameters.GetParamCollection 006e @CheckAutoResult 00a0 @OleVarFromInt 00da @HandleAnyException 00df @DoneExcept 00fa TParameters.GetItem 0102 TParameter.GetParameter 013f @IntfClear 0157 @VarClr 0175 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 06 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 78 1C 00 0F 84 FE 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 01 6A 00 8D 45 F8 50 B1 03 BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 50 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8D 45 F0 50 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D F0 4B 83 FB 00 7C 37 8D 45 DC 8B D3 B1 FC E8 ?? ?? ?? ?? FF 75 E8 FF 75 E4 FF 75 E0 FF 75 DC 8D 55 D8 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 4B 83 FB FF 75 C9 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 40 08 8B 70 08 4E 85 F6 7C 36 46 33 DB 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8D 55 D4 E8 ?? ?? ?? ?? 8B 45 D4 50 8D 55 D0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 D0 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 43 4E 75 CD 8B 45 FC C6 40 1C 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 5F 5E 5B 8B E5 5D C3 00 00 02 00 00 00 5F 00 00 00 }
	condition:
		$1
}

rule function_1574_0 {
	meta:
		name = "TParameters.CreateParameter"
		size = 189
		refs = "0023 @VarAddRef 002b TParameters.CreateParameter 0038 TParameters.AddParameter 0054 TParameters.Create_Parameter 005f @IntfCopy 0089 @CheckAutoResult 009e @IntfClear 00a6 @VarClr 00ac @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 33 DB 89 5D E8 8B 75 08 8D 7D F0 A5 A5 A5 A5 88 4D EF 8B FA 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B F0 0F B6 45 10 50 8B 45 0C 50 8D 45 E8 50 0F B6 4D EF 8B D7 8B C3 E8 ?? ?? ?? ?? 8B 55 E8 8D 46 0C E8 ?? ?? ?? ?? 66 83 7D F0 0A 75 09 81 7D F8 04 00 02 80 74 1A FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 46 0C 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1575_0 {
	meta:
		name = "TParameters.AssignValues"
		size = 145
		refs = "0018 TParameters.AssignValues 0039 TParameters.GetItem 0041 TParameter.GetName 004c TParameters.FindParam 007e @WStrClr 0084 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 C9 89 4D F4 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 8B 40 08 8B 78 08 4F 85 FF 7C 3D 47 33 DB 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8B C6 8B 08 FF 51 08 43 4F 75 C6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1576_0 {
	meta:
		name = "TParameters.IsEqual"
		size = 75
		refs = "002a TParameters.GetItem 003a TParameter.IsEqual"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 47 08 8B 50 08 8B 45 08 3B 50 08 0F 94 C0 84 C0 74 2B 8B F2 4E 85 F6 7C 24 46 33 DB 8B D3 8B C5 E8 ?? ?? ?? ?? 50 8B D3 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 84 C0 74 04 43 4E 75 DF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_9680_0 {
	meta:
		name = "TParams.IsEqual"
		size = 75
		refs = "002a TParams.GetItem 003a TParam.IsEqual"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F8 8B 47 08 8B 50 08 8B 45 08 3B 50 08 0F 94 C0 84 C0 74 2B 8B F2 4E 85 F6 7C 24 46 33 DB 8B D3 8B C5 E8 ?? ?? ?? ?? 50 8B D3 8B C7 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 84 C0 74 04 43 4E 75 DF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1577_0 {
	meta:
		name = "TParameters.FindParam"
		size = 171
		refs = "0017 TParameters.FindParam 0038 TCollection.GetItem 0044 TParameter.GetName 004f @UStrFromWStr 0067 CompareText 0086 @UStrClr 008e @WStrClr 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 57 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 08 8B 58 08 4B 85 DB 7C 44 43 33 FF 8B D7 8B 45 FC E8 ?? ?? ?? ?? 8B F0 8D 55 F0 8B C6 E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F4 E8 ?? ?? ?? ?? 8B 45 F4 50 8D 45 EC 8B 55 F8 E8 ?? ?? ?? ?? 8B 55 EC 58 E8 ?? ?? ?? ?? 85 C0 74 06 47 4B 75 BF 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1578_0 {
	meta:
		name = "GetComponent"
		size = 58
		refs = "000b TParameters.GetCommand 001a _DV_TCustomADODataSet 001f @IsClass"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B D8 85 DB 74 20 8B 43 04 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 58 04 8B C3 5B 5D C3 }
	condition:
		$1
}

rule function_1579_0 {
	meta:
		name = "TParameters.ParamByName"
		size = 128
		refs = "0016 TParameters.ParamByName 0026 TParameters.FindParam 0032 GetComponent 003c SParameterNotFound 0041 LoadResString 0057 DatabaseErrorFmt 006c @UStrClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 33 C9 89 4D F8 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B D8 85 DB 75 2B 55 E8 ?? ?? ?? ?? 59 50 8D 55 F8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 50 89 75 F0 C6 45 F4 0F 8D 55 F0 33 C9 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1580_0 {
	meta:
		name = "TParameters.GetParamList"
		size = 123
		refs = "0018 TParameters.GetParamList 0034 ExtractFieldName 003e TParameters.ParamByName 0047 TList.Add 004e @WStrLen 0068 @WStrClr 006e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B D9 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 FC 01 00 00 00 EB 20 8D 4D F8 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C7 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 3B 45 FC 7D D4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1581_0 {
	meta:
		name = "TParameters.GetParamValue"
		size = 276
		refs = "001e TParameters.GetParamValue 0030 Pos 003f _Dn_TList 0044 TObject.Create 0061 TParameters.GetParamList 0082 VarArrayCreate 009d TList.Get 00a5 TParameter.GetValue 00af @VarArrayPut 00cb TObject.Free 00d1 @HandleFinally 00dc TParameters.ParamByName 00f8 @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 9B 00 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 57 33 C0 89 45 F4 8B 45 FC 8B 40 08 48 89 45 F8 8D 45 F4 66 B9 0C 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B 45 FC 8B 70 08 4E 85 F6 7C 29 46 33 DB 53 6A 01 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8D 55 E4 E8 ?? ?? ?? ?? 8D 45 E4 50 57 E8 ?? ?? ?? ?? 83 C4 10 43 4E 75 DA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 00 02 00 00 00 3B 00 00 00 }
	condition:
		$1
}

rule function_1582_0 {
	meta:
		name = "TParameters.SetParamValue"
		size = 236
		refs = "001a TParameters.SetParamValue 002c Pos 0037 _Dn_TList 003c TObject.Create 0059 TParameters.GetParamList 0071 TList.Get 007f @VarArrayGet 008b TParameter.SetValue 00a4 TObject.Free 00aa @HandleFinally 00b5 TParameters.ParamByName 00d1 @VarClr"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D6 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 7C B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CE 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 8B 70 08 4E 85 F6 7C 2B 46 33 DB 8B D3 8B 45 FC E8 ?? ?? ?? ?? 50 53 6A 01 57 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 EC 58 E8 ?? ?? ?? ?? 43 4E 75 D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B D6 8B C3 E8 ?? ?? ?? ?? 8B D7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 02 00 00 00 3B 00 00 00 }
	condition:
		$1
}

rule function_1583_0 {
	meta:
		name = "NameDelimiter"
		size = 43
	strings:
		$1 = { 0F B7 C0 83 F8 29 7F 13 74 1B 83 E8 0A 74 16 83 E8 03 74 11 83 E8 13 74 0C EB 0D 83 E8 2C 74 05 83 E8 0F 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_1584_0 {
	meta:
		name = "TParameters.ParseSQL"
		size = 516
		refs = "0021 TParameters.ParseSQL 002f @WStrClr 003d TCollection.Clear 0045 @WStrToPWChar 00fb @WStrCopy 0110 @WStrCatN 0144 NameDelimiter 016a @WStrFromPWCharLen 0180 TParameters.AddParameter 0188 TParameter.SetName 01c1 @WStrCat 01de @WStrArrayClr 01ec @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 DB 89 5D DC 89 5D E0 89 5D FC 88 4D F3 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 80 7D F3 00 74 08 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 89 45 EC 8B 45 EC 89 45 E8 8B 5D EC 0F B7 03 83 F8 27 7F 0E 74 1B 83 E8 01 72 16 83 E8 21 74 11 EB 0A 83 E8 3A 74 0A 83 E8 26 74 05 83 C3 02 EB DB 0F B7 03 83 F8 27 7F 12 74 1C 83 E8 01 0F 82 07 01 00 00 83 E8 21 74 0E EB C1 83 E8 3A 74 2C 83 E8 26 74 02 EB B5 0F B7 3B 83 C3 02 EB 03 83 C3 02 66 83 3B 00 74 05 66 3B 3B 75 F2 66 83 3B 00 0F 84 D4 00 00 00 83 C3 02 EB 90 83 C3 02 66 83 3B 3A 75 05 83 C3 02 EB 82 8B 45 08 FF 30 8D 45 E0 50 8B CB 2B 4D EC D1 F9 79 03 83 D1 00 49 8B 55 EC 2B 55 E8 D1 FA 79 03 83 D2 00 42 8B 45 F4 E8 ?? ?? ?? ?? FF 75 E0 68 ?? ?? ?? ?? 8B 45 08 BA 03 00 00 00 E8 ?? ?? ?? ?? 33 FF 0F B7 03 66 83 E8 22 74 0C 66 83 E8 05 74 06 66 83 E8 39 75 06 0F B7 3B 83 C3 02 89 5D E4 0F B7 33 66 85 F6 74 1B 66 3B FE 74 16 8B C6 E8 ?? ?? ?? ?? 84 C0 75 0B 83 C3 02 0F B7 33 66 85 F6 75 E5 8B CB 2B 4D E4 D1 F9 79 03 83 D1 00 8D 45 FC 8B 55 E4 E8 ?? ?? ?? ?? 66 85 FF 74 03 83 C3 02 80 7D F3 00 74 10 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 FC E8 ?? ?? ?? ?? 89 5D EC E9 C1 FE FF FF 8D 45 DC 50 8B CB 2B 4D EC D1 F9 79 03 83 D1 00 8B 55 EC 2B 55 E8 D1 FA 79 03 83 D2 00 42 8B 45 F4 E8 ?? ?? ?? ?? 8B 55 DC 8B 45 08 E8 ?? ?? ?? ?? 8B 45 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C2 04 00 00 02 00 00 00 3F 00 00 00 }
	condition:
		$1
}

rule function_1585_0 {
	meta:
		name = "TParameters.GetAttr"
		size = 51
		refs = "000f sNameAttr 0014 LoadResString 001d sValueAttr 002d @UStrAsg"
	strings:
		$1 = { 53 8B D9 83 EA 01 72 04 74 10 EB 1C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 8B C3 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_12473_0 {
	meta:
		name = "THTMLTableColumns.GetAttr"
		size = 51
		refs = "000f sFieldNameColumn 0014 LoadResString 001d sFieldTypeColumn 002d @UStrAsg"
	strings:
		$1 = { 53 8B D9 83 EA 01 72 04 74 10 EB 1C 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 8B C3 33 D2 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1586_0 {
	meta:
		name = "TBooleanField.GetDataSize"
		size = 6
		altNames = "THTMLTableColumns.GetAttrCount TIBTransactionEditor.GetVerbCount TIBUpdateSQLEditor.GetVerbCount TParameters.GetAttrCount TSmallintField.GetDataSize TWordField.GetDataSize"
	strings:
		$1 = { B8 02 00 00 00 C3 }
	condition:
		$1
}

rule function_1587_0 {
	meta:
		name = "TParameters.GetItemAttr"
		size = 191
		refs = "001d TParameters.GetItemAttr 0035 TParameters.GetItem 003d TParameter.GetName 0047 @UStrFromWStr 0055 IntToStr 0068 TParameter.GetValue 0073 VarToWideStr 0088 @UStrAsg 009d @VarClr 00aa @WStrArrayClr 00b0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B D8 8B 75 08 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 EA 01 72 04 74 2D EB 53 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 83 3E 00 75 3C 8B D6 8B C7 E8 ?? ?? ?? ?? EB 31 8B D7 8B C3 E8 ?? ?? ?? ?? 8D 55 E8 E8 ?? ?? ?? ?? 8D 45 E8 8D 55 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B C6 E8 ?? ?? ?? ?? EB 09 8B C6 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1588_0 {
	meta:
		name = "TParameters.GetCommand"
		size = 29
		refs = "000b @CallDynaInst 0011 _DV_TADOCommand 0016 @AsClass"
	strings:
		$1 = { 53 56 8B D8 8B C3 66 BE FF FF E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20902_0 {
	meta:
		name = "TCellCollection.Owner"
		size = 29
		refs = "000b @CallDynaInst 0011 _DV_TCustomGridPanel 0016 @AsClass"
	strings:
		$1 = { 53 56 8B D8 8B C3 66 BE FF FF E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1591_0 {
	meta:
		name = "TParameters.GetParamCollection"
		size = 38
		refs = "0009 @IntfClear 0011 TParameters.GetCommand 001f @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B 40 34 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1592_0 {
	meta:
		name = "TParameter.AppendChunk"
		size = 127
		refs = "001d @VarAddRef 0025 TParameter.AppendChunk 0041 TParameter.GetParameter 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1593_0 {
	meta:
		name = "AssignParameter"
		size = 224
		refs = "0018 AssignParameter 0025 TParameter.GetAttributes 002e TParameter.SetAttributes 0035 TParameter.GetDataType 0049 TParameter.SetDataType 0050 TParameter.GetParameterDirection 0059 TParameter.SetParameterDirection 0063 TParameter.GetName 006d TParameter.SetName 0074 TParameter.GetNumericScale 007d TParameter.SetNumericScale 0084 TParameter.GetPrecision 008d TParameter.SetPrecision 0094 TParameter.GetSize 009d TParameter.SetSize 00a7 TParameter.GetValue 00b1 TParameter.SetValue 00c6 @VarClr 00ce @WStrClr 00d4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B D8 8B 75 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B 06 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8D 55 EC 8B 06 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1594_0 {
	meta:
		name = "AssignField"
		size = 125
		refs = "0010 AssignField 0025 TParameter.SetDataType 003c TParameter.SetSize 0057 TParameter.SetValue 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 0F B6 53 44 E8 ?? ?? ?? ?? 8B C3 8B 10 FF 92 A8 00 00 00 8B D0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 F0 8B C3 8B 08 FF 91 84 00 00 00 8D 55 F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1595_0 {
	meta:
		name = "AssignParam"
		size = 236
		refs = "0018 AssignParam 0025 TParam.GetParamType 0032 TParameter.SetParameterDirection 004f @WStrFromUStr 0059 TParameter.SetName 0067 TParameter.SetAttributes 0072 TParameter.SetNumericScale 007d TParameter.SetPrecision 0087 TParameter.SetSize 0091 TParam.GetAsVariant 009b TParameter.SetValue 00a2 TParameter.GetDataType 00ad TParam.GetDataType 00b6 TParameter.SetDataType 00cb @VarClr 00d3 @WStrClr 00d9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B D8 8B 75 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 84 C0 75 0B 8B 06 B2 01 E8 ?? ?? ?? ?? EB 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 8D 45 FC 8B 53 34 E8 ?? ?? ?? ?? 8B 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 06 0F B6 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 0F B6 53 2C E8 ?? ?? ?? ?? 8B 06 0F B6 53 28 E8 ?? ?? ?? ?? 8B 06 8B 53 3C E8 ?? ?? ?? ?? 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8D 55 EC 8B 06 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 84 C0 75 10 8B C3 E8 ?? ?? ?? ?? 8B D0 8B 06 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1596_0 {
	meta:
		name = "LoadFromStreamPersist"
		size = 95
		refs = "000a _Dn_TMemoryStream 000f TObject.Create 001a LoadFromStreamPersist 003a TParameter.LoadFromStream 004f TObject.Free 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 8B 08 FF 51 10 8B 45 08 8B 40 FC B1 11 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_9712_0 {
	meta:
		name = "LoadFromStreamPersist"
		size = 95
		refs = "000a _Dn_TMemoryStream 000f TObject.Create 001a LoadFromStreamPersist 003a TParam.LoadFromStream 004f TObject.Free 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B C3 8B 08 FF 51 10 8B 45 08 8B 40 FC B1 11 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1597_0 {
	meta:
		name = "LoadFromStrings"
		size = 117
		refs = "0011 LoadFromStrings 002c @VarFromUStr 003a TParameter.SetValue 0047 TParameter.SetDataType 005c @UStrClr 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 8B 08 FF 51 1C 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 8D 55 F0 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1598_0 {
	meta:
		name = "TParameter.Assign"
		size = 244
		refs = "0015 TParameter.Assign 0023 _DV_TParameter 0028 @IsClass 0034 AssignParameter 0042 _Dn_TField 0053 AssignField 005e _Dn_TParam 006f AssignParam 007a _Dn_TStrings 008b LoadFromStrings 0096 @IntfClear 00a4 Supports 00b1 LoadFromStreamPersist 00be TPersistent.Assign 00d9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 C9 89 4D F8 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0E 55 8B C3 E8 ?? ?? ?? ?? 59 E9 84 00 00 00 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 68 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 4C 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 30 8D 45 F8 E8 ?? ?? ?? ?? 8B C8 BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 0C 55 8B 45 F8 E8 ?? ?? ?? ?? 59 EB 0A 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 59 5D C3 A3 12 CD B8 7A 26 D4 11 83 DA 00 C0 4F 60 B2 DD }
	condition:
		$1
}

rule function_1599_0 {
	meta:
		name = "AssignToParam"
		size = 186
		refs = "0018 AssignToParam 0028 TParameter.GetName 0033 @UStrFromWStr 003a TParameter.GetParameterDirection 0043 TParam.SetParamType 004a TParameter.GetDataType 0053 TParam.SetDataType 005a TParameter.GetSize 0064 TParameter.GetPrecision 0071 TParameter.GetNumericScale 0081 TParameter.GetValue 008b TParam.SetAsVariant 00a0 @VarClr 00a8 @WStrClr 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B D8 8B 75 08 83 C6 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B 06 E8 ?? ?? ?? ?? 8B 55 FC 8D 43 34 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 89 43 3C 8B 06 E8 ?? ?? ?? ?? 0F B6 C0 89 43 28 8B 06 E8 ?? ?? ?? ?? 0F B6 C0 89 43 2C 8D 55 EC 8B 06 E8 ?? ?? ?? ?? 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1600_0 {
	meta:
		name = "TParameter.AssignTo"
		size = 145
		refs = "0014 TParameter.AssignTo 0022 _Dn_TField 0027 @IsClass 0036 TParameter.GetValue 004d _Dn_TParam 005e AssignToParam 006b TPersistent.AssignTo 0080 @VarClr 0086 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B DA 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1A 8D 55 EC 8B 45 FC E8 ?? ?? ?? ?? 8D 55 EC 8B C3 8B 08 FF 91 F4 00 00 00 EB 26 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 0A 8B D3 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1601_0 {
	meta:
		name = "TParameter.LoadFromFile"
		size = 89
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TParameter.LoadFromFile 0033 TParameter.LoadFromStream 0048 TObject.Free 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B D9 8B F0 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9775_0 {
	meta:
		name = "TParam.LoadFromFile"
		size = 89
		refs = "000f _Dn_TFileStream 0016 TFileStream.Create 0021 TParam.LoadFromFile 0033 TParam.LoadFromStream 0048 TObject.Free 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 8B D9 8B F0 6A 00 8B CA A1 ?? ?? ?? ?? B2 01 E8 ?? ?? ?? ?? 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B CB 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1602_0 {
	meta:
		name = "TParameter.LoadFromStream"
		size = 397
		refs = "0021 TParameter.LoadFromStream 0032 TParameter.SetDataType 003d TStream.SetPosition 0075 @LStrSetLength 0081 TStream.ReadBuffer 008c @VarFromLStr 0096 TParameter.SetValue 00ac @WStrSetLength 00c3 @VarFromWStr 00ef VarArrayCreate 00fa @OleVarFromVar 0102 VarArrayLock 013a VarArrayUnlock 0140 @HandleFinally 0158 Variant 0162 @FinalizeArray 016a @VarClr 0172 @WStrClr 017a @LStrClr"
	strings:
		$1 = { 55 8B EC 51 B9 0A 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 88 4D E7 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 55 E7 8B C6 E8 ?? ?? ?? ?? 6A 00 6A 00 8B C7 E8 ?? ?? ?? ?? 8B C7 8B 10 FF 12 8B D8 0F B6 45 E7 83 F8 17 7F 0C 74 19 48 74 16 83 E8 0F 74 11 EB 75 83 E8 18 74 3C 83 C0 F2 83 E8 02 72 34 EB 66 8D 45 FC 33 C9 8B D3 E8 ?? ?? ?? ?? 8B 55 FC 8B CB 8B C7 E8 ?? ?? ?? ?? 8D 45 D4 8B 55 FC E8 ?? ?? ?? ?? 8D 55 D4 8B C6 E8 ?? ?? ?? ?? E9 A7 00 00 00 8B D3 D1 FA 79 03 83 D2 00 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B CB 8B C7 E8 ?? ?? ?? ?? 8D 45 C4 8B 55 F8 E8 ?? ?? ?? ?? 8D 55 C4 8B C6 E8 ?? ?? ?? ?? EB 73 8D 45 B4 50 33 C0 89 45 AC 8B C3 48 89 45 B0 8D 45 AC 66 B9 11 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8D 55 B4 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B D0 8B CB 8B C7 E8 ?? ?? ?? ?? 8D 55 E8 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 B4 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB CD 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1603_0 {
	meta:
		name = "TParameter.IsEqual"
		size = 389
		refs = "001a TParameter.IsEqual 002a TParameter.GetValue 0053 VarIsClear 0078 @VarCmpEQ 0092 TParameter.GetName 00a9 @WStrEqual 00bb TParameter.GetDataType 00d8 TParameter.GetParameterDirection 00f5 TParameter.GetNumericScale 0112 TParameter.GetPrecision 012f TParameter.GetSize 015d @WStrArrayClr 0166 Variant 0170 @FinalizeArray 0176 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 0B 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 0F B7 7D F0 8D 55 E0 8B C6 E8 ?? ?? ?? ?? 0F B7 45 E0 66 3B C7 75 41 8D 55 D0 8B C3 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 84 C0 75 27 8D 55 C0 8B C3 E8 ?? ?? ?? ?? 8D 45 C0 50 8D 55 B0 8B C6 E8 ?? ?? ?? ?? 8D 55 B0 58 E8 ?? ?? ?? ?? 74 04 33 C0 EB 06 B0 01 EB 02 33 C0 84 C0 74 26 8D 55 AC 8B C3 E8 ?? ?? ?? ?? 8B 45 AC 50 8D 55 A8 8B C6 E8 ?? ?? ?? ?? 8B 55 A8 58 E8 ?? ?? ?? ?? 0F 94 C0 EB 02 33 C0 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 3A D0 0F 94 C0 EB 02 33 C0 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 3A D0 0F 94 C0 EB 02 33 C0 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 3A D0 0F 94 C0 EB 02 33 C0 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 5A 3A D0 0F 94 C0 EB 02 33 C0 84 C0 74 17 8B C3 E8 ?? ?? ?? ?? 8B D8 8B C6 E8 ?? ?? ?? ?? 3B D8 0F 94 C0 EB 02 33 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 A8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 B0 8B 15 ?? ?? ?? ?? B9 05 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1604_0 {
	meta:
		name = "TParameter.GetAttributes"
		size = 172
		refs = "0014 TParameter.GetAttributes 0032 TParameter.GetParameter 0040 @CheckAutoResult 004e ParameterAttributeValues 008e @IntfClear 0094 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 D2 89 55 F4 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 05 ?? ?? ?? ?? 88 45 FF 8D 45 F8 50 8D 55 F4 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 8B 7D F8 85 FF 74 32 33 DB BE ?? ?? ?? ?? 85 3E 74 1E 8B C3 3C 07 77 18 83 E0 7F 8D 55 FF 8B CA 83 E1 03 2B D1 03 C9 03 C9 03 C9 03 C1 0F AB 02 43 83 C6 04 80 FB 03 75 D5 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1605_0 {
	meta:
		name = "TParameter.SetAttributes"
		size = 160
		refs = "0017 TParameter.SetAttributes 0032 ParameterAttributeValues 005b TParameter.GetParameter 0069 @CheckAutoResult 0073 TCollectionItem.Changed 0088 @IntfClear 008e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 88 55 FB 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 0F B6 05 ?? ?? ?? ?? 3A 45 FB 74 24 33 C0 BA ?? ?? ?? ?? 8B C8 80 F9 07 77 0A 83 E1 7F 0F B6 5D FB 0F A3 CB 73 02 03 32 40 83 C2 04 3C 03 75 E3 56 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1606_0 {
	meta:
		name = "TParameter.GetDataType"
		size = 194
		refs = "0018 TParameter.GetDataType 002e TParameter.GetParameter 003c @CheckAutoResult 0088 ADOTypeToFieldType 009f @IntfClear 00b5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 33 D2 89 55 E8 89 55 F0 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 01 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 0F B6 45 FC 50 8D 45 F4 50 8D 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B6 45 F4 50 8D 45 EC 50 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 45 E8 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 EC 5A 59 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1607_0 {
	meta:
		name = "TParameter.SetDataType"
		size = 103
		refs = "000f TParameter.SetDataType 001f DataTypeValues 002a TParameter.GetParameter 0038 @CheckAutoResult 0041 TCollectionItem.Changed 0056 @IntfClear 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1608_0 {
	meta:
		name = "TParameter.GetDisplayName"
		size = 79
		refs = "000f TParameter.GetDisplayName 001f TParameter.GetName 0029 @UStrFromWStr 003e @WStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_42326_0 {
	meta:
		name = "LoadResStringW"
		size = 79
		refs = "000f LoadResStringW 001f LoadResString 0029 @WStrFromUStr 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9369_0 {
	meta:
		name = "TBinaryField.GetText"
		size = 79
		refs = "000f TBinaryField.GetText 001f TField.GetAsString 0029 @UStrAsg 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9450_0 {
	meta:
		name = "TBlobField.GetText"
		size = 79
		refs = "000f TBlobField.GetText 001f TField.GetAsString 0029 @UStrAsg 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1848_0 {
	meta:
		name = "TCustomADODataSet.PSGetCommandText"
		size = 79
		refs = "000f TCustomADODataSet.PSGetCommandText 001f TCustomADODataSet.GetCommandText 0029 @UStrFromWStr 003e @WStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_50675_0 {
	meta:
		name = "TModuleObj.GetObjects"
		size = 79
		refs = "000f TModuleObj.GetObjects 001f CreateEnumeratedObject 0029 @VarFromDisp 003e @IntfClear 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54223_0 {
	meta:
		name = "VariantArrayToString"
		size = 79
		refs = "000f VariantArrayToString 0029 @UStrFromLStr 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54321_0 {
	meta:
		name = "XMLStringToWideString"
		size = 79
		refs = "000f XMLStringToWideString 001f XMLStringToUnicodeString 0029 @WStrFromUStr 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1609_0 {
	meta:
		name = "TParameter.GetName"
		size = 91
		refs = "000f TParameter.GetName 001c @WStrClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1610_0 {
	meta:
		name = "TParameter.SetName"
		size = 93
		refs = "000f TParameter.SetName 0020 TParameter.GetParameter 002e @CheckAutoResult 0037 TCollectionItem.Changed 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1611_0 {
	meta:
		name = "TParameter.GetNumericScale"
		size = 96
		refs = "0012 TParameter.GetNumericScale 0026 TParameter.GetParameter 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 0F B6 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1612_0 {
	meta:
		name = "TParameter.SetNumericScale"
		size = 93
		refs = "000f TParameter.SetNumericScale 0020 TParameter.GetParameter 002e @CheckAutoResult 0037 TCollectionItem.Changed 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 53 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1613_0 {
	meta:
		name = "TParameter.GetParameter"
		size = 110
		refs = "000f TParameter.GetParameter 002a TParameter.GetParameters 0033 TParameters.Create_Parameter 003e @IntfCopy 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 0C 00 75 23 6A 01 6A 00 8D 45 FC 50 8B C3 E8 ?? ?? ?? ?? 33 C9 33 D2 E8 ?? ?? ?? ?? 8B 55 FC 8D 43 0C E8 ?? ?? ?? ?? 8B C6 8B 53 0C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1614_0 {
	meta:
		name = "TParameter.GetParameterDirection"
		size = 112
		refs = "0012 TParameter.GetParameterDirection 0026 TParameter.GetParameter 0034 @CheckAutoResult 003c ParameterDirectionValues 0046 OleEnumToOrd 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 8B 4D FC B8 ?? ?? ?? ?? BA 04 00 00 00 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1615_0 {
	meta:
		name = "TParameter.SetParameterDirection"
		size = 103
		refs = "000f TParameter.SetParameterDirection 001f ParameterDirectionValues 002a TParameter.GetParameter 0038 @CheckAutoResult 0041 TCollectionItem.Changed 0056 @IntfClear 005c @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1617_0 {
	meta:
		name = "TParameter.GetPrecision"
		size = 96
		refs = "0012 TParameter.GetPrecision 0026 TParameter.GetParameter 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B6 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1618_0 {
	meta:
		name = "TParameter.SetPrecision"
		size = 93
		refs = "000f TParameter.SetPrecision 0020 TParameter.GetParameter 002e @CheckAutoResult 0037 TCollectionItem.Changed 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 53 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1619_0 {
	meta:
		name = "TParameter.GetProperties"
		size = 91
		refs = "000f TParameter.GetProperties 001c @IntfClear 0027 TParameter.GetParameter 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1620_0 {
	meta:
		name = "TParameter.GetSize"
		size = 95
		refs = "0012 TParameter.GetSize 0026 TParameter.GetParameter 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_38422_0 {
	meta:
		name = "TInternetExplorer.Get_Left"
		size = 95
		refs = "0012 TInternetExplorer.Get_Left 0026 TInternetExplorer.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1621_0 {
	meta:
		name = "TParameter.SetSize"
		size = 93
		refs = "000f TParameter.SetSize 0020 TParameter.GetParameter 002e @CheckAutoResult 0037 TCollectionItem.Changed 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 D2 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1622_0 {
	meta:
		name = "TParameter.GetValue"
		size = 91
		refs = "000f TParameter.GetValue 001c @VarClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_5000_0 {
	meta:
		name = "TCOMAdminCatalogObject.Get_Name"
		size = 91
		refs = "000f TCOMAdminCatalogObject.Get_Name 001c @VarClr 0027 TCOMAdminCatalogObject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1623_0 {
	meta:
		name = "TParameter.SetValue"
		size = 336
		refs = "0019 TParameter.SetValue 0026 VarIsClear 0031 VarIsNull 003d Null 0048 @OleVarFromVar 0051 TParameter.GetDataType 005d VarTypeToDataType 0066 TParameter.SetDataType 008b @VarToUStr 0096 StringToVarArray 00cc VarDataSize 00d5 TParameter.GetSize 00ed TParameter.SetSize 0103 TParameter.GetParameter 0111 @CheckAutoResult 0126 @IntfClear 012e @UStrClr 0136 @VarClr 0144 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 84 C0 75 0B 8B C6 E8 ?? ?? ?? ?? 84 C0 74 15 8D 45 E0 E8 ?? ?? ?? ?? 8D 55 E0 8D 45 F0 E8 ?? ?? ?? ?? EB 58 8B C3 E8 ?? ?? ?? ?? 84 C0 75 11 0F B7 06 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 3C 0F 75 0A 66 81 3E 00 01 0F 94 C0 EB 02 33 C0 84 C0 74 17 8D 45 DC 8B D6 E8 ?? ?? ?? ?? 8B 45 DC 8D 55 F0 E8 ?? ?? ?? ?? EB 0A 8D 45 F0 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 2C 02 72 17 04 F6 2C 02 72 11 48 2C 02 72 0C 04 FA 2C 02 72 06 04 F3 2C 02 73 29 8D 45 F0 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 85 C0 74 0B 8B C3 E8 ?? ?? ?? ?? 3B F0 7E 09 8B D6 8B C3 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 45 D8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1624_0 {
	meta:
		name = "TADOCommand.Create"
		size = 236
		refs = "000f @ClassCreate 001b TADOCommand.Create 002a TComponent.Create 0032 CLASS_Command 0037 CreateADOObject 0047 @IntfCast 004c _DV_TParameter 0056 _DV_TParameters 005b TOwnedCollection.Create 006b TADOCommand.SetComandType 0078 @UStrAsg 0090 @IntfClear 0096 @HandleFinally 00a3 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8D 46 34 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 50 C6 46 56 01 B2 01 8B C6 E8 ?? ?? ?? ?? 8D 46 44 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 76 48 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B 59 5D C3 BD 00 84 B0 D1 F9 02 4D B8 56 71 D5 DB A1 23 E9 B0 04 02 00 FF FF FF FF 0B 00 00 00 43 00 6F 00 6D 00 6D 00 61 00 6E 00 64 00 54 00 65 00 78 00 74 00 00 00 }
	condition:
		$1
}

rule function_1625_0 {
	meta:
		name = "TADOCommand.Destroy"
		size = 70
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001c TADOCommand.SetConnection 0024 @IntfClear 0034 TObject.Free 003f @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 46 34 E8 ?? ?? ?? ?? 8D 46 50 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1626_0 {
	meta:
		name = "TADOCommand.Assign"
		size = 134
		refs = "000a _DV_TADOCommand 000f @IsClass 0023 TADOCommand.SetConnection 002f TADOCommand.SetConnectionString 0036 TADOCommand.GetCommandTimeOut 003f TADOCommand.SetCommandTimeOut 0046 TADOCommand.GetCommandType 004f TADOCommand.SetComandType 0060 TADOCommand.GetPrepared 0069 TADOCommand.SetPrepared 0073 TADOCommand.SetParameters 007f TPersistent.Assign"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 63 8B 46 38 85 C0 74 0B 8B D0 8B C3 E8 ?? ?? ?? ?? EB 0A 8B 56 3C 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 56 40 8B C3 8B 08 FF 51 3C 8B C6 E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 8B 56 50 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1627_0 {
	meta:
		name = "TADOCommand.Cancel"
		size = 15
		refs = "000a @CheckAutoResult"
	strings:
		$1 = { 8B 40 34 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1628_0 {
	meta:
		name = "TADOCommand.CheckCommandText"
		size = 116
		refs = "0012 TADOCommand.CheckCommandText 0022 @WStrEqual 0030 SMissingCommandText 0035 LoadResString 004e DatabaseErrorFmt 0063 @UStrClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 33 D2 89 55 FC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 40 33 D2 E8 ?? ?? ?? ?? 75 2A 8B 43 48 50 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8B 43 44 89 45 F4 C6 45 F8 11 8D 55 F4 33 C9 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1629_0 {
	meta:
		name = "TADOCommand.SetConnectionFlag"
		size = 124
		refs = "0026 TADOCommand.SetConnectionFlag"
	strings:
		$1 = { 53 56 51 8B DA 8B F0 8B C3 83 F8 0F 77 05 66 0F A3 46 54 0F 92 C0 88 04 24 84 C9 74 26 80 3C 24 00 75 4B 0F B7 05 ?? ?? ?? ?? 66 3B 46 54 75 07 8B C6 8B 10 FF 52 38 83 FB 0F 77 32 66 0F AB 5E 54 EB 2B 80 3C 24 00 74 25 83 FB 0F 77 05 66 0F B3 5E 54 0F B7 05 ?? ?? ?? ?? 66 3B 46 54 75 0E 83 7E 38 00 74 08 8B 46 38 8B 10 FF 52 54 0F B6 04 24 5A 5E 5B C3 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1630_0 {
	meta:
		name = "TADOCommand.OpenConnection"
		size = 216
		refs = "0012 TADOCommand.OpenConnection 0020 @IntfClear 002f @CheckAutoResult 003f @WStrEqual 004c @VarFromWStr 0074 TADOConnection.CheckActive 0093 SMissingConnection 0098 LoadResString 00a2 DatabaseError 00b7 @UStrClr 00bf @VarClr 00cd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 50 8B 43 34 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 83 7D FC 00 75 6D 8B 43 3C 33 D2 E8 ?? ?? ?? ?? 74 27 8D 45 EC 8B 53 3C E8 ?? ?? ?? ?? FF 75 F8 FF 75 F4 FF 75 F0 FF 75 EC 8B 43 34 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? EB 3A 8B 43 38 85 C0 74 1C E8 ?? ?? ?? ?? 8B 43 38 8B 40 74 50 8B 43 34 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? EB 17 8D 55 E8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 E8 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1631_0 {
	meta:
		name = "TADOCommand.ComponentLoading"
		size = 25
	strings:
		$1 = { F6 40 1C 01 75 10 8B 50 04 85 D2 74 06 F6 42 1C 01 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_1632_0 {
	meta:
		name = "TADOCommand.Execute"
		size = 24
		refs = "000a EmptyParam 0011 TADOCommand.Execute"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B CE 8B 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1633_0 {
	meta:
		name = "TADOCommand.Execute"
		size = 34
		refs = "0019 TADOCommand.Execute"
	strings:
		$1 = { 53 56 57 51 8B F9 8B F2 8B D8 33 C0 89 04 24 57 8B CE 8D 54 24 04 8B C3 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1634_0 {
	meta:
		name = "TADOCommand.Execute"
		size = 237
		refs = "001d TADOCommand.Execute 0052 @IntfClear 0068 @CheckAutoResult 0077 ExecuteOptionsToOrd 0083 @VarClr 009d @VarToInteger 00c1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F1 8B DA 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B1 01 BA 02 00 00 00 8B 45 EC 8B 38 FF 57 40 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 01 8B 45 EC 8B 08 FF 51 34 8B 45 08 E8 ?? ?? ?? ?? 50 8D 45 E8 50 8B 45 EC 8B 40 34 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 7D E8 8B 45 EC 0F B6 40 4C E8 ?? ?? ?? ?? 03 F8 57 56 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 45 EC 8B 40 34 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 89 03 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 33 C9 BA 02 00 00 00 8B 45 EC 8B 18 FF 53 40 C3 E9 ?? ?? ?? ?? EB E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1635_0 {
	meta:
		name = "TADOCommand.Initialize"
		size = 392
		refs = "0013 TADOCommand.Initialize 0020 TADOCommand.CheckCommandText 002f TADOCommand.GetCommandType 0046 Pos 0066 @WStrLAsg 0095 WideStringReplace 00b2 @WStrCat3 00fb @WStrCat 010d @CheckAutoResult 0115 TParameters.AppendParameters 012f @WStrArrayClr 0135 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 84 DB 0F 84 ED 00 00 00 8B C6 E8 ?? ?? ?? ?? 04 FE 2C 02 0F 83 D4 00 00 00 8B 56 40 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 8E BF 00 00 00 8B 46 40 66 83 38 5B 0F 84 B2 00 00 00 8D 45 FC 8B 56 40 E8 ?? ?? ?? ?? 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 2B 0F B6 05 ?? ?? ?? ?? 50 8D 45 F8 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? EB 10 8D 45 FC 8B 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7E 2B 0F B6 05 ?? ?? ?? ?? 50 8D 45 F4 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B 55 F4 8D 45 FC E8 ?? ?? ?? ?? EB 0D 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 50 8B 46 34 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 46 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 00 00 00 02 00 00 00 20 00 00 00 02 00 00 00 2E 00 00 00 00 00 00 00 04 00 00 00 2E 00 5B 00 00 00 00 00 02 00 00 00 5B 00 00 00 02 00 00 00 3B 00 00 00 04 00 00 00 5D 00 3B 00 00 00 00 00 02 00 00 00 5D 00 00 00 }
	condition:
		$1
}

rule function_1636_0 {
	meta:
		name = "TADOCommand.GetActiveConnection"
		size = 31
		refs = "0009 @IntfClear 0018 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 34 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1637_0 {
	meta:
		name = "InitParameters"
		size = 672
		refs = "0012 InitParameters 001d _DV_TParameter 002b _DV_TParameters 0030 TOwnedCollection.Create 0055 TParameters.ParseSQL 0066 TParameters.AssignValues 007e @CheckAutoResult 00a7 @WStrEqual 00e9 TParameters.InternalRefresh 0127 TParameters.GetItem 012c TParameter.GetDataType 013d TParameter.SetDataType 0152 TParameter.GetSize 0163 TParameter.SetSize 0178 TParameter.GetNumericScale 0189 TParameter.SetNumericScale 019e TParameter.GetPrecision 01af TParameter.SetPrecision 01c4 TParameter.GetParameterDirection 01d5 TParameter.SetParameterDirection 01ea TParameter.GetAttributes 01fb TParameter.SetAttributes 0228 @HandleFinally 0239 @HandleAnyException 023e @DoneExcept 0270 TObject.Free 028d @WStrClr"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 C0 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 50 8B 45 08 8B 48 FC B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8D 45 FC 50 8B 45 08 8B 50 F8 B1 01 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 50 50 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 45 08 8B 40 FC 8B 40 34 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 08 80 78 F7 00 0F 85 D0 01 00 00 8B 45 08 8B 40 FC 83 78 38 00 75 16 8B 45 08 8B 40 FC 8B 40 3C 33 D2 E8 ?? ?? ?? ?? 0F 84 AE 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 08 8B 40 FC B1 01 BA 04 00 00 00 8B 18 FF 53 40 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 08 8B 40 FC 8B 40 50 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B 40 08 8B 50 08 8B 45 F8 8B 40 08 8B 40 08 3B D0 0F 85 FA 00 00 00 8B F0 4E 85 F6 0F 8C EF 00 00 00 46 33 DB 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 40 50 8B D3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 8B 45 F8 E8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 43 4E 0F 85 14 FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 08 8B 40 FC 33 C9 BA 04 00 00 00 8B 18 FF 53 40 C3 E9 ?? ?? ?? ?? EB E6 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 40 08 83 78 08 00 7E 11 8B 45 08 8B 40 FC 8B 40 50 8B 55 F8 8B 08 FF 51 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1638_0 {
	meta:
		name = "TADOCommand.AssignCommandText"
		size = 99
		refs = "0013 TADOCommand.GetCommandType 0021 @WStrEqual 0032 InitParameters 004a @CheckAutoResult 005b TCollection.Clear"
	strings:
		$1 = { 55 8B EC 83 C4 F4 88 4D F7 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 3C 01 75 1E 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 74 12 8B 45 FC 80 78 56 00 74 09 55 E8 ?? ?? ?? ?? 59 EB 26 8B 45 F8 50 8B 45 FC 8B 40 34 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 80 7D F7 00 75 0B 8B 45 FC 8B 40 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_1639_0 {
	meta:
		name = "TADOCommand.SetCommandText"
		size = 37
		refs = "000c @WStrAsg 0013 TADOCommand.ComponentLoading 001e TADOCommand.AssignCommandText"
	strings:
		$1 = { 53 56 8B F2 8B D8 8D 43 40 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1640_0 {
	meta:
		name = "TADOCommand.GetCommandTimeOut"
		size = 21
		refs = "000c @CheckAutoResult"
	strings:
		$1 = { 51 54 8B 40 34 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_1641_0 {
	meta:
		name = "TADOCommand.SetCommandTimeOut"
		size = 16
		refs = "000b @CheckAutoResult"
	strings:
		$1 = { 52 8B 40 34 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1642_0 {
	meta:
		name = "TADOCommand.GetCommandType"
		size = 40
		refs = "000f @CheckAutoResult 0017 CommandTypeValues 0021 OleEnumToOrd"
	strings:
		$1 = { 53 51 8B D8 54 8B 43 34 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 0C 24 B8 ?? ?? ?? ?? BA 05 00 00 00 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1643_0 {
	meta:
		name = "TADOCommand.SetComandType"
		size = 26
		refs = "0006 CommandTypeValues 0015 @CheckAutoResult"
	strings:
		$1 = { 83 E2 7F 8B 14 95 ?? ?? ?? ?? 52 8B 40 34 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1644_0 {
	meta:
		name = "TADOCommand.ClearActiveConnection"
		size = 17
		refs = "000c @CheckAutoResult"
	strings:
		$1 = { 6A 00 8B 40 34 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1645_0 {
	meta:
		name = "TADOCommand.ConnectionStateChange"
		size = 10
		refs = "0005 TADOCommand.ClearActiveConnection"
	strings:
		$1 = { 84 C9 75 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1646_0 {
	meta:
		name = "TADOCommand.SetConnection"
		size = 65
		refs = "000f @WStrClr 002c TADOCommand.ConnectionStateChange 003a TADOCommand.ClearActiveConnection"
	strings:
		$1 = { 53 56 8B F2 8B D8 3B 73 38 74 33 8D 43 3C E8 ?? ?? ?? ?? 8B 43 38 85 C0 74 07 8B D3 8B 08 FF 51 50 8B C6 89 43 38 85 C0 74 0D 53 68 ?? ?? ?? ?? 8B D3 8B 08 FF 51 48 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1647_0 {
	meta:
		name = "TADOCommand.SetConnectionString"
		size = 47
		refs = "000c @WStrEqual 0017 TADOCommand.SetConnection 0021 @WStrAsg 0028 TADOCommand.ClearActiveConnection"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 43 3C 8B D6 E8 ?? ?? ?? ?? 74 1A 33 D2 8B C3 E8 ?? ?? ?? ?? 8D 43 3C 8B D6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1648_0 {
	meta:
		name = "TADOCommand.SetParameters"
		size = 13
		altNames = "TIBConnectionBroker.SetDBParams"
	strings:
		$1 = { 56 8B F0 8B 46 50 8B 08 FF 51 08 5E C3 }
	condition:
		$1
}

rule function_1649_0 {
	meta:
		name = "TADOCommand.GetPrepared"
		size = 22
		refs = "000c @CheckAutoResult"
	strings:
		$1 = { 51 54 8B 40 34 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B7 04 24 5A C3 }
	condition:
		$1
}

rule function_1650_0 {
	meta:
		name = "TADOCommand.SetPrepared"
		size = 16
		refs = "000b @CheckAutoResult"
	strings:
		$1 = { 52 8B 40 34 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1651_0 {
	meta:
		name = "TADOCommand.GetState"
		size = 36
		refs = "0010 @CheckAutoResult 0018 GetStates"
	strings:
		$1 = { 53 56 51 8B F0 54 8B 46 34 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 8B 04 24 E8 ?? ?? ?? ?? 8B D8 8B C3 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1652_0 {
	meta:
		name = "TADOCommand.GetProperties"
		size = 31
		refs = "0009 @IntfClear 0018 @CheckAutoResult"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 50 8B 43 34 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1653_0 {
	meta:
		name = "InitializeMasterFields"
		size = 452
		refs = "0015 InitializeMasterFields 0022 TCustomADODataSet.GetParameters 0081 TParameters.GetItem 0086 TParameter.GetParameterDirection 00a4 TParameter.GetName 00af @UStrFromWStr 00c3 TDataSet.FindField 0100 @UStrCatN 0125 @InternalUStrFromLStr 0144 @UStrCopy 014f @WStrFromUStr 0159 TCustomADODataSet.SetMasterFields 0160 TCustomADODataSet.SetParamsFromCursor 0175 @UStrClr 0182 @WStrArrayClr 0192 @WStrClr 019f @UStrArrayClr 01a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 7E 0F 8B 83 D8 01 00 00 83 78 04 00 0F 95 C0 EB 02 33 C0 84 C0 0F 84 1B 01 00 00 8B 83 D8 01 00 00 8B 40 04 83 78 34 00 0F 84 08 01 00 00 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B F8 4F 85 FF 0F 8C 98 00 00 00 47 33 F6 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 2C 01 74 04 2C 02 75 72 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8D 55 F4 E8 ?? ?? ?? ?? 8B 55 F4 8D 45 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B 83 D8 01 00 00 8B 40 04 8B 40 34 E8 ?? ?? ?? ?? 85 C0 74 39 FF 75 FC 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? FF 75 F0 68 ?? ?? ?? ?? 8D 45 FC BA 03 00 00 00 E8 ?? ?? ?? ?? 46 4F 0F 85 6B FF FF FF 8B 45 FC 85 C0 74 16 8B D0 83 EA 0A 66 83 3A 02 74 0B 8D 45 FC 8B 55 FC E8 ?? ?? ?? ?? 8B F0 85 F6 74 05 83 EE 04 8B 36 8D 45 E4 50 8B CE 49 BA 01 00 00 00 8B 45 FC E8 ?? ?? ?? ?? 8B 55 E4 8D 45 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C6 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3B 00 00 00 }
	condition:
		$1
}

rule function_1654_0 {
	meta:
		name = "TCustomADODataSet.Create"
		size = 251
		refs = "000e @ClassCreate 001c TDataSet.Create 0025 _DV_TADOCommand 002a TADOCommand.Create 003e _Dn_TIndexDefs 0043 TIndexDefs.Create 0050 _Dn_TList 0055 TObject.Create 0095 TCustomADODataSet.SetCommandType 009a _DV_TADODataSet 00a9 _Dn_TMasterDataLink 00ae TMasterDataLink.Create 00e6 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 51 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 88 55 FF 8B D8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 A0 01 00 00 89 5E 48 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 C8 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 BC 01 00 00 B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 83 C4 01 00 00 C6 83 DE 01 00 00 02 C6 83 DF 01 00 00 03 C6 83 DD 01 00 00 01 C7 83 AC 01 00 00 01 00 00 00 B2 01 8B C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 83 94 00 00 00 8B CB B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 89 B3 D8 01 00 00 89 5E 2C 8B 03 8B 80 B8 02 00 00 89 46 28 89 5E 34 8B 03 8B 80 BC 02 00 00 89 46 30 C6 83 ED 01 00 00 01 8B C3 80 7D FF 00 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1655_0 {
	meta:
		name = "TCustomADODataSet.Destroy"
		size = 177
		refs = "0003 @BeforeDestruction 000e TComponent.Destroying 0015 TDataSet.Close 0034 TObject.Free 009f TDataSet.Destroy 00aa @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 33 D2 8B C6 8B 08 FF 91 C4 02 00 00 8D 86 A0 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 BC 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 C8 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 C4 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 D8 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8D 86 CC 01 00 00 8B 10 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1657_0 {
	meta:
		name = "TCustomADODataSet.SetConnectionFlag"
		size = 24
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B D7 8B 86 A0 01 00 00 8B 18 FF 53 40 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1658_0 {
	meta:
		name = "InitializeConnection"
		size = 388
		refs = "0015 InitializeConnection 0022 TCustomADODataSet.GetConnection 002d TCustomADODataSet.GetExecuteOptions 0046 SConnectionRequired 004b LoadResString 0055 DatabaseError 006a EmptyParam 006f @VarCopy 0076 TCustomADODataSet.GetCommandType 00aa InitializeMasterFields 00c0 @VarFromDisp 00dc TCustomConnection.Open 00fd TCustomADODataSet.GetConnectionString 0107 @WStrEqual 0121 @VarFromWStr 012e TADOCommand.CheckCommandText 0138 TCustomADODataSet.GetCommandText 0160 @WStrArrayClr 0168 @UStrClr 016e @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B 5D 08 83 C3 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 03 E8 ?? ?? ?? ?? 85 C0 75 2F 8B 03 E8 ?? ?? ?? ?? 22 05 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 3A D0 74 17 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 33 D2 E8 ?? ?? ?? ?? 8B 03 C6 80 EE 01 00 00 00 8B 45 08 83 C0 E8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 04 FC 2C 02 0F 92 C0 34 01 84 C0 74 42 8B 03 B1 01 BA 01 00 00 00 8B 30 FF 96 C8 02 00 00 8B 03 8B 80 A0 01 00 00 B2 01 8B 08 FF 51 34 8B 03 E8 ?? ?? ?? ?? 8B 45 08 83 C0 D8 8B 13 8B 92 A0 01 00 00 8B 52 34 E8 ?? ?? ?? ?? E9 81 00 00 00 8B 03 E8 ?? ?? ?? ?? 85 C0 74 23 8B 03 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 50 74 8B 45 08 83 C0 E8 E8 ?? ?? ?? ?? EB 2E 8D 55 F8 8B 03 E8 ?? ?? ?? ?? 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 74 18 8D 55 F4 8B 03 E8 ?? ?? ?? ?? 8B 55 F4 8B 45 08 83 C0 E8 E8 ?? ?? ?? ?? 8B 03 8B 80 A0 01 00 00 E8 ?? ?? ?? ?? 8D 55 F0 8B 03 E8 ?? ?? ?? ?? 8B 55 F0 8B 45 08 83 C0 D8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5E 5B 8B E5 5D C3 00 00 07 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1659_0 {
	meta:
		name = "InitializeRecordset"
		size = 496
		refs = "0018 InitializeRecordset 0026 CLASS_Recordset 002b CreateADOObject 003f @IntfCast 004f CursorLocationValues 0066 @CheckAutoResult 00ad @WStrEqual 00d5 TCustomADODataSet.RefreshIndexFields 00dc TCustomADODataSet.EnableEvents 0122 @IntfClear 0169 @VarFromDisp 01bd @VarClr 01d3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 8B 5D 08 83 C3 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B 03 05 78 01 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 0F B6 80 DD 01 00 00 8B 04 85 ?? ?? ?? ?? 50 8B 03 8B 80 78 01 00 00 50 8B 00 FF 90 F0 00 00 00 E8 ?? ?? ?? ?? 8B 03 8B 80 AC 01 00 00 50 8B 03 8B 80 78 01 00 00 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 8B 03 8B 80 B8 01 00 00 50 8B 03 8B 80 78 01 00 00 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 8B 03 8B 80 D0 01 00 00 33 D2 E8 ?? ?? ?? ?? 74 26 8B 03 8B 80 D0 01 00 00 50 8B 03 8B 80 78 01 00 00 50 8B 00 FF 90 48 01 00 00 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 8B 03 66 83 B8 4A 02 00 00 00 0F 84 B4 00 00 00 8B 45 08 66 83 78 E8 09 75 24 8B 45 08 FF 70 F4 FF 70 F0 FF 70 EC FF 70 E8 8B 03 8B 80 78 01 00 00 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? EB 6E 8D 45 F8 E8 ?? ?? ?? ?? 50 8B 03 8B 80 A0 01 00 00 8B 40 34 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 83 7D F8 00 74 49 8D 45 E4 E8 ?? ?? ?? ?? 50 8B 03 8B 80 A0 01 00 00 8B 40 34 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 55 E4 8D 45 E8 E8 ?? ?? ?? ?? FF 75 F4 FF 75 F0 FF 75 EC FF 75 E8 8B 03 8B 80 78 01 00 00 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 8B 33 8B 03 8B 88 78 01 00 00 8B 13 8B 86 4C 02 00 00 FF 96 48 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D8 5E 5B 8B E5 5D C3 00 56 05 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 }
	condition:
		$1
}

rule function_1660_0 {
	meta:
		name = "TCustomADODataSet.OpenCursor"
		size = 495
		refs = "001a TCustomADODataSet.OpenCursor 0036 InitializeConnection 003d InitializeRecordset 0046 TCustomADODataSet.GetExecuteOptions 004b ExecuteOptionsToOrd 0055 TCustomADODataSet.GetCommandType 005f CommandTypeValues 0071 LockTypeValues 0083 CursorTypeValues 00b3 @CheckAutoResult 00ce @IntfClear 00d7 @VarClr 00ff @IntfCopy 0110 Abort 011f @HandleAnyException 0127 SNoResultSet 012c LoadResString 0137 DatabaseError 013c @DoneExcept 016b TCustomADODataSet.EnableEvents 01a2 TDataSet.SetState 01ac TDataSet.OpenCursor 01c1 @UStrClr 01d2 OleVariant 01dc @FinalizeArray 01e2 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 B8 78 01 00 00 00 0F 85 33 01 00 00 55 E8 ?? ?? ?? ?? 59 55 E8 ?? ?? ?? ?? 59 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B 45 FC E8 ?? ?? ?? ?? 83 E0 7F 03 1C 85 ?? ?? ?? ?? 53 8B 45 FC 0F B6 80 DF 01 00 00 8B 04 85 ?? ?? ?? ?? 50 8B 45 FC 0F B6 80 DE 01 00 00 8B 04 85 ?? ?? ?? ?? 50 FF 75 F4 FF 75 F0 FF 75 EC FF 75 E8 FF 75 E4 FF 75 E0 FF 75 DC FF 75 D8 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? E9 84 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 C4 E8 ?? ?? ?? ?? 50 8D 45 C8 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 F4 00 00 00 E8 ?? ?? ?? ?? 8B 55 C4 8B 45 FC 05 78 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 83 B8 78 01 00 00 00 75 05 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 22 E9 ?? ?? ?? ?? 8D 55 C0 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 C0 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 BC 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 83 7D BC 00 0F 84 57 FF FF FF EB 08 8B 45 FC E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? A8 01 74 2B 8D 45 BC 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? F6 45 BC 04 74 0A B2 0C 8B 45 FC E8 ?? ?? ?? ?? 33 D2 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 C4 E8 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1661_0 {
	meta:
		name = "TCustomADODataSet.InternalOpen"
		size = 162
		refs = "000a TCustomADODataSet.GetCursorType 002f @CheckAutoResult 0050 TFieldDefs.Update 006a FieldListCheckSum 0084 TFields.GetCount"
	strings:
		$1 = { 53 56 51 8B D8 8B F3 8B C3 E8 ?? ?? ?? ?? 3C 01 0F 94 C0 88 86 8C 00 00 00 54 68 00 20 00 00 8B 83 78 01 00 00 50 8B 00 FF 90 F8 00 00 00 E8 ?? ?? ?? ?? 66 83 3C 24 00 74 09 C7 43 68 10 00 00 00 EB 05 33 C0 89 43 68 8B 43 3C C6 40 20 00 E8 ?? ?? ?? ?? 80 BB AA 00 00 00 00 74 0A 8B C3 8B 10 FF 92 CC 00 00 00 8B C3 E8 ?? ?? ?? ?? 89 83 98 00 00 00 B2 01 8B C3 8B 08 FF 91 A8 00 00 00 8B 43 34 E8 ?? ?? ?? ?? C1 E0 04 83 C0 19 89 83 A8 01 00 00 8B C3 8B 10 FF 92 C0 02 00 00 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1662_0 {
	meta:
		name = "TCustomADODataSet.InternalClose"
		size = 227
		refs = "000d TCustomADODataSet.InternalClose 004e TCustomADODataSet.GetRecordsetState 006c TCustomADODataSet.ConnectionPoint 007a OleCheck 008d @IntfClear 00ac @UStrAsg 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 8B C6 8B 08 FF 91 A8 00 00 00 80 BE AA 00 00 00 00 74 0A 8B C6 8B 10 FF 92 E0 00 00 00 8B 86 C4 01 00 00 8B 10 FF 52 08 8B C6 8B 10 FF 92 B4 02 00 00 8B C6 E8 ?? ?? ?? ?? A8 02 74 30 83 BE 9C 01 00 00 00 7E 27 8B 86 9C 01 00 00 50 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 18 E8 ?? ?? ?? ?? 33 C0 89 86 9C 01 00 00 8D 86 7C 01 00 00 E8 ?? ?? ?? ?? 8D 86 78 01 00 00 E8 ?? ?? ?? ?? C6 86 DC 01 00 00 00 8D 86 B0 01 00 00 33 D2 E8 ?? ?? ?? ?? 33 C9 BA 01 00 00 00 8B C6 8B 18 FF 93 C8 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1663_0 {
	meta:
		name = "TCustomADODataSet.InternalRefresh"
		size = 88
		refs = "001a @CheckAutoResult 0043 TCustomADODataSet.InternalRefresh 004a TCustomADODataSet.InternalRequery"
	strings:
		$1 = { 53 51 8B D8 54 68 00 00 02 00 8B 83 78 01 00 00 50 8B 00 FF 90 F8 00 00 00 E8 ?? ?? ?? ?? 66 83 3C 24 00 74 1B 6A 02 6A 03 8B 83 78 01 00 00 50 8B 00 FF 90 40 01 00 00 E8 ?? ?? ?? ?? 5A 5B C3 0F B6 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_1664_0 {
	meta:
		name = "TCustomADODataSet.InternalRequery"
		size = 229
		refs = "0018 TCustomADODataSet.InternalRequery 0032 SCantRequery 0037 LoadResString 0041 DatabaseError 0058 ExecuteOptionsToOrd 0070 @CheckAutoResult 007f @HandleAnyException 00a8 TDataSet.Close 00ad @RaiseAgain 00b2 @DoneExcept 00d2 @UStrClr 00d8 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 C9 89 4D F4 88 55 FB 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 80 B8 EE 01 00 00 00 74 17 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 33 D2 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B6 45 FB E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 38 E9 ?? ?? ?? ?? 8D 45 F0 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 83 7D F0 00 75 08 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 8B 10 FF 92 B4 02 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1665_0 {
	meta:
		name = "TCustomADODataSet.Requery"
		size = 35
		refs = "000a TDataSet.CheckBrowseMode 0015 TCustomADODataSet.InternalRequery 001c TDataSet.First"
	strings:
		$1 = { 53 51 88 14 24 8B D8 8B C3 E8 ?? ?? ?? ?? 0F B6 14 24 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_1666_0 {
	meta:
		name = "TCustomADODataSet.CheckActive"
		size = 35
		refs = "0006 DBApplication 001d TDataSet.CheckActive"
	strings:
		$1 = { 53 8B D8 EB 0C A1 ?? ?? ?? ?? 8B 00 8B 10 FF 52 10 80 BB A1 00 00 00 0C 74 EB 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1667_0 {
	meta:
		name = "TCustomADODataSet.CheckFieldCompatibility"
		size = 100
		refs = "005e TDataSet.CheckFieldCompatibility"
	strings:
		$1 = { 56 8B F0 0F B6 42 44 83 F8 18 7F 0F 74 33 48 74 30 83 C0 FB 83 E8 03 72 12 EB 3A 83 E8 20 74 07 83 E8 05 74 06 EB 2E B0 01 EB 2C 0F B6 41 25 04 FA 2C 03 72 08 2C 1C 74 04 33 C0 EB 1A B0 01 EB 16 0F B6 41 25 2C 01 74 08 2C 17 74 04 33 C0 EB 06 B0 01 EB 02 33 C0 84 C0 75 07 8B C6 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule function_1668_0 {
	meta:
		name = "TCustomADODataSet.IsCursorOpen"
		size = 17
		refs = "0006 TCustomADODataSet.GetRecordsetState"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? A8 02 0F 95 C0 5B C3 }
	condition:
		$1
}

rule function_1669_0 {
	meta:
		name = "TCustomADODataSet.DefChanged"
		size = 8
	strings:
		$1 = { C6 80 EC 01 00 00 01 C3 }
	condition:
		$1
}

rule function_1670_0 {
	meta:
		name = "AddFieldDef"
		size = 1168
		refs = "001b @IntfAddRef 0023 AddFieldDef 0049 @CheckAutoResult 0081 ADOTypeToFieldType 009f TFieldDefs.AddFieldDef 00b4 @WStrClr 00e7 @WStrEqual 0103 WideFormat 015e @UStrFromWStr 0168 TDefCollection.IndexOf 0185 TNamedItem.SetDisplayName 02a4 @VarClr 02ad @IntfClear 02b7 SIsAutoInc 02bc @VarFromWStr 0309 @VarFromBool 0312 @VarCmpEQ 034a TFieldDef.SetAttributes 03ad TFieldDef.SetDataType 03b7 TFieldDef.SetSize 03c1 TFieldDef.SetPrecision 03d5 TFields.GetCount 03e6 TDataSet.SetObjectView 0428 @UStrArrayClr 044e @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 10 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B FA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 FC 0F B6 80 ED 01 00 00 50 8D 45 E8 50 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 0F B6 45 E8 50 8D 45 E4 50 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B6 45 E4 50 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 45 E0 5A 59 E8 ?? ?? ?? ?? 88 45 F7 80 7D F7 00 0F 84 58 03 00 00 33 C0 89 45 F0 33 C0 89 45 EC 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 47 08 8B 40 08 89 43 1C 33 F6 8D 45 F8 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? EB 7E 46 8D 45 DC E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 8B 45 DC 33 D2 E8 ?? ?? ?? ?? 75 1C 8D 45 F8 50 89 75 D4 C6 45 D8 00 8D 55 D4 33 C9 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3E 8D 45 F8 50 8D 45 C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 8B 45 C0 89 45 C4 C6 45 C8 0F 89 75 CC C6 45 D0 00 8D 55 C4 B9 01 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 0F 84 72 FF FF FF 8D 45 BC 8B 55 F8 E8 ?? ?? ?? ?? 8B 55 BC 8B C7 E8 ?? ?? ?? ?? 85 C0 0F 8D 55 FF FF FF 8D 45 B8 8B 55 F8 E8 ?? ?? ?? ?? 8B 55 B8 8B C3 E8 ?? ?? ?? ?? 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 81 7D E0 83 00 00 00 75 34 8D 45 E8 50 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 80 7D E8 00 75 1C 8D 45 E4 50 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 80 7D E4 0A 73 04 C6 45 F7 03 0F B6 45 F7 83 F8 26 0F 87 40 01 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 00 03 00 00 00 00 02 00 00 00 01 01 00 00 00 00 00 00 00 00 00 01 01 00 00 00 00 00 00 00 00 00 00 04 00 02 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 E0 89 45 F0 E9 DA 00 00 00 8D 45 E8 50 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B6 45 E8 89 45 EC 8D 45 E8 50 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 0F BE 45 E8 89 45 F0 83 7D F0 00 0F 8D 9E 00 00 00 C7 45 F0 04 00 00 00 E9 92 00 00 00 8B 45 08 80 78 FB 00 0F 84 85 00 00 00 8D 45 A8 E8 ?? ?? ?? ?? 50 8D 45 A4 E8 ?? ?? ?? ?? 50 8D 45 94 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 A0 FF 75 9C FF 75 98 FF 75 94 8D 45 90 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 45 90 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 A4 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8D 45 A8 50 8D 45 80 B2 01 E8 ?? ?? ?? ?? 8D 55 80 58 E8 ?? ?? ?? ?? 75 0D C6 45 F7 0E EB 07 C7 45 F0 26 00 00 00 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? F6 45 E1 01 74 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? F6 45 E0 10 74 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 8D 45 E0 50 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? F6 45 E0 0C 74 06 80 7D F7 0E 75 11 0F B6 15 ?? ?? ?? ?? 0A 53 26 8B C3 E8 ?? ?? ?? ?? 0F B6 55 F7 8B C3 E8 ?? ?? ?? ?? 8B 55 F0 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8B C3 E8 ?? ?? ?? ?? 80 7B 25 1D 75 1F 8B 45 08 8B 40 FC 8B 40 34 E8 ?? ?? ?? ?? 85 C0 75 0D 8B 45 08 8B 40 FC B2 01 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 80 E8 ?? ?? ?? ?? 8D 45 90 E8 ?? ?? ?? ?? 8D 45 94 E8 ?? ?? ?? ?? 8D 45 A4 E8 ?? ?? ?? ?? 8D 45 A8 E8 ?? ?? ?? ?? 8D 45 B8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB A3 5F 5E 5B 8B E5 5D C3 00 10 00 00 00 43 00 4F 00 4C 00 55 00 4D 00 4E 00 25 00 64 00 00 00 00 00 0A 00 00 00 25 00 73 00 5F 00 25 00 64 00 00 00 01 00 00 00 20 00 00 00 02 00 00 00 }
	condition:
		$1
}

rule function_1671_0 {
	meta:
		name = "TCustomADODataSet.InternalInitFieldDefs"
		size = 411
		refs = "0019 TCustomADODataSet.InternalInitFieldDefs 002a TCollection.Clear 0036 @IntfClear 004b @CheckAutoResult 007e @OleVarFromInt 00cc SIsAutoInc 00d1 PropertyExists 0137 AddFieldDef 0159 @VarClr 018f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 8B 40 3C E8 ?? ?? ?? ?? 8D 45 F4 50 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D F4 85 DB 7E 74 8D 45 EC E8 ?? ?? ?? ?? 50 8D 45 E8 E8 ?? ?? ?? ?? 50 8D 45 D8 33 D2 B1 01 E8 ?? ?? ?? ?? FF 75 E4 FF 75 E0 FF 75 DC FF 75 D8 8D 45 D4 E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 D4 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 E8 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 45 EC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 45 FB 4B 85 DB 7C 63 43 33 F6 55 8D 45 D0 E8 ?? ?? ?? ?? 50 8D 45 C0 8B D6 B1 FC E8 ?? ?? ?? ?? FF 75 CC FF 75 C8 FF 75 C4 FF 75 C0 8D 45 BC E8 ?? ?? ?? ?? 50 8B 45 FC 8B 80 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 BC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 D0 8B 55 FC 8B 52 3C E8 ?? ?? ?? ?? 59 46 4B 75 A0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB B8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1672_0 {
	meta:
		name = "InitBinding"
		size = 109
		refs = "0013 @FillChar"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B C3 33 C9 BA 34 00 00 00 E8 ?? ?? ?? ?? C7 43 1C 07 00 00 00 8B 46 08 89 03 0F B7 46 14 66 89 43 30 8B 07 89 43 0C 8B 07 83 C0 04 89 43 08 8B 07 83 C0 08 89 43 04 66 81 7B 30 82 00 75 10 83 7E 10 FF 74 0A 8B 46 10 03 C0 89 43 28 EB 06 8B 46 10 89 43 28 8B 43 28 83 C0 0F 83 E0 F8 01 07 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1673_0 {
	meta:
		name = "SetupBindings"
		size = 364
		refs = "0014 SetupBindings 003d @IntfCast 0057 OleCheck 007c :TCustomADODataSet.:1 0081 @DynArraySetLength 00ad InitBinding 0109 GlobalMalloc 0124 @HandleFinally 0141 @DynArrayClear 0149 @IntfClear"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 33 C0 89 45 FC 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F0 33 C0 89 45 EC 8D 45 FC 8B 55 08 8B 52 FC 8B 92 88 01 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 EC 50 8D 45 E8 50 8D 45 F0 50 8B 45 FC 50 8B 00 FF 50 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 F4 8B 45 F0 50 8D 45 F8 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 75 F0 4E 85 F6 72 25 46 33 DB 8B C3 03 C0 8D 04 40 8B 55 E8 8D 14 C2 6B C3 0D 8B 4D F8 8D 04 81 8D 4D F4 E8 ?? ?? ?? ?? 43 4E 75 DE 6A 00 8B 45 08 8B 40 FC 05 94 01 00 00 50 8B 45 F4 50 8B 45 F8 50 8B 45 F0 50 6A 02 8B 45 08 8B 40 FC 8B 80 8C 01 00 00 50 8B 00 FF 50 10 E8 ?? ?? ?? ?? 8B 45 08 8B 40 FC 8B 55 F4 89 90 98 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 EC 50 A1 ?? ?? ?? ?? 50 8B 00 FF 50 14 8B 45 E8 50 A1 ?? ?? ?? ?? 50 8B 00 FF 50 14 C3 E9 ?? ?? ?? ?? EB DA 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E2 5E 5B 8B E5 5D C3 00 11 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D }
	condition:
		$1
}

rule function_1674_0 {
	meta:
		name = "TCustomADODataSet.InitOleDBAccess"
		size = 384
		refs = "0010 TCustomADODataSet.InitOleDBAccess 0026 @IntfClear 003d @IntfCast 004b @CheckAutoResult 00a8 SetupBindings 0133 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 84 D2 0F 84 8D 00 00 00 8D 45 F8 E8 ?? ?? ?? ?? 50 8D 45 F4 8B 55 FC 8B 92 78 01 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 05 88 01 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC 05 8C 01 00 00 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 8B 80 88 01 00 00 50 8B 00 FF 10 8B 45 FC 05 90 01 00 00 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 FC 8B 80 88 01 00 00 50 8B 00 FF 10 55 E8 ?? ?? ?? ?? 59 EB 65 8B 45 FC 83 B8 8C 01 00 00 00 74 32 8B 45 FC 83 B8 94 01 00 00 00 74 26 6A 00 8B 45 FC 8B 80 94 01 00 00 50 8B 45 FC 8B 80 8C 01 00 00 50 8B 00 FF 50 18 8B 45 FC 33 D2 89 90 94 01 00 00 8B 45 FC 05 8C 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 05 90 01 00 00 E8 ?? ?? ?? ?? 8B 45 FC 05 88 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 00 83 02 00 00 00 00 10 00 80 00 00 AA 00 6D 2E A4 7C 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D 8C 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D 9D 3A 73 0C 1C 2A CE 11 AD E5 00 AA 00 44 77 3D }
	condition:
		$1
}

rule function_1675_0 {
	meta:
		name = "TCustomADODataSet.PrepareCursor"
		size = 276
		refs = "0010 TCustomADODataSet.PrepareCursor 0040 StringReplace 004b @WStrFromUStr 0055 TCustomADODataSet.InternalSetSort 0068 TCustomADODataSet.GetParameters 0079 TCustomADODataSet.SetDetailFilter 0092 TCustomADODataSet.ActivateTextFilter 00af @CheckAutoResult 00d5 @UStrClr 00dd @WStrClr 00e3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB B4 01 00 00 00 74 36 0F B6 05 ?? ?? ?? ?? 50 8D 45 F8 50 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 83 B4 01 00 00 E8 ?? ?? ?? ?? 8B 55 F8 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 83 D8 01 00 00 80 78 15 00 74 18 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 75 07 8B C3 E8 ?? ?? ?? ?? 80 BB AC 00 00 00 00 74 10 83 7B 7C 00 74 0A 8B 53 7C 8B C3 E8 ?? ?? ?? ?? 8D 45 F4 50 68 00 22 00 00 8B 83 78 01 00 00 50 8B 00 FF 90 F8 00 00 00 E8 ?? ?? ?? ?? 66 83 7D F4 00 74 0A 8B C3 8B 10 FF 92 F8 01 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 00 00 01 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2C 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 3B 00 00 00 }
	condition:
		$1
}

rule function_1677_0 {
	meta:
		name = "TCustomADODataSet.LoadFromFile"
		size = 50
		refs = "0009 TDataSet.Close 0012 TCustomADODataSet.SetCommandType 001b TCustomADODataSet.SetLockType 0024 TCustomADODataSet.SetCommandText 002b TDataSet.Open"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? B2 04 8B C3 E8 ?? ?? ?? ?? B2 04 8B C3 E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1678_0 {
	meta:
		name = "TCustomADODataSet.SaveToFile"
		size = 272
		refs = "0020 TCustomADODataSet.SaveToFile 002d TDataSet.CheckBrowseMode 0037 @UStrFromWStr 003f FileExists 0055 @UStrToPWChar 005b DeleteFile 0070 ExtractFileExt 007b LowerCase 0088 @UStrEqual 009a @VarFromWStr 00ba @CheckAutoResult 00d8 @VarClr 00e5 @UStrArrayClr 00eb @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B D9 8B F2 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 84 C0 74 18 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 45 EC 8B D6 E8 ?? ?? ?? ?? 8B 45 EC 8D 55 F0 E8 ?? ?? ?? ?? 8B 45 F0 8D 55 F4 E8 ?? ?? ?? ?? 8B 45 F4 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 02 B3 01 0F B6 C3 50 8D 45 DC 8B D6 E8 ?? ?? ?? ?? FF 75 E8 FF 75 E4 FF 75 E0 FF 75 DC 8B 87 78 01 00 00 50 8B 00 FF 90 50 01 00 00 E8 ?? ?? ?? ?? 8B C7 C7 40 5C FF FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC BA 05 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5F 5E 5B 8B E5 5D C3 B0 04 02 00 FF FF FF FF 04 00 00 00 2E 00 78 00 6D 00 6C 00 00 00 00 00 }
	condition:
		$1
}

rule function_1679_0 {
	meta:
		name = "TCustomADODataSet.Clone"
		size = 195
		refs = "0019 TCustomADODataSet.Clone 0027 TDataSet.Close 002f @IntfClear 003a LockTypeValues 004f @CheckAutoResult 005f @IntfCopy 0075 TDataSet.Open 0084 @HandleAnyException 0096 @RaiseAgain 009b @DoneExcept 00b6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B D9 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 50 0F B6 C3 8B 04 85 ?? ?? ?? ?? 50 8B 86 78 01 00 00 50 8B 00 FF 90 3C 01 00 00 E8 ?? ?? ?? ?? 8B 55 F8 8B 45 FC 05 78 01 00 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB 1C E9 ?? ?? ?? ?? 8B 45 FC 05 78 01 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1680_0 {
	meta:
		name = "TCustomADODataSet.NextRecordset"
		size = 124
		refs = "0018 TCustomADODataSet.NextRecordset 0025 TDataSet.CheckBrowseMode 002c @IntfClear 0035 @VarClr 004a @CheckAutoResult 0052 @VarToInteger 006f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 8D 45 F0 E8 ?? ?? ?? ?? 50 8B 83 78 01 00 00 50 8B 00 FF 90 F4 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 89 06 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1681_0 {
	meta:
		name = "TCustomADODataSet.DataEvent"
		size = 89
		refs = "0022 TDataSet.GetActive 0036 FieldListCheckSum 0051 TDataSet.DataEvent"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C3 2C 04 74 10 2C 04 75 37 8B 86 C8 01 00 00 C6 40 20 00 EB 2B 8B C6 E8 ?? ?? ?? ?? 84 C0 74 20 83 BE 98 00 00 00 00 74 17 8B C6 E8 ?? ?? ?? ?? 3B 86 98 00 00 00 74 08 33 C0 89 86 98 00 00 00 8B CF 8B D3 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1682_0 {
	meta:
		name = "DesignerDataStored"
		size = 68
		refs = "0027 @UStrEqual"
	strings:
		$1 = { 55 8B EC 53 8B 45 08 8B 40 FC 8B 58 20 85 DB 74 20 8B 45 08 8B 83 D4 01 00 00 8B 55 08 8B 52 F8 8B 92 D4 01 00 00 E8 ?? ?? ?? ?? 0F 95 C0 5B 5D C3 8B 45 08 8B 40 F8 83 B8 D4 01 00 00 00 0F 95 C0 5B 5D C3 }
	condition:
		$1
}

rule function_1683_0 {
	meta:
		name = "TCustomADODataSet.DefineProperties"
		size = 112
		refs = "0014 TComponent.DefineProperties 001d TCustomADODataSet.ReadDesignerData 0026 TCustomADODataSet.WriteDesignerData 002c DesignerDataStored 0034 TCustomADODataSet.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 0C 00 00 00 44 00 65 00 73 00 69 00 67 00 6E 00 65 00 72 00 44 00 61 00 74 00 61 00 00 00 00 00 }
	condition:
		$1
}

rule function_40464_0 {
	meta:
		name = "TCustomSQLDataSet.DefineProperties"
		size = 112
		refs = "0014 TComponent.DefineProperties 001d TCustomSQLDataSet.ReadDesignerData 0026 TCustomSQLDataSet.WriteDesignerData 002c DesignerDataStored 0034 TCustomSQLDataSet.DefineProperties"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 89 55 FC 89 45 F8 8B 55 FC 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 8B 45 F8 50 68 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 8B C8 BA ?? ?? ?? ?? 8B 45 FC 8B 18 FF 53 04 5B 59 59 5D C3 00 00 00 B0 04 02 00 FF FF FF FF 0C 00 00 00 44 00 65 00 73 00 69 00 67 00 6E 00 65 00 72 00 44 00 61 00 74 00 61 00 00 00 00 00 }
	condition:
		$1
}

rule function_1684_0 {
	meta:
		name = "TCustomADODataSet.ReadDesignerData"
		size = 83
		refs = "000f TCustomADODataSet.ReadDesignerData 001f TReader.ReadString 002d @UStrAsg 0042 @UStrClr 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 55 FC 8D 83 D4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1685_0 {
	meta:
		name = "TCustomADODataSet.WriteDesignerData"
		size = 13
		refs = "0008 TWriter.WriteString"
	strings:
		$1 = { 8B 80 D4 01 00 00 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1686_0 {
	meta:
		name = "TCustomADODataSet.MasterChanged"
		size = 67
		refs = "0006 TDataSet.GetActive 0011 TCustomADODataSet.GetParameters 0022 TDataSet.CheckBrowseMode 0029 TCustomADODataSet.SetDetailFilter 0034 TDataSet.First 003d TCustomADODataSet.RefreshParams"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 84 C0 74 33 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 75 1B 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 84 C0 74 10 8B C3 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1687_0 {
	meta:
		name = "TCustomADODataSet.MasterDisabled"
		size = 36
		refs = "0006 TCustomADODataSet.GetParameters 0017 TDataSet.CheckBrowseMode 001e TCustomADODataSet.DeactivateFilters"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 85 C0 75 0E 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1688_0 {
	meta:
		name = "FieldValueChanged"
		size = 143
		refs = "0011 FieldValueChanged 0036 VarToStr 004d SameStr 005c @VarCmpNE 007b @UStrArrayClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 3B 0E 75 04 B0 01 EB 07 66 83 3E 0E 0F 94 C0 84 C0 74 27 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 34 01 8B D8 EB 0E 8B C3 8B D6 E8 ?? ?? ?? ?? 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1689_0 {
	meta:
		name = "MasterFieldsChanged"
		size = 234
		refs = "0016 MasterFieldsChanged 0059 TList.Get 0077 TCustomADODataSet.GetParameters 0083 @WStrFromUStr 008c TParameters.ParamByName 0094 TParameter.GetValue 009d FieldValueChanged 00c0 @WStrClr 00c9 Variant 00d3 @FinalizeArray 00d9 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FF 00 8B 45 08 8B 40 FC 8B 80 D8 01 00 00 83 78 04 00 74 79 8B 55 08 8B 40 24 8B 70 08 4E 85 F6 7C 6B 46 33 FF 8B 45 08 8B 40 FC 8B 80 D8 01 00 00 8B 40 24 8B D7 E8 ?? ?? ?? ?? 8B D8 8D 55 EC 8B C3 8B 08 FF 91 84 00 00 00 8D 45 EC 50 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 50 8D 45 D8 8B 53 3C E8 ?? ?? ?? ?? 8B 55 D8 58 E8 ?? ?? ?? ?? 8D 55 DC E8 ?? ?? ?? ?? 8D 45 DC 5A E8 ?? ?? ?? ?? 84 C0 74 06 C6 45 FF 01 EB 04 47 4E 75 98 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 DC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 0F B6 45 FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1690_0 {
	meta:
		name = "TCustomADODataSet.RefreshParams"
		size = 144
		refs = "000c TDataSet.DisableControls 0014 TCustomADODataSet.RefreshParams 0038 TDataSet.GetActive 004b MasterFieldsChanged 0058 TCustomADODataSet.SetParamsFromCursor 0067 TCustomADODataSet.Requery 007c TDataSet.EnableControls 0082 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 80 D8 01 00 00 8B 40 04 85 C0 74 3D 8B 58 34 85 DB 74 36 8B C3 E8 ?? ?? ?? ?? 84 C0 74 2B 80 BB A1 00 00 00 04 74 22 55 E8 ?? ?? ?? ?? 59 84 C0 74 17 8B 45 FC E8 ?? ?? ?? ?? 0F B6 15 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 00 00 00 }
	condition:
		$1
}

rule function_1691_0 {
	meta:
		name = "TCustomADODataSet.SetParamsFromCursor"
		size = 169
		refs = "0014 TCustomADODataSet.SetParamsFromCursor 0044 TList.Get 005f TCustomADODataSet.GetParameters 006e @WStrFromUStr 0077 TParameters.ParamByName 0096 @WStrClr 009c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 D8 01 00 00 83 78 04 00 74 5B 8B 40 24 8B 78 08 4F 85 FF 7C 50 47 33 F6 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 89 45 FC 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 50 8D 45 F8 8B 55 FC 8B 52 3C E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 5A 8B 08 FF 51 08 46 4F 75 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1692_0 {
	meta:
		name = "TCustomADODataSet.SetDetailFilter"
		size = 344
		refs = "0019 TCustomADODataSet.SetDetailFilter 003e TCustomADODataSet.GetIndexFieldCount 004b TCustomADODataSet.GetIndexField 0060 TList.Get 008f GetFilterStr 009a @UStrFromWStr 00b8 @UStrCatN 00c5 @UStrLAsg 00db @UStrEqual 00f3 @UStrAsg 00fd TCustomADODataSet.ActivateTextFilter 0112 @VarClr 011a @WStrClr 0127 @UStrArrayClr 012d @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 83 D8 01 00 00 8B 40 24 8B 78 08 4F 85 FF 0F 8C 99 00 00 00 47 33 F6 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 0E 8B D6 8B C3 E8 ?? ?? ?? ?? 89 45 F0 EB 13 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 89 45 F0 8D 45 EC 50 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 8D 55 DC 8B 08 FF 91 84 00 00 00 8D 55 DC 33 C9 8B 45 F0 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 FC E8 ?? ?? ?? ?? 83 7D F8 00 74 1A FF 75 F8 68 ?? ?? ?? ?? FF 75 FC 8D 45 F8 BA 03 00 00 00 E8 ?? ?? ?? ?? EB 0B 8D 45 F8 8B 55 FC E8 ?? ?? ?? ?? 46 4F 0F 85 6A FF FF FF 8B 83 B0 01 00 00 8B 55 F8 E8 ?? ?? ?? ?? 0F 95 45 F7 80 7D F7 00 74 18 8D 83 B0 01 00 00 8B 55 F8 E8 ?? ?? ?? ?? 8B 55 F8 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 0F B6 45 F7 5F 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 20 00 41 00 4E 00 44 00 20 00 00 00 }
	condition:
		$1
}

rule function_1693_0 {
	meta:
		name = "TCustomADODataSet.DoOnNewRecord"
		size = 167
		refs = "0049 TCustomADODataSet.GetIndexFieldCount 0056 TCustomADODataSet.GetIndexField 006a TList.Get 0074 TDataSet.FindField 009e TDataSet.DoOnNewRecord"
	strings:
		$1 = { 53 56 57 55 8B D8 8B C3 8B 50 58 8B 40 60 8B 04 90 C7 40 11 01 00 00 00 8B 83 BC 01 00 00 8B 10 FF 52 08 8B 83 D8 01 00 00 80 78 15 00 74 6C 8B 50 24 83 7A 08 00 7E 63 8B 40 24 8B 68 08 4D 85 ED 7C 58 45 33 F6 8B C3 E8 ?? ?? ?? ?? 3B F0 7D 0D 8B D6 8B C3 E8 ?? ?? ?? ?? 8B F8 EB 1C 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 8B 50 3C 8B C3 E8 ?? ?? ?? ?? 8B F8 85 FF 74 19 8B 83 D8 01 00 00 8B 40 24 8B D6 E8 ?? ?? ?? ?? 8B D0 8B C7 8B 08 FF 51 08 46 4D 75 AB 8B C3 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1694_0 {
	meta:
		name = "TCustomADODataSet.InternalGotoBookmark"
		size = 29
		refs = "0018 @CheckAutoResult"
	strings:
		$1 = { FF 72 0C FF 72 08 FF 72 04 FF 32 8B 80 78 01 00 00 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_1695_0 {
	meta:
		name = "TCustomADODataSet.InternalSetToRecord"
		size = 35
	strings:
		$1 = { 56 57 8B F0 8B FA 0F B6 47 10 84 C0 74 04 2C 03 75 0E 8B C7 8B D0 8B C6 8B 08 FF 91 FC 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule function_1696_0 {
	meta:
		name = "TCustomADODataSet.GetBookmarkFlag"
		size = 5
	strings:
		$1 = { 0F B6 42 10 C3 }
	condition:
		$1
}

rule function_1697_0 {
	meta:
		name = "TCustomADODataSet.SetBookmarkFlag"
		size = 4
	strings:
		$1 = { 88 4A 10 C3 }
	condition:
		$1
}

rule function_1698_0 {
	meta:
		name = "TCustomADODataSet.GetBookmarkData"
		size = 35
		refs = "000d OleVariant 0012 @Initialize 001b @VarCopy"
	strings:
		$1 = { 53 56 57 8B D9 8B FA 8B F3 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 8B D7 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1699_0 {
	meta:
		name = "TCustomADODataSet.SetBookmarkData"
		size = 29
		refs = "000f @VarCopy"
	strings:
		$1 = { 53 56 8B D9 8B F2 85 DB 74 0C 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 C6 46 10 04 5E 5B C3 }
	condition:
		$1
}

rule function_1700_0 {
	meta:
		name = "TCustomADODataSet.BookmarkValid"
		size = 182
		refs = "0012 @DynArrayAddRef 001a TCustomADODataSet.BookmarkValid 0032 VarIsNull 0063 @CheckAutoResult 007f @HandleAnyException 0084 @DoneExcept 009a TBytes 009f @DynArrayClear 00a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FB 00 83 7D FC 00 74 5A 8B 45 FC E8 ?? ?? ?? ?? 84 C0 75 4E 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC FF 70 0C FF 70 08 FF 70 04 FF 30 8B 83 78 01 00 00 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 8B C3 C7 40 5C FF FF FF FF C6 45 FB 01 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EA 0F B6 45 FB 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1701_0 {
	meta:
		name = "TCustomADODataSet.CompareBookmarks"
		size = 264
		refs = "0015 @DynArrayAddRef 0025 TCustomADODataSet.CompareBookmarks 0046 RetCodes 0095 @CheckAutoResult 00a5 @VarToInteger 00cc @HandleAnyException 00d3 @DoneExcept 00e9 TBytes 00f3 @FinalizeArray 00f9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 89 4D F8 89 55 FC 8B F0 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D F8 00 0F 94 C0 83 E0 7F 83 7D FC 00 0F 94 C2 83 E2 7F 8D 14 55 ?? ?? ?? ?? 0F BE 1C 02 83 FB 02 0F 85 80 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 45 F4 50 8B 45 F8 FF 70 0C FF 70 08 FF 70 04 FF 30 8B 7D FC FF 77 0C FF 77 08 FF 77 04 FF 37 8B 86 78 01 00 00 50 8B 00 FF 90 38 01 00 00 E8 ?? ?? ?? ?? 8B 5D F4 4B 83 FB 01 7E 1F 8B C7 E8 ?? ?? ?? ?? 8B D8 8B 45 F8 E8 ?? ?? ?? ?? 3B C3 7D 07 BB 01 00 00 00 EB 03 83 CB FF 33 C0 5A 59 59 64 89 10 EB 0C E9 ?? ?? ?? ?? 33 DB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1702_0 {
	meta:
		name = "TCustomADODataSet.GetRecordSize"
		size = 8
	strings:
		$1 = { 0F B7 80 A8 01 00 00 C3 }
	condition:
		$1
}

rule function_1703_0 {
	meta:
		name = "TCustomADODataSet.AllocRecordBuffer"
		size = 59
		refs = "000b AllocMem 0015 TRecInfo 001a @Initialize 0022 TFields.GetCount 002d TVariantList 0032 @InitializeArray"
	strings:
		$1 = { 53 56 8B D8 8B 83 A8 01 00 00 E8 ?? ?? ?? ?? 8B F0 8B C6 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 43 34 E8 ?? ?? ?? ?? 8B C8 8D 46 19 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_1704_0 {
	meta:
		name = "TCustomADODataSet.FreeRecordBuffer"
		size = 67
		refs = "000a TRecInfo 000f @Finalize 0017 TFields.GetCount 0030 TVariantList 0035 @FinalizeArray 003c @FreeMem"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B 06 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 43 34 E8 ?? ?? ?? ?? 85 C0 7E 1A 8B 43 34 E8 ?? ?? ?? ?? 8B C8 8B 06 83 C0 19 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1705_0 {
	meta:
		name = "TCustomADODataSet.InternalGetRecord"
		size = 770
		refs = "0023 TCustomADODataSet.InternalGetRecord 003a TDataSet.GetActive 0107 @CheckAutoResult 0152 TFields.GetCount 0168 TVariantList 016d @FinalizeArray 0241 @VarClr 025d @VarCopy 02c4 @HandleAnyException 02cf @RaiseAgain 02d6 @DoneExcept 02f1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 33 DB 89 5D E0 89 5D E4 89 5D E8 89 5D EC 88 4D FB 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 9E E4 01 00 00 85 DB 74 2B 8B C3 E8 ?? ?? ?? ?? 84 C0 74 20 8B 96 E4 01 00 00 8B C2 8B 48 58 3B 48 54 7C 04 B0 01 EB 0E 80 BA A1 00 00 00 03 0F 94 C0 EB 02 33 C0 84 C0 74 04 B0 01 EB 45 8B 86 D8 01 00 00 80 78 15 00 74 37 8B C6 8B 10 FF 92 54 01 00 00 8B 40 34 8B 50 58 3B 50 54 0F 9D C0 84 C0 74 04 B0 01 EB 1B 8B C6 8B 10 FF 92 54 01 00 00 8B 40 34 80 B8 A1 00 00 00 03 0F 94 C0 EB 02 33 C0 84 C0 74 07 B3 02 E9 1E 02 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 0F B6 45 FB 2C 01 0F 82 EE 00 00 00 74 0D FE C8 0F 84 94 00 00 00 E9 1B 01 00 00 80 BE A1 00 00 00 00 75 06 83 7E 68 00 7E 30 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 7D F4 00 75 14 8B 86 78 01 00 00 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 7D F4 00 74 02 B3 02 83 7E 68 00 0F 85 B4 00 00 00 8B 46 34 E8 ?? ?? ?? ?? 8B C8 8B FE 8B 47 58 8B 57 60 8B 04 82 83 C0 19 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 8C 00 00 00 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 66 83 7D F4 00 75 14 8B 86 78 01 00 00 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 66 83 7D F4 00 74 40 B3 01 EB 3C 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 66 83 7D F4 00 74 02 B3 01 8D 45 F4 50 8B 86 78 01 00 00 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 7D F4 00 74 02 B3 02 84 DB 0F 85 AF 00 00 00 8B 45 FC 8B F8 8D 45 F0 50 8B 86 78 01 00 00 50 8B 00 FF 90 D8 00 00 00 E8 ?? ?? ?? ?? 8B 45 F0 89 47 11 83 7E 68 00 7E 5A F6 47 11 04 75 54 C6 47 10 00 8D 45 E0 E8 ?? ?? ?? ?? 50 8B 86 78 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8D 55 E0 8B C7 E8 ?? ?? ?? ?? 83 7E 74 00 74 09 C7 47 15 FE FF FF FF EB 21 8D 45 F0 50 8B 86 78 01 00 00 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 8B 45 F0 89 47 15 EB 04 C6 47 10 04 8B 46 34 E8 ?? ?? ?? ?? 8B C8 8B 45 FC 83 C0 19 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 8B 08 FF 91 4C 01 00 00 33 C0 5A 59 59 64 89 10 EB 17 E9 ?? ?? ?? ?? 80 7D 08 00 74 05 E8 ?? ?? ?? ?? B3 03 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1706_0 {
	meta:
		name = "TCustomADODataSet.GetRecord"
		size = 325
		refs = "001a TCustomADODataSet.GetRecord 003a SBookmarksRequired 003f LoadResString 0049 DatabaseError 007d TDataSet.SetTempState 00a5 TCustomADODataSet.InternalGetRecord 00e7 @HandleAnyException 00ef ApplicationHandleException 00f6 @DoneExcept 0102 TDataSet.RestoreState 012e @UStrClr 0134 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 88 4D FB 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 83 78 68 00 75 20 8B 45 FC 83 78 50 01 7E 17 8D 55 F4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F4 33 D2 E8 ?? ?? ?? ?? 8B 45 FC 80 B8 AC 00 00 00 00 0F 84 AB 00 00 00 8B 45 FC 66 83 B8 6A 01 00 00 00 0F 84 9A 00 00 00 8B 45 FC 89 B0 A4 01 00 00 B2 06 8B 45 FC E8 ?? ?? ?? ?? 88 45 F9 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C6 45 FA 01 0F B6 45 08 50 0F B6 4D FB 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B D8 84 DB 75 23 8D 4D FA 8B 7D FC 8B 55 FC 8B 87 6C 01 00 00 FF 97 68 01 00 00 80 7D FA 00 75 08 80 7D FB 00 75 02 B3 03 80 7D FA 00 75 04 84 DB 74 BA 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? B3 03 E8 ?? ?? ?? ?? 0F B6 55 F9 8B 45 FC E8 ?? ?? ?? ?? EB 15 0F B6 45 08 50 0F B6 4D FB 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1707_0 {
	meta:
		name = "TCustomADODataSet.InternalInitRecord"
		size = 114
		refs = "0014 TCustomADODataSet.InternalInitRecord 0022 TFields.GetCount 0034 Null 0046 @OleVarFromVar 005f @VarClr 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B FA 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 34 E8 ?? ?? ?? ?? 48 85 C0 7C 23 40 89 C3 33 F6 8D 45 F0 E8 ?? ?? ?? ?? 8D 55 F0 8B C6 03 C0 8D 4F 19 8D 04 C1 E8 ?? ?? ?? ?? 46 4B 75 E2 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1708_0 {
	meta:
		name = "TCustomADODataSet.ClearCalcFields"
		size = 162
		refs = "0017 TCustomADODataSet.ClearCalcFields 002b TFields.GetCount 0045 TFields.GetField 0057 TField.GetIndex 006b Null 0074 @OleVarFromVar 008f @VarClr 0095 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7F 6C 00 7E 57 8B 47 34 E8 ?? ?? ?? ?? 8B F0 4E 85 F6 7C 48 46 C7 45 F8 00 00 00 00 8B 47 34 8B 55 F8 E8 ?? ?? ?? ?? 8B D8 0F B6 43 46 48 2C 02 73 24 8B C3 E8 ?? ?? ?? ?? 03 C0 8B 55 FC 83 C2 19 8D 04 C2 50 8D 45 E8 E8 ?? ?? ?? ?? 8D 55 E8 58 E8 ?? ?? ?? ?? FF 45 F8 4E 75 C0 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1709_0 {
	meta:
		name = "TCustomADODataSet.GetActiveRecBuf"
		size = 191
		refs = "001a TCustomADODataSet.GetActiveRecBuf 0067 @CheckAutoResult"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 0F B6 83 A1 00 00 00 83 F8 0B 0F 87 9A 00 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 02 02 00 03 04 02 00 00 01 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B C3 8B 50 58 3B 50 54 7C 04 B0 01 EB 25 83 7B 68 00 75 19 54 8B 83 78 01 00 00 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 3C 24 00 75 04 33 C0 EB 02 B0 01 84 C0 74 06 33 C0 89 06 EB 33 8B C3 8B 50 58 8B 40 60 8B 04 90 89 06 EB 24 8B C3 8B 50 58 8B 40 60 8B 04 90 89 06 EB 15 8B 43 64 89 06 EB 0E 8B 83 A4 01 00 00 89 06 EB 04 33 C0 89 06 83 3E 00 0F 95 C0 5A 5E 5B C3 }
	condition:
		$1
}

rule function_1710_0 {
	meta:
		name = "TCustomADODataSet.UpdateRecordSetPosition"
		size = 253
		refs = "0016 TCustomADODataSet.UpdateRecordSetPosition 0048 @CheckAutoResult 0073 @VarClr 008f @VarCmpNE 00a2 TDataSet.GetActive 00f0 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 57 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 80 BB A1 00 00 00 05 0F 84 AC 00 00 00 83 7B 68 00 0F 8E A2 00 00 00 8D 45 FC 50 8B 83 78 01 00 00 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 66 83 7D FC 00 75 42 8D 45 F8 50 8B 83 78 01 00 00 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 66 83 7D F8 00 75 26 8D 45 E8 E8 ?? ?? ?? ?? 50 8B 83 78 01 00 00 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 8D 45 E8 8B D6 E8 ?? ?? ?? ?? 74 44 8B BB E4 01 00 00 85 FF 74 25 8B C7 E8 ?? ?? ?? ?? 84 C0 74 1A 8B 93 E4 01 00 00 8B 4A 58 8B 83 E4 01 00 00 8B 52 60 8B 14 8A E8 ?? ?? ?? ?? 8B D6 8B C3 8B 08 FF 91 0C 02 00 00 8B C3 C7 40 5C FF FF FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1712_0 {
	meta:
		name = "TCustomADODataSet.GetFieldData"
		size = 19
	strings:
		$1 = { 53 56 8B F0 6A 01 8B C6 8B 18 FF 93 88 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_1713_0 {
	meta:
		name = "CurrToBuffer"
		size = 69
	strings:
		$1 = { 55 8B EC 53 8B 45 10 80 78 08 00 74 22 8B 45 10 8B 40 E4 50 6A 01 8D 4D 08 8B 45 10 8B 50 E8 8B 45 10 8B 40 EC 8B 18 FF 93 D4 00 00 00 EB 11 8B 45 10 8B 40 E4 8B 55 08 89 10 8B 55 0C 89 50 04 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_1714_0 {
	meta:
		name = "VarToBuffer"
		size = 984
		refs = "0015 VarToBuffer 00e2 SysStringLen 00f1 WideCharToMultiByte 0107 WStrCopy 017f @VarToInteger 01ba @VarToReal 01d6 VarToBcd 020b CurrToBuffer 0220 @VarToCurrency 02d3 @VarCopy 02e9 @VarToIntf 02ff @VarToDisp 0322 @_llmul 036a FieldTypeNames 0382 TField.GetDisplayName 0398 SUsupportedFieldType 039d LoadResString 03ab DatabaseErrorFmt 03c5 @UStrArrayClr 03cb @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 C4 53 56 57 33 C0 89 45 C8 89 45 C4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 8B 40 E8 0F B6 40 44 83 F8 27 0F 87 2A 03 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 00 01 03 05 04 09 06 06 08 0A 0A 0A 0B 0B 05 0F 0F 0F 0F 0F 0F 0F 00 01 02 0E 00 00 00 00 00 00 0F 0C 0D 01 00 07 02 0F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 8B 40 E8 8B 10 FF 92 A8 00 00 00 8B 55 08 8B 52 E4 C6 04 02 00 6A 00 6A 00 8B 45 08 8B 40 E8 8B 10 FF 92 A8 00 00 00 50 8B 45 08 8B 40 E4 50 8B 45 08 8B 58 F8 53 E8 ?? ?? ?? ?? 40 50 8B 45 08 53 6A 00 6A 00 E8 ?? ?? ?? ?? E9 B5 02 00 00 8B 45 08 8B 50 F8 8B 45 08 8B 40 E4 E8 ?? ?? ?? ?? E9 9F 02 00 00 8B 45 08 66 83 78 F0 11 75 15 8B 45 08 0F B6 40 F8 8B 55 08 8B 52 E4 66 89 02 E9 80 02 00 00 8B 45 08 0F B7 40 F8 8B 55 08 8B 52 E4 66 89 02 E9 6B 02 00 00 8B 45 08 66 83 78 F0 11 75 15 8B 45 08 0F B6 40 F8 8B 55 08 8B 52 E4 66 89 02 E9 4C 02 00 00 8B 45 08 0F B7 40 F8 8B 55 08 8B 52 E4 66 89 02 E9 37 02 00 00 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 8B 55 08 8B 52 E4 89 02 E9 1F 02 00 00 8B 45 08 66 83 78 F0 05 75 19 8B 45 08 8B 40 E4 8B 55 08 8B 4A F8 89 08 8B 4A FC 89 48 04 E9 FC 01 00 00 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 E4 DD 18 9B E9 E3 01 00 00 8D 55 DC 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 8B 45 08 8B 40 E4 8D 75 DC 8B F8 B9 08 00 00 00 F3 A5 66 A5 E9 BC 01 00 00 8B 45 08 66 83 78 F0 06 75 18 8B 45 08 50 8B 45 08 FF 70 FC FF 70 F8 E8 ?? ?? ?? ?? 59 E9 9A 01 00 00 8B 45 08 50 8B 45 08 83 C0 F0 E8 ?? ?? ?? ?? 83 C4 F8 DF 3C 24 9B E8 ?? ?? ?? ?? 59 E9 79 01 00 00 8B 45 08 0F B7 40 F8 8B 55 08 8B 52 E4 66 89 02 E9 64 01 00 00 8B 45 08 80 78 08 00 74 28 8B 45 08 8B 40 E4 50 6A 01 8B 45 08 8D 48 F8 8B 45 08 8B 50 E8 8B 45 08 8B 40 EC 8B 18 FF 93 D4 00 00 00 E9 33 01 00 00 8B 45 08 8B 40 E4 8B 55 08 8B 4A F8 89 08 8B 4A FC 89 48 04 E9 1A 01 00 00 8B 45 08 80 78 08 00 74 28 8B 45 08 8B 40 E4 50 6A 01 8B 45 08 8D 48 F0 8B 45 08 8B 50 E8 8B 45 08 8B 40 EC 8B 18 FF 93 D4 00 00 00 E9 E9 00 00 00 8B 45 08 8B 40 E4 8B 55 08 83 C2 F0 E8 ?? ?? ?? ?? E9 D3 00 00 00 8B 45 08 8B 40 E4 8B 55 08 83 C2 F0 E8 ?? ?? ?? ?? E9 BD 00 00 00 8B 45 08 8B 40 E4 8B 55 08 83 C2 F0 E8 ?? ?? ?? ?? E9 A7 00 00 00 8B 45 08 80 78 F3 00 76 22 8B 45 08 FF 70 FC FF 70 F8 B8 FF FF FF FF 8B D0 E8 ?? ?? ?? ?? 8B 4D 08 8B 49 E4 89 01 89 51 04 EB 7C 8B 45 08 8B 40 E4 8B 55 08 8B 4A F8 89 08 8B 4A FC 89 48 04 EB 66 8B 45 08 8B 40 E4 8B 55 08 83 C2 F0 E8 ?? ?? ?? ?? EB 53 6A 00 8B 45 08 8B 40 E8 0F B6 40 44 8B 15 ?? ?? ?? ?? 8B 04 82 89 45 CC C6 45 D0 11 8D 55 C8 8B 45 08 8B 40 E8 E8 ?? ?? ?? ?? 8B 45 C8 89 45 D4 C6 45 D8 11 8D 45 CC 50 8D 55 C4 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 C4 B9 01 00 00 00 5A E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1715_0 {
	meta:
		name = "RefreshBuffers"
		size = 64
		refs = "000a FieldListCheckSum 0021 TDataSet.UpdateCursorPos 002e RefreshBuffers"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 EC E8 ?? ?? ?? ?? 8B 55 08 8B 52 EC 89 82 98 00 00 00 8B 45 08 8B 40 EC E8 ?? ?? ?? ?? 8B 45 08 8B 40 EC 0F B6 15 ?? ?? ?? ?? 8B 08 FF 91 A8 02 00 00 5D C3 00 00 00 00 }
	condition:
		$1
}

rule function_1716_0 {
	meta:
		name = "TCustomADODataSet.GetFieldData"
		size = 435
		refs = "0022 TCustomADODataSet.GetFieldData 003a RefreshBuffers 0046 TCustomADODataSet.GetActiveRecBuf 0058 TField.GetIndex 006b @VarCopy 0073 VarIsClear 00a2 TCustomADODataSet.UpdateRecordSetPosition 00aa @VarClr 00b3 @IntfClear 00cc @OleVarFromInt 00f5 @CheckAutoResult 0125 Null 0130 @OleVarFromVar 0153 VarIsNull 0168 VarToBuffer 01a4 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 89 4D E4 89 55 E8 89 45 EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 EC 83 B8 98 00 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 8D 55 E0 8B 45 EC E8 ?? ?? ?? ?? 8B D8 84 DB 0F 84 19 01 00 00 8B 45 E8 E8 ?? ?? ?? ?? 03 C0 8B 55 E0 83 C2 19 8D 14 C2 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 0F 84 D0 00 00 00 8B 45 E8 8B 10 FF 92 9C 00 00 00 85 C0 0F 8E BD 00 00 00 8B 45 E0 F6 40 11 04 75 7A 8B 55 E0 8B 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 50 8D 45 DC E8 ?? ?? ?? ?? 50 8B 45 E8 8B 10 FF 92 9C 00 00 00 8B D0 4A 8D 45 CC B1 FC E8 ?? ?? ?? ?? FF 75 D8 FF 75 D4 FF 75 D0 FF 75 CC 8D 45 C8 E8 ?? ?? ?? ?? 50 8B 45 EC 8B 80 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 C8 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 DC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 84 C0 74 13 8D 45 B8 E8 ?? ?? ?? ?? 8D 55 B8 8D 45 F0 E8 ?? ?? ?? ?? 8B 45 E8 E8 ?? ?? ?? ?? 03 C0 8B 55 E0 83 C2 19 8D 04 C2 8D 55 F0 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8B D8 80 F3 01 84 DB 74 0D 83 7D E4 00 74 07 55 E8 ?? ?? ?? ?? 59 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 B8 E8 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D0 8B C3 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1717_0 {
	meta:
		name = "TCustomADODataSet.GetFieldData"
		size = 37
		refs = "000f TFields.FieldByNumber"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 8B 43 34 8B D6 E8 ?? ?? ?? ?? 8B D0 8B CF 8B C3 8B 18 FF 93 80 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1718_0 {
	meta:
		name = "TCustomADODataSet.GetStateFieldValue"
		size = 430
		refs = "0021 TCustomADODataSet.GetStateFieldValue 0050 Null 005c TDataSet.UpdateCursorPos 0075 @VarClr 007e @IntfClear 0097 @OleVarFromInt 00bd @CheckAutoResult 015e TDataSet.GetStateFieldValue 01a1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 89 4D F8 88 55 FF 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 50 58 3B 50 54 7C 04 B0 01 EB 0F 0F B6 83 A1 00 00 00 48 2C 02 0F 92 C0 34 01 84 C0 74 0D 8B 45 08 E8 ?? ?? ?? ?? E9 09 01 00 00 8B C3 E8 ?? ?? ?? ?? 0F B6 45 FF 2C 08 74 09 FE C8 74 76 E9 DF 00 00 00 8B 45 08 E8 ?? ?? ?? ?? 50 8D 45 F4 E8 ?? ?? ?? ?? 50 8B 45 F8 8B 10 FF 92 9C 00 00 00 8B D0 4A 8D 45 E4 B1 FC E8 ?? ?? ?? ?? FF 75 F0 FF 75 EC FF 75 E8 FF 75 E4 8D 45 E0 E8 ?? ?? ?? ?? 50 8B 83 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 E0 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? E9 80 00 00 00 8B 45 08 E8 ?? ?? ?? ?? 50 8D 45 DC E8 ?? ?? ?? ?? 50 8B 45 F8 8B 10 FF 92 9C 00 00 00 8B D0 4A 8D 45 CC B1 FC E8 ?? ?? ?? ?? FF 75 D8 FF 75 D4 FF 75 D0 FF 75 CC 8D 45 C8 E8 ?? ?? ?? ?? 50 8B 83 78 01 00 00 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 8B 45 C8 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 8B 45 DC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? EB 12 8B 45 08 50 8B 4D F8 0F B6 55 FF 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1719_0 {
	meta:
		name = "TCustomADODataSet.SetFieldData"
		size = 25
	strings:
		$1 = { 53 56 57 8B FA 8B F0 6A 01 8B D7 8B C6 8B 18 FF 93 1C 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_1720_0 {
	meta:
		name = "BcdToOleVariant"
		size = 129
		refs = "0014 BcdToOleVariant 0021 @VarClear 002b BcdToStr 0036 @OleVarFromUStr 0049 VariantChangeTypeEx 0052 VarResultCheck 0067 @UStrClr 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 E8 ?? ?? ?? ?? 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 6A 0E 6A 00 68 00 04 00 00 8D 45 F0 50 53 A1 ?? ?? ?? ?? 8B 00 FF D0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1721_0 {
	meta:
		name = "BufferToVar"
		size = 776
		refs = "001b BufferToVar 00bd @LStrFromPChar 00c7 @OleVarFromLStr 00da @WStrFromPWChar 00e4 @VarFromWStr 00fa @OleVarFromInt 0144 @VarFromBool 0158 @VarFrom