private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 16
		refs = "0009 ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 16
		refs = "0009 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "??_U@YAPAXIHPBDH@Z"
		size = 16
		refs = "0009 ??_U@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_904_0_0 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 16
		refs = "0009 ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 748
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d 02df ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2F 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 BA EB 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__execl"
		size = 76
		refs = "0010 __errno 0020 __invalid_parameter 0042 __execve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 1D 38 19 74 DF 8B 45 0C 3B C3 74 D8 38 18 74 D4 53 8D 45 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "___libm_sse2_tanf"
		size = 416
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER_16 0047 _SHIFTER 007a _PP_1 0086 _P_1 0092 _PP_2 009e _P_2 00a8 _Ctable 00e4 _ONE 015b _ONE_P230 018a _tan"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D FF 46 0F 87 3A 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 3D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 F8 F3 0F 5A C0 F2 0F 10 25 ?? ?? ?? ?? F3 0F 58 E1 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 0F 10 2D ?? ?? ?? ?? 66 0F 57 EF F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D7 F2 0F 10 35 ?? ?? ?? ?? 66 0F 57 F7 F2 0F 10 1D ?? ?? ?? ?? 66 0F 57 DF 8D 05 ?? ?? ?? ?? C1 E2 03 03 C2 C1 E2 03 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 29
		refs = "0014 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_462_7_0 {
	meta:
		name = "__aligned_recalloc"
		size = 29
		refs = "0014 __aligned_offset_recalloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_685_20_0 {
	meta:
		name = "__cftof"
		size = 29
		refs = "0014 __cftof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 29
		refs = "0014 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 29
		refs = "0014 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 29
		refs = "0014 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 29
		refs = "0014 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 29
		refs = "0014 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_673_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 29
		refs = "0014 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_517_8_0 {
	meta:
		name = "_wcsftime"
		size = 29
		refs = "0014 __wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_637_4_0 {
	meta:
		name = "_wctomb_s"
		size = 29
		refs = "0014 __wctomb_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 135
		refs = "0014 __getptd 002a ___ptlocinfo 0032 ___globallocalestatus 003c ___updatetlocinfo 0047 ___ptmbcinfo 005c ___updatetmbcinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 C6 46 0C 00 85 C0 75 63 E8 ?? ?? ?? ?? 89 46 08 8B 48 6C 89 0E 8B 48 68 89 4E 04 8B 0E 3B 0D ?? ?? ?? ?? 74 12 8B 0D ?? ?? ?? ?? 85 48 70 75 07 E8 ?? ?? ?? ?? 89 06 8B 46 04 3B 05 ?? ?? ?? ?? 74 16 8B 46 08 8B 0D ?? ?? ?? ?? 85 48 70 75 08 E8 ?? ?? ?? ?? 89 46 04 8B 46 08 F6 40 70 02 75 14 83 48 70 02 C6 46 0C 01 EB 0A 8B 08 89 0E 8B 40 04 89 46 04 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "__mbsdec_l"
		size = 153
		refs = "0011 __errno 0021 __invalid_parameter 005e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 33 DB 39 5D 08 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 6A 56 8B 75 0C 3B F3 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 05 39 75 08 72 04 33 C0 EB 3E FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 8D 46 FF 39 59 08 74 1C 48 39 45 08 77 0A 0F B6 10 F6 44 0A 1D 04 75 F0 8B CE 2B C8 83 E1 01 2B F1 4E 8B C6 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_462_3_0 {
	meta:
		name = "__aligned_malloc"
		size = 23
		refs = "000e __aligned_offset_malloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_697_4_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e __atodbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_697_8_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e __atoflt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_697_6_0 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_547_4_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_570_4_0 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_512_4_0 {
	meta:
		name = "__mbbtype"
		size = 23
		refs = "000e __mbbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_846_4_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_170_4_0 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_430_4_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_532_4_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_580_4_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_296_4_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_727_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_440_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_460_1_0 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_142_4_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_493_4_0 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_412_4_0 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_537_4_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_574_1_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_272_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_613_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_441_7_0 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_506_7_0 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_49_7_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_912_7_0 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_728_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_711_1_0 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_568_4_0 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_786_4_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e __strtod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_103_4_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e __wcstod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_wcscpy_s"
		size = 111
		refs = "0019 __errno 0028 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 56 57 33 FF 3B D7 74 07 8B 5D 0C 3B DF 77 1E E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5F 5E 5B 5D C3 8B 75 10 3B F7 75 07 33 C0 66 89 02 EB D4 8B CA 0F B7 06 66 89 01 41 41 46 46 66 3B C7 74 03 4B 75 EE 33 C0 3B DF 75 D3 66 89 02 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB B3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__getws_helper"
		size = 331
		refs = "0003 __sehtable$__getws_helper 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 004a ___iob_func 0051 __lock_file2 0061 __fgetwc_nolock 010f ___security_cookie 0114 __local_unwind4 0135 __SEH_epilog4 0144 __unlock_file2"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 89 75 DC 33 C0 33 FF 3B F7 0F 95 C0 3B C7 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F6 00 00 00 33 C0 3B 45 0C 1B C0 F7 D8 74 D6 E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 59 59 89 7D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 BB FF FF 00 00 3B C3 75 0C 89 7D DC 39 7D 10 0F 85 A4 00 00 00 8B 4D 0C 83 F9 FF 75 2D 83 F8 0A 0F 84 8E 00 00 00 3B C3 0F 84 86 00 00 00 66 89 06 46 46 89 75 D8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 EB D3 89 4D E4 83 F8 0A 74 28 3B C3 74 24 39 7D E4 76 0B FF 4D E4 66 89 06 46 46 89 75 D8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 EB D3 39 7D E4 75 35 33 C0 8B 4D 08 66 89 01 E8 ?? ?? ?? ?? C7 00 22 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 E9 17 FF FF FF 33 C0 66 89 06 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 DC E8 ?? ?? ?? ?? C3 33 FF E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "__getws"
		size = 22
		refs = "000d __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_711_2_0 {
	meta:
		name = "_gets"
		size = 22
		refs = "000d __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 36
		refs = "001b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 17 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "__setdefaultprecision"
		size = 43
		refs = "0011 __controlfp_s 0022 __invoke_watson"
	strings:
		$1 = { 8B FF 56 68 00 00 03 00 68 00 00 01 00 33 F6 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 5E C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_672_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_779_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_942_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_918_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_672_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_779_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_396_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_942_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_918_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__lsearch_s"
		size = 179
		refs = "000e __errno 001e __invalid_parameter 00a3 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 84 00 00 00 57 8B 7D 10 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5F 53 8B 5D 0C 3B DE 74 0A 39 75 14 76 05 39 75 18 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 30 39 37 76 19 53 FF 75 08 FF 75 1C FF 55 18 83 C4 0C 85 C0 74 19 03 5D 14 46 3B 37 72 E7 FF 75 14 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C FF 07 8B C3 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__recalloc"
		size = 123
		refs = "001c __errno 002c __invalid_parameter 0048 __msize 0054 _realloc 006d _memset"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 33 DB 3B CB 76 28 6A E0 33 D2 58 F7 F1 3B 45 10 73 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 41 0F AF 4D 10 56 57 8B F1 39 5D 08 74 0B FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 14 3B DE 73 10 2B F3 56 6A 00 03 DF 53 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__wchmod"
		size = 111
		refs = "000e ___doserrno 0015 __errno 0025 __invalid_parameter 0036 __imp__GetFileAttributesW@4 0041 __imp__GetLastError@0 0047 __dosmaperr 0062 __imp__SetFileAttributesW@8"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3B FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DE F6 45 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__chmod"
		size = 111
		refs = "000e ___doserrno 0015 __errno 0025 __invalid_parameter 0036 __imp__GetFileAttributesA@4 0041 __imp__GetLastError@0 0047 __dosmaperr 0062 __imp__SetFileAttributesA@8"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3B FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DE F6 45 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_wcsncat_s"
		size = 238
		refs = "002f __errno 003e __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 5D 08 56 57 33 FF 39 7D 14 75 10 3B DF 75 10 39 7D 0C 75 12 33 C0 5F 5E 5B C9 C3 3B DF 74 07 8B 4D 0C 3B CF 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 8B 55 10 39 7D 14 74 0B 3B D7 75 07 33 C0 66 89 03 EB D2 6A 02 8B C3 89 4D FC 5E 66 39 38 74 07 03 C6 FF 4D FC 75 F4 39 7D FC 74 E0 83 7D 14 FF 75 16 0F B7 0A 66 89 08 03 C6 03 D6 66 3B CF 74 2F FF 4D FC 75 EC EB 28 39 7D 14 76 1C 0F B7 0A 66 89 08 03 C6 03 D6 66 3B CF 74 0A FF 4D FC 74 05 FF 4D 14 75 E7 39 7D 14 75 05 33 C9 66 89 08 39 7D FC 0F 85 5A FF FF FF 33 C0 83 7D 14 FF 75 10 8B 4D 0C 6A 50 66 89 44 4B FE 58 E9 44 FF FF FF 66 89 03 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 4A FF FF FF }
	condition:
		$1
}

rule file_20_3_0 {
	meta:
		name = "__mbsncpy_s_l"
		size = 523
		refs = "0035 __errno 0044 __invalid_parameter 0088 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 009d _strncpy_s 00df __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 33 DB 56 89 5D F8 39 5D 14 75 13 8B 75 08 3B F3 75 14 39 5D 0C 75 14 33 C0 E9 E0 01 00 00 39 5D 08 74 08 8B 75 08 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 B5 01 00 00 39 5D 14 75 04 88 1E EB C5 57 8B 7D 10 3B FB 75 1E 88 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 54 01 00 00 FF 75 18 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 25 FF 75 14 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 38 5D F4 0F 84 59 01 00 00 8B 4D F0 83 61 70 FD E9 4D 01 00 00 83 7D 14 FF 8B 45 0C 89 45 FC 75 11 8A 07 88 06 46 47 3A C3 74 66 FF 4D FC 75 F1 EB 5F 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 20 8D 47 01 38 18 74 2F 83 7D FC 02 76 35 8A 0F 88 0E 46 8B F8 8A 07 88 06 46 47 83 6D FC 02 EB 0F 8A 07 88 06 46 47 3A C3 74 1B FF 4D FC 74 16 FF 4D 14 75 B9 EB 0F 88 1E 46 C7 45 F8 01 00 00 00 EB 03 89 5D FC 39 5D 14 75 02 88 1E 39 5D FC 0F 85 9B 00 00 00 83 7D 14 FF 75 69 39 5D F8 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 45 0C 8B 7D 08 83 F8 01 76 39 8D 74 07 FE 89 75 14 3B F7 72 1E 8D 45 E8 50 8B 45 14 0F B6 00 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 08 FF 4D 14 39 7D 14 73 E2 8B C6 2B 45 14 A8 01 74 04 88 1E EB 07 8B 45 0C 88 5C 07 FF 38 5D F4 74 07 8B 45 F0 83 60 70 FD 6A 50 58 EB 59 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C6 EB 2D 39 5D F8 74 1A E8 ?? ?? ?? ?? 6A 2A 59 89 08 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C1 EB 0E 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__lsearch"
		size = 175
		refs = "000e __errno 001e __invalid_parameter 009f _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 80 00 00 00 57 8B 7D 10 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5B 53 8B 5D 0C 3B DE 74 0A 39 75 14 76 05 39 75 18 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2C 39 37 76 15 53 FF 75 08 FF 55 18 59 59 85 C0 74 19 03 5D 14 46 3B 37 72 EB FF 75 14 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C FF 07 8B C3 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "_wcsncmp"
		size = 55
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 8B 55 0C 8B 4D 08 FF 4D 10 74 13 0F B7 01 66 85 C0 74 0B 66 3B 02 75 06 41 41 42 42 EB E8 0F B7 01 0F B7 0A 2B C1 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__fptostr"
		size = 191
		refs = "0018 __errno 0027 __invalid_parameter 00a8 _strlen 00b1 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 14 53 56 8B 75 08 33 DB 57 8B 79 0C 3B F3 75 1E E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 85 00 00 00 39 5D 0C 76 DD 8B 55 10 3B D3 88 1E 7E 04 8B C2 EB 02 33 C0 40 39 45 0C 77 0E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB C4 3B D3 C6 06 30 8D 46 01 7E 1A 8A 0F 3A CB 74 06 0F BE C9 47 EB 03 6A 30 59 88 08 40 4A 3B D3 7F E9 8B 4D 14 3B D3 88 18 7C 12 80 3F 35 7C 0D EB 03 C6 00 30 48 80 38 39 74 F7 FE 00 80 3E 31 75 05 FF 41 04 EB 15 8D 7E 01 57 E8 ?? ?? ?? ?? 40 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "__mblen_l"
		size = 191
		refs = "002f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003c __isleadbyte_l 0064 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 0F 84 A2 00 00 00 38 1E 0F 84 9A 00 00 00 39 5D 0C 0F 84 91 00 00 00 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 8B 45 F0 59 74 4B 8B 88 AC 00 00 00 83 F9 01 7E 2F 39 4D 0C 7C 2A 53 53 51 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 74 17 8B 45 F0 8B 80 AC 00 00 00 38 5D FC 74 41 8B 4D F8 83 61 70 FD EB 38 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB 27 53 53 6A 01 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 74 DB 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 40 EB 02 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "_mblen"
		size = 39
		refs = "0007 ___locale_changed 000f ___initiallocalestructinfo 001e __mblen_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 07 68 ?? ?? ?? ?? EB 02 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z"
		size = 66
		refs = "0038 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 75 2A 83 78 10 03 75 24 8B 40 14 3D 20 05 93 19 74 15 3D 21 05 93 19 74 0E 3D 22 05 93 19 74 07 3D 00 40 99 01 75 05 E8 ?? ?? ?? ?? 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "__mbsnextc_l"
		size = 120
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 0031 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 0C 8D 4D F0 33 DB 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 3B CB 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 2C 0F B6 01 8B 55 F4 F6 44 10 1D 04 74 0E 8D 51 01 38 1A 74 07 C1 E0 08 8B F0 8B CA 0F B6 01 03 C6 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_29_4_0 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000b __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_685_12_0 {
	meta:
		name = "__cropzeros"
		size = 19
		refs = "000b __cropzeros_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_685_11_0 {
	meta:
		name = "__forcdecpt"
		size = 19
		refs = "000b __forcdecpt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_769_25_0 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000b __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000b __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_278_4_0 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000b __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_174_4_0 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000b __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_199_4_0 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000b __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_233_4_0 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000b __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_233_6_0 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000b __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_117_4_0 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000b __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_117_6_0 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000b __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_117_8_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000b __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_230_4_0 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000b __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000b __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_718_4_0 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000b __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_569_4_0 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000b __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_308_4_0 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000b __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_233_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000b __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_876_4_0 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000b __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_361_4_0 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000b __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_592_4_0 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000b __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_592_6_0 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000b __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_822_1_0 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000b __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_475_1_0 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000b __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_787_4_0 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000b __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_361_6_0 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000b __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_207_4_0 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000b __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_930_4_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000b __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_899_4_0 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000b __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_300_4_0 {
	meta:
		name = "__wtof"
		size = 19
		refs = "000b __wtof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "_atof"
		size = 19
		refs = "000b __atof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_4_0 {
	meta:
		name = "_isleadbyte"
		size = 19
		refs = "000b __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_101_4_0 {
	meta:
		name = "_towlower"
		size = 19
		refs = "000b __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_500_4_0 {
	meta:
		name = "_towupper"
		size = 19
		refs = "000b __towupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_labs"
		size = 16
		altNames = "_abs"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 7D 02 F7 D8 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_bsearch"
		size = 194
		refs = "0024 __errno 0034 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 8B 4D 0C 56 8D 70 FF 0F AF 75 14 57 33 FF 03 F1 89 4D 0C 3B CF 75 20 3B C7 74 1C E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 12 39 7D 14 76 DF 39 7D 18 74 DA 53 3B CE 76 09 33 C0 5B 5F 5E 5D C3 33 FF 8B D8 D1 EB 74 4B 89 45 10 83 65 10 01 8B C3 75 03 8D 43 FF 0F AF 45 14 03 45 0C 8B F8 57 FF 75 08 FF 55 18 59 59 85 C0 74 23 7D 10 2B 7D 14 83 7D 10 00 8B F7 75 0D 8D 43 FF EB 0A 8B 45 14 03 F8 89 7D 0C 8B C3 39 75 0C 76 B3 EB AA 8B C7 EB A8 3B C7 74 A2 FF 75 0C FF 75 08 FF 55 18 F7 D8 1B C0 59 F7 D0 23 45 0C 59 EB 8E }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 559
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 __errno 0038 __invalid_parameter 0084 __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 57 FF 75 08 8D 4D EC E8 ?? ?? ?? ?? 8B 45 10 8B 75 0C 33 FF 3B C7 74 02 89 30 3B F7 75 2C E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 E9 D8 01 00 00 39 7D 14 74 0C 83 7D 14 02 7C C9 83 7D 14 24 7F C3 8B 4D EC 53 8A 1E 89 7D FC 8D 7E 01 83 B9 AC 00 00 00 01 7E 17 8D 45 EC 50 0F B6 C3 6A 08 50 E8 ?? ?? ?? ?? 8B 4D EC 83 C4 0C EB 10 8B 91 C8 00 00 00 0F B6 C3 0F B7 04 42 83 E0 08 85 C0 74 05 8A 1F 47 EB C7 80 FB 2D 75 06 83 4D 18 02 EB 05 80 FB 2B 75 03 8A 1F 47 8B 45 14 85 C0 0F 8C 4B 01 00 00 83 F8 01 0F 84 42 01 00 00 83 F8 24 0F 8F 39 01 00 00 85 C0 75 2A 80 FB 30 74 09 C7 45 14 0A 00 00 00 EB 34 8A 07 3C 78 74 0D 3C 58 74 09 C7 45 14 08 00 00 00 EB 21 C7 45 14 10 00 00 00 EB 0A 83 F8 10 75 13 80 FB 30 75 0E 8A 07 3C 78 74 04 3C 58 75 04 47 8A 1F 47 8B B1 C8 00 00 00 B8 FF FF FF FF 33 D2 F7 75 14 0F B6 CB 0F B7 0C 4E F6 C1 04 74 08 0F BE CB 83 E9 30 EB 1B F7 C1 03 01 00 00 74 31 8A CB 80 E9 61 80 F9 19 0F BE CB 77 03 83 E9 20 83 C1 C9 3B 4D 14 73 19 83 4D 18 08 39 45 FC 72 27 75 04 3B CA 76 21 83 4D 18 04 83 7D 10 00 75 23 8B 45 18 4F A8 08 75 20 83 7D 10 00 74 03 8B 7D 0C 83 65 FC 00 EB 5B 8B 5D FC 0F AF 5D 14 03 D9 89 5D FC 8A 1F 47 EB 8B BE FF FF FF 7F A8 04 75 1B A8 01 75 3D 83 E0 02 74 09 81 7D FC 00 00 00 80 77 09 85 C0 75 2B 39 75 FC 76 26 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 06 83 4D FC FF EB 0F F6 45 18 02 6A 00 58 0F 95 C0 03 C6 89 45 FC 8B 45 10 85 C0 74 02 89 38 F6 45 18 02 74 03 F7 5D FC 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 8B 45 FC EB 18 8B 45 10 85 C0 74 02 89 30 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "_strtol"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_535_4_0 {
	meta:
		name = "__strtoi64"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "__wcstoi64"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_835_4_0 {
	meta:
		name = "_wcstol"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_5_0 {
	meta:
		name = "__strtol_l"
		size = 29
		refs = "0014 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_535_5_0 {
	meta:
		name = "__strtoi64_l"
		size = 29
		refs = "0014 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "__wcstoi64_l"
		size = 29
		refs = "0014 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_835_5_0 {
	meta:
		name = "__wcstol_l"
		size = 29
		refs = "0014 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "_strtoul"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_535_6_0 {
	meta:
		name = "__strtoui64"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "__wcstoui64"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_835_6_0 {
	meta:
		name = "_wcstoul"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_7_0 {
	meta:
		name = "__strtoul_l"
		size = 29
		refs = "0014 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_535_7_0 {
	meta:
		name = "__strtoui64_l"
		size = 29
		refs = "0014 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_7_0 {
	meta:
		name = "__wcstoui64_l"
		size = 29
		refs = "0014 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_835_7_0 {
	meta:
		name = "__wcstoul_l"
		size = 29
		refs = "0014 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 27
		refs = "0006 __bad_alloc_Message 000d ??0exception@std@@QAE@ABQBDH@Z 0013 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 56 6A 01 68 ?? ?? ?? ?? 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_alloc@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_191_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@D$00@std@@6B@ 000f ??1?$_Mpunct@D@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_188_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@D$0A@@std@@6B@ 000f ??1?$_Mpunct@D@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_476_1 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@G$00@std@@6B@ 000f ??1?$_Mpunct@G@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_473_1 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@G$0A@@std@@6B@ 000f ??1?$_Mpunct@G@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_470_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@_W$00@std@@6B@ 000f ??1?$_Mpunct@_W@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_467_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 39
		refs = "000a ??_7?$moneypunct@_W$0A@@std@@6B@ 000f ??1?$_Mpunct@_W@std@@MAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_19_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_typeid@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_17_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_cast@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_924_2_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_exception@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_18_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_typeid@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_75_206_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7failure@ios_base@std@@6B@ 000f ??1runtime_error@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_48_1 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7invalid_argument@std@@6B@ 000f ??1logic_error@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_45_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7length_error@std@@6B@ 000f ??1logic_error@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_48_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7out_of_range@std@@6B@ 000f ??1logic_error@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_14_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0bad_typeid@std@@QAE@ABV01@@Z 0012 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_13_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 29
		refs = "000c ??0bad_typeid@std@@QAE@PBD@Z 0012 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_8_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_924_31_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_4_1 {
	meta:
		name = "??0bad_function_call@tr1@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_11_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_89_4_1 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_75_229_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0runtime_error@std@@QAE@ABV01@@Z 0012 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_204_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 29
		refs = "000c ??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0012 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_69_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV01@@Z 0012 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_40_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0012 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_68_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV01@@Z 0012 ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_43_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0012 ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_28_56_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV01@@Z 0012 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_28_46_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 29
		refs = "000c ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0012 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "?_Nomemory@std@@YAXXZ"
		size = 72
		refs = "000a ?$S1@?1??_Nomemory@std@@YAXXZ@4IA 0011 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0021 ??0bad_alloc@std@@QAE@XZ 0026 ??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ 002b _atexit 0035 ??0bad_alloc@std@@QAE@ABV01@@Z 003a __TI2?AVbad_alloc@std@@ 0043 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C F6 05 ?? ?? ?? ?? 01 56 BE ?? ?? ?? ?? 75 19 83 0D ?? ?? ?? ?? 01 8B CE E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 56 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_469_5_0 {
	meta:
		name = "??__Fnomem@?5???2@YAPAXI@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_333_1 {
	meta:
		name = "??__Fnomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV234@PAVfacet@34@I@Z@4Vbad_alloc@4@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_332_1 {
	meta:
		name = "??__Fnomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV234@ABV234@@Z@4Vbad_alloc@4@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__wutime32"
		size = 129
		refs = "000e __errno 001e __invalid_parameter 003a __wsopen_s 004d __futime32 006a __close"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "__utime32"
		size = 129
		refs = "000e __errno 001e __invalid_parameter 003a __sopen_s 004d __futime32 006a __close"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_917_1_0 {
	meta:
		name = "__utime64"
		size = 129
		refs = "000e __errno 001e __invalid_parameter 003a __sopen_s 004d __futime64 006a __close"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__wutime64"
		size = 129
		refs = "000e __errno 001e __invalid_parameter 003a __wsopen_s 004d __futime64 006a __close"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_42_2_0 {
	meta:
		name = "__CItan_default"
		size = 178
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003e ___fastflag 0045 __fast_exit 0050 _NAME_ 0055 __math_exit 005b __pi_by_2_to_61 0072 __convertTOStoQNaN 008a __indefinite 00ac __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 54 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 F2 9B DF E0 9E 7A 1F DD D8 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 F2 DD D8 EB CB E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 51
		refs = "0027 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 74 21 3B 75 0C 74 05 3B 75 10 75 17 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "__wsetlocale"
		size = 508
		refs = "0003 __sehtable$__wsetlocale 0008 __SEH_prolog4 002b _wcstombs_s 0046 __invoke_watson 0058 __calloc_crt 0099 _free 00ab _setlocale 00c1 __getptd 00e6 __mbstowcs_s_l 011e __malloc_crt 0179 __lock 0190 __imp__InterlockedDecrement@4 01ac ___globallocalestatus 01ee __SEH_epilog4 01f6 __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 DB 39 7D 0C 0F 84 89 00 00 00 68 FF FF FF 7F FF 75 0C 57 57 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 14 3B C7 74 17 83 F8 16 74 05 83 F8 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 39 7D E4 74 4C 6A 01 FF 75 E4 E8 ?? ?? ?? ?? 59 59 8B D8 3B DF 74 3A 6A FF FF 75 0C FF 75 E4 53 57 E8 ?? ?? ?? ?? 83 C4 14 8B F0 3B F7 74 29 83 FE 16 74 05 83 FE 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 3B F7 74 0E 53 E8 ?? ?? ?? ?? 59 33 C0 E9 48 01 00 00 53 8B 75 08 56 E8 ?? ?? ?? ?? 89 45 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 39 7D 0C 74 DE E8 ?? ?? ?? ?? 89 45 DC 8B 48 6C 89 4D D0 8B 40 68 89 45 D4 89 7D E4 8D 45 D0 50 57 FF 75 0C 57 57 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 18 8B D8 3B DF 74 1B 83 FB 16 74 05 83 FB 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 3B DF 75 90 8B 45 E4 3D EE FF FF 7F 77 86 8D 44 00 04 50 E8 ?? ?? ?? ?? 59 8B D8 89 5D D8 3B DF 0F 84 6E FF FF FF 8D 43 04 89 45 E0 8D 4D D0 51 6A FF FF 75 0C FF 75 E4 50 57 E8 ?? ?? ?? ?? 83 C4 18 89 45 0C 3B C7 74 17 83 F8 16 74 05 83 F8 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 39 7D 0C 0F 85 24 FF FF FF 8B 5D D0 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC C1 E6 04 03 F3 8B 46 54 3B C7 74 14 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 45 DC F6 40 70 02 75 24 F6 05 ?? ?? ?? ?? 01 75 1B 8B 46 54 3B C7 74 14 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 0B 8B 45 D8 89 08 89 46 54 8B 45 E0 89 46 4C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_fastzero_I"
		size = 87
	strings:
		$1 = { 55 8B EC 83 EC 04 89 7D FC 8B 7D 08 8B 4D 0C C1 E9 07 66 0F EF C0 EB 08 8D A4 24 00 00 00 00 90 66 0F 7F 07 66 0F 7F 47 10 66 0F 7F 47 20 66 0F 7F 47 30 66 0F 7F 47 40 66 0F 7F 47 50 66 0F 7F 47 60 66 0F 7F 47 70 8D BF 80 00 00 00 49 75 D0 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "__VEC_memzero"
		size = 143
		refs = "0032 _fastzero_I 007e __VEC_memzero"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 7D FC 8B 45 08 99 8B F8 33 FA 2B FA 83 E7 0F 33 FA 2B FA 85 FF 75 3C 8B 4D 10 8B D1 83 E2 7F 89 55 F4 3B CA 74 12 2B CA 51 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B 55 F4 85 D2 74 45 03 45 10 2B C2 89 45 F8 33 C0 8B 7D F8 8B 4D F4 F3 AA 8B 45 08 EB 2E F7 DF 83 C7 10 89 7D F0 33 C0 8B 7D 08 8B 4D F0 F3 AA 8B 45 F0 8B 4D 08 8B 55 10 03 C8 2B D0 52 6A 00 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_vfwprintf_helper"
		size = 147
		refs = "0003 __sehtable$_vfwprintf_helper 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 004a __lock_file 0054 __stbuf 006d __ftbuf 0084 __SEH_epilog4 008d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 0C 33 F6 3B FE 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4A 33 C0 39 75 10 0F 95 C0 3B C6 74 D7 89 7D 0C 57 E8 ?? ?? ?? ?? 59 89 75 FC 57 E8 ?? ?? ?? ?? 8B F0 FF 75 18 FF 75 14 FF 75 10 57 FF 55 08 89 45 E4 57 56 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__vfwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_1_0 {
	meta:
		name = "__vfprintf_l"
		size = 32
		refs = "0012 __output_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_3_0 {
	meta:
		name = "__vfprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_2_0 {
	meta:
		name = "__vfprintf_s_l"
		size = 32
		refs = "0012 __output_s_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "__vfwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "__vfwprintf_s_l"
		size = 32
		refs = "0012 __woutput_s_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "_vfwprintf"
		size = 31
		refs = "0011 __woutput_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_6_0 {
	meta:
		name = "__vfprintf_p"
		size = 31
		refs = "0011 __output_p_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "__vfwprintf_p"
		size = 31
		refs = "0011 __woutput_p_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_4_0 {
	meta:
		name = "_vfprintf"
		size = 31
		refs = "0011 __output_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_513_5_0 {
	meta:
		name = "_vfprintf_s"
		size = 31
		refs = "0011 __output_s_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "_vfwprintf_s"
		size = 31
		refs = "0011 __woutput_s_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 692
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 __errno 0038 __invalid_parameter 0082 __iswctype_l 00ca __wchartodigit 012e __aulldvrm 01de __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 56 FF 75 08 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 10 8B 5D 0C 33 F6 3B C6 74 02 89 18 3B DE 75 2E E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 33 C0 33 D2 E9 5B 02 00 00 39 75 14 74 0C 83 7D 14 02 7C C7 83 7D 14 24 7F C1 57 89 75 F8 89 75 FC 0F B7 33 8D 7B 02 EB 05 0F B7 37 47 47 8D 45 D0 50 6A 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E8 66 83 FE 2D 75 06 83 4D 18 02 EB 06 66 83 FE 2B 75 05 0F B7 37 47 47 8B 45 14 85 C0 0F 8C E6 01 00 00 83 F8 01 0F 84 DD 01 00 00 83 F8 24 0F 8F D4 01 00 00 6A 10 5B 85 C0 75 2F 56 E8 ?? ?? ?? ?? 59 85 C0 74 09 C7 45 14 0A 00 00 00 EB 41 0F B7 07 66 83 F8 78 74 0F 66 83 F8 58 74 09 C7 45 14 08 00 00 00 EB 29 89 5D 14 39 5D 14 75 21 56 E8 ?? ?? ?? ?? 59 85 C0 75 16 0F B7 07 66 83 F8 78 74 06 66 83 F8 58 75 07 47 47 0F B7 37 47 47 8B 45 14 99 52 50 6A FF 6A FF 89 45 E0 89 55 E4 E8 ?? ?? ?? ?? 89 4D E8 89 5D EC 89 45 F0 89 55 F4 56 E8 ?? ?? ?? ?? 8B D8 59 83 FB FF 75 29 6A 41 58 66 3B C6 77 06 66 83 FE 5A 76 09 8D 46 9F 66 83 F8 19 77 52 8D 46 9F 66 83 F8 19 0F B7 C6 77 03 83 E8 20 8D 58 C9 3B 5D 14 73 3B 8B 4D FC 83 4D 18 08 3B 4D F4 72 4D 77 08 8B 45 F8 3B 45 F0 72 43 8B 45 F0 39 45 F8 75 13 3B 4D F4 75 0E 33 C0 3B 45 EC 72 2F 77 05 3B 5D E8 76 28 83 4D 18 04 83 7D 10 00 75 39 8B 45 18 4F 4F A8 08 75 3A 33 C0 39 45 10 74 03 8B 7D 0C 89 45 F8 89 45 FC E9 8B 00 00 00 51 FF 75 F8 FF 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 33 C9 03 C3 13 D1 89 45 F8 89 55 FC 0F B7 37 47 47 E9 46 FF FF FF BE FF FF FF 7F BB 00 00 00 80 A8 04 75 27 A8 01 75 54 83 E0 02 74 0D 39 5D FC 77 19 72 06 83 7D F8 00 77 11 85 C0 75 3E 39 75 FC 72 39 77 06 83 7D F8 FF 76 31 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 0A 83 4D F8 FF 83 4D FC FF EB 16 F6 45 18 02 74 09 83 65 F8 00 89 5D FC EB 07 83 4D F8 FF 89 75 FC 8B 45 10 85 C0 74 02 89 38 F6 45 18 02 74 13 8B 45 F8 8B 4D FC F7 D8 83 D1 00 F7 D9 89 45 F8 89 4D FC 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 8B 45 F8 8B 55 FC EB 1A 8B 45 10 85 C0 74 02 89 18 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 33 C0 33 D2 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__MarkAllocaS"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 08 8B 4D 0C 89 08 83 C0 08 5D C3 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "__freea"
		size = 32
		refs = "0019 _free"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_49_5_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
		size = 400
		refs = "0009 ___security_cookie 001b __errno 002a __invalid_parameter 003d _wcsnlen 0096 ___crtLCMapStringW 00ef __alloca_probe_16 0103 _malloc 015d _wcscpy_s 0178 __freea 018a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 F6 57 3B DE 75 1E E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 47 01 00 00 FF 75 08 53 E8 ?? ?? ?? ?? 59 59 3B 45 08 72 07 33 C0 66 89 03 EB CB 8B 55 0C 8B 02 8B 48 14 3B CE 75 2A 8B C3 66 39 33 74 1C 0F B7 08 66 83 F9 41 72 0C 66 83 F9 5A 77 06 83 C1 20 66 89 08 40 40 66 39 30 75 E4 33 C0 E9 FA 00 00 00 FF 70 04 BF 00 01 00 00 56 56 6A FF 53 57 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 20 89 4D F4 3B CE 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 C2 00 00 00 39 4D 08 73 11 33 C0 66 89 03 E8 ?? ?? ?? ?? 6A 22 E9 4E FF FF FF 3B CE 7E 46 6A E0 33 D2 58 F7 F1 83 F8 02 72 3A 8D 44 09 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C6 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C6 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F4 89 45 F8 EB 03 89 75 F8 39 75 F8 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 7C FF FF FF 8B 55 0C 8B 02 FF 70 04 51 FF 75 F8 6A FF 53 57 FF 70 14 52 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 13 FF 75 F8 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 FF 75 F8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 EC 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_49_6_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 53
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f ?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 5B 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_912_6_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 53
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f ?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 5B 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_49_8_0 {
	meta:
		name = "__wcslwr_l"
		size = 26
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_441_8_0 {
	meta:
		name = "__strlwr_l"
		size = 26
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_506_8_0 {
	meta:
		name = "__strupr_l"
		size = 26
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_912_8_0 {
	meta:
		name = "__wcsupr_l"
		size = 26
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_49_9_0 {
	meta:
		name = "__wcslwr"
		size = 112
		refs = "000a ___locale_changed 0018 __errno 0028 __invalid_parameter 0063 __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 4C 8B 45 08 3B C6 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3A 8B C8 66 39 30 74 33 57 0F B7 11 6A 41 5F 66 3B FA 77 0C 66 83 FA 5A 77 06 83 C2 20 66 89 11 41 41 66 39 31 75 E2 5F EB 11 56 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__rmdir"
		size = 48
		refs = "000a __imp__RemoveDirectoryA@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_817_0_0 {
	meta:
		name = "__wremove"
		size = 48
		refs = "000a __imp__DeleteFileW@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "__wrmdir"
		size = 48
		refs = "000a __imp__RemoveDirectoryW@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "_remove"
		size = 48
		refs = "000a __imp__DeleteFileA@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__execv"
		size = 79
		refs = "0010 __errno 0020 __invalid_parameter 0045 __execve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 33 DB 3B D3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 20 38 1A 74 DF 8B 4D 0C 3B CB 74 D8 8B 01 3B C3 74 D2 38 18 74 CE 53 51 52 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__seterrormode"
		size = 16
		refs = "000a __imp__SetErrorMode@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_2_1 {
	meta:
		name = "__Mtxdst"
		size = 16
		refs = "000a __imp__DeleteCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_1_1 {
	meta:
		name = "__Mtxinit"
		size = 16
		refs = "000a __imp__InitializeCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_3_1 {
	meta:
		name = "__Mtxlock"
		size = 16
		refs = "000a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_4_1 {
	meta:
		name = "__Mtxunlock"
		size = 16
		refs = "000a __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "__loaddll"
		size = 16
		refs = "000a __imp__LoadLibraryA@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_localeconv"
		size = 38
		refs = "0001 __getptd 000a ___ptlocinfo 0012 ___globallocalestatus 001c ___updatetlocinfo 0021 ___lconv"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 6C 3B 0D ?? ?? ?? ?? 74 10 8B 0D ?? ?? ?? ?? 85 48 70 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "___libm_sse2_atan"
		size = 530
		refs = "0007 _BMASK1 0013 _BMASK2 001b _SGNMASK 0059 _ONEMASK 00a2 _a2 00aa _b2 00bf _atan_tbl 01ca _pi_table"
	strings:
		$1 = { 83 EC 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 D2 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F C5 D0 03 8B C2 81 E2 FF 7F 00 00 66 0F 13 44 24 04 B9 40 40 00 00 66 0F C4 D1 03 66 0F 54 C7 66 0F 57 FF F2 0F 10 C8 66 0F 54 D8 66 0F C4 F9 03 66 0F 56 DE 66 0F 12 2D ?? ?? ?? ?? 81 EA A0 3F 00 00 81 FA 5F 04 00 00 0F 87 BD 00 00 00 83 C4 0C F2 0F C2 D0 06 F2 0F 5D DF 66 0F 54 EA 66 0F 54 C2 F2 0F 59 CB F2 0F 5C C3 F2 0F 58 CD F2 0F 5E C1 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 F8 03 03 D2 66 0F 12 34 D5 ?? ?? ?? ?? 83 C2 01 66 0F 12 2C D5 ?? ?? ?? ?? 66 0F 57 EF 66 0F 57 F7 F2 0F 10 C8 66 0F 57 CF F2 0F 10 D9 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 E0 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F3 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 D8 F2 0F 58 F5 F2 0F 59 D3 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 81 C2 B0 03 00 00 81 FA 0F 08 00 00 77 56 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 44 24 04 83 C4 0C F2 0F 59 C9 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F9 F2 0F 10 F1 F2 0F 59 C8 F2 0F 58 D4 F2 0F 59 FE F2 0F 59 D1 F2 0F 58 FD F2 0F 59 D7 F2 0F 58 C2 C3 81 C2 F0 3B 00 00 81 FA F0 43 00 00 73 17 66 0F 12 44 24 04 83 C4 0C 83 FA 10 66 0F 28 C8 73 04 F2 0F 59 C9 C3 66 0F 12 64 24 04 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 66 0F 73 D1 20 66 0F 7E CA 81 FA 00 00 F0 7F 73 11 66 0F 55 C4 66 0F 56 D0 66 0F 56 C3 F2 0F 58 C2 C3 81 EA 00 00 F0 7F 0B C2 83 F8 00 74 E2 F2 0F 10 C4 F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "_atol"
		size = 22
		refs = "000d _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_56_4_0 {
	meta:
		name = "__atoi64"
		size = 22
		refs = "000d __strtoi64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_433_4_0 {
	meta:
		name = "__wtoi64"
		size = 22
		refs = "000d __wcstoi64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "__wtol"
		size = 22
		refs = "000d _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "__atol_l"
		size = 25
		refs = "0010 __strtol_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_56_5_0 {
	meta:
		name = "__atoi64_l"
		size = 25
		refs = "0010 __strtoi64_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_433_5_0 {
	meta:
		name = "__wtoi64_l"
		size = 25
		refs = "0010 __wcstoi64_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_433_1_0 {
	meta:
		name = "__wtol_l"
		size = 25
		refs = "0010 __wcstol_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__filelengthi64"
		size = 278
		refs = "0003 __sehtable$__filelengthi64 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0039 __nhandle 0057 __invalid_parameter 0068 ___pioinfo 0082 ___lock_fhandle 009b __lseeki64_nolock 0107 __SEH_epilog4 0110 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF 0B D0 E9 D5 00 00 00 33 F6 3B C6 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB C7 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F8 83 E7 1F C1 E7 06 8B 0B 0F BE 4C 39 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 75 FC 8B 03 F6 44 38 04 01 74 47 6A 01 56 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F8 8B DA 23 C3 83 F8 FF 74 3F 6A 02 56 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 89 55 E0 3B F8 75 04 3B DA 74 2A 56 53 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 1A E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 83 4D DC FF 83 4D E0 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 DC 8B 55 E0 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "___report_gsfailure"
		size = 262
		refs = "000c _GS_ContextRecord 008d _GS_ExceptionRecord 00a6 ___security_cookie 00b1 ___security_cookie_complement 00bd __imp__IsDebuggerPresent@0 00c2 _DebuggerWasPresent 00c9 __crt_debugger_hook 00d2 __imp__SetUnhandledExceptionFilter@4 00d7 _GS_ExceptionPointers 00dd __imp__UnhandledExceptionFilter@4 00f9 __imp__GetCurrentProcess@0 0100 __imp__TerminateProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 28 03 00 00 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E0 FC FF FF C7 05 ?? ?? ?? ?? 01 00 01 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 A1 ?? ?? ?? ?? 89 85 D8 FC FF FF A1 ?? ?? ?? ?? 89 85 DC FC FF FF FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 6A 01 E8 ?? ?? ?? ?? 59 68 09 04 00 C0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 20
		refs = "000a ?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 20
		refs = "000a ?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_59_1_0 {
	meta:
		name = "??1type_info@@UAE@XZ"
		size = 16
		refs = "0005 ??_7type_info@@6B@ 000a ?_Type_info_dtor@type_info@@CAXPAV1@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_88_38_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_61_40_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_38_1 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_36_33_1 {
	meta:
		name = "??1ios_base@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_59_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1type_info@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_138_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Mpunct@D@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_324_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Mpunct@G@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_323_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Mpunct@_W@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_88_235_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_35_252_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_252_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_100_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_27_110_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_110_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_74_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ctype@D@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_61_81_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ctype@G@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_126_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ctype@_W@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_12_140_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$numpunct@D@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_417_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$numpunct@G@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_410_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$numpunct@_W@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_351_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_1022_1 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_945_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_137_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_322_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_7_157_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_2227_3_3 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Fac_node@std@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_40_79_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Locimp@locale@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_5_1 {
	meta:
		name = "??_Gbad_function_call@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_89_5_1 {
	meta:
		name = "??_Gbad_weak_ptr@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_602_16_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_40_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1locale@std@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_38_1 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1logic_error@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_46_53_1 {
	meta:
		name = "??_Gregex_error@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1runtime_error@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_36_181_1 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1runtime_error@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_59_5_0 {
	meta:
		name = "??8type_info@@QBE_NABV0@@Z"
		size = 32
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 5D C2 04 00 }
	condition:
		$1
}

rule file_59_6_0 {
	meta:
		name = "??9type_info@@QBE_NABV0@@Z"
		size = 33
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_59_7_0 {
	meta:
		name = "?before@type_info@@QBEHABV1@@Z"
		size = 36
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? 59 59 33 C9 85 C0 0F 9F C1 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "__mbsnlen_l"
		size = 121
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D F4 33 D2 39 53 08 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 3C 56 8B 75 0C 57 33 FF 85 F6 76 29 8B 45 08 8A 08 84 C9 74 1C 0F B6 C9 F6 44 19 1D 04 74 0B 42 3B D6 73 11 40 80 38 00 74 07 47 40 42 3B D6 72 DE 3B D6 72 04 8B C6 EB 02 8B C7 5F 5E 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_fast_error_exit"
		size = 41
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0017 __NMSG_WRITE 0021 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "_check_managed_app"
		size = 71
		refs = "0008 ___ImageBase"
	strings:
		$1 = { B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 75 36 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 25 B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 17 83 B8 ?? ?? ?? ?? 0E 76 0E 33 C9 39 88 ?? ?? ?? ?? 0F 95 C1 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 337
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0014 ___ImageBase 0059 __heap_init 0065 _fast_error_exit 006b __mtinit 007c __RTC_Initialize 0085 __ioinit 0090 __amsg_exit 0096 ___crtGetCommandLineW 009b __wcmdln 00a0 ___crtGetEnvironmentStringsW 00a5 __wenvptr 00aa __wsetargv 00bb __wsetenvp 00ce __cinit 00df __wenviron 00e4 ___winitenv 00eb ___wargv 00f1 ___argc 00f6 _wmain 0108 _exit 010d __cexit 0120 __XcptFilter 0138 __exit 013d __c_exit 014c __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 75 38 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 27 B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 19 83 B8 ?? ?? ?? ?? 0E 76 10 33 C9 39 88 ?? ?? ?? ?? 0F 95 C1 89 4D E4 EB 04 83 65 E4 00 6A 01 E8 ?? ?? ?? ?? 59 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 94
		refs = "0010 __errno 0020 __invalid_parameter 0054 __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 66 39 31 74 DE 8B 45 10 3B C6 74 D7 66 39 30 74 D2 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "__wspawnle"
		size = 94
		refs = "0010 __errno 0020 __invalid_parameter 0054 __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 66 39 31 74 DE 8B 45 10 3B C6 74 D7 66 39 30 74 D2 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__chdir"
		size = 312
		refs = "000c ___security_cookie 0034 ___doserrno 003b __errno 004b __invalid_parameter 005e __imp__SetCurrentDirectoryA@4 0078 __imp__GetCurrentDirectoryA@8 008d __calloc_crt 00d2 __mbctoupper 00f5 __imp__SetEnvironmentVariableA@8 0109 __imp__GetLastError@0 010f __dosmaperr 011f _free 0132 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 18 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 8D EC FE FF FF FF 53 33 DB 56 8D B5 F4 FE FF FF 89 9D E8 FE FF FF 3B C3 75 27 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D0 00 00 00 57 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9D 00 00 00 8D 85 F4 FE FF FF 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F8 81 FF 04 01 00 00 7E 2D 8D 5F 01 6A 01 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 6C C7 85 E8 FE FF FF 01 00 00 00 85 FF 74 5E 56 53 FF 15 ?? ?? ?? ?? 8B F8 33 DB 3B FB 74 50 8A 06 3C 5C 74 04 3C 2F 75 05 3A 46 01 74 37 C6 85 F0 FE FF FF 3D 0F B6 06 50 E8 ?? ?? ?? ?? 59 88 85 F1 FE FF FF 56 8D 85 F0 FE FF FF 50 C6 85 F2 FE FF FF 3A C6 85 F3 FE FF FF 00 FF 15 ?? ?? ?? ?? 85 C0 74 0A 89 9D EC FE FF FF EB 0F 33 DB FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 5F 39 9D E8 FE FF FF 74 07 56 E8 ?? ?? ?? ?? 59 8B 85 EC FE FF FF 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "___addl"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 8B 75 0C 8D 0C 32 33 C0 3B CA 72 04 3B CE 73 03 33 C0 40 8B 55 10 89 0A 5E 5D C3 }
	condition:
		$1
}

rule file_68_1_0 {
	meta:
		name = "___add_12"
		size = 113
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 53 56 57 8B 7D 0C 8B 17 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 89 30 85 DB 74 1E 8B 48 04 8D 51 01 33 F6 3B D1 72 05 83 FA 01 73 03 33 F6 46 89 50 04 85 F6 74 03 FF 40 08 8B 48 04 8B 57 04 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 89 70 04 85 DB 74 03 FF 40 08 8B 4F 08 01 48 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_68_2_0 {
	meta:
		name = "___shl_12"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B 30 8B CE 03 F6 57 8B 78 04 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F 03 C9 0B CA 5F 89 70 04 89 48 08 5E 5D C3 }
	condition:
		$1
}

rule file_68_3_0 {
	meta:
		name = "___mtold12"
		size = 462
		refs = "0009 ___security_cookie 01c8 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 56 33 F6 57 C7 45 E8 4E 40 00 00 89 30 89 70 04 89 70 08 39 75 0C 0F 86 46 01 00 00 8B 10 8B 58 04 8B F0 8D 7D F0 A5 A5 A5 8B CA C1 E9 1F 8D 3C 12 8D 14 1B 0B D1 8B 48 08 8B F3 C1 EE 1F 03 C9 0B CE 89 7D EC 8B F7 83 65 EC 00 8B DA C1 EB 1F 03 C9 C1 EF 1F 0B CB 8B 5D F0 03 F6 03 D2 0B D7 8D 3C 1E 89 30 89 50 04 89 48 08 3B FE 72 04 3B FB 73 07 C7 45 EC 01 00 00 00 33 DB 89 38 39 5D EC 74 1A 8D 72 01 3B F2 72 05 83 FE 01 73 03 33 DB 43 89 70 04 85 DB 74 04 41 89 48 08 8B 48 04 8B 55 F4 8D 1C 11 33 F6 3B D9 72 04 3B DA 73 03 33 F6 46 89 58 04 85 F6 74 03 FF 40 08 8B 4D F8 01 48 08 83 65 EC 00 8D 0C 3F 8B D7 C1 EA 1F 8D 3C 1B 0B FA 8B 50 08 8B F3 C1 EE 1F 8D 1C 12 8B 55 08 0B DE 89 08 89 78 04 89 58 08 0F BE 12 8D 34 11 89 55 F0 3B F1 72 04 3B F2 73 07 C7 45 EC 01 00 00 00 83 7D EC 00 89 30 74 1C 8D 4F 01 33 D2 3B CF 72 05 83 F9 01 73 03 33 D2 42 89 48 04 85 D2 74 04 43 89 58 08 FF 4D 0C FF 45 08 83 7D 0C 00 0F 87 E4 FE FF FF 33 F6 EB 26 8B 48 04 8B D1 C1 EA 10 89 50 08 8B 10 8B FA C1 E1 10 C1 EF 10 0B CF C1 E2 10 81 45 E8 F0 FF 00 00 89 48 04 89 10 39 70 08 74 D5 BB 00 80 00 00 85 58 08 75 30 8B 30 8B 78 04 81 45 E8 FF FF 00 00 8B CE 03 F6 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F 03 C9 0B CA 89 70 04 89 48 08 85 CB 74 D0 66 8B 4D E8 66 89 48 0A 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_xtow@16"
		size = 84
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 74 0B 6A 2D 5A 66 89 11 83 C1 02 F7 D8 56 8B F1 33 D2 F7 75 08 83 FA 09 76 05 83 C2 57 EB 03 83 C2 30 66 89 11 41 41 85 C0 77 E5 33 C0 66 89 01 49 49 66 8B 16 0F B7 01 66 89 11 49 66 89 06 49 46 46 3B F1 72 EC 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "__itow"
		size = 42
		refs = "0021 _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_445_1_0 {
	meta:
		name = "__itoa"
		size = 42
		refs = "0021 _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_70_2_0 {
	meta:
		name = "__ltow"
		size = 39
		refs = "001e _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_445_2_0 {
	meta:
		name = "__ltoa"
		size = 39
		refs = "001e _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_70_3_0 {
	meta:
		name = "__ultow"
		size = 26
		refs = "0011 _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 6A 00 FF 75 10 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_445_3_0 {
	meta:
		name = "__ultoa"
		size = 26
		refs = "0011 _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 6A 00 FF 75 10 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_70_4_0 {
	meta:
		name = "@x64tow@20"
		size = 127
		refs = "0036 __aulldvrm"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 53 8B 5D 08 56 57 8B F0 74 15 6A 2D 58 66 89 06 8B 45 0C 83 C6 02 F7 DB 83 D0 00 F7 D8 EB 03 8B 45 0C 8B FE 33 C9 51 FF 75 10 50 53 E8 ?? ?? ?? ?? 89 5D 0C 8B D8 8B C2 83 F9 09 76 05 83 C1 57 EB 03 83 C1 30 66 89 0E 46 46 85 C0 77 D6 72 04 85 DB 77 D0 33 C0 66 89 06 4E 4E 66 8B 0F 0F B7 06 66 89 0E 4E 66 89 07 4E 47 47 3B FE 72 EC 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "__i64tow"
		size = 51
		refs = "002a @x64tow@20"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_445_5_0 {
	meta:
		name = "__i64toa"
		size = 51
		refs = "002a @x64toa@20"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_70_6_0 {
	meta:
		name = "__ui64tow"
		size = 29
		refs = "0014 @x64tow@20"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_445_6_0 {
	meta:
		name = "__ui64toa"
		size = 29
		refs = "0014 @x64toa@20"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_IsRootUNCName"
		size = 161
		refs = "0004 _wcslen"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 59 83 F8 05 0F 82 8C 00 00 00 0F B7 06 66 83 F8 5C 74 06 66 83 F8 2F 75 7D 0F B7 46 02 66 83 F8 5C 74 06 66 83 F8 2F 75 6D 0F B7 46 04 66 83 F8 5C 74 63 66 83 F8 2F 74 5D 8D 46 06 0F B7 08 33 D2 66 3B CA 74 50 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 0F B7 08 66 3B CA 75 EA 66 39 10 74 35 83 C0 02 66 39 10 74 2D 0F B7 08 66 3B CA 74 21 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 0F B7 08 66 3B CA 75 EA 66 39 10 74 06 66 39 50 02 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "__wfullpath_helper"
		size = 96
		refs = "0008 __errno 0020 __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? FF 75 10 83 20 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E8 ?? ?? ?? ?? 85 FF 74 06 89 30 8B C7 EB 24 83 38 22 74 04 33 C0 EB 1B E8 ?? ?? ?? ?? 6A 00 FF 75 0C 89 30 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5F 5E 5D C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "__fullpath_helper"
		size = 96
		refs = "0008 __errno 0020 __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? FF 75 10 83 20 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E8 ?? ?? ?? ?? 85 FF 74 06 89 30 8B C7 EB 24 83 38 22 74 04 33 C0 EB 1B E8 ?? ?? ?? ?? 6A 00 FF 75 0C 89 30 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5F 5E 5D C3 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "__wstat64i32"
		size = 987
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0059 _wcspbrk 0090 _towlower 009e __getdrive 00b2 __imp__FindFirstFileW@8 00c6 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00f1 __wfullpath_helper 0104 _wcslen 010f _IsRootUNCName 011a __imp__GetDriveTypeW@4 0132 _free 0165 ___loctotime64_t 01d0 __imp__FileTimeToLocalFileTime@8 01ec __imp__FileTimeToSystemTime@8 036c __imp__FindClose@4 0378 ___wdtoxmode 03b2 __imp__GetLastError@0 03b8 __dosmaperr 03d5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 7B 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 50 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 84 FB FF FF 8D 85 A4 FB FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 A0 FB FF FF 83 F8 FF 0F 85 E3 00 00 00 68 ?? ?? ?? ?? 56 89 9D A0 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 87 8D 85 A0 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 89 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 74 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 68 39 9D A0 FB FF FF 74 0C FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 A4 FB FF FF 10 00 00 00 89 9D C0 FB FF FF 89 9D C4 FB FF FF 66 89 85 D0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 8B CA 83 C4 1C 89 47 20 89 57 24 89 47 18 89 4F 1C 89 47 28 89 4F 2C E9 E5 01 00 00 39 9D A0 FB FF FF 0F 84 CC FE FF FF FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 E9 BB FE FF FF 39 9D B8 FB FF FF 75 10 39 9D BC FB FF FF 75 08 89 5F 20 89 5F 24 EB 78 8D 85 88 FB FF FF 50 8D 85 B8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D4 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B8 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D B0 FB FF FF 75 16 39 9D B4 FB FF FF 75 0E 8B 47 20 89 47 18 8B 47 24 89 47 1C EB 78 8D 85 88 FB FF FF 50 8D 85 B0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3E 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 22 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 18 89 57 1C 39 9D A8 FB FF FF 75 16 39 9D AC FB FF FF 75 0E 8B 47 20 89 47 28 8B 47 24 89 47 2C EB 78 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A8 00 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8C 00 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C FF B5 A0 FB FF FF FF 15 ?? ?? ?? ?? 56 FF B5 A4 FB FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 8B 85 C4 FB FF FF 89 47 14 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 59 89 07 89 47 10 59 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 A0 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_wcsstr"
		size = 97
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 8B 5D 0C 66 83 3B 00 57 8B F8 74 44 0F B7 08 66 85 C9 74 3A 0F B7 D1 2B C3 8B 4D 0C 66 85 D2 74 1B 0F B7 11 66 85 D2 74 2B 0F B7 1C 08 0F B7 D2 2B DA 75 08 41 41 66 39 1C 08 75 E5 66 83 39 00 74 12 47 47 0F B7 17 40 40 66 85 D2 75 CB 33 C0 5F 5B 5D C3 8B C7 EB F8 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
		size = 54
		refs = "0009 __lock 000f ?_pnhHeap@@3P6AHI@ZA 0014 __decode_pointer 001e __encode_pointer 002a __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 04 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? 6A 04 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_77_4_0 {
	meta:
		name = "__callnewh"
		size = 40
		refs = "0007 ?_pnhHeap@@3P6AHI@ZA 000c __decode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 0F FF 75 08 FF D0 59 85 C0 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__execlpe"
		size = 89
		refs = "0010 __errno 0020 __invalid_parameter 004f __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 38 19 74 DF 8B 45 0C 3B C3 74 D8 38 18 74 D4 8D 45 0C 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__sleep"
		size = 29
		refs = "0017 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 07 C7 45 08 01 00 00 00 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_79_1_0 {
	meta:
		name = "__beep"
		size = 19
		refs = "000d __imp__Beep@8"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "_wparse_cmdline"
		size = 368
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 5D 0C 56 33 F6 89 37 C7 03 01 00 00 00 39 75 08 74 09 8B 4D 08 83 45 08 04 89 11 3B D6 74 08 66 8B 08 66 89 0A 42 42 FF 07 6A 22 59 66 39 08 75 10 33 DB 85 F6 0F 94 C3 40 40 8B F3 8B 5D 0C EB 18 FF 07 85 D2 74 08 66 8B 08 66 89 0A 42 42 0F B7 08 40 40 66 85 C9 74 39 85 F6 75 CC 66 83 F9 20 74 06 66 83 F9 09 75 C0 85 D2 74 06 33 C9 66 89 4A FE 33 F6 66 83 38 00 0F 84 D9 00 00 00 0F B7 08 66 83 F9 20 74 06 66 83 F9 09 75 08 40 40 EB ED 48 48 EB DD 66 83 38 00 0F 84 B8 00 00 00 83 7D 08 00 74 09 8B 4D 08 83 45 08 04 89 11 FF 03 85 D2 74 08 66 8B 08 66 89 0A 42 42 FF 07 C7 45 FC 01 00 00 00 33 DB EB 03 40 40 43 66 83 38 5C 74 F7 66 83 38 22 75 36 F6 C3 01 75 1E 85 F6 74 0D 8D 48 02 66 83 39 22 75 04 8B C1 EB 0D 83 65 FC 00 33 C9 85 F6 0F 94 C1 8B F1 D1 EB EB 0F 4B 85 D2 74 08 6A 5C 59 66 89 0A 42 42 FF 07 85 DB 75 ED 0F B7 08 66 85 C9 74 28 85 F6 75 0C 66 83 F9 20 74 1E 66 83 F9 09 74 18 83 7D FC 00 74 0B 85 D2 74 05 66 89 0A 42 42 FF 07 40 40 E9 7C FF FF FF 85 D2 74 07 33 C9 66 89 0A 42 42 FF 07 8B 5D 0C E9 1D FF FF FF 8B 45 08 85 C0 74 03 83 20 00 FF 03 5E 5B C9 C3 }
	condition:
		$1
}

rule file_80_2_0 {
	meta:
		name = "___wsetargv"
		size = 181
		refs = "0010 ?_pgmname@?1??__wsetargv@@9@9 0022 __imp__GetModuleFileNameW@12 0027 __wcmdln 002d __wpgmptr 004b _wparse_cmdline 0074 __malloc_crt 0098 ___argc 009e ___wargv 00a3 __wcwild"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 68 04 01 00 00 BE ?? ?? ?? ?? 56 33 C0 33 FF 57 66 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 3B C7 74 07 8B D8 66 39 38 75 02 8B DE 8D 45 FC 50 57 8D 7D F8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 7D FC 59 59 81 FF FF FF FF 3F 73 51 8B 4D F8 81 F9 FF FF FF 7F 73 46 8D 04 79 03 C0 03 C9 3B C1 72 3B 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 2E 8D 45 FC 50 8D 14 BE 56 8D 7D F8 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 59 48 59 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 1B C0 EB 03 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_82_3_0 {
	meta:
		name = "__stricoll_l"
		size = 166
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 005c __stricmp 007c ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D0 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 01 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_82_4_0 {
	meta:
		name = "__stricoll"
		size = 38
		refs = "0007 ___locale_changed 0010 __stricmp 001d __stricoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "___libm_sse2_atanf"
		size = 416
		refs = "000d _BMASK1 0019 _SGNMASK_S 0021 _BMASK2 0085 _ONEMASK 00b4 _cv 00c7 _atan_tbl 00fe _cvs 015c _pi_table"
	strings:
		$1 = { B9 C0 01 00 00 66 0F 6E D1 F3 0F 10 1D ?? ?? ?? ?? 66 0F 57 E4 F3 0F 10 3D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 73 F2 18 0F 54 D8 66 0F C5 D0 01 0F 54 F8 66 0F 57 C9 8B C2 81 E2 F8 7F 00 00 81 EA 00 3D 00 00 81 FA F8 22 00 00 0F 87 99 00 00 00 66 0F D4 DA B9 50 40 00 00 66 0F C4 E1 03 66 0F D4 FA 66 0F 73 F3 1D 66 0F C4 C9 03 66 0F 73 F7 1D F2 0F C2 E3 06 66 0F 56 DE F2 0F 10 C7 66 0F 12 2D ?? ?? ?? ?? F2 0F 5D D9 66 0F 54 C4 F2 0F 59 FB 66 0F 54 EC F2 0F 5C C3 F2 0F 58 FD F2 0F 5E C7 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 C8 03 66 0F 12 34 D5 ?? ?? ?? ?? 66 0F 57 F1 66 0F 57 C8 F2 0F 59 C0 F2 0F 59 E1 F2 0F 58 CE F2 0F 59 C4 F2 0F 58 C1 66 0F 5A C0 C3 81 C2 80 1D 00 00 81 FA 7F 40 00 00 77 35 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 FF F3 0F 59 E0 F3 0F 59 D0 F3 0F 10 EF F3 0F 59 FF F3 0F 59 E5 F3 0F 59 FA F3 0F 58 FC F3 0F 58 C7 C3 81 C2 80 1F 00 00 81 FA 80 5F 00 00 73 1B B8 01 00 80 3F 66 0F 7E C1 81 FA 80 00 00 00 0F 42 C1 66 0F 6E C8 F3 0F 59 C9 C3 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? 81 FA 7F 7F 00 00 77 19 25 00 80 00 00 66 0F 57 C0 66 0F C4 C0 01 0F 56 D0 0F 56 C3 F3 0F 58 C2 C3 66 0F 7E C2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 74 D5 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__CRT_INIT@12"
		size = 309
		refs = "0011 __heap_init 0022 __mtinit 002b __heap_term 0032 __RTC_Initialize 0038 __imp__GetCommandLineA@0 003d __acmdln 0042 ___crtGetEnvironmentStringsA 0047 __aenvptr 004c __ioinit 0055 __mtterm 005c __setargv 0065 __setenvp 0070 __cinit 007b ___proc_attached 0085 __ioterm 00a1 __C_Termination_Done 00a8 __cexit 00c8 ___set_flsgetvalue 00d4 __calloc_crt 00e7 ___flsindex 00ed _gpFlsSetValue 00f2 __decode_pointer 0100 __initptd 0108 __imp__GetCurrentThreadId@0 0116 _free 0127 __freeptd"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 56 57 83 F8 01 75 7C 50 E8 ?? ?? ?? ?? 59 85 C0 75 07 33 C0 E9 0E 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 E8 ?? ?? ?? ?? EB E9 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 07 E8 ?? ?? ?? ?? EB CF E8 ?? ?? ?? ?? 85 C0 7C 20 E8 ?? ?? ?? ?? 85 C0 7C 17 6A 00 E8 ?? ?? ?? ?? 59 85 C0 75 0B FF 05 ?? ?? ?? ?? E9 A8 00 00 00 E8 ?? ?? ?? ?? EB C9 33 FF 3B C7 75 31 39 3D ?? ?? ?? ?? 7E 81 FF 0D ?? ?? ?? ?? 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 39 7D 10 75 7B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 6A 83 F8 02 75 59 E8 ?? ?? ?? ?? 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 3B F7 0F 84 36 FF FF FF 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 17 57 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 EB 18 56 E8 ?? ?? ?? ?? 59 E9 FA FE FF FF 83 F8 03 75 07 57 E8 ?? ?? ?? ?? 59 33 C0 40 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "___DllMainCRTStartup"
		size = 246
		refs = "0003 __sehtable$___DllMainCRTStartup 0008 __SEH_prolog4 001f ___proc_attached 0037 __pRawDllMain 0055 __CRT_INIT@12 0068 _DllMain@12 00dd ___CppXcptFilter 00f1 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B F2 8B 5D 08 33 C0 40 89 45 E4 85 F6 75 0C 39 15 ?? ?? ?? ?? 0F 84 C5 00 00 00 83 65 FC 00 3B F0 74 05 83 FE 02 75 2E A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 E4 83 7D E4 00 0F 84 96 00 00 00 57 56 53 E8 ?? ?? ?? ?? 89 45 E4 85 C0 0F 84 83 00 00 00 57 56 53 E8 ?? ?? ?? ?? 89 45 E4 83 FE 01 75 24 85 C0 75 20 57 50 53 E8 ?? ?? ?? ?? 57 6A 00 53 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 06 57 6A 00 53 FF D0 85 F6 74 05 83 FE 03 75 26 57 56 53 E8 ?? ?? ?? ?? 85 C0 75 03 21 45 E4 83 7D E4 00 74 11 A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 E4 C7 45 FC FE FF FF FF 8B 45 E4 EB 1D 8B 45 EC 8B 08 8B 09 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 C7 45 FC FE FF FF FF 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_85_2_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 35
		refs = "000c ___security_init_cookie 001a ___DllMainCRTStartup"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? ?? FF 75 08 8B 4D 10 8B 55 0C E8 ?? ?? ?? ?? 59 5D C2 0C 00 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "__make__time32_t"
		size = 583
		refs = "0019 __errno 0029 __invalid_parameter 007c __days 01a6 ___tzset 01af __get_dstbias 01be __invoke_watson 01ca __get_timezone 01ef __localtime32_s 0229 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 33 DB 57 8B F8 89 5D F4 89 5D F8 3B FB 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8C 00 00 00 8B 4F 14 8D 41 BB 56 89 4D FC 83 F8 46 77 6E 8B 47 10 3B C3 7C 05 83 F8 0B 7E 23 6A 0C 99 5E F7 FE 03 C8 3B D3 89 4D FC 89 57 10 7D 09 03 D6 49 89 57 10 89 4D FC 8D 41 BB 83 F8 46 77 3F 8B 47 10 8B 14 85 ?? ?? ?? ?? F6 C1 03 75 06 83 F8 01 7E 01 42 8D 41 FF 69 C9 6D 01 00 00 C1 F8 02 03 C2 8D 84 01 21 9C FF FF 3B C3 8B 4F 0C 8D 34 08 89 75 FC 7C 1B 3B CB 7C 1F 3B F3 7D 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5F 5B C9 C3 3B CB 7D 04 3B F3 7D E5 8B CE 6B C9 18 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 18 0F 95 C2 8B C2 EB 02 33 C0 3B C3 75 C5 3B CB 8B 47 08 8D 34 08 89 75 FC 7C 0A 3B C3 7C 0E 3B F3 7C B0 EB 08 3B C3 7D 04 3B F3 7D A6 8B CE 6B C9 3C 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 3B C3 75 86 3B CB 8B 47 04 8D 34 08 89 75 FC 7C 0E 3B C3 7C 16 3B F3 0F 8C 6D FF FF FF EB 0C 3B C3 7D 08 3B F3 0F 8D 5F FF FF FF 8B CE 6B C9 3C 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 3B C3 0F 85 3B FF FF FF 3B CB 8B 07 8D 14 08 89 55 FC 7C 0E 3B C3 7C 16 3B D3 0F 8C 23 FF FF FF EB 0C 3B C3 7D 08 3B D3 0F 8D 15 FF FF FF 39 5D 08 74 7B E8 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 45 F8 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 01 45 FC 8D 45 FC 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 B8 FE FF FF 8B 47 20 3B C3 7F 07 7D 31 39 5D F0 7E 2C 8B 45 F4 01 45 FC 8D 45 FC 50 8D 45 D0 50 E8 ?? ?? ?? ?? EB 0D 8D 45 FC 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 7E FE FF FF 8B 45 FC 6A 09 59 8D 75 D0 F3 A5 E9 7C FE FF FF }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "__mktime32"
		size = 18
		refs = "000b __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 01 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_824_2_0 {
	meta:
		name = "__mktime64"
		size = 18
		refs = "000b __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 01 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "__mkgmtime32"
		size = 18
		refs = "000b __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 00 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_824_3_0 {
	meta:
		name = "__mkgmtime64"
		size = 18
		refs = "000b __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 00 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__wdospawn"
		size = 535
		refs = "0034 ___doserrno 003b __errno 004b __invalid_parameter 0081 _memset 008a __nhandle 00a2 ___pioinfo 00df __calloc_crt 0193 __imp__CreateProcessW@40 019b __imp__GetLastError@0 01a5 _free 01b0 __dosmaperr 01bf __exit 01c5 __imp__CloseHandle@4 01d5 __imp__WaitForSingleObject@8 01e2 __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 68 8B 45 08 53 33 DB 57 88 5D FF 3B C3 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 3E E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B9 01 00 00 40 40 66 39 18 75 F9 8D 48 02 66 39 19 74 08 6A 20 5A 66 89 10 8B C1 66 39 18 75 E4 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 2B 8D 46 FF 8B C8 8B D0 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E2 1F C1 E2 06 38 5C 11 04 75 06 4E 48 3B F3 75 E0 3B F3 0F 8C 44 01 00 00 81 FE 32 33 00 00 0F 83 38 01 00 00 8B C6 6B C0 05 83 C0 04 66 89 45 CA 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 CC 3B C3 0F 84 14 01 00 00 3B F3 89 30 8B 45 CC 8D 48 04 8D 7C 30 04 89 5D F8 7E 39 8B 45 F8 8B D0 83 E0 1F C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? 8A 50 04 F6 C2 10 75 08 88 11 8B 00 89 07 EB 05 88 19 83 0F FF FF 45 F8 41 83 C7 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2A 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 6A 08 5E EB 02 8B F3 E8 ?? ?? ?? ?? 89 18 8D 45 DC 50 8D 45 98 50 53 FF 75 14 81 CE 00 04 00 00 56 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 59 3B F3 75 09 57 E8 ?? ?? ?? ?? 59 EB 58 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 39 5D 08 75 1D 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC EB 06 83 7D 08 04 75 07 FF 75 DC FF D6 EB 03 8B 5D DC FF 75 E0 FF D6 8B C3 EB 0E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "_wadd"
		size = 65
		refs = "0008 __malloc_crt 001f _arghead 002a _argend"
		altNames = "_add"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 59 85 C0 75 05 83 C8 FF 5D C3 8B 4D 08 83 60 04 00 83 3D ?? ?? ?? ?? 00 89 08 74 0B 8B 0D ?? ?? ?? ?? 89 41 04 EB 05 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "_wsort"
		size = 55
		refs = "0011 __wcsicmp"
	strings:
		$1 = { 8B FF 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 59 59 85 C0 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_474_2_0 {
	meta:
		name = "_sort"
		size = 55
		refs = "0011 __mbsicmp"
	strings:
		$1 = { 8B FF 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 59 59 85 C0 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_89_3_0 {
	meta:
		name = "_wfind"
		size = 145
		refs = "000d ?findbuf@?1??wfind@@9@9 001a __malloc_crt 002d ?_WildFindHandle@?1??wfind@@9@9 0038 __imp__FindClose@4 004e __imp__FindFirstFileW@8 0074 __imp__FindNextFileW@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 5B 83 3D ?? ?? ?? ?? 00 75 18 68 54 03 00 00 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 75 04 33 C0 5D C3 A1 ?? ?? ?? ?? 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 FF 35 ?? ?? ?? ?? FF 75 08 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 74 CC A1 ?? ?? ?? ?? 83 C0 2C 5D C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 E0 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 EB 97 }
	condition:
		$1
}

rule file_89_4_0 {
	meta:
		name = "_wmatch"
		size = 487
		refs = "0071 _wfind 0083 _argend 008b ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0093 _wcscmp 00a2 ??_C@_15DDHGOCBH@?$AA?4?$AA?4?$AA?$AA@ 00d1 __wcsdup 00df _wadd 00f8 _wcslen 0115 __calloc_crt 0128 _wcsncpy_s 013b __invoke_watson 014d _wcscpy_s 01a2 _arghead 01b1 __wcsicmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 0C 33 DB 89 5D F8 3B F3 75 08 83 C8 FF E9 C5 01 00 00 57 8B 7D 08 EB 1A 0F B7 06 66 83 F8 5C 74 15 66 83 F8 2F 74 0F 66 83 F8 3A 74 0F 4E 4E 89 75 0C 3B F7 75 E2 66 83 3E 3A 75 0B 8D 47 02 3B F0 0F 85 88 01 00 00 0F B7 06 66 83 F8 5C 74 0C 66 83 F8 2F 74 06 66 83 F8 3A 75 07 8B DE 2B DF D1 FB 43 57 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 84 5A 01 00 00 8B 3D ?? ?? ?? ?? 89 7D F4 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 DE 00 00 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 C7 00 00 00 0F B7 06 66 83 F8 5C 74 33 66 83 F8 3A 74 2D 66 83 F8 2F 74 27 FF 75 FC E8 ?? ?? ?? ?? 59 89 45 08 85 C0 74 0F 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 90 00 00 00 83 C8 FF E9 EE 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 59 8D 74 18 01 85 DB 7C E7 81 FE FF FF FF 7F 73 DF 3B F3 72 DB 6A 02 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 CB 53 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC 2B F3 8D 04 5F 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 59 85 C0 0F 85 76 FF FF FF 8B 75 0C 8B 7D F4 FF 45 F8 6A 00 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 85 F8 FE FF FF 39 45 F8 74 41 85 FF 74 05 8B 77 04 EB 06 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 59 59 85 C0 7D 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 0A 8B 7D 08 57 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_89_5_0 {
	meta:
		name = "__wcwild"
		size = 189
		refs = "0005 ___wargv 000e _argend 0014 _arghead 0020 ??_C@_15EAECJAPL@?$AA?$CK?$AA?$DP?$AA?$AA@ 0026 _wcspbrk 0034 _wmatch 003e _wadd 006b __calloc_crt 0077 ___argc 00a7 _free"
	strings:
		$1 = { 8B FF 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 30 83 06 02 8B 06 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 3B C7 74 0B 50 FF 36 E8 ?? ?? ?? ?? 59 EB 07 FF 36 E8 ?? ?? ?? ?? 59 85 C0 75 10 83 C6 04 39 3E 75 CC A1 ?? ?? ?? ?? 33 F6 EB 09 83 C8 FF EB 5E 8B 40 04 46 3B C7 75 F8 8D 46 01 50 6A 04 E8 ?? ?? ?? ?? 59 59 3B C7 74 E2 89 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B CE 3B F7 74 0E 8B 11 89 10 8B 49 04 83 C0 04 3B CF 75 F2 89 38 8B C6 3B F7 74 16 8B 76 04 50 E8 ?? ?? ?? ?? 59 8B C6 3B F7 75 F0 89 35 ?? ?? ?? ?? 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "___check_float_string"
		size = 90
		refs = "0017 __calloc_crt 003b _memcpy 0046 __recalloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 8B 06 39 45 08 75 49 8B 0F 6A 04 50 3B 4D 0C 75 2E E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 5D C3 8B 45 10 C7 00 01 00 00 00 8B 06 03 C0 50 FF 75 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D2 89 07 D1 26 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_91_5_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8B 80 BC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_91_6_0 {
	meta:
		name = "__hextodec"
		size = 54
		refs = "001c _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 08 00 FF 00 00 56 75 1A 0F B7 75 08 8B C6 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 59 85 C0 74 04 8B C6 EB 0A 0F B7 45 08 83 E0 DF 83 E8 07 5E 5D C3 }
	condition:
		$1
}

rule file_91_8_0 {
	meta:
		name = "__un_inc"
		size = 24
		refs = "0012 __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_236_8_0 {
	meta:
		name = "__un_inc"
		size = 24
		refs = "0012 __ungetwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_91_9_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "0006 __getwche_nolock 001b _iswctype"
	strings:
		$1 = { 8B FF 57 FF 06 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 66 3B F8 74 0E 6A 08 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 DE 66 8B C7 5F C3 }
	condition:
		$1
}

rule file_91_10_0 {
	meta:
		name = "__cprinput_l"
		size = 4072
		refs = "000c ___security_cookie 0057 __errno 0067 __invalid_parameter 0080 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00aa _iswctype 00c1 __whiteout 00ca __un_inc 0166 _isdigit 0300 __getwche_nolock 047a ___check_float_string 04d5 __mbtowc_l 07b9 __malloc_crt 07d8 _wcstombs_s 07f3 __invoke_watson 0813 __cfltcvt_tab 0818 __decode_pointer 0821 _free 09d5 _memset 0bae _wctomb_s 0d31 __allmul 0d50 _isxdigit 0d7a __hextodec 0fe2 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 38 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 57 33 FF 8B F1 89 85 E8 FC FF FF 8D 85 40 FD FF FF 89 85 24 FD FF FF C7 85 04 FD FF FF 5E 01 00 00 89 BD 00 FD FF FF 89 BD FC FC FF FF 89 BD E0 FC FF FF 89 BD 34 FD FF FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 64 0F 00 00 FF 75 08 8D 8D C8 FC FF FF E8 ?? ?? ?? ?? 0F B7 06 C6 85 2B FD FF FF 00 89 BD 38 FD FF FF 89 BD F8 FC FF FF 66 3B C7 0F 84 1E 0F 00 00 8B FE 53 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 33 FF 8D 38 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 59 47 47 0F B7 07 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ED E9 95 0E 00 00 0F B7 07 6A 25 59 8B D1 66 3B D0 0F 85 55 0E 00 00 66 3B 57 02 0F 84 4B 0E 00 00 33 C0 89 85 F4 FC FF FF 89 85 D8 FC FF FF 89 85 1C FD FF FF 89 85 0C FD FF FF 89 85 30 FD FF FF 88 85 13 FD FF FF 88 85 2A FD FF FF 88 85 2E FD FF FF 88 85 3F FD FF FF 88 85 2C FD FF FF 88 85 2F FD FF FF C6 85 2D FD FF FF 01 89 85 F0 FC FF FF BE 00 FF 00 00 47 47 0F B7 1F 85 DE 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 30 FD FF FF FF 85 0C FD FF FF 6B C0 0A 8D 44 18 D0 89 85 30 FD FF FF E9 DA 00 00 00 83 FB 4E 0F 8F 97 00 00 00 0F 84 CB 00 00 00 83 FB 2A 0F 84 80 00 00 00 83 FB 46 0F 84 B9 00 00 00 83 FB 49 74 14 83 FB 4C 0F 85 80 00 00 00 FE 85 2D FD FF FF E9 A0 00 00 00 0F B7 4F 02 66 83 F9 36 75 21 8D 47 04 66 83 38 34 75 18 FF 85 F0 FC FF FF 83 A5 14 FD FF FF 00 83 A5 18 FD FF FF 00 8B F8 EB 75 66 83 F9 33 75 0D 8D 47 04 66 83 38 32 75 04 8B F8 EB 62 66 83 F9 64 74 5C 66 83 F9 69 74 56 66 83 F9 6F 74 50 66 83 F9 78 74 4A 66 83 F9 58 75 19 EB 42 FE 85 2E FD FF FF EB 3A 83 FB 68 74 29 83 FB 6C 74 0D 83 FB 77 74 17 FE 85 3F FD FF FF EB 23 8D 47 02 66 83 38 6C 74 8D FE 85 2D FD FF FF FE 85 2F FD FF FF EB 0C FE 8D 2D FD FF FF FE 8D 2F FD FF FF 80 BD 3F FD FF FF 00 0F 84 E4 FE FF FF 80 BD 2E FD FF FF 00 89 BD EC FC FF FF 75 19 8B 85 E8 FC FF FF 8B 18 89 85 DC FC FF FF 83 C0 04 89 85 E8 FC FF FF EB 02 33 DB 80 BD 2F FD FF FF 00 89 9D 08 FD FF FF C6 85 3F FD FF FF 00 75 1D 0F B7 07 66 83 F8 53 74 0D C6 85 2F FD FF FF 01 66 83 F8 43 75 07 C6 85 2F FD FF FF FF 0F B7 07 83 C8 20 89 85 20 FD FF FF 83 F8 6E 74 54 83 F8 63 74 12 83 F8 7B 74 0D 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 0B FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF B8 FF FF 00 00 66 3B 85 34 FD FF FF 0F 84 77 0C 00 00 8B 9D 08 FD FF FF 8B BD EC FC FF FF 8B 85 20 FD FF FF BE 00 FF 00 00 8B 8D 0C FD FF FF 85 C9 74 0D 83 BD 30 FD FF FF 00 0F 84 3D 0C 00 00 83 F8 6F 0F 8F C4 05 00 00 0F 84 F8 08 00 00 83 F8 63 0F 84 C8 04 00 00 6A 64 5A 3B C2 0F 84 E4 08 00 00 0F 8E CC 05 00 00 83 F8 67 7E 48 83 F8 69 74 21 83 F8 6E 0F 85 B9 05 00 00 80 BD 2E FD FF FF 00 8B BD 38 FD FF FF 0F 84 75 0B 00 00 E9 9C 0B 00 00 89 95 20 FD FF FF 6A 2D 58 66 3B 85 34 FD FF FF 0F 85 E8 06 00 00 C6 85 2A FD FF FF 01 E9 E8 06 00 00 6A 2D 58 33 DB 66 3B 85 34 FD FF FF 75 0C 8B 8D 24 FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 1A FF 8D 30 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 83 BD 0C FD FF FF 00 75 07 83 8D 30 FD FF FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 85 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 73 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 63 66 0F BE 85 34 FD FF FF 8B 8D 24 FD FF FF FF 85 1C FD FF FF 66 89 04 59 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 04 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 0D 0B 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 0F 84 7B FF FF FF 8D 85 C8 FC FF FF 50 8B 85 C8 FC FF FF C7 85 E4 FC FF FF 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 0F B7 85 E4 FC FF FF 0F BE 8D 34 FD FF FF 83 C4 10 3B C1 0F 85 F5 00 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 E1 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 8B 8D 24 FD FF FF 0F B7 C0 89 85 34 FD FF FF 66 8B 85 E4 FC FF FF 66 89 04 59 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 04 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 3F 0A 00 00 F7 85 34 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 24 FD FF FF 66 8B 8D 34 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 04 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 CA 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 74 80 83 BD 1C FD FF FF 00 0F 84 7B 01 00 00 6A 65 58 66 3B 85 34 FD FF FF 74 10 6A 45 58 66 3B 85 34 FD FF FF 0F 85 5F 01 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 4B 01 00 00 8B 8D 24 FD FF FF 6A 65 58 66 89 04 59 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 04 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 39 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 6A 2D 59 89 85 34 FD FF FF 66 3B C8 75 2E 51 8B 8D 24 FD FF FF 58 66 89 04 59 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 F1 08 00 00 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 2C 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 75 08 21 85 30 FD FF FF EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 24 FD FF FF 66 8B 8D 34 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 00 FD FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 04 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 42 08 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 74 80 FF B5 34 FD FF FF FF 8D 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 1C FD FF FF 00 59 0F 84 08 08 00 00 80 BD 2E FD FF FF 00 0F 85 A2 07 00 00 8B B5 04 FD FF FF 8B 8D 24 FD FF FF FF 85 F8 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 CE 07 00 00 8D 46 FF 50 FF B5 24 FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 85 C8 FC FF FF 50 0F BE 85 2D FD FF FF 57 FF B5 08 FD FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 10 07 00 00 85 C9 75 10 FF 85 30 FD FF FF C7 85 0C FD FF FF 01 00 00 00 80 BD 2F FD FF FF 00 7E 07 C6 85 2C FD FF FF 01 FF B5 34 FD FF FF FF 8D 38 FD FF FF 8B FB E8 ?? ?? ?? ?? 59 83 BD 0C FD FF FF 00 74 14 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 7C 03 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 20 FD FF FF 63 0F B7 D0 89 95 34 FD FF FF 74 57 83 BD 20 FD FF FF 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 39 03 00 00 66 83 FA 20 75 38 83 BD 20 FD FF FF 7B 0F 85 26 03 00 00 0F B7 C2 8B C8 33 F6 83 E1 07 46 D3 E6 8B 8D FC FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 13 FD FF FF 33 C1 85 F0 0F 84 FB 02 00 00 80 BD 2E FD FF FF 00 0F 85 E7 02 00 00 80 BD 2C FD FF FF 00 0F 84 8A 02 00 00 66 89 13 43 43 E9 C5 02 00 00 83 E8 70 0F 84 2A 03 00 00 83 E8 03 0F 84 15 FF FF FF 48 48 0F 84 20 03 00 00 83 E8 03 0F 84 6A FA FF FF 83 E8 03 74 34 66 8B 85 34 FD FF FF 66 39 07 0F 85 38 06 00 00 FE 8D 2B FD FF FF 80 BD 2E FD FF FF 00 0F 85 D8 05 00 00 8B 85 DC FC FF FF 89 85 E8 FC FF FF E9 C7 05 00 00 80 BD 2F FD FF FF 00 7E 07 C6 85 2C FD FF FF 01 47 6A 5E 47 58 66 3B 07 75 0A 83 C7 02 C6 85 13 FD FF FF FF 83 BD FC FC FF FF 00 75 23 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 FC FC FF FF 85 C0 0F 84 DA 05 00 00 C7 85 E0 FC FF FF 01 00 00 00 8B 9D FC FC FF FF 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 58 66 3B 07 75 0D 50 47 5E 47 C6 43 0B 20 E9 84 00 00 00 8B B5 D8 FC FF FF EB 7C 0F B7 C0 47 6A 2D 59 47 66 3B C8 75 59 66 85 F6 74 54 0F B7 0F 6A 5D 5A 66 3B D1 74 49 0F B7 C9 47 47 66 3B F1 73 05 0F B7 C1 EB 06 0F B7 C6 0F B7 F1 66 3B F0 77 25 2B C6 40 0F B7 D6 0F B7 F0 8B 8D FC FC FF FF 8B C2 C1 E8 03 03 C1 8B CA 83 E1 07 B3 01 D2 E3 08 18 42 4E 75 E4 8B 9D FC FC FF FF 33 F6 EB 16 0F B7 C8 0F B7 F0 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 0F B7 07 6A 5D 59 66 3B C8 0F 85 75 FF FF FF 66 83 3F 00 0F 84 08 05 00 00 8B 9D 08 FD FF FF 89 BD EC FC FF FF E9 B2 FD FF FF 6A 2B 58 66 3B 85 34 FD FF FF 75 29 FF 8D 30 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 6A 30 5B 8B C3 66 3B 85 34 FD FF FF 0F 85 B8 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 6A 78 0F B7 C0 5F 8B CF 89 85 34 FD FF FF 66 3B C8 74 58 6A 58 59 66 3B C8 74 50 C7 85 1C FD FF FF 01 00 00 00 39 BD 20 FD FF FF 74 26 83 BD 0C FD FF FF 00 74 0E FF 8D 30 FD FF FF 75 06 FE 85 3F FD FF FF C7 85 20 FD FF FF 6F 00 00 00 E9 5A 01 00 00 FF 8D 38 FD FF FF 50 E8 ?? ?? ?? ?? 59 89 9D 34 FD FF FF E9 42 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 0C FD FF FF 00 0F B7 C0 89 85 34 FD FF FF 74 16 83 AD 30 FD FF FF 02 83 BD 30 FD FF FF 01 7D 06 FE 85 3F FD FF FF 89 BD 20 FD FF FF E9 04 01 00 00 52 6A 05 8D 85 F4 FC FF FF 53 33 F6 50 89 B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 10 3B C6 74 20 83 F8 16 74 09 83 F8 22 0F 85 9E FC FF FF 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E9 8C FC FF FF 03 9D F4 FC FF FF 89 9D 08 FD FF FF E9 7B FC FF FF 47 47 E9 74 FC FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 3B FB 0F 84 90 03 00 00 80 BD 2E FD FF FF 00 0F 85 2A 03 00 00 FF 85 F8 FC FF FF 83 BD 20 FD FF FF 63 0F 84 17 03 00 00 80 BD 2C FD FF FF 00 74 10 8B 8D 08 FD FF FF 33 C0 66 89 01 E9 FE 02 00 00 8B 85 08 FD FF FF C6 00 00 E9 F0 02 00 00 C6 85 2D FD FF FF 01 6A 2D 58 66 3B 85 34 FD FF FF 75 09 C6 85 2A FD FF FF 01 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 29 FF 8D 30 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 83 BD F0 FC FF FF 00 0F 84 64 01 00 00 80 BD 3F FD FF FF 00 0F 85 20 01 00 00 8B 9D 34 FD FF FF 83 BD 20 FD FF FF 78 74 7C 83 BD 20 FD FF FF 70 74 73 85 DE 0F 85 F3 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E1 00 00 00 83 BD 20 FD FF FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 CC 00 00 00 8B 85 14 FD FF FF 8B 8D 18 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 14 FD FF FF 89 8D 18 FD FF FF EB 68 6A 00 6A 0A FF B5 18 FD FF FF FF B5 14 FD FF FF E8 ?? ?? ?? ?? 89 85 14 FD FF FF 89 95 18 FD FF FF EB 45 85 DE 0F 85 80 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 85 14 FD FF FF 8B 8D 18 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 14 FD FF FF 89 8D 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 1C FD FF FF 0F B7 C3 83 E8 30 99 01 85 14 FD FF FF 11 95 18 FD FF FF 83 BD 0C FD FF FF 00 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 34 FD FF FF E9 F3 FE FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 2A FD FF FF 00 8B BD F4 FC FF FF 0F 84 F4 00 00 00 8B 85 14 FD FF FF 8B 8D 18 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 14 FD FF FF 89 8D 18 FD FF FF E9 D0 00 00 00 80 BD 3F FD FF FF 00 8B BD F4 FC FF FF 0F 85 B2 00 00 00 8B 9D 34 FD FF FF 83 BD 20 FD FF FF 78 74 3A 83 BD 20 FD FF FF 70 74 31 85 DE 0F 85 85 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 77 83 BD 20 FD FF FF 6F 75 0D 6A 38 58 66 3B C3 76 66 C1 E7 03 EB 2A 6B FF 0A EB 25 85 DE 75 58 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 4A 53 C1 E7 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 1C FD FF FF 83 BD 0C FD FF FF 00 0F B7 C3 8D 7C 07 D0 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 34 FD FF FF E9 61 FF FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 2A FD FF FF 00 74 02 F7 DF 83 BD 20 FD FF FF 46 75 07 83 A5 1C FD FF FF 00 83 BD 1C FD FF FF 00 0F 84 9A 00 00 00 80 BD 2E FD FF FF 00 75 38 FF 85 F8 FC FF FF 8B 9D 08 FD FF FF 83 BD F0 FC FF FF 00 74 13 8B 85 14 FD FF FF 89 03 8B 85 18 FD FF FF 89 43 04 EB 10 80 BD 2D FD FF FF 00 74 04 89 3B EB 03 66 89 3B FE 85 2B FD FF FF 8B BD EC FC FF FF 47 47 EB 2F 8B D1 66 3B D0 75 0A 8D 47 02 66 3B 08 75 02 8B F8 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 66 8B 0F 0F B7 C0 47 47 89 85 34 FD FF FF 66 3B C8 75 0E 0F B7 07 66 85 C0 0F 85 1E F1 FF FF EB 0C FF B5 34 FD FF FF E8 ?? ?? ?? ?? 59 83 BD E0 FC FF FF 01 5B 75 0C FF B5 FC FC FF FF E8 ?? ?? ?? ?? 59 83 BD 00 FD FF FF 01 75 0C FF B5 24 FD FF FF E8 ?? ?? ?? ?? 59 80 BD D4 FC FF FF 00 74 0A 8B 85 D0 FC FF FF 83 60 70 FD 8B 85 F8 FC FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_91_11_0 {
	meta:
		name = "__cwscanf"
		size = 23
		refs = "000f __cprinput_l"
		altNames = "__cscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_781_10_0 {
	meta:
		name = "__cscanf_s"
		size = 23
		refs = "000f __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_270_11_0 {
	meta:
		name = "__cwscanf_s"
		size = 23
		refs = "000f __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_91_12_0 {
	meta:
		name = "__cwscanf_l"
		size = 24
		refs = "0010 __cprinput_l"
		altNames = "__cscanf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_781_11_0 {
	meta:
		name = "__cscanf_s_l"
		size = 24
		refs = "0010 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_270_12_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 24
		refs = "0010 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__dospawn"
		size = 527
		refs = "0037 ___doserrno 003e __errno 004e __invalid_parameter 007d _memset 0086 __nhandle 009e ___pioinfo 00db __calloc_crt 018b __imp__CreateProcessA@40 0193 __imp__GetLastError@0 019d _free 01a8 __dosmaperr 01b7 __exit 01bd __imp__CloseHandle@4 01cd __imp__WaitForSingleObject@8 01da __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 68 8B 45 08 53 33 DB 57 89 5D F4 88 5D FF 3B C3 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 38 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AE 01 00 00 40 38 18 75 FB 8D 48 01 38 19 74 05 C6 00 20 8B C1 38 18 75 EB 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 2B 8D 46 FF 8B C8 8B D0 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E2 1F C1 E2 06 38 5C 11 04 75 06 4E 48 3B F3 75 E0 3B F3 0F 8C 40 01 00 00 81 FE 32 33 00 00 0F 83 34 01 00 00 8B C6 6B C0 05 83 C0 04 66 89 45 CA 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 CC 3B C3 0F 84 10 01 00 00 3B F3 89 30 8B 45 CC 8D 48 04 8D 7C 30 04 89 5D F8 7E 39 8B 45 F8 8B D0 83 E0 1F C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? 8A 50 04 F6 C2 10 75 08 88 11 8B 00 89 07 EB 05 88 19 83 0F FF FF 45 F8 41 83 C7 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2C 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 C7 45 F4 08 00 00 00 E8 ?? ?? ?? ?? 89 18 8D 45 DC 50 8D 45 98 50 53 FF 75 14 FF 75 F4 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 59 3B F3 75 09 57 E8 ?? ?? ?? ?? 59 EB 58 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 39 5D 08 75 1D 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC EB 06 83 7D 08 04 75 07 FF 75 DC FF D6 EB 03 8B 5D DC FF 75 E0 FF D6 8B C3 EB 0E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__fseeki64_nolock"
		size = 156
		refs = "002f __ftelli64_nolock 003e __flush 0071 __fileno 0078 __lseeki64 008b __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8B 46 0C 57 A8 83 74 79 8B 7D 14 85 FF 74 0A 83 FF 01 74 05 83 FF 02 75 68 83 E0 EF 89 46 0C 83 FF 01 75 0F 56 E8 ?? ?? ?? ?? 01 45 0C 59 11 55 10 33 FF 56 E8 ?? ?? ?? ?? 8B 46 0C 59 84 C0 79 08 83 E0 FC 89 46 0C EB 16 A8 01 74 12 A8 08 74 0E A9 00 04 00 00 75 07 C7 46 18 00 02 00 00 57 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 0F 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5E 5D C3 }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "__fseeki64"
		size = 79
		refs = "0003 __sehtable$__fseeki64 0008 __SEH_prolog4 0010 __lock_file 0026 __fseeki64_nolock 0040 __SEH_epilog4 0049 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "__wfindfirst32i64"
		size = 324
		refs = "000c ___security_cookie 0024 __errno 0034 __invalid_parameter 0051 __imp__FindFirstFileW@8 0062 __imp__GetLastError@0 00bd ___timet_from_ft 00f0 __allmul 0117 _wcscpy_s 0129 __invoke_watson 013e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 58 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F3 00 00 00 3B C7 74 DC 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 89 85 A8 FD FF FF 83 F8 FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B2 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A5 E8 ?? ?? ?? ?? 89 30 EB 9C 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 53 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 C8 FD FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 89 46 10 13 D3 8D 85 D8 FD FF FF 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 5B 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 A8 FD FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_97_2_0 {
	meta:
		name = "__wfindnext32i64"
		size = 324
		refs = "000c ___security_cookie 0026 __errno 0038 __invalid_parameter 005d __imp__FindNextFileW@8 0067 __imp__GetLastError@0 00c1 ___timet_from_ft 00f4 __allmul 011b _wcscpy_s 012c __invoke_watson 013e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 83 CB FF 57 3B C3 75 21 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C3 E9 EF 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D9 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 C8 FD FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 89 46 10 13 D3 8D 85 D8 FD FF FF 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 122
		refs = "0010 __errno 0020 __invalid_parameter 0043 __wcenvarg 005c __wdospawn 0066 _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 39 75 10 74 DE FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_509_1_0 {
	meta:
		name = "_comexecmd"
		size = 122
		refs = "0010 __errno 0020 __invalid_parameter 0043 __cenvarg 005c __dospawn 0066 _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 39 75 10 74 DE FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "__wspawnve"
		size = 544
		refs = "0017 __errno 0027 __invalid_parameter 0052 _wcsrchr 0077 _wcschr 0085 _wcslen 0092 __calloc_crt 00a7 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 00ae _wcscpy_s 00bf __invoke_watson 00cc _wcscat_s 010d __waccess_s 0128 _wcomexecmd 01a2 _ext_strings 0202 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 8B 5D 0C 57 33 FF 89 5D FC 3B DF 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E6 01 00 00 66 39 3B 74 DB 8B 45 10 3B C7 74 D4 8B 00 3B C7 74 CE 66 39 38 74 C9 56 6A 5C 53 E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 3B C7 0F 85 81 00 00 00 3B F7 0F 85 83 00 00 00 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 59 59 3B F7 75 73 53 E8 ?? ?? ?? ?? 8B F0 83 C6 03 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 89 5D FC 3B DF 0F 84 AF 00 00 00 68 ?? ?? ?? ?? 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 0C 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 73 04 8B 5D 0C EB 0A 3B F7 74 04 3B C6 76 02 8B F0 83 4D F4 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 2F 57 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 EF 00 00 00 FF 75 14 FF 75 10 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 E9 D3 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C6 05 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 3B DF 75 08 83 C8 FF E9 BE 00 00 00 FF 75 FC 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC E8 ?? ?? ?? ?? 8D 04 43 59 89 45 F0 E8 ?? ?? ?? ?? 8B 00 89 45 EC 8B 45 F0 2B C3 89 75 F8 D1 F8 29 45 F8 BE ?? ?? ?? ?? FF 36 FF 75 F8 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 57 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 0D 83 EE 04 81 FE ?? ?? ?? ?? 7D C7 EB 1F E8 ?? ?? ?? ?? FF 75 14 8B 4D EC FF 75 10 89 08 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 53 E8 ?? ?? ?? ?? 8B 5D 0C 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "___libm_sse2_exp"
		size = 534
		refs = "000b _cv 0013 _Shifter 0096 _Tbl_addr 00ba _mmask 00c6 _bias 0124 _emask 0193 _XMAX 01a3 _XMIN 01d1 _INF 01dd _ZERO 0211 _ONE_val"
	strings:
		$1 = { 83 EC 0C 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 9F 01 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 0C 83 C4 0C F2 0F 59 C2 F2 0F 58 C2 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 1E C3 3D 00 00 F0 7F 73 2B 8B 44 24 08 3D 00 00 00 80 73 10 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 8B 54 24 04 3D 00 00 F0 7F 77 28 83 FA 00 75 23 8B 44 24 08 3D 00 00 F0 7F 75 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 0F 83 79 FF FF FF 66 0F 12 44 24 04 83 C4 0C F2 0F 58 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_101_3_0 {
	meta:
		name = "__towlower_l"
		size = 181
		refs = "0021 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005e __iswctype_l 0093 ___crtLCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 8B C8 83 EC 14 66 39 4D 08 0F 84 9A 00 00 00 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D EC 8B 51 14 33 DB 3B D3 75 14 8B 45 08 8D 48 BF 66 83 F9 19 77 03 83 C0 20 0F B7 C0 EB 61 56 B8 00 01 00 00 8B F0 66 39 75 08 5E 73 29 8D 45 EC 50 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F B7 45 08 74 39 8B 4D EC 8B 89 CC 00 00 00 66 0F B6 04 01 EB C3 FF 71 04 8D 4D FC 6A 01 51 6A 01 8D 4D 08 51 50 52 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F B7 45 08 74 04 0F B7 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_103_3_0 {
	meta:
		name = "__wcstod_l"
		size = 263
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0029 __errno 003b __invalid_parameter 0067 __iswctype_l 007c _wcslen 0088 __wfltin2 00bd __HUGE"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 8B 5D 08 56 57 FF 75 10 8D 4D E8 8B F3 E8 ?? ?? ?? ?? 8B 7D 0C 85 FF 74 02 89 1F 85 DB 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD D9 EE E9 AD 00 00 00 8D 45 E8 50 0F B7 03 EB 05 46 46 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 8D 45 E8 50 75 E8 6A 00 6A 00 56 E8 ?? ?? ?? ?? 59 50 8D 45 D0 56 50 E8 ?? ?? ?? ?? 83 C4 18 8B C8 85 FF 74 08 8B 41 04 8D 04 46 89 07 8B 01 A9 40 02 00 00 74 0D D9 EE DD 5D F8 85 FF 74 43 89 1F EB 3F A8 81 74 10 66 83 3E 2D DD 05 ?? ?? ?? ?? 75 17 D9 E0 EB 13 A9 00 01 00 00 74 1E D9 EE DC 51 10 DF E0 F6 C4 44 7A 10 DD 5D F8 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 08 DD D8 DD 41 10 DD 5D F8 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD DD 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__fputwchar"
		size = 26
		refs = "0006 ___iob_func 0012 _fputwc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__fputchar"
		size = 26
		refs = "0006 ___iob_func 0012 _putc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_wcsnlen"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 45 0C 76 11 8B 4D 08 66 83 39 00 74 08 40 41 41 3B 45 0C 72 F2 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_strncat_s"
		size = 196
		refs = "0030 __errno 003f __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 14 8B 55 08 53 33 DB 56 57 3B CB 75 10 3B D3 75 10 39 5D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B D3 74 07 8B 7D 0C 3B FB 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 8B 75 10 3B CB 74 08 3B F3 75 04 88 1A EB D6 8B C2 38 18 74 04 40 4F 75 F8 3B FB 74 EE 83 F9 FF 75 0F 8A 0E 88 08 40 46 3A CB 74 22 4F 75 F3 EB 1D 3B CB 76 12 8A 0E 88 08 40 46 3A CB 74 08 4F 74 05 FF 4D 14 75 EE 39 5D 14 75 02 88 18 3B FB 75 81 83 7D 14 FF 75 0F 8B 45 0C 6A 50 88 5C 02 FF 58 E9 6E FF FF FF 88 1A E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 75 FF FF FF }
	condition:
		$1
}

rule file_110_3_0 {
	meta:
		name = "__mbsnbcoll_l"
		size = 227
		refs = "0020 __errno 0030 __invalid_parameter 0071 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0088 __strncoll_l 00a9 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 10 33 DB 3B F3 75 07 33 C0 E9 C5 00 00 00 39 5D 08 75 22 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 9E 00 00 00 39 5D 0C 74 D9 57 BF FF FF FF 7F 3B F7 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 61 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 39 58 08 75 14 FF 75 14 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 41 FF 70 04 56 FF 75 0C 56 FF 75 08 68 00 10 00 00 FF 70 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_110_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 26
		refs = "0011 __mbsnbcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_57_1_1 {
	meta:
		name = "__Stoll"
		size = 26
		refs = "0011 __Stollx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1_1_1 {
	meta:
		name = "__Stoul"
		size = 26
		refs = "0011 __Stoulx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_1_1 {
	meta:
		name = "__Stoull"
		size = 26
		refs = "0011 __Stoullx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_462_6_0 {
	meta:
		name = "__aligned_realloc"
		size = 26
		refs = "0011 __aligned_offset_realloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_685_9_0 {
	meta:
		name = "__fassign"
		size = 26
		refs = "0011 __fassign_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "__mbscat_s"
		size = 26
		refs = "0011 __mbscat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 26
		refs = "0011 __mbscpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_471_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 26
		refs = "0011 __mbsnbcat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_765_4_0 {
	meta:
		name = "__mbsnbcmp"
		size = 26
		refs = "0011 __mbsnbcmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_468_4_0 {
	meta:
		name = "__mbsnbcpy"
		size = 26
		refs = "0011 __mbsnbcpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_945_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 26
		refs = "0011 __mbsnbicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_631_4_0 {
	meta:
		name = "__mbsnbicoll"
		size = 26
		refs = "0011 __mbsnbicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_309_4_0 {
	meta:
		name = "__mbsnbset"
		size = 26
		refs = "0011 __mbsnbset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_411_4_0 {
	meta:
		name = "__mbsncat"
		size = 26
		refs = "0011 __mbsncat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_431_4_0 {
	meta:
		name = "__mbsncmp"
		size = 26
		refs = "0011 __mbsncmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_340_4_0 {
	meta:
		name = "__mbsncoll"
		size = 26
		refs = "0011 __mbsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_908_4_0 {
	meta:
		name = "__mbsncpy"
		size = 26
		refs = "0011 __mbsncpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_486_4_0 {
	meta:
		name = "__mbsnicmp"
		size = 26
		refs = "0011 __mbsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_524_4_0 {
	meta:
		name = "__mbsnicoll"
		size = 26
		refs = "0011 __mbsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_274_4_0 {
	meta:
		name = "__mbsnset"
		size = 26
		refs = "0011 __mbsnset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_709_0_0 {
	meta:
		name = "__mbsset_s"
		size = 26
		refs = "0011 __mbsset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_406_4_0 {
	meta:
		name = "__mbstok_s"
		size = 26
		refs = "0011 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_699_0_0 {
	meta:
		name = "__spawnvp"
		size = 26
		refs = "0011 __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__wspawnvp"
		size = 26
		refs = "0011 __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_4_0 {
	meta:
		name = "_mbtowc"
		size = 26
		refs = "0011 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_853_4_0 {
	meta:
		name = "_strxfrm"
		size = 26
		refs = "0011 __strxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_6_0 {
	meta:
		name = "_wcstombs"
		size = 26
		refs = "0011 __wcstombs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_594_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 26
		refs = "0011 __wcsxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_112_6_0 {
	meta:
		name = "__Getdays_l"
		size = 256
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002f _strlen 0057 __malloc_crt 0083 _strcpy_s 0096 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 FF 75 08 8D 4D E8 33 DB E8 ?? ?? ?? ?? 8B 45 E8 8B B8 D4 00 00 00 89 5D FC 8B 75 FC C1 E6 02 FF 74 3E 1C E8 ?? ?? ?? ?? FF 34 3E 89 45 F8 E8 ?? ?? ?? ?? 03 C3 FF 45 FC 83 7D FC 07 59 59 8B 4D F8 8D 5C 08 02 72 D2 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 59 89 75 F8 85 F6 0F 84 82 00 00 00 83 65 FC 00 8B 45 FC C6 06 3A FF 34 87 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 8B 45 FC C6 06 3A FF 74 87 1C 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 FF 45 FC 83 7D FC 07 59 72 85 C6 06 00 80 7D F4 00 5F 5E 5B 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 C9 C3 }
	condition:
		$1
}

rule file_112_8_0 {
	meta:
		name = "__Getmonths_l"
		size = 256
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 _strlen 005e __malloc_crt 0089 _strcpy_s 009c __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 57 FF 75 08 8D 4D E4 33 DB E8 ?? ?? ?? ?? 8B 45 E4 8B B8 D4 00 00 00 8D 77 38 89 75 FC C7 45 F8 0C 00 00 00 FF 76 30 E8 ?? ?? ?? ?? FF 36 89 45 F4 E8 ?? ?? ?? ?? 8B 75 FC 59 59 8B 4D F4 03 C3 83 C6 04 FF 4D F8 8D 5C 08 02 89 75 FC 75 D5 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 59 89 75 FC 85 F6 74 7F 83 C7 68 C7 45 F8 0C 00 00 00 8B 45 FC C6 06 3A FF 77 D0 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 8B 45 FC C6 06 3A FF 37 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 83 C7 04 FF 4D F8 59 75 8E C6 06 00 80 7D F0 00 5F 5E 5B 74 07 8B 45 EC 83 60 70 FD 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_112_10_0 {
	meta:
		name = "__Gettnames_l"
		size = 855
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002f _strlen 00db __malloc_crt 00fa _memcpy 0127 _strcpy_s 013a __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 57 FF 75 08 8D 4D DC 33 FF E8 ?? ?? ?? ?? 8B 45 DC 8B B0 D4 00 00 00 89 7D FC 8B 5D FC C1 E3 02 FF 74 33 1C E8 ?? ?? ?? ?? FF 34 33 89 45 EC E8 ?? ?? ?? ?? 03 C7 FF 45 FC 83 7D FC 07 59 59 8B 4D EC 8D 7C 08 02 72 D2 8D 46 38 89 45 F0 C7 45 F4 0C 00 00 00 8B 5D F0 FF 73 30 E8 ?? ?? ?? ?? FF 33 89 45 EC E8 ?? ?? ?? ?? 83 45 F0 04 59 59 8B 4D EC 03 C7 FF 4D F4 8D 7C 08 02 75 D7 FF B6 9C 00 00 00 E8 ?? ?? ?? ?? FF B6 98 00 00 00 8B D8 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 03 C7 8D 7C 18 02 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? 8D 84 07 B9 00 00 00 50 89 45 F8 E8 ?? ?? ?? ?? 8B D8 83 C4 18 85 DB 0F 84 57 02 00 00 68 B8 00 00 00 56 53 8D BB B8 00 00 00 E8 ?? ?? ?? ?? 83 65 FC 00 8D 46 1C 89 5D F0 83 C4 0C 29 75 F0 89 45 F4 8B 45 FC 89 3C 83 8B 45 F4 FF 70 E4 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8B 4D F0 8D 7C 07 01 8B 45 F4 89 3C 01 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? FF 45 FC 83 45 F4 04 83 7D FC 07 59 8D 7C 07 01 0F 82 7B FF FF FF 8D 43 68 89 45 FC 8D 46 38 89 45 F4 C7 45 EC 0C 00 00 00 EB 03 8B 45 F4 8B 4D F0 89 3C 08 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B 45 FC 89 38 8B 45 F4 FF 70 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 83 45 F4 04 83 45 FC 04 FF 4D EC 59 8D 7C 07 01 75 80 8B C3 2B C7 03 45 F8 89 BB 98 00 00 00 FF B6 98 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB 9C 00 00 00 FF B6 9C 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A0 00 00 00 FF B6 A0 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A4 00 00 00 FF B6 A4 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 44 07 01 8B CB 2B C8 03 4D F8 89 83 A8 00 00 00 FF B6 A8 00 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D E8 00 74 07 8B 45 E4 83 60 70 FD 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_112_12_0 {
	meta:
		name = "?_store_str@@YAXPADPAPADPAI@Z"
		size = 32
	strings:
		$1 = { 83 38 00 56 8B F2 74 16 57 8A 16 84 D2 74 0E 8B 39 88 17 FF 01 46 FF 08 83 38 00 75 EC 5F 5E C3 }
	condition:
		$1
}

rule file_112_13_0 {
	meta:
		name = "?_store_number@@YAXHPAPADPAI@Z"
		size = 54
	strings:
		$1 = { 83 3E 01 8B 0F 53 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 11 41 FF 0E 8B 16 85 C0 7E 05 83 FA 01 77 E7 8B 07 89 0F 49 8A 18 8A 11 88 19 49 88 10 40 3B C1 72 F2 5B C3 }
	condition:
		$1
}

rule file_112_14_0 {
	meta:
		name = "?_store_num@@YAXHHPAPADPAII@Z"
		size = 123
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F2 33 D2 89 55 FC 39 55 08 74 35 83 39 01 8B 37 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 16 46 FF 09 8B 11 85 C0 7E 05 83 FA 01 77 E7 8B 07 89 37 4E 8A 10 8A 0E 88 16 4E 88 08 40 3B C6 72 F2 EB 2E 3B 31 73 28 4E 8D 56 01 85 D2 74 17 6A 0A 99 5B F7 FB 8B 1F 80 C2 30 FF 45 FC 88 14 1E 4E 83 FE FF 75 E9 8B 45 FC 01 07 29 01 EB 02 89 11 5E 5B C9 C3 }
	condition:
		$1
}

rule file_112_15_0 {
	meta:
		name = "?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
		size = 1000
		refs = "01b6 __errno 0253 ?_store_num@@YAXHHPAPADPAII@Z 0272 ?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z 02e9 __invalid_parameter 0330 ___tzset 0335 ___tzname 03dc ?_store_str@@YAXPADPAPADPAI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 0F BE C0 83 F8 59 56 57 8B D9 8B F2 0F 8F BD 01 00 00 0F 84 85 01 00 00 83 F8 49 0F 8F CB 00 00 00 0F 84 98 00 00 00 83 E8 04 0F 84 A9 03 00 00 83 E8 09 0F 84 A0 03 00 00 83 E8 18 74 70 83 E8 1C 74 49 48 74 24 83 E8 06 0F 85 9A 02 00 00 8B 46 08 33 FF 3B C7 0F 8C 75 02 00 00 83 F8 17 0F 8F 6C 02 00 00 E9 D6 01 00 00 8B 76 10 33 FF 3B F7 0F 8C 5A 02 00 00 83 FE 0B 0F 8F 51 02 00 00 8B 55 10 8B 54 B2 68 E9 45 03 00 00 8B 76 18 33 FF 3B F7 0F 8C 38 02 00 00 83 FE 06 0F 8F 2F 02 00 00 8B 55 10 8B 54 B2 1C E9 23 03 00 00 8B 03 C6 00 25 8B 45 0C FF 03 FF 08 E9 1A 03 00 00 8B 46 08 33 FF 3B C7 0F 8C 05 02 00 00 83 F8 17 0F 8F FC 01 00 00 99 6A 0C 59 F7 F9 8B C2 3B C7 0F 85 5B 01 00 00 51 58 E9 54 01 00 00 83 E8 4D 0F 84 A3 00 00 00 6A 06 59 2B C1 0F 84 84 00 00 00 48 48 74 34 48 48 74 12 48 0F 85 DA 01 00 00 FF 75 10 FF 75 0C E9 73 01 00 00 8B 46 18 33 FF 3B C7 0F 8C AA 01 00 00 3B C1 0F 8F A2 01 00 00 3B C7 74 1C 8D 48 FF EB 17 8B 46 18 33 FF 3B C7 0F 8C 8C 01 00 00 3B C1 0F 8F 84 01 00 00 8B C8 8B 46 1C 3B C7 0F 8C 77 01 00 00 3D 6D 01 00 00 0F 8F 6C 01 00 00 3B C1 7D 07 33 C0 E9 D0 00 00 00 6A 07 99 5E F7 FE 3B D1 0F 8C C2 00 00 00 40 E9 BC 00 00 00 8B 06 33 FF 3B C7 0F 8C 41 01 00 00 83 F8 3B E9 C7 FE FF FF 8B 46 04 EB E9 8B 46 14 3D 94 F8 FF FF 7C 07 3D A3 1F 00 00 7E 0C E8 ?? ?? ?? ?? 33 FF E9 1C 01 00 00 99 6A 64 59 F7 F9 FF 75 14 6A 04 83 C0 13 6B C0 64 03 C2 EB 76 83 F8 6D 0F 8F 39 01 00 00 0F 84 1D 01 00 00 83 E8 5A 0F 84 41 01 00 00 83 E8 07 0F 84 D3 00 00 00 48 0F 84 B2 00 00 00 48 74 5C 48 74 2C 83 E8 06 0F 85 E3 00 00 00 8B 76 1C 33 FF 3B F7 0F 8C BE 00 00 00 81 FE 6D 01 00 00 0F 8F B2 00 00 00 FF 75 14 8D 46 01 6A 03 EB 1C 8B 76 0C 83 FE 01 0F 8C 79 FF FF FF 83 FE 1F 0F 8F 70 FF FF FF 8B C6 FF 75 14 6A 02 5A 8B 4D 0C 8B FB E8 ?? ?? ?? ?? 59 E9 83 01 00 00 FF 75 10 33 FF FF 75 0C 53 56 39 7D 14 74 41 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 73 8B 45 0C 39 38 74 6C 8B 03 FF 75 10 C6 00 20 8B 45 0C FF 03 FF 08 50 53 56 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 85 35 01 00 00 EB 43 57 EB BE 8B 76 10 33 FF 3B F7 7C 1F 83 FE 0B 7F 1A 8B 55 10 8B 54 B2 38 E9 0E 01 00 00 8B 76 18 33 FF 3B F7 7C 05 83 FE 06 7E 1F E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 EC 00 00 00 8B 55 10 8B 14 B2 E9 D6 00 00 00 8B 76 10 33 FF 3B F7 7C CD 83 FE 0B 7F C8 8D 46 01 E9 2F FF FF FF 83 E8 70 0F 84 8B 00 00 00 83 E8 07 74 65 48 74 46 48 74 26 48 75 C1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 33 C0 39 46 20 8B CB 0F 95 C0 8B D8 8B 14 9A 89 45 FC E9 86 00 00 00 8B 46 14 33 FF 3B C7 0F 8C 79 FF FF FF FF 75 14 99 6A 64 59 F7 F9 8B C2 E9 DB FE FF FF FF 75 10 33 FF FF 75 0C 53 56 39 7D 14 74 07 6A 01 E9 13 FF FF FF 57 E9 0D FF FF FF 8B 46 18 33 FF 3B C7 0F 8C 40 FF FF FF 83 F8 06 0F 8F 37 FF FF FF FF 75 14 33 D2 42 E9 A1 FE FF FF 8B 76 08 33 FF 3B F7 0F 8C 1F FF FF FF 83 FE 17 0F 8F 16 FF FF FF 83 FE 0B 8B 55 10 7F 08 8B 92 98 00 00 00 EB 06 8B 92 9C 00 00 00 8B 45 0C E8 ?? ?? ?? ?? 33 C0 40 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_112_16_0 {
	meta:
		name = "?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z"
		size = 1121
		refs = "0009 ___security_cookie 0050 __imp__GetDateFormatA@24 0058 __imp__GetTimeFormatA@24 00c1 __alloca_probe_16 00d5 _malloc 012e __freea 0142 @__security_check_cookie@4 01a5 __isleadbyte_l 0229 ??_C@_05JAMEPDIN@am?1pm?$AA@ 022f ___ascii_stricmp 023f ??_C@_03EBAPMIKO@a?1p?$AA@ 0447 ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 56 8B 75 1C 33 DB 2B C3 57 74 13 48 74 08 8B BE A8 00 00 00 EB 0E 8B BE A4 00 00 00 EB 06 8B BE A0 00 00 00 83 BE B0 00 00 00 01 8B 45 10 0F 84 FE 00 00 00 83 7D 0C 02 8B 0D ?? ?? ?? ?? 75 06 8B 0D ?? ?? ?? ?? BA 6C 07 00 00 66 03 50 14 53 66 89 55 E0 66 8B 50 10 66 42 66 89 55 E2 66 8B 50 0C 66 89 55 E6 66 8B 50 08 66 89 55 E8 66 8B 50 04 66 8B 00 66 89 45 EC 53 33 C0 57 66 89 45 EE 8D 45 E0 50 53 FF B6 AC 00 00 00 89 4D F4 66 89 55 EA FF D1 89 45 F0 3B C3 0F 84 92 00 00 00 83 C0 08 3D 00 04 00 00 7F 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F8 3B C3 74 5A FF 75 F0 8B D8 53 57 8D 45 E0 50 6A 00 FF B6 AC 00 00 00 FF 55 F4 48 85 C0 7E 21 8B 75 18 8B 4D 14 83 3E 00 76 16 8B 11 89 45 F0 8A 03 88 02 FF 01 8B 45 F0 43 FF 0E 48 85 C0 7F E5 FF 75 F8 E8 ?? ?? ?? ?? 59 33 C0 40 8D 65 D4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 8A 07 84 C0 74 E5 8B 5D 18 8B 75 14 83 3B 00 74 DA 33 D2 89 55 F8 8B CF 41 42 38 01 74 FA 89 4D F4 0F BE C8 83 F9 64 0F 8F 82 01 00 00 0F 84 4E 01 00 00 83 F9 27 0F 84 D8 00 00 00 83 F9 41 0F 84 9B 00 00 00 83 F9 48 74 7E 83 F9 4D 74 4F 83 F9 61 0F 84 88 00 00 00 FF 75 08 51 E8 ?? ?? ?? ?? 59 59 85 C0 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 9A 02 00 00 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 0F 85 73 FF FF FF E9 4D FF FF FF 8B C2 48 74 17 48 74 1B 48 74 0A 48 75 AC B0 42 E9 3C 02 00 00 B0 62 E9 35 02 00 00 C7 45 F8 01 00 00 00 B0 6D E9 27 02 00 00 8B C2 48 74 05 48 74 09 EB 86 C7 45 F8 01 00 00 00 B0 48 E9 0F 02 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 C7 05 EB 14 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 83 C7 03 89 7D F4 B0 70 E9 DB 01 00 00 03 FA F6 C2 01 0F 84 70 FF FF FF 8A 07 84 C0 0F 84 C2 FE FF FF 83 3B 00 0F 84 5D FF FF FF 3C 27 74 45 FF 75 08 0F BE C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 B9 01 00 00 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8B 06 8A 0F 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 B3 E9 14 FF FF FF 47 E9 0E FF FF FF 8B C2 48 74 1B 48 74 1F 48 74 0E 48 0F 85 C5 FE FF FF B0 41 E9 55 01 00 00 B0 61 E9 4E 01 00 00 C7 45 F8 01 00 00 00 B0 64 E9 40 01 00 00 8B C1 83 E8 68 0F 84 1F 01 00 00 83 E8 05 0F 84 FE 00 00 00 83 E8 06 0F 84 DD 00 00 00 48 74 25 83 E8 05 0F 85 80 FE FF FF 8B C2 48 48 74 0F 48 48 0F 85 72 FE FF FF B0 59 E9 02 01 00 00 B0 79 E9 FB 00 00 00 8B 45 10 83 78 08 0B 8B 45 1C 7F 08 8B B8 98 00 00 00 EB 06 8B B8 9C 00 00 00 83 FA 01 0F 85 8A 00 00 00 83 3B 00 0F 86 81 00 00 00 0F BE 07 FF 75 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 CF 00 00 00 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8B 06 8A 0F 88 08 FF 06 FF 0B E9 AC 00 00 00 83 3B 00 0F 86 A3 00 00 00 FF 75 08 0F BE C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 88 00 00 00 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 B7 EB 61 8B C2 48 74 08 48 74 0C E9 A2 FD FF FF C7 45 F8 01 00 00 00 B0 53 EB 2E 8B C2 48 74 08 48 74 0C E9 8A FD FF FF C7 45 F8 01 00 00 00 B0 4D EB 16 8B C2 48 74 08 48 74 0C E9 72 FD FF FF C7 45 F8 01 00 00 00 B0 49 FF 75 F8 8B 55 10 FF 75 1C 8B CE 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 08 8B 7D F4 E9 7D FD FF FF 33 C0 E9 D5 FC FF FF }
	condition:
		$1
}

rule file_112_17_0 {
	meta:
		name = "__Strftime_l"
		size = 420
		refs = "001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0037 __invalid_parameter 00c3 __isleadbyte_l 011e ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 08 53 FF 75 1C 33 DB 8D 4D E0 89 5D F8 89 45 F0 E8 ?? ?? ?? ?? 8B 45 08 3B C3 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 50 01 00 00 57 8B 7D 0C 3B FB 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 1C 01 00 00 56 8B 75 10 88 18 3B F3 0F 84 E7 00 00 00 8B 45 18 3B C3 75 09 8B 45 E0 8B 80 D4 00 00 00 89 45 F4 89 7D FC 3B FB 0F 86 9F 00 00 00 8A 06 3A C3 74 79 3C 25 74 41 8D 4D E0 0F BE C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1E 33 C9 41 39 4D FC 76 16 8D 46 01 38 18 74 70 8A 0E 8B 55 08 88 0A FF 45 08 FF 4D FC 8B F0 8A 06 8B 4D 08 88 01 FF 45 08 46 FF 4D FC EB 2F 8B 55 14 3B D3 74 77 46 33 C0 80 3E 23 75 02 40 46 50 FF 75 F4 8D 45 FC 50 8D 45 E0 50 8A 06 8D 4D 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 42 46 39 5D FC 77 81 39 5D FC 76 1B 8B 45 08 88 18 2B 7D FC 8B C7 38 5D EC 74 5C 8B 4D E8 83 61 70 FD EB 53 89 4D F8 8B 45 F0 88 18 39 5D F8 75 20 39 5D FC 77 1B E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 26 39 5D FC 76 DF C7 45 F8 01 00 00 00 EB D6 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_112_18_0 {
	meta:
		name = "__strftime_l"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_501_6_0 {
	meta:
		name = "__vsnprintf_s"
		size = 32
		refs = "0017 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_626_6_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 32
		refs = "0017 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_112_19_0 {
	meta:
		name = "_strftime"
		size = 31
		refs = "0016 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_112_20_0 {
	meta:
		name = "__Strftime"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_685_17_0 {
	meta:
		name = "__cftoa"
		size = 32
		refs = "0017 __cftoa_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_685_15_0 {
	meta:
		name = "__cftoe"
		size = 32
		refs = "0017 __cftoe_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_685_22_0 {
	meta:
		name = "__cftog"
		size = 32
		refs = "0017 __cftog_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_698_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 32
		refs = "0017 __mbstowcs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_424_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 32
		refs = "0017 __wcstombs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__locking_nolock"
		size = 189
		refs = "0011 __lseek_nolock 0048 __get_osfhandle 0055 __imp__UnlockFile@20 005d __imp__LockFile@20 0067 __imp__GetLastError@0 007d __imp__Sleep@4 0098 __dosmaperr 00a0 __errno 00ab ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 6A 01 33 F6 56 FF 75 08 E8 ?? ?? ?? ?? 8B D8 83 C8 FF 83 C4 0C 3B D8 0F 84 94 00 00 00 83 7D 0C 01 74 09 83 7D 0C 03 89 75 FC 75 07 C7 45 FC 09 00 00 00 57 56 FF 75 10 33 FF 56 53 FF 75 08 E8 ?? ?? ?? ?? 59 50 39 75 0C 75 08 FF 15 ?? ?? ?? ?? EB 06 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? 8B F8 39 75 FC 7E 14 3B FE 74 40 68 E8 03 00 00 FF 15 ?? ?? ?? ?? FF 4D FC EB B6 3B FE 74 2C 83 7D 0C 01 74 0F 83 7D 0C 03 74 09 57 E8 ?? ?? ?? ?? 59 EB 12 E8 ?? ?? ?? ?? C7 00 24 00 00 00 E8 ?? ?? ?? ?? 89 38 83 C8 FF EB 02 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "__locking"
		size = 220
		refs = "0003 __sehtable$__locking 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __locking_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "__lseek"
		size = 220
		refs = "0003 __sehtable$__lseek 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __lseek_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_948_1_0 {
	meta:
		name = "__write"
		size = 220
		refs = "0003 __sehtable$__write 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __write_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "_realloc"
		size = 539
		refs = "0003 __sehtable$_realloc 0008 __SEH_prolog4 0017 _malloc 002a _free 0036 ___active_heap 0052 __lock 005c ___sbh_find_block 006e ___sbh_threshold 0078 ___sbh_resize_block 008a ___sbh_alloc_block 00a6 _memcpy 00b6 ___sbh_free_block 00d9 __crtheap 00df __imp__HeapAlloc@12 0136 __imp__HeapReAlloc@16 0147 __unlock 015a __newmode 0162 __callnewh 0170 __errno 017d __imp__GetLastError@0 0183 __get_errno_from_oserr 01ee __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 85 DB 75 0E FF 75 0C E8 ?? ?? ?? ?? 59 E9 CC 01 00 00 8B 75 0C 85 F6 75 0C 53 E8 ?? ?? ?? ?? 59 E9 B7 01 00 00 83 3D ?? ?? ?? ?? 03 0F 85 93 01 00 00 33 FF 89 7D E4 83 FE E0 0F 87 8A 01 00 00 6A 04 E8 ?? ?? ?? ?? 59 89 7D FC 53 E8 ?? ?? ?? ?? 59 89 45 E0 3B C7 0F 84 9E 00 00 00 3B 35 ?? ?? ?? ?? 77 49 56 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 05 89 5D E4 EB 35 56 E8 ?? ?? ?? ?? 59 89 45 E4 3B C7 74 27 8B 43 FC 48 3B C6 72 02 8B C6 50 53 FF 75 E4 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 89 45 E0 53 50 E8 ?? ?? ?? ?? 83 C4 18 39 7D E4 75 48 3B F7 75 06 33 F6 46 89 75 0C 83 C6 0F 83 E6 F0 89 75 0C 56 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B C7 74 20 8B 43 FC 48 3B C6 72 02 8B C6 50 53 FF 75 E4 E8 ?? ?? ?? ?? 53 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 14 C7 45 FC FE FF FF FF E8 2E 00 00 00 83 7D E0 00 75 31 85 F6 75 01 46 83 C6 0F 83 E6 F0 89 75 0C 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 EB 12 8B 75 0C 8B 5D 08 6A 04 E8 ?? ?? ?? ?? 59 C3 8B 7D E4 85 FF 0F 85 BF 00 00 00 39 3D ?? ?? ?? ?? 74 2C 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 D2 FE FF FF E8 ?? ?? ?? ?? 39 7D E0 75 6C 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 EB 5F 85 FF 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 39 7D E0 74 68 C7 00 0C 00 00 00 EB 71 85 F6 75 01 46 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 56 39 05 ?? ?? ?? ?? 74 34 56 E8 ?? ?? ?? ?? 59 85 C0 74 1F 83 FE E0 76 CD 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? E9 7C FF FF FF 85 FF 75 16 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 06 59 8B C7 EB D2 }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "__mbsspn_l"
		size = 199
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strspn 0039 __errno 0049 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 86 00 00 00 8B 45 08 3B C3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 39 5D 0C 74 D3 38 18 74 4B 57 8B 4D 0C EB 28 8A 11 0F B6 FA F6 44 37 1D 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D4 38 19 74 14 0F B6 08 F6 44 31 1D 04 74 05 40 38 18 74 05 40 38 18 75 B7 5F 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_117_3_0 {
	meta:
		name = "__ismbcl0_l"
		size = 89
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 29 8B 4D 08 C1 E9 08 0F B6 C9 F6 44 01 1D 04 74 19 0F B6 4D 08 F6 44 01 1D 08 74 0E 81 7D 08 9F 88 00 00 73 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_117_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 95
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 77 FF FF 81 F9 D3 0F 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_117_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 95
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 67 FF FF 81 F9 05 52 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "__freebuf"
		size = 49
		refs = "0018 _free"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8B 46 0C A8 83 74 1E A8 08 74 1A FF 76 08 E8 ?? ?? ?? ?? 81 66 0C F7 FB FF FF 33 C0 59 89 06 89 46 08 89 46 04 5E 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__87except"
		size = 319
		refs = "001e ___security_cookie 00a5 __handle_exc 00f2 __raise_exc 0105 __ctrlfp 0112 __matherr_flag 011b __matherr 0127 __set_errno_from_matherr 0134 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 0F B7 08 56 8B 73 0C 8B 06 48 57 89 8D 78 FF FF FF 74 52 48 74 43 48 74 34 48 74 25 48 74 46 48 48 74 13 48 0F 85 A5 00 00 00 C7 85 7C FF FF FF 10 00 00 00 EB 39 C7 06 01 00 00 00 E9 8E 00 00 00 C7 85 7C FF FF FF 12 00 00 00 EB 22 C7 85 7C FF FF FF 11 00 00 00 EB 16 C7 85 7C FF FF FF 04 00 00 00 EB 0A C7 85 7C FF FF FF 08 00 00 00 51 8D 7E 18 57 FF B5 7C FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 49 8B 43 08 83 F8 10 74 10 83 F8 16 74 0B 83 F8 1D 74 06 83 65 C0 FE EB 12 8B 4D C0 DD 46 10 83 E1 E3 DD 5D B0 83 C9 03 89 4D C0 57 8D 4E 08 51 50 FF B5 7C FF FF FF 8D 85 78 FF FF FF 50 8D 45 80 50 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 FF B5 78 FF FF FF E8 ?? ?? ?? ?? 83 3E 08 59 59 74 14 83 3D ?? ?? ?? ?? 00 75 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 08 FF 36 E8 ?? ?? ?? ?? 59 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_sprintf"
		size = 125
		refs = "0011 __errno 0021 __invalid_parameter 0056 __output_l 0071 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4D 8B 45 08 3B C3 74 DC 56 89 45 E8 89 45 E0 8D 45 10 50 53 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "__sprintf_l"
		size = 28
		refs = "0013 __vsprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_473_1_0 {
	meta:
		name = "___swprintf_l"
		size = 28
		refs = "0013 ___vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_875_1_0 {
	meta:
		name = "__fprintf_l"
		size = 28
		refs = "0013 __vfprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_875_4_0 {
	meta:
		name = "__fprintf_p_l"
		size = 28
		refs = "0013 __vfprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_875_2_0 {
	meta:
		name = "__fprintf_s_l"
		size = 28
		refs = "0013 __vfprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_567_1_0 {
	meta:
		name = "__fwprintf_l"
		size = 28
		refs = "0013 __vfwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_567_4_0 {
	meta:
		name = "__fwprintf_p_l"
		size = 28
		refs = "0013 __vfwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_567_2_0 {
	meta:
		name = "__fwprintf_s_l"
		size = 28
		refs = "0013 __vfwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_sprintf_s"
		size = 30
		refs = "0015 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "?swprintf@@YAHPAGIPBGZZ"
		size = 30
		refs = "0015 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_120_6_0 {
	meta:
		name = "__sprintf_p"
		size = 30
		refs = "0015 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_473_4_0 {
	meta:
		name = "__swprintf_p"
		size = 30
		refs = "0015 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "_swprintf"
		size = 30
		refs = "0015 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_473_2_0 {
	meta:
		name = "_swprintf_s"
		size = 30
		refs = "0015 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 31
		refs = "0016 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_849_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 31
		refs = "0016 __vsnprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_797_1_0 {
	meta:
		name = "__snprintf_l"
		size = 31
		refs = "0016 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_371_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 31
		refs = "0016 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_120_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 31
		refs = "0016 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_752_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 31
		refs = "0016 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_473_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 31
		refs = "0016 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_473_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 31
		refs = "0016 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "__snprintf_s"
		size = 33
		refs = "0018 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_473_3_0 {
	meta:
		name = "__snwprintf_s"
		size = 33
		refs = "0018 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "__snprintf_s_l"
		size = 34
		refs = "0019 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_473_6_0 {
	meta:
		name = "__snwprintf_s_l"
		size = 34
		refs = "0019 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_120_8_0 {
	meta:
		name = "__scprintf"
		size = 21
		refs = "000d __vscprintf"
		altNames = "__scprintf_p"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_473_8_0 {
	meta:
		name = "__scwprintf"
		size = 21
		refs = "000d __vscwprintf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_473_9_0 {
	meta:
		name = "__scwprintf_p"
		size = 21
		refs = "000d __vscwprintf_p"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_120_10_0 {
	meta:
		name = "__scprintf_l"
		size = 25
		refs = "0010 __vscprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_510_10_0 {
	meta:
		name = "__cprintf_l"
		size = 25
		refs = "0010 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_420_11_0 {
	meta:
		name = "__cprintf_p_l"
		size = 25
		refs = "0010 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_358_10_0 {
	meta:
		name = "__cprintf_s_l"
		size = 25
		refs = "0010 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_323_9_0 {
	meta:
		name = "__cwprintf_l"
		size = 25
		refs = "0010 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_872_9_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 25
		refs = "0010 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_633_9_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 25
		refs = "0010 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_301_1_0 {
	meta:
		name = "__printf_l"
		size = 25
		refs = "0010 __vprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_301_4_0 {
	meta:
		name = "__printf_p_l"
		size = 25
		refs = "0010 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_301_2_0 {
	meta:
		name = "__printf_s_l"
		size = 25
		refs = "0010 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_120_11_0 {
	meta:
		name = "__scprintf_p_l"
		size = 25
		refs = "0010 __vscprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_473_10_0 {
	meta:
		name = "__scwprintf_l"
		size = 25
		refs = "0010 __vscwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_473_11_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 25
		refs = "0010 __vscwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_868_1_0 {
	meta:
		name = "__wprintf_l"
		size = 25
		refs = "0010 __vwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_868_4_0 {
	meta:
		name = "__wprintf_p_l"
		size = 25
		refs = "0010 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_868_2_0 {
	meta:
		name = "__wprintf_s_l"
		size = 25
		refs = "0010 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_121_1_0 {
	meta:
		name = "__ftime64_s"
		size = 374
		refs = "000c ___security_cookie 0027 __errno 0036 __invalid_parameter 0045 ___tzset 0051 __get_timezone 0060 __invoke_watson 0081 __imp__GetSystemTimeAsFileTime@4 009a __aulldiv 00ac _elapsed_minutes_cache 00c3 __imp__GetTimeZoneInformation@4 00e0 _dstflag_cache 013e __aullrem 0170 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 33 FF 89 BD 4C FF FF FF 3B F7 75 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 24 01 00 00 E8 ?? ?? ?? ?? 8D 85 4C FF FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 4C FF FF FF 53 6A 3C 99 59 F7 F9 66 89 46 0A 8D 85 44 FF FF FF 50 FF 15 ?? ?? ?? ?? 8B 9D 44 FF FF FF 57 8B BD 48 FF FF FF 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 89 85 3C FF FF FF 89 95 40 FF FF FF 3B 05 ?? ?? ?? ?? 75 08 3B 15 ?? ?? ?? ?? 74 62 8D 85 50 FF FF FF 50 FF 15 ?? ?? ?? ?? 83 F8 FF 74 27 83 F8 02 75 19 66 83 7D EA 00 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 83 25 ?? ?? ?? ?? 00 EB 07 83 0D ?? ?? ?? ?? FF 8B 85 3C FF FF FF 8B BD 48 FF FF FF 8B 9D 44 FF FF FF A3 ?? ?? ?? ?? 8B 85 40 FF FF FF A3 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 46 0C E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 66 89 46 08 E8 ?? ?? ?? ?? 89 06 89 56 04 33 C0 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 72
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_rename"
		size = 51
		refs = "000d __imp__MoveFileA@8 0017 __imp__GetLastError@0 0025 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "__wrename"
		size = 51
		refs = "000d __imp__MoveFileW@8 0017 __imp__GetLastError@0 0025 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "?_open@@YAHPBDHH@Z"
		size = 45
		refs = "0018 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_124_2_0 {
	meta:
		name = "?_wopen@@YAHPB_WHH@Z"
		size = 45
		refs = "0018 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "?_sopen@@YAHPBDHHH@Z"
		size = 46
		refs = "0019 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_124_3_0 {
	meta:
		name = "?_wsopen@@YAHPB_WHHH@Z"
		size = 46
		refs = "0019 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__lseeki64_nolock"
		size = 133
		refs = "001a __get_osfhandle 0027 __errno 0044 __imp__SetFilePointer@16 0051 __imp__GetLastError@0 005b __dosmaperr 006a ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 56 8B 75 08 89 45 F8 8B 45 10 57 56 89 45 FC E8 ?? ?? ?? ?? 83 CF FF 59 3B C7 75 11 E8 ?? ?? ?? ?? C7 00 09 00 00 00 8B C7 8B D7 EB 4A FF 75 14 8D 4D FC 51 FF 75 F8 50 FF 15 ?? ?? ?? ?? 89 45 F8 3B C7 75 13 FF 15 ?? ?? ?? ?? 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB CF 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FD 8B 45 F8 8B 55 FC 5F 5E C9 C3 }
	condition:
		$1
}

rule file_125_1_0 {
	meta:
		name = "__lseeki64"
		size = 281
		refs = "0003 __sehtable$__lseeki64 0008 __SEH_prolog4 001e ___doserrno 0026 __errno 0041 __nhandle 005f __invalid_parameter 0070 ___pioinfo 00b0 ___lock_fhandle 00ce __lseeki64_nolock 010a __SEH_epilog4 0113 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 CE FF 89 75 DC 89 75 E0 8B 45 08 83 F8 FE 75 1C E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 8B C6 8B D6 E9 D0 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C8 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 75 26 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 CA FF 8B C2 EB 5B 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 1C FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 89 55 E0 EB 1A E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D DC FF 83 4D E0 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 DC 8B 55 E0 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__isatty"
		size = 100
		refs = "000e __errno 0025 __nhandle 003c __invalid_parameter 0052 ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 FE 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 33 C0 5D C3 56 33 F6 3B C6 7C 08 3B 05 ?? ?? ?? ?? 72 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 1A 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 0F BE 44 01 04 83 E0 40 5E 5D C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__fsqrt"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 D9 FA DD 5D F8 DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_CallDestructExceptionObject"
		size = 56
		refs = "0013 __pDestructExceptionObject 0020 __IsNonwritableInCurrentImage"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 81 3E 63 73 6D E0 75 24 83 3D ?? ?? ?? ?? 00 74 1B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 0C FF 75 0C 56 FF 15 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__eof"
		size = 284
		refs = "0003 __sehtable$__eof 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 0099 __lseeki64_nolock 010d __SEH_epilog4 0116 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 DD 00 00 00 33 F6 3B C6 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F8 83 E7 1F C1 E7 06 8B 0B 0F BE 4C 39 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 75 FC 8B 03 F6 44 38 04 01 74 56 6A 01 56 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F8 8B DA 23 C3 83 F8 FF 74 4E 6A 02 56 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B C8 23 CA 83 F9 FF 74 36 3B F8 75 0D 3B DA 75 09 C7 45 E4 01 00 00 00 EB 29 56 53 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 75 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 87
		refs = "0005 __imp__GetEnvironmentStringsW@0 0032 __malloc_crt 0040 __imp__FreeEnvironmentStringsW@4 004e _memcpy"
	strings:
		$1 = { 8B FF 56 FF 15 ?? ?? ?? ?? 8B F0 33 C9 3B F1 75 04 33 C0 5E C3 66 39 0E 74 0E 40 40 66 39 08 75 F9 40 40 66 39 08 75 F2 2B C6 40 53 40 8B D8 57 53 E8 ?? ?? ?? ?? 8B F8 59 85 FF 75 0D 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5B 5E C3 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB E6 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__strnset_s"
		size = 120
		refs = "0030 __errno 003f __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 57 8B 7D 14 33 DB 3B FB 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B F3 74 07 8B 4D 0C 3B CB 77 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 8B C6 38 1E 74 12 3B FB 76 10 49 74 0B 8A 55 10 88 10 40 4F 38 18 75 EE 3B FB 75 0A EB 04 49 74 05 40 38 18 75 F8 3B CB 75 A9 88 1E EB B7 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__tell"
		size = 22
		refs = "000d __lseek"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__fwrite_nolock"
		size = 354
		refs = "001f __errno 002f __invalid_parameter 00a7 _memcpy 00c5 __flush 00e5 __fileno 00ec __write 0117 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 57 33 FF 39 7D 0C 74 24 39 7D 10 74 1F 8B 75 14 3B F7 75 1F E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5E 5B C9 C3 8B 4D 08 3B CF 74 DA 83 C8 FF 33 D2 F7 75 0C 39 45 10 77 CD 8B 7D 0C 0F AF 7D 10 F7 46 0C 0C 01 00 00 89 4D FC 89 7D F4 8B DF 74 08 8B 46 18 89 45 F8 EB 07 C7 45 F8 00 10 00 00 85 FF 0F 84 BF 00 00 00 8B 4E 0C 81 E1 08 01 00 00 74 2F 8B 46 04 85 C0 74 28 0F 8C AF 00 00 00 8B FB 3B D8 72 02 8B F8 57 FF 75 FC FF 36 E8 ?? ?? ?? ?? 29 7E 04 01 3E 83 C4 0C 2B DF 01 7D FC EB 4F 3B 5D F8 72 4F 85 C9 74 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 7D 83 7D F8 00 8B FB 74 09 33 D2 8B C3 F7 75 F8 2B FA 57 FF 75 FC 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 61 8B CF 3B C7 77 02 8B C8 01 4D FC 2B D9 3B C7 72 50 8B 7D F4 EB 29 8B 45 FC 0F BE 00 56 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 29 FF 45 FC 8B 46 18 4B 89 45 F8 85 C0 7F 07 C7 45 F8 01 00 00 00 85 DB 0F 85 41 FF FF FF 8B 45 10 E9 F1 FE FF FF 83 4E 0C 20 8B C7 2B C3 33 D2 F7 75 0C E9 DF FE FF FF 83 4E 0C 20 8B 45 F4 EB EB }
	condition:
		$1
}

rule file_139_1_0 {
	meta:
		name = "_fwrite"
		size = 130
		refs = "0003 __sehtable$_fwrite 0008 __SEH_prolog4 0025 __errno 0035 __invalid_parameter 003f __SEH_epilog4 0048 __lock_file 005d __fwrite_nolock 007c __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 75 0C 74 29 39 75 10 74 24 33 C0 39 75 14 0F 95 C0 3B C6 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E8 ?? ?? ?? ?? C3 FF 75 14 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 8B 45 E4 EB C6 FF 75 14 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__getdllprocaddr"
		size = 49
		refs = "001c __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 75 17 81 7D 10 FF FF 00 00 7F 19 FF 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 83 7D 10 FF 75 05 FF 75 0C EB EA 33 C0 5D C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__strset"
		size = 33
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 8B D7 33 C0 83 C9 FF F2 AE 83 C1 02 F7 D9 8A 45 0C 8B FA F3 AA 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_142_3_0 {
	meta:
		name = "__mbspbrk_l"
		size = 205
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strpbrk 0039 __errno 0049 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 8C 00 00 00 8B 4D 08 3B CB 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 69 39 5D 0C 74 D3 38 19 74 4B 57 8B 45 0C EB 28 8A 10 0F B6 FA F6 44 37 1D 04 74 17 3A 11 75 08 8A 50 01 3A 51 01 74 14 8D 50 01 38 1A 74 0D 8B C2 EB 04 3A 11 74 05 40 38 18 75 D4 38 18 75 14 0F B6 01 F6 44 30 1D 04 74 05 41 38 19 74 05 41 38 19 75 B7 5F 0F B6 01 F7 D8 1B C0 23 C1 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_wcstok_s"
		size = 238
		refs = "0011 __errno 0021 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 10 56 33 F6 3B C6 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 BC 00 00 00 57 8B 7D 0C 3B FE 74 0D 8B 4D 08 3B CE 75 25 8B 08 3B CE 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 87 00 00 00 0F B7 11 53 66 3B D6 74 2C 0F B7 1F 8B 7D 0C 66 3B DE 74 12 0F B7 C3 66 3B C2 74 0A 47 47 0F B7 07 66 3B C6 75 F1 66 39 37 74 0A 41 41 0F B7 11 66 3B D6 75 D7 89 4D FC 66 39 31 74 38 8B 45 0C 0F B7 18 8B 55 0C 66 3B DE 74 15 0F B7 39 0F B7 C3 66 3B C7 74 0A 42 42 0F B7 02 66 3B C6 75 F1 66 39 32 75 09 41 41 66 39 31 75 D7 EB 07 33 C0 66 89 01 41 41 8B 45 10 89 08 8B 45 FC 2B C1 F7 D8 1B C0 23 45 FC 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "_strcpy_s"
		size = 104
		refs = "0019 __errno 0028 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 53 33 DB 56 57 3B CB 74 07 8B 7D 0C 3B FB 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 30 8B 75 10 3B F3 75 04 88 19 EB DA 8B D1 8A 06 88 02 42 46 3A C3 74 03 4F 75 F3 3B FB 75 10 88 19 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB C1 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_146_3_0 {
	meta:
		name = "__gcvt_s"
		size = 288
		refs = "0009 ___security_cookie 001f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 __errno 0037 __invalid_parameter 006c __fltout2 0091 __cftof 00a6 __cftoe 011a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 33 DB 53 8D 4D D4 E8 ?? ?? ?? ?? 3B FB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 C0 00 00 00 39 5D 0C 76 DF 8B 75 18 88 1F 3B 75 0C 72 09 E8 ?? ?? ?? ?? 6A 22 EB D3 6A 16 8D 45 E4 50 8D 45 C4 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 8B 40 04 8D 48 FF 83 C4 14 83 F9 FF 7C 1C 8D 56 FF 3B CA 7F 15 2B F0 56 FF 75 0C 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 10 EB 13 53 4E 56 FF 75 0C 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 14 8B F0 3B F3 75 49 8A 0F 8B C7 3A CB 74 18 8B 55 D4 8B 92 BC 00 00 00 8B 12 8A 12 3A CA 74 07 40 8A 08 3A CB 75 F5 8A 08 40 84 C9 74 29 EB 06 80 F9 65 74 07 40 8A 08 3A CB 75 F4 8B D0 48 80 38 30 74 FA 8A 0A 40 42 88 08 3A CB 75 F6 EB 07 E8 ?? ?? ?? ?? 89 30 38 5D E0 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 5F 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "__gcvt"
		size = 40
		refs = "0016 __gcvt_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 6A FF FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 F7 D8 1B C0 F7 D0 23 45 14 5D C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__swab"
		size = 86
		refs = "0010 __errno 0020 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 75 1A E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 2A 8B 45 0C 3B C6 74 DF 8B 55 10 3B D6 7C D8 83 FA 01 7E 17 8D 72 FE D1 EE 46 53 8A 11 41 8A 19 41 88 18 40 88 10 40 4E 75 F1 5B 5E 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__allmul"
		size = 52
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
	condition:
		$1
}

rule file_149_2_0 {
	meta:
		name = "___shr_12"
		size = 50
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 50 08 8B 48 04 56 57 8B F9 8B F2 D1 E9 C1 E6 1F 0B CE 89 48 04 8B 08 C1 E7 1F D1 EA D1 E9 0B CF 5F 89 50 08 89 08 5E 5D C3 }
	condition:
		$1
}

rule file_149_3_0 {
	meta:
		name = "___ld12mul"
		size = 635
		refs = "0009 ___security_cookie 0275 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 33 C9 53 8B 5D 0C 0F B7 53 0A 56 89 4D D4 89 4D F0 89 4D F4 89 4D F8 0F B7 48 0A 8B F2 33 F1 81 E6 00 80 00 00 89 75 E0 BE FF 7F 00 00 23 CE 23 D6 8D 34 0A 57 0F B7 F6 BF FF 7F 00 00 89 75 D0 66 3B CF 0F 83 EE 01 00 00 66 3B D7 0F 83 E5 01 00 00 BF FD BF 00 00 66 3B F7 0F 87 D7 01 00 00 BF BF 3F 00 00 66 3B F7 77 0A 33 C9 89 48 08 E9 DE 01 00 00 BF FF FF FF 7F 66 85 C9 75 1D 46 89 75 D0 85 78 08 75 14 33 C9 39 48 04 75 0F 39 08 75 0B 66 89 48 0A E9 BC 01 00 00 33 C9 66 3B D1 75 12 46 89 75 D0 85 7B 08 75 09 39 4B 04 75 04 39 0B 74 B8 89 4D E4 8D 7D F4 C7 45 E8 05 00 00 00 8B 4D E4 8B 55 E8 03 C9 89 55 D8 85 D2 7E 4F 83 C3 08 89 5D DC 8D 1C 08 8B 55 DC 0F B7 12 0F B7 0B 83 65 EC 00 0F AF CA 8B 57 FC 8D 34 0A 3B F2 72 04 3B F1 73 07 C7 45 EC 01 00 00 00 83 7D EC 00 89 77 FC 74 03 66 FF 07 83 6D DC 02 43 43 FF 4D D8 83 7D D8 00 7F C0 8B 5D 0C 8B 75 D0 47 47 FF 45 E4 FF 4D E8 83 7D E8 00 7F 94 81 C6 02 C0 00 00 BF FF FF 00 00 66 85 F6 7E 38 F7 45 F8 00 00 00 80 75 2A 8B 4D F0 8B 5D F4 8B 55 F4 D1 65 F0 C1 E9 1F 03 DB 0B D9 8B 4D F8 C1 EA 1F 03 C9 0B CA 03 F7 89 5D F4 89 4D F8 66 85 F6 7F CD 66 85 F6 7F 4F 03 F7 66 85 F6 7D 48 8B CE F7 D9 0F B7 C9 89 4D EC 03 F1 F6 45 F0 01 74 03 FF 45 D4 8B 4D F8 8B 5D F4 8B 55 F4 D1 6D F8 C1 E1 1F D1 EB 0B D9 8B 4D F0 C1 E2 1F D1 E9 0B CA FF 4D EC 89 5D F4 89 4D F0 75 CF 83 7D D4 00 74 05 66 83 4D F0 01 B9 00 80 00 00 8B D1 66 39 55 F0 77 11 8B 55 F0 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 2F 83 7D F2 FF 75 26 83 65 F2 00 83 7D F6 FF 75 17 83 65 F6 00 66 39 7D FA 75 07 66 89 4D FA 46 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 B9 FF 7F 00 00 66 3B F1 73 1C 66 8B 4D F2 0B 75 E0 66 89 08 8B 4D F4 89 48 02 8B 4D F8 89 48 06 66 89 70 0A EB 20 33 D2 33 C9 66 39 4D E0 0F 94 C2 4A 81 E2 00 00 00 80 81 C2 00 80 FF 7F 89 50 08 89 08 89 48 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_149_4_0 {
	meta:
		name = "___multtenpow12"
		size = 773
		refs = "0009 ___security_cookie 0016 __pow10pos 0031 __pow10neg 02ff @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 B9 ?? ?? ?? ?? 83 E9 60 33 D2 89 4D DC 39 55 0C 0F 84 CE 02 00 00 7D 0E F7 5D 0C B9 ?? ?? ?? ?? 83 E9 60 89 4D DC 39 55 10 75 05 33 C9 66 89 08 39 55 0C 0F 84 AB 02 00 00 53 56 57 8B 4D 0C 83 45 DC 54 C1 7D 0C 03 83 E1 07 3B CA 0F 84 84 02 00 00 6B C9 0C 03 4D DC 8B D9 B9 00 80 00 00 66 39 0B 72 0E 8B F3 8D 7D E4 A5 A5 A5 FF 4D E6 8D 5D E4 0F B7 48 0A 89 55 C8 89 55 F0 89 55 F4 89 55 F8 0F B7 53 0A 8B F2 33 F1 81 E6 00 80 00 00 89 75 D0 BE FF 7F 00 00 23 CE 23 D6 8D 3C 0A 0F B7 FF 89 7D D8 8B FE 66 3B CF 0F 83 06 02 00 00 66 3B D6 0F 83 FD 01 00 00 8B 7D D8 BE FD BF 00 00 66 3B FE 0F 87 EC 01 00 00 BE BF 3F 00 00 66 3B FE 77 0A 33 C9 89 48 08 E9 F3 01 00 00 33 F6 66 3B CE 75 21 47 F7 40 08 FF FF FF 7F 89 7D D8 75 14 39 70 04 75 0F 39 30 75 0B 33 C9 66 89 48 0A E9 D0 01 00 00 66 3B D6 75 23 47 F7 43 08 FF FF FF 7F 89 7D D8 75 16 39 73 04 75 11 39 33 75 0D 89 70 08 89 70 04 89 30 E9 A8 01 00 00 89 75 CC 8D 75 F4 C7 45 E0 05 00 00 00 8B 4D CC 8B 55 E0 03 C9 89 55 D4 85 D2 7E 53 8D 53 08 03 C8 89 55 C0 89 4D C4 8B 4D C4 8B 55 C0 0F B7 12 0F B7 09 83 65 BC 00 0F AF CA 8B 56 FC 8D 3C 0A 3B FA 72 04 3B F9 73 07 C7 45 BC 01 00 00 00 83 7D BC 00 89 7E FC 74 03 66 FF 06 83 45 C4 02 83 6D C0 02 FF 4D D4 83 7D D4 00 7F BB 8B 7D D8 46 46 FF 45 CC FF 4D E0 83 7D E0 00 7F 90 81 C7 02 C0 00 00 66 85 FF 7E 3B F7 45 F8 00 00 00 80 75 2D 8B 75 F4 8B 4D F0 D1 65 F0 C1 E9 1F 8B D6 03 F6 0B F1 8B 4D F8 C1 EA 1F 03 C9 0B CA 81 C7 FF FF 00 00 89 75 F4 89 4D F8 66 85 FF 7F CA 66 85 FF 7F 4D 81 C7 FF FF 00 00 66 85 FF 7D 42 8B CF F7 D9 0F B7 F1 03 FE F6 45 F0 01 74 03 FF 45 C8 8B 4D F8 8B 5D F4 8B 55 F4 D1 6D F8 C1 E1 1F D1 EB 0B D9 8B 4D F0 C1 E2 1F D1 E9 0B CA 4E 89 5D F4 89 4D F0 75 D1 39 75 C8 74 05 66 83 4D F0 01 B9 00 80 00 00 8B D1 66 39 55 F0 77 11 8B 55 F0 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 34 83 7D F2 FF 75 2B 83 65 F2 00 83 7D F6 FF 75 1C 83 65 F6 00 BA FF FF 00 00 66 39 55 FA 75 07 66 89 4D FA 47 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 B9 FF 7F 00 00 66 3B F9 73 1C 66 8B 4D F2 0B 7D D0 66 89 08 8B 4D F4 89 48 02 8B 4D F8 89 48 06 66 89 78 0A EB 20 33 D2 33 C9 66 39 4D D0 0F 94 C2 4A 81 E2 00 00 00 80 81 C2 00 80 FF 7F 89 50 08 89 48 04 89 08 33 D2 39 55 0C 0F 85 5B FD FF FF 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_149_5_0 {
	meta:
		name = "___strgtold12_l"
		size = 1784
		refs = "0009 ___security_cookie 004c __errno 005c __invalid_parameter 0096 $LN276 0329 ___mtold12 0366 __pow10pos 037d __pow10neg 06c1 @__security_check_cookie@4 06c8 $LN119 06cc $LN108 06d0 $LN97 06d4 $LN88 06d8 $LN75 06dc $LN61 06e0 $LN58 06e4 $LN43 06e8 $LN49 06ec $LN36 06f0 $LN254 06f4 $LN28"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 33 DB 56 33 F6 89 45 88 8B 45 0C 46 33 C9 57 89 45 90 8D 7D E0 89 5D 8C 89 75 98 89 5D B4 89 5D A8 89 5D A4 89 5D A0 89 5D 9C 89 5D B0 89 5D 94 39 5D 24 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 4E 06 00 00 8B 55 10 89 55 AC 8A 02 3C 20 74 0C 3C 09 74 08 3C 0A 74 04 3C 0D 75 03 42 EB EB B3 30 8A 02 42 83 F9 0B 0F 87 2F 02 00 00 FF 24 8D ?? ?? ?? ?? 8A C8 80 E9 31 80 F9 08 77 06 6A 03 59 4A EB DD 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 05 6A 05 59 EB C7 0F BE C0 83 E8 2B 74 1D 48 48 74 0D 83 E8 03 0F 85 8B 01 00 00 8B CE EB AE 6A 02 59 C7 45 8C 00 80 00 00 EB A2 83 65 8C 00 6A 02 59 EB 99 8A C8 80 E9 31 89 75 A8 80 F9 08 76 A9 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 04 6A 04 EB AD 3C 2B 74 28 3C 2D 74 24 3A C3 74 B9 3C 43 0F 8E 3C 01 00 00 3C 45 7E 10 3C 63 0F 8E 30 01 00 00 3C 65 0F 8F 28 01 00 00 6A 06 EB 81 4A 6A 0B E9 79 FF FF FF 8A C8 80 E9 31 80 F9 08 0F 86 52 FF FF FF 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 54 FF FF FF 3A C3 0F 84 66 FF FF FF 8B 55 AC E9 14 01 00 00 89 75 A8 EB 1A 3C 39 7F 1A 83 7D B4 19 73 0A FF 45 B4 2A C3 88 07 47 EB 03 FF 45 B0 8A 02 42 3A C3 7D E2 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 5D FF FF FF 3C 2B 74 89 3C 2D 74 85 E9 60 FF FF FF 83 7D B4 00 89 75 A8 89 75 A4 75 26 EB 06 FF 4D B0 8A 02 42 3A C3 74 F6 EB 18 3C 39 7F D5 83 7D B4 19 73 0B FF 45 B4 2A C3 88 07 47 FF 4D B0 8A 02 42 3A C3 7D E4 EB BB 2A C3 89 75 A4 3C 09 0F 87 6E FF FF FF 6A 04 E9 9E FE FF FF 8D 4A FE 89 4D AC 8A C8 80 E9 31 80 F9 08 77 07 6A 09 E9 87 FE FF FF 0F BE C0 83 E8 2B 74 20 48 48 74 10 83 E8 03 0F 85 3B FF FF FF 6A 08 E9 82 FE FF FF 83 4D 98 FF 6A 07 59 E9 40 FE FF FF 6A 07 E9 6F FE FF FF 89 75 A0 EB 03 8A 02 42 3A C3 74 F9 2C 31 3C 08 76 B8 4A EB 28 8A C8 80 E9 31 80 F9 08 76 AB 3A C3 EB BD 83 7D 20 00 74 47 0F BE C0 83 E8 2B 8D 4A FF 89 4D AC 74 C2 48 48 74 B2 8B D1 83 7D A8 00 8B 45 90 89 10 0F 84 D9 03 00 00 6A 18 58 39 45 B4 76 10 80 7D F7 05 7C 03 FE 45 F7 4F FF 45 B0 89 45 B4 83 7D B4 00 0F 86 DE 03 00 00 EB 59 6A 0A 59 4A 83 F9 0A 0F 85 BC FD FF FF EB BE 89 75 A0 33 C9 EB 19 3C 39 7F 20 6B C9 0A 0F BE F0 8D 4C 31 D0 81 F9 50 14 00 00 7F 09 8A 02 42 3A C3 7D E3 EB 05 B9 51 14 00 00 89 4D 9C EB 0B 3C 39 0F 8F 5B FF FF FF 8A 02 42 3A C3 7D F1 E9 4F FF FF FF FF 4D B4 FF 45 B0 4F 80 3F 00 74 F4 8D 45 C4 50 FF 75 B4 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 45 9C 33 D2 83 C4 0C 39 55 98 7D 02 F7 D8 03 45 B0 39 55 A0 75 03 03 45 18 39 55 A4 75 03 2B 45 1C 3D 50 14 00 00 0F 8F 22 03 00 00 3D B0 EB FF FF 0F 8C 2E 03 00 00 B9 ?? ?? ?? ?? 83 E9 60 89 45 AC 3B C2 0F 84 E9 02 00 00 7D 0D F7 D8 B9 ?? ?? ?? ?? 89 45 AC 83 E9 60 39 55 14 75 06 33 C0 66 89 45 C4 39 55 AC 0F 84 C6 02 00 00 EB 05 8B 4D 84 33 D2 8B 45 AC C1 7D AC 03 83 C1 54 83 E0 07 89 4D 84 3B C2 0F 84 9D 02 00 00 6B C0 0C 03 C1 8B D8 B8 00 80 00 00 66 39 03 72 0E 8B F3 8D 7D B8 A5 A5 A5 FF 4D BA 8D 5D B8 0F B7 4B 0A 33 C0 89 45 B0 89 45 D4 89 45 D8 89 45 DC 8B 45 CE 8B F1 BA FF 7F 00 00 33 F0 23 C2 23 CA 81 E6 00 80 00 00 BF FF 7F 00 00 8D 14 01 89 75 90 0F B7 D2 66 3B C7 0F 83 21 02 00 00 66 3B CF 0F 83 18 02 00 00 BF FD BF 00 00 66 3B D7 0F 87 0A 02 00 00 BE BF 3F 00 00 66 3B D6 77 0D 33 C0 89 45 C8 89 45 C4 E9 0E 02 00 00 33 F6 66 3B C6 75 1F 42 F7 45 CC FF FF FF 7F 75 15 39 75 C8 75 10 39 75 C4 75 0B 33 C0 66 89 45 CE E9 EB 01 00 00 66 3B CE 75 21 42 F7 43 08 FF FF FF 7F 75 17 39 73 04 75 12 39 33 75 0E 89 75 CC 89 75 C8 89 75 C4 E9 C5 01 00 00 89 75 98 8D 7D D8 C7 45 A8 05 00 00 00 8B 45 98 8B 4D A8 03 C0 89 4D 9C 85 C9 7E 52 8D 44 05 C4 89 45 A4 8D 43 08 89 45 A0 8B 45 A0 8B 4D A4 0F B7 09 0F B7 00 83 65 B4 00 0F AF C1 8B 4F FC 8D 34 01 3B F1 72 04 3B F0 73 07 C7 45 B4 01 00 00 00 83 7D B4 00 89 77 FC 74 03 66 FF 07 83 45 A4 02 83 6D A0 02 FF 4D 9C 83 7D 9C 00 7F BB 47 47 FF 45 98 FF 4D A8 83 7D A8 00 7F 91 81 C2 02 C0 00 00 66 85 D2 7E 37 8B 7D DC 85 FF 78 2B 8B 75 D8 8B 45 D4 D1 65 D4 C1 E8 1F 8B CE 03 F6 0B F0 C1 E9 1F 8D 04 3F 0B C1 81 C2 FF FF 00 00 89 75 D8 89 45 DC 66 85 D2 7F CE 66 85 D2 7F 4D 81 C2 FF FF 00 00 66 85 D2 7D 42 8B C2 F7 D8 0F B7 F0 03 D6 F6 45 D4 01 74 03 FF 45 B0 8B 45 DC 8B 7D D8 8B 4D D8 D1 6D DC C1 E0 1F D1 EF 0B F8 8B 45 D4 C1 E1 1F D1 E8 0B C1 4E 89 7D D8 89 45 D4 75 D1 39 75 B0 74 05 66 83 4D D4 01 B8 00 80 00 00 8B C8 66 39 4D D4 77 11 8B 4D D4 81 E1 FF FF 01 00 81 F9 00 80 01 00 75 34 83 7D D6 FF 75 2B 83 65 D6 00 83 7D DA FF 75 1C 83 65 DA 00 B9 FF FF 00 00 66 39 4D DE 75 07 66 89 45 DE 42 EB 0E 66 FF 45 DE EB 08 FF 45 DA EB 03 FF 45 D6 B8 FF 7F 00 00 66 3B D0 72 23 33 C0 33 C9 66 39 45 90 89 45 C8 0F 94 C1 89 45 C4 49 81 E1 00 00 00 80 81 C1 00 80 FF 7F 89 4D CC EB 3B 66 8B 45 D6 0B 55 90 66 89 45 C4 8B 45 D8 89 45 C6 8B 45 DC 89 45 CA 66 89 55 CE EB 1E 33 C0 66 85 F6 0F 94 C0 83 65 C8 00 48 25 00 00 00 80 05 00 80 FF 7F 83 65 C4 00 89 45 CC 83 7D AC 00 0F 85 3C FD FF FF 8B 45 CC 0F B7 4D C4 8B 75 C6 8B 55 CA C1 E8 10 EB 2F C7 45 94 04 00 00 00 EB 1E 33 F6 B8 FF 7F 00 00 BA 00 00 00 80 33 C9 C7 45 94 02 00 00 00 EB 0F C7 45 94 01 00 00 00 33 C9 33 C0 33 D2 33 F6 8B 7D 88 0B 45 8C 66 89 0F 66 89 47 0A 8B 45 94 89 77 02 89 57 06 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_6_0 {
	meta:
		name = "___STRINGTOLD_L"
		size = 91
		refs = "0009 ___security_cookie 0030 ___strgtold12_l 003c __ld12told 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_825_6_0 {
	meta:
		name = "___WSTRINGTOLD_L"
		size = 91
		refs = "0009 ___security_cookie 0030 ___wstrgtold12_l 003c __ld12told 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_152_3_0 {
	meta:
		name = "__mbtowc_l"
		size = 279
		refs = "0035 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 __isleadbyte_l 009b __imp__MultiByteToWideChar@24 00d2 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 0C 33 DB 3B F3 74 15 39 5D 10 74 10 38 1E 75 12 8B 45 08 3B C3 74 05 33 C9 66 89 08 33 C0 5E 5B C9 C3 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 39 58 14 75 1F 8B 45 08 3B C3 74 07 66 0F B6 0E 66 89 08 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 40 EB CA 8D 45 F0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 7D 8B 45 F0 8B 88 AC 00 00 00 83 F9 01 7E 25 39 4D 10 7C 20 33 D2 39 5D 08 0F 95 C2 52 FF 75 08 51 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 8B 45 F0 75 10 8B 4D 10 3B 88 AC 00 00 00 72 20 38 5E 01 74 1B 8B 80 AC 00 00 00 38 5D FC 0F 84 65 FF FF FF 8B 4D F8 83 61 70 FD E9 59 FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF E9 3A FF FF FF 33 C0 39 5D 08 0F 95 C0 50 FF 75 08 8B 45 F0 6A 01 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 0F 85 3A FF FF FF EB BA }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__creat"
		size = 49
		refs = "001c __sopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__wcreat"
		size = 49
		refs = "001c __wsopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "___wcsncnt"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 EB 09 49 66 83 38 00 74 07 40 40 85 C9 75 F3 49 8B 45 0C 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__ms_p5_test_fdiv"
		size = 62
		refs = "000a __real@4147ffff80000000 0013 __real@4150017ec0000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 DD 05 ?? ?? ?? ?? DD 5D F0 DD 05 ?? ?? ?? ?? DD 5D E8 DD 45 E8 DC 75 F0 DC 4D F0 DC 6D E8 DD 5D F8 D9 E8 DC 5D F8 DF E0 F6 C4 05 7A 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_156_1_0 {
	meta:
		name = "__ms_p5_mp_test_fdiv"
		size = 41
		refs = "0001 ??_C@_08CPNIBGIE@KERNEL32?$AA@ 0007 __imp__GetModuleHandleA@4 0010 ??_C@_0BK@NHEOCAHP@IsProcessorFeaturePresent?$AA@ 0017 __imp__GetProcAddress@8 0025 __ms_p5_test_fdiv"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 6A 00 FF D0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_1_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 40
		refs = "000e ___sys_nerr 001e ___sys_errlist"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 7C 09 E8 ?? ?? ?? ?? 3B 30 7C 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E 5D C3 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "_strerror"
		size = 108
		refs = "0008 __getptd_noexit 0015 ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@ 002a __calloc_crt 0045 __get_sys_err_msg 004d _strcpy_s 005e __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 E8 ?? ?? ?? ?? 8B F0 33 DB 3B F3 75 07 B8 ?? ?? ?? ?? EB 4D 57 BF 86 00 00 00 39 5E 24 75 18 6A 01 57 E8 ?? ?? ?? ?? 59 59 89 46 24 3B C3 75 07 B8 ?? ?? ?? ?? EB 29 FF 75 08 8B 76 24 E8 ?? ?? ?? ?? 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_157_3_0 {
	meta:
		name = "_strerror_s"
		size = 97
		refs = "000f __errno 001e __invalid_parameter 0038 __get_sys_err_msg 0043 _strncpy_s 0054 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 57 39 75 08 75 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 34 8B 7D 0C 3B FE 76 DE 8D 47 FF 50 FF 75 10 E8 ?? ?? ?? ?? 59 50 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_158_3_0 {
	meta:
		name = "__mbscspn_l"
		size = 199
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strcspn 0039 __errno 0049 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 86 00 00 00 8B 45 08 3B C3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 39 5D 0C 74 D3 38 18 74 4B 57 8B 4D 0C EB 28 8A 11 0F B6 FA F6 44 37 1D 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D4 38 19 75 14 0F B6 08 F6 44 31 1D 04 74 05 40 38 18 74 05 40 38 18 75 B7 5F 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__vsnprintf_l"
		size = 179
		refs = "0011 __errno 0021 __invalid_parameter 0087 __output_l 00a6 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 10 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 80 00 00 00 8B 4D 0C 56 8B 75 08 3B CB 74 21 3B F3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 53 B8 FF FF FF 7F 89 45 E4 3B C8 77 03 89 4D E4 57 FF 75 18 8D 45 E0 FF 75 14 C7 45 EC 42 00 00 00 FF 75 10 89 75 E8 50 89 75 E0 E8 ?? ?? ?? ?? 83 C4 10 8B F8 3B F3 74 1A FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "__vsnprintf"
		size = 29
		refs = "0014 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_343_3_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 29
		refs = "0014 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_343_1_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 29
		refs = "0014 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_818_1_0 {
	meta:
		name = "__vsnwprintf"
		size = 29
		refs = "0014 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_501_4_0 {
	meta:
		name = "_vsprintf_s"
		size = 29
		refs = "0014 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_626_4_0 {
	meta:
		name = "_vswprintf_s"
		size = 29
		refs = "0014 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__putws"
		size = 233
		refs = "0003 __sehtable$__putws 0008 __SEH_prolog4 0023 __errno 0033 __invalid_parameter 0042 ___iob_func 004d __lock_file2 0060 __stbuf 0085 __fputwc_nolock 00bb __ftbuf 00d1 __SEH_epilog4 00e2 __unlock_file2"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE FF FF 00 00 89 75 E4 33 C0 33 DB 39 5D 08 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 8F 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 5D FC E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 89 45 E0 8B 45 08 0F B7 00 66 3B C3 74 21 0F B7 F8 83 45 08 02 E8 ?? ?? ?? ?? 83 C0 20 50 57 E8 ?? ?? ?? ?? 59 59 8B CE 66 3B C1 74 1C EB D4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 59 59 66 3B C6 74 03 89 5D E4 E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 E0 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__tsopen_nolock"
		size = 1823
		refs = "003d __get_fmode 004c __invoke_watson 008a ___doserrno 0094 __errno 00a3 __invalid_parameter 0191 __umaskval 01e7 __alloc_osfhnd 0211 __imp__CreateFileA@28 027c ___pioinfo 028f __imp__GetLastError@0 0295 __dosmaperr 02ab __imp__GetFileType@4 02e2 __imp__CloseHandle@4 0311 __set_osfhnd 0378 __lseek_nolock 0396 __close_nolock 03ab __read_nolock 03c5 __chsize_nolock 04e2 __lseeki64_nolock 0603 __write 06f7 __free_osfhnd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 33 DB F6 45 10 80 56 57 8B F0 89 5D E0 88 5D FE C7 45 D0 0C 00 00 00 89 5D D4 74 09 89 5D D8 C6 45 FF 10 EB 0A C7 45 D8 01 00 00 00 88 5D FF 8D 45 E0 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 10 B8 00 80 00 00 85 C8 75 11 F7 C1 00 40 07 00 75 05 39 45 E0 74 04 80 4D FF 80 8B C1 83 E0 03 2B C3 BA 00 00 00 C0 BF 00 00 00 80 74 47 48 74 2E 48 74 26 E8 ?? ?? ?? ?? 89 18 83 0E FF E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 00 05 00 00 89 55 F8 EB 19 F6 C1 08 74 08 F7 C1 00 00 07 00 75 EE C7 45 F8 00 00 00 40 EB 03 89 7D F8 8B 45 14 6A 10 59 2B C1 74 37 2B C1 74 2A 2B C1 74 1D 2B C1 74 10 83 E8 40 75 A1 39 7D F8 0F 94 C0 89 45 F0 EB 1E C7 45 F0 03 00 00 00 EB 15 C7 45 F0 02 00 00 00 EB 0C C7 45 F0 01 00 00 00 EB 03 89 5D F0 8B 45 10 BA 00 07 00 00 23 C2 B9 00 04 00 00 3B C1 BF 00 01 00 00 7F 3B 74 30 3B C3 74 2C 3B C7 74 1F 3D 00 02 00 00 0F 84 94 00 00 00 3D 00 03 00 00 0F 85 40 FF FF FF C7 45 EC 02 00 00 00 EB 2F C7 45 EC 04 00 00 00 EB 26 C7 45 EC 03 00 00 00 EB 1D 3D 00 05 00 00 74 0F 3D 00 06 00 00 74 60 3B C2 0F 85 0F FF FF FF C7 45 EC 01 00 00 00 8B 45 10 C7 45 F4 80 00 00 00 85 C7 74 16 8B 0D ?? ?? ?? ?? F7 D1 23 4D 18 84 C9 78 07 C7 45 F4 01 00 00 00 A8 40 74 12 81 4D F4 00 00 00 04 81 4D F8 00 00 01 00 83 4D F0 04 A9 00 10 00 00 74 03 09 7D F4 A8 20 74 12 81 4D F4 00 00 00 08 EB 14 C7 45 EC 05 00 00 00 EB A6 A8 10 74 07 81 4D F4 00 00 00 10 E8 ?? ?? ?? ?? 89 06 83 F8 FF 75 1A E8 ?? ?? ?? ?? 89 18 83 0E FF E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 8E 00 00 00 8B 45 08 8B 3D ?? ?? ?? ?? 53 FF 75 F4 C7 00 01 00 00 00 FF 75 EC 8D 45 D0 50 FF 75 F0 FF 75 F8 FF 75 0C FF D7 89 45 E4 83 F8 FF 75 6D 8B 4D F8 B8 00 00 00 C0 23 C8 3B C8 75 2B F6 45 10 01 74 25 81 65 F8 FF FF FF 7F 53 FF 75 F4 8D 45 D0 FF 75 EC 50 FF 75 F0 FF 75 F8 FF 75 0C FF D7 89 45 E4 83 F8 FF 75 34 8B 36 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FE FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 E9 74 04 00 00 FF 75 E4 FF 15 ?? ?? ?? ?? 3B C3 75 44 8B 36 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FE FF 15 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 FF 75 E4 FF 15 ?? ?? ?? ?? 3B F3 75 B0 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB A3 83 F8 02 75 06 80 4D FF 40 EB 09 83 F8 03 75 04 80 4D FF 08 FF 75 E4 FF 36 E8 ?? ?? ?? ?? 8B 06 8B D0 83 E0 1F C1 FA 05 8B 14 95 ?? ?? ?? ?? 59 C1 E0 06 59 8A 4D FF 80 C9 01 88 4C 02 04 8B 06 8B D0 83 E0 1F C1 FA 05 8B 14 95 ?? ?? ?? ?? C1 E0 06 8D 44 02 24 80 20 80 88 4D FD 80 65 FD 48 88 4D FF 0F 85 80 00 00 00 F6 C1 80 0F 84 B1 02 00 00 F6 45 10 02 74 71 6A 02 83 CF FF 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E8 3B C7 75 19 E8 ?? ?? ?? ?? 81 38 83 00 00 00 74 4D FF 36 E8 ?? ?? ?? ?? E9 FA FE FF FF 6A 01 8D 45 FC 50 FF 36 88 5D FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1A 80 7D FC 1A 75 14 8B 45 E8 99 52 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 C3 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 B3 F6 45 FF 80 0F 84 30 02 00 00 BF 00 40 07 00 B9 00 40 00 00 85 7D 10 75 0F 8B 45 E0 23 C7 75 05 09 4D 10 EB 03 09 45 10 8B 45 10 23 C7 3B C1 74 44 3D 00 00 01 00 74 29 3D 00 40 01 00 74 22 3D 00 00 02 00 74 29 3D 00 40 02 00 74 22 3D 00 00 04 00 74 07 3D 00 40 04 00 75 1D C6 45 FE 01 EB 17 8B 4D 10 B8 01 03 00 00 23 C8 3B C8 75 09 C6 45 FE 02 EB 03 88 5D FE F7 45 10 00 00 07 00 0F 84 B5 01 00 00 F6 45 FF 40 89 5D E8 0F 85 A8 01 00 00 8B 45 F8 B9 00 00 00 C0 23 C1 3D 00 00 00 40 0F 84 B7 00 00 00 3D 00 00 00 80 74 77 3B C1 0F 85 84 01 00 00 8B 45 EC 3B C3 0F 86 79 01 00 00 83 F8 02 76 0E 83 F8 04 76 30 83 F8 05 0F 85 66 01 00 00 0F BE 45 FE 33 FF 48 0F 84 26 01 00 00 48 0F 85 52 01 00 00 C7 45 E8 FF FE 00 00 C7 45 EC 02 00 00 00 E9 1A 01 00 00 6A 02 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 10 0B C2 74 C7 53 53 53 FF 36 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 8E FE FF FF 6A 03 8D 45 E8 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 75 FE FF FF 83 F8 02 74 6B 83 F8 03 0F 85 AD 00 00 00 81 7D E8 EF BB BF 00 75 59 C6 45 FE 01 E9 DC 00 00 00 8B 45 EC 3B C3 0F 86 D1 00 00 00 83 F8 02 0F 86 62 FF FF FF 83 F8 04 0F 87 50 FF FF FF 6A 02 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 10 0B C2 0F 84 43 FF FF FF 53 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 10 23 C2 83 F8 FF 0F 85 91 00 00 00 E9 05 FE FF FF 8B 45 E8 25 FF FF 00 00 3D FE FF 00 00 75 19 FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 6A 16 5E 89 30 8B C6 E9 64 01 00 00 3D FF FE 00 00 75 1C 53 6A 02 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 C0 FD FF FF C6 45 FE 02 EB 41 53 53 FF 36 E8 ?? ?? ?? ?? 83 C4 0C EB 99 C7 45 E8 EF BB BF 00 C7 45 EC 03 00 00 00 8B 45 EC 2B C7 50 8D 44 3D E8 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 80 FD FF FF 03 F8 39 7D EC 7F DB 8B 06 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 8D 44 01 24 8A 08 32 4D FE 80 E1 7F 30 08 8B 06 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 8D 44 01 24 8B 4D 10 8A 10 C1 E9 10 C0 E1 07 80 E2 7F 0A CA 88 08 38 5D FD 75 21 F6 45 10 08 74 1B 8B 06 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 8D 44 01 04 80 08 20 8B 7D F8 B8 00 00 00 C0 8B CF 23 C8 3B C8 75 7C F6 45 10 01 74 76 FF 75 E4 FF 15 ?? ?? ?? ?? 53 FF 75 F4 8D 45 D0 6A 03 50 FF 75 F0 81 E7 FF FF FF 7F 57 FF 75 0C FF 15 ?? ?? ?? ?? 83 F8 FF 75 34 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 06 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 8D 44 01 04 80 20 FE FF 36 E8 ?? ?? ?? ?? 59 E9 98 FB FF FF 8B 36 8B CE C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E6 1F C1 E6 06 89 04 0E 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "__open"
		size = 182
		refs = "0003 __sehtable$__open 0008 __SEH_prolog4 0022 __errno 0032 __invalid_parameter 0054 __tsopen_nolock 0098 ___pioinfo 00a7 __unlock_fhandle 00b1 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 F6 89 75 E0 33 C0 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 72 89 75 FC FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E0 50 8D 45 E4 E8 ?? ?? ?? ?? 83 C4 14 89 45 DC C7 45 FC FE FF FF FF E8 12 00 00 00 8B 7D DC 3B FE 74 3C E8 ?? ?? ?? ?? 89 38 EB BF 33 F6 39 75 E0 74 2B 39 75 DC 74 1D 8B 45 E4 C1 F8 05 8B 4D E4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_798_2_0 {
	meta:
		name = "__wopen"
		size = 182
		refs = "0003 __sehtable$__wopen 0008 __SEH_prolog4 0022 __errno 0032 __invalid_parameter 0054 __tsopen_nolock 0098 ___pioinfo 00a7 __unlock_fhandle 00b1 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 F6 89 75 E0 33 C0 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 72 89 75 FC FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E0 50 8D 45 E4 E8 ?? ?? ?? ?? 83 C4 14 89 45 DC C7 45 FC FE FF FF FF E8 12 00 00 00 8B 7D DC 3B FE 74 3C E8 ?? ?? ?? ?? 89 38 EB BF 33 F6 39 75 E0 74 2B 39 75 DC 74 1D 8B 45 E4 C1 F8 05 8B 4D E4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_168_3_0 {
	meta:
		name = "__sopen_helper"
		size = 204
		refs = "0003 __sehtable$__sopen_helper 0008 __SEH_prolog4 0020 __errno 002f __invalid_parameter 0073 __tsopen_nolock 0094 __SEH_epilog4 00b8 ___pioinfo 00c6 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 33 C0 8B 7D 18 3B FE 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 59 83 0F FF 33 C0 39 75 08 0F 95 C0 3B C6 74 D6 39 75 1C 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 C2 89 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 8D 45 E4 50 8B C7 E8 ?? ?? ?? ?? 83 C4 14 89 45 E0 C7 45 FC FE FF FF FF E8 15 00 00 00 8B 45 E0 3B C6 74 03 83 0F FF E8 ?? ?? ?? ?? C3 33 F6 8B 7D 18 39 75 E4 74 28 39 75 E0 74 1B 8B 07 8B C8 C1 F9 05 83 E0 1F C1 E0 06 8B 0C 8D ?? ?? ?? ?? 8D 44 01 04 80 20 FE FF 37 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_798_3_0 {
	meta:
		name = "__wsopen_helper"
		size = 204
		refs = "0003 __sehtable$__wsopen_helper 0008 __SEH_prolog4 0020 __errno 002f __invalid_parameter 0073 __tsopen_nolock 0094 __SEH_epilog4 00b8 ___pioinfo 00c6 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 33 C0 8B 7D 18 3B FE 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 59 83 0F FF 33 C0 39 75 08 0F 95 C0 3B C6 74 D6 39 75 1C 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 C2 89 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 8D 45 E4 50 8B C7 E8 ?? ?? ?? ?? 83 C4 14 89 45 E0 C7 45 FC FE FF FF FF E8 15 00 00 00 8B 45 E0 3B C6 74 03 83 0F FF E8 ?? ?? ?? ?? C3 33 F6 8B 7D 18 39 75 E4 74 28 39 75 E0 74 1B 8B 07 8B C8 C1 F9 05 83 E0 1F C1 E0 06 8B 0C 8D ?? ?? ?? ?? 8D 44 01 04 80 20 FE FF 37 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_168_4_0 {
	meta:
		name = "__sopen"
		size = 50
		refs = "001d __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_798_4_0 {
	meta:
		name = "__wsopen"
		size = 50
		refs = "001d __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_168_5_0 {
	meta:
		name = "__sopen_s"
		size = 32
		refs = "0017 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_798_5_0 {
	meta:
		name = "__wsopen_s"
		size = 32
		refs = "0017 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_170_3_0 {
	meta:
		name = "__mbschr_l"
		size = 188
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e __errno 002e __invalid_parameter 0053 _strchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 33 DB 3B C3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 74 56 8B 75 F4 39 5E 08 75 3A FF 75 0C 50 E8 ?? ?? ?? ?? 59 59 EB 41 0F B6 D1 F6 44 32 1D 04 74 1A 40 8A 10 3A D3 74 3E 0F B7 C9 0F B6 D2 C1 E1 08 0B CA 39 4D 0C 75 0B 48 EB 1D 0F B7 D1 39 55 0C 74 0D 40 66 0F B6 08 0F B7 C9 66 3B CB 75 C7 0F B7 C9 39 4D 0C 75 0E 38 5D FC 74 17 8B 4D F8 83 61 70 FD EB 0E 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__spawnlp"
		size = 78
		refs = "0010 __errno 0020 __invalid_parameter 0044 __spawnvp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 1F 38 19 74 DF 8B 45 10 3B C3 74 D8 38 18 74 D4 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_174_3_0 {
	meta:
		name = "__ismbcdigit_l"
		size = 199
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006a ___crtGetStringTypeA 00a1 __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6E 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 73 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 0B F6 45 FC 04 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 2E 8B 45 EC 83 B8 AC 00 00 00 01 7E 11 8D 45 EC 50 6A 04 51 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8B 80 C8 00 00 00 0F B7 04 48 83 E0 04 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__EH_prolog3"
		size = 51
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "__EH_prolog3_catch"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_178_2_0 {
	meta:
		name = "__EH_prolog3_GS"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_178_3_0 {
	meta:
		name = "__EH_prolog3_catch_GS"
		size = 57
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 EC 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_178_4_0 {
	meta:
		name = "__EH_epilog3"
		size = 20
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__mbsinc_l"
		size = 39
		refs = "0011 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 0F B6 06 FF 75 0C 50 E8 ?? ?? ?? ?? 59 46 59 85 C0 74 06 80 3E 00 74 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "__mbsinc"
		size = 70
		refs = "0011 __errno 0021 __invalid_parameter 0031 __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 16 0F B6 06 50 E8 ?? ?? ?? ?? 46 59 85 C0 74 05 38 1E 74 01 46 8B C6 5E 5B 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "___libm_sse2_log10"
		size = 574
		refs = "0024 _emask 002c _CC 0034 _One 003c _Magic 0044 _hi_mask 0062 _CB_Tbl 006a _T_Tbl 00cc _coeff 00f8 _LOG10_2 0104 _place_LR 015e _Zero 01b2 _Infs 01e1 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 B1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 1B FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_183_3_0 {
	meta:
		name = "___check_float_string"
		size = 87
		refs = "0017 __calloc_crt 0038 _memcpy 0043 __recalloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 8B 06 39 45 08 75 46 8B 0F 6A 02 50 3B 4D 0C 75 2B E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 5D C3 8B 45 10 C7 00 01 00 00 00 FF 36 FF 75 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D5 89 07 D1 26 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_183_5_0 {
	meta:
		name = "__hextodec"
		size = 32
		refs = "000b _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 08 50 E8 ?? ?? ?? ?? 85 C0 0F BE 45 08 59 75 06 83 E0 DF 83 E8 07 5D C3 }
	condition:
		$1
}

rule file_183_7_0 {
	meta:
		name = "__un_inc"
		size = 19
		refs = "000d __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_193_7_0 {
	meta:
		name = "__un_inc"
		size = 19
		refs = "000d __ungetc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_183_8_0 {
	meta:
		name = "__whiteout"
		size = 35
		refs = "0006 __getche_nolock 0016 _isspace"
	strings:
		$1 = { 8B FF 53 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 E4 8B C3 5B C3 }
	condition:
		$1
}

rule file_183_9_0 {
	meta:
		name = "__cprinput_l"
		size = 3602
		refs = "000c ___security_cookie 0051 __errno 0061 __invalid_parameter 007a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00a3 _isspace 00b9 __whiteout 00bf __un_inc 0147 _isdigit 02c1 __getche_nolock 0402 ___check_float_string 06da __cfltcvt_tab 06df __decode_pointer 07d0 _isleadbyte 0816 __mbtowc_l 08b4 _memset 0b54 __allmul 0b67 _isxdigit 0b8a __hextodec 0de6 _free 0e0c @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F8 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 57 33 FF 8B F1 89 85 1C FE FF FF 8D 85 7C FE FF FF 89 85 5C FE FF FF C7 85 30 FE FF FF 5E 01 00 00 89 BD 40 FE FF FF 89 BD 20 FE FF FF 89 BD 74 FE FF FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 94 0D 00 00 FF 75 08 8D 8D 08 FE FF FF E8 ?? ?? ?? ?? 8A 06 C6 85 66 FE FF FF 00 89 BD 78 FE FF FF 89 BD 3C FE FF FF 84 C0 0F 84 50 0D 00 00 8B FE 53 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 2C FF 8D 78 FE FF FF 8D B5 78 FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 E9 D3 0C 00 00 8A 07 3C 25 0F 85 87 0C 00 00 38 47 01 0F 84 70 0C 00 00 33 C0 89 85 24 FE FF FF 88 85 3B FE FF FF 89 85 54 FE FF FF 89 85 50 FE FF FF 89 85 6C FE FF FF 88 85 68 FE FF FF 88 85 67 FE FF FF 88 85 6A FE FF FF 88 85 5B FE FF FF 88 85 69 FE FF FF 88 85 73 FE FF FF C6 85 6B FE FF FF 01 89 85 34 FE FF FF 33 F6 47 0F B6 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 6C FE FF FF FF 85 50 FE FF FF 6B C0 0A 8D 44 18 D0 89 85 6C FE FF FF E9 C5 00 00 00 83 FB 4E 0F 8F 83 00 00 00 0F 84 B6 00 00 00 83 FB 2A 74 70 83 FB 46 0F 84 A8 00 00 00 83 FB 49 74 10 83 FB 4C 75 74 FE 85 6B FE FF FF E9 93 00 00 00 8A 4F 01 80 F9 36 75 1E 8D 47 02 80 38 34 75 16 FF 85 34 FE FF FF 8B F8 89 B5 44 FE FF FF 89 B5 48 FE FF FF EB 6D 80 F9 33 75 0C 8D 47 02 80 38 32 75 04 8B F8 EB 5C 80 F9 64 74 57 80 F9 69 74 52 80 F9 6F 74 4D 80 F9 78 74 48 80 F9 58 75 19 EB 41 FE 85 6A FE FF FF EB 39 83 FB 68 74 28 83 FB 6C 74 0D 83 FB 77 74 16 FE 85 5B FE FF FF EB 22 8D 47 01 80 38 6C 74 97 FE 85 6B FE FF FF FE 85 73 FE FF FF EB 0C FE 8D 6B FE FF FF FE 8D 73 FE FF FF 80 BD 5B FE FF FF 00 0F 84 FE FE FF FF 80 BD 6A FE FF FF 00 89 BD 2C FE FF FF 75 19 8B 85 1C FE FF FF 8B 30 89 85 18 FE FF FF 83 C0 04 89 85 1C FE FF FF EB 02 33 F6 32 DB 89 B5 4C FE FF FF 38 9D 73 FE FF FF 75 18 8A 07 3C 53 74 0B C6 85 73 FE FF FF FF 3C 43 75 07 C6 85 73 FE FF FF 01 0F B6 07 83 C8 20 89 85 60 FE FF FF 83 F8 6E 74 3D 83 F8 63 74 12 83 F8 7B 74 0D 8D B5 78 FE FF FF E8 ?? ?? ?? ?? EB 0B FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 83 F8 FF 0F 84 01 0B 00 00 8B B5 4C FE FF FF 8B BD 2C FE FF FF 8B 8D 50 FE FF FF 85 C9 74 0D 83 BD 6C FE FF FF 00 0F 84 C0 0A 00 00 8B 85 60 FE FF FF 83 F8 6F 0F 8F 28 05 00 00 0F 84 93 07 00 00 83 F8 63 0F 84 D9 03 00 00 6A 64 5A 3B C2 0F 84 7F 07 00 00 0F 8E 30 05 00 00 83 F8 67 7E 45 83 F8 69 74 21 83 F8 6E 0F 85 1D 05 00 00 80 BD 6A FE FF FF 00 8B BD 78 FE FF FF 0F 84 D4 09 00 00 E9 FB 09 00 00 89 95 60 FE FF FF 83 BD 74 FE FF FF 2D 0F 85 EA 05 00 00 C6 85 67 FE FF FF 01 E9 E7 05 00 00 33 DB 83 BD 74 FE FF FF 2D 75 0C 8B 85 5C FE FF FF C6 00 2D 43 EB 09 83 BD 74 FE FF FF 2B 75 17 FF 8D 6C FE FF FF FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 83 BD 50 FE FF FF 00 75 07 83 8D 6C FE FF FF FF 0F B6 85 74 FE FF FF EB 65 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 60 8A 85 74 FE FF FF 8B 8D 5C FE FF FF FF 85 54 FE FF FF 88 04 0B 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 30 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C4 09 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 8B 85 08 FE FF FF 8B 80 BC 00 00 00 8B 00 8A 00 88 85 68 FE FF FF 3A 85 74 FE FF FF 0F 85 D9 00 00 00 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 C5 00 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 8B 8D 5C FE FF FF 89 85 74 FE FF FF 8A 85 68 FE FF FF 88 04 0B 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 30 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 23 09 00 00 0F B6 85 74 FE FF FF EB 65 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 60 8B 85 5C FE FF FF 8A 8D 74 FE FF FF FF 85 54 FE FF FF 88 0C 03 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 30 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C9 08 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 83 BD 54 FE FF FF 00 0F 84 4D 01 00 00 83 BD 74 FE FF FF 65 74 0D 83 BD 74 FE FF FF 45 0F 85 37 01 00 00 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 23 01 00 00 8B 85 5C FE FF FF C6 04 03 65 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 30 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 3D 08 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 83 F8 2D 75 2C 8B 85 5C FE FF FF C6 04 03 2D 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 FD 07 00 00 EB 09 83 BD 74 FE FF FF 2B 75 29 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 75 08 21 85 6C FE FF FF EB 11 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 0F B6 85 74 FE FF FF EB 65 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 60 8B 85 5C FE FF FF 8A 8D 74 FE FF FF FF 85 54 FE FF FF 88 0C 03 8D 85 40 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 30 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 6F 07 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 FF B5 74 FE FF FF FF 8D 78 FE FF FF E8 ?? ?? ?? ?? 83 BD 54 FE FF FF 00 59 0F 84 31 07 00 00 80 BD 6A FE FF FF 00 0F 85 9B 06 00 00 8B 85 5C FE FF FF FF 85 3C FE FF FF 8D 8D 08 FE FF FF 51 50 FF B5 4C FE FF FF C6 04 03 00 0F BE 85 6B FE FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 C4 10 E9 5E 06 00 00 85 C9 75 10 FF 85 6C FE FF FF C7 85 50 FE FF FF 01 00 00 00 80 BD 73 FE FF FF 00 7E 07 C6 85 69 FE FF FF 01 FF B5 74 FE FF FF FF 8D 78 FE FF FF 8B FE E8 ?? ?? ?? ?? 59 83 BD 50 FE FF FF 00 74 14 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 06 03 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 83 BD 60 FE FF FF 63 89 85 74 FE FF FF 74 4E 83 BD 60 FE FF FF 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E C8 02 00 00 83 F8 20 75 32 83 BD 60 FE FF FF 7B 0F 85 B6 02 00 00 0F BE 9D 68 FE FF FF 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 4C 0D DC 33 CB 85 D1 0F 84 91 02 00 00 80 BD 6A FE FF FF 00 0F 85 7E 02 00 00 80 BD 69 FE FF FF 00 0F 84 63 02 00 00 88 85 28 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 11 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 88 85 29 FE FF FF 8D 85 08 FE FF FF 50 8B 85 08 FE FF FF C7 85 20 FE FF FF 3F 00 00 00 FF B0 AC 00 00 00 8D 85 28 FE FF FF 50 8D 85 20 FE FF FF 50 E8 ?? ?? ?? ?? 66 8B 85 20 FE FF FF 83 C4 10 66 89 06 46 46 E9 FD 01 00 00 83 E8 70 0F 84 61 02 00 00 83 E8 03 0F 84 C2 FE FF FF 48 48 0F 84 57 02 00 00 83 E8 03 0F 84 06 FB FF FF 83 E8 03 74 33 0F B6 07 3B 85 74 FE FF FF 0F 85 52 05 00 00 FE 8D 66 FE FF FF 80 BD 6A FE FF FF 00 0F 85 D4 04 00 00 8B 85 18 FE FF FF 89 85 1C FE FF FF E9 C3 04 00 00 80 BD 73 FE FF FF 00 7E 07 C6 85 69 FE FF FF 01 47 80 3F 5E 8B F7 75 0A 8D 77 01 C6 85 68 FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 09 B2 5D 46 C6 45 E7 20 EB 66 8A 95 3B FE FF FF EB 5E 46 3C 2D 75 42 84 D2 74 3E 8A 0E 80 F9 5D 74 37 46 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 22 2A C2 FE C0 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 47 4A 75 E8 32 D2 EB 17 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 44 05 DC 08 18 8A 06 3C 5D 75 9C 84 C0 0F 84 98 04 00 00 89 B5 2C FE FF FF 8B B5 4C FE FF FF E9 C4 FD FF FF 83 BD 74 FE FF FF 2B 75 21 FF 8D 6C FE FF FF 75 08 85 C9 74 04 B3 01 EB 11 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 6A 30 5E 39 B5 74 FE FF FF 0F 85 54 01 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 3C 78 74 51 3C 58 74 4D 83 BD 60 FE FF FF 78 C7 85 54 FE FF FF 01 00 00 00 74 22 83 BD 50 FE FF FF 00 74 0A FF 8D 6C FE FF FF 75 02 FE C3 C7 85 60 FE FF FF 6F 00 00 00 E9 06 01 00 00 FF 8D 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 89 B5 74 FE FF FF E9 EE 00 00 00 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 83 BD 50 FE FF FF 00 89 85 74 FE FF FF 74 12 83 AD 6C FE FF FF 02 83 BD 6C FE FF FF 01 7D 02 FE C3 C7 85 60 FE FF FF 78 00 00 00 E9 B3 00 00 00 88 06 46 89 B5 4C FE FF FF E9 F0 FC FF FF 47 E9 EA FC FF FF FF 8D 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 3B FE 0F 84 84 03 00 00 80 BD 6A FE FF FF 00 0F 85 EE 02 00 00 FF 85 3C FE FF FF 83 BD 60 FE FF FF 63 0F 84 DB 02 00 00 80 BD 69 FE FF FF 00 74 10 8B 8D 4C FE FF FF 33 C0 66 89 01 E9 C2 02 00 00 8B 85 4C FE FF FF C6 00 00 E9 B4 02 00 00 C6 85 6B FE FF FF 01 83 BD 74 FE FF FF 2D 75 09 C6 85 67 FE FF FF 01 EB 09 83 BD 74 FE FF FF 2B 75 21 FF 8D 6C FE FF FF 75 08 85 C9 74 04 B3 01 EB 11 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF 83 BD 34 FE FF FF 00 0F 84 3D 01 00 00 84 DB 0F 85 FE 00 00 00 83 BD 60 FE FF FF 78 74 65 83 BD 60 FE FF FF 70 74 5C 0F B6 85 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 C4 00 00 00 83 BD 60 FE FF FF 6F 75 22 83 BD 74 FE FF FF 38 0F 8D AE 00 00 00 8B B5 44 FE FF FF 8B BD 48 FE FF FF 0F A4 F7 03 C1 E6 03 EB 52 6A 00 6A 0A FF B5 48 FE FF FF FF B5 44 FE FF FF E8 ?? ?? ?? ?? 8B F0 8B FA EB 37 0F B6 85 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6C 8B B5 44 FE FF FF 8B BD 48 FE FF FF FF B5 74 FE FF FF 0F A4 F7 04 C1 E6 04 E8 ?? ?? ?? ?? 59 89 85 74 FE FF FF 8B 85 74 FE FF FF FF 85 54 FE FF FF 83 C0 D0 99 03 F0 13 FA 83 BD 50 FE FF FF 00 89 B5 44 FE FF FF 89 BD 48 FE FF FF 74 08 FF 8D 6C FE FF FF 74 28 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF E9 14 FF FF FF FF B5 74 FE FF FF FF 8D 78 FE FF FF E8 ?? ?? ?? ?? 59 80 BD 67 FE FF FF 00 8B BD 24 FE FF FF 0F 84 ED 00 00 00 8B 85 44 FE FF FF 8B 8D 48 FE FF FF F7 D8 83 D1 00 F7 D9 89 85 44 FE FF FF 89 8D 48 FE FF FF E9 C9 00 00 00 8B BD 24 FE FF FF 84 DB 0F 85 B0 00 00 00 83 BD 60 FE FF FF 78 74 37 83 BD 60 FE FF FF 70 74 2E 0F B6 85 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 83 BD 60 FE FF FF 6F 75 0E 83 BD 74 FE FF FF 38 7D 68 C1 E7 03 EB 2C 6B FF 0A EB 27 0F B6 85 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 4C FF B5 74 FE FF FF C1 E7 04 E8 ?? ?? ?? ?? 59 89 85 74 FE FF FF FF 85 54 FE FF FF 83 BD 50 FE FF FF 00 8B 85 74 FE FF FF 8D 7C 07 D0 74 08 FF 8D 6C FE FF FF 74 28 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 89 85 74 FE FF FF E9 62 FF FF FF FF B5 74 FE FF FF FF 8D 78 FE FF FF E8 ?? ?? ?? ?? 59 80 BD 67 FE FF FF 00 74 02 F7 DF 83 BD 60 FE FF FF 46 75 07 83 A5 54 FE FF FF 00 83 BD 54 FE FF FF 00 0F 84 CA 00 00 00 80 BD 6A FE FF FF 00 75 38 FF 85 3C FE FF FF 8B B5 4C FE FF FF 83 BD 34 FE FF FF 00 74 13 8B 85 44 FE FF FF 89 06 8B 85 48 FE FF FF 89 46 04 EB 10 80 BD 6B FE FF FF 00 74 04 89 3E EB 03 66 89 3E 8B BD 2C FE FF FF FE 85 66 FE FF FF 47 EB 50 3C 25 75 0A 8D 47 01 80 38 25 75 02 8B F8 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 89 9D 74 FE FF FF 3B C3 75 40 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 19 FF 85 78 FE FF FF E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 75 22 FF 8D 78 FE FF FF 8A 07 84 C0 0F 85 E9 F2 FF FF EB 1E FF B5 74 FE FF FF E8 ?? ?? ?? ?? EB 10 53 EB F6 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 83 BD 40 FE FF FF 01 5B 75 0C FF B5 5C FE FF FF E8 ?? ?? ?? ?? 59 80 BD 14 FE FF FF 00 74 0A 8B 85 10 FE FF FF 83 60 70 FD 8B 85 3C FE FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 0B 83 E9 01 75 D1 33 C9 3A E0 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "___dtold"
		size = 189
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 55 0C 0F B7 42 06 53 8B C8 56 57 C1 E9 04 25 00 80 00 00 BF FF 07 00 00 23 CF 89 45 0C 8B 42 04 8B 12 0F B7 D9 BE 00 00 00 80 25 FF FF 0F 00 89 75 FC 85 DB 74 13 3B DF 74 08 81 C1 00 3C 00 00 EB 28 BF FF 7F 00 00 EB 24 33 DB 3B C3 75 12 3B D3 75 0E 8B 45 08 66 8B 4D 0C 89 58 04 89 18 EB 4C 81 C1 01 3C 00 00 89 5D FC 0F B7 F9 8B CA C1 E9 15 C1 E0 0B 0B C8 0B 4D FC 8B 45 08 C1 E2 0B 89 48 04 89 10 85 CE 75 1F 8B 08 8B 50 04 8B D9 03 D2 C1 EB 1F 0B D3 03 C9 81 C7 FF FF 00 00 89 50 04 89 08 85 D6 74 E1 8B 4D 0C 0B CF 5F 5E 66 89 48 08 5B C9 C3 }
	condition:
		$1
}

rule file_187_2_0 {
	meta:
		name = "__fltout2"
		size = 144
		refs = "0009 ___security_cookie 0027 ___dtold 0042 _$I10_OUTPUT 0062 _strcpy_s 0075 __invoke_watson 008a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 8B 5D 10 56 89 45 D0 57 8D 45 08 50 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 8D 45 D4 50 6A 00 6A 11 83 EC 0C 8D 75 F0 8B FC A5 A5 66 A5 E8 ?? ?? ?? ?? 8B 75 D0 89 43 08 0F BE 45 D6 89 03 0F BF 45 D4 89 43 04 8D 45 D8 50 FF 75 18 56 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D FC 5F 89 73 0C 5E 8B C3 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_188_3_0 {
	meta:
		name = "__isleadbyte_l"
		size = 56
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 45 08 8B 4D F0 8B 89 C8 00 00 00 0F B7 04 41 25 00 80 00 00 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_188_5_0 {
	meta:
		name = "__iswalpha_l"
		size = 26
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_6_0 {
	meta:
		name = "_iswalpha"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_7_0 {
	meta:
		name = "__iswupper_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_8_0 {
	meta:
		name = "_iswupper"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_9_0 {
	meta:
		name = "__iswlower_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_10_0 {
	meta:
		name = "_iswlower"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_11_0 {
	meta:
		name = "__iswdigit_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 04 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_12_0 {
	meta:
		name = "_iswdigit"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 04 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_13_0 {
	meta:
		name = "__iswxdigit_l"
		size = 26
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_14_0 {
	meta:
		name = "_iswxdigit"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_15_0 {
	meta:
		name = "__iswspace_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 08 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_16_0 {
	meta:
		name = "_iswspace"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_17_0 {
	meta:
		name = "__iswpunct_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_18_0 {
	meta:
		name = "_iswpunct"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_313_9_0 {
	meta:
		name = "_tmpfile_s"
		size = 19
		refs = "000b __tmpfile_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_19_0 {
	meta:
		name = "__iswalnum_l"
		size = 26
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_20_0 {
	meta:
		name = "_iswalnum"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_21_0 {
	meta:
		name = "__iswprint_l"
		size = 26
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_22_0 {
	meta:
		name = "_iswprint"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_23_0 {
	meta:
		name = "__iswgraph_l"
		size = 26
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_24_0 {
	meta:
		name = "_iswgraph"
		size = 22
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_25_0 {
	meta:
		name = "__iswcntrl_l"
		size = 23
		refs = "000e __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 20 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_26_0 {
	meta:
		name = "_iswcntrl"
		size = 19
		refs = "000b _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 6A 20 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_188_27_0 {
	meta:
		name = "_iswascii"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC B8 80 00 00 00 66 39 45 08 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_188_28_0 {
	meta:
		name = "__iswcsym_l"
		size = 42
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_188_29_0 {
	meta:
		name = "___iswcsym"
		size = 38
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_188_30_0 {
	meta:
		name = "__iswcsymf_l"
		size = 42
		refs = "0011 __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_188_31_0 {
	meta:
		name = "___iswcsymf"
		size = 38
		refs = "000e _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_strncmp"
		size = 192
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 53 8B 5D 10 85 DB 75 07 33 C0 E9 9A 00 00 00 57 83 FB 04 72 75 8D 7B FC 85 FF 76 6E 8B 4D 0C 8B 45 08 8A 10 83 C0 04 83 C1 04 84 D2 74 52 3A 51 FC 75 4D 8A 50 FD 84 D2 74 3C 3A 51 FD 75 37 8A 50 FE 84 D2 74 26 3A 51 FE 75 21 8A 50 FF 84 D2 74 10 3A 51 FF 75 0B 83 45 FC 04 39 7D FC 72 C2 EB 3F 0F B6 40 FF 0F B6 49 FF EB 46 0F B6 40 FE 0F B6 49 FE EB 3C 0F B6 40 FD 0F B6 49 FD EB 32 0F B6 40 FC 0F B6 49 FC EB 28 8B 4D 0C 8B 45 08 EB 0F 8A 10 84 D2 74 14 3A 11 75 10 40 41 FF 45 FC 39 5D FC 72 EC 33 C0 5F 5B C9 C3 0F B6 00 0F B6 09 2B C1 EB F2 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__read_nolock"
		size = 1474
		refs = "001d ___doserrno 0025 __errno 0040 __nhandle 005e __invalid_parameter 0076 ___pioinfo 012b __malloc_crt 015d __lseeki64_nolock 01ff __imp__ReadFile@20 02c1 __imp__GetLastError@0 0375 __lookuptrailbytes 03fb __imp__MultiByteToWideChar@24 040e __dosmaperr 0421 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 55 10 56 8B 75 08 6A FE 58 89 45 EC 89 55 E4 3B F0 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 88 05 00 00 53 33 DB 3B F3 7C 08 3B 35 ?? ?? ?? ?? 72 27 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 51 05 00 00 8B C6 C1 F8 05 57 8D 3C 85 ?? ?? ?? ?? 8B 07 83 E6 1F C1 E6 06 03 C6 8A 48 04 F6 C1 01 75 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 6A 81 FA FF FF FF 7F 77 50 89 5D F0 3B D3 0F 84 08 05 00 00 F6 C1 02 0F 85 FF 04 00 00 39 5D 0C 74 37 8A 40 24 02 C0 D0 F8 88 45 FE 0F BE C0 48 6A 04 59 74 1C 48 75 0E 8B C2 F7 D0 A8 01 74 19 83 E2 FE 89 55 10 8B 45 0C 89 45 F4 E9 81 00 00 00 8B C2 F7 D0 A8 01 75 21 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 34 8B C2 D1 E8 89 4D 10 3B C1 72 03 89 45 10 FF 75 10 E8 ?? ?? ?? ?? 59 89 45 F4 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 68 04 00 00 6A 01 53 53 FF 75 08 E8 ?? ?? ?? ?? 8B 0F 89 44 0E 28 8B 45 F4 83 C4 10 89 54 0E 2C 8B 0F 03 CE F6 41 04 48 74 74 8A 49 05 80 F9 0A 74 6C 39 5D 10 74 67 88 08 8B 0F 40 FF 4D 10 C7 45 F0 01 00 00 00 C6 44 0E 05 0A 38 5D FE 74 4E 8B 0F 8A 4C 0E 25 80 F9 0A 74 43 39 5D 10 74 3E 88 08 8B 0F 40 FF 4D 10 80 7D FE 01 C7 45 F0 02 00 00 00 C6 44 0E 25 0A 75 24 8B 0F 8A 4C 0E 26 80 F9 0A 74 19 39 5D 10 74 14 88 08 8B 0F 40 FF 4D 10 C7 45 F0 03 00 00 00 C6 44 0E 26 0A 53 8D 4D E8 51 FF 75 10 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 0F 84 7B 03 00 00 8B 4D E8 3B CB 0F 8C 70 03 00 00 3B 4D 10 0F 87 67 03 00 00 8B 07 01 4D F0 8D 44 06 04 F6 00 80 0F 84 E6 01 00 00 80 7D FE 02 0F 84 16 02 00 00 3B CB 74 0D 8B 4D F4 80 39 0A 75 05 80 08 04 EB 03 80 20 FB 8B 5D F4 8B 45 F0 03 C3 89 5D 10 89 45 F0 3B D8 0F 83 D0 00 00 00 8B 4D 10 8A 01 3C 1A 0F 84 AE 00 00 00 3C 0D 74 0C 88 03 43 41 89 4D 10 E9 90 00 00 00 8B 45 F0 48 3B C8 73 17 8D 41 01 80 38 0A 75 0A 41 41 89 4D 10 C6 03 0A EB 75 89 45 10 EB 6D FF 45 10 6A 00 8D 45 E8 50 6A 01 8D 45 FF 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 45 83 7D E8 00 74 3F 8B 07 F6 44 06 04 48 74 14 80 7D FF 0A 74 B9 C6 03 0D 8B 07 8A 4D FF 88 4C 06 05 EB 25 3B 5D F4 75 06 80 7D FF 0A 74 A0 6A 01 6A FF 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 80 7D FF 0A 74 04 C6 03 0D 43 8B 45 F0 39 45 10 0F 82 47 FF FF FF EB 15 8B 07 8D 44 06 04 F6 00 40 75 05 80 08 02 EB 05 8A 01 88 03 43 8B C3 2B 45 F4 80 7D FE 01 89 45 F0 0F 85 D0 00 00 00 85 C0 0F 84 C8 00 00 00 4B 8A 0B 84 C9 78 06 43 E9 86 00 00 00 33 C0 40 0F B6 C9 EB 0F 83 F8 04 7F 13 3B 5D F4 72 0E 4B 0F B6 0B 40 80 B9 ?? ?? ?? ?? 00 74 E8 8A 13 0F B6 CA 0F BE 89 ?? ?? ?? ?? 85 C9 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 7A 41 3B C8 75 04 03 D8 EB 40 8B 0F 03 CE F6 41 04 48 74 24 43 83 F8 02 88 51 05 7C 09 8A 13 8B 0F 88 54 0E 25 43 83 F8 03 75 09 8A 13 8B 0F 88 54 0E 26 43 2B D8 EB 12 F7 D8 99 6A 01 52 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B 45 E4 2B 5D F4 D1 E8 50 FF 75 0C 53 FF 75 F4 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 45 F0 85 C0 75 34 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 4D EC FF 8B 45 F4 3B 45 0C 74 07 50 E8 ?? ?? ?? ?? 59 8B 45 EC 83 F8 FE 0F 85 8B 01 00 00 8B 45 F0 E9 83 01 00 00 8B 45 F0 8B 17 33 C9 3B C3 0F 95 C1 03 C0 89 45 F0 89 4C 16 30 EB C6 3B CB 74 0E 8B 4D F4 66 83 39 0A 75 05 80 08 04 EB 03 80 20 FB 8B 5D F4 8B 45 F0 03 C3 89 5D 10 89 45 F0 3B D8 0F 83 FF 00 00 00 8B 45 10 0F B7 08 66 83 F9 1A 0F 84 D7 00 00 00 66 83 F9 0D 74 0F 66 89 0B 43 43 40 40 89 45 10 E9 B4 00 00 00 8B 4D F0 83 C1 FE 3B C1 73 1E 8D 48 02 66 83 39 0A 75 0D 83 C0 04 89 45 10 6A 0A E9 8E 00 00 00 89 4D 10 E9 84 00 00 00 83 45 10 02 6A 00 8D 45 E8 50 6A 02 8D 45 F8 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 5B 83 7D E8 00 74 55 8B 07 F6 44 06 04 48 74 28 66 83 7D F8 0A 74 B2 6A 0D 58 66 89 03 8B 07 8A 4D F8 88 4C 06 05 8B 07 8A 4D F9 88 4C 06 25 8B 07 C6 44 06 26 0A EB 2A 3B 5D F4 75 07 66 83 7D F8 0A 74 85 6A 01 6A FF 6A FE FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 66 83 7D F8 0A 74 08 6A 0D 58 66 89 03 43 43 8B 45 F0 39 45 10 0F 82 1B FF FF FF EB 18 8B 0F 8D 74 0E 04 F6 06 40 75 05 80 0E 02 EB 08 66 8B 00 66 89 03 43 43 2B 5D F4 89 5D F0 E9 91 FE FF FF FF 15 ?? ?? ?? ?? 6A 05 5E 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 E9 69 FE FF FF 83 F8 6D 0F 85 59 FE FF FF 89 5D EC E9 5C FE FF FF 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "__read"
		size = 253
		refs = "0003 __sehtable$__read 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 00a1 ___lock_fhandle 00bc __read_nolock 00ee __SEH_epilog4 00f7 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 BE 00 00 00 33 F6 3B C6 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F8 83 E7 1F C1 E7 06 8B 0B 0F BE 4C 39 04 83 E1 01 74 BF B9 FF FF FF 7F 3B 4D 10 1B C9 41 75 14 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B0 50 E8 ?? ?? ?? ?? 59 89 75 FC 8B 03 F6 44 38 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "__set_controlfp"
		size = 117
		refs = "0034 ___sse2_available 005a __controlfp_s 006b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 56 33 F6 81 7D 08 1F 00 09 00 75 39 83 F8 FF 75 34 9B D9 7D FC 8B 4D FC 81 E1 3D 1F 00 00 BA 3D 02 00 00 66 3B CA 75 1D 39 35 ?? ?? ?? ?? 74 38 0F AE 5D F8 8B 4D F8 81 E1 C0 FE 00 00 81 F9 80 1E 00 00 74 23 25 FF FF F7 FF 50 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 5E C9 C3 }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "__abstract_cw"
		size = 159
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 33 C0 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 53 0F B7 D1 56 8B CA BE 00 0C 00 00 23 CE 57 BF 00 03 00 00 BB 00 02 00 00 74 21 81 F9 00 04 00 00 74 14 81 F9 00 08 00 00 74 08 3B CE 75 0D 0B C7 EB 09 0B C3 EB 05 0D 00 01 00 00 23 D7 74 0B 3B D3 75 0C 0D 00 00 01 00 EB 05 0D 00 00 02 00 F7 45 08 00 10 00 00 5F 5E 5B 74 05 0D 00 00 04 00 5D C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "__hw_cw"
		size = 142
	strings:
		$1 = { 33 C0 F6 C3 10 74 01 40 F6 C3 08 74 03 83 C8 04 F6 C3 04 74 03 83 C8 08 F6 C3 02 74 03 83 C8 10 F6 C3 01 74 03 83 C8 20 F7 C3 00 00 08 00 74 03 83 C8 02 8B CB BA 00 03 00 00 23 CA 56 BE 00 02 00 00 74 23 81 F9 00 01 00 00 74 16 3B CE 74 0B 3B CA 75 13 0D 00 0C 00 00 EB 0C 0D 00 08 00 00 EB 05 0D 00 04 00 00 8B CB 81 E1 00 00 03 00 74 0C 81 F9 00 00 01 00 75 06 0B C6 EB 02 0B C2 5E F7 C3 00 00 04 00 74 05 0D 00 10 00 00 C3 }
	condition:
		$1
}

rule file_192_4_0 {
	meta:
		name = "__abstract_sw"
		size = 67
		altNames = "___abstract_sw_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8A 4D 08 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 5D C3 }
	condition:
		$1
}

rule file_192_5_0 {
	meta:
		name = "___abstract_cw_sse2"
		size = 160
	strings:
		$1 = { 33 C0 84 D2 79 03 6A 10 58 53 BB 00 02 00 00 56 57 85 D3 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BF 00 01 00 00 85 D7 74 05 0D 00 00 08 00 8B CA BE 00 60 00 00 23 CE 74 21 81 F9 00 20 00 00 74 17 81 F9 00 40 00 00 74 0B 3B CE 75 0D 0D 00 03 00 00 EB 06 0B C3 EB 02 0B C7 5F 81 E2 40 80 00 00 83 EA 40 5E 5B 74 19 81 EA C0 7F 00 00 74 0B 83 EA 40 75 11 0D 00 00 00 01 C3 0D 00 00 00 03 C3 0D 00 00 00 02 C3 }
	condition:
		$1
}

rule file_192_6_0 {
	meta:
		name = "___hw_cw_sse2"
		size = 160
	strings:
		$1 = { 33 C0 F6 C2 10 74 05 B8 80 00 00 00 53 56 57 BB 00 02 00 00 F6 C2 08 74 02 0B C3 F6 C2 04 74 05 0D 00 04 00 00 F6 C2 02 74 05 0D 00 08 00 00 F6 C2 01 74 05 0D 00 10 00 00 BF 00 01 00 00 F7 C2 00 00 08 00 74 02 0B C7 8B CA BE 00 03 00 00 23 CE 74 1F 3B CF 74 16 3B CB 74 0B 3B CE 75 13 0D 00 60 00 00 EB 0C 0D 00 40 00 00 EB 05 0D 00 20 00 00 B9 00 00 00 03 5F 23 D1 5E 5B 81 FA 00 00 00 01 74 16 81 FA 00 00 00 02 74 0A 3B D1 75 0F 0D 00 80 00 00 C3 83 C8 40 C3 0D 40 80 00 00 C3 }
	condition:
		$1
}

rule file_192_9_0 {
	meta:
		name = "__statusfp"
		size = 146
		refs = "0045 ___sse2_available"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 9B DD 7D FC 8A 45 FC 33 D2 BE 00 00 08 00 A8 3F 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 83 3D ?? ?? ?? ?? 00 74 41 0F AE 5D F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 EB 02 8B C2 5E C9 C3 }
	condition:
		$1
}

rule file_192_10_0 {
	meta:
		name = "__fpreset"
		size = 56
		refs = "0004 ___pxcptinfoptrs 000d __setdefaultprecision 0017 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 8B 30 DB E3 E8 ?? ?? ?? ?? 68 80 1F 00 00 E8 ?? ?? ?? ?? 59 85 F6 74 16 8B 46 04 F7 00 08 00 01 00 74 0B 83 60 20 00 C7 40 24 FF FF 00 00 5E C3 }
	condition:
		$1
}

rule file_192_11_0 {
	meta:
		name = "___statusfp_sse2"
		size = 59
		refs = "0001 ___get_fpsr_sse2"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 8B C1 C3 }
	condition:
		$1
}

rule file_192_12_0 {
	meta:
		name = "___clearfp_sse2"
		size = 80
	strings:
		$1 = { 8B FF 55 8B EC 51 0F AE 5D FC 83 65 FC C0 0F AE 55 FC 8A 4D FC 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C9 C3 }
	condition:
		$1
}

rule file_192_13_0 {
	meta:
		name = "___control87_sse2"
		size = 374
		refs = "00cc ___hw_cw_sse2 00d5 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 81 65 0C 1F 03 08 03 0F AE 5D F8 8B 4D F8 33 C0 84 C9 79 03 6A 10 58 53 BB 00 02 00 00 56 57 85 CB 74 03 83 C8 08 F7 C1 00 04 00 00 74 03 83 C8 04 F7 C1 00 08 00 00 74 03 83 C8 02 F7 C1 00 10 00 00 74 03 83 C8 01 BE 00 01 00 00 85 CE 74 05 0D 00 00 08 00 8B D1 BF 00 60 00 00 23 D7 74 21 81 FA 00 20 00 00 74 17 81 FA 00 40 00 00 74 0B 3B D7 75 0D 0D 00 03 00 00 EB 06 0B C3 EB 02 0B C6 BE 40 80 00 00 23 CE 83 E9 40 74 1B 81 E9 C0 7F 00 00 74 0C 83 E9 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B 55 0C 8B 4D 08 23 4D 0C F7 D2 23 D0 0B D1 3B D0 0F 84 A6 00 00 00 E8 ?? ?? ?? ?? 50 89 45 FC E8 ?? ?? ?? ?? 59 0F AE 5D FC 8B 55 FC 33 C0 84 D2 79 03 6A 10 58 85 D3 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BB 00 01 00 00 85 D3 74 05 0D 00 00 08 00 8B CA 23 CF 74 24 81 F9 00 20 00 00 74 1A 81 F9 00 40 00 00 74 0B 3B CF 75 10 0D 00 03 00 00 EB 09 0D 00 02 00 00 EB 02 0B C3 23 D6 83 EA 40 74 1B 81 EA C0 7F 00 00 74 0C 83 EA 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_192_14_0 {
	meta:
		name = "__statusfp2"
		size = 90
		refs = "0051 ___statusfp_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 85 D2 74 3C 9B DD 7D 08 8A 45 08 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 89 0A 56 8B 75 0C 85 F6 74 07 E8 ?? ?? ?? ?? 89 06 5E 5D C3 }
	condition:
		$1
}

rule file_192_15_0 {
	meta:
		name = "__clearfp"
		size = 217
		refs = "000e ___sse2_available"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 7D FC DB E2 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 8A 45 FC 33 D2 56 BE 00 00 08 00 A8 3F 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 0F AE 5D F8 83 65 F8 C0 0F AE 55 F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 5E C9 C3 8A 4D FC 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C9 C3 }
	condition:
		$1
}

rule file_192_16_0 {
	meta:
		name = "___control87_2"
		size = 788
		refs = "00cb __hw_cw 017f ___sse2_available 0251 ___hw_cw_sse2 025a ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 EC 10 53 56 33 D2 57 BF 00 03 00 00 39 55 10 0F 84 53 01 00 00 9B D9 7D F8 8B 5D F8 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 C3 8B C8 BE 00 0C 00 00 23 CE 74 26 81 F9 00 04 00 00 74 18 81 F9 00 08 00 00 74 08 3B CE 75 12 0B D7 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 C7 74 0F 3D 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 8B 5D 0C 8B 45 08 23 45 0C F7 D3 23 DA 0B D8 3B DA 0F 84 9F 00 00 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC D9 6D FC 9B D9 7D FC 8B 55 FC 33 DB F6 C2 01 74 03 6A 10 5B F6 C2 04 74 03 83 CB 08 F6 C2 08 74 03 83 CB 04 F6 C2 10 74 03 83 CB 02 F6 C2 20 74 03 83 CB 01 F6 C2 02 74 06 81 CB 00 00 08 00 0F B7 CA 8B C1 23 C6 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C6 75 12 0B DF EB 0E 81 CB 00 02 00 00 EB 06 81 CB 00 01 00 00 23 CF 74 10 81 F9 00 02 00 00 75 0E 81 CB 00 00 01 00 EB 06 81 CB 00 00 02 00 F7 C2 00 10 00 00 74 06 81 CB 00 00 04 00 8B 45 10 89 18 8B 45 0C 83 7D 14 00 0F 84 91 01 00 00 33 F6 39 35 ?? ?? ?? ?? 0F 84 7E 01 00 00 25 1F 03 08 03 89 45 F0 0F AE 5D F4 8B 45 F4 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BF 00 60 00 00 23 CF 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CF 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 F0 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 B0 00 00 00 E8 ?? ?? ?? ?? 50 89 45 10 E8 ?? ?? ?? ?? 59 0F AE 5D 10 8B 4D 10 33 D2 84 C9 79 03 6A 10 5A F7 C1 00 02 00 00 74 03 83 CA 08 F7 C1 00 04 00 00 74 03 83 CA 04 F7 C1 00 08 00 00 74 03 83 CA 02 F7 C1 00 10 00 00 74 03 83 CA 01 BE 00 01 00 00 85 CE 74 06 81 CA 00 00 08 00 8B C1 23 C7 74 24 3D 00 20 00 00 74 1B 3D 00 40 00 00 74 0C 3B C7 75 12 81 CA 00 03 00 00 EB 0A 81 CA 00 02 00 00 EB 02 0B D6 23 CB 83 E9 40 74 1D 81 E9 C0 7F 00 00 74 0D 83 E9 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B C2 8B 4D 14 89 01 EB 05 8B 45 14 89 30 5F 33 C0 5E 40 5B C9 C3 }
	condition:
		$1
}

rule file_192_17_0 {
	meta:
		name = "__control87"
		size = 783
		refs = "00c4 __hw_cw 0173 ___sse2_available 0246 ___hw_cw_sse2 024f ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 57 9B D9 7D F8 8B 5D F8 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BE 00 0C 00 00 23 C6 BF 00 03 00 00 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C6 75 12 0B D7 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 CF 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 8B 7D 0C 8B 4D 08 8B C7 F7 D0 23 C2 23 CF 0B C1 89 45 0C 3B C2 0F 84 AE 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC D9 6D FC 9B D9 7D FC 8B 5D FC 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 89 55 0C 8B C2 33 F6 39 35 ?? ?? ?? ?? 0F 84 8D 01 00 00 81 E7 1F 03 08 03 89 7D EC 0F AE 5D F0 8B 45 F0 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BB 00 60 00 00 23 CB 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CB 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BF 40 80 00 00 23 C7 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 EC 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 B0 00 00 00 E8 ?? ?? ?? ?? 50 89 45 F4 E8 ?? ?? ?? ?? 59 0F AE 5D F4 8B 4D F4 33 D2 84 C9 79 03 6A 10 5A F7 C1 00 02 00 00 74 03 83 CA 08 F7 C1 00 04 00 00 74 03 83 CA 04 F7 C1 00 08 00 00 74 03 83 CA 02 F7 C1 00 10 00 00 74 03 83 CA 01 BE 00 01 00 00 85 CE 74 06 81 CA 00 00 08 00 8B C1 23 C3 74 24 3D 00 20 00 00 74 1B 3D 00 40 00 00 74 0C 3B C3 75 12 81 CA 00 03 00 00 EB 0A 81 CA 00 02 00 00 EB 02 0B D6 23 CF 83 E9 40 74 1D 81 E9 C0 7F 00 00 74 0D 83 E9 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B C2 8B C8 33 4D 0C 0B 45 0C F7 C1 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_192_18_0 {
	meta:
		name = "__controlfp"
		size = 786
		refs = "00cd __hw_cw 017c ___sse2_available 024f ___hw_cw_sse2 0258 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 57 8B 7D 0C 81 E7 FF FF F7 FF 9B D9 7D FC 8B 5D FC 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BE 00 0C 00 00 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 8B C7 F7 D0 8B CF 23 4D 08 23 C2 0B C1 89 45 F0 3B C2 0F 84 AE 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 45 0C D9 6D 0C 9B D9 7D 0C 8B 5D 0C 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 8B C2 89 55 F0 33 F6 39 35 ?? ?? ?? ?? 0F 84 87 01 00 00 81 E7 1F 03 08 03 89 7D EC 0F AE 5D F4 8B 45 F4 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BF 00 60 00 00 23 CF 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CF 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 EC 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 AA 00 00 00 E8 ?? ?? ?? ?? 50 89 45 F8 E8 ?? ?? ?? ?? 59 0F AE 5D F8 8B 55 F8 33 C0 84 D2 79 03 6A 10 58 F7 C2 00 02 00 00 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BE 00 01 00 00 85 D6 74 05 0D 00 00 08 00 8B CA 23 CF 74 24 81 F9 00 20 00 00 74 1A 81 F9 00 40 00 00 74 0B 3B CF 75 10 0D 00 03 00 00 EB 09 0D 00 02 00 00 EB 02 0B C6 23 D3 83 EA 40 74 1B 81 EA C0 7F 00 00 74 0C 83 EA 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B C8 33 4D F0 0B 45 F0 F7 C1 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_193_6_0 {
	meta:
		name = "__inc"
		size = 22
		refs = "0010 __filbuf"
	strings:
		$1 = { FF 4A 04 78 09 8B 0A 0F B6 01 41 89 0A C3 52 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_193_8_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "000c __inc 001c _isspace"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 55 08 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 E1 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_193_9_0 {
	meta:
		name = "__input_s_l"
		size = 4388
		refs = "000c ___security_cookie 0067 __errno 0077 __invalid_parameter 0093 __fileno 0099 ___badioinfo 00b7 ___pioinfo 0115 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 013b _isspace 015d __whiteout 0164 __un_inc 020a _isdigit 0397 __inc 051d ___check_float_string 0820 __cfltcvt_tab 0825 __decode_pointer 093f _isleadbyte 0987 __mbtowc_l 0a23 _memset 0cfd __allmul 0d18 _isxdigit 0d47 __hextodec 10a1 _free 111e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 00 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 14 8B 45 08 56 33 F6 57 8B 7D 0C 89 8D 20 FE FF FF 8D 8D 7C FE FF FF 89 85 64 FE FF FF 89 BD 54 FE FF FF 89 8D 5C FE FF FF C7 85 28 FE FF FF 5E 01 00 00 89 B5 30 FE FF FF 89 B5 14 FE FF FF 89 B5 78 FE FF FF 89 B5 10 FE FF FF 3B FE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 90 10 00 00 3B C6 74 DC F6 40 0C 40 53 75 7A 50 E8 ?? ?? ?? ?? 59 BA ?? ?? ?? ?? 83 F8 FF 74 1B 83 F8 FE 74 16 8B C8 83 E1 1F 8B D8 C1 FB 05 C1 E1 06 03 0C 9D ?? ?? ?? ?? EB 02 8B CA F6 41 24 7F 75 26 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 83 E0 1F C1 F9 05 C1 E0 06 03 04 8D ?? ?? ?? ?? EB 02 8B C2 F6 40 24 80 74 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0A 10 00 00 FF 75 10 8D 8D 00 FE FF FF E8 ?? ?? ?? ?? 8A 07 C6 85 63 FE FF FF 00 89 B5 74 FE FF FF 89 B5 3C FE FF FF 84 C0 0F 84 C6 0F 00 00 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 46 FF B5 64 FE FF FF FF 8D 74 FE FF FF FF B5 64 FE FF FF 8D B5 74 FE FF FF E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 8B B5 54 FE FF FF 59 59 46 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 89 B5 54 FE FF FF E9 60 0E 00 00 8B B5 54 FE FF FF 8A 06 3C 25 0F 85 CC 0D 00 00 38 46 01 0F 84 B5 0D 00 00 33 FF 89 BD 38 FE FF FF C6 85 2F FE FF FF 00 89 BD 58 FE FF FF 89 BD 40 FE FF FF 89 BD 6C FE FF FF 89 BD 34 FE FF FF C6 85 62 FE FF FF 00 C6 85 61 FE FF FF 00 C6 85 71 FE FF FF 00 C6 85 73 FE FF FF 00 C6 85 6A FE FF FF 00 C6 85 72 FE FF FF 00 C6 85 6B FE FF FF 01 89 BD 50 FE FF FF 46 0F B6 1E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 6C FE FF FF FF 85 40 FE FF FF 6B C0 0A 8D 44 18 D0 89 85 6C FE FF FF E9 C5 00 00 00 83 FB 4E 0F 8F 83 00 00 00 0F 84 B6 00 00 00 83 FB 2A 74 70 83 FB 46 0F 84 A8 00 00 00 83 FB 49 74 10 83 FB 4C 75 74 FE 85 6B FE FF FF E9 93 00 00 00 8A 4E 01 80 F9 36 75 1E 8D 46 02 80 38 34 75 16 FF 85 50 FE FF FF 8B F0 89 BD 48 FE FF FF 89 BD 4C FE FF FF EB 6D 80 F9 33 75 0C 8D 46 02 80 38 32 75 04 8B F0 EB 5C 80 F9 64 74 57 80 F9 69 74 52 80 F9 6F 74 4D 80 F9 78 74 48 80 F9 58 75 19 EB 41 FE 85 71 FE FF FF EB 39 83 FB 68 74 28 83 FB 6C 74 0D 83 FB 77 74 16 FE 85 73 FE FF FF EB 22 8D 46 01 80 38 6C 74 97 FE 85 6B FE FF FF FE 85 72 FE FF FF EB 0C FE 8D 6B FE FF FF FE 8D 72 FE FF FF 80 BD 73 FE FF FF 00 0F 84 FE FE FF FF 80 BD 71 FE FF FF 00 89 B5 54 FE FF FF 75 19 8B 85 20 FE FF FF 8B 18 89 85 18 FE FF FF 83 C0 04 89 85 20 FE FF FF EB 02 33 DB 80 BD 72 FE FF FF 00 89 9D 44 FE FF FF C6 85 73 FE FF FF 00 75 18 8A 06 3C 53 74 0B C6 85 72 FE FF FF FF 3C 43 75 07 C6 85 72 FE FF FF 01 0F B6 3E 83 CF 20 89 BD 1C FE FF FF 83 FF 6E 74 4A 83 FF 63 74 19 83 FF 7B 74 14 FF B5 64 FE FF FF 8D B5 74 FE FF FF E8 ?? ?? ?? ?? 59 EB 11 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 F8 FF 0F 84 E7 0C 00 00 8B 9D 44 FE FF FF 8B B5 54 FE FF FF 8B 8D 40 FE FF FF 85 C9 74 0D 83 BD 6C FE FF FF 00 0F 84 2C 0C 00 00 80 BD 71 FE FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 18 FE FF FF 8B 18 83 C0 04 89 85 18 FE FF FF 83 C0 04 89 85 20 FE FF FF 8B 40 FC 89 9D 44 FE FF FF 89 85 34 FE FF FF 83 F8 01 0F 82 FA 0B 00 00 83 FF 6F 0F 8F 7F 05 00 00 0F 84 12 08 00 00 83 FF 63 0F 84 05 04 00 00 83 FF 64 0F 84 00 08 00 00 0F 8E 8B 05 00 00 83 FF 67 7E 42 83 FF 69 74 21 83 FF 6E 0F 85 78 05 00 00 80 BD 71 FE FF FF 00 8B 85 74 FE FF FF 0F 84 B0 09 00 00 E9 DA 0A 00 00 6A 64 5F 83 BD 78 FE FF FF 2D 0F 85 50 06 00 00 C6 85 61 FE FF FF 01 E9 4D 06 00 00 33 DB 83 BD 78 FE FF FF 2D 75 0C 8B 85 5C FE FF FF C6 00 2D 43 EB 09 83 BD 78 FE FF FF 2B 75 1D FF 8D 6C FE FF FF 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 BD 40 FE FF FF 00 75 07 83 8D 6C FE FF FF FF 0F B6 85 78 FE FF FF EB 6B 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 66 8A 85 78 FE FF FF 8B 8D 5C FE FF FF FF 85 58 FE FF FF 88 04 0B 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 65 0B 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A 8B 85 00 FE FF FF 8B 80 BC 00 00 00 8B 00 8A 00 88 85 62 FE FF FF 3A 85 78 FE FF FF 0F 85 E5 00 00 00 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 D1 00 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B 8D 5C FE FF FF 89 85 78 FE FF FF 8A 85 62 FE FF FF 88 04 0B 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B8 0A 00 00 0F B6 85 78 FE FF FF EB 6B 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 66 8B 85 5C FE FF FF 8A 8D 78 FE FF FF FF 85 58 FE FF FF 88 0C 03 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 5E 0A 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A 83 BD 58 FE FF FF 00 0F 84 5F 01 00 00 83 BD 78 FE FF FF 65 74 0D 83 BD 78 FE FF FF 45 0F 85 49 01 00 00 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 35 01 00 00 8B 85 5C FE FF FF C6 04 03 65 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 CC 09 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 F8 2D 75 2C 8B 85 5C FE FF FF C6 04 03 2D 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 86 09 00 00 EB 09 83 BD 78 FE FF FF 2B 75 2F 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 75 08 21 85 6C FE FF FF EB 17 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 0F B6 85 78 FE FF FF EB 6B 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 74 66 8B 85 5C FE FF FF 8A 8D 78 FE FF FF FF 85 58 FE FF FF 88 0C 03 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 5C FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 F2 08 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A FF B5 64 FE FF FF FF 8D 74 FE FF FF FF B5 78 FE FF FF E8 ?? ?? ?? ?? 83 BD 58 FE FF FF 00 59 59 0F 84 A7 08 00 00 80 BD 71 FE FF FF 00 0F 85 4C 07 00 00 8B 85 5C FE FF FF FF 85 3C FE FF FF 8D 8D 00 FE FF FF 51 50 FF B5 44 FE FF FF C6 04 03 00 0F BE 85 6B FE FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 C4 10 E9 0F 07 00 00 85 C9 75 10 FF 85 6C FE FF FF C7 85 40 FE FF FF 01 00 00 00 80 BD 72 FE FF FF 00 7E 07 C6 85 6A FE FF FF 01 8B B5 64 FE FF FF FF 8D 74 FE FF FF 56 FF B5 78 FE FF FF 89 9D 50 FE FF FF E8 ?? ?? ?? ?? 59 59 83 FF 63 74 06 FF 8D 34 FE FF FF 83 BD 40 FE FF FF 00 74 14 8B 85 6C FE FF FF FF 8D 6C FE FF FF 85 C0 0F 84 42 03 00 00 FF 85 74 FE FF FF 8B D6 E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 F8 FF 0F 84 17 03 00 00 83 FF 63 74 4C 83 FF 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E FF 02 00 00 83 F8 20 75 34 83 FF 7B 0F 85 F1 02 00 00 0F BE BD 62 FE FF FF 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 4C 0D DC 33 CF 8B BD 1C FE FF FF 85 D1 0F 84 C6 02 00 00 80 BD 71 FE FF FF 00 0F 85 AE 02 00 00 83 BD 34 FE FF FF 00 0F 84 29 07 00 00 80 BD 6A FE FF FF 00 0F 84 86 02 00 00 88 85 24 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 13 FF 85 74 FE FF FF 8B D6 E8 ?? ?? ?? ?? 88 85 25 FE FF FF 8D 85 00 FE FF FF 50 8B 85 00 FE FF FF C7 85 14 FE FF FF 3F 00 00 00 FF B0 AC 00 00 00 8D 85 24 FE FF FF 50 8D 85 14 FE FF FF 50 E8 ?? ?? ?? ?? 66 8B 85 14 FE FF FF 83 C4 10 66 89 03 43 43 E9 1E 02 00 00 8B C7 83 E8 70 0F 84 87 02 00 00 83 E8 03 0F 84 95 FE FF FF 48 48 0F 84 7D 02 00 00 83 E8 03 0F 84 A8 FA FF FF 83 E8 03 74 33 0F B6 06 3B 85 78 FE FF FF 0F 85 59 06 00 00 FE 8D 63 FE FF FF 80 BD 71 FE FF FF 00 0F 85 58 05 00 00 8B 85 18 FE FF FF 89 85 20 FE FF FF E9 47 05 00 00 80 BD 72 FE FF FF 00 7E 07 C6 85 6A FE FF FF 01 46 80 3E 5E 75 08 46 C6 85 62 FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 09 B2 5D 46 C6 45 E7 20 EB 72 8A 95 2F FE FF FF EB 6A 46 3C 2D 75 48 84 D2 74 44 8A 0E 80 F9 5D 74 3D 46 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 28 2A C2 FE C0 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 47 4A 75 E8 8B BD 1C FE FF FF 32 D2 EB 1D 8B BD 1C FE FF FF 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 44 05 DC 08 18 8A 06 3C 5D 75 90 84 C0 0F 84 D9 05 00 00 8B 9D 44 FE FF FF 89 B5 54 FE FF FF E9 8F FD FF FF 83 BD 78 FE FF FF 2B 75 2C FF 8D 6C FE FF FF 75 0D 85 C9 74 09 C6 85 73 FE FF FF 01 EB 17 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 BD 78 FE FF FF 30 0F 85 74 01 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 3C 78 74 56 3C 58 74 52 C7 85 58 FE FF FF 01 00 00 00 83 FF 78 74 1B 83 BD 40 FE FF FF 00 74 0E FF 8D 6C FE FF FF 75 06 FE 85 73 FE FF FF 6A 6F EB 60 FF B5 64 FE FF FF FF 8D 74 FE FF FF FF B5 78 FE FF FF E8 ?? ?? ?? ?? 59 59 C7 85 78 FE FF FF 30 00 00 00 E9 03 01 00 00 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 83 BD 40 FE FF FF 00 89 85 78 FE FF FF 74 16 83 AD 6C FE FF FF 02 83 BD 6C FE FF FF 01 7D 06 FE 85 73 FE FF FF 6A 78 5F E9 C5 00 00 00 88 03 43 89 9D 44 FE FF FF E9 B5 FC FF FF FF 85 50 FE FF FF E9 B0 FC FF FF FF 8D 74 FE FF FF 56 50 E8 ?? ?? ?? ?? 59 59 39 9D 50 FE FF FF 0F 84 A3 04 00 00 80 BD 71 FE FF FF 00 0F 85 48 03 00 00 FF 85 3C FE FF FF 83 FF 63 0F 84 39 03 00 00 80 BD 6A FE FF FF 00 74 10 8B 8D 44 FE FF FF 33 C0 66 89 01 E9 20 03 00 00 8B 85 44 FE FF FF C6 00 00 E9 12 03 00 00 C6 85 6B FE FF FF 01 83 BD 78 FE FF FF 2D 75 09 C6 85 61 FE FF FF 01 EB 09 83 BD 78 FE FF FF 2B 75 2C FF 8D 6C FE FF FF 75 0D 85 C9 74 09 C6 85 73 FE FF FF 01 EB 17 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF 83 BD 50 FE FF FF 00 0F 84 AB 01 00 00 80 BD 73 FE FF FF 00 0F 85 1B 01 00 00 83 FF 78 74 71 83 FF 70 74 6C 0F B6 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E2 00 00 00 83 FF 6F 75 2E 83 BD 78 FE FF FF 38 0F 8D D0 00 00 00 8B 85 48 FE FF FF 8B 8D 4C FE FF FF 0F A4 C1 03 C1 E0 03 89 85 48 FE FF FF 89 8D 4C FE FF FF EB 66 6A 00 6A 0A FF B5 4C FE FF FF FF B5 48 FE FF FF E8 ?? ?? ?? ?? 89 85 48 FE FF FF 89 95 4C FE FF FF EB 43 0F B6 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 8B 85 48 FE FF FF 8B 8D 4C FE FF FF FF B5 78 FE FF FF 0F A4 C1 04 C1 E0 04 89 85 48 FE FF FF 89 8D 4C FE FF FF E8 ?? ?? ?? ?? 59 89 85 78 FE FF FF 8B 85 78 FE FF FF FF 85 58 FE FF FF 83 C0 D0 99 01 85 48 FE FF FF 11 95 4C FE FF FF 83 BD 40 FE FF FF 00 74 08 FF 8D 6C FE FF FF 74 35 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF E9 FE FE FF FF FF B5 64 FE FF FF FF 8D 74 FE FF FF FF B5 78 FE FF FF E8 ?? ?? ?? ?? 59 59 80 BD 61 FE FF FF 00 74 1F 8B 85 48 FE FF FF 8B 8D 4C FE FF FF F7 D8 83 D1 00 F7 D9 89 85 48 FE FF FF 89 8D 4C FE FF FF 8B 85 38 FE FF FF 83 FF 46 75 07 83 A5 58 FE FF FF 00 83 BD 58 FE FF FF 00 0F 84 96 02 00 00 80 BD 71 FE FF FF 00 0F 85 3B 01 00 00 FF 85 3C FE FF FF 8B 9D 44 FE FF FF 83 BD 50 FE FF FF 00 0F 84 12 01 00 00 8B 85 48 FE FF FF 89 03 8B 85 4C FE FF FF 89 43 04 E9 0C 01 00 00 80 BD 73 FE FF FF 00 0F 85 D5 00 00 00 83 FF 78 74 43 83 FF 70 74 3E 0F B6 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 9C 00 00 00 83 FF 6F 75 18 83 BD 78 FE FF FF 38 0F 8D 8A 00 00 00 8B 85 38 FE FF FF C1 E0 03 EB 3C 8B 85 38 FE FF FF 6B C0 0A EB 31 0F B6 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 62 FF B5 78 FE FF FF C1 A5 38 FE FF FF 04 E8 ?? ?? ?? ?? 89 85 78 FE FF FF 8B 85 38 FE FF FF 59 8B 8D 78 FE FF FF FF 85 58 FE FF FF 83 BD 40 FE FF FF 00 8D 44 08 D0 89 85 38 FE FF FF 74 08 FF 8D 6C FE FF FF 74 35 8B 95 64 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 78 FE FF FF E9 44 FF FF FF FF B5 64 FE FF FF FF 8D 74 FE FF FF FF B5 78 FE FF FF E8 ?? ?? ?? ?? 59 59 80 BD 61 FE FF FF 00 0F 84 B6 FE FF FF 8B 85 38 FE FF FF F7 D8 E9 AF FE FF FF 80 BD 6B FE FF FF 00 74 04 89 03 EB 03 66 89 03 8B B5 54 FE FF FF FE 85 63 FE FF FF 46 89 B5 54 FE FF FF EB 6E 3C 25 75 0A 8D 46 01 80 38 25 75 02 8B F0 8B BD 64 FE FF FF FF 85 74 FE FF FF 8B D7 E8 ?? ?? ?? ?? 8B D8 0F B6 06 46 89 9D 78 FE FF FF 89 B5 54 FE FF FF 3B C3 0F 85 E9 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 25 FF 85 74 FE FF FF 8B D7 E8 ?? ?? ?? ?? 0F B6 0E 46 89 B5 54 FE FF FF 3B C8 0F 85 C0 00 00 00 FF 8D 74 FE FF FF 83 BD 78 FE FF FF FF 75 1B 80 3E 25 0F 85 B9 00 00 00 8B 85 54 FE FF FF 80 78 01 6E 0F 85 A9 00 00 00 8B F0 8A 06 84 C0 0F 85 42 F1 FF FF E9 98 00 00 00 FF B5 64 FE FF FF FF }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__spawnv"
		size = 82
		refs = "0010 __errno 0020 __invalid_parameter 0048 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 53 33 DB 3B D3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 23 38 1A 74 DF 8B 4D 10 3B CB 74 D8 8B 01 3B C3 74 D2 38 18 74 CE 53 51 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5B 5D C3 }
	condition:
		$1
}

rule file_196_3_0 {
	meta:
		name = "__mbsnccnt_l"
		size = 139
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0036 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8B 75 0C 33 DB 3B CB 75 2C 3B F3 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 3A 33 C0 3B F3 74 28 57 8A 11 4E 3A D3 74 1F 8B 7D F4 0F B6 D2 F6 44 3A 1D 04 74 0C 8B D6 4E 85 D2 74 0B 41 38 19 74 06 40 41 3B F3 75 DA 5F 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "___RTtypeid"
		size = 125
		refs = "0003 __sehtable$___RTtypeid 0008 __SEH_prolog4 0014 ??_C@_0CE@FFJAJLDK@Attempted?5a?5typeid?5of?5NULL?5point@ 001c ??0bad_typeid@std@@QAE@PBD@Z 0021 __TI2?AVbad_typeid@std@@ 002a __CxxThrowException@8 0046 __SEH_epilog4 004c ??_C@_0CB@EEENAAHH@Bad?5read?5pointer?5?9?5no?5RTTI?5data?$CB@ 0054 ??0__non_rtti_object@std@@QAE@PBD@Z 0059 __TI3?AV__non_rtti_object@std@@ 0077 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 75 1B 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 83 65 FC 00 8B 00 8B 40 FC 8B 40 0C 85 C0 74 0D C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C6 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? EB D3 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "?FindCompleteObject@@YAPAXPAPAX@Z"
		size = 22
	strings:
		$1 = { 8B 01 8B 50 FC 8B C1 2B 42 04 8B 52 08 85 D2 74 04 2B CA 2B 01 C3 }
	condition:
		$1
}

rule file_197_2_0 {
	meta:
		name = "?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@1@Z"
		size = 119
		refs = "0030 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 40 10 53 8B 58 08 56 33 F6 57 8B 78 0C 85 DB 76 27 8B 04 B7 8B 4D 0C 89 45 FC 8B 00 3B C1 74 44 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 31 46 3B F3 72 D9 33 C0 5F 5E 5B C9 C3 8B 04 B7 F6 40 14 04 75 F0 8B 00 8B 4D 08 3B C1 74 1A 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 46 3B F3 72 D6 EB CD 8B 45 FC EB CA }
	condition:
		$1
}

rule file_197_3_0 {
	meta:
		name = "?PMDtoOffset@@YAHPAXABUPMD@@@Z"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 50 04 33 C9 85 D2 7C 10 8B CA 8B 55 08 8B 14 11 56 8B 70 08 03 0C 32 5E 8B 00 03 C1 5D C3 }
	condition:
		$1
}

rule file_197_4_0 {
	meta:
		name = "___RTCastToVoid"
		size = 96
		refs = "0003 __sehtable$___RTCastToVoid 0008 __SEH_prolog4 0016 __SEH_epilog4 0020 ?FindCompleteObject@@YAPAXPAPAX@Z 0045 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 004d ??0__non_rtti_object@std@@QAE@PBD@Z 0052 __TI3?AV__non_rtti_object@std@@ 005b __CxxThrowException@8"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB E8 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_197_5_0 {
	meta:
		name = "?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 264
		refs = "004e _strcmp 0091 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 40 10 83 4D F8 FF 53 8B 58 08 33 C9 56 57 8B 78 0C 89 4D F0 89 4D EC 89 4D F4 89 4D FC 3B D9 0F 86 D3 00 00 00 8B 45 FC 8B 34 87 2B 45 F8 3B 45 F4 76 32 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 16 8B 45 EC 85 C0 75 50 8B 45 FC 89 45 F8 8B 46 04 89 75 F0 89 45 F4 8B 06 8B 4D 0C 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 1B FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 59 3B 45 10 75 0A 8B 4D F0 85 C9 75 1D 89 75 EC FF 45 FC 39 5D FC 72 81 EB 52 F6 46 14 03 75 4C F6 40 14 01 75 46 8B C6 EB 44 8B 45 FC 2B 45 F8 3B 45 F4 77 31 F6 41 14 40 75 10 83 7D F8 00 75 06 F6 46 14 01 75 25 8B C1 EB 23 8B 51 18 8B 52 0C 8B 04 82 8A 40 14 24 01 0F B6 C0 F7 D8 1B C0 F7 D0 23 C1 EB 08 F6 41 14 03 74 D5 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_197_6_0 {
	meta:
		name = "?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 342
		refs = "005f _strcmp 00a7 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8B 40 10 8B 48 0C 83 4D F4 FF 83 4D E8 FF 53 8B 58 08 56 57 33 FF 89 7D EC 89 7D E4 89 7D E0 89 4D DC 89 7D F0 C6 45 FF 01 89 7D F8 3B DF 0F 86 13 01 00 00 8B 45 F8 8B 4D DC 8B 34 81 2B 45 F4 3B 45 F0 76 33 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 17 F6 46 14 03 75 03 89 75 E0 8B 45 F8 89 45 F4 8B 46 04 8B FE 89 45 F0 8B 06 8B 4D 0C 3B C1 74 17 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 89 00 00 00 FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 59 3B 45 10 75 78 8B 45 F8 2B 45 F4 3B 45 F0 77 64 80 7D FF 00 74 67 F6 47 14 40 75 14 83 7D F4 00 75 0A F6 46 14 01 74 04 C6 45 FF 00 B0 01 EB 1B 8B 4F 18 8B 49 0C 8B 04 81 8B 40 14 A8 01 74 04 C6 45 FF 00 C1 E8 02 F6 D0 24 01 80 7D FF 00 74 2C 84 C0 74 28 FF 75 08 8D 47 08 E8 ?? ?? ?? ?? 83 7D EC 00 59 74 05 39 45 E8 75 37 89 7D EC 89 45 E8 EB 09 F6 46 14 05 75 03 89 75 E4 FF 45 F8 39 5D F8 0F 82 07 FF FF FF 80 7D FF 00 74 07 8B 45 EC 85 C0 75 0F 83 7D E4 00 74 07 8B 45 E0 85 C0 75 02 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_197_7_0 {
	meta:
		name = "___RTDynamicCast"
		size = 213
		refs = "0003 __sehtable$___RTDynamicCast 0008 __SEH_prolog4 0016 __SEH_epilog4 0022 ?FindCompleteObject@@YAPAXPAPAX@Z 0044 ?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@1@Z 0057 ?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 005e ?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 006e ?PMDtoOffset@@YAHPAXABUPMD@@@Z 008c ??_C@_0BC@JNJNLHBP@Bad?5dynamic_cast?$CB?$AA@ 0094 ??0bad_cast@std@@QAE@PBD@Z 0099 __TI2?AVbad_cast@std@@ 00a2 __CxxThrowException@8 00c2 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 00ca ??0__non_rtti_object@std@@QAE@PBD@Z 00cf __TI3?AV__non_rtti_object@std@@"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 8B CE E8 ?? ?? ?? ?? 8B F8 8B 06 8B 40 FC 2B 75 0C 2B F7 8B 48 10 8B 49 04 FF 75 14 F6 C1 01 75 0C FF 75 10 E8 ?? ?? ?? ?? 59 59 EB 19 56 FF 75 10 57 F6 C1 02 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 18 83 C0 08 57 E8 ?? ?? ?? ?? 59 03 C7 89 45 E4 C7 45 FC FE FF FF FF EB 94 33 C0 89 45 E4 39 45 18 74 ED 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 83 65 E4 00 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C8 }
	condition:
		$1
}

rule file_198_1_0 {
	meta:
		name = "__findclose"
		size = 38
		refs = "000a __imp__FindClose@4 0013 __errno"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_198_2_0 {
	meta:
		name = "___timet_from_ft"
		size = 102
		refs = "001d __imp__FileTimeToLocalFileTime@8 002f __imp__FileTimeToSystemTime@8 0058 ___loctotime32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 18 83 38 00 75 06 83 78 04 00 74 4B 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F4 6A 00 50 0F B7 45 F2 50 0F B7 45 F0 50 0F B7 45 EE 50 0F B7 45 EA 50 0F B7 45 E8 50 E8 ?? ?? ?? ?? 83 C4 1C C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_198_3_0 {
	meta:
		name = "__findfirst32"
		size = 295
		refs = "000c ___security_cookie 0024 __errno 0034 __invalid_parameter 0052 __imp__FindFirstFileA@8 005f __imp__GetLastError@0 00bf ___timet_from_ft 00fe _strcpy_s 010f __invoke_watson 0121 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D6 00 00 00 3B C7 74 DC 53 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 8B D8 83 FB FF 75 45 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 2A 83 F8 08 74 18 83 F8 12 74 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 8C 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB EB E8 ?? ?? ?? ?? 89 30 EB E2 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 68 04 01 00 00 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C3 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_198_4_0 {
	meta:
		name = "__findnext32"
		size = 294
		refs = "000c ___security_cookie 0023 __errno 0035 __invalid_parameter 005b __imp__FindNextFileA@8 0065 __imp__GetLastError@0 00bf ___timet_from_ft 00fe _strcpy_s 010f __invoke_watson 0120 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 83 F8 FF 75 22 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D4 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D8 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B0 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A3 E8 ?? ?? ?? ?? 89 30 EB 9A 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 68 04 01 00 00 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_199_3_0 {
	meta:
		name = "__ismbcgraph_l"
		size = 187
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 78 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 3C F7 45 FC 17 01 00 00 74 33 33 C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 BA 17 01 00 00 66 85 14 41 75 D7 8B 4D F0 F6 44 08 1D 03 75 CD 33 C0 EB CC }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "_strncpy_s"
		size = 181
		refs = "002e __errno 003d __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 33 DB 57 39 5D 14 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B F3 74 07 8B 7D 0C 3B FB 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 39 5D 14 75 04 88 1E EB CA 8B 55 10 3B D3 75 04 88 1E EB D1 83 7D 14 FF 8B C6 75 0F 8A 0A 88 08 40 42 3A CB 74 1E 4F 75 F3 EB 19 8A 0A 88 08 40 42 3A CB 74 08 4F 74 05 FF 4D 14 75 EE 39 5D 14 75 02 88 18 3B FB 75 8B 83 7D 14 FF 75 0F 8B 45 0C 6A 50 88 5C 06 FF 58 E9 78 FF FF FF 88 1E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB 82 }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "__atof_l"
		size = 171
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f __errno 002f __invalid_parameter 005d __isctype_l 0085 _strlen 0091 __fltin2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 53 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 08 33 DB 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD D9 EE EB 61 8B 45 F0 83 B8 AC 00 00 00 01 7E 14 8D 45 F0 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 10 0F B6 0E 8B 80 C8 00 00 00 0F B7 04 48 83 E0 08 3B C3 74 03 46 EB C9 8D 45 F0 50 53 53 56 E8 ?? ?? ?? ?? 59 50 8D 45 D8 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 18 38 5D FC 74 07 8B 45 F8 83 60 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_203_5_0 {
	meta:
		name = "___strgtold12"
		size = 66
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ___strgtold12_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_300_5_0 {
	meta:
		name = "___wstrgtold12"
		size = 66
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ___wstrgtold12_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_203_6_0 {
	meta:
		name = "___STRINGTOLD"
		size = 57
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ___STRINGTOLD_L"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_455_4_0 {
	meta:
		name = "?_fltinf@@YAPAU_flt@@PBDHHH@Z"
		size = 57
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 __fltinf_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_300_6_0 {
	meta:
		name = "___WSTRINGTOLD"
		size = 57
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ___WSTRINGTOLD_L"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_204_2_0 {
	meta:
		name = "__searchenv_s"
		size = 908
		refs = "000c ___security_cookie 003f __errno 004e __invalid_parameter 0094 __access_s 00ba __fullpath 00dc __dupenv_s 00f2 __invoke_watson 0123 _free 013e @__security_check_cookie@4 015b _strlen 019a __calloc_crt 01ed __getpath 02c1 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 28 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 4D 0C 53 33 DB 56 8B 75 10 89 85 E0 FE FF FF 89 8D EC FE FF FF 89 9D DC FE FF FF 89 9D F0 FE FF FF 3B F3 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 DA 00 00 00 39 5D 14 76 DF 3B C3 75 04 88 1E EB D7 38 18 75 19 88 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 E9 8A 00 00 00 57 E8 ?? ?? ?? ?? 8B 38 53 FF B5 E0 FE FF FF E8 ?? ?? ?? ?? 59 59 89 85 E8 FE FF FF E8 ?? ?? ?? ?? 89 38 39 9D E8 FE FF FF 75 1E FF 75 14 FF B5 E0 FE FF FF 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 BC 02 00 00 88 1E EB 39 FF B5 EC FE FF FF 8D 85 DC FE FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 5D 83 F8 16 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 88 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 5F 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 FF B5 DC FE FF FF E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8B 85 DC FE FF FF 3B C3 74 AB FF B5 E0 FE FF FF 89 85 E4 FE FF FF E8 ?? ?? ?? ?? 89 85 EC FE FF FF 8D 85 F4 FE FF FF 89 85 F0 FE FF FF B8 08 01 00 00 59 8B F8 39 85 EC FE FF FF 72 3C FF B5 E4 FE FF FF E8 ?? ?? ?? ?? 8B 8D EC FE FF FF 8D 7C 08 02 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F0 FE FF FF 3B C3 75 12 88 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 49 FF FF FF E8 ?? ?? ?? ?? 8B 00 89 85 D8 FE FF FF E9 1C 01 00 00 8B 85 E4 FE FF FF 8B CF 2B 8D EC FE FF FF 89 85 E8 FE FF FF 49 51 FF B5 F0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FE FF FF 3B C3 75 74 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 0F 85 E9 FE FF FF E8 ?? ?? ?? ?? 83 38 22 0F 85 DB FE FF FF FF B5 E8 FE FF FF E8 ?? ?? ?? ?? 8B 8D EC FE FF FF 8D 7C 08 02 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F0 FE FF FF 3B C3 0F 84 5F FF FF FF 8B CF 2B 8D EC FE FF FF 51 50 FF B5 E8 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FE FF FF 3B C3 0F 84 87 FE FF FF 8B 85 F0 FE FF FF 38 18 0F 84 79 FE FF FF 50 E8 ?? ?? ?? ?? 8B 95 F0 FE FF FF 89 85 E8 FE FF FF 03 C2 59 0F BE 48 FF 83 F9 2F 74 14 83 F9 5C 74 0F 83 F9 3A 74 0A C6 00 5C 40 FF 85 E8 FE FF FF FF B5 E0 FE FF FF 8B CF 2B C8 03 CA 51 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 53 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 11 39 9D E4 FE FF FF 0F 85 D8 FE FF FF E9 FD FD FF FF 8B 85 E8 FE FF FF 8B 8D EC FE FF FF 03 C1 3B 45 14 72 2C 8D 85 F4 FE FF FF 88 1E 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E9 CB FD FF FF E8 ?? ?? ?? ?? FF B5 F0 FE FF FF 8B 8D D8 FE FF FF FF 75 14 89 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 33 F6 E9 81 FD FF FF }
	condition:
		$1
}

rule file_204_3_0 {
	meta:
		name = "__searchenv"
		size = 29
		refs = "0014 __searchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_324_3_0 {
	meta:
		name = "__wsearchenv"
		size = 29
		refs = "0014 __wsearchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_205_1_0 {
	meta:
		name = "__wgetenv_helper_nolock"
		size = 155
		refs = "0007 ___env_initialized 000f __wenviron 0020 __environ 0027 ___crtGetEnvironmentStringsW 002c __wenvptr 0031 __wsetenvp 003a ___mbtow_environ 0056 _wcslen 0079 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 EB 77 57 85 F6 75 2E 39 35 ?? ?? ?? ?? 74 67 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 09 E8 ?? ?? ?? ?? 85 C0 75 4B 8B 35 ?? ?? ?? ?? 85 F6 74 41 83 7D 08 00 74 3B FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 28 50 E8 ?? ?? ?? ?? 59 3B C7 76 1A 8B 06 66 83 3C 78 3D 75 11 57 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D2 33 C0 5F 5E 5D C3 8B 06 8D 44 78 02 EB F4 }
	condition:
		$1
}

rule file_205_2_0 {
	meta:
		name = "__wgetenv_s_helper"
		size = 152
		refs = "0010 __errno 001f __invalid_parameter 004d __wgetenv_helper_nolock 005a _wcslen 0079 _wcscpy_s 008a __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F8 33 F6 3B FE 75 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 6A 8B 45 08 89 37 3B C6 74 07 39 75 0C 77 07 EB D5 39 75 0C 75 D0 3B C6 74 05 33 C9 66 89 08 53 FF 75 10 E8 ?? ?? ?? ?? 8B D8 59 3B DE 74 39 53 E8 ?? ?? ?? ?? 40 59 89 07 39 75 0C 74 2A 3B 45 0C 76 05 6A 22 58 EB 22 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_205_3_0 {
	meta:
		name = "__wdupenv_s_helper"
		size = 164
		refs = "000f __errno 001e __invalid_parameter 003d __wgetenv_helper_nolock 004b _wcslen 0056 _calloc 007d _wcscpy_s 008e __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 57 33 FF 3B DF 75 1B E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 77 8B 45 08 89 3B 3B C7 74 02 89 38 39 7D 0C 74 D5 FF 75 0C E8 ?? ?? ?? ?? 59 89 45 FC 3B C7 74 55 50 E8 ?? ?? ?? ?? 8B F0 46 6A 02 56 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C7 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 29 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 74 02 89 30 33 C0 5F 5E C9 C3 }
	condition:
		$1
}

rule file_205_4_0 {
	meta:
		name = "__wgetenv"
		size = 131
		refs = "0003 __sehtable$__wgetenv 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0040 _wcsnlen 0051 __lock 005d __wgetenv_helper_nolock 0075 __SEH_epilog4 007d __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3E BF FF 7F 00 00 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 CC 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_331_4_0 {
	meta:
		name = "_getenv"
		size = 131
		refs = "0003 __sehtable$_getenv 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0040 _strnlen 0051 __lock 005d __getenv_helper_nolock 0075 __SEH_epilog4 007d __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3E BF FF 7F 00 00 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 CC 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_205_5_0 {
	meta:
		name = "__wgetenv_s"
		size = 219
		refs = "0003 __sehtable$__wgetenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0072 __wgetenv_helper_nolock 007f _wcslen 00a2 _wcscpy_s 00b3 __invoke_watson 00cd __SEH_epilog4 00d5 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 EB 7A 89 33 8B 4D 0C 3B CE 74 09 39 75 10 77 09 3B CE 75 0A 39 75 10 75 05 33 C0 40 EB 02 33 C0 3B C6 74 C2 3B CE 74 05 33 C0 66 89 01 FF 75 14 E8 ?? ?? ?? ?? 59 8B F8 3B FE 74 3D 57 E8 ?? ?? ?? ?? 59 40 89 03 39 75 10 74 2E 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 23 57 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_205_6_0 {
	meta:
		name = "__wdupenv_s"
		size = 230
		refs = "0003 __sehtable$__wdupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0061 __wgetenv_helper_nolock 006f _wcslen 007a _calloc 00a4 _wcscpy_s 00b5 __invoke_watson 00d8 __SEH_epilog4 00e0 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 E9 82 00 00 00 89 33 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 CA FF 75 10 E8 ?? ?? ?? ?? 59 89 45 E0 3B C6 74 58 50 E8 ?? ?? ?? ?? 8B F8 47 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 2A FF 75 E0 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 45 0C 3B C6 74 02 89 38 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__set_error_mode"
		size = 75
		refs = "001a ___error_mode 002e __errno 003e __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 7C 1E 83 F9 02 7E 0C 83 F9 03 75 14 A1 ?? ?? ?? ?? EB 28 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_207_3_0 {
	meta:
		name = "__mbctoupper_l"
		size = 166
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0066 ___crtLCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 61 8B C3 C1 E8 08 0F B6 C8 88 45 FC 8B 45 EC 88 5D FD F6 44 01 1D 04 75 11 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C3 EB 5B 6A 01 FF 70 04 8D 4D F8 6A 02 51 6A 02 8D 4D FC 51 68 00 02 00 00 FF 70 0C 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 C6 0F B6 45 F8 0F B6 4D F9 C1 E0 08 03 C1 EB 16 8B 45 EC 03 C3 F6 40 1D 20 74 09 0F B6 80 1D 01 00 00 EB 02 8B C3 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "_vscanf"
		size = 134
		refs = "0003 __sehtable$_vscanf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 003f __lock_file2 0070 __SEH_epilog4 007f __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 33 F6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "_vwscanf"
		size = 134
		refs = "0003 __sehtable$_vwscanf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 003f __lock_file2 0070 __SEH_epilog4 007f __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 33 F6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "_scanf"
		size = 29
		refs = "000f __input_l 0014 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_209_3_0 {
	meta:
		name = "_scanf_s"
		size = 29
		refs = "000f __input_s_l 0014 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_627_1_0 {
	meta:
		name = "_wscanf"
		size = 29
		refs = "000f __winput_l 0014 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_627_3_0 {
	meta:
		name = "_wscanf_s"
		size = 29
		refs = "000f __winput_s_l 0014 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_209_2_0 {
	meta:
		name = "__scanf_l"
		size = 30
		refs = "0010 __input_l 0015 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_209_4_0 {
	meta:
		name = "__scanf_s_l"
		size = 30
		refs = "0010 __input_s_l 0015 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_627_2_0 {
	meta:
		name = "__wscanf_l"
		size = 30
		refs = "0010 __winput_l 0015 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_627_4_0 {
	meta:
		name = "__wscanf_s_l"
		size = 30
		refs = "0010 __winput_s_l 0015 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__findfirst64"
		size = 333
		refs = "000c ___security_cookie 0024 __errno 0034 __invalid_parameter 0051 __imp__FindFirstFileA@8 0062 __imp__GetLastError@0 00bd ___time64_t_from_ft 00f9 __allmul 0120 _strcpy_s 0132 __invoke_watson 0147 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 FC 00 00 00 3B C7 74 DC 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 F8 FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B2 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A5 E8 ?? ?? ?? ?? 89 30 EB 9C 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 53 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 D8 FE FF FF 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 DB 03 C1 89 46 20 13 D3 8D 85 E8 FE FF FF 50 89 56 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 0C 5B 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 B8 FE FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__findnext64"
		size = 333
		refs = "000c ___security_cookie 0026 __errno 0038 __invalid_parameter 005d __imp__FindNextFileA@8 0067 __imp__GetLastError@0 00c1 ___time64_t_from_ft 00fd __allmul 0124 _strcpy_s 0135 __invoke_watson 0147 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 83 CB FF 57 3B C3 75 21 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C3 E9 F8 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D9 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 D8 FE FF FF 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 DB 03 C1 89 46 20 13 D3 8D 85 E8 FE FF FF 50 89 56 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_211_3_0 {
	meta:
		name = "__mbccpy_s_l"
		size = 280
		refs = "0022 __errno 0031 __invalid_parameter 0069 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0076 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 83 EC 10 53 33 DB 56 3B C3 74 02 89 18 8B 75 08 3B F3 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 D5 00 00 00 57 8B 7D 14 3B FB 75 1B 88 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 EB 79 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 74 38 5F 01 75 29 8B 45 10 88 1E 3B C3 74 06 C7 00 01 00 00 00 E8 ?? ?? ?? ?? 6A 2A 59 89 08 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C1 EB 65 6A 02 59 39 4D 0C 73 29 88 1E E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 34 8A 07 88 06 8A 47 01 88 46 01 8B 45 10 3B C3 74 15 89 08 EB 11 8A 07 88 06 8B 45 10 3B C3 74 06 C7 00 01 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "__CIlog_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 ED D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_213_3_0 {
	meta:
		name = "__strnicmp_l"
		size = 242
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0037 __invalid_parameter 009d ___ascii_strnicmp 00be __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 33 DB 56 57 39 5D 10 0F 84 D5 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 99 00 00 00 8B 7D 0C 3B FB 74 CB BE FF FF FF 7F 39 75 10 76 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 60 8B 45 F0 39 58 14 75 1D FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 74 44 8B 4D F8 83 61 70 FD EB 3B 8B 45 08 0F B6 00 8D 4D F0 51 50 E8 ?? ?? ?? ?? FF 45 08 8B F0 0F B6 07 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 47 FF 4D 10 74 08 3B F3 74 04 3B F0 74 CD 2B F0 8B C6 EB B9 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "__strnicmp"
		size = 94
		refs = "000a ___locale_changed 0016 __errno 0026 __invalid_parameter 0045 ___ascii_strnicmp 0054 __strnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_794_4_0 {
	meta:
		name = "__strncoll"
		size = 94
		refs = "000a ___locale_changed 0016 __errno 0026 __invalid_parameter 0045 _strncmp 0054 __strncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_562_4_0 {
	meta:
		name = "__wcsncoll"
		size = 94
		refs = "000a ___locale_changed 0016 __errno 0026 __invalid_parameter 0045 _wcsncmp 0054 __wcsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__frnd"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 D9 FC DD 5D F8 DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "_has_osfxsr_set"
		size = 80
		refs = "0003 __sehtable$_has_osfxsr_set 0008 __SEH_prolog4 004b __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 66 0F 28 C1 C7 45 E4 01 00 00 00 EB 23 8B 45 EC 8B 00 8B 00 3D 05 00 00 C0 74 0A 3D 1D 00 00 C0 74 03 33 C0 C3 33 C0 40 C3 8B 65 E8 83 65 E4 00 C7 45 FC FE FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "__get_sse2_info"
		size = 98
		refs = "0050 _has_osfxsr_set"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 33 C0 53 89 45 FC 89 45 F4 89 45 F8 53 9C 58 8B C8 35 00 00 20 00 50 9D 9C 5A 2B D1 74 1F 51 9D 33 C0 0F A2 89 45 F4 89 5D E8 89 55 EC 89 4D F0 B8 01 00 00 00 0F A2 89 55 FC 89 45 F8 5B F7 45 FC 00 00 00 04 74 0E E8 ?? ?? ?? ?? 85 C0 74 05 33 C0 40 EB 02 33 C0 5B C9 C3 }
	condition:
		$1
}

rule file_217_3_0 {
	meta:
		name = "__mbsset_s_l"
		size = 345
		refs = "001d __errno 002c __invalid_parameter 0041 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0055 __strset_s 0094 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 8B 7D 08 33 DB 89 5D F8 3B FB 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 1A 01 00 00 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 24 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F4 0F 84 EF 00 00 00 8B 4D F0 83 61 70 FD E9 E3 00 00 00 8B 45 0C 89 45 FC 8B 45 10 C1 E8 08 8B F7 88 45 0B 3A C3 74 40 38 5D 10 74 4F 8D 4D E8 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 3C 38 1F 74 6C FF 4D FC 74 67 8D 46 01 38 18 74 3F FF 4D FC 8A 4D 0B 88 0E 8B F0 74 59 8A 45 10 88 06 46 38 1E 75 DE EB 48 8D 45 E8 50 0F B6 45 10 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 21 88 1F E8 ?? ?? ?? ?? 8B C8 6A 2A 58 89 01 E9 6F FF FF FF FF 45 FC 88 1E C7 45 F8 01 00 00 00 EB 13 38 1F 74 0F FF 4D FC 74 0A 8A 45 10 88 06 46 38 1E 75 F1 39 5D FC 75 2E 88 1F E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 0F 84 FE FE FF FF 8B 45 F0 83 60 70 FD E9 F2 FE FF FF 39 5D F8 75 96 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "__floor_default"
		size = 213
		refs = "0011 _newcw 0016 __ctrlfp 0036 __sptype 0056 __handle_qnan1 0073 __real@3ff0000000000000 008b __frnd 00ca __except1"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 45 08 59 59 8B 4D 0E 8B D8 B8 F0 7F 00 00 23 C8 51 51 DD 1C 24 66 3B C8 75 55 E8 ?? ?? ?? ?? 59 59 85 C0 7E 2D 83 F8 02 7E 1A 83 F8 03 75 23 DD 45 08 53 51 51 DD 1C 24 6A 0B E8 ?? ?? ?? ?? 83 C4 10 EB 72 56 53 E8 ?? ?? ?? ?? DD 45 08 59 59 EB 64 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 08 EB 3F E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 59 DC 5D F8 59 DF E0 F6 C4 44 7A 0E 56 53 E8 ?? ?? ?? ?? DD 45 F8 59 59 EB 22 F6 C3 20 75 ED DD 45 F8 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "__cfltcvt_init"
		size = 96
		refs = "0001 __cfltcvt 0006 __cfltcvt_tab 0010 __cropzeros 001a __fassign 0024 __forcdecpt 002e __positive 003d __cfltcvt_l 0047 __fassign_l 0051 __cropzeros_l 005b __forcdecpt_l"
	strings:
		$1 = { B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "___setfflag"
		size = 21
		refs = "0009 ___fastflag"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_434_1_0 {
	meta:
		name = "__set_malloc_crt_max_wait"
		size = 21
		refs = "0009 __maxwait"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "__fpmath"
		size = 35
		refs = "0006 __cfltcvt_init 000b __ms_p5_mp_test_fdiv 0014 __adjust_fdiv 001b __setdefaultprecision"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 08 00 A3 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? DB E2 5D C3 }
	condition:
		$1
}

rule file_223_2_0 {
	meta:
		name = "__strerror"
		size = 242
		refs = "0009 __getptd_noexit 002b __calloc_crt 0058 __mbsnbcat_s 0069 __invoke_watson 0071 ??_C@_02LMMGGCAJ@?3?5?$AA@ 0078 _strcat_s 0091 __errno 0098 __get_sys_err_msg 00a1 _strlen 00b3 _strncat_s 00cc ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 E8 ?? ?? ?? ?? 8B F8 33 DB 3B FB 75 07 33 C0 E9 D2 00 00 00 56 BE 86 00 00 00 39 5F 24 75 18 6A 01 56 E8 ?? ?? ?? ?? 59 59 89 47 24 3B C3 75 07 33 C0 E9 AE 00 00 00 8B 45 08 8B 7F 24 88 1F 3B C3 74 45 38 18 74 41 68 82 00 00 00 50 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 57 89 45 FC E8 ?? ?? ?? ?? B9 84 00 00 00 2B C8 51 FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C7 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_223_3_0 {
	meta:
		name = "__strerror_s"
		size = 183
		refs = "0012 __errno 0021 __invalid_parameter 0045 _strlen 0057 _strcpy_s 0068 __invoke_watson 0070 ??_C@_02LMMGGCAJ@?3?5?$AA@ 0077 _strcat_s 00ab _strerror_s"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 7D 08 33 DB 3B FB 75 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 83 00 00 00 8B 75 0C 3B F3 76 DB 8B 45 10 88 1F 3B C3 74 50 38 18 74 4C 50 E8 ?? ?? ?? ?? 59 8D 4E F9 3B C1 73 3E FF 75 10 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 30 57 E8 ?? ?? ?? ?? 59 2B F0 56 57 E8 ?? ?? ?? ?? 59 03 C7 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__close_nolock"
		size = 156
		refs = "000c __get_osfhandle 0017 ___pioinfo 0054 __imp__CloseHandle@4 005e __imp__GetLastError@0 006a __free_osfhnd 008c __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 50 A1 ?? ?? ?? ?? 83 FE 01 75 09 F6 80 84 00 00 00 01 75 0B 83 FE 02 75 1C F6 40 44 01 74 16 6A 02 E8 ?? ?? ?? ?? 6A 01 8B F8 E8 ?? ?? ?? ?? 59 59 3B C7 74 1C 56 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 8B F8 EB 02 33 FF 56 E8 ?? ?? ?? ?? 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 59 C6 44 30 04 00 85 FF 74 0C 57 E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "__close"
		size = 205
		refs = "0003 __sehtable$__close 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 0095 __close_nolock 00be __SEH_epilog4 00c7 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 8E 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 0E FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 EB 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_228_2_0 {
	meta:
		name = "__spawnvpe"
		size = 632
		refs = "0019 __errno 0029 __invalid_parameter 008a __spawnve 00b1 __mbschr 00c0 ??_C@_04HBHDLLBA@PATH?$AA@ 00ca __dupenv_s 00e4 __invoke_watson 0101 __calloc_crt 0129 _strlen 013c __mbsrchr 0147 ??_C@_01KICIPPFI@?2?$AA@ 0152 _strcat_s 0232 __getpath 025d _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 0C 53 33 DB 56 33 F6 89 5D FC 3B C3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3C 02 00 00 38 18 74 DC 57 8B 7D 10 3B FB 74 0A 8B 07 3B C3 74 04 38 18 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 05 02 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 F0 E8 ?? ?? ?? ?? FF 75 14 89 18 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 0F 85 A7 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 99 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 85 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 1B 83 F8 16 0F 85 66 01 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 54 01 00 00 39 5D FC 0F 84 4B 01 00 00 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 59 59 3B F3 0F 84 33 01 00 00 68 03 01 00 00 56 FF 75 FC E9 12 01 00 00 38 1E 0F 84 1D 01 00 00 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 59 3C 5C 75 23 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 3D 68 ?? ?? ?? ?? 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C EB 28 3C 2F 74 24 68 ?? ?? ?? ?? 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? FF 75 0C 8B F8 E8 ?? ?? ?? ?? 03 F8 B8 04 01 00 00 59 59 3B F8 0F 83 A0 00 00 00 FF 75 0C 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 75 14 89 18 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 75 61 E8 ?? ?? ?? ?? 83 38 02 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F0 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F0 75 3B 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 59 59 3B F8 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 59 59 3B F8 75 1C 68 03 01 00 00 56 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C3 0F 85 DB FE FF FF E8 ?? ?? ?? ?? 39 18 75 0A E8 ?? ?? ?? ?? 8B 4D F0 89 08 3B F3 74 07 56 E8 ?? ?? ?? ?? 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__fstat32i64"
		size = 844
		refs = "0003 __sehtable$__fstat32i64 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 004b _memset 0074 __nhandle 0096 ___pioinfo 00b3 ___lock_fhandle 00e7 __SEH_epilog4 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0171 __imp__PeekNamedPipe@24 01b8 __imp__GetFileInformationByHandle@8 01f7 __imp__FileTimeToLocalFileTime@8 020d __imp__FileTimeToSystemTime@8 023a ___loctotime32_t 0318 __allmul 0346 __unlock_fhandle"
	strings:
		$1 = { 6A 5C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 0C 3B F7 0F 95 C0 3B C7 75 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 6A 30 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 F9 FE 75 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D0 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB A3 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 89 45 0C 8B D9 83 E3 1F C1 E3 06 8B 00 0F BE 44 18 04 83 E0 01 74 C9 51 E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 8B 00 03 C3 F6 40 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 5F 02 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 91 00 00 00 83 F8 02 74 1D 83 F8 03 74 13 3B C7 74 B8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B4 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4E 06 8B 4D 08 89 0E 89 4E 10 33 C9 41 66 89 4E 08 33 C9 66 89 4E 04 66 89 4E 0C 66 89 4E 0A 89 7E 28 89 7E 24 89 7E 20 83 F8 02 74 29 57 8D 45 0C 50 57 57 57 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 3B C7 74 0F 8B 45 0C 99 89 46 18 89 56 1C E9 4F FF FF FF 89 7E 18 89 7E 1C E9 44 FF FF FF 33 C0 66 89 46 06 66 89 46 0C 66 89 46 0A 66 89 46 04 40 66 89 46 08 8D 45 94 50 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4C FF FF FF 0F B7 46 06 F6 45 94 01 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 46 06 39 7D A8 75 0A 39 7D AC 75 05 89 7E 24 EB 57 8D 45 D8 50 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D0 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BA FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 24 39 7D A0 75 0A 39 7D A4 75 05 8B 46 24 EB 54 8D 45 D8 50 8D 45 A0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 6A FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 54 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 39 7D 98 75 0A 39 7D 9C 75 05 8B 46 24 EB 54 8D 45 D8 50 8D 45 98 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 04 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EE FD FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 28 6A 01 57 57 FF 75 B4 E8 ?? ?? ?? ?? 8B 4D B8 33 DB 03 C1 13 D3 89 46 18 89 56 1C 0F B7 46 06 0D 00 80 00 00 66 89 46 06 89 3E 89 7E 10 E9 95 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_230_3_0 {
	meta:
		name = "__ismbclegal_l"
		size = 71
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 C1 E8 08 0F B6 C8 8B 45 F4 F6 44 01 1D 04 74 10 0F B6 4D 08 F6 44 01 1D 08 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_231_1_0 {
	meta:
		name = "___getlocaleinfo"
		size = 383
		refs = "000c ___security_cookie 0053 ___crtGetLocaleInfoA 0062 __imp__GetLastError@0 0096 __calloc_crt 00ea _free 00fb @__security_check_cookie@4 0109 _strncpy_s 011a __invoke_watson 013d ?wcbuffer@?4??__getlocaleinfo@@9@9 014a ___crtGetLocaleInfoW 015e _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 94 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 18 33 DB 83 7D 0C 01 57 89 85 74 FF FF FF 89 B5 6C FF FF FF 0F 85 FE 00 00 00 53 68 80 00 00 00 8D BD 7C FF FF FF 8B CF 51 FF 75 14 89 9D 78 FF FF FF FF 75 10 50 E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B F3 75 6A FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 80 00 00 00 53 53 53 FF 75 14 FF 75 10 FF B5 74 FF FF FF E8 ?? ?? ?? ?? 83 C4 18 89 85 70 FF FF FF 3B C3 74 5F 33 F6 46 56 50 E8 ?? ?? ?? ?? 8B F8 59 59 3B FB 74 4D 53 FF B5 70 FF FF FF 89 B5 78 FF FF FF 57 FF 75 14 FF 75 10 FF B5 74 FF FF FF E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B F3 74 1E 6A 01 56 E8 ?? ?? ?? ?? 59 59 8B 8D 6C FF FF FF 89 01 3B C3 75 21 39 9D 78 FF FF FF 74 07 57 E8 ?? ?? ?? ?? 59 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8D 4E FF 51 57 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 9D 78 FF FF FF 74 07 57 E8 ?? ?? ?? ?? 59 33 C0 EB BE 39 5D 0C 75 B6 53 6A 04 BF ?? ?? ?? ?? 57 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 9A 88 1E 8A 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 C9 8A 06 B1 0A F6 E9 02 C3 2C 30 47 47 81 FF ?? ?? ?? ?? 88 06 7C DA EB B1 }
	condition:
		$1
}

rule file_233_3_0 {
	meta:
		name = "__ismbchira_l"
		size = 66
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 12 8B 45 08 05 61 7D FF FF 83 F8 52 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_233_5_0 {
	meta:
		name = "__ismbckata_l"
		size = 74
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 C0 7C FF FF 83 F9 56 77 0C 3D 7F 83 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_233_7_0 {
	meta:
		name = "__ismbcsymbol_l"
		size = 74
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 BF 7E FF FF 83 F9 6B 77 0C 3D 7F 81 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__fileno"
		size = 50
		refs = "0010 __errno 0020 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 03 8B 40 10 5E 5D C3 }
	condition:
		$1
}

rule file_235_2_0 {
	meta:
		name = "__wcenvarg"
		size = 1045
		refs = "0009 ___security_cookie 002e ??_C@_1BG@FIGGICF@?$AAS?$AAy?$AAs?$AAt?$AAe?$AAm?$AAR?$AAo?$AAo?$AAt?$AA?$AA@ 0052 _wcslen 006b __calloc_crt 0080 __errno 008b ___doserrno 00a7 __wdupenv_s 00bd __invoke_watson 0115 __wenvptr 011e ___crtGetEnvironmentStringsW 0132 _free 0169 _wcscpy_s 022c __wcsnicmp 0306 _memcpy 0381 ??_C@_13NMPKAAJP@?$AA?$DN?$AA?$AA@ 0388 _wcscat_s 040f @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 8B 45 08 53 56 57 89 4D C8 8B 4D 10 89 4D CC 8B 4D 14 6A 05 89 4D E0 59 BE ?? ?? ?? ?? 8D 7D E4 F3 A5 33 DB 66 A5 6A 02 89 45 B8 8B F8 8B 00 89 5D D0 89 5D DC 89 5D C0 5E EB 10 50 E8 ?? ?? ?? ?? 83 C7 04 8D 74 06 01 8B 07 59 3B C3 75 EC 6A 02 56 89 75 B4 E8 ?? ?? ?? ?? 8B 75 CC 59 59 89 06 3B C3 75 23 8B 45 E0 89 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 69 03 00 00 8D 45 E4 50 8D 45 DC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 14 83 F8 16 75 74 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 65 8D 45 E4 50 E8 ?? ?? ?? ?? 8B F8 47 47 59 89 7D C4 39 5D DC 74 0E FF 75 DC E8 ?? ?? ?? ?? 03 F8 59 89 7D C4 8B 7D C8 3B FB 74 52 C7 45 D8 02 00 00 00 EB 14 50 E8 ?? ?? ?? ?? 59 8B 4D D8 8D 44 01 01 89 45 D8 83 C7 04 8B 07 3B C3 75 E6 A1 ?? ?? ?? ?? 3B C3 75 7A E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 3B C3 75 6C FF 36 83 4D D0 FF E8 ?? ?? ?? ?? 8B 45 E0 89 1E 59 89 18 E9 9C 02 00 00 8B 45 E0 8B 7D BC 89 18 8B 5D B8 8B 03 8B 36 85 C0 0F 84 79 01 00 00 8B 4D B4 50 8B C6 2B C6 D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 33 E8 ?? ?? ?? ?? 59 8D 74 46 02 83 C3 04 E9 3E 01 00 00 6A 3D 89 5D D4 5E 66 39 18 74 2B 0F B7 10 8B C8 66 3B D6 74 21 51 E8 ?? ?? ?? ?? 59 8B 4D D4 8D 4C 01 01 A1 ?? ?? ?? ?? 89 4D D4 8D 0C 48 0F B7 11 66 3B D3 75 DA 8B 7D D4 8B CF 8D 0C 48 EB 2C 66 39 59 02 74 2B 66 83 7C 78 04 3A 75 23 66 39 74 78 06 75 1C 8D 44 78 08 50 E8 ?? ?? ?? ?? 8D 7C 07 05 A1 ?? ?? ?? ?? 59 8D 0C 78 66 39 31 74 CF 8B 75 C8 8B C7 2B 45 D4 01 45 D8 8B 45 D8 89 45 BC EB 1F 8D 45 E4 50 E8 ?? ?? ?? ?? 50 8D 45 E4 50 FF 36 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 50 83 C6 04 39 1E 75 DD 8B 45 D8 03 45 C4 6A 02 50 E8 ?? ?? ?? ?? 8B 75 CC 59 59 8B 4D E0 89 01 3B C3 0F 85 ED FE FF FF FF 36 E8 ?? ?? ?? ?? 59 89 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 4D D0 FF C7 00 08 00 00 00 E9 58 01 00 00 8B 45 D8 C7 45 C0 01 00 00 00 EB B1 8B 4D CC 50 8B C6 2B 01 8B 4D B4 D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 33 E8 ?? ?? ?? ?? 59 8D 34 46 6A 20 58 83 C3 04 66 89 06 46 46 8B 03 85 C0 75 B8 8B 5D C8 66 89 46 FE 66 89 06 8B 45 E0 8B 30 85 DB 0F 84 D4 00 00 00 8B 45 D4 8B 0D ?? ?? ?? ?? 2B F8 03 FF 57 8D 04 41 50 56 E8 ?? ?? ?? ?? 03 F7 83 C4 0C 83 3B 00 8B FB 74 40 8B 4D E0 FF 37 8B C6 2B 01 8B 4D BC D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 33 DB 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 37 E8 ?? ?? ?? ?? 83 C7 04 59 8D 74 46 02 39 1F 75 C0 83 7D C0 00 75 6A 8B 5D C4 8D 45 E4 50 53 56 E8 ?? ?? ?? ?? 83 C4 0C 33 FF 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 39 7D DC 74 1E FF 75 DC 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 34 5E 85 F6 74 13 8B 45 E0 3B 30 75 07 33 C0 66 89 06 46 46 33 C0 66 89 06 33 DB A1 ?? ?? ?? ?? 3B C3 74 07 50 E8 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 39 5D DC 74 09 FF 75 DC E8 ?? ?? ?? ?? 59 8B 45 D0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_236_9_0 {
	meta:
		name = "__whiteout"
		size = 50
		refs = "000c __fgetwc_nolock 0022 _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 57 FF 75 08 FF 06 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 59 66 3B F8 74 0E 6A 08 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 DA 66 8B C7 5F 5D C3 }
	condition:
		$1
}

rule file_236_10_0 {
	meta:
		name = "__winput_s_l"
		size = 4641
		refs = "000c ___security_cookie 006d __errno 007d __invalid_parameter 009a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00c2 _iswctype 00e5 __whiteout 00ef __un_inc 01a9 _isdigit 0345 __fgetwc_nolock 0505 ___check_float_string 0567 __mbtowc_l 087c __malloc_crt 089b _wcstombs_s 08b6 __invoke_watson 08d6 __cfltcvt_tab 08db __decode_pointer 08e4 _free 0aca _memset 0cc8 _wctomb_s 0e3e __allmul 0e61 _isxdigit 0e8b __hextodec 121b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 14 8B 45 08 53 8B 5D 0C 56 33 F6 89 8D D8 FC FF FF 8D 8D 40 FD FF FF 89 85 24 FD FF FF 89 9D 04 FD FF FF 89 8D 1C FD FF FF C7 85 E8 FC FF FF 5E 01 00 00 89 B5 EC FC FF FF 89 B5 E0 FC FF FF 89 B5 C8 FC FF FF 89 B5 30 FD FF FF 89 B5 CC FC FF FF 3B DE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 87 11 00 00 3B C6 74 DC FF 75 10 8D 8D B8 FC FF FF E8 ?? ?? ?? ?? 0F B7 03 C6 85 22 FD FF FF 00 89 B5 38 FD FF FF 89 B5 F0 FC FF FF 66 3B C6 0F 84 3D 11 00 00 57 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 4D FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 24 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 50 E8 ?? ?? ?? ?? 8B B5 04 FD FF FF 59 59 46 46 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ED 89 B5 04 FD FF FF E9 E2 0F 00 00 8B B5 04 FD FF FF 0F B7 06 6A 25 59 8B D1 66 3B D0 0F 85 64 0F 00 00 66 3B 56 02 0F 84 5A 0F 00 00 33 FF 89 BD F8 FC FF FF 89 BD E4 FC FF FF 89 BD 18 FD FF FF 89 BD FC FC FF FF 89 BD 2C FD FF FF 89 BD F4 FC FF FF C6 85 0B FD FF FF 00 C6 85 21 FD FF FF 00 C6 85 2B FD FF FF 00 C6 85 3F FD FF FF 00 C6 85 23 FD FF FF 00 C6 85 37 FD FF FF 00 C6 85 2A FD FF FF 01 89 BD 0C FD FF FF 46 46 0F B7 1E F7 C3 00 FF 00 00 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 2C FD FF FF FF 85 FC FC FF FF 6B C0 0A 8D 44 18 D0 89 85 2C FD FF FF E9 D0 00 00 00 83 FB 4E 0F 8F 8D 00 00 00 0F 84 C1 00 00 00 83 FB 2A 74 7A 83 FB 46 0F 84 B3 00 00 00 83 FB 49 74 10 83 FB 4C 75 7E FE 85 2A FD FF FF E9 9E 00 00 00 0F B7 4E 02 66 83 F9 36 75 1F 8D 46 04 66 83 38 34 75 16 FF 85 0C FD FF FF 8B F0 89 BD 10 FD FF FF 89 BD 14 FD FF FF EB 75 66 83 F9 33 75 0D 8D 46 04 66 83 38 32 75 04 8B F0 EB 62 66 83 F9 64 74 5C 66 83 F9 69 74 56 66 83 F9 6F 74 50 66 83 F9 78 74 4A 66 83 F9 58 75 19 EB 42 FE 85 2B FD FF FF EB 3A 83 FB 68 74 29 83 FB 6C 74 0D 83 FB 77 74 17 FE 85 3F FD FF FF EB 23 8D 46 02 66 83 38 6C 74 8F FE 85 2A FD FF FF FE 85 37 FD FF FF EB 0C FE 8D 2A FD FF FF FE 8D 37 FD FF FF 80 BD 3F FD FF FF 00 0F 84 EA FE FF FF 80 BD 2B FD FF FF 00 89 B5 04 FD FF FF 75 19 8B 85 D8 FC FF FF 8B 18 89 85 D4 FC FF FF 83 C0 04 89 85 D8 FC FF FF EB 02 33 DB 80 BD 37 FD FF FF 00 89 9D 00 FD FF FF C6 85 3F FD FF FF 00 75 1D 0F B7 06 66 83 F8 53 74 0D C6 85 37 FD FF FF 01 66 83 F8 43 75 07 C6 85 37 FD FF FF FF 0F B7 3E 83 CF 20 89 BD DC FC FF FF 83 FF 6E 74 58 83 FF 63 74 18 83 FF 7B 74 13 FF B5 24 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 11 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 B9 FF FF 00 00 89 85 30 FD FF FF 66 3B C8 0F 84 13 0E 00 00 8B 9D 00 FD FF FF 8B B5 04 FD FF FF 8B BD DC FC FF FF 8B 8D FC FC FF FF 85 C9 74 0D 83 BD 2C FD FF FF 00 0F 84 D7 0D 00 00 80 BD 2B FD FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 D4 FC FF FF 8B 18 83 C0 04 89 85 D4 FC FF FF 83 C0 04 89 85 D8 FC FF FF 8B 40 FC 89 9D 00 FD FF FF 89 85 F4 FC FF FF 83 F8 01 0F 82 35 0D 00 00 83 FF 6F 0F 8F 34 06 00 00 0F 84 87 09 00 00 83 FF 63 0F 84 04 05 00 00 83 FF 64 0F 84 75 09 00 00 0F 8E 40 06 00 00 83 FF 67 7E 47 83 FF 69 74 21 83 FF 6E 0F 85 2D 06 00 00 80 BD 2B FD FF FF 00 8B 85 38 FD FF FF 0F 84 31 0C 00 00 E9 58 0C 00 00 6A 64 5F 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 0F 85 7F 07 00 00 C6 85 21 FD FF FF 01 E9 7B 07 00 00 6A 2D 58 33 DB 66 3B 85 30 FD FF FF 75 0C 8B 8D 1C FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 21 FF 8D 2C FD FF FF FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF 83 BD FC FC FF FF 00 75 07 83 8D 2C FD FF FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 8C 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 6A 66 0F BE 85 30 FD FF FF 8B 8D 1C FD FF FF FF 85 18 FD FF FF 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 60 0C 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 74 FF FF FF 8D 85 B8 FC FF FF 50 8B 85 B8 FC FF FF C7 85 D0 FC FF FF 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 85 D0 FC FF FF 50 E8 ?? ?? ?? ?? 0F B7 85 D0 FC FF FF 0F BE 8D 30 FD FF FF 83 C4 10 3B C1 0F 85 06 01 00 00 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 F2 00 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 8B 8D 1C FD FF FF 0F B7 C0 89 85 30 FD FF FF 66 8B 85 D0 FC FF FF 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 85 0B 00 00 F7 85 30 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 69 8B 85 1C FD FF FF 66 8B 8D 30 FD FF FF FF 85 18 FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 10 0B 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF 83 BD 18 FD FF FF 00 0F 84 94 01 00 00 6A 65 58 66 3B 85 30 FD FF FF 74 10 6A 45 58 66 3B 85 30 FD FF FF 0F 85 78 01 00 00 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 64 01 00 00 8B 8D 1C FD FF FF 6A 65 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 74 0A 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 C0 6A 2D 59 89 85 30 FD FF FF 66 3B C8 75 2E 51 8B 8D 1C FD FF FF 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 25 0A 00 00 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 33 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 75 08 21 85 2C FD FF FF EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 69 8B 85 1C FD FF FF 66 8B 8D 30 FD FF FF FF 85 18 FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 6F 09 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 30 FD FF FF E8 ?? ?? ?? ?? 83 BD 18 FD FF FF 00 59 59 0F 84 23 09 00 00 80 BD 2B FD FF FF 00 0F 85 20 08 00 00 8B B5 E8 FC FF FF 8B 8D 1C FD FF FF FF 85 F0 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 E9 08 00 00 8D 46 FF 50 FF B5 1C FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 85 B8 FC FF FF 50 0F BE 85 2A FD FF FF 57 FF B5 00 FD FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 8E 07 00 00 85 C9 75 10 FF 85 2C FD FF FF C7 85 FC FC FF FF 01 00 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 23 FD FF FF 01 FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 30 FD FF FF 8B F3 E8 ?? ?? ?? ?? 59 59 83 FF 63 74 06 FF 8D F4 FC FF FF 83 BD FC FC FF FF 00 74 14 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 BD 03 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D0 B8 FF FF 00 00 59 89 95 30 FD FF FF 66 3B C2 0F 84 80 03 00 00 83 FF 63 74 55 83 FF 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 66 03 00 00 66 83 FA 20 75 3A 83 FF 7B 0F 85 57 03 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 8D E0 FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 0B FD FF FF 33 C1 85 F8 0F 84 2C 03 00 00 8B BD DC FC FF FF 80 BD 2B FD FF FF 00 0F 85 12 03 00 00 83 BD F4 FC FF FF 00 0F 84 4D 07 00 00 80 BD 23 FD FF FF 00 0F 84 B0 02 00 00 66 89 13 43 43 89 9D 00 FD FF FF E9 23 FF FF FF 8B C7 83 E8 70 0F 84 47 03 00 00 83 E8 03 0F 84 DF FE FF FF 48 48 0F 84 3D 03 00 00 83 E8 03 0F 84 F3 F9 FF FF 83 E8 03 74 33 8B 85 30 FD FF FF 66 39 06 0F 85 DF 06 00 00 FE 8D 22 FD FF FF 80 BD 2B FD FF FF 00 0F 85 21 06 00 00 8B 85 D4 FC FF FF 89 85 D8 FC FF FF E9 10 06 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 23 FD FF FF 01 46 6A 5E 46 58 66 3B 06 75 0A 83 C6 02 C6 85 0B FD FF FF FF 8B 9D E0 FC FF FF 85 DB 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 E0 FC FF FF 85 C0 0F 84 BF 06 00 00 C7 85 C8 FC FF FF 01 00 00 00 8B D8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 59 8B C1 66 3B 06 0F 85 AE 00 00 00 46 89 8D E4 FC FF FF 46 C6 43 0B 20 E9 9D 00 00 00 0F B7 C0 46 6A 2D 59 46 66 3B C8 75 71 8B 95 E4 FC FF FF 66 85 D2 74 66 0F B7 0E 6A 5D 5F 66 3B F9 74 5B 0F B7 C9 46 46 66 3B D1 73 05 0F B7 C1 EB 0C 0F B7 C2 0F B7 D1 89 95 E4 FC FF FF 66 3B D0 77 32 2B 85 E4 FC FF FF 0F B7 BD E4 FC FF FF 40 0F B7 C0 89 85 0C FD FF FF 8B CF 83 E1 07 8B C7 B2 01 D2 E2 C1 E8 03 03 C3 08 10 47 FF 8D 0C FD FF FF 75 E5 83 A5 E4 FC FF FF 00 EB 1C 0F B7 C8 89 8D E4 FC FF FF 0F B7 C8 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 6A 5D 59 0F B7 06 66 3B C8 0F 85 57 FF FF FF 66 83 3E 00 0F 84 D1 05 00 00 8B 9D 00 FD FF FF 8B BD DC FC FF FF 89 B5 04 FD FF FF E9 5A FD FF FF 6A 2B 58 66 3B C3 75 30 FF 8D 2C FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF 6A 30 58 66 3B C3 0F 85 BB 01 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 6A 78 58 89 9D 30 FD FF FF 66 3B C3 74 4E 6A 58 58 66 3B C3 74 46 C7 85 18 FD FF FF 01 00 00 00 83 FF 78 74 1B 83 BD FC FC FF FF 00 74 0E FF 8D 2C FD FF FF 75 06 FE 85 3F FD FF FF 6A 6F EB 58 FF B5 24 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 44 01 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD FC FC FF FF 00 0F B7 D8 59 89 9D 30 FD FF FF 74 16 83 AD 2C FD FF FF 02 83 BD 2C FD FF FF 01 7D 06 FE 85 3F FD FF FF 6A 78 5F E9 08 01 00 00 83 A5 0C FD FF FF 00 52 FF B5 F4 FC FF FF 8D 85 0C FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 69 04 00 00 8B 85 0C FD FF FF 85 C0 0F 8E 54 FC FF FF 03 D8 29 85 F4 FC FF FF 89 9D 00 FD FF FF E9 41 FC FF FF 46 46 E9 3A FC FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 59 3B F3 0F 84 58 04 00 00 80 BD 2B FD FF FF 00 0F 85 55 03 00 00 FF 85 F0 FC FF FF 83 BD DC FC FF FF 63 0F 84 42 03 00 00 80 BD 23 FD FF FF 00 74 10 8B 8D 00 FD FF FF 33 C0 66 89 01 E9 29 03 00 00 8B 85 00 FD FF FF C6 00 00 E9 1B 03 00 00 C6 85 2A FD FF FF 01 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 75 09 C6 85 21 FD FF FF 01 EB 08 6A 2B 58 66 3B C3 75 30 FF 8D 2C FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 89 9D 30 FD FF FF 83 BD 0C FD FF FF 00 0F 84 62 01 00 00 80 BD 3F FD FF FF 00 0F 85 24 01 00 00 83 FF 78 74 78 83 FF 70 74 73 F7 C3 00 FF 00 00 0F 85 FA 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E8 00 00 00 83 FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 D7 00 00 00 8B 85 10 FD FF FF 8B 8D 14 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 10 FD FF FF 89 8D 14 FD FF FF EB 6C 6A 00 6A 0A FF B5 14 FD FF FF FF B5 10 FD FF FF E8 ?? ?? ?? ?? 89 85 10 FD FF FF 89 95 14 FD FF FF EB 49 F7 C3 00 FF 00 00 0F 85 87 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 10 FD FF FF 8B 8D 14 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 10 FD FF FF 89 8D 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF FF 85 18 FD FF FF 0F B7 C3 83 E8 30 99 01 85 10 FD FF FF 11 95 14 FD FF FF 83 BD FC FC FF FF 00 74 08 FF 8D 2C FD FF FF 74 34 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF E9 F0 FE FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 21 FD FF FF 00 0F 84 1A 01 00 00 8B 85 10 FD FF FF 8B 8D 14 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 10 FD FF FF 89 8D 14 FD FF FF E9 F6 00 00 00 80 BD 3F FD FF FF 00 0F 85 DA 00 00 00 83 FF 78 74 4A 83 FF 70 74 45 F7 C3 00 FF 00 00 0F 85 B0 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 9E 00 00 00 83 FF 6F 75 17 6A 38 58 66 3B C3 0F 86 8D 00 00 00 8B 85 F8 FC FF FF C1 E0 03 EB 3E 8B 85 F8 FC FF FF 6B C0 0A EB 33 F7 C3 00 FF 00 00 75 6F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 61 C1 A5 F8 FC FF FF 04 53 E8 ?? ?? ?? ?? 0F B7 D8 8B 85 F8 FC FF FF 59 89 9D 30 FD FF FF FF 85 18 FD FF FF 83 BD FC FC FF FF 00 0F B7 CB 8D 44 08 D0 89 85 F8 FC FF FF 74 08 FF 8D 2C FD FF FF 74 34 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF E9 3A FF FF FF FF B5 24 FD FF }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__msize"
		size = 163
		refs = "0003 __sehtable$__msize 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 003b ___active_heap 0045 __lock 004f ___sbh_find_block 007e __crtheap 0084 __imp__HeapSize@12 008d __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 5D 08 33 FF 3B DF 0F 95 C0 3B C7 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 53 83 3D ?? ?? ?? ?? 03 75 38 6A 04 E8 ?? ?? ?? ?? 59 89 7D FC 53 E8 ?? ?? ?? ?? 59 89 45 E0 3B C7 74 0B 8B 73 FC 83 EE 09 89 75 E4 EB 03 8B 75 E4 C7 45 FC FE FF FF FF E8 25 00 00 00 39 7D E0 75 10 53 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 8B C6 E8 ?? ?? ?? ?? C3 33 FF 8B 5D 08 8B 75 E4 6A 04 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__fstat32"
		size = 816
		refs = "0003 __sehtable$__fstat32 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 004b _memset 0074 __nhandle 0096 ___pioinfo 00b3 ___lock_fhandle 00e7 __SEH_epilog4 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0179 __imp__PeekNamedPipe@24 01b1 __imp__GetFileInformationByHandle@8 01f0 __imp__FileTimeToLocalFileTime@8 0206 __imp__FileTimeToSystemTime@8 0233 ___loctotime32_t 032a __unlock_fhandle"
	strings:
		$1 = { 6A 5C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 0C 3B F7 0F 95 C0 3B C7 75 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 6A 24 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 F9 FE 75 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D0 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB A3 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 89 45 0C 8B D9 83 E3 1F C1 E3 06 8B 00 0F BE 44 18 04 83 E0 01 74 C9 51 E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 8B 00 03 C3 F6 40 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 43 02 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 8A 00 00 00 83 F8 02 74 1D 83 F8 03 74 13 3B C7 74 B8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B4 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4E 06 8B 4D 08 89 0E 89 4E 10 33 C9 41 66 89 4E 08 33 C9 66 89 4E 04 66 89 4E 0C 66 89 4E 0A 89 7E 20 89 7E 1C 89 7E 18 83 F8 02 75 08 89 7E 14 E9 70 FF FF FF 57 8D 45 0C 50 57 57 57 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? F7 D8 1B C0 23 45 0C 89 46 14 E9 4B FF FF FF 33 C0 66 89 46 06 66 89 46 0C 66 89 46 0A 66 89 46 04 40 66 89 46 08 8D 45 94 50 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 53 FF FF FF 0F B7 46 06 F6 45 94 01 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 46 06 39 7D A8 75 0A 39 7D AC 75 05 89 7E 1C EB 57 8D 45 D8 50 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D7 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C1 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 1C 39 7D A0 75 0A 39 7D A4 75 05 8B 46 1C EB 54 8D 45 D8 50 8D 45 A0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 71 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 5B FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 18 39 7D 98 75 0A 39 7D 9C 75 05 8B 46 1C EB 54 8D 45 D8 50 8D 45 98 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0B FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F5 FD FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 8B 45 B8 89 46 14 0F B7 46 06 0D 00 80 00 00 66 89 46 06 89 3E 89 7E 10 E9 B1 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "__ismbclower_l"
		size = 175
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006a ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6E 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 5B 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 0B F6 45 FC 02 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 16 8B 45 F0 8A 44 08 1D 24 20 33 C9 3C 20 0F 94 C1 80 7D F8 00 8B C1 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__lseek_nolock"
		size = 117
		refs = "000b __get_osfhandle 0016 __errno 0031 __imp__SetFilePointer@16 003e __imp__GetLastError@0 004c __dosmaperr 005e ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF EB 4D 57 FF 75 10 6A 00 FF 75 0C 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF EB 1B 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FD 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "__wspawnvpe"
		size = 578
		refs = "0019 __errno 0029 __invalid_parameter 008c __wspawnve 00b3 _wcschr 00c2 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00cc __wdupenv_s 00e6 __invoke_watson 0104 __calloc_crt 012d _wcslen 0146 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 014d _wcscat_s 01fc __wgetpath 0227 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 0C 56 33 F6 57 33 FF 89 75 FC 3B C6 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 06 02 00 00 66 39 30 74 DB 53 8B 5D 10 3B DE 74 0B 8B 03 3B C6 74 05 66 39 30 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CD 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 EC E8 ?? ?? ?? ?? FF 75 14 89 30 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 0F 85 6F 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 61 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 4D 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 1B 83 F8 16 0F 85 2E 01 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E9 1C 01 00 00 39 75 FC 0F 84 13 01 00 00 6A 02 BB 04 01 00 00 53 E8 ?? ?? ?? ?? 8B F8 59 59 3B FE 0F 84 FA 00 00 00 68 03 01 00 00 57 FF 75 FC E9 D9 00 00 00 66 39 37 0F 84 E3 00 00 00 57 E8 ?? ?? ?? ?? 8D 44 47 FE 0F B7 00 59 66 83 F8 5C 74 26 66 83 F8 2F 74 20 68 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? FF 75 0C 89 45 F0 E8 ?? ?? ?? ?? 59 59 8B 4D F0 03 C8 BB 04 01 00 00 3B CB 0F 83 84 00 00 00 FF 75 0C 53 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 75 14 89 30 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 75 45 E8 ?? ?? ?? ?? 83 38 02 74 1F 0F B7 07 66 83 F8 5C 74 06 66 83 F8 2F 75 2C 0F B7 47 02 66 83 F8 5C 74 06 66 83 F8 2F 75 1C 68 03 01 00 00 57 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C6 0F 85 14 FF FF FF E8 ?? ?? ?? ?? 39 30 75 0A E8 ?? ?? ?? ?? 8B 4D EC 89 08 3B FE 74 07 57 E8 ?? ?? ?? ?? 59 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__ctime64_s"
		size = 138
		refs = "0019 __errno 0028 __invalid_parameter 006c __localtime64_s 007f _asctime_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 8B 75 08 33 DB 3B F3 74 05 39 5D 0C 77 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 53 8B 45 10 88 1E 3B C3 74 DC 8B 48 04 3B CB 8B 10 7F 12 7C 04 3B D3 73 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB D8 83 F9 07 7C 0A 7F ED 81 FA FF 6F 40 93 77 E5 50 8D 45 DC 50 E8 ?? ?? ?? ?? 59 59 3B C3 75 10 8D 45 DC 50 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "__ctime64"
		size = 99
		refs = "0013 __errno 0023 __invalid_parameter 004d __localtime64_s 005c _asctime"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 70 04 7F 13 7C 04 39 30 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB E3 50 8D 45 DC 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 D3 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB C9 }
	condition:
		$1
}

rule file_871_1_0 {
	meta:
		name = "__wctime64"
		size = 99
		refs = "0013 __errno 0023 __invalid_parameter 004d __localtime64_s 005c __wasctime"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 70 04 7F 13 7C 04 39 30 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB E3 50 8D 45 DC 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 D3 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB C9 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "__d_inttype"
		size = 102
		refs = "0010 __fpclass 0023 __frnd 0039 __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 A8 90 75 48 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 5D 08 59 59 DF E0 F6 C4 44 7A 2F DD 45 08 51 DC 0D ?? ?? ?? ?? 51 DD 5D F8 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? DC 5D F8 59 59 DF E0 F6 C4 44 7A 05 6A 02 58 C9 C3 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "__powhlp"
		size = 320
		refs = "0042 __d_inf 00a0 __d_ind 00f0 __d_inttype 0128 __d_mzero"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 56 DC 55 08 33 D2 33 F6 DF E0 DD 45 08 F6 C4 41 75 02 D9 E0 B8 00 00 F0 7F B9 00 00 F0 FF 39 45 14 75 3D 39 55 10 75 7F D9 E8 D8 D1 DF E0 F6 C4 05 7A 11 DD DA DD D9 DD D8 DD 05 ?? ?? ?? ?? E9 E1 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 75 07 DD D8 E9 CF 00 00 00 DD D9 E9 C8 00 00 00 39 4D 14 75 42 39 55 10 75 3D D9 E8 D8 D1 DF E0 F6 C4 05 7A 09 DD D8 DD D8 E9 A7 00 00 00 DD DA DE D9 DF E0 F6 C4 05 8B 45 18 7A 0B DD 05 ?? ?? ?? ?? E9 91 00 00 00 DD 05 ?? ?? ?? ?? 33 F6 DD 18 46 E9 8D 00 00 00 DD D8 39 45 0C 75 26 39 55 08 75 7F DC 55 10 DF E0 F6 C4 05 0F 8B 76 FF FF FF DC 55 10 DF E0 F6 C4 41 8B 45 18 74 5A DD D8 D9 E8 EB 54 DD D8 39 4D 0C 75 59 39 55 08 75 54 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 EE 59 DC 55 10 59 8B C8 DF E0 F6 C4 05 7A 11 DD D8 DD 05 ?? ?? ?? ?? 83 F9 01 75 1B D9 E0 EB 17 DC 55 10 DF E0 F6 C4 41 75 14 83 F9 01 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 45 18 DD 18 EB 08 DD D8 D9 E8 EB F3 DD D8 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_247_2_0 {
	meta:
		name = "__wexecvpe"
		size = 555
		refs = "0017 __errno 0027 __invalid_parameter 0075 __wexecve 008e _wcschr 00bf ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00c9 __wdupenv_s 00e3 __invoke_watson 0100 __calloc_crt 0162 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 016d _wcscat_s 0187 _wcslen 0210 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 08 56 33 F6 89 75 F8 3B DE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 F1 01 00 00 66 39 33 74 DE 57 8B 7D 0C 3B FE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 C6 01 00 00 8B 07 3B C6 74 DD 66 39 30 74 D8 E8 ?? ?? ?? ?? FF 75 10 89 30 57 53 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 0F 85 8B 01 00 00 6A 5C 53 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 79 01 00 00 6A 2F 53 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 67 01 00 00 66 39 33 74 0B 66 83 7B 02 3A 0F 84 57 01 00 00 68 ?? ?? ?? ?? 8D 45 F8 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 1B 83 F8 16 0F 85 38 01 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E9 26 01 00 00 39 75 F8 0F 84 2B 01 00 00 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F8 59 59 89 7D FC 3B FE 0F 84 02 01 00 00 8B 4D F8 EB 1D 66 83 F8 3B 74 22 8D 97 04 02 00 00 39 55 FC 73 17 8B 55 FC 83 45 FC 02 66 89 02 41 41 0F B7 01 89 4D F4 66 3B C6 75 D8 8B 45 FC 33 C9 66 89 08 3B C7 76 03 83 C0 FE 0F B7 00 89 7D FC 66 83 F8 5C 74 2A 66 83 F8 2F 74 24 68 ?? ?? ?? ?? 68 04 01 00 00 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 53 89 45 F0 E8 ?? ?? ?? ?? 59 59 8B 4D F0 03 C8 B8 04 01 00 00 3B C8 73 6A 8B 5D 08 53 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 75 10 89 30 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 74 1F 0F B7 07 66 83 F8 5C 74 06 66 83 F8 2F 75 1C 0F B7 47 02 66 83 F8 5C 74 06 66 83 F8 2F 75 0C 8B 4D F4 66 39 31 0F 85 25 FF FF FF 57 E8 ?? ?? ?? ?? 59 39 75 F8 74 09 FF 75 F8 E8 ?? ?? ?? ?? 59 5F 5E 83 C8 FF 5B C9 C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "___ascii_stricmp"
		size = 57
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 56 8B 75 08 57 0F B6 06 8D 48 BF 46 83 F9 19 77 03 83 C0 20 0F B6 0A 8D 79 BF 42 83 FF 19 77 03 83 C1 20 85 C0 74 04 3B C1 74 DA 5F 2B C1 5E 5D C3 }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "__stricmp_l"
		size = 213
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 0089 ___ascii_stricmp 009e __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 89 00 00 00 57 8B 7D 0C 3B FB 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 55 8B 45 F0 39 58 14 75 0D 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 34 56 8B 45 08 0F B6 00 8D 4D F0 51 50 E8 ?? ?? ?? ?? FF 45 08 8B F0 0F B6 07 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 47 3B F3 74 04 3B F0 74 D2 2B F0 8B C6 5E 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5B C9 C3 }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "__stricmp"
		size = 82
		refs = "000a ___locale_changed 0016 __errno 0026 __invalid_parameter 003c ___ascii_stricmp 0048 __stricmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 30 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 1B 39 75 0C 74 DC 5E 5D E9 ?? ?? ?? ?? 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_770_4_0 {
	meta:
		name = "_wcscoll"
		size = 82
		refs = "000a ___locale_changed 0016 __errno 0026 __invalid_parameter 003c _wcscmp 0048 __wcscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 30 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 1B 39 75 0C 74 DC 5E 5D E9 ?? ?? ?? ?? 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "_fgetc"
		size = 260
		refs = "0003 __sehtable$_fgetc 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0041 __lock_file 0051 __fileno 0070 ___pioinfo 0077 ___badioinfo 00dc __filbuf 00f4 __SEH_epilog4 00fe __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 08 3B F7 0F 95 C0 3B C7 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B4 00 00 00 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 40 75 77 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 7D E4 75 19 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 08 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "_getc"
		size = 260
		refs = "0003 __sehtable$_getc 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0041 __lock_file 0051 __fileno 0070 ___pioinfo 0077 ___badioinfo 00dc __filbuf 00f4 __SEH_epilog4 00fe __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 08 3B F7 0F 95 C0 3B C7 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B4 00 00 00 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 40 75 77 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 7D E4 75 19 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 08 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_250_2_0 {
	meta:
		name = "__getc_nolock"
		size = 32
		refs = "0019 __filbuf"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 FF 4A 04 78 0A 8B 0A 0F B6 01 41 89 0A 5D C3 52 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsA"
		size = 311
		refs = "0006 ?f_use@?1??__crtGetEnvironmentStringsA@@9@9 0011 __imp__GetEnvironmentStringsW@0 0034 __imp__GetLastError@0 007f __imp__WideCharToMultiByte@32 009e __malloc_crt 00c0 _free 00ce __imp__FreeEnvironmentStringsW@4 00e1 __imp__GetEnvironmentStrings@0 0113 __imp__FreeEnvironmentStringsA@4 0122 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC A1 ?? ?? ?? ?? 83 EC 0C 53 56 8B 35 ?? ?? ?? ?? 57 33 DB 33 FF 3B C3 75 2E FF D6 8B F8 3B FB 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 23 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A 6A 02 58 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 01 0F 85 81 00 00 00 3B FB 75 0F FF D6 8B F8 3B FB 75 07 33 C0 E9 CA 00 00 00 8B C7 66 39 1F 74 0E 40 40 66 39 18 75 F9 40 40 66 39 18 75 F2 8B 35 ?? ?? ?? ?? 53 53 53 2B C7 53 D1 F8 40 50 57 53 53 89 45 F4 FF D6 89 45 F8 3B C3 74 2F 50 E8 ?? ?? ?? ?? 59 89 45 FC 3B C3 74 21 53 53 FF 75 F8 50 FF 75 F4 57 53 53 FF D6 85 C0 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 89 5D FC 8B 5D FC 57 FF 15 ?? ?? ?? ?? 8B C3 EB 5C 83 F8 02 74 04 3B C3 75 82 FF 15 ?? ?? ?? ?? 8B F0 3B F3 0F 84 72 FF FF FF 38 1E 74 0A 40 38 18 75 FB 40 38 18 75 F6 2B C6 40 50 89 45 F8 E8 ?? ?? ?? ?? 8B F8 59 3B FB 75 0C 56 FF 15 ?? ?? ?? ?? E9 45 FF FF FF FF 75 F8 56 57 E8 ?? ?? ?? ?? 83 C4 0C 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_fp64_is_qnan"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 0E F7 45 0C 00 00 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "_fp64_is_snan"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 1D F7 45 0C 00 00 08 00 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "_fp64_is_inf"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 14 F7 45 0C FF FF 0F 00 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_3_0 {
	meta:
		name = "_fp64_is_zero"
		size = 29
		altNames = "_iszerod"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C FF FF FF 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_4_0 {
	meta:
		name = "_fp64_is_denormal"
		size = 38
		altNames = "_isdenormald"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C 00 00 F0 7F 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_5_0 {
	meta:
		name = "_RoundDoubleToIntegral"
		size = 537
		refs = "0014 _fp64_is_qnan 0025 _fp64_is_zero 0037 _fp64_is_inf 005f _fp64_is_denormal 00a2 __aullshr 00ad __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 83 EC 1C 53 56 8B 75 10 57 56 52 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 E8 01 00 00 56 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 D6 01 00 00 56 52 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 C5 01 00 00 8B CE C1 E9 14 81 E1 FF 07 00 00 81 F9 33 04 00 00 0F 83 AE 01 00 00 56 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 26 01 00 00 81 F9 FF 03 00 00 0F 82 1A 01 00 00 8D 99 01 FC FF FF 81 E6 FF FF 0F 00 0B F0 6A 34 33 FF 0B FA 59 81 CE 00 00 10 00 2B CB 8B C7 8B D6 89 5D FC 89 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 89 45 E4 E8 ?? ?? ?? ?? 89 45 F4 89 55 F8 83 C3 0C 8B C7 8B D6 8B CB E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 8B 4D 14 6A 00 8B DA 5A 8B F8 6A 01 0B C3 89 5D F0 58 74 04 89 01 EB 02 89 11 6A 33 59 39 4D FC 74 0A 2B 4D FC 33 D2 E8 ?? ?? ?? ?? 8B C8 8B F2 0F A4 CE 01 03 C9 83 7D 08 00 75 4A 39 55 F0 77 36 72 04 3B F8 73 32 8B 45 F4 8B 75 F8 8B 55 FC 8B 4D 10 81 C2 FF 03 00 00 C1 E2 14 81 E2 00 00 F0 7F 81 E6 FF FF 0F 00 0B D6 81 E1 00 00 00 80 0B D1 E9 D1 00 00 00 3B F8 75 2F 39 55 F0 75 2A F6 45 E4 01 EB 22 83 7D 08 01 75 0B F7 45 10 00 00 00 80 74 B2 EB 0F 83 7D 08 02 75 AA F7 45 10 00 00 00 80 75 A1 0B FB 74 9D 03 4D F4 13 75 F8 8B C1 85 C0 75 97 81 FE 00 00 20 00 75 8F FF 45 FC BE 00 00 10 00 EB 85 33 DB 33 C0 43 39 45 08 75 3E BF 00 00 00 80 85 F7 74 1F 81 F9 FE 03 00 00 75 13 F7 C6 FF FF 0F 00 75 04 3B D0 74 07 BA 00 00 F0 BF EB 41 8B D7 EB 3D 81 F9 FE 03 00 00 75 33 F7 C6 FF FF 0F 00 75 20 3B D0 74 27 EB 1A 39 5D 08 75 06 85 F6 79 1C EB D4 83 7D 08 02 BA 00 00 00 80 75 0B 85 F2 75 0D BA 00 00 F0 3F EB 06 85 F2 75 02 33 D2 8B 4D 14 89 19 EB 0A 8B 45 14 83 20 00 8B C2 8B D6 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_252_7_0 {
	meta:
		name = "_isinfd"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_8_0 {
	meta:
		name = "_issnand"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 25 00 00 F8 7F 3D 00 00 F0 7F 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_9_0 {
	meta:
		name = "_isnand"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_10_0 {
	meta:
		name = "_quietd"
		size = 46
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 51 51 0D 00 00 08 00 89 4D F8 89 45 FC DD 45 F8 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_252_12_0 {
	meta:
		name = "_isdenormalf"
		size = 32
		altNames = "_fp32_is_denormal"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 08 00 00 80 7F 75 0E F7 45 08 FF FF 7F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_252_13_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 193
	strings:
		$1 = { 8B 48 20 8B 50 10 33 11 83 E2 03 31 11 8B 50 14 8B 48 20 C1 E2 02 33 11 83 E2 1C 31 11 8B 10 8B 48 20 C1 EA 05 F7 D2 33 51 08 83 E2 01 31 51 08 8B 10 8B 48 20 C1 EA 03 F7 D2 33 51 08 83 E2 02 31 51 08 8B 10 8B 48 20 D1 EA F7 D2 33 51 08 83 E2 04 31 51 08 8B 10 8B 48 20 03 D2 F7 D2 33 51 08 83 E2 08 31 51 08 8B 10 8B 48 20 C1 E2 04 F7 D2 33 51 08 83 E2 10 31 51 08 8B 48 20 83 61 0C FE 8B 48 20 83 61 0C FD 8B 48 20 83 61 0C FB 8B 48 20 83 61 0C F7 8B 48 20 83 61 0C EF 8B 48 20 83 61 04 FE 8B 48 20 83 61 04 FD 8B 48 20 83 61 04 FB 8B 48 20 83 61 04 F7 8B 40 20 83 60 04 EF C3 }
	condition:
		$1
}

rule file_252_14_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 5972
		refs = "001e ___security_cookie 0082 $LN367 0089 $LN475 00af _isdenormald 00ef $LN476 0161 __control87 01fb __statusfp 0225 _Fill_FPIEEE_RECORD 0247 _isnand 0330 _MIN_DOUBLE_NORMALA 0336 _memcpy 033f _MAX_DOUBLE_NORMALA 034e _POSINFDEA 035d _NEGINFDEA 036c _TWO_TO_1536A 037b _TWO_TO_M1536A 0600 _ZERODA 0615 _NZERODA 07ce $LN368 07d5 $LN477 07e0 _issnand 08e4 $LN369 08eb $LN478 0925 $LN370 092c $LN479 0c52 _isdenormalf 0fe7 _MIN_SINGLE_NORMALA 1019 _MAX_SINGLE_NORMALA 1115 _ZEROFA 1127 _NZEROFA 14e2 _fp64_is_qnan 151f _fp64_is_snan 157c _fp64_is_denormal 15fe _RoundDoubleToIntegral 16a3 @__security_check_cookie@4 16b0 $LN351 16b4 $LN40 16b8 $LN74 16bc $LN276 16c0 $LN225 16c4 $LN157 16c8 $LN131 16cc $LN116 16d0 $LN194 16d4 $LN183 16d8 $LN21 16dc $LN1 1704 $LN345 170c $LN344 1714 $LN343 171c $LN342 1724 $LN270 1728 $LN265 1734 $LN228 1738 $LN229"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC B0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 73 08 33 D2 57 89 95 78 FF FF FF DB E3 8B 46 20 8B 08 33 4E 10 89 95 5C FF FF FF 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 89 95 58 FF FF FF 83 E1 1C 31 08 8B 4E 20 8B 39 C1 EF 05 81 E7 FF 0F 00 00 8D 47 B7 89 85 54 FF FF FF 83 F8 23 0F 87 1A 16 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 41 10 8B 79 14 89 45 90 8B 41 30 89 45 98 8B 41 34 89 7D 94 89 45 9C 39 56 0C 74 37 57 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 09 23 FA 83 65 90 00 89 7D 94 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 8B 85 54 FF FF FF 83 F8 07 77 39 FF 24 85 ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 18 B8 00 02 00 00 EB 11 B8 00 01 00 00 EB 0A 33 C0 EB 06 8B 85 58 FF FF FF 0D 1F 00 09 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 66 48 74 44 48 74 22 48 75 7A DB E2 DD 45 90 DD 45 98 DE F9 DD 9D 68 FF FF FF DB E2 DD 45 90 DD 45 98 DE F9 DB 7D A8 EB 5B DB E2 DD 45 90 DD 45 98 DE C9 DD 9D 68 FF FF FF DB E2 DD 45 90 DD 45 98 DE C9 DB 7D A8 EB 3C DB E2 DD 45 90 DD 45 98 DE E9 DD 9D 68 FF FF FF DB E2 DD 45 90 DD 45 98 DE E9 DB 7D A8 EB 1D DB E2 DD 45 90 DD 45 98 DE C1 DD 9D 68 FF FF FF DB E2 DD 45 90 DD 45 98 DE C1 DB 7D A8 E8 ?? ?? ?? ?? 89 85 78 FF FF FF A8 08 74 0A 81 A5 78 FF FF FF FF FF F7 FF 8B 06 A8 01 75 29 F6 85 78 FF FF FF 10 74 20 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 33 C0 40 09 46 04 8B 76 20 83 4E 04 10 E9 59 14 00 00 57 FF 75 90 E8 ?? ?? ?? ?? 8B D0 59 59 85 D2 0F 85 A3 04 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 8E 04 00 00 8B 06 BF 00 00 08 00 A8 02 75 1B 85 BD 78 FF FF FF 74 13 8B C6 E8 ?? ?? ?? ?? 83 4E 04 02 33 C0 40 E9 09 14 00 00 A8 04 75 24 F6 85 78 FF FF FF 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB D0 DD 85 68 FF FF FF DD 9D 70 FF FF FF FF B5 74 FF FF FF FF B5 70 FF FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 3F 8B 46 20 83 48 60 01 DD 85 70 FF FF FF 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 83 4E 04 01 E9 7D 13 00 00 85 BD 78 FF FF FF 74 04 83 4E 04 02 6A 0A 5F 57 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 CC 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 D8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 E4 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 B4 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 48 DB 6D A8 DB 6D F0 D9 E0 DE D9 9B DD BD 7C FF FF FF D9 EE DB 6D A8 DE D9 9B DD 7D 8C DB 6D A8 D9 EE DE D9 9B DD 7D 88 DB 6D F0 DB 6D A8 DE D9 9B DD 7D 84 8B 85 7C FF FF FF B9 00 45 00 00 23 C1 BA 00 01 00 00 66 3B C2 75 0C 8B 45 8C 23 C1 8B FA 66 3B C7 74 16 8B 45 88 23 C1 8B FA 66 3B C7 75 14 8B 45 84 23 C1 66 3B C7 75 0A C7 85 5C FF FF FF 01 00 00 00 DB 6D A8 DB 6D D8 DE D9 9B DD BD 7C FF FF FF DB 6D C0 D9 E0 DB 6D A8 DE D9 9B DD 7D 8C DB 6D A8 DB 6D C0 DE D9 9B DD 7D 88 DB 6D CC DB 6D A8 DE D9 9B DD 7D 84 8B 85 7C FF FF FF 23 C1 8B FA 66 3B C7 75 0A 8B 45 8C 23 C1 66 3B C7 74 16 8B 45 88 23 C1 8B FA 66 3B C7 75 14 8B 45 84 23 C1 66 3B C2 75 0A C7 85 58 FF FF FF 01 00 00 00 8B 06 33 FF A8 10 75 5F 39 BD 5C FF FF FF 74 57 DB 6D A8 DB 6D E4 DE C9 DD 9D 68 FF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 02 8B 46 20 83 4E 04 10 83 48 04 02 8B 4E 20 33 C0 40 09 41 60 DD 85 68 FF FF FF 8B 4E 20 DD 59 50 84 85 78 FF FF FF 0F 84 D7 11 00 00 8B 4E 20 09 41 0C 83 4E 04 20 E9 C8 11 00 00 A8 08 75 31 39 BD 58 FF FF FF 74 29 DB 6D A8 DB 6D B4 DE C9 DD 9D 68 FF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 EB 9B 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 39 48 74 26 48 74 13 48 75 3E DD 45 90 DD 45 98 DE F9 DD 9D 70 FF FF FF EB 2E DD 45 90 DD 45 98 DE C9 DD 9D 70 FF FF FF EB 1E DD 45 90 DD 45 98 DE E9 DD 9D 70 FF FF FF EB 0E DD 45 90 DD 45 98 DE C1 DD 9D 70 FF FF FF E8 ?? ?? ?? ?? 33 C9 8B D0 41 84 D1 74 0B 39 BD 5C FF FF FF 74 03 83 CA 02 F6 06 20 0F 85 B1 00 00 00 84 D1 75 15 39 7E 08 0F 84 A4 00 00 00 39 BD 5C FF FF FF 0F 84 98 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 33 C9 41 09 48 0C 8B 46 20 83 4E 04 20 09 48 04 8B 46 20 09 48 60 39 BD 5C FF FF FF 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 39 BD 58 FF FF FF 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 74 3A 39 BD 5C FF FF FF 74 32 D9 EE DC 95 70 FF FF FF DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 13 DC 9D 70 FF FF FF DF E0 F6 C4 41 75 0C DD 05 ?? ?? ?? ?? DD 9D 70 FF FF FF 8B 46 20 DD 85 70 FF FF FF DD 58 50 8B C1 E9 69 10 00 00 8B 46 20 09 48 60 8B 46 20 F6 C2 02 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD 8B 46 20 F6 C2 04 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 8B 46 20 84 D1 74 09 09 48 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 4F 39 BD 5C FF FF FF 74 47 D9 EE DC 95 70 FF FF FF DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 13 DC 9D 70 FF FF FF DF E0 F6 C4 41 75 0C DD 05 ?? ?? ?? ?? DD 9D 70 FF FF FF 8B 46 20 09 48 0C 83 4E 04 20 8B 46 20 83 48 0C 02 83 4E 04 10 8B 46 20 DD 85 70 FF FF FF DD 58 50 8B 46 20 F6 C2 08 74 0A 83 48 0C 08 83 4E 04 04 EB 04 83 60 0C F7 8B 76 20 83 66 0C EF E9 9F 0F 00 00 8B 46 20 83 48 60 01 85 D2 74 25 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 74 14 8B 45 90 81 CF 00 00 08 00 89 45 98 89 7D 9C DD 45 98 EB 06 DD 85 68 FF FF FF 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 85 78 FF FF FF 10 74 93 E9 AC FB FF FF 8B 79 14 8B 41 10 89 7D 94 8B 79 30 89 7D 98 8B 79 34 89 45 90 89 7D 9C 39 56 0C 74 35 FF 75 94 50 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 07 21 55 94 83 65 90 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 8B 01 8B 7E 18 25 FF 00 FE FF 83 E7 07 0D E0 00 00 00 89 01 83 FF 07 77 57 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1A FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 08 21 85 5C FF FF FF EB 0A C7 85 5C FF FF FF 01 00 00 00 E8 ?? ?? ?? ?? A8 10 74 0A C7 85 5C FF FF FF 01 00 00 00 33 D2 39 95 5C FF FF FF 74 09 F6 06 01 0F 84 ED F9 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 19 01 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 04 01 00 00 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 4C 83 4E 04 02 F6 06 02 75 43 8B C6 E8 ?? ?? ?? ?? E9 F2 F9 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 6B FF FF FF FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 56 FF FF FF 21 85 5C FF FF FF 33 D2 E9 66 FF FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 41 75 13 83 FF 07 77 55 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? DD 45 98 DC 5D 90 DF E0 F6 C4 05 7A 14 83 FF 03 76 2F 83 FF 07 77 30 83 4D 98 FF 83 4D 9C FF EB 26 DD 45 98 DC 5D 90 DF E0 F6 C4 44 7A 19 83 FF 07 77 14 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 55 98 89 55 9C 8B 46 20 DD 45 98 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 87 FD FF FF 83 FF 02 76 0A 83 FF 06 76 42 83 FF 07 75 06 89 55 98 89 55 9C 8B 46 20 DD 45 98 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 95 5C FF FF FF E9 AA FD FF FF 83 4D 98 FF 83 4D 9C FF EB BF 8B 41 10 89 45 90 8B 41 14 89 45 94 8B 41 30 89 45 98 8B 41 34 89 45 9C 39 56 0C 74 37 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 07 21 55 94 83 65 90 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 83 EF 59 74 38 4F 75 5B FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 03 33 FF 47 E8 ?? ?? ?? ?? A8 10 74 31 33 FF 47 EB 2C FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 75 EA FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 75 D9 33 FF EB 06 8B BD 5C FF FF FF 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 89 08 85 FF 74 09 F6 06 01 0F 84 8C F7 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 9D 00 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 88 00 00 00 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 9B FD FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 3C FE FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 41 75 0D 8B 46 1C 25 2B F7 FF FF 83 C8 01 EB 1C DD 45 98 DC 5D 90 DF E0 F6 C4 44 0F 8A 11 FE FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 FE FD FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 E0 FB FF FF 8B 41 10 89 85 54 FF FF FF 8B 46 10 2B C2 74 24 48 74 14 48 74 0A 48 75 15 BA 00 03 00 00 EB 14 BA 00 02 00 00 EB 0D BA 00 01 00 00 EB 06 8B 95 58 FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DB 85 54 FF FF FF D9 5D A4 E8 ?? ?? ?? ?? F6 06 20 75 45 A8 01 74 41 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 81 C9 00 01 00 00 89 08 8B 4E 20 33 C0 40 09 41 0C 8B 4E 20 83 4E 04 20 09 41 04 8B 4E 20 09 41 60 D9 45 A4 8B 4E 20 D9 59 50 E9 81 0A 00 00 8B 4E 20 83 49 60 01 D9 45 A4 8B 4E 20 D9 59 50 A8 01 8B 46 20 0F 84 14 FD FF FF 83 48 0C 01 83 4E 04 20 E9 0B FD FF FF 8B 41 10 89 85 78 FF FF FF 39 56 0C 74 17 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0A 81 A5 78 FF FF FF 00 00 00 80 8B C7 83 E8 64 BF 00 01 00 00 74 0E 48 75 19 8B 01 25 1F 01 FE FF 0B C7 EB 0C 8B 01 25 5F 05 FE FF 0D 40 05 00 00 89 01 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 05 83 F8 2A EB 0E 8B 46 10 2B C2 74 21 48 74 14 48 74 0A 48 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D7 EB 06 8B 95 58 FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 D9 85 78 FF FF FF DB 5D 80 E8 ?? ?? ?? ?? 33 D2 42 84 16 75 08 A8 10 0F 85 22 F5 FF FF 8B 4E 20 8B 7D 80 89 79 50 F6 06 20 75 29 84 C2 74 25 8B C6 E8 ?? ?? ?? ?? 8B 4E 20 33 C0 40 09 41 0C 8B 4E 20 83 4E 04 20 09 41 04 8B 76 20 09 46 60 E9 64 09 00 00 8B 4E 20 09 51 60 8B 4E 20 84 C2 74 09 09 51 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 0F 84 80 F9 FF FF 8B 46 20 83 48 0C 10 09 56 04 E9 1C 09 00 00 8B 41 10 89 45 90 8B 41 14 89 45 94 39 56 0C 74 1A 50 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0A 81 65 94 00 00 00 80 89 55 90 B8 00 01 00 00 83 FF 5B 72 20 83 FF 5C 76 0F 83 FF 5E 76 2E 83 FF 66 74 29 83 FF 67 75 0C 8B 39 81 E7 1F 01 FE FF 0B F8 89 39 8B 4E 20 8B 09 C1 E9 05 81 E1 FF 0F 00 00 83 F9 08 74 15 83 F9 2A EB 1E 8B 39 81 E7 5F 05 FE FF 81 CF 40 05 00 00 EB D6 8B 4E 10 2B CA 74 21 49 74 14 49 74 0A 49 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D0 EB 06 8B 95 58 FF FF FF 81 CA 1F 00 09 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 90 DB 5D 80 E9 AA FE FF FF 8B 41 10 89 85 78 FF FF FF 39 56 0C 74 17 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0A 81 A5 78 FF FF FF 00 00 00 80 8B 01 25 1F 01 FE FF 0D 00 01 00 00 89 01 DB E2 D9 85 78 FF FF FF DD 9D 70 FF FF FF E8 ?? ?? ?? ?? 8B 0E F6 C1 01 75 08 A8 10 0F 85 8B F3 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 DA F9 FF FF 8B 4E 20 DD 85 70 FF FF FF DD 59 50 8B 4E 20 83 49 60 01 8B 4E 20 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 71 F8 FF FF 8B 41 10 8B 79 14 89 45 90 89 7D 94 39 56 0C 74 18 57 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0A 81 65 94 00 00 00 80 89 55 90 8B 01 25 1F 01 FE FF BF 00 01 00 00 0B C7 89 01 8B 46 10 2B C2 74 21 48 74 14 48 74 0A 48 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D7 EB 06 8B 95 58 FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 90 D9 5D A4 E8 ?? ?? ?? ?? 33 D2 8B C8 8B 06 42 89 8D 78 FF FF FF 84 C2 75 09 F6 C1 10 0F 85 9F F2 FF FF 81 E1 00 00 08 00 74 04 83 4E 04 02 A8 02 75 08 85 C9 0F 85 F1 F8 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 31 02 00 00 8B 45 94 25 FF FF FF 7F 3D 00 00 F8 7F 75 0A 83 7D 90 00 0F 84 18 02 00 00 85 C0 75 09 39 45 90 0F 84 0B 02 00 00 DB E2 DD 45 90 D9 E8 DE C9 DD 9D 60 FF FF FF DD 05 ?? ?? ?? ?? D9 C0 D9 E0 DD 85 60 FF FF FF D8 D1 DF E0 DD D9 F6 C4 41 75 0F }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_wcspbrk"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 10 53 56 57 66 85 D2 74 29 8B 5D 0C 0F B7 3B 8B F3 66 85 FF 74 12 0F B7 CF 66 3B CA 74 16 46 46 0F B7 0E 66 85 C9 75 F1 40 40 0F B7 10 66 85 D2 75 DD 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 50
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 6D FC 8B 63 FC FF E0 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 84
		refs = "0017 $ReturnPoint$26949 0027 _RtlUnwind@16"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 64 8B 35 00 00 00 00 89 75 FC C7 45 F8 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 8B 40 04 83 E0 FD 8B 4D 0C 89 41 04 64 8B 3D 00 00 00 00 8B 5D FC 89 3B 64 89 1D 00 00 00 00 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 54
		refs = "0022 ___InternalCxxFrameHandler"
		altNames = "___CxxFrameHandler2 ___CxxFrameHandler3"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 FC 33 C0 50 50 50 FF 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 5F 5E 5B 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_8_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 31
		refs = "0014 ___FrameUnwindToState"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 70 1C FF 70 28 6A 00 FF 70 18 E8 ?? ?? ?? ?? 83 C4 10 5D C2 04 00 }
	condition:
		$1
}

rule file_254_9_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 51
		refs = "0010 @__security_check_cookie@4 0029 ___InternalCxxFrameHandler"
	strings:
		$1 = { 8B FF 55 8B EC 56 FC 8B 75 0C 8B 4E 08 33 CE E8 ?? ?? ?? ?? 6A 00 56 FF 76 14 FF 76 0C 6A 00 FF 75 10 FF 76 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 5E 5D C3 }
	condition:
		$1
}

rule file_254_10_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 215
		refs = "0013 $ExceptionContinuation$27067 002b ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 0030 ___security_cookie 008c __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 53 81 7D 08 23 01 00 00 75 12 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 33 C0 40 E9 B0 00 00 00 83 65 D8 00 C7 45 DC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D D8 33 C1 89 45 E0 8B 45 18 89 45 E4 8B 45 0C 89 45 E8 8B 45 1C 89 45 EC 8B 45 20 89 45 F0 83 65 F4 00 83 65 F8 00 83 65 FC 00 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 45 D8 64 A3 00 00 00 00 C7 45 C8 01 00 00 00 8B 45 08 89 45 CC 8B 45 10 89 45 D0 E8 ?? ?? ?? ?? 8B 80 80 00 00 00 89 45 D4 8D 45 CC 50 8B 45 08 FF 30 FF 55 D4 59 59 83 65 C8 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 C8 5B C9 C3 }
	condition:
		$1
}

rule file_254_11_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 159
		refs = "0012 @__security_check_cookie@4 0055 ___InternalCxxFrameHandler 006c ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0084 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 8B 45 08 8B 40 04 83 E0 66 74 11 8B 45 0C C7 40 24 01 00 00 00 33 C0 40 EB 6C EB 6A 6A 01 8B 45 0C FF 70 18 8B 45 0C FF 70 14 8B 45 0C FF 70 0C 6A 00 FF 75 10 8B 45 0C FF 70 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 8B 45 0C 83 78 24 00 75 0B FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 45 FC 50 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 33 C0 40 5B C9 C3 }
	condition:
		$1
}

rule file_254_12_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 117
		refs = "001f ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 8B 7D 08 8B 47 10 8B 77 0C 89 45 FC 8B DE EB 2D 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 4D FC 4E 8B C6 6B C0 14 03 C1 8B 4D 10 39 48 04 7D 05 3B 48 08 7E 05 83 FE FF 75 09 FF 4D 0C 8B 5D 08 89 75 08 83 7D 0C 00 7D CA 8B 45 14 46 89 30 8B 45 18 89 18 3B 5F 0C 77 04 3B F3 76 05 E8 ?? ?? ?? ?? 8B C6 6B C0 14 03 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_254_13_0 {
	meta:
		name = "__CreateFrameInfo"
		size = 44
		refs = "000f __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 56 8B 75 08 89 06 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 89 46 04 E8 ?? ?? ?? ?? 89 B0 98 00 00 00 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_254_14_0 {
	meta:
		name = "__IsExceptionObjectToBeDestroyed"
		size = 39
		refs = "0006 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 0A 8B 08 3B 4D 08 74 0A 8B 40 04 85 C0 75 F2 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_254_15_0 {
	meta:
		name = "__FindAndUnlinkFrame"
		size = 82
		refs = "0007 __getptd 0046 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 3B B0 98 00 00 00 75 11 E8 ?? ?? ?? ?? 8B 4E 04 89 88 98 00 00 00 5E 5D C3 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 09 8B 48 04 3B F1 74 0F 8B C1 83 78 04 00 75 F1 5E 5D E9 ?? ?? ?? ?? 8B 4E 04 89 48 04 EB D2 }
	condition:
		$1
}

rule file_254_16_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 96
		refs = "0009 ___security_cookie 0029 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 004d __CallSettingFrame@12"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 65 E8 00 8D 4D E8 33 C1 8B 4D 08 89 45 F0 8B 45 0C 89 45 F4 8B 45 14 40 C7 45 EC ?? ?? ?? ?? 89 4D F8 89 45 FC 64 A1 00 00 00 00 89 45 E8 8D 45 E8 64 A3 00 00 00 00 FF 75 18 51 FF 75 10 E8 ?? ?? ?? ?? 8B C8 8B 45 E8 64 A3 00 00 00 00 8B C1 C9 C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__purecall"
		size = 42
		refs = "0002 ___pPurecall 0007 __decode_pointer 0015 __NMSG_WRITE 001e __set_abort_behavior 0026 _abort"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 02 FF D0 6A 19 E8 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "__set_purecall_handler"
		size = 39
		refs = "0008 ___pPurecall 000d __decode_pointer 0017 __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_788_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 39
		refs = "0008 ?__pInconsistency@@3P6AXXZA 000d __decode_pointer 0017 __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_660_2_0 {
	meta:
		name = "__set_invalid_parameter_handler"
		size = 39
		refs = "0008 ___pInvalidArgHandler 000d __decode_pointer 0017 __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "_wcsrchr"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B D0 66 8B 08 40 40 66 85 C9 75 F6 66 8B 4D 0C 48 48 3B C2 74 05 66 39 08 75 F5 66 39 08 74 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "__wstat32i64"
		size = 965
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0059 _wcspbrk 0090 _towlower 009e __getdrive 00b2 __imp__FindFirstFileW@8 00c6 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00f1 __wfullpath_helper 0100 _wcslen 010b _IsRootUNCName 0116 __imp__GetDriveTypeW@4 012e _free 0161 ___loctotime32_t 01be __imp__FileTimeToLocalFileTime@8 01da __imp__FileTimeToSystemTime@8 033f __imp__FindClose@4 034b ___wdtoxmode 0366 __allmul 039c __imp__GetLastError@0 03a2 __dosmaperr 03bf @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 65 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 3A 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 84 FB FF FF 8D 85 A4 FB FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 A0 FB FF FF 83 F8 FF 0F 85 D4 00 00 00 68 ?? ?? ?? ?? 56 89 9D A0 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 87 8D 85 A0 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 74 7E 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 69 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 5D 39 9D A0 FB FF FF 74 0C FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 A4 FB FF FF 10 00 00 00 89 9D C0 FB FF FF 89 9D C4 FB FF FF 66 89 85 D0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 83 C4 1C 89 47 24 89 47 20 89 47 28 E9 C7 01 00 00 39 9D A0 FB FF FF 0F 84 DB FE FF FF FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 E9 CA FE FF FF 39 9D B8 FB FF FF 75 0D 39 9D BC FB FF FF 75 05 89 5F 24 EB 75 8D 85 88 FB FF FF 50 8D 85 B8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D0 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B4 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 24 39 9D B0 FB FF FF 75 0D 39 9D B4 FB FF FF 75 05 8B 47 24 EB 72 8D 85 88 FB FF FF 50 8D 85 B0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 46 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2A 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 39 9D A8 FB FF FF 75 0D 39 9D AC FB FF FF 75 05 8B 47 24 EB 72 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BC 00 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A0 00 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 A0 FB FF FF 89 47 28 FF 15 ?? ?? ?? ?? 56 FF B5 A4 FB FF FF E8 ?? ?? ?? ?? 59 66 89 47 06 59 33 C0 40 50 53 53 FF B5 C0 FB FF FF 66 89 47 08 E8 ?? ?? ?? ?? 8B 8D C4 FB FF FF 33 F6 03 C1 13 D6 89 47 18 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 89 07 89 47 10 89 57 1C 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 A0 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "_fp32_is_qnan"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 00 00 40 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "_fp32_is_snan"
		size = 46
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 17 F7 45 08 00 00 40 00 75 0E F7 45 08 FF FF 3F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_261_2_0 {
	meta:
		name = "_fp32_is_inf"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 FF FF 7F 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_261_3_0 {
	meta:
		name = "_fp32_is_zero"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 F7 45 08 FF FF FF 7F 75 01 40 5D C3 }
	condition:
		$1
}

rule file_261_5_0 {
	meta:
		name = "_RoundFloatToIntegral"
		size = 423
		refs = "000d _fp32_is_qnan 001c _fp32_is_zero 002d _fp32_is_inf 0053 _fp32_is_denormal"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 0C 57 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 81 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 85 70 01 00 00 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 61 01 00 00 8B FE C1 EF 17 81 E7 FF 00 00 00 81 FF 96 00 00 00 0F 83 4A 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 85 AE 00 00 00 83 FF 7F 0F 82 A5 00 00 00 53 8B C6 25 FF FF 7F 00 0D 00 00 80 00 6A 17 8B D0 83 C7 81 59 2B CF D3 EA 6A 16 89 55 FC D3 E2 8D 4F 09 D3 E0 D3 E8 8B 4D 10 8B D8 33 C0 85 DB 0F 95 C0 89 01 33 C0 59 40 3B F9 74 04 2B CF D3 E0 83 7D 08 00 8D 0C 00 75 1E 3B D8 72 34 75 06 F6 45 FC 01 74 2C 03 CA 81 F9 00 00 00 01 75 24 B9 00 00 80 00 47 EB 1C 83 7D 08 01 75 06 85 F6 79 10 EB 0A 83 7D 08 02 75 08 85 F6 78 04 85 DB 75 D4 8B CA 8D 47 7F C1 E0 17 25 00 00 80 7F 81 E1 FF FF 7F 00 0B C1 81 E6 00 00 00 80 0B C6 5B E9 93 00 00 00 33 C9 41 83 7D 08 00 75 39 B8 00 00 00 80 85 F0 74 18 83 FF 7E 75 0F F7 C6 FF FF 7F 00 74 07 BE 00 00 80 BF EB 5E 8B F0 EB 5A 83 FF 7E 75 0F F7 C6 FF FF 7F 00 74 07 BE 00 00 80 3F EB 46 33 F6 EB 42 39 4D 08 75 12 81 E6 00 00 00 80 F7 DE 1B F6 81 E6 00 00 80 BF EB 2B 83 7D 08 02 75 18 81 E6 00 00 00 80 F7 DE 1B F6 81 E6 00 00 80 40 81 C6 00 00 80 3F EB 0D B8 00 00 00 80 23 F0 F7 DE 1B F6 23 F0 8B 45 10 89 08 EB 06 8B 45 10 83 20 00 8B C6 5F 5E C9 C3 }
	condition:
		$1
}

rule file_261_6_0 {
	meta:
		name = "_issnanf"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 25 00 00 C0 7F 3D 00 00 80 7F 75 0E F7 45 08 FF FF 3F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_261_7_0 {
	meta:
		name = "_isnanf"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 FF FF 7F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_261_11_0 {
	meta:
		name = "_XMMI_FP_Emulation"
		size = 3968
		refs = "0056 $LN275 005d $LN356 0077 _isdenormalf 00a4 $LN357 0113 __control87 016d __statusfp 0194 _Fill_FPIEEE_RECORD 01b5 _isnanf 0274 _MIN_SINGLE_NORMALA 02b1 _NEGINFFA 02bb _MAX_SINGLE_NORMALA 02dc _POSINFFA 02fe _TWO_TO_192A 0357 _TWO_TO_M192A 0456 _ZEROFA 0468 _NZEROFA 05eb $LN276 05f2 $LN358 05f8 _issnanf 06bd $LN277 06c4 $LN359 06fe $LN278 0705 $LN360 0d82 _fp32_is_qnan 0da0 _fp32_is_snan 0dfd _fp32_is_denormal 0e6f _RoundFloatToIntegral 0eec $LN267 0ef0 $LN40 0ef4 $LN74 0ef8 $LN193 0efc $LN142 0f00 $LN111 0f04 $LN100 0f08 $LN21 0f0c $LN1 0f30 $LN261 0f38 $LN260 0f40 $LN259 0f48 $LN258 0f50 $LN187 0f54 $LN182 0f60 $LN145 0f64 $LN146"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 33 C0 57 89 45 E8 DB E3 8B 75 08 89 45 EC 89 45 E4 8B 46 20 8B 08 33 4E 10 BB FF 0F 00 00 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 83 E1 1C 31 08 8B 4E 20 8B 11 C1 EA 05 23 D3 8D 7A D5 83 FF 1C 0F 87 90 0E 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7E 0C 00 8B 41 10 89 45 08 8B 41 30 89 45 F8 74 29 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 03 21 5D 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 83 FF 07 77 39 FF 24 BD ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 36 48 74 24 48 74 12 48 75 3A DB E2 D9 45 08 D9 45 F8 DE F9 DD 5D DC EB 2B DB E2 D9 45 08 D9 45 F8 DE C9 DD 5D DC EB 1C DB E2 D9 45 08 D9 45 F8 DE E9 DD 5D DC EB 0D DB E2 D9 45 08 D9 45 F8 DE C1 DD 5D DC E8 ?? ?? ?? ?? 89 45 F0 A8 08 74 07 81 65 F0 FF FF F7 FF 8B 06 33 DB 43 89 45 E8 84 C3 75 25 F6 45 F0 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 35 0D 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 85 72 03 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 61 03 00 00 F6 45 E8 02 6A 02 BA 00 00 08 00 5F 75 11 85 55 F0 74 0C 8B C6 E8 ?? ?? ?? ?? 09 7E 04 EB B5 F6 45 E8 04 75 21 F6 45 F0 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 8E DD 45 DC D9 55 FC FF 75 FC E8 ?? ?? ?? ?? 59 85 C0 74 3C 8B 46 20 DD D8 09 58 60 D9 45 FC 8B 46 20 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 5E 04 E9 79 0C 00 00 85 55 F0 74 03 09 7E 04 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 D9 EE F6 C4 05 7A 09 D8 D2 DF E0 F6 C4 41 74 14 D8 DA DF E0 F6 C4 05 7A 14 D8 D9 DF E0 F6 C4 41 75 0D EB 04 DD D9 DD D8 89 5D EC EB 02 DD D8 D9 05 ?? ?? ?? ?? D8 D9 DF E0 DD 05 ?? ?? ?? ?? F6 C4 05 7A 0D D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 74 1A D8 D9 DF E0 F6 C4 05 7A 16 D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 07 EB 02 DD D8 89 5D E4 F6 45 E8 10 75 53 83 7D EC 00 74 4D DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 09 78 0C 8B 46 20 83 4E 04 10 09 78 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 8B 46 20 D9 58 50 84 5D F0 0F 84 6F FE FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 60 FE FF FF F6 45 E8 08 75 39 83 7D E4 00 74 33 DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 EB A3 8B 46 20 DD D8 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 30 48 74 20 48 74 10 48 75 32 D9 45 08 D9 45 F8 DE F9 D9 5D FC EB 25 D9 45 08 D9 45 F8 DE C9 D9 5D FC EB 18 D9 45 08 D9 45 F8 DE E9 D9 5D FC EB 0B D9 45 08 D9 45 F8 DE C1 D9 5D FC E8 ?? ?? ?? ?? F6 06 20 8B C8 0F 85 98 00 00 00 84 CB 75 14 83 7E 08 00 0F 84 8A 00 00 00 83 7D EC 00 0F 84 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 83 7D EC 00 74 0A 8B 46 20 09 78 0C 83 4E 04 10 33 C9 39 4D E4 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 4E 08 74 2E 39 4D EC 74 29 D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 D9 45 FC D9 58 50 E9 2C FD FF FF 8B 46 20 09 58 60 8B 46 20 F6 C1 02 74 09 09 78 0C 83 4E 04 10 EB 04 83 60 0C FD 8B 46 20 F6 C1 04 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 8B 46 20 84 CB 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 83 7E 08 00 74 43 83 7D EC 00 74 3D D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 09 78 0C 83 4E 04 10 8B 46 20 D9 45 FC D9 58 50 8B 46 20 F6 C1 08 74 0A 83 48 0C 08 83 4E 04 04 EB 04 83 60 0C F7 8B 76 20 83 66 0C EF E9 AD 09 00 00 8B 46 20 09 58 60 85 FF 74 1B FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 74 0E 8B 46 20 81 CA 00 00 40 00 89 50 50 EB 0F DD 45 DC 8B 46 20 D9 5D 08 D9 45 08 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 F0 10 74 9E E9 CA FC FF FF 83 7E 0C 00 8B 51 10 8B 41 30 89 55 08 89 45 F8 74 29 52 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 05 23 D3 89 55 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 89 01 83 FF 07 77 3E 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 05 21 45 F0 EB 03 89 5D F0 E8 ?? ?? ?? ?? A8 10 74 03 89 5D F0 83 7D F0 00 74 08 84 1E 0F 84 5D FB FF FF FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 0F 85 F4 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 E3 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 32 83 4E 04 02 F6 06 02 75 29 8B C6 E8 ?? ?? ?? ?? E9 20 FB FF FF 52 E8 ?? ?? ?? ?? 59 85 C0 75 8F FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 75 82 21 45 F0 EB 8E D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 13 83 FF 07 77 53 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 10 83 FF 03 76 2D 83 FF 07 77 2C 83 4D 08 FF EB 26 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 17 83 FF 07 77 12 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 65 08 00 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 ED FD FF FF 83 FF 02 76 0A 83 FF 06 76 3D 83 FF 07 75 04 83 65 08 00 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 83 7D F0 00 E9 0A FE FF FF 83 4D 08 FF EB C6 83 7E 0C 00 8B 79 10 8B 49 30 89 7D 08 89 4D F8 74 29 57 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 05 23 FB 89 7D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 CB 89 4D F8 83 EA 3B 6A 01 5B 74 30 4A 75 49 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? A8 10 74 23 8B FB EB 1F 57 E8 ?? ?? ?? ?? 59 85 C0 75 F1 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 75 E4 33 FF EB 03 8B 7D F0 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 89 08 85 FF 74 08 84 1E 0F 84 5A F9 FF FF FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 0F 85 98 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 87 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 F9 FD FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 7D FE FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 0F 8A 4F FE FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 3C FE FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 79 FC FF FF 8B 41 10 89 45 08 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 08 D9 5D FC E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 35 84 C3 74 31 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 0B CF 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 E9 CD FA FF FF 8B 4E 20 09 59 60 D9 45 FC 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 63 FD FF FF 09 58 0C 83 4E 04 20 E9 5B FD FF FF 83 7E 0C 00 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 BF 00 01 00 00 83 FA 3F 72 23 83 FA 40 76 13 83 FA 42 77 19 8B 01 25 5F 05 FE FF 0D 40 05 00 00 EB 09 8B 01 25 1F 01 FE FF 0B C7 89 01 8B 46 20 8B 00 C1 E8 05 23 C3 83 F8 08 74 05 83 F8 2A EB 0F 8B 46 10 83 E8 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 DB 5D F4 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 10 F7 FF FF 8B 4E 20 8B 55 F4 89 51 50 F6 06 20 75 26 84 C3 74 22 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 76 20 09 5E 60 E9 F4 F6 FF FF 8B 4E 20 09 59 60 8B 4E 20 84 C3 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 9F FA FF FF 83 7E 0C 00 8B 59 10 8B 79 30 89 5D 08 89 7D F8 74 2A 53 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 03 21 5D 08 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 FB 89 7D F8 8B 5D 08 83 FA 35 72 26 83 FA 36 76 13 83 FA 38 77 1C 8B 01 25 1F 05 FE FF 0D 00 05 00 00 EB 0C 8B 01 25 3F 05 FE FF 0D 20 05 00 00 89 01 53 E8 ?? ?? ?? ?? 59 85 C0 75 0B 57 E8 ?? ?? ?? ?? 59 85 C0 74 31 33 DB 43 84 1E 0F 84 1E F6 FF FF 8B 46 20 09 58 60 8B 46 20 89 78 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB E9 BB F6 FF FF 53 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0D 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 18 83 4E 04 02 F6 06 02 75 0F 8B C6 E8 ?? ?? ?? ?? 33 C0 40 E9 1A 03 00 00 D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 2C 48 75 43 89 79 50 EB 3E D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 DA 48 75 1A 89 59 50 EB 15 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 06 8B 46 20 89 78 50 8B 46 20 83 48 60 01 E9 DE FA FF FF 83 7E 0C 00 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 8B 01 25 BF 00 FE FF 0D A0 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 D9 FA D9 5D FC E8 ?? ?? ?? ?? A8 10 74 05 25 FF FF F7 FF 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 BD F4 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 8E F9 FF FF 8B 4E 20 D9 45 FC D9 59 50 F6 06 20 75 08 84 C3 0F 85 8E FD FF FF 8B 4E 20 09 59 60 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 84 C3 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C F7 A8 10 0F 84 EE F7 FF FF 8B 46 20 83 48 0C 10 89 5E 04 E9 98 01 00 00 8B 01 25 3F 01 FE FF 0D 20 01 00 00 89 01 8B 46 20 8B 78 10 8B D7 C1 FA 17 8B C7 C1 F8 1F C1 E0 08 81 E2 FF 00 00 00 0B D0 8B C7 25 FF FF 7F 00 C1 E2 17 0B D0 52 E8 ?? ?? ?? ?? 59 85 C0 74 13 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 60 01 E9 38 01 00 00 52 E8 ?? ?? ?? ?? 59 85 C0 74 52 33 DB 43 8B C6 84 1E 75 22 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 8B 46 20 09 5E 04 83 48 04 10 8B 76 20 83 66 60 FE E9 D5 F3 FF FF E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 8B 46 20 09 5E 04 09 58 60 8B 46 20 83 60 60 E1 81 CF 00 00 40 00 E9 E2 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 26 83 7E 0C 00 74 20 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 60 01 8B 46 20 83 60 60 E1 81 E7 00 00 00 80 E9 AF 00 00 00 8B 46 18 33 DB 83 E0 0F 43 89 45 08 A8 04 75 05 83 E0 03 EB 25 8B 46 10 83 E8 00 74 16 48 74 0F 48 74 07 48 75 11 6A 03 EB 02 6A 02 58 EB 0B 8B C3 EB 07 33 C0 EB 03 8B 45 08 8D 4D E8 51 52 50 E8 ?? ?? ?? ?? 83 C4 0C F6 45 08 08 8B F8 75 4B 83 7D E8 00 74 45 F6 06 20 8B C6 75 2D E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 8B 46 20 83 60 60 E1 8B 46 20 89 78 50 E9 F1 F2 FF FF E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 83 4E 04 20 EB 07 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 60 8B 46 20 83 60 60 E1 8B 46 20 89 78 50 33 C0 5F 5E 5B C9 C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 01 02 02 02 02 03 03 04 04 05 05 06 06 06 06 08 08 08 07 07 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 00 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "__cwait"
		size = 145
		refs = "0019 __imp__WaitForSingleObject@8 0028 __imp__GetExitCodeProcess@8 0036 __imp__GetLastError@0 0042 __errno 004d ___doserrno 005d __dosmaperr 006b __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 0C 83 FB FF 74 72 83 FB FE 74 6D 56 6A FF 53 FF 15 ?? ?? ?? ?? 85 C0 75 13 8D 45 0C 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 04 8B F3 EB 34 8B 35 ?? ?? ?? ?? FF D6 83 F8 06 75 18 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? C7 00 06 00 00 00 EB 09 FF D6 50 E8 ?? ?? ?? ?? 59 83 CE FF 89 75 0C 53 FF 15 ?? ?? ?? ?? 8B 45 08 85 C0 74 05 8B 4D 0C 89 08 8B C6 5E EB 0E E8 ?? ?? ?? ?? C7 00 0A 00 00 00 83 C8 FF 5B 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__wfdopen"
		size = 404
		refs = "0003 __sehtable$__wfdopen 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0056 __nhandle 0077 ___pioinfo 00b1 __commode 0146 __getstream 0168 __cflush 0184 __SEH_epilog4 018e __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 8B 45 0C 33 FF 3B C7 0F 95 C1 3B CF 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 48 01 00 00 8B 4D 08 83 F9 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E4 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BE 8B D1 C1 FA 05 83 E1 1F C1 E1 06 8B 14 95 ?? ?? ?? ?? 0F BE 4C 0A 04 33 D2 42 23 CA 74 D5 EB 02 40 40 66 83 38 20 74 F8 0F B7 08 83 F9 61 74 0E 83 F9 72 74 19 83 F9 77 0F 85 75 FF FF FF 6A 02 5B 33 F6 89 7D 0C 0B 1D ?? ?? ?? ?? EB 68 8B DA EB EF 3B D7 74 6E 0F B7 C9 83 E9 20 74 58 83 E9 0B 74 42 83 E9 37 74 11 49 74 2B 83 E9 0B 74 17 83 E9 06 0F 85 3A FF FF FF 39 7D 0C 75 2B C7 45 0C 01 00 00 00 EB 2F 3B F7 75 1E 33 F6 46 81 E3 FF BF FF FF EB 20 3B F7 75 0F 33 F6 46 81 CB 00 40 00 00 EB 11 84 DB 79 04 33 D2 EB 09 83 E3 FC 81 CB 80 00 00 00 40 40 0F B7 08 66 3B CF 75 92 EB 02 40 40 66 83 38 20 74 F8 33 C9 66 39 38 0F 94 C1 8B C1 3B C7 0F 84 D7 FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 3B F7 75 10 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 D1 FE FF FF 89 7D FC FF 05 ?? ?? ?? ?? 89 5E 0C 8B 45 08 89 46 10 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "___ansicp"
		size = 73
		refs = "0009 ___security_cookie 0026 __imp__GetLocaleInfoA@16 0038 _atol 0043 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 6A 06 8D 45 F4 50 68 04 10 00 00 FF 75 08 C6 45 FA 00 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 0A 8D 45 F4 50 E8 ?? ?? ?? ?? 59 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "___convertcp"
		size = 436
		refs = "0009 ___security_cookie 0042 __imp__GetCPInfo@8 004f __imp__MultiByteToWideChar@24 0083 _strlen 00a3 __alloca_probe_16 00d3 _malloc 00fb _memset 012e __imp__WideCharToMultiByte@32 015e __calloc_crt 0181 _free 019a __freea 01ae @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 8B 4D 18 89 45 D8 8B 45 14 53 89 45 D0 8B 00 56 89 45 DC 8B 45 08 57 33 FF 89 4D CC 89 7D E0 89 7D D4 3B 45 0C 0F 84 5F 01 00 00 8B 35 ?? ?? ?? ?? 8D 4D E8 51 50 FF D6 8B 1D ?? ?? ?? ?? 85 C0 74 5E 83 7D E8 01 75 58 8D 45 E8 50 FF 75 0C FF D6 85 C0 74 4B 83 7D E8 01 75 45 8B 75 DC C7 45 D4 01 00 00 00 83 FE FF 75 0C FF 75 D8 E8 ?? ?? ?? ?? 8B F0 59 46 3B F7 7E 5B 81 FE F0 FF FF 7F 77 53 8D 44 36 08 3D 00 04 00 00 77 2F E8 ?? ?? ?? ?? 8B C4 3B C7 74 38 C7 00 CC CC 00 00 EB 2D 57 57 FF 75 DC FF 75 D8 6A 01 FF 75 08 FF D3 8B F0 3B F7 75 C3 33 C0 E9 D1 00 00 00 50 E8 ?? ?? ?? ?? 59 3B C7 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 E4 EB 03 89 7D E4 39 7D E4 74 D8 8D 04 36 50 57 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 0C 56 FF 75 E4 FF 75 DC FF 75 D8 6A 01 FF 75 08 FF D3 85 C0 74 7F 8B 5D CC 3B DF 74 1D 57 57 FF 75 1C 53 56 FF 75 E4 57 FF 75 0C FF 15 ?? ?? ?? ?? 85 C0 74 60 89 5D E0 EB 5B 8B 1D ?? ?? ?? ?? 39 7D D4 75 14 57 57 57 57 56 FF 75 E4 57 FF 75 0C FF D3 8B F0 3B F7 74 3C 56 6A 01 E8 ?? ?? ?? ?? 59 59 89 45 E0 3B C7 74 2B 57 57 56 50 56 FF 75 E4 57 FF 75 0C FF D3 3B C7 75 0E FF 75 E0 E8 ?? ?? ?? ?? 59 89 7D E0 EB 0B 83 7D DC FF 74 05 8B 4D D0 89 01 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 45 E0 8D 65 C0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "__difftime32"
		size = 44
		refs = "001e __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 7C 12 8B 45 08 85 C0 7C 0B 2B 45 0C 89 45 0C DB 45 0C 5D C3 E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 5D C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 80
		refs = "0003 __sehtable$?DebuggerProbe@@YAHK@Z 0008 __SEH_prolog4 0032 __imp__RaiseException@16 004b __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 01 10 00 00 89 4D D0 8D 4D E7 89 4D D4 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 98
		refs = "0003 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 0008 __SEH_prolog4 0044 __imp__RaiseException@16 005d __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 02 10 00 00 89 4D D0 8B 4D 08 89 4D D4 8B 4D 0C 89 4D D8 8D 4D E7 89 4D DC 8B 4D 10 89 4D E0 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_267_2_0 {
	meta:
		name = "_DebuggerKnownHandle"
		size = 31
		refs = "0002 __imp__IsDebuggerPresent@0 0010 ?DebuggerProbe@@YAHK@Z"
	strings:
		$1 = { FF 15 ?? ?? ?? ?? 85 C0 74 12 B9 04 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_267_3_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 505
		refs = "000c ___security_cookie 0032 ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 0043 ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 0055 __imp__MultiByteToWideChar@24 0088 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 0092 ?DebuggerProbe@@YAHK@Z 00a7 __RTC_NoFalsePositives 00ac ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00db __imp__IsDebuggerPresent@0 010e ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 0128 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 014a __imp__WideCharToMultiByte@32 016d ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01a2 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01c2 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 01e6 __imp__DebugBreak@0 01f3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 40 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B F1 57 8B FA 33 DB 56 89 B5 CC F1 FF FF 89 BD C4 F1 FF FF 89 9D C8 F1 FF FF E8 ?? ?? ?? ?? 59 89 85 D0 F1 FF FF 3B C3 75 0D 56 E8 ?? ?? ?? ?? 59 89 85 C8 F1 FF FF 53 53 6A FF 57 8B 3D ?? ?? ?? ?? 53 BE E9 FD 00 00 56 FF D7 3D 00 02 00 00 73 1E 50 8D 85 D4 F1 FF FF 50 6A FF FF B5 C4 F1 FF FF 53 56 FF D7 8D BD D4 F1 FF FF 85 C0 75 05 BF ?? ?? ?? ?? B9 02 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 25 8B 4D 0C 57 FF B5 CC F1 FF FF FF 34 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 2F 01 00 00 32 C0 EB 02 B0 01 39 9D C8 F1 FF FF 75 0C 39 9D D0 F1 FF FF 0F 84 0F 01 00 00 3A C3 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 FD 00 00 00 B8 04 01 00 00 50 8D 8D EC FB FF FF 51 8D 8D CC F1 FF FF 51 50 8D 85 F4 FD FF FF 50 8B 85 CC F1 FF FF 83 C0 FB 50 E8 ?? ?? ?? ?? 83 C4 18 39 9D D0 F1 FF FF 74 2B 57 FF 75 0C 8D 85 EC FB FF FF 68 ?? ?? ?? ?? 50 FF B5 CC F1 FF FF 8D 85 F4 FD FF FF 50 FF 75 08 FF 95 D0 F1 FF FF E9 94 00 00 00 8B 3D ?? ?? ?? ?? 53 53 68 0A 03 00 00 8D 85 D4 F5 FF FF 50 6A FF 8D 85 F4 FD FF FF 50 53 56 C7 85 D0 F1 FF FF ?? ?? ?? ?? FF D7 85 C0 74 0C 8D 85 D4 F5 FF FF 89 85 D0 F1 FF FF 53 53 68 0A 03 00 00 8D 85 E0 F8 FF FF 50 6A FF 8D 85 EC FB FF FF 50 53 56 C7 85 C0 F1 FF FF ?? ?? ?? ?? FF D7 85 C0 8D 85 E0 F8 FF FF 75 06 8B 85 C0 F1 FF FF FF B5 C4 F1 FF FF FF 75 0C 68 ?? ?? ?? ?? 50 FF B5 CC F1 FF FF FF B5 D0 F1 FF FF FF 75 08 FF 95 C8 F1 FF FF 83 C4 1C 83 F8 01 75 06 FF 15 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_267_4_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 59
		refs = "0010 ?_RTC_ErrorLevels@@3PAHA 0017 __RTC_ErrorMessages 0023 ??_C@_0BO@GNIAFIKK@Unknown?5Runtime?5Check?5Error?6?$AN?$AA@ 0033 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 83 F9 04 77 10 8B 04 8D ?? ?? ?? ?? 8B 14 8D ?? ?? ?? ?? EB 0B 33 C0 6A 05 40 BA ?? ?? ?? ?? 59 83 F8 FF 74 0C 51 8B 4D 08 50 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_267_5_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 243
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 005c _stack_premsg 0096 _stack_postmsg 00ca ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00df ?failwithmessage@@YAXPAXHHPBD@Z 00ed @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 56 8B 75 0C 89 85 F8 FB FF FF 0F 84 B7 00 00 00 80 3E 00 53 0F 84 90 00 00 00 8B CE 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 83 C1 2D 81 F9 00 04 00 00 77 77 8D 9D FC FB FF FF 33 C9 8A 81 ?? ?? ?? ?? 88 84 0D FC FB FF FF 41 84 C0 75 EE 8B C6 8B D6 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 10 40 84 D2 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BB ?? ?? ?? ?? 8B 8D F8 FB FF FF 6A 02 FF 35 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 59 59 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_267_6_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 103
		refs = "0034 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 003d ?wsprintffp@@3P6AHPADPBDZZA"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 53 56 89 45 FC 8B 45 10 57 8B 7D 08 33 F6 2B C7 89 45 F8 8B 4D 14 83 F9 10 72 03 6A 10 59 3B F1 73 25 8A 1C 38 0F B6 C3 50 68 ?? ?? ?? ?? FF 75 FC FF 15 ?? ?? ?? ?? 83 45 FC 03 8B 45 F8 83 C4 0C 88 1F 46 47 EB CC 8B 45 08 C6 04 06 00 6B F6 03 8B 45 0C 5F C6 04 06 00 5E 5B C9 C3 }
	condition:
		$1
}

rule file_267_7_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 287
		refs = "000c ___security_cookie 0018 ?_RTC_ErrorLevels@@3PAHA 0034 ??_C@_0L@GMPLCCII@user32?4dll?$AA@ 003a __imp__LoadLibraryA@4 0047 ??_C@_09FOPFMPEJ@wsprintfA?$AA@ 004e __imp__GetProcAddress@8 0053 ?wsprintffp@@3P6AHPADPBDZZA 006b ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0076 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 007c ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0085 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 008a ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0095 ??_C@_0BC@KIBAILCI@?$CFs?$CFs?$CFp?$CFs?$CFld?$CFs?$CFd?$CFs?$AA@ 00ad ?_getMemBlockDataString@@YAXPAD00I@Z 00b5 ??_C@_01EEMJAFIK@?6?$AA@ 00be ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00c7 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00d4 __imp__lstrlenA@4 00f6 ?failwithmessage@@YAXPAXHHPBD@Z 0103 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 0119 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 1D ?? ?? ?? ?? 56 8B 75 0C 57 8B 7D 08 89 BD BC FE FF FF 83 FB FF 0F 84 DD 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 B9 00 00 00 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 F6 0F 84 A0 00 00 00 85 C0 0F 84 98 00 00 00 8B 4E 0C 68 ?? ?? ?? ?? FF 75 10 83 E9 24 68 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 8D 7E 20 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D C0 FE FF FF 68 ?? ?? ?? ?? 51 FF D0 8B 46 0C 83 E8 24 50 57 8D 45 B4 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 38 68 ?? ?? ?? ?? 8D 45 B4 50 68 ?? ?? ?? ?? 8D 45 E8 50 68 ?? ?? ?? ?? 8D 85 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8D 84 05 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8B 8D BC FE FF FF 6A 04 53 8D 95 C0 FE FF FF E8 ?? ?? ?? ?? 83 C4 20 EB 11 6A 04 53 BA ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_267_8_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 226
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 0052 _uninit_premsg 008a _uninit_postmsg 00be ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00ce ?failwithmessage@@YAXPAXHHPBD@Z 00dc @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 04 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 0F 84 B1 00 00 00 53 56 85 C0 0F 84 8E 00 00 00 8B C8 8D 71 01 8A 19 41 84 DB 75 F9 2B CE 83 C1 3A 81 F9 00 04 00 00 77 75 8D 95 FC FB FF FF 33 C9 8A 99 ?? ?? ?? ?? 88 9C 0D FC FB FF FF 41 84 DB 75 EE 8B F0 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 18 40 84 DB 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BA ?? ?? ?? ?? 8B 4D 04 6A 03 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "___dtoxmode"
		size = 189
		refs = "0052 __mbsrchr 005f ??_C@_04JLMDILM@?4exe?$AA@ 0065 __mbsicmp 0070 ??_C@_04CPCBDHLK@?4cmd?$AA@ 0081 ??_C@_04NEEFLLOK@?4bat?$AA@ 0092 ??_C@_04PNGHFIJN@?4com?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 08 56 8B 75 0C 80 7E 01 3A 57 8B CE 75 03 8D 4E 02 8A 11 80 FA 5C 74 05 80 FA 2F 75 06 80 79 01 00 74 0D A8 10 75 09 BF 00 80 00 00 84 D2 75 05 BF 40 40 00 00 C1 E0 07 F7 D0 25 80 00 00 00 0D 00 01 00 00 6A 2E 56 0B F8 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 47 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 33 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 22 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 11 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 03 83 CF 40 8B C7 C1 E8 03 83 E0 38 0B F8 8B C7 C1 E8 06 83 E0 07 0B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 122
		refs = "0004 _strlen"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 59 83 F8 05 72 69 8A 06 3C 5C 74 04 3C 2F 75 5F 8A 46 01 3C 5C 74 04 3C 2F 75 54 8A 46 02 3C 5C 74 4D 3C 2F 74 49 8D 46 03 8A 08 32 D2 3A CA 74 3E 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 29 40 38 10 74 24 8A 08 3A CA 74 1A 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 05 38 50 01 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_268_3_0 {
	meta:
		name = "__stat32"
		size = 935
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0059 __mbspbrk 008f __mbctolower 009a __getdrive 00ae __imp__FindFirstFileA@8 00c2 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00ed __fullpath_helper 00fc _strlen 0107 _IsRootUNCName 0112 __imp__GetDriveTypeA@4 012a _free 015a ___loctotime32_t 01b7 __imp__FileTimeToLocalFileTime@8 01d3 __imp__FileTimeToSystemTime@8 0338 __imp__FindClose@4 0344 ___dtoxmode 037e __imp__GetLastError@0 0384 __dosmaperr 03a1 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 A0 FD FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 47 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 1C 03 00 00 80 7E 01 3A 75 1A 8A 06 3A C3 74 05 38 5E 02 74 D9 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 98 FD FF FF 8D 85 B8 FD FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 B4 FD FF FF 83 F8 FF 0F 85 D1 00 00 00 68 ?? ?? ?? ?? 56 89 9D B4 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 8B 8D 85 B4 FD FF FF 50 68 04 01 00 00 8D 85 F8 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 74 7B 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 66 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 5A 39 9D B4 FD FF FF 74 0C FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 B8 FD FF FF 10 00 00 00 89 9D D4 FD FF FF 89 9D D8 FD FF FF 88 9D E4 FD FF FF E8 ?? ?? ?? ?? 8B B5 A0 FD FF FF 83 C4 1C 89 47 1C 89 47 18 89 47 20 E9 C7 01 00 00 39 9D B4 FD FF FF 0F 84 E2 FE FF FF FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 E9 D1 FE FF FF 39 9D CC FD FF FF 75 0D 39 9D D0 FD FF FF 75 05 89 5F 1C EB 75 8D 85 9C FD FF FF 50 8D 85 CC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B9 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9D 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 1C 39 9D C4 FD FF FF 75 0D 39 9D C8 FD FF FF 75 05 8B 47 1C EB 72 8D 85 9C FD FF FF 50 8D 85 C4 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2F 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 13 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 18 39 9D BC FD FF FF 75 0D 39 9D C0 FD FF FF 75 05 8B 47 1C EB 72 8D 85 9C FD FF FF 50 8D 85 BC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A5 00 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 89 00 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 B4 FD FF FF 89 47 20 FF 15 ?? ?? ?? ?? 56 FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 8B 85 D8 FD FF FF 89 47 14 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 98 FD FF FF 48 59 89 07 89 47 10 59 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 B4 FD FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "__allshr"
		size = 33
	strings:
		$1 = { 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 }
	condition:
		$1
}

rule file_270_10_0 {
	meta:
		name = "__cprinput_s_l"
		size = 4317
		refs = "000c ___security_cookie 0063 __errno 0073 __invalid_parameter 008c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b3 _iswctype 00ca __whiteout 00d3 __un_inc 0186 _isdigit 0316 __getwche_nolock 04d2 ___check_float_string 052d __mbtowc_l 0811 __malloc_crt 0830 _wcstombs_s 084b __invoke_watson 086b __cfltcvt_tab 0870 __decode_pointer 0879 _free 0a43 _memset 0c25 _wctomb_s 0d8d __allmul 0db0 _isxdigit 0dda __hextodec 10d7 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 33 DB 56 8B F1 89 85 DC FC FF FF 8D 85 40 FD FF FF 89 B5 F8 FC FF FF 89 85 20 FD FF FF C7 85 E8 FC FF FF 5E 01 00 00 89 9D EC FC FF FF 89 9D E4 FC FF FF 89 9D CC FC FF FF 89 9D 30 FD FF FF 89 9D D0 FC FF FF 3B F3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 4D 10 00 00 FF 75 08 8D 8D BC FC FF FF E8 ?? ?? ?? ?? 0F B7 06 88 9D 25 FD FF FF 89 9D 38 FD FF FF 89 9D F4 FC FF FF 66 3B C3 0F 84 08 10 00 00 57 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 39 FF 8D 38 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 8B B5 F8 FC FF FF 59 46 46 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ED E9 C9 0E 00 00 8B B5 F8 FC FF FF 0F B7 06 6A 25 59 8B D1 66 3B D0 0F 85 BA 0E 00 00 66 3B 56 02 0F 84 B0 0E 00 00 33 FF 89 BD 00 FD FF FF 89 BD F0 FC FF FF 89 BD 1C FD FF FF 89 BD 04 FD FF FF 89 BD 28 FD FF FF 89 BD FC FC FF FF C6 85 0F FD FF FF 00 C6 85 24 FD FF FF 00 C6 85 2F FD FF FF 00 C6 85 3F FD FF FF 00 C6 85 26 FD FF FF 00 C6 85 37 FD FF FF 00 C6 85 27 FD FF FF 01 89 BD 18 FD FF FF 46 46 0F B7 1E F7 C3 00 FF 00 00 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 28 FD FF FF FF 85 04 FD FF FF 6B C0 0A 8D 44 18 D0 89 85 28 FD FF FF E9 D0 00 00 00 83 FB 4E 0F 8F 8D 00 00 00 0F 84 C1 00 00 00 83 FB 2A 74 7A 83 FB 46 0F 84 B3 00 00 00 83 FB 49 74 10 83 FB 4C 75 7E FE 85 27 FD FF FF E9 9E 00 00 00 0F B7 4E 02 66 83 F9 36 75 1F 8D 46 04 66 83 38 34 75 16 FF 85 18 FD FF FF 8B F0 89 BD 10 FD FF FF 89 BD 14 FD FF FF EB 75 66 83 F9 33 75 0D 8D 46 04 66 83 38 32 75 04 8B F0 EB 62 66 83 F9 64 74 5C 66 83 F9 69 74 56 66 83 F9 6F 74 50 66 83 F9 78 74 4A 66 83 F9 58 75 19 EB 42 FE 85 2F FD FF FF EB 3A 83 FB 68 74 29 83 FB 6C 74 0D 83 FB 77 74 17 FE 85 3F FD FF FF EB 23 8D 46 02 66 83 38 6C 74 8F FE 85 27 FD FF FF FE 85 37 FD FF FF EB 0C FE 8D 27 FD FF FF FE 8D 37 FD FF FF 80 BD 3F FD FF FF 00 0F 84 EA FE FF FF 80 BD 2F FD FF FF 00 89 B5 F8 FC FF FF 75 19 8B 85 DC FC FF FF 8B 18 89 85 D8 FC FF FF 83 C0 04 89 85 DC FC FF FF EB 02 33 DB 80 BD 37 FD FF FF 00 89 9D 08 FD FF FF C6 85 3F FD FF FF 00 75 1D 0F B7 06 66 83 F8 53 74 0D C6 85 37 FD FF FF 01 66 83 F8 43 75 07 C6 85 37 FD FF FF FF 0F B7 3E 83 CF 20 89 BD E0 FC FF FF 83 FF 6E 74 4F 83 FF 63 74 12 83 FF 7B 74 0D 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 0B FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF B8 FF FF 00 00 66 3B 85 30 FD FF FF 0F 84 33 0D 00 00 8B 9D 08 FD FF FF 8B B5 F8 FC FF FF 8B BD E0 FC FF FF 8B 8D 04 FD FF FF 85 C9 74 0D 83 BD 28 FD FF FF 00 0F 84 FE 0C 00 00 80 BD 2F FD FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 D8 FC FF FF 8B 18 83 C0 04 89 85 D8 FC FF FF 83 C0 04 89 85 DC FC FF FF 8B 40 FC 89 9D 08 FD FF FF 89 85 FC FC FF FF 83 F8 01 0F 82 62 0C 00 00 83 FF 6F 0F 8F D9 05 00 00 0F 84 09 09 00 00 83 FF 63 0F 84 C5 04 00 00 83 FF 64 0F 84 F7 08 00 00 0F 8E E5 05 00 00 83 FF 67 7E 47 83 FF 69 74 21 83 FF 6E 0F 85 D2 05 00 00 80 BD 2F FD FF FF 00 8B 85 38 FD FF FF 0F 84 90 0B 00 00 E9 B7 0B 00 00 6A 64 5F 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 0F 85 24 07 00 00 C6 85 24 FD FF FF 01 E9 20 07 00 00 6A 2D 58 33 DB 66 3B 85 30 FD FF FF 75 0C 8B 8D 20 FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 1A FF 8D 28 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF 83 BD 04 FD FF FF 00 75 07 83 8D 28 FD FF FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 85 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 73 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 63 66 0F BE 85 30 FD FF FF 8B 8D 20 FD FF FF FF 85 1C FD FF FF 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 87 0B 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 7B FF FF FF 8D 85 BC FC FF FF 50 8B 85 BC FC FF FF C7 85 D4 FC FF FF 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 85 D4 FC FF FF 50 E8 ?? ?? ?? ?? 0F B7 85 D4 FC FF FF 0F BE 8D 30 FD FF FF 83 C4 10 3B C1 0F 85 F5 00 00 00 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 E1 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 8B 8D 20 FD FF FF 0F B7 C0 89 85 30 FD FF FF 66 8B 85 D4 FC FF FF 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B9 0A 00 00 F7 85 30 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 5E 8B 85 20 FD FF FF 66 8B 8D 30 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 44 0A 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF A9 00 FF 00 00 74 80 83 BD 1C FD FF FF 00 0F 84 7B 01 00 00 6A 65 58 66 3B 85 30 FD FF FF 74 10 6A 45 58 66 3B 85 30 FD FF FF 0F 85 5F 01 00 00 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 4B 01 00 00 8B 8D 20 FD FF FF 6A 65 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B3 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 6A 2D 59 89 85 30 FD FF FF 66 3B C8 75 2E 51 8B 8D 20 FD FF FF 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 6B 09 00 00 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 2C 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 75 08 21 85 28 FD FF FF EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 5E 8B 85 20 FD FF FF 66 8B 8D 30 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 BC 08 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF A9 00 FF 00 00 74 80 FF B5 30 FD FF FF FF 8D 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 1C FD FF FF 00 59 0F 84 82 08 00 00 80 BD 2F FD FF FF 00 0F 85 BE 07 00 00 8B B5 E8 FC FF FF 8B 8D 20 FD FF FF FF 85 F4 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 48 08 00 00 8D 46 FF 50 FF B5 20 FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 85 BC FC FF FF 50 0F BE 85 27 FD FF FF 57 FF B5 08 FD FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 2C 07 00 00 85 C9 75 10 FF 85 28 FD FF FF C7 85 04 FD FF FF 01 00 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 26 FD FF FF 01 FF B5 30 FD FF FF FF 8D 38 FD FF FF 8B F3 E8 ?? ?? ?? ?? 59 83 FF 63 74 06 FF 8D FC FC FF FF 83 BD 04 FD FF FF 00 74 14 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 85 03 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D0 89 95 30 FD FF FF 83 FF 63 74 55 83 FF 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 4A 03 00 00 66 83 FA 20 75 3A 83 FF 7B 0F 85 3B 03 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 8D E4 FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 0F FD FF FF 33 C1 85 F8 0F 84 10 03 00 00 8B BD E0 FC FF FF 80 BD 2F FD FF FF 00 0F 85 F6 02 00 00 83 BD FC FC FF FF 00 0F 84 CF 06 00 00 80 BD 26 FD FF FF 00 0F 84 94 02 00 00 66 89 13 43 43 89 9D 08 FD FF FF E9 38 FF FF FF 8B C7 83 E8 70 0F 84 24 03 00 00 83 E8 03 0F 84 FB FE FF FF 48 48 0F 84 1A 03 00 00 83 E8 03 0F 84 4E FA FF FF 83 E8 03 74 33 8B 85 30 FD FF FF 66 39 06 0F 85 67 06 00 00 FE 8D 25 FD FF FF 80 BD 2F FD FF FF 00 0F 85 DB 05 00 00 8B 85 D8 FC FF FF 89 85 DC FC FF FF E9 CA 05 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 26 FD FF FF 01 46 6A 5E 46 58 66 3B 06 75 0A 83 C6 02 C6 85 0F FD FF FF FF 8B 9D E4 FC FF FF 85 DB 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 E4 FC FF FF 85 C0 0F 84 3A 06 00 00 C7 85 CC FC FF FF 01 00 00 00 8B D8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 59 8B C1 66 3B 06 0F 85 AE 00 00 00 46 89 8D F0 FC FF FF 46 C6 43 0B 20 E9 9D 00 00 00 0F B7 C0 46 6A 2D 59 46 66 3B C8 75 71 8B 95 F0 FC FF FF 66 85 D2 74 66 0F B7 0E 6A 5D 5F 66 3B F9 74 5B 0F B7 C9 46 46 66 3B D1 73 05 0F B7 C1 EB 0C 0F B7 C2 0F B7 D1 89 95 F0 FC FF FF 66 3B D0 77 32 2B 85 F0 FC FF FF 0F B7 BD F0 FC FF FF 40 0F B7 C0 89 85 18 FD FF FF 8B CF 83 E1 07 8B C7 B2 01 D2 E2 C1 E8 03 03 C3 08 10 47 FF 8D 18 FD FF FF 75 E5 83 A5 F0 FC FF FF 00 EB 1C 0F B7 C8 89 8D F0 FC FF FF 0F B7 C8 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 6A 5D 59 0F B7 06 66 3B C8 0F 85 57 FF FF FF 66 83 3E 00 0F 84 4C 05 00 00 8B 9D 08 FD FF FF 8B BD E0 FC FF FF 89 B5 F8 FC FF FF E9 76 FD FF FF 6A 2B 58 66 3B C3 75 29 FF 8D 28 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 30 FD FF FF 6A 30 58 66 3B C3 0F 85 98 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 6A 78 58 89 9D 30 FD FF FF 66 3B C3 74 47 6A 58 58 66 3B C3 74 3F C7 85 1C FD FF FF 01 00 00 00 83 FF 78 74 1B 83 BD 04 FD FF FF 00 74 0E FF 8D 28 FD FF FF 75 06 FE 85 3F FD FF FF 6A 6F EB 4A FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 6A 30 5B E9 2F 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 04 FD FF FF 00 0F B7 D8 89 9D 30 FD FF FF 74 16 83 AD 28 FD FF FF 02 83 BD 28 FD FF FF 01 7D 06 FE 85 3F FD FF FF 6A 78 5F E9 FA 00 00 00 83 A5 18 FD FF FF 00 52 FF B5 FC FC FF FF 8D 85 18 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 07 04 00 00 8B 85 18 FD FF FF 85 C0 0F 8E 85 FC FF FF 03 D8 29 85 FC FC FF FF 89 9D 08 FD FF FF E9 72 FC FF FF 46 46 E9 6B FC FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 3B F3 0F 84 F6 03 00 00 80 BD 2F FD FF FF 00 0F 85 32 03 00 00 FF 85 F4 FC FF FF 83 BD E0 FC FF FF 63 0F 84 1F 03 00 00 80 BD 26 FD FF FF 00 74 10 8B 8D 08 FD FF FF 33 C0 66 89 01 E9 06 03 00 00 8B 85 08 FD FF FF C6 00 00 E9 F8 02 00 00 C6 85 27 FD FF FF 01 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 75 09 C6 85 24 FD FF FF 01 EB 08 6A 2B 58 66 3B C3 75 29 FF 8D 28 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 30 FD FF FF 83 BD 18 FD FF FF 00 0F 84 54 01 00 00 80 BD 3F FD FF FF 00 0F 85 16 01 00 00 83 FF 78 74 78 83 FF 70 74 73 F7 C3 00 FF 00 00 0F 85 F3 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E1 00 00 00 83 FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 D0 00 00 00 8B 85 10 FD FF FF 8B 8D 14 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 10 FD FF FF 89 8D 14 FD FF FF EB 6C 6A 00 6A 0A FF B5 14 FD FF FF FF B5 10 FD FF FF E8 ?? ?? ?? ?? 89 85 10 FD FF FF 89 95 14 FD FF FF EB 49 F7 C3 00 FF 00 00 0F 85 80 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 85 10 FD FF FF 8B 8D 14 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 10 FD FF FF 89 8D 14 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF FF 85 1C FD FF FF 0F B7 C3 83 E8 30 99 01 85 10 FD FF FF 11 95 14 FD FF FF 83 BD 04 FD FF FF 00 74 08 FF 8D 28 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 30 FD FF FF E9 F7 FE FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 24 FD FF FF 00 0F 84 0C 01 00 00 8B 85 10 FD FF FF 8B 8D 14 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 10 FD FF FF 89 8D 14 FD FF FF E9 E8 00 00 00 80 BD 3F FD FF FF 00 0F 85 CC 00 00 00 83 FF 78 74 4A 83 FF 70 74 45 F7 C3 00 FF 00 00 0F 85 A9 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 97 00 00 00 83 FF 6F 75 17 6A 38 58 66 3B C3 0F 86 86 00 00 00 8B 85 00 FD FF FF C1 E0 03 EB 3E 8B 85 00 FD FF FF 6B C0 0A EB 33 F7 C3 00 FF 00 00 75 68 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 5A C1 A5 00 FD FF FF 04 53 E8 ?? ?? ?? ?? 0F B7 D8 8B 85 00 FD FF FF 59 89 9D 30 FD FF FF FF 85 1C FD FF FF 83 BD 04 FD FF FF 00 0F B7 CB 8D 44 08 D0 89 85 00 FD FF FF 74 08 FF 8D 28 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 30 FD FF FF E9 41 FF FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 24 FD FF FF 00 74 06 F7 9D 00 FD FF FF 83 FF 46 75 07 83 A5 1C FD FF FF 00 83 BD 1C FD FF FF 00 0F 84 FE 00 00 00 80 BD 2F FD FF FF 00 75 3E FF 85 F4 FC FF FF 8B 9D 08 FD FF FF 8B 85 00 FD FF FF 83 BD 18 FD FF FF 00 74 13 8B 85 10 FD FF FF 89 03 8B 85 14 FD FF FF 89 43 04 EB 10 80 BD 27 FD FF FF 00 74 04 89 03 EB 03 66 89 03 FE 85 25 FD FF FF 8B B5 F8 FC FF FF 46 46 89 B5 F8 FC FF FF EB 35 8B D1 66 3B D0 75 0A 8D 46 02 66 3B 08 75 02 8B F0 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 66 8B 0E 0F B7 C0 46 46 89 85 30 FD FF FF 89 B5 F8 FC FF FF 66 3B C8 75 60 0F B7 06 66 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__crt_wait_module_handle"
		size = 26
		refs = "000a __imp__GetModuleHandleW@4 0014 __crt_waiting_on_module_handle"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "__encode_pointer"
		size = 114
		refs = "0008 ___getvalueindex 000e __imp__TlsGetValue@4 0019 ___flsindex 003a ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0041 __imp__GetModuleHandleW@4 004b __crt_waiting_on_module_handle 0055 ??_C@_0O@NLDKAIKN@EncodePointer?$AA@ 005c __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 21 A1 ?? ?? ?? ?? 83 F8 FF 74 17 50 FF 35 ?? ?? ?? ?? FF D6 FF D0 85 C0 74 08 8B 80 F8 01 00 00 EB 27 BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 0B 56 E8 ?? ?? ?? ?? 59 85 C0 74 18 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 08 FF 75 08 FF D0 89 45 08 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_271_3_0 {
	meta:
		name = "__decode_pointer"
		size = 114
		refs = "0008 ___getvalueindex 000e __imp__TlsGetValue@4 0019 ___flsindex 003a ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0041 __imp__GetModuleHandleW@4 004b __crt_waiting_on_module_handle 0055 ??_C@_0O@KBPMFGHI@DecodePointer?$AA@ 005c __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 21 A1 ?? ?? ?? ?? 83 F8 FF 74 17 50 FF 35 ?? ?? ?? ?? FF D6 FF D0 85 C0 74 08 8B 80 FC 01 00 00 EB 27 BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 0B 56 E8 ?? ?? ?? ?? 59 85 C0 74 18 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 08 FF 75 08 FF D0 89 45 08 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_271_5_0 {
	meta:
		name = "___fls_getvalue@4"
		size = 26
		refs = "000a ___getvalueindex 0010 __imp__TlsGetValue@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 5D C2 04 00 }
	condition:
		$1
}

rule file_271_7_0 {
	meta:
		name = "___set_flsgetvalue"
		size = 52
		refs = "0005 ___getvalueindex 000b __imp__TlsGetValue@4 0017 _gpFlsGetValue 001c __decode_pointer 002c __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 1B FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F0 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_271_8_0 {
	meta:
		name = "___fls_setvalue@8"
		size = 29
		refs = "000d _gpFlsSetValue 0012 __decode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 5D C2 08 00 }
	condition:
		$1
}

rule file_271_9_0 {
	meta:
		name = "__mtterm"
		size = 61
		refs = "0001 ___flsindex 000d _gpFlsFree 0012 __decode_pointer 0021 ___getvalueindex 002d __imp__TlsFree@4 0039 __mtdeletelocks"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 16 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 0D ?? ?? ?? ?? FF A1 ?? ?? ?? ?? 83 F8 FF 74 0E 50 FF 15 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_271_10_0 {
	meta:
		name = "__initptd"
		size = 231
		refs = "0003 __sehtable$__initptd 0008 __SEH_prolog4 000d ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0014 __imp__GetModuleHandleW@4 001e __crt_waiting_on_module_handle 002c __XcptActTab 003b ??_C@_0O@NLDKAIKN@EncodePointer?$AA@ 0042 __imp__GetProcAddress@8 004f ??_C@_0O@KBPMFGHI@DecodePointer?$AA@ 0072 ___initialmbcinfo 0079 __lock 0087 __imp__InterlockedIncrement@4 00ad ___ptlocinfo 00b8 ___addlocaleref 00ca __SEH_epilog4 00d8 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 89 45 E4 8B 75 08 C7 46 5C ?? ?? ?? ?? 33 FF 47 89 7E 14 85 C0 74 24 68 ?? ?? ?? ?? 50 8B 1D ?? ?? ?? ?? FF D3 89 86 F8 01 00 00 68 ?? ?? ?? ?? FF 75 E4 FF D3 89 86 FC 01 00 00 89 7E 70 C6 86 C8 00 00 00 43 C6 86 4B 01 00 00 43 C7 46 68 ?? ?? ?? ?? 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 76 68 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 3E 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 89 46 6C 85 C0 75 08 A1 ?? ?? ?? ?? 89 46 6C FF 76 6C E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 15 00 00 00 E8 ?? ?? ?? ?? C3 33 FF 47 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_271_11_0 {
	meta:
		name = "__getptd_noexit"
		size = 121
		refs = "0006 __imp__GetLastError@0 000c ___flsindex 0013 ___set_flsgetvalue 0027 __calloc_crt 003c _gpFlsSetValue 0041 __decode_pointer 0050 __initptd 0058 __imp__GetCurrentThreadId@0 0066 _free 0070 __imp__SetLastError@4"
	strings:
		$1 = { 8B FF 56 57 FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? FF D0 8B F0 85 F6 75 4E 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 3A 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 18 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 EB 09 56 E8 ?? ?? ?? ?? 59 33 F6 57 FF 15 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_271_12_0 {
	meta:
		name = "__getptd"
		size = 26
		refs = "0004 __getptd_noexit 0011 __amsg_exit"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 08 6A 10 E8 ?? ?? ?? ?? 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_271_13_0 {
	meta:
		name = "__freefls@4"
		size = 303
		refs = "0003 __sehtable$__freefls@4 0008 __SEH_prolog4 0020 _free 007d __XcptActTab 008d __lock 00a0 __imp__InterlockedDecrement@4 00aa ___initialmbcinfo 00db ___removelocaleref 00e2 ___ptlocinfo 00ea ___initiallocinfo 00f7 ___freetlocinfo 0110 __SEH_epilog4 011d __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 F8 00 00 00 8B 46 24 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 2C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 34 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 3C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 40 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 44 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 48 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 5C 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7E 68 85 FF 74 1A 57 FF 15 ?? ?? ?? ?? 85 C0 75 0F 81 FF ?? ?? ?? ?? 74 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 57 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 7E 6C 85 FF 74 23 57 E8 ?? ?? ?? ?? 59 3B 3D ?? ?? ?? ?? 74 14 81 FF ?? ?? ?? ?? 74 0C 83 3F 00 75 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1E 00 00 00 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C2 04 00 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_271_14_0 {
	meta:
		name = "__freeptd"
		size = 110
		refs = "0007 ___flsindex 0017 ___getvalueindex 001d __imp__TlsGetValue@4 0045 _gpFlsSetValue 004a __decode_pointer 0055 __freefls@4 0068 __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? FF 74 4B 83 7D 08 00 75 27 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 13 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 FF D0 89 45 08 5E 6A 00 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 FF 75 08 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 74 09 6A 00 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_271_17_0 {
	meta:
		name = "__mtinit"
		size = 397
		refs = "0005 ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 000c __imp__GetModuleHandleW@4 0016 __crt_waiting_on_module_handle 0027 __imp__GetProcAddress@8 002c ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 0034 ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 003a _gpFlsAlloc 0041 ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 0047 _gpFlsGetValue 004e ??_C@_07PEJMOBNF@FlsFree?$AA@ 0054 _gpFlsSetValue 0063 __imp__TlsSetValue@8 0068 _gpFlsFree 0085 __imp__TlsGetValue@4 008f __imp__TlsFree@4 0099 ___crtTlsAlloc@4 00aa __imp__TlsAlloc@0 00af ___getvalueindex 00ce __init_pointers 00d9 __encode_pointer 0116 __mtinitlocks 011f __freefls@4 012a __decode_pointer 0132 ___flsindex 0143 __calloc_crt 016c __initptd 0174 __imp__GetCurrentThreadId@0 0184 __mtterm"
	strings:
		$1 = { 8B FF 56 57 BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 8B F8 85 FF 0F 84 5E 01 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 83 3D ?? ?? ?? ?? 00 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 16 83 3D ?? ?? ?? ?? 00 74 0D 83 3D ?? ?? ?? ?? 00 74 04 85 C0 75 24 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 0F 84 CC 00 00 00 FF 35 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 BB 00 00 00 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 65 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 A3 ?? ?? ?? ?? 83 F8 FF 74 48 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 34 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 1B 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 33 C0 40 EB 07 E8 ?? ?? ?? ?? 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_272_3_0 {
	meta:
		name = "__mbstrnlen_l"
		size = 259
		refs = "0014 __errno 0024 __invalid_parameter 0060 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0073 _strnlen 0086 __imp__MultiByteToWideChar@24 00c3 __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 8B 75 08 33 DB 3B F3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CC 00 00 00 57 8B 7D 0C 81 FF FF FF FF 7F 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 4C FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 B8 AC 00 00 00 01 75 0B 57 56 E8 ?? ?? ?? ?? 59 59 EB 77 53 53 57 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D F8 74 07 8B 45 F4 83 60 70 FD 83 C8 FF EB 54 89 5D FC 89 5D 08 3B FB 76 37 8A 06 3A C3 74 2C 8D 4D EC 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0D FF 45 08 39 7D 08 73 16 46 38 1E 74 0C FF 45 FC 46 FF 45 08 39 7D 08 72 CE 39 7D 08 72 04 8B C7 EB 03 8B 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__initp_misc_winsig"
		size = 30
		refs = "0009 _ctrlc_action 000e _ctrlbreak_action 0013 _abort_action 0018 _term_action"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "_ctrlevent_capture@4"
		size = 155
		refs = "0003 __sehtable$_ctrlevent_capture@4 0008 __SEH_prolog4 0010 __lock 001e _ctrlc_action 0029 __decode_pointer 003a _ctrlbreak_action 005e __encoded_null 007d __unlock 0094 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 57 E8 ?? ?? ?? ?? 59 89 7D FC 39 7D 08 75 1C BE ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 C7 45 E0 02 00 00 00 EB 1A BE ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 C7 45 E0 15 00 00 00 59 3B C7 74 0C 83 F8 01 74 07 E8 ?? ?? ?? ?? 89 06 C7 45 FC FE FF FF FF E8 0B 00 00 00 39 7D E4 75 0E 33 C0 EB 1A 33 FF 57 E8 ?? ?? ?? ?? 59 C3 83 7D E4 01 74 07 FF 75 E0 FF 55 E4 59 33 C0 40 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_273_2_0 {
	meta:
		name = "_siglookup"
		size = 55
		refs = "000a __XcptActTabCount"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 0D ?? ?? ?? ?? 56 39 50 04 74 0F 8B F1 6B F6 0C 03 75 08 83 C0 0C 3B C6 72 EC 6B C9 0C 03 4D 08 5E 3B C1 73 05 39 50 04 74 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_273_6_0 {
	meta:
		name = "_signal"
		size = 573
		refs = "0003 __sehtable$_signal 0008 __SEH_prolog4 006b __getptd_noexit 007a __XcptActTab 0085 __XcptActTabSize 008a __malloc_crt 00a3 _memcpy 00b0 _siglookup 00d6 __XcptActTabCount 00f5 __lock 0109 _ConsoleCtrlHandler_Installed 0113 _ctrlevent_capture@4 0119 __imp__SetConsoleCtrlHandler@8 012d ___doserrno 0135 __imp__GetLastError@0 015f _abort_action 0164 __decode_pointer 0172 __encode_pointer 017f _ctrlbreak_action 019f _term_action 01bf _ctrlc_action 01fb __unlock 021b __errno 022d __invalid_parameter 0238 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E0 00 8B 75 0C 8B 5D 08 83 FE 04 0F 84 E2 01 00 00 83 FE 03 0F 84 D9 01 00 00 6A 02 5F 3B DF 0F 84 BF 00 00 00 83 FB 15 0F 84 B6 00 00 00 83 FB 16 0F 84 AD 00 00 00 83 FB 06 0F 84 A4 00 00 00 83 FB 0F 0F 84 9B 00 00 00 83 FB 08 74 0E 83 FB 04 74 09 83 FB 0B 0F 85 97 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 88 01 00 00 BF ?? ?? ?? ?? 39 7E 5C 75 27 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 46 5C 85 C0 0F 84 67 01 00 00 FF 35 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 0C FF 76 5C 8B D3 E8 ?? ?? ?? ?? 59 85 C0 0F 84 44 01 00 00 8B 50 08 8B 4D 0C 83 F9 02 0F 84 25 01 00 00 EB 1A 89 48 08 83 C0 0C 8B 3D ?? ?? ?? ?? 6B FF 0C 03 7E 5C 3B C7 0F 83 09 01 00 00 39 58 04 74 E1 E9 FF 00 00 00 6A 00 E8 ?? ?? ?? ?? 59 83 65 FC 00 3B DF 74 05 83 FB 15 75 3E 83 3D ?? ?? ?? ?? 00 75 35 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 41 3B C1 75 08 89 0D ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 89 06 C7 45 E0 01 00 00 00 8B 75 0C 8B C3 2B C7 74 72 83 E8 04 74 0D 83 E8 09 74 48 83 E8 06 74 23 48 75 7F FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 45 E4 3B F7 74 6C 56 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 5E FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 45 E4 3B F7 74 4C 56 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 3E FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 45 E4 3B F7 74 2C 56 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 1E FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 45 E4 3B F7 74 0C 56 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 10 00 00 00 83 7D E0 00 75 13 8B 55 E4 8B C2 EB 42 8B 5D 08 6A 00 E8 ?? ?? ?? ?? 59 C3 83 FB 01 74 2E 83 FB 03 74 29 83 FB 0D 74 24 83 FB 0F 7E 05 83 FB 11 7E 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_273_7_0 {
	meta:
		name = "_raise"
		size = 432
		refs = "0003 __sehtable$_raise 0008 __SEH_prolog4 0034 __getptd_noexit 004a _ctrlc_action 005b _siglookup 0078 __errno 008a __invalid_parameter 0094 _abort_action 00a0 _ctrlbreak_action 00ac _term_action 00be __decode_pointer 00da __exit 00e5 __lock 0120 __First_FPE_Indx 0129 __Num_FPE 014d __encoded_null 017d __unlock 01ab __SEH_epilog4"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 89 7D D8 8B 5D 08 83 FB 0B 7F 4C 74 15 8B C3 6A 02 59 2B C1 74 22 2B C1 74 08 2B C1 74 64 2B C1 75 44 E8 ?? ?? ?? ?? 8B F8 89 7D D8 85 FF 75 14 83 C8 FF E9 61 01 00 00 BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 60 FF 77 5C 8B D3 E8 ?? ?? ?? ?? 8B F0 83 C6 08 8B 06 EB 5A 8B C3 83 E8 0F 74 3C 83 E8 06 74 2B 48 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 EB AE BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 16 BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 0A BE ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 45 E4 01 00 00 00 50 E8 ?? ?? ?? ?? 89 45 E0 59 33 C0 83 7D E0 01 0F 84 D8 00 00 00 39 45 E0 75 07 6A 03 E8 ?? ?? ?? ?? 39 45 E4 74 07 50 E8 ?? ?? ?? ?? 59 33 C0 89 45 FC 83 FB 08 74 0A 83 FB 0B 74 05 83 FB 04 75 1B 8B 4F 60 89 4D D4 89 47 60 83 FB 08 75 40 8B 4F 64 89 4D D0 C7 47 64 8C 00 00 00 83 FB 08 75 2E 8B 0D ?? ?? ?? ?? 89 4D DC 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 03 CA 39 4D DC 7D 19 8B 4D DC 6B C9 0C 8B 57 5C 89 44 11 08 FF 45 DC EB DB E8 ?? ?? ?? ?? 89 06 C7 45 FC FE FF FF FF E8 15 00 00 00 83 FB 08 75 1F FF 77 64 53 FF 55 E0 59 EB 19 8B 5D 08 8B 7D D8 83 7D E4 00 74 08 6A 00 E8 ?? ?? ?? ?? 59 C3 53 FF 55 E0 59 83 FB 08 74 0A 83 FB 0B 74 05 83 FB 04 75 11 8B 45 D4 89 47 60 83 FB 08 75 06 8B 45 D0 89 47 64 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_274_3_0 {
	meta:
		name = "__mbsnset_l"
		size = 327
		refs = "001c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a __errno 003a __invalid_parameter 0064 __strnset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 57 FF 75 14 8D 4D F0 89 75 08 33 DB 33 FF E8 ?? ?? ?? ?? 3B F3 75 30 39 5D 10 74 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 EE 00 00 00 8B 45 F4 39 58 08 75 24 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 CE 00 00 00 8B 4D F8 83 61 70 FD E9 C2 00 00 00 8B 55 0C 8B CA C1 E9 08 3A CB 74 6E 3A D3 75 0F E8 ?? ?? ?? ?? B1 20 C7 00 16 00 00 00 8A D1 39 5D 10 0F 84 8B 00 00 00 8A 06 FF 4D 10 3A C3 74 77 3B FB 75 12 8B 7D F4 0F B6 C0 F6 44 38 1D 04 74 05 33 FF 47 EB 02 33 FF 88 0E 46 8A 06 3A C3 74 1D 3B FB 75 12 8B 7D F4 0F B6 C0 F6 44 38 1D 04 74 05 33 FF 47 EB 02 33 FF 88 16 46 EB 04 C6 46 FF 20 39 5D 10 75 B0 EB 2E 39 5D 10 74 34 8A 06 FF 4D 10 3A C3 74 20 3B FB 75 12 8B 4D F4 0F B6 C0 F6 44 08 1D 04 74 05 33 FF 47 EB 02 33 FF 88 16 46 39 5D 10 75 D7 3B FB 74 07 38 1E 74 03 C6 06 20 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__strnset"
		size = 43
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 12 F2 AE 75 03 83 C1 01 2B D9 8B CB 8B FA 8A 45 0C F3 AA 8B C2 5B 5F C9 C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__wcsset_s"
		size = 91
		refs = "0018 __errno 0027 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 57 3B C6 74 07 8B 55 0C 3B D6 77 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 25 8B C8 66 39 30 74 11 4A 74 0E 66 8B 7D 10 66 89 39 41 41 66 39 31 75 EF 3B D6 75 07 33 C9 66 89 08 EB C2 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_278_3_0 {
	meta:
		name = "__ismbcalpha_l"
		size = 187
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 78 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 3C F7 45 FC 03 01 00 00 74 33 33 C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 BA 03 01 00 00 66 85 14 41 75 D7 8B 4D F0 F6 44 08 1D 01 75 CD 33 C0 EB CC }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__modf_pentium4"
		size = 264
		refs = "000a _Bns 0031 _Sign 00a9 _Mantissa 00b1 _Zero 00fc ___libm_error_support"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 C8 66 0F 28 E0 66 0F 28 F0 66 0F 73 F0 01 66 0F 73 D0 35 66 0F 73 D3 34 66 0F 54 25 ?? ?? ?? ?? 66 0F 7E C0 66 0F FA D0 8B 4C 24 0C 66 0F D3 CA 66 0F F3 CA 66 0F 7E DA 3D FF 03 00 00 7C 1E 3D 32 04 00 00 7F 20 66 0F D6 09 F2 0F 5C F1 66 0F 56 F4 66 0F D6 74 24 04 DD 44 24 04 C3 66 0F D6 21 DD 44 24 04 C3 3D FF 07 00 00 F3 0F 7E 44 24 04 74 11 66 0F D6 01 81 FA 00 08 00 00 D9 EE 7C 02 D9 E0 C3 66 0F 28 C8 F2 0F 58 C0 66 0F D6 01 66 0F 54 05 ?? ?? ?? ?? 66 0F C2 05 ?? ?? ?? ?? 04 66 0F C5 C0 00 66 0F 54 C1 66 0F 56 C4 BA EF 03 00 00 83 F8 00 75 0B 66 0F D6 44 24 04 DD 44 24 04 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 }
	condition:
		$1
}

rule file_282_2_0 {
	meta:
		name = "___wcserror"
		size = 270
		refs = "0009 __getptd_noexit 002b __calloc_crt 005c _wcsncat_s 006d __invoke_watson 0075 ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 007c _wcscat_s 0095 __errno 009c __get_sys_err_msg 00a5 _wcslen 00cf _mbstowcs_s 00e8 ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 E8 ?? ?? ?? ?? 8B F0 33 DB 3B F3 75 07 33 C0 E9 EE 00 00 00 57 BF 86 00 00 00 39 5E 28 75 18 6A 02 57 E8 ?? ?? ?? ?? 59 59 89 46 28 3B C3 75 07 33 C0 E9 CA 00 00 00 8B 76 28 33 C0 66 89 06 8B 45 08 3B C3 74 46 66 39 18 74 41 68 82 00 00 00 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 56 89 45 FC E8 ?? ?? ?? ?? 59 59 B9 84 00 00 00 2B C8 51 FF 75 FC 56 E8 ?? ?? ?? ?? 59 8B CF 2B C8 51 56 E8 ?? ?? ?? ?? 59 8D 04 46 50 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_282_3_0 {
	meta:
		name = "___wcserror_s"
		size = 188
		refs = "0012 __errno 0021 __invalid_parameter 0049 _wcslen 005b _wcscpy_s 006c __invoke_watson 0074 ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 007b _wcscat_s 00b0 __wcserror_s"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 08 56 33 F6 57 3B DE 75 1E E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 88 00 00 00 8B 7D 0C 3B FE 76 DB 33 C0 66 89 03 8B 45 10 3B C6 74 51 66 39 30 74 4C 50 E8 ?? ?? ?? ?? 59 8D 4F F9 3B C1 73 3E FF 75 10 57 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 30 53 E8 ?? ?? ?? ?? 59 2B F8 57 53 E8 ?? ?? ?? ?? 59 8D 04 43 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__wstrdate_s"
		size = 190
		refs = "0019 __errno 002a __invalid_parameter 0053 __imp__GetLocalTime@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B 75 08 57 33 FF 3B F7 74 05 39 7D 0C 77 20 E8 ?? ?? ?? ?? 6A 16 59 57 57 57 57 57 8B F1 89 08 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 82 00 00 00 33 C0 83 7D 0C 09 66 89 06 73 09 E8 ?? ?? ?? ?? 6A 22 EB D3 53 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F0 99 6A 64 5B F7 FB 0F B7 4D F2 6A 2F 58 66 89 46 0A 66 89 46 04 33 C0 66 89 46 10 8B C1 6A 0A 59 0F B7 7D F6 8B DA 99 F7 F9 83 C0 30 66 89 06 83 C2 30 66 89 56 02 8B C7 99 F7 F9 83 C0 30 66 89 46 06 83 C2 30 66 89 56 08 8B C3 99 F7 F9 5B 83 C0 30 83 C2 30 66 89 46 0C 66 89 56 0E 33 C0 5F 5E C9 C3 }
	condition:
		$1
}

rule file_284_1_0 {
	meta:
		name = "__wstrdate"
		size = 28
		refs = "000b __wstrdate_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_515_1_0 {
	meta:
		name = "__strdate"
		size = 28
		refs = "000b __strdate_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_934_1_0 {
	meta:
		name = "__strtime"
		size = 28
		refs = "000b __strtime_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_931_1_0 {
	meta:
		name = "__wstrtime"
		size = 28
		refs = "000b __wstrtime_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__difftime64"
		size = 67
		refs = "0035 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 7C 29 7F 06 83 7D 10 00 72 21 8B 4D 0C 85 C9 7C 1A 8B 45 08 7F 04 85 C0 72 11 2B 45 10 1B 4D 14 89 45 10 89 4D 14 DF 6D 10 5D C3 E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 5D C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "__endthreadex"
		size = 61
		refs = "0007 __FPmtterm 0014 __IsNonwritableInCurrentImage 0024 __getptd_noexit 002e __freeptd 0038 __imp__ExitThread@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 74 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 06 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 FF 75 08 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_287_1_0 {
	meta:
		name = "__callthreadstartex"
		size = 65
		refs = "0003 __sehtable$__callthreadstartex 0008 __SEH_prolog4 000d __getptd 001d __endthreadex 002e __XcptFilter 003c __exit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 70 58 FF 50 54 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 09 89 4D E4 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 FF 75 E4 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_287_2_0 {
	meta:
		name = "__threadstartex@4"
		size = 131
		refs = "0007 ___set_flsgetvalue 000c ___get_flsindex 0012 ___fls_getvalue@4 0025 ___fls_setvalue@8 002f __imp__GetLastError@0 0036 __imp__ExitThread@4 003c __imp__GetCurrentThreadId@0 005b __freefls@4 0061 __FPmtinit 006e __IsNonwritableInCurrentImage 007e __callthreadstartex"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2A 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 0D FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 06 EB 1B 8B 4D 08 8B 51 54 89 50 54 8B 51 58 89 50 58 8B 51 04 51 89 50 04 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 06 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_287_3_0 {
	meta:
		name = "__beginthreadex"
		size = 176
		refs = "0015 __errno 0025 __invalid_parameter 0032 ___set_flsgetvalue 003e __calloc_crt 004b __getptd 0054 __initptd 0077 __threadstartex@4 0083 __imp__CreateThread@24 008d __imp__GetLastError@0 0096 _free 00a4 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 8B 7D 10 33 DB 89 5D FC 3B FB 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 7C 56 E8 ?? ?? ?? ?? 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 3B F3 74 4A E8 ?? ?? ?? ?? FF 70 6C 56 E8 ?? ?? ?? ?? 8B 45 14 83 4E 04 FF 89 46 58 8B 45 1C 59 59 89 7E 54 3B C3 75 03 8D 45 10 50 FF 75 18 56 68 ?? ?? ?? ?? FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 3B C3 75 20 FF 15 ?? ?? ?? ?? 89 45 FC 56 E8 ?? ?? ?? ?? 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 33 C0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__access_s"
		size = 137
		refs = "000e ___doserrno 0015 __errno 0025 __invalid_parameter 003f __imp__GetFileAttributesA@4 004a __imp__GetLastError@0 0050 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 55 F7 45 0C F9 FF FF FF 75 D3 FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 EB 28 A8 10 75 22 A8 01 74 1E F6 45 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D1 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_691_0_0 {
	meta:
		name = "__waccess_s"
		size = 137
		refs = "000e ___doserrno 0015 __errno 0025 __invalid_parameter 003f __imp__GetFileAttributesW@4 004a __imp__GetLastError@0 0050 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 55 F7 45 0C F9 FF FF FF 75 D3 FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 EB 28 A8 10 75 22 A8 01 74 1E F6 45 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D1 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__access"
		size = 24
		refs = "000c __access_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_691_1_0 {
	meta:
		name = "__waccess"
		size = 24
		refs = "000c __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "_wcsncpy_s"
		size = 211
		refs = "002e __errno 003d __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 57 33 FF 39 7D 14 75 10 3B F7 75 10 39 7D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B F7 74 07 8B 5D 0C 3B DF 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 39 7D 14 75 07 33 C0 66 89 06 EB C7 8B 55 10 3B D7 75 07 33 C0 66 89 06 EB CB 83 7D 14 FF 8B C6 75 14 0F B7 0A 66 89 08 40 40 42 42 66 3B CF 74 26 4B 75 EE EB 21 0F B7 0A 66 89 08 40 40 42 42 66 3B CF 74 08 4B 74 05 FF 4D 14 75 E9 39 7D 14 75 05 33 C9 66 89 08 3B DF 0F 85 74 FF FF FF 33 C0 83 7D 14 FF 75 10 8B 4D 0C 6A 50 66 89 44 4E FE 58 E9 5E FF FF FF 66 89 06 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 64 FF FF FF }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__flsbuf"
		size = 356
		refs = "000c __fileno 001c __errno 007a ___iob_func 0095 __isatty 00a0 __getbuf 00d0 __write 0104 ___pioinfo 010b ___badioinfo 011b __lseeki64"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 0C 56 E8 ?? ?? ?? ?? 89 45 0C 8B 46 0C 59 A8 82 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4E 0C 20 83 C8 FF E9 2F 01 00 00 A8 40 74 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB E3 53 33 DB A8 01 74 16 89 5E 04 A8 10 0F 84 87 00 00 00 8B 4E 08 83 E0 FE 89 0E 89 46 0C 8B 46 0C 83 E0 EF 83 C8 02 89 46 0C 89 5E 04 89 5D FC A9 0C 01 00 00 75 2C E8 ?? ?? ?? ?? 83 C0 20 3B F0 74 0C E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 0D FF 75 0C E8 ?? ?? ?? ?? 59 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 F7 46 0C 08 01 00 00 57 0F 84 80 00 00 00 8B 46 08 8B 3E 8D 48 01 89 0E 8B 4E 18 2B F8 49 3B FB 89 4E 04 7E 1D 57 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC EB 4D 83 C8 20 89 46 0C 83 C8 FF EB 79 8B 4D 0C 83 F9 FF 74 1B 83 F9 FE 74 16 8B C1 83 E0 1F 8B D1 C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 04 20 74 14 6A 02 53 53 51 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 25 8B 46 08 8A 4D 08 88 08 EB 16 33 FF 47 57 8D 45 08 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 39 7D FC 74 09 83 4E 0C 20 83 C8 FF EB 08 8B 45 08 25 FF 00 00 00 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__alldiv"
		size = 170
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 4E 33 D2 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5B 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_296_3_0 {
	meta:
		name = "__mbsicoll_l"
		size = 170
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 005d __stricoll_l 0080 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 61 39 5D 0C 74 D0 8B 45 F4 39 58 08 75 13 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 35 FF 70 04 6A FF FF 75 0C 6A FF FF 75 08 68 01 10 00 00 FF 70 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9B 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__mbccpy_l"
		size = 28
		refs = "0013 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_297_1_0 {
	meta:
		name = "__mbccpy"
		size = 27
		refs = "0012 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__is_LFH_enabled"
		size = 127
		refs = "000c ?bInitialized@?1??_is_LFH_enabled@@9@9 0014 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 001a __imp__GetModuleHandleW@4 0023 ??_C@_0BF@PEEJCKGM@HeapQueryInformation?$AA@ 002a __imp__GetProcAddress@8 0030 __encode_pointer 0036 ?pfnHeapQueryInformation@?1??_is_LFH_enabled@@9@9 0045 __encoded_null 005f __crtheap 0065 __decode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 83 3D ?? ?? ?? ?? 00 75 31 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 18 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B C8 74 28 6A 00 6A 04 8D 45 FC 50 6A 00 FF 35 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 0B 83 7D FC 02 75 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_298_1_0 {
	meta:
		name = "__expand"
		size = 320
		refs = "0003 __sehtable$__expand 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0052 ___active_heap 0060 __lock 006a ___sbh_find_block 007b ___sbh_threshold 0085 ___sbh_resize_block 00b7 __crtheap 00bd __imp__HeapReAlloc@16 00d1 __imp__GetLastError@0 00d7 __get_errno_from_oserr 00e2 __SEH_epilog4 00f2 __unlock 0109 __imp__HeapSize@12 0133 __is_LFH_enabled"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 5D 08 33 FF 3B DF 0F 95 C0 3B C7 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A6 00 00 00 8B 75 0C 83 FE E0 76 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E4 83 3D ?? ?? ?? ?? 03 0F 85 9B 00 00 00 6A 04 E8 ?? ?? ?? ?? 59 89 7D FC 53 E8 ?? ?? ?? ?? 59 89 45 E0 3B C7 74 1D 89 7D E4 3B 35 ?? ?? ?? ?? 77 12 56 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 03 89 5D E4 C7 45 FC FE FF FF FF E8 50 00 00 00 39 7D E0 75 3A 3B F7 75 03 33 F6 46 83 C6 0F 83 E6 F0 56 53 6A 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B C7 75 16 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 06 59 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 0C 8B 5D 08 33 FF 6A 04 E8 ?? ?? ?? ?? 59 C3 3B F7 75 03 33 F6 46 53 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 56 53 6A 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 85 C0 75 B8 81 FF 00 40 00 00 77 9A 3B F7 77 96 E8 ?? ?? ?? ?? 85 C0 74 8D 89 5D E4 EB 9E }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "__wtof_l"
		size = 140
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f __errno 002f __invalid_parameter 0053 __iswctype_l 0066 _wcslen 0072 __wfltin2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 53 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 08 33 DB 3B F3 75 2A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD D9 EE EB 42 46 46 8D 45 F0 50 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E8 8D 45 F0 50 53 53 56 E8 ?? ?? ?? ?? 59 50 8D 45 D8 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 18 38 5D FC 74 07 8B 45 F8 83 60 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "_printf"
		size = 175
		refs = "0003 __sehtable$_printf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 0045 __lock_file2 0057 __stbuf 006f __output_l 0080 __ftbuf 0097 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "_wprintf"
		size = 175
		refs = "0003 __sehtable$_wprintf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 0045 __lock_file2 0057 __stbuf 006f __woutput_l 0080 __ftbuf 0097 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_301_3_0 {
	meta:
		name = "_printf_s"
		size = 24
		refs = "000f __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_510_11_0 {
	meta:
		name = "__cprintf"
		size = 24
		refs = "000f __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_420_12_0 {
	meta:
		name = "__cprintf_p"
		size = 24
		refs = "000f __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_358_11_0 {
	meta:
		name = "__cprintf_s"
		size = 24
		refs = "000f __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_323_10_0 {
	meta:
		name = "__cwprintf"
		size = 24
		refs = "000f __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_872_10_0 {
	meta:
		name = "__cwprintf_p"
		size = 24
		refs = "000f __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_633_10_0 {
	meta:
		name = "__cwprintf_s"
		size = 24
		refs = "000f __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_301_5_0 {
	meta:
		name = "__printf_p"
		size = 24
		refs = "000f __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_868_5_0 {
	meta:
		name = "__wprintf_p"
		size = 24
		refs = "000f __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_868_3_0 {
	meta:
		name = "_wprintf_s"
		size = 24
		refs = "000f __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_301_6_0 {
	meta:
		name = "__set_printf_count_output"
		size = 42
		refs = "0007 ___security_cookie 0015 ___enable_percent_n"
	strings:
		$1 = { 8B FF 55 8B EC 8B 0D ?? ?? ?? ?? 8B 55 08 83 C9 01 33 C0 39 0D ?? ?? ?? ?? 0F 94 C0 F7 DA 1B D2 23 D1 89 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_301_7_0 {
	meta:
		name = "__get_printf_count_output"
		size = 22
		refs = "0001 ___security_cookie 000c ___enable_percent_n"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 C8 01 33 C9 39 05 ?? ?? ?? ?? 0F 94 C1 8B C1 C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_302_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "_evaluate"
		size = 88
		refs = "0016 __invalid_parameter 001c __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 3B CF 7E 04 3B D7 7F 15 57 57 57 57 57 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 14 EB 30 DD 04 C8 DD 45 08 EB 05 DD 04 C8 DE C2 49 DC C9 3B CF 7F F4 DD 00 8D 42 FF DE C2 DD 04 D6 3B C7 D8 C9 7E 06 DC 04 C6 48 EB F4 DD D9 DC 06 DE F9 5F 5D C3 }
	condition:
		$1
}

rule file_303_1_0 {
	meta:
		name = "__j0"
		size = 374
		refs = "001f __real@401e000000000000 002f _J0p 0052 _J0q 007c __real@4020000000000000 0081 _P0p 00af _P0q 00cc _Q0p 00fa _Q0q 0127 __real@3fe921fb54442d18 0135 _cos 0146 _sin 015d __real@400921fb54442d18 0163 __real@4000000000000000 016b _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 05 D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 4E D9 C0 B8 ?? ?? ?? ?? DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 D9 C0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DE C2 DE F1 DD 5D E8 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E0 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E0 DC 4D F8 DE C9 DC 6D E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_303_2_0 {
	meta:
		name = "__j1"
		size = 395
		refs = "002a __real@401e000000000000 003a _J1p 005d _J1q 008e __real@4020000000000000 0093 _P1p 00c1 _P1q 00de _Q1p 010c _Q1q 0139 __real@4002d97c7f3321d2 0147 _cos 0158 _sin 016f __real@400921fb54442d18 0175 __real@4000000000000000 017d _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 D9 EE C7 45 FC 01 00 00 00 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 09 83 4D FC FF D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 55 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 DB 45 FC DE CA DE C9 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F4 DD 45 F4 DC 4D F4 D9 C0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DE C2 DE F1 DD 5D E4 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D DC DC 25 ?? ?? ?? ?? DD 5D EC DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D E4 DD 5D E4 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DD 45 DC DC 4D F4 DE C9 DC 6D E4 DD 5D DC DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DA 4D FC 59 59 DC 4D DC C9 C3 }
	condition:
		$1
}

rule file_303_3_0 {
	meta:
		name = "__jn"
		size = 319
		refs = "002a __j0 0041 __j1 006b _fabs"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 8B 75 08 85 F6 7D 0F DD 45 0C F7 DE D9 E0 89 75 08 DD 5D 0C 85 F6 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 07 01 00 00 83 FE 01 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 F0 00 00 00 D9 EE DC 55 0C DF E0 F6 C4 44 0F 8B E2 00 00 00 DD D8 51 DB 45 08 51 DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DC 5D F4 59 03 F6 59 DF E0 DD 45 0C F6 C4 41 75 54 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? D9 C0 59 D9 C9 59 DC C0 6A 04 58 89 45 FC DC 75 0C DC 65 F4 3B F0 75 09 DD D9 E9 85 00 00 00 D9 C9 D9 C0 DB 45 FC 83 45 FC 02 DE CA D9 C9 DC 75 0C DE E2 39 75 FC 75 E7 DD D8 EB 68 D9 C0 8D 46 24 3B C6 D8 C9 D9 EE 89 75 08 89 45 FC 7E 10 DA 6D FC 83 6D FC 02 39 75 FC D9 C1 DE F1 7F F0 DD D9 83 C6 FE DA 6D 08 89 75 FC D9 C1 DE F1 DD 55 EC D9 E8 DB 45 FC 83 6D FC 02 D8 F3 DE E2 D9 C9 DD 5D F4 74 0B DD 45 F4 DB 45 FC DC 4D F4 EB E6 51 DD D8 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D EC DC 75 F4 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_303_4_0 {
	meta:
		name = "_domain_err"
		size = 54
		refs = "0010 __ctrlfp 002d __except1"
	strings:
		$1 = { 8B FF 55 8B EC 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 14 59 59 50 83 EC 10 DD 5C 24 08 DD 45 0C DD 1C 24 FF 75 08 6A 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_303_5_0 {
	meta:
		name = "__y0"
		size = 439
		refs = "001a __d_ind 002b _domain_err 0036 __real@401e000000000000 0046 _Y0p 0069 _Y0q 0098 __j0 009e __real@3fe45f306dc9c883 00ac _log 00bd __real@4020000000000000 00c2 _P0p 00f0 _P0q 010d _Q0p 013b _Q0q 0168 __real@3fe921fb54442d18 0176 _cos 018c _sin 019e __real@400921fb54442d18 01a4 __real@4000000000000000 01ac _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 78 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 DC 45 F8 E9 F8 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 D9 C0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DE C2 DE F1 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E8 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 DC 4D F8 DE C9 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_303_6_0 {
	meta:
		name = "__y1"
		size = 455
		refs = "001a __d_ind 002b _domain_err 0036 __real@401e000000000000 004a _Y1p 006d _Y1q 009c __j1 00aa _log 00ba __real@3fe45f306dc9c883 00cd __real@4020000000000000 00d2 _P1p 0100 _P1q 011d _Q1p 014b _Q1q 0178 __real@4002d97c7f3321d2 0186 _cos 019c _sin 01ae __real@400921fb54442d18 01b4 __real@4000000000000000 01bc _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 84 00 00 00 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 D9 E8 DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DD 45 F8 DC 4D 08 DE C1 E9 F8 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 D9 C0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DE C2 DE F1 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 3D ?? ?? ?? ?? D8 C9 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 3D ?? ?? ?? ?? D8 CA 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E8 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 DC 4D F8 DE C9 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_303_7_0 {
	meta:
		name = "__yn"
		size = 200
		refs = "001a __d_ind 002b _domain_err 0059 __y0 0065 __y1 0085 __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 14 DD 45 0C D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 53 33 DB 43 83 7D 08 00 89 5D FC 7D 10 F7 5D 08 84 5D 08 74 04 83 4D FC FF 83 7D 08 00 51 51 DD 1C 24 75 07 E8 ?? ?? ?? ?? EB 0A 39 5D 08 75 0C E8 ?? ?? ?? ?? DA 4D FC 59 59 EB 55 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 45 08 3B C3 DC 75 0C 59 59 89 5D 10 7F 06 DD D9 EB 21 D9 C9 DB 45 10 FF 45 10 39 45 10 D8 C9 D8 CA DC 65 F4 DD 5D EC D9 C9 DD 5D F4 DD 45 EC 7C E1 DD D8 DD D8 DB 45 FC DC 4D EC 5B C9 C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "_fabs"
		size = 186
		refs = "001a __ctrlfp 003a __sptype 004f __real@3ff0000000000000 0065 __except1 0076 __handle_qnan1"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 D9 EE 56 57 DD 5D F8 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 59 59 8B 4D 0E 8B F8 B8 F0 7F 00 00 23 C8 66 3B C8 75 68 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 4A 48 74 39 48 DD 45 08 57 74 21 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 15 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 48 51 51 DD 1C 24 6A 15 E8 ?? ?? ?? ?? 83 C4 10 EB 37 56 57 E8 ?? ?? ?? ?? DD 45 08 D9 E0 EB 27 56 57 E8 ?? ?? ?? ?? DD 45 08 EB 1B 8B 45 0C 25 FF FF FF 7F 89 45 FC 8B 45 08 56 57 89 45 F8 E8 ?? ?? ?? ?? DD 45 F8 59 59 5F 5E C9 C3 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__ftell_nolock"
		size = 413
		refs = "0014 __errno 0024 __invalid_parameter 0035 __fileno 004a __lseek 0089 ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 57 8B 7D 08 33 DB 3B FB 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 66 01 00 00 57 E8 ?? ?? ?? ?? 39 5F 04 59 89 45 FC 7D 03 89 5F 04 6A 01 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 89 45 F8 7C D3 8B 57 0C F7 C2 08 01 00 00 75 08 2B 47 04 E9 2E 01 00 00 8B 07 8B 4F 08 56 8B F0 2B F1 89 75 F4 F6 C2 03 74 41 8B 55 FC 8B 75 FC C1 FA 05 8B 14 95 ?? ?? ?? ?? 83 E6 1F C1 E6 06 F6 44 32 04 80 74 17 8B D1 3B D0 73 11 8B F0 80 3A 0A 75 05 FF 45 F4 33 DB 42 3B D6 72 F1 39 5D F8 75 1C 8B 45 F4 E9 DA 00 00 00 84 D2 78 EF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 87 00 00 00 F6 47 0C 01 0F 84 B4 00 00 00 8B 57 04 3B D3 75 08 89 5D F4 E9 A5 00 00 00 8B 5D FC 8B 75 FC 2B C1 03 C2 C1 FB 05 83 E6 1F 8D 1C 9D ?? ?? ?? ?? 89 45 08 8B 03 C1 E6 06 F6 44 30 04 80 74 79 6A 02 6A 00 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 3B 45 F8 75 20 8B 47 08 8B 4D 08 03 C8 EB 09 80 38 0A 75 03 FF 45 08 40 3B C1 72 F3 F7 47 0C 00 20 00 00 EB 40 6A 00 FF 75 F8 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 05 83 C8 FF EB 3A B8 00 02 00 00 39 45 08 77 10 8B 4F 0C F6 C1 08 74 08 F7 C1 00 04 00 00 74 03 8B 47 18 89 45 08 8B 03 F6 44 30 04 04 74 03 FF 45 08 8B 45 08 29 45 F8 8B 45 F4 8B 4D F8 03 C1 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_307_1_0 {
	meta:
		name = "_ftell"
		size = 110
		refs = "0003 __sehtable$_ftell 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 003b __lock_file 0047 __ftell_nolock 005f __SEH_epilog4 0068 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 27 FF 75 08 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_308_3_0 {
	meta:
		name = "__ismbcspace_l"
		size = 196
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 ___crtGetStringTypeA 009e __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6B 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 70 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CF 66 39 5D FE 75 0B F6 45 FC 08 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 2E 8B 45 EC 83 B8 AC 00 00 00 01 7E 11 8D 45 EC 50 6A 08 51 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8B 80 C8 00 00 00 0F B7 04 48 83 E0 08 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_309_3_0 {
	meta:
		name = "__mbsnbset_l"
		size = 229
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d __strnset 0056 __errno 0066 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 FF 75 14 8D 4D F0 89 75 08 E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 24 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 A4 00 00 00 8B 4D F8 83 61 70 FD E9 98 00 00 00 57 8B 7D 10 3B F3 75 2C 3B FB 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 8B 4D 0C 8B C1 C1 E8 08 3A C3 74 44 8A D1 3A CB 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 B0 20 8A D0 EB 1A 4F 38 1E 74 2C 8B CF 4F 85 C9 74 14 8D 4E 01 38 19 74 0D 88 06 8B F1 88 16 46 3B FB 75 E2 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 0E 46 3B FB 75 F4 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__stbuf"
		size = 156
		refs = "000b __fileno 0011 __isatty 001c ___iob_func 003c __cflush 004e __stdbuf 005e __malloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 7C E8 ?? ?? ?? ?? 83 C0 20 3B F0 75 04 33 C0 EB 0F E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 60 33 C0 40 FF 05 ?? ?? ?? ?? F7 46 0C 0C 01 00 00 75 4E 53 57 8D 3C 85 ?? ?? ?? ?? 83 3F 00 BB 00 10 00 00 75 20 53 E8 ?? ?? ?? ?? 59 89 07 85 C0 75 13 8D 46 14 6A 02 89 46 08 89 06 58 89 46 18 89 46 04 EB 0D 8B 3F 89 7E 08 89 3E 89 5E 18 89 5E 04 81 4E 0C 02 11 00 00 33 C0 5F 40 5B EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "__ftbuf"
		size = 52
		refs = "001a __flush"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 27 56 8B 75 0C F7 46 0C 00 10 00 00 74 19 56 E8 ?? ?? ?? ?? 81 66 0C FF EE FF FF 83 66 18 00 83 26 00 83 66 08 00 59 5E 5D C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 18
		refs = "000e ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 74 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_1_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 94
		refs = "0003 __sehtable$?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0048 ?terminate@@YAXXZ 0057 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 4D 10 78 3A 8B 4D 08 2B 4D 0C 89 4D 08 FF 55 14 EB ED 8B 45 EC 89 45 E4 8B 45 E4 8B 00 89 45 E0 8B 45 E0 81 38 63 73 6D E0 74 0B C7 45 DC 00 00 00 00 8B 45 DC C3 E8 ?? ?? ?? ?? 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_311_2_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 99
		refs = "0003 __sehtable$??_M@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0044 __SEH_epilog4 005e ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 75 0C 8B C6 0F AF 45 10 01 45 08 83 65 FC 00 FF 4D 10 78 0B 29 75 08 8B 4D 08 FF 55 14 EB F0 C7 45 E4 01 00 00 00 C7 45 FC FE FF FF FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 10 00 83 7D E4 00 75 11 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__byteswap_ulong"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 8B C1 BA 00 FF 00 00 23 C2 8B F1 C1 E6 10 03 C6 8B F1 C1 EE 08 23 F2 C1 E0 08 03 C6 C1 E9 18 03 C1 5E 5D C3 }
	condition:
		$1
}

rule file_312_1_0 {
	meta:
		name = "__byteswap_ushort"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B C1 C1 E0 08 66 C1 E9 08 66 03 C1 5D C3 }
	condition:
		$1
}

rule file_312_2_0 {
	meta:
		name = "__byteswap_uint64"
		size = 182
		refs = "0025 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 5D 08 56 57 33 C0 50 BE 00 00 01 00 56 FF 75 0C 81 E3 00 FF 00 00 FF 75 08 89 45 FC E8 ?? ?? ?? ?? 03 D8 8B 45 FC 13 C2 33 FF 57 56 50 53 E8 ?? ?? ?? ?? 8B 4D 08 81 E1 00 00 FF 00 57 33 DB 03 C1 56 13 D3 52 50 E8 ?? ?? ?? ?? 8B 4D 08 BE 00 00 00 FF 23 CE 57 03 C1 68 00 01 00 00 13 D3 52 50 E8 ?? ?? ?? ?? 8B 4D 0C 8B F9 C1 EF 08 81 E7 00 FF 00 00 03 C7 8B 7D 08 13 D3 8B D9 0F AC DF 08 23 FE 33 F6 03 C7 8B 7D 08 13 D6 8B F1 0F AC F7 18 8B F7 81 E6 00 00 FF 00 33 FF 03 C6 13 D7 C1 E9 18 33 F6 03 C1 5F 13 D6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "_init_namebuf"
		size = 199
		refs = "001a _tmpnam_s_buf 0021 _tmpfile_buf 002b _tmpnam_buf 0037 ??_C@_01KICIPPFI@?2?$AA@ 003e _strcpy_s 004f __invoke_watson 0084 __getpid 008a __ultoa_s 00a3 ??_C@_01LFCBOECM@?4?$AA@ 00aa _strcat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 56 57 33 DB 33 FF 2B C3 74 17 48 74 0A 48 75 1A BE ?? ?? ?? ?? EB 05 BE ?? ?? ?? ?? 6A 12 5F EB 0C BE ?? ?? ?? ?? 6A 0E EB F4 8B 75 08 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 46 01 8A 48 FF 80 F9 5C 74 09 80 F9 2F 74 04 C6 00 5C 40 83 7D 08 01 75 05 C6 00 74 EB 03 C6 00 73 40 8B CE 2B C8 6A 20 03 CF 51 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "_genfname"
		size = 176
		refs = "0009 ___security_cookie 001b __mbsrchr 0039 __invalid_parameter 004c _strtoul 0063 __ultoa_s 0074 __invoke_watson 0087 _strcpy_s 00aa @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B F9 6A 2E 57 E8 ?? ?? ?? ?? 8B F0 46 59 59 3B F7 72 09 8B C6 2B C7 39 45 08 77 14 33 DB 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5C 6A 20 33 DB 53 56 E8 ?? ?? ?? ?? 83 C4 0C 40 3B 45 0C 73 E7 6A 20 6A 08 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 45 F4 2B FE 03 7D 08 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_313_4_0 {
	meta:
		name = "__tmpnam_helper"
		size = 319
		refs = "0003 __sehtable$__tmpnam_helper 0008 __SEH_prolog4 0012 __errno 001e __mtinitlocknum 003b __lock 0049 _tmpnam_buf 0052 _tmpnam_s_buf 0061 _init_namebuf 006f _genfname 0080 __access_s 0092 __getptd_noexit 00ad __malloc_crt 00cb _strlen 00eb _strcpy_s 00fc __invoke_watson 012c __unlock 013a __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 E8 ?? ?? ?? ?? 8B 00 89 45 E0 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 11 8B 45 18 89 18 E8 ?? ?? ?? ?? 8B 00 E9 01 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC 39 5D 10 75 09 BF ?? ?? ?? ?? 6A 0E EB 07 BF ?? ?? ?? ?? 6A 12 5E 38 1F 75 0B FF 75 10 E8 ?? ?? ?? ?? 59 EB 15 FF 75 14 56 8B CF E8 ?? ?? ?? ?? 59 85 C0 59 0F 85 86 00 00 00 53 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 DE 8B 75 08 3B F3 75 33 E8 ?? ?? ?? ?? 8B F0 3B F3 75 09 C7 45 E4 0C 00 00 00 EB 5E 39 5E 2C 75 0F 6A 0E E8 ?? ?? ?? ?? 59 89 46 2C 3B C3 74 E3 8B 76 2C 89 75 08 57 6A 0E EB 25 39 5D 10 74 1C 57 E8 ?? ?? ?? ?? 59 3B 45 0C 72 10 C7 45 E4 22 00 00 00 39 5D 0C 74 22 88 1E EB 1E 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 C7 45 FC FE FF FF FF E8 1A 00 00 00 8B 45 18 8B 4D 08 89 08 8B 75 E4 E8 ?? ?? ?? ?? 3B F3 74 0F 89 30 EB 10 33 DB 6A 02 E8 ?? ?? ?? ?? 59 C3 8B 4D E0 89 08 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_313_5_0 {
	meta:
		name = "_tmpnam_s"
		size = 70
		refs = "000e __errno 001e __invalid_parameter 003c __tmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 19 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5E 5D C3 }
	condition:
		$1
}

rule file_863_4_0 {
	meta:
		name = "__wtmpnam_s"
		size = 70
		refs = "000e __errno 001e __invalid_parameter 003c __wtmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 19 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5E 5D C3 }
	condition:
		$1
}

rule file_313_6_0 {
	meta:
		name = "_tmpnam"
		size = 39
		refs = "001b __tmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_863_5_0 {
	meta:
		name = "__wtmpnam"
		size = 39
		refs = "001b __wtmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_313_7_0 {
	meta:
		name = "__tmpfile_helper"
		size = 544
		refs = "0003 __sehtable$__tmpfile_helper 0008 __SEH_prolog4 0023 __errno 0032 __invalid_parameter 0043 __mtinitlocknum 005b __lock 0064 _tmpfile_buf 0075 ??_C@_01KICIPPFI@?2?$AA@ 007d _strcpy_s 008e __invoke_watson 00cf __getpid 00d5 __ultoa_s 00ee ??_C@_01LFCBOECM@?4?$AA@ 00f6 _strcat_s 011a _genfname 0129 __getstream 016d __sopen_s 01a8 __strdup 01b8 __close 01c8 __commode 0201 __SEH_epilog4 0212 __unlock_file 021a __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D D4 89 5D D8 33 C9 8B 45 08 3B C3 0F 95 C1 3B CB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 C0 01 00 00 89 18 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 0C E8 ?? ?? ?? ?? 8B 00 E9 A8 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC BF ?? ?? ?? ?? 38 1D ?? ?? ?? ?? 0F 85 9C 00 00 00 68 ?? ?? ?? ?? 6A 12 57 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 ?? ?? ?? ?? A0 ?? ?? ?? ?? 3C 5C 74 12 3C 2F 74 0E C6 05 ?? ?? ?? ?? 5C C7 45 E4 ?? ?? ?? ?? 8B 45 E4 C6 00 74 FF 45 E4 6A 20 B8 ?? ?? ?? ?? 2B 45 E4 50 FF 75 E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 6A 12 57 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 27 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 18 68 FF FF FF 7F 6A 12 8B CF E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 B9 00 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 DC 3B F3 75 0C C7 45 D4 18 00 00 00 E9 A2 00 00 00 C7 45 D8 01 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 D0 E8 ?? ?? ?? ?? 89 18 68 80 01 00 00 FF 75 0C 68 42 85 00 00 57 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 14 83 F8 11 75 14 68 FF FF FF 7F 6A 12 8B CF E8 ?? ?? ?? ?? 59 59 85 C0 74 CD E8 ?? ?? ?? ?? 39 18 75 0A E8 ?? ?? ?? ?? 8B 4D D0 89 08 83 7D E0 FF 74 3E 57 E8 ?? ?? ?? ?? 59 89 46 1C 3B C3 75 0B FF 75 E0 E8 ?? ?? ?? ?? 59 EB 25 89 5E 04 89 1E 89 5E 08 A1 ?? ?? ?? ?? 0D 80 00 00 00 89 46 0C 8B 45 E0 89 46 10 8B 45 08 89 30 EB 03 8B 75 DC C7 45 FC FE FF FF FF E8 1B 00 00 00 8B 75 D4 3B F3 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 E8 ?? ?? ?? ?? C3 33 DB 8B 75 DC 39 5D D8 74 07 56 E8 ?? ?? ?? ?? 59 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_313_8_0 {
	meta:
		name = "_tmpfile"
		size = 28
		refs = "0011 __tmpfile_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 C9 C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__cputs"
		size = 148
		refs = "0003 __sehtable$__cputs 0008 __SEH_prolog4 001e ___doserrno 0025 __errno 0035 __invalid_parameter 0044 __lock 0051 __confh 0058 ___initconout 006d __putch_nolock 0086 __SEH_epilog4 008e __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 39 5D 08 0F 95 C0 3B C3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 44 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 6A FE 5E 39 35 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 8B 45 08 8A 00 3A C3 74 15 0F BE C0 FF 45 08 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 E5 09 45 E4 89 75 FC E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "_fast_error_exit"
		size = 41
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0017 __NMSG_WRITE 0021 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 382
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0017 __imp__GetStartupInfoA@4 0029 ___ImageBase 006f __heap_init 007b _fast_error_exit 0081 __mtinit 0092 __RTC_Initialize 009a __ioinit 00a5 __amsg_exit 00ac __imp__GetCommandLineA@0 00b1 __acmdln 00b6 ___crtGetEnvironmentStringsA 00bb __aenvptr 00c0 __setargv 00d1 __setenvp 00e3 __cinit 00f4 __wincmdln 010f _WinMain@16 011d _exit 0122 __cexit 0138 __XcptFilter 0150 __exit 0155 __c_exit 0179 __SEH_epilog4"
	strings:
		$1 = { 6A 58 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 FC 8D 45 98 50 FF 15 ?? ?? ?? ?? 6A FE 5F 89 7D FC B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 75 38 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 27 B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 19 83 B8 ?? ?? ?? ?? 0E 76 10 33 C9 39 B0 ?? ?? ?? ?? 0F 95 C1 89 4D E4 EB 03 89 75 E4 33 DB 43 53 E8 ?? ?? ?? ?? 59 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 5D FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 59 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 5D C4 74 06 0F B7 4D C8 EB 03 6A 0A 59 51 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 39 75 E4 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 7D FC EB 35 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 EB 13 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF B8 FF 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "__mbsrchr_l"
		size = 188
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 0031 __invalid_parameter 0056 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 10 33 DB 8D 4D EC 89 5D FC E8 ?? ?? ?? ?? 8B 4D 08 3B CB 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 71 56 8B 75 F0 39 5E 08 75 19 FF 75 0C 51 E8 ?? ?? ?? ?? 59 59 38 5D F8 74 57 8B 4D F4 83 61 70 FD EB 4E 57 8A 11 0F B6 C2 0F B6 F8 F6 44 37 1D 04 74 21 41 8A 11 3A D3 74 15 0F B6 FA C1 E0 08 0B C7 39 45 0C 75 15 8D 41 FF 89 45 FC EB 0D 39 5D FC EB 03 39 45 0C 75 03 89 4D FC 41 3A D3 75 C3 5F 38 5D F8 74 07 8B 45 F4 83 60 70 FD 8B 45 FC 5E 5B C9 C3 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "___strncnt"
		size = 33
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 EB 07 49 80 38 00 74 06 40 85 C9 75 F5 49 8B 45 0C 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_319_3_0 {
	meta:
		name = "___freetlocinfo"
		size = 329
		refs = "0018 ___lconv_c 003c _free 0047 ___free_lconv_mon 0068 ___free_lconv_num 00dd ___lc_time_c 00ed ___free_lc_time 0107 ___clocalestr"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B 86 BC 00 00 00 33 DB 57 3B C3 74 6F 3D ?? ?? ?? ?? 74 68 8B 86 B0 00 00 00 3B C3 74 5E 39 18 75 5A 8B 86 B8 00 00 00 3B C3 74 17 39 18 75 13 50 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 B4 00 00 00 3B C3 74 17 39 18 75 13 50 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 FF B6 B0 00 00 00 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 C0 00 00 00 3B C3 74 44 39 18 75 40 8B 86 C4 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 CC 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 D0 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8D BE D4 00 00 00 8B 07 3D ?? ?? ?? ?? 74 17 39 98 B4 00 00 00 75 0F 50 E8 ?? ?? ?? ?? FF 37 E8 ?? ?? ?? ?? 59 59 8D 7E 50 C7 45 08 06 00 00 00 81 7F F8 ?? ?? ?? ?? 74 11 8B 07 3B C3 74 0B 39 18 75 07 50 E8 ?? ?? ?? ?? 59 39 5F FC 74 12 8B 47 04 3B C3 74 0B 39 18 75 07 50 E8 ?? ?? ?? ?? 59 83 C7 10 FF 4D 08 75 C7 56 E8 ?? ?? ?? ?? 59 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_319_4_0 {
	meta:
		name = "___addlocaleref"
		size = 143
		refs = "0009 __imp__InterlockedIncrement@4 0055 ___clocalestr"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 35 ?? ?? ?? ?? 57 8B 7D 08 57 FF D6 8B 87 B0 00 00 00 85 C0 74 03 50 FF D6 8B 87 B8 00 00 00 85 C0 74 03 50 FF D6 8B 87 B4 00 00 00 85 C0 74 03 50 FF D6 8B 87 C0 00 00 00 85 C0 74 03 50 FF D6 8D 5F 50 C7 45 08 06 00 00 00 81 7B F8 ?? ?? ?? ?? 74 09 8B 03 85 C0 74 03 50 FF D6 83 7B FC 00 74 0A 8B 43 04 85 C0 74 03 50 FF D6 83 C3 10 FF 4D 08 75 D6 8B 87 D4 00 00 00 05 B4 00 00 00 50 FF D6 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_319_5_0 {
	meta:
		name = "___removelocaleref"
		size = 153
		refs = "0015 __imp__InterlockedDecrement@4 005d ___clocalestr"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B 7D 08 85 FF 0F 84 83 00 00 00 53 56 8B 35 ?? ?? ?? ?? 57 FF D6 8B 87 B0 00 00 00 85 C0 74 03 50 FF D6 8B 87 B8 00 00 00 85 C0 74 03 50 FF D6 8B 87 B4 00 00 00 85 C0 74 03 50 FF D6 8B 87 C0 00 00 00 85 C0 74 03 50 FF D6 8D 5F 50 C7 45 08 06 00 00 00 81 7B F8 ?? ?? ?? ?? 74 09 8B 03 85 C0 74 03 50 FF D6 83 7B FC 00 74 0A 8B 43 04 85 C0 74 03 50 FF D6 83 C3 10 FF 4D 08 75 D6 8B 87 D4 00 00 00 05 B4 00 00 00 50 FF D6 5E 5B 8B C7 5F 5D C3 }
	condition:
		$1
}

rule file_319_6_0 {
	meta:
		name = "__copytlocinfo_nolock"
		size = 38
		refs = "001e ___addlocaleref"
	strings:
		$1 = { 8B FF 56 8B F1 85 F6 74 1B 85 C0 74 17 3B C6 74 13 57 6A 36 59 8B F8 F3 A5 83 20 00 50 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_319_7_0 {
	meta:
		name = "__updatetlocinfoEx_nolock"
		size = 62
		refs = "0013 ___addlocaleref 001e ___removelocaleref 002a ___initiallocinfo 0032 ___freetlocinfo"
	strings:
		$1 = { 85 FF 74 37 85 C0 74 33 56 8B 30 3B F7 74 28 57 89 38 E8 ?? ?? ?? ?? 59 85 F6 74 1B 56 E8 ?? ?? ?? ?? 83 3E 00 59 75 0F 81 FE ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C7 5E C3 33 C0 C3 }
	condition:
		$1
}

rule file_319_8_0 {
	meta:
		name = "___updatetlocinfo"
		size = 118
		refs = "0003 __sehtable$___updatetlocinfo 0008 __SEH_prolog4 000d __getptd 0014 ___globallocalestatus 0032 __amsg_exit 003a __SEH_epilog4 0042 __lock 0050 ___ptlocinfo 0055 __updatetlocinfoEx_nolock 006d __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 A1 ?? ?? ?? ?? 85 46 70 74 22 83 7E 6C 00 74 1C E8 ?? ?? ?? ?? 8B 70 6C 85 F6 75 08 6A 20 E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 8D 46 6C 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB C1 6A 0C E8 ?? ?? ?? ?? 59 8B 75 E4 C3 }
	condition:
		$1
}

rule file_319_9_0 {
	meta:
		name = "__configthreadlocale"
		size = 106
		refs = "0008 __getptd 0034 __errno 0044 __invalid_parameter 005f ___globallocalestatus"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 8B 48 70 F6 C1 02 6A 00 5A 0F 94 C2 42 8B FA 8B 55 08 83 FA FF 74 3A 33 F6 3B D6 74 3B 83 FA 01 74 27 83 FA 02 74 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 83 E1 FD EB 03 83 C9 02 89 48 70 EB 07 83 0D ?? ?? ?? ?? FF 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_319_10_0 {
	meta:
		name = "_sync_legacy_variables_lk"
		size = 83
		refs = "0001 ___ptlocinfo 000a ___lc_codepage 0013 ___lc_collate_cp 001f ___lc_clike 002b ___lc_time_curr 0037 ___lconv 0043 __pctype 004e ___mb_cur_max"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 48 04 89 0D ?? ?? ?? ?? 8B 48 08 89 0D ?? ?? ?? ?? 8B 88 A8 00 00 00 89 0D ?? ?? ?? ?? 8B 88 D4 00 00 00 89 0D ?? ?? ?? ?? 8B 88 BC 00 00 00 89 0D ?? ?? ?? ?? 8B 88 C8 00 00 00 89 0D ?? ?? ?? ?? 8B 80 AC 00 00 00 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_319_11_0 {
	meta:
		name = "__free_locale"
		size = 194
		refs = "0003 __sehtable$__free_locale 0008 __SEH_prolog4 001a __lock 002d __imp__InterlockedDecrement@4 0039 ___initialmbcinfo 0041 _free 0069 ___removelocaleref 007a ___initiallocinfo 0082 ___freetlocinfo 00a5 __SEH_epilog4 00b0 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 8D 00 00 00 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 46 04 85 C0 74 1C 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 8B 46 04 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 5B 00 00 00 83 3E 00 74 3C 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 FF 36 E8 ?? ?? ?? ?? 59 8B 06 85 C0 74 13 83 38 00 75 0E 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 26 00 00 00 B8 0D F0 AD BA 89 06 89 46 04 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_319_13_0 {
	meta:
		name = "__get_current_locale"
		size = 175
		refs = "0003 __sehtable$__get_current_locale 0008 __SEH_prolog4 000d __getptd 0018 __calloc_crt 0028 __errno 0037 ___updatetlocinfo 003c ___updatetmbcinfo 004e __lock 005a ___addlocaleref 007f __imp__InterlockedIncrement@4 0092 __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 6A 01 6A 08 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 5B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 6C 89 06 8B 47 68 89 46 04 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 36 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 2F 00 00 00 6A 0D E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 FF 76 04 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 17 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 8B 75 E4 6A 0D E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_319_16_0 {
	meta:
		name = "__strcats"
		size = 64
		refs = "0020 _strcat_s 0031 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 57 8B 7D 10 33 DB 3B FB 7E 2C 56 8D 75 10 83 C6 04 FF 36 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 4F 75 D9 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_319_17_0 {
	meta:
		name = "___lc_strtolc"
		size = 297
		refs = "0015 _memset 0044 _strncpy_s 0055 __invoke_watson 0065 ??_C@_03EGDHDPFD@_?4?0?$AA@ 006e _strcspn"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 7D 08 68 90 00 00 00 33 DB 53 57 E8 ?? ?? ?? ?? 8B 75 0C 8A 06 83 C4 0C 84 C0 75 07 33 C0 E9 F8 00 00 00 3C 2E 75 34 8D 46 01 38 18 74 2D 6A 0F 50 8D 87 80 00 00 00 6A 10 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 88 9F 8F 00 00 00 EB C1 68 ?? ?? ?? ?? 56 89 5D 0C E8 ?? ?? ?? ?? 3B C3 E9 A0 00 00 00 83 7D 0C 00 8D 3C 30 8A 1F 75 1B 83 F8 40 0F 83 94 00 00 00 80 FB 2E 0F 84 8B 00 00 00 50 56 6A 40 FF 75 08 EB 3B 83 7D 0C 01 75 16 83 F8 40 73 77 80 FB 5F 74 72 50 8B 45 08 56 6A 40 83 C0 40 EB 1E 83 7D 0C 02 75 60 83 F8 10 73 5B 84 DB 74 05 80 FB 2C 75 52 50 8B 45 08 56 6A 10 83 E8 80 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 FB 2C 0F 84 27 FF FF FF 84 DB 0F 84 1F FF FF FF FF 45 0C 8D 77 01 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 58 FF FF FF 83 C8 FF 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_319_18_0 {
	meta:
		name = "___lc_lctostr"
		size = 109
		refs = "0012 _strcpy_s 0025 __invoke_watson 0035 ??_C@_01IDAFKMJL@_?$AA@ 0042 __strcats 0057 ??_C@_01LFCBOECM@?4?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 10 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 DB 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 46 40 38 18 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 8D 86 80 00 00 00 38 18 5E 5B 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_319_19_0 {
	meta:
		name = "__setlocale_get_all"
		size = 381
		refs = "0015 __malloc_crt 003d ??_C@_01NEMOKFLO@?$DN?$AA@ 0043 ___lc_category 0050 __strcats 0065 ??_C@_01ICJEACDI@?$DL?$AA@ 0070 _strcat_s 0083 __invoke_watson 0093 _strcmp 00e7 __imp__InterlockedDecrement@4 00fa _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 33 DB 43 68 55 03 00 00 89 5D F0 E8 ?? ?? ?? ?? 59 89 45 EC 85 C0 0F 84 55 01 00 00 57 8D 78 04 C6 07 00 89 18 89 5D F8 8D 5E 10 8D 43 48 FF 30 89 45 F4 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A 03 68 51 03 00 00 57 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 18 89 45 F4 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 51 03 00 00 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 73 58 8B 45 F4 FF 30 E8 ?? ?? ?? ?? 59 59 85 C0 74 04 83 65 F0 00 FF 45 F8 8B 45 F8 83 45 FC 0C C1 E0 04 8D 1C 30 8D 43 48 FF 30 89 45 F4 8B 45 FC 68 ?? ?? ?? ?? FF 30 6A 03 68 51 03 00 00 57 E8 ?? ?? ?? ?? 83 C4 18 81 7D FC ?? ?? ?? ?? 7C 88 83 7D F0 00 75 49 8B 46 50 8B 1D ?? ?? ?? ?? 85 C0 74 10 50 FF D3 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 85 C0 74 10 50 FF D3 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 45 EC 83 66 54 00 83 66 4C 00 89 46 50 89 7E 48 8B C7 EB 4E FF 75 EC E8 ?? ?? ?? ?? 8B 46 50 8B 3D ?? ?? ?? ?? 33 DB 59 3B C3 74 10 50 FF D7 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 3B C3 74 10 50 FF D7 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 46 68 89 5E 54 89 5E 4C 89 5E 50 89 5E 48 5F 5B C9 C3 }
	condition:
		$1
}

rule file_319_20_0 {
	meta:
		name = "__expandlocale"
		size = 561
		refs = "000c ___security_cookie 0037 __getptd 008b ??_C@_01GFHCPBMG@C?$AA@ 0099 _strcpy_s 00ac __invoke_watson 00dd _strlen 00f9 _strcmp 012d ___lc_strtolc 0145 ___get_qualified_locale 016f ___lc_lctostr 018c ??_C@_00CNPNBAHC@?$AA@ 019b _strncpy_s 01cb _memcpy 022b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC B4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 56 8B 75 08 57 8B 7D 14 89 85 64 FF FF FF 8B 45 18 89 BD 5C FF FF FF 89 85 60 FF FF FF E8 ?? ?? ?? ?? 05 9C 00 00 00 8D 48 28 89 8D 54 FF FF FF 8D 48 2C 8D 58 20 05 AF 00 00 00 89 8D 58 FF FF FF 89 85 68 FF FF FF 85 F6 0F 84 B8 01 00 00 83 BD 64 FF FF FF 00 0F 84 AB 01 00 00 83 7D 10 00 0F 84 A1 01 00 00 80 3E 43 75 57 80 7E 01 00 75 51 68 ?? ?? ?? ?? FF 75 10 FF B5 64 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 33 F6 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 3B FE 74 0D 33 C0 66 89 07 66 89 47 02 66 89 47 04 8B 85 60 FF FF FF 3B C6 74 02 89 30 8B 85 64 FF FF FF E9 47 01 00 00 56 E8 ?? ?? ?? ?? BF 83 00 00 00 59 89 85 50 FF FF FF 3B C7 73 2C 56 FF B5 68 FF FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B0 00 00 00 56 FF B5 58 FF FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 9A 00 00 00 83 A5 4C FF FF FF 00 8D 85 6C FF FF FF 56 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 E5 00 00 00 8D 85 6C FF FF FF 50 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 CC 00 00 00 0F B7 43 04 8B 8D 54 FF FF FF 89 01 8D 85 6C FF FF FF 50 57 FF B5 68 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 80 3E 00 74 0A 8B 85 50 FF FF FF 3B C7 72 0B 8B 85 4C FF FF FF BE ?? ?? ?? ?? 40 50 56 57 FF B5 58 FF FF FF E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 11 33 F6 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB 02 33 F6 39 B5 5C FF FF FF 74 11 6A 06 53 FF B5 5C FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 39 B5 60 FF FF FF 74 16 6A 04 FF B5 54 FF FF FF FF B5 60 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 68 FF FF FF FF 75 10 FF B5 64 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 85 68 FF FF FF EB 02 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_319_21_0 {
	meta:
		name = "__setlocale_set_cat"
		size = 770
		refs = "000c ___security_cookie 001a __getptd 0045 __expandlocale 006b _strcmp 0081 _strlen 0090 __malloc_crt 00d8 _memcpy 0101 _strcpy_s 0114 __invoke_watson 01ef __first_127char 01f8 ___crtGetStringTypeA 021f __ctype_loc_style 022b _memcmp 0266 ___lc_category 027f _free 02a6 ___clocalestr 02bc __imp__InterlockedDecrement@4 02fc @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C4 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 57 8B D9 E8 ?? ?? ?? ?? FF 75 08 8B F8 8D 85 68 FE FF FF 50 8D 85 50 FE FF FF 50 68 83 00 00 00 8D 85 78 FF FF FF 50 53 81 C7 D0 01 00 00 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 9D 02 00 00 8B 45 08 C1 E0 04 8D 1C 30 FF 73 48 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 78 02 00 00 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 83 C0 05 50 89 85 74 FE FF FF E8 ?? ?? ?? ?? 59 59 89 85 70 FE FF FF 85 C0 74 B0 8B 43 48 8B 4D 08 89 85 5C FE FF FF 8D 44 8E 0C 83 C1 06 6B C9 06 89 85 6C FE FF FF 8B 00 89 85 58 FE FF FF 8D 04 31 6A 06 50 89 85 64 FE FF FF 8D 85 3C FE FF FF 50 E8 ?? ?? ?? ?? 8B 46 04 8D 8D 78 FF FF FF 51 8B 8D 74 FE FF FF 89 85 4C FE FF FF 8B 85 70 FE FF FF 83 C1 FC 83 C0 04 51 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 85 70 FE FF FF 8B 8D 6C FE FF FF 83 C0 04 89 43 48 0F B7 85 50 FE FF FF 89 01 6A 06 8D 85 50 FE FF FF 50 FF B5 64 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 02 0F 85 F7 00 00 00 8B 85 68 FE FF FF 83 A5 74 FE FF FF 00 89 46 04 8B 47 24 8B 4F 20 89 85 64 FE FF FF 8B C7 8B 56 04 3B 10 74 36 8B 10 FF 85 74 FE FF FF 89 08 8B 8D 64 FE FF FF 89 95 44 FE FF FF 8B 50 04 89 48 04 8B 8D 44 FE FF FF 83 C0 08 83 BD 74 FE FF FF 05 89 95 64 FE FF FF 7C C5 EB 22 8B 85 74 FE FF FF 85 C0 74 18 8D 04 C7 8B 10 89 17 8B 50 04 89 57 04 89 08 8B 8D 64 FE FF FF 89 48 04 83 BD 74 FE FF FF 05 75 68 6A 01 FF 76 14 8D 85 78 FE FF FF FF 76 04 50 6A 7F 68 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 39 33 C0 B9 FF 01 00 00 66 21 8C 45 78 FE FF FF 40 83 F8 7F 72 ED 68 FE 00 00 00 FF 35 ?? ?? ?? ?? 8D 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 40 89 47 04 EB 04 83 67 04 00 8B 46 04 89 07 8B 47 04 89 86 A8 00 00 00 83 7D 08 01 75 09 8B 85 68 FE FF FF 89 46 08 8B 45 08 6B C0 0C 56 FF 90 ?? ?? ?? ?? 59 85 C0 74 31 8B 85 5C FE FF FF FF B5 70 FE FF FF 89 43 48 E8 ?? ?? ?? ?? 8B 85 58 FE FF FF 59 8B 8D 6C FE FF FF 89 01 8B 85 4C FE FF FF 89 46 04 E9 B0 FD FF FF 81 BD 5C FE FF FF ?? ?? ?? ?? 74 2D 8B 45 08 83 C0 05 C1 E0 04 8D 3C 30 FF 37 FF 15 ?? ?? ?? ?? 85 C0 75 15 FF 37 E8 ?? ?? ?? ?? FF 73 54 E8 ?? ?? ?? ?? 83 63 4C 00 59 59 8B 4D 08 8B 85 70 FE FF FF 83 C1 05 C1 E1 04 C7 00 01 00 00 00 89 04 31 8B 43 48 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_319_22_0 {
	meta:
		name = "__setlocale_nolock"
		size = 539
		refs = "000c ___security_cookie 002f __setlocale_set_cat 007d ??_C@_02BALPLPBG@?$DN?$DL?$AA@ 0083 _strpbrk 00b5 ___lc_category 00c6 _strncmp 00d4 _strlen 00f4 ??_C@_01ICJEACDI@?$DL?$AA@ 00fa _strcspn 0129 _strncpy_s 013a __invoke_watson 01a7 __expandlocale 01c3 _strcmp 0208 __setlocale_get_all 0215 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 98 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 33 DB 8B F2 57 89 B5 68 FF FF FF 3B C3 74 1C 3B CB 74 0C 50 E8 ?? ?? ?? ?? 59 E9 D3 01 00 00 C1 E0 04 8B 44 30 48 E9 C7 01 00 00 C7 85 70 FF FF FF 01 00 00 00 89 9D 74 FF FF FF 3B CB 0F 84 AA 01 00 00 80 39 4C 0F 85 30 01 00 00 80 79 01 43 0F 85 26 01 00 00 80 79 02 5F 0F 85 1C 01 00 00 8B F9 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 0F 84 FF 00 00 00 2B C7 89 85 70 FF FF FF 0F 84 F1 00 00 00 80 3B 3B 0F 84 E8 00 00 00 C7 85 6C FF FF FF 01 00 00 00 BE ?? ?? ?? ?? EB 06 8B 85 70 FF FF FF 50 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 10 FF 36 E8 ?? ?? ?? ?? 59 39 85 70 FF FF FF 74 11 FF 85 6C FF FF FF 83 C6 0C 81 FE ?? ?? ?? ?? 7E C9 43 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B F8 33 F6 59 59 3B FE 75 09 80 3B 3B 0F 85 81 00 00 00 83 BD 6C FF FF FF 05 7F 51 57 53 8D 85 78 FF FF FF 68 83 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 FF B5 6C FF FF FF 8B B5 68 FF FF FF 8D 8D 78 FF FF FF C6 84 3D 78 FF FF FF 00 E8 ?? ?? ?? ?? 59 85 C0 74 06 FF 85 74 FF FF FF 03 FB 80 3F 00 74 0A 47 80 3F 00 0F 85 00 FF FF FF 33 C0 39 85 74 FF FF FF 0F 84 82 00 00 00 8B B5 68 FF FF FF EB 75 33 C0 EB 76 53 53 53 68 83 00 00 00 8D 85 78 FF FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 5A 8D 7E 48 85 DB 74 33 FF 37 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 19 53 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 59 85 C0 75 08 21 85 70 FF FF FF EB 06 FF 85 74 FF FF FF 43 83 C7 10 83 FB 05 7E C0 33 C0 39 85 70 FF FF FF 75 08 39 85 74 FF FF FF 74 05 E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_319_23_0 {
	meta:
		name = "__create_locale"
		size = 245
		refs = "001a __calloc_crt 0027 __errno 004c _free 007a ___initiallocinfo 007f __copytlocinfo_nolock 008c __setlocale_nolock 0098 ___removelocaleref 009f ___freetlocinfo 00b7 __setmbcp_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 05 56 57 77 24 83 7D 0C 00 74 1E 33 FF 47 57 6A 08 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 11 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 5F 5E 5D C3 57 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 89 06 85 C0 75 09 56 E8 ?? ?? ?? ?? 59 EB D3 57 68 20 02 00 00 E8 ?? ?? ?? ?? 59 59 89 46 04 85 C0 75 10 FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 EB D9 8B 06 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 8B 4D 0C 8B 16 E8 ?? ?? ?? ?? 59 85 C0 75 19 FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C EB 32 FF 76 04 8B 06 FF 70 04 E8 ?? ?? ?? ?? 59 59 85 C0 74 23 FF 76 04 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 10 33 F6 EB 0A 8B 46 04 89 38 8B 46 04 89 38 8B C6 E9 3E FF FF FF }
	condition:
		$1
}

rule file_319_25_0 {
	meta:
		name = "_setlocale"
		size = 368
		refs = "0003 __sehtable$_setlocale 0008 __SEH_prolog4 0018 __errno 0028 __invalid_parameter 0037 __getptd 0041 ___updatetlocinfo 0054 __calloc_crt 006a __lock 007c __copytlocinfo_nolock 0091 __setlocale_nolock 00a7 ___clocalestr 00af _strcmp 00bb ___locale_changed 00d8 __updatetlocinfoEx_nolock 00de ___removelocaleref 00eb ___globallocalestatus 00f5 ___ptlocinfo 010a ___lc_handle 010f _memcpy 0117 _sync_legacy_variables_lk 0131 __unlock 014d ___freetlocinfo 0163 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 83 7D 08 05 76 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2C 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 E8 ?? ?? ?? ?? 83 4E 70 10 89 5D FC 6A 01 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 8B F8 89 7D DC 3B FB 0F 84 EC 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 4E 6C 8B C7 E8 ?? ?? ?? ?? 89 5D FC E8 A6 00 00 00 FF 75 08 8B 4D 0C 8B D7 E8 ?? ?? ?? ?? 59 89 45 E0 3B C3 0F 84 A4 00 00 00 39 5D 0C 74 1D 68 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 74 0A C7 05 ?? ?? ?? ?? 01 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 02 00 00 00 8D 5E 6C 8B C3 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 F6 46 70 02 75 32 F6 05 ?? ?? ?? ?? 01 75 29 8B 3B B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 18 A1 ?? ?? ?? ?? 83 C0 0C 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 65 FC 00 E8 16 00 00 00 EB 2D 8B 7D DC 8B 75 E4 33 DB 6A 0C E8 ?? ?? ?? ?? 59 C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 EB 0E 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 E4 83 66 70 EF C3 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__futime32"
		size = 432
		refs = "0011 __errno 0029 __nhandle 0037 ___pioinfo 0059 __invalid_parameter 0075 __time32 008c __localtime32_s 00e2 __imp__SystemTimeToFileTime@8 0106 __imp__LocalFileTimeToFileTime@8 0189 __get_osfhandle 0191 __imp__SetFileTime@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 54 83 F8 FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF C9 C3 57 33 FF 3B C7 7C 21 3B 05 ?? ?? ?? ?? 73 19 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 F6 44 01 04 01 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 45 01 00 00 53 8B 5D 0C 3B DF 75 13 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 59 89 45 F8 8D 5D F8 8D 43 04 50 8D 45 AC 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 03 01 00 00 8B 45 C0 05 6C 07 00 00 66 89 45 D0 8B 45 BC 40 66 89 45 D2 66 8B 45 B8 66 89 45 D6 66 8B 45 B4 66 89 45 D8 66 8B 45 B0 66 89 45 DA 66 8B 45 AC 66 89 45 DC 33 C0 56 8B 35 ?? ?? ?? ?? 66 89 45 DE 8D 45 F0 50 8D 45 D0 50 FF D6 85 C0 0F 84 A1 00 00 00 8D 45 E8 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8B 00 00 00 8D 45 AC 53 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 7B 8B 45 C0 05 6C 07 00 00 66 89 45 D0 8B 45 BC 40 66 89 45 D2 66 8B 45 B8 66 89 45 D6 66 8B 45 B4 66 89 45 D8 66 8B 45 B0 66 89 45 DA 66 8B 45 AC 66 89 45 DC 33 C0 66 89 45 DE 8D 45 F0 50 8D 45 D0 50 FF D6 85 C0 74 33 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8D 45 E8 50 8D 45 E0 50 57 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "___init_ctype"
		size = 930
		refs = "0009 ___security_cookie 0050 ___getlocaleinfo 0062 __malloc_crt 0072 __calloc_crt 00eb __imp__GetCPInfo@8 0157 ___crtGetStringTypeA 018a ___crtLCMapStringA 0260 _memcpy 0295 __imp__InterlockedDecrement@4 02aa _free 036f ___newctype 0379 ___newclmap 0383 ___newcumap 039c @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 56 8B 75 08 57 89 5D D4 89 5D E4 89 5D E0 89 5D D8 89 5D DC 89 75 B4 89 5D B8 39 5E 14 0F 84 16 03 00 00 8D 46 04 39 18 75 20 50 0F B7 46 30 68 04 10 00 00 50 8D 45 B4 53 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 C7 02 00 00 6A 04 E8 ?? ?? ?? ?? 6A 02 BF 80 01 00 00 57 89 45 D4 E8 ?? ?? ?? ?? 6A 01 57 89 45 E4 E8 ?? ?? ?? ?? 6A 01 57 89 45 E0 E8 ?? ?? ?? ?? 6A 01 68 01 01 00 00 89 45 D8 E8 ?? ?? ?? ?? 83 C4 24 89 45 DC 39 5D D4 0F 84 7C 02 00 00 39 5D E4 0F 84 73 02 00 00 3B C3 0F 84 6B 02 00 00 39 5D E0 0F 84 62 02 00 00 39 5D D8 0F 84 59 02 00 00 8B 45 D4 89 18 33 C0 8B 4D DC 88 04 08 40 3D 00 01 00 00 7C F2 8D 45 E8 50 FF 76 04 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2F 02 00 00 83 7D E8 05 0F 87 25 02 00 00 0F B7 45 E8 83 F8 01 89 45 D0 7E 2D 38 5D EE 74 28 8D 45 EF 8A 08 3A CB 74 1F 0F B6 78 FF 0F B6 C9 EB 0B 8B 4D DC C6 04 0F 20 0F B6 08 47 3B F9 7E F1 40 40 38 58 FF 75 DB 8B 45 E4 53 53 FF 76 04 05 00 01 00 00 50 68 00 01 00 00 FF 75 DC 89 45 C0 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F 84 C0 01 00 00 8B 4D E0 8B 45 DC 53 FF 76 04 BF FF 00 00 00 57 81 C1 81 00 00 00 51 57 40 50 68 00 01 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 8D 01 00 00 8B 45 D8 53 FF 76 04 05 81 00 00 00 57 50 8B 45 DC 57 40 50 68 00 02 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 60 01 00 00 8B 45 E4 8B 7D E0 8D 88 FE 00 00 00 33 D2 83 7D D0 01 66 89 11 8B 55 D8 89 4D C4 8D 8F 80 00 00 00 88 5F 7F 88 5A 7F 88 19 89 4D BC 8D 8A 80 00 00 00 89 4D C8 88 19 7E 53 38 5D EE 74 4E 8D 4D EF 89 4D E4 8A 11 3A D3 74 42 0F B6 49 FF 0F B6 D2 3B CA 89 4D E0 7F 27 8D 8C 48 00 01 00 00 EB 03 8B 4D CC FF 45 E0 BA 00 80 00 00 66 89 11 41 41 89 4D CC 8B 4D E4 0F B6 09 39 4D E0 7E E2 8B 4D E4 41 41 89 4D E4 38 59 FF 75 B8 68 FE 00 00 00 8D 88 00 02 00 00 51 50 E8 ?? ?? ?? ?? 6A 7F 8D 87 00 01 00 00 50 57 E8 ?? ?? ?? ?? 8B 45 D8 6A 7F 8D 88 00 01 00 00 51 50 E8 ?? ?? ?? ?? 8B 86 C0 00 00 00 83 C4 24 3B C3 74 4B 50 FF 15 ?? ?? ?? ?? 85 C0 75 40 8B 86 C4 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 CC 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 D0 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 45 D4 C7 00 01 00 00 00 89 86 C0 00 00 00 8B 45 C0 89 86 C8 00 00 00 8B 45 C4 89 86 C4 00 00 00 8B 45 BC 89 86 CC 00 00 00 8B 45 C8 89 86 D0 00 00 00 8B 45 D0 89 86 AC 00 00 00 FF 75 DC E8 ?? ?? ?? ?? 59 8B C3 EB 6D FF 75 D4 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 D8 E8 ?? ?? ?? ?? 33 DB 83 C4 10 43 EB CB 8D BE C0 00 00 00 8B 07 3B C3 74 07 50 FF 15 ?? ?? ?? ?? 89 1F 89 9E C4 00 00 00 C7 86 C8 00 00 00 ?? ?? ?? ?? C7 86 CC 00 00 00 ?? ?? ?? ?? C7 86 D0 00 00 00 ?? ?? ?? ?? C7 86 AC 00 00 00 01 00 00 00 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "____mb_cur_max_func"
		size = 41
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 80 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_321_2_0 {
	meta:
		name = "____mb_cur_max_l_func"
		size = 28
		refs = "000e ____mb_cur_max_func"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 06 5D E9 ?? ?? ?? ?? 8B 00 8B 80 AC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_321_3_0 {
	meta:
		name = "____lc_codepage_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 04 C3 }
	condition:
		$1
}

rule file_321_4_0 {
	meta:
		name = "____lc_collate_cp_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 08 C3 }
	condition:
		$1
}

rule file_321_5_0 {
	meta:
		name = "____lc_handle_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 83 C0 0C C3 }
	condition:
		$1
}

rule file_322_3_0 {
	meta:
		name = "__mbsnbset_s_l"
		size = 558
		refs = "0034 __errno 0043 __invalid_parameter 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006f __strnset_s 00ac __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 56 57 89 5D F0 89 5D F4 39 5D 14 75 0F 39 5D 08 75 0F 39 5D 0C 75 11 E9 00 02 00 00 39 5D 08 74 07 8B 7D 0C 3B FB 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 D8 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 27 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 38 5D EC 0F 84 AA 01 00 00 8B 4D E8 83 61 70 FD E9 9E 01 00 00 8B 45 10 8B 75 08 C1 E8 08 89 7D F8 88 45 FF 3A C3 74 30 38 5D 10 74 43 8D 4D E0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 30 F6 45 14 01 74 0A FF 4D 14 C7 45 F0 01 00 00 00 D1 6D 14 E9 8E 00 00 00 8D 45 E0 50 0F B6 45 10 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B9 00 00 00 88 1E E8 ?? ?? ?? ?? 8B C8 6A 2A 58 89 01 EB 80 39 5D 14 0F 86 A7 00 00 00 FF 4D F8 0F 84 9B 00 00 00 8D 7E 01 38 1F 74 53 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 FF 4D F8 8A 45 FF 88 06 8B F7 74 6C 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 8A 45 10 88 06 46 FF 4D 14 38 1E 75 96 EB 41 FF 45 F8 88 1E C7 45 F0 01 00 00 00 EB 33 39 5D 14 76 31 FF 4D F8 74 29 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 8A 45 10 88 06 46 FF 4D 14 38 1E 75 CD 39 5D 14 75 34 39 5D F4 74 2B 38 1E 74 2B FF 4D F8 74 22 8D 46 01 C7 45 F0 01 00 00 00 38 18 75 07 FF 45 F8 88 1E EB 0D C6 06 20 8B F0 EB 06 FF 4D F8 74 05 46 38 1E 75 F6 39 5D F8 75 31 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 0F 84 44 FE FF FF 8B 45 E8 83 60 70 FD E9 38 FE FF FF 39 5D F0 0F 85 CD FE FF FF 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_323_3_0 {
	meta:
		name = "_write_char"
		size = 33
		refs = "0009 __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 B9 FF FF 00 00 66 3B C1 75 05 83 0E FF 5D C3 FF 06 5D C3 }
	condition:
		$1
}

rule file_323_4_0 {
	meta:
		name = "_write_multi_char"
		size = 36
		refs = "0011 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 11 FF 75 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 59 74 06 83 7D 0C 00 7F E9 5E 5D C3 }
	condition:
		$1
}

rule file_323_5_0 {
	meta:
		name = "_write_string"
		size = 61
		refs = "0015 _write_char 0022 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F0 8B F9 EB 26 0F B7 07 FF 4D 08 50 E8 ?? ?? ?? ?? 47 47 83 3E FF 59 75 12 E8 ?? ?? ?? ?? 83 38 2A 75 0E 6A 3F E8 ?? ?? ?? ?? 59 83 7D 08 00 7F D4 5F 5E 5D C3 }
	condition:
		$1
}

rule file_323_6_0 {
	meta:
		name = "_get_int_arg"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_323_7_0 {
	meta:
		name = "_get_int64_arg"
		size = 21
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_323_8_0 {
	meta:
		name = "__vcwprintf_l"
		size = 2900
		refs = "000c ___security_cookie 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 __errno 0073 __invalid_parameter 00e2 ___lookuptable 010a $LN243 0340 _write_char 042c ___nullstring 045d __isleadbyte_l 04f1 __mbtowc_l 0578 _strlen 05e1 __get_printf_count_output 0685 __malloc_crt 06f5 __cfltcvt_tab 06fa __decode_pointer 08bf __aulldvrm 091d ___wnullstring 09b3 _write_multi_char 09cc _write_string 0ac0 _free 0b2c @__security_check_cookie@4 0b34 $NORMAL_STATE$29507 0b38 $LN131 0b3c $LN130 0b40 $LN122 0b44 $LN118 0b48 $LN117 0b4c $LN113 0b50 $LN97"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 10 56 8B 75 08 57 FF 75 0C 33 FF 8D 8D AC FB FF FF 89 9D E8 FB FF FF 89 BD C0 FB FF FF 89 BD F8 FB FF FF 89 BD D4 FB FF FF 89 BD F4 FB FF FF 89 BD DC FB FF FF 89 BD BC FB FF FF 89 BD D8 FB FF FF E8 ?? ?? ?? ?? 3B F7 75 33 E8 ?? ?? ?? ?? 57 57 57 57 C7 00 16 00 00 00 57 E8 ?? ?? ?? ?? 83 C4 14 80 BD B8 FB FF FF 00 74 0A 8B 85 B4 FB FF FF 83 60 70 FD 83 C8 FF E9 8E 0A 00 00 0F B7 0E 33 D2 89 BD E0 FB FF FF 89 BD F0 FB FF FF 89 BD C8 FB FF FF 89 8D EC FB FF FF 66 3B CF 0F 84 4F 0A 00 00 6A 02 5F 03 F7 83 BD E0 FB FF FF 00 89 B5 C4 FB FF FF 0F 8C 37 0A 00 00 8D 41 E0 66 83 F8 58 77 0F 0F B7 C1 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C2 ?? ?? ?? ?? C1 F8 04 89 85 A4 FB FF FF 83 F8 07 0F 87 C5 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D F4 FB FF FF FF 89 85 A0 FB FF FF 89 85 BC FB FF FF 89 85 D4 FB FF FF 89 85 DC FB FF FF 89 85 F8 FB FF FF 89 85 D8 FB FF FF E9 8C 09 00 00 0F B7 C1 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 2B C7 74 15 83 E8 03 0F 85 6D 09 00 00 83 8D F8 FB FF FF 08 E9 61 09 00 00 83 8D F8 FB FF FF 04 E9 55 09 00 00 83 8D F8 FB FF FF 01 E9 49 09 00 00 81 8D F8 FB FF FF 80 00 00 00 E9 3A 09 00 00 09 BD F8 FB FF FF E9 2F 09 00 00 66 83 F9 2A 75 2E 83 C3 04 89 9D E8 FB FF FF 8B 5B FC 89 9D D4 FB FF FF 85 DB 0F 8D 0F 09 00 00 83 8D F8 FB FF FF 04 F7 DB 89 9D D4 FB FF FF E9 FB 08 00 00 8B 85 D4 FB FF FF 6B C0 0A 0F B7 C9 8D 44 08 D0 89 85 D4 FB FF FF E9 E0 08 00 00 83 A5 F4 FB FF FF 00 E9 D4 08 00 00 66 83 F9 2A 75 26 83 C3 04 89 9D E8 FB FF FF 8B 5B FC 89 9D F4 FB FF FF 85 DB 0F 8D B4 08 00 00 83 8D F4 FB FF FF FF E9 A8 08 00 00 8B 85 F4 FB FF FF 6B C0 0A 0F B7 C9 8D 44 08 D0 89 85 F4 FB FF FF E9 8D 08 00 00 0F B7 C1 83 F8 49 74 57 83 F8 68 74 46 83 F8 6C 74 18 83 F8 77 0F 85 72 08 00 00 81 8D F8 FB FF FF 00 08 00 00 E9 63 08 00 00 66 83 3E 6C 75 17 03 F7 81 8D F8 FB FF FF 00 10 00 00 89 B5 C4 FB FF FF E9 46 08 00 00 83 8D F8 FB FF FF 10 E9 3A 08 00 00 83 8D F8 FB FF FF 20 E9 2E 08 00 00 0F B7 06 66 83 F8 36 75 1F 66 83 7E 02 34 75 18 83 C6 04 81 8D F8 FB FF FF 00 80 00 00 89 B5 C4 FB FF FF E9 06 08 00 00 66 83 F8 33 75 1F 66 83 7E 02 32 75 18 83 C6 04 81 A5 F8 FB FF FF FF 7F FF FF 89 B5 C4 FB FF FF E9 E1 07 00 00 66 83 F8 64 0F 84 D7 07 00 00 66 83 F8 69 0F 84 CD 07 00 00 66 83 F8 6F 0F 84 C3 07 00 00 66 83 F8 75 0F 84 B9 07 00 00 66 83 F8 78 0F 84 AF 07 00 00 66 83 F8 58 0F 84 A5 07 00 00 83 A5 A4 FB FF FF 00 51 8D B5 E0 FB FF FF C7 85 D8 FB FF FF 01 00 00 00 E8 ?? ?? ?? ?? E9 82 07 00 00 0F B7 C1 83 F8 64 0F 8F 2D 02 00 00 0F 84 BE 02 00 00 83 F8 53 0F 8F 18 01 00 00 74 7E 83 E8 41 74 10 2B C7 74 59 2B C7 74 08 2B C7 0F 85 D1 05 00 00 83 C1 20 C7 85 A0 FB FF FF 01 00 00 00 89 8D EC FB FF FF 83 8D F8 FB FF FF 40 83 BD F4 FB FF FF 00 8D BD FC FB FF FF B8 00 02 00 00 89 BD E4 FB FF FF 89 85 F0 FB FF FF 0F 8D 90 02 00 00 C7 85 F4 FB FF FF 06 00 00 00 E9 EC 02 00 00 F7 85 F8 FB FF FF 30 08 00 00 0F 85 C6 00 00 00 83 8D F8 FB FF FF 20 E9 BA 00 00 00 F7 85 F8 FB FF FF 30 08 00 00 75 07 83 8D F8 FB FF FF 20 8B BD F4 FB FF FF 83 FF FF 75 05 BF FF FF FF 7F 83 C3 04 F6 85 F8 FB FF FF 20 89 9D E8 FB FF FF 8B 5B FC 89 9D E4 FB FF FF 0F 84 F1 04 00 00 85 DB 75 0C 8B 1D ?? ?? ?? ?? 89 9D E4 FB FF FF 83 A5 F0 FB FF FF 00 8B F3 85 FF 0F 8E 05 05 00 00 8A 06 84 C0 0F 84 FB 04 00 00 8D 8D AC FB FF FF 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 01 46 46 FF 85 F0 FB FF FF 39 BD F0 FB FF FF 7C D0 E9 D0 04 00 00 83 E8 58 0F 84 FA 02 00 00 2B C7 0F 84 95 00 00 00 83 E8 07 0F 84 F8 FE FF FF 2B C7 0F 85 AE 04 00 00 0F B7 03 83 C3 04 33 F6 46 F6 85 F8 FB FF FF 20 89 B5 D8 FB FF FF 89 9D E8 FB FF FF 89 85 A8 FB FF FF 74 42 88 85 CC FB FF FF 8D 85 AC FB FF FF 50 8B 85 AC FB FF FF C6 85 CD FB FF FF 00 FF B0 AC 00 00 00 8D 85 CC FB FF FF 50 8D 85 FC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 0F 89 B5 BC FB FF FF EB 07 66 89 85 FC FB FF FF 8D 85 FC FB FF FF 89 85 E4 FB FF FF 89 B5 F0 FB FF FF E9 2A 04 00 00 8B 03 83 C3 04 89 9D E8 FB FF FF 85 C0 74 3A 8B 48 04 85 C9 74 33 F7 85 F8 FB FF FF 00 08 00 00 0F BF 00 89 8D E4 FB FF FF 74 12 99 2B C2 C7 85 D8 FB FF FF 01 00 00 00 E9 E5 03 00 00 83 A5 D8 FB FF FF 00 E9 DB 03 00 00 A1 ?? ?? ?? ?? 89 85 E4 FB FF FF 50 E8 ?? ?? ?? ?? 59 E9 C4 03 00 00 83 F8 70 0F 8F 00 02 00 00 0F 84 E4 01 00 00 83 F8 65 0F 8C B2 03 00 00 83 F8 67 0F 8E EB FD FF FF 83 F8 69 74 71 83 F8 6E 74 28 83 F8 6F 0F 85 96 03 00 00 F6 85 F8 FB FF FF 80 C7 85 EC FB FF FF 08 00 00 00 74 61 81 8D F8 FB FF FF 00 02 00 00 EB 55 8B 33 83 C3 04 89 9D E8 FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 06 05 00 00 F6 85 F8 FB FF FF 20 74 0C 66 8B 85 E0 FB FF FF 66 89 06 EB 08 8B 85 E0 FB FF FF 89 06 C7 85 BC FB FF FF 01 00 00 00 E9 97 04 00 00 83 8D F8 FB FF FF 40 C7 85 EC FB FF FF 0A 00 00 00 8B 8D F8 FB FF FF F7 C1 00 80 00 00 0F 84 AF 01 00 00 8B 03 8B 53 04 83 C3 08 E9 DB 01 00 00 75 12 66 83 F9 67 75 63 C7 85 F4 FB FF FF 01 00 00 00 EB 57 39 85 F4 FB FF FF 7E 06 89 85 F4 FB FF FF 81 BD F4 FB FF FF A3 00 00 00 7E 3D 8B B5 F4 FB FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 59 8B 8D EC FB FF FF 89 85 C8 FB FF FF 85 C0 74 10 8B F8 89 85 E4 FB FF FF 89 B5 F0 FB FF FF EB 0A C7 85 F4 FB FF FF A3 00 00 00 8B 03 83 C3 08 89 85 98 FB FF FF 8B 43 FC 89 85 9C FB FF FF 8D 85 AC FB FF FF 50 FF B5 A0 FB FF FF 0F BE C1 FF B5 F4 FB FF FF 89 9D E8 FB FF FF 50 FF B5 F0 FB FF FF 8D 85 98 FB FF FF 57 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B B5 F8 FB FF FF 83 C4 1C 81 E6 80 00 00 00 74 21 83 BD F4 FB FF FF 00 75 18 8D 85 AC FB FF FF 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 66 83 BD EC FB FF FF 67 75 1C 85 F6 75 18 8D 85 AC FB FF FF 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3F 2D 75 11 81 8D F8 FB FF FF 00 01 00 00 47 89 BD E4 FB FF FF 57 E9 02 FE FF FF C7 85 F4 FB FF FF 08 00 00 00 C7 85 C0 FB FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 63 FC FF FF 2B C7 0F 84 84 FE FF FF 83 E8 03 0F 85 A7 01 00 00 C7 85 C0 FB FF FF 27 00 00 00 F6 85 F8 FB FF FF 80 C7 85 EC FB FF FF 10 00 00 00 0F 84 64 FE FF FF 6A 30 58 66 89 85 D0 FB FF FF 8B 85 C0 FB FF FF 83 C0 51 66 89 85 D2 FB FF FF 89 BD DC FB FF FF E9 3F FE FF FF F7 C1 00 10 00 00 0F 85 45 FE FF FF 83 C3 04 F6 C1 20 74 18 89 9D E8 FB FF FF F6 C1 40 74 06 0F BF 43 FC EB 04 0F B7 43 FC 99 EB 13 8B 43 FC F6 C1 40 74 03 99 EB 02 33 D2 89 9D E8 FB FF FF F6 C1 40 74 1B 85 D2 7F 17 7C 04 85 C0 73 11 F7 D8 83 D2 00 F7 DA 81 8D F8 FB FF FF 00 01 00 00 F7 85 F8 FB FF FF 00 90 00 00 8B DA 8B F0 75 02 33 DB 83 BD F4 FB FF FF 00 7D 0C C7 85 F4 FB FF FF 01 00 00 00 EB 1A 83 A5 F8 FB FF FF F7 B8 00 02 00 00 39 85 F4 FB FF FF 7E 06 89 85 F4 FB FF FF 8B C6 0B C3 75 06 21 85 DC FB FF FF 8D BD FB FD FF FF 8B 85 F4 FB FF FF FF 8D F4 FB FF FF 85 C0 7F 06 8B C6 0B C3 74 2D 8B 85 EC FB FF FF 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 94 FB FF FF 8B F0 8B DA 7E 06 03 8D C0 FB FF FF 88 0F 4F EB BD 8D 85 FB FD FF FF 2B C7 47 F7 85 F8 FB FF FF 00 02 00 00 89 85 F0 FB FF FF 89 BD E4 FB FF FF 74 4B 85 C0 74 05 80 3F 30 74 42 4F 89 BD E4 FB FF FF C6 07 30 40 EB 2F 85 DB 75 0C 8B 1D ?? ?? ?? ?? 89 9D E4 FB FF FF C7 85 D8 FB FF FF 01 00 00 00 8B C3 EB 09 4F 66 83 38 00 74 06 40 40 85 FF 75 F3 2B C3 D1 F8 89 85 F0 FB FF FF 83 BD BC FB FF FF 00 0F 85 57 01 00 00 8B 85 F8 FB FF FF A8 40 74 2B A9 00 01 00 00 74 04 6A 2D EB 0E A8 01 74 04 6A 2B EB 06 A8 02 74 14 6A 20 58 66 89 85 D0 FB FF FF C7 85 DC FB FF FF 01 00 00 00 8B 9D D4 FB FF FF 2B 9D F0 FB FF FF 2B 9D DC FB FF FF F6 85 F8 FB FF FF 0C 75 10 53 6A 20 8D 85 E0 FB FF FF E8 ?? ?? ?? ?? 59 59 FF B5 DC FB FF FF 8D 85 E0 FB FF FF 8D 8D D0 FB FF FF E8 ?? ?? ?? ?? F6 85 F8 FB FF FF 08 59 74 19 F6 85 F8 FB FF FF 04 75 10 53 6A 30 8D 85 E0 FB FF FF E8 ?? ?? ?? ?? 59 59 83 BD D8 FB FF FF 00 75 7A 83 BD F0 FB FF FF 00 7E 71 8B 85 F0 FB FF FF 8B BD E4 FB FF FF 89 85 EC FB FF FF FF 8D EC FB FF FF 8D 85 AC FB FF FF 50 8B 85 AC FB FF FF FF B0 AC 00 00 00 8D 85 A8 FB FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 94 FB FF FF 85 C0 7E 23 FF B5 A8 FB FF FF 8D B5 E0 FB FF FF E8 ?? ?? ?? ?? 03 BD 94 FB FF FF 83 BD EC FB FF FF 00 59 7F AC EB 21 83 8D E0 FB FF FF FF EB 18 FF B5 F0 FB FF FF 8B 8D E4 FB FF FF 8D 85 E0 FB FF FF E8 ?? ?? ?? ?? 59 83 BD E0 FB FF FF 00 7C 19 F6 85 F8 FB FF FF 04 74 10 53 6A 20 8D 85 E0 FB FF FF E8 ?? ?? ?? ?? 59 59 83 BD C8 FB FF FF 00 74 13 FF B5 C8 FB FF FF E8 ?? ?? ?? ?? 83 A5 C8 FB FF FF 00 59 8B B5 C4 FB FF FF 0F B7 06 89 85 EC FB FF FF 66 85 C0 74 2A 8B 95 A4 FB FF FF 8B 9D E8 FB FF FF 8B C8 E9 C8 F5 FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E9 68 F5 FF FF 80 BD B8 FB FF FF 00 74 0A 8B 85 B4 FB FF FF 83 60 70 FD 8B 85 E0 FB FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_11_0 {
	meta:
		name = "__vcwprintf"
		size = 23
		refs = "000e __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_510_12_0 {
	meta:
		name = "__vcprintf"
		size = 23
		refs = "000e __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_420_13_0 {
	meta:
		name = "__vcprintf_p"
		size = 23
		refs = "000e __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_358_12_0 {
	meta:
		name = "__vcprintf_s"
		size = 23
		refs = "000e __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_872_11_0 {
	meta:
		name = "__vcwprintf_p"
		size = 23
		refs = "000e __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_633_11_0 {
	meta:
		name = "__vcwprintf_s"
		size = 23
		refs = "000e __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_324_2_0 {
	meta:
		name = "__wsearchenv_s"
		size = 935
		refs = "000c ___security_cookie 0045 __errno 0054 __invalid_parameter 00a3 __waccess_s 00c9 __wfullpath 00e8 __wdupenv_s 00fe __invoke_watson 0132 _free 014d @__security_check_cookie@4 016a _wcslen 019b __calloc_crt 01f3 __wgetpath 02c7 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 30 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 4D 0C 56 33 F6 57 8B 7D 10 89 85 D8 FD FF FF 89 8D E4 FD FF FF 89 BD DC FD FF FF 89 B5 D4 FD FF FF 89 B5 E8 FD FF FF 3B FE 75 1E E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 E3 00 00 00 39 75 14 76 DD 3B C6 75 07 33 C0 66 89 07 EB D2 66 39 30 75 1C 33 C0 66 89 07 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 E9 8A 00 00 00 53 E8 ?? ?? ?? ?? 8B 18 56 FF B5 D8 FD FF FF E8 ?? ?? ?? ?? 59 59 89 85 E0 FD FF FF E8 ?? ?? ?? ?? 89 18 39 B5 E0 FD FF FF 75 1B FF 75 14 FF B5 D8 FD FF FF 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 48 66 89 07 EB 3C FF B5 E4 FD FF FF 8D 85 D4 FD FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 60 83 F8 16 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 66 89 07 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 5B 8D 85 EC FD FF FF 39 85 E8 FD FF FF 74 0C FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 FF B5 D4 FD FF FF E8 ?? ?? ?? ?? 59 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 8B 85 D4 FD FF FF 3B C6 74 A8 FF B5 D8 FD FF FF 89 85 E4 FD FF FF E8 ?? ?? ?? ?? 8B D8 8D 85 EC FD FF FF 89 85 E8 FD FF FF B8 08 01 00 00 59 8B F8 3B D8 72 3F FF B5 E4 FD FF FF E8 ?? ?? ?? ?? 8D 7C 18 02 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FD FF FF 3B C6 75 1B 8B 8D DC FD FF FF 33 C0 66 89 01 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 4E FF FF FF E8 ?? ?? ?? ?? 8B 00 89 85 D0 FD FF FF E9 18 01 00 00 8B 85 E4 FD FF FF 8B CF 2B CB 49 51 FF B5 E8 FD FF FF 89 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FD FF FF 3B C6 75 6A 8D 85 EC FD FF FF 39 85 E8 FD FF FF 0F 85 E7 00 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 D9 00 00 00 FF B5 E0 FD FF FF E8 ?? ?? ?? ?? 8D 7C 18 02 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FD FF FF 3B C6 0F 84 60 FF FF FF 8B CF 2B CB 51 50 FF B5 E0 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FD FF FF 3B C6 0F 84 8F 00 00 00 8B 85 E8 FD FF FF 66 39 30 0F 84 80 00 00 00 50 E8 ?? ?? ?? ?? 8B 95 E8 FD FF FF 89 85 E0 FD FF FF 8D 04 42 59 0F B7 48 FE 83 F9 2F 74 18 83 F9 5C 74 13 83 F9 3A 74 0E 6A 5C 59 66 89 08 40 40 FF 85 E0 FD FF FF FF B5 D8 FD FF FF 8B C8 2B CA D1 F9 8B D7 2B D1 52 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 56 FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 1C 39 B5 E4 FD FF FF 0F 85 DC FE FF FF 8B 8D DC FD FF FF 33 C0 66 89 01 E9 FD FD FF FF 8B 85 E0 FD FF FF 03 C3 3B 45 14 72 35 8B 8D DC FD FF FF 33 C0 66 89 01 8D 85 EC FD FF FF 39 85 E8 FD FF FF 74 0C FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E9 C6 FD FF FF E8 ?? ?? ?? ?? FF B5 E8 FD FF FF 8B 8D D0 FD FF FF FF 75 14 89 08 FF B5 DC FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 85 EC FD FF FF 39 85 E8 FD FF FF 0F 84 86 FD FF FF FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 E9 75 FD FF FF }
	condition:
		$1
}

rule file_325_1_0 {
	meta:
		name = "_comexecmd"
		size = 121
		refs = "0010 __errno 0020 __invalid_parameter 0043 __cenvarg 005b __dospawn 0065 _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4A 39 75 0C 74 DE FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 08 6A 02 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 121
		refs = "0010 __errno 0020 __invalid_parameter 0043 __wcenvarg 005b __wdospawn 0065 _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4A 39 75 0C 74 DE FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 08 6A 02 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_325_2_0 {
	meta:
		name = "__execve"
		size = 539
		refs = "0017 __errno 0027 __invalid_parameter 0050 __mbsrchr 0075 __mbschr 0083 _strlen 0090 __calloc_crt 00a5 ??_C@_02CEGDFPFP@?4?2?$AA@ 00ac _strcpy_s 00bd __invoke_watson 00ca _strcat_s 010b __access_s 0123 _comexecmd 0199 _ext_strings 01fd _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 57 8B 7D 08 33 DB 89 7D FC 3B FB 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E1 01 00 00 38 1F 74 DC 8B 45 0C 3B C3 74 D5 8B 00 3B C3 74 CF 38 18 74 CB 56 6A 5C 57 E8 ?? ?? ?? ?? 6A 2F 57 8B F0 E8 ?? ?? ?? ?? 83 C4 10 3B C3 0F 85 81 00 00 00 3B F3 0F 85 83 00 00 00 6A 3A 57 E8 ?? ?? ?? ?? 8B F0 59 59 3B F3 75 73 57 E8 ?? ?? ?? ?? 8B F0 83 C6 03 6A 01 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 89 7D FC 3B FB 0F 84 AD 00 00 00 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 77 02 8B 7D 08 EB 0A 3B F3 74 04 3B C6 76 02 8B F0 83 4D F0 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 2C 53 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 EC 00 00 00 FF 75 10 FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 E9 D3 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C6 05 6A 01 56 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C3 75 08 83 C8 FF E9 BD 00 00 00 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC E8 ?? ?? ?? ?? 8B F8 03 7D F8 59 E8 ?? ?? ?? ?? 8B 00 89 45 EC 8B 45 F8 2B F7 03 F0 C7 45 F4 ?? ?? ?? ?? 8B 45 F4 FF 30 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 53 FF 75 F8 E8 ?? ?? ?? ?? 59 59 85 C0 74 0F 83 6D F4 04 81 7D F4 ?? ?? ?? ?? 7D C4 EB 1E E8 ?? ?? ?? ?? FF 75 10 8B 4D EC FF 75 0C 89 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 FF 75 F8 E8 ?? ?? ?? ?? 8B 7D 08 59 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__dup2_nolock"
		size = 276
		refs = "0018 ___pioinfo 0029 __errno 0034 ___doserrno 0075 __close_nolock 0086 __imp__GetCurrentProcess@0 008f __get_osfhandle 009e __imp__DuplicateHandle@28 00a8 __imp__GetLastError@0 00b5 __set_osfhnd 00c3 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8B 5D 08 56 8B 75 08 C1 FB 05 83 E6 1F 8D 1C 9D ?? ?? ?? ?? 8B 03 C1 E6 06 F6 44 30 04 01 75 1B E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 C8 FF E9 CD 00 00 00 8B 4D 0C 39 4D 08 75 07 33 C0 E9 BE 00 00 00 57 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 8B F9 83 E7 1F 89 45 F8 8B 00 C1 E7 06 F6 44 38 04 01 74 07 51 E8 ?? ?? ?? ?? 59 6A 02 6A 01 6A 00 8D 45 FC 50 FF 15 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 0F FF 75 FC FF 75 0C E8 ?? ?? ?? ?? 59 59 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF EB 42 8B 03 8A 44 30 04 8B 4D F8 8B 11 24 EF 88 44 3A 04 8B 13 8A 54 32 24 8B 01 8D 44 38 24 02 D2 D0 FA 32 10 80 E2 7F 30 10 8B 01 8B 0B 8D 7C 38 24 8B 03 8A 44 30 24 32 07 24 7F 32 44 31 24 88 07 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_326_1_0 {
	meta:
		name = "_extend_ioinfo_arrays"
		size = 101
		refs = "0002 __nhandle 000a ___pioinfo 0018 __calloc_crt"
	strings:
		$1 = { 3B 3D ?? ?? ?? ?? 56 7C 53 BE ?? ?? ?? ?? 83 3E 00 75 3E 6A 40 6A 20 E8 ?? ?? ?? ?? 59 59 85 C0 74 3E 83 05 ?? ?? ?? ?? 20 89 06 8D 88 00 08 00 00 EB 1A 83 08 FF 83 60 08 00 C6 40 04 00 C6 40 05 0A 8B 0E 83 C0 40 81 C1 00 08 00 00 3B C1 72 E2 83 C6 04 3B 3D ?? ?? ?? ?? 7D B2 33 C0 5E C3 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_326_2_0 {
	meta:
		name = "__dup2"
		size = 269
		refs = "0003 __sehtable$__dup2 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0036 __nhandle 0056 __invalid_parameter 006f ___pioinfo 009f _extend_ioinfo_arrays 00bd ___lock_fhandle 00da __dup2_nolock 00f3 __SEH_epilog4 0100 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 C3 00 00 00 33 F6 3B DE 7C 09 A1 ?? ?? ?? ?? 3B D8 72 21 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 09 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB C8 8B CB C1 F9 05 8B D3 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 0F BE 4C 11 04 83 E1 01 74 C1 8B 7D 0C 83 FF FE 75 09 E8 ?? ?? ?? ?? 89 30 EB 8E 81 FF 00 08 00 00 1B C9 F7 D9 74 A4 3B F8 7C 19 E8 ?? ?? ?? ?? 85 C0 74 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 70 FF FF FF 3B DF 7D 09 53 E8 ?? ?? ?? ?? 57 EB 09 7E 0E 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 89 75 FC 57 53 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 0F 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 7D 0C 8B 5D 08 53 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "_wcstok"
		size = 171
		refs = "0007 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 4D 08 89 45 FC 85 C9 75 03 8B 48 1C 0F B7 11 56 57 66 85 D2 74 30 8B 45 0C 0F B7 00 8B 7D 0C 66 85 C0 74 12 0F B7 F0 66 3B F2 74 0A 47 47 0F B7 37 66 85 F6 75 F1 66 83 3F 00 74 0A 41 41 0F B7 11 66 85 D2 75 D6 66 83 39 00 89 4D 08 74 3A 8B 45 0C 0F B7 00 8B 75 0C 66 85 C0 74 15 0F B7 39 0F B7 D0 66 3B D7 74 0A 46 46 0F B7 16 66 85 D2 75 F1 66 83 3E 00 75 0A 41 41 66 83 39 00 75 D5 EB 07 33 C0 66 89 01 41 41 8B 45 FC 89 48 1C 8B 45 08 2B C1 F7 D8 1B C0 23 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_328_2_0 {
	meta:
		name = "__wstat64"
		size = 1010
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0059 _wcspbrk 0090 _towlower 009e __getdrive 00b2 __imp__FindFirstFileW@8 00c6 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00f1 __wfullpath_helper 0104 _wcslen 010f _IsRootUNCName 011a __imp__GetDriveTypeW@4 0132 _free 0165 ___loctotime64_t 01d0 __imp__FileTimeToLocalFileTime@8 01ec __imp__FileTimeToSystemTime@8 036c __imp__FindClose@4 0378 ___wdtoxmode 0393 __allmul 03c9 __imp__GetLastError@0 03cf __dosmaperr 03ec @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 92 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 67 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 84 FB FF FF 8D 85 A4 FB FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 A0 FB FF FF 83 F8 FF 0F 85 E3 00 00 00 68 ?? ?? ?? ?? 56 89 9D A0 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 87 8D 85 A0 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 89 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 74 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 68 39 9D A0 FB FF FF 74 0C FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 A4 FB FF FF 10 00 00 00 89 9D C0 FB FF FF 89 9D C4 FB FF FF 66 89 85 D0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 8B CA 83 C4 1C 89 47 28 89 57 2C 89 47 20 89 4F 24 89 47 30 89 4F 34 E9 E5 01 00 00 39 9D A0 FB FF FF 0F 84 CC FE FF FF FF B5 A0 FB FF FF E8 ?? ?? ?? ?? 59 E9 BB FE FF FF 39 9D B8 FB FF FF 75 10 39 9D BC FB FF FF 75 08 89 5F 28 89 5F 2C EB 78 8D 85 88 FB FF FF 50 8D 85 B8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EB 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CF 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 39 9D B0 FB FF FF 75 16 39 9D B4 FB FF FF 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 78 8D 85 88 FB FF FF 50 8D 85 B0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 55 01 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 39 01 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D A8 FB FF FF 75 16 39 9D AC FB FF FF 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 78 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BF 00 00 00 8D 85 90 FB FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 0F B7 85 9C FB FF FF 6A FF 50 0F B7 85 9A FB FF FF 50 0F B7 85 98 FB FF FF 50 0F B7 85 96 FB FF FF 50 0F B7 85 92 FB FF FF 50 0F B7 85 90 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 FF B5 A0 FB FF FF FF 15 ?? ?? ?? ?? 56 FF B5 A4 FB FF FF E8 ?? ?? ?? ?? 59 66 89 47 06 59 33 C0 40 50 53 53 FF B5 C0 FB FF FF 66 89 47 08 E8 ?? ?? ?? ?? 8B 8D C4 FB FF FF 33 F6 03 C1 13 D6 89 47 18 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 89 07 89 47 10 89 57 1C 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 A0 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "_fputws"
		size = 172
		refs = "0003 __sehtable$_fputws 0008 __SEH_prolog4 001e __errno 002e __invalid_parameter 004c _wcslen 0057 __lock_file 0079 __fputwc_nolock 009d __SEH_epilog4 00a6 __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E0 33 C0 39 75 08 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF 00 00 EB 60 33 C0 39 75 0C 0F 95 C0 3B C6 74 D5 FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 FF 75 0C E8 ?? ?? ?? ?? 59 59 89 75 FC 8B 45 E4 FF 4D E4 85 C0 74 23 8B 45 08 0F B7 00 83 45 08 02 FF 75 0C 50 E8 ?? ?? ?? ?? 59 59 B9 FF FF 00 00 66 3B C1 75 D7 83 4D E0 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__telli64"
		size = 24
		refs = "000f __lseeki64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "__getenv_helper_nolock"
		size = 135
		refs = "0007 ___env_initialized 000f __environ 0020 __wenviron 0027 ___wtomb_environ 0043 _strlen 0065 __mbsnbicoll"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 EB 63 57 85 F6 75 1B 39 35 ?? ?? ?? ?? 74 53 E8 ?? ?? ?? ?? 85 C0 75 4A 8B 35 ?? ?? ?? ?? 85 F6 74 40 83 7D 08 00 74 3A FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 27 50 E8 ?? ?? ?? ?? 59 3B C7 76 19 8B 06 80 3C 38 3D 75 11 57 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D3 33 C0 5F 5E 5D C3 8B 06 8D 44 38 01 EB F4 }
	condition:
		$1
}

rule file_331_2_0 {
	meta:
		name = "__getenv_s_helper"
		size = 149
		refs = "0010 __errno 001f __invalid_parameter 004a __getenv_helper_nolock 0057 _strlen 0076 _strcpy_s 0087 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F0 33 DB 3B F3 75 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 67 8B 45 08 89 1E 3B C3 74 07 39 5D 0C 77 07 EB D5 39 5D 0C 75 D0 3B C3 74 02 88 18 57 FF 75 10 E8 ?? ?? ?? ?? 8B F8 59 3B FB 74 39 57 E8 ?? ?? ?? ?? 40 59 89 06 39 5D 0C 74 2A 3B 45 0C 76 05 6A 22 58 EB 22 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_331_3_0 {
	meta:
		name = "__dupenv_s_helper"
		size = 164
		refs = "000f __errno 001e __invalid_parameter 003d __getenv_helper_nolock 004b _strlen 0056 _calloc 007d _strcpy_s 008e __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 57 33 FF 3B DF 75 1B E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 77 8B 45 08 89 3B 3B C7 74 02 89 38 39 7D 0C 74 D5 FF 75 0C E8 ?? ?? ?? ?? 59 89 45 FC 3B C7 74 55 50 E8 ?? ?? ?? ?? 8B F0 46 6A 01 56 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C7 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 29 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 74 02 89 30 33 C0 5F 5E C9 C3 }
	condition:
		$1
}

rule file_331_5_0 {
	meta:
		name = "_getenv_s"
		size = 216
		refs = "0003 __sehtable$_getenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 006f __getenv_helper_nolock 007c _strlen 009f _strcpy_s 00b0 __invoke_watson 00ca __SEH_epilog4 00d2 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 33 C0 8B 7D 08 3B FB 0F 95 C0 3B C3 75 1C E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 75 E4 EB 77 89 1F 8B 4D 0C 3B CB 74 09 39 5D 10 77 09 3B CB 75 0A 39 5D 10 75 05 33 C0 40 EB 02 33 C0 3B C3 74 C2 3B CB 74 02 88 19 FF 75 14 E8 ?? ?? ?? ?? 59 8B F0 3B F3 74 3D 56 E8 ?? ?? ?? ?? 59 40 89 07 39 5D 10 74 2E 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 23 56 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 5D E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_331_6_0 {
	meta:
		name = "__dupenv_s"
		size = 230
		refs = "0003 __sehtable$__dupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0061 __getenv_helper_nolock 006f _strlen 007a _calloc 00a4 _strcpy_s 00b5 __invoke_watson 00d8 __SEH_epilog4 00e0 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 E9 82 00 00 00 89 33 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 CA FF 75 10 E8 ?? ?? ?? ?? 59 89 45 E0 3B C6 74 58 50 E8 ?? ?? ?? ?? 8B F8 47 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 2A FF 75 E0 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 45 0C 3B C6 74 02 89 38 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "?wcsncnt@@YAHPB_WH@Z"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 EB 09 49 66 83 38 00 74 07 40 40 85 C9 75 F3 49 8B 45 08 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_332_4_0 {
	meta:
		name = "?__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z"
		size = 93
		refs = "0011 ?wcsncnt@@YAHPB_WH@Z 0040 __imp__CompareStringW@24"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 85 D2 7E 0C 8B 45 10 52 E8 ?? ?? ?? ?? 59 8B D0 85 F6 7E 0C 8B 45 14 56 E8 ?? ?? ?? ?? 59 8B F0 85 D2 74 1A 85 F6 74 16 56 FF 75 14 52 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 14 2B D6 75 05 6A 02 58 EB 0B 33 C0 85 D2 0F 9D C0 8D 44 00 01 5E 5D C3 }
	condition:
		$1
}

rule file_332_5_0 {
	meta:
		name = "___crtCompareStringW"
		size = 124
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ?wcsncnt@@YAHPB_WH@Z 0052 __imp__CompareStringW@24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 18 8B 55 20 85 F6 7E 0C 8B 45 14 56 E8 ?? ?? ?? ?? 59 8B F0 85 D2 7E 0C 8B 45 1C 52 E8 ?? ?? ?? ?? 59 8B D0 85 F6 74 1A 85 D2 74 16 52 FF 75 1C 56 FF 75 14 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? EB 14 2B F2 75 05 6A 02 58 EB 0B 33 C0 85 F6 0F 9D C0 8D 44 00 01 80 7D FC 00 5E 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "?_set_new_mode@@YAHH@Z"
		size = 63
		refs = "0015 __errno 0025 __invalid_parameter 0032 __newmode"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 74 22 83 F9 01 74 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 0B A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "_xtoa_s@20"
		size = 221
		refs = "0011 __errno 0020 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 33 DB 3B F3 75 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 A9 00 00 00 57 39 5D 08 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 84 00 00 00 33 C9 39 5D 10 88 1E 0F 95 C1 41 39 4D 08 77 09 E8 ?? ?? ?? ?? 6A 22 EB D0 8B 4D 0C 83 C1 FE 83 F9 22 77 BE 89 5D FC 8B CE 39 5D 10 74 0F C6 06 2D 8D 4E 01 C7 45 FC 01 00 00 00 F7 D8 8B F9 33 D2 F7 75 0C 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 11 41 FF 45 FC 33 DB 3B C3 76 08 8B 55 08 39 55 FC 72 DA 8B 45 FC 3B 45 08 72 04 88 1E EB 9F 88 19 49 8A 17 8A 01 88 11 49 88 07 47 3B F9 72 F2 33 C0 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_334_1_0 {
	meta:
		name = "__itoa_s"
		size = 42
		refs = "0024 _xtoa_s@20"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 14 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_334_2_0 {
	meta:
		name = "__ltoa_s"
		size = 39
		refs = "0021 _xtoa_s@20"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 14 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 14 8B 45 08 FF 75 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_334_3_0 {
	meta:
		name = "__ultoa_s"
		size = 26
		refs = "0014 _xtoa_s@20"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 6A 00 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_334_4_0 {
	meta:
		name = "@x64toa_s@24"
		size = 248
		refs = "0011 __errno 0020 __invalid_parameter 0089 __aulldvrm"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 33 DB 56 3B FB 75 1E E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 C4 00 00 00 39 5D 10 76 DD 33 C0 39 5D 18 88 1F 0F 95 C0 40 39 45 10 77 09 E8 ?? ?? ?? ?? 6A 22 EB CB 8B 45 14 83 C0 FE 83 F8 22 77 B9 8B 55 08 8B 45 0C 89 5D FC 8B F7 39 5D 18 74 13 F7 DA 13 C3 C6 07 2D 8D 77 01 C7 45 FC 01 00 00 00 F7 D8 89 75 18 89 5D 0C FF 75 0C FF 75 14 50 52 E8 ?? ?? ?? ?? 89 5D F8 8B DA 8B D0 8B C3 83 F9 09 76 05 80 C1 57 EB 03 80 C1 30 88 0E 8B 4D FC 46 41 89 4D FC 85 C0 77 04 85 D2 76 08 3B 4D 10 72 C6 8B 4D FC 3B 4D 10 72 16 C6 07 00 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 33 DB E9 42 FF FF FF C6 06 00 4E 8B 45 18 8A 10 8A 0E 88 16 4E 88 08 40 89 45 18 3B C6 72 EC 33 C0 5E 5B C9 C2 14 00 }
	condition:
		$1
}

rule file_334_5_0 {
	meta:
		name = "__i64toa_s"
		size = 53
		refs = "002e @x64toa_s@24"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 18 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 57 8B 7D 10 50 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_884_5_0 {
	meta:
		name = "__i64tow_s"
		size = 53
		refs = "002e @x64tow_s@24"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 18 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 57 8B 7D 10 50 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_334_6_0 {
	meta:
		name = "__ui64toa_s"
		size = 31
		refs = "0018 @x64toa_s@24"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B 7D 10 6A 00 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_884_6_0 {
	meta:
		name = "__ui64tow_s"
		size = 31
		refs = "0018 @x64tow_s@24"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B 7D 10 6A 00 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__execle"
		size = 89
		refs = "0013 __errno 0023 __invalid_parameter 004f __execve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 33 DB 8D 45 0C 3B D3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 27 38 1A 74 DF 8B 4D 0C 3B CB 74 D8 38 19 74 D4 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 45 0C 50 52 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_336_2_0 {
	meta:
		name = "__stat64i32"
		size = 980
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0059 __mbspbrk 008f __mbctolower 009a __getdrive 00ae __imp__FindFirstFileA@8 00c2 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00ed __fullpath_helper 0100 _strlen 010b _IsRootUNCName 0116 __imp__GetDriveTypeA@4 012e _free 015e ___loctotime64_t 01c9 __imp__FileTimeToLocalFileTime@8 01e5 __imp__FileTimeToSystemTime@8 0365 __imp__FindClose@4 0371 ___dtoxmode 03ab __imp__GetLastError@0 03b1 __dosmaperr 03ce @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 A0 FD FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 74 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 49 03 00 00 80 7E 01 3A 75 1A 8A 06 3A C3 74 05 38 5E 02 74 D9 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 98 FD FF FF 8D 85 B8 FD FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 B4 FD FF FF 83 F8 FF 0F 85 E0 00 00 00 68 ?? ?? ?? ?? 56 89 9D B4 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 8B 8D 85 B4 FD FF FF 50 68 04 01 00 00 8D 85 F8 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 86 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 71 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 65 39 9D B4 FD FF FF 74 0C FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 B8 FD FF FF 10 00 00 00 89 9D D4 FD FF FF 89 9D D8 FD FF FF 88 9D E4 FD FF FF E8 ?? ?? ?? ?? 8B B5 A0 FD FF FF 8B CA 83 C4 1C 89 47 20 89 57 24 89 47 18 89 4F 1C 89 47 28 89 4F 2C E9 E5 01 00 00 39 9D B4 FD FF FF 0F 84 D3 FE FF FF FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 E9 C2 FE FF FF 39 9D CC FD FF FF 75 10 39 9D D0 FD FF FF 75 08 89 5F 20 89 5F 24 EB 78 8D 85 9C FD FF FF 50 8D 85 CC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D4 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B8 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D C4 FD FF FF 75 16 39 9D C8 FD FF FF 75 0E 8B 47 20 89 47 18 8B 47 24 89 47 1C EB 78 8D 85 9C FD FF FF 50 8D 85 C4 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3E 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 22 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 18 89 57 1C 39 9D BC FD FF FF 75 16 39 9D C0 FD FF FF 75 0E 8B 47 20 89 47 28 8B 47 24 89 47 2C EB 78 8D 85 9C FD FF FF 50 8D 85 BC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A8 00 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8C 00 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C FF B5 B4 FD FF FF FF 15 ?? ?? ?? ?? 56 FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 8B 85 D8 FD FF FF 89 47 14 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 98 FD FF FF 48 59 89 07 89 47 10 59 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 B4 FD FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "__except_handler3"
		size = 254
		refs = "0035 __ValidateEH3RN 007a _CallDestructExceptionObject 0086 __global_unwind2 0093 __local_unwind2 00a4 __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 C3 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 0F 8E 8F 00 00 00 83 FE FF 0F 84 8D 00 00 00 8D 0C 76 8B 44 8F 04 0B C0 74 66 56 55 8D 6B 10 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 5D 5E 8B 5D 0C 0B C0 74 4C 78 58 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 08 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C 8B 44 8F 08 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 8B 7B 08 8D 0C 76 8B 34 8F E9 78 FF FF FF B8 00 00 00 00 EB 23 8B 45 08 83 48 04 08 B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_338_1_0 {
	meta:
		name = "__localtime32_s"
		size = 559
		refs = "001d __errno 002c __invalid_parameter 0044 _memset 0081 ___tzset 008a __get_daylight 0099 __invoke_watson 00a5 __get_dstbias 00c0 __get_timezone 00f2 __gmtime32_s 010b __isindst"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 08 57 33 FF 89 7D F8 89 7D F4 89 7D FC 3B F7 75 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 BA 01 00 00 53 6A 24 68 FF 00 00 00 56 E8 ?? ?? ?? ?? 8B 5D 0C 83 C4 0C 3B DF 75 19 E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 EB 0E 39 3B 7D 11 E8 ?? ?? ?? ?? 6A 16 5E 89 30 8B C6 E9 73 01 00 00 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 45 F4 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 45 FC 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 03 3D 80 F4 03 00 7E 5F 3D 7F 0B FC 7F 7D 58 2B 45 FC 89 45 08 8D 45 08 50 56 E8 ?? ?? ?? ?? 59 59 3B C7 0F 85 F3 00 00 00 39 7D F8 0F 84 E8 00 00 00 56 E8 ?? ?? ?? ?? 59 85 C0 0F 84 D9 00 00 00 8B 45 F4 29 45 08 8D 45 08 50 56 E8 ?? ?? ?? ?? 59 59 3B C7 0F 85 C1 00 00 00 C7 46 20 01 00 00 00 E9 B3 00 00 00 53 56 E8 ?? ?? ?? ?? 59 59 3B C7 0F 85 A4 00 00 00 39 7D F8 74 1C 56 E8 ?? ?? ?? ?? 59 85 C0 74 11 8B 0E 2B 4D FC C7 46 20 01 00 00 00 2B 4D F4 EB 05 8B 0E 2B 4D FC 8B C1 6A 3C 99 5B F7 FB 3B D7 89 16 7D 06 03 D3 89 16 2B CB 8B C1 99 6A 3C 59 F7 F9 6A 3C 5B 8B C8 03 4E 04 8B C1 99 F7 FB 3B D7 89 56 04 7D 07 03 D3 89 56 04 2B CB 8B C1 99 6A 3C 59 F7 F9 6A 18 5B 8B C8 03 4E 08 8B C1 99 F7 FB 3B D7 89 56 08 7D 07 03 D3 89 56 08 2B CB 8B C1 6A 18 99 59 F7 F9 8B C8 3B CF 7E 1B 8B 46 18 03 C1 6A 07 99 5F F7 FF 01 4E 0C 89 56 18 01 4E 1C 33 C0 5B 5F 5E C9 C3 7D F7 8B 46 18 8D 44 08 07 99 6A 07 5B F7 FB 01 4E 0C 8B 46 0C 3B C7 89 56 18 7F DA 81 C1 6D 01 00 00 01 4E 1C 83 C0 1F FF 4E 14 89 46 0C C7 46 10 0B 00 00 00 EB C2 }
	condition:
		$1
}

rule file_338_2_0 {
	meta:
		name = "__localtime32"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 __localtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_690_2_0 {
	meta:
		name = "__gmtime32"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_929_1_0 {
	meta:
		name = "__gmtime64"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 __gmtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_947_2_0 {
	meta:
		name = "__localtime64"
		size = 39
		refs = "0007 ___getgmtimebuf 0016 __localtime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 13 FF 75 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_339_2_0 {
	meta:
		name = "__wexecve"
		size = 538
		refs = "0017 __errno 0027 __invalid_parameter 0052 _wcsrchr 0077 _wcschr 0085 _wcslen 0092 __calloc_crt 00a7 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 00ae _wcscpy_s 00bf __invoke_watson 00cc _wcscat_s 010d __waccess_s 0125 _wcomexecmd 019f _ext_strings 01fc _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 8B 5D 08 57 33 FF 89 5D FC 3B DF 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E0 01 00 00 66 39 3B 74 DB 8B 45 0C 3B C7 74 D4 8B 00 3B C7 74 CE 66 39 38 74 C9 56 6A 5C 53 E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 3B C7 0F 85 81 00 00 00 3B F7 0F 85 83 00 00 00 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 59 59 3B F7 75 73 53 E8 ?? ?? ?? ?? 8B F0 83 C6 03 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 89 5D FC 3B DF 0F 84 AC 00 00 00 68 ?? ?? ?? ?? 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 08 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 73 04 8B 5D 08 EB 0A 3B F7 74 04 3B C6 76 02 8B F0 83 4D F4 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 2C 57 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 E9 00 00 00 FF 75 10 FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 E9 D0 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C6 05 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 3B DF 75 08 83 C8 FF E9 BB 00 00 00 FF 75 FC 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC E8 ?? ?? ?? ?? 8D 04 43 59 89 45 F0 E8 ?? ?? ?? ?? 8B 00 89 45 EC 8B 45 F0 2B C3 89 75 F8 D1 F8 29 45 F8 BE ?? ?? ?? ?? FF 36 FF 75 F8 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 57 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 0D 83 EE 04 81 FE ?? ?? ?? ?? 7D C7 EB 1C E8 ?? ?? ?? ?? FF 75 10 8B 4D EC FF 75 0C 89 08 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 53 E8 ?? ?? ?? ?? 8B 5D 08 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_340_3_0 {
	meta:
		name = "__mbsncoll_l"
		size = 283
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0037 __errno 0047 __invalid_parameter 009f __strncoll_l 00b1 __mbsnbcnt_l 00de ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 10 33 DB 3B F3 75 13 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 E6 00 00 00 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 B3 00 00 00 57 8B 7D 0C 3B FB 74 08 81 FE FF FF FF 7F 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 66 8B 45 F4 39 58 08 75 12 FF 75 14 56 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 62 8D 45 F0 50 56 FF 75 08 E8 ?? ?? ?? ?? 89 45 10 8D 45 F0 50 56 57 E8 ?? ?? ?? ?? 8B 4D F4 FF 71 04 50 57 FF 75 10 8D 45 F0 FF 75 08 68 00 10 00 00 FF 71 0C 50 E8 ?? ?? ?? ?? 83 C4 38 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "?_Type_info_dtor@type_info@@CAXPAV1@@Z"
		size = 112
		refs = "0003 __sehtable$?_Type_info_dtor@type_info@@CAXPAV1@@Z 0008 __SEH_prolog4 000f __lock 0023 ___type_info_root_node 003f _free 005e __SEH_epilog4 006a __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 0E E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 75 08 8B 4E 04 85 C9 74 2F A1 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 45 E4 85 C0 74 11 39 08 75 2C 8B 48 04 89 4A 04 50 E8 ?? ?? ?? ?? 59 FF 76 04 E8 ?? ?? ?? ?? 59 83 66 04 00 C7 45 FC FE FF FF FF E8 0A 00 00 00 E8 ?? ?? ?? ?? C3 8B D0 EB C5 6A 0E E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_341_3_0 {
	meta:
		name = "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z"
		size = 112
		refs = "0003 __sehtable$?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z 0008 __SEH_prolog4 000f __lock 0023 ___type_info_root_node 003f _free 005e __SEH_epilog4 006a __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 0E E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 75 08 8B 4E 04 85 C9 74 2F A1 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 45 E4 85 C0 74 11 39 08 75 2C 8B 48 04 89 4A 04 50 E8 ?? ?? ?? ?? 59 FF 76 04 E8 ?? ?? ?? ?? 59 83 66 04 00 C7 45 FC FE FF FF FF E8 0A 00 00 00 E8 ?? ?? ?? ?? C3 8B D0 EB C5 6A 0E E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_341_2_0 {
	meta:
		name = "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
		size = 245
		refs = "0003 __sehtable$?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z 0008 __SEH_prolog4 0020 _free 0025 _malloc 0030 ___unDName 0047 _strlen 0065 __lock 0097 _strcpy_s 00aa __invoke_watson 00e4 __SEH_epilog4 00ef __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 39 5F 04 0F 85 C6 00 00 00 68 00 28 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 8D 47 09 50 53 E8 ?? ?? ?? ?? 83 C4 18 89 45 E4 3B C3 75 07 33 C0 E9 9E 00 00 00 50 E8 ?? ?? ?? ?? 59 8B F0 EB 0D 4E 8B 45 E4 03 C6 80 38 20 75 07 88 18 3B F3 77 EF 4E 6A 0E E8 ?? ?? ?? ?? 59 89 5D FC 39 5F 04 75 59 6A 08 E8 ?? ?? ?? ?? 59 8B D8 85 DB 74 4B 83 C6 02 56 E8 ?? ?? ?? ?? 59 89 47 04 85 C0 74 33 FF 75 E4 56 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 3B C1 74 0D 51 51 51 51 51 E8 ?? ?? ?? ?? 83 C4 14 8B 47 04 89 03 8B 45 0C 8B 48 04 89 4B 04 89 58 04 EB 07 53 E8 ?? ?? ?? ?? 59 FF 75 E4 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 47 04 E8 ?? ?? ?? ?? C3 8B 7D 08 6A 0E E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_341_4_0 {
	meta:
		name = "___unDNameHelper"
		size = 51
		refs = "0017 _free 001c _malloc 002a ___unDName"
	strings:
		$1 = { 8B FF 55 8B EC 66 83 7D 14 00 75 07 C7 45 14 00 28 00 00 FF 75 14 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_341_5_0 {
	meta:
		name = "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
		size = 271
		refs = "0003 __sehtable$?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z 0008 __SEH_prolog4 001d __lock 003a ___unDNameHelper 0051 ___security_cookie 0056 __local_unwind4 0066 _strlen 008a _malloc 00ab _strcpy_s 00be __invoke_watson 00dd _free 00fe __SEH_epilog4 0109 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 8B 75 08 39 5E 04 0F 85 E0 00 00 00 6A 0E E8 ?? ?? ?? ?? 59 89 5D FC 39 5E 04 0F 85 C0 00 00 00 68 00 28 00 00 53 83 C6 09 56 53 E8 ?? ?? ?? ?? 83 C4 10 8B F8 89 7D E4 3B FB 75 1A 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 99 00 00 00 57 E8 ?? ?? ?? ?? 59 8B F0 89 75 E0 8B C6 4E 89 75 E0 85 C0 76 0D 8D 04 3E 80 38 20 75 05 C6 00 00 EB E9 6A 08 E8 ?? ?? ?? ?? 59 8B F8 3B FB 74 4D 8D 5E 02 53 E8 ?? ?? ?? ?? 59 8B F0 85 F6 74 36 FF 75 E4 53 56 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 3B C1 74 0D 51 51 51 51 51 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 89 70 04 89 37 8B 45 0C 8B 48 04 89 4F 04 89 78 04 EB 07 57 E8 ?? ?? ?? ?? 59 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 75 08 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 46 04 E8 ?? ?? ?? ?? C3 8B 75 08 6A 0E E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_341_6_0 {
	meta:
		name = "___clean_type_info_names_internal"
		size = 83
		refs = "0003 __sehtable$___clean_type_info_names_internal 0008 __SEH_prolog4 000f __lock 0028 _free 0045 __SEH_epilog4 004d __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 0E E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 45 08 8B 70 04 85 F6 74 16 8B 7E 04 FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 8B F7 EB E6 C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 6A 0E E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "___wrt2err"
		size = 39
		refs = "0015 ___pioinfo 0021 __imp__WriteFile@20"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8D 45 08 50 8B 45 08 0F BE 08 51 40 50 A1 ?? ?? ?? ?? FF B0 80 00 00 00 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
		size = 132
		refs = "003f __woutput_l 005f __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C C7 45 EC 42 00 00 00 3D FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 56 FF 75 18 8D 45 E0 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0B 8B 45 E0 C6 00 00 FF 45 E0 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__lrotl"
		size = 18
		altNames = "__rotl"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 83 E1 1F D3 C0 5D C3 }
	condition:
		$1
}

rule file_345_2_0 {
	meta:
		name = "__rotl64"
		size = 58
		refs = "0018 __aullshr 002a __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 83 65 10 3F 8B 45 08 8B 55 0C 56 57 6A 40 59 2B 4D 10 E8 ?? ?? ?? ?? 8B 4D 10 8B F0 8B 45 08 8B FA 8B 55 0C E8 ?? ?? ?? ?? 0B F0 0B FA 8B D7 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_710_2_0 {
	meta:
		name = "__rotr64"
		size = 58
		refs = "0018 __allshl 002a __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 83 65 10 3F 8B 45 08 8B 55 0C 56 57 6A 40 59 2B 4D 10 E8 ?? ?? ?? ?? 8B 4D 10 8B F0 8B 45 08 8B FA 8B 55 0C E8 ?? ?? ?? ?? 0B F0 0B FA 8B D7 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2912
		refs = "0023 SIGMASK 002b ONEMASK 005c rcp_t1 0070 log2_t1 00ab HALFSIG 00d7 rcp_t2 00eb log2_t2 011d LHN 0133 rcp_t3 0145 log2_t3 022e clv 0289 Shifter 02ad exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 07a9 INF 0844 ___libm_error_support 0a7d EMIN 0aaa NEG_BIG 0ab2 POS_BIG"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 E4 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E E1 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 1C 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9A 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 86 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 99 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 47 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 2B 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 8F 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 48 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A2 00 00 00 66 0F 7E E0 83 F8 00 75 20 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 E9 00 00 00 81 FA 00 00 F0 BF 75 03 D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 63 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 3A 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 25 72 05 83 F9 00 77 1E 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? BA 1C 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 65 FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 54 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 EF F6 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 2D FF FF FF E9 4B FF FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__wputenv_helper"
		size = 547
		refs = "000f ___env_initialized 0026 __errno 0036 __invalid_parameter 004f _wcschr 0073 _wcsnlen 007f _wcslen 008a __calloc_crt 00a0 _wcscpy_s 0138 ___crtwsetenv 0155 __environ 0161 __imp__WideCharToMultiByte@32 01be _strlen 01e7 _free 01ff ___crtsetenv"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 33 F6 89 75 F8 39 35 ?? ?? ?? ?? 75 08 83 C8 FF E9 03 02 00 00 53 8B 5D 08 3B DE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DA 01 00 00 57 39 75 0C 75 61 6A 3D 53 E8 ?? ?? ?? ?? 59 59 3B C6 74 24 8B C8 2B CB 83 E1 FE 81 F9 FE FF 00 00 7D 66 BF FF 7F 00 00 83 C0 02 57 50 E8 ?? ?? ?? ?? 59 59 3B C7 73 51 53 E8 ?? ?? ?? ?? 8B F8 47 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C6 0F 84 7B 01 00 00 53 57 50 E8 ?? ?? ?? ?? 83 C4 0C E9 85 00 00 00 BF FF 7F 00 00 57 53 E8 ?? ?? ?? ?? 57 FF 75 0C 8B D8 E8 ?? ?? ?? ?? 83 C4 10 3B DF 73 04 3B C7 72 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 2C 01 00 00 8D 7C 18 02 6A 02 57 E8 ?? ?? ?? ?? 59 59 89 45 F8 3B C6 0F 84 13 01 00 00 FF 75 08 57 50 E8 ?? ?? ?? ?? 8B 4D F8 6A 3D 58 FF 75 0C 66 89 04 59 8B 45 F8 43 2B FB 8D 04 58 57 50 E8 ?? ?? ?? ?? 8B 5D 08 83 C4 18 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 11 39 75 F8 0F 84 CC 00 00 00 FF 75 F8 E9 BE 00 00 00 39 35 ?? ?? ?? ?? 0F 84 BD 00 00 00 8B 3D ?? ?? ?? ?? 56 56 56 56 6A FF 53 56 56 89 75 FC FF D7 8B D8 3B DE 74 73 39 75 0C 74 15 56 56 56 56 6A FF FF 75 0C 56 56 FF D7 3B C6 74 5D 8D 5C 03 01 6A 01 53 E8 ?? ?? ?? ?? 59 59 89 45 FC 3B C6 74 73 56 56 53 50 6A FF FF 75 08 56 56 FF D7 85 C0 74 2E 39 75 0C 74 3F FF 75 FC E8 ?? ?? ?? ?? 59 8B 4D FC 56 C6 04 08 3D 8B 4D FC 56 40 2B D8 53 03 C1 50 6A FF FF 75 0C 56 56 FF D7 85 C0 75 16 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 1E 8D 45 FC 56 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 13 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_349_1_0 {
	meta:
		name = "__wputenv"
		size = 69
		refs = "0003 __sehtable$__wputenv 0008 __SEH_prolog4 000f __lock 001e __wputenv_helper 0037 __SEH_epilog4 003f __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_579_1_0 {
	meta:
		name = "__putenv"
		size = 69
		refs = "0003 __sehtable$__putenv 0008 __SEH_prolog4 000f __lock 001e __putenv_helper 0037 __SEH_epilog4 003f __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_349_2_0 {
	meta:
		name = "__wputenv_s"
		size = 121
		refs = "0003 __sehtable$__wputenv_s 0008 __SEH_prolog4 001b __errno 002a __invalid_parameter 0038 __lock 0047 __wputenv_helper 006b __SEH_epilog4 0073 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 35 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_579_2_0 {
	meta:
		name = "__putenv_s"
		size = 121
		refs = "0003 __sehtable$__putenv_s 0008 __SEH_prolog4 001b __errno 002a __invalid_parameter 0038 __lock 0047 __putenv_helper 006b __SEH_epilog4 0073 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 35 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "__findfirst32i64"
		size = 324
		refs = "000c ___security_cookie 0024 __errno 0034 __invalid_parameter 0051 __imp__FindFirstFileA@8 0062 __imp__GetLastError@0 00bd ___timet_from_ft 00f0 __allmul 0117 _strcpy_s 0129 __invoke_watson 013e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F3 00 00 00 3B C7 74 DC 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 F8 FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B2 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A5 E8 ?? ?? ?? ?? 89 30 EB 9C 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 53 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 D8 FE FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 DB 03 C1 89 46 10 13 D3 8D 85 E8 FE FF FF 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 5B 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 B8 FE FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_350_2_0 {
	meta:
		name = "__findnext32i64"
		size = 324
		refs = "000c ___security_cookie 0026 __errno 0038 __invalid_parameter 005d __imp__FindNextFileA@8 0067 __imp__GetLastError@0 00c1 ___timet_from_ft 00f4 __allmul 011b _strcpy_s 012c __invoke_watson 013e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 83 CB FF 57 3B C3 75 21 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C3 E9 EF 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D9 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 D8 FE FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D DC FE FF FF 33 DB 03 C1 89 46 10 13 D3 8D 85 E8 FE FF FF 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__ValidateImageBase"
		size = 53
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 4D 5A 00 00 66 39 01 74 04 33 C0 5D C3 8B 41 3C 03 C1 81 38 50 45 00 00 75 EF 33 D2 B9 0B 01 00 00 66 39 48 18 0F 94 C2 8B C2 5D C3 }
	condition:
		$1
}

rule file_351_1_0 {
	meta:
		name = "__FindPESection"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 48 3C 03 C8 0F B7 41 14 53 56 0F B7 71 06 33 D2 57 8D 44 08 18 85 F6 76 1B 8B 7D 0C 8B 48 0C 3B F9 72 09 8B 58 08 03 D9 3B FB 72 0A 42 83 C0 28 3B D6 72 E8 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_351_2_0 {
	meta:
		name = "__IsNonwritableInCurrentImage"
		size = 189
		refs = "0008 __sehtable$__IsNonwritableInCurrentImage 000d __except_handler4 001f ___security_cookie 003d ___ImageBase 0042 __ValidateImageBase 005c __FindPESection"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 55 8B 45 08 2D ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 3B 8B 40 24 C1 E8 1F F7 D0 83 E0 01 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 8B 45 EC 8B 08 8B 01 33 D2 3D 05 00 00 C0 0F 94 C2 8B C2 C3 8B 65 E8 C7 45 FC FE FF FF FF 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "___libm_sse2_log"
		size = 550
		refs = "0024 _emask 002c _One 0034 _Magic 003c _hi_mask 005a _B_Tbl 0062 _T_Tbl 00c4 _coeff 00f0 _LOG_2 00fc _place_LR 0146 _Zero 019a _Infs 01c9 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 A1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 15 C9 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 33 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "_strnlen"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 45 0C 76 0F 8B 4D 08 80 39 00 74 07 40 41 3B 45 0C 72 F4 5D C3 }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "__wcsdup"
		size = 88
		refs = "0017 _wcslen 0022 _calloc 0035 _wcscpy_s 0046 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 5D 08 75 04 33 C0 EB 44 56 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 46 6A 02 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 3B FB 74 22 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__putw"
		size = 177
		refs = "0003 __sehtable$__putw 0008 __SEH_prolog4 0027 __errno 0037 __invalid_parameter 0048 __lock_file 006f __flsbuf 007d _ferror 00a1 __SEH_epilog4 00ab __unlock_file"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E4 04 00 00 00 8D 7D 08 33 C0 8B 75 0C 33 DB 3B F3 0F 95 C0 3B C3 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5D 89 75 0C 56 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 E4 FF 4D E4 85 C0 74 21 FF 4E 04 78 0A 8B 06 8A 0F 88 08 FF 06 EB 0C 56 0F BE 07 50 E8 ?? ?? ?? ?? 59 59 47 89 7D DC EB D5 56 E8 ?? ?? ?? ?? 59 85 C0 74 05 83 C8 FF EB 03 8B 45 08 89 45 E0 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_356_2_0 {
	meta:
		name = "__wstripquote"
		size = 91
		refs = "000c _wcslen 0014 __calloc_crt 0051 _free"
	strings:
		$1 = { 8B FF 53 56 8B F0 6A 02 56 33 DB E8 ?? ?? ?? ?? 59 40 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 38 0F B7 0E 8B D0 66 85 C9 74 27 66 83 F9 22 75 05 46 46 43 EB 07 66 89 08 40 40 46 46 0F B7 0E 66 85 C9 75 E6 85 DB 74 09 33 C9 66 89 08 8B C2 EB 09 52 E8 ?? ?? ?? ?? 59 33 C0 5E 5B C3 }
	condition:
		$1
}

rule file_356_3_0 {
	meta:
		name = "__wtempnam"
		size = 585
		refs = "0003 __sehtable$__wtempnam 0008 __SEH_prolog4 001a __mtinitlocknum 0028 ??_C@_17DDHKMLLK@?$AAT?$AAM?$AAP?$AA?$AA@ 0032 __wdupenv_s 004a __invoke_watson 005f __waccess_s 0084 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0095 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00a2 _wcslen 00be _calloc 00dd _wcscat_s 0165 __lock 0173 __old_pfxlen 017b __tempoff 0191 __errno 01b5 _free 01da __ultow_s 0238 __SEH_epilog4 0243 __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D DC 89 5D D0 89 5D E4 6A 02 E8 ?? ?? ?? ?? 59 85 C0 0F 84 10 02 00 00 68 ?? ?? ?? ?? 53 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 3B F3 74 16 83 FE 16 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 3B F3 75 19 39 5D E4 74 14 53 FF 75 E4 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 8B 7D E4 EB 2B 8B 7D 08 3B FB 74 0D 53 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 17 53 BF ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 BF ?? ?? ?? ?? 39 5D 0C 74 0C FF 75 0C E8 ?? ?? ?? ?? 59 89 45 DC 57 E8 ?? ?? ?? ?? 8B 4D DC 8D 44 08 0C 89 45 E0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 D4 3B F3 0F 84 51 01 00 00 33 C0 66 89 06 57 FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 59 8D 44 47 FE 0F B7 00 66 83 F8 5C 74 28 66 83 F8 2F 74 22 68 ?? ?? ?? ?? FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 5D 0C 74 20 FF 75 0C FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 8D 04 46 89 45 D8 6A 02 E8 ?? ?? ?? ?? 59 59 89 5D FC 8B 45 DC 39 05 ?? ?? ?? ?? 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 DC E8 ?? ?? ?? ?? 8B 38 FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B 45 DC 3D FF FF FF 7F 76 15 E8 ?? ?? ?? ?? 89 38 56 E8 ?? ?? ?? ?? 59 33 F6 89 75 D4 EB 56 6A 0A 8B 45 D8 2B C6 D1 F8 8B 4D E0 2B C8 51 FF 75 D8 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 89 18 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 91 E8 ?? ?? ?? ?? 83 38 0D 74 87 E8 ?? ?? ?? ?? 89 38 C7 45 FC FE FF FF FF E8 1D 00 00 00 FF 75 E4 E8 ?? ?? ?? ?? FF 75 D0 E8 ?? ?? ?? ?? 59 59 8B C6 E8 ?? ?? ?? ?? C3 8B 75 D4 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__copysign"
		size = 40
	strings:
		$1 = { 8B FF 55 8B EC 51 51 D9 EE 8B 45 08 DD 5D F8 89 45 F8 8B 45 14 33 45 0C 25 FF FF FF 7F 33 45 14 89 45 FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_357_1_0 {
	meta:
		name = "__chgsign"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 51 51 D9 EE 8B 45 08 DD 5D F8 89 45 F8 8B 45 0C 8B C8 F7 D1 33 C8 81 E1 FF FF FF 7F F7 D0 33 C8 89 4D FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_357_2_0 {
	meta:
		name = "__scalb"
		size = 26
		refs = "0011 _ldexp"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_357_3_0 {
	meta:
		name = "__logb"
		size = 233
		refs = "0014 __ctrlfp 0034 __sptype 0054 __handle_qnan1 0071 __real@3ff0000000000000 0087 __except1 009e __d_inf 00c5 __decomp"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 59 59 8B 4D 0E 8B F8 B8 F0 7F 00 00 23 C8 66 3B C8 75 65 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 85 C0 7E 2D 83 F8 02 7E 1D 83 F8 03 75 23 DD 45 08 57 51 51 DD 1C 24 6A 25 E8 ?? ?? ?? ?? 83 C4 10 E9 85 00 00 00 56 57 E8 ?? ?? ?? ?? 59 59 EB 77 DD 45 08 57 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 25 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 55 D9 EE DC 5D 08 DF E0 F6 C4 44 7A 1C DD 05 ?? ?? ?? ?? 57 83 EC 10 D9 E0 DD 5C 24 08 DD 45 08 DD 1C 24 6A 25 6A 04 EB CE DD 45 08 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 FC DD D8 48 89 45 0C DB 45 0C 56 57 DD 5D 08 E8 ?? ?? ?? ?? 83 C4 14 DD 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_357_4_0 {
	meta:
		name = "__nextafter"
		size = 680
		refs = "001c __ctrlfp 00a6 __except2 01d7 __decomp 01ed __set_exp 029c __handle_qnan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 EE 53 56 DD 5D F4 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 7D 0C 59 89 45 FC 8B 45 0E 59 B9 F0 7F 00 00 8B D1 23 C1 66 3B C2 8B 55 08 74 10 8B 45 16 23 C1 8B D9 66 3B C3 0F 85 82 00 00 00 8B 5D 0E B8 F8 7F 00 00 23 D8 8B F1 66 3B DE 75 0C F7 C7 FF FF 07 00 75 1F 85 D2 75 1B 8B 75 16 23 F0 8B F9 66 3B F7 75 3D F7 45 14 FF FF 07 00 75 06 83 7D 10 00 74 2E FF 75 FC DD 45 08 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 F1 01 00 00 8B F8 66 3B DF 0F 84 C9 01 00 00 66 3B F0 0F 84 C0 01 00 00 8B 7D 0C BE FF FF 00 00 DD 45 08 D9 C0 DD 45 10 DD E1 DF E0 DD D9 F6 C4 44 7A 17 56 DD D9 FF 75 FC DD D8 E8 ?? ?? ?? ?? DD 45 08 59 59 E9 AB 01 00 00 D9 EE D9 C0 DD EB DF E0 F6 C4 44 7A 21 D9 C9 C7 45 F4 01 00 00 00 D8 D2 DF E0 F6 C4 41 75 06 83 65 F8 00 EB 07 C7 45 F8 00 00 00 80 D9 C9 D8 D2 DF E0 F6 C4 05 7A 0D D9 C9 D8 D2 DF E0 F6 C4 05 7B 16 D9 C9 D8 D2 DF E0 F6 C4 41 75 26 D9 C9 D8 D2 DF E0 F6 C4 41 75 19 DD D9 8D 42 FF DD D9 89 45 F4 DD D8 89 7D F8 85 D2 75 4F 4F 89 7D F8 EB 49 D9 C9 D8 D2 DF E0 F6 C4 05 7A 0D D9 C9 D8 D2 DF E0 F6 C4 41 74 16 D9 C9 D8 DA DF E0 F6 C4 41 75 21 DE D9 DF E0 F6 C4 05 7A 1C EB 06 DD D9 DD D9 DD D8 8D 42 01 89 45 F4 89 7D F8 85 C0 75 0A 47 EB B9 DD D9 DD D8 8B 45 F4 8B 55 F8 8B FA C1 EF 10 85 F9 75 56 F7 C2 FF FF 0F 00 75 04 85 C0 74 4A DD 45 F4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 12 E9 91 FE FF FF 81 FA 00 00 F0 7F 75 04 85 C0 74 0C 81 FA 00 00 F0 FF 75 4E 85 C0 75 4A DD 45 F4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 11 E9 2F FE FF FF 56 FF 75 FC E8 ?? ?? ?? ?? DD 45 F4 59 59 EB 1D FF 75 FC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_357_5_0 {
	meta:
		name = "__finite"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC B8 F0 7F 00 00 8B C8 66 23 4D 0E 33 D2 66 3B C8 0F 95 C2 8B C2 5D C3 }
	condition:
		$1
}

rule file_357_6_0 {
	meta:
		name = "__isnan"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0E B8 F8 7F 00 00 23 C8 8D 50 F8 66 3B CA 75 0F F7 45 0C FF FF 07 00 75 0B 83 7D 08 00 75 05 66 3B C8 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_357_7_0 {
	meta:
		name = "__fpclass"
		size = 148
		refs = "001f __sptype"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0E B9 F0 7F 00 00 8B D0 23 D1 66 3B D1 75 2D DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 14 48 74 0C 48 74 05 33 C0 40 5D C3 6A 02 EB 02 6A 04 58 5D C3 B8 00 02 00 00 5D C3 25 00 80 00 00 8B C8 66 85 D2 75 1B F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 0C F7 D8 1B C0 83 E0 90 83 E8 80 5D C3 D9 EE DC 5D 08 DF E0 F6 C4 44 8B C1 7A 0C F7 D8 1B C0 83 E0 E0 83 C0 40 5D C3 F7 D8 1B C0 25 08 FF FF FF 05 00 01 00 00 5D C3 }
	condition:
		$1
}

rule file_358_3_0 {
	meta:
		name = "_write_char"
		size = 21
		refs = "0005 __putch_nolock"
	strings:
		$1 = { 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 03 09 06 C3 FF 06 C3 }
	condition:
		$1
}

rule file_358_4_0 {
	meta:
		name = "_write_multi_char"
		size = 35
		refs = "0011 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 10 8A 45 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 74 06 83 7D 0C 00 7F EA 5E 5D C3 }
	condition:
		$1
}

rule file_358_5_0 {
	meta:
		name = "_write_string"
		size = 56
		refs = "0013 _write_char 001e __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F0 8B F9 EB 21 8A 07 FF 4D 08 E8 ?? ?? ?? ?? 47 83 3E FF 75 11 E8 ?? ?? ?? ?? 83 38 2A 75 0D B0 3F E8 ?? ?? ?? ?? 83 7D 08 00 7F D9 5F 5E 5D C3 }
	condition:
		$1
}

rule file_358_8_0 {
	meta:
		name = "_get_short_arg"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 66 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_358_9_0 {
	meta:
		name = "__vcprintf_s_l"
		size = 2904
		refs = "000c ___security_cookie 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 __errno 0073 __invalid_parameter 00de ___lookuptable_s 0118 $LN264 033f __isleadbyte_l 0356 _write_char 047c ___wnullstring 04e3 _wctomb_s 056a ___nullstring 0576 _strlen 05df __get_printf_count_output 0686 __malloc_crt 06f4 __cfltcvt_tab 06f9 __decode_pointer 08b9 __aulldvrm 09b6 _write_multi_char 09cf _write_string 0aa0 _free 0b32 @__security_check_cookie@4 0b38 $LN241 0b3c $LN131 0b40 $LN130 0b44 $LN122 0b48 $LN118 0b4c $LN117 0b50 $LN113 0b54 $LN97"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 74 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 33 F6 57 8B 7D 10 FF 75 0C 8D 8D A4 FD FF FF 89 BD E0 FD FF FF 89 B5 B4 FD FF FF 89 B5 F0 FD FF FF 89 B5 C4 FD FF FF 89 B5 E8 FD FF FF 89 B5 C8 FD FF FF 89 B5 BC FD FF FF 89 B5 C0 FD FF FF E8 ?? ?? ?? ?? 3B DE 75 33 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 BD B0 FD FF FF 00 74 0A 8B 85 AC FD FF FF 83 60 70 FD 83 C8 FF E9 94 0A 00 00 8A 13 89 B5 DC FD FF FF 89 B5 E4 FD FF FF 89 B5 CC FD FF FF 89 B5 B8 FD FF FF 88 95 EF FD FF FF 84 D2 0F 84 53 0A 00 00 43 39 B5 DC FD FF FF 89 9D D4 FD FF FF 0F 8C 29 0A 00 00 8A C2 2C 20 3C 58 77 0F 0F BE C2 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 8B 8D CC FD FF FF 6B C0 09 0F B6 84 08 ?? ?? ?? ?? C1 E8 04 89 85 CC FD FF FF 83 F8 08 0F 84 56 FF FF FF 83 F8 07 0F 87 9D 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D E8 FD FF FF FF 89 85 9C FD FF FF 89 85 BC FD FF FF 89 85 C4 FD FF FF 89 85 C8 FD FF FF 89 85 F0 FD FF FF 89 85 C0 FD FF FF E9 64 09 00 00 0F BE C2 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 48 48 74 15 83 E8 03 0F 85 45 09 00 00 83 8D F0 FD FF FF 08 E9 39 09 00 00 83 8D F0 FD FF FF 04 E9 2D 09 00 00 83 8D F0 FD FF FF 01 E9 21 09 00 00 81 8D F0 FD FF FF 80 00 00 00 E9 12 09 00 00 83 8D F0 FD FF FF 02 E9 06 09 00 00 80 FA 2A 75 2B 8B 07 83 C7 04 89 BD E0 FD FF FF 89 85 C4 FD FF FF 85 C0 0F 8D E8 08 00 00 83 8D F0 FD FF FF 04 F7 9D C4 FD FF FF E9 D6 08 00 00 8B 85 C4 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 C4 FD FF FF E9 BB 08 00 00 83 A5 E8 FD FF FF 00 E9 AF 08 00 00 80 FA 2A 75 25 8B 07 83 C7 04 89 BD E0 FD FF FF 89 85 E8 FD FF FF 85 C0 0F 8D 91 08 00 00 83 8D E8 FD FF FF FF E9 85 08 00 00 8B 85 E8 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 E8 FD FF FF E9 6A 08 00 00 80 FA 49 74 5A 80 FA 68 74 49 80 FA 6C 74 18 80 FA 77 0F 85 52 08 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 43 08 00 00 8B 85 D4 FD FF FF 80 38 6C 75 15 FF 85 D4 FD FF FF 81 8D F0 FD FF FF 00 10 00 00 E9 23 08 00 00 83 8D F0 FD FF FF 10 E9 17 08 00 00 83 8D F0 FD FF FF 20 E9 0B 08 00 00 8B 8D D4 FD FF FF 8A 01 3C 36 75 1D 80 79 01 34 75 17 41 41 81 8D F0 FD FF FF 00 80 00 00 89 8D D4 FD FF FF E9 E2 07 00 00 3C 33 75 1D 80 79 01 32 75 17 41 41 81 A5 F0 FD FF FF FF 7F FF FF 89 8D D4 FD FF FF E9 C1 07 00 00 3C 64 0F 84 B9 07 00 00 3C 69 0F 84 B1 07 00 00 3C 6F 0F 84 A9 07 00 00 3C 75 0F 84 A1 07 00 00 3C 78 0F 84 99 07 00 00 3C 58 0F 84 91 07 00 00 33 DB 89 9D CC FD FF FF EB 02 33 DB 8D 85 A4 FD FF FF 50 0F B6 C2 50 89 9D C0 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 2D 8A 85 EF FD FF FF 8D B5 DC FD FF FF E8 ?? ?? ?? ?? 8B 85 D4 FD FF FF 8A 00 FF 85 D4 FD FF FF 88 85 EF FD FF FF 84 C0 0F 84 5D 07 00 00 8A 85 EF FD FF FF 8D B5 DC FD FF FF E8 ?? ?? ?? ?? E9 26 07 00 00 0F BE C2 83 F8 64 0F 8F E8 01 00 00 0F 84 79 02 00 00 83 F8 53 0F 8F F0 00 00 00 0F 84 81 00 00 00 83 E8 41 74 10 48 48 74 59 48 48 74 08 48 48 0F 85 86 05 00 00 80 C2 20 C7 85 9C FD FF FF 01 00 00 00 88 95 EF FD FF FF 83 8D F0 FD FF FF 40 83 BD E8 FD FF FF 00 8D 9D F4 FD FF FF B8 00 02 00 00 89 9D D8 FD FF FF 89 85 98 FD FF FF 0F 8D 47 02 00 00 C7 85 E8 FD FF FF 06 00 00 00 E9 A0 02 00 00 F7 85 F0 FD FF FF 30 08 00 00 0F 85 96 00 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 87 00 00 00 F7 85 F0 FD FF FF 30 08 00 00 75 0A 81 8D F0 FD FF FF 00 08 00 00 8B 8D E8 FD FF FF 83 F9 FF 75 05 B9 FF FF FF 7F 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD E0 FD FF FF 8B 7F FC 89 BD D8 FD FF FF 0F 84 AB 04 00 00 85 FF 75 0C 8B 3D ?? ?? ?? ?? 89 BD D8 FD FF FF C7 85 C0 FD FF FF 01 00 00 00 8B C7 E9 80 04 00 00 83 E8 58 0F 84 DD 02 00 00 48 48 74 7A 83 E8 07 0F 84 28 FF FF FF 48 48 0F 85 93 04 00 00 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD E0 FD FF FF 74 30 0F B7 47 FC 50 68 00 02 00 00 8D 85 F4 FD FF FF 50 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 1F C7 85 BC FD FF FF 01 00 00 00 EB 13 8A 47 FC 88 85 F4 FD FF FF C7 85 E4 FD FF FF 01 00 00 00 8D 85 F4 FD FF FF 89 85 D8 FD FF FF E9 2A 04 00 00 8B 07 83 C7 04 89 BD E0 FD FF FF 85 C0 74 3C 8B 48 04 85 C9 74 35 F7 85 F0 FD FF FF 00 08 00 00 0F BF 00 89 8D D8 FD FF FF 74 14 99 2B C2 D1 F8 C7 85 C0 FD FF FF 01 00 00 00 E9 E5 03 00 00 83 A5 C0 FD FF FF 00 E9 D9 03 00 00 A1 ?? ?? ?? ?? 89 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 59 E9 C2 03 00 00 83 F8 70 0F 8F 00 02 00 00 0F 84 E4 01 00 00 83 F8 65 0F 8C B0 03 00 00 83 F8 67 0F 8E 34 FE FF FF 83 F8 69 74 71 83 F8 6E 74 28 83 F8 6F 0F 85 94 03 00 00 F6 85 F0 FD FF FF 80 C7 85 E4 FD FF FF 08 00 00 00 74 61 81 8D F0 FD FF FF 00 02 00 00 EB 55 8B 37 83 C7 04 89 BD E0 FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 F7 04 00 00 F6 85 F0 FD FF FF 20 74 0C 66 8B 85 DC FD FF FF 66 89 06 EB 08 8B 85 DC FD FF FF 89 06 C7 85 BC FD FF FF 01 00 00 00 E9 79 04 00 00 83 8D F0 FD FF FF 40 C7 85 E4 FD FF FF 0A 00 00 00 8B 8D F0 FD FF FF F7 C1 00 80 00 00 0F 84 AE 01 00 00 8B 07 8B 57 04 83 C7 08 E9 DA 01 00 00 75 15 80 BD EF FD FF FF 67 75 5D C7 85 E8 FD FF FF 01 00 00 00 EB 51 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 81 BD E8 FD FF FF A3 00 00 00 7E 37 8B B5 E8 FD FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 59 89 85 B8 FD FF FF 85 C0 74 10 8B D8 89 85 D8 FD FF FF 89 B5 98 FD FF FF EB 0A C7 85 E8 FD FF FF A3 00 00 00 8B 07 83 C7 08 89 85 8C FD FF FF 8B 47 FC 89 85 90 FD FF FF 8D 85 A4 FD FF FF 50 FF B5 9C FD FF FF 0F BE 85 EF FD FF FF FF B5 E8 FD FF FF 89 BD E0 FD FF FF 50 FF B5 98 FD FF FF 8D 85 8C FD FF FF 53 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B B5 F0 FD FF FF 83 C4 1C 81 E6 80 00 00 00 74 21 83 BD E8 FD FF FF 00 75 18 8D 85 A4 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 BD EF FD FF FF 67 75 1C 85 F6 75 18 8D 85 A4 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3B 2D 75 11 81 8D F0 FD FF FF 00 01 00 00 43 89 9D D8 FD FF FF 53 E9 02 FE FF FF C7 85 E8 FD FF FF 08 00 00 00 C7 85 B4 FD FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 B2 FC FF FF 48 48 0F 84 84 FE FF FF 83 E8 03 0F 85 A5 01 00 00 C7 85 B4 FD FF FF 27 00 00 00 F6 85 F0 FD FF FF 80 C7 85 E4 FD FF FF 10 00 00 00 0F 84 64 FE FF FF 8A 85 B4 FD FF FF 04 51 C6 85 D0 FD FF FF 30 88 85 D1 FD FF FF C7 85 C8 FD FF FF 02 00 00 00 E9 40 FE FF FF F7 C1 00 10 00 00 0F 85 46 FE FF FF 83 C7 04 F6 C1 20 74 18 89 BD E0 FD FF FF F6 C1 40 74 06 0F BF 47 FC EB 04 0F B7 47 FC 99 EB 13 8B 47 FC F6 C1 40 74 03 99 EB 02 33 D2 89 BD E0 FD FF FF F6 C1 40 74 1B 85 D2 7F 17 7C 04 85 C0 73 11 F7 D8 83 D2 00 F7 DA 81 8D F0 FD FF FF 00 01 00 00 F7 85 F0 FD FF FF 00 90 00 00 8B DA 8B F0 75 02 33 DB 83 BD E8 FD FF FF 00 7D 0C C7 85 E8 FD FF FF 01 00 00 00 EB 1A 83 A5 F0 FD FF FF F7 B8 00 02 00 00 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 8B C6 0B C3 75 06 21 85 C8 FD FF FF 8D 7D F3 8B 85 E8 FD FF FF FF 8D E8 FD FF FF 85 C0 7F 06 8B C6 0B C3 74 2D 8B 85 E4 FD FF FF 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 98 FD FF FF 8B F0 8B DA 7E 06 03 8D B4 FD FF FF 88 0F 4F EB BD 8D 45 F3 2B C7 47 F7 85 F0 FD FF FF 00 02 00 00 89 85 E4 FD FF FF 89 BD D8 FD FF FF 74 50 85 C0 74 05 80 3F 30 74 47 4F 89 BD D8 FD FF FF C6 07 30 40 EB 34 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B C7 D1 F8 EB 21 85 FF 75 0C 8B 3D ?? ?? ?? ?? 89 BD D8 FD FF FF 8B C7 EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B C7 89 85 E4 FD FF FF 83 BD BC FD FF FF 00 0F 85 3B 01 00 00 8B 85 F0 FD FF FF A8 40 74 32 A9 00 01 00 00 74 09 C6 85 D0 FD FF FF 2D EB 18 A8 01 74 09 C6 85 D0 FD FF FF 2B EB 0B A8 02 74 11 C6 85 D0 FD FF FF 20 C7 85 C8 FD FF FF 01 00 00 00 8B 9D C4 FD FF FF 2B 9D E4 FD FF FF 2B 9D C8 FD FF FF F6 85 F0 FD FF FF 0C 75 10 53 6A 20 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 FF B5 C8 FD FF FF 8D 85 DC FD FF FF 8D 8D D0 FD FF FF E8 ?? ?? ?? ?? F6 85 F0 FD FF FF 08 59 74 19 F6 85 F0 FD FF FF 04 75 10 53 6A 30 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 83 BD C0 FD FF FF 00 8B BD E4 FD FF FF 74 56 85 FF 7E 52 8B B5 D8 FD FF FF 0F B7 06 50 6A 06 8D 45 F4 50 8D 85 A0 FD FF FF 4F 46 50 46 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 23 39 85 A0 FD FF FF 74 1B FF B5 A0 FD FF FF 8D 85 DC FD FF FF 8D 4D F4 E8 ?? ?? ?? ?? 59 85 FF 75 BF EB 1C 83 8D DC FD FF FF FF EB 13 8B 8D D8 FD FF FF 57 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 83 BD DC FD FF FF 00 7C 19 F6 85 F0 FD FF FF 04 74 10 53 6A 20 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 83 BD B8 FD FF FF 00 74 13 FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 83 A5 B8 FD FF FF 00 59 8B BD E0 FD FF FF 8B 85 D4 FD FF FF 8A 00 88 85 EF FD FF FF 84 C0 74 35 8B 9D D4 FD FF FF 33 F6 8A D0 E9 EA F5 FF FF E8 ?? ?? ?? ?? 53 53 53 53 53 E9 8A F5 FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E9 79 F5 FF FF 33 F6 39 B5 CC FD FF FF 74 0D 83 BD CC FD FF FF 07 0F 85 52 F5 FF FF 80 BD B0 FD FF FF 00 74 0A 8B 85 AC FD FF FF 83 60 70 FD 8B 85 DC FD FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "_cmpResult"
		size = 18
	strings:
		$1 = { 85 C0 74 0D 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 }
	condition:
		$1
}

rule file_359_1_0 {
	meta:
		name = "_cmpBYTE"
		size = 24
	strings:
		$1 = { 0F B6 00 0F B6 09 2B C1 74 0D 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 }
	condition:
		$1
}

rule file_359_2_0 {
	meta:
		name = "_cmpWORD"
		size = 64
	strings:
		$1 = { 66 8B 06 66 3B 01 74 35 0F B6 11 0F B6 C0 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 1C 0F B6 46 01 0F B6 49 01 2B C1 74 10 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_359_3_0 {
	meta:
		name = "_cmpDWORD"
		size = 120
	strings:
		$1 = { 8B 06 3B 01 74 6F 0F B6 11 0F B6 C0 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 56 0F B6 46 01 0F B6 51 01 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 39 0F B6 46 02 0F B6 51 02 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 1C 0F B6 46 03 0F B6 49 03 2B C1 74 10 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_359_4_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 5268
		refs = "0482 $LN1372 1414 $LN61 1418 $LN1182 141c $LN1190 1420 $LN1198 1424 $LN1174 1428 $LN1181 142c $LN1189 1430 $LN1197 1434 $LN1173 1438 $LN1180 143c $LN1188 1440 $LN1196 1444 $LN1172 1448 $LN1179 144c $LN1187 1450 $LN1195 1454 $LN1171 1458 $LN1178 145c $LN1186 1460 $LN1194 1464 $LN1170 1468 $LN1177 146c $LN1185 1470 $LN1193 1474 $LN1169 1478 $LN1176 147c $LN1184 1480 $LN1192 1484 $LN60 1488 $LN45 148c $LN30 1490 $LN15"
	strings:
		$1 = { 8B FF 56 57 8B F8 E9 5E 04 00 00 8B 01 3B 02 74 78 0F B6 F0 0F B6 02 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 12 08 00 00 0F B6 71 01 0F B6 42 01 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F3 07 00 00 0F B6 71 02 0F B6 42 02 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D4 07 00 00 0F B6 71 03 0F B6 42 03 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 AD 07 00 00 8B 41 04 3B 42 04 74 79 0F B6 F0 0F B6 42 04 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 87 07 00 00 0F B6 71 05 0F B6 42 05 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 68 07 00 00 0F B6 71 06 0F B6 42 06 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 49 07 00 00 0F B6 71 07 0F B6 42 07 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 22 07 00 00 8B 41 08 3B 42 08 74 79 0F B6 F0 0F B6 42 08 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 FC 06 00 00 0F B6 71 09 0F B6 42 09 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 DD 06 00 00 0F B6 71 0A 0F B6 42 0A 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BE 06 00 00 0F B6 71 0B 0F B6 42 0B 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 97 06 00 00 8B 41 0C 3B 42 0C 74 79 0F B6 F0 0F B6 42 0C 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 71 06 00 00 0F B6 71 0D 0F B6 42 0D 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 52 06 00 00 0F B6 71 0E 0F B6 42 0E 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 33 06 00 00 0F B6 71 0F 0F B6 42 0F 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 0C 06 00 00 8B 41 10 3B 42 10 74 79 0F B6 F0 0F B6 42 10 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E6 05 00 00 0F B6 71 11 0F B6 42 11 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 C7 05 00 00 0F B6 71 12 0F B6 42 12 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A8 05 00 00 0F B6 71 13 0F B6 42 13 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 81 05 00 00 8B 41 14 3B 42 14 74 79 0F B6 F0 0F B6 42 14 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5B 05 00 00 0F B6 71 15 0F B6 42 15 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3C 05 00 00 0F B6 71 16 0F B6 42 16 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 1D 05 00 00 0F B6 71 17 0F B6 42 17 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F6 04 00 00 8B 41 18 3B 42 18 74 79 0F B6 F0 0F B6 42 18 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D0 04 00 00 0F B6 71 19 0F B6 42 19 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B1 04 00 00 0F B6 71 1A 0F B6 42 1A 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 92 04 00 00 0F B6 71 1B 0F B6 42 1B 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 6B 04 00 00 8B 41 1C 3B 42 1C 74 79 0F B6 F0 0F B6 42 1C 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 45 04 00 00 0F B6 71 1D 0F B6 42 1D 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 26 04 00 00 0F B6 71 1E 0F B6 42 1E 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 07 04 00 00 0F B6 71 1F 0F B6 42 1F 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 E0 03 00 00 83 C1 20 83 C2 20 83 EF 20 83 FF 20 0F 83 99 FB FF FF 03 CF 03 D7 83 FF 1F 0F 87 BF 03 00 00 FF 24 BD ?? ?? ?? ?? 8B 41 E4 3B 42 E4 74 7A 0F B6 42 E4 0F B6 71 E4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 93 03 00 00 0F B6 71 E5 0F B6 42 E5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 74 03 00 00 0F B6 71 E6 0F B6 42 E6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 55 03 00 00 0F B6 71 E7 0F B6 42 E7 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 2E 03 00 00 8B 41 E8 3B 42 E8 74 79 0F B6 F0 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 08 03 00 00 0F B6 71 E9 0F B6 42 E9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E9 02 00 00 0F B6 71 EA 0F B6 42 EA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 CA 02 00 00 0F B6 71 EB 0F B6 42 EB 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 A3 02 00 00 8B 41 EC 3B 42 EC 74 79 0F B6 F0 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 7D 02 00 00 0F B6 71 ED 0F B6 42 ED 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5E 02 00 00 0F B6 71 EE 0F B6 42 EE 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3F 02 00 00 0F B6 71 EF 0F B6 42 EF 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 18 02 00 00 8B 41 F0 3B 42 F0 74 79 0F B6 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F2 01 00 00 0F B6 71 F1 0F B6 42 F1 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D3 01 00 00 0F B6 71 F2 0F B6 42 F2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B4 01 00 00 0F B6 71 F3 0F B6 42 F3 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 8D 01 00 00 8B 41 F4 3B 42 F4 74 79 0F B6 F0 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 67 01 00 00 0F B6 71 F5 0F B6 42 F5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 48 01 00 00 0F B6 71 F6 0F B6 42 F6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 29 01 00 00 0F B6 71 F7 0F B6 42 F7 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 02 01 00 00 8B 41 F8 3B 42 F8 74 79 0F B6 F0 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 DC 00 00 00 0F B6 71 F9 0F B6 42 F9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BD 00 00 00 0F B6 71 FA 0F B6 42 FA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 9E 00 00 00 0F B6 71 FB 0F B6 42 FB 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 75 7B 8B 41 FC 3B 42 FC 74 6B 0F B6 F0 0F B6 42 FC 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 59 0F B6 71 FD 0F B6 42 FD 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 3E 0F B6 71 FE 0F B6 42 FE 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 23 0F B6 41 FF 0F B6 4A FF 2B C1 74 11 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 EB 02 33 C0 85 C0 75 02 33 C0 5F 5E C3 8B 41 E3 3B 42 E3 74 6D 0F B6 F0 0F B6 42 E3 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 DB 0F B6 71 E4 0F B6 42 E4 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 C0 0F B6 71 E5 0F B6 42 E5 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 A5 0F B6 71 E6 0F B6 42 E6 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 75 82 8B 41 E7 3B 42 E7 74 7A 0F B6 42 E7 0F B6 71 E7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5B FF FF FF 0F B6 71 E8 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3C FF FF FF 0F B6 71 E9 0F B6 42 E9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 1D FF FF FF 0F B6 71 EA 0F B6 42 EA 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F6 FE FF FF 8B 41 EB 3B 42 EB 74 79 0F B6 F0 0F B6 42 EB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D0 FE FF FF 0F B6 71 EC 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B1 FE FF FF 0F B6 71 ED 0F B6 42 ED 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 92 FE FF FF 0F B6 71 EE 0F B6 42 EE 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 6B FE FF FF 8B 41 EF 3B 42 EF 74 79 0F B6 F0 0F B6 42 EF 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 45 FE FF FF 0F B6 71 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 26 FE FF FF 0F B6 71 F1 0F B6 42 F1 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 07 FE FF FF 0F B6 71 F2 0F B6 42 F2 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 E0 FD FF FF 8B 41 F3 3B 42 F3 74 79 0F B6 F0 0F B6 42 F3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BA FD FF FF 0F B6 71 F4 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 9B FD FF FF 0F B6 71 F5 0F B6 42 F5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 7C FD FF FF 0F B6 71 F6 0F B6 42 F6 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 55 FD FF FF 8B 41 F7 3B 42 F7 74 79 0F B6 F0 0F B6 42 F7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 2F FD FF FF 0F B6 71 F8 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 10 FD FF FF 0F B6 71 F9 0F B6 42 F9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F1 FC FF FF 0F B6 71 FA 0F B6 42 FA 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 CA FC FF FF 8B 41 FB 3B 42 FB 74 79 0F B6 F0 0F B6 42 FB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A4 FC FF FF 0F B6 71 FC 0F B6 42 FC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 85 FC FF FF 0F B6 71 FD 0F B6 42 FD 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 66 FC FF FF 0F B6 71 FE 0F B6 42 FE 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 3F FC FF FF 0F B6 41 FF 0F B6 4A FF 2B C1 0F 84 2F FC FF FF 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 E9 1D FC FF FF 8B 41 E2 3B 42 E2 74 79 0F B6 F0 0F B6 42 E2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F7 FB FF FF 0F B6 71 E3 0F B6 42 E3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D8 FB FF FF 0F B6 71 E4 0F B6 42 E4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B9 FB FF FF 0F B6 71 E5 0F B6 42 E5 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 92 FB FF FF 8B 41 E6 3B 42 E6 74 7A 0F B6 42 E6 0F B6 71 E6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 6B FB FF FF 0F B6 71 E7 0F B6 42 E7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 4C FB FF FF 0F B6 71 E8 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 2D FB FF FF 0F B6 71 E9 0F B6 42 E9 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 06 FB FF FF 8B 41 EA 3B 42 EA 74 79 0F B6 F0 0F B6 42 EA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E0 FA FF FF 0F B6 71 EB 0F B6 42 EB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 C1 FA FF FF 0F B6 71 EC 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A2 FA FF FF 0F B6 71 ED 0F B6 42 ED 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 7B FA FF FF 8B 41 EE 3B 42 EE 74 79 0F B6 F0 0F B6 42 EE 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 55 FA FF FF 0F B6 71 EF 0F B6 42 EF 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 36 FA FF FF 0F B6 71 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 17 FA FF FF 0F B6 71 F1 0F B6 42 F1 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F0 F9 FF FF 8B 41 F2 3B 42 F2 74 79 0F B6 F0 0F B6 42 F2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 CA F9 FF FF 0F B6 71 F3 0F B6 42 F3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 AB F9 FF FF 0F B6 71 F4 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 8C F9 FF FF 0F B6 71 F5 0F B6 42 F5 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 65 F9 FF FF 8B 41 F6 3B 42 F6 74 79 0F B6 F0 0F B6 42 F6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3F F9 FF FF 0F B6 71 F7 0F B6 42 F7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 20 F9 FF FF 0F B6 71 F8 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 01 F9 FF FF 0F B6 71 F9 0F B6 42 F9 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 DA F8 FF FF 8B 41 FA 3B 42 FA 74 79 0F B6 F0 0F B6 42 FA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B4 F8 FF FF 0F B6 71 FB 0F B6 42 FB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 95 F8 FF FF 0F B6 71 FC 0F B6 42 FC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 76 F8 FF FF 0F B6 71 FD 0F B6 42 FD 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 4F F8 FF FF 66 8B 41 FE 66 3B 42 FE 0F 84 3F F8 FF FF E9 }
	condition:
		$1
}

rule file_359_5_0 {
	meta:
		name = "_memcmp"
		size = 5760
		refs = "04ca $LN1307 1600 $LN132 1604 $LN103 1608 $LN88 160c $LN73 1610 $LN120 1614 $LN105 1618 $LN90 161c $LN75 1620 $LN122 1624 $LN107 1628 $LN92 162c $LN77 1630 $LN124 1634 $LN109 1638 $LN94 163c $LN79 1640 $LN126 1644 $LN111 1648 $LN96 164c $LN81 1650 $LN128 1654 $LN113 1658 $LN98 165c $LN83 1660 $LN130 1664 $LN115 1668 $LN100 166c $LN85 1670 $LN131 1674 $LN116 1678 $LN101 167c $LN86"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 10 8B C7 83 E8 00 0F 84 E5 15 00 00 48 0F 84 CD 15 00 00 48 0F 84 98 15 00 00 48 0F 84 49 15 00 00 48 0F 84 B9 14 00 00 8B 4D 0C 8B 45 08 53 6A 20 5A E9 72 04 00 00 8B 30 3B 31 74 7C 0F B6 30 0F B6 19 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 69 04 00 00 0F B6 70 01 0F B6 59 01 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 48 04 00 00 0F B6 70 02 0F B6 59 02 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 27 04 00 00 0F B6 70 03 0F B6 59 03 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 02 04 00 00 8B 70 04 3B 71 04 74 7E 0F B6 70 04 0F B6 59 04 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 D9 03 00 00 0F B6 70 05 0F B6 59 05 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 B8 03 00 00 0F B6 70 06 0F B6 59 06 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 97 03 00 00 0F B6 70 07 0F B6 59 07 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 72 03 00 00 8B 70 08 3B 71 08 74 7E 0F B6 70 08 0F B6 59 08 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 49 03 00 00 0F B6 70 09 0F B6 59 09 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 28 03 00 00 0F B6 70 0A 0F B6 59 0A 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 07 03 00 00 0F B6 70 0B 0F B6 59 0B 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 E2 02 00 00 8B 70 0C 3B 71 0C 74 7E 0F B6 70 0C 0F B6 59 0C 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 B9 02 00 00 0F B6 70 0D 0F B6 59 0D 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 98 02 00 00 0F B6 70 0E 0F B6 59 0E 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 77 02 00 00 0F B6 70 0F 0F B6 59 0F 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 52 02 00 00 8B 70 10 3B 71 10 74 7E 0F B6 59 10 0F B6 70 10 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 29 02 00 00 0F B6 70 11 0F B6 59 11 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 08 02 00 00 0F B6 70 12 0F B6 59 12 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 E7 01 00 00 0F B6 70 13 0F B6 59 13 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 C2 01 00 00 8B 70 14 3B 71 14 74 7E 0F B6 70 14 0F B6 59 14 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 99 01 00 00 0F B6 70 15 0F B6 59 15 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 78 01 00 00 0F B6 70 16 0F B6 59 16 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 57 01 00 00 0F B6 70 17 0F B6 59 17 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 32 01 00 00 8B 70 18 3B 71 18 74 7E 0F B6 70 18 0F B6 59 18 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 09 01 00 00 0F B6 70 19 0F B6 59 19 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 E8 00 00 00 0F B6 70 1A 0F B6 59 1A 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 C7 00 00 00 0F B6 70 1B 0F B6 59 1B 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 A2 00 00 00 8B 70 1C 3B 71 1C 74 72 0F B6 70 1C 0F B6 59 1C 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 7D 0F B6 70 1D 0F B6 59 1D 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 60 0F B6 70 1E 0F B6 59 1E 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 43 0F B6 70 1F 0F B6 59 1F 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 75 22 03 C2 03 CA 2B FA 3B FA 0F 83 86 FB FF FF 03 C7 03 CF 83 FF 1F 0F 87 DA 03 00 00 FF 24 BD ?? ?? ?? ?? 8B C6 E9 CE 03 00 00 8B 50 E4 3B 51 E4 74 71 0F B6 F2 0F B6 51 E4 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 D5 0F B6 70 E5 0F B6 51 E5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 B8 0F B6 70 E6 0F B6 51 E6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 9B 0F B6 70 E7 0F B6 51 E7 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 76 FF FF FF 8B 50 E8 3B 51 E8 74 7D 0F B6 F2 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 4E FF FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2D FF FF FF 0F B6 70 EA 0F B6 51 EA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0C FF FF FF 0F B6 70 EB 0F B6 51 EB 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 E7 FE FF FF 8B 50 EC 3B 51 EC 74 7D 0F B6 F2 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BF FE FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 9E FE FF FF 0F B6 70 EE 0F B6 51 EE 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7D FE FF FF 0F B6 70 EF 0F B6 51 EF 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 58 FE FF FF 8B 50 F0 3B 51 F0 74 7D 0F B6 F2 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 30 FE FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0F FE FF FF 0F B6 70 F2 0F B6 51 F2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 EE FD FF FF 0F B6 70 F3 0F B6 51 F3 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 C9 FD FF FF 8B 50 F4 3B 51 F4 74 7E 0F B6 51 F4 0F B6 70 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A0 FD FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7F FD FF FF 0F B6 70 F6 0F B6 51 F6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 5E FD FF FF 0F B6 70 F7 0F B6 51 F7 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 39 FD FF FF 8B 50 F8 3B 51 F8 74 7D 0F B6 F2 0F B6 51 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 11 FD FF FF 0F B6 70 F9 0F B6 51 F9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 F0 FC FF FF 0F B6 70 FA 0F B6 51 FA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 CF FC FF FF 0F B6 70 FB 0F B6 51 FB 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 AA FC FF FF 8B 50 FC 3B 51 FC 74 6F 0F B6 F2 0F B6 51 FC 2B F2 74 0F 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 75 36 0F B6 70 FD 0F B6 51 FD 2B F2 74 0F 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 75 1B 0F B6 70 FE 0F B6 51 FE 2B F2 74 13 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 74 04 8B C2 EB 1D 0F B6 40 FF 0F B6 49 FF 2B C1 74 11 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 EB 02 33 C0 85 C0 75 02 33 C0 5B E9 53 0D 00 00 8B 50 E3 3B 51 E3 74 7D 0F B6 F2 0F B6 51 E3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 FD FB FF FF 0F B6 70 E4 0F B6 51 E4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 DC FB FF FF 0F B6 70 E5 0F B6 51 E5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BB FB FF FF 0F B6 70 E6 0F B6 51 E6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 96 FB FF FF 8B 50 E7 3B 51 E7 74 7D 0F B6 F2 0F B6 51 E7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 6E FB FF FF 0F B6 70 E8 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 4D FB FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2C FB FF FF 0F B6 70 EA 0F B6 51 EA 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 07 FB FF FF 8B 50 EB 3B 51 EB 74 7D 0F B6 F2 0F B6 51 EB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 DF FA FF FF 0F B6 70 EC 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BE FA FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 9D FA FF FF 0F B6 70 EE 0F B6 51 EE 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 78 FA FF FF 8B 50 EF 3B 51 EF 74 7D 0F B6 F2 0F B6 51 EF 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 50 FA FF FF 0F B6 70 F0 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2F FA FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0E FA FF FF 0F B6 70 F2 0F B6 51 F2 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 E9 F9 FF FF 8B 50 F3 3B 51 F3 74 7D 0F B6 F2 0F B6 51 F3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 C1 F9 FF FF 0F B6 70 F4 0F B6 51 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A0 F9 FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7F F9 FF FF 0F B6 70 F6 0F B6 51 F6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 5A F9 FF FF 8B 50 F7 3B 51 F7 74 7E 0F B6 51 F7 0F B6 70 F7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 31 F9 FF FF 0F B6 70 F8 0F B6 51 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 10 F9 FF FF 0F B6 70 F9 0F B6 51 F9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 EF F8 FF FF 0F B6 70 FA 0F B6 51 FA 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 CA F8 FF FF 8B 50 FB 3B 51 FB 74 7D 0F B6 F2 0F B6 51 FB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A2 F8 FF FF 0F B6 70 FC 0F B6 51 FC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 81 F8 FF FF 0F B6 70 FD 0F B6 51 FD 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 60 F8 FF FF 0F B6 70 FE 0F B6 51 FE 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 3B F8 FF FF 0F B6 49 FF 0F B6 40 FF 2B C1 0F 84 00 FC FF FF 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 E9 EE FB FF FF 8B 50 E2 3B 51 E2 74 7D 0F B6 F2 0F B6 51 E2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 F1 F7 FF FF 0F B6 70 E3 0F B6 51 E3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 D0 F7 FF FF 0F B6 70 E4 0F B6 51 E4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 AF F7 FF FF 0F B6 70 E5 0F B6 51 E5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 8A F7 FF FF 8B 50 E6 3B 51 E6 74 7D 0F B6 F2 0F B6 51 E6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 62 F7 FF FF 0F B6 70 E7 0F B6 51 E7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 41 F7 FF FF 0F B6 70 E8 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 20 F7 FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 FB F6 FF FF 8B 50 EA 3B 51 EA 74 7D 0F B6 F2 0F B6 51 EA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 D3 F6 FF FF 0F B6 70 EB 0F B6 51 EB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 B2 F6 FF FF 0F B6 70 EC 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 91 F6 FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 6C F6 FF FF 8B 50 EE 3B 51 EE 74 7D 0F B6 F2 0F B6 51 EE 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 44 F6 FF FF 0F B6 70 EF 0F B6 51 EF 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 23 F6 FF FF 0F B6 70 F0 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 02 F6 FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 DD F5 FF FF 8B 50 F2 3B 51 F2 74 7D 0F B6 F2 0F B6 51 F2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 B5 F5 FF FF 0F B6 70 F3 0F B6 51 F3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 94 F5 FF FF 0F B6 70 F4 0F B6 51 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 73 F5 FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 4E F5 FF FF 8B 50 F6 3B 51 F6 74 7E 0F B6 51 F6 0F B6 70 F6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 25 F5 FF FF 0F B6 51 F7 0F B6 70 F7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 04 F5 FF FF 0F B6 51 F8 0F B6 70 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 E3 F4 FF FF 0F B6 51 F9 0F B6 70 F9 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "_vscan_fn"
		size = 106
		refs = "000b _strlen 0017 __errno 0027 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 57 56 E8 ?? ?? ?? ?? 33 FF 59 3B F7 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 39 7D 0C 74 DE B9 FF FF FF 7F C7 45 EC 49 00 00 00 89 75 E8 89 75 E0 89 4D E4 3B C1 77 03 89 45 E4 FF 75 14 8D 45 E0 FF 75 10 FF 75 0C 50 FF 55 08 83 C4 10 5F C9 C3 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "_sscanf"
		size = 34
		refs = "0013 __input_l 0018 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 10 50 6A 00 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_360_3_0 {
	meta:
		name = "_sscanf_s"
		size = 34
		refs = "0013 __input_s_l 0018 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 10 50 6A 00 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_795_1_0 {
	meta:
		name = "_swscanf"
		size = 34
		refs = "0013 __winput_l 0018 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 10 50 6A 00 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_795_3_0 {
	meta:
		name = "_swscanf_s"
		size = 34
		refs = "0013 __winput_s_l 0018 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 10 50 6A 00 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "__sscanf_l"
		size = 35
		refs = "0014 __input_l 0019 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 14 50 FF 75 10 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_360_4_0 {
	meta:
		name = "__sscanf_s_l"
		size = 35
		refs = "0014 __input_s_l 0019 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 14 50 FF 75 10 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_795_2_0 {
	meta:
		name = "__swscanf_l"
		size = 35
		refs = "0014 __winput_l 0019 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 14 50 FF 75 10 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_795_4_0 {
	meta:
		name = "__swscanf_s_l"
		size = 35
		refs = "0014 __winput_s_l 0019 _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8D 45 14 50 FF 75 10 FF 75 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_361_3_0 {
	meta:
		name = "__mbbtombc_l"
		size = 162
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0040 _mbbtable 006e _mbctable"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 8B 45 08 8D 48 E0 83 F9 5E 77 0A 0F B7 04 45 ?? ?? ?? ?? EB 4D 3D DC 00 00 00 75 14 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 8F 83 00 00 C9 C3 8D 88 5F FF FF FF 83 F9 3E 77 27 8A 0D ?? ?? ?? ?? 33 D2 EB 0F 0F B6 C9 3B C1 74 0E 8A 0C 95 ?? ?? ?? ?? 42 84 C9 75 ED EB 08 0F B7 04 95 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_361_5_0 {
	meta:
		name = "__mbctombb_l"
		size = 192
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003d _mbbtable 0058 _mbctable"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 8B 45 08 53 33 DB 33 C9 0F B7 14 4D ?? ?? ?? ?? 3B C2 74 51 41 83 F9 5E 7E EE 56 57 3D 96 83 00 00 77 5B 33 FF 38 1D ?? ?? ?? ?? 74 51 33 D2 0F B7 B2 ?? ?? ?? ?? 8B C8 2B CE 74 3A 33 F0 F7 C6 00 FF 00 00 75 0F 3B CB 7E 0B 0F BE 92 ?? ?? ?? ?? 2B CA 78 21 47 8B D7 C1 E2 02 38 9A ?? ?? ?? ?? 75 CC EB 19 8D 41 20 38 5D FC 74 1F 8B 4D F8 83 61 70 FD EB 16 0F B6 04 BD ?? ?? ?? ?? 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__splitpath_s"
		size = 511
		refs = "0080 _strncpy_s 00b5 __ismbblead 01b0 __errno 01c4 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 33 DB 56 57 89 5D F8 39 5D 08 74 7E 8B 4D 0C 3B CB 75 07 39 5D 10 75 72 EB 05 39 5D 10 74 6B 39 5D 14 75 07 39 5D 18 75 61 EB 05 39 5D 18 74 5A 39 5D 1C 75 07 39 5D 20 75 50 EB 05 39 5D 20 74 49 39 5D 24 75 3F 39 5D 28 75 3F 8B 75 08 33 C0 40 38 1E 74 06 48 46 3B C3 77 F6 80 3E 3A 75 36 3B CB 74 1B 83 7D 10 03 0F 82 01 01 00 00 6A 02 FF 75 08 FF 75 10 51 E8 ?? ?? ?? ?? 83 C4 10 46 89 75 08 EB 17 39 5D 28 75 C1 C7 45 F8 01 00 00 00 E9 D9 00 00 00 3B CB 74 02 88 19 8B 75 08 33 FF 89 5D FC 38 1E 74 5A 0F BE 06 50 E8 ?? ?? ?? ?? 59 85 C0 74 03 46 EB 16 8A 06 3C 2F 74 0D 3C 5C 74 09 3C 2E 75 08 89 75 FC EB 03 8D 7E 01 46 38 1E 75 D4 3B FB 74 2A 39 5D 14 74 20 8B C7 2B 45 08 39 45 18 0F 86 84 00 00 00 50 FF 75 08 FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 83 C4 10 89 7D 08 EB 09 8B 45 14 3B C3 74 02 88 18 8B 45 FC 3B C3 74 4C 3B 45 08 72 47 39 5D 1C 74 1A 2B 45 08 39 45 20 76 4B 50 FF 75 08 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 83 C4 10 39 5D 24 0F 84 B1 00 00 00 2B 75 FC 39 75 28 76 28 56 FF 75 FC FF 75 28 FF 75 24 E8 ?? ?? ?? ?? 83 C4 10 E9 92 00 00 00 39 5D 1C 0F 84 80 00 00 00 2B 75 08 39 75 20 77 66 8B 45 0C 3B C3 74 07 39 5D 10 76 02 88 18 8B 45 14 3B C3 74 07 39 5D 18 76 02 88 18 8B 45 1C 3B C3 74 07 39 5D 20 76 02 88 18 8B 45 24 3B C3 74 07 39 5D 28 76 02 88 18 E8 ?? ?? ?? ?? 39 5D 08 75 16 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 2B 39 5D F8 75 E5 6A 22 59 89 08 8B C1 EB 1D 56 FF 75 08 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 3B C3 74 02 88 18 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__ungetc_nolock"
		size = 241
		refs = "0012 __fileno 0018 ___badioinfo 0036 ___pioinfo 006b __errno 007d __invalid_parameter 00aa __getbuf"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 0C F6 46 0C 40 57 75 79 56 E8 ?? ?? ?? ?? 59 BA ?? ?? ?? ?? 83 F8 FF 74 1B 83 F8 FE 74 16 8B C8 83 E1 1F 8B F8 C1 FF 05 C1 E1 06 03 0C BD ?? ?? ?? ?? EB 02 8B CA F6 41 24 7F 75 26 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 83 E0 1F C1 F9 05 C1 E0 06 03 04 8D ?? ?? ?? ?? EB 02 8B C2 F6 40 24 80 74 1F E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4A 53 8B 5D 08 83 FB FF 74 3D 8B 46 0C A8 01 75 08 84 C0 79 32 A8 02 75 2E 33 FF 39 7E 08 75 07 56 E8 ?? ?? ?? ?? 59 8B 06 3B 46 08 75 08 39 7E 04 75 14 40 89 06 FF 0E F6 46 0C 40 8B 06 74 0F 38 18 74 0D 40 89 06 83 C8 FF 5B 5F 5E 5D C3 88 18 8B 46 0C FF 46 04 83 E0 EF 83 C8 01 89 46 0C 8B C3 25 FF 00 00 00 EB E1 }
	condition:
		$1
}

rule file_363_1_0 {
	meta:
		name = "_ungetc"
		size = 114
		refs = "0003 __sehtable$_ungetc 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 003b __lock_file 004a __ungetc_nolock 0063 __SEH_epilog4 006c __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2B FF 75 0C E8 ?? ?? ?? ?? 59 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 37
		refs = "0003 __ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z 0008 __EH_prolog3_catch 0014 ??2@YAPAXI@Z 0020 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 83 65 FC 00 E8 ?? ?? ?? ?? 59 89 45 EC 8B 45 EC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_367_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_248_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_261_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_261_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_249_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_261_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_261_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_83_1 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_1051_1 {
	meta:
		name = "__ehhandler$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_1045_1 {
	meta:
		name = "__ehhandler$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_132_1 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "_puts"
		size = 351
		refs = "0003 __sehtable$_puts 0008 __SEH_prolog4 0021 __errno 0031 __invalid_parameter 0040 ___iob_func 004f __fileno 006d ___pioinfo 0074 ___badioinfo 00b6 __lock_file2 00c9 __stbuf 00d3 _strlen 00e9 __fwrite_nolock 011d __flsbuf 0131 __ftbuf 0147 __SEH_epilog4 0158 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 CE FF 89 75 E4 33 C0 33 DB 39 5D 08 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 07 01 00 00 E8 ?? ?? ?? ?? 83 C0 20 F6 40 0C 40 75 5D 50 E8 ?? ?? ?? ?? 59 3B C6 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 A2 3B C6 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 0F 85 76 FF FF FF E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 5D FC E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 8B F8 FF 75 08 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 83 C0 20 50 56 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 3B C6 75 32 E8 ?? ?? ?? ?? 83 C0 24 FF 08 78 11 E8 ?? ?? ?? ?? 83 C0 20 8B 08 C6 01 0A FF 00 EB 12 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 59 59 89 5D E4 E8 ?? ?? ?? ?? 83 C0 20 50 57 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "_store_dt"
		size = 28
	strings:
		$1 = { 8B FF 56 99 6A 0A 5E F7 FE 5E 83 C0 30 66 89 01 41 41 83 C2 30 66 89 11 8D 41 02 C3 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "__wasctime_s"
		size = 434
		refs = "0017 __errno 0026 __invalid_parameter 0088 __days 010f ___dnames 011b ___mnames 0140 _store_dt"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 08 56 57 33 FF 3B CF 74 05 39 7D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 7A 01 00 00 33 C0 83 7D 0C 1A 66 89 01 72 D7 8B 75 10 3B F7 74 D0 39 7E 14 7C CB 8B 56 10 3B D7 7C C4 83 FA 0B 7F BF 8B 46 08 3B C7 7C B8 83 F8 17 7F B3 8B 46 04 3B C7 7C AC 83 F8 3B 7F A7 8B 06 3B C7 7C A1 83 F8 3B 7F 9C 83 7E 0C 01 53 7C 65 8B C2 C1 E0 02 8B 98 ?? ?? ?? ?? 2B 98 ?? ?? ?? ?? 3B 5E 0C 7D 43 8B 46 14 05 6C 07 00 00 8B D0 81 E2 03 00 00 80 89 45 08 79 05 4A 83 CA FC 42 75 0A 6A 64 99 5B F7 FB 85 D2 75 0F 8B 45 08 99 BB 90 01 00 00 F7 FB 85 D2 75 1A 8B 56 10 83 FA 01 75 12 83 7E 0C 1D 7F 0C 8B 46 18 3B C7 7C 05 83 F8 06 7E 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 A9 00 00 00 6B C0 03 6B D2 03 66 0F BE 9C 38 ?? ?? ?? ?? 66 89 19 66 0F BE 9C 3A ?? ?? ?? ?? 66 89 59 08 47 41 41 83 FF 03 7C DF 6A 20 5F 8B C7 66 89 01 83 C1 08 66 89 01 8B 46 0C 83 C1 02 E8 ?? ?? ?? ?? 8B CF 66 89 08 8D 48 02 8B 46 08 E8 ?? ?? ?? ?? 6A 3A 59 66 89 08 8D 48 02 8B 46 04 E8 ?? ?? ?? ?? 6A 3A 59 66 89 08 8D 48 02 8B 06 E8 ?? ?? ?? ?? 8B C8 66 89 39 8B 46 14 99 6A 64 5F F7 FF 83 C1 02 83 C0 13 E8 ?? ?? ?? ?? 8B C8 8B 46 14 99 57 5E F7 FE 8B C2 E8 ?? ?? ?? ?? 6A 0A 59 66 89 08 33 C9 66 89 48 02 33 C0 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_370_2_0 {
	meta:
		name = "__wasctime"
		size = 76
		refs = "0008 _buf 000d __getptd_noexit 0022 __calloc_crt 0039 __wasctime_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 1B 83 7E 40 00 75 12 6A 02 6A 1A E8 ?? ?? ?? ?? 59 59 89 46 40 85 C0 74 03 8B 7E 40 FF 75 08 6A 1A 57 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__snwprintf"
		size = 211
		refs = "0011 __errno 0021 __invalid_parameter 008c __woutput_l 00ae __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 10 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 8B 45 0C 56 8B 75 08 3B C3 74 21 3B F3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 73 C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 3D FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 57 8D 45 14 50 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 8B F8 3B F3 74 35 FF 4D E4 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__wincmdln"
		size = 95
		refs = "0008 ___mbctype_initialized 000f ___initmbctable 0015 __acmdln 001e ??_C@_00CNPNBAHC@?$AA@ 0042 __ismbblead"
	strings:
		$1 = { 8B FF 56 57 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 75 05 BE ?? ?? ?? ?? 8A 06 3C 20 77 08 84 C0 74 2E 85 FF 74 24 3C 22 75 09 33 C9 85 FF 0F 94 C1 8B F9 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 01 46 46 EB D3 3C 20 77 07 46 8A 06 84 C0 75 F5 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 343
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 0141 _cos"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 10 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 19 F3 0F 5A C0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 5C C8 F2 0F 5A C1 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__time64"
		size = 81
		refs = "000d __imp__GetSystemTimeAsFileTime@4 002c __aulldiv"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 45 F8 8B 4D FC 6A 00 05 00 80 C1 2A 68 80 96 98 00 81 D1 21 4E 62 FE 51 50 E8 ?? ?? ?? ?? 83 FA 07 7C 0E 7F 07 3D FF 6F 40 93 76 05 83 C8 FF 8B D0 8B 4D 08 85 C9 74 05 89 01 89 51 04 C9 C3 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 75
		refs = "0003 __sehtable$__rt_probe_read4@4 0008 __SEH_prolog4 0044 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8B 45 08 8B 00 C7 45 E4 01 00 00 00 EB 1B 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 83 65 E4 00 C7 45 FC FE FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "__fdopen"
		size = 390
		refs = "0003 __sehtable$__fdopen 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0056 __nhandle 0077 ___pioinfo 00ab __commode 0138 __getstream 015a __cflush 0176 __SEH_epilog4 0180 __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 4D 0C 33 FF 3B CF 0F 95 C0 3B C7 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 3A 01 00 00 8B 45 08 83 F8 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E4 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BE 8B D0 C1 FA 05 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 0F BE 44 02 04 33 F6 46 23 C6 74 D5 EB 01 41 80 39 20 74 FA 8A 01 3C 61 74 0C 3C 72 74 18 3C 77 0F 85 7B FF FF FF 6A 02 5B 33 D2 89 7D 0C 0B 1D ?? ?? ?? ?? EB 68 8B DE EB EF 3B F7 74 6A 0F BE C0 83 E8 20 74 58 83 E8 0B 74 42 83 E8 37 74 11 48 74 2B 83 E8 0B 74 17 83 E8 06 0F 85 40 FF FF FF 39 7D 0C 75 2B C7 45 0C 01 00 00 00 EB 2F 3B D7 75 1E 33 D2 42 81 E3 FF BF FF FF EB 20 3B D7 75 0F 33 D2 42 81 CB 00 40 00 00 EB 11 84 DB 79 04 33 F6 EB 09 83 E3 FC 81 CB 80 00 00 00 41 8A 01 84 C0 75 95 EB 01 41 80 39 20 74 FA 33 C0 38 01 0F 94 C0 3B C7 0F 84 E5 FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 3B F7 75 10 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 DF FE FF FF 89 7D FC FF 05 ?? ?? ?? ?? 89 5E 0C 8B 45 08 89 46 10 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "__crt_waiting_on_module_handle"
		size = 48
		refs = "000e __imp__Sleep@4 0017 __imp__GetModuleHandleW@4"
	strings:
		$1 = { 8B FF 55 8B EC 57 BF E8 03 00 00 57 FF 15 ?? ?? ?? ?? FF 75 08 FF 15 ?? ?? ?? ?? 81 C7 E8 03 00 00 81 FF 60 EA 00 00 77 04 85 C0 74 DE 5F 5D C3 }
	condition:
		$1
}

rule file_380_1_0 {
	meta:
		name = "__amsg_exit"
		size = 41
		refs = "0006 __FF_MSGBANNER 000e __NMSG_WRITE 0014 __aexit_rtn 0019 __decode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 FF 00 00 00 FF D0 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_380_2_0 {
	meta:
		name = "___crtCorExitProcess"
		size = 43
		refs = "0006 ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 000c __imp__GetModuleHandleW@4 0015 ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 001c __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 FF 75 08 FF D0 5D C3 }
	condition:
		$1
}

rule file_380_3_0 {
	meta:
		name = "___crtExitProcess"
		size = 24
		refs = "0009 ___crtCorExitProcess 0013 __imp__ExitProcess@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 FF 75 08 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_380_6_0 {
	meta:
		name = "__initterm"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 0B 8B 06 85 C0 74 02 FF D0 83 C6 04 3B 75 08 72 F0 5E 5D C3 }
	condition:
		$1
}

rule file_380_7_0 {
	meta:
		name = "__initterm_e"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 33 C0 EB 0F 85 C0 75 10 8B 0E 85 C9 74 02 FF D1 83 C6 04 3B 75 0C 72 EC 5E 5D C3 }
	condition:
		$1
}

rule file_380_8_0 {
	meta:
		name = "__get_wpgmptr"
		size = 60
		refs = "0010 __errno 0020 __invalid_parameter 002d __wpgmptr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0D A1 ?? ?? ?? ?? 3B C6 74 DA 89 01 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_380_9_0 {
	meta:
		name = "__get_pgmptr"
		size = 60
		refs = "0010 __errno 0020 __invalid_parameter 002d __pgmptr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0D A1 ?? ?? ?? ?? 3B C6 74 DA 89 01 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_380_10_0 {
	meta:
		name = "__cinit"
		size = 133
		refs = "0007 __FPinit 0014 __IsNonwritableInCurrentImage 0028 __initp_misc_cfltcvt_tab 002d ___xi_z 0032 ___xi_a 0037 __initterm_e 0042 __RTC_Terminate 0047 _atexit 004c ___xc_a 0053 ___xc_z 0058 __initterm 005e ___dyn_tls_init_callback"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 74 19 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 0A FF 75 08 FF 15 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 75 42 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 59 74 1B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 0C 6A 00 6A 02 6A 00 FF 15 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_380_11_0 {
	meta:
		name = "_doexit"
		size = 300
		refs = "0003 __sehtable$_doexit 0008 __SEH_prolog4 000f __lock 001d __C_Exit_Done 0029 __C_Termination_Done 0031 __exitflag 0041 ___onexitbegin 0046 __decode_pointer 0056 ___onexitend 0076 __encoded_null 00cd ___xp_z 00d2 ___xp_a 00d7 __initterm 00dd ___xt_z 00e2 ___xt_a 0107 __unlock 0110 ___crtExitProcess 0127 __SEH_epilog4"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 33 DB 43 39 1D ?? ?? ?? ?? 0F 84 C5 00 00 00 89 1D ?? ?? ?? ?? 8A 45 10 A2 ?? ?? ?? ?? 83 7D 0C 00 0F 85 9D 00 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F8 89 7D D8 85 FF 74 78 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F0 89 75 DC 89 7D E4 89 75 E0 83 EE 04 89 75 DC 3B F7 72 57 E8 ?? ?? ?? ?? 39 06 74 ED 3B F7 72 4A FF 36 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 89 06 FF D7 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 39 7D E4 75 05 39 45 E0 74 0E 89 7D E4 89 7D D8 89 45 E0 8B F0 89 75 DC 8B 7D D8 EB 9F 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1F 00 00 00 83 7D 10 00 75 28 89 1D ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 59 FF 75 08 E8 ?? ?? ?? ?? 33 DB 43 83 7D 10 00 74 08 6A 08 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_380_12_0 {
	meta:
		name = "_exit"
		size = 22
		refs = "000d _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_380_13_0 {
	meta:
		name = "__exit"
		size = 22
		refs = "000d _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_380_16_0 {
	meta:
		name = "__init_pointers"
		size = 78
		refs = "0004 __encoded_null 000c __initp_heap_handler 0012 __initp_misc_initcrit 0018 __initp_misc_invarg 001e __initp_misc_purevirt 0024 __initp_misc_rand_s 002a __initp_misc_winsig 0030 __initp_misc_winxfltr 0036 __initp_eh_hooks 003b __exit 0040 __encode_pointer 0048 __aexit_rtn"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 24 A3 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "_rewind"
		size = 198
		refs = "0003 __sehtable$_rewind 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0035 __SEH_epilog4 003f __fileno 0047 __lock_file 0052 __flush 0075 ___pioinfo 007c ___badioinfo 009b __lseek 00c0 __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 33 DB 3B F3 0F 95 C0 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? C3 89 75 08 56 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 59 89 5D FC 56 E8 ?? ?? ?? ?? 59 83 66 0C CF 83 FF FF 74 1B 83 FF FE 74 16 8B CF C1 F9 05 8B C7 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? 0F BE 48 04 80 E1 FD 88 48 04 8B 46 0C 84 C0 79 06 83 E0 FC 89 46 0C 53 53 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 04 83 4E 0C 20 C7 45 FC FE FF FF FF E8 05 00 00 00 E9 78 FF FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "_strcpy"
		size = 16
	strings:
		$1 = { 57 8B 7C 24 08 EB 6E 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "_strcat"
		size = 232
	strings:
		$1 = { 8B 4C 24 04 57 F7 C1 03 00 00 00 74 13 8A 01 83 C1 01 84 C0 74 3D F7 C1 03 00 00 00 75 EF 8B FF 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD 8D 79 FF EB 0D 8D 79 FE EB 08 8D 79 FD EB 03 8D 79 FC 8B 4C 24 0C F7 C1 03 00 00 00 74 1D 8A 11 83 C1 01 84 D2 74 66 88 17 83 C7 01 F7 C1 03 00 00 00 75 EA EB 05 89 17 83 C7 04 BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 89 17 8B 44 24 08 5F C3 66 89 17 8B 44 24 08 C6 47 02 00 5F C3 66 89 17 8B 44 24 08 5F C3 88 17 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "___libm_sse2_asin"
		size = 1097
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 0089 _T_table 0096 _Tbl_addr 00c2 _cv 00d6 _SIGNMASK 014b _HALFMASK2 01a2 _PI_BY_2 025d _cv2 02c4 _ONE_BY_2"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 BE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 54 15 ?? ?? ?? ?? F2 0F 10 D9 F2 0F 59 C9 66 0F 12 35 ?? ?? ?? ?? 83 C4 0C F2 0F 59 D9 F2 0F 59 F9 F2 0F 59 EB 66 0F 57 E2 F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 66 0F 56 E2 F2 0F 58 C6 F2 0F 58 C4 C3 2D BB 03 00 00 83 F8 43 0F 83 18 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 8B C2 66 0F 54 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 00 00 08 00 C1 E8 04 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 83 C4 0C 66 0F C4 F0 03 F2 0F 58 C5 F2 0F 10 EC 66 0F 70 DB EE F2 0F 5C E3 F2 0F 58 DC F2 0F 5C EB F2 0F 5C C5 F2 0F 5C C4 66 0F 56 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 73 5D 66 0F 14 FF 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 F7 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 83 C4 0C 66 0F 59 FF 66 0F 59 F7 66 0F 59 CF 66 0F 59 FF F2 0F 10 DE F2 0F 59 F6 66 0F 58 CA 66 0F 59 E7 F2 0F 59 F3 66 0F 58 CC 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 C3 2D FE 3B 00 00 83 F8 02 0F 83 BB 00 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 5C D9 F2 0F 59 E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 70 FC 44 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 59 DF 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FD 66 0F 58 D3 F2 0F 59 D7 66 0F 59 D5 F2 0F 58 E4 66 0F 70 EE EE 66 0F 70 DC 44 F2 0F 5C E5 F2 0F 58 EC F2 0F 5C EB 66 0F 59 D3 F2 0F 58 EE 66 0F 57 F6 66 0F 70 C2 EE F2 0F 5C D5 83 C4 0C F2 0F 58 C2 25 00 80 00 00 35 00 80 00 00 66 0F C4 F0 03 F2 0F 58 C4 66 0F 57 C6 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 8A 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 42 83 C4 0C 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 10 F8 83 C4 0C 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 C3 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "__setmode_nolock"
		size = 188
		refs = "0015 ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 0C 56 8B 75 08 8B C6 C1 F8 05 8D 14 85 ?? ?? ?? ?? 8B 02 83 E6 1F C1 E6 06 8D 0C 30 8A 41 24 02 C0 57 0F B6 79 04 0F BE C0 81 E7 80 00 00 00 D1 F8 81 FB 00 40 00 00 74 50 81 FB 00 80 00 00 74 42 81 FB 00 00 01 00 74 26 81 FB 00 00 02 00 74 1E 81 FB 00 00 04 00 75 3D 80 49 04 80 8B 0A 8D 4C 31 24 8A 11 80 E2 81 80 CA 01 88 11 EB 27 80 49 04 80 8B 0A 8D 4C 31 24 8A 11 80 E2 82 80 CA 02 EB E8 80 61 04 7F EB 0D 80 49 04 80 8B 0A 8D 4C 31 24 80 21 80 85 FF 5F 5E 5B 75 07 B8 00 80 00 00 5D C3 F7 D8 1B C0 25 00 C0 00 00 05 00 40 00 00 5D C3 }
	condition:
		$1
}

rule file_387_1_0 {
	meta:
		name = "__set_fmode"
		size = 76
		refs = "001e __errno 0030 __invalid_parameter 003e __fmode 0044 __imp__InterlockedExchange@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3D 00 40 00 00 74 2D 3D 00 80 00 00 74 26 3D 00 00 01 00 74 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5D C3 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "__get_fmode"
		size = 57
		refs = "0010 __errno 0020 __invalid_parameter 002e __fmode"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0A 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_545_0_0 {
	meta:
		name = "__get_daylight"
		size = 57
		refs = "0010 __errno 0020 __invalid_parameter 002e __daylight"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0A 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_545_1_0 {
	meta:
		name = "__get_dstbias"
		size = 57
		refs = "0010 __errno 0020 __invalid_parameter 002e __dstbias"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0A 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_545_2_0 {
	meta:
		name = "__get_timezone"
		size = 57
		refs = "0010 __errno 0020 __invalid_parameter 002e __timezone"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 0A 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "__setmode"
		size = 247
		refs = "0003 __sehtable$__setmode 0008 __SEH_prolog4 0033 __errno 0045 __invalid_parameter 0071 __nhandle 008c ___pioinfo 00a6 ___lock_fhandle 00be __setmode_nolock 00e8 __SEH_epilog4 00f1 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 3D 00 40 00 00 74 3E 3D 00 80 00 00 74 37 3D 00 00 01 00 74 30 3D 00 00 04 00 74 29 3D 00 00 02 00 74 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 DB 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 93 00 00 00 8B 45 08 83 F8 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E3 33 DB 3B C3 7C 08 3B 05 ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BB 8B C8 C1 F9 05 8D 3C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0F 0F BE 4C 31 04 83 E1 01 74 D3 50 E8 ?? ?? ?? ?? 59 89 5D FC 8B 07 F6 44 30 04 01 74 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 EB 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "__makepath"
		size = 32
		refs = "0017 __makepath_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_916_0_0 {
	meta:
		name = "__wmakepath"
		size = 32
		refs = "0017 __wmakepath_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "__ceil_default"
		size = 213
		refs = "0011 _newcw 0016 __ctrlfp 0036 __sptype 0056 __handle_qnan1 0073 __real@3ff0000000000000 008b __frnd 00ca __except1"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 45 08 59 59 8B 4D 0E 8B D8 B8 F0 7F 00 00 23 C8 51 51 DD 1C 24 66 3B C8 75 55 E8 ?? ?? ?? ?? 59 59 85 C0 7E 2D 83 F8 02 7E 1A 83 F8 03 75 23 DD 45 08 53 51 51 DD 1C 24 6A 0C E8 ?? ?? ?? ?? 83 C4 10 EB 72 56 53 E8 ?? ?? ?? ?? DD 45 08 59 59 EB 64 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0C 6A 08 EB 3F E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 59 DC 5D F8 59 DF E0 F6 C4 44 7A 0E 56 53 E8 ?? ?? ?? ?? DD 45 F8 59 59 EB 22 F6 C3 20 75 ED DD 45 F8 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0C 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_391_1_0 {
	meta:
		name = "__floor_pentium4"
		size = 225
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00c1 _NegZero 00d2 _NegOne"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 75 4C 3D FF 03 00 00 7C 7D 66 0F F3 CA 3D 32 04 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA ED 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 01 3D FF 0B 00 00 7C 21 3D 32 0C 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 5C C8 66 0F D6 4C 24 04 DD 44 24 04 C3 D9 EE C3 66 0F C2 1D ?? ?? ?? ?? 01 66 0F 56 1D ?? ?? ?? ?? 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_392_3_0 {
	meta:
		name = "_write_char"
		size = 51
		refs = "0022 __flsbuf"
	strings:
		$1 = { F6 41 0C 40 74 06 83 79 08 00 74 24 FF 49 04 78 0B 8B 11 88 02 FF 01 0F B6 C0 EB 0C 0F BE C0 51 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 03 09 06 C3 FF 06 C3 }
	condition:
		$1
}

rule file_392_4_0 {
	meta:
		name = "_write_multi_char"
		size = 38
		refs = "0014 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 13 8B 4D 10 8A 45 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 74 06 83 7D 0C 00 7F E7 5E 5D C3 }
	condition:
		$1
}

rule file_392_5_0 {
	meta:
		name = "_write_string"
		size = 77
		refs = "0026 _write_char 0031 __errno"
	strings:
		$1 = { 8B FF 55 8B EC F6 47 0C 40 53 56 8B F0 8B D9 74 32 83 7F 08 00 75 2C 8B 45 08 01 06 EB 2B 8A 03 FF 4D 08 8B CF E8 ?? ?? ?? ?? 43 83 3E FF 75 13 E8 ?? ?? ?? ?? 83 38 2A 75 0F 8B CF B0 3F E8 ?? ?? ?? ?? 83 7D 08 00 7F D5 5E 5B 5D C3 }
	condition:
		$1
}

rule file_392_9_0 {
	meta:
		name = "__output_s_l"
		size = 3024
		refs = "000c ___security_cookie 0063 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006c __errno 007e __invalid_parameter 00a8 __fileno 00ae ___badioinfo 00cc ___pioinfo 015b ___lookuptable_s 0195 $LN283 03ad __isleadbyte_l 03ca _write_char 04e4 ___wnullstring 054e _wctomb_s 05d5 ___nullstring 05e1 _strlen 0646 __get_printf_count_output 06e9 __malloc_crt 075c __cfltcvt_tab 0761 __decode_pointer 0919 __aulldvrm 0a2e _write_multi_char 0a4e _write_string 0b33 _free 0ba8 @__security_check_cookie@4 0bb0 $NORMAL_STATE$28987 0bb4 $LN131 0bb8 $LN130 0bbc $LN122 0bc0 $LN118 0bc4 $LN117 0bc8 $LN113 0bcc $LN97"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 78 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 56 8B 75 08 33 C0 57 8B 7D 14 FF 75 10 8D 8D B0 FD FF FF 89 B5 A0 FD FF FF 89 BD DC FD FF FF 89 85 A4 FD FF FF 89 85 F0 FD FF FF 89 85 CC FD FF FF 89 85 E8 FD FF FF 89 85 D0 FD FF FF 89 85 A8 FD FF FF 89 85 C8 FD FF FF E8 ?? ?? ?? ?? 85 F6 75 35 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 BD BC FD FF FF 00 74 0A 8B 85 B8 FD FF FF 83 60 70 FD 83 C8 FF E9 FF 0A 00 00 F6 46 0C 40 75 5E 56 E8 ?? ?? ?? ?? 59 BA ?? ?? ?? ?? 83 F8 FF 74 1B 83 F8 FE 74 16 8B C8 83 E1 1F 8B F0 C1 FE 05 C1 E1 06 03 0C B5 ?? ?? ?? ?? EB 02 8B CA F6 41 24 7F 75 91 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 83 E0 1F C1 F9 05 C1 E0 06 03 04 8D ?? ?? ?? ?? EB 02 8B C2 F6 40 24 80 0F 85 67 FF FF FF 33 C0 3B D8 0F 84 5D FF FF FF 8A 13 89 85 D8 FD FF FF 89 85 E0 FD FF FF 89 85 C0 FD FF FF 89 85 AC FD FF FF 88 95 EF FD FF FF 84 D2 0F 84 50 0A 00 00 43 33 C0 39 85 D8 FD FF FF 89 9D C4 FD FF FF 0F 8C 13 0A 00 00 8A CA 80 E9 20 80 F9 58 77 0D 0F BE C2 0F B6 80 ?? ?? ?? ?? 83 E0 0F 8B 8D C0 FD FF FF 6B C0 09 0F B6 84 08 ?? ?? ?? ?? 6A 08 C1 E8 04 5E 89 85 C0 FD FF FF 3B C6 0F 84 E4 FE FF FF 6A 07 59 3B C1 0F 87 AD 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D E8 FD FF FF FF 89 85 94 FD FF FF 89 85 A8 FD FF FF 89 85 CC FD FF FF 89 85 D0 FD FF FF 89 85 F0 FD FF FF 89 85 C8 FD FF FF E9 74 09 00 00 0F BE C2 83 E8 20 74 48 83 E8 03 74 34 2B C6 74 24 48 48 74 14 83 E8 03 0F 85 56 09 00 00 09 B5 F0 FD FF FF E9 4B 09 00 00 83 8D F0 FD FF FF 04 E9 3F 09 00 00 83 8D F0 FD FF FF 01 E9 33 09 00 00 81 8D F0 FD FF FF 80 00 00 00 E9 24 09 00 00 83 8D F0 FD FF FF 02 E9 18 09 00 00 80 FA 2A 75 2C 83 C7 04 89 BD DC FD FF FF 8B 7F FC 89 BD CC FD FF FF 85 FF 0F 8D F9 08 00 00 83 8D F0 FD FF FF 04 F7 9D CC FD FF FF E9 E7 08 00 00 8B 85 CC FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 CC FD FF FF E9 CC 08 00 00 83 A5 E8 FD FF FF 00 E9 C0 08 00 00 80 FA 2A 75 26 83 C7 04 89 BD DC FD FF FF 8B 7F FC 89 BD E8 FD FF FF 85 FF 0F 8D A1 08 00 00 83 8D E8 FD FF FF FF E9 95 08 00 00 8B 85 E8 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 E8 FD FF FF E9 7A 08 00 00 80 FA 49 74 55 80 FA 68 74 44 80 FA 6C 74 18 80 FA 77 0F 85 62 08 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 53 08 00 00 80 3B 6C 75 16 43 81 8D F0 FD FF FF 00 10 00 00 89 9D C4 FD FF FF E9 38 08 00 00 83 8D F0 FD FF FF 10 E9 2C 08 00 00 83 8D F0 FD FF FF 20 E9 20 08 00 00 8A 03 3C 36 75 1D 80 7B 01 34 75 17 43 43 81 8D F0 FD FF FF 00 80 00 00 89 9D C4 FD FF FF E9 FD 07 00 00 3C 33 75 1D 80 7B 01 32 75 17 43 43 81 A5 F0 FD FF FF FF 7F FF FF 89 9D C4 FD FF FF E9 DC 07 00 00 3C 64 0F 84 D4 07 00 00 3C 69 0F 84 CC 07 00 00 3C 6F 0F 84 C4 07 00 00 3C 75 0F 84 BC 07 00 00 3C 78 0F 84 B4 07 00 00 3C 58 0F 84 AC 07 00 00 83 A5 C0 FD FF FF 00 83 A5 C8 FD FF FF 00 8D 85 B0 FD FF FF 50 0F B6 C2 50 E8 ?? ?? ?? ?? 59 85 C0 8A 85 EF FD FF FF 59 74 22 8B 8D A0 FD FF FF 8D B5 D8 FD FF FF E8 ?? ?? ?? ?? 8A 03 43 89 9D C4 FD FF FF 84 C0 0F 84 8C FC FF FF 8B 8D A0 FD FF FF 8D B5 D8 FD FF FF E8 ?? ?? ?? ?? E9 4A 07 00 00 0F BE C2 83 F8 64 0F 8F EA 01 00 00 0F 84 77 02 00 00 83 F8 53 0F 8F F3 00 00 00 0F 84 81 00 00 00 83 E8 41 74 10 48 48 74 59 48 48 74 08 48 48 0F 85 8F 05 00 00 80 C2 20 C7 85 94 FD FF FF 01 00 00 00 88 95 EF FD FF FF 83 8D F0 FD FF FF 40 83 BD E8 FD FF FF 00 8D 9D F4 FD FF FF B8 00 02 00 00 89 9D E4 FD FF FF 89 85 9C FD FF FF 0F 8D 45 02 00 00 C7 85 E8 FD FF FF 06 00 00 00 E9 A3 02 00 00 F7 85 F0 FD FF FF 30 08 00 00 0F 85 98 00 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 89 00 00 00 F7 85 F0 FD FF FF 30 08 00 00 75 0A 81 8D F0 FD FF FF 00 08 00 00 8B 8D E8 FD FF FF 83 F9 FF 75 05 B9 FF FF FF 7F 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD DC FD FF FF 8B 7F FC 89 BD E4 FD FF FF 0F 84 AD 04 00 00 85 FF 75 0B A1 ?? ?? ?? ?? 89 85 E4 FD FF FF 8B 85 E4 FD FF FF C7 85 C8 FD FF FF 01 00 00 00 E9 7B 04 00 00 83 E8 58 0F 84 D5 02 00 00 48 48 74 79 2B C1 0F 84 26 FF FF FF 48 48 0F 85 9A 04 00 00 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD DC FD FF FF 74 30 0F B7 47 FC 50 68 00 02 00 00 8D 85 F4 FD FF FF 50 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 1F C7 85 A8 FD FF FF 01 00 00 00 EB 13 8A 47 FC 88 85 F4 FD FF FF C7 85 E0 FD FF FF 01 00 00 00 8D 85 F4 FD FF FF 89 85 E4 FD FF FF E9 31 04 00 00 8B 07 83 C7 04 89 BD DC FD FF FF 85 C0 74 3C 8B 48 04 85 C9 74 35 F7 85 F0 FD FF FF 00 08 00 00 0F BF 00 89 8D E4 FD FF FF 74 14 99 2B C2 D1 F8 C7 85 C8 FD FF FF 01 00 00 00 E9 EC 03 00 00 83 A5 C8 FD FF FF 00 E9 E0 03 00 00 A1 ?? ?? ?? ?? 89 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 59 E9 C9 03 00 00 83 F8 70 0F 8F F5 01 00 00 0F 84 E1 01 00 00 83 F8 65 0F 8C B7 03 00 00 83 F8 67 0F 8E 32 FE FF FF 83 F8 69 74 6D 83 F8 6E 74 24 83 F8 6F 0F 85 9B 03 00 00 F6 85 F0 FD FF FF 80 89 B5 E0 FD FF FF 74 61 81 8D F0 FD FF FF 00 02 00 00 EB 55 8B 37 83 C7 04 89 BD DC FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 19 FA FF FF F6 85 F0 FD FF FF 20 74 0C 66 8B 85 D8 FD FF FF 66 89 06 EB 08 8B 85 D8 FD FF FF 89 06 C7 85 A8 FD FF FF 01 00 00 00 E9 A5 04 00 00 83 8D F0 FD FF FF 40 C7 85 E0 FD FF FF 0A 00 00 00 8B 8D F0 FD FF FF F7 C1 00 80 00 00 0F 84 A7 01 00 00 03 FE 8B 47 F8 8B 57 FC E9 D3 01 00 00 75 11 80 FA 67 75 66 C7 85 E8 FD FF FF 01 00 00 00 EB 5A 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 81 BD E8 FD FF FF A3 00 00 00 7E 40 8B B5 E8 FD FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 8A 95 EF FD FF FF 59 89 85 AC FD FF FF 6A 08 85 C0 74 10 89 85 E4 FD FF FF 89 B5 9C FD FF FF 8B D8 EB 0A C7 85 E8 FD FF FF A3 00 00 00 5E 03 FE 8B 47 F8 89 85 88 FD FF FF 8B 47 FC 89 85 8C FD FF FF 8D 85 B0 FD FF FF 50 FF B5 94 FD FF FF 0F BE C2 FF B5 E8 FD FF FF 89 BD DC FD FF FF 50 FF B5 9C FD FF FF 8D 85 88 FD FF FF 53 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B BD F0 FD FF FF 83 C4 1C 81 E7 80 00 00 00 74 21 83 BD E8 FD FF FF 00 75 18 8D 85 B0 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 BD EF FD FF FF 67 75 1C 85 FF 75 18 8D 85 B0 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3B 2D 75 11 81 8D F0 FD FF FF 00 01 00 00 43 89 9D E4 FD FF FF 53 E9 05 FE FF FF 89 B5 E8 FD FF FF 89 8D A4 FD FF FF EB 24 83 E8 73 0F 84 BB FC FF FF 48 48 0F 84 8B FE FF FF 83 E8 03 0F 85 B7 01 00 00 C7 85 A4 FD FF FF 27 00 00 00 F6 85 F0 FD FF FF 80 C7 85 E0 FD FF FF 10 00 00 00 0F 84 6B FE FF FF 8A 85 A4 FD FF FF 04 51 C6 85 D4 FD FF FF 30 88 85 D5 FD FF FF C7 85 D0 FD FF FF 02 00 00 00 E9 47 FE FF FF F7 C1 00 10 00 00 0F 85 4D FE FF FF 83 C7 04 F6 C1 20 74 18 89 BD DC FD FF FF F6 C1 40 74 06 0F BF 47 FC EB 04 0F B7 47 FC 99 EB 13 8B 47 FC F6 C1 40 74 03 99 EB 02 33 D2 89 BD DC FD FF FF F6 C1 40 74 1B 85 D2 7F 17 7C 04 85 C0 73 11 F7 D8 83 D2 00 F7 DA 81 8D F0 FD FF FF 00 01 00 00 F7 85 F0 FD FF FF 00 90 00 00 8B DA 8B F8 75 02 33 DB 83 BD E8 FD FF FF 00 7D 0C C7 85 E8 FD FF FF 01 00 00 00 EB 1A 83 A5 F0 FD FF FF F7 B8 00 02 00 00 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 8B C7 0B C3 75 06 21 85 D0 FD FF FF 8D 75 F3 8B 85 E8 FD FF FF FF 8D E8 FD FF FF 85 C0 7F 06 8B C7 0B C3 74 2D 8B 85 E0 FD FF FF 99 52 50 53 57 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 9C FD FF FF 8B F8 8B DA 7E 06 03 8D A4 FD FF FF 88 0E 4E EB BD 8D 45 F3 2B C6 46 F7 85 F0 FD FF FF 00 02 00 00 89 85 E0 FD FF FF 89 B5 E4 FD FF FF 74 62 85 C0 74 07 8B CE 80 39 30 74 57 FF 8D E4 FD FF FF 8B 8D E4 FD FF FF C6 01 30 40 EB 3F 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B 85 E4 FD FF FF D1 F8 EB 28 85 FF 75 0B A1 ?? ?? ?? ?? 89 85 E4 FD FF FF 8B 85 E4 FD FF FF EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B 85 E4 FD FF FF 89 85 E0 FD FF FF 83 BD A8 FD FF FF 00 0F 85 5C 01 00 00 8B 85 F0 FD FF FF A8 40 74 32 A9 00 01 00 00 74 09 C6 85 D4 FD FF FF 2D EB 18 A8 01 74 09 C6 85 D4 FD FF FF 2B EB 0B A8 02 74 11 C6 85 D4 FD FF FF 20 C7 85 D0 FD FF FF 01 00 00 00 8B 9D CC FD FF FF 2B 9D E0 FD FF FF 2B 9D D0 FD FF FF F6 85 F0 FD FF FF 0C 75 17 FF B5 A0 FD FF FF 8D 85 D8 FD FF FF 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C FF B5 D0 FD FF FF 8B BD A0 FD FF FF 8D 85 D8 FD FF FF 8D 8D D4 FD FF FF E8 ?? ?? ?? ?? F6 85 F0 FD FF FF 08 59 74 1B F6 85 F0 FD FF FF 04 75 12 57 53 6A 30 8D 85 D8 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 BD C8 FD FF FF 00 8B 85 E0 FD FF FF 74 66 85 C0 7E 62 8B B5 E4 FD FF FF 89 85 9C FD FF FF 0F B7 06 FF 8D 9C FD FF FF 50 6A 06 8D 45 F4 50 8D 85 90 FD FF FF 46 50 46 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 28 39 85 90 FD FF FF 74 20 FF B5 90 FD FF FF 8D 85 D8 FD FF FF 8D 4D F4 E8 ?? ?? ?? ?? 83 BD 9C FD FF FF 00 59 75 B5 EB 1C 83 8D D8 FD FF FF FF EB 13 8B 8D E4 FD FF FF 50 8D 85 D8 FD FF FF E8 ?? ?? ?? ?? 59 83 BD D8 FD FF FF 00 7C 1B F6 85 F0 FD FF FF 04 74 12 57 53 6A 20 8D 85 D8 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 BD AC FD FF FF 00 74 13 FF B5 AC FD FF FF E8 ?? ?? ?? ?? 83 A5 AC FD FF FF 00 59 8B 9D C4 FD FF FF 8A 03 88 85 EF FD FF FF 84 C0 74 0D 8B BD DC FD FF FF 8A D0 E9 D8 F5 FF FF 33 F6 39 B5 C0 FD FF FF 74 1E 83 BD C0 FD FF FF 07 74 15 E8 ?? ?? ?? ?? 56 56 56 56 C7 00 16 00 00 00 56 E9 F7 F4 FF FF 80 BD BC FD FF FF 00 74 0A 8B 85 B8 FD FF FF 83 60 70 FD 8B 85 D8 FD FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "__set_exp"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 05 FE 03 00 00 C1 E0 04 81 E1 0F 80 00 00 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_394_1_0 {
	meta:
		name = "__get_exp"
		size = 24
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0E C1 E8 04 25 FF 07 00 00 2D FE 03 00 00 98 5D C3 }
	condition:
		$1
}

rule file_394_2_0 {
	meta:
		name = "__add_exp"
		size = 45
		refs = "0024 __set_exp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0E DD 45 08 8B 4D 10 C1 E8 04 25 FF 07 00 00 8D 84 08 02 FC FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_394_3_0 {
	meta:
		name = "__set_bexp"
		size = 39
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 C1 E0 04 81 E1 0F 80 00 00 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_394_4_0 {
	meta:
		name = "__sptype"
		size = 96
	strings:
		$1 = { 8B FF 55 8B EC 33 D2 81 7D 0C 00 00 F0 7F 75 0A 39 55 08 75 18 33 C0 40 5D C3 81 7D 0C 00 00 F0 FF 75 0A 39 55 08 75 05 6A 02 58 5D C3 8B 4D 0E B8 F8 7F 00 00 23 C8 66 3B C8 75 04 6A 03 EB EA B8 F0 7F 00 00 66 3B C8 75 12 F7 45 0C FF FF 07 00 75 05 39 55 08 74 04 6A 04 EB CE 33 C0 5D C3 }
	condition:
		$1
}

rule file_394_5_0 {
	meta:
		name = "__decomp"
		size = 185
		refs = "0087 __set_exp"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE DC 55 08 DF E0 F6 C4 44 7A 07 33 D2 E9 9A 00 00 00 8B 55 0E 33 C9 F7 C2 F0 7F 00 00 75 6B F7 45 0C FF FF 0F 00 75 05 39 4D 08 74 5D DC 5D 08 BA 03 FC FF FF DF E0 F6 C4 41 75 05 33 C0 40 EB 18 33 C0 EB 14 D1 65 0C F7 45 08 00 00 00 80 74 04 83 4D 0C 01 D1 65 08 4A F6 45 0E 10 74 E6 56 BE EF FF 00 00 66 21 75 0E 5E 3B C1 74 09 B8 00 80 00 00 66 09 45 0E DD 45 08 51 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C EB 22 51 DD D8 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? C1 EA 04 81 E2 FF 07 00 00 83 C4 0C 81 EA FE 03 00 00 8B 45 10 89 10 5D C3 }
	condition:
		$1
}

rule file_396_2_0 {
	meta:
		name = "__CIcos_default"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "__set_output_format"
		size = 60
		refs = "000b __outputformat 0017 __errno 0029 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B 35 ?? ?? ?? ?? A9 FE FF FF FF 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 EB 05 A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_398_1_0 {
	meta:
		name = "__CIfmod"
		size = 40
		refs = "0001 __OP_FMODjmptab 0006 __cintrindisp2 000e __adjust_fdiv 001a __adj_fprem"
	strings:
		$1 = { BA ?? ?? ?? ?? E9 ?? ?? ?? ?? D9 C9 83 3D ?? ?? ?? ?? 01 74 04 D9 F8 EB 05 E8 ?? ?? ?? ?? 9B DF E0 9B 9E 7A E7 DD D9 C3 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "_clock"
		size = 69
		refs = "000e __imp__GetSystemTimeAsFileTime@4 001c __allmul 0022 _start_tics 003e __aulldiv"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 57 8D 45 F8 50 FF 15 ?? ?? ?? ?? 6A 01 6A 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 8B 4D F8 1B 15 ?? ?? ?? ?? 33 FF 57 03 C1 68 10 27 00 00 13 D7 52 50 E8 ?? ?? ?? ?? 5F C9 C3 }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "___inittime"
		size = 57
		refs = "000e __imp__GetSystemTimeAsFileTime@4 001c __allmul 002a _start_tics"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 6A 01 6A 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? 8B 4D F8 33 F6 03 C1 13 D6 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 33 C0 5E C9 C3 }
	condition:
		$1
}

rule file_400_3_0 {
	meta:
		name = "__ismbcalnum_l"
		size = 184
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 33 DB 81 F9 FF 00 00 00 76 72 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 3F 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CF 66 39 5D FE 75 3C F7 45 FC 07 01 00 00 74 33 33 C0 40 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 BA 07 01 00 00 66 85 14 41 75 D7 8B 4D F0 F6 44 08 1D 01 75 CD 33 C0 EB CC }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "__RTC_InitBase"
		size = 38
		refs = "0004 ?init@?1??_RTC_InitBase@@9@4_NA 0018 __CRT_RTC_INITW 001e __RTC_SetErrorFuncW"
	strings:
		$1 = { 33 C0 38 05 ?? ?? ?? ?? 75 1B 50 6A 01 50 50 50 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 C3 }
	condition:
		$1
}

rule file_401_1_0 {
	meta:
		name = "__RTC_Shutdown"
		size = 18
		refs = "000a __CRT_RTC_INITW"
	strings:
		$1 = { 6A 01 33 C0 6A 01 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__mkdir"
		size = 50
		refs = "000c __imp__CreateDirectoryA@8 0016 __imp__GetLastError@0 0024 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "__wmkdir"
		size = 50
		refs = "000c __imp__CreateDirectoryW@8 0016 __imp__GetLastError@0 0024 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "___libm_sse2_acosf"
		size = 989
		refs = "005a _T_table 0062 _Tbl_addr 009a _PI_BY_2 0191 _NEG_PI 02ea _PI"
	strings:
		$1 = { 66 0F 7E C0 B9 00 00 80 3F 66 0F 6E D9 0F 57 FF B9 00 00 FE FF 66 0F 6E D1 BA FF FF FF 7F 23 D0 81 EA 00 00 80 3D 81 FA D7 B3 DD 01 0F 83 BB 00 00 00 F3 0F 10 C8 F3 0F 59 C0 B9 01 00 00 00 66 0F C4 F9 01 F3 0F 5C D8 F3 0F 51 DB C1 EA 10 81 E2 FE 01 00 00 F3 0F 10 2C 55 ?? ?? ?? ?? 0F 10 24 95 ?? ?? ?? ?? 0F 54 D1 0F 56 D7 66 0F 70 F1 00 66 0F 70 F9 00 F3 0F 58 CA F3 0F 59 F5 F3 0F 5C FA B9 AB AA 2A 3E 66 0F 6E C1 F3 0F 59 F9 F3 0F 10 EE F3 0F 59 D3 0F 10 0D ?? ?? ?? ?? F3 0F 58 EA F3 0F 5E FD F3 0F 5C D6 25 00 00 00 80 66 0F 6E D8 F3 0F 59 C2 F3 0F 59 D2 66 0F 70 DB 00 F3 0F 59 C2 0F 57 E3 0F 5C CC 66 0F 70 E9 55 F3 0F 58 C1 66 0F 70 F1 55 F3 0F 5C EF F3 0F 5C F5 F3 0F 5C FE F3 0F 5C C7 F3 0F 58 C5 C3 81 EA D7 B3 DD 01 81 FA 29 4C 20 00 0F 83 EC 00 00 00 66 0F 70 F8 00 F3 0F 10 C8 66 0F 73 D7 0C 66 0F 73 F7 0C 25 00 00 00 80 F3 0F 5C CF 66 0F 70 F7 00 F3 0F 59 FF F3 0F 58 C6 F3 0F 5C DF F3 0F 59 C1 66 0F 70 E3 00 F3 0F 5C D8 F3 0F 51 DB B9 00 00 01 00 0B C8 66 0F 6E E9 C1 E8 1F F7 D8 0F 54 D3 66 0F C5 D3 01 0F 56 D5 83 E0 08 C1 E8 03 F7 D8 66 0F 6E F8 66 0F 70 FF 00 81 EA 80 3D 00 00 81 E2 FE FF 00 00 F3 0F 59 1C 55 ?? ?? ?? ?? F3 0F 59 F2 F3 0F 59 CA F3 0F 59 D2 F3 0F 5C F3 0F 54 3D ?? ?? ?? ?? F3 0F 58 F1 F3 0F 5C E2 F3 0F 58 DB F3 0F 5C E0 F3 0F 58 DE B9 AB AA 2A BE 66 0F 6E E9 F3 0F 5E E3 0F 10 14 95 ?? ?? ?? ?? F3 0F 59 EE F3 0F 59 F6 F3 0F 59 EE 0F 58 FA F3 0F 58 EF 25 00 00 00 80 66 0F 6E C0 66 0F 70 DF 55 F3 0F 58 EC F3 0F 58 EB 0F 57 C5 C3 81 C2 D7 B3 DD 07 81 FA 00 00 00 06 73 66 B9 AB AA 2A BE 66 0F 6E C9 66 0F 70 E8 00 F3 0F 59 C0 BA 9A 99 99 BD 66 0F 6E D2 F3 0F 59 CD 66 0F 70 E5 00 F3 0F 59 D5 F3 0F 10 35 ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? 66 0F 70 D8 00 F3 0F 59 C0 F3 0F 59 CB F3 0F 5C E7 F3 0F 59 C2 F3 0F 58 FC F3 0F 58 CE F3 0F 5C EF F3 0F 58 C1 F3 0F 5C C5 F3 0F 5C C4 C3 81 EA 00 00 FE 07 81 FA 00 00 02 00 0F 83 DD 00 00 00 B9 FF FF FF 7F 66 0F 6E F9 0F 54 F8 BA 00 00 00 3F 66 0F 6E E2 B9 9A 99 99 BD 66 0F 6E C9 F3 0F 59 FC BA AB AA 2A BE 66 0F 6E D2 F3 0F 5C E7 BA 6E DB 36 BD 66 0F 6E DA 66 0F 70 FC 00 F3 0F 51 E4 F3 0F 59 CF 66 0F 70 EF 00 25 00 00 00 80 C1 E8 1F F7 D8 66 0F 6E C0 F3 0F 59 FF F3 0F 58 D1 B9 00 F0 FF FF 66 0F 6E C9 F3 0F 59 DF 66 0F 70 C0 00 F3 0F 58 D3 0F 54 05 ?? ?? ?? ?? F3 0F 59 D5 0F 54 CC 66 0F 70 DC 00 F3 0F 5C E1 F3 0F 58 DB F3 0F 59 C9 F3 0F 5C DC F3 0F 5C E9 F3 0F 59 E3 66 0F 70 DB 55 F3 0F 5C EC F3 0F 5E EB F3 0F 58 DB F3 0F 59 D3 F3 0F 58 D0 25 00 00 00 80 35 00 00 00 80 66 0F 6E F0 66 0F 70 C0 55 F3 0F 5C D5 F3 0F 5C D3 F3 0F 58 C2 0F 57 C6 C3 81 C2 00 00 7E 3F 81 FA 00 00 80 37 72 21 81 FA 00 00 80 3F 74 50 81 FA 00 00 80 7F 77 40 BA 00 00 80 7F 66 0F 6E CA 0F 57 C0 F3 0F 59 C1 C3 66 0F 70 C8 00 F3 0F 10 15 ?? ?? ?? ?? 66 0F 70 D8 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C CA F3 0F 58 D1 F3 0F 5C D3 F3 0F 58 C2 F3 0F 5C C1 C3 0F 57 FF F3 0F 58 C7 C3 25 00 00 00 80 C1 E8 1F F7 D8 66 0F 6E C0 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? 0F 54 D0 0F 54 C1 F3 0F 58 C2 C3 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "__modf_default"
		size = 271
		refs = "000d __ctrlfp 0019 _newcw 0040 __d_ind 0050 __sptype 0075 __handle_qnan1 0096 __copysign 00af __real@3ff0000000000000 00c7 __except1 00d7 __frnd"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 6A 00 6A 00 E8 ?? ?? ?? ?? BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B 7D 0E B8 F0 7F 00 00 83 C4 10 8B CF 23 C8 51 51 66 3B C8 0F 85 92 00 00 00 DD 05 ?? ?? ?? ?? 8B 7D 10 DD 1F DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 59 59 85 C0 7E 4F 83 F8 02 7E 22 83 F8 03 75 45 DD 45 08 53 51 DD 1F DD 45 08 51 DD 1C 24 6A 1C E8 ?? ?? ?? ?? 83 C4 10 E9 89 00 00 00 DD 45 08 83 EC 10 DD 1F DD 45 08 DD 5C 24 08 D9 EE DD 1C 24 E8 ?? ?? ?? ?? DD 5D 08 56 53 E8 ?? ?? ?? ?? 83 C4 18 EB 5E DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 17 DD 5C 24 08 DD 45 08 DD 1C 24 6A 1C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 3A DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 10 DD 10 59 DC 6D 08 59 DD 5D 08 D9 EE DC 5D 08 DF E0 F6 C4 44 7A 0A 81 E7 00 80 00 00 66 09 7D 0E 56 53 E8 ?? ?? ?? ?? 59 59 DD 45 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_406_3_0 {
	meta:
		name = "__mbstok_s_l"
		size = 463
		refs = "0014 __errno 0024 __invalid_parameter 0067 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0079 _strtok_s 00af __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 57 8B 7D 10 33 DB 3B FB 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 99 01 00 00 39 5D 0C 74 DC 56 8B 75 08 3B F3 75 21 39 1F 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 57 01 00 00 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 22 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F4 0F 84 41 01 00 00 8B 4D F0 83 61 70 FD E9 35 01 00 00 3B F3 75 6E 8B 37 EB 6A 8B 7D 0C 8B C7 38 18 74 44 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 18 8D 47 01 8A 08 3A CB 74 1C 8A 17 3A 16 75 05 3A 4E 01 74 1D 8B F8 EB 06 8A 07 3A 06 74 13 47 38 1F 75 CA EB 0C 47 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 1F 74 2A 8D 45 E8 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 46 38 1E 74 07 46 38 1E 75 92 EB 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 89 75 F8 EB 6F 8B 7D 0C 8B C7 89 5D FC 38 18 74 42 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 18 8D 47 01 8A 08 3A CB 74 1C 8A 17 3A 16 75 05 3A 4E 01 74 14 8B F8 EB 06 8A 07 3A 06 74 11 47 38 1F 75 CA EB 0A 47 EB 07 C7 45 FC 01 00 00 00 38 1F 75 23 8D 45 E8 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 09 8D 46 01 38 18 74 16 8B F0 46 38 1E 75 8D EB 0F 88 1E 46 39 5D FC 74 07 88 1E 46 EB 02 88 1E 8B 45 10 89 30 39 75 F8 75 10 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 0F 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_407_10_0 {
	meta:
		name = "__winput_l"
		size = 4353
		refs = "000c ___security_cookie 0061 __errno 0071 __invalid_parameter 008e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b8 _iswctype 00db __whiteout 00e5 __un_inc 0187 _isdigit 031f __fgetwc_nolock 0494 ___check_float_string 04f6 __mbtowc_l 080b __malloc_crt 082a _wcstombs_s 0845 __invoke_watson 0865 __cfltcvt_tab 086a __decode_pointer 0873 _free 0a3d _memset 0c33 _wctomb_s 0db9 __allmul 0dd4 _isxdigit 0df8 __hextodec 10fb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 40 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 14 8B 45 08 56 33 F6 57 8B 7D 0C 89 8D DC FC FF FF 8D 8D 40 FD FF FF 89 85 24 FD FF FF 89 8D 1C FD FF FF C7 85 EC FC FF FF 5E 01 00 00 89 B5 F0 FC FF FF 89 B5 F4 FC FF FF 89 B5 D8 FC FF FF 89 B5 34 FD FF FF 3B FE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 73 10 00 00 3B C6 74 DC FF 75 10 8D 8D C4 FC FF FF E8 ?? ?? ?? ?? 0F B7 07 C6 85 23 FD FF FF 00 89 B5 38 FD FF FF 89 B5 F8 FC FF FF 66 3B C6 0F 84 29 10 00 00 53 6A 08 50 33 F6 E8 ?? ?? ?? ?? 59 59 85 C0 74 41 FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 24 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 50 E8 ?? ?? ?? ?? 59 59 47 47 0F B7 07 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ED E9 4A 0F 00 00 0F B7 07 6A 25 59 8B D1 66 3B D0 0F 85 DA 0E 00 00 66 3B 57 02 0F 84 D0 0E 00 00 89 B5 E8 FC FF FF 89 B5 C0 FC FF FF 89 B5 18 FD FF FF 89 B5 0C FD FF FF 89 B5 2C FD FF FF 89 B5 E4 FC FF FF C6 85 13 FD FF FF 00 C6 85 21 FD FF FF 00 C6 85 2B FD FF FF 00 C6 85 3F FD FF FF 00 C6 85 22 FD FF FF 00 C6 85 33 FD FF FF 00 C6 85 2A FD FF FF 01 33 F6 47 47 0F B7 1F F7 C3 00 FF 00 00 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 2C FD FF FF FF 85 0C FD FF FF 6B C0 0A 8D 44 18 D0 89 85 2C FD FF FF E9 D0 00 00 00 83 FB 4E 0F 8F 8D 00 00 00 0F 84 C1 00 00 00 83 FB 2A 74 7A 83 FB 46 0F 84 B3 00 00 00 83 FB 49 74 10 83 FB 4C 75 7E FE 85 2A FD FF FF E9 9E 00 00 00 0F B7 4F 02 66 83 F9 36 75 1F 8D 47 04 66 83 38 34 75 16 FF 85 E4 FC FF FF 8B F8 89 B5 04 FD FF FF 89 B5 08 FD FF FF EB 75 66 83 F9 33 75 0D 8D 47 04 66 83 38 32 75 04 8B F8 EB 62 66 83 F9 64 74 5C 66 83 F9 69 74 56 66 83 F9 6F 74 50 66 83 F9 78 74 4A 66 83 F9 58 75 19 EB 42 FE 85 2B FD FF FF EB 3A 83 FB 68 74 29 83 FB 6C 74 0D 83 FB 77 74 17 FE 85 3F FD FF FF EB 23 8D 47 02 66 83 38 6C 74 8F FE 85 2A FD FF FF FE 85 33 FD FF FF EB 0C FE 8D 2A FD FF FF FE 8D 33 FD FF FF 80 BD 3F FD FF FF 00 0F 84 EA FE FF FF 80 BD 2B FD FF FF 00 89 BD 00 FD FF FF 75 17 8B 85 DC FC FF FF 8B 30 89 85 D4 FC FF FF 83 C0 04 89 85 DC FC FF FF 80 BD 33 FD FF FF 00 89 B5 FC FC FF FF C6 85 3F FD FF FF 00 75 1D 0F B7 07 66 83 F8 53 74 0D C6 85 33 FD FF FF 01 66 83 F8 43 75 07 C6 85 33 FD FF FF FF 0F B7 1F 83 CB 20 89 9D 14 FD FF FF 83 FB 6E 74 52 83 FB 63 74 18 83 FB 7B 74 13 FF B5 24 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 11 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 B9 FF FF 00 00 89 85 34 FD FF FF 66 3B C8 0F 84 3C 0D 00 00 8B B5 FC FC FF FF 8B BD 00 FD FF FF 8B 8D 0C FD FF FF 85 C9 74 0D 83 BD 2C FD FF FF 00 0F 84 06 0D 00 00 83 FB 6F 0F 8F 1B 06 00 00 0F 84 71 09 00 00 83 FB 63 0F 84 09 05 00 00 6A 64 58 3B D8 0F 84 5D 09 00 00 0F 8E 25 06 00 00 83 FB 67 7E 4A 83 FB 69 74 21 83 FB 6E 0F 85 12 06 00 00 80 BD 2B FD FF FF 00 8B BD 38 FD FF FF 0F 84 FF 0B 00 00 E9 26 0C 00 00 89 85 14 FD FF FF 8B 9D 34 FD FF FF 6A 2D 58 66 3B C3 0F 85 4C 07 00 00 C6 85 21 FD FF FF 01 E9 48 07 00 00 6A 2D 58 33 DB 66 3B 85 34 FD FF FF 75 0C 8B 8D 1C FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 21 FF 8D 2C FD FF FF FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 34 FD FF FF 83 BD 0C FD FF FF 00 75 07 83 8D 2C FD FF FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 8C 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 6A 66 0F BE 85 34 FD FF FF 8B 8D 1C FD FF FF FF 85 18 FD FF FF 66 89 04 59 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 EC FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D4 0B 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 34 FD FF FF A9 00 FF 00 00 0F 84 74 FF FF FF 8D 85 C4 FC FF FF 50 8B 85 C4 FC FF FF C7 85 E0 FC FF FF 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 85 E0 FC FF FF 50 E8 ?? ?? ?? ?? 0F B7 85 E0 FC FF FF 0F BE 8D 34 FD FF FF 83 C4 10 3B C1 0F 85 06 01 00 00 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 F2 00 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 8B 8D 1C FD FF FF 0F B7 C0 89 85 34 FD FF FF 66 8B 85 E0 FC FF FF 66 89 04 59 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 EC FC FF FF E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 F9 0A 00 00 F7 85 34 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 69 8B 85 1C FD FF FF 66 8B 8D 34 FD FF FF FF 85 18 FD FF FF 66 89 0C 58 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 EC FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 84 0A 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 34 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF 83 BD 18 FD FF FF 00 0F 84 94 01 00 00 6A 65 58 66 3B 85 34 FD FF FF 74 10 6A 45 58 66 3B 85 34 FD FF FF 0F 85 78 01 00 00 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 64 01 00 00 8B 8D 1C FD FF FF 6A 65 58 66 89 04 59 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 EC FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 E8 09 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 C0 6A 2D 59 89 85 34 FD FF FF 66 3B C8 75 2E 51 8B 8D 1C FD FF FF 58 66 89 04 59 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 99 09 00 00 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 33 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 75 08 21 85 2C FD FF FF EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 34 FD FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 74 69 8B 85 1C FD FF FF 66 8B 8D 34 FD FF FF FF 85 18 FD FF FF 66 89 0C 58 8D 85 F0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 1C FD FF FF 8D B5 EC FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 E3 08 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 34 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 34 FD FF FF E8 ?? ?? ?? ?? 83 BD 18 FD FF FF 00 59 59 0F 84 97 08 00 00 80 BD 2B FD FF FF 00 0F 85 EB 07 00 00 8B B5 EC FC FF FF 8B 8D 1C FD FF FF FF 85 F8 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 5D 08 00 00 8D 46 FF 50 FF B5 1C FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 85 C4 FC FF FF 50 0F BE 85 2A FD FF FF 57 FF B5 FC FC FF FF 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 59 07 00 00 85 C9 75 10 FF 85 2C FD FF FF C7 85 0C FD FF FF 01 00 00 00 80 BD 33 FD FF FF 00 7E 07 C6 85 22 FD FF FF 01 FF B5 24 FD FF FF FF 8D 38 FD FF FF FF B5 34 FD FF FF 8B FE E8 ?? ?? ?? ?? 59 59 83 BD 0C FD FF FF 00 74 14 8B 85 2C FD FF FF FF 8D 2C FD FF FF 85 C0 0F 84 B1 03 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D0 B8 FF FF 00 00 59 89 95 34 FD FF FF 66 3B C2 0F 84 74 03 00 00 83 FB 63 74 55 83 FB 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 5A 03 00 00 66 83 FA 20 75 3A 83 FB 7B 0F 85 4B 03 00 00 0F B7 C2 8B C8 33 DB 83 E1 07 43 D3 E3 8B 8D F4 FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 13 FD FF FF 33 C1 85 D8 8B 9D 14 FD FF FF 0F 84 1A 03 00 00 80 BD 2B FD FF FF 00 0F 85 06 03 00 00 80 BD 22 FD FF FF 00 0F 84 A8 02 00 00 66 89 16 46 46 E9 E4 02 00 00 8B C3 83 E8 70 0F 84 4A 03 00 00 83 E8 03 0F 84 FD FE FF FF 48 48 0F 84 40 03 00 00 83 E8 03 0F 84 11 FA FF FF 83 E8 03 74 33 8B 85 34 FD FF FF 66 39 07 0F 85 A0 06 00 00 FE 8D 23 FD FF FF 80 BD 2B FD FF FF 00 0F 85 0A 06 00 00 8B 85 D4 FC FF FF 89 85 DC FC FF FF E9 F9 05 00 00 80 BD 33 FD FF FF 00 7E 07 C6 85 22 FD FF FF 01 47 6A 5E 47 58 66 3B 07 75 0A 83 C7 02 C6 85 13 FD FF FF FF 83 BD F4 FC FF FF 00 75 23 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 F4 FC FF FF 85 C0 0F 84 52 06 00 00 C7 85 D8 FC FF FF 01 00 00 00 68 00 20 00 00 6A 00 FF B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 58 66 3B 07 75 13 50 8B 85 F4 FC FF FF 47 5E 47 C6 40 0B 20 E9 8D 00 00 00 8B B5 C0 FC FF FF E9 82 00 00 00 0F B7 C0 47 6A 2D 59 47 66 3B C8 75 59 66 85 F6 74 54 0F B7 0F 6A 5D 5A 66 3B D1 74 49 0F B7 C9 47 47 66 3B F1 73 05 0F B7 C1 EB 06 0F B7 C6 0F B7 F1 66 3B F0 77 2B 2B C6 40 0F B7 D6 0F B7 F0 8B 8D F4 FC FF FF 8B C2 C1 E8 03 03 C1 8B CA 83 E1 07 B3 01 D2 E3 08 18 42 4E 75 E4 8B 9D 14 FD FF FF 33 F6 EB 1C 8B 95 F4 FC FF FF 0F B7 C8 0F B7 F0 8B C1 C1 E8 03 03 C2 83 E1 07 B2 01 D2 E2 08 10 0F B7 07 6A 5D 59 66 3B C8 0F 85 6F FF FF FF 66 83 3F 00 0F 84 72 05 00 00 8B B5 FC FC FF FF 89 BD 00 FD FF FF E9 8D FD FF FF 6A 2B 58 66 3B C3 75 30 FF 8D 2C FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF 6A 30 58 66 3B C3 0F 85 D3 01 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 6A 78 5E 8B C6 89 9D 34 FD FF FF 66 3B C3 74 5C 6A 58 58 66 3B C3 74 54 C7 85 18 FD FF FF 01 00 00 00 39 B5 14 FD FF FF 74 26 83 BD 0C FD FF FF 00 74 0E FF 8D 2C FD FF FF 75 06 FE 85 3F FD FF FF C7 85 14 FD FF FF 6F 00 00 00 E9 6E 01 00 00 FF B5 24 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 4C 01 00 00 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 0C FD FF FF 00 0F B7 D8 59 89 9D 34 FD FF FF 74 16 83 AD 2C FD FF FF 02 83 BD 2C FD FF FF 01 7D 06 FE 85 3F FD FF FF 89 B5 14 FD FF FF E9 0D 01 00 00 83 A5 E8 FC FF FF 00 52 6A 05 8D 85 E8 FC FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 22 83 F8 16 74 09 83 F8 22 0F 85 72 FC FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 E9 5E FC FF FF 03 B5 E8 FC FF FF 89 B5 FC FC FF FF E9 4D FC FF FF 47 47 E9 46 FC FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 59 3B FE 0F 84 E3 03 00 00 80 BD 2B FD FF FF 00 0F 85 37 03 00 00 FF 85 F8 FC FF FF 83 FB 63 0F 84 28 03 00 00 80 BD 22 FD FF FF 00 74 10 8B 8D FC FC FF FF 33 C0 66 89 01 E9 0F 03 00 00 8B 85 FC FC FF FF C6 00 00 E9 01 03 00 00 C6 85 2A FD FF FF 01 8B 9D 34 FD FF FF 6A 2D 58 66 3B C3 75 09 C6 85 21 FD FF FF 01 EB 08 6A 2B 58 66 3B C3 75 30 FF 8D 2C FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 89 9D 34 FD FF FF 83 BD E4 FC FF FF 00 0F 84 63 01 00 00 80 BD 3F FD FF FF 00 0F 85 1F 01 00 00 BF 00 FF 00 00 83 BD 14 FD FF FF 78 74 72 83 BD 14 FD FF FF 70 74 69 85 DF 0F 85 EC 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 DA 00 00 00 83 BD 14 FD FF FF 6F 75 27 6A 38 58 66 3B C3 0F 86 C5 00 00 00 8B 85 08 FD FF FF 8B B5 04 FD FF FF 0F A4 F0 03 C1 E6 03 89 85 08 FD FF FF EB 5E 6A 00 6A 0A FF B5 08 FD FF FF FF B5 04 FD FF FF E8 ?? ?? ?? ?? 8B F0 89 95 08 FD FF FF EB 3F 85 DF 0F 85 83 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 75 8B 85 08 FD FF FF 8B B5 04 FD FF FF 0F A4 F0 04 53 C1 E6 04 89 85 08 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 18 FD FF FF 0F B7 C3 83 E8 30 99 03 F0 11 95 08 FD FF FF 83 BD 0C FD FF FF 00 89 B5 04 FD FF FF 74 08 FF 8D 2C FD FF FF 74 34 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF E9 FA FE FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 21 FD FF FF 00 8B BD E8 FC FF FF 0F 84 01 01 00 00 8B 85 04 FD FF FF 8B 8D 08 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 04 FD FF FF 89 8D 08 FD FF FF E9 DD 00 00 00 80 BD 3F FD FF FF 00 8B BD E8 FC FF FF 0F 85 BF 00 00 00 BE 00 FF 00 00 83 BD 14 FD FF FF 78 74 3A 83 BD 14 FD FF FF 70 74 31 85 DE 0F 85 8C 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 7E 83 BD 14 FD FF FF 6F 75 0D 6A 38 58 66 3B C3 76 6D C1 E7 03 EB 2A 6B FF 0A EB 25 85 DE 75 5F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 51 53 C1 E7 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 18 FD FF FF 83 BD 0C FD FF FF 00 0F B7 C3 8D 7C 07 D0 74 08 FF 8D 2C FD FF FF 74 34 FF B5 24 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF E9 5A FF FF FF FF B5 24 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 21 FD FF FF 00 74 02 F7 DF 83 BD 14 FD FF FF 46 75 07 83 A5 18 FD FF FF 00 83 BD 18 FD FF FF 00 0F 84 E0 00 00 00 80 BD 2B FD FF FF 00 75 38 FF 85 F8 FC FF FF 8B B5 FC FC FF FF 83 BD E4 FC FF FF 00 74 13 8B 85 04 FD FF FF 89 06 8B 85 08 FD FF FF 89 46 04 EB 10 80 BD 2A FD FF FF 00 74 04 89 3E EB 03 66 89 3E 8B BD 00 FD FF FF FE 85 23 FD FF FF 47 47 89 BD 00 FD FF FF EB 3C 8B D1 66 3B D0 75 0A 8D 47 02 66 3B 08 75 02 8B F8 FF }
	condition:
		$1
}

rule file_408_1_0 {
	meta:
		name = "_parse_cmdline"
		size = 410
		refs = "0056 __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 10 53 33 C0 56 89 07 8B F2 8B 55 0C C7 01 01 00 00 00 39 45 08 74 09 8B 5D 08 83 45 08 04 89 13 89 45 FC 80 3E 22 75 10 33 C0 39 45 FC B3 22 0F 94 C0 46 89 45 FC EB 3C FF 07 85 D2 74 08 8A 06 88 02 42 89 55 0C 8A 1E 0F B6 C3 50 46 E8 ?? ?? ?? ?? 59 85 C0 74 13 FF 07 83 7D 0C 00 74 0A 8B 4D 0C 8A 06 FF 45 0C 88 01 46 8B 55 0C 8B 4D 10 84 DB 74 32 83 7D FC 00 75 A9 80 FB 20 74 05 80 FB 09 75 9F 85 D2 74 04 C6 42 FF 00 83 65 FC 00 80 3E 00 0F 84 E9 00 00 00 8A 06 3C 20 74 04 3C 09 75 06 46 EB F3 4E EB E3 80 3E 00 0F 84 D0 00 00 00 83 7D 08 00 74 09 8B 45 08 83 45 08 04 89 10 FF 01 33 DB 43 33 C9 EB 02 46 41 80 3E 5C 74 F9 80 3E 22 75 26 F6 C1 01 75 1F 83 7D FC 00 74 0C 8D 46 01 80 38 22 75 04 8B F0 EB 0D 33 C0 33 DB 39 45 FC 0F 94 C0 89 45 FC D1 E9 85 C9 74 12 49 85 D2 74 04 C6 02 5C 42 FF 07 85 C9 75 F1 89 55 0C 8A 06 84 C0 74 55 83 7D FC 00 75 08 3C 20 74 4B 3C 09 74 47 85 DB 74 3D 0F BE C0 50 85 D2 74 23 E8 ?? ?? ?? ?? 59 85 C0 74 0D 8A 06 8B 4D 0C FF 45 0C 88 01 46 FF 07 8B 4D 0C 8A 06 FF 45 0C 88 01 EB 0D E8 ?? ?? ?? ?? 59 85 C0 74 03 46 FF 07 FF 07 8B 55 0C 46 E9 56 FF FF FF 85 D2 74 07 C6 02 00 42 89 55 0C FF 07 8B 4D 10 E9 0E FF FF FF 8B 45 08 5E 5B 85 C0 74 03 83 20 00 FF 01 C9 C3 }
	condition:
		$1
}

rule file_408_2_0 {
	meta:
		name = "__setargv"
		size = 187
		refs = "000f ___mbctype_initialized 0016 ___initmbctable 0020 ?_pgmname@?1??_setargv@@9@9 002e __imp__GetModuleFileNameA@12 0033 __acmdln 0039 __pgmptr 0058 _parse_cmdline 007f __malloc_crt 00a5 ___argc 00ab ___argv"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 33 DB 56 57 39 1D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 BE ?? ?? ?? ?? 56 53 88 1D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 3B C3 74 07 89 45 FC 38 18 75 03 89 75 FC 8B 55 FC 8D 45 F8 50 53 53 8D 7D F4 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 3D FF FF FF 3F 73 4A 8B 4D F4 83 F9 FF 73 42 8B F8 C1 E7 02 8D 04 0F 3B C1 72 36 50 E8 ?? ?? ?? ?? 8B F0 59 3B F3 74 29 8B 55 FC 8D 45 F8 50 03 FE 57 56 8D 7D F4 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 48 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 33 C0 EB 03 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "__fcloseall"
		size = 159
		refs = "0003 __sehtable$__fcloseall 0008 __SEH_prolog4 0014 __lock 0024 __nstream 0030 ___piob 0044 _fclose 0064 __imp__DeleteCriticalSection@4 0071 _free 0091 __SEH_epilog4 0099 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 6A 01 E8 ?? ?? ?? ?? 59 89 5D FC 6A 03 5F 89 7D E0 3B 3D ?? ?? ?? ?? 7D 57 8B F7 C1 E6 02 A1 ?? ?? ?? ?? 03 C6 39 18 74 44 8B 00 F6 40 0C 83 74 0F 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 03 FF 45 E4 83 FF 14 7C 28 A1 ?? ?? ?? ?? 8B 04 06 83 C0 20 50 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? FF 34 06 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? 89 1C 06 47 EB 9E C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "__spawnl"
		size = 79
		refs = "0010 __errno 0020 __invalid_parameter 0045 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 20 38 19 74 DF 8B 45 10 3B C3 74 D8 38 18 74 D4 53 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5B 5D C3 }
	condition:
		$1
}

rule file_411_3_0 {
	meta:
		name = "__mbsncat_l"
		size = 292
		refs = "0021 __errno 0031 __invalid_parameter 006d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 007f _strncat 00af __ismbslead_l 00f1 __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 33 DB 39 5D 10 75 08 8B 45 08 E9 09 01 00 00 56 8B 75 08 3B F3 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E1 00 00 00 57 8B 7D 0C 3B FB 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B9 00 00 00 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 39 58 08 75 22 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F8 0F 84 90 00 00 00 8B 4D F4 83 61 70 FD E9 84 00 00 00 89 75 FC 8A 06 46 84 C0 75 F9 8D 45 EC 50 4E 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 01 4E 8A 07 8B 55 F0 FF 4D 10 0F B6 C8 F6 44 11 1D 04 88 06 74 33 46 47 8A 07 88 06 46 47 3A C3 75 2D 88 5E FE 8B 7D FC 3B F7 74 2A 8D 45 EC 50 8B C6 2B C7 48 50 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 12 88 5E FF EB 0F 46 47 3A C3 74 D6 39 5D 10 75 AE EB CF 88 1E 38 5D F8 74 07 8B 45 F4 83 60 70 FD 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_412_3_0 {
	meta:
		name = "__mbsspnp_l"
		size = 209
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 _strspn 003d __errno 004d __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 16 FF 75 0C 8B 75 08 56 E8 ?? ?? ?? ?? 59 59 8D 0C 30 E9 83 00 00 00 8B 4D 08 3B CB 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 69 39 5D 0C 74 D3 38 19 74 4B 57 8B 45 0C EB 28 8A 10 0F B6 FA F6 44 37 1D 04 74 17 3A 11 75 08 8A 50 01 3A 51 01 74 14 8D 50 01 38 1A 74 0D 8B C2 EB 04 3A 11 74 05 40 38 18 75 D4 38 18 74 14 0F B6 01 F6 44 30 1D 04 74 05 41 38 19 74 05 41 38 19 75 B7 5F 0F B6 01 F7 D8 1B C0 23 C1 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "_findenv"
		size = 82
		refs = "0008 __environ 0014 __mbsnbicoll"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 35 ?? ?? ?? ?? EB 21 57 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 06 8A 04 07 3C 3D 74 1D 84 C0 74 19 83 C6 04 8B 06 85 C0 75 D9 8B C6 2B 05 ?? ?? ?? ?? C1 F8 02 F7 D8 5E 5D C3 8B C6 2B 05 ?? ?? ?? ?? C1 F8 02 EB F0 }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "_copy_environ"
		size = 90
		refs = "0024 __calloc_crt 0036 __amsg_exit 003e __strdup"
	strings:
		$1 = { 8B FF 55 8B EC 51 57 8B F8 33 C0 8B CF 85 FF 74 46 39 07 74 09 83 C1 04 40 83 39 00 75 F7 56 40 6A 04 50 E8 ?? ?? ?? ?? 8B F0 59 59 89 75 FC 85 F6 75 18 6A 09 E8 ?? ?? ?? ?? EB 0E 50 E8 ?? ?? ?? ?? 89 06 83 C6 04 83 C7 04 59 8B 07 85 C0 75 EB 21 06 8B 45 FC 5E 5F C9 C3 }
	condition:
		$1
}

rule file_669_2_0 {
	meta:
		name = "_copy_environ"
		size = 90
		refs = "0024 __calloc_crt 0036 __amsg_exit 003e __wcsdup"
	strings:
		$1 = { 8B FF 55 8B EC 51 57 8B F8 33 C0 8B CF 85 FF 74 46 39 07 74 09 83 C1 04 40 83 39 00 75 F7 56 40 6A 04 50 E8 ?? ?? ?? ?? 8B F0 59 59 89 75 FC 85 F6 75 18 6A 09 E8 ?? ?? ?? ?? EB 0E 50 E8 ?? ?? ?? ?? 89 06 83 C6 04 83 C7 04 59 8B 07 85 C0 75 EB 21 06 8B 45 FC 5E 5F C9 C3 }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "___crtsetenv"
		size = 587
		refs = "0016 __errno 0026 __invalid_parameter 0041 __mbschr 0060 __environ 0066 ___initenv 006d _copy_environ 0081 __wenviron 0088 ___wtomb_environ 00af __malloc_crt 00ee _findenv 0103 _free 013e __recalloc_crt 01aa _strlen 01b3 __calloc_crt 01cc _strcpy_s 01dd __invoke_watson 01fd __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 53 33 DB 89 5D F4 3B C3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6E 56 8B 30 57 89 75 FC 3B F3 74 53 6A 3D 56 E8 ?? ?? ?? ?? 8B F8 59 59 89 7D EC 3B FB 74 40 3B F7 74 3C 33 C0 38 5F 01 0F 94 C0 89 45 F8 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 3B C3 75 60 39 5D 0C 74 24 39 1D ?? ?? ?? ?? 74 1C E8 ?? ?? ?? ?? 85 C0 74 4A E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5E 5B C9 C3 39 5D F8 0F 85 98 01 00 00 6A 04 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 3B C3 74 DE 89 18 39 1D ?? ?? ?? ?? 75 13 6A 04 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 3B C3 74 C3 89 18 8B 35 ?? ?? ?? ?? 89 75 F0 3B F3 74 B4 2B 7D FC FF 75 FC E8 ?? ?? ?? ?? 8B F8 3B FB 59 7C 52 39 1E 74 4E 8D 34 BE FF 36 E8 ?? ?? ?? ?? 59 39 5D F8 75 1B 8B 45 FC 89 06 8B 45 08 89 18 E9 82 00 00 00 8B 46 04 89 06 8B 45 F0 47 8D 34 B8 39 1E 75 F0 81 FF FF FF FF 3F 73 6A 6A 04 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 55 EB 4E 39 5D F8 0F 85 E2 00 00 00 3B FB 7D 02 F7 DF 8D 47 02 3B C7 0F 8C 36 FF FF FF 3D FF FF FF 3F 0F 83 2B FF FF FF 50 6A 04 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 3B C3 0F 84 12 FF FF FF 8B 55 FC 8D 0C B8 89 11 89 59 04 8B 4D 08 89 19 A3 ?? ?? ?? ?? 39 5D 0C 74 78 8B 75 FC 6A 01 56 E8 ?? ?? ?? ?? 40 59 40 50 E8 ?? ?? ?? ?? 8B F8 59 59 3B FB 74 5C 56 56 E8 ?? ?? ?? ?? 40 59 40 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 4D F8 8B C7 2B C6 03 45 EC 88 18 40 F7 D9 1B C9 F7 D1 23 C8 51 57 FF 15 ?? ?? ?? ?? 85 C0 75 0F 83 4D F4 FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 57 E8 ?? ?? ?? ?? 59 39 5D F8 74 0E FF 75 FC E8 ?? ?? ?? ?? 8B 45 08 59 89 18 8B 45 F4 E9 68 FE FF FF FF 75 FC E8 ?? ?? ?? ?? 8B 45 08 59 89 18 33 C0 E9 53 FE FF FF }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__CIasin_pentium4"
		size = 1408
		refs = "0022 ABSVALMASK 002a ONEMASK 0036 TMASK 0094 T_table 00a1 Tbl_addr 00cd cv 0165 HALFMASK2 01c1 PI_BY_2 0279 cv2 02fe HALFMASK 04d4 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 CE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 F9 83 EC 10 66 0F 57 E2 F2 0F 59 EB F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 F2 0F 58 C6 F2 0F 58 C4 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D BB 03 00 00 83 F8 43 0F 83 19 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 66 0F D7 C7 66 0F 73 F0 01 66 0F 54 3D ?? ?? ?? ?? 66 0F 73 D0 01 F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 80 00 00 00 C1 E0 08 F2 0F 59 C6 F2 0F 59 CE 83 EC 10 F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 66 0F C4 F0 03 F2 0F 58 C5 66 0F 70 DB EE F2 0F 5C C4 F2 0F 58 C3 66 0F 56 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 BB 3B 00 00 3D 00 38 00 00 73 6A 66 0F 14 FF 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 CF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 FF 83 EC 10 66 0F 59 CF 66 0F 59 F7 66 0F 59 FF F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E7 F2 0F 59 CB 66 0F 58 F4 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D FE 3B 00 00 83 F8 02 0F 83 4F 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 66 0F C5 C7 03 66 0F 54 3D ?? ?? ?? ?? 66 0F 70 EB 44 66 0F 54 1D ?? ?? ?? ?? F2 0F 10 CF 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C C7 F2 0F 59 FF F2 0F 58 C9 F2 0F 59 C8 F2 0F 5C E7 F2 0F 10 F3 F2 0F 59 DB F2 0F 59 C0 F2 0F 5C E1 F2 0F 5C F5 F2 0F 58 ED F2 0F 5C E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 70 DD EE F2 0F 5C E0 F2 0F 58 EE 66 0F 70 FB EE F2 0F 58 DB F2 0F 59 EE F2 0F 58 E5 66 0F 70 F7 EE F2 0F 5E E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 FF F2 0F 10 DE 66 0F 59 D7 66 0F 59 F7 25 00 80 00 00 F2 0F 59 CF 66 0F 59 FF 66 0F 58 EA 66 0F 28 D6 F2 0F 59 F6 66 0F 59 F8 66 0F 28 05 ?? ?? ?? ?? F2 0F 59 D6 66 0F 58 FD 66 0F 70 E9 EE F2 0F 59 F2 83 EC 10 66 0F 59 FA F2 0F 58 CD 66 0F 57 ED 66 0F 70 D7 EE F2 0F 59 CE 66 0F 70 F0 EE F2 0F 58 FA F2 0F 10 D3 66 0F C4 E8 03 F2 0F 5C DE F2 0F 58 C1 F2 0F 58 F3 F2 0F 58 FC F2 0F 5C D6 F2 0F 5C C7 F2 0F 5C C2 F2 0F 5C C3 66 0F 56 C5 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 F7 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 0F 84 85 00 00 00 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 0F 8D 8F 00 00 00 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 BA 3D 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 58 C6 BA F1 03 00 00 E9 74 FF FF FF 66 0F 12 44 24 04 66 0F 57 F6 83 EC 10 F2 0F 10 F8 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "__flush"
		size = 104
		refs = "0030 __fileno 0037 __write"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B 46 0C 8B C8 80 E1 03 33 DB 80 F9 02 75 40 A9 08 01 00 00 74 39 8B 46 08 57 8B 3E 2B F8 85 FF 7E 2C 57 50 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 0F 8B 46 0C 84 C0 79 0F 83 E0 FD 89 46 0C EB 07 83 4E 0C 20 83 CB FF 5F 8B 46 08 83 66 04 00 89 06 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_416_1_0 {
	meta:
		name = "__fflush_nolock"
		size = 72
		refs = "000f _flsall 0018 __flush 0031 __fileno 0037 __commit"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 09 56 E8 ?? ?? ?? ?? 59 EB 2F 56 E8 ?? ?? ?? ?? 59 85 C0 74 05 83 C8 FF EB 1F F7 46 0C 00 40 00 00 74 14 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_416_2_0 {
	meta:
		name = "_flsall"
		size = 218
		refs = "0003 __sehtable$_flsall 0008 __SEH_prolog4 0017 __lock 0026 __nstream 0031 ___piob 0047 __lock_file2 006a __fflush_nolock 00ac __unlock_file2 00cc __SEH_epilog4 00d4 __unlock"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 89 7D DC 6A 01 E8 ?? ?? ?? ?? 59 89 7D FC 33 F6 89 75 E0 3B 35 ?? ?? ?? ?? 0F 8D 83 00 00 00 A1 ?? ?? ?? ?? 8D 04 B0 39 38 74 5E 8B 00 F6 40 0C 83 74 56 50 56 E8 ?? ?? ?? ?? 59 59 33 D2 42 89 55 FC A1 ?? ?? ?? ?? 8B 04 B0 8B 48 0C F6 C1 83 74 2F 39 55 08 75 11 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1E FF 45 E4 EB 19 39 7D 08 75 14 F6 C1 02 74 0F 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 03 09 45 DC 89 7D FC E8 08 00 00 00 46 EB 84 33 FF 8B 75 E0 A1 ?? ?? ?? ?? FF 34 B0 56 E8 ?? ?? ?? ?? 59 59 C3 C7 45 FC FE FF FF FF E8 12 00 00 00 83 7D 08 01 8B 45 E4 74 03 8B 45 DC E8 ?? ?? ?? ?? C3 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_416_3_0 {
	meta:
		name = "_fflush"
		size = 83
		refs = "0003 __sehtable$_fflush 0008 __SEH_prolog4 0015 _flsall 0020 __lock_file 002c __fflush_nolock 0044 __SEH_epilog4 004d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 75 08 75 09 56 E8 ?? ?? ?? ?? 59 EB 27 FF 75 08 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_417_2_0 {
	meta:
		name = "__stat64"
		size = 1003
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 0042 __invalid_parameter 0053 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0059 __mbspbrk 008f __mbctolower 009a __getdrive 00ae __imp__FindFirstFileA@8 00c2 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00ed __fullpath_helper 0100 _strlen 010b _IsRootUNCName 0116 __imp__GetDriveTypeA@4 012e _free 015e ___loctotime64_t 01c9 __imp__FileTimeToLocalFileTime@8 01e5 __imp__FileTimeToSystemTime@8 0365 __imp__FindClose@4 0371 ___dtoxmode 038c __allmul 03c2 __imp__GetLastError@0 03c8 __dosmaperr 03e5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 A0 FD FF FF 3B F3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 8B 03 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 60 03 00 00 80 7E 01 3A 75 1A 8A 06 3A C3 74 05 38 5E 02 74 D9 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 98 FD FF FF 8D 85 B8 FD FF FF 50 56 FF 15 ?? ?? ?? ?? 89 85 B4 FD FF FF 83 F8 FF 0F 85 E0 00 00 00 68 ?? ?? ?? ?? 56 89 9D B4 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 8B 8D 85 B4 FD FF FF 50 68 04 01 00 00 8D 85 F8 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 86 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 71 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 65 39 9D B4 FD FF FF 74 0C FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 B8 FD FF FF 10 00 00 00 89 9D D4 FD FF FF 89 9D D8 FD FF FF 88 9D E4 FD FF FF E8 ?? ?? ?? ?? 8B B5 A0 FD FF FF 8B CA 83 C4 1C 89 47 28 89 57 2C 89 47 20 89 4F 24 89 47 30 89 4F 34 E9 E5 01 00 00 39 9D B4 FD FF FF 0F 84 D3 FE FF FF FF B5 B4 FD FF FF E8 ?? ?? ?? ?? 59 E9 C2 FE FF FF 39 9D CC FD FF FF 75 10 39 9D D0 FD FF FF 75 08 89 5F 28 89 5F 2C EB 78 8D 85 9C FD FF FF 50 8D 85 CC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EB 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CF 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 39 9D C4 FD FF FF 75 16 39 9D C8 FD FF FF 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 78 8D 85 9C FD FF FF 50 8D 85 C4 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 55 01 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 39 01 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D BC FD FF FF 75 16 39 9D C0 FD FF FF 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 78 8D 85 9C FD FF FF 50 8D 85 BC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BF 00 00 00 8D 85 A4 FD FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 0F B7 85 B0 FD FF FF 6A FF 50 0F B7 85 AE FD FF FF 50 0F B7 85 AC FD FF FF 50 0F B7 85 AA FD FF FF 50 0F B7 85 A6 FD FF FF 50 0F B7 85 A4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 FF B5 B4 FD FF FF FF 15 ?? ?? ?? ?? 56 FF B5 B8 FD FF FF E8 ?? ?? ?? ?? 59 66 89 47 06 59 33 C0 40 50 53 53 FF B5 D4 FD FF FF 66 89 47 08 E8 ?? ?? ?? ?? 8B 8D D8 FD FF FF 33 F6 03 C1 13 D6 89 47 18 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 98 FD FF FF 48 89 07 89 47 10 89 57 1C 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 B4 FD FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "__getsystime"
		size = 130
		refs = "0014 __errno 0024 __invalid_parameter 0035 __imp__GetLocalTime@4 0075 __mktime32"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B 75 08 57 33 FF 3B F7 75 1C E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 4F 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 FC 83 4E 20 FF 89 06 0F B7 45 FA 89 46 04 0F B7 45 F8 89 46 08 0F B7 45 F6 89 46 0C 0F B7 45 F2 48 89 46 10 0F B7 45 F0 2D 6C 07 00 00 89 46 14 0F B7 45 F4 56 89 46 18 E8 ?? ?? ?? ?? 0F B7 45 FE 59 5F 5E C9 C3 }
	condition:
		$1
}

rule file_418_1_0 {
	meta:
		name = "__setsystime"
		size = 117
		refs = "0017 __mktime32 0060 __imp__SetLocalTime@4 006a __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B 75 08 85 F6 75 05 6A 57 58 EB 5D 56 E8 ?? ?? ?? ?? B8 6C 07 00 00 66 03 46 14 59 66 89 45 F0 66 8B 46 10 66 40 66 89 45 F2 66 8B 46 0C 66 89 45 F6 66 8B 46 08 66 89 45 F8 66 8B 46 04 66 89 45 FA 66 8B 06 66 89 45 FC 66 8B 45 0C 66 89 45 FE 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 5E C9 C3 }
	condition:
		$1
}

rule file_419_1_0 {
	meta:
		name = "?swprintf@@YAHPA_WIPB_WZZ"
		size = 131
		refs = "0041 __woutput_l 005f __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C C7 45 EC 42 00 00 00 3D FF FF FF 3F 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 53 56 8D 45 14 50 33 DB 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_420_10_0 {
	meta:
		name = "__vcprintf_p_l"
		size = 4704
		refs = "000c ___security_cookie 004e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0064 __errno 0074 __invalid_parameter 0135 ___lookuptable_s 0180 _strtol 01ac _memset 0251 $LN662 03bf __validate_param_reuseA 05a0 __isleadbyte_l 05b7 _write_char 07b1 _wctomb_s 08f4 ___nullstring 0900 _strlen 09cd __get_printf_count_output 0ac5 __malloc_crt 0b64 __cfltcvt_tab 0b69 __decode_pointer 0ef0 __aulldvrm 0f8f ___wnullstring 1080 _write_multi_char 1099 _write_string 116a _free 123a @__security_check_cookie@4 1240 $LN265 1244 $LN259 1248 $LN258 124c $LN250 1250 $LN238 1254 $LN237 1258 $LN225 125c $LN209"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 08 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 10 56 8B 75 08 57 FF 75 0C 33 FF 8D 8D CC FD FF FF 89 9D EC FD FF FF 89 BD 90 FD FF FF 89 BD F0 FD FF FF 89 BD B4 FD FF FF 89 BD 88 FD FF FF 89 BD 94 FD FF FF E8 ?? ?? ?? ?? 83 8D E4 FD FF FF FF 89 BD AC FD FF FF 3B F7 75 33 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 BD D8 FD FF FF 00 74 0A 8B 85 D4 FD FF FF 83 60 70 FD 83 C8 FF E9 9B 11 00 00 89 BD C0 FD FF FF 89 B5 74 FD FF FF 89 BD E0 FD FF FF 83 BD E0 FD FF FF 01 75 0C 39 BD E4 FD FF FF 0F 84 5B 11 00 00 8B B5 74 FD FF FF 83 8D A8 FD FF FF FF 83 8D C8 FD FF FF FF 83 8D E4 FD FF FF FF 89 BD 9C FD FF FF 8A 16 89 BD A0 FD FF FF 89 BD 8C FD FF FF 89 BD B0 FD FF FF 89 BD E8 FD FF FF 88 95 DC FD FF FF 84 D2 0F 84 FF 10 00 00 EB 0C 8B B5 C4 FD FF FF 8A 95 DC FD FF FF 46 39 BD C0 FD FF FF 89 B5 C4 FD FF FF 0F 8C 6D 10 00 00 8A C2 2C 20 3C 58 77 0F 0F BE C2 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 8B 8D A0 FD FF FF 6B C0 09 0F B6 9C 08 ?? ?? ?? ?? C1 EB 04 89 9D A0 FD FF FF 83 FB 01 0F 85 D3 00 00 00 80 3E 25 0F 84 E2 00 00 00 83 BD E4 FD FF FF FF 75 56 6A 0A 8D 85 AC FD FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 34 8B 85 AC FD FF FF 80 38 24 75 29 39 BD E0 FD FF FF 75 15 68 40 06 00 00 8D 85 34 F7 FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 E4 FD FF FF 01 00 00 00 EB 15 8A 95 DC FD FF FF 89 BD E4 FD FF FF 83 BD E4 FD FF FF 01 75 7A 6A 0A 8D 85 AC FD FF FF 50 56 E8 ?? ?? ?? ?? 8B C8 8B 85 AC FD FF FF 83 C4 0C 49 8D 50 01 89 8D C8 FD FF FF 89 95 C4 FD FF FF 39 BD E0 FD FF FF 75 28 3B CF 0F 8C 55 FE FF FF 80 38 24 0F 85 4C FE FF FF 83 F9 64 0F 8D 43 FE FF FF 3B 8D A8 FD FF FF 7E 06 89 8D A8 FD FF FF 8A 95 DC FD FF FF EB 18 83 FB 08 0F 84 24 FE FF FF 83 FB 07 0F 87 2E 0F 00 00 8B 9D A0 FD FF FF FF 24 9D ?? ?? ?? ?? 33 FF 39 BD E0 FD FF FF 75 0D 83 BD E4 FD FF FF 01 0F 84 0A 0F 00 00 83 BD E0 FD FF FF 01 0F 85 15 03 00 00 83 BD E4 FD FF FF FF 0F 85 08 03 00 00 E9 EB 0E 00 00 33 C0 83 8D E8 FD FF FF FF 89 85 84 FD FF FF 89 85 88 FD FF FF 89 85 B0 FD FF FF 89 85 B4 FD FF FF 89 85 F0 FD FF FF 89 85 94 FD FF FF E9 B9 0E 00 00 0F BE C2 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 48 48 74 15 83 E8 03 0F 85 9A 0E 00 00 83 8D F0 FD FF FF 08 E9 8E 0E 00 00 83 8D F0 FD FF FF 04 E9 82 0E 00 00 83 8D F0 FD FF FF 01 E9 76 0E 00 00 81 8D F0 FD FF FF 80 00 00 00 E9 67 0E 00 00 83 8D F0 FD FF FF 02 E9 5B 0E 00 00 80 FA 2A 0F 85 E5 00 00 00 33 F6 39 B5 E4 FD FF FF 75 15 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 40 FC E9 A6 00 00 00 6A 0A 8D 85 AC FD FF FF 50 FF B5 C4 FD FF FF E8 ?? ?? ?? ?? 8B 8D AC FD FF FF 83 C4 0C 48 8D 51 01 89 95 C4 FD FF FF 39 B5 E0 FD FF FF 75 6B 3B C6 7C 58 80 39 24 75 53 83 BD C8 FD FF FF 64 7D 4A 3B 85 A8 FD FF FF 7E 06 89 85 A8 FD FF FF C1 E0 04 8D 8C 05 34 F7 FF FF 39 31 75 13 C7 01 01 00 00 00 C6 84 05 3C F7 FF FF 2A E9 DF 02 00 00 FF B5 F0 FD FF FF 6A 2A 6A 01 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 A8 0D 00 00 E8 ?? ?? ?? ?? 56 56 56 56 56 E9 90 FC FF FF C1 E0 04 8B 84 05 38 F7 FF FF 8B 00 3B C6 89 85 B0 FD FF FF 0F 8D 7F 0D 00 00 83 8D F0 FD FF FF 04 F7 9D B0 FD FF FF E9 6D 0D 00 00 8B 85 B0 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 B0 FD FF FF E9 52 0D 00 00 83 A5 E8 FD FF FF 00 E9 46 0D 00 00 80 FA 2A 75 75 33 F6 39 B5 E4 FD FF FF 75 12 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 40 FC EB 3F 6A 0A 8D 85 AC FD FF FF 50 FF B5 C4 FD FF FF E8 ?? ?? ?? ?? 8B 8D AC FD FF FF 83 C4 0C 48 8D 51 01 89 95 C4 FD FF FF 39 B5 E0 FD FF FF 0F 84 EE FE FF FF C1 E0 04 8B 84 05 38 F7 FF FF 8B 00 3B C6 89 85 E8 FD FF FF 0F 8D D8 0C 00 00 83 8D E8 FD FF FF FF E9 CC 0C 00 00 8B 85 E8 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 E8 FD FF FF E9 B1 0C 00 00 80 FA 49 74 5A 80 FA 68 74 49 80 FA 6C 74 18 80 FA 77 0F 85 99 0C 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 8A 0C 00 00 8B 85 C4 FD FF FF 80 38 6C 75 15 FF 85 C4 FD FF FF 81 8D F0 FD FF FF 00 10 00 00 E9 6A 0C 00 00 83 8D F0 FD FF FF 10 E9 5E 0C 00 00 83 8D F0 FD FF FF 20 E9 52 0C 00 00 8B 8D C4 FD FF FF 8A 01 3C 36 75 1D 80 79 01 34 75 17 41 41 81 8D F0 FD FF FF 00 80 00 00 89 8D C4 FD FF FF E9 29 0C 00 00 3C 33 75 1D 80 79 01 32 75 17 41 41 81 A5 F0 FD FF FF FF 7F FF FF 89 8D C4 FD FF FF E9 08 0C 00 00 3C 64 74 6F 3C 69 74 6B 3C 6F 74 67 3C 75 74 63 3C 78 74 5F 3C 58 74 5B 33 FF 89 BD A0 FD FF FF 8D 85 CC FD FF FF 50 0F B6 C2 50 89 BD 94 FD FF FF E8 ?? ?? ?? ?? 59 85 C0 8A 85 DC FD FF FF 59 74 21 8D B5 C0 FD FF FF E8 ?? ?? ?? ?? 8B 85 C4 FD FF FF 8A 00 FF 85 C4 FD FF FF 84 C0 0F 84 92 FA FF FF 8D B5 C0 FD FF FF E8 ?? ?? ?? ?? E9 95 0B 00 00 81 8D F0 FD FF FF 00 00 01 00 E9 86 0B 00 00 0F BE C2 83 F8 64 0F 8F 0E 03 00 00 0F 84 03 04 00 00 83 F8 53 0F 8F FA 00 00 00 0F 84 AB 00 00 00 83 E8 41 74 17 6A 02 5F 2B C7 0F 84 83 00 00 00 2B C7 74 08 2B C7 0F 85 CF 09 00 00 80 C2 20 C7 85 84 FD FF FF 01 00 00 00 88 95 DC FD FF FF 83 8D F0 FD FF FF 40 33 C9 41 33 F6 39 8D E4 FD FF FF 0F 85 0A 04 00 00 39 B5 E0 FD FF FF 0F 85 FE 03 00 00 8B 85 C8 FD FF FF 83 F8 63 0F 87 5B FD FF FF C1 E0 04 8D 8C 05 34 F7 FF FF 39 31 0F 85 CA 03 00 00 C7 01 08 00 00 00 88 94 05 3C F7 FF FF 8B 8D F0 FD FF FF 89 8C 05 40 F7 FF FF E9 D2 0A 00 00 F7 85 F0 FD FF FF 30 08 00 00 75 7A 81 8D F0 FD FF FF 00 08 00 00 EB 6E F7 85 F0 FD FF FF 30 08 00 00 75 0A 81 8D F0 FD FF FF 00 08 00 00 8B BD E8 FD FF FF 83 FF FF 75 05 BF FF FF FF 7F 33 F6 39 B5 E4 FD FF FF 0F 85 60 08 00 00 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 48 FC E9 72 08 00 00 83 E8 58 0F 84 DE 04 00 00 48 48 0F 84 2C 01 00 00 83 E8 07 0F 84 21 FF FF FF 48 48 0F 85 D5 08 00 00 6A 02 5F 8B 9D F0 FD FF FF 33 F6 F7 C3 10 08 00 00 0F 84 8A 00 00 00 39 B5 E4 FD FF FF 75 13 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 0F B7 40 FC EB 43 8B 85 C8 FD FF FF 83 F8 63 0F 87 66 FC FF FF C1 E0 04 39 B5 E0 FD FF FF 75 1F 8D 8C 05 34 F7 FF FF 39 31 75 07 89 39 E9 0D 07 00 00 53 FF B5 DC FD FF FF 57 E9 03 01 00 00 8B 84 05 38 F7 FF FF 0F B7 00 50 68 00 02 00 00 8D 85 F4 FD FF FF 50 8D 85 9C FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 75 C7 85 88 FD FF FF 01 00 00 00 EB 69 39 B5 E4 FD FF FF 75 13 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 0F B7 40 FC EB 3E 8B 85 C8 FD FF FF 83 F8 63 0F 87 DC FB FF FF C1 E0 04 39 B5 E0 FD FF FF 75 1A 8D 8C 05 34 F7 FF FF 39 31 0F 84 80 06 00 00 53 FF B5 DC FD FF FF 6A 01 EB 7E 8B 84 05 38 F7 FF FF 0F B7 00 88 85 F4 FD FF FF C7 85 9C FD FF FF 01 00 00 00 8D 85 F4 FD FF FF 89 85 BC FD FF FF E9 BA 07 00 00 33 F6 39 B5 E4 FD FF FF 75 12 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 40 FC EB 56 8B 85 C8 FD FF FF 83 F8 63 0F 87 61 FB FF FF C1 E0 04 39 B5 E0 FD FF FF 75 33 8D 8C 05 34 F7 FF FF 39 31 0F 84 20 07 00 00 FF B5 F0 FD FF FF FF B5 DC FD FF FF 6A 03 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 28 FB FF FF E9 51 07 00 00 8B 84 05 38 F7 FF FF 8B 00 3B C6 74 3B 8B 48 04 3B CE 74 34 F7 85 F0 FD FF FF 00 08 00 00 0F BF 00 89 8D BC FD FF FF 74 14 99 2B C2 D1 F8 C7 85 94 FD FF FF 01 00 00 00 E9 0E 07 00 00 89 B5 94 FD FF FF E9 03 07 00 00 A1 ?? ?? ?? ?? 89 85 BC FD FF FF 50 E8 ?? ?? ?? ?? 59 E9 EC 06 00 00 83 F8 70 0F 8F E5 02 00 00 0F 84 C9 02 00 00 83 F8 65 0F 8C DA 06 00 00 83 F8 67 0F 8E 15 FD FF FF 83 F8 69 0F 84 D1 00 00 00 83 F8 6E 74 32 83 F8 6F 0F 85 BA 06 00 00 8B 9D F0 FD FF FF C7 85 A4 FD FF FF 08 00 00 00 84 DB 0F 89 C2 00 00 00 81 CB 00 02 00 00 89 9D F0 FD FF FF E9 B1 00 00 00 33 FF 39 BD E4 FD FF FF 75 12 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 70 FC EB 45 8B 85 C8 FD FF FF 83 F8 63 0F 87 CD F6 FF FF C1 E0 04 39 BD E0 FD FF FF 75 22 8D 8C 05 34 F7 FF FF 39 39 0F 84 F7 05 00 00 FF B5 F0 FD FF FF FF B5 DC FD FF FF 6A 03 E9 23 04 00 00 8B 84 05 38 F7 FF FF 8B 30 E8 ?? ?? ?? ?? 85 C0 0F 84 8A F6 FF FF F6 85 F0 FD FF FF 20 74 0C 66 8B 85 C0 FD FF FF 66 89 06 EB 08 8B 85 C0 FD FF FF 89 06 C7 85 88 FD FF FF 01 00 00 00 E9 F7 05 00 00 83 8D F0 FD FF FF 40 C7 85 A4 FD FF FF 0A 00 00 00 8B 9D F0 FD FF FF 33 FF F7 C3 00 80 00 00 0F 84 6B 02 00 00 39 BD E4 FD FF FF 0F 85 21 02 00 00 8B 8D EC FD FF FF 8B 01 8B 51 04 83 C1 08 89 8D EC FD FF FF E9 F8 03 00 00 FF B5 F0 FD FF FF FF B5 DC FD FF FF 6A 08 E9 5B F9 FF FF 39 B5 E8 FD FF FF 8D 9D F4 FD FF FF B8 00 02 00 00 89 9D BC FD FF FF 89 85 A4 FD FF FF 7D 0C C7 85 E8 FD FF FF 06 00 00 00 EB 63 75 0D 80 FA 67 75 5C 89 8D E8 FD FF FF EB 54 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF BF A3 00 00 00 39 BD E8 FD FF FF 7E 39 8B B5 E8 FD FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 8A 95 DC FD FF FF 59 89 85 8C FD FF FF 85 C0 74 10 8B D8 89 85 BC FD FF FF 89 B5 A4 FD FF FF EB 06 89 BD E8 FD FF FF 33 FF 39 BD E4 FD FF FF 75 11 8B 85 EC FD FF FF 83 C0 08 89 85 EC FD FF FF EB 20 83 BD C8 FD FF FF 63 0F 87 4B F5 FF FF 8B 85 C8 FD FF FF C1 E0 04 8B 84 05 38 F7 FF FF 83 C0 08 8B 48 F8 89 8D 78 FD FF FF 8B 40 FC 89 85 7C FD FF FF 8D 85 CC FD FF FF 50 FF B5 84 FD FF FF 0F BE C2 FF B5 E8 FD FF FF 50 FF B5 A4 FD FF FF 8D 85 78 FD FF FF 53 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B B5 F0 FD FF FF 83 C4 1C 81 E6 80 00 00 00 74 20 39 BD E8 FD FF FF 75 18 8D 85 CC FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 BD DC FD FF FF 67 75 1C 3B F7 75 18 8D 85 CC FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3B 2D 75 11 81 8D F0 FD FF FF 00 01 00 00 43 89 9D BC FD FF FF 53 E9 1D FD FF FF C7 85 E8 FD FF FF 08 00 00 00 C7 85 90 FD FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 D1 FA FF FF 48 48 0F 84 03 FE FF FF 83 E8 03 0F 85 EA 03 00 00 C7 85 90 FD FF FF 27 00 00 00 F6 85 F0 FD FF FF 80 C7 85 A4 FD FF FF 10 00 00 00 0F 84 E3 FD FF FF 8A 85 90 FD FF FF 04 51 C6 85 B8 FD FF FF 30 88 85 B9 FD FF FF C7 85 B4 FD FF FF 02 00 00 00 E9 BF FD FF FF 8B 85 C8 FD FF FF 83 F8 63 0F 87 FD F3 FF FF C1 E0 04 39 BD E0 FD FF FF 75 76 8D 8C 05 34 F7 FF FF 39 39 75 0B C7 01 04 00 00 00 E9 0B 02 00 00 53 FF B5 DC FD FF FF 6A 04 E9 51 01 00 00 F7 C3 00 10 00 00 74 5B 39 BD E4 FD FF FF 0F 84 8D FD FF FF 8B 85 C8 FD FF FF 83 F8 63 0F 87 AB F3 FF FF C1 E0 04 39 BD E0 FD FF FF 75 24 8D 8C 05 34 F7 FF FF 39 39 75 0B C7 01 05 00 00 00 E9 B9 01 00 00 53 FF B5 DC FD FF FF 6A 05 E9 FF 00 00 00 8B 8C 05 38 F7 FF FF 8B 01 8B 51 04 E9 4F 01 00 00 F6 C3 20 0F 84 94 00 00 00 F6 C3 40 74 4B 39 BD E4 FD FF FF 75 16 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 0F BF 40 FC E9 E1 00 00 00 8B 85 C8 FD FF FF 83 F8 63 0F 87 30 F3 FF FF C1 E0 04 39 BD E0 FD FF FF 0F 84 8C 00 00 00 8B 84 05 38 F7 FF FF 0F BF 00 E9 B4 00 00 00 39 BD E4 FD FF FF 75 16 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 0F B7 40 FC E9 96 00 00 00 8B 85 C8 FD FF FF 83 F8 63 0F 87 E5 F2 FF FF C1 E0 04 39 BD E0 FD FF FF 74 45 8B 84 05 38 F7 FF FF 0F B7 00 EB 70 F6 C3 40 74 6E 39 BD E4 FD FF FF 75 12 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 40 FC EB 51 8B 85 C8 FD FF FF 83 F8 63 0F 87 A0 F2 FF FF C1 E0 04 39 BD E0 FD FF FF 75 2E 8D 8C 05 34 F7 FF FF 39 39 0F 84 AF 00 00 00 53 FF B5 DC FD FF FF 6A 01 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 6C F2 FF FF E9 00 02 00 00 8B 84 05 38 F7 FF FF 8B 00 99 EB 3F 39 BD E4 FD FF FF 75 12 83 85 EC FD FF FF 04 8B 85 EC FD FF FF 8B 40 FC EB 23 8B 85 C8 FD FF FF 83 F8 63 0F 87 32 F2 FF FF C1 E0 04 39 BD E0 FD FF FF 74 92 8B 84 05 38 F7 FF FF 8B 00 33 D2 F6 C3 40 74 1A 3B D7 7F 16 7C 04 3B C7 73 10 F7 D8 13 D7 F7 DA 81 8D F0 FD FF FF 00 01 00 00 F7 85 F0 FD FF FF 00 90 00 00 8B DA 8B F0 75 02 33 DB 39 BD E8 FD FF FF 7D 25 C7 85 E8 FD FF FF 01 00 00 00 EB 33 C7 01 01 00 00 00 88 94 05 3C F7 FF FF 89 9C 05 40 F7 FF FF E9 57 01 00 00 83 A5 F0 FD FF FF F7 B8 00 02 00 00 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 8B C6 0B C3 75 06 89 BD B4 FD FF FF 8D 7D F3 8B 85 E8 FD FF FF FF 8D E8 FD FF FF 85 C0 7F 06 8B C6 0B C3 74 2D 8B 85 A4 FD FF FF 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 9C FD FF FF 8B F0 8B DA 7E 06 03 8D 90 FD FF FF 88 0F 4F EB BD 8D 45 F3 2B C7 47 F7 85 F0 FD FF FF 00 02 00 00 89 85 9C FD FF FF 89 BD BC FD FF FF 0F 84 C9 00 00 00 85 C0 74 09 80 3F 30 0F 84 BC 00 00 00 4F 89 BD BC FD FF FF C6 07 30 40 E9 A6 00 00 00 8B 85 C8 FD FF FF 83 F8 63 0F 87 6F F4 FF FF C1 E0 04 39 B5 E0 FD FF FF 0F 84 0A F9 FF FF 8B 84 05 38 F7 FF FF 8B 08 F7 85 F0 FD FF FF 10 08 00 00 89 8D BC FD FF FF 74 4C 3B CE 75 0C 8B 0D ?? ?? ?? ?? 89 8D BC FD FF FF C7 85 94 FD FF FF 01 00 00 00 8B C1 EB 24 C7 01 03 00 00 00 8B 8D F0 FD FF FF 88 94 05 3C F7 FF FF 89 8C 05 40 F7 FF FF EB 39 4F 66 39 30 74 06 40 40 3B FE 75 F4 2B C1 D1 F8 EB 21 3B CE 75 0C 8B 0D ?? ?? ?? ?? 89 8D BC FD FF FF 8B C1 EB 07 4F 80 38 00 74 05 40 3B FE 75 F5 2B C1 89 85 9C FD FF FF 83 BD E4 FD }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "__makepath_s"
		size = 265
		refs = "0018 __errno 0029 __invalid_parameter 0083 __mbsdec"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 08 33 DB 57 3B F3 74 05 39 5D 0C 77 20 E8 ?? ?? ?? ?? 6A 16 59 53 53 53 53 53 8B F1 89 08 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 CD 00 00 00 8B 45 10 33 FF 3B C3 74 19 8A 00 3A C3 74 13 6A 02 5F 39 7D 0C 0F 86 9D 00 00 00 88 06 46 C6 06 3A 46 8B 4D 14 8B C1 3B CB 74 40 38 19 74 3C EB 03 8B 7D FC 8B 55 0C 47 89 7D FC 3B FA 73 79 8A 10 88 16 46 40 38 18 75 E8 50 51 E8 ?? ?? ?? ?? 8A 00 59 59 3C 2F 74 10 3C 5C 74 0C 47 3B 7D 0C 73 56 C6 06 5C 46 EB 03 8B 7D FC 8B 45 18 3B C3 74 12 EB 0C 47 3B 7D 0C 73 3E 8A 08 88 0E 46 40 38 18 75 F0 8B 45 1C 3B C3 74 27 8A 08 3A CB 74 21 80 F9 2E 74 18 47 3B 7D 0C 73 1C C6 06 2E 46 EB 0C 47 3B 7D 0C 73 10 8A 08 88 0E 46 40 38 18 75 F0 47 3B 7D 0C 76 11 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 22 E9 1E FF FF FF 88 1E 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_422_1_0 {
	meta:
		name = "___initstdio"
		size = 177
		refs = "0001 __nstream 0023 __calloc_crt 002a ___piob 0053 __iob 0082 ___pioinfo"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 6A 14 5E 85 C0 75 07 B8 00 02 00 00 EB 06 3B C6 7D 07 8B C6 A3 ?? ?? ?? ?? 6A 04 50 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 85 C0 75 1E 6A 04 56 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 85 C0 75 05 6A 1A 58 5E C3 33 D2 B9 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 89 0C 02 83 C1 20 83 C2 04 81 F9 ?? ?? ?? ?? 7C EA 6A FE 5E 33 D2 B9 ?? ?? ?? ?? 57 8B C2 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B FA 83 E7 1F C1 E7 06 8B 04 07 83 F8 FF 74 08 3B C6 74 04 85 C0 75 02 89 31 83 C1 20 42 81 F9 ?? ?? ?? ?? 7C CE 5F 33 C0 5E C3 }
	condition:
		$1
}

rule file_422_2_0 {
	meta:
		name = "___endstdio"
		size = 32
		refs = "0001 __flushall 0007 __exitflag 000f __fcloseall 0015 ___piob 001a _free"
	strings:
		$1 = { E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_422_3_0 {
	meta:
		name = "__lock_file"
		size = 65
		refs = "000a __iob 0026 __lock 003a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 B8 ?? ?? ?? ?? 3B F0 72 22 81 FE ?? ?? ?? ?? 77 1A 8B CE 2B C8 C1 F9 05 83 C1 10 51 E8 ?? ?? ?? ?? 81 4E 0C 00 80 00 00 59 EB 0A 83 C6 20 56 FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_422_4_0 {
	meta:
		name = "__lock_file2"
		size = 50
		refs = "0012 __lock 002c __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 14 7D 16 83 C0 10 50 E8 ?? ?? ?? ?? 8B 45 0C 81 48 0C 00 80 00 00 59 5D C3 8B 45 0C 83 C0 20 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_422_5_0 {
	meta:
		name = "__unlock_file"
		size = 60
		refs = "0009 __iob 0029 __unlock 0036 __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 B9 ?? ?? ?? ?? 3B C1 72 1F 3D ?? ?? ?? ?? 77 18 81 60 0C FF 7F FF FF 2B C1 C1 F8 05 83 C0 10 50 E8 ?? ?? ?? ?? 59 5D C3 83 C0 20 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_422_6_0 {
	meta:
		name = "__unlock_file2"
		size = 47
		refs = "001c __unlock 0029 __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 83 F9 14 8B 45 0C 7D 13 81 60 0C FF 7F FF FF 83 C1 10 51 E8 ?? ?? ?? ?? 59 5D C3 83 C0 20 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_strncat"
		size = 309
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 B7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 11 8A 07 83 C7 01 84 C0 74 39 F7 C7 03 00 00 00 75 EF 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 21 84 E4 74 18 A9 00 00 FF 00 74 0C A9 00 00 00 FF 75 CF 83 EF 01 EB 0D 83 EF 02 EB 08 83 EF 03 EB 03 83 EF 04 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 5C EB 22 8A 16 83 C6 01 84 D2 74 3D 88 17 83 C7 01 83 E9 01 74 29 F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 38 8B CB 83 E1 03 74 13 8A 16 83 C6 01 88 17 83 C7 01 84 D2 74 07 83 E9 01 75 ED 88 0F 5B 5E 8B 44 24 08 5F C3 88 17 8B 44 24 10 5B 5E 5F C3 89 17 83 C7 04 83 E9 01 74 C8 BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 CE 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C4 89 17 8B 44 24 10 5B 5E 5F C3 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 66 89 17 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_424_3_0 {
	meta:
		name = "?wcsncnt@@YAIPB_WI@Z"
		size = 49
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 33 D2 3B CA 74 1B 66 39 10 74 05 40 40 49 75 F6 3B CA 74 0D 66 39 10 75 08 2B 45 08 D1 F8 40 5D C3 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_424_4_0 {
	meta:
		name = "__wcstombs_l_helper"
		size = 578
		refs = "0009 ___security_cookie 003e __errno 004e __invalid_parameter 0061 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0111 __imp__WideCharToMultiByte@32 015e __imp__GetLastError@0 018e @__security_check_cookie@4 020d _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 75 D8 89 7D D4 89 5D DC 89 5D F0 3B F3 74 0C 39 5D 10 75 07 33 C0 E9 4C 01 00 00 3B FB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 28 01 00 00 FF 75 14 8D 4D E0 E8 ?? ?? ?? ?? 3B F3 0F 84 96 01 00 00 8B 75 E0 39 5E 14 75 5A 39 5D 10 76 2C B8 FF 00 00 00 66 39 07 0F 87 E3 00 00 00 8A 0F 8B 55 D8 8B 45 DC 88 0C 02 66 8B 0F 47 47 66 85 C9 74 1D 40 89 45 DC 3B 45 10 72 D4 38 5D EC 74 07 8B 45 E8 83 60 70 FD 8B 45 DC E9 CB 00 00 00 38 5D EC 0F 84 C2 00 00 00 8B 4D E8 83 61 70 FD E9 B6 00 00 00 83 BE AC 00 00 00 01 75 54 8B 4D 10 3B CB 76 1D 8B C7 66 39 18 74 05 40 40 49 75 F6 3B CB 74 0D 66 39 18 75 08 2B C7 D1 F8 40 89 45 10 8D 45 F0 50 53 FF 75 10 FF 75 D8 FF 75 10 57 53 FF 76 04 FF 15 ?? ?? ?? ?? 3B C3 74 52 39 5D F0 75 4D 8B 4D D8 38 5C 01 FF 75 93 E9 10 01 00 00 8D 45 F0 50 53 FF 75 10 FF 75 D8 6A FF 57 53 FF 76 04 FF 15 ?? ?? ?? ?? 8B F8 3B FB 74 0D 39 5D F0 75 1C 8D 47 FF E9 63 FF FF FF 39 5D F0 75 0F FF 15 ?? ?? ?? ?? 83 F8 7A 0F 84 83 00 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D EC 74 07 8B 45 E8 83 60 70 FD 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8D 45 F0 50 53 FF B6 AC 00 00 00 8D 45 F4 50 6A 01 FF 75 D4 53 FF 76 04 FF 15 ?? ?? ?? ?? 89 45 DC 3B C3 74 B2 39 5D F0 75 AD 3B C3 7C A9 83 F8 05 77 A4 8D 0C 38 3B 4D 10 77 24 33 D2 3B C3 7E 15 8A 4C 15 F4 8B 45 D8 88 0C 38 3A CB 74 10 42 47 3B 55 DC 7C EB 83 45 D4 02 3B 7D 10 72 A1 38 5D EC 74 07 8B 45 E8 83 60 70 FD 8B C7 EB 82 8B 45 E0 39 58 14 75 0C 57 E8 ?? ?? ?? ?? 59 E9 A3 FE FF FF 8D 4D F0 51 53 53 53 6A FF 57 53 FF 70 04 FF 15 ?? ?? ?? ?? 3B C3 0F 84 38 FF FF FF 39 5D F0 0F 85 2F FF FF FF 48 E9 78 FE FF FF }
	condition:
		$1
}

rule file_424_7_0 {
	meta:
		name = "__wcstombs_s_l"
		size = 186
		refs = "0044 __wcstombs_l_helper 0057 __errno 0073 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 0C 33 DB 57 8B 7D 10 89 5D FC 3B F3 74 47 3B FB 76 47 3B F3 74 02 88 1E 8B 45 08 3B C3 74 02 89 18 8B 45 18 3B C7 76 02 8B C7 3D FF FF FF 7F 77 28 FF 75 1C 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 2E 3B F3 74 02 88 1E E8 ?? ?? ?? ?? 8B 00 EB 56 3B FB 74 B9 E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 37 40 3B F3 74 26 3B C7 76 1E 83 7D 18 FF 74 0F 88 1E 3B F8 77 09 E8 ?? ?? ?? ?? 6A 22 EB CE 8B C7 C7 45 FC 50 00 00 00 88 5C 30 FF 8B 4D 08 3B CB 74 02 89 01 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "__hypothlp"
		size = 595
		refs = "0017 __ctrlfp 00bb _sqrt 00c3 __decomp 00ee __get_exp 0110 __set_exp 020c __except2 022a __d_inf 0247 __handle_qnan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 55 0E 59 59 8B D8 B8 F0 7F 00 00 8B CA 23 C8 8B F8 66 3B CF 0F 84 7F 01 00 00 8B 4D 16 23 C8 66 3B CF 0F 84 71 01 00 00 D9 EE DD 45 08 D8 D1 DF E0 F6 C4 05 7A 02 D9 E0 DD 45 10 D8 D2 DF E0 F6 C4 05 7A 02 D9 E0 D8 D1 DF E0 F6 C4 41 75 05 DD 55 F0 EB 07 D9 C9 DD 55 F0 D9 C9 D9 CA DC 5D F0 DF E0 F6 C4 44 7A 14 56 DD D9 53 DD D8 E8 ?? ?? ?? ?? D9 EE 59 59 E9 B7 01 00 00 DC 75 F0 8D 45 F8 50 51 51 DD 5D 08 DC 75 F0 DD 5D 10 DD 45 08 DC 4D 08 DD 45 10 DC 4D 10 DE C1 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E8 DD 45 F0 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 83 C4 04 DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 03 45 FC DD 45 F0 59 03 45 F8 59 3D 00 04 00 00 7E 32 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 11 E9 D5 00 00 00 3D 03 FC FF FF 7D 32 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 12 E9 9C 00 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 F6 C3 20 74 11 56 53 E8 ?? ?? ?? ?? DD 45 F0 59 59 E9 B8 00 00 00 DD 45 F0 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 10 EB 56 B9 F8 7F 00 00 23 D1 8B F8 66 3B D7 75 0F F7 45 0C FF FF 07 00 75 1F 83 7D 08 00 75 19 8B 7D 16 23 F9 66 3B F8 75 39 F7 45 14 FF FF 07 00 75 06 83 7D 10 00 74 2A DD 45 08 53 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 08 E8 ?? ?? ?? ?? 83 C4 24 EB 39 8B C1 66 3B D0 74 16 66 3B F9 74 11 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 59 EB 1C DD 45 10 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_427_1_0 {
	meta:
		name = "__hypot"
		size = 33
		refs = "0018 __hypothlp"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 6A 18 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_427_2_0 {
	meta:
		name = "__cabs"
		size = 33
		refs = "0018 __hypothlp"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 10 6A 11 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "__wspawnv"
		size = 84
		refs = "0010 __errno 0020 __invalid_parameter 004a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 56 33 F6 3B D6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 25 66 39 32 74 DE 8B 4D 10 3B CE 74 D7 8B 01 3B C6 74 D1 66 39 30 74 CC 56 51 52 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_430_3_0 {
	meta:
		name = "__mbscmp_l"
		size = 295
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 008d _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 C7 00 00 00 56 8B 75 0C 3B F3 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 90 00 00 00 57 8B 7D F4 39 5F 08 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 81 00 00 00 8B 45 08 66 0F B6 00 FF 45 08 0F B7 C8 0F B6 C1 F6 44 38 1D 04 74 1D 8B 45 08 8A 00 3A C3 75 04 33 C9 EB 10 C1 E1 08 66 0F B6 C0 66 0B C8 FF 45 08 0F B7 C9 66 0F B6 06 0F B7 C0 0F B6 D0 46 F6 44 3A 1D 04 74 18 8A 16 3A D3 75 04 33 C0 EB 0E C1 E0 08 66 0F B6 D2 66 0B C2 0F B7 C0 46 66 3B C1 75 18 66 3B CB 75 98 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 1B C0 83 E0 02 48 38 5D FC 74 F0 8B 4D F8 83 61 70 FD EB E7 }
	condition:
		$1
}

rule file_431_3_0 {
	meta:
		name = "__mbsncmp_l"
		size = 300
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0041 _strncmp 006b __errno 007b __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 10 75 13 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 E7 00 00 00 57 8B 7D F4 39 5F 08 75 26 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 C3 00 00 00 8B 4D F8 83 61 70 FD E9 B7 00 00 00 56 8B 75 08 3B F3 74 05 39 5D 0C 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 7E 66 0F B6 06 FF 4D 10 0F B7 C8 0F B6 C1 46 F6 44 38 1D 04 74 18 8A 06 3A C3 75 04 33 C9 EB 0E C1 E1 08 66 0F B6 C0 66 0B C8 0F B7 C9 46 8B 45 0C 66 0F B6 00 FF 45 0C 0F B7 C0 0F B6 D0 F6 44 3A 1D 04 74 1D 8B 55 0C 8A 12 3A D3 75 04 33 C0 EB 10 C1 E0 08 66 0F B6 D2 66 0B C2 FF 45 0C 0F B7 C0 66 3B C1 75 1D 66 3B CB 74 05 39 5D 10 75 90 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5E 5F 5B C9 C3 1B C0 83 E0 02 48 38 5D FC 74 F0 8B 4D F8 83 61 70 FD EB E7 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "_wait_a_bit"
		size = 38
		refs = "000c __imp__Sleep@4 0018 __maxwait"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 56 FF 15 ?? ?? ?? ?? 81 C6 E8 03 00 00 3B 35 ?? ?? ?? ?? 76 03 83 CE FF 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_434_2_0 {
	meta:
		name = "__malloc_crt"
		size = 69
		refs = "000d _malloc 001a __maxwait 0023 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 33 F6 FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 85 FF 75 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 8B F0 83 F8 FF 75 CA 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_434_3_0 {
	meta:
		name = "__calloc_crt"
		size = 76
		refs = "0012 __calloc_impl 0021 __maxwait 002a __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 33 F6 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 8B F0 83 F8 FF 75 C3 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_434_4_0 {
	meta:
		name = "__realloc_crt"
		size = 78
		refs = "0010 _realloc 0023 __maxwait 002c __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 33 F6 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 75 2C 39 45 0C 74 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 8B F0 83 F8 FF 75 C1 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_434_5_0 {
	meta:
		name = "__recalloc_crt"
		size = 82
		refs = "0013 __recalloc 0027 __maxwait 0030 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 33 F6 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 2C 39 45 10 74 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 8B F0 83 F8 FF 75 BD 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__hypotf"
		size = 293
		refs = "0052 _sqrt 007e ___libm_error_support 0094 _fabs 009a __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 83 EC 0C 56 8B 75 0C B8 FF 00 00 00 C1 E9 17 C1 EE 17 23 C8 23 F0 3B C8 0F 84 AA 00 00 00 3B F0 0F 84 A2 00 00 00 8B C1 2B C6 83 C0 1C 51 51 83 F8 38 77 51 D9 45 08 03 F1 D9 45 0C D9 C0 DE C9 D9 C1 DE CA DE C1 DD 1C 24 E8 ?? ?? ?? ?? 81 FE 7A 01 00 00 59 59 7E 68 DD 55 F4 81 7D F8 00 00 F0 47 7C 5C 6A 2F D9 5D FC 8D 45 FC 50 8D 45 0C 50 8D 45 08 50 E8 ?? ?? ?? ?? D9 45 FC 83 C4 10 E9 95 00 00 00 D9 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DD 5D F4 D9 45 0C DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 59 59 DC 45 F4 D9 5D F8 D9 45 F8 81 7D F8 00 00 00 7F DC C0 EB A2 D9 5D F8 D9 45 F8 EB 52 BA FF FF FF 7F 21 55 08 21 55 0C BA FF FF 7F 00 3B C8 75 05 85 55 08 75 09 3B F0 75 0D 85 55 0C 74 08 D9 45 08 D8 4D 0C EB 06 D9 45 08 D8 45 0C D9 5D F8 3B C8 75 0A 85 55 08 75 05 D9 45 08 EB 11 3B F0 75 0A 85 55 0C 75 05 D9 45 0C EB 03 D9 45 F8 5E C9 C3 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "__chsize_nolock"
		size = 438
		refs = "001b __lseeki64_nolock 006b __imp__GetProcessHeap@0 0072 __imp__HeapAlloc@12 007e __errno 009d __setmode_nolock 00be __write_nolock 00f5 __imp__HeapFree@12 0101 ___doserrno 0148 __get_osfhandle 0150 __imp__SetEndOfFile@4 017d __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 33 DB 6A 01 53 53 FF 75 08 89 5D F0 89 5D F4 E8 ?? ?? ?? ?? 89 45 E8 23 C2 83 C4 10 89 55 EC 83 F8 FF 74 59 6A 02 53 53 FF 75 08 E8 ?? ?? ?? ?? 8B C8 23 CA 83 C4 10 83 F9 FF 74 41 8B 75 0C 8B 7D 10 2B F0 1B FA 0F 88 C6 00 00 00 7F 08 3B F3 0F 86 BC 00 00 00 BB 00 10 00 00 53 6A 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5F 5E 5B C9 C3 68 00 80 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 F8 85 FF 7C 0A 7F 04 3B F3 72 04 8B C3 EB 02 8B C6 50 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 36 99 2B F0 1B FA 78 06 7F D3 85 F6 77 CF 8B 75 F0 FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 59 59 FF 75 FC 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 DB E9 86 00 00 00 E8 ?? ?? ?? ?? 83 38 05 75 0B E8 ?? ?? ?? ?? C7 00 0D 00 00 00 83 CE FF 89 75 F4 EB BD 3B FB 7F 71 7C 04 3B F3 73 6B 53 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 44 FF FF FF FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 48 99 89 45 F0 23 C2 89 55 F4 83 F8 FF 75 29 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 89 06 8B 75 F0 23 75 F4 83 FE FF 0F 84 F6 FE FF FF 53 FF 75 EC FF 75 E8 FF 75 08 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 0F 84 D9 FE FF FF 33 C0 E9 D9 FE FF FF }
	condition:
		$1
}

rule file_436_1_0 {
	meta:
		name = "__chsize_s"
		size = 237
		refs = "0003 __sehtable$__chsize_s 0008 __SEH_prolog4 0015 ___doserrno 002c __nhandle 003a __errno 0049 __invalid_parameter 005f ___pioinfo 009a ___lock_fhandle 00b5 __chsize_nolock 00de __SEH_epilog4 00e7 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 10 E8 ?? ?? ?? ?? 83 20 00 6A 09 58 E9 B9 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 25 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 6A 09 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 86 00 00 00 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 BB 39 7D 10 7F 1C 7C 05 39 7D 0C 73 15 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 6A 16 59 89 08 8B F1 EB AB 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 0D E8 ?? ?? ?? ?? 6A 09 5E 89 30 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_436_2_0 {
	meta:
		name = "__chsize"
		size = 28
		refs = "000f __chsize_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 99 52 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 5D C3 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "__EH_prolog"
		size = 31
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 C3 }
	condition:
		$1
}

rule file_440_3_0 {
	meta:
		name = "__mbsnbcnt_l"
		size = 134
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 __errno 0033 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 0C 33 DB 39 5D 08 75 2C 3B D3 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 39 8B 45 08 3B D3 74 23 56 8A 08 4A 3A CB 74 1A 8B 75 F4 0F B6 C9 F6 44 31 1D 04 74 05 40 38 18 74 07 40 3B D3 75 E2 EB 01 48 5E 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_441_5_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
		size = 387
		refs = "0009 ___security_cookie 001f __errno 002e __invalid_parameter 003f _strnlen 008d ___crtLCMapStringA 00e2 __alloca_probe_16 00f6 _malloc 014f _strcpy_s 016a __freea 017d @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 33 DB 3B FB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 35 01 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 59 59 3B 45 0C 72 04 88 1F EB D0 8B 55 10 8B 02 8B 48 14 3B CB 75 20 8B CF 38 1F 74 13 8A 01 3C 41 7C 08 3C 5A 7F 04 04 20 88 01 41 38 19 75 ED 33 C0 E9 F7 00 00 00 6A 01 FF 70 04 BE 00 01 00 00 53 53 6A FF 57 56 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 24 89 4D F4 3B CB 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BD 00 00 00 39 4D 0C 73 0E 88 1F E8 ?? ?? ?? ?? 6A 22 E9 5E FF FF FF 3B CB 7E 45 6A E0 33 D2 58 F7 F1 83 F8 01 72 39 8D 41 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F4 89 45 F8 EB 03 89 5D F8 39 5D F8 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 83 8B 55 10 8B 02 6A 01 FF 70 04 51 FF 75 F8 6A FF 57 56 FF 70 14 52 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 13 FF 75 F8 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 FF 75 F8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 E8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_441_6_0 {
	meta:
		name = "__strlwr_s_l"
		size = 52
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e ?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_441_9_0 {
	meta:
		name = "__strlwr"
		size = 101
		refs = "000a ___locale_changed 0018 __errno 0028 __invalid_parameter 0058 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 1D ?? ?? ?? ?? 75 41 8B 45 08 3B C3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2F 8B D0 38 18 74 29 8A 0A 80 F9 41 7C 0A 80 F9 5A 7F 05 80 C1 20 88 0A 42 38 1A 75 EA EB 11 53 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "_clearerr_s"
		size = 173
		refs = "0003 __sehtable$_clearerr_s 0008 __SEH_prolog4 001d __errno 002c __invalid_parameter 0039 __lock_file 0047 __fileno 0069 ___pioinfo 0080 ___badioinfo 009d __SEH_epilog4 00a7 __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 08 33 F6 3B FE 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 65 57 E8 ?? ?? ?? ?? 59 89 75 FC 83 67 0C CF 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 57 E8 ?? ?? ?? ?? C1 F8 05 8D 34 85 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 83 E0 1F C1 E0 06 03 06 EB 05 B8 ?? ?? ?? ?? 0F BE 48 04 80 E1 FD 88 48 04 C7 45 FC FE FF FF FF E8 0B 00 00 00 33 C0 E8 ?? ?? ?? ?? C3 8B 7D 08 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "_xtoa@16"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 74 06 C6 01 2D 41 F7 D8 56 8B F1 33 D2 F7 75 08 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 11 41 85 C0 77 E7 C6 01 00 49 8A 16 8A 01 88 11 49 88 06 46 3B F1 72 F2 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_445_4_0 {
	meta:
		name = "@x64toa@20"
		size = 111
		refs = "0031 __aulldvrm"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8B 5D 08 56 33 C9 8B F0 8B 45 0C 57 39 4D 14 74 0A C6 06 2D 46 F7 DB 13 C1 F7 D8 8B FE 89 4D 0C FF 75 0C FF 75 10 50 53 E8 ?? ?? ?? ?? 89 5D FC 8B D8 8B C2 83 F9 09 76 05 80 C1 57 EB 03 80 C1 30 88 0E 46 85 C0 77 D8 72 04 85 DB 77 D2 C6 06 00 4E 8A 0F 8A 06 88 0E 4E 88 07 47 3B FE 72 F2 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "__AdjustLocation"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 7C 12 83 F8 07 7F 0D 2B 45 0C 78 05 83 F8 07 7E 03 6A 1F 58 5D C3 }
	condition:
		$1
}

rule file_446_1_0 {
	meta:
		name = "__IsMemoryLocation"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 0A 7C 0B 83 7D 08 10 7F 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_446_2_0 {
	meta:
		name = "__GetFpRegVal"
		size = 45
		refs = "001c __zero80"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 56 57 83 F8 07 77 0C 8B 4D 0C 6B C0 0A 8D 74 08 1C EB 05 BE ?? ?? ?? ?? 8B 45 08 8B F8 A5 A5 66 A5 5F 5E 5D C3 }
	condition:
		$1
}

rule file_446_3_0 {
	meta:
		name = "__SetTag"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 55 10 03 C9 6A 03 58 D3 E0 D3 E2 8B 4D 08 23 D0 F7 D0 23 01 0B D0 89 11 5D C3 }
	condition:
		$1
}

rule file_446_4_0 {
	meta:
		name = "__FillOperand"
		size = 399
		refs = "0113 __GetFpRegVal 0159 __zero80"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 83 EC 0C 56 33 D2 57 8B 7D 08 42 09 57 10 83 F9 0D 8B 47 10 0F 8F 12 01 00 00 0F 84 FA 00 00 00 85 C9 0F 8C 5B 01 00 00 83 F9 07 0F 8E C8 00 00 00 83 F9 08 0F 84 05 01 00 00 83 F9 09 74 62 83 F9 0A 74 43 83 F9 0B 74 26 83 F9 0C 0F 85 31 01 00 00 83 E0 ED 0B C1 89 47 10 8B 45 0C 8B 40 14 8B 08 89 0F 8B 40 04 89 47 04 E9 14 01 00 00 83 E0 EB 83 C8 0A 89 47 10 8B 45 0C 8B 40 14 8B 00 89 07 E9 FC 00 00 00 83 E0 E9 83 C8 08 89 47 10 8B 45 0C 8B 40 14 66 8B 00 66 89 07 E9 E2 00 00 00 83 E0 F7 83 C8 16 89 47 10 8B 45 0C 8B 48 04 8B C1 C1 E8 03 25 A0 00 00 00 81 E1 00 01 00 00 0B C1 C1 E8 05 83 E8 00 74 28 48 74 1A 2D FF 00 00 00 74 0B C7 07 03 00 00 00 E9 A4 00 00 00 83 27 00 E9 9C 00 00 00 C7 07 02 00 00 00 E9 91 00 00 00 89 17 E9 8A 00 00 00 83 E0 E5 83 C8 04 51 FF 75 0C 89 47 10 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 A5 A5 66 A5 EB 69 83 E0 E1 89 47 10 8B 45 0C 8B 40 14 D9 00 D9 1F EB 57 83 E9 0E 74 3F 49 74 2B 49 74 20 49 74 0D 83 E9 0E 75 44 83 E0 FE 89 47 10 EB 3C 83 E0 E5 83 C8 04 89 47 10 BE ?? ?? ?? ?? EB BD 83 E0 F5 83 C8 14 EB 06 83 E0 E5 83 C8 04 89 47 10 8B 45 0C 8B 70 14 EB A4 83 E0 E3 83 C8 02 89 47 10 8B 45 0C 8B 40 14 DD 00 DD 1F 5F 5E C9 C3 }
	condition:
		$1
}

rule file_446_5_0 {
	meta:
		name = "__AdjustStack"
		size = 229
		refs = "0009 ___security_cookie 0033 __SetTag 006a _memcpy 007f _memmove 00df @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 8B 7D 0C 85 FF 7E 7B 53 8D 5E 08 89 7D A8 8B 46 04 C1 E8 0B 6A 03 83 E0 07 50 53 E8 ?? ?? ?? ?? 8B 46 04 8B C8 81 E1 00 F8 FF FF 81 C1 00 08 00 00 33 C8 81 E1 00 38 00 00 33 C8 83 C4 0C FF 4D A8 89 4E 04 75 C8 6B FF 0A 57 8D 5E 1C 8D 45 AC 53 50 E8 ?? ?? ?? ?? 6A 08 58 2B 45 0C 6B C0 0A 50 8D 44 37 1C 50 53 E8 ?? ?? ?? ?? 57 8D 45 AC 2B F7 50 83 C6 6C 56 E8 ?? ?? ?? ?? 83 C4 24 5B EB 3E 7D 3C 8B 4E 04 8B C1 C1 E8 0B 48 C1 E0 0B 33 C1 25 00 38 00 00 33 C1 89 46 04 C1 E8 0B 83 E0 07 6A 00 50 8D 46 08 50 E8 ?? ?? ?? ?? 8D 46 1C 6A 46 50 83 C6 26 56 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_446_6_0 {
	meta:
		name = "__PreventStackOverwrite"
		size = 63
		refs = "000a __IsMemoryLocation"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 25 8B 4D 08 8B 81 C4 00 00 00 3B 41 30 76 17 54 58 89 45 FC 8B 41 30 83 C0 04 39 45 FC 77 07 C7 45 0C 1F 00 00 00 8B 45 0C C9 C3 }
	condition:
		$1
}

rule file_446_7_0 {
	meta:
		name = "__SetFpRegVal"
		size = 107
		refs = "005f __SetTag"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 07 77 5E 8B 45 0C 8B 55 08 6B C0 0A 53 8B 5D 10 56 57 8D 7C 10 1C 8B F3 A5 A5 66 A5 8B 42 04 0F B7 4B 08 C1 E8 0B 03 45 0C BE FF 7F 00 00 83 E0 07 23 CE 74 08 3B CE 74 14 33 C9 EB 13 83 3B 00 75 0B 83 7B 04 00 75 05 33 C9 41 EB 03 6A 02 59 51 50 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_446_8_0 {
	meta:
		name = "__UpdateResult"
		size = 288
		refs = "00c5 __SetFpRegVal"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 83 F8 0C 56 57 0F 8F D0 00 00 00 0F 84 B5 00 00 00 85 C0 0F 8C FB 00 00 00 83 F8 07 0F 8E 93 00 00 00 83 F8 09 74 34 83 F8 0A 74 1B 83 F8 0B 0F 85 DF 00 00 00 8B 45 08 8B 4D 0C 8B 40 14 8B 09 89 08 E9 CD 00 00 00 8B 45 08 8B 4D 0C 8B 40 14 66 8B 09 66 89 08 E9 B9 00 00 00 8B 45 0C 8B 00 83 E8 00 74 3C 48 74 2D 48 74 16 48 0F 85 A2 00 00 00 8B 45 08 81 48 04 00 45 00 00 E9 93 00 00 00 8B 45 08 8B 48 04 81 E1 FF BB FF FF 81 C9 00 01 00 00 EB 41 8B 45 08 81 60 04 FF BA FF FF EB 73 8B 45 08 8B 48 04 81 E1 FF FA FF FF 81 C9 00 40 00 00 EB 21 FF 75 0C 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 4E 8B 4D 0C 8B 45 08 8B 11 8B 40 14 89 10 8B 49 04 89 48 04 EB 39 83 E8 0D 74 27 48 74 15 48 74 03 48 75 2B 8B 45 08 8B 78 14 8B 75 0C A5 A5 66 A5 EB 1C 8B 45 08 8B 4D 0C 8B 40 14 DD 01 DD 18 EB 0D 8B 45 08 8B 4D 0C 8B 40 14 D9 01 D9 18 5F 5E 5D C3 }
	condition:
		$1
}

rule file_446_9_0 {
	meta:
		name = "__UpdateFpCtxt"
		size = 59
		refs = "0012 __AdjustStack 0022 __UpdateResult"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 14 85 F6 7D 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 7E 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_446_10_0 {
	meta:
		name = "__fpieee_flt"
		size = 1724
		refs = "001e ___security_cookie 0107 _instr_info_table 02b3 _FLDTable 0371 __IsMemoryLocation 038c __FillOperand 03a0 __GetFpRegVal 0458 __PreventStackOverwrite 0477 __UpdateFpCtxt 0491 __AdjustLocation 0547 __UpdateResult 06a2 _fpieee_flt_simd 06b1 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC B8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 08 8B 53 10 8B 4B 0C 56 BE B4 02 00 C0 57 89 95 64 FF FF FF 8D 7E 01 3D 8E 00 00 C0 74 2B 3D 8F 00 00 C0 74 24 3D 90 00 00 C0 74 1D 3D 91 00 00 C0 74 16 3D 93 00 00 C0 74 0F 3B C6 74 0B 3B C7 74 07 33 C0 E9 37 06 00 00 DB E3 3B C6 0F 84 22 06 00 00 3B C7 0F 84 1A 06 00 00 8B 01 8B 49 04 83 C0 14 8B 00 8D 71 1C 89 8D 60 FF FF FF 89 B5 70 FF FF FF 85 C0 74 16 50 FF D2 59 83 F8 FF 0F 85 FB 05 00 00 C6 46 04 00 E9 F2 05 00 00 8B 46 0C 0F B6 08 80 E1 F8 80 F9 D8 75 A6 66 8B 00 66 89 85 74 FF FF FF 8B 85 74 FF FF FF 8B 7D 80 B9 00 C0 00 00 23 C1 2B C1 8B 8D 74 FF FF FF F7 D8 1B C0 83 E1 07 03 C9 40 0B C1 8B 8D 74 FF FF FF C1 E9 0B 83 E1 07 C1 E0 03 0B C1 8D 0C 85 ?? ?? ?? ?? 89 8D 4C FF FF FF 8B 09 8B D1 C1 E2 05 33 D7 89 8D 7C FF FF FF 81 E2 E0 FF 01 00 C1 E1 02 C1 F9 1D 33 FA 89 7D 80 89 8D 78 FF FF FF 89 8D 6C FF FF FF 8B 0E 8B 76 04 8B D1 81 E2 00 0C 00 00 74 2D 81 FA 00 04 00 00 74 1D 81 FA 00 08 00 00 74 0D 81 FA 00 0C 00 00 75 1B 83 CF 03 EB 13 83 E7 FE 83 CF 02 EB 0B 83 E7 FD 83 CF 01 EB 03 83 E7 FC 89 7D 80 8B D1 81 E2 00 03 00 00 74 1D 81 FA 00 02 00 00 74 0D 81 FA 00 03 00 00 75 16 83 E7 E3 EB 0E 83 E7 E7 83 CF 04 EB 06 83 E7 EB 83 CF 08 89 7D 80 8B D1 C1 E2 04 8B F9 F7 D2 83 E2 10 C1 EF 05 F7 D7 83 E7 01 0B D7 8D 3C 09 F7 D7 83 E7 08 0B D7 8B F9 C1 E9 03 F7 D1 83 E1 02 D1 EF F7 D7 83 E7 04 0B D7 0B D1 8B 4D 88 83 E1 E0 0B D1 89 55 88 8B CE C1 E9 02 83 E1 08 8B D6 83 E2 10 0B CA C1 E9 02 8B D6 83 E2 08 0B CA 33 FF 8B D6 47 23 D7 C1 E2 03 83 E6 04 0B D6 03 D2 D1 E9 0B CA 8B 55 8C 83 E2 E0 0B CA 8A 55 88 89 4D 8C F6 C2 01 74 09 F6 C1 01 74 04 8B CF EB 02 33 C9 8B 75 84 33 CE 23 CF 33 F1 F6 C2 02 74 0A F6 45 8C 02 74 04 8B CF EB 02 33 C9 03 C9 33 CE 83 E1 02 33 F1 F6 C2 04 74 0A F6 45 8C 04 74 04 8B CF EB 02 33 C9 C1 E1 02 33 CE 83 E1 04 33 F1 F6 C2 08 74 0A F6 45 8C 08 74 04 8B CF EB 02 33 C9 C1 E1 03 33 CE 83 E1 08 33 F1 F6 C2 10 74 0A F6 45 8C 10 74 04 8B CF EB 02 33 C9 C1 E1 04 33 CE 83 E1 10 33 F1 89 75 84 B9 ?? ?? ?? ?? 39 01 75 16 F6 45 84 10 75 10 83 BD 6C FF FF FF 00 7D 07 83 A5 6C FF FF FF 00 83 C1 04 81 F9 ?? ?? ?? ?? 7C DB 8B 8D 7C FF FF FF 8B 95 74 FF FF FF 8B C1 C1 E8 0C 83 E0 1F 83 F8 08 75 0A 8B F2 C1 EE 08 83 E6 07 EB 02 8B F0 8B C1 C1 E8 11 83 E0 1F 83 F8 08 75 0A 8B FA C1 EF 08 83 E7 07 EB 02 8B F8 C1 E9 16 83 E1 1F 83 F9 08 75 0E C1 EA 08 83 E2 07 89 95 74 FF FF FF EB 06 89 8D 74 FF FF FF 8B 43 08 3D 8E 00 00 C0 0F 84 0C 02 00 00 3D 8F 00 00 C0 0F 84 37 01 00 00 3D 90 00 00 C0 0F 84 F6 01 00 00 3D 91 00 00 C0 74 0B 3D 93 00 00 C0 0F 85 60 02 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 09 01 00 00 56 FF B5 70 FF FF FF 8D 45 90 50 E8 ?? ?? ?? ?? 6A 00 FF B5 70 FF FF FF 8D 85 50 FF FF FF 50 E8 ?? ?? ?? ?? 8B F0 8B 45 E0 8D 7D F0 A5 A5 83 C4 18 83 C8 01 83 BD 74 FF FF FF 0D 66 A5 75 0F 83 E0 E1 C7 85 78 FF FF FF C0 00 00 00 EB 10 83 E0 E3 83 C8 02 C7 85 78 FF FF FF 00 06 00 00 81 7B 08 91 00 00 C0 89 45 E0 75 06 F7 9D 78 FF FF FF DB 85 78 FF FF FF DB 6D F0 D9 FD DD D9 DB 7D F0 83 BD 74 FF FF FF 0D 75 14 DB 6D F0 D9 9D 7C FF FF FF D9 85 7C FF FF FF D9 5D D0 EB 12 DB 6D F0 DD 9D 68 FF FF FF DD 85 68 FF FF FF DD 5D D0 DB E2 8D 45 80 50 FF 95 64 FF FF FF 59 89 85 78 FF FF FF 83 F8 FF 0F 85 4B 02 00 00 FF B5 74 FF FF FF FF B5 60 FF FF FF E8 ?? ?? ?? ?? 8B 8D 4C FF FF FF 8B 09 C1 E1 02 C1 F9 1D 51 50 8D 45 D0 50 FF B5 70 FF FF FF E8 ?? ?? ?? ?? 8B B5 70 FF FF FF 83 C4 18 E9 59 01 00 00 FF B5 78 FF FF FF 56 E8 ?? ?? ?? ?? FF B5 78 FF FF FF 89 85 7C FF FF FF 57 E8 ?? ?? ?? ?? FF B5 78 FF FF FF 89 85 6C FF FF FF FF B5 74 FF FF FF E8 ?? ?? ?? ?? 8B F8 83 C4 18 39 BD 7C FF FF FF 75 0A C7 85 7C FF FF FF 1F 00 00 00 39 BD 6C FF FF FF 75 0A C7 85 6C FF FF FF 1F 00 00 00 8B B5 70 FF FF FF 57 8D 45 D0 56 50 E8 ?? ?? ?? ?? FF B5 7C FF FF FF 8D 45 90 56 50 E8 ?? ?? ?? ?? FF B5 6C FF FF FF 8D 45 B0 56 50 E8 ?? ?? ?? ?? 8D 45 80 50 FF 95 64 FF FF FF 83 C4 28 89 85 78 FF FF FF 83 F8 FF 0F 85 62 01 00 00 57 FF B5 60 FF FF FF E8 ?? ?? ?? ?? 50 8D 45 D0 50 56 E8 ?? ?? ?? ?? 83 C4 14 E9 8F 00 00 00 56 8B B5 70 FF FF FF 8D 45 90 56 50 E8 ?? ?? ?? ?? 57 8D 45 B0 56 50 E8 ?? ?? ?? ?? FF B5 74 FF FF FF 8D 45 D0 56 50 E8 ?? ?? ?? ?? 83 65 E0 FE 8D 45 80 50 FF 95 64 FF FF FF 83 C4 28 89 85 78 FF FF FF 83 F8 FF 0F 85 F7 00 00 00 FF B5 74 FF FF FF FF B5 60 FF FF FF E8 ?? ?? ?? ?? 8B 8D 4C FF FF FF 8B 09 C1 E1 02 C1 F9 1D 51 50 8D 45 D0 50 56 E8 ?? ?? ?? ?? 83 C4 18 EB 06 8B B5 70 FF FF FF 83 BD 78 FF FF FF FF 0F 85 B4 00 00 00 8B 0E C6 46 04 00 8B 55 80 8B C2 83 E0 03 83 E8 00 74 2D 48 74 1C 48 74 0B 48 75 2A 81 C9 00 0C 00 00 EB 22 81 E1 FF FB FF FF 81 C9 00 08 00 00 EB 14 81 E1 FF F7 FF FF 81 C9 00 04 00 00 EB 06 81 E1 FF F3 FF FF C1 EA 02 83 E2 07 83 EA 00 74 1C 4A 74 0B 4A 75 1C 81 E1 FF FC FF FF EB 14 81 E1 FF FE FF FF 81 C9 00 02 00 00 EB 06 81 C9 00 03 00 00 8A 45 88 A8 01 74 05 83 E1 DF EB 03 83 C9 20 A8 02 74 05 83 E1 EF EB 03 83 C9 10 A8 04 74 05 83 E1 F7 EB 03 83 C9 08 A8 08 74 05 83 E1 FB EB 03 83 C9 04 A8 10 74 05 83 E1 FE EB 03 83 C9 01 89 0E 8B 85 78 FF FF FF EB 0B 52 51 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_448_2_0 {
	meta:
		name = "__wassert"
		size = 1874
		refs = "000c ___security_cookie 002d __set_error_mode 0049 ___app_type 0055 ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 0067 _wcscpy_s 007a __invoke_watson 0083 _dblnewline 0090 _wcscat_s 00a9 ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 00e6 __imp__GetModuleFileNameW@12 00ef ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0122 _wcslen 014c _dotdotdot 015c _wcsncpy_s 0198 _newline 01be ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0282 _wcsncat_s 044a ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 049c __itow_s 04dc ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 05b9 ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@ 0606 ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@ 0637 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 063d ___crtMessageBoxW 064c _raise 0654 __exit 0675 __imp__GetStdHandle@4 067e __assertstring 06a8 _swprintf 06b6 __imp__GetFileType@4 06df __imp__WriteConsoleW@20 06e8 _abort 06ed ___iob_func 0708 _setvbuf 0729 _fwprintf 0737 _fflush 074c @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 58 06 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 89 85 AC F9 FF FF 8B 45 0C 57 6A 03 89 85 B4 F9 FF FF E8 ?? ?? ?? ?? 59 83 F8 01 0F 84 36 06 00 00 6A 03 E8 ?? ?? ?? ?? 59 85 C0 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 1D 06 00 00 68 ?? ?? ?? ?? BE 1C 02 00 00 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 33 FF 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 66 89 85 C0 FB FF FF 68 04 01 00 00 8D 85 B8 F9 FF FF 50 57 FF 15 ?? ?? ?? ?? 85 C0 75 2A 68 ?? ?? ?? ?? 8D 85 B8 F9 FF FF 68 05 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 9D B8 F9 FF FF 8B C3 50 E8 ?? ?? ?? ?? 83 C0 0B 59 83 F8 3C 76 45 8B C3 50 E8 ?? ?? ?? ?? 8D 9C 45 56 F9 FF FF 8D 8D B8 F9 FF FF 8B C3 2B C1 6A 03 FF 35 ?? ?? ?? ?? D1 F8 B9 05 01 00 00 2B C8 51 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 53 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF B5 B4 F9 FF FF E8 ?? ?? ?? ?? 83 C0 08 59 FF B5 B4 F9 FF FF 83 F8 3C 0F 86 00 02 00 00 E8 ?? ?? ?? ?? 8B 95 B4 F9 FF FF 8B D8 0F B7 44 5A FE 59 C7 85 B0 F9 FF FF 01 00 00 00 66 83 F8 5C 74 29 0F B7 C8 8D 44 5A FE 66 83 F9 2F 74 1C 39 9D B0 F9 FF FF 73 14 FF 85 B0 F9 FF FF 48 48 0F B7 10 0F B7 CA 66 83 FA 5C 75 DE 8B C3 2B 85 B0 F9 FF FF 89 85 A8 F9 FF FF 83 F8 23 76 78 83 BD B0 F9 FF FF 11 73 6C 6A 31 58 2B 85 B0 F9 FF FF 50 FF B5 B4 F9 FF FF 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 B4 F9 FF FF 8B 8D A8 F9 FF FF 8D 04 48 E9 2B 01 00 00 83 F8 23 73 72 D1 AD B0 F9 FF FF 6A 31 58 2B 85 B0 F9 FF FF 50 FF B5 B4 F9 FF FF 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 2B 9D B0 F9 FF FF 8B 85 B4 F9 FF FF 8D 04 58 E9 B4 00 00 00 6A 20 FF B5 B4 F9 FF FF 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 8D A8 F9 FF FF 8B 85 B4 F9 FF FF 6A 07 8D 04 48 50 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 B4 F9 FF FF 8D 44 58 F2 50 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 85 C4 FB FF FF 6A 0A 50 E8 ?? ?? ?? ?? 59 8B CE 2B C8 51 8D 85 C4 FB FF FF 50 E8 ?? ?? ?? ?? 59 8D 84 45 C4 FB FF FF 50 FF 75 10 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF B5 AC F9 FF FF E8 ?? ?? ?? ?? 8B D8 8D 85 C4 FB FF FF 50 E8 ?? ?? ?? ?? 8D 84 03 B0 00 00 00 59 3B C6 59 8D 85 C4 FB FF FF 76 43 50 E8 ?? ?? ?? ?? B9 69 01 00 00 2B C8 51 FF B5 AC F9 FF FF 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF EB 06 FF B5 AC F9 FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 C4 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 68 12 20 01 00 8D 85 C4 FB FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 03 75 0F 6A 16 E8 ?? ?? ?? ?? 59 6A 03 E8 ?? ?? ?? ?? 83 F8 04 75 06 CC E9 E0 00 00 00 83 F8 05 0F 85 D2 00 00 00 E9 D2 00 00 00 6A F4 FF 15 ?? ?? ?? ?? 8B D8 33 FF BE ?? ?? ?? ?? 83 FB FF 74 65 3B DF 74 61 FF 75 10 8D 85 C4 FB FF FF FF B5 B4 F9 FF FF FF B5 AC F9 FF FF 56 68 1C 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 7C 39 53 FF 15 ?? ?? ?? ?? 83 F8 02 75 2D 57 8D 85 A8 F9 FF FF 50 8D 85 C4 FB FF FF 50 E8 ?? ?? ?? ?? 59 50 8D 85 C4 FB FF FF 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 40 4C 0C 01 00 00 75 15 57 6A 04 57 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 10 FF 75 10 FF B5 B4 F9 FF FF FF B5 AC F9 FF FF 56 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "_strspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 72 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "__aulldiv"
		size = 104
	strings:
		$1 = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 3B 44 24 0C 76 01 4E 33 D2 8B C6 5E 5B C2 10 00 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "_vfwscanf"
		size = 131
		refs = "0003 __sehtable$_vfwscanf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0047 __lock_file 0074 __SEH_epilog4 007d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3C 33 C0 39 75 10 0F 95 C0 3B C6 74 D7 FF 75 0C E8 ?? ?? ?? ?? 59 89 75 FC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_451_1_0 {
	meta:
		name = "_fwscanf"
		size = 32
		refs = "0012 __winput_l 0017 _vfwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_820_1_0 {
	meta:
		name = "_fscanf"
		size = 32
		refs = "0012 __input_l 0017 _vfscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_820_3_0 {
	meta:
		name = "_fscanf_s"
		size = 32
		refs = "0012 __input_s_l 0017 _vfscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_451_3_0 {
	meta:
		name = "_fwscanf_s"
		size = 32
		refs = "0012 __winput_s_l 0017 _vfwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_451_2_0 {
	meta:
		name = "__fwscanf_l"
		size = 33
		refs = "0013 __winput_l 0018 _vfwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_820_2_0 {
	meta:
		name = "__fscanf_l"
		size = 33
		refs = "0013 __input_l 0018 _vfscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_820_4_0 {
	meta:
		name = "__fscanf_s_l"
		size = 33
		refs = "0013 __input_s_l 0018 _vfscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_451_4_0 {
	meta:
		name = "__fwscanf_s_l"
		size = 33
		refs = "0013 __winput_s_l 0018 _vfwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "___tlregdtor"
		size = 107
		refs = "0006 __tls_index 000d __tls_array 0017 _dtor_list 0021 _dtor_list_head 0032 __malloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 56 8B 34 81 8B 86 ?? ?? ?? ?? 85 C0 75 08 8D 86 ?? ?? ?? ?? EB 25 83 38 1E 75 29 68 80 00 00 00 E8 ?? ?? ?? ?? 59 85 C0 75 05 83 C8 FF EB 28 8B 8E ?? ?? ?? ?? 83 20 00 89 48 04 83 20 00 89 86 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 8B 06 8B 4D 08 89 4C 86 08 FF 06 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_452_1_0 {
	meta:
		name = "___dyn_tls_dtor@12"
		size = 100
		refs = "0012 __tls_index 0019 __tls_array 0023 _dtor_list 004f _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 03 74 06 83 7D 0C 00 75 4C A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 04 81 56 8B B0 ?? ?? ?? ?? 85 F6 74 31 53 57 8B 3E 4F 78 14 8D 5C BE 08 8B 03 85 C0 74 02 FF D0 4F 83 EB 04 85 FF 7D F0 8B 7E 04 85 FF 74 07 56 E8 ?? ?? ?? ?? 59 8B F7 85 FF 75 D3 5F 5B 5E 33 C0 40 5D C2 0C 00 }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "__fread_nolock_s"
		size = 522
		refs = "0028 __errno 0038 __invalid_parameter 0063 _memset 00d8 _memcpy_s 0138 __fileno 013f __read 0163 __filbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 4D 08 53 8B 5D 0C 56 57 33 FF 89 4D F8 89 5D FC 39 7D 10 74 21 39 7D 14 74 1C 3B CF 75 1F E8 ?? ?? ?? ?? 57 57 57 57 C7 00 16 00 00 00 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5E 5B C9 C3 8B 75 18 3B F7 74 0D 83 C8 FF 33 D2 F7 75 10 39 45 14 76 21 83 FB FF 74 0B 53 57 51 E8 ?? ?? ?? ?? 83 C4 0C 3B F7 74 B9 83 C8 FF 33 D2 F7 75 10 39 45 14 77 AC 8B 7D 10 0F AF 7D 14 F7 46 0C 0C 01 00 00 89 7D F0 8B DF 74 08 8B 46 18 89 45 F4 EB 07 C7 45 F4 00 10 00 00 85 FF 0F 84 EA 00 00 00 F7 46 0C 0C 01 00 00 74 44 8B 46 04 85 C0 74 3D 0F 8C 35 01 00 00 8B FB 3B D8 72 02 8B F8 3B 7D FC 0F 87 CB 00 00 00 57 FF 36 FF 75 FC FF 75 F8 E8 ?? ?? ?? ?? 29 7E 04 01 3E 01 7D F8 2B DF 83 C4 10 29 7D FC 8B 7D F0 E9 95 00 00 00 3B 5D F4 72 68 83 7D F4 00 74 1F B9 FF FF FF 7F 33 D2 3B D9 76 09 8B C1 F7 75 F4 8B C1 EB 07 8B C3 F7 75 F4 8B C3 2B C2 EB 0B B8 FF FF FF 7F 3B D8 77 02 8B C3 3B 45 FC 0F 87 93 00 00 00 50 FF 75 F8 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B6 00 00 00 83 F8 FF 0F 84 9B 00 00 00 01 45 F8 2B D8 29 45 FC EB 28 56 E8 ?? ?? ?? ?? 59 83 F8 FF 0F 84 85 00 00 00 83 7D FC 00 74 4E 8B 4D F8 FF 45 F8 88 01 8B 46 18 4B FF 4D FC 89 45 F4 85 DB 0F 85 16 FF FF FF 8B 45 14 E9 A8 FE FF FF 33 F6 83 7D 0C FF 74 0F FF 75 0C 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 56 56 56 56 C7 00 22 00 00 00 56 E9 72 FE FF FF 83 7D 0C FF 74 10 FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 50 50 50 50 50 E9 45 FE FF FF 83 4E 0C 20 8B C7 2B C3 33 D2 F7 75 10 E9 3D FE FF FF 83 4E 0C 10 EB EC }
	condition:
		$1
}

rule file_453_1_0 {
	meta:
		name = "__fread_nolock"
		size = 29
		refs = "0014 __fread_nolock_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "_fread"
		size = 29
		refs = "0014 _fread_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_453_2_0 {
	meta:
		name = "_fread_s"
		size = 150
		refs = "0003 __sehtable$_fread_s 0008 __SEH_prolog4 002e _memset 0036 __errno 0046 __invalid_parameter 0050 __SEH_epilog4 0059 __lock_file 0071 __fread_nolock_s 0090 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 39 75 10 74 37 39 75 14 74 32 39 75 18 75 35 83 7D 0C FF 74 0F FF 75 0C 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E8 ?? ?? ?? ?? C3 FF 75 18 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 8B 45 E4 EB C3 FF 75 18 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__wchartodigit"
		size = 475
	strings:
		$1 = { 8B FF 55 8B EC 66 8B 45 08 66 83 F8 30 73 07 B8 FF FF FF FF 5D C3 66 83 F8 3A 73 08 0F B7 C0 83 E8 30 5D C3 B9 10 FF 00 00 8B D1 66 3B C2 0F 83 94 01 00 00 B9 60 06 00 00 8B D1 66 3B C2 0F 82 92 01 00 00 83 C2 0A 66 3B C2 73 07 0F B7 C0 2B C1 5D C3 B9 F0 06 00 00 8B D1 66 3B C2 0F 82 73 01 00 00 83 C2 0A 66 3B C2 72 E1 B9 66 09 00 00 8B D1 66 3B C2 0F 82 5B 01 00 00 83 C2 0A 66 3B C2 72 C9 B9 E6 09 00 00 8B D1 66 3B C2 0F 82 43 01 00 00 83 C2 0A 66 3B C2 72 B1 B9 66 0A 00 00 8B D1 66 3B C2 0F 82 2B 01 00 00 83 C2 0A 66 3B C2 72 99 B9 E6 0A 00 00 8B D1 66 3B C2 0F 82 13 01 00 00 83 C2 0A 66 3B C2 72 81 B9 66 0B 00 00 8B D1 66 3B C2 0F 82 FB 00 00 00 83 C2 0A 66 3B C2 0F 82 65 FF FF FF B9 66 0C 00 00 8B D1 66 3B C2 0F 82 DF 00 00 00 83 C2 0A 66 3B C2 0F 82 49 FF FF FF B9 E6 0C 00 00 8B D1 66 3B C2 0F 82 C3 00 00 00 83 C2 0A 66 3B C2 0F 82 2D FF FF FF B9 66 0D 00 00 8B D1 66 3B C2 0F 82 A7 00 00 00 83 C2 0A 66 3B C2 0F 82 11 FF FF FF B9 50 0E 00 00 8B D1 66 3B C2 0F 82 8B 00 00 00 83 C2 0A 66 3B C2 0F 82 F5 FE FF FF B9 D0 0E 00 00 8B D1 66 3B C2 72 73 83 C2 0A 66 3B C2 0F 82 DD FE FF FF 83 C1 50 8B D1 66 3B C2 72 5D BA 2A 0F 00 00 66 3B C2 0F 82 C5 FE FF FF B9 40 10 00 00 8B D1 66 3B C2 72 43 83 C2 0A 66 3B C2 0F 82 AD FE FF FF B9 E0 17 00 00 8B D1 66 3B C2 72 2B 83 C2 0A 66 3B C2 0F 82 95 FE FF FF 83 C1 30 8B D1 66 3B C2 72 15 BA 1A 18 00 00 EB 05 BA 1A FF 00 00 66 3B C2 0F 82 76 FE FF FF 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_455_3_0 {
	meta:
		name = "?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z"
		size = 118
		refs = "001b __errno 002a __invalid_parameter 0045 __fptostr"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 3B CB 56 7E 04 8B C1 EB 02 33 C0 83 C0 02 3B D0 73 1B E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 3D 8D 42 FE 3B C8 7F 02 8B C1 57 50 52 FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 74 09 E8 ?? ?? ?? ?? 89 30 EB D6 8B 4D 10 33 C0 83 3F 2D 0F 94 C0 89 01 8B 47 04 8B 4D 0C 89 01 33 C0 5E 5B 5D C3 }
	condition:
		$1
}

rule file_455_5_0 {
	meta:
		name = "__fcvt_s"
		size = 169
		refs = "0009 ___security_cookie 002b __errno 003a __invalid_parameter 0065 __fltout2 0093 ?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z 00a3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8B 4D 20 53 56 57 8B 7D 08 33 DB 89 45 E0 89 4D DC 3B FB 75 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 55 39 5D 0C 76 E0 88 1F 3B C3 74 DA 3B CB 74 D6 6A 16 8D 45 E4 50 8D 45 CC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 8B 75 18 8B 50 04 83 C4 14 3B F3 8D 0C 32 7E 0D 3B D3 7E 09 3B CE 7D 05 B9 FF FF FF 7F FF 75 DC 8B 55 0C FF 75 E0 57 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_455_6_0 {
	meta:
		name = "__fcvt"
		size = 157
		refs = "0009 ___security_cookie 001e __getptd_noexit 0036 __malloc_crt 0056 __fltout2 007f __fcvt_s 0097 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 53 8B 5D 14 56 89 45 E0 E8 ?? ?? ?? ?? 8B F0 85 F6 74 67 83 7E 48 00 57 BF 5D 01 00 00 75 0E 57 E8 ?? ?? ?? ?? 59 89 46 48 85 C0 74 4C 8B 76 48 6A 16 8D 45 E4 50 8D 45 D0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? B9 5B 01 00 00 2B 48 04 83 C4 14 39 4D 10 7C 03 89 4D 10 FF 75 E0 DD 45 08 53 FF 75 10 51 51 DD 1C 24 57 56 E8 ?? ?? ?? ?? 83 C4 1C F7 D8 1B C0 F7 D0 23 C6 5F 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_455_7_0 {
	meta:
		name = "__ecvt_s"
		size = 173
		refs = "0009 ___security_cookie 002e __errno 003d __invalid_parameter 0068 __fltout2 007a ?_fpcvt@@YAHPADIPAU_strflt@@HPAH2@Z 00a7 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 53 56 8B 75 08 89 45 E0 8B 45 20 33 DB 57 8B 7D 1C 89 45 DC 3B F3 75 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 56 39 5D 0C 76 E0 88 1E 3B FB 74 DA 3B C3 74 D6 6A 16 8D 45 E4 50 8D 45 CC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? FF 75 DC 8B 4D E0 8B 55 0C 57 56 8B F8 E8 ?? ?? ?? ?? 8B 4D 0C 83 C1 FE 83 C4 20 39 4D E0 7E 03 89 4D E0 8B 4D E0 3B CB 7C 08 03 F1 38 1E 74 02 88 1E 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_455_8_0 {
	meta:
		name = "__ecvt"
		size = 98
		refs = "0007 __getptd_noexit 001f __malloc_crt 004f __ecvt_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 4E 83 7E 48 00 57 BF 5D 01 00 00 75 0E 57 E8 ?? ?? ?? ?? 59 89 46 48 85 C0 74 33 8B 76 48 B8 5B 01 00 00 39 45 10 7C 03 89 45 10 FF 75 18 DD 45 08 FF 75 14 FF 75 10 51 51 DD 1C 24 57 56 E8 ?? ?? ?? ?? 83 C4 1C F7 D8 1B C0 F7 D0 23 C6 5F 5E 5D C3 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "_memmove_s"
		size = 93
		refs = "0016 __errno 0025 __invalid_parameter 0050 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 56 57 33 FF 3B C7 74 47 39 7D 08 75 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 29 39 7D 10 74 E0 39 45 0C 73 0E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB D7 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "__mbsninc_l"
		size = 37
		refs = "0019 __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 04 33 C0 5D C3 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 03 45 08 5D C3 }
	condition:
		$1
}

rule file_461_1_0 {
	meta:
		name = "__abs64"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 85 C9 7C 06 7F 0B 85 C0 73 07 F7 D8 83 D1 00 F7 D9 8B D1 5D C3 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "__aligned_offset_malloc"
		size = 157
		refs = "0010 __errno 0022 __invalid_parameter 0077 _malloc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8D 48 FF 85 C8 74 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5D C3 8B 4D 08 53 8B 5D 10 56 33 F6 3B DE 74 20 3B D9 72 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3E 83 F8 04 77 03 6A 04 58 8B F3 F7 DE 57 8D 78 FF 83 E6 03 8D 04 0E 8D 44 38 04 50 E8 ?? ?? ?? ?? 59 8B C8 85 C9 74 16 8D 04 31 03 C7 8D 44 18 04 F7 D7 23 C7 2B C3 8B D0 2B D6 89 4A FC 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_462_1_0 {
	meta:
		name = "__aligned_msize"
		size = 85
		refs = "0010 __errno 0020 __invalid_parameter 0033 __msize"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 26 83 E0 FC FF 70 FC E8 ?? ?? ?? ?? 8B 55 0C 59 8B 4D 10 F7 D9 83 E1 03 83 FA 04 77 03 6A 04 5A 2B C2 2B C1 83 E8 03 5E 5D C3 }
	condition:
		$1
}

rule file_462_2_0 {
	meta:
		name = "__aligned_free"
		size = 26
		refs = "0013 _free"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 0C 83 E0 FC FF 70 FC E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_462_4_0 {
	meta:
		name = "__aligned_offset_realloc"
		size = 368
		refs = "001d __aligned_offset_malloc 0032 __aligned_free 0056 __errno 0066 __invalid_parameter 009b __msize 00dc __expand 00f7 _malloc 014b _memmove 015a _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 56 33 F6 89 75 F8 39 75 08 75 16 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C E9 44 01 00 00 39 75 0C 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 33 C0 E9 2F 01 00 00 57 8B 7D 10 8D 47 FF 85 C7 75 0C 8B 45 14 3B C6 74 24 3B 45 0C 72 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F8 00 00 00 8B 4D 08 83 E1 FC 53 8B 59 FC 89 5D E8 83 FF 04 77 03 6A 04 5F 8B F0 8B 45 08 2B C3 F7 DE 53 4F 83 E6 03 89 45 EC E8 ?? ?? ?? ?? 59 8B CB 2B 4D 08 03 C1 8B 4D 0C 89 45 F0 3B C1 76 03 89 4D F0 8D 04 0E 8D 0C 1E 8D 4C 39 04 8D 44 38 04 89 45 F4 3B 4D 08 73 03 50 EB 29 E8 ?? ?? ?? ?? FF 75 F4 8B 00 53 89 45 E4 E8 ?? ?? ?? ?? 59 59 89 45 FC 85 C0 75 23 E8 ?? ?? ?? ?? 8B 4D E4 FF 75 F4 89 08 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 74 68 C7 45 F8 01 00 00 00 EB 03 89 45 E8 8B 45 08 8B 4D FC 8B D0 2B 55 EC 3B CA 75 0E 8D 14 06 03 55 14 8B DF F7 D3 85 D3 74 3F 8B 45 14 FF 75 F0 03 CE 03 CF 8D 5C 01 04 F7 D7 23 DF 8B 7D E8 2B D8 8B 45 EC 03 C7 50 53 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 00 74 07 57 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C3 2B C6 89 48 FC 8B C3 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_462_5_0 {
	meta:
		name = "__aligned_offset_recalloc"
		size = 139
		refs = "001c __errno 002c __invalid_parameter 004e __aligned_msize 0062 __aligned_offset_realloc 007d _memset"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 33 DB 3B CB 76 28 6A E0 33 D2 58 F7 F1 3B 45 10 73 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 51 0F AF 4D 10 56 57 8B F1 39 5D 08 74 13 FF 75 18 FF 75 14 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 FF 75 18 FF 75 14 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 10 85 FF 74 15 3B DE 73 11 2B F3 56 8D 04 1F 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "__heapchk"
		size = 141
		refs = "0003 __sehtable$__heapchk 0008 __SEH_prolog4 0014 ___active_heap 001e __lock 0028 ___sbh_heap_check 0045 __crtheap 004b __imp__HeapValidate@12 0055 __imp__GetLastError@0 0061 ___doserrno 0068 __errno 0077 __unlock 0088 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A FE 5E 89 75 E4 83 3D ?? ?? ?? ?? 03 75 24 6A 04 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 85 C0 7D 07 C7 45 E4 FC FF FF FF 89 75 FC E8 35 00 00 00 6A 00 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 31 FF 15 ?? ?? ?? ?? 6A 78 5E 3B C6 75 1D E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 28 00 00 00 EB 10 6A 04 E8 ?? ?? ?? ?? 59 C3 C7 45 E4 FC FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "___libm_sse2_tan"
		size = 597
		refs = "001f _PI32INV 002f _SHIFTER 003b _P_1 0047 _QQ_2 0055 _P_2 0074 _P_3 008f _ONE 0098 _Ctable 00a0 _MASK_35 01f2 _TWO_POW_M55 01fa _TWO_POW_55 0217 _sign_mask 0227 _INF 023f _tan"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 C7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA F2 0F 10 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F2 0F 10 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 F2 0F 10 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 E6 F2 0F 10 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 C3 7F 33 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 28 C3 C3 F3 0F 7E 3D ?? ?? ?? ?? 66 0F 54 F8 66 0F 57 F8 66 0F 2E 3D ?? ?? ?? ?? 74 23 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 8B 64 24 08 C3 F2 0F 5C C0 C3 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "___libm_sse2_acos"
		size = 1187
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 007f _T_table 008c _Tbl_addr 00b8 _cv 00fb _PI_BY_2 01ba _NEG_PI 026a _cv2 0303 _ONE_BY_2 034a _HALFMASK 0463 _PI"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 C9 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 F8 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E FE 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 C1 66 0F 57 E2 F2 0F 59 EB 66 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 C6 F2 0F 59 C3 F2 0F 5C EC 66 0F 70 E4 EE F2 0F 58 C5 F2 0F 5C C7 83 C4 0C F2 0F 5C C4 C3 2D BB 03 00 00 83 F8 41 0F 83 20 01 00 00 66 0F 73 D7 26 66 0F 73 F7 26 66 0F D7 C0 66 0F 55 E0 F2 0F 5C CF F2 0F 10 F7 F2 0F 59 FF F2 0F 58 C6 66 0F 56 EC F2 0F 5C DF F2 0F 59 C1 F2 0F 10 E3 F2 0F 5C D8 F2 0F 51 DB 25 80 00 00 00 C1 E8 07 F7 D8 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 66 0F 6E D8 66 0F 70 DB 00 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 66 0F 54 1D ?? ?? ?? ?? F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 58 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB F2 0F 58 C5 25 00 80 00 00 66 0F C4 F0 03 F2 0F 10 EC 66 0F 70 DB EE F2 0F 58 E3 F2 0F 5C DC F2 0F 58 EB F2 0F 58 C5 F2 0F 58 C4 83 C4 0C 66 0F 57 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 0F 83 83 00 00 00 66 0F 14 C0 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 C0 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 F0 66 0F 59 C0 F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E0 F2 0F 59 CB 66 0F 58 F4 66 0F 70 C5 EE 66 0F 59 CE 66 0F 70 F5 EE F2 0F 5C C7 66 0F 70 D1 EE F2 0F 5C E9 F2 0F 5C F0 F2 0F 5C EA F2 0F 5C FE 83 C4 0C F2 0F 5C EF F2 0F 58 C5 C3 2D FC 3B 00 00 83 F8 04 0F 83 E7 00 00 00 66 0F 57 F6 66 0F 54 3D ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 FC 66 0F 28 15 ?? ?? ?? ?? F2 0F 5C E7 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 FC 44 F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 12 0D ?? ?? ?? ?? 66 0F 59 DF F2 0F C2 C6 01 F2 0F 59 FD 66 0F 58 D3 66 0F 70 C0 44 F2 0F 59 D7 66 0F 54 05 ?? ?? ?? ?? 66 0F 59 D5 66 0F 54 CC 66 0F 70 DC 44 F2 0F 5C E1 F2 0F 58 DB F2 0F 59 C9 F2 0F 5C DC F2 0F 5C E9 F2 0F 59 E3 66 0F 70 DB EE F2 0F 5C EC F2 0F 5E EB 66 0F 58 DB 66 0F 59 D3 66 0F 70 E2 EE F2 0F 58 D0 25 00 80 00 00 66 0F C4 F0 03 66 0F 70 C0 EE F2 0F 58 D4 F2 0F 58 D5 F2 0F 58 D3 F2 0F 58 C2 83 C4 0C 66 0F 57 C6 C3 05 FC FE 03 00 3D 00 FF 03 00 0F 82 95 00 00 00 66 0F 7E F9 66 0F 73 D7 20 66 0F 7E FA 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 65 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 83 C4 0C F2 0F 59 C1 C3 66 0F C5 D7 01 C1 EA 0F F7 DA 66 0F 6E FA 66 0F 70 FF 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 66 0F 54 D7 66 0F 54 C7 83 C4 0C F2 0F 58 C2 C3 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 C3 66 0F 57 F6 83 C4 0C F2 0F 58 C6 C3 }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "__wexeclp"
		size = 76
		refs = "0010 __errno 0020 __invalid_parameter 0043 __wexecvp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 1D 66 39 31 74 DE 8B 45 0C 3B C6 74 D7 66 39 30 74 D2 8D 45 0C 50 51 E8 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_468_3_0 {
	meta:
		name = "__mbsnbcpy_l"
		size = 227
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0037 __invalid_parameter 0068 _strncpy 00b6 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 FF 75 14 8D 4D F0 89 75 08 E8 ?? ?? ?? ?? 33 DB 3B F3 75 2D 39 5D 10 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 7F 8B 4D 0C 3B CB 75 05 39 5D 10 75 CC 8B 55 F4 39 5A 08 75 1B FF 75 10 51 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 74 59 8B 4D F8 83 61 70 FD EB 50 39 5D 10 74 3C 57 8A 01 FF 4D 10 0F B6 F8 F6 44 17 1D 04 88 06 74 3D 46 41 39 5D 10 74 43 8A 01 FF 4D 10 88 06 46 41 3A C3 75 2F 88 5E FE 39 5D 10 74 0D FF 75 10 53 56 E8 ?? ?? ?? ?? 83 C4 0C 5F 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5E 5B C9 C3 46 41 3A C3 74 D4 39 5D 10 75 A7 EB DF 88 5E FF EB DA }
	condition:
		$1
}

rule file_469_4_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 101
		refs = "000e __callnewh 001b _malloc 0028 ?$S1@?5???2@YAPAXI@Z@4IA 002e ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 003e ??0bad_alloc@std@@QAE@XZ 0043 ??__Fnomem@?5???2@YAPAXI@Z@YAXXZ 0048 _atexit 0052 ??0bad_alloc@std@@QAE@ABV01@@Z 0057 __TI2?AVbad_alloc@std@@ 0060 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C EB 0D FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 74 0F FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 74 E6 C9 C3 F6 05 ?? ?? ?? ?? 01 BE ?? ?? ?? ?? 75 19 83 0D ?? ?? ?? ?? 01 8B CE E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 56 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "__local_unwind4"
		size = 144
		refs = "0015 __unwind_handler4 0021 ___security_cookie 006f __NLG_Notify 007c __NLG_Call"
	strings:
		$1 = { 53 56 57 8B 54 24 10 8B 44 24 14 8B 4C 24 18 55 52 50 51 51 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 A1 ?? ?? ?? ?? 33 C4 89 44 24 08 64 89 25 00 00 00 00 8B 44 24 30 8B 58 08 8B 4C 24 2C 33 19 8B 70 0C 83 FE FE 74 3B 8B 54 24 34 83 FA FE 74 04 3B F2 76 2E 8D 34 76 8D 5C B3 10 8B 0B 89 48 0C 83 7B 04 00 75 CC 68 01 01 00 00 8B 43 08 E8 ?? ?? ?? ?? B9 01 00 00 00 8B 43 08 E8 ?? ?? ?? ?? EB B0 64 8F 05 00 00 00 00 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule file_470_1_0 {
	meta:
		name = "__unwind_handler4"
		size = 70
		refs = "001c @__security_check_cookie@4"
	strings:
		$1 = { 8B 4C 24 04 F7 41 04 06 00 00 00 B8 01 00 00 00 74 33 8B 44 24 08 8B 48 08 33 C8 E8 ?? ?? ?? ?? 55 8B 68 18 FF 70 0C FF 70 10 FF 70 14 E8 3E FF FF FF 83 C4 0C 5D 8B 44 24 08 8B 54 24 10 89 02 B8 03 00 00 00 C3 }
	condition:
		$1
}

rule file_470_2_0 {
	meta:
		name = "__seh_longjmp_unwind4@4"
		size = 28
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 FF 71 1C FF 71 18 FF 71 28 E8 15 FF FF FF 83 C4 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_470_3_0 {
	meta:
		name = "@_EH4_CallFilterFunc@8"
		size = 23
	strings:
		$1 = { 55 56 57 53 8B EA 33 C0 33 DB 33 D2 33 F6 33 FF FF D1 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_470_4_0 {
	meta:
		name = "@_EH4_TransferToHandler@8"
		size = 25
		refs = "0009 __NLG_Notify"
	strings:
		$1 = { 8B EA 8B F1 8B C1 6A 01 E8 ?? ?? ?? ?? 33 C0 33 DB 33 C9 33 D2 33 FF FF E6 }
	condition:
		$1
}

rule file_470_5_0 {
	meta:
		name = "@_EH4_GlobalUnwind@4"
		size = 26
		refs = "000b ReturnPoint 0011 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 53 56 57 6A 00 6A 00 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_470_6_0 {
	meta:
		name = "@_EH4_LocalUnwind@16"
		size = 23
	strings:
		$1 = { 55 8B 6C 24 08 52 51 FF 74 24 14 E8 B4 FE FF FF 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_471_3_0 {
	meta:
		name = "__mbsnbcat_l"
		size = 315
		refs = "0021 __errno 0031 __invalid_parameter 006d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 007f _strncat 00b8 __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 33 DB 39 5D 10 75 08 8B 45 08 E9 20 01 00 00 56 8B 75 08 3B F3 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F8 00 00 00 57 8B 7D 0C 3B FB 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D0 00 00 00 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 39 58 08 75 22 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F8 0F 84 A7 00 00 00 8B 4D F4 83 61 70 FD E9 9B 00 00 00 8B C6 89 45 FC 8A 0E 46 84 C9 75 F9 4E 3B F0 74 19 8D 4D EC 51 8B CE 2B C8 49 51 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 01 4E 8A 07 8B 55 F0 FF 4D 10 0F B6 C8 F6 44 11 1D 04 88 06 74 3B 46 47 39 5D 10 74 41 8A 07 FF 4D 10 88 06 46 47 3A C3 75 2D 88 5E FE 8B 7D FC 3B F7 74 2F 8D 45 EC 50 8B C6 2B C7 48 50 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 17 88 5E FF EB 14 46 47 3A C3 74 D6 39 5D 10 75 A6 EB CF 88 5E FF EB CA 88 1E 38 5D F8 74 07 8B 45 F4 83 60 70 FD 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "_fix_grouping"
		size = 51
	strings:
		$1 = { 32 D2 38 11 74 17 53 56 8A 01 3C 30 7C 10 3C 39 7F 0C 2C 30 88 01 41 38 11 75 ED 5E 5B C3 3C 3B 75 F4 8B C1 8D 70 01 8A 1E 88 18 8B C6 38 10 75 F3 EB E4 }
	condition:
		$1
}

rule file_472_1_0 {
	meta:
		name = "___free_lconv_mon"
		size = 142
		refs = "0012 ___lconv_c 001a _free"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 74 7E 8B 46 0C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 10 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 14 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 18 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 1C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 20 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 76 24 3B 35 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 5E 5D C3 }
	condition:
		$1
}

rule file_472_2_0 {
	meta:
		name = "___init_monetary"
		size = 710
		refs = "002a ___lconv_c 0038 __calloc_crt 004f __malloc_crt 005d _free 00a3 ___getlocaleinfo 01d1 ___free_lconv_mon 0276 __imp__InterlockedDecrement@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 57 33 FF 89 7D FC 89 75 F0 89 7D F4 39 7E 18 75 15 39 7E 1C 75 10 89 7D FC 89 7D F8 BB ?? ?? ?? ?? E9 36 02 00 00 6A 30 6A 01 E8 ?? ?? ?? ?? 8B D8 59 59 3B DF 75 08 33 C0 40 E9 75 02 00 00 6A 04 E8 ?? ?? ?? ?? 59 89 45 F8 3B C7 75 09 53 E8 ?? ?? ?? ?? 59 EB E0 89 38 39 7E 18 0F 84 B9 01 00 00 6A 04 E8 ?? ?? ?? ?? 59 89 45 FC 3B C7 75 11 53 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 59 EB D2 89 38 0F B7 76 38 8D 43 0C 50 6A 15 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 8B F8 8D 43 10 50 6A 14 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 14 50 6A 16 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 18 50 6A 17 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 1C 50 6A 18 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 20 50 6A 50 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 24 50 6A 51 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 28 50 6A 1A 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 29 50 6A 19 56 6A 00 8D 45 F0 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2A 50 6A 54 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2B 50 6A 55 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2C 50 6A 56 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 2D 50 6A 57 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2E 50 6A 52 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2F 50 6A 53 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 3C 0B C7 74 24 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 E9 51 FE FF FF 8B 43 1C EB 12 8A 08 80 F9 30 7C 12 80 F9 39 7F 0D 80 E9 30 88 08 40 80 38 00 75 E9 EB 23 80 F9 3B 75 F3 8B F0 8D 7E 01 8A 0F 88 0E 8B F7 80 3E 00 75 F2 EB E2 6A 0C 59 BE ?? ?? ?? ?? 8B FB F3 A5 8B 45 08 8B 75 08 05 BC 00 00 00 8B 08 8B 09 89 0B 8B 08 8B 49 04 89 4B 04 8B 00 8B 40 08 8B 4D F8 89 43 08 33 C0 40 33 FF 89 01 39 7D FC 74 05 8B 4D FC 89 01 8B 86 B8 00 00 00 3B C7 74 07 50 FF 15 ?? ?? ?? ?? 8B 86 B0 00 00 00 3B C7 74 23 50 FF 15 ?? ?? ?? ?? 85 C0 75 18 FF B6 BC 00 00 00 E8 ?? ?? ?? ?? FF B6 B0 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 45 FC 89 86 B8 00 00 00 8B 45 F8 89 86 B0 00 00 00 89 9E BC 00 00 00 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__swprintf"
		size = 152
		refs = "0011 __errno 0021 __invalid_parameter 0056 __woutput_l 0074 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 68 8B 45 08 3B C3 74 DC 56 89 45 E8 89 45 E0 8D 45 10 50 53 FF 75 0C 8D 45 E0 50 C7 45 EC 42 00 00 00 C7 45 E4 FF FF FF 7F E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_474_3_0 {
	meta:
		name = "_find"
		size = 145
		refs = "000d ?findbuf@?1??find@@9@9 001a __malloc_crt 002d ?_WildFindHandle@?1??find@@9@9 0038 __imp__FindClose@4 004e __imp__FindFirstFileA@8 0074 __imp__FindNextFileA@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 5B 83 3D ?? ?? ?? ?? 00 75 18 68 44 02 00 00 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 85 C0 75 04 33 C0 5D C3 A1 ?? ?? ?? ?? 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 FF 35 ?? ?? ?? ?? FF 75 08 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 74 CC A1 ?? ?? ?? ?? 83 C0 2C 5D C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 E0 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 EB 97 }
	condition:
		$1
}

rule file_474_4_0 {
	meta:
		name = "_match"
		size = 489
		refs = "003c __mbsdec 0056 _add 0079 _find 008b _argend 0093 ??_C@_01LFCBOECM@?4?$AA@ 009b __mbscmp 00aa ??_C@_02DJGKEECL@?4?4?$AA@ 00d2 __strdup 00f9 _strlen 0116 __calloc_crt 012b __mbsnbcpy_s 013e __invoke_watson 0152 _strcpy_s 01a7 _arghead 01b6 __mbsicmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 65 F8 00 83 65 F4 00 53 8B D8 85 DB 75 08 83 C8 FF E9 C7 01 00 00 56 8B 75 08 EB 1F 8A 03 3C 5C 74 1D 3C 2F 74 19 3C 3A 74 1A 4B 3B DE 76 0E 43 53 56 E8 ?? ?? ?? ?? 59 59 8B D8 3B DE 75 DD 80 3B 3A 75 13 8D 46 01 3B D8 74 0C 56 E8 ?? ?? ?? ?? 59 E9 85 01 00 00 8A 03 3C 5C 74 08 3C 2F 74 04 3C 3A 75 08 8B C3 2B C6 40 89 45 F8 57 56 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 84 54 01 00 00 8B 3D ?? ?? ?? ?? 89 7D F0 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 DB 00 00 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 C4 00 00 00 8A 03 3C 5C 74 2F 3C 3A 74 2B 3C 2F 74 27 FF 75 FC E8 ?? ?? ?? ?? 59 89 45 08 85 C0 74 0F 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 91 00 00 00 83 C8 FF E9 EF 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 59 8B 4D F8 8D 74 08 01 85 C9 7C E4 83 FE FF 73 DF 3B F1 72 DB 6A 01 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 CB FF 75 F8 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 FF 75 FC 2B F0 03 C7 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 59 85 C0 0F 85 72 FF FF FF 8B 7D F0 FF 45 F4 8B 75 08 6A 00 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 85 FB FE FF FF 39 45 F4 74 41 85 FF 74 05 8B 77 04 EB 06 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 59 59 85 C0 7D 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 07 56 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_474_5_0 {
	meta:
		name = "__cwild"
		size = 184
		refs = "0005 ___argv 000e _argend 0014 _arghead 001f ??_C@_02GNLKMPOH@?$CK?$DP?$AA@ 0025 __mbspbrk 0032 _match 0039 _add 0066 __calloc_crt 0072 ___argc 00a2 _free"
	strings:
		$1 = { 8B FF 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 2B FF 06 8B 06 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 FF 36 3B C7 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 59 85 C0 75 10 83 C6 04 39 3E 75 D1 A1 ?? ?? ?? ?? 33 F6 EB 09 83 C8 FF EB 5E 8B 40 04 46 3B C7 75 F8 8D 46 01 50 6A 04 E8 ?? ?? ?? ?? 59 59 3B C7 74 E2 89 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B CE 3B F7 74 0E 8B 11 89 10 8B 49 04 83 C0 04 3B CF 75 F2 89 38 8B C6 3B F7 74 16 8B 76 04 50 E8 ?? ?? ?? ?? 59 8B C6 3B F7 75 F0 89 35 ?? ?? ?? ?? 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "__mbctokata_l"
		size = 44
		refs = "000e __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 0C 8B 75 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 0F 81 C6 A1 00 00 00 81 FE 7F 83 00 00 72 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "__wfullpath"
		size = 270
		refs = "0022 __imp__GetFullPathNameW@16 0037 __imp__GetLastError@0 003d __dosmaperr 005a __errno 006f _calloc 00a1 __invalid_parameter 00ca _free 0103 __wgetcwd"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 53 33 DB 56 57 3B C3 0F 84 E5 00 00 00 66 39 18 0F 84 DC 00 00 00 8B 35 ?? ?? ?? ?? 39 5D 08 75 5E 53 53 53 50 FF D6 3B C3 75 13 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 E9 C0 00 00 00 8B 7D 10 3B F8 77 02 8B F8 81 FF FF FF FF 7F 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 9E 00 00 00 6A 02 57 E8 ?? ?? ?? ?? 59 59 89 45 FC 3B C3 75 34 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DB 8B 7D 10 3B FB 77 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB BA 8B 45 08 89 45 FC 8D 45 F8 50 FF 75 FC 57 FF 75 0C FF D6 3B C7 72 1B 39 5D 08 75 09 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 88 3B C3 75 17 39 5D 08 0F 85 4C FF FF FF FF 75 FC E8 ?? ?? ?? ?? 59 E9 3E FF FF FF 8B 45 FC EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "_fgets"
		size = 328
		refs = "0003 __sehtable$_fgets 0008 __SEH_prolog4 0021 __errno 0031 __invalid_parameter 0063 __lock_file 0073 __fileno 0092 ___pioinfo 0099 ___badioinfo 0105 __filbuf 0138 __SEH_epilog4 0142 __unlock_file"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 89 45 E0 89 45 E4 33 DB 3B C3 75 24 39 5D 0C 74 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F8 00 00 00 33 C0 39 5D 0C 0F 9D C0 3B C3 74 D5 33 C0 8B 75 10 3B F3 0F 95 C0 3B C3 74 C7 39 5D 0C 74 DA 89 75 DC 56 E8 ?? ?? ?? ?? 59 89 5D FC F6 46 0C 40 75 76 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 5D E4 39 5D E4 74 3C 8B 7D E0 FF 4D 0C 74 32 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 89 45 D8 83 F8 FF 75 0A 3B 7D 08 75 0F 89 5D E4 EB 0C 88 07 47 89 7D E0 3C 0A 75 C9 88 1F C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 DC 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "_vscan_fn"
		size = 99
		refs = "0010 __errno 0020 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 39 75 0C 74 DE 89 45 E8 89 45 E0 B8 FF FF FF 7F C7 45 EC 49 00 00 00 89 45 E4 3B C8 77 03 89 4D E4 FF 75 14 8D 45 E0 FF 75 10 FF 75 0C 50 FF 55 08 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_479_1_0 {
	meta:
		name = "__snscanf"
		size = 35
		refs = "0015 __input_l 001a _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 14 50 8B 45 08 6A 00 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_479_3_0 {
	meta:
		name = "__snscanf_s"
		size = 35
		refs = "0015 __input_s_l 001a _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 14 50 8B 45 08 6A 00 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_707_1_0 {
	meta:
		name = "__snwscanf"
		size = 35
		refs = "0015 __winput_l 001a _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 14 50 8B 45 08 6A 00 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_707_3_0 {
	meta:
		name = "__snwscanf_s"
		size = 35
		refs = "0015 __winput_s_l 001a _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 14 50 8B 45 08 6A 00 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_479_2_0 {
	meta:
		name = "__snscanf_l"
		size = 36
		refs = "0016 __input_l 001b _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_479_4_0 {
	meta:
		name = "__snscanf_s_l"
		size = 36
		refs = "0016 __input_s_l 001b _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_707_2_0 {
	meta:
		name = "__snwscanf_l"
		size = 36
		refs = "0016 __winput_l 001b _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_707_4_0 {
	meta:
		name = "__snwscanf_s_l"
		size = 36
		refs = "0016 __winput_s_l 001b _vscan_fn"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_480_1_0 {
	meta:
		name = "__wfindfirst64i32"
		size = 304
		refs = "000c ___security_cookie 0024 __errno 0034 __invalid_parameter 0052 __imp__FindFirstFileW@8 005f __imp__GetLastError@0 00bf ___time64_t_from_ft 0107 _wcscpy_s 0118 __invoke_watson 012a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DF 00 00 00 3B C7 74 DC 53 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 8B D8 83 FB FF 75 45 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 2A 83 F8 08 74 18 83 F8 12 74 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 95 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB EB E8 ?? ?? ?? ?? 89 30 EB E2 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 89 56 1C 68 04 01 00 00 83 C6 24 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C3 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_480_2_0 {
	meta:
		name = "__wfindnext64i32"
		size = 303
		refs = "000c ___security_cookie 0023 __errno 0035 __invalid_parameter 005b __imp__FindNextFileW@8 0065 __imp__GetLastError@0 00bf ___time64_t_from_ft 0107 _wcscpy_s 0118 __invoke_watson 0129 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 83 F8 FF 75 22 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DD 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D8 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B0 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A3 E8 ?? ?? ?? ?? 89 30 EB 9A 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 CC FD FF FF 89 46 20 8D 85 D8 FD FF FF 50 89 56 1C 68 04 01 00 00 83 C6 24 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "__vsprintf_l"
		size = 126
		refs = "0011 __errno 0021 __invalid_parameter 0057 __output_l 0072 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4E 8B 45 08 3B C3 74 DC 56 FF 75 14 89 45 E8 FF 75 10 89 45 E0 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_482_1_0 {
	meta:
		name = "_vsprintf"
		size = 26
		refs = "0011 __vsprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_782_1_0 {
	meta:
		name = "__vswprintf"
		size = 26
		refs = "0011 __vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_2_0 {
	meta:
		name = "__vscprintf_helper"
		size = 87
		refs = "0011 __errno 0021 __invalid_parameter"
		altNames = "__vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 27 FF 75 14 8D 45 E0 FF 75 10 C7 45 E4 FF FF FF 7F FF 75 0C C7 45 EC 42 00 00 00 50 89 75 E8 89 75 E0 FF 55 08 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_482_3_0 {
	meta:
		name = "__vscprintf"
		size = 28
		refs = "000e __output_l 0013 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_6_0 {
	meta:
		name = "__vprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_5_0 {
	meta:
		name = "__vscprintf_p"
		size = 28
		refs = "000e __output_p_l 0013 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_782_4_0 {
	meta:
		name = "__vscwprintf"
		size = 28
		refs = "000e __woutput_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_782_6_0 {
	meta:
		name = "__vscwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_6_0 {
	meta:
		name = "__vwprintf_p"
		size = 28
		refs = "000e __woutput_p_l 0013 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_4_0 {
	meta:
		name = "_vprintf"
		size = 28
		refs = "000e __output_l 0013 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_5_0 {
	meta:
		name = "_vprintf_s"
		size = 28
		refs = "000e __output_s_l 0013 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_4_0 {
	meta:
		name = "_vwprintf"
		size = 28
		refs = "000e __woutput_l 0013 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_5_0 {
	meta:
		name = "_vwprintf_s"
		size = 28
		refs = "000e __woutput_s_l 0013 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_4_0 {
	meta:
		name = "__vscprintf_l"
		size = 29
		refs = "000f __output_l 0014 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_1_0 {
	meta:
		name = "__vprintf_l"
		size = 29
		refs = "000f __output_l 0014 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_3_0 {
	meta:
		name = "__vprintf_p_l"
		size = 29
		refs = "000f __output_p_l 0014 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_744_2_0 {
	meta:
		name = "__vprintf_s_l"
		size = 29
		refs = "000f __output_s_l 0014 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_482_6_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 29
		refs = "000f __output_p_l 0014 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_782_5_0 {
	meta:
		name = "__vscwprintf_l"
		size = 29
		refs = "000f __woutput_l 0014 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_782_7_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 29
		refs = "000f __woutput_p_l 0014 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_1_0 {
	meta:
		name = "__vwprintf_l"
		size = 29
		refs = "000f __woutput_l 0014 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_3_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 29
		refs = "000f __woutput_p_l 0014 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_741_2_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 29
		refs = "000f __woutput_s_l 0014 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "__wspawnl"
		size = 81
		refs = "0010 __errno 0020 __invalid_parameter 0047 __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 22 66 39 31 74 DE 8B 45 10 3B C6 74 D7 66 39 30 74 D2 56 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "__trandisp1"
		size = 103
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 9B 8A 8D 61 FF FF FF D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_484_1_0 {
	meta:
		name = "__trandisp2"
		size = 355
		refs = "0029 XAMtoTagTab 00d1 One 0145 __indefinite"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 D9 C9 8A 8D 61 FF FF FF D9 E5 9B DD BD 60 FF FF FF D9 C9 8A AD 61 FF FF FF D0 E5 D0 FD D0 C5 8A C5 24 0F D7 8A E0 D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 D0 E4 D0 E4 0A C4 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 E8 C1 00 00 00 D9 C9 DD D8 C3 E8 B7 00 00 00 EB F6 DD D8 DD D8 D9 EE C3 DD D8 DD D8 D9 E8 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 08 C6 85 70 FF FF FF 07 C3 C6 85 70 FF FF FF 01 DC 05 ?? ?? ?? ?? C3 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 20 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DD D8 DD D8 DB 2D ?? ?? ?? ?? 80 BD 70 FF FF FF 00 7F 07 C6 85 70 FF FF FF 01 0A C9 C3 0A C9 74 02 D9 E0 C3 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "_calloc"
		size = 64
		refs = "0016 __calloc_impl 0029 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 56 8D 45 FC 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 18 39 45 FC 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_486_3_0 {
	meta:
		name = "__mbsnicmp_l"
		size = 456
		refs = "001e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 __strnicmp 005e __errno 006e __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 33 DB 39 5D 10 75 07 33 C0 E9 9A 01 00 00 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 8B 45 F0 39 58 08 75 26 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F8 0F 84 6D 01 00 00 8B 4D F4 83 61 70 FD E9 61 01 00 00 57 8B 7D 08 3B FB 74 05 39 5D 0C 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F8 74 07 8B 45 F4 83 60 70 FD B8 FF FF FF 7F E9 25 01 00 00 56 66 0F B6 0F FF 4D 10 0F B7 C9 0F B6 D1 47 F6 44 02 1D 04 89 4D FC 74 43 8A 17 3A D3 75 05 89 5D FC EB 58 C1 E1 08 66 0F B6 D2 66 0B CA 0F B7 C9 66 8B F1 47 89 4D FC 66 3B 70 10 72 0C 66 3B 70 12 77 06 66 03 70 14 EB 36 66 3B 70 16 72 30 66 3B 70 18 77 2A 66 03 70 1A EB 24 0F B7 55 FC 8D 0C 02 F6 41 1D 10 74 0D 66 0F B6 89 1D 01 00 00 0F B7 C9 EB 03 0F B7 CA 89 4D FC 66 8B 75 FC 8B 4D 0C 66 0F B6 09 FF 45 0C 0F B7 C9 0F B6 D1 F6 44 02 1D 04 89 4D FC 74 45 8B 55 0C 8A 12 3A D3 75 05 89 5D FC EB 57 C1 E1 08 66 0F B6 D2 66 0B CA FF 45 0C 0F B7 C9 89 4D FC 66 3B 48 10 72 0C 66 3B 48 12 77 06 66 03 48 14 EB 36 66 3B 48 16 72 30 66 3B 48 18 77 2A 66 03 48 1A EB 24 0F B7 55 FC 8D 0C 02 F6 41 1D 10 74 0D 66 0F B6 89 1D 01 00 00 0F B7 C9 EB 03 0F B7 CA 89 4D FC 66 8B 4D FC 66 3B CE 75 21 66 3B F3 74 09 39 5D 10 0F 85 EB FE FF FF 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 5E 5F 5B C9 C3 1B C0 83 E0 02 48 38 5D F8 74 F0 8B 4D F4 83 61 70 FD EB E7 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "__RTC_Initialize"
		size = 38
		refs = "0004 ___rtc_iaa 0009 ___rtc_izz"
	strings:
		$1 = { 8B FF 56 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 57 8B F8 3B C6 73 0F 8B 07 85 C0 74 02 FF D0 83 C7 04 3B FE 72 F1 5F 5E C3 }
	condition:
		$1
}

rule file_487_1_0 {
	meta:
		name = "__RTC_Terminate"
		size = 38
		refs = "0004 ___rtc_taa 0009 ___rtc_tzz"
	strings:
		$1 = { 8B FF 56 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 57 8B F8 3B C6 73 0F 8B 07 85 C0 74 02 FF D0 83 C7 04 3B FE 72 F1 5F 5E C3 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "__fullpath"
		size = 266
		refs = "0021 __imp__GetFullPathNameA@16 0036 __imp__GetLastError@0 003c __dosmaperr 0056 __errno 006b _calloc 009d __invalid_parameter 00c6 _free 00ff __getcwd"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 53 33 DB 56 57 3B C3 0F 84 E1 00 00 00 38 18 0F 84 D9 00 00 00 8B 35 ?? ?? ?? ?? 39 5D 08 75 5B 53 53 53 50 FF D6 3B C3 75 13 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 E9 BD 00 00 00 8B 7D 10 3B F8 77 02 8B F8 83 FF FF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 9E 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 59 59 89 45 FC 3B C3 75 34 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DB 8B 7D 10 3B FB 77 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB BA 8B 45 08 89 45 FC 8D 45 F8 50 FF 75 FC 57 FF 75 0C FF D6 3B C7 72 1B 39 5D 08 75 09 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 88 3B C3 75 17 39 5D 08 0F 85 4F FF FF FF FF 75 FC E8 ?? ?? ?? ?? 59 E9 41 FF FF FF 8B 45 FC EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "_strcmp"
		size = 136
	strings:
		$1 = { 8B 54 24 04 8B 4C 24 08 F7 C2 03 00 00 00 75 3C 8B 02 3A 01 75 2E 0A C0 74 26 3A 61 01 75 25 0A E4 74 1D C1 E8 10 3A 41 02 75 19 0A C0 74 11 3A 61 03 75 10 83 C1 04 83 C2 04 0A E4 75 D2 8B FF 33 C0 C3 90 1B C0 D1 E0 83 C0 01 C3 F7 C2 01 00 00 00 74 18 8A 02 83 C2 01 3A 01 75 E7 83 C1 01 0A C0 74 DC F7 C2 02 00 00 00 74 A4 66 8B 02 83 C2 02 3A 01 75 CE 0A C0 74 C6 3A 61 01 75 C5 0A E4 74 BD 83 C1 02 EB 88 }
	condition:
		$1
}

rule file_493_3_0 {
	meta:
		name = "__mbsset_l"
		size = 187
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0022 __errno 0032 __invalid_parameter 0056 __strset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 57 FF 75 10 8D 4D F0 8B FE E8 ?? ?? ?? ?? 33 DB 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 6D 8B 45 F4 39 58 08 75 19 FF 75 0C 56 E8 ?? ?? ?? ?? 59 59 38 5D FC 74 55 8B 4D F8 83 61 70 FD EB 4C 8B 4D 0C 8B C1 C1 E8 08 3A C3 74 2E 3A CB 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B0 20 8A C8 EB 10 88 06 46 38 1E 74 05 88 0E 46 EB 04 C6 46 FF 20 38 1E 75 EC EB 07 88 0E 46 38 1E 75 F9 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "__wcsnset"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 33 D2 8B C1 39 55 10 74 18 56 FF 4D 10 66 39 11 74 0E 66 8B 75 0C 66 89 31 41 41 39 55 10 75 EA 5E 5D C3 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__ftelli64_nolock"
		size = 844
		refs = "000b __chkstk 0010 ___security_cookie 0021 __fileno 003e __lseeki64 006f ___pioinfo 014f __imp__ReadFile@20 01d3 __lookuptrailbytes 022a __errno 0346 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC B8 20 10 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 57 56 E8 ?? ?? ?? ?? 8B D8 33 C0 39 46 04 59 89 9D E8 EF FF FF 7D 03 89 46 04 6A 01 50 50 53 E8 ?? ?? ?? ?? 83 C4 10 8B F8 89 BD EC EF FF FF 89 95 F0 EF FF FF 85 D2 7F 10 7C 04 85 FF 73 0A 83 C8 FF 0B D0 E9 D6 02 00 00 8B C3 C1 F8 05 8D 04 85 ?? ?? ?? ?? 83 E3 1F 89 85 E4 EF FF FF 8B 00 C1 E3 06 03 C3 8A 48 24 02 C9 D0 F9 F7 46 0C 08 01 00 00 88 8D FB EF FF FF 75 17 8B 46 04 8B 8D F0 EF FF FF 99 2B F8 1B CA 8B C7 8B D1 E9 8D 02 00 00 8B 0E 8B 56 08 8B F9 2B FA 8B 56 0C 89 BD F4 EF FF FF F6 C2 03 0F 84 5A 01 00 00 80 BD FB EF FF FF 01 0F 85 19 01 00 00 33 D2 39 50 30 0F 84 0E 01 00 00 D1 EF 89 BD E0 EF FF FF 39 56 04 75 11 8B 85 EC EF FF FF 8B 95 F0 EF FF FF E9 3C 02 00 00 52 FF 70 2C FF 70 28 FF B5 E8 EF FF FF E8 ?? ?? ?? ?? 8B F0 8B 85 E4 EF FF FF 8B 00 03 C3 83 C4 10 8B FA 3B 70 28 0F 85 30 FF FF FF 3B 78 2C 0F 85 27 FF FF FF 6A 00 8D 8D F4 EF FF FF 51 68 00 10 00 00 8D 8D FC EF FF FF 51 FF 30 FF 15 ?? ?? ?? ?? 85 C0 0F 84 02 FF FF FF 6A 00 FF B5 F0 EF FF FF FF B5 EC EF FF FF FF B5 E8 EF FF FF E8 ?? ?? ?? ?? 83 C4 10 85 D2 7F 0E 0F 8C DC FE FF FF 85 C0 0F 82 D4 FE FF FF 8B 8D F4 EF FF FF 8B 9D E0 EF FF FF 3B D9 0F 87 C0 FE FF FF 8D 85 FC EF FF FF 85 DB 74 37 8D 94 0D FC EF FF FF 4B 3B C2 73 2B 8A 08 80 F9 0D 75 13 8D 4A FF 3B C1 73 18 8D 48 01 80 39 0A 75 10 8B C1 EB 0C 0F B6 C9 0F BE 89 ?? ?? ?? ?? 03 C1 40 85 DB 75 D0 8D 8D FC EF FF FF 2B C1 33 D2 03 C6 13 D7 E9 4C 01 00 00 F6 40 04 80 74 15 8B 56 08 EB 0C 80 3A 0A 75 06 FF 85 F4 EF FF FF 42 3B D1 72 F0 8B 95 EC EF FF FF 0B 95 F0 EF FF FF 75 1F 8B 85 F4 EF FF FF E9 18 01 00 00 84 D2 78 E3 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 24 FE FF FF F6 46 0C 01 0F 84 D7 00 00 00 8B 56 04 85 D2 75 0B 21 95 F4 EF FF FF E9 C5 00 00 00 2B 4E 08 03 CA F6 40 04 80 8B F9 0F 84 9C 00 00 00 6A 02 6A 00 6A 00 FF B5 E8 EF FF FF E8 ?? ?? ?? ?? 83 C4 10 3B 85 EC EF FF FF 75 24 3B 95 F0 EF FF FF 75 1C 8B 46 08 8D 0C 38 EB 07 80 38 0A 75 01 47 40 3B C1 72 F5 F7 46 0C 00 20 00 00 EB 59 6A 00 FF B5 F0 EF FF FF FF B5 EC EF FF FF FF B5 E8 EF FF FF E8 ?? ?? ?? ?? 83 C4 10 85 D2 7F 0E 0F 8C 91 FD FF FF 85 C0 0F 82 89 FD FF FF B8 00 02 00 00 3B F8 77 12 8B 4E 0C F6 C1 08 74 0A 8B F8 F7 C1 00 04 00 00 74 03 8B 7E 18 8B 85 E4 EF FF FF 8B 00 F6 44 18 04 04 74 01 47 80 BD FB EF FF FF 01 75 02 D1 EF 29 BD EC EF FF FF 83 9D F0 EF FF FF 00 80 BD FB EF FF FF 01 75 06 D1 AD F4 EF FF FF 8B 85 F4 EF FF FF 33 D2 03 85 EC EF FF FF 13 95 F0 EF FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_495_1_0 {
	meta:
		name = "__ftelli64"
		size = 74
		refs = "0003 __sehtable$__ftelli64 0008 __SEH_prolog4 0010 __lock_file 001d __ftelli64_nolock 003b __SEH_epilog4 0044 __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E0 89 55 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 8B 55 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "_wcscat_s"
		size = 125
		refs = "0019 __errno 0028 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 56 57 33 FF 3B D7 74 07 8B 5D 0C 3B DF 77 1E E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5F 5E 5B 5D C3 8B 75 10 3B F7 75 07 33 C0 66 89 02 EB D4 8B CA 66 39 39 74 05 41 41 4B 75 F6 3B DF 74 E9 0F B7 06 66 89 01 41 41 46 46 66 3B C7 74 03 4B 75 EE 33 C0 3B DF 75 C5 66 89 02 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB A5 }
	condition:
		$1
}

rule file_500_3_0 {
	meta:
		name = "__towupper_l"
		size = 181
		refs = "0021 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005a __iswctype_l 0093 ___crtLCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 8B C8 83 EC 14 66 39 4D 08 0F 84 9A 00 00 00 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC 8B 48 14 33 DB 3B CB 75 14 8B 45 08 8D 48 9F 66 83 F9 19 77 03 83 C0 E0 0F B7 C0 EB 61 BA 00 01 00 00 66 39 55 08 73 29 8D 45 EC 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F B7 45 08 74 3D 8B 4D EC 8B 89 D0 00 00 00 66 0F B6 04 01 EB C7 FF 70 04 8D 45 FC 6A 01 50 6A 01 8D 45 08 50 68 00 02 00 00 51 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F B7 45 08 74 04 0F B7 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "__vsnprintf_helper"
		size = 204
		refs = "0011 __errno 0021 __invalid_parameter 00a9 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 99 00 00 00 56 8B 75 0C 57 8B 7D 10 3B FB 74 21 3B F3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6A B8 FF FF FF 7F 89 45 E4 3B F8 77 03 89 7D E4 FF 75 1C 8D 45 E0 FF 75 18 C7 45 EC 42 00 00 00 FF 75 14 89 75 E8 50 89 75 E0 FF 55 08 83 C4 10 89 45 14 3B F3 74 34 3B C3 7C 22 FF 4D E4 78 07 8B 45 E0 88 18 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 05 8B 45 14 EB 0E 33 C0 39 5D E4 88 5C 3E FF 0F 9D C0 48 48 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_501_1_0 {
	meta:
		name = "__vsnprintf_c"
		size = 41
		refs = "0014 __output_l 0019 __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_501_7_0 {
	meta:
		name = "__vsprintf_p"
		size = 41
		refs = "0014 __output_p_l 0019 __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_626_1_0 {
	meta:
		name = "__vswprintf_c"
		size = 41
		refs = "0014 __woutput_l 0019 __vswprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_626_7_0 {
	meta:
		name = "__vswprintf_p"
		size = 41
		refs = "0014 __woutput_p_l 0019 __vswprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_501_2_0 {
	meta:
		name = "__vsnprintf_c_l"
		size = 42
		refs = "0015 __output_l 001a __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_501_8_0 {
	meta:
		name = "__vsprintf_p_l"
		size = 42
		refs = "0015 __output_p_l 001a __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_626_2_0 {
	meta:
		name = "__vswprintf_c_l"
		size = 42
		refs = "0015 __woutput_l 001a __vswprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_626_8_0 {
	meta:
		name = "__vswprintf_p_l"
		size = 42
		refs = "0015 __woutput_p_l 001a __vswprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_501_3_0 {
	meta:
		name = "__vsprintf_s_l"
		size = 136
		refs = "000e __errno 001e __invalid_parameter 0052 __output_s_l 0057 __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 5D 10 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5B 56 8B 75 08 3B F3 74 05 39 5D 0C 77 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 30 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 3B C3 7D 02 88 1E 83 F8 FE 75 1B E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E 5B 5D C3 }
	condition:
		$1
}

rule file_501_5_0 {
	meta:
		name = "__vsnprintf_s_l"
		size = 263
		refs = "000f __errno 001f __invalid_parameter 007f __output_s_l 0084 __vsnprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D6 00 00 00 56 8B 75 08 57 39 5D 10 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 E9 BA 00 00 00 3B F3 74 07 8B 7D 0C 3B FB 77 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 8F 00 00 00 E8 ?? ?? ?? ?? FF 75 1C FF 75 18 FF 75 14 3B 7D 10 76 2D 8B 38 8B 45 10 40 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 75 4C E8 ?? ?? ?? ?? 83 38 22 75 65 E8 ?? ?? ?? ?? 89 38 EB 5C 8B 00 57 56 68 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 83 C4 18 88 5C 3E FF 83 F8 FE 75 1C 83 7D 10 FF 75 1A E8 ?? ?? ?? ?? 83 38 22 75 2F E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 23 3B C3 7D 22 88 1E 83 F8 FE 75 18 E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "__time32"
		size = 78
		refs = "000d __imp__GetSystemTimeAsFileTime@4 002c __aulldiv"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 45 F8 8B 4D FC 6A 00 05 00 80 C1 2A 68 80 96 98 00 81 D1 21 4E 62 FE 51 50 E8 ?? ?? ?? ?? 85 D2 7C 0F 7F 07 3D 7F D2 FF 7F 76 06 83 C8 FF 89 45 FC 8B 4D 08 85 C9 74 02 89 01 C9 C3 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "_wcscmp"
		size = 55
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 8B 75 0C 57 EB 09 66 85 C9 74 11 42 42 46 46 0F B7 0E 0F B7 02 0F B7 F9 2B C7 74 EA 5F 5E 85 C0 7D 05 83 C8 FF 5D C3 7E 03 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_506_5_0 {
	meta:
		name = "?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
		size = 382
		refs = "0009 ___security_cookie 001b __errno 002a __invalid_parameter 003b _strnlen 0089 ___crtLCMapStringA 00de __alloca_probe_16 00f2 _malloc 014b _strcpy_s 0166 __freea 0178 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 56 3B FB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 35 01 00 00 FF 75 08 57 E8 ?? ?? ?? ?? 59 59 3B 45 08 72 04 88 1F EB D0 8B 55 0C 8B 02 8B 48 14 3B CB 75 20 8B CF 38 1F 74 13 8A 01 3C 61 7C 08 3C 7A 7F 04 2C 20 88 01 41 38 19 75 ED 33 C0 E9 F7 00 00 00 6A 01 FF 70 04 BE 00 02 00 00 53 53 6A FF 57 56 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 24 89 4D F4 3B CB 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BD 00 00 00 39 4D 08 73 0E 88 1F E8 ?? ?? ?? ?? 6A 22 E9 5E FF FF FF 3B CB 7E 45 6A E0 33 D2 58 F7 F1 83 F8 01 72 39 8D 41 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F4 89 45 F8 EB 03 89 5D F8 39 5D F8 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 83 8B 55 0C 8B 02 6A 01 FF 70 04 51 FF 75 F8 6A FF 57 56 FF 70 14 52 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 13 FF 75 F8 FF 75 08 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 FF 75 F8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 EC 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_506_6_0 {
	meta:
		name = "__strupr_s_l"
		size = 53
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f ?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 57 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 5F 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_506_9_0 {
	meta:
		name = "__strupr"
		size = 101
		refs = "000a ___locale_changed 0018 __errno 0028 __invalid_parameter 0058 __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 1D ?? ?? ?? ?? 75 41 8B 45 08 3B C3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2F 8B D0 38 18 74 29 8A 0A 80 F9 61 7C 0A 80 F9 7A 7F 05 80 E9 20 88 0A 42 38 1A 75 EA EB 11 53 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5B 5D C3 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "_fgetpos"
		size = 110
		refs = "000e __errno 001e __invalid_parameter 0053 __ftelli64"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 39 7D 08 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 41 56 8B 75 0C 3B F7 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 1B FF 75 08 E8 ?? ?? ?? ?? 59 8B C8 89 06 23 CA 83 C8 FF 89 56 04 3B C8 74 02 33 C0 5E 5F 5D C3 }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "_strtok"
		size = 193
		refs = "0009 ___security_cookie 001f __getptd 00bb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 57 89 45 D4 E8 ?? ?? ?? ?? 6A 08 59 89 45 D8 33 C0 8D 7D DC 6A 07 F3 AB 5F 8A 16 0F B6 CA 8B C1 23 CF B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 46 84 D2 75 E5 8B 55 D4 85 D2 75 0D 8B 45 D8 8B 50 18 EB 05 84 C0 74 1A 42 8A 02 0F B6 F0 33 DB 8B CE 23 CF 43 D3 E3 C1 EE 03 8A 4C 35 DC 84 D9 75 E2 8B DA EB 18 0F B6 32 33 C0 8B CE 23 CF 40 D3 E0 C1 EE 03 8A 4C 35 DC 84 C1 75 08 42 80 3A 00 75 E3 EB 04 C6 02 00 42 8B 45 D8 8B 4D FC 89 50 18 8B C3 2B C2 F7 D8 1B C0 5F 23 C3 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_509_2_0 {
	meta:
		name = "__spawnve"
		size = 545
		refs = "0017 __errno 0027 __invalid_parameter 0050 __mbsrchr 0075 __mbschr 0083 _strlen 0090 __calloc_crt 00a5 ??_C@_02CEGDFPFP@?4?2?$AA@ 00ac _strcpy_s 00bd __invoke_watson 00ca _strcat_s 010b __access_s 0126 _comexecmd 019c _ext_strings 0203 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 57 8B 7D 0C 33 DB 89 7D FC 3B FB 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E7 01 00 00 38 1F 74 DC 8B 45 10 3B C3 74 D5 8B 00 3B C3 74 CF 38 18 74 CB 56 6A 5C 57 E8 ?? ?? ?? ?? 6A 2F 57 8B F0 E8 ?? ?? ?? ?? 83 C4 10 3B C3 0F 85 81 00 00 00 3B F3 0F 85 83 00 00 00 6A 3A 57 E8 ?? ?? ?? ?? 8B F0 59 59 3B F3 75 73 57 E8 ?? ?? ?? ?? 8B F0 83 C6 03 6A 01 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 89 7D FC 3B FB 0F 84 B0 00 00 00 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 77 02 8B 7D 0C EB 0A 3B F3 74 04 3B C6 76 02 8B F0 83 4D F0 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 2F 53 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 F2 00 00 00 FF 75 14 FF 75 10 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 E9 D6 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C6 05 6A 01 56 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C3 75 08 83 C8 FF E9 C0 00 00 00 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC E8 ?? ?? ?? ?? 8B F8 03 7D F8 59 E8 ?? ?? ?? ?? 8B 00 89 45 EC 8B 45 F8 2B F7 03 F0 C7 45 F4 ?? ?? ?? ?? 8B 45 F4 FF 30 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 53 FF 75 F8 E8 ?? ?? ?? ?? 59 59 85 C0 74 0F 83 6D F4 04 81 7D F4 ?? ?? ?? ?? 7D C4 EB 21 E8 ?? ?? ?? ?? FF 75 14 8B 4D EC FF 75 10 89 08 FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 FF 75 F8 E8 ?? ?? ?? ?? 8B 7D 0C 59 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_510_9_0 {
	meta:
		name = "__vcprintf_l"
		size = 2864
		refs = "000c ___security_cookie 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 __errno 0073 __invalid_parameter 00da ___lookuptable 0102 $LN246 0329 __isleadbyte_l 0340 _write_char 0465 ___wnullstring 04cc _wctomb_s 0553 ___nullstring 055f _strlen 05c8 __get_printf_count_output 066f __malloc_crt 06dd __cfltcvt_tab 06e2 __decode_pointer 08a2 __aulldvrm 099f _write_multi_char 09b8 _write_string 0a89 _free 0b0a @__security_check_cookie@4 0b10 $LN226 0b14 $LN130 0b18 $LN129 0b1c $LN121 0b20 $LN117 0b24 $LN116 0b28 $LN112 0b2c $LN96"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 74 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 33 F6 57 8B 7D 10 FF 75 0C 8D 8D A4 FD FF FF 89 BD E0 FD FF FF 89 B5 B8 FD FF FF 89 B5 F0 FD FF FF 89 B5 C8 FD FF FF 89 B5 E8 FD FF FF 89 B5 CC FD FF FF 89 B5 BC FD FF FF 89 B5 C4 FD FF FF E8 ?? ?? ?? ?? 3B DE 75 33 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 BD B0 FD FF FF 00 74 0A 8B 85 AC FD FF FF 83 60 70 FD 83 C8 FF E9 6C 0A 00 00 8A 13 33 C9 89 B5 DC FD FF FF 89 B5 E4 FD FF FF 89 B5 C0 FD FF FF 88 95 EF FD FF FF 84 D2 0F 84 2F 0A 00 00 43 39 B5 DC FD FF FF 89 9D D0 FD FF FF 0F 8C 1C 0A 00 00 8A C2 2C 20 3C 58 77 0F 0F BE C2 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C1 ?? ?? ?? ?? C1 F8 04 89 85 B4 FD FF FF 83 F8 07 0F 87 9C 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D E8 FD FF FF FF 89 85 9C FD FF FF 89 85 BC FD FF FF 89 85 C8 FD FF FF 89 85 CC FD FF FF 89 85 F0 FD FF FF 89 85 C4 FD FF FF E9 63 09 00 00 0F BE C2 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 48 48 74 15 83 E8 03 0F 85 44 09 00 00 83 8D F0 FD FF FF 08 E9 38 09 00 00 83 8D F0 FD FF FF 04 E9 2C 09 00 00 83 8D F0 FD FF FF 01 E9 20 09 00 00 81 8D F0 FD FF FF 80 00 00 00 E9 11 09 00 00 83 8D F0 FD FF FF 02 E9 05 09 00 00 80 FA 2A 75 2B 8B 07 83 C7 04 89 BD E0 FD FF FF 89 85 C8 FD FF FF 85 C0 0F 8D E7 08 00 00 83 8D F0 FD FF FF 04 F7 9D C8 FD FF FF E9 D5 08 00 00 8B 85 C8 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 C8 FD FF FF E9 BA 08 00 00 83 A5 E8 FD FF FF 00 E9 AE 08 00 00 80 FA 2A 75 25 8B 07 83 C7 04 89 BD E0 FD FF FF 89 85 E8 FD FF FF 85 C0 0F 8D 90 08 00 00 83 8D E8 FD FF FF FF E9 84 08 00 00 8B 85 E8 FD FF FF 6B C0 0A 0F BE CA 8D 44 08 D0 89 85 E8 FD FF FF E9 69 08 00 00 80 FA 49 74 5A 80 FA 68 74 49 80 FA 6C 74 18 80 FA 77 0F 85 51 08 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 42 08 00 00 8B 85 D0 FD FF FF 80 38 6C 75 15 FF 85 D0 FD FF FF 81 8D F0 FD FF FF 00 10 00 00 E9 22 08 00 00 83 8D F0 FD FF FF 10 E9 16 08 00 00 83 8D F0 FD FF FF 20 E9 0A 08 00 00 8B 8D D0 FD FF FF 8A 01 3C 36 75 1D 80 79 01 34 75 17 41 41 81 8D F0 FD FF FF 00 80 00 00 89 8D D0 FD FF FF E9 E1 07 00 00 3C 33 75 1D 80 79 01 32 75 17 41 41 81 A5 F0 FD FF FF FF 7F FF FF 89 8D D0 FD FF FF E9 C0 07 00 00 3C 64 0F 84 B8 07 00 00 3C 69 0F 84 B0 07 00 00 3C 6F 0F 84 A8 07 00 00 3C 75 0F 84 A0 07 00 00 3C 78 0F 84 98 07 00 00 3C 58 0F 84 90 07 00 00 33 DB 89 9D B4 FD FF FF EB 02 33 DB 8D 85 A4 FD FF FF 50 0F B6 C2 50 89 9D C4 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 2D 8A 85 EF FD FF FF 8D B5 DC FD FF FF E8 ?? ?? ?? ?? 8B 85 D0 FD FF FF 8A 00 FF 85 D0 FD FF FF 88 85 EF FD FF FF 84 C0 0F 84 62 07 00 00 8A 85 EF FD FF FF 8D B5 DC FD FF FF E8 ?? ?? ?? ?? E9 25 07 00 00 0F BE C2 83 F8 64 0F 8F E7 01 00 00 0F 84 78 02 00 00 83 F8 53 0F 8F EF 00 00 00 0F 84 81 00 00 00 83 E8 41 74 10 48 48 74 59 48 48 74 08 48 48 0F 85 85 05 00 00 80 C2 20 C7 85 9C FD FF FF 01 00 00 00 88 95 EF FD FF FF 83 8D F0 FD FF FF 40 83 BD E8 FD FF FF 00 8D 9D F4 FD FF FF B8 00 02 00 00 89 9D D8 FD FF FF 89 85 98 FD FF FF 0F 8D 46 02 00 00 C7 85 E8 FD FF FF 06 00 00 00 E9 9F 02 00 00 F7 85 F0 FD FF FF 30 08 00 00 0F 85 95 00 00 00 81 8D F0 FD FF FF 00 08 00 00 E9 86 00 00 00 F7 85 F0 FD FF FF 30 08 00 00 75 0A 81 8D F0 FD FF FF 00 08 00 00 8B 8D E8 FD FF FF 83 F9 FF 75 05 B9 FF FF FF 7F 8B 17 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD E0 FD FF FF 89 95 D8 FD FF FF 0F 84 AB 04 00 00 85 D2 75 0C 8B 15 ?? ?? ?? ?? 89 95 D8 FD FF FF C7 85 C4 FD FF FF 01 00 00 00 8B C2 E9 80 04 00 00 83 E8 58 0F 84 DD 02 00 00 48 48 74 7A 83 E8 07 0F 84 29 FF FF FF 48 48 0F 85 93 04 00 00 83 C7 04 F7 85 F0 FD FF FF 10 08 00 00 89 BD E0 FD FF FF 74 30 0F B7 47 FC 50 68 00 02 00 00 8D 85 F4 FD FF FF 50 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 1F C7 85 BC FD FF FF 01 00 00 00 EB 13 8A 47 FC 88 85 F4 FD FF FF C7 85 E4 FD FF FF 01 00 00 00 8D 85 F4 FD FF FF 89 85 D8 FD FF FF E9 2A 04 00 00 8B 07 83 C7 04 89 BD E0 FD FF FF 85 C0 74 3C 8B 48 04 85 C9 74 35 F7 85 F0 FD FF FF 00 08 00 00 0F BF 00 89 8D D8 FD FF FF 74 14 99 2B C2 D1 F8 C7 85 C4 FD FF FF 01 00 00 00 E9 E5 03 00 00 83 A5 C4 FD FF FF 00 E9 D9 03 00 00 A1 ?? ?? ?? ?? 89 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 59 E9 C2 03 00 00 83 F8 70 0F 8F 00 02 00 00 0F 84 E4 01 00 00 83 F8 65 0F 8C B0 03 00 00 83 F8 67 0F 8E 35 FE FF FF 83 F8 69 74 71 83 F8 6E 74 28 83 F8 6F 0F 85 94 03 00 00 F6 85 F0 FD FF FF 80 C7 85 E4 FD FF FF 08 00 00 00 74 61 81 8D F0 FD FF FF 00 02 00 00 EB 55 8B 37 83 C7 04 89 BD E0 FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 FD 04 00 00 F6 85 F0 FD FF FF 20 74 0C 66 8B 85 DC FD FF FF 66 89 06 EB 08 8B 85 DC FD FF FF 89 06 C7 85 BC FD FF FF 01 00 00 00 E9 79 04 00 00 83 8D F0 FD FF FF 40 C7 85 E4 FD FF FF 0A 00 00 00 8B 8D F0 FD FF FF F7 C1 00 80 00 00 0F 84 AE 01 00 00 8B 07 8B 57 04 83 C7 08 E9 DA 01 00 00 75 15 80 BD EF FD FF FF 67 75 5D C7 85 E8 FD FF FF 01 00 00 00 EB 51 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 81 BD E8 FD FF FF A3 00 00 00 7E 37 8B B5 E8 FD FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 59 89 85 C0 FD FF FF 85 C0 74 10 8B D8 89 85 D8 FD FF FF 89 B5 98 FD FF FF EB 0A C7 85 E8 FD FF FF A3 00 00 00 8B 07 83 C7 08 89 85 8C FD FF FF 8B 47 FC 89 85 90 FD FF FF 8D 85 A4 FD FF FF 50 FF B5 9C FD FF FF 0F BE 85 EF FD FF FF FF B5 E8 FD FF FF 89 BD E0 FD FF FF 50 FF B5 98 FD FF FF 8D 85 8C FD FF FF 53 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B B5 F0 FD FF FF 83 C4 1C 81 E6 80 00 00 00 74 21 83 BD E8 FD FF FF 00 75 18 8D 85 A4 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 BD EF FD FF FF 67 75 1C 85 F6 75 18 8D 85 A4 FD FF FF 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3B 2D 75 11 81 8D F0 FD FF FF 00 01 00 00 43 89 9D D8 FD FF FF 53 E9 02 FE FF FF C7 85 E8 FD FF FF 08 00 00 00 C7 85 B8 FD FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 B3 FC FF FF 48 48 0F 84 84 FE FF FF 83 E8 03 0F 85 A5 01 00 00 C7 85 B8 FD FF FF 27 00 00 00 F6 85 F0 FD FF FF 80 C7 85 E4 FD FF FF 10 00 00 00 0F 84 64 FE FF FF 8A 85 B8 FD FF FF 04 51 C6 85 D4 FD FF FF 30 88 85 D5 FD FF FF C7 85 CC FD FF FF 02 00 00 00 E9 40 FE FF FF F7 C1 00 10 00 00 0F 85 46 FE FF FF 83 C7 04 F6 C1 20 74 18 89 BD E0 FD FF FF F6 C1 40 74 06 0F BF 47 FC EB 04 0F B7 47 FC 99 EB 13 8B 47 FC F6 C1 40 74 03 99 EB 02 33 D2 89 BD E0 FD FF FF F6 C1 40 74 1B 85 D2 7F 17 7C 04 85 C0 73 11 F7 D8 83 D2 00 F7 DA 81 8D F0 FD FF FF 00 01 00 00 F7 85 F0 FD FF FF 00 90 00 00 8B DA 8B F0 75 02 33 DB 83 BD E8 FD FF FF 00 7D 0C C7 85 E8 FD FF FF 01 00 00 00 EB 1A 83 A5 F0 FD FF FF F7 B8 00 02 00 00 39 85 E8 FD FF FF 7E 06 89 85 E8 FD FF FF 8B C6 0B C3 75 06 21 85 CC FD FF FF 8D 7D F3 8B 85 E8 FD FF FF FF 8D E8 FD FF FF 85 C0 7F 06 8B C6 0B C3 74 2D 8B 85 E4 FD FF FF 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 98 FD FF FF 8B F0 8B DA 7E 06 03 8D B8 FD FF FF 88 0F 4F EB BD 8D 45 F3 2B C7 47 F7 85 F0 FD FF FF 00 02 00 00 89 85 E4 FD FF FF 89 BD D8 FD FF FF 74 50 85 C0 74 05 80 3F 30 74 47 4F 89 BD D8 FD FF FF C6 07 30 40 EB 34 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B C2 D1 F8 EB 21 85 D2 75 0C 8B 15 ?? ?? ?? ?? 89 95 D8 FD FF FF 8B C2 EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B C2 89 85 E4 FD FF FF 83 BD BC FD FF FF 00 0F 85 3B 01 00 00 8B 85 F0 FD FF FF A8 40 74 32 A9 00 01 00 00 74 09 C6 85 D4 FD FF FF 2D EB 18 A8 01 74 09 C6 85 D4 FD FF FF 2B EB 0B A8 02 74 11 C6 85 D4 FD FF FF 20 C7 85 CC FD FF FF 01 00 00 00 8B 9D C8 FD FF FF 2B 9D E4 FD FF FF 2B 9D CC FD FF FF F6 85 F0 FD FF FF 0C 75 10 53 6A 20 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 FF B5 CC FD FF FF 8D 85 DC FD FF FF 8D 8D D4 FD FF FF E8 ?? ?? ?? ?? F6 85 F0 FD FF FF 08 59 74 19 F6 85 F0 FD FF FF 04 75 10 53 6A 30 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 83 BD C4 FD FF FF 00 8B BD E4 FD FF FF 74 56 85 FF 7E 52 8B B5 D8 FD FF FF 0F B7 06 50 6A 06 8D 45 F4 50 8D 85 A0 FD FF FF 4F 46 50 46 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 23 39 85 A0 FD FF FF 74 1B FF B5 A0 FD FF FF 8D 85 DC FD FF FF 8D 4D F4 E8 ?? ?? ?? ?? 59 85 FF 75 BF EB 1C 83 8D DC FD FF FF FF EB 13 8B 8D D8 FD FF FF 57 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 83 BD DC FD FF FF 00 7C 19 F6 85 F0 FD FF FF 04 74 10 53 6A 20 8D 85 DC FD FF FF E8 ?? ?? ?? ?? 59 59 83 BD C0 FD FF FF 00 74 13 FF B5 C0 FD FF FF E8 ?? ?? ?? ?? 83 A5 C0 FD FF FF 00 59 8B BD E0 FD FF FF 8B 85 D0 FD FF FF 8A 00 88 85 EF FD FF FF 84 C0 74 3B 8B 8D B4 FD FF FF 8B 9D D0 FD FF FF 33 F6 8A D0 E9 F7 F5 FF FF E8 ?? ?? ?? ?? 53 53 53 53 53 E9 9B F5 FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E9 8A F5 FF FF 80 BD B0 FD FF FF 00 74 0A 8B 85 AC FD FF FF 83 60 70 FD 8B 85 DC FD FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_512_3_0 {
	meta:
		name = "__mbbtype_l"
		size = 146
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 0C 8B 4D F4 48 0F B6 45 08 74 47 8A 4C 08 1D F6 C1 04 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 33 C0 40 C9 C3 8B 55 F0 8B 92 C8 00 00 00 56 BE 57 01 00 00 66 85 34 42 5E 75 05 F6 C1 03 74 2A 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 33 C0 C9 C3 F6 44 08 1D 08 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 6A 02 58 C9 C3 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "_vfprintf_helper"
		size = 283
		refs = "0003 __sehtable$_vfprintf_helper 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0050 __lock_file 0060 __fileno 007f ___pioinfo 0086 ___badioinfo 00dc __stbuf 00f5 __ftbuf 010c __SEH_epilog4 0115 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 33 C0 8B 7D 0C 3B FE 0F 95 C0 3B C6 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CC 00 00 00 33 C0 39 75 10 0F 95 C0 3B C6 74 D4 89 7D 0C 57 E8 ?? ?? ?? ?? 59 89 75 FC F6 47 0C 40 75 77 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 75 E4 75 22 57 E8 ?? ?? ?? ?? 8B F0 FF 75 18 FF 75 14 FF 75 10 57 FF 55 08 89 45 E4 57 56 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_515_0_0 {
	meta:
		name = "__strdate_s"
		size = 172
		refs = "0019 __errno 002a __invalid_parameter 004d __imp__GetLocalTime@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 74 05 39 5D 0C 77 1D E8 ?? ?? ?? ?? 6A 16 59 53 53 53 53 53 8B F1 89 08 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 73 83 7D 0C 09 88 1E 73 09 E8 ?? ?? ?? ?? 6A 22 EB D9 57 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F0 99 6A 64 5B F7 FB 0F B7 4D F2 8B C1 6A 0A 59 0F B7 7D F6 6A 0A C6 46 05 2F C6 46 02 2F C6 46 08 00 8B DA 99 F7 F9 B1 30 02 C1 88 06 02 D1 88 56 01 8B C7 99 5F F7 FF 02 C1 88 46 03 02 D1 88 56 04 8B C3 99 F7 FF 5F 02 C1 02 D1 88 46 06 88 56 07 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "__putwch_nolock"
		size = 197
		refs = "0009 ___security_cookie 0017 ?use_w@?1??_putwch_nolock@@9@9 001f __confh 0027 ___initconout 004a __imp__WriteConsoleW@20 005d __imp__GetLastError@0 007d __imp__GetConsoleOutputCP@0 0084 __imp__WideCharToMultiByte@32 00a0 __imp__WriteConsoleA@20 00b3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 F6 39 35 ?? ?? ?? ?? 74 4F 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 07 B8 FF FF 00 00 EB 70 56 8D 4D F0 51 6A 01 8D 4D 08 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 67 83 3D ?? ?? ?? ?? 02 75 DA FF 15 ?? ?? ?? ?? 83 F8 78 75 CF 89 35 ?? ?? ?? ?? 56 56 6A 05 8D 45 F4 50 6A 01 8D 45 08 50 56 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 F9 FF 74 A2 56 8D 55 F0 52 50 8D 45 F4 50 51 FF 15 ?? ?? ?? ?? 85 C0 74 8D 66 8B 45 08 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 C7 05 ?? ?? ?? ?? 01 00 00 00 EB E3 }
	condition:
		$1
}

rule file_516_1_0 {
	meta:
		name = "__cputws"
		size = 159
		refs = "0003 __sehtable$__cputws 0008 __SEH_prolog4 001e ___doserrno 0025 __errno 0035 __invalid_parameter 0045 _wcslen 004f __lock 006e __putwch_nolock 0091 __SEH_epilog4 0099 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E0 33 C0 39 75 08 0F 95 C0 3B C6 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4F FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 6A 03 E8 ?? ?? ?? ?? 59 59 89 75 FC 8B 45 E4 FF 4D E4 85 C0 74 1F 8B 45 08 0F B7 00 83 45 08 02 50 E8 ?? ?? ?? ?? 59 B9 FF FF 00 00 66 3B C1 75 DB 83 4D E0 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_516_2_0 {
	meta:
		name = "__putwch"
		size = 70
		refs = "0003 __sehtable$__putwch 0008 __SEH_prolog4 000f __lock 001c __putwch_nolock 0038 __SEH_epilog4 0040 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_723_5_0 {
	meta:
		name = "__ungetwch"
		size = 70
		refs = "0003 __sehtable$__ungetwch 0008 __SEH_prolog4 000f __lock 001c __ungetwch_nolock 0038 __SEH_epilog4 0040 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_517_6_0 {
	meta:
		name = "?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z"
		size = 470
		refs = "0009 ___security_cookie 0022 __errno 0032 __invalid_parameter 0057 _wcslen 007a __alloca_probe_16 008e _malloc 010a __wcstombs_s_l 0129 __invoke_watson 0147 __Strftime_l 0163 __mbstowcs_s_l 01a7 __freea 01d0 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 33 DB 56 57 89 5D F8 3B C3 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 84 01 00 00 8B 7D 0C 3B FB 74 DA 76 05 33 C9 66 89 08 39 5D 10 74 CE FF 75 10 E8 ?? ?? ?? ?? 8B F0 8D 47 FF BF EF FF FF 7F 46 59 3B C7 77 3A 8B 45 0C 8D 44 00 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F0 EB 03 89 5D F0 39 5D F0 74 8C 8D 46 FF 3B C7 77 37 8D 44 36 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F4 EB 03 89 5D F4 39 5D F4 0F 84 B5 00 00 00 FF 75 18 8D 04 36 8D 48 FF 51 FF 75 10 50 FF 75 F4 53 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 1D 83 F8 16 74 09 83 F8 22 0F 85 80 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 71 FF 75 18 8B 75 0C 53 FF 75 14 8D 04 36 FF 75 F4 50 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 4E FF 75 18 8D 45 F8 6A FF FF 75 F0 56 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 28 6A 22 5F 83 F8 16 74 04 3B C7 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 75 F8 72 07 E8 ?? ?? ?? ?? 89 38 89 5D F8 39 5D F8 76 08 FF 4D F8 EB 03 89 5D F8 FF 75 F4 E8 ?? ?? ?? ?? 59 FF 75 F0 E8 ?? ?? ?? ?? 8B 45 F8 59 3B C3 75 08 8B 55 08 33 C9 66 89 0A 8D 65 E4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_517_7_0 {
	meta:
		name = "__wcsftime_l"
		size = 58
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0024 ?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_519_1_0 {
	meta:
		name = "__ceil_pentium4"
		size = 221
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00bc _NegZero 00c5 _Zero"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 74 4C 3D FF 0B 00 00 7C 7D 66 0F F3 CA 3D 32 0C 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA EC 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 06 3D FF 03 00 00 7C 25 3D 32 04 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 58 C8 66 0F D6 4C 24 04 DD 44 24 04 C3 DD 05 ?? ?? ?? ?? C3 66 0F C2 1D ?? ?? ?? ?? 06 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_520_1_0 {
	meta:
		name = "__strdup"
		size = 85
		refs = "0017 _strlen 0020 _malloc 0032 _strcpy_s 0043 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 5D 08 75 04 33 C0 EB 41 56 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 46 56 E8 ?? ?? ?? ?? 8B F8 59 59 3B FB 74 22 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_521_5_0 {
	meta:
		name = "?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z"
		size = 442
		refs = "0008 ___security_cookie 0012 ?f_use@?1??__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z@4HA 002a ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0031 __imp__GetStringTypeW@16 0043 __imp__GetLastError@0 0087 __imp__MultiByteToWideChar@24 00c8 __alloca_probe_16 00dc _malloc 00fc _memset 0129 __freea 0153 ___ansicp 0174 ___convertcp 0195 __imp__GetStringTypeA@20 01a1 _free 01b4 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 53 56 33 DB 57 8B F9 3B C3 75 3A 8D 45 F8 50 33 F6 46 56 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 35 ?? ?? ?? ?? EB 34 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A 6A 02 58 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 02 0F 84 CF 00 00 00 3B C3 0F 84 C7 00 00 00 83 F8 01 0F 85 E8 00 00 00 89 5D F8 39 5D 18 75 08 8B 07 8B 40 04 89 45 18 8B 35 ?? ?? ?? ?? 33 C0 39 5D 20 53 53 FF 75 10 0F 95 C0 FF 75 0C 8D 04 C5 01 00 00 00 50 FF 75 18 FF D6 8B F8 3B FB 0F 84 AB 00 00 00 7E 3C 81 FF F0 FF FF 7F 77 34 8D 44 3F 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 8B D8 85 DB 74 69 8D 04 3F 50 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 57 53 FF 75 10 FF 75 0C 6A 01 FF 75 18 FF D6 85 C0 74 11 FF 75 14 50 53 FF 75 08 FF 15 ?? ?? ?? ?? 89 45 F8 53 E8 ?? ?? ?? ?? 8B 45 F8 59 EB 75 33 F6 39 5D 1C 75 08 8B 07 8B 40 14 89 45 1C 39 5D 18 75 08 8B 07 8B 40 04 89 45 18 FF 75 1C E8 ?? ?? ?? ?? 59 83 F8 FF 75 04 33 C0 EB 47 3B 45 18 74 1E 53 53 8D 4D 10 51 FF 75 0C 50 FF 75 18 E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B F3 74 DC 89 75 0C FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 75 1C FF 15 ?? ?? ?? ?? 8B F8 3B F3 74 07 56 E8 ?? ?? ?? ?? 59 8B C7 8D 65 EC 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_521_6_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 66
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 4D F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 1C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "__mktemp_s"
		size = 272
		refs = "0018 __errno 0027 __invalid_parameter 003a _strnlen 004f ___threadid 006d __ismbstrail 00c5 __access_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 8B 7D 08 33 DB 3B FB 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 D6 00 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 8B F0 59 59 89 75 08 3B 75 0C 72 04 88 1F EB C9 E8 ?? ?? ?? ?? 89 45 FC 8B 45 08 03 F7 83 F8 06 72 EA 39 45 0C 76 E5 89 5D 08 EB 2D 56 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 25 80 3E 58 75 CE 83 7D 08 05 73 1A 8B 45 FC 6A 0A 33 D2 59 F7 F1 FF 45 08 80 C2 30 88 16 89 45 FC 4E 3B F7 73 CE 80 3E 58 75 A9 83 7D 08 05 72 A3 C6 06 61 C7 45 08 62 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 FC E8 ?? ?? ?? ?? 53 57 89 18 E8 ?? ?? ?? ?? 59 59 85 C0 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 10 83 7D 08 7B 74 18 8A 45 08 FF 45 08 88 06 EB D2 E8 ?? ?? ?? ?? 8B 4D FC 89 08 33 C0 EB 14 88 1F E8 ?? ?? ?? ?? C7 00 11 00 00 00 E8 ?? ?? ?? ?? 8B 00 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_523_1_0 {
	meta:
		name = "__mktemp"
		size = 73
		refs = "0011 __errno 0021 __invalid_parameter 002e _strlen 0036 __mktemp_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 33 F6 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 19 57 E8 ?? ?? ?? ?? 40 50 57 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_648_1_0 {
	meta:
		name = "__wmktemp"
		size = 73
		refs = "0011 __errno 0021 __invalid_parameter 002e _wcslen 0036 __wmktemp_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 33 F6 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 19 57 E8 ?? ?? ?? ?? 40 50 57 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_524_3_0 {
	meta:
		name = "__mbsnicoll_l"
		size = 283
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0037 __errno 0047 __invalid_parameter 009f __strnicoll_l 00b1 __mbsnbcnt_l 00de ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 10 33 DB 3B F3 75 13 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 E6 00 00 00 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 B3 00 00 00 57 8B 7D 0C 3B FB 74 08 81 FE FF FF FF 7F 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 66 8B 45 F4 39 58 08 75 12 FF 75 14 56 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 62 8D 45 F0 50 56 FF 75 08 E8 ?? ?? ?? ?? 89 45 10 8D 45 F0 50 56 57 E8 ?? ?? ?? ?? 8B 4D F4 FF 71 04 50 57 FF 75 10 8D 45 F0 FF 75 08 68 01 10 00 00 FF 71 0C 50 E8 ?? ?? ?? ?? 83 C4 38 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "__fltin2"
		size = 167
		refs = "0009 ___security_cookie 0034 ___strgtold12_l 0058 __ld12tod 00a1 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8B 4D 0C 53 56 8B 75 08 57 50 33 FF 57 57 57 57 51 8D 45 DC 50 8D 45 F0 50 89 4D E0 33 DB E8 ?? ?? ?? ?? 83 C4 20 89 45 EC A8 04 74 0D BB 00 02 00 00 89 7D E4 89 7D E8 EB 30 8D 45 E4 50 8D 45 F0 50 E8 ?? ?? ?? ?? F6 45 EC 02 59 59 75 05 83 F8 01 75 05 BB 80 00 00 00 F6 45 EC 01 75 05 83 F8 02 75 06 81 CB 00 01 00 00 8B 45 DC 2B 45 E0 8B 4D FC 89 46 04 8B 45 E4 89 46 10 8B 45 E8 89 46 14 5F 89 1E 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "___wtomb_environ"
		size = 151
		refs = "000e __wenviron 001d __imp__WideCharToMultiByte@32 0037 __calloc_crt 005c ___crtsetenv 006f _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 33 F6 57 8B 3D ?? ?? ?? ?? 89 75 FC 8B 07 3B C6 74 65 8B 1D ?? ?? ?? ?? 56 56 56 56 6A FF 50 56 56 FF D3 89 45 F8 3B C6 74 54 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 FC 3B C6 74 43 56 56 FF 75 F8 50 6A FF FF 37 56 56 FF D3 85 C0 74 36 8D 45 FC 56 50 E8 ?? ?? ?? ?? 59 59 85 C0 7D 11 39 75 FC 74 0C FF 75 FC E8 ?? ?? ?? ?? 59 89 75 FC 83 C7 04 8B 07 3B C6 75 A1 33 C0 5F 5E 5B C9 C3 83 C8 FF EB F6 FF 75 FC E8 ?? ?? ?? ?? 59 EB F0 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "__getdiskfree"
		size = 182
		refs = "0011 __errno 0021 __invalid_parameter 005b _memset 008b __imp__GetDiskFreeSpaceA@20 0095 __imp__GetLastError@0 00a4 __get_errno_from_oserr"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 0C 33 F6 3B FE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 57 58 E9 82 00 00 00 53 8B 5D 08 83 FB 1A 76 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 57 58 EB 5B 6A 10 56 57 E8 ?? ?? ?? ?? 83 C4 0C 3B DE 74 15 80 C3 40 8D 75 0C 88 5D 0C C6 45 0D 3A C6 45 0E 5C C6 45 0F 00 57 8D 47 04 50 8D 47 0C 50 83 C7 08 57 56 FF 15 ?? ?? ?? ?? 85 C0 75 1C FF 15 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 89 06 59 8B C7 EB 02 33 C0 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_532_3_0 {
	meta:
		name = "__mbscoll_l"
		size = 170
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 005d __strcoll_l 0080 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 61 39 5D 0C 74 D0 8B 45 F4 39 58 08 75 13 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 35 FF 70 04 6A FF FF 75 0C 6A FF FF 75 08 68 00 10 00 00 FF 70 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9B 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_535_3_0 {
	meta:
		name = "?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 663
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 __errno 0038 __invalid_parameter 008a __isctype_l 0125 __aulldvrm 01d4 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 53 57 FF 75 08 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 10 8B 7D 0C 33 DB 3B C3 74 02 89 38 3B FB 75 2D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D D4 74 07 8B 45 D0 83 60 70 FD 33 C0 33 D2 E9 3F 02 00 00 39 5D 14 74 0C 83 7D 14 02 7C C8 83 7D 14 24 7F C2 56 8B 75 C8 89 5D F0 89 5D F4 8A 07 47 83 BE AC 00 00 00 01 88 45 FF 7E 18 8D 45 C8 50 0F B6 45 FF 6A 08 50 E8 ?? ?? ?? ?? 8B 75 C8 83 C4 0C EB 11 0F B6 45 FF 8B 8E C8 00 00 00 0F B7 04 41 83 E0 08 3B C3 75 C4 80 7D FF 2D 89 7D F8 75 06 83 4D 18 02 EB 06 80 7D FF 2B 75 09 8A 07 47 89 7D F8 88 45 FF 6A 10 59 39 5D 14 75 25 80 7D FF 30 74 09 C7 45 14 0A 00 00 00 EB 35 8A 07 3C 78 74 0D 3C 58 74 09 C7 45 14 08 00 00 00 EB 22 89 4D 14 39 4D 14 75 1A 80 7D FF 30 75 14 8A 07 3C 78 74 04 3C 58 75 0A 47 8A 07 47 88 45 FF 89 7D F8 8B 45 14 99 52 8B F8 57 6A FF 6A FF 89 55 DC E8 ?? ?? ?? ?? 89 5D E4 8B 9E C8 00 00 00 89 4D E0 89 45 E8 89 55 EC 8A 4D FF 0F B6 C1 0F B7 04 43 A8 04 74 08 0F BE F1 83 EE 30 EB 18 A9 03 01 00 00 74 51 8A C1 2C 61 3C 19 0F BE C1 77 03 83 E8 20 8D 70 C9 3B 75 14 73 3B 8B 4D F4 83 4D 18 08 3B 4D EC 72 51 77 08 8B 45 F0 3B 45 E8 72 47 8B 45 E8 39 45 F0 75 13 3B 4D EC 75 0E 33 C0 3B 45 E4 72 33 77 05 3B 75 E0 76 2C 83 4D 18 04 83 7D 10 00 75 3B 8B 45 18 FF 4D F8 A8 08 75 41 33 C0 39 45 10 74 06 8B 4D 0C 89 4D F8 89 45 F0 89 45 F4 E9 8F 00 00 00 51 FF 75 F0 FF 75 DC 57 E8 ?? ?? ?? ?? 33 C9 03 C6 13 D1 89 45 F0 89 55 F4 8B 45 F8 8A 00 FF 45 F8 88 45 FF E9 47 FF FF FF BE FF FF FF 7F BB 00 00 00 80 A8 04 75 27 A8 01 75 54 83 E0 02 74 0D 39 5D F4 77 19 72 06 83 7D F0 00 77 11 85 C0 75 3E 39 75 F4 72 39 77 06 83 7D F0 FF 76 31 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 0A 83 4D F0 FF 83 4D F4 FF EB 16 F6 45 18 02 74 09 83 65 F0 00 89 5D F4 EB 07 83 4D F0 FF 89 75 F4 8B 45 10 5E 85 C0 74 05 8B 4D F8 89 08 F6 45 18 02 74 13 8B 45 F0 8B 4D F4 F7 D8 83 D1 00 F7 D9 89 45 F0 89 4D F4 80 7D D4 00 74 07 8B 45 D0 83 60 70 FD 8B 45 F0 8B 55 F4 5F 5B C9 C3 }
	condition:
		$1
}

rule file_536_0_0 {
	meta:
		name = "??__C@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 105
		refs = "0003 __sehtable$??__C@YGXPAX0IHP6EX00@ZP6EX0@Z@Z 0008 __SEH_prolog4 004a __SEH_epilog4 0064 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 8B 45 E4 3B 45 14 7D 17 FF 75 0C 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C FF 45 E4 EB E1 C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 18 00 83 7D E0 00 75 11 FF 75 1C FF 75 E4 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_537_3_0 {
	meta:
		name = "__mbsstr_l"
		size = 321
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strstr 0048 __errno 0058 __invalid_parameter 00bf _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 33 DB 39 58 08 75 22 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 38 5D F4 0F 84 FA 00 00 00 8B 4D F0 83 61 70 FD E9 EE 00 00 00 8B 45 0C 3B C3 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 E9 BC 00 00 00 38 18 75 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B 45 08 E9 A4 00 00 00 56 8B 75 08 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 73 57 50 8B FE E8 ?? ?? ?? ?? 89 75 F8 29 45 F8 56 E8 ?? ?? ?? ?? 03 45 F8 59 59 38 1E 74 46 2B 75 0C 3B F8 77 3F 8A 17 8B 4D 0C 88 55 FF 3A D3 74 11 8A 11 3A D3 74 40 38 14 0E 75 06 41 38 1C 0E 75 EF 38 19 74 31 0F B6 4D FF 8B 55 EC 8A 4C 11 1D 80 E1 04 47 46 84 C9 74 06 38 1F 74 06 47 46 38 1F 75 BD 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C7 EB EB }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "__wfsopen"
		size = 198
		refs = "0003 __sehtable$__wfsopen 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0056 __getstream 0088 ___security_cookie 008d __local_unwind4 009d __wopenfile 00b7 __SEH_epilog4 00c0 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E4 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 7B 33 C0 8B 7D 0C 3B FE 0F 95 C0 3B C6 74 D6 33 C0 66 39 37 0F 95 C0 3B C6 74 CA E8 ?? ?? ?? ?? 89 45 08 3B C6 75 0D E8 ?? ?? ?? ?? C7 00 18 00 00 00 EB C9 89 75 FC 66 39 33 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB A1 50 FF 75 10 57 53 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_539_1_0 {
	meta:
		name = "__wfopen"
		size = 23
		refs = "000e __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_937_1_0 {
	meta:
		name = "_fopen"
		size = 23
		refs = "000e __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_539_2_0 {
	meta:
		name = "__wfopen_s"
		size = 83
		refs = "0011 __errno 0020 __invalid_parameter 0037 __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 33 F6 3B FE 75 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 07 3B C6 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_937_2_0 {
	meta:
		name = "_fopen_s"
		size = 83
		refs = "0011 __errno 0020 __invalid_parameter 0037 __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 33 F6 3B FE 75 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 24 68 80 00 00 00 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 07 3B C6 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "__controlfp_s"
		size = 108
		refs = "0028 __control87 0031 __errno 0040 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 8B 4D 0C 25 FF FF F7 FF 23 C8 56 F7 C1 E0 FC F0 FC 74 31 57 8B 7D 08 33 F6 3B FE 74 0B 56 56 E8 ?? ?? ?? ?? 59 59 89 07 E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 5F EB 1D 8B 75 08 50 FF 75 0C 85 F6 74 09 E8 ?? ?? ?? ?? 89 06 EB 05 E8 ?? ?? ?? ?? 59 59 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_542_4_0 {
	meta:
		name = "__tolower_l"
		size = 277
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0035 __isctype_l 0096 __isleadbyte_l 00b3 __errno 00e3 ___crtLCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 BE 00 01 00 00 3B DE 73 54 8B 4D E8 83 B9 AC 00 00 00 01 7E 14 8D 45 E8 50 6A 01 53 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 0C EB 0D 8B 81 C8 00 00 00 0F B7 04 58 83 E0 01 85 C0 74 0F 8B 81 CC 00 00 00 0F B6 04 18 E9 A3 00 00 00 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C3 E9 9C 00 00 00 8B 45 E8 83 B8 AC 00 00 00 01 7E 31 89 5D 08 C1 7D 08 08 8D 45 E8 50 8B 45 08 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 12 8A 45 08 6A 02 88 45 FC 88 5D FD C6 45 FE 00 59 EB 15 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 33 C9 88 5D FC C6 45 FD 00 41 8B 45 E8 6A 01 FF 70 04 8D 55 F8 6A 03 52 51 8D 4D FC 51 56 FF 70 14 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 6F FF FF FF 83 F8 01 0F B6 45 F8 74 09 0F B6 4D F9 C1 E0 08 0B C1 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_542_5_0 {
	meta:
		name = "_tolower"
		size = 44
		refs = "0007 ___locale_changed 0024 __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 10 8B 45 08 8D 48 BF 83 F9 19 77 11 83 C0 20 5D C3 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_543_1_0 {
	meta:
		name = "___loctotime64_t"
		size = 619
		refs = "006e __days 0145 __allmul 01a3 ___tzset 01ac __get_daylight 01bd __invoke_watson 01c9 __get_dstbias 01e6 __get_timezone 023f __isindst 0257 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 53 56 8B 75 08 33 C0 81 C6 94 F8 FF FF 83 FE 46 57 89 45 F8 89 45 F4 89 45 FC 0F 8C 2E 02 00 00 81 FE 4C 04 00 00 0F 8F 22 02 00 00 8B 5D 0C 8D 43 FF 83 F8 0B 0F 87 13 02 00 00 83 7D 14 17 0F 87 09 02 00 00 83 7D 18 3B 0F 87 FF 01 00 00 83 7D 1C 3B 0F 87 F5 01 00 00 83 7D 10 01 0F 8C EB 01 00 00 8D 04 9D ?? ?? ?? ?? 8B 48 FC 8B 00 2B C1 3B 45 10 BF 90 01 00 00 7D 45 8B C6 25 03 00 00 80 79 05 48 83 C8 FC 40 75 0C 8B C6 6A 64 99 5B F7 FB 85 D2 75 13 8D 86 6C 07 00 00 99 8B DF F7 FB 85 D2 0F 85 A4 01 00 00 8B 5D 0C 83 FB 02 0F 85 98 01 00 00 83 7D 10 1D 0F 8F 8E 01 00 00 8B 45 10 03 C8 8B C6 25 03 00 00 80 89 4D 08 79 05 48 83 C8 FC 40 75 0C 8B C6 6A 64 99 59 F7 F9 85 D2 75 0F 8D 86 6C 07 00 00 99 8B CF F7 F9 85 D2 75 08 83 FB 02 7E 03 FF 45 08 8D 86 2B 01 00 00 99 F7 FF 8D 4E FF 6A 64 5B 6A 00 68 6D 01 00 00 8B F8 8B C1 99 F7 FB 2B F8 8B C1 99 83 E2 03 03 C2 C1 F8 02 8D 44 07 EF 99 8B D8 8B C2 89 45 F0 8B C6 99 83 E8 46 83 DA 00 52 50 E8 ?? ?? ?? ?? 03 D8 8B 45 F0 13 C2 89 45 F0 8B 45 08 99 03 D8 8B 45 F0 13 C2 33 FF 57 6A 18 50 53 E8 ?? ?? ?? ?? 8B C8 8B 45 14 8B DA 99 57 03 C8 6A 3C 13 DA 53 51 E8 ?? ?? ?? ?? 8B C8 8B 45 18 8B DA 99 57 03 C8 6A 3C 13 DA 53 51 E8 ?? ?? ?? ?? 8B F8 8B 45 1C 8B DA 99 03 F8 13 DA E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8D 45 F4 50 E8 ?? ?? ?? ?? 59 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8D 45 FC 50 E8 ?? ?? ?? ?? 59 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 99 03 F8 8B 45 08 89 45 E8 8B 45 0C 13 DA 48 83 7D 20 01 89 45 DC 8B 45 14 89 45 D4 8B 45 18 89 45 D0 8B 45 1C 89 75 E0 89 45 CC 74 1A 83 7D 20 FF 75 1C 83 7D F8 00 74 16 8D 45 CC 50 E8 ?? ?? ?? ?? 59 85 C0 74 08 8B 45 F4 99 03 F8 13 DA 8B C7 8B D3 EB 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 0B D0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "__CItan_pentium4"
		size = 608
		refs = "003d PI32INV 004d SHIFTER 0059 P_1 0065 QQ_2 0073 P_2 0092 P_3 00ad ONE 00b6 Ctable 00be MASK_35 0223 TWO_POW_M55 022b TWO_POW_55 024e __tan_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 D7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 12 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 66 0F 12 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 66 0F 12 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 66 0F 12 3D ?? ?? ?? ?? F2 0F 59 E6 66 0F 12 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 83 EC 10 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 7F 3F 83 EC 10 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 13 5C 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 8B FF 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_545_3_0 {
	meta:
		name = "__get_tzname"
		size = 164
		refs = "0030 __errno 003f __invalid_parameter 006d __tzname 0074 _strlen 0098 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 53 33 DB 56 3B C3 74 3A 39 5D 10 76 3A 3B C3 74 02 88 18 57 8B 7D 08 3B FB 74 0C 8B 45 14 3B C3 74 40 83 F8 01 74 3B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 55 39 5D 10 74 C6 E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 36 8D 34 85 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 40 59 89 07 39 5D 0C 75 04 33 C0 EB 1A 3B 45 10 76 05 6A 22 58 EB 10 FF 36 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_547_3_0 {
	meta:
		name = "__ismbslead_l"
		size = 170
		refs = "0014 __errno 0024 __invalid_parameter 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 44 57 8B 7D 0C 3B FB 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 1F FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 39 59 08 75 2F 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 8A 06 3A C3 74 E7 0F B6 C0 F6 44 08 1D 04 74 0B 8B C6 46 3B C7 74 0B 38 1E 74 D2 46 3B F7 76 E0 EB CB 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB C8 }
	condition:
		$1
}

rule file_550_1_0 {
	meta:
		name = "__RTC_GetErrDesc"
		size = 26
		refs = "0010 __RTC_errlist"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 04 77 09 8B 04 85 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_550_2_0 {
	meta:
		name = "__RTC_SetErrorType"
		size = 34
		refs = "0013 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 04 77 10 8B 55 0C 8D 0C 85 ?? ?? ?? ?? 8B 01 89 11 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_550_3_0 {
	meta:
		name = "__RTC_SetErrorFunc"
		size = 28
		refs = "0009 __RTC_ErrorReportFunc 000f __RTC_ErrorReportFuncW"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_550_4_0 {
	meta:
		name = "__RTC_SetErrorFuncW"
		size = 28
		refs = "0009 __RTC_ErrorReportFuncW 000f __RTC_ErrorReportFunc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_553_3_0 {
	meta:
		name = "__strnicoll_l"
		size = 250
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0036 __errno 0046 __invalid_parameter 00a2 __strnicmp_l 00c1 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 10 33 DB 3B D3 75 13 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 C7 00 00 00 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 94 00 00 00 39 5D 0C 74 CD 56 BE FF FF FF 7F 3B D6 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 4B 8B 45 F0 8B 48 10 3B CB 75 15 8D 45 F0 50 52 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 3F FF 70 08 8D 45 F0 52 FF 75 0C 52 FF 75 08 68 01 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_553_4_0 {
	meta:
		name = "__strnicoll"
		size = 41
		refs = "0007 ___locale_changed 0010 __strnicmp 0020 __strnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_554_3_0 {
	meta:
		name = "__iswctype_l"
		size = 138
		refs = "002a __pwctype 0045 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 ___crtGetStringTypeW"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 83 EC 14 66 39 45 08 75 06 83 65 FC 00 EB 65 B8 00 01 00 00 66 39 45 08 73 1A 0F B7 45 08 8B 0D ?? ?? ?? ?? 66 8B 04 41 66 23 45 0C 0F B7 C0 89 45 FC EB 40 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC FF 70 14 FF 70 04 8D 45 FC 50 6A 01 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 03 21 45 FC 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 0F B7 45 FC 0F B7 4D 0C 23 C1 C9 C3 }
	condition:
		$1
}

rule file_554_4_0 {
	meta:
		name = "_iswctype"
		size = 118
		refs = "0026 __pwctype 0038 ___locale_changed 0041 ___initiallocinfo 0058 ___initiallocalestructinfo 005d ___crtGetStringTypeW 006d __iswctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 B8 FF FF 00 00 66 39 45 08 75 04 33 C0 C9 C3 B8 00 01 00 00 66 39 45 08 73 16 0F B7 45 08 8B 0D ?? ?? ?? ?? 0F B7 04 41 0F B7 4D 0C 23 C1 C9 C3 83 3D ?? ?? ?? ?? 00 75 25 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 01 8D 45 08 50 6A 01 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_555_1_0 {
	meta:
		name = "__ftime32_s"
		size = 346
		refs = "000c ___security_cookie 0027 __errno 0036 __invalid_parameter 0045 ___tzset 0051 __get_timezone 0060 __invoke_watson 0081 __imp__GetSystemTimeAsFileTime@4 009a __aulldiv 00a6 _elapsed_minutes_cache 00b5 __imp__GetTimeZoneInformation@4 00d2 _dstflag_cache 0125 __aullrem 0154 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 33 FF 89 BD 4C FF FF FF 3B F7 75 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 08 01 00 00 E8 ?? ?? ?? ?? 8D 85 4C FF FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 4C FF FF FF 53 6A 3C 99 59 F7 F9 66 89 46 06 8D 85 44 FF FF FF 50 FF 15 ?? ?? ?? ?? 8B 9D 44 FF FF FF 57 8B BD 48 FF FF FF 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 89 85 40 FF FF FF 3B 05 ?? ?? ?? ?? 74 57 8D 85 50 FF FF FF 50 FF 15 ?? ?? ?? ?? 83 F8 FF 74 27 83 F8 02 75 19 66 83 7D EA 00 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 83 25 ?? ?? ?? ?? 00 EB 07 83 0D ?? ?? ?? ?? FF 8B 85 40 FF FF FF 8B BD 48 FF FF FF 8B 9D 44 FF FF FF A3 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 46 08 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 66 89 46 04 E8 ?? ?? ?? ?? 89 06 33 C0 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "__sse2_mathfcns_init"
		size = 20
		refs = "0002 ___use_sse2_mathfcns 0008 __get_sse2_info"
	strings:
		$1 = { 83 25 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_556_1_0 {
	meta:
		name = "__set_SSE2_enable"
		size = 25
		refs = "000e ___sse2_available 0013 ___use_sse2_mathfcns"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 1B C0 23 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "___initconin"
		size = 31
		refs = "000f ??_C@_06GDENEHCP@CONIN$?$AA@ 0015 __imp__CreateFileA@28 001a __coninpfh"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 C0 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_557_1_0 {
	meta:
		name = "___initconout"
		size = 31
		refs = "000f ??_C@_07GPDNMNG@CONOUT$?$AA@ 0015 __imp__CreateFileA@28 001a __confh"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 40 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_557_2_0 {
	meta:
		name = "___termcon"
		size = 45
		refs = "0001 __confh 0008 __imp__CloseHandle@4 001a __coninpfh"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? 83 F8 FF 74 08 83 F8 FE 74 03 50 FF D6 A1 ?? ?? ?? ?? 83 F8 FF 74 08 83 F8 FE 74 03 50 FF D6 5E C3 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "__wsplitpath_s"
		size = 544
		refs = "0085 _wcsncpy_s 01d0 __errno 01df __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 08 53 56 57 33 FF 89 7D FC 3B CF 0F 84 82 00 00 00 8B 55 0C 3B D7 75 07 39 7D 10 75 76 EB 05 39 7D 10 74 6F 39 7D 14 75 07 39 7D 18 75 65 EB 05 39 7D 18 74 5E 39 7D 1C 75 07 39 7D 20 75 54 EB 05 39 7D 20 74 4D 39 7D 24 75 43 39 7D 28 75 43 33 C0 40 8B F1 66 39 3E 74 07 48 46 46 3B C7 77 F4 66 83 3E 3A 75 38 3B D7 74 19 83 7D 10 03 0F 82 0D 01 00 00 6A 02 51 FF 75 10 52 E8 ?? ?? ?? ?? 83 C4 10 83 C6 02 89 75 08 8B CE EB 1A 39 7D 28 75 BD C7 45 FC 01 00 00 00 E9 E0 00 00 00 3B D7 74 05 33 C0 66 89 02 0F B7 01 33 DB 8B F1 66 85 C0 74 56 0F B7 C0 66 83 F8 2F 74 10 66 83 F8 5C 74 0A 66 83 F8 2E 75 07 8B DE EB 03 8D 7E 02 46 46 0F B7 06 66 85 C0 75 DD 85 FF 74 2C 83 7D 14 00 74 1F 8B C7 2B C1 D1 F8 39 45 18 0F 86 8A 00 00 00 50 51 FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 83 C4 10 89 7D 08 8B CF EB 0C 8B 45 14 85 C0 74 05 33 D2 66 89 10 85 DB 74 50 3B D9 72 4C 83 7D 1C 00 74 1E 8B C3 2B C1 D1 F8 39 45 20 76 4E 50 51 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 8B 4D 08 83 C4 10 83 7D 24 00 0F 84 C5 00 00 00 2B F3 D1 FE 39 75 28 76 28 56 53 FF 75 28 FF 75 24 E8 ?? ?? ?? ?? 83 C4 10 E9 A7 00 00 00 83 7D 1C 00 0F 84 91 00 00 00 2B F1 D1 FE 39 75 20 77 78 33 FF 8B 55 0C 3B D7 74 0A 39 7D 10 76 05 33 C0 66 89 02 8B 45 14 3B C7 74 0A 39 7D 18 76 05 33 D2 66 89 10 8B 45 1C 3B C7 74 0A 39 7D 20 76 05 33 D2 66 89 10 8B 45 24 3B C7 74 0A 39 7D 28 76 05 33 D2 66 89 10 3B CF 75 1B E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 31 E8 ?? ?? ?? ?? 39 7D FC 75 E0 6A 22 59 89 08 8B C1 EB 1E 56 51 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 05 33 C9 66 89 08 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__twoToTOS"
		size = 21
	strings:
		$1 = { D9 C0 D9 FC DC E1 D9 C9 D9 E0 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule file_559_1_0 {
	meta:
		name = "__load_CW"
		size = 23
	strings:
		$1 = { 8B 54 24 04 81 E2 00 03 00 00 83 CA 7F 66 89 54 24 06 D9 6C 24 06 C3 }
	condition:
		$1
}

rule file_559_2_0 {
	meta:
		name = "__convertTOStoQNaN"
		size = 25
		refs = "000f One"
	strings:
		$1 = { A9 00 00 08 00 74 06 B8 07 00 00 00 C3 DC 05 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_559_3_0 {
	meta:
		name = "__fload_withFB"
		size = 67
	strings:
		$1 = { 8B 42 04 25 00 00 F0 7F 3D 00 00 F0 7F 74 03 DD 02 C3 8B 42 04 83 EC 0A 0D 00 00 FF 7F 89 44 24 06 8B 42 04 8B 0A 0F A4 C8 0B C1 E1 0B 89 44 24 04 89 0C 24 DB 2C 24 83 C4 0A A9 00 00 00 00 8B 42 04 C3 }
	condition:
		$1
}

rule file_559_4_0 {
	meta:
		name = "__checkTOS_withFB"
		size = 22
	strings:
		$1 = { 8B 44 24 08 25 00 00 F0 7F 3D 00 00 F0 7F 74 01 C3 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_559_6_0 {
	meta:
		name = "__math_exit"
		size = 42
		refs = "001f __startOneArgErrorHandling"
	strings:
		$1 = { 66 8B 04 24 66 3D 7F 02 74 1E 66 83 E0 20 74 15 9B DF E0 66 83 E0 20 74 0C B8 08 00 00 00 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 }
	condition:
		$1
}

rule file_559_7_0 {
	meta:
		name = "__check_overflow_exit"
		size = 20
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F EB 14 }
	condition:
		$1
}

rule file_559_8_0 {
	meta:
		name = "__check_range_exit"
		size = 163
		refs = "003f __startOneArgErrorHandling 0046 __startTwoArgErrorHandling 0053 IeeeAdjU 0063 DblMin 0074 _zero 007c IeeeAdjO 008c DblMax 009d _infinity"
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F 74 3D 3D 00 00 F0 7F 74 5F 66 8B 04 24 66 3D 7F 02 74 2A 66 83 E0 20 75 21 9B DF E0 66 83 E0 20 74 18 B8 08 00 00 00 83 FA 1D 74 07 E8 ?? ?? ?? ?? 5A C3 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 04 00 00 00 73 C7 DC 0D ?? ?? ?? ?? EB BF DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 03 00 00 00 76 9E DC 0D ?? ?? ?? ?? EB 96 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "__wexeclpe"
		size = 91
		refs = "0010 __errno 0020 __invalid_parameter 0051 __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2C 66 39 31 74 DE 8B 45 0C 3B C6 74 D7 66 39 30 74 D2 8D 45 0C 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_562_3_0 {
	meta:
		name = "__wcsncoll_l"
		size = 236
		refs = "0021 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002b __errno 003b __invalid_parameter 0093 _wcsncmp 00b2 ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 10 33 DB 3B F3 75 07 33 C0 E9 CE 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 90 00 00 00 39 5D 0C 74 CD 57 BF FF FF FF 7F 3B F7 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 47 8B 45 F0 8B 48 10 3B CB 75 11 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 3F FF 70 08 8D 45 F0 56 FF 75 0C 56 FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "__SEH_prolog"
		size = 59
		refs = "0001 __except_handler3"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_563_1_0 {
	meta:
		name = "__SEH_epilog"
		size = 17
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 C3 }
	condition:
		$1
}

rule file_564_3_0 {
	meta:
		name = "__validate_param_reuseW"
		size = 342
	strings:
		$1 = { 8B FF 55 8B EC 56 66 8B 75 10 57 8B 7D 08 0F B7 47 08 66 83 F8 70 0F 84 2C 01 00 00 66 83 FE 70 0F 84 22 01 00 00 66 83 F8 73 74 0A 66 83 F8 53 74 04 33 D2 EB 03 33 D2 42 66 83 FE 73 74 0A 66 83 FE 53 74 04 33 C9 EB 03 33 C9 41 85 D2 0F 85 D1 00 00 00 85 C9 0F 85 E8 00 00 00 6A 69 5F 6A 64 5A 66 3B C2 74 65 66 3B C7 74 3A 66 83 F8 6F 74 34 66 83 F8 75 74 2E 66 83 F8 78 74 28 66 83 F8 58 74 22 66 3B F2 74 1D 66 3B F7 74 18 66 83 FE 6F 74 12 66 83 FE 75 74 0C 66 83 FE 78 74 06 66 83 FE 58 75 70 66 3B C2 74 21 66 3B C7 74 1C 66 83 F8 6F 74 16 66 83 F8 75 74 10 66 83 F8 78 74 0A 66 83 F8 58 74 04 33 C9 EB 03 33 C9 41 66 3B F2 74 21 66 3B F7 74 1C 66 83 FE 6F 74 16 66 83 FE 75 74 10 66 83 FE 78 74 0A 66 83 FE 58 74 04 33 C0 EB 03 33 C0 40 3B C8 75 48 8B 45 08 8B 40 0C 8B C8 33 4D 14 F7 C1 00 00 01 00 75 35 33 45 14 A8 20 75 2E 8B 4D 08 8B 09 33 C0 3B 4D 0C 0F 94 C0 EB 2D 3B D1 75 1B 8B 47 0C 8B 4D 14 C1 E8 05 C1 E9 05 F7 D0 F7 D1 33 C1 A8 01 75 05 33 C0 40 EB 0E 33 C0 EB 0A 33 C9 66 3B C6 0F 94 C1 8B C1 5F 5E 5D C3 }
	condition:
		$1
}

rule file_564_4_0 {
	meta:
		name = "_write_char"
		size = 47
		refs = "0016 __fputwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC F6 40 0C 40 74 06 83 78 08 00 74 1A 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 B9 FF FF 00 00 66 3B C1 75 05 83 0E FF 5D C3 FF 06 5D C3 }
	condition:
		$1
}

rule file_564_5_0 {
	meta:
		name = "_write_multi_char"
		size = 39
		refs = "0014 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 14 FF 75 08 8B 45 10 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 59 74 06 83 7D 0C 00 7F E6 5E 5D C3 }
	condition:
		$1
}

rule file_564_6_0 {
	meta:
		name = "_write_string"
		size = 82
		refs = "0028 _write_char 0035 __errno"
	strings:
		$1 = { 8B FF 55 8B EC F6 47 0C 40 53 56 8B F0 8B D9 74 37 83 7F 08 00 75 31 8B 45 08 01 06 EB 30 0F B7 03 FF 4D 08 50 8B C7 E8 ?? ?? ?? ?? 43 43 83 3E FF 59 75 14 E8 ?? ?? ?? ?? 83 38 2A 75 10 6A 3F 8B C7 E8 ?? ?? ?? ?? 59 83 7D 08 00 7F D0 5E 5B 5D C3 }
	condition:
		$1
}

rule file_564_9_0 {
	meta:
		name = "__woutput_p_l"
		size = 4800
		refs = "000c ___security_cookie 0057 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006d __errno 007d __invalid_parameter 0143 ___lookuptable_s 018f _wcstol 01be _memset 0254 $LN649 05cd _write_char 07b1 __mbtowc_l 0866 ___nullstring 0872 _strlen 093e __get_printf_count_output 09cb __validate_param_reuseW 0a67 __malloc_crt 0b06 __cfltcvt_tab 0b0b __decode_pointer 0ea3 __aulldvrm 0f7d __isleadbyte_l 0fbb ___wnullstring 1076 _write_multi_char 1096 _write_string 1189 _free 120b _get_crtdouble_arg 129a @__security_check_cookie@4 12a0 $LN255 12a4 $LN251 12a8 $LN250 12ac $LN242 12b0 $LN230 12b4 $LN229 12b8 $LN217 12bc $LN201"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D4 0A 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 56 8B 75 0C 57 8B 7D 08 FF 75 10 33 DB 8D 8D D0 FB FF FF 89 BD A0 FB FF FF 89 85 F4 FB FF FF 89 9D 94 FB FF FF 89 9D F8 FB FF FF 89 9D B4 FB FF FF 89 9D 98 FB FF FF 89 9D AC FB FF FF E8 ?? ?? ?? ?? 83 8D EC FB FF FF FF 89 9D B0 FB FF FF 3B FB 75 32 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 9D DC FB FF FF 74 0A 8B 85 D8 FB FF FF 83 60 70 FD 83 C8 FF E9 F3 11 00 00 3B F3 74 CA 89 9D C4 FB FF FF 89 B5 74 FB FF FF 89 9D E4 FB FF FF 83 BD E4 FB FF FF 01 75 0C 39 9D EC FB FF FF 0F 84 AF 11 00 00 0F B7 16 83 8D B8 FB FF FF FF 83 8D E0 FB FF FF FF 83 8D EC FB FF FF FF 89 9D C8 FB FF FF 89 9D A8 FB FF FF 89 9D 90 FB FF FF 89 9D BC FB FF FF 89 9D F0 FB FF FF 89 B5 C0 FB FF FF 89 95 CC FB FF FF 66 3B D3 0F 84 22 11 00 00 EB 06 8B 95 CC FB FF FF 6A 02 5F 03 F7 83 BD C4 FB FF FF 00 89 B5 C0 FB FF FF 0F 8C 79 10 00 00 8D 42 E0 66 83 F8 58 77 0F 0F B7 C2 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 8B 8D A8 FB FF FF 6B C0 09 0F B6 9C 08 ?? ?? ?? ?? C1 EB 04 89 9D A8 FB FF FF 83 FB 01 0F 85 E7 00 00 00 66 83 3E 25 0F 84 D0 00 00 00 83 BD EC FB FF FF FF 75 5A 6A 0A 8D 85 B0 FB FF FF 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 37 8B 85 B0 FB FF FF 66 83 38 24 75 2B 83 BD E4 FB FF FF 00 75 16 68 40 06 00 00 8D 85 2C F5 FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 EC FB FF FF 01 00 00 00 EB 16 83 A5 EC FB FF FF 00 8B 95 CC FB FF FF 83 BD EC FB FF FF 01 75 64 6A 0A 8D 85 B0 FB FF FF 50 56 E8 ?? ?? ?? ?? 8B 8D B0 FB FF FF 83 C4 0C 48 83 BD E4 FB FF FF 00 8D 51 02 89 85 E0 FB FF FF 89 95 C0 FB FF FF 75 2B 33 F6 3B C6 0F 8C B8 07 00 00 66 83 39 24 0F 85 AE 07 00 00 83 F8 64 0F 8D A5 07 00 00 3B 85 B8 FB FF FF 7E 06 89 85 B8 FB FF FF 8B F2 8B 95 CC FB FF FF 8B 8D E0 FB FF FF FF 24 9D ?? ?? ?? ?? 83 FB 08 0F 84 F1 0F 00 00 83 FB 07 0F 87 2B 0F 00 00 EB DF 83 BD E4 FB FF FF 00 75 0D 83 BD EC FB FF FF 01 0F 84 13 0F 00 00 83 BD E4 FB FF FF 01 0F 85 26 03 00 00 83 BD EC FB FF FF FF 0F 85 19 03 00 00 E9 F4 0E 00 00 33 C0 83 8D F0 FB FF FF FF 89 85 80 FB FF FF 89 85 98 FB FF FF 89 85 BC FB FF FF 89 85 B4 FB FF FF 89 85 F8 FB FF FF 89 85 AC FB FF FF E9 C2 0E 00 00 0F B7 C2 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 2B C7 74 15 83 E8 03 0F 85 A3 0E 00 00 83 8D F8 FB FF FF 08 E9 97 0E 00 00 83 8D F8 FB FF FF 04 E9 8B 0E 00 00 83 8D F8 FB FF FF 01 E9 7F 0E 00 00 81 8D F8 FB FF FF 80 00 00 00 E9 70 0E 00 00 09 BD F8 FB FF FF E9 65 0E 00 00 66 83 FA 2A 0F 85 C4 00 00 00 83 BD EC FB FF FF 00 75 15 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC E9 86 00 00 00 6A 0A 8D 85 B0 FB FF FF 50 56 E8 ?? ?? ?? ?? 8B 8D B0 FB FF FF 83 C4 0C 33 F6 48 8D 51 02 89 95 C0 FB FF FF 39 B5 E4 FB FF FF 75 4E 3B C6 0F 8C 4E 06 00 00 66 83 39 24 0F 85 44 06 00 00 83 BD E0 FB FF FF 64 0F 8D 37 06 00 00 3B 85 B8 FB FF FF 7E 06 89 85 B8 FB FF FF C1 E0 04 8D 8C 05 2C F5 FF FF 39 31 0F 84 DD 00 00 00 FF B5 F8 FB FF FF 6A 2A 6A 01 E9 F7 05 00 00 C1 E0 04 8B 84 05 30 F5 FF FF 8B 00 89 85 BC FB FF FF 85 C0 0F 8D A9 0D 00 00 83 8D F8 FB FF FF 04 F7 9D BC FB FF FF E9 97 0D 00 00 8B 85 BC FB FF FF 6B C0 0A 0F B7 CA 8D 44 08 D0 89 85 BC FB FF FF E9 7C 0D 00 00 83 A5 F0 FB FF FF 00 E9 70 0D 00 00 66 83 FA 2A 0F 85 94 00 00 00 83 BD EC FB FF FF 00 75 12 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC EB 3C 6A 0A 8D 85 B0 FB FF FF 50 56 E8 ?? ?? ?? ?? 8B 8D B0 FB FF FF 83 C4 0C 33 F6 48 8D 51 02 89 95 C0 FB FF FF 39 B5 E4 FB FF FF 0F 84 0A FF FF FF C1 E0 04 8B 84 05 30 F5 FF FF 8B 00 89 85 F0 FB FF FF 85 C0 0F 8D 01 0D 00 00 83 8D F0 FB FF FF FF E9 F5 0C 00 00 C7 01 01 00 00 00 6A 2A 59 66 89 8C 05 34 F5 FF FF 8B 8D F8 FB FF FF 89 8C 05 38 F5 FF FF E9 D2 0C 00 00 8B 85 F0 FB FF FF 6B C0 0A 0F B7 CA 8D 44 08 D0 89 85 F0 FB FF FF E9 B7 0C 00 00 0F B7 C2 83 F8 49 74 57 83 F8 68 74 46 83 F8 6C 74 18 83 F8 77 0F 85 9C 0C 00 00 81 8D F8 FB FF FF 00 08 00 00 E9 8D 0C 00 00 66 83 3E 6C 75 17 03 F7 81 8D F8 FB FF FF 00 10 00 00 89 B5 C0 FB FF FF E9 70 0C 00 00 83 8D F8 FB FF FF 10 E9 64 0C 00 00 83 8D F8 FB FF FF 20 E9 58 0C 00 00 0F B7 06 66 83 F8 36 75 1F 66 83 7E 02 34 75 18 83 C6 04 81 8D F8 FB FF FF 00 80 00 00 89 B5 C0 FB FF FF E9 30 0C 00 00 66 83 F8 33 75 1F 66 83 7E 02 32 75 18 83 C6 04 81 A5 F8 FB FF FF FF 7F FF FF 89 B5 C0 FB FF FF E9 0B 0C 00 00 66 83 F8 64 74 46 66 83 F8 69 74 40 66 83 F8 6F 74 3A 66 83 F8 75 74 34 66 83 F8 78 74 2E 66 83 F8 58 74 28 83 A5 A8 FB FF FF 00 8B 85 A0 FB FF FF 52 8D B5 C4 FB FF FF C7 85 AC FB FF FF 01 00 00 00 E8 ?? ?? ?? ?? E9 BE 0B 00 00 81 8D F8 FB FF FF 00 00 01 00 E9 B0 0B 00 00 0F B7 C2 83 F8 64 0F 8F 8B 02 00 00 0F 84 7F 03 00 00 83 F8 53 0F 8F E0 00 00 00 0F 84 94 00 00 00 83 E8 41 74 10 2B C7 74 76 2B C7 74 08 2B C7 0F 85 D6 09 00 00 83 C2 20 C7 85 80 FB FF FF 01 00 00 00 89 95 CC FB FF FF 83 8D F8 FB FF FF 40 83 BD EC FB FF FF 01 0F 85 BC 03 00 00 83 BD E4 FB FF FF 00 0F 85 AF 03 00 00 83 F9 63 0F 87 FA 0B 00 00 8B 85 E0 FB FF FF C1 E0 04 8D 8C 05 2C F5 FF FF 33 F6 39 31 0F 85 4E 03 00 00 C7 01 07 00 00 00 66 89 94 05 34 F5 FF FF E9 2C FE FF FF F7 85 F8 FB FF FF 30 08 00 00 75 71 83 8D F8 FB FF FF 20 EB 68 F7 85 F8 FB FF FF 30 08 00 00 75 07 83 8D F8 FB FF FF 20 8B 9D F0 FB FF FF 83 FB FF 75 05 BB FF FF FF 7F 33 F6 39 B5 EC FB FF FF 0F 85 48 08 00 00 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC E9 54 08 00 00 83 E8 58 0F 84 A6 04 00 00 2B C7 0F 84 F9 00 00 00 83 E8 07 0F 84 34 FF FF FF 2B C7 0F 85 EF 08 00 00 83 BD EC FB FF FF 00 C7 85 AC FB FF FF 01 00 00 00 75 13 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 0F B7 40 FC EB 4B 83 F9 63 0F 87 21 0B 00 00 83 BD E4 FB FF FF 00 75 2C 8B 85 E0 FB FF FF C1 E0 04 8D 8C 05 2C F5 FF FF 33 F6 39 31 75 0B C7 01 01 00 00 00 E9 40 08 00 00 FF B5 F8 FB FF FF E9 15 06 00 00 C1 E1 04 8B 84 0D 30 F5 FF FF 0F B7 00 F6 85 F8 FB FF FF 20 89 85 8C FB FF FF 74 46 88 85 9C FB FF FF 8D 85 D0 FB FF FF 50 8B 85 D0 FB FF FF C6 85 9D FB FF FF 00 FF B0 AC 00 00 00 8D 85 9C FB FF FF 50 8D 85 FC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 13 C7 85 98 FB FF FF 01 00 00 00 EB 07 66 89 85 FC FB FF FF 8D 85 FC FB FF FF 89 85 E8 FB FF FF C7 85 C8 FB FF FF 01 00 00 00 E9 07 08 00 00 83 BD EC FB FF FF 00 75 12 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC EB 22 83 F9 63 0F 87 44 0A 00 00 83 BD E4 FB FF FF 00 0F 84 EF 00 00 00 C1 E1 04 8B 84 0D 30 F5 FF FF 8B 00 85 C0 74 3A 8B 48 04 85 C9 74 33 F7 85 F8 FB FF FF 00 08 00 00 0F BF 00 89 8D E8 FB FF FF 74 12 99 2B C2 C7 85 AC FB FF FF 01 00 00 00 E9 90 07 00 00 83 A5 AC FB FF FF 00 E9 86 07 00 00 A1 ?? ?? ?? ?? 89 85 E8 FB FF FF 50 E8 ?? ?? ?? ?? 59 E9 6F 07 00 00 83 F8 70 0F 8F 16 03 00 00 0F 84 FA 02 00 00 83 F8 65 0F 8C 5D 07 00 00 83 F8 67 0F 8E 91 FD FF FF 83 F8 69 0F 84 D0 00 00 00 83 F8 6E 74 32 83 F8 6F 0F 85 3D 07 00 00 8B 9D F8 FB FF FF C7 85 CC FB FF FF 08 00 00 00 84 DB 0F 89 C1 00 00 00 81 CB 00 02 00 00 89 9D F8 FB FF FF E9 B0 00 00 00 83 BD EC FB FF FF 00 75 12 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 70 FC EB 45 83 F9 63 0F 87 51 09 00 00 83 BD E4 FB FF FF 00 75 27 8B 85 E0 FB FF FF C1 E0 04 33 F6 8D 8C 05 2C F5 FF FF 39 31 0F 84 75 06 00 00 FF B5 F8 FB FF FF 52 57 E9 4D 04 00 00 C1 E1 04 8B 84 0D 30 F5 FF FF 8B 30 E8 ?? ?? ?? ?? 85 C0 0F 84 08 09 00 00 F6 85 F8 FB FF FF 20 74 0C 66 8B 85 C4 FB FF FF 66 89 06 EB 08 8B 85 C4 FB FF FF 89 06 C7 85 98 FB FF FF 01 00 00 00 E9 7B 06 00 00 83 8D F8 FB FF FF 40 C7 85 CC FB FF FF 0A 00 00 00 8B 9D F8 FB FF FF F7 C3 00 80 00 00 0F 84 9E 02 00 00 83 BD EC FB FF FF 00 0F 85 55 02 00 00 8B 8D F4 FB FF FF 83 C1 08 89 8D F4 FB FF FF 8B 41 F8 8B 51 FC E9 1E 04 00 00 FF B5 F8 FB FF FF 52 6A 07 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 BB 07 00 00 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 BD DC FB FF FF 00 E9 8C F6 FF FF 83 BD F0 FB FF FF 00 8D BD FC FB FF FF B8 00 02 00 00 89 BD E8 FB FF FF 89 85 C8 FB FF FF 7D 0C C7 85 F0 FB FF FF 06 00 00 00 EB 68 75 12 66 83 FA 67 75 60 C7 85 F0 FB FF FF 01 00 00 00 EB 54 39 85 F0 FB FF FF 7E 06 89 85 F0 FB FF FF BB A3 00 00 00 39 9D F0 FB FF FF 7E 39 8B B5 F0 FB FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 8B 95 CC FB FF FF 59 89 85 90 FB FF FF 85 C0 74 10 89 85 E8 FB FF FF 89 B5 C8 FB FF FF 8B F8 EB 06 89 9D F0 FB FF FF 33 DB 39 9D EC FB FF FF 75 11 8B 85 F4 FB FF FF 83 C0 08 89 85 F4 FB FF FF EB 20 83 BD E0 FB FF FF 63 0F 87 AF 07 00 00 8B 85 E0 FB FF FF C1 E0 04 8B 84 05 30 F5 FF FF 83 C0 08 8B 48 F8 89 8D 78 FB FF FF 8B 40 FC 89 85 7C FB FF FF 8D 85 D0 FB FF FF 50 FF B5 80 FB FF FF 0F BE C2 FF B5 F0 FB FF FF 50 FF B5 C8 FB FF FF 8D 85 78 FB FF FF 57 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B B5 F8 FB FF FF 83 C4 1C 81 E6 80 00 00 00 74 20 39 9D F0 FB FF FF 75 18 8D 85 D0 FB FF FF 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 66 83 BD CC FB FF FF 67 75 1C 3B F3 75 18 8D 85 D0 FB FF FF 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3F 2D 75 11 81 8D F8 FB FF FF 00 01 00 00 47 89 BD E8 FB FF FF 57 E9 EC FC FF FF C7 85 F0 FB FF FF 08 00 00 00 C7 85 94 FB FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 09 FB FF FF 2B C7 0F 84 D1 FD FF FF 83 E8 03 0F 85 3C 04 00 00 C7 85 94 FB FF FF 27 00 00 00 F6 85 F8 FB FF FF 80 C7 85 CC FB FF FF 10 00 00 00 0F 84 B1 FD FF FF 6A 30 58 66 89 85 A4 FB FF FF 8B 85 94 FB FF FF 83 C0 51 66 89 85 A6 FB FF FF 89 BD B4 FB FF FF E9 8C FD FF FF 83 F9 63 0F 87 4E 06 00 00 8B 85 E0 FB FF FF C1 E0 04 83 BD E4 FB FF FF 00 75 72 8D 8C 05 2C F5 FF FF 33 F6 39 31 75 0B C7 01 03 00 00 00 E9 04 02 00 00 53 52 6A 03 E9 47 01 00 00 F7 C3 00 10 00 00 74 5A 83 BD EC FB FF FF 00 0F 84 5A FD FF FF 83 F9 63 0F 87 FD 05 00 00 8B 85 E0 FB FF FF C1 E0 04 83 BD E4 FB FF FF 00 75 21 8D 8C 05 2C F5 FF FF 33 F6 39 31 75 0B C7 01 04 00 00 00 E9 B3 01 00 00 53 52 6A 04 E9 F6 00 00 00 8B 8C 05 30 F5 FF FF 8B 01 8B 51 04 E9 45 01 00 00 F6 C3 20 0F 84 8C 00 00 00 F6 C3 40 74 47 83 BD EC FB FF FF 00 75 16 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 0F BF 40 FC E9 DA 00 00 00 83 F9 63 0F 87 83 05 00 00 83 BD E4 FB FF FF 00 0F 84 84 00 00 00 C1 E1 04 8B 84 0D 30 F5 FF FF 0F BF 00 E9 B2 00 00 00 83 BD EC FB FF FF 00 75 16 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 0F B7 40 FC E9 93 00 00 00 83 F9 63 0F 87 3C 05 00 00 83 BD E4 FB FF FF 00 74 41 C1 E1 04 8B 84 0D 30 F5 FF FF 0F B7 00 EB 72 F6 C3 40 74 70 83 BD EC FB FF FF 00 75 12 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC EB 52 83 F9 63 0F 87 FB 04 00 00 83 BD E4 FB FF FF 00 75 34 8B 85 E0 FB FF FF C1 E0 04 33 F6 8D 8C 05 2C F5 FF FF 39 31 0F 84 B2 00 00 00 53 52 6A 01 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 4B FC FF FF E9 5D 02 00 00 C1 E1 04 8B 84 0D 30 F5 FF FF 8B 00 99 EB 3B 83 BD EC FB FF FF 00 75 12 83 85 F4 FB FF FF 04 8B 85 F4 FB FF FF 8B 40 FC EB 1E 83 F9 63 0F 87 8B 04 00 00 83 BD E4 FB FF FF 00 74 90 C1 E1 04 8B 84 0D 30 F5 FF FF 8B 00 33 D2 F6 C3 40 74 1D 85 D2 7F 19 7C 04 85 C0 73 13 F7 D8 83 D2 00 F7 DA 81 CB 00 01 00 00 89 9D F8 FB FF FF 89 95 88 FB FF FF 8B F8 F7 C3 00 90 00 00 75 07 83 A5 88 FB FF FF 00 83 BD F0 FB FF FF 00 7D 26 C7 85 F0 FB FF FF 01 00 00 00 EB 36 C7 01 01 00 00 00 66 89 94 05 34 F5 FF FF 89 9C 05 38 F5 FF FF E9 AB 01 00 00 83 E3 F7 B8 00 02 00 00 39 85 F0 FB FF FF 89 9D F8 FB FF FF 7E 06 89 85 F0 FB FF FF 8B C7 0B 85 88 FB FF FF 75 06 21 85 B4 FB FF FF 8D B5 FB FD FF FF 8B 85 F0 FB FF FF FF 8D F0 FB FF FF 85 C0 7F 0A 8B C7 0B 85 88 FB FF FF 74 3C 8B 85 CC FB FF FF 99 52 50 FF B5 88 FB FF FF 57 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 9D 70 FB FF FF 8B F8 89 95 88 FB FF FF 7E 06 03 8D 94 FB FF FF 8B 9D F8 FB FF FF 88 0E 4E EB AA 8D 85 FB FD FF FF 2B C6 46 89 85 C8 FB FF FF 89 B5 E8 FB FF FF F7 C3 00 02 00 00 0F 84 02 01 00 00 85 C0 74 0B 8B CE 80 39 30 0F 84 F3 00 00 00 FF 8D E8 FB FF FF 8B 8D E8 FB FF FF C6 01 30 40 E9 D8 00 00 00 83 F9 63 0F 87 36 03 00 00 39 B5 E4 FB FF FF 0F 84 E2 F9 FF FF C1 E1 04 8B 84 0D 30 F5 FF FF 8B 00 F6 85 F8 FB FF FF 20 89 85 E8 FB FF FF 74 6F 3B C6 75 0B A1 ?? ?? ?? ?? 89 85 E8 FB FF FF 83 A5 C8 FB FF FF 00 8B B5 E8 FB FF FF 85 DB 0F 8E 8A 00 00 00 8A 06 84 C0 0F 84 80 00 00 00 8D 8D D0 FB FF FF 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 01 46 46 FF 85 C8 FB FF FF 39 9D C8 FB FF FF 7C D0 EB 58 89 39 8B 8D F8 FB FF FF 66 89 94 05 34 F5 FF FF 89 8C 05 38 F5 FF FF EB 3F 39 B5 E8 FB FF FF 75 0B A1 ?? ?? ?? ?? 89 85 E8 FB FF FF 8B 85 E8 FB FF FF C7 85 AC FB FF FF 01 00 00 00 EB 08 4B 66 39 30 74 06 03 C7 3B DE 75 F4 2B 85 E8 FB FF FF D1 F8 89 85 C8 FB FF FF 83 BD EC FB FF FF 01 75 0D 83 BD E4 FB FF FF }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "__fgetwc_nolock"
		size = 427
		refs = "0011 ___badioinfo 001d __fileno 0040 ___pioinfo 006e __filbuf 0126 _isleadbyte 0151 _ungetc 016d _mbtowc 017e __errno 01a1 __filwbuf"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 08 F6 46 0C 40 57 BB ?? ?? ?? ?? 0F 85 72 01 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 56 8D 3C 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 59 C1 E0 06 03 07 59 EB 02 8B C3 F6 40 24 7F 74 4F FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 0A B8 FF FF 00 00 E9 24 01 00 00 FF 4E 04 88 45 08 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 D8 88 45 09 66 8B 45 08 E9 FA 00 00 00 F6 46 0C 40 0F 85 D7 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 56 8D 3C 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 59 C1 E0 06 03 07 59 EB 02 8B C3 F6 40 04 80 0F 84 91 00 00 00 33 FF 47 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 0F 84 5A FF FF FF 88 45 FC 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 34 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 13 0F BE 45 FC 56 50 E8 ?? ?? ?? ?? 59 B8 FF FF 00 00 EB 48 6A 02 88 45 FD 5F 57 8D 45 FC 50 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 85 26 FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E9 EB FE FF FF 83 46 04 FE 78 0C 8B 0E 0F B7 01 83 C1 02 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_566_1_0 {
	meta:
		name = "_fgetwc"
		size = 116
		refs = "0003 __sehtable$_fgetwc 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 003d __lock_file 0049 __fgetwc_nolock 0065 __SEH_epilog4 006e __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF 00 00 EB 2B FF 75 08 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_567_0_0 {
	meta:
		name = "_fwprintf"
		size = 148
		refs = "0003 __sehtable$_fwprintf 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 004a __lock_file 0054 __stbuf 0064 __woutput_l 006e __ftbuf 0085 __SEH_epilog4 008e __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 08 33 F6 3B FE 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 33 C0 39 75 0C 0F 95 C0 3B C6 74 D7 89 7D 08 57 E8 ?? ?? ?? ?? 59 89 75 FC 57 E8 ?? ?? ?? ?? 8B D8 8D 45 10 50 56 FF 75 0C 57 E8 ?? ?? ?? ?? 89 45 E4 57 53 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_567_3_0 {
	meta:
		name = "_fwprintf_s"
		size = 27
		refs = "0012 __vfwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_875_5_0 {
	meta:
		name = "__fprintf_p"
		size = 27
		refs = "0012 __vfprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_567_5_0 {
	meta:
		name = "__fwprintf_p"
		size = 27
		refs = "0012 __vfwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_875_3_0 {
	meta:
		name = "_fprintf_s"
		size = 27
		refs = "0012 __vfprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_568_3_0 {
	meta:
		name = "__strcoll_l"
		size = 166
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 005c _strcmp 007c ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D0 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_770_3_0 {
	meta:
		name = "__wcscoll_l"
		size = 166
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 005c _wcscmp 007c ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D0 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_569_3_0 {
	meta:
		name = "__ismbcpunct_l"
		size = 179
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 75 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 34 F6 45 FC 10 74 2E 33 C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 F6 04 41 10 75 DC 8B 4D F0 F6 44 08 1D 02 75 D2 33 C0 EB D1 }
	condition:
		$1
}

rule file_570_3_0 {
	meta:
		name = "__ismbstrail_l"
		size = 168
		refs = "0014 __errno 0024 __invalid_parameter 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 44 57 8B 7D 0C 3B FB 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 1F FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 39 59 08 75 2D 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 8A 06 3A C3 74 E7 0F B6 C0 F6 44 08 1D 04 74 09 46 3B F7 74 0B 38 1E 74 D4 46 3B F7 76 E2 EB CD 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB CA }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "__ctime32_s"
		size = 112
		refs = "0019 __e