private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__fpieee_flt"
		size = 3308
		refs = "001f ___security_cookie 008f _fpieee_flt_simd 0117 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 011e __CrtDbgReportW 0178 _instr_info_table 05ef _FLDTable 0705 $LN82 071c __FillOperand 077c __PreventStackOverwrite 07a5 __UpdateFpCtxt 07be __IsMemoryLocation 07f5 __GetFpRegVal 0834 __ieee_adj_single 084e __ieee_adj_double 0927 __AdjustLocation 0a7d $LN83 0cb8 @__security_check_cookie@4 0cc4 $LN26 0cc8 $LN23 0cd0 $LN24 0cd4 $LN27 0cdc $LN9 0ce0 $LN8 0ce4 $LN7 0ce8 $LN6"
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 40 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 81 7B 08 8E 00 00 C0 74 3D 81 7B 08 8F 00 00 C0 74 34 81 7B 08 90 00 00 C0 74 2B 81 7B 08 91 00 00 C0 74 22 81 7B 08 93 00 00 C0 74 19 81 7B 08 B4 02 00 C0 74 10 81 7B 08 B5 02 00 C0 74 07 33 C0 E9 44 0C 00 00 DB E3 81 7B 08 B4 02 00 C0 74 09 81 7B 08 B5 02 00 C0 75 19 8B 43 10 50 8B 4B 0C 51 8B 53 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 17 0C 00 00 8B 43 0C 8B 08 89 4D F8 8B 55 F8 83 C2 14 89 55 F4 8B 43 0C 8B 48 04 89 4D F0 8B 55 F0 83 C2 1C 89 55 EC 8B 45 F4 83 38 00 74 2F 8B 4D F4 8B 11 52 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 12 8B 45 EC 8B 48 04 81 E1 00 FF FF FF 8B 55 EC 89 4A 04 8B 45 E8 E9 BD 0B 00 00 8B 45 EC 8B 48 0C 0F B6 11 83 E2 F8 81 FA D8 00 00 00 74 29 33 C0 75 1E 6A 00 6A 00 68 F2 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 E9 80 0B 00 00 8B 55 EC 8B 42 0C 66 8B 08 66 89 4D E4 8B 55 E4 C1 EA 0E 83 E2 03 33 C0 83 FA 03 0F 94 C0 89 45 E0 8B 4D E4 83 E1 07 C1 E1 04 8B 55 E0 C1 E2 03 0B CA 8B 45 E4 C1 E8 0B 83 E0 07 0B C8 89 4D DC 8B 4D DC 8D 14 8D ?? ?? ?? ?? 89 55 D8 8B 45 D8 8B 08 81 E1 FF 0F 00 00 81 E1 FF 0F 00 00 C1 E1 05 8B 95 60 FF FF FF 81 E2 1F 00 FE FF 0B D1 89 95 60 FF FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 89 8D 5C FF FF FF 8B 55 EC 8B 02 89 85 58 FF FF FF 8B 4D EC 8B 51 04 89 95 54 FF FF FF 8B 85 58 FF FF FF 25 00 0C 00 00 89 85 50 FF FF FF 81 BD 50 FF FF FF 00 08 00 00 77 23 81 BD 50 FF FF FF 00 08 00 00 74 4A 83 BD 50 FF FF FF 00 74 1C 81 BD 50 FF FF FF 00 04 00 00 74 21 EB 56 81 BD 50 FF FF FF 00 0C 00 00 74 3B EB 48 8B 8D 60 FF FF FF 83 E1 FC 89 8D 60 FF FF FF EB 37 8B 95 60 FF FF FF 83 E2 FC 83 CA 01 89 95 60 FF FF FF EB 23 8B 85 60 FF FF FF 83 E0 FC 83 C8 02 89 85 60 FF FF FF EB 0F 8B 8D 60 FF FF FF 83 C9 03 89 8D 60 FF FF FF 8B 95 58 FF FF FF 81 E2 00 03 00 00 89 95 4C FF FF FF 74 3F 81 BD 4C FF FF FF 00 02 00 00 74 1F 81 BD 4C FF FF FF 00 03 00 00 74 02 EB 37 8B 85 60 FF FF FF 83 E0 E3 89 85 60 FF FF FF EB 26 8B 8D 60 FF FF FF 83 E1 E3 83 C9 04 89 8D 60 FF FF FF EB 12 8B 95 60 FF FF FF 83 E2 E3 83 CA 08 89 95 60 FF FF FF 8B 85 58 FF FF FF 83 E0 20 F7 D8 1B C0 83 C0 01 83 E0 01 8B 8D 68 FF FF FF 83 E1 FE 0B C8 89 8D 68 FF FF FF 8B 95 58 FF FF FF 83 E2 10 F7 DA 1B D2 83 C2 01 83 E2 01 D1 E2 8B 85 68 FF FF FF 83 E0 FD 0B C2 89 85 68 FF FF FF 8B 8D 58 FF FF FF 83 E1 08 F7 D9 1B C9 83 C1 01 83 E1 01 C1 E1 02 8B 95 68 FF FF FF 83 E2 FB 0B D1 89 95 68 FF FF FF 8B 85 58 FF FF FF 83 E0 04 F7 D8 1B C0 83 C0 01 83 E0 01 C1 E0 03 8B 8D 68 FF FF FF 83 E1 F7 0B C8 89 8D 68 FF FF FF 8B 95 58 FF FF FF 83 E2 01 F7 DA 1B D2 83 C2 01 83 E2 01 C1 E2 04 8B 85 68 FF FF FF 83 E0 EF 0B C2 89 85 68 FF FF FF 8B 8D 54 FF FF FF 83 E1 20 F7 D9 1B C9 F7 D9 83 E1 01 8B 95 6C FF FF FF 83 E2 FE 0B D1 89 95 6C FF FF FF 8B 85 54 FF FF FF 83 E0 10 F7 D8 1B C0 F7 D8 83 E0 01 D1 E0 8B 8D 6C FF FF FF 83 E1 FD 0B C8 89 8D 6C FF FF FF 8B 95 54 FF FF FF 83 E2 08 F7 DA 1B D2 F7 DA 83 E2 01 C1 E2 02 8B 85 6C FF FF FF 83 E0 FB 0B C2 89 85 6C FF FF FF 8B 8D 54 FF FF FF 83 E1 04 F7 D9 1B C9 F7 D9 83 E1 01 C1 E1 03 8B 95 6C FF FF FF 83 E2 F7 0B D1 89 95 6C FF FF FF 8B 85 54 FF FF FF 83 E0 01 F7 D8 1B C0 F7 D8 83 E0 01 C1 E0 04 8B 8D 6C FF FF FF 83 E1 EF 0B C8 89 8D 6C FF FF FF 8B 95 68 FF FF FF 83 E2 01 74 17 8B 85 6C FF FF FF 83 E0 01 74 0C C7 85 48 FF FF FF 01 00 00 00 EB 0A C7 85 48 FF FF FF 00 00 00 00 8B 8D 48 FF FF FF 83 E1 01 8B 95 64 FF FF FF 83 E2 FE 0B D1 89 95 64 FF FF FF 8B 85 68 FF FF FF D1 E8 83 E0 01 74 19 8B 8D 6C FF FF FF D1 E9 83 E1 01 74 0C C7 85 44 FF FF FF 01 00 00 00 EB 0A C7 85 44 FF FF FF 00 00 00 00 8B 95 44 FF FF FF 83 E2 01 D1 E2 8B 85 64 FF FF FF 83 E0 FD 0B C2 89 85 64 FF FF FF 8B 8D 68 FF FF FF C1 E9 02 83 E1 01 74 1A 8B 95 6C FF FF FF C1 EA 02 83 E2 01 74 0C C7 85 40 FF FF FF 01 00 00 00 EB 0A C7 85 40 FF FF FF 00 00 00 00 8B 85 40 FF FF FF 83 E0 01 C1 E0 02 8B 8D 64 FF FF FF 83 E1 FB 0B C8 89 8D 64 FF FF FF 8B 95 68 FF FF FF C1 EA 03 83 E2 01 74 1A 8B 85 6C FF FF FF C1 E8 03 83 E0 01 74 0C C7 85 3C FF FF FF 01 00 00 00 EB 0A C7 85 3C FF FF FF 00 00 00 00 8B 8D 3C FF FF FF 83 E1 01 C1 E1 03 8B 95 64 FF FF FF 83 E2 F7 0B D1 89 95 64 FF FF FF 8B 85 68 FF FF FF C1 E8 04 83 E0 01 74 1A 8B 8D 6C FF FF FF C1 E9 04 83 E1 01 74 0C C7 85 38 FF FF FF 01 00 00 00 EB 0A C7 85 38 FF FF FF 00 00 00 00 8B 95 38 FF FF FF 83 E2 01 C1 E2 04 8B 85 64 FF FF FF 83 E0 EF 0B C2 89 85 64 FF FF FF C7 85 34 FF FF FF 00 00 00 00 EB 0F 8B 8D 34 FF FF FF 83 C1 01 89 8D 34 FF FF FF 83 BD 34 FF FF FF 04 7D 35 8B 95 34 FF FF FF 8B 04 95 ?? ?? ?? ?? 3B 45 DC 75 21 8B 8D 64 FF FF FF C1 E9 04 83 E1 01 75 13 83 BD 5C FF FF FF 00 7D 0A C7 85 5C FF FF FF 00 00 00 00 EB B3 8B 55 D8 8B 02 C1 E8 0C 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 30 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 0C 83 E0 1F 89 85 30 FF FF FF 8B 8D 30 FF FF FF 89 8D 2C FF FF FF 8B 55 D8 8B 02 C1 E8 11 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 28 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 11 83 E0 1F 89 85 28 FF FF FF 8B 8D 28 FF FF FF 89 8D 24 FF FF FF 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 20 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 89 85 20 FF FF FF 8B 8D 20 FF FF FF 89 8D 1C FF FF FF 8B 53 08 89 95 18 FF FF FF 8B 85 18 FF FF FF 05 72 FF FF 3F 89 85 18 FF FF FF 83 BD 18 FF FF FF 05 0F 87 3A 03 00 00 8B 8D 18 FF FF FF FF 24 8D ?? ?? ?? ?? 8B 95 2C FF FF FF 52 8B 45 EC 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 24 FF FF FF 52 8B 45 EC 50 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 1C FF FF FF 52 8B 45 EC 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 C0 83 E2 FE 89 55 C0 8D 85 60 FF FF FF 50 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 3C 8B 8D 1C FF FF FF 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 1C FF FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 1C FF FF FF 52 8D 45 B0 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 E9 85 02 00 00 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 46 01 00 00 8B 8D 2C FF FF FF 51 8B 55 EC 52 8D 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 4D EC 51 8D 95 08 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 08 89 8D FC FE FF FF 8B 50 04 89 95 00 FF FF FF 66 8B 40 08 66 89 85 04 FF FF FF 8B 4D C0 83 C9 01 89 4D C0 83 BD 1C FF FF FF 0D 75 16 8B 55 C0 83 E2 E1 89 55 C0 A1 ?? ?? ?? ?? 89 85 F8 FE FF FF EB 18 8B 4D C0 83 E1 E1 83 C9 02 89 4D C0 8B 15 ?? ?? ?? ?? 89 95 F8 FE FF FF 81 7B 08 91 00 00 C0 75 0E 8B 85 F8 FE FF FF F7 D8 89 85 F8 FE FF FF DB 85 F8 FE FF FF DB AD FC FE FF FF D9 FD DD D9 DB BD FC FE FF FF 83 BD 1C FF FF FF 0D 75 17 DB AD FC FE FF FF D9 9D F4 FE FF FF D9 85 F4 FE FF FF D9 5D B0 EB 15 DB AD FC FE FF FF DD 9D E8 FE FF FF DD 85 E8 FE FF FF DD 5D B0 DB E2 8D 8D 60 FF FF FF 51 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 3C 8B 95 1C FF FF FF 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 1C FF FF FF 8B 4D D8 8B 11 C1 E2 02 C1 FA 1D 52 8B 85 1C FF FF FF 50 8D 4D B0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 23 01 00 00 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 E4 FE FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 24 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 E0 FE FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 1C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 DC FE FF FF 8B 85 E4 FE FF FF 3B 85 DC FE FF FF 75 0A C7 85 E4 FE FF FF 1F 00 00 00 8B 8D E0 FE FF FF 3B 8D DC FE FF FF 75 0A C7 85 E0 FE FF FF 1F 00 00 00 8B 95 DC FE FF FF 52 8B 45 EC 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 E4 FE FF FF 52 8B 45 EC 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 E0 FE FF FF 52 8B 45 EC 50 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 0C 8D 95 60 FF FF FF 52 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 32 8B 85 DC FE FF FF 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 DC FE FF FF 6A 00 8B 95 DC FE FF FF 52 8D 45 B0 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D E8 FF 0F 85 6F 02 00 00 8B 55 EC 8B 42 04 25 00 FF FF FF 8B 4D EC 89 41 04 8B 55 EC 8B 02 89 85 58 FF FF FF 8B 8D 60 FF FF FF 83 E1 03 89 8D D8 FE FF FF 83 BD D8 FE FF FF 03 77 6A 8B 95 D8 FE FF FF FF 24 95 ?? ?? ?? ?? 8B 85 58 FF FF FF 25 FF F3 FF FF 89 85 58 FF FF FF EB 4A 8B 8D 58 FF FF FF 81 E1 FF F3 FF FF 81 C9 00 04 00 00 89 8D 58 FF FF FF EB 30 8B 95 58 FF FF FF 81 E2 FF F3 FF FF 81 CA 00 08 00 00 89 95 58 FF FF FF EB 16 8B 85 58 FF FF FF 25 FF F3 FF FF 0D 00 0C 00 00 89 85 58 FF FF FF 8B 8D 60 FF FF FF C1 E9 02 83 E1 07 89 8D D4 FE FF FF 74 14 83 BD D4 FE FF FF 01 74 25 83 BD D4 FE FF FF 02 74 34 EB 44 8B 95 58 FF FF FF 81 E2 FF FC FF FF 81 CA 00 03 00 00 89 95 58 FF FF FF EB 2A 8B 85 58 FF FF FF 25 FF FC FF FF 0D 00 02 00 00 89 85 58 FF FF FF EB 12 8B 8D 58 FF FF FF 81 E1 FF FC FF FF 89 8D 58 FF FF FF 8B 95 68 FF FF FF 83 E2 01 74 1D 8B 85 58 FF FF FF 83 E0 DF 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D D0 FE FF FF EB 1B 8B 95 58 FF FF FF 83 CA 20 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 D0 FE FF FF 8B 8D 68 FF FF FF D1 E9 83 E1 01 74 1D 8B 95 58 FF FF FF 83 E2 EF 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 CC FE FF FF EB 1B 8B 8D 58 FF FF FF 83 C9 10 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 CC FE FF FF 8B 85 68 FF FF FF C1 E8 02 83 E0 01 74 1D 8B 8D 58 FF FF FF 83 E1 F7 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 C8 FE FF FF EB 1B 8B 85 58 FF FF FF 83 C8 08 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D C8 FE FF FF 8B 95 68 FF FF FF C1 EA 03 83 E2 01 74 1D 8B 85 58 FF FF FF 83 E0 FB 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D C4 FE FF FF EB 1B 8B 95 58 FF FF FF 83 CA 04 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 C4 FE FF FF 8B 8D 68 FF FF FF C1 E9 04 83 E1 01 74 1D 8B 95 58 FF FF FF 83 E2 FE 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 C0 FE FF FF EB 1B 8B 8D 58 FF FF FF 83 C9 01 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 C0 FE FF FF 8B 45 EC 8B 8D 58 FF FF FF 89 08 8B 45 E8 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__FillOperand"
		size = 768
		refs = "002d $LN24 0034 $LN25 0057 __GetFpRegVal 0248 __zero80 0282 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0289 __CrtDbgReportW 02ac $LN18 02b0 $LN1 02b4 $LN10 02b8 $LN16 02bc $LN15 02c0 $LN14 02c4 $LN12 02c8 $LN13 02cc $LN17 02d0 $LN11 02d4 $LN3 02d8 $LN2 02dc $LN19"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8B 45 08 8B 48 10 83 C9 01 8B 55 08 89 4A 10 8B 45 10 89 45 DC 83 7D DC 1F 0F 87 7E 02 00 00 8B 4D DC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 08 8B 48 10 83 E1 E1 83 C9 04 8B 55 08 89 4A 10 8B 45 10 50 8B 4D 0C 51 8D 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 66 8B 40 08 66 89 41 08 E9 2D 02 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 04 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 FB 01 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 08 8B 55 08 89 4A 10 8B 45 0C 8B 48 14 8B 55 08 66 8B 01 66 89 02 E9 D5 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 0A 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 E9 B1 01 00 00 8B 55 08 8B 42 10 83 E0 E1 83 C8 0C 8B 4D 08 89 41 10 8B 55 0C 8B 42 14 8B 08 8B 50 04 8B 45 08 89 08 89 50 04 E9 87 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 02 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 DD 02 DD 18 E9 63 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 D9 02 D9 18 E9 42 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 14 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 10 01 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 16 8B 55 08 89 4A 10 8B 45 0C 8B 48 04 81 E1 00 01 00 00 F7 D9 1B C9 F7 D9 89 4D FC 8B 55 0C 8B 42 04 25 00 04 00 00 F7 D8 1B C0 83 E0 04 89 45 F4 8B 4D 0C 8B 51 04 81 E2 00 01 00 00 F7 DA 1B D2 83 E2 08 89 55 F8 8B 45 FC 0B 45 F4 0B 45 F8 89 45 D8 74 11 83 7D D8 01 74 16 81 7D D8 00 01 00 00 74 18 EB 21 8B 4D 08 C7 01 01 00 00 00 EB 1F 8B 55 08 C7 02 02 00 00 00 EB 14 8B 45 08 C7 00 00 00 00 00 EB 09 8B 4D 08 C7 01 03 00 00 00 EB 73 8B 55 08 8B 42 10 83 E0 E1 83 C8 04 8B 4D 08 89 41 10 8B 55 08 A1 ?? ?? ?? ?? 89 02 8B 0D ?? ?? ?? ?? 89 4A 04 66 A1 ?? ?? ?? ?? 66 89 42 08 EB 42 8B 4D 08 8B 51 10 83 E2 FE 8B 45 08 89 50 10 EB 31 33 C9 75 1E 6A 00 6A 00 68 C6 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 8B 48 10 83 E1 FE 8B 55 08 89 4A 10 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 02 03 04 05 06 07 08 09 0A 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "__UpdateFpCtxt"
		size = 71
		refs = "0014 __AdjustStack 0028 __UpdateResult"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 7D 10 8B 45 14 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 7E 10 8B 55 14 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "__UpdateResult"
		size = 476
		refs = "001e $LN23 0025 $LN24 0036 __SetFpRegVal 00f8 $LN25 0178 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 017f __CrtDbgReportW 0190 $LN17 0194 $LN1 0198 $LN9 019c $LN15 01a0 $LN14 01a4 $LN13 01a8 $LN11 01ac $LN12 01b0 $LN16 01b4 $LN10 01cc $LN6 01d0 $LN5 01d4 $LN4 01d8 $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 10 89 45 FC 83 7D FC 11 0F 87 74 01 00 00 8B 4D FC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 4A 01 00 00 8B 45 0C 8B 4D 08 8B 51 14 8B 08 89 0A 8B 48 04 89 4A 04 66 8B 40 08 66 89 42 08 E9 2A 01 00 00 8B 4D 08 8B 51 14 8B 45 0C 66 8B 08 66 89 0A E9 16 01 00 00 8B 55 08 8B 42 14 8B 4D 0C 8B 11 89 10 E9 04 01 00 00 8B 45 0C 8B 08 8B 50 04 8B 45 08 8B 40 14 89 08 89 50 04 E9 EC 00 00 00 8B 4D 08 8B 51 14 8B 45 0C DD 00 DD 1A E9 DA 00 00 00 8B 4D 08 8B 51 14 8B 45 0C D9 00 D9 1A E9 C8 00 00 00 8B 4D 0C 8B 55 08 8B 42 14 8B 11 89 10 8B 51 04 89 50 04 66 8B 49 08 66 89 48 08 E9 A8 00 00 00 8B 55 0C 8B 02 89 45 F8 83 7D F8 03 77 76 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 08 8B 42 04 0D 00 40 00 00 8B 4D 08 89 41 04 8B 55 08 8B 42 04 25 FF FA FF FF 8B 4D 08 89 41 04 EB 48 8B 55 08 8B 42 04 25 FF BA FF FF 8B 4D 08 89 41 04 EB 35 8B 55 08 8B 42 04 0D 00 01 00 00 8B 4D 08 89 41 04 8B 55 08 8B 42 04 25 FF BB FF FF 8B 4D 08 89 41 04 EB 11 8B 55 08 8B 42 04 0D 00 45 00 00 8B 4D 08 89 41 04 EB 22 33 D2 75 1E 6A 00 6A 00 68 6C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 02 03 04 05 06 07 08 09 01 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "__AdjustStack"
		size = 348
		refs = "0009 ___security_cookie 0055 __SetTag 0096 _memcpy 00bf _memmove 0154 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 5C A1 ?? ?? ?? ?? 33 C5 89 45 F8 8B 45 08 83 C0 04 89 45 A4 83 7D 0C 00 0F 8E C9 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 55 0C 7D 44 6A 03 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 83 C1 01 83 E1 07 C1 E1 0B 8B 55 A4 8B 02 25 FF C7 FF FF 0B C1 8B 4D A4 89 01 EB AB 8B 55 0C 6B D2 0A 52 8B 45 08 83 C0 1C 50 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 2B 55 0C 6B D2 0A 52 8B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 6B C9 0A 51 8D 55 A8 52 B8 08 00 00 00 2B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 E8 ?? ?? ?? ?? 83 C4 0C EB 60 83 7D 0C 00 7D 5A 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 83 E9 01 83 E1 07 C1 E1 0B 8B 55 A4 8B 02 25 FF C7 FF FF 0B C1 8B 4D A4 89 01 6A 00 8B 55 A4 8B 02 C1 E8 0B 83 E0 07 50 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 46 8B 55 08 83 C2 1C 52 8B 45 08 83 C0 26 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "__AdjustLocation"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 89 45 F8 83 7D F8 00 7C 22 83 7D F8 07 7E 02 EB 1A 8B 4D 08 2B 4D 0C 89 4D FC 78 06 83 7D FC 07 7E 07 C7 45 FC 1F 00 00 00 EB 06 8B 55 08 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "__PreventStackOverwrite"
		size = 72
		refs = "000b __IsMemoryLocation"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 2B 8B 4D 08 8B 55 08 8B 81 C4 00 00 00 3B 42 30 76 1A 54 58 89 45 FC 8B 4D 08 8B 51 30 83 C2 04 39 55 FC 77 07 C7 45 0C 1F 00 00 00 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "__IsMemoryLocation"
		size = 39
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 83 7D FC 0A 7C 0F 83 7D FC 10 7E 02 EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "__GetFpRegVal"
		size = 94
		refs = "003f __zero80"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 7C 2F 83 7D 10 08 7D 29 8B 45 10 6B C0 0A 8B 4D 0C 8D 54 01 1C 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 8B 45 08 EB 24 EB 22 8B 45 08 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 66 8B 0D ?? ?? ?? ?? 66 89 48 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "__SetFpRegVal"
		size = 203
		refs = "00c0 __SetTag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 83 C0 04 89 45 F4 83 7D 0C 00 0F 8C AC 00 00 00 83 7D 0C 08 0F 8D A2 00 00 00 8B 4D 10 8B 55 0C 6B D2 0A 8B 45 08 8D 54 10 1C 8B 01 89 02 8B 41 04 89 42 04 66 8B 49 08 66 89 4A 08 8B 55 F4 8B 02 C1 E8 0B 83 E0 07 03 45 0C 33 D2 B9 08 00 00 00 F7 F1 89 55 F8 8B 55 10 0F B7 42 08 25 FF 7F 00 00 89 45 F0 74 0B 81 7D F0 FF 7F 00 00 74 25 EB 2C 8B 4D 10 83 39 00 75 12 8B 55 10 83 7A 04 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 02 00 00 00 EB 10 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D F8 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "__SetTag"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C D1 E0 89 45 F8 BA 03 00 00 00 8B 4D F8 D3 E2 89 55 FC 8B 45 10 8B 4D F8 D3 E0 89 45 10 8B 4D FC F7 D1 8B 55 08 23 0A 8B 45 10 23 45 FC 0B C8 8B 55 08 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "___mtold12"
		size = 338
		refs = "0009 ___security_cookie 006b ___shl_12 0087 ___add_12 014a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 F8 B8 4E 40 00 00 66 89 45 FC 8B 4D 10 C7 01 00 00 00 00 8B 55 10 C7 42 04 00 00 00 00 8B 45 10 C7 40 08 00 00 00 00 EB 12 8B 4D 0C 83 E9 01 89 4D 0C 8B 55 08 83 C2 01 89 55 08 83 7D 0C 00 76 74 8B 45 10 8B 08 89 4D EC 8B 50 04 89 55 F0 8B 40 08 89 45 F4 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8D 45 EC 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 0F BE 08 89 4D EC C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 8D 55 EC 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 E9 74 FF FF FF 8B 4D 10 83 79 08 00 75 42 8B 55 10 8B 42 04 C1 E8 10 8B 4D 10 89 41 08 8B 55 10 8B 42 04 C1 E0 10 8B 4D 10 8B 11 C1 EA 10 0B C2 8B 4D 10 89 41 04 8B 55 10 8B 02 C1 E0 10 8B 4D 10 89 01 0F B7 55 FC 83 EA 10 66 89 55 FC EB B5 8B 45 10 8B 48 08 81 E1 00 80 00 00 75 1A 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 66 8B 45 FC 66 83 E8 01 66 89 45 FC EB D8 8B 4D 10 66 8B 55 FC 66 89 51 0A 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "___add_12"
		size = 175
		refs = "0019 ___addl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 30 8B 55 08 83 C2 04 52 6A 01 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 0F 8B 55 08 8B 42 08 83 C0 01 8B 4D 08 89 41 08 8B 55 08 83 C2 04 52 8B 45 0C 8B 48 04 51 8B 55 08 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 0F 8B 4D 08 8B 51 08 83 C2 01 8B 45 08 89 50 08 8B 4D 08 83 C1 08 51 8B 55 0C 8B 42 08 50 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "___addl"
		size = 64
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8B 45 08 03 45 0C 89 45 F8 8B 4D F8 3B 4D 08 72 08 8B 55 F8 3B 55 0C 73 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D 10 8B 55 F8 89 11 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "___shl_12"
		size = 98
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 8B 08 81 E1 00 00 00 80 F7 D9 1B C9 F7 D9 89 4D FC 8B 55 08 8B 42 04 25 00 00 00 80 F7 D8 1B C0 F7 D8 89 45 F8 8B 4D 08 8B 11 D1 E2 8B 45 08 89 10 8B 4D 08 8B 51 04 D1 E2 0B 55 FC 8B 45 08 89 50 04 8B 4D 08 8B 51 08 D1 E2 0B 55 F8 8B 45 08 89 50 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_clearerr_s"
		size = 337
		refs = "0008 __sehtable$_clearerr_s 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GE@OJGFJACJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BG@GHDODAOE@?$AAc?$AAl?$AAe?$AAa?$AAr?$AAe?$AAr?$AAr?$AA_?$AAs?$AA?$AA@ 0087 __invalid_parameter 009d __lock_file 00bf __fileno 0102 ___pioinfo 010e ___badioinfo 0135 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 A7 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 8B 48 0C 83 E1 CF 8B 55 08 89 4A 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 E0 EB 07 C7 45 E0 ?? ?? ?? ?? 8B 4D E0 0F BE 51 04 83 E2 FD 8B 45 E0 88 50 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "_clearerr"
		size = 19
		refs = "000a _clearerr_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_486_26_0 {
	meta:
		name = "??2CacheLocalScheduleGroup@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_161_0 {
	meta:
		name = "??2ExternalContextBase@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_486_37_0 {
	meta:
		name = "??2FairScheduleGroup@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_635_30_0 {
	meta:
		name = "??2ThreadInternalContext@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_689_19_0 {
	meta:
		name = "??2UMSThreadInternalContext@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_671_50_0 {
	meta:
		name = "??2WorkQueue@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_20_61_2 {
	meta:
		name = "??2_AllocBase@details@Concurrency@@SAPAXI@Z"
		size = 19
		refs = "000a ?Alloc@Concurrency@@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_581_0_6 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_486_27_0 {
	meta:
		name = "??3CacheLocalScheduleGroup@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_100_14_0 {
	meta:
		name = "??3Context@Concurrency@@KAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_162_0 {
	meta:
		name = "??3ExternalContextBase@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_486_38_0 {
	meta:
		name = "??3FairScheduleGroup@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_28_11_0 {
	meta:
		name = "??3ScheduleGroup@Concurrency@@KAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_635_31_0 {
	meta:
		name = "??3ThreadInternalContext@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_655_9_0 {
	meta:
		name = "??3UMSThreadInternalContext@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_671_51_0 {
	meta:
		name = "??3WorkQueue@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_68_62_1 {
	meta:
		name = "??3_AllocBase@details@Concurrency@@SAXPAX@Z"
		size = 19
		refs = "000a ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_36_163_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAX@Z"
		size = 19
		refs = "000a ??$_DebugHeapDelete@Vfacet@locale@std@@@std@@YAXPAVfacet@locale@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_80_205_2 {
	meta:
		name = "??3facet@locale@std@@SAXPAXABU_DebugHeapTag_t@2@PADH@Z"
		size = 19
		refs = "000a ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_94_0_2 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "??_V@YAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1604_0_6 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 19
		refs = "000a ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_671_152_0 {
	meta:
		name = "?Alloc@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_339_0 {
	meta:
		name = "?Alloc@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_144_30_0 {
	meta:
		name = "?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
		size = 19
		refs = "000a ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_100_124_0 {
	meta:
		name = "?Free@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_340_0 {
	meta:
		name = "?Free@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_221_87_0 {
	meta:
		name = "?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
		size = 19
		refs = "000a ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_2_0 {
	meta:
		name = "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 19
		refs = "000a ?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_55_211_2 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 19
		refs = "000a _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_84_966_1 {
	meta:
		name = "?length@?$char_traits@G@std@@SAIPBG@Z"
		size = 19
		refs = "000a _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_9_666_2 {
	meta:
		name = "?length@?$char_traits@_W@std@@SAIPB_W@Z"
		size = 19
		refs = "000a _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_51_0_1 {
	meta:
		name = "__LDtest"
		size = 19
		refs = "000a __Dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_367_5_0 {
	meta:
		name = "___free_locale"
		size = 19
		refs = "000a __free_locale"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_264_57_0 {
	meta:
		name = "__aligned_free"
		size = 19
		refs = "000a __aligned_free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_489_2_0 {
	meta:
		name = "__ftime32"
		size = 19
		refs = "000a __ftime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_328_2_0 {
	meta:
		name = "__ftime64"
		size = 19
		refs = "000a __ftime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_352_8_0 {
	meta:
		name = "__inc"
		size = 19
		refs = "000a __fgetwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_90_1_0 {
	meta:
		name = "__unlink"
		size = 19
		refs = "000a _remove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_676_2_0 {
	meta:
		name = "__wtoi"
		size = 19
		refs = "000a __wtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_861_1_0 {
	meta:
		name = "__wunlink"
		size = 19
		refs = "000a __wremove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_325_2_0 {
	meta:
		name = "_atoi"
		size = 19
		refs = "000a _atol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_getwc"
		size = 19
		refs = "000a _fgetwc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_640_1_0 {
	meta:
		name = "_putchar"
		size = 19
		refs = "000a __fputchar"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__strnset"
		size = 43
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 12 F2 AE 75 03 83 C1 01 2B D9 8B CB 8B FA 8A 45 0C F3 AA 8B C2 5B 5F C9 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "___libm_sse2_sinf"
		size = 335
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 010a _ONE_M230 0139 _sin"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 00 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_fgetwc"
		size = 233
		refs = "0008 __sehtable$_fgetwc 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GA@GEOKFMMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1O@CGPBPCOK@?$AAf?$AAg?$AAe?$AAt?$AAw?$AAc?$AA?$AA@ 0087 __invalid_parameter 009a __lock_file 00ad __fgetwc_nolock 00cb __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF 00 00 EB 42 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__fgetwc_nolock"
		size = 865
		refs = "001d __fileno 0060 ___pioinfo 006c ___badioinfo 00cb __filbuf 025a _isleadbyte 02c5 _ungetc 02f0 _mbtowc 02fd __errno 0355 __filwbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C 56 8B 45 08 8B 48 0C 83 E1 40 0F 85 55 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 E0 EB 07 C7 45 E0 ?? ?? ?? ?? 8B 45 E0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 0F 84 E8 00 00 00 8D 45 F8 89 45 FC 8B 4D 08 8B 51 04 83 EA 01 89 55 DC 8B 45 08 8B 4D DC 89 48 04 83 7D DC 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D D8 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 45 D8 89 45 F4 83 7D F4 FF 75 0A B8 FF FF 00 00 E9 71 02 00 00 8B 4D FC 8A 55 F4 88 11 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 51 04 83 EA 01 89 55 D4 8B 45 08 8B 4D D4 89 48 04 83 7D D4 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D D0 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 8B 45 D0 89 45 F4 83 7D F4 FF 75 0A B8 FF FF 00 00 E9 00 02 00 00 8B 4D FC 8A 55 F4 88 11 66 8B 45 F8 E9 EF 01 00 00 8B 45 08 8B 48 0C 83 E1 40 0F 85 98 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 45 CC 0F BE 48 04 81 E1 80 00 00 00 0F 84 2D 01 00 00 C7 45 F0 01 00 00 00 8B 55 08 8B 42 04 83 E8 01 89 45 C8 8B 4D 08 8B 55 C8 89 51 04 83 7D C8 00 7C 20 8B 45 08 8B 08 0F BE 11 81 E2 FF 00 00 00 89 55 C4 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A EB 0F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 C4 8B 4D C4 89 4D E4 83 7D E4 FF 75 0A B8 FF FF 00 00 E9 0E 01 00 00 8A 55 E4 88 55 E8 0F B6 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 7E 8B 4D 08 8B 51 04 83 EA 01 89 55 C0 8B 45 08 8B 4D C0 89 48 04 83 7D C0 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D BC 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 BC 8B 45 BC 89 45 E4 83 7D E4 FF 75 1B 8B 4D 08 51 0F BE 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 B8 FF FF 00 00 E9 86 00 00 00 8A 45 E4 88 45 E9 C7 45 F0 02 00 00 00 8B 4D F0 51 8D 55 E8 52 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 B8 FF FF 00 00 EB 4E 66 8B 45 EC EB 48 8B 4D 08 8B 51 04 83 EA 02 89 55 B8 8B 45 08 8B 4D B8 89 48 04 83 7D B8 00 7C 21 8B 55 08 8B 02 66 8B 08 66 89 4D B6 8B 55 08 8B 02 83 C0 02 8B 4D 08 89 01 66 8B 45 B6 EB 0E EB 0C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__wcstoi64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "__strtoi64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "_strtol"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 1324
		refs = "0008 __ehhandler$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0019 ___security_cookie 0031 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005d ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0066 ??_C@_1GA@OFLNHKCJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d __CrtDbgReportW 0081 __errno 0095 ??_C@_1BA@FACINJJA@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAx?$AAq?$AA?$AA@ 009f __invalid_parameter 00bf ??1_LocaleUpdate@@QAE@XZ 00fd ??_C@_1FE@CEHLKAHD@?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAi?$AAb?$AAa@ 019d _iswctype 0256 __wchartodigit 02e4 __aulldiv 03a7 __aullrem 03d8 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 70 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 45 08 50 8D 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 7D 10 00 74 08 8B 4D 10 8B 55 0C 89 11 33 C0 83 7D 0C 00 0F 95 C0 89 45 C0 83 7D C0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B4 00 00 00 00 C7 45 B8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 B4 8B 55 B8 E9 4D 04 00 00 83 7D 14 00 74 15 83 7D 14 02 7C 06 83 7D 14 24 7E 09 C7 45 98 00 00 00 00 EB 07 C7 45 98 01 00 00 00 8B 55 98 89 55 BC 83 7D BC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 60 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 AC 00 00 00 00 C7 45 B0 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 AC 8B 55 B0 E9 AD 03 00 00 8B 4D 0C 89 4D F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 8B 55 F0 66 8B 02 66 89 45 E0 8B 4D F0 83 C1 02 89 4D F0 6A 08 0F B7 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 15 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 EB D8 0F B7 45 E0 83 F8 2D 75 1E 8B 4D 18 83 C9 02 89 4D 18 8B 55 F0 66 8B 02 66 89 45 E0 8B 4D F0 83 C1 02 89 4D F0 EB 1C 0F B7 55 E0 83 FA 2B 75 13 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 83 7D 14 00 7C 0C 83 7D 14 01 74 06 83 7D 14 24 7E 38 83 7D 10 00 74 08 8B 45 10 8B 4D 0C 89 08 C7 45 A4 00 00 00 00 C7 45 A8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 A4 8B 55 A8 E9 D3 02 00 00 EB 46 83 7D 14 00 75 40 0F B7 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 14 0A 00 00 00 EB 26 8B 45 F0 0F B7 08 83 F9 78 74 0B 8B 55 F0 0F B7 02 83 F8 58 75 09 C7 45 14 10 00 00 00 EB 07 C7 45 14 08 00 00 00 83 7D 14 10 75 43 0F B7 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 32 8B 55 F0 0F B7 02 83 F8 78 74 0B 8B 4D F0 0F B7 11 83 FA 58 75 1C 8B 45 F0 83 C0 02 89 45 F0 8B 4D F0 66 8B 11 66 89 55 E0 8B 45 F0 83 C0 02 89 45 F0 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 45 E4 89 55 E8 0F B7 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 7D EC FF 74 02 EB 59 0F B7 55 E0 83 FA 41 7C 09 0F B7 45 E0 83 F8 5A 7E 12 0F B7 4D E0 83 F9 61 7C 39 0F B7 55 E0 83 FA 7A 7F 30 0F B7 45 E0 83 F8 61 7C 15 0F B7 4D E0 83 F9 7A 7F 0C 0F B7 55 E0 83 EA 20 89 55 94 EB 07 0F B7 45 E0 89 45 94 8B 4D 94 83 E9 37 89 4D EC EB 05 E9 B7 00 00 00 8B 55 EC 3B 55 14 72 05 E9 AA 00 00 00 8B 45 18 83 C8 08 89 45 18 8B 4D C8 3B 4D E8 72 4C 77 08 8B 55 C4 3B 55 E4 72 42 8B 45 C4 3B 45 E4 75 5E 8B 4D C8 3B 4D E8 75 56 8B 75 EC 33 FF 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 75 8C 89 7D 90 89 45 84 89 55 88 8B 55 90 3B 55 88 77 2E 72 08 8B 45 8C 3B 45 84 77 24 8B 45 14 99 52 50 8B 4D C8 51 8B 55 C4 52 E8 ?? ?? ?? ?? 8B 4D EC 33 F6 03 C1 13 D6 89 45 C4 89 55 C8 EB 11 8B 55 18 83 CA 04 89 55 18 83 7D 10 00 75 02 EB 18 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 E9 D8 FE FF FF 8B 45 F0 83 E8 02 89 45 F0 8B 4D 18 83 E1 08 75 1F 83 7D 10 00 74 06 8B 55 0C 89 55 F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 E9 8B 00 00 00 8B 45 18 83 E0 04 75 3A 8B 4D 18 83 E1 01 75 7B 8B 55 18 83 E2 02 74 11 81 7D C8 00 00 00 80 77 21 72 06 83 7D C4 00 77 19 8B 45 18 83 E0 02 75 5A 81 7D C8 FF FF FF 7F 72 51 77 06 83 7D C4 FF 76 49 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 18 83 E1 01 74 10 C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF FF EB 26 8B 55 18 83 E2 02 74 10 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 80 EB 0E C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF 7F 83 7D 10 00 74 08 8B 45 10 8B 4D F0 89 08 8B 55 18 83 E2 02 74 13 8B 45 C4 F7 D8 8B 4D C8 83 D1 00 F7 D9 89 45 C4 89 4D C8 8B 55 C4 89 55 9C 8B 45 C8 89 45 A0 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 9C 8B 55 A0 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "__ehhandler$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 217
		refs = "001b __getptd 0049 ___ptlocinfo 005a ___globallocalestatus 0061 ___updatetlocinfo 0072 ___ptmbcinfo 008a ___updatetmbcinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 0F 85 A6 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 08 8B 55 FC 8B 42 08 8B 4D FC 8B 50 6C 89 11 8B 45 FC 8B 48 08 8B 55 FC 8B 41 68 89 42 04 8B 4D FC 8B 11 3B 15 ?? ?? ?? ?? 74 1B 8B 45 FC 8B 48 08 8B 51 70 23 15 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 42 04 3B 05 ?? ?? ?? ?? 74 1C 8B 4D FC 8B 51 08 8B 42 70 23 05 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 8B 42 08 8B 48 70 83 E1 02 75 1C 8B 55 FC 8B 42 08 8B 48 70 83 C9 02 8B 55 FC 8B 42 08 89 48 70 8B 4D FC C6 41 0C 01 EB 10 8B 55 08 8B 02 8B 4A 04 8B 55 FC 89 02 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_5_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 15 8B 55 FC 8B 42 08 8B 48 70 83 E1 FD 8B 55 FC 8B 42 08 89 48 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_6_0 {
	meta:
		name = "__wcstoi64_l"
		size = 33
		refs = "0018 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_526_7_0 {
	meta:
		name = "__strtoi64_l"
		size = 33
		refs = "0018 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_391_7_0 {
	meta:
		name = "__strtol_l"
		size = 33
		refs = "0018 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_7_0 {
	meta:
		name = "__wcstoui64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_526_8_0 {
	meta:
		name = "__strtoui64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_391_8_0 {
	meta:
		name = "_strtoul"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_8_0 {
	meta:
		name = "__wcstoui64_l"
		size = 33
		refs = "0018 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_526_9_0 {
	meta:
		name = "__strtoui64_l"
		size = 33
		refs = "0018 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_391_9_0 {
	meta:
		name = "__strtoul_l"
		size = 33
		refs = "0018 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__except_handler3"
		size = 254
		refs = "0035 __ValidateEH3RN 007a _CallDestructExceptionObject 0086 __global_unwind2 0093 __local_unwind2 00a4 __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 C3 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 0F 8E 8F 00 00 00 83 FE FF 0F 84 8D 00 00 00 8D 0C 76 8B 44 8F 04 0B C0 74 66 56 55 8D 6B 10 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 5D 5E 8B 5D 0C 0B C0 74 4C 78 58 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 08 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C 8B 44 8F 08 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 8B 7B 08 8D 0C 76 8B 34 8F E9 78 FF FF FF B8 00 00 00 00 EB 23 8B 45 08 83 48 04 08 B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__snprintf"
		size = 449
		refs = "003f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0048 ??_C@_1GC@BMNPEKNN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004f __CrtDbgReportW 0063 __errno 0077 ??_C@_1BE@CHNFPLHD@?$AA_?$AAs?$AAn?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0081 __invalid_parameter 00b9 ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 0158 __output_l 01b0 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 C7 45 D4 00 00 00 00 33 C0 89 45 D8 89 45 DC 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 8D 4D D4 89 4D F4 33 D2 83 7D 10 00 0F 95 C2 89 55 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2D 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 4D C8 89 4D CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B3 00 00 00 8D 45 14 89 45 FC 81 7D 0C FF FF FF 7F 76 0C 8B 4D F4 C7 41 04 FF FF FF 7F EB 09 8B 55 F4 8B 45 0C 89 42 04 8B 4D F4 C7 41 0C 42 00 00 00 8B 55 F4 8B 45 08 89 42 08 8B 4D F4 8B 55 08 89 11 8B 45 FC 50 6A 00 8B 4D 10 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 05 8B 45 F8 EB 50 8B 45 F4 8B 48 04 83 E9 01 89 4D C4 8B 55 F4 8B 45 C4 89 42 04 83 7D C4 00 7C 21 8B 4D F4 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 C0 8B 4D F4 8B 11 83 C2 01 8B 45 F4 89 10 EB 11 8B 4D F4 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__snprintf_l"
		size = 44
		refs = "0021 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_415_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 44
		refs = "0021 __vsnprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 44
		refs = "0021 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_358_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 44
		refs = "0021 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_358_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 44
		refs = "0021 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_799_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 44
		refs = "0021 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_360_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 44
		refs = "0021 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_360_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 44
		refs = "0021 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_825_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_714_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_825_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_661_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_714_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_672_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_491_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_675_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__execvp"
		size = 25
		refs = "0010 __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_79_755_3 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 25
		refs = "0010 ??$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_68_750_1 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 25
		refs = "0010 ??$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_79_756_3 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 25
		refs = "0010 ??$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 25
		refs = "0010 __aligned_offset_malloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_499_4_0 {
	meta:
		name = "__atodbl"
		size = 25
		refs = "0010 __atodbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_499_8_0 {
	meta:
		name = "__atoflt"
		size = 25
		refs = "0010 __atoflt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_499_6_0 {
	meta:
		name = "__atoldbl"
		size = 25
		refs = "0010 __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_879_1_0 {
	meta:
		name = "__getws_s"
		size = 25
		refs = "0010 __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_716_4_0 {
	meta:
		name = "__ismbslead"
		size = 25
		refs = "0010 __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_282_4_0 {
	meta:
		name = "__ismbstrail"
		size = 25
		refs = "0010 __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_904_4_0 {
	meta:
		name = "__mbsbtype"
		size = 25
		refs = "0010 __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_414_4_0 {
	meta:
		name = "__mbschr"
		size = 25
		refs = "0010 __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_435_4_0 {
	meta:
		name = "__mbscmp"
		size = 25
		refs = "0010 __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_513_4_0 {
	meta:
		name = "__mbscoll"
		size = 25
		refs = "0010 __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_230_4_0 {
	meta:
		name = "__mbscspn"
		size = 25
		refs = "0010 __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_805_4_0 {
	meta:
		name = "__mbsdec"
		size = 25
		refs = "0010 __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_606_4_0 {
	meta:
		name = "__mbsicmp"
		size = 25
		refs = "0010 __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_568_4_0 {
	meta:
		name = "__mbsicoll"
		size = 25
		refs = "0010 __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_142_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 25
		refs = "0010 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_343_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 25
		refs = "0010 __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_972_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 25
		refs = "0010 __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_679_1_0 {
	meta:
		name = "__mbsninc"
		size = 25
		refs = "0010 __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_837_4_0 {
	meta:
		name = "__mbsnlen"
		size = 25
		refs = "0010 __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_395_4_0 {
	meta:
		name = "__mbspbrk"
		size = 25
		refs = "0010 __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_401_4_0 {
	meta:
		name = "__mbsrchr"
		size = 25
		refs = "0010 __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_219_4_0 {
	meta:
		name = "__mbsset"
		size = 25
		refs = "0010 __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_114_4_0 {
	meta:
		name = "__mbsspn"
		size = 25
		refs = "0010 __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_425_4_0 {
	meta:
		name = "__mbsspnp"
		size = 25
		refs = "0010 __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_524_4_0 {
	meta:
		name = "__mbsstr"
		size = 25
		refs = "0010 __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_500_1_0 {
	meta:
		name = "__mbstok"
		size = 25
		refs = "0010 __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_286_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 25
		refs = "0010 __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_650_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 25
		refs = "0010 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_611_9_0 {
	meta:
		name = "__strlwr_s"
		size = 25
		refs = "0010 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_732_9_0 {
	meta:
		name = "__strupr_s"
		size = 25
		refs = "0010 __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_809_9_0 {
	meta:
		name = "__wcslwr_s"
		size = 25
		refs = "0010 __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_354_9_0 {
	meta:
		name = "__wcsupr_s"
		size = 25
		refs = "0010 __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_982_0_0 {
	meta:
		name = "__wexecvp"
		size = 25
		refs = "0010 __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_651_1_0 {
	meta:
		name = "_gets_s"
		size = 25
		refs = "0010 __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_715_4_0 {
	meta:
		name = "_strcoll"
		size = 25
		refs = "0010 __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_284_4_0 {
	meta:
		name = "_strtod"
		size = 25
		refs = "0010 __strtod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_509_4_0 {
	meta:
		name = "_wcstod"
		size = 25
		refs = "0010 __wcstod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__findfirst32i64"
		size = 725
		refs = "000c ___security_cookie 002f ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0038 ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003f __CrtDbgReportW 0056 __errno 006a ??_C@_1CA@CBALGFIN@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0074 __invalid_parameter 0097 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0104 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 016d __imp__FindFirstFileExA@24 017c __imp__GetLastError@0 01b3 $LN15 01ba $LN16 020e ___timet_from_ft 0254 __allmul 027c ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 0294 _strcpy_s 029d __invoke_watson_if_error 02ae @__security_check_cookie@4 02b8 $LN3 02bc $LN2 02c0 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 56 33 C0 83 7D 0C 00 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 24 02 00 00 C7 85 AC FE FF FF 01 00 00 00 83 BD AC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BC 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 A8 FE FF FF 83 BD A8 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 4F 01 00 00 6A 00 6A 00 6A 00 8D 95 B8 FE FF FF 52 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BC 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D4 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 FE FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 5E 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 40
		refs = "0022 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 EB 19 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "__findnext32i64"
		size = 733
		refs = "000c ___security_cookie 002f ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 003b ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0042 __CrtDbgReportW 0059 __errno 0070 ??_C@_1BO@BOILMGOI@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 007a __invalid_parameter 00a2 ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0110 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0177 __imp__FindNextFileA@8 0181 __imp__GetLastError@0 01b8 $LN15 01bf $LN16 0213 ___timet_from_ft 0259 __allmul 0284 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 029c _strcpy_s 02a5 __invoke_watson_if_error 02b5 @__security_check_cookie@4 02c0 $LN3 02c4 $LN2 02c8 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 FF 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 25 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 AC FE FF FF 83 BD AC FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B2 01 00 00 C7 85 A8 FE FF FF 01 00 00 00 83 BD A8 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 44 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BE 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D4 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 FE FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__splitpath_s"
		size = 1563
		refs = "0102 _strncpy_s 013d ___crtDebugFillThreshold 0168 _memset 01a0 __ismbblead 0531 ??_C@_1CI@MLPLHPBP@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAP?$AAa?$AAt?$AAh?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 053d ??_C@_1HA@GHKPFCBF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0544 __CrtDbgReportW 0558 __errno 056f ??_C@_1BK@GOODFINI@?$AA_?$AAs?$AAp?$AAl?$AAi?$AAt?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 0579 __invalid_parameter 05b1 ??_C@_1DE@MLEJGPLF@?$AA?$CI?$AAL?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 E8 00 00 00 00 83 7D 08 00 75 05 E9 6F 03 00 00 83 7D 0C 00 75 06 83 7D 10 00 75 0C 83 7D 0C 00 74 0B 83 7D 10 00 75 05 E9 52 03 00 00 83 7D 14 00 75 06 83 7D 18 00 75 0C 83 7D 14 00 74 0B 83 7D 18 00 75 05 E9 35 03 00 00 83 7D 1C 00 75 06 83 7D 20 00 75 0C 83 7D 1C 00 74 0B 83 7D 20 00 75 05 E9 18 03 00 00 83 7D 24 00 75 06 83 7D 28 00 75 0C 83 7D 24 00 74 0B 83 7D 28 00 75 05 E9 FB 02 00 00 83 7D F4 00 0F 85 C9 00 00 00 C7 45 E4 01 00 00 00 8B 45 08 89 45 EC 83 7D E4 00 76 1E 8B 4D EC 0F BE 11 85 D2 74 14 8B 45 E4 83 E8 01 89 45 E4 8B 4D EC 83 C1 01 89 4D EC EB DC 8B 55 EC 0F BE 02 83 F8 3A 75 32 83 7D 0C 00 74 21 83 7D 10 03 73 05 E9 AB 02 00 00 6A 02 8B 4D 08 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D EC 83 C1 01 89 4D 08 EB 5B 83 7D 0C 00 74 55 8B 55 0C C6 02 00 83 7D 10 FF 74 49 81 7D 10 FF FF FF 7F 74 40 83 7D 10 01 76 3A 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D8 EB 09 8B 55 10 83 EA 01 89 55 D8 8B 45 D8 50 68 FE 00 00 00 8B 4D 0C 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 F0 00 00 00 00 C7 45 FC 00 00 00 00 8B 55 08 89 55 EC EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D EC 0F BE 11 85 D2 74 52 8B 45 EC 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0B 8B 55 EC 83 C2 01 89 55 EC EB 32 8B 45 EC 0F BE 08 83 F9 2F 74 0B 8B 55 EC 0F BE 02 83 F8 5C 75 0B 8B 4D EC 83 C1 01 89 4D F0 EB 11 8B 55 EC 0F BE 02 83 F8 2E 75 06 8B 4D EC 89 4D FC EB 9B 83 7D F0 00 74 3C 83 7D 14 00 74 2E 8B 55 F0 2B 55 08 89 55 F8 8B 45 18 3B 45 F8 77 05 E9 92 01 00 00 8B 4D F8 51 8B 55 08 52 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F0 89 55 08 EB 5B 83 7D 14 00 74 55 8B 45 14 C6 00 00 83 7D 18 FF 74 49 81 7D 18 FF FF FF 7F 74 40 83 7D 18 01 76 3A 8B 4D 18 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D4 EB 09 8B 45 18 83 E8 01 89 45 D4 8B 4D D4 51 68 FE 00 00 00 8B 55 14 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 75 8B 45 FC 3B 45 08 72 6D 83 7D 1C 00 74 2E 8B 4D FC 2B 4D 08 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 ED 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 2E 8B 4D EC 2B 4D FC 89 4D F8 8B 55 28 3B 55 F8 77 05 E9 B9 00 00 00 8B 45 F8 50 8B 4D FC 51 8B 55 28 52 8B 45 24 50 E8 ?? ?? ?? ?? 83 C4 10 E9 8E 00 00 00 83 7D 1C 00 74 2E 8B 4D EC 2B 4D 08 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 80 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 54 8B 4D 24 C6 01 00 83 7D 28 FF 74 48 81 7D 28 FF FF FF 7F 74 3F 83 7D 28 01 76 39 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D0 EB 09 8B 4D 28 83 E9 01 89 4D D0 8B 55 D0 52 68 FE 00 00 00 8B 45 24 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 80 02 00 00 C7 45 E8 01 00 00 00 83 7D 0C 00 74 5A 83 7D 10 00 76 54 8B 4D 0C C6 01 00 83 7D 10 FF 74 48 81 7D 10 FF FF FF 7F 74 3F 83 7D 10 01 76 39 8B 55 10 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 CC EB 09 8B 4D 10 83 E9 01 89 4D CC 8B 55 CC 52 68 FE 00 00 00 8B 45 0C 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 5A 83 7D 18 00 76 54 8B 4D 14 C6 01 00 83 7D 18 FF 74 48 81 7D 18 FF FF FF 7F 74 3F 83 7D 18 01 76 39 8B 55 18 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C8 EB 09 8B 4D 18 83 E9 01 89 4D C8 8B 55 C8 52 68 FE 00 00 00 8B 45 14 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 1C 00 74 5A 83 7D 20 00 76 54 8B 4D 1C C6 01 00 83 7D 20 FF 74 48 81 7D 20 FF FF FF 7F 74 3F 83 7D 20 01 76 39 8B 55 20 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C4 EB 09 8B 4D 20 83 E9 01 89 4D C4 8B 55 C4 52 68 FE 00 00 00 8B 45 1C 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 24 00 74 5A 83 7D 28 00 76 54 8B 4D 24 C6 01 00 83 7D 28 FF 74 48 81 7D 28 FF FF FF 7F 74 3F 83 7D 28 01 76 39 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C0 EB 09 8B 4D 28 83 E9 01 89 4D C0 8B 55 C0 52 68 FE 00 00 00 8B 45 24 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D5 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8D 00 00 00 83 7D E8 00 74 77 33 C0 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 4D BC 89 4D DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 22 00 00 00 B8 22 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "___libm_sse2_log10f"
		size = 377
		refs = "0004 _dword_mask 000c _SIGMASK 0018 _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_Tbl 00cc _L102 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F 6F F8 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_rename"
		size = 71
		refs = "0010 __imp__MoveFileA@8 001a __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_680_0_0 {
	meta:
		name = "__wrename"
		size = 71
		refs = "0010 __imp__MoveFileW@8 001a __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 224
		refs = "0018 ___security_cookie 0038 ___security_cookie_complement 0047 __imp__GetSystemTimeAsFileTime@4 005c __imp__GetCurrentProcessId@0 0068 __imp__GetCurrentThreadId@0 0074 __imp__GetTickCount@0 0084 __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 81 3D ?? ?? ?? ?? 4E E6 40 BB 74 1F A1 ?? ?? ?? ?? 25 00 00 FF FF 74 13 8B 0D ?? ?? ?? ?? F7 D1 89 0D ?? ?? ?? ?? E9 9B 00 00 00 8D 55 F8 52 FF 15 ?? ?? ?? ?? 8B 45 F8 89 45 F4 8B 4D F4 33 4D FC 89 4D F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 8D 55 E8 52 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 E8 89 45 F4 8B 4D F4 33 4D EC 89 4D F4 81 7D F4 4E E6 40 BB 75 09 C7 45 F4 4F E6 40 BB EB 1C 8B 55 F4 81 E2 00 00 FF FF 75 11 8B 45 F4 0D 11 47 00 00 C1 E0 10 0B 45 F4 89 45 F4 8B 4D F4 89 0D ?? ?? ?? ?? 8B 55 F4 F7 D2 89 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__87except"
		size = 432
		refs = "001f ___security_cookie 0054 $LN19 00b1 __handle_exc 0121 __raise_exc 0134 __ctrlfp 014f __matherr_flag 015b __matherr 0178 __set_errno_from_matherr 0185 @__security_check_cookie@4 0190 $LN14 0194 $LN11 0198 $LN13 019c $LN12 01a4 $LN8 01a8 $LN9 01ac $LN10"
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC A0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 0F B7 08 89 4D F8 8D 55 F8 89 55 F4 8B 43 0C 8B 08 89 4D F0 8B 55 F0 83 EA 01 89 55 F0 83 7D F0 07 77 40 8B 45 F0 FF 24 85 ?? ?? ?? ?? C7 45 EC 08 00 00 00 EB 34 C7 45 EC 11 00 00 00 EB 2B C7 45 EC 12 00 00 00 EB 22 C7 45 EC 04 00 00 00 EB 19 C7 45 EC 10 00 00 00 EB 10 8B 4B 0C C7 01 01 00 00 00 C7 45 EC 00 00 00 00 83 7D EC 00 0F 84 89 00 00 00 8B 55 F4 8B 02 50 8B 4B 0C 83 C1 18 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6C 8B 43 08 89 45 E8 83 7D E8 10 74 0E 83 7D E8 16 74 08 83 7D E8 1D 74 02 EB 20 8B 4D B0 83 C9 01 89 4D B0 8B 55 B0 83 E2 E1 83 CA 02 89 55 B0 8B 43 0C DD 40 10 DD 5D A0 EB 09 8B 4D B0 83 E1 FE 89 4D B0 8B 53 0C 83 C2 18 52 8B 43 0C 83 C0 08 50 8B 4B 08 51 8B 55 EC 52 8B 45 F4 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 C7 85 6C FF FF FF 00 00 00 00 8B 4B 0C 83 39 08 74 1B 83 3D ?? ?? ?? ?? 00 75 12 8B 53 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FF FF FF 83 BD 6C FF FF FF 00 75 0E 8B 43 0C 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__wexecve"
		size = 1241
		refs = "0028 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0034 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003b __CrtDbgReportW 004f __errno 0066 ??_C@_1BC@EKDLGEAB@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAv?$AAe?$AA?$AA@ 0070 __invalid_parameter 0091 ??_C@_1CE@CONABGGG@?$AA?$CK?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00fb ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0167 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01d2 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0230 _wcsrchr 0266 _wcschr 027f _wcslen 0292 ??_C@_0DB@JOMLOMIN@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 029f __calloc_dbg 02c9 ??_C@_1FE@EDEBHNHE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 02ce ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 02db _wcscpy_s 02e4 __invoke_watson_if_error 02fd ??_C@_1FA@KFCDCBOG@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 030e _wcscat_s 0362 __waccess_s 037a _wcomexecmd 03d8 ??_C@_1DI@MLPIPGLK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 0442 ??_C@_1GA@NDGMJEBK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAe?$AAx?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAe?$AAx?$AAt?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5@ 044c _ext_strings 04b5 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8B 45 08 89 45 F0 C7 45 E4 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 56 04 00 00 8B 45 08 0F B7 08 F7 D9 1B C9 F7 D9 89 4D DC 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 ED 03 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 83 03 00 00 8B 55 0C 33 C0 83 3A 00 0F 95 C0 89 45 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 17 03 00 00 8B 55 0C 8B 02 0F B7 08 F7 D9 1B C9 F7 D9 89 4D D0 75 21 68 ?? ?? ?? ?? 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AC 02 00 00 6A 5C 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 6A 2F 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 0F 85 D4 00 00 00 83 7D FC 00 0F 85 C8 00 00 00 6A 3A 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 0F 85 AD 00 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 03 89 45 CC 68 F3 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F0 83 7D F0 00 75 08 83 C8 FF E9 1E 02 00 00 6A 00 68 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 51 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F0 83 C1 04 89 4D FC EB 14 83 7D FC 00 74 08 8B 55 EC 3B 55 FC 76 06 8B 45 EC 89 45 FC C7 45 F8 FF FF FF FF 6A 2E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 2E 6A 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 17 8B 45 10 50 8B 4D 0C 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 E9 33 01 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 05 89 45 C8 68 25 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D C8 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 0F 01 00 00 6A 00 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F0 52 8B 45 C8 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 E8 E8 ?? ?? ?? ?? 8B 00 89 45 E4 C7 45 F4 03 00 00 00 EB 09 8B 4D F4 83 E9 01 89 4D F4 83 7D F4 00 7C 7E 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 04 95 ?? ?? ?? ?? 50 8B 4D E8 2B 4D FC D1 F9 8B 55 C8 2B D1 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 23 E8 ?? ?? ?? ?? 8B 55 E4 89 10 8B 45 10 50 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 EB 05 E9 73 FF FF FF 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F0 3B 4D 08 74 0E 6A 02 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_wcomexecmd"
		size = 303
		refs = "001b ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BG@DLIHJHNJ@?$AAw?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005d __invalid_parameter 007f ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e2 __wcenvarg 0102 __wdospawn 0113 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BF 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5E 8B 4D 08 51 8D 55 F8 52 8D 45 F4 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 38 8B 45 F8 50 8B 4D F4 51 8B 55 08 52 6A 02 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_853_2_0 {
	meta:
		name = "_comexecmd"
		size = 303
		refs = "001b ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@BCIEHILB@?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005d __invalid_parameter 007f ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e2 __cenvarg 0102 __dospawn 0113 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BF 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5E 8B 4D 08 51 8D 55 F8 52 8D 45 F4 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 38 8B 45 F8 50 8B 4D F4 51 8B 55 08 52 6A 02 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__wcsicoll_l"
		size = 547
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0030 ??_C@_1GE@HCLMOBKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0037 __CrtDbgReportW 004b __errno 005f ??_C@_1BI@EFNHPDCH@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0069 __invalid_parameter 007b ??1_LocaleUpdate@@QAE@XZ 009a ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fe ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01dc ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8B 45 10 50 8D 4D E4 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 98 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 25 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 0F 85 AE 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 C4 EB 09 8B 45 08 0F B7 08 89 4D C4 66 8B 55 C4 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 C0 EB 09 8B 45 0C 0F B7 08 89 4D C0 66 8B 55 C0 66 89 55 F4 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 0F B7 55 FC 85 D2 74 10 0F B7 45 FC 0F B7 4D F4 3B C1 0F 84 6C FF FF FF 0F B7 55 FC 0F B7 45 F4 2B D0 89 55 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 EB 63 6A FF 8B 4D 0C 51 6A FF 8B 55 08 52 68 01 10 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 CC FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC EB 14 8B 55 F8 83 EA 02 89 55 C8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ"
		size = 16
		altNames = "??0?$_DebugMallocator@H@@QAE@XZ ??0?$_DebugMallocator@V__ExceptionPtr@@@@QAE@XZ ??0?$allocator@D@std@@QAE@XZ ??0?$allocator@G@std@@QAE@XZ ??0?$allocator@V?$_Function_impl1@XABI@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@std@@QAE@XZ ??0?$allocator@_W@std@@QAE@XZ ??0?$cache_aligned_allocator@V_Concurrent_queue_iterator_rep@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$cache_aligned_allocator@V_Concurrent_queue_rep@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0_Ignore@tr1@std@@QAE@XZ ??D?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ ??D?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ ??D?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ ?_Get@?$_Callable_base@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@QBEABQ6A_NABW4agent_status@Concurrency@@@ZXZ ?_Get@?$_Callable_base@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QAEAAV<lambda0>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QBEABV<lambda0>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QAEAAV<lambda1>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QBEABV<lambda1>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QAEAAV<lambda2>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QBEABV<lambda2>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QAEAAV<lambda3>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QBEABV<lambda3>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QAEAAV<lambda4>@?A0x8894c2c9@Concurrency@@XZ ?_Get@?$_Callable_base@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@QBEABV<lambda4>@?A0x8894c2c9@Concurrency@@XZ ?native_handle@critical_section@Concurrency@@QAEAAV12@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "__wcsicoll"
		size = 409
		refs = "000a ___locale_changed 0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@HCLMOBKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BE@HPGMPCMA@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018e __wcsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 3D ?? ?? ?? ?? 00 0F 85 6E 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 65 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 65 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 1A 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 B4 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 EC EB 09 8B 4D 08 0F B7 11 89 55 EC 66 8B 45 EC 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 0C 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 6C FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 14 EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_memset"
		size = 122
		refs = "0020 ___sse2_available 0028 __VEC_memzero"
	strings:
		$1 = { 8B 54 24 0C 8B 4C 24 04 85 D2 74 69 33 C0 8A 44 24 08 84 C0 75 16 81 FA 80 00 00 00 72 0E 83 3D ?? ?? ?? ?? 00 74 05 E9 ?? ?? ?? ?? 57 8B F9 83 FA 04 72 31 F7 D9 83 E1 03 74 0C 2B D1 88 07 83 C7 01 83 E9 01 75 F6 8B C8 C1 E0 08 03 C1 8B C8 C1 E0 10 03 C1 8B CA 83 E2 03 C1 E9 02 74 06 F3 AB 85 D2 74 0A 88 07 83 C7 01 83 EA 01 75 F6 8B 44 24 08 5F C3 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "___init_numeric"
		size = 810
		refs = "003e ??_C@_0DB@KKFMDHFI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0049 __calloc_dbg 0082 __malloc_dbg 0099 __free_dbg 0126 ___getlocaleinfo 01be ___free_lconv_num 01f1 _fix_grouping 0205 ___lconv_c 0281 __imp__InterlockedDecrement@4 0296 ??_C@_1DM@IFKAINNE@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AAo?$AAn?$AAv?$AA_?$AAn?$AAu?$AAm?$AA_?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 02a2 ??_C@_1GC@EDJOCBCL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 02a9 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 56 57 C7 45 E8 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 89 45 F0 C7 45 F4 00 00 00 00 8B 4D 08 83 79 1C 00 75 0D 8B 55 08 83 7A 18 00 0F 84 19 02 00 00 6A 65 68 ?? ?? ?? ?? 6A 02 6A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 0A B8 01 00 00 00 E9 C1 02 00 00 8B 45 08 8B B0 BC 00 00 00 B9 14 00 00 00 8B 7D E4 F3 A5 6A 71 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC 83 7D EC 00 75 18 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 7A 02 00 00 8B 55 EC C7 02 00 00 00 00 8B 45 08 83 78 1C 00 0F 84 3A 01 00 00 6A 7D 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 26 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 22 02 00 00 8B 45 F8 C7 00 00 00 00 00 8B 4D 08 0F B7 51 3E 89 55 FC 8B 45 E4 50 6A 0E 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 04 50 6A 0F 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 08 50 6A 10 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 30 50 6A 0E 8B 4D FC 51 6A 02 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 34 50 6A 0F 8B 4D FC 51 6A 02 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 74 30 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF E9 3B 01 00 00 8B 45 E4 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 EB 40 C7 45 F8 00 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 89 02 8B 4D E4 8B 15 ?? ?? ?? ?? 89 51 04 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 08 8B 55 E4 A1 ?? ?? ?? ?? 89 42 30 8B 4D E4 8B 15 ?? ?? ?? ?? 89 51 34 8B 45 EC C7 00 01 00 00 00 83 7D F8 00 74 09 8B 4D F8 C7 01 01 00 00 00 EB 15 C7 45 F8 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 E4 ?? ?? ?? ?? 8B 55 08 83 BA B4 00 00 00 00 74 41 8B 45 08 8B 88 B4 00 00 00 51 FF 15 ?? ?? ?? ?? 85 C0 75 2D 8B 55 08 83 BA B4 00 00 00 00 77 21 68 ?? ?? ?? ?? 6A 00 68 C3 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 08 83 B9 B0 00 00 00 00 74 3C 8B 55 08 8B 82 B0 00 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 75 28 6A 02 8B 4D 08 8B 91 B0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 BC 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 45 F8 89 82 B4 00 00 00 8B 4D 08 8B 55 EC 89 91 B0 00 00 00 8B 45 08 8B 4D E4 89 88 BC 00 00 00 33 C0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "_fix_grouping"
		size = 127
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 0F BE 08 85 C9 74 6B 8B 55 08 0F BE 02 83 F8 30 7C 24 8B 4D 08 0F BE 11 83 FA 39 7F 19 8B 45 08 0F BE 08 83 E9 30 8B 55 08 88 0A 8B 45 08 83 C0 01 89 45 08 EB 3A 8B 4D 08 0F BE 11 83 FA 3B 75 26 8B 45 08 89 45 FC 8B 4D FC 8B 55 FC 8A 42 01 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 75 E2 EB 09 8B 4D 08 83 C1 01 89 4D 08 EB 8B 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "___free_lconv_num"
		size = 171
		refs = "0017 ___lconv_c 0026 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 05 E9 99 00 00 00 8B 45 08 8B 08 3B 0D ?? ?? ?? ?? 74 10 6A 02 8B 55 08 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 04 3B 15 ?? ?? ?? ?? 74 11 6A 02 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 08 3B 05 ?? ?? ?? ?? 74 11 6A 02 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B 48 30 3B 0D ?? ?? ?? ?? 74 11 6A 02 8B 55 08 8B 42 30 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 34 3B 15 ?? ?? ?? ?? 74 11 6A 02 8B 45 08 8B 48 34 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 83 E8 01 89 45 10 78 11 8B 4D 08 FF 55 14 8B 4D 08 03 4D 0C 89 4D 08 EB E4 5D C2 10 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 207
		refs = "0008 __ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0015 ___security_cookie 002c ??0ScheduleGroup@Concurrency@@QAE@XZ 0035 ??_7ScheduleGroupBase@details@Concurrency@@6B@ 0040 ??0?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ 0058 ??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 008d ??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 00aa ?GetNewScheduleGroupId@SchedulerBase@details@Concurrency@@QAEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 6A 40 68 00 01 00 00 8B 4D 08 8B 11 52 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 45 F0 8B 4D 08 89 48 60 8B 55 F0 C7 42 6C 01 00 00 00 68 FF FF FF 7F 68 00 01 00 00 8B 45 08 8B 08 51 8B 4D F0 83 C1 78 E8 ?? ?? ?? ?? C6 45 FC 01 8B 55 F0 8B 42 60 8B 4D F0 8B 10 89 51 64 8B 45 F0 8B 48 64 E8 ?? ?? ?? ?? 8B 4D F0 89 41 70 C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_4_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_50_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_103_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_684_3 {
	meta:
		name = "__ehhandler$??0?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_714_3 {
	meta:
		name = "__ehhandler$??0?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_466_3 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_947_3 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@QAE@ABQ6A_NABW4agent_status@Concurrency@@@ZV?$allocator@V?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@QAE@ABQ6A_NABW4agent_status@Concurrency@@@ZV?$allocator@V?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_960_3 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@QAE@AAV<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@QAE@AAV<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_973_1 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_986_2 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@QAE@AAV<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@QAE@AAV<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_999_3 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_1010_1 {
	meta:
		name = "__ehhandler$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@AAV<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_298_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_914_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_780_3 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_152_0 {
	meta:
		name = "__ehhandler$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_642_1 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_638_3 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_159_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1185_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_1184_3 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_4_2 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_4_1 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_4_2 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_236_3 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@tr1@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@tr1@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_220_2 {
	meta:
		name = "__ehhandler$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_204_3 {
	meta:
		name = "__ehhandler$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_199_2 {
	meta:
		name = "__ehhandler$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_17_1 {
	meta:
		name = "__ehhandler$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_440_3 {
	meta:
		name = "__ehhandler$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_266_1 {
	meta:
		name = "__ehhandler$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_287_2 {
	meta:
		name = "__ehhandler$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_292_2 {
	meta:
		name = "__ehhandler$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_313_3 {
	meta:
		name = "__ehhandler$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_71_1 {
	meta:
		name = "__ehhandler$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_456_3 {
	meta:
		name = "__ehhandler$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_290_2 {
	meta:
		name = "__ehhandler$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_85_1 {
	meta:
		name = "__ehhandler$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_458_1 {
	meta:
		name = "__ehhandler$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_306_2 {
	meta:
		name = "__ehhandler$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_99_1 {
	meta:
		name = "__ehhandler$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_473_1 {
	meta:
		name = "__ehhandler$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_321_3 {
	meta:
		name = "__ehhandler$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_94_3 {
	meta:
		name = "__ehhandler$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_374_2 {
	meta:
		name = "__ehhandler$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_183_3 {
	meta:
		name = "__ehhandler$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_140_2 {
	meta:
		name = "__ehhandler$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_412_3 {
	meta:
		name = "__ehhandler$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_229_1 {
	meta:
		name = "__ehhandler$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_159_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_428_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_252_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_612_3 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_664_2 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_51_1 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_376_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_319_3 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_702_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_145_1 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_603_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_571_3 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_731_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_626_3 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_589_3 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_425_1 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_133_2 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_513_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_353_3 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_151_3 {
	meta:
		name = "__ehhandler$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_528_2 {
	meta:
		name = "__ehhandler$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_156_3 {
	meta:
		name = "__ehhandler$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_14_0 {
	meta:
		name = "__ehhandler$??0CacheLocalScheduleGroup@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0CacheLocalScheduleGroup@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_3_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_35_0 {
	meta:
		name = "__ehhandler$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_33_0 {
	meta:
		name = "__ehhandler$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_121_0 {
	meta:
		name = "__ehhandler$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_3_0 {
	meta:
		name = "__ehhandler$??0SchedulingNode@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingNode@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_3_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_3_0 {
	meta:
		name = "__ehhandler$??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_342_3_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_908_13_0 {
	meta:
		name = "__ehhandler$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_76_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_689_3_0 {
	meta:
		name = "__ehhandler$??0UMSThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_3_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_581_3_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessor@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessor@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_948_4_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_873_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_820_2 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_18_2 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_843_2 {
	meta:
		name = "__ehhandler$??0_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_790_3 {
	meta:
		name = "__ehhandler$??0_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_220_1 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@Verror_code@1@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0system_error@std@@QAE@Verror_code@1@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_294_3 {
	meta:
		name = "__ehhandler$??1?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_284_3 {
	meta:
		name = "__ehhandler$??1?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_172_1 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_598_2 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@G@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@G@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_568_2 {
	meta:
		name = "__ehhandler$??1?$_Mpunct@_W@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Mpunct@_W@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_161_0 {
	meta:
		name = "__ehhandler$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_458_3 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_450_3 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_53_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_65_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_56_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_7_3 {
	meta:
		name = "__ehhandler$??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_7_3 {
	meta:
		name = "__ehhandler$??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_7_3 {
	meta:
		name = "__ehhandler$??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_40_2 {
	meta:
		name = "__ehhandler$??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_907_3 {
	meta:
		name = "__ehhandler$??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_199_3 {
	meta:
		name = "__ehhandler$??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_240_1 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_457_3 {
	meta:
		name = "__ehhandler$??1?$ctype@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ctype@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_196_2 {
	meta:
		name = "__ehhandler$??1?$numpunct@D@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@D@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_568_1 {
	meta:
		name = "__ehhandler$??1?$numpunct@G@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@G@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_539_1 {
	meta:
		name = "__ehhandler$??1?$numpunct@_W@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$numpunct@_W@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_228_1 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_134_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_184_3 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_90_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_509_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_392_1 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_337_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_188_3 {
	meta:
		name = "__ehhandler$??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_605_2 {
	meta:
		name = "__ehhandler$??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_576_2 {
	meta:
		name = "__ehhandler$??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_192_3 {
	meta:
		name = "__ehhandler$??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_609_3 {
	meta:
		name = "__ehhandler$??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_531_1 {
	meta:
		name = "__ehhandler$??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_768_46_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_83_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_15_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_37_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_7_0 {
	meta:
		name = "__ehhandler$??1SchedulingNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingNode@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_6_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_10_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_581_20_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_177_0 {
	meta:
		name = "__ehhandler$??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_27_2 {
	meta:
		name = "__ehhandler$??1_Locimp@locale@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locimp@locale@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_196_3 {
	meta:
		name = "__ehhandler$??1_Locinfo@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locinfo@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_55_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_28_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_18_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_21_0 {
	meta:
		name = "__ehhandler$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_5_0 {
	meta:
		name = "?Id@ScheduleGroupBase@details@Concurrency@@UBEIXZ"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_6_0 {
	meta:
		name = "?Reference@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_408_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Clear@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_353_3 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Clear@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_369_1 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Clear@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_312_1 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Clear@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_68_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_619_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_623_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_137_0 {
	meta:
		name = "??1?$_Ref_count@V__ExceptionPtr@@@tr1@std@@UAE@XZ"
		size = 21
		refs = "000d ??1_Ref_count_base@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_542_3 {
	meta:
		name = "??1?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_617_2 {
	meta:
		name = "??1?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_621_3 {
	meta:
		name = "??1?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_63_2 {
	meta:
		name = "??1?$_String_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_587_3 {
	meta:
		name = "??1?$_String_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_557_3 {
	meta:
		name = "??1?$_String_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 21
		refs = "000d ??1?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_188_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Yarn@D@std@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_258_1 {
	meta:
		name = "??1?$function@$$A6AXABI@Z@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Function_impl1@XABI@tr1@std@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_387_2 {
	meta:
		name = "??1?$function@$$A6AXPAV?$message@I@Concurrency@@@Z@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_332_1 {
	meta:
		name = "??1?$function@$$A6AXPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@Z@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_436_2 {
	meta:
		name = "??1?$function@$$A6A_NABI@Z@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Function_impl1@_NABI@tr1@std@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_141_3 {
	meta:
		name = "??1?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Tidy@?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_64_0 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@tr1@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_30_0 {
	meta:
		name = "??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_40_0 {
	meta:
		name = "??1FairScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_794_8_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_127_0 {
	meta:
		name = "??1RealizedChore@details@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1_Chore@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_908_15_0 {
	meta:
		name = "??1TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@XZ"
		size = 21
		refs = "000d ??1_Timer@details@Concurrency@@IAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_220_2 {
	meta:
		name = "??1_Container_base12@std@@QAE@XZ"
		size = 21
		refs = "000d ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_21_2 {
	meta:
		name = "??1_Generic_error_category@std@@UAE@XZ"
		size = 21
		refs = "000d ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_64_1 {
	meta:
		name = "??1_Iostream_error_category@std@@UAE@XZ"
		size = 21
		refs = "000d ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_285_3 {
	meta:
		name = "??1_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_277_2 {
	meta:
		name = "??1_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_92_2 {
	meta:
		name = "??1_System_error_category@std@@UAE@XZ"
		size = 21
		refs = "000d ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_58_4_3 {
	meta:
		name = "??1bad_function_call@tr1@std@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_278_3 {
	meta:
		name = "??1bad_target@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_115_0 {
	meta:
		name = "??1bad_weak_ptr@tr1@std@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_36_0 {
	meta:
		name = "??1context_self_unblock@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_32_0 {
	meta:
		name = "??1context_unblock_unbalanced@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_28_0 {
	meta:
		name = "??1default_scheduler_exists@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_290_3 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 21
		refs = "000d ??1system_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_88_0 {
	meta:
		name = "??1improper_lock@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_16_0 {
	meta:
		name = "??1improper_scheduler_attach@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_20_0 {
	meta:
		name = "??1improper_scheduler_detach@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_24_0 {
	meta:
		name = "??1improper_scheduler_reference@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_31_3 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 21
		refs = "000d ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_307_3 {
	meta:
		name = "??1invalid_link_target@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_80_0 {
	meta:
		name = "??1invalid_multiple_scheduling@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_684_18_0 {
	meta:
		name = "??1invalid_operation@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_655_31_0 {
	meta:
		name = "??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_56_0 {
	meta:
		name = "??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_64_0 {
	meta:
		name = "??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_60_0 {
	meta:
		name = "??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_28_1 {
	meta:
		name = "??1length_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_10_1 {
	meta:
		name = "??1logic_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_270_1 {
	meta:
		name = "??1message_not_found@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_293_3 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 21
		refs = "000d ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_597_58_0 {
	meta:
		name = "??1missing_wait@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_181_2 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 21
		refs = "000d ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_75_0 {
	meta:
		name = "??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_894_1 {
	meta:
		name = "??1operation_timed_out@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_6_1 {
	meta:
		name = "??1out_of_range@std@@UAE@XZ"
		size = 21
		refs = "000d ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_66_25_2 {
	meta:
		name = "??1overflow_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_18_3 {
	meta:
		name = "??1range_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_12_3 {
	meta:
		name = "??1regex_error@tr1@std@@UAE@XZ"
		size = 21
		refs = "000d ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_195_2 {
	meta:
		name = "??1runtime_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_459_7_0 {
	meta:
		name = "??1scheduler_not_attached@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_706_5_0 {
	meta:
		name = "??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_223_1 {
	meta:
		name = "??1system_error@std@@UAE@XZ"
		size = 21
		refs = "000d ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_92_0 {
	meta:
		name = "??1task_canceled@details@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_704_8_0 {
	meta:
		name = "??1unsupported_os@Concurrency@@UAE@XZ"
		size = 21
		refs = "000d ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_68_0 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 21
		refs = "000d ?_Get@?$_Ptr_base@V__ExceptionPtr@@@tr1@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_105_1 {
	meta:
		name = "??D?$_String_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEAADXZ"
		size = 21
		refs = "000d ??D?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_960_2 {
	meta:
		name = "??D?$_String_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEAAGXZ"
		size = 21
		refs = "000d ??D?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEABGXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_872_1 {
	meta:
		name = "??D?$_String_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEAA_WXZ"
		size = 21
		refs = "000d ??D?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEAB_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_289_0 {
	meta:
		name = "?Count@?$List@UListEntry@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEHXZ"
		size = 21
		refs = "000d ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_850_112_0 {
	meta:
		name = "?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEHXZ"
		size = 21
		refs = "000d ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_67_0 {
	meta:
		name = "?Destroy@WaitAllBlock@details@Concurrency@@UAEXXZ"
		size = 21
		refs = "000d ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_28_0 {
	meta:
		name = "?IsStructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 21
		refs = "000d ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_671_41_0 {
	meta:
		name = "?PopStructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 21
		refs = "000d ?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_7_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_57_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 21
		refs = "000d ?_DebugAcquire@_NonReentrantLock@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_671_59_0 {
	meta:
		name = "?_IsLockHeld@_CriticalNonReentrantLock@details@Concurrency@@QBE_NXZ"
		size = 21
		refs = "000d ?_IsLockHeld@_NonReentrantLock@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_29_0 {
	meta:
		name = "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
		size = 21
		refs = "000d ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 21
		refs = "000d ?_DebugTryAcquire@_NonReentrantLock@details@Concurrency@@AAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_277_2 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
		size = 21
		refs = "000d ?_Myptr@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_914_3 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
		size = 21
		refs = "000d ?_Myptr@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_196_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
		size = 21
		refs = "000d ?_Myptr@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_399_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?_Count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_344_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?_Count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_192_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?_Count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_97_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 21
		refs = "000d ?_Count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_110_0 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 21
		refs = "000d ?_Get@?$_Ptr_base@V__ExceptionPtr@@@tr1@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_8_0 {
	meta:
		name = "?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 81
		refs = "0026 ??_C@_0DL@KMFIAFEF@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 002b ??_C@_0BA@NCCPDIBA@m_refCount?5?$DO?$DN?50?$AA@ 0030 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 74 83 E1 04 75 36 8B 55 FC 83 7A 6C 00 7C 02 EB 17 68 E7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 83 C0 6C B9 01 00 00 00 F0 0F C1 08 41 8B C1 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_9_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 102
		refs = "0028 ??_C@_0DL@KMFIAFEF@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 002d ??_C@_0P@FKFIPPPI@m_refCount?5?$DO?50?$AA@ 0032 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0057 ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AAEXPAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 0F B6 48 74 83 E1 04 75 49 8B 55 F8 83 7A 6C 00 7E 02 EB 17 68 F5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 83 C0 6C 83 C9 FF F0 0F C1 08 49 89 4D FC 75 0F 8B 55 F8 52 8B 45 F8 8B 48 60 E8 ?? ?? ?? ?? 8B 45 FC EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_10_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 001e ??3ScheduleGroup@Concurrency@@KAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_199_0 {
	meta:
		name = "??_G?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_268_2 {
	meta:
		name = "??_G?$ISource@I@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ISource@I@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_280_2 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_267_2 {
	meta:
		name = "??_G?$ITarget@I@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ITarget@I@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_273_2 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_106_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_108_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_554_2 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_962_2 {
	meta:
		name = "??_G?$_Impl_base1@XABI@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_base1@XABI@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_975_2 {
	meta:
		name = "??_G?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_988_3 {
	meta:
		name = "??_G?$_Impl_base1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_base1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_949_2 {
	meta:
		name = "??_G?$_Impl_base1@_NABW4agent_status@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_base1@_NABW4agent_status@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_1019_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_1023_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_1027_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_1031_3 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_1035_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_1038_2 {
	meta:
		name = "??_G?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_174_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_599_2 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_570_3 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_560_2 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_136_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Ref_count@V__ExceptionPtr@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_158_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_553_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_550_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_59_3 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_53_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_26_53_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_10_251_3 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_210_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_207_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_44_58_3 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_52_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_52_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_295_3 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_89_192_1 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@DDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_42_222_3 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@GDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_85_217_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@_WDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_168_2 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_569_1 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_540_1 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_448_2 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_2_313_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_92_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_289_1 {
	meta:
		name = "??_G?$function@$$A6A_NABI@Z@tr1@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1?$function@$$A6A_NABI@Z@tr1@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_275_1 {
	meta:
		name = "??_G?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_551_2 {
	meta:
		name = "??_G?$message@I@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$message@I@Concurrency@@UAE@XZ 001e ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_548_3 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$message@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_162_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_588_3 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_542_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_164_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_590_3 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_560_3 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_38_174_3 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_575_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_546_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_175_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@D$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_176_2 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@D$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_600_2 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@G$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_594_3 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@G$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_571_2 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@_W$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_564_3 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@_W$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_404_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_349_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_287_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_272_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_40_189_3 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_577_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_547_2 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_40_191_3 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_579_3 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_534_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_193_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_565_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_536_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_291_1 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_281_2 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_269_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_288_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_274_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_561_2 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_45_0 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_286_1 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$single_assignment@I@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_518_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_914_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_290_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_276_2 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_562_1 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_296_2 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_185_2 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_602_3 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_557_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_189_2 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_589_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_528_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_486_28_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ 001e ??3CacheLocalScheduleGroup@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_850_47_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1ExecutionResource@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_768_21_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ExternalContextBase@details@Concurrency@@UAE@XZ 001e ??3ExternalContextBase@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_486_39_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1FairScheduleGroup@details@Concurrency@@UAE@XZ 001e ??3FairScheduleGroup@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_36_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1FreeThreadProxy@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_39_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1FreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_794_7_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_44_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_13_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1InternalContextBase@details@Concurrency@@UAE@XZ 001e ??3Context@Concurrency@@KAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_126_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1RealizedChore@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_124_67_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 46
		refs = "000d ??1ResourceManager@details@Concurrency@@AAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_15_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1Scheduler@Concurrency@@MAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_26_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1SchedulerBase@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_88_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1SchedulerPolicy@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_850_6_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 46
		refs = "000d ??1SchedulerProxy@details@Concurrency@@IAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_39_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1SchedulingNode@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_40_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1SchedulingRing@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_65_0 {
	meta:
		name = "??_GSubAllocator@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1SubAllocator@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_61_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1TaskStack@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_635_32_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ThreadInternalContext@details@Concurrency@@UAE@XZ 001e ??3ThreadInternalContext@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_941_7_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ThreadProxy@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_635_9_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ThreadScheduler@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_342_6_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_480_17_0 {
	meta:
		name = "??_GTransmogrificator@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1Transmogrificator@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_26_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_763_13_0 {
	meta:
		name = "??_GUMSBackgroundPoller@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSBackgroundPoller@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_88_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_93_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_221_104_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_221_93_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_643_9_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSSchedulingContext@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_655_8_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 001e ??3UMSThreadInternalContext@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_864_16_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_689_9_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSThreadScheduler@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_643_5_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_581_11_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1VirtualProcessor@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_221_14_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_118_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1WorkQueue@details@Concurrency@@QAE@XZ 001e ??3WorkQueue@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_897_3 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_893_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_124_0 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1_Chore@details@Concurrency@@MAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_21_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_993_20_0 {
	meta:
		name = "??_G_Exception_ptr@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1_Exception_ptr@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_63_2 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1_Fac_node@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_20_2 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Generic_error_category@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_85_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Iostream_error_category@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_23_3 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1_Locimp@locale@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_896_3 {
	meta:
		name = "??_G_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_892_2 {
	meta:
		name = "??_G_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_132_0 {
	meta:
		name = "??_G_Ref_count_base@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_Ref_count_base@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_6_69_1 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1_System_error_category@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_671_70_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1_TaskCollection@details@Concurrency@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_109_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1__ExceptionPtr@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_19_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1__non_rtti_object@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_6_1 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1agent@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_36_3 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_alloc@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_11_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_cast@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_exception@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_3_3 {
	meta:
		name = "??_Gbad_function_call@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_function_call@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_299_3 {
	meta:
		name = "??_Gbad_target@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_target@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_15_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_typeid@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_93_3_3 {
	meta:
		name = "??_Gbad_weak_ptr@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_weak_ptr@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_234_3 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1codecvt_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_32_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1context_self_unblock@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_768_32_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1context_unblock_unbalanced@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_316_3 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ctype_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_27_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1default_scheduler_exists@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_6_6_1 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1error_category@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_1_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1exception@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_223_2 {
	meta:
		name = "??_Gfacet@locale@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1facet@locale@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_268_2 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1failure@ios_base@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_226_74_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1improper_lock@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_15_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1improper_scheduler_attach@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_155_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1improper_scheduler_detach@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_23_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1improper_scheduler_reference@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_706_35_0 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_argument@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_309_2 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_link_target@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_79_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_multiple_scheduling@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_387_31_0 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_operation@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_655_33_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_12_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_14_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_13_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_29_271_3 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ios_base@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_27_2 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1length_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_241_3 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1locale@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_141_0 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1logic_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_298_1 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1message_not_found@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_73_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1messages_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_39_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1missing_wait@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_261_1 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1money_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_77_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_898_1 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1operation_timed_out@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_66_16_2 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1out_of_range@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_67_24_3 {
	meta:
		name = "??_Goverflow_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1overflow_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_17_3 {
	meta:
		name = "??_Grange_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1range_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_11_3 {
	meta:
		name = "??_Gregex_error@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1regex_error@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_86_188_3 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1runtime_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_11_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1scheduler_not_attached@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_2_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_16_21_2 {
	meta:
		name = "??_Gsystem_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1system_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_106_0 {
	meta:
		name = "??_Gtask_canceled@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1task_canceled@details@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_38_136_3 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1time_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_433_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1type_info@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_124_32_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1unsupported_os@Concurrency@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_12_0 {
	meta:
		name = "??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
		size = 184
		refs = "0008 __ehhandler$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0015 ___security_cookie 002d ??_7ScheduleGroupBase@details@Concurrency@@6B@ 003f ?IsEmptyAtSafePoint@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NXZ 004f ??_C@_0DL@KMFIAFEF@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0054 ??_C@_0CC@MOIHNAGF@m_workQueues?4IsEmptyAtSafePoint?$CI@ 0059 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0067 ?IsEmptyAtSafePoint@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NXZ 007c ??_C@_0CK@LNINOACK@m_detachedWorkQueues?4IsEmptyAtSa@ 0093 ??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@XZ 00a5 ??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 14 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 C1 78 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 02 EB 14 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C6 45 FC 00 8B 4D F0 83 C1 78 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_16_0 {
	meta:
		name = "??0ScheduleGroup@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7ScheduleGroup@Concurrency@@6B@"
		altNames = "??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ ??0?$List@VContextExitEventHandler@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAE@XZ ??0?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAE@XZ ??0?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$_String_const_iterator@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ ??0?$_String_const_iterator@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ ??0?$_String_const_iterator@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ ??0Block@_HeapManager@@QAE@XZ ??0Count@CollectionTypes@details@Concurrency@@QAE@XZ ??0Replicator@@QAE@XZ ??0StructuredEvent@details@Concurrency@@QAE@XZ ??0_Container_base12@std@@QAE@XZ ??0_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_654_3 {
	meta:
		name = "??0?$ISource@I@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$ISource@I@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_653_3 {
	meta:
		name = "??0?$ISource@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_547_3 {
	meta:
		name = "??0?$ITarget@I@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$ITarget@I@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_546_3 {
	meta:
		name = "??0?$ITarget@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1025_3 {
	meta:
		name = "??0?$_Impl_base1@XABI@tr1@std@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$_Impl_base1@XABI@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1029_3 {
	meta:
		name = "??0?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1033_3 {
	meta:
		name = "??0?$_Impl_base1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$_Impl_base1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_1021_2 {
	meta:
		name = "??0?$_Impl_base1@_NABW4agent_status@Concurrency@@@tr1@std@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$_Impl_base1@_NABW4agent_status@Concurrency@@@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_655_3 {
	meta:
		name = "??0?$message_processor@I@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$message_processor@I@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_707_1 {
	meta:
		name = "??0?$message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$message_processor@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_710_1 {
	meta:
		name = "??0?$network_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$network_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_708_2 {
	meta:
		name = "??0?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_709_2 {
	meta:
		name = "??0?$network_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$network_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_706_3 {
	meta:
		name = "??0?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_671_10_0 {
	meta:
		name = "??0Context@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7Context@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_787_131_0 {
	meta:
		name = "??0DNameNode@@IAE@XZ"
		size = 25
		refs = "000e ??_7DNameNode@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_15_0 {
	meta:
		name = "??0IExecutionContext@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IExecutionContext@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_387_16_0 {
	meta:
		name = "??0IExecutionResource@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IExecutionResource@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_45_0 {
	meta:
		name = "??0IResourceManager@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IResourceManager@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_830_3_0 {
	meta:
		name = "??0IScheduler@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IScheduler@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_850_7_0 {
	meta:
		name = "??0ISchedulerProxy@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7ISchedulerProxy@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_941_8_0 {
	meta:
		name = "??0IThreadProxy@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IThreadProxy@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_107_0 {
	meta:
		name = "??0IThreadProxyFactory@details@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_706_12_0 {
	meta:
		name = "??0IUMSCompletionList@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IUMSCompletionList@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_864_19_0 {
	meta:
		name = "??0IUMSUnblockNotification@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7IUMSUnblockNotification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_13_0 {
	meta:
		name = "??0Scheduler@Concurrency@@IAE@XZ"
		size = 25
		refs = "000e ??_7Scheduler@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_221_21_0 {
	meta:
		name = "??0UMSBaseObject@details@Concurrency@@QAE@XZ"
		size = 25
		refs = "000e ??_7UMSBaseObject@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_122_0 {
	meta:
		name = "??0_Chore@details@Concurrency@@IAE@XZ"
		size = 25
		refs = "000e ??_7_Chore@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_5_1 {
	meta:
		name = "??0error_category@std@@QAE@XZ"
		size = 25
		refs = "000e ??_7error_category@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_297_3 {
	meta:
		name = "??0ios_base@std@@IAE@XZ"
		size = 25
		refs = "000e ??_7ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_17_0 {
	meta:
		name = "??0?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 35
		refs = "000d ??0?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0018 ??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 08 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_29_0 {
	meta:
		name = "??0?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 35
		refs = "000d ??0?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0018 ??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 08 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_27_0 {
	meta:
		name = "??0?$SafeSQueue@VSafePointInvocation@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 35
		refs = "000d ??0?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QAE@XZ 0018 ??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 08 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "??0?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 35
		refs = "000d ??0?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAE@XZ 0018 ??0_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 08 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_18_0 {
	meta:
		name = "??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ??0_NonReentrantLock@details@Concurrency@@QAE@XZ"
		altNames = "??0_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_689_3 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ?_Init@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_668_1 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ?_Init@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_719_3 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ?_Init@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_711_3 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ?_Init@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_160_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 24
		refs = "000d ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_1148_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 24
		refs = "000d ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_1145_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 24
		refs = "000d ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_58_0 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAE@XZ"
		size = 24
		refs = "000d ??0?$_Ptr_base@V__ExceptionPtr@@@tr1@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_581_4_0 {
	meta:
		name = "??0SafePointMarker@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ?Reset@SafePointMarker@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_27_0 {
	meta:
		name = "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "000d ??0critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_287_2 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ"
		size = 24
		refs = "000d ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_951_2 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ"
		size = 24
		refs = "000d ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_948_2 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ"
		size = 24
		refs = "000d ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_20_0 {
	meta:
		name = "?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z"
		size = 153
		refs = "0012 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 0020 ??_C@_0DN@FBKLHFDA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0025 ??_C@_0CF@OOOMHKNH@pContext?9?$DOGetScheduleGroup?$CI?$CJ?5?$DN?$DN?5@ 002a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0032 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0052 ?CrossGroupRunnable@InternalContextBase@details@Concurrency@@QAEXJ@Z 0085 ?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D 08 83 C1 04 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 14 6A 29 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 0D 8B 4D FC E8 ?? ?? ?? ?? 3B 45 F8 74 0A 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D F8 8B 11 8B 4D F8 8B 42 14 FF D0 8B 4D F8 8B 51 64 83 BA FC 00 00 00 00 7E 13 8B 45 0C 50 8B 4D F8 51 8B 55 F8 8B 4A 64 E8 ?? ?? ?? ?? 6A 00 8B 4D 08 E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_28_21_0 {
	meta:
		name = "?CrossGroupRunnable@InternalContextBase@details@Concurrency@@QAEXJ@Z"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 88 C4 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_22_0 {
	meta:
		name = "?StealUnrealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAV_UnrealizedChore@23@XZ"
		size = 663
		refs = "000c ___security_cookie 0024 ?MaxIndex@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHXZ 0070 ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QBEPAVWorkQueue@12@H@Z 0085 ?IsEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 009c ?TryToSteal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@AA_N@Z 00df ?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 00f8 ?IsDetached@WorkQueue@details@Concurrency@@QBE_NXZ 020b ?MaxIndex@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHXZ 026d ?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 0280 ?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IAE_NPAVWorkQueue@23@@Z 028f @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 E4 53 89 4D 80 C6 45 FF 00 8B 4D 80 83 C1 10 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 0F 8E CF 01 00 00 C7 45 9C 00 00 00 00 C7 45 EC 10 00 00 00 C6 45 EB 00 C7 45 98 00 00 00 00 EB 09 8B 45 98 83 C0 01 89 45 98 8B 4D 98 3B 4D F4 0F 8D EB 00 00 00 8B 55 98 52 8B 4D 80 83 C1 10 E8 ?? ?? ?? ?? 89 45 94 83 7D 94 00 0F 84 CA 00 00 00 8B 4D 94 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 85 A3 00 00 00 8D 4D EB 51 8B 4D 94 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 0A 8B 45 F8 E9 D7 01 00 00 EB 41 0F B6 55 EB 85 D2 75 39 83 7D 9C 0F 7D 1A 8B 45 9C 8B 4D 98 89 4C 85 A0 8B 55 9C 83 C2 01 89 55 9C E9 77 FF FF FF EB 19 8B 4D 94 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 08 8B 45 F8 E9 94 01 00 00 8B 4D 94 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1B 8B 4D 94 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 0F B6 55 FF 0B 95 7C FF FF FF 88 55 FF EB 14 0F B6 5D FF 8B 4D 94 E8 ?? ?? ?? ?? 0F B6 C0 0B D8 88 5D FF E9 00 FF FF FF 83 7D 9C 00 0F 8E AA 00 00 00 C7 45 90 00 00 00 00 EB 09 8B 4D 90 83 C1 01 89 4D 90 8B 55 90 3B 55 9C 0F 8D 8C 00 00 00 8B 45 90 8B 4C 85 A0 51 8B 4D 80 83 C1 10 E8 ?? ?? ?? ?? 89 45 8C 83 7D 8C 00 74 6B 8B 4D 8C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 1B 8B 4D 8C E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 0A 8B 45 F8 E9 CC 00 00 00 EB 41 8B 4D 8C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1B 8B 4D 8C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C C7 85 78 FF FF FF 01 00 00 00 EB 0A C7 85 78 FF FF FF 00 00 00 00 0F B6 55 FF 0B 95 78 FF FF FF 88 55 FF E9 5F FF FF FF 8B 4D 80 83 C1 78 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 7E 6E 0F B6 45 FF 85 C0 74 66 C7 45 88 00 00 00 00 EB 09 8B 4D 88 83 C1 01 89 4D 88 8B 4D 80 83 C1 10 E8 ?? ?? ?? ?? 39 45 88 7D 44 8B 55 88 52 8B 4D 80 83 C1 10 E8 ?? ?? ?? ?? 89 45 84 83 7D 84 00 74 2A 8B 4D 84 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1B 8B 4D 84 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C 8B 55 84 52 8B 4D 80 E8 ?? ?? ?? ?? EB A3 33 C0 5B 8B 4D E4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_23_0 {
	meta:
		name = "?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 24
		refs = "0010 ?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 48 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_51_0 {
	meta:
		name = "?MarkDetachment@WorkQueue@details@Concurrency@@QAEXXZ"
		size = 24
		refs = "0010 ?MarkDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 48 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_24_0 {
	meta:
		name = "?IsEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 67
		refs = "000f ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ 0021 ?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1B 8B 4D FC 83 C1 48 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_25_0 {
	meta:
		name = "?IsDetached@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 34 33 C0 83 F9 01 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_26_0 {
	meta:
		name = "?HasRealizedChores@ScheduleGroupBase@details@Concurrency@@IBE_NXZ"
		size = 34
		refs = "0010 ?Empty@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 F7 D8 1B C0 83 C0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_27_0 {
	meta:
		name = "?HasUnrealizedChores@ScheduleGroupBase@details@Concurrency@@IAE_NXZ"
		size = 140
		refs = "0024 ?MaxIndex@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHXZ 0038 ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QBEPAVWorkQueue@12@H@Z 0049 ?IsStructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 0058 ?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 006d ?IsDetached@WorkQueue@details@Concurrency@@QBE_NXZ 0080 ?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IAE_NPAVWorkQueue@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F4 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F4 83 C1 10 E8 ?? ?? ?? ?? 39 45 FC 7D 59 8B 4D FC 51 8B 4D F4 83 C1 10 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 3F 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0F 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 06 B0 01 EB 21 EB 1B 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C 8B 55 F8 52 8B 4D F4 E8 ?? ?? ?? ?? EB 8E 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_29_0 {
	meta:
		name = "?SafelyDeleteDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IAE_NPAVWorkQueue@23@@Z"
		size = 132
		refs = "0019 ?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@_N@Z 0028 ?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 003b ?RetireAtSafePoint@WorkQueue@details@Concurrency@@QAEXPAVScheduleGroupBase@23@@Z 004c ?InFinalizationSweep@SchedulerBase@details@Concurrency@@QAE_NXZ 005f ??_C@_0DN@FBKLHFDA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0064 ??_C@_0CF@MPCEALLH@?$CBm_pScheduler?9?$DOInFinalizationSwe@ 0069 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0078 ?RedetachFromScheduleGroupAtSafePoint@WorkQueue@details@Concurrency@@QAEXPAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 00 8B 45 08 83 C0 28 50 8B 4D FC 83 C1 78 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 58 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 12 8B 45 FC 50 8B 4D 08 E8 ?? ?? ?? ?? B0 01 EB 3B EB 37 8B 4D FC 8B 49 64 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 E9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 50 8B 4D 08 E8 ?? ?? ?? ?? 32 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_30_0 {
	meta:
		name = "?ScheduleTask@ScheduleGroupBase@details@Concurrency@@UAEXP6AXPAX@Z0@Z"
		size = 477
		refs = "0008 __ehhandler$?ScheduleTask@ScheduleGroupBase@details@Concurrency@@UAEXP6AXPAX@Z0@Z 0017 ___security_cookie 0031 ??_C@_04MGCDEED@proc?$AA@ 0039 ??0invalid_argument@std@@QAE@PBD@Z 003e __TI3?AVinvalid_argument@std@@ 0047 __CxxThrowException@8 005a ?GetRealizedChore@SchedulerBase@details@Concurrency@@QAEPAVRealizedChore@23@P6AXPAX@Z0@Z 0065 ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ 0074 ?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0079 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 008a ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 00a6 __imp__TlsGetValue@4 00b6 ??2@YAPAXI@Z 00d1 ??0ExternalStatistics@details@Concurrency@@QAE@XZ 00ff ?AddExternalStatistics@SchedulerBase@details@Concurrency@@QAEXPAVExternalStatistics@23@@Z 0113 __imp__TlsSetValue@8 0123 ?MaxIndex@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHXZ 0133 ??_C@_0DN@FBKLHFDA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0138 ??_C@_0DI@IDCOPJJA@m_pScheduler?9?$DOm_externalThreadSt@ 013d ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0157 ??_C@_0BL@IEICBKJJ@externalStatistics?5?$CB?$DN?5NULL?$AA@ 0167 ?IncrementEnqueuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ 0171 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 0180 ?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ 01a2 ?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D0 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 8B 4D 0C 51 8B 55 08 52 8B 45 D0 8B 48 64 E8 ?? ?? ?? ?? 89 45 F0 8B 4D D0 E8 ?? ?? ?? ?? 8B 4D F0 51 8B 4D D0 83 C1 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 14 8B 4D EC E8 ?? ?? ?? ?? 8B 55 D0 3B 42 64 0F 84 D3 00 00 00 8B 45 D0 8B 48 64 8B 51 18 52 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 66 6A 1C E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 C7 45 FC 00 00 00 00 83 7D D4 00 74 0D 8B 4D D4 E8 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 D8 C7 45 FC FF FF FF FF 8B 4D D8 89 4D E8 8B 55 E8 52 8B 45 D0 8B 48 64 E8 ?? ?? ?? ?? 8B 4D E8 51 8B 55 D0 8B 42 64 8B 48 18 51 FF 15 ?? ?? ?? ?? EB 2B 8B 55 D0 8B 4A 64 83 C1 40 E8 ?? ?? ?? ?? 85 C0 7E 02 EB 17 68 2C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D E8 00 74 02 EB 17 68 2F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E8 E8 ?? ?? ?? ?? EB 39 8B 4D EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0A 8B 4D EC E8 ?? ?? ?? ?? EB 20 83 7D EC 00 74 0B 8B 4D EC 83 E9 04 89 4D C8 EB 07 C7 45 C8 00 00 00 00 8B 4D C8 E8 ?? ?? ?? ?? 8B 55 D0 8B 42 64 83 B8 FC 00 00 00 00 7E 17 8B 4D D0 51 8B 55 D0 8B 42 64 8B 4D D0 8B 49 64 8B 10 8B 42 28 FF D0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_28_32_0 {
	meta:
		name = "__ehhandler$?ScheduleTask@ScheduleGroupBase@details@Concurrency@@UAEXP6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ScheduleTask@ScheduleGroupBase@details@Concurrency@@UAEXP6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_921_2 {
	meta:
		name = "__ehhandler$??$_Reset0f@V?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@_NABW4agent_status@Concurrency@@V?$allocator@V?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@IAEXQ6A_NABW4agent_status@Concurrency@@@ZV?$allocator@V?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0f@V?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@_NABW4agent_status@Concurrency@@V?$allocator@V?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@IAEXQ6A_NABW4agent_status@Concurrency@@@ZV?$allocator@V?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_927_2 {
	meta:
		name = "__ehhandler$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@V<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XABI@tr1@std@@@3@@?$_Function_impl1@XABI@tr1@std@@IAEXV<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XABI@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@V<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XABI@tr1@std@@@3@@?$_Function_impl1@XABI@tr1@std@@IAEXV<lambda0>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XABI@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_931_1 {
	meta:
		name = "__ehhandler$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda1>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_935_3 {
	meta:
		name = "__ehhandler$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@V<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@IAEXV<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@V<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@IAEXV<lambda2>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_939_3 {
	meta:
		name = "__ehhandler$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda3>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_943_1 {
	meta:
		name = "__ehhandler$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Reset0o@V?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@V<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@3@@?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@IAEXV<lambda4>@?A0x8894c2c9@Concurrency@@V?$allocator@V?$_Function_impl1@XPAV?$message@I@Concurrency@@@tr1@std@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_57_0 {
	meta:
		name = "__ehhandler$??1_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_45_0 {
	meta:
		name = "__ehhandler$?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_87_0 {
	meta:
		name = "__ehhandler$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_15_0 {
	meta:
		name = "__ehhandler$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_695_2 {
	meta:
		name = "__ehhandler$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_675_2 {
	meta:
		name = "__ehhandler$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_215_2 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_120_3 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_537_2 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_33_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@PBD@Z 001a ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_20_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0bad_typeid@std@@QAE@ABV01@@Z 001a ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_18_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0bad_typeid@std@@QAE@PBD@Z 001a ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_85_235_2 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_12_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_40_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_5_3 {
	meta:
		name = "??0bad_function_call@tr1@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_279_2 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_16_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_5_2 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_36_168_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_30_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_768_30_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_314_3 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_90_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_91_270_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0system_error@std@@QAE@ABV01@@Z 001a ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_226_73_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_149_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_154_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_135_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_684_19_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_308_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_10_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_684_21_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_768_37_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_9_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_11_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_945_10_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_80_0 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_26_3 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@PBD@Z 001a ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_794_28_0 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7logic_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_271_2 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_38_74_3 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7messages_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_59_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_776_2 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7money_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_76_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_79_895_3 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_66_18_2 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_7_2 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@PBD@Z 001a ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_66_26_2 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@ABV01@@Z 001a ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_20_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@PBD@Z 001a ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_38_22_1 {
	meta:
		name = "??0range_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@ABV01@@Z 001a ??_7range_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_13_2 {
	meta:
		name = "??0range_error@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@PBD@Z 001a ??_7range_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_18_192_2 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_459_8_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_105_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_354_2 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7time_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_124_31_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_34_0 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7logic_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_2_228_2 {
	meta:
		name = "??0bad_alloc@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_10_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_534_37_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_42_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_848_14_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_34_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_30_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_26_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_86_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_14_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_18_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_22_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_50_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_78_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_66_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_82_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_54_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_62_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_58_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_46_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_38_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_70_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_74_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_63_187_3 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_10_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_90_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_704_6_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_39_0 {
	meta:
		name = "?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 19
		altNames = "?IsRootRemoved@VirtualProcessorRoot@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 40 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_40_0 {
	meta:
		name = "?AddExternalStatistics@SchedulerBase@details@Concurrency@@QAEXPAVExternalStatistics@23@@Z"
		size = 30
		refs = "0014 ?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 40 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_41_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 70
		refs = "0012 ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ 0021 ?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXXZ 002b ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 1B 8B 4D FC E8 ?? ?? ?? ?? 83 C0 5C 89 45 F8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_42_0 {
	meta:
		name = "?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 33 C9 83 78 08 01 0F 94 C1 8A C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_43_0 {
	meta:
		name = "?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
		size = 75
		refs = "001c ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ 002d ??_C@_0DN@COCFINJF@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0032 ??_C@_0DJ@FICHJDBF@_m_pVirtualProcessor?5?$DN?$DN?5NULL?5?$HM?$HM?5@ 0037 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 B8 84 00 00 00 00 74 29 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 17 68 DE 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 82 84 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_44_0 {
	meta:
		name = "??0ExternalStatistics@details@Concurrency@@QAE@XZ"
		size = 66
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 8B 4D FC C7 41 0C 00 00 00 00 8B 55 FC C7 42 10 00 00 00 00 8B 45 FC C7 40 14 00 00 00 00 8B 4D FC C7 41 18 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_45_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 08 83 C1 01 8B 55 FC 89 4A 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_46_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "0013 ?IncrementEnqueuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_597_26_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "0013 ?IncrementDequeuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_49_0 {
	meta:
		name = "?DetachActiveWorkQueue@ScheduleGroupBase@details@Concurrency@@IAEXPAVWorkQueue@23@@Z"
		size = 51
		refs = "000d ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ 0017 ?SetDetached@WorkQueue@details@Concurrency@@QAEX_N@Z 0029 ?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 83 C0 28 50 8B 4D FC 83 C1 78 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_50_0 {
	meta:
		name = "?SetDetached@WorkQueue@details@Concurrency@@QAEX_N@Z"
		size = 49
		refs = "0015 ?MarkDetachment@WorkQueue@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 08 85 C0 74 08 8B 4D FC E8 ?? ?? ?? ?? 0F B6 4D 08 F7 D9 1B C9 F7 D9 8B 55 FC 83 C2 34 87 0A 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_52_0 {
	meta:
		name = "?RedetachQueue@ScheduleGroupBase@details@Concurrency@@QAEXPAVWorkQueue@23@@Z"
		size = 33
		refs = "0017 ?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 83 C0 28 50 8B 4D FC 83 C1 78 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_53_0 {
	meta:
		name = "?GetDetachedWorkQueue@ScheduleGroupBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ"
		size = 143
		refs = "0012 ?MaxIndex@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHXZ 003e ??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QBEPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z 005c ?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z 0076 ?SetDetached@WorkQueue@details@Concurrency@@QAEX_N@Z 007e ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D EC 8B 4D EC 83 C1 78 E8 ?? ?? ?? ?? 89 45 FC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D FC 7D 56 8B 55 F8 52 8B 4D EC 83 C1 78 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 3C 6A 00 8B 45 F8 50 8B 4D F4 51 8B 4D EC 83 C1 78 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 20 8B 45 F4 8B 48 08 89 4D F0 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8B 45 F0 EB 04 EB 99 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_54_0 {
	meta:
		name = "?RetireDetachedQueue@ScheduleGroupBase@details@Concurrency@@QAEXPAVWorkQueue@23@@Z"
		size = 87
		refs = "0018 ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@_N@Z 0038 ??_C@_0DN@FBKLHFDA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003d ??_C@_0CA@NDGJCOI@m_workQueues?4Remove?$CIpWorkQueue?$CJ?$AA@ 0042 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 004d ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 6A 01 8B 45 08 50 8B 4D F8 83 C1 10 E8 ?? ?? ?? ?? 0F B6 C8 F7 D9 1B C9 F7 D9 88 4D FF 0F B6 55 FF 85 D2 74 02 EB 17 68 90 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_55_0 {
	meta:
		name = "?GetRealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ"
		size = 54
		refs = "0012 ?Empty@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 0028 ?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 33 C0 EB 11 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_56_0 {
	meta:
		name = "?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z"
		size = 86
		refs = "0012 ?GetInternalContext@SchedulerBase@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0027 ??_C@_0DN@FBKLHFDA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 002c ??_C@_0BB@DCHEAJGK@pContext?5?$CB?$DN?5NULL?$AA@ 0031 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0049 ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAU_Chore@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 64 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 02 EB 17 68 AF 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 0F B6 4D 0C 51 8B 55 08 52 8B 45 F8 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_28_57_0 {
	meta:
		name = "?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z"
		size = 38
		refs = "000d ?RemoveFromUse@InternalContextBase@details@Concurrency@@QAEXXZ 001c ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC 8B 49 64 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_58_0 {
	meta:
		name = "?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
		size = 33
		altNames = "?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 55 FC 8B 02 33 D2 3B C8 0F 9E C2 8A C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_60_0 {
	meta:
		name = "?MarkDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ"
		size = 57
		refs = "0016 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0031 ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 10 51 8D 4D FC E8 ?? ?? ?? ?? 8B 55 F8 C6 42 14 01 8B 45 F8 8B 48 04 8B 55 F8 89 4A 18 8D 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_61_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_104_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 36
		refs = "0017 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_763_24_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_635_56_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?AcquireWrite@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_72_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_124_64_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_32_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_480_23_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_850_56_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_597_142_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 36
		refs = "0017 ?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_226_101_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 36
		refs = "0017 ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_62_0 {
	meta:
		name = "??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_105_0 {
	meta:
		name = "??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_763_25_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_635_57_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?ReleaseWrite@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_984_53_0 {
	meta:
		name = "??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_65_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_392_6_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_47_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_256_0 {
	meta:
		name = "??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_850_57_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_51_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_597_143_0 {
	meta:
		name = "??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_79_0 {
	meta:
		name = "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_100_0 {
	meta:
		name = "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_102_0 {
	meta:
		name = "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 23
		refs = "000f ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_63_0 {
	meta:
		name = "?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
		size = 668
		refs = "0008 __ehhandler$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z 0017 ___security_cookie 015c ??_U@YAPAXI@Z 017d _memset 0187 ??2@YAPAXI@Z 01a6 ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z 020d ?_UnderlyingYield@details@Concurrency@@YAXXZ 0215 ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 021d ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 024a ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 024f ??_C@_0EB@GPLICCGB@inserted?5?$DN?$DN?5true?5?$HM?$HM?5?$CIinserted?5?$DN?$DN@ 0254 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 027c ??_C@_0L@MKDLGBOI@index?5?$DO?$DN?50?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 48 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C6 45 F3 00 C7 45 EC 00 00 00 00 8B 45 B0 8B 48 30 89 4D E8 0F B6 55 F3 85 D2 0F 85 1F 02 00 00 8B 45 E8 83 78 08 FF 0F 8C 9D 00 00 00 8B 4D E8 8B 11 89 55 E4 C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D B0 8B 55 E0 3B 51 28 7D 78 8B 45 E0 8B 4D E4 83 3C 81 00 74 02 EB DE 8B 55 EC 03 55 E0 8B 45 08 89 10 8B 4D B0 8B 51 40 89 55 DC 8B 4D 08 8B 55 E0 8B 45 E4 8D 14 90 33 C0 F0 0F B1 0A 89 45 D8 83 7D D8 00 75 36 C6 45 F3 01 8B 45 EC 03 45 E0 89 45 EC 8B 4D EC 3B 4D DC 7C 0F 8B 55 B0 83 C2 40 B8 01 00 00 00 F0 0F C1 02 8B 45 E0 83 C9 FF 8B 55 E8 83 C2 08 F0 0F B1 0A EB 05 E9 74 FF FF FF 0F B6 45 F3 85 C0 0F 85 2A 01 00 00 B9 FE FF FF FF 8B 55 E8 83 C2 08 83 C8 FF F0 0F B1 0A 8B 45 B0 8B 4D EC 03 48 28 89 4D EC 8B 55 E8 83 7A 04 00 0F 85 D8 00 00 00 B9 01 00 00 00 8B 55 E8 83 C2 04 33 C0 F0 0F B1 0A 85 C0 0F 85 BF 00 00 00 33 C9 8B 55 B0 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 BC 8B 45 BC 89 45 D4 8B 4D B0 8B 51 28 C1 E2 02 52 6A 00 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 B4 C7 45 FC 00 00 00 00 83 7D B4 00 74 11 8B 4D D4 51 8B 4D B4 E8 ?? ?? ?? ?? 89 45 AC EB 07 C7 45 AC 00 00 00 00 8B 55 AC 89 55 B8 C7 45 FC FF FF FF FF 8B 45 B8 89 45 D0 8B 4D B0 8B 55 B0 8B 41 3C 3B 42 38 7D 21 8B 4D B0 8B 51 3C 8B 45 B0 8B 48 34 8B 45 D0 89 04 91 8B 4D B0 8B 51 3C 83 C2 01 8B 45 B0 89 50 3C 8B 4D D0 8B 55 E8 83 C2 04 87 0A 8B 45 E8 83 78 04 01 75 1E 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8B 4D E8 83 79 04 01 74 EF 0F B6 55 F3 83 FA 01 74 28 0F B6 45 F3 85 C0 75 09 8B 4D E8 83 79 04 00 75 17 68 8C 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E8 8B 42 04 89 45 E8 E9 D5 FD FF FF 83 7D EC 00 7C 02 EB 17 68 92 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_92_0 {
	meta:
		name = "?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
		size = 668
		refs = "0008 __ehhandler$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 0017 ___security_cookie 015c ??_U@YAPAXI@Z 017d _memset 0187 ??2@YAPAXI@Z 01a6 ??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 020d ?_UnderlyingYield@details@Concurrency@@YAXXZ 0215 ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 021d ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 024a ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 024f ??_C@_0EB@GPLICCGB@inserted?5?$DN?$DN?5true?5?$HM?$HM?5?$CIinserted?5?$DN?$DN@ 0254 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 027c ??_C@_0L@MKDLGBOI@index?5?$DO?$DN?50?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 48 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D B0 C6 45 F3 00 C7 45 EC 00 00 00 00 8B 45 B0 8B 48 30 89 4D E8 0F B6 55 F3 85 D2 0F 85 1F 02 00 00 8B 45 E8 83 78 08 FF 0F 8C 9D 00 00 00 8B 4D E8 8B 11 89 55 E4 C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D B0 8B 55 E0 3B 51 28 7D 78 8B 45 E0 8B 4D E4 83 3C 81 00 74 02 EB DE 8B 55 EC 03 55 E0 8B 45 08 89 10 8B 4D B0 8B 51 40 89 55 DC 8B 4D 08 8B 55 E0 8B 45 E4 8D 14 90 33 C0 F0 0F B1 0A 89 45 D8 83 7D D8 00 75 36 C6 45 F3 01 8B 45 EC 03 45 E0 89 45 EC 8B 4D EC 3B 4D DC 7C 0F 8B 55 B0 83 C2 40 B8 01 00 00 00 F0 0F C1 02 8B 45 E0 83 C9 FF 8B 55 E8 83 C2 08 F0 0F B1 0A EB 05 E9 74 FF FF FF 0F B6 45 F3 85 C0 0F 85 2A 01 00 00 B9 FE FF FF FF 8B 55 E8 83 C2 08 83 C8 FF F0 0F B1 0A 8B 45 B0 8B 4D EC 03 48 28 89 4D EC 8B 55 E8 83 7A 04 00 0F 85 D8 00 00 00 B9 01 00 00 00 8B 55 E8 83 C2 04 33 C0 F0 0F B1 0A 85 C0 0F 85 BF 00 00 00 33 C9 8B 55 B0 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 BC 8B 45 BC 89 45 D4 8B 4D B0 8B 51 28 C1 E2 02 52 6A 00 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 B4 C7 45 FC 00 00 00 00 83 7D B4 00 74 11 8B 4D D4 51 8B 4D B4 E8 ?? ?? ?? ?? 89 45 AC EB 07 C7 45 AC 00 00 00 00 8B 55 AC 89 55 B8 C7 45 FC FF FF FF FF 8B 45 B8 89 45 D0 8B 4D B0 8B 55 B0 8B 41 3C 3B 42 38 7D 21 8B 4D B0 8B 51 3C 8B 45 B0 8B 48 34 8B 45 D0 89 04 91 8B 4D B0 8B 51 3C 83 C2 01 8B 45 B0 89 50 3C 8B 4D D0 8B 55 E8 83 C2 04 87 0A 8B 45 E8 83 78 04 01 75 1E 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8B 4D E8 83 79 04 01 74 EF 0F B6 55 F3 83 FA 01 74 28 0F B6 45 F3 85 C0 75 09 8B 4D E8 83 79 04 00 75 17 68 8C 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E8 8B 42 04 89 45 E8 E9 D5 FD FF FF 83 7D EC 00 7C 02 EB 17 68 92 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_65_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_94_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_52_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_25_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_121_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_18_0 {
	meta:
		name = "__ehhandler$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_3_0 {
	meta:
		name = "__ehhandler$?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_66_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"
		size = 37
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 8B 4D FC 8B 55 08 89 51 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_67_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 284
		refs = "0024 $LN17 002c ?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ 0055 ?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ 0084 ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0090 ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0097 __CrtDbgReportW 00cd ?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ 00d9 ?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ 00f9 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 0108 $LN2 010c $LN11 0110 $LN6 0114 $LN4 0118 $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D F4 8B 45 F4 8B 48 08 89 4D F0 83 7D F0 04 0F 87 E1 00 00 00 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? 89 45 FC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D FC 73 04 F3 90 EB EB 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 13 8B 45 F4 8B 48 04 F7 D9 1B C9 83 C1 03 8B 55 F4 89 4A 08 B0 01 E9 87 00 00 00 8B 45 F4 83 78 04 00 77 21 68 ?? ?? ?? ?? 6A 00 68 F9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 F4 8B 42 04 83 E8 01 89 45 EC 8B 4D F4 8B 55 EC 89 51 04 83 7D EC 00 75 0A 8B 45 F4 C7 40 08 03 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? B0 01 EB 2C 8B 4D F4 E8 ?? ?? ?? ?? 32 C0 EB 20 8B 4D F4 E8 ?? ?? ?? ?? 32 C0 EB 14 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? EB 02 32 C0 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_75_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"
		size = 284
		refs = "0024 $LN17 002c ?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ 0055 ?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ 0084 ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0090 ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0097 __CrtDbgReportW 00cd ?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ 00d9 ?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ 00f9 ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 0108 $LN2 010c $LN11 0110 $LN6 0114 $LN4 0118 $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D F4 8B 45 F4 8B 48 08 89 4D F0 83 7D F0 04 0F 87 E1 00 00 00 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? 89 45 FC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D FC 73 04 F3 90 EB EB 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 13 8B 45 F4 8B 48 04 F7 D9 1B C9 83 C1 03 8B 55 F4 89 4A 08 B0 01 E9 87 00 00 00 8B 45 F4 83 78 04 00 77 21 68 ?? ?? ?? ?? 6A 00 68 F9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 F4 8B 42 04 83 E8 01 89 45 EC 8B 4D F4 8B 55 EC 89 51 04 83 7D EC 00 75 0A 8B 45 F4 C7 40 08 03 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? B0 01 EB 2C 8B 4D F4 E8 ?? ?? ?? ?? 32 C0 EB 20 8B 4D F4 E8 ?? ?? ?? ?? 32 C0 EB 14 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D F4 E8 ?? ?? ?? ?? EB 02 32 C0 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_68_0 {
	meta:
		name = "?MaxIndex@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHXZ"
		size = 19
		altNames = "?GetExecutionContext@FreeThreadProxy@details@Concurrency@@QAEPAUIExecutionContext@3@XZ ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ ?MaxIndex@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHXZ ?MaxIndex@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHXZ ?MaxIndex@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHXZ ?MaxIndex@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 40 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_69_0 {
	meta:
		name = "?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
		size = 108
		refs = "0008 __ehhandler$?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0017 ___security_cookie 0035 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0048 ?Enqueue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0057 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 108
		refs = "0008 __ehhandler$?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0017 ___security_cookie 0035 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0048 ?Enqueue@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0057 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_29_0 {
	meta:
		name = "?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 108
		refs = "0008 __ehhandler$?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0017 ___security_cookie 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0048 ?Enqueue@?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0057 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D EC E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_71_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_242_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_247_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_268_3 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_247_3 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_247_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_268_3 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_69_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_201_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_78_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_24_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_204_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_75_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_902_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_809_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_894_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_891_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_893_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_890_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_619_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_302_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_656_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_266_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_613_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_650_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_49_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_224_3 {
	meta:
		name = "__ehhandler$??1?$_String_val@DV?$allocator@D@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_val@DV?$allocator@D@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1077_2 {
	meta:
		name = "__ehhandler$??1?$_String_val@GV?$allocator@G@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_val@GV?$allocator@G@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_678_2 {
	meta:
		name = "__ehhandler$??1?$_String_val@_WV?$allocator@_W@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_String_val@_WV?$allocator@_W@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_706_15_0 {
	meta:
		name = "__ehhandler$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_68_3 {
	meta:
		name = "__ehhandler$??1_Iterator_base12@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Iterator_base12@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_763_17_0 {
	meta:
		name = "__ehhandler$?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_254_0 {
	meta:
		name = "__ehhandler$?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_691_4_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_31_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_13_0 {
	meta:
		name = "__ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_25_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_18_0 {
	meta:
		name = "__ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_834_37_0 {
	meta:
		name = "__ehhandler$?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_42_0 {
	meta:
		name = "__ehhandler$?RemoveThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_37_0 {
	meta:
		name = "__ehhandler$?ThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_157_0 {
	meta:
		name = "__ehhandler$?_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@EAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@tr1@std@@EAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_61_2 {
	meta:
		name = "__ehhandler$?_Fac_tidy@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Fac_tidy@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_38_2 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_53_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_74_0 {
	meta:
		name = "?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
		size = 108
		refs = "0008 __ehhandler$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ 0017 ___security_cookie 0035 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0044 ?Dequeue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAVRealizedChore@23@XZ 0056 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E8 8B 45 E8 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E8 E8 ?? ?? ?? ?? 89 45 EC C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_61_0 {
	meta:
		name = "?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 108
		refs = "0008 __ehhandler$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0017 ___security_cookie 0035 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0044 ?Dequeue@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0056 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E8 8B 45 E8 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E8 E8 ?? ?? ?? ?? 89 45 EC C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_36_0 {
	meta:
		name = "?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ"
		size = 108
		refs = "0008 __ehhandler$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 0017 ___security_cookie 0035 ??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0044 ?Dequeue@?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 0056 ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E8 8B 45 E8 83 C0 08 50 8D 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E8 E8 ?? ?? ?? ?? 89 45 EC C7 45 FC FF FF FF FF 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_76_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_126_0 {
	meta:
		name = "__ehhandler$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_71_1 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_99_3 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_99_3 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_12_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_9_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_5_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_12_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_689_12_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_21_0 {
	meta:
		name = "__ehhandler$?CreateFactory@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_60_0 {
	meta:
		name = "__ehhandler$?CreateFactory@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_63_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_38_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_83_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_3_0 {
	meta:
		name = "__ehhandler$?EnsureSingleton@Etw@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?EnsureSingleton@Etw@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_480_27_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_259_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_33_0 {
	meta:
		name = "__ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_948_16_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_91_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_164_3 {
	meta:
		name = "__ehhandler$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_993_8_0 {
	meta:
		name = "__ehhandler$?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_77_0 {
	meta:
		name = "??0?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 34
		altNames = "??0?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC 8B 55 FC 89 51 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_78_0 {
	meta:
		name = "?Empty@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
		size = 26
		altNames = "?Empty@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ ?Empty@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QBE_NXZ ?Empty@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?Empty@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?_Empty@?$_Yarn@D@std@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 33 C9 83 38 00 0F 94 C1 8A C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_79_0 {
	meta:
		name = "??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 490
		refs = "0008 __ehhandler$??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___security_cookie 00f2 ??_U@YAPAXI@Z 0113 _memset 011d ??2@YAPAXI@Z 013c ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z 01a1 __imp__InitializeSListHead@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D8 8B 45 D8 C7 40 10 00 00 00 00 8B 4D D8 8B 55 08 89 51 24 8B 45 D8 C7 40 2C 00 00 00 00 8B 4D D8 C7 41 30 00 00 00 00 8B 55 D8 C7 42 38 00 02 00 00 8B 45 D8 C7 40 3C 01 00 00 00 8B 4D D8 C7 41 40 00 00 00 00 8B 55 D8 8B 45 10 89 42 44 8B 4D D8 C7 41 48 00 00 00 00 8B 55 0C 83 EA 01 23 55 0C 74 44 8B 45 0C D1 F8 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 02 0B 4D 0C 89 4D 0C 8B 55 0C C1 FA 04 0B 55 0C 89 55 0C 8B 45 0C C1 F8 08 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 10 0B 4D 0C 89 4D 0C 8B 55 0C 83 C2 01 89 55 0C 8B 45 D8 8B 4D 0C 89 48 28 33 C9 8B 55 D8 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 45 E8 89 45 EC 8B 4D D8 8B 51 28 C1 E2 02 52 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 11 8B 4D EC 51 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 E4 C7 45 FC FF FF FF FF 8B 45 D8 8B 4D E4 89 48 30 33 C9 8B 55 D8 8B 42 38 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 D8 8B 4D DC 89 48 34 8B 55 D8 8B 42 34 8B 4D D8 8B 51 30 89 10 8B 45 D8 50 FF 15 ?? ?? ?? ?? 8B 4D D8 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 D8 8B 42 28 89 45 F0 8B 4D F0 D1 F9 89 4D F0 74 11 8B 55 D8 8B 42 2C 83 C0 01 8B 4D D8 89 41 2C EB E5 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_28_87_0 {
	meta:
		name = "??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 490
		refs = "0008 __ehhandler$??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___security_cookie 00f2 ??_U@YAPAXI@Z 0113 _memset 011d ??2@YAPAXI@Z 013c ??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 01a1 __imp__InitializeSListHead@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D8 8B 45 D8 C7 40 10 00 00 00 00 8B 4D D8 8B 55 08 89 51 24 8B 45 D8 C7 40 2C 00 00 00 00 8B 4D D8 C7 41 30 00 00 00 00 8B 55 D8 C7 42 38 00 02 00 00 8B 45 D8 C7 40 3C 01 00 00 00 8B 4D D8 C7 41 40 00 00 00 00 8B 55 D8 8B 45 10 89 42 44 8B 4D D8 C7 41 48 00 00 00 00 8B 55 0C 83 EA 01 23 55 0C 74 44 8B 45 0C D1 F8 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 02 0B 4D 0C 89 4D 0C 8B 55 0C C1 FA 04 0B 55 0C 89 55 0C 8B 45 0C C1 F8 08 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 10 0B 4D 0C 89 4D 0C 8B 55 0C 83 C2 01 89 55 0C 8B 45 D8 8B 4D 0C 89 48 28 33 C9 8B 55 D8 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 45 E8 89 45 EC 8B 4D D8 8B 51 28 C1 E2 02 52 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 11 8B 4D EC 51 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 E4 C7 45 FC FF FF FF FF 8B 45 D8 8B 4D E4 89 48 30 33 C9 8B 55 D8 8B 42 38 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 D8 8B 4D DC 89 48 34 8B 55 D8 8B 42 34 8B 4D D8 8B 51 30 89 10 8B 45 D8 50 FF 15 ?? ?? ?? ?? 8B 4D D8 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 D8 8B 42 28 89 45 F0 8B 4D F0 D1 F9 89 4D F0 74 11 8B 55 D8 8B 42 2C 83 C0 01 8B 4D D8 89 41 2C EB E5 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_303_261_0 {
	meta:
		name = "??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 490
		refs = "0008 __ehhandler$??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___security_cookie 00f2 ??_U@YAPAXI@Z 0113 _memset 011d ??2@YAPAXI@Z 013c ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z 01a1 __imp__InitializeSListHead@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D8 8B 45 D8 C7 40 10 00 00 00 00 8B 4D D8 8B 55 08 89 51 24 8B 45 D8 C7 40 2C 00 00 00 00 8B 4D D8 C7 41 30 00 00 00 00 8B 55 D8 C7 42 38 00 02 00 00 8B 45 D8 C7 40 3C 01 00 00 00 8B 4D D8 C7 41 40 00 00 00 00 8B 55 D8 8B 45 10 89 42 44 8B 4D D8 C7 41 48 00 00 00 00 8B 55 0C 83 EA 01 23 55 0C 74 44 8B 45 0C D1 F8 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 02 0B 4D 0C 89 4D 0C 8B 55 0C C1 FA 04 0B 55 0C 89 55 0C 8B 45 0C C1 F8 08 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 10 0B 4D 0C 89 4D 0C 8B 55 0C 83 C2 01 89 55 0C 8B 45 D8 8B 4D 0C 89 48 28 33 C9 8B 55 D8 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 45 E8 89 45 EC 8B 4D D8 8B 51 28 C1 E2 02 52 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 11 8B 4D EC 51 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 E4 C7 45 FC FF FF FF FF 8B 45 D8 8B 4D E4 89 48 30 33 C9 8B 55 D8 8B 42 38 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 D8 8B 4D DC 89 48 34 8B 55 D8 8B 42 34 8B 4D D8 8B 51 30 89 10 8B 45 D8 50 FF 15 ?? ?? ?? ?? 8B 4D D8 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 D8 8B 42 28 89 45 F0 8B 4D F0 D1 F9 89 4D F0 74 11 8B 55 D8 8B 42 2C 83 C0 01 8B 4D D8 89 41 2C EB E5 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_486_46_0 {
	meta:
		name = "??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 490
		refs = "0008 __ehhandler$??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___security_cookie 00f2 ??_U@YAPAXI@Z 0113 _memset 011d ??2@YAPAXI@Z 013c ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z 01a1 __imp__InitializeSListHead@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D8 8B 45 D8 C7 40 10 00 00 00 00 8B 4D D8 8B 55 08 89 51 24 8B 45 D8 C7 40 2C 00 00 00 00 8B 4D D8 C7 41 30 00 00 00 00 8B 55 D8 C7 42 38 00 02 00 00 8B 45 D8 C7 40 3C 01 00 00 00 8B 4D D8 C7 41 40 00 00 00 00 8B 55 D8 8B 45 10 89 42 44 8B 4D D8 C7 41 48 00 00 00 00 8B 55 0C 83 EA 01 23 55 0C 74 44 8B 45 0C D1 F8 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 02 0B 4D 0C 89 4D 0C 8B 55 0C C1 FA 04 0B 55 0C 89 55 0C 8B 45 0C C1 F8 08 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 10 0B 4D 0C 89 4D 0C 8B 55 0C 83 C2 01 89 55 0C 8B 45 D8 8B 4D 0C 89 48 28 33 C9 8B 55 D8 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 45 E8 89 45 EC 8B 4D D8 8B 51 28 C1 E2 02 52 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 11 8B 4D EC 51 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 E4 C7 45 FC FF FF FF FF 8B 45 D8 8B 4D E4 89 48 30 33 C9 8B 55 D8 8B 42 38 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 D8 8B 4D DC 89 48 34 8B 55 D8 8B 42 34 8B 4D D8 8B 51 30 89 10 8B 45 D8 50 FF 15 ?? ?? ?? ?? 8B 4D D8 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 D8 8B 42 28 89 45 F0 8B 4D F0 D1 F9 89 4D F0 74 11 8B 55 D8 8B 42 2C 83 C0 01 8B 4D D8 89 41 2C EB E5 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_749_19_0 {
	meta:
		name = "??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 490
		refs = "0008 __ehhandler$??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___security_cookie 00f2 ??_U@YAPAXI@Z 0113 _memset 011d ??2@YAPAXI@Z 013c ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z 01a1 __imp__InitializeSListHead@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D8 8B 45 D8 C7 40 10 00 00 00 00 8B 4D D8 8B 55 08 89 51 24 8B 45 D8 C7 40 2C 00 00 00 00 8B 4D D8 C7 41 30 00 00 00 00 8B 55 D8 C7 42 38 00 02 00 00 8B 45 D8 C7 40 3C 01 00 00 00 8B 4D D8 C7 41 40 00 00 00 00 8B 55 D8 8B 45 10 89 42 44 8B 4D D8 C7 41 48 00 00 00 00 8B 55 0C 83 EA 01 23 55 0C 74 44 8B 45 0C D1 F8 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 02 0B 4D 0C 89 4D 0C 8B 55 0C C1 FA 04 0B 55 0C 89 55 0C 8B 45 0C C1 F8 08 0B 45 0C 89 45 0C 8B 4D 0C C1 F9 10 0B 4D 0C 89 4D 0C 8B 55 0C 83 C2 01 89 55 0C 8B 45 D8 8B 4D 0C 89 48 28 33 C9 8B 55 D8 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 45 E8 89 45 EC 8B 4D D8 8B 51 28 C1 E2 02 52 6A 00 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 0C E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 11 8B 4D EC 51 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 E4 C7 45 FC FF FF FF FF 8B 45 D8 8B 4D E4 89 48 30 33 C9 8B 55 D8 8B 42 38 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 D8 8B 4D DC 89 48 34 8B 55 D8 8B 42 34 8B 4D D8 8B 51 30 89 10 8B 45 D8 50 FF 15 ?? ?? ?? ?? 8B 4D D8 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 D8 8B 42 28 89 45 F0 8B 4D F0 D1 F9 89 4D F0 74 11 8B 55 D8 8B 42 2C 83 C0 01 8B 4D D8 89 41 2C EB E5 8B 45 D8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_28_81_0 {
	meta:
		name = "__ehhandler$??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_89_0 {
	meta:
		name = "__ehhandler$??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_263_0 {
	meta:
		name = "__ehhandler$??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_48_0 {
	meta:
		name = "__ehhandler$??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_749_21_0 {
	meta:
		name = "__ehhandler$??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_768_4_0 {
	meta:
		name = "__ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_882_1 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_829_3 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_37_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_13_0 {
	meta:
		name = "__ehhandler$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_317_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_852_1 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_738_1 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_15_3 {
	meta:
		name = "__ehhandler$?_Pop@_Micro_queue@details@Concurrency@@QAE_NPAXIAAV_Concurrent_queue_base_v4@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Pop@_Micro_queue@details@Concurrency@@QAE_NPAXIAAV_Concurrent_queue_base_v4@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_199_3 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_104_2 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_521_2 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_474_3 {
	meta:
		name = "__ehhandler$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_20_0 {
	meta:
		name = "__ehhandler$?reset@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reset@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_202_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_107_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_524_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_852_2 {
	meta:
		name = "__ehhandler$?unlink_target@_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@2@ABI@Z@UAEX0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@2@ABI@Z@UAEX0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_799_2 {
	meta:
		name = "__ehhandler$?unlink_target@_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@2@ABW4agent_status@2@@Z@UAEX0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@2@ABW4agent_status@2@@Z@UAEX0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_82_0 {
	meta:
		name = "??1?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 225
		refs = "0011 __imp__InterlockedFlushSList@4 0020 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0088 ??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z 00a7 ??_V@YAXPAX@Z 00b9 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 89 4D E0 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 8B 4D E0 E8 ?? ?? ?? ?? 8B 55 E0 83 C2 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 8B 51 10 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 30 89 4D F8 83 7D F8 00 74 6A C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 E0 8B 4D F0 3B 48 28 7D 16 8B 55 F8 8B 02 8B 4D F0 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 EB D6 8B 45 F8 8B 48 04 89 4D F4 8B 55 F8 8B 02 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 89 4D F8 EB 90 8B 55 E0 8B 42 34 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_90_0 {
	meta:
		name = "??1?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 225
		refs = "0011 __imp__InterlockedFlushSList@4 0020 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0088 ??$_InternalDeleteHelper@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@YAXPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@01@@Z 00a7 ??_V@YAXPAX@Z 00b9 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 89 4D E0 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 8B 4D E0 E8 ?? ?? ?? ?? 8B 55 E0 83 C2 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 8B 51 10 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 30 89 4D F8 83 7D F8 00 74 6A C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 E0 8B 4D F0 3B 48 28 7D 16 8B 55 F8 8B 02 8B 4D F0 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 EB D6 8B 45 F8 8B 48 04 89 4D F4 8B 55 F8 8B 02 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 89 4D F8 EB 90 8B 55 E0 8B 42 34 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_264_0 {
	meta:
		name = "??1?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 225
		refs = "0011 __imp__InterlockedFlushSList@4 0020 ?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0088 ??$_InternalDeleteHelper@VExternalStatistics@details@Concurrency@@@details@Concurrency@@YAXPAVExternalStatistics@01@@Z 00a7 ??_V@YAXPAX@Z 00b9 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 89 4D E0 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 8B 4D E0 E8 ?? ?? ?? ?? 8B 55 E0 83 C2 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 8B 51 10 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 30 89 4D F8 83 7D F8 00 74 6A C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 E0 8B 4D F0 3B 48 28 7D 16 8B 55 F8 8B 02 8B 4D F0 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 EB D6 8B 45 F8 8B 48 04 89 4D F4 8B 55 F8 8B 02 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 89 4D F8 EB 90 8B 55 E0 8B 42 34 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_49_0 {
	meta:
		name = "??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 225
		refs = "0011 __imp__InterlockedFlushSList@4 0020 ?DeleteElements@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0088 ??$_InternalDeleteHelper@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@YAXPAVScheduleGroupBase@01@@Z 00a7 ??_V@YAXPAX@Z 00b9 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 89 4D E0 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 8B 4D E0 E8 ?? ?? ?? ?? 8B 55 E0 83 C2 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 8B 51 10 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 30 89 4D F8 83 7D F8 00 74 6A C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 E0 8B 4D F0 3B 48 28 7D 16 8B 55 F8 8B 02 8B 4D F0 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 EB D6 8B 45 F8 8B 48 04 89 4D F4 8B 55 F8 8B 02 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 89 4D F8 EB 90 8B 55 E0 8B 42 34 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_749_22_0 {
	meta:
		name = "??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 225
		refs = "0011 __imp__InterlockedFlushSList@4 0020 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0088 ??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPAVVirtualProcessor@01@@Z 00a7 ??_V@YAXPAX@Z 00b9 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 89 4D E0 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 8B 4D E0 E8 ?? ?? ?? ?? 8B 55 E0 83 C2 08 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 8B 51 10 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 30 89 4D F8 83 7D F8 00 74 6A C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 E0 8B 4D F0 3B 48 28 7D 16 8B 55 F8 8B 02 8B 4D F0 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 EB D6 8B 45 F8 8B 48 04 89 4D F4 8B 55 F8 8B 02 89 45 EC 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F8 89 55 E8 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 89 4D F8 EB 90 8B 55 E0 8B 42 34 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_83_0 {
	meta:
		name = "?IsEmptyAtSafePoint@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NXZ"
		size = 92
		altNames = "?IsEmptyAtSafePoint@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 8B 48 30 89 4D FC 83 7D FC 00 74 3C C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F4 8B 4D F8 3B 48 28 7D 14 8B 55 FC 8B 02 8B 4D F8 83 3C 88 00 74 04 32 C0 EB 0F EB D8 8B 55 FC 8B 42 04 89 45 FC EB BE B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_84_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@_N@Z"
		size = 39
		refs = "001d ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 0C 50 8B 4D 08 8B 51 40 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_28_85_0 {
	meta:
		name = "??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QBEPAVWorkQueue@12@H@Z"
		size = 163
		altNames = "??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QBEPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z ??A?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QBEPAVExternalStatistics@12@H@Z ??A?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QBEPAVScheduleGroupBase@12@H@Z ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F0 8B 45 F0 8B 55 08 8B 48 2C D3 FA 89 55 FC 8B 45 F0 8B 4D FC 3B 48 3C 7C 04 33 C0 EB 75 C7 45 F8 00 00 00 00 8B 55 F0 8B 45 FC 3B 42 38 7C 40 8B 4D F0 8B 51 38 8B 45 F0 8B 48 34 8B 54 91 FC 89 55 F8 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 8B 4D F0 8B 55 FC 2B 51 38 39 55 F4 7F 0B 8B 45 F8 8B 48 04 89 4D F8 EB DE EB 0F 8B 55 F0 8B 42 34 8B 4D FC 8B 14 88 89 55 F8 8B 45 F0 8B 48 28 83 E9 01 23 4D 08 8B 55 F8 8B 02 8B 04 88 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_95_0 {
	meta:
		name = "?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@_N@Z"
		size = 38
		refs = "001c ?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 0C 50 8B 4D 08 8B 11 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_303_265_0 {
	meta:
		name = "?Remove@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE_NPAVExternalStatistics@23@_N@Z"
		size = 38
		refs = "001c ?Remove@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE_NPAVExternalStatistics@23@H_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 0C 50 8B 4D 08 8B 11 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_28_96_0 {
	meta:
		name = "?Remove@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE_NPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@H_N@Z"
		size = 497
		refs = "00f4 __imp__QueryDepthSList@4 011b ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0120 ??_C@_0DB@OAPOABKA@m_deletionThreshold?5?$CB?$DN?5DeletionT@ 0125 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 013c __imp__InterlockedPushEntrySList@8 0165 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 019b ??_C@_0BH@JHEKOJJN@m_deletionList?5?$DN?$DN?5NULL?$AA@ 01b0 __imp__InterlockedFlushSList@4 01c6 ?CheckForDeletionBridge@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 01d1 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 89 4D DC 8B 45 DC 8B 55 0C 8B 48 2C D3 FA 89 55 FC 8B 45 DC 8B 48 28 83 E9 01 23 4D 0C 89 4D EC 8B 55 DC 8B 45 FC 3B 42 3C 7C 07 32 C0 E9 AF 01 00 00 C7 45 E8 00 00 00 00 8B 4D DC 8B 55 FC 3B 51 38 7C 40 8B 45 DC 8B 48 38 8B 55 DC 8B 42 34 8B 4C 88 FC 89 4D E8 C7 45 E4 00 00 00 00 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 DC 8B 4D FC 2B 48 38 39 4D E4 7F 0B 8B 55 E8 8B 42 04 89 45 E8 EB DE EB 0F 8B 4D DC 8B 51 34 8B 45 FC 8B 0C 82 89 4D E8 8B 55 E8 8B 02 89 45 F4 8B 4D 08 89 4D F8 8B 45 F8 33 D2 8B 4D EC 8B 75 F4 8D 0C 8E F0 0F B1 11 89 45 F0 8B 55 F0 3B 55 F8 75 14 8B 4D EC 8B 55 E8 83 C2 08 B8 FE FF FF FF F0 0F B1 0A EB 07 32 C0 E9 08 01 00 00 0F B6 45 10 85 C0 0F 84 FA 00 00 00 8B 4D DC 51 FF 15 ?? ?? ?? ?? 0F B7 D0 8B 45 DC 3B 50 44 0F 8E D0 00 00 00 8B 4D DC 81 79 44 FF FF FF 7F 74 02 EB 17 68 07 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 83 C2 04 52 8B 45 DC 83 C0 08 50 FF 15 ?? ?? ?? ?? 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 0F B7 D0 89 55 E0 8B 45 DC 8B 4D E0 3B 48 44 7E 77 8B 55 DC 8B 4A 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 65 B9 01 00 00 00 8B 55 DC 83 C2 48 33 C0 F0 0F B1 0A 85 C0 75 50 8B 45 DC 83 78 10 00 75 02 EB 17 68 18 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 DC 89 42 10 8B 45 DC 8B 48 24 51 8B 55 DC 52 68 ?? ?? ?? ?? 8B 4D DC 83 C1 14 E8 ?? ?? ?? ?? EB 11 8B 45 08 83 C0 04 50 8B 4D DC 51 FF 15 ?? ?? ?? ?? B0 01 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_303_330_0 {
	meta:
		name = "?Remove@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE_NPAVExternalStatistics@23@H_N@Z"
		size = 497
		refs = "00f4 __imp__QueryDepthSList@4 011b ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0120 ??_C@_0DB@OAPOABKA@m_deletionThreshold?5?$CB?$DN?5DeletionT@ 0125 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 013c __imp__InterlockedPushEntrySList@8 0165 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 019b ??_C@_0BH@JHEKOJJN@m_deletionList?5?$DN?$DN?5NULL?$AA@ 01b0 __imp__InterlockedFlushSList@4 01c6 ?CheckForDeletionBridge@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 01d1 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 89 4D DC 8B 45 DC 8B 55 0C 8B 48 2C D3 FA 89 55 FC 8B 45 DC 8B 48 28 83 E9 01 23 4D 0C 89 4D EC 8B 55 DC 8B 45 FC 3B 42 3C 7C 07 32 C0 E9 AF 01 00 00 C7 45 E8 00 00 00 00 8B 4D DC 8B 55 FC 3B 51 38 7C 40 8B 45 DC 8B 48 38 8B 55 DC 8B 42 34 8B 4C 88 FC 89 4D E8 C7 45 E4 00 00 00 00 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 DC 8B 4D FC 2B 48 38 39 4D E4 7F 0B 8B 55 E8 8B 42 04 89 45 E8 EB DE EB 0F 8B 4D DC 8B 51 34 8B 45 FC 8B 0C 82 89 4D E8 8B 55 E8 8B 02 89 45 F4 8B 4D 08 89 4D F8 8B 45 F8 33 D2 8B 4D EC 8B 75 F4 8D 0C 8E F0 0F B1 11 89 45 F0 8B 55 F0 3B 55 F8 75 14 8B 4D EC 8B 55 E8 83 C2 08 B8 FE FF FF FF F0 0F B1 0A EB 07 32 C0 E9 08 01 00 00 0F B6 45 10 85 C0 0F 84 FA 00 00 00 8B 4D DC 51 FF 15 ?? ?? ?? ?? 0F B7 D0 8B 45 DC 3B 50 44 0F 8E D0 00 00 00 8B 4D DC 81 79 44 FF FF FF 7F 74 02 EB 17 68 07 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 83 C2 04 52 8B 45 DC 83 C0 08 50 FF 15 ?? ?? ?? ?? 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 0F B7 D0 89 55 E0 8B 45 DC 8B 4D E0 3B 48 44 7E 77 8B 55 DC 8B 4A 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 65 B9 01 00 00 00 8B 55 DC 83 C2 48 33 C0 F0 0F B1 0A 85 C0 75 50 8B 45 DC 83 78 10 00 75 02 EB 17 68 18 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 DC 89 42 10 8B 45 DC 8B 48 24 51 8B 55 DC 52 68 ?? ?? ?? ?? 8B 4D DC 83 C1 14 E8 ?? ?? ?? ?? EB 11 8B 45 08 83 C0 04 50 8B 4D DC 51 FF 15 ?? ?? ?? ?? B0 01 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_28_99_0 {
	meta:
		name = "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 81
		refs = "0021 ??_C@_1DC@GPJLLKOM@?$AA_?$AAM?$AA_?$AAy?$AAi?$AAe?$AAl?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002d ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0034 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 C6 45 FF 01 0F B6 45 FF 85 C0 74 34 8B 4D F8 83 79 0C 00 75 21 68 ?? ?? ?? ?? 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 F8 8B 48 0C FF D1 EB 02 F3 90 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_100_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 79
		refs = "0014 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 001d ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z 002b ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0037 ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003e __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 79 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 44 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_81_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 79
		refs = "0014 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 001d ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z 002b ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0037 ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003e __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 79 08 00 75 21 68 ?? ?? ?? ?? 6A 00 68 44 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_101_0 {
	meta:
		name = "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ"
		size = 18
		altNames = "?GetContextKind@ThreadInternalContext@details@Concurrency@@UBE?AW4ContextKind@ContextBase@23@XZ ?_Getfalse@_Locinfo@std@@QBEPBDXZ ?_Gettrue@_Locinfo@std@@QBEPBDXZ ?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@UBEABVtype_info@@XZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@UBEABVtype_info@@XZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UBEABVtype_info@@XZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UBEABVtype_info@@XZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UBEABVtype_info@@XZ ?_Target_type@?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UBEABVtype_info@@XZ ?do_encoding@codecvt_base@std@@MBEHXZ ?do_max_length@codecvt_base@std@@MBEHXZ ?length@charNode@@UBEHXZ ?what@bad_function_call@tr1@std@@UBEPBDXZ ?what@bad_weak_ptr@tr1@std@@UBEPBDXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_102_0 {
	meta:
		name = "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ"
		size = 37
		altNames = "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 E9 01 8B 55 FC 89 0A 8B 45 FC 33 C9 3B 08 1B C0 F7 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_103_0 {
	meta:
		name = "?Enqueue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
		size = 79
		refs = "0017 ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001c ??_C@_0O@EJCMDNEL@pNode?5?$CB?$DN?5NULL?$AA@ 0021 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
		altNames = "?Enqueue@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QAEXPAVSafePointInvocation@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 83 7D 08 00 74 02 EB 17 68 26 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C7 40 0C 00 00 00 00 8B 4D FC 8B 51 04 8B 45 08 89 02 8B 4D 08 83 C1 0C 8B 55 FC 89 4A 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_104_0 {
	meta:
		name = "?Dequeue@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
		size = 68
		altNames = "?Dequeue@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QAEPAVSafePointInvocation@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 75 04 33 C0 EB 29 8B 4D F8 8B 11 89 55 FC 8B 45 F8 8B 08 8B 55 F8 8B 41 0C 89 02 8B 4D F8 83 39 00 75 09 8B 55 F8 8B 45 F8 89 42 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_105_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
		size = 497
		refs = "00f4 __imp__QueryDepthSList@4 011b ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0120 ??_C@_0DB@OAPOABKA@m_deletionThreshold?5?$CB?$DN?5DeletionT@ 0125 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 013c __imp__InterlockedPushEntrySList@8 0165 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 019b ??_C@_0BH@JHEKOJJN@m_deletionList?5?$DN?$DN?5NULL?$AA@ 01b0 __imp__InterlockedFlushSList@4 01c6 ?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 01d1 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 56 89 4D DC 8B 45 DC 8B 55 0C 8B 48 2C D3 FA 89 55 FC 8B 45 DC 8B 48 28 83 E9 01 23 4D 0C 89 4D EC 8B 55 DC 8B 45 FC 3B 42 3C 7C 07 32 C0 E9 AF 01 00 00 C7 45 E8 00 00 00 00 8B 4D DC 8B 55 FC 3B 51 38 7C 40 8B 45 DC 8B 48 38 8B 55 DC 8B 42 34 8B 4C 88 FC 89 4D E8 C7 45 E4 00 00 00 00 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 DC 8B 4D FC 2B 48 38 39 4D E4 7F 0B 8B 55 E8 8B 42 04 89 45 E8 EB DE EB 0F 8B 4D DC 8B 51 34 8B 45 FC 8B 0C 82 89 4D E8 8B 55 E8 8B 02 89 45 F4 8B 4D 08 89 4D F8 8B 45 F8 33 D2 8B 4D EC 8B 75 F4 8D 0C 8E F0 0F B1 11 89 45 F0 8B 55 F0 3B 55 F8 75 14 8B 4D EC 8B 55 E8 83 C2 08 B8 FE FF FF FF F0 0F B1 0A EB 07 32 C0 E9 08 01 00 00 0F B6 45 10 85 C0 0F 84 FA 00 00 00 8B 4D DC 51 FF 15 ?? ?? ?? ?? 0F B7 D0 8B 45 DC 3B 50 44 0F 8E D0 00 00 00 8B 4D DC 81 79 44 FF FF FF 7F 74 02 EB 17 68 07 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 83 C2 14 52 8B 45 DC 83 C0 08 50 FF 15 ?? ?? ?? ?? 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 0F B7 D0 89 55 E0 8B 45 DC 8B 4D E0 3B 48 44 7E 77 8B 55 DC 8B 4A 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 65 B9 01 00 00 00 8B 55 DC 83 C2 48 33 C0 F0 0F B1 0A 85 C0 75 50 8B 45 DC 83 78 10 00 75 02 EB 17 68 18 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D DC 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 DC 89 42 10 8B 45 DC 8B 48 24 51 8B 55 DC 52 68 ?? ?? ?? ?? 8B 4D DC 83 C1 14 E8 ?? ?? ?? ?? EB 11 8B 45 08 83 C0 14 50 8B 4D DC 51 FF 15 ?? ?? ?? ?? B0 01 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_28_106_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 54
		refs = "0027 ??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 1F 8B 45 08 83 E8 14 89 45 FC 8B 4D 08 8B 11 89 55 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB DB 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_108_0 {
	meta:
		name = "?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 54
		refs = "0027 ??$_InternalDeleteHelper@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@YAXPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 1F 8B 45 08 83 E8 04 89 45 FC 8B 4D 08 8B 11 89 55 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB DB 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_303_331_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 54
		refs = "0027 ??$_InternalDeleteHelper@VExternalStatistics@details@Concurrency@@@details@Concurrency@@YAXPAVExternalStatistics@01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 1F 8B 45 08 83 E8 04 89 45 FC 8B 4D 08 8B 11 89 55 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB DB 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_109_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z"
		size = 46
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 8B 45 FC C7 40 08 FF FF FF FF 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_112_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
		size = 103
		refs = "0013 ??_C@_1DE@FNIGIOLJ@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 001f ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0026 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 21 68 ?? ?? ?? ?? 6A 00 68 C9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 08 00 75 0C 8B 55 FC C7 42 08 04 00 00 00 EB 1C 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 01 00 00 00 8B 45 FC C7 40 08 01 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_114_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 68
		refs = "0010 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0028 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_348_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 68
		refs = "0010 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0028 ?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_486_80_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 68
		refs = "0010 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0028 ?DeleteElements@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_581_54_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 68
		refs = "0010 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0028 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_115_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 68
		refs = "0010 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0028 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_116_0 {
	meta:
		name = "??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z"
		size = 52
		refs = "0020 ??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 74 0F 6A 01 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_117_0 {
	meta:
		name = "??$_InternalDeleteHelper@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@YAXPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@01@@Z"
		size = 28
		refs = "0011 ??3@YAXPAX@Z"
		altNames = "??$_InternalDeleteHelper@VExternalStatistics@details@Concurrency@@@details@Concurrency@@YAXPAVExternalStatistics@01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_120_0 {
	meta:
		name = "??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 88
		refs = "0008 __ehhandler$??1WorkQueue@details@Concurrency@@QAE@XZ 0015 ___security_cookie 0036 ??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ 0045 ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 C7 45 FC 00 00 00 00 8B 4D F0 83 C1 48 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_123_0 {
	meta:
		name = "??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 36
		refs = "0019 ??_V@YAXPAX@Z"
		altNames = "??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 0C 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_124_0 {
	meta:
		name = "??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 36
		refs = "0019 ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 1C 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 33
		refs = "0018 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_403_3_0 {
	meta:
		name = "__aligned_recalloc_base"
		size = 33
		refs = "0018 __aligned_offset_recalloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_404_19_0 {
	meta:
		name = "__cftof"
		size = 33
		refs = "0018 __cftof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_731_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 33
		refs = "0018 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 33
		refs = "0018 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 33
		refs = "0018 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 33
		refs = "0018 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 33
		refs = "0018 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 33
		refs = "0018 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__ctime64_s"
		size = 483
		refs = "0009 ___security_cookie 003b ??_C@_1FM@LCOGKOBI@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn@ 0044 ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004b __CrtDbgReportW 005f __errno 0073 ??_C@_1BG@CFEMLMNL@?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAs?$AA?$AA@ 007d __invalid_parameter 00b1 ___crtDebugFillThreshold 00dc _memset 00f6 ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 01ab __localtime64_s 01c8 _asctime_s 01db @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 47 01 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D C4 EB 09 8B 55 0C 83 EA 01 89 55 C4 8B 45 C4 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8C 00 00 00 8B 4D 10 89 4D C0 8B 55 C0 83 7A 04 00 7F 1C 7C 08 8B 45 C0 83 38 00 73 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 EB 61 8B 4D 10 89 4D BC 8B 55 BC 83 7A 04 07 7C 1F 7F 0B 8B 45 BC 81 38 FF 6F 40 93 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 EB 33 8B 4D 10 51 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 83 7D D4 00 75 17 8D 45 D8 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D4 8B 45 D4 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__ctime64"
		size = 211
		refs = "0009 ___security_cookie 0025 ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 002e ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BC@LNHMEBEJ@?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 0067 __invalid_parameter 00a3 __localtime64_s 00b8 _asctime 00cb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 83 7D 08 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 53 8B 55 08 89 55 CC 8B 45 CC 83 78 04 00 7F 19 7C 08 8B 4D CC 83 39 00 73 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 EB 2B 8B 55 08 52 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 83 7D D4 00 75 10 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 EB 04 EB 02 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_954_1_0 {
	meta:
		name = "__wctime64"
		size = 211
		refs = "0009 ___security_cookie 0025 ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 002e ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0035 __CrtDbgReportW 0049 __errno 005d ??_C@_1BE@DGAEHIKH@?$AA_?$AAw?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 0067 __invalid_parameter 00a3 __localtime64_s 00b8 __wasctime 00cb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 83 7D 08 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 53 8B 55 08 89 55 CC 8B 45 CC 83 78 04 00 7F 19 7C 08 8B 4D CC 83 39 00 73 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 EB 2B 8B 55 08 52 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 83 7D D4 00 75 10 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 EB 04 EB 02 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__write"
		size = 545
		refs = "0008 __sehtable$__write 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008d ??_C@_1FO@EPLDPDDL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0094 __CrtDbgReportW 00c7 ??_C@_1O@KOFKDHPL@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA?$AA@ 00d1 __invalid_parameter 00f2 ___pioinfo 010a ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 016b ___lock_fhandle 01a6 __write_nolock 01d4 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0204 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B9 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2F 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__write_nolock"
		size = 2880
		refs = "000b __chkstk 0010 ___security_cookie 0054 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005d ??_C@_1FO@EPLDPDDL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0064 __CrtDbgReportW 0078 ___doserrno 0083 __errno 0097 ??_C@_1BM@NCANHCIP@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 00a1 __invalid_parameter 00c2 ___pioinfo 00f6 ??_C@_1CC@EEOLPHGO@?$AA?$CI?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$CG?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 017d __lseeki64_nolock 0189 __isatty 01b8 __getptd 01f1 __imp__GetConsoleMode@8 0216 __imp__GetConsoleCP@0 029b _isleadbyte 02a7 ??_C@_1DI@CNMHHHLG@?$AAi?$AAs?$AAl?$AAe?$AAa?$AAd?$AAb?$AAy?$AAt?$AAe?$AA?$CI?$AA_?$AAd?$AAb?$AAc?$AAs?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0315 _mbtowc 0445 __imp__WideCharToMultiByte@32 0483 __imp__WriteFile@20 04a8 __imp__GetLastError@0 0543 __putwch_nolock 0ad0 __dosmaperr 0b38 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC B8 90 3C 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 BC C7 45 E8 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 FC 89 45 EC 83 7D 10 00 75 07 33 C0 E9 F1 0A 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 82 0A 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 88 45 FB 0F BE 4D FB 83 F9 02 74 09 0F BE 55 FB 83 FA 01 75 6F 8B 45 10 83 E0 01 F7 D8 1B C0 83 C0 01 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E0 09 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 20 74 12 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 64 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 81 E2 80 00 00 00 74 41 E8 ?? ?? ?? ?? 89 45 D4 8B 45 D4 8B 48 6C 33 D2 83 79 14 00 0F 94 C2 89 55 E4 8D 45 D8 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 0F 84 C0 03 00 00 83 7D E4 00 74 0C 0F BE 55 FB 85 D2 0F 84 AE 03 00 00 FF 15 ?? ?? ?? ?? 89 45 C4 C7 45 C8 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 0C 89 45 D0 8B 4D D0 2B 4D 0C 3B 4D 10 0F 83 7D 03 00 00 0F BE 55 FB 85 D2 0F 85 A1 01 00 00 8B 45 D0 0F BE 08 33 D2 83 F9 0A 0F 94 C2 89 55 B0 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 83 7C 0A 38 00 0F 84 AD 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 34 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 AF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8A 54 01 34 88 55 B4 8B 45 D0 8A 08 88 4D B5 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? C7 44 01 38 00 00 00 00 6A 02 8D 55 B4 52 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 97 02 00 00 E9 B7 00 00 00 8B 4D D0 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 84 00 00 00 8B 45 D0 2B 45 0C 8B 4D 10 2B C8 83 F9 01 76 27 6A 02 8B 55 D0 52 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 4F 02 00 00 8B 4D D0 83 C1 01 89 4D D0 EB 4B 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 D0 8A 12 88 54 01 34 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? C7 44 0A 38 01 00 00 00 8B 45 FC 83 C0 01 89 45 FC E9 F9 01 00 00 EB 1C 6A 01 8B 4D D0 51 8D 55 C0 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 DB 01 00 00 8B 45 D0 83 C0 01 89 45 D0 EB 34 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 22 8B 45 D0 66 8B 08 66 89 4D C0 0F B7 55 C0 33 C0 83 FA 0A 0F 94 C0 89 45 B0 8B 4D D0 83 C1 02 89 4D D0 0F BE 55 FB 85 D2 0F 85 FE 00 00 00 6A 00 6A 00 6A 05 8D 45 B4 50 6A 01 8D 4D C0 51 6A 00 8B 55 C4 52 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 75 07 E9 66 01 00 00 EB 5B 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8B 4D D0 2B 4D 0C 03 4D EC 89 4D FC 8B 55 CC 3B 55 C8 7D 05 E9 19 01 00 00 EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 09 01 00 00 83 7D B0 00 74 6C C7 45 C8 01 00 00 00 C6 45 B4 0D 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8B 4D CC 3B 4D C8 7D 05 E9 B9 00 00 00 8B 55 EC 83 C2 01 89 55 EC 8B 45 FC 83 C0 01 89 45 FC EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 97 00 00 00 E9 8D 00 00 00 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 7B 0F B7 45 C0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 0F B7 55 C0 3B CA 75 0B 8B 45 FC 83 C0 02 89 45 FC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 52 83 7D B0 00 74 47 C7 45 C8 01 00 00 00 B9 0D 00 00 00 66 89 4D C0 0F B7 55 C0 52 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 0F B7 4D C0 3B C1 75 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 74 FC FF FF E9 DC 04 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 81 E1 80 00 00 00 0F 84 6B 04 00 00 C7 45 F4 00 00 00 00 0F BE 55 FB 85 D2 0F 85 3F 01 00 00 C7 85 AC EB FF FF 00 00 00 00 C7 85 A8 EB FF FF 00 00 00 00 8B 45 0C 89 85 AC EB FF FF 8B 8D AC EB FF FF 2B 4D 0C 3B 4D 10 0F 83 0B 01 00 00 8D 95 B0 EB FF FF 89 95 A8 EB FF FF 8B 85 A8 EB FF FF 8D 8D B0 EB FF FF 2B C1 3D FF 13 00 00 73 7A 8B 95 AC EB FF FF 2B 55 0C 3B 55 10 73 6C 8B 85 AC EB FF FF 8A 08 88 8D A7 EB FF FF 8B 95 AC EB FF FF 83 C2 01 89 95 AC EB FF FF 0F BE 85 A7 EB FF FF 83 F8 0A 75 21 8B 4D EC 83 C1 01 89 4D EC 8B 95 A8 EB FF FF C6 02 0D 8B 85 A8 EB FF FF 83 C0 01 89 85 A8 EB FF FF 8B 8D A8 EB FF FF 8A 95 A7 EB FF FF 88 11 8B 85 A8 EB FF FF 83 C0 01 89 85 A8 EB FF FF E9 71 FF FF FF 6A 00 8D 4D F0 51 8B 95 A8 EB FF FF 8D 85 B0 EB FF FF 2B D0 52 8D 8D B0 EB FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 45 FC 03 45 F0 89 45 FC 8B 8D A8 EB FF FF 8D 95 B0 EB FF FF 2B CA 39 4D F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 E3 FE FF FF E9 17 03 00 00 0F BE 45 FB 83 F8 02 0F 85 43 01 00 00 8B 4D 0C 89 8D 94 D7 FF FF C7 85 9C D7 FF FF 00 00 00 00 8B 95 94 D7 FF FF 2B 55 0C 3B 55 10 0F 83 19 01 00 00 8D 85 A0 D7 FF FF 89 85 9C D7 FF FF 8B 8D 9C D7 FF FF 8D 95 A0 D7 FF FF 2B CA 81 F9 FE 13 00 00 0F 83 83 00 00 00 8B 85 94 D7 FF FF 2B 45 0C 3B 45 10 73 75 8B 8D 94 D7 FF FF 66 8B 11 66 89 95 98 D7 FF FF 8B 85 94 D7 FF FF 83 C0 02 89 85 94 D7 FF FF 0F B7 8D 98 D7 FF FF 83 F9 0A 75 26 8B 55 EC 83 C2 02 89 55 EC B8 0D 00 00 00 8B 8D 9C D7 FF FF 66 89 01 8B 95 9C D7 FF FF 83 C2 02 89 95 9C D7 FF FF 8B 85 9C D7 FF FF 66 8B 8D 98 D7 FF FF 66 89 08 8B 95 9C D7 FF FF 83 C2 02 89 95 9C D7 FF FF E9 63 FF FF FF 6A 00 8D 45 F0 50 8B 8D 9C D7 FF FF 8D 95 A0 D7 FF FF 2B CA 51 8D 85 A0 D7 FF FF 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 55 FC 03 55 F0 89 55 FC 8B 85 9C D7 FF FF 8D 8D A0 D7 FF FF 2B C1 39 45 F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 D5 FE FF FF E9 C7 01 00 00 8B 55 0C 89 95 D4 D0 FF FF C7 85 DC D0 FF FF 00 00 00 00 8B 45 0C 89 85 D4 D0 FF FF 8B 8D D4 D0 FF FF 2B 4D 0C 3B 4D 10 0F 83 99 01 00 00 C7 85 74 C3 FF FF 00 00 00 00 8D 95 E0 D0 FF FF 89 95 DC D0 FF FF 8B 85 DC D0 FF FF 8D 8D E0 D0 FF FF 2B C1 3D A8 06 00 00 73 7A 8B 95 D4 D0 FF FF 2B 55 0C 3B 55 10 73 6C 8B 85 D4 D0 FF FF 66 8B 08 66 89 8D D8 D0 FF FF 8B 95 D4 D0 FF FF 83 C2 02 89 95 D4 D0 FF FF 0F B7 85 D8 D0 FF FF 83 F8 0A 75 1D B9 0D 00 00 00 8B 95 DC D0 FF FF 66 89 0A 8B 85 DC D0 FF FF 83 C0 02 89 85 DC D0 FF FF 8B 8D DC D0 FF FF 66 8B 95 D8 D0 FF FF 66 89 11 8B 85 DC D0 FF FF 83 C0 02 89 85 DC D0 FF FF E9 71 FF FF FF 6A 00 6A 00 68 55 0D 00 00 8D 8D 78 C3 FF FF 51 8B 85 DC D0 FF FF 8D 95 E0 D0 FF FF 2B C2 99 2B C2 D1 F8 50 8D 85 E0 D0 FF FF 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 85 74 C3 FF FF 83 BD 74 C3 FF FF 00 75 13 FF 15 ?? ?? ?? ?? 89 45 F4 E9 9F 00 00 00 E9 95 00 00 00 C7 85 70 C3 FF FF 00 00 00 00 6A 00 8D 4D F0 51 8B 95 74 C3 FF FF 2B 95 70 C3 FF FF 52 8B 85 70 C3 FF FF 8D 8C 05 78 C3 FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 11 8B 85 70 C3 FF FF 03 45 F0 89 85 70 C3 FF FF EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 0E 8B 8D 74 C3 FF FF 3B 8D 70 C3 FF FF 7F 91 8B 95 74 C3 FF FF 3B 95 70 C3 FF FF 7E 02 EB 11 8B 85 D4 D0 FF FF 2B 45 0C 89 45 FC E9 55 FE FF FF EB 4A 6A 00 8D 4D F0 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 0F C7 45 F4 00 00 00 00 8B 55 F0 89 55 FC EB 09 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D FC 00 0F 85 84 00 00 00 83 7D F4 00 74 30 83 7D F4 05 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B 4D F4 89 08 EB 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 56 EB 4C 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 40 74 11 8B 4D 0C 0F BE 11 83 FA 1A 75 06 33 C0 EB 25 EB 1B E8 ?? ?? ?? ?? C7 00 1C 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF EB 08 EB 06 8B 45 FC 2B 45 EC 8B 4D BC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__ismbcl0_l"
		size = 149
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 008a ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 33 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 12 81 7D 08 9F 88 00 00 73 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "__ismbcl0"
		size = 21
		refs = "000c __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_404_5_0 {
	meta:
		name = "__cropzeros"
		size = 21
		refs = "000c __cropzeros_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__forcdecpt"
		size = 21
		refs = "000c __forcdecpt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_974_24_0 {
	meta:
		name = "__ismbbkana"
		size = 21
		refs = "000c __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_298_4_0 {
	meta:
		name = "__ismbcalnum"
		size = 21
		refs = "000c __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_174_4_0 {
	meta:
		name = "__ismbcalpha"
		size = 21
		refs = "000c __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_130_4_0 {
	meta:
		name = "__ismbcdigit"
		size = 21
		refs = "000c __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_952_4_0 {
	meta:
		name = "__ismbcgraph"
		size = 21
		refs = "000c __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_898_4_0 {
	meta:
		name = "__ismbchira"
		size = 21
		refs = "000c __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_898_6_0 {
	meta:
		name = "__ismbckata"
		size = 21
		refs = "000c __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_35_6_0 {
	meta:
		name = "__ismbcl1"
		size = 21
		refs = "000c __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_35_8_0 {
	meta:
		name = "__ismbcl2"
		size = 21
		refs = "000c __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_610_4_0 {
	meta:
		name = "__ismbclegal"
		size = 21
		refs = "000c __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_246_4_0 {
	meta:
		name = "__ismbclower"
		size = 21
		refs = "000c __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_863_4_0 {
	meta:
		name = "__ismbcprint"
		size = 21
		refs = "000c __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_193_4_0 {
	meta:
		name = "__ismbcpunct"
		size = 21
		refs = "000c __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_462_4_0 {
	meta:
		name = "__ismbcspace"
		size = 21
		refs = "000c __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_898_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 21
		refs = "000c __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_744_4_0 {
	meta:
		name = "__ismbcupper"
		size = 21
		refs = "000c __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_855_4_0 {
	meta:
		name = "__mbbtombc"
		size = 21
		refs = "000c __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_419_4_0 {
	meta:
		name = "__mbcjistojms"
		size = 21
		refs = "000c __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_419_6_0 {
	meta:
		name = "__mbcjmstojis"
		size = 21
		refs = "000c __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_357_1_0 {
	meta:
		name = "__mbctohira"
		size = 21
		refs = "000c __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_709_1_0 {
	meta:
		name = "__mbctokata"
		size = 21
		refs = "000c __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_767_4_0 {
	meta:
		name = "__mbctolower"
		size = 21
		refs = "000c __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_855_6_0 {
	meta:
		name = "__mbctombb"
		size = 21
		refs = "000c __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_443_4_0 {
	meta:
		name = "__mbctoupper"
		size = 21
		refs = "000c __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_101_4_0 {
	meta:
		name = "__mbslen"
		size = 21
		refs = "000c __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_721_4_0 {
	meta:
		name = "__mbsnextc"
		size = 21
		refs = "000c __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_78_4_0 {
	meta:
		name = "__mbsrev"
		size = 21
		refs = "000c __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_990_1_0 {
	meta:
		name = "__mkgmtime32"
		size = 21
		refs = "000c __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_792_1_0 {
	meta:
		name = "__mkgmtime64"
		size = 21
		refs = "000c __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_290_4_0 {
	meta:
		name = "__wtof"
		size = 21
		refs = "000c __wtof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_975_4_0 {
	meta:
		name = "_atof"
		size = 21
		refs = "000c __atof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_532_4_0 {
	meta:
		name = "_isleadbyte"
		size = 21
		refs = "000c __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_35_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 158
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0093 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 88 00 00 72 12 81 7D 08 72 98 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 158
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0093 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 98 00 00 72 12 81 7D 08 A4 EA 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "___libm_sse2_expf"
		size = 343
		refs = "0015 _log2e 0044 _c1 0060 _Tl 007f _Tm 0094 _Th 0137 _INF 0140 _ZERO 0152 _ONE"
	strings:
		$1 = { F3 0F 10 C8 F3 0F 10 E0 B8 3B AA B8 46 66 0F 6E F8 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C1 0F 5A C9 81 E1 FF FF FF 7F 81 E9 00 00 80 31 81 F9 00 00 00 12 0F 83 92 00 00 00 F3 0F 59 C7 F3 0F 2D C0 66 0F 12 35 ?? ?? ?? ?? 66 0F 6E D0 8B C8 C1 E0 03 8B D1 F2 0F 59 D9 D1 F9 83 E0 78 F2 0F 59 B0 ?? ?? ?? ?? 66 0F 12 80 ?? ?? ?? ?? 81 E1 F8 00 00 00 8B C2 C1 FA 06 F3 0F E6 D2 66 0F 12 B9 ?? ?? ?? ?? C1 F8 0E 81 E2 F8 00 00 00 66 0F 6E E8 F2 0F 59 BA ?? ?? ?? ?? F2 0F 5C DA 66 0F 73 F5 34 66 0F 7E E1 8B C1 81 E1 FF FF FF 7F F2 0F 59 F3 81 F9 4F AC AE 42 77 4F 66 0F FE FD F2 0F 58 C6 F2 0F 59 C7 66 0F 5A C0 C3 81 C1 00 00 80 31 81 F9 00 00 80 31 76 76 81 F9 00 00 80 7F 73 40 66 0F 7E E2 81 FA 00 00 00 80 73 0E BA FF FF 7F 7F 66 0F 6E C2 F3 0F 59 C0 C3 BA 00 00 80 00 66 0F 6E C2 F3 0F 59 C0 C3 3D 18 72 B1 42 72 AA 66 0F FE FD F2 0F 58 F0 F2 0F 59 F7 F2 0F 5A C6 C3 81 F9 00 00 80 7F 75 1D 66 0F 7E E0 3D 00 00 80 7F 75 09 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C4 F3 0F 58 C0 C3 F3 0F 10 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__wexecle"
		size = 455
		refs = "0021 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002a ??_C@_1GA@IHAAKPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0031 __CrtDbgReportW 0045 __errno 0059 ??_C@_1BC@OIHGEFPM@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?$AA@ 0063 __invalid_parameter 0084 ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e8 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 014b ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01bc __wexecve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 45 0C 89 45 FC 33 C9 83 7D 08 00 0F 95 C1 89 4D F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 51 01 00 00 8B 45 08 0F B7 08 F7 D9 1B C9 F7 D9 89 4D F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EE 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8A 00 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2912
		refs = "0023 SIGMASK 002b ONEMASK 005c rcp_t1 0070 log2_t1 00ab HALFSIG 00d7 rcp_t2 00eb log2_t2 011d LHN 0133 rcp_t3 0145 log2_t3 022e clv 0289 Shifter 02ad exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 07a9 INF 0844 ___libm_error_support 0a7d EMIN 0aaa NEG_BIG 0ab2 POS_BIG"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 E4 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E E1 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 1C 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9A 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 86 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 99 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 47 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 2B 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 8F 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 48 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A2 00 00 00 66 0F 7E E0 83 F8 00 75 20 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 E9 00 00 00 81 FA 00 00 F0 BF 75 03 D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 63 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 3A 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 25 72 05 83 F9 00 77 1E 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? BA 1C 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 65 FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 54 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 EF F6 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 2D FF FF FF E9 4B FF FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ"
		size = 149
		refs = "000a ?g_hTimerQueue@details@Concurrency@@3RAXA 0017 ?g_TimerQueueDemandInit@details@Concurrency@@3JC 0027 __imp__CreateTimerQueue@0 0045 ?_UnderlyingYield@details@Concurrency@@YAXXZ 004d ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0067 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 007a ??0bad_alloc@std@@QAE@XZ 007f __TI2?AVbad_alloc@std@@ 0088 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 3D ?? ?? ?? ?? 00 75 7B B9 01 00 00 00 BA ?? ?? ?? ?? 33 C0 F0 0F B1 0A 85 C0 75 1F FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 09 33 C0 B9 ?? ?? ?? ?? 87 01 EB 29 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 13 83 3D ?? ?? ?? ?? 01 75 0A 8D 4D F0 E8 ?? ?? ?? ?? EB E4 83 3D ?? ?? ?? ?? 00 75 16 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 E4 52 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 48
		refs = "000e ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 001c ??0exception@std@@QAE@ABQBDH@Z 0025 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 C7 45 FC ?? ?? ?? ?? 6A 01 8D 45 FC 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 C7 01 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_alloc@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_42_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@6B@ 0016 ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_98_0 {
	meta:
		name = "??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@6B@ 0016 ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1020_3 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_fun@Q6A_NABW4agent_status@Concurrency@@@Z$0A@@tr1@std@@_NABW4agent_status@Concurrency@@@tr1@std@@6B@ 0016 ??1?$_Impl_base1@_NABW4agent_status@Concurrency@@@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1024_3 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda0>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XABI@tr1@std@@6B@ 0016 ??1?$_Impl_base1@XABI@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_1028_1 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda1>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@6B@ 0016 ??1?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_1032_2 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda2>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@6B@ 0016 ??1?$_Impl_base1@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1036_3 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda3>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@6B@ 0016 ??1?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_1039_3 {
	meta:
		name = "??1?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$_Impl_no_alloc1@U?$_Callable_obj@V<lambda4>@?A0x8894c2c9@Concurrency@@$0A@@tr1@std@@XPAV?$message@I@Concurrency@@@tr1@std@@6B@ 0016 ??1?$_Impl_base1@XPAV?$message@I@Concurrency@@@tr1@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_248_3 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_248_2 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_269_3 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_193_1 {
	meta:
		name = "??1?$codecvt@DDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@DDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_223_3 {
	meta:
		name = "??1?$codecvt@GDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@GDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_218_2 {
	meta:
		name = "??1?$codecvt@_WDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@_WDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_169_2 {
	meta:
		name = "??1?$collate@D@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@D@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_586_2 {
	meta:
		name = "??1?$collate@G@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@G@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_556_3 {
	meta:
		name = "??1?$collate@_W@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@_W@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_171_3 {
	meta:
		name = "??1?$messages@D@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@D@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_589_3 {
	meta:
		name = "??1?$messages@G@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@G@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_543_1 {
	meta:
		name = "??1?$messages@_W@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@_W@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_165_1 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_574_1 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_561_2 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_167_1 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_593_3 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_563_3 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_184_3 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@D$00@std@@6B@ 0016 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_177_2 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@D$0A@@std@@6B@ 0016 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_601_3 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@G$00@std@@6B@ 0016 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_595_2 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@G$0A@@std@@6B@ 0016 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_556_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@_W$00@std@@6B@ 0016 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_549_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@_W$0A@@std@@6B@ 0016 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_0_190_2 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_578_2 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_548_2 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_192_3 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_580_3 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_550_3 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_37_0 {
	meta:
		name = "??1FreeThreadProxy@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7FreeThreadProxy@details@Concurrency@@6B@ 0016 ??1ThreadProxy@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_40_0 {
	meta:
		name = "??1FreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7FreeThreadProxyFactory@details@Concurrency@@6B@ 0016 ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@VFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_635_34_0 {
	meta:
		name = "??1ThreadScheduler@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7ThreadScheduler@details@Concurrency@@6B@ 0016 ??1SchedulerBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_342_7_0 {
	meta:
		name = "??1ThreadVirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 0016 ??1VirtualProcessor@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_416_94_0 {
	meta:
		name = "??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7UMSFreeThreadProxyFactory@details@Concurrency@@6B@ 0016 ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_689_21_0 {
	meta:
		name = "??1UMSThreadScheduler@details@Concurrency@@UAE@XZ"
		size = 30
		refs = "000e ??_7UMSThreadScheduler@details@Concurrency@@6B@ 0016 ??1SchedulerBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_848_21_0 {
	meta:
		name = "??1__non_rtti_object@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7__non_rtti_object@std@@6B@ 0016 ??1bad_typeid@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_848_13_0 {
	meta:
		name = "??1bad_cast@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_cast@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_534_38_0 {
	meta:
		name = "??1bad_exception@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_exception@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_848_17_0 {
	meta:
		name = "??1bad_typeid@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_typeid@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_172_1 {
	meta:
		name = "??1codecvt_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7codecvt_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_315_3 {
	meta:
		name = "??1ctype_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7ctype_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_848_6_0 {
	meta:
		name = "??1exception@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7exception@std@@6B@ 0016 ?_Tidy@exception@std@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_133_1 {
	meta:
		name = "??1time_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7time_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "??0event@Concurrency@@QAE@XZ"
		size = 46
		refs = "0023 ??0critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 4D FC 83 C1 08 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "??1event@Concurrency@@QAE@XZ"
		size = 236
		refs = "0008 __ehhandler$??1event@Concurrency@@QAE@XZ 0017 ___security_cookie 0038 ?_Flush_current_owner@critical_section@Concurrency@@QAEXXZ 006d ?Satisfy@EventWaitNode@details@Concurrency@@QAE_NPAPAVContext@3@@Z 00c5 ?Destroy@EventWaitNode@details@Concurrency@@QAEXXZ 00d9 ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 10 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E4 C7 45 FC 00 00 00 00 8B 4D E4 83 C1 08 E8 ?? ?? ?? ?? C7 45 E8 00 00 00 00 8B 45 E4 8B 08 89 4D EC 83 7D EC 01 76 37 EB 06 8B 55 F0 89 55 EC 83 7D EC 00 74 29 8B 45 EC 8B 08 89 4D F0 6A 00 8B 4D EC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0E 8B 45 EC 8B 4D E8 89 08 8B 55 EC 89 55 E8 EB CB 83 7D E8 00 74 14 8B 45 E8 8B 4D E4 8B 51 04 89 10 8B 45 E4 8B 4D E8 89 48 04 8B 55 E4 8B 42 04 89 45 EC EB 06 8B 4D F0 89 4D EC 83 7D EC 00 74 12 8B 55 EC 8B 02 89 45 F0 8B 4D EC E8 ?? ?? ?? ?? EB E2 C7 45 FC FF FF FF FF 8B 4D E4 83 C1 08 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "__ehhandler$??1event@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1event@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_85_2 {
	meta:
		name = "__ehhandler$??0?$_String_val@DV?$allocator@D@std@@@std@@QAE@V?$allocator@D@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@DV?$allocator@D@std@@@std@@QAE@V?$allocator@D@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1074_2 {
	meta:
		name = "__ehhandler$??0?$_String_val@GV?$allocator@G@std@@@std@@QAE@V?$allocator@G@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@GV?$allocator@G@std@@@std@@QAE@V?$allocator@G@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_680_3 {
	meta:
		name = "__ehhandler$??0?$_String_val@_WV?$allocator@_W@std@@@std@@QAE@V?$allocator@_W@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_val@_WV?$allocator@_W@std@@@std@@QAE@V?$allocator@_W@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_878_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@QAE@0ABV345@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@QAE@0ABV345@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_825_1 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@QAE@0ABV456@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@QAE@0ABV456@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_181_2 {
	meta:
		name = "__ehhandler$??0_Locinfo@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locinfo@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_226_43_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_226_50_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_64_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_226_54_0 {
	meta:
		name = "__ehhandler$??0critical_section@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0critical_section@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_226_82_0 {
	meta:
		name = "__ehhandler$??0reader_writer_lock@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0reader_writer_lock@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_559_1 {
	meta:
		name = "__ehhandler$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_395_2 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_340_1 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_188_1 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_93_1 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_169_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_75_3 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_495_3 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_149_3 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_248_3 {
	meta:
		name = "__ehhandler$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_100_0 {
	meta:
		name = "__ehhandler$??1SchedulerProxy@details@Concurrency@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerProxy@details@Concurrency@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_8_0 {
	meta:
		name = "__ehhandler$??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_849_2 {
	meta:
		name = "__ehhandler$??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_796_2 {
	meta:
		name = "__ehhandler$??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_19_1 {
	meta:
		name = "__ehhandler$??1_Pop_finalizer@_Micro_queue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Pop_finalizer@_Micro_queue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_69_0 {
	meta:
		name = "__ehhandler$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_30_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_30_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_18_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_689_18_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_54_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_635_15_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_689_15_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_62_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_47_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_169_0 {
	meta:
		name = "__ehhandler$?DestroySchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroySchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_83_0 {
	meta:
		name = "__ehhandler$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_222_0 {
	meta:
		name = "__ehhandler$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_94_0 {
	meta:
		name = "__ehhandler$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_647_1 {
	meta:
		name = "__ehhandler$?_Create_send_message@?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Create_send_message@?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_2_3 {
	meta:
		name = "__ehhandler$?_Facet_Register@facet@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Facet_Register@facet@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_2_0 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_125_0 {
	meta:
		name = "__ehhandler$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_43_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCreate@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCreate@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_477_3 {
	meta:
		name = "__ehhandler$?accept_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@I@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?accept_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@I@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_158_3 {
	meta:
		name = "__ehhandler$?accept_message@?$single_assignment@I@Concurrency@@MAEPAV?$message@I@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?accept_message@?$single_assignment@I@Concurrency@@MAEPAV?$message@I@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_238_2 {
	meta:
		name = "__ehhandler$?construct@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@2@$$QAU32@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?construct@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@2@$$QAU32@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_651_3 {
	meta:
		name = "__ehhandler$?register_filter@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@IAEXABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?register_filter@?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@IAEXABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "?Satisfy@EventWaitNode@details@Concurrency@@QAE_NPAPAVContext@3@@Z"
		size = 41
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 50 8B 4D 08 51 8B 55 FC 8B 42 04 8B 4D FC 8B 49 04 8B 10 8B 02 FF D0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_11_0 {
	meta:
		name = "?Destroy@EventWaitNode@details@Concurrency@@QAEXXZ"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 55 FC 8B 42 04 8B 11 8B C8 8B 42 08 FF D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_12_0 {
	meta:
		name = "?wait@event@Concurrency@@QAEII@Z"
		size = 346
		refs = "0008 __ehhandler$?wait@event@Concurrency@@QAEII@Z 0017 ___security_cookie 0062 ?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z 006f ?_UnderlyingYield@details@Concurrency@@YAXXZ 0077 ??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z 0094 ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 00a3 ??0SingleWaitBlock@details@Concurrency@@QAE@XZ 00af ??0EventWaitNode@details@Concurrency@@QAE@PAVWaitBlock@12@@Z 00c2 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 00e2 ?Sweep@details@Concurrency@@YAPAVEventWaitNode@12@PAV312@@Z 00ff ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0143 ?Block@Context@Concurrency@@SAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D AC 83 7D 08 FF 74 3E 83 7D 08 00 75 19 8B 45 AC 83 38 01 75 09 33 C0 E9 04 01 00 00 EB 08 83 C8 FF E9 FA 00 00 00 8B 4D AC 89 4D C4 8B 55 08 52 6A 01 6A 01 8D 45 C4 50 E8 ?? ?? ?? ?? 83 C4 10 E9 DB 00 00 00 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D AC 8B 11 89 55 F0 83 7D F0 01 75 07 33 C0 E9 B9 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 DC 8D 4D C8 E8 ?? ?? ?? ?? 8D 4D C8 51 8D 4D D4 E8 ?? ?? ?? ?? C6 45 DF 00 8B 55 AC 83 C2 08 52 8D 4D B4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 45 AC 83 38 01 75 06 C6 45 DF 01 EB 19 8B 4D AC 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 8B 45 AC 8D 4D D4 89 08 C7 45 FC FF FF FF FF 8D 4D B4 E8 ?? ?? ?? ?? 0F B6 55 DF 85 D2 75 3C 83 7D D0 01 74 1C B9 02 00 00 00 8D 55 D0 33 C0 F0 0F B1 0A 83 F8 01 74 09 C7 45 A8 00 00 00 00 EB 07 C7 45 A8 01 00 00 00 8A 45 A8 88 45 B3 0F B6 4D B3 85 C9 75 05 E8 ?? ?? ?? ?? 33 C0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_14_0 {
	meta:
		name = "__ehhandler$?wait@event@Concurrency@@QAEII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@event@Concurrency@@QAEII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_15_0 {
	meta:
		name = "??0EventWaitNode@details@Concurrency@@QAE@PAVWaitBlock@12@@Z"
		size = 27
		altNames = "??0ContextNode@SchedulerBase@details@Concurrency@@QAE@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_16_0 {
	meta:
		name = "??0SingleWaitBlock@details@Concurrency@@QAE@XZ"
		size = 33
		refs = "000d ??0WaitBlock@details@Concurrency@@QAE@XZ 0016 ??_7SingleWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_270_2 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 33
		refs = "000d ??0ios_base@std@@IAE@XZ 0016 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_275_2 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 33
		refs = "000d ??0ios_base@std@@IAE@XZ 0016 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_275_2 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 33
		refs = "000d ??0ios_base@std@@IAE@XZ 0016 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_830_2_0 {
	meta:
		name = "??0IUMSScheduler@Concurrency@@QAE@XZ"
		size = 33
		refs = "000d ??0IScheduler@Concurrency@@QAE@XZ 0016 ??_7IUMSScheduler@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_864_18_0 {
	meta:
		name = "??0IUMSThreadProxy@Concurrency@@QAE@XZ"
		size = 33
		refs = "000d ??0IThreadProxy@Concurrency@@QAE@XZ 0016 ??_7IUMSThreadProxy@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_387_15_0 {
	meta:
		name = "??0IVirtualProcessorRoot@Concurrency@@QAE@XZ"
		size = 33
		refs = "000d ??0IExecutionResource@Concurrency@@QAE@XZ 0016 ??_7IVirtualProcessorRoot@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_17_0 {
	meta:
		name = "??0WaitBlock@details@Concurrency@@QAE@XZ"
		size = 56
		refs = "000e ??_7WaitBlock@details@Concurrency@@6B@ 0027 ?CurrentContext@Context@Concurrency@@SAPAV12@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 08 00 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_18_0 {
	meta:
		name = "?reset@event@Concurrency@@QAEXXZ"
		size = 196
		refs = "0008 __ehhandler$?reset@event@Concurrency@@QAEXXZ 0017 ___security_cookie 0035 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0083 ?Reset@EventWaitNode@details@Concurrency@@QAE_NXZ 00b1 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D4 8B 45 D4 83 C0 08 50 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D D4 83 39 01 75 5E C7 45 D8 00 00 00 00 C7 45 E0 00 00 00 00 8B 55 D4 8B 42 04 89 45 DC 8B 4D D4 C7 41 04 00 00 00 00 EB 06 8B 55 E0 89 55 DC 83 7D DC 00 74 27 8B 45 DC 8B 08 89 4D E0 8B 4D DC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0E 8B 45 DC 8B 4D D8 89 08 8B 55 DC 89 55 D8 EB CD 8B 45 D4 8B 4D D8 89 08 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_21_0 {
	meta:
		name = "?Reset@EventWaitNode@details@Concurrency@@QAE_NXZ"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 55 FC 8B 42 04 8B 11 8B C8 8B 42 04 FF D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_22_0 {
	meta:
		name = "?set@event@Concurrency@@QAEXXZ"
		size = 405
		refs = "0008 __ehhandler$?set@event@Concurrency@@QAEXXZ 0017 ___security_cookie 0043 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0076 ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 007b ??_C@_0BH@HIHNOLDA@_M_pResetChain?5?$DN?$DN?5NULL?$AA@ 0080 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 00c0 _malloc 00c9 __MarkAllocaS 00fe ?Satisfy@EventWaitNode@details@Concurrency@@QAE_NPAPAVContext@3@@Z 0145 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 017f __freea"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 30 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D C4 C7 45 F0 00 00 00 00 C7 45 EC 00 00 00 00 8B 45 C4 83 C0 08 50 8D 4D D8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 B9 01 00 00 00 8B 55 C4 87 0A 89 4D E8 83 7D E8 01 0F 86 D5 00 00 00 8B 45 C4 83 78 04 00 75 02 EB 17 68 08 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C7 45 EC 00 00 00 00 8B 4D E8 89 4D D0 EB 08 8B 55 D0 8B 02 89 45 D0 83 7D D0 00 74 0B 8B 4D EC 83 C1 01 89 4D EC EB E7 68 DD DD 00 00 8B 55 EC 8D 04 95 08 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 C7 45 EC 00 00 00 00 8B 4D E8 89 4D CC EB 06 8B 55 D4 89 55 CC 83 7D CC 00 74 4C 8B 45 CC 8B 08 89 4D D4 8D 55 C8 52 8B 4D CC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 14 8B 4D CC 8B 55 C4 8B 42 04 89 01 8B 4D C4 8B 55 CC 89 51 04 83 7D C8 00 74 15 8B 45 EC 8B 4D F0 8B 55 C8 89 14 81 8B 45 EC 83 C0 01 89 45 EC EB A8 C7 45 FC FF FF FF FF 8D 4D D8 E8 ?? ?? ?? ?? 8B 4D EC 8B 55 EC 83 EA 01 89 55 EC 85 C9 76 1B 8B 45 EC 8B 4D F0 8B 14 81 8B 45 EC 8B 4D F0 8B 0C 81 8B 12 8B 42 0C FF D0 EB D5 83 7D F0 00 74 0C 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_24_0 {
	meta:
		name = "__ehhandler$?set@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_46_0 {
	meta:
		name = "__ehhandler$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_64_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@QAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxyFactory@details@Concurrency@@QAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_120_0 {
	meta:
		name = "__ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_136_0 {
	meta:
		name = "__ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_174_0 {
	meta:
		name = "__ehhandler$?RegisterForExitTracking@SchedulerBase@details@Concurrency@@QAEXPAVExternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RegisterForExitTracking@SchedulerBase@details@Concurrency@@QAEXPAVExternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_313_3 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_849_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_729_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_993_3_0 {
	meta:
		name = "__ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "__ehhandler$?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_631_1 {
	meta:
		name = "__ehhandler$?release@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_594_2 {
	meta:
		name = "__ehhandler$?release@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_25_0 {
	meta:
		name = "__MarkAllocaS"
		size = 33
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 11 8B 45 08 8B 4D 0C 89 08 8B 55 08 83 C2 08 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_39_26_0 {
	meta:
		name = "__freea"
		size = 54
		refs = "002b _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 74 26 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_27_0 {
	meta:
		name = "?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z"
		size = 1026
		refs = "0008 __ehhandler$?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z 001a ___security_cookie 0031 ??_C@_07CAAEJHLA@pEvents?$AA@ 0039 ??0invalid_argument@std@@QAE@PBD@Z 003e __TI3?AVinvalid_argument@std@@ 0047 __CxxThrowException@8 0097 ?wait@event@Concurrency@@QAEII@Z 0125 ??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0134 ?GetWaitBlock@MultiWaitBlockHolder@details@Concurrency@@QBEPAVMultiWaitBlock@23@XZ 0174 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0184 ?GetWaitNode@MultiWaitBlockHolder@details@Concurrency@@QBEPAVEventWaitNode@23@I@Z 018f ?Release@MultiWaitBlockHolder@details@Concurrency@@QAEXXZ 01b5 ?Satisfy@EventWaitNode@details@Concurrency@@QAE_NPAPAVContext@3@@Z 01c8 ?Sweep@details@Concurrency@@YAPAVEventWaitNode@12@PAV312@@Z 01f6 ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 01fb ??_C@_0P@OGECOMAI@i?5?$DN?$DN?5count?5?9?51?$AA@ 0200 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0278 ??_C@_0BK@NBCOMBPO@pSatisfiedContext?5?$DN?$DN?5NULL?$AA@ 028e ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0342 ?Block@Context@Concurrency@@SAXXZ 0364 ?DispatchEventTimer@MultiWaitBlock@details@Concurrency@@SGXPAXE@Z 0369 ?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ 0377 __imp__CreateTimerQueueTimer@28 0386 ??0bad_alloc@std@@QAE@XZ 038b __TI2?AVbad_alloc@std@@ 03c8 ?GetIndexOfNode@MultiWaitBlockHolder@details@Concurrency@@QBEIPAVEventWaitNode@23@@Z 03e9 ??1MultiWaitBlockHolder@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 EC 94 00 00 00 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D 94 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 94 50 E8 ?? ?? ?? ?? 83 7D 0C 00 75 07 33 C0 E9 9B 03 00 00 83 7D 0C 01 75 42 83 7D 14 00 74 06 83 7D 14 FF 75 36 8B 4D 08 83 39 00 75 1B 68 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 88 52 E8 ?? ?? ?? ?? 8B 45 14 50 8B 4D 08 8B 09 E8 ?? ?? ?? ?? E9 53 03 00 00 C7 45 CC 00 00 00 00 EB 09 8B 55 CC 83 C2 01 89 55 CC 8B 45 CC 3B 45 0C 73 2F 8B 4D CC 8B 55 08 83 3C 8A 00 75 21 68 ?? ?? ?? ?? 8D 8D 7C FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 7C FF FF FF 50 E8 ?? ?? ?? ?? EB C0 83 7D 14 00 74 0F 83 7D 14 FF 74 09 C6 85 6B FF FF FF 01 EB 07 C6 85 6B FF FF FF 00 0F B6 8D 6B FF FF FF 51 83 7D 14 FF 0F 95 C2 0F B6 C2 50 8B 4D 0C 51 0F B6 55 10 52 8D 4D D8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 89 45 D4 C6 45 D3 00 C7 45 C8 00 00 00 00 EB 09 8B 45 C8 83 C0 01 89 45 C8 8B 4D C8 3B 4D 0C 0F 83 63 01 00 00 8B 55 C8 8B 45 08 8B 0C 90 89 4D A8 8B 55 A8 83 C2 08 52 8D 4D B0 E8 ?? ?? ?? ?? C6 45 FC 01 8B 45 C8 50 8D 4D D8 E8 ?? ?? ?? ?? 89 45 C0 8D 4D D8 E8 ?? ?? ?? ?? 8B 4D A8 8B 11 89 55 C4 83 7D C4 01 0F 85 F1 00 00 00 0F B6 45 10 85 C0 74 63 8D 4D AC 51 8B 4D C0 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 1D 8B 45 A8 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 C0 89 02 8B 45 A8 8B 4D C0 89 48 04 83 7D AC 00 74 28 8B 55 0C 83 EA 01 39 55 C8 75 02 EB 17 68 A2 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C6 45 D3 01 E9 84 00 00 00 8D 45 AC 50 8B 4D C0 E8 ?? ?? ?? ?? 83 7D AC 00 74 04 C6 45 D3 01 8B 4D C8 83 C1 01 89 4D A4 EB 09 8B 55 A4 83 C2 01 89 55 A4 8B 45 A4 3B 45 0C 73 44 8B 4D A4 51 8D 4D D8 E8 ?? ?? ?? ?? 89 45 C0 8D 4D D8 E8 ?? ?? ?? ?? 8D 55 AC 52 8B 4D C0 E8 ?? ?? ?? ?? 83 7D AC 00 75 02 EB 17 68 B3 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB AB C6 45 FC 00 8D 4D B0 E8 ?? ?? ?? ?? EB 2C EB 19 8B 45 C4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D C0 89 01 8B 55 A8 8B 45 C0 89 02 C6 45 FC 00 8D 4D B0 E8 ?? ?? ?? ?? E9 88 FE FF FF 0F B6 4D D3 85 C9 0F 85 DC 00 00 00 8B 55 D4 83 7A 08 01 74 22 B9 02 00 00 00 8B 55 D4 83 C2 08 33 C0 F0 0F B1 0A 83 F8 01 74 0C C7 85 64 FF FF FF 00 00 00 00 EB 0A C7 85 64 FF FF FF 01 00 00 00 8A 85 64 FF FF FF 88 45 A3 0F B6 4D A3 85 C9 0F 85 92 00 00 00 83 7D 14 00 75 2C 8B 55 D4 83 C2 14 B8 01 00 00 00 F0 0F C1 02 40 83 F8 01 75 10 8B 4D D4 C7 41 0C 00 00 00 00 C6 45 D3 01 EB 05 E8 ?? ?? ?? ?? EB 60 83 7D 14 FF 74 55 8B 55 D4 83 7A 14 00 75 4C 6A 20 6A 00 8B 45 14 50 8B 4D D4 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 55 D4 83 C2 10 52 FF 15 ?? ?? ?? ?? 85 C0 75 1C 8D 8D 70 FF FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D D4 83 79 0C 00 75 0C C7 85 60 FF FF FF FF FF FF FF EB 15 8B 55 D4 8B 42 0C 50 8D 4D D8 E8 ?? ?? ?? ?? 89 85 60 FF FF FF 8B 8D 60 FF FF FF 89 8D 6C FF FF FF C7 45 FC FF FF FF FF 8D 4D D8 E8 ?? ?? ?? ?? 8B 85 6C FF FF FF 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_30_0 {
	meta:
		name = "__ehhandler$?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z"
		size = 30
		refs = "0010 @__security_check_cookie@4 0015 __ehfuncinfo$?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z 001a ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 68 FF FF FF 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_37_0 {
	meta:
		name = "?Release@MultiWaitBlockHolder@details@Concurrency@@QAEXXZ"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 14 83 C1 01 8B 55 FC 89 4A 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_38_0 {
	meta:
		name = "?GetWaitBlock@MultiWaitBlockHolder@details@Concurrency@@QBEPAVMultiWaitBlock@23@XZ"
		size = 19
		altNames = "?Count@MeasuredHistory@HillClimbing@details@Concurrency@@QAEHXZ ?GetAllocatedNodes@SchedulerProxy@details@Concurrency@@QBEPAUSchedulerNode@23@XZ ?GetNumSchedulersForNotifications@ResourceManager@details@Concurrency@@QAEIXZ ?GetProxy@UMSSchedulingContext@details@Concurrency@@UAEPAUIThreadProxy@3@XZ ?GetUMSContext@UMSThreadProxy@details@Concurrency@@QBEPAXXZ ?GetVirtualProcessorRoot@ThreadProxy@details@Concurrency@@QAEPAVVirtualProcessorRoot@23@XZ ?do_date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?do_date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?do_date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AW4dateorder@time_base@2@XZ ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIXZ ?size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEIXZ ?size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEIXZ ?state@?$fpos@H@std@@QBEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_39_0 {
	meta:
		name = "?GetWaitNode@MultiWaitBlockHolder@details@Concurrency@@QBEPAVEventWaitNode@23@I@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 0C 8B 4D FC 03 01 8B 55 FC 8B 4A 04 0F AF 4D 08 03 C1 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_40_0 {
	meta:
		name = "?GetIndexOfNode@MultiWaitBlockHolder@details@Concurrency@@QBEIPAVEventWaitNode@23@@Z"
		size = 39
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 0C 8B 55 FC 03 0A 8B 45 08 2B C1 8B 4D FC 33 D2 F7 71 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_39_43_0 {
	meta:
		name = "??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z"
		size = 460
		refs = "0008 __ehhandler$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0017 ___security_cookie 0071 ??_U@YAPAXI@Z 00a2 ??2@YAPAXIPAX@Z 00cb ??0WaitAllBlock@details@Concurrency@@QAE@I_N0@Z 011d ??0WaitAnyBlock@details@Concurrency@@QAE@I_N0@Z 0184 ??0EventWaitNode@details@Concurrency@@QAE@PAVWaitBlock@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 30 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D D0 8B 45 D0 C7 40 14 00 00 00 00 0F B6 4D 08 F7 D9 1B C9 83 E1 00 83 C1 33 83 E1 F8 8B 55 D0 89 0A 8B 45 D0 C7 40 04 08 00 00 00 8B 4D D0 8B 51 04 0F AF 55 0C 8B 45 D0 03 10 8B 4D D0 89 51 08 8B 55 D0 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8B 4D D0 8B 55 E8 89 51 0C 8B 45 D0 8B 4D D0 8B 51 0C 89 50 10 0F B6 45 08 85 C0 74 52 8B 4D D0 8B 51 0C 52 6A 2C E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 C7 45 FC 00 00 00 00 83 7D E0 00 74 1B 0F B6 45 14 50 0F B6 4D 10 51 8B 55 0C 52 8B 4D E0 E8 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 E4 C7 45 FC FF FF FF FF EB 50 8B 4D D0 8B 51 0C 52 6A 2C E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 C7 45 FC 01 00 00 00 83 7D D8 00 74 1B 0F B6 45 14 50 0F B6 4D 10 51 8B 55 0C 52 8B 4D D8 E8 ?? ?? ?? ?? 89 45 C8 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 DC C7 45 FC FF FF FF FF 8B 4D D0 8B 51 0C 8B 45 D0 03 10 89 55 F0 C7 45 EC 00 00 00 00 EB 09 8B 4D EC 83 C1 01 89 4D EC 8B 55 EC 3B 55 0C 73 40 8B 45 F0 50 6A 08 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 83 7D D4 00 74 14 8B 4D D0 8B 51 10 52 8B 4D D4 E8 ?? ?? ?? ?? 89 45 C4 EB 07 C7 45 C4 00 00 00 00 8B 45 D0 8B 4D F0 03 48 04 89 4D F0 EB AF 0F B6 55 14 F7 DA 1B D2 F7 DA 83 C2 01 03 55 0C 8B 45 D0 89 50 18 8B 45 D0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_39_44_0 {
	meta:
		name = "__unwindfunclet$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z$0"
		size = 20
		refs = "000c ??3@YAXPAX0@Z"
	strings:
		$1 = { 8B 45 D0 8B 48 0C 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 C3 }
	condition:
		$1
}

rule file_39_45_0 {
	meta:
		name = "__unwindfunclet$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z$1"
		size = 20
		refs = "000c ??3@YAXPAX0@Z"
	strings:
		$1 = { 8B 45 D0 8B 48 0C 51 8B 55 D8 52 E8 ?? ?? ?? ?? 83 C4 08 C3 }
	condition:
		$1
}

rule file_39_49_0 {
	meta:
		name = "??0WaitAllBlock@details@Concurrency@@QAE@I_N0@Z"
		size = 58
		refs = "001b ??0MultiWaitBlock@details@Concurrency@@QAE@I_N0@Z 0024 ??_7WaitAllBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 10 50 0F B6 4D 0C 51 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 1C 8B 45 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_39_50_0 {
	meta:
		name = "??0MultiWaitBlock@details@Concurrency@@QAE@I_N0@Z"
		size = 113
		refs = "000d ??0WaitBlock@details@Concurrency@@QAE@XZ 0016 ??_7MultiWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC C7 41 0C 00 00 00 00 8B 55 FC C7 42 10 00 00 00 00 8B 45 FC C7 40 14 00 00 00 00 0F B6 4D 10 F7 D9 1B C9 F7 D9 03 4D 08 8B 55 FC 89 4A 18 8B 45 FC C7 40 20 00 00 00 00 8B 4D FC C7 41 24 00 00 00 00 8B 55 FC 8A 45 0C 88 42 28 8B 45 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_39_51_0 {
	meta:
		name = "??0WaitAnyBlock@details@Concurrency@@QAE@I_N0@Z"
		size = 59
		refs = "001b ??0MultiWaitBlock@details@Concurrency@@QAE@I_N0@Z 0024 ??_7WaitAnyBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 45 10 50 0F B6 4D 0C 51 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC C7 41 1C 01 00 00 00 8B 45 FC 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_39_52_0 {
	meta:
		name = "??1MultiWaitBlockHolder@details@Concurrency@@QAE@XZ"
		size = 59
		refs = "0030 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 89 4D FC 8B 45 FC 8B 4D FC 8B 50 14 8B 41 18 8B 4D FC 8B 49 14 83 C1 01 8B 75 FC 89 4E 14 3B D0 73 0D 8B 55 FC 8B 4A 10 E8 ?? ?? ?? ?? EB D4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_53_0 {
	meta:
		name = "?SingleSatisfy@MultiWaitBlock@details@Concurrency@@MAEXPAPAVContext@3@PAVEventWaitNode@23@@Z"
		size = 274
		refs = "0064 ?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ 006b __imp__DeleteTimerQueueTimer@12 0075 __imp__GetLastError@0 0095 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D F0 8B 45 F0 8B 48 04 89 4D F8 C6 45 FF 01 8B 55 F0 0F B6 42 28 85 C0 74 19 8B 4D F0 83 C1 14 BA 01 00 00 00 F0 0F C1 11 42 83 FA 01 74 04 C6 45 FF 00 0F B6 45 FF 85 C0 0F 84 C4 00 00 00 8B 4D F0 8B 55 0C 89 51 0C 8B 45 F0 83 78 10 00 74 3F 6A FF 8B 4D F0 8B 51 10 52 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 3D E5 03 00 00 75 02 EB 06 EB 02 EB 02 EB D2 8B 45 F0 83 78 14 01 75 08 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C 8B 51 04 83 7A 08 02 74 24 B9 01 00 00 00 8B 55 0C 8B 42 04 83 C0 08 8B D0 33 C0 F0 0F B1 0A 83 F8 02 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8A 45 EC 88 45 F7 0F B6 4D F7 85 C9 74 11 83 7D 08 00 74 09 8B 55 08 C7 02 00 00 00 00 EB 1D 83 7D 08 00 74 0A 8B 45 08 8B 4D F8 89 08 EB 0D 8B 55 F8 8B 02 8B 4D F8 8B 50 0C FF D2 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_39_54_0 {
	meta:
		name = "?DispatchEventTimer@MultiWaitBlock@details@Concurrency@@SGXPAXE@Z"
		size = 140
		refs = "003d ?GetSharedTimerQueue@details@Concurrency@@YAPAXXZ 0044 __imp__DeleteTimerQueueTimer@12 004e __imp__GetLastError@0 0082 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 89 45 FC C7 45 F8 00 00 00 00 8B 4D FC 83 C1 14 BA 01 00 00 00 F0 0F C1 11 42 83 FA 01 75 37 8B 45 FC 8B 48 04 89 4D F8 6A 00 8B 55 FC 8B 42 10 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 3D E5 03 00 00 75 02 EB 06 EB 02 EB 02 EB D2 83 7D F8 00 74 17 8B 4D FC C7 41 0C 00 00 00 00 8B 55 F8 8B 02 8B 4D F8 8B 50 0C FF D2 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_39_55_0 {
	meta:
		name = "?Satisfy@SingleWaitBlock@details@Concurrency@@UAE_NPAPAVContext@3@PAVEventWaitNode@23@@Z"
		size = 141
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F8 8B 45 0C 8B 48 04 83 79 08 02 74 22 BA 01 00 00 00 8B 45 0C 8B 48 04 83 C1 08 33 C0 F0 0F B1 11 83 F8 02 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8A 55 F4 88 55 FF 0F B6 45 FF 85 C0 74 11 83 7D 08 00 74 09 8B 4D 08 C7 01 00 00 00 00 EB 26 83 7D 08 00 74 0D 8B 55 08 8B 45 F8 8B 48 04 89 0A EB 13 8B 55 F8 8B 42 04 8B 4D F8 8B 49 04 8B 10 8B 42 0C FF D0 32 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_39_56_0 {
	meta:
		name = "?Reset@SingleWaitBlock@details@Concurrency@@UAE_NXZ"
		size = 38
		refs = "000f ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0014 ??_C@_05LAPONLG@false?$AA@ 0019 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 68 BE 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_57_0 {
	meta:
		name = "?Destroy@SingleWaitBlock@details@Concurrency@@UAEXXZ"
		size = 36
		refs = "000f ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0014 ??_C@_05LAPONLG@false?$AA@ 0019 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 68 C7 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_59_0 {
	meta:
		name = "?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
		size = 68
		refs = "0039 ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F4 8B 45 F4 8B 48 18 89 4D FC 8B 55 F4 83 C2 24 B8 01 00 00 00 F0 0F C1 02 40 8B 4D FC 83 C1 01 3B C1 75 12 8B 55 F4 89 55 F8 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_60_0 {
	meta:
		name = "?Satisfy@WaitAnyBlock@details@Concurrency@@UAE_NPAPAVContext@3@PAVEventWaitNode@23@@Z"
		size = 127
		refs = "002b ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0030 ??_C@_0BE@CABJMBFN@m_triggerLimit?5?$DN?$DN?51?$AA@ 0035 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0073 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 09 8B 45 08 C7 00 00 00 00 00 8B 4D F8 83 79 1C 01 75 02 EB 17 68 EC 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 83 C2 20 B8 01 00 00 00 F0 0F C1 02 40 89 45 FC 8B 4D F8 8B 51 1C 39 55 FC 75 15 8B 45 0C 50 8B 4D 08 51 8B 55 F8 8B 02 8B 4D F8 8B 50 10 FF D2 8B 4D F8 E8 ?? ?? ?? ?? 32 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_39_63_0 {
	meta:
		name = "?Sweep@WaitAnyBlock@details@Concurrency@@UAE_NXZ"
		size = 84
		refs = "0039 ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003e ??_C@_0BB@BJGACNAO@pContext?5?$DN?$DN?5NULL?$AA@ 0043 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 20 8B 55 F8 3B 4A 1C 72 35 6A 00 8D 45 FC 50 8B 4D F8 8B 11 8B 4D F8 8B 02 FF D0 83 7D FC 00 75 02 EB 17 68 15 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 32 C0 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_64_0 {
	meta:
		name = "?Satisfy@WaitAllBlock@details@Concurrency@@UAE_NPAPAVContext@3@PAVEventWaitNode@23@@Z"
		size = 131
		refs = "002b ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0030 ??_C@_0BE@GHLJLLIN@m_triggerLimit?5?$DO?$DN?51?$AA@ 0035 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0073 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 09 8B 45 08 C7 00 00 00 00 00 8B 4D F8 83 79 1C 01 72 02 EB 17 68 25 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 83 C2 20 B8 01 00 00 00 F0 0F C1 02 40 89 45 FC 8B 4D F8 8B 51 1C 39 55 FC 75 21 8B 45 0C 50 8B 4D 08 51 8B 55 F8 8B 02 8B 4D F8 8B 50 10 FF D2 8B 4D F8 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_39_65_0 {
	meta:
		name = "?Reset@WaitAllBlock@details@Concurrency@@UAE_NXZ"
		size = 105
		refs = "005b ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F0 8B 45 F0 8B 48 1C 89 4D FC 8B 55 F0 8B 42 20 89 45 F8 8B 4D F8 3B 4D FC 75 02 EB 28 8B 45 F8 8B 55 F8 83 EA 01 8B 4D F0 83 C1 20 F0 0F B1 11 89 45 F4 8B 55 F4 3B 55 F8 75 02 EB 08 8B 45 F4 89 45 F8 EB CE 8B 4D F8 3B 4D FC 75 0C 8B 4D F0 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_66_0 {
	meta:
		name = "?Sweep@WaitAllBlock@details@Concurrency@@UAE_NXZ"
		size = 85
		refs = "001f ??_C@_0DB@DJOFALEM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0024 ??_C@_0BK@FLCBH@m_count?5?$DM?$DN?5m_triggerLimit?$AA@ 0029 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 20 8B 55 FC 3B 4A 1C 77 02 EB 17 68 5B 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 48 20 8B 55 FC 3B 4A 1C 72 11 8B 45 FC 8B 10 8B 4D FC 8B 42 04 FF D0 32 C0 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_68_0 {
	meta:
		name = "?Sweep@details@Concurrency@@YAPAVEventWaitNode@12@PAV312@@Z"
		size = 82
		refs = "0030 ?Sweep@EventWaitNode@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 EB 06 8B 45 FC 89 45 08 83 7D 08 00 74 27 8B 4D 08 8B 11 89 55 FC 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0E 8B 4D 08 8B 55 F8 89 11 8B 45 08 89 45 F8 EB CD 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_69_0 {
	meta:
		name = "?Sweep@EventWaitNode@details@Concurrency@@QAE_NXZ"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 8B 55 FC 8B 42 04 8B 11 8B C8 8B 42 0C FF D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_70_0 {
	meta:
		name = "?Wait@StructuredEvent@details@Concurrency@@QAEXXZ"
		size = 146
		refs = "001c ?_UnderlyingYield@details@Concurrency@@YAXXZ 0024 ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 003c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 004c ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 008a ?Block@Context@Concurrency@@SAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 89 4D D8 8B 45 D8 8B 08 89 4D FC 83 7D FC 01 75 02 EB 73 68 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 55 D8 8B 02 89 45 FC 83 7D FC 01 75 02 EB 56 8D 4D EC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 02 EB 02 EB DD E8 ?? ?? ?? ?? 89 45 E8 8B 55 E8 89 55 E4 8B 45 FC 89 45 E0 8B 45 FC 8D 4D E0 8B 55 D8 F0 0F B1 0A 89 45 DC 8B 45 DC 3B 45 FC 75 02 EB 10 8B 4D DC 89 4D FC 83 7D FC 01 75 02 EB 07 EB D0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_71_0 {
	meta:
		name = "?Set@StructuredEvent@details@Concurrency@@QAEXXZ"
		size = 114
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D EC 8B 45 EC 8B 08 89 4D FC 8B 45 FC BA 01 00 00 00 8B 4D EC F0 0F B1 11 89 45 F8 8B 55 F8 3B 55 FC 75 02 EB 08 8B 45 F8 89 45 FC EB DC 83 7D FC 01 76 31 8B 4D FC 89 4D F0 EB 06 8B 55 F4 89 55 F0 83 7D F0 00 74 1D 8B 45 F0 8B 08 89 4D F4 8B 55 F0 8B 42 04 8B 4D F0 8B 49 04 8B 10 8B 42 0C FF D0 EB D7 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_80_0 {
	meta:
		name = "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 81
		refs = "0021 ??_C@_1DC@GPJLLKOM@?$AA_?$AAM?$AA_?$AAy?$AAi?$AAe?$AAl?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002d ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0034 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 C6 45 FF 00 0F B6 45 FF 85 C0 74 34 8B 4D F8 83 79 0C 00 75 21 68 ?? ?? ?? ?? 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 F8 8B 48 0C FF D1 EB 02 F3 90 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_85_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
		size = 103
		refs = "0013 ??_C@_1DE@FNIGIOLJ@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 001f ??_C@_1GA@IDONOJIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0026 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 21 68 ?? ?? ?? ?? 6A 00 68 C9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 08 00 75 0C 8B 55 FC C7 42 08 04 00 00 00 EB 1C 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 8B 45 FC C7 40 08 01 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__modf_default"
		size = 363
		refs = "000d __ctrlfp 001d _newcw 0045 __d_ind 0055 __sptype 008d __copysign 00c8 __handle_qnan1 00d9 __real@3ff0000000000000 0103 __except1 0116 __frnd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 68 FF FF 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B7 4D 0E 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 CC 00 00 00 8B 55 10 DD 05 ?? ?? ?? ?? DD 1A 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 83 7D E4 00 7E 6F 83 7D E4 02 7E 08 83 7D E4 03 74 3F EB 61 8B 45 10 DD 45 08 DD 18 83 EC 08 DD 45 08 DD 1C 24 83 EC 08 D9 EE DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 E8 E9 B7 00 00 00 8B 55 10 DD 45 08 DD 1A 8B 45 F4 50 83 EC 08 DD 45 08 DD 1C 24 6A 1C E8 ?? ?? ?? ?? 83 C4 10 E9 93 00 00 00 DD 45 08 DC 05 ?? ?? ?? ?? DD 5D E8 8B 4D 10 DD 45 E8 DD 19 8B 55 F4 52 83 EC 08 DD 45 E8 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 1C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 5B 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 8B 45 10 DD 45 F8 DD 18 DD 45 08 DC 65 F8 DD 5D E8 DD 45 E8 D9 EE DA E9 DF E0 F6 C4 44 7A 14 0F B7 4D 0E 81 E1 00 80 00 00 0F B7 55 EE 0B D1 66 89 55 EE 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__wwincmdln"
		size = 147
		refs = "0011 __wcmdln 001b ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 09 C7 45 F4 ?? ?? ?? ?? EB 08 A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 89 4D FC 8B 55 FC 0F B7 02 83 F8 20 7F 10 8B 4D FC 0F B7 11 85 D2 74 28 83 7D F8 00 74 22 8B 45 FC 0F B7 08 83 F9 22 75 0C 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 FC 83 C0 02 89 45 FC EB C3 8B 4D FC 0F B7 11 85 D2 74 16 8B 45 FC 0F B7 08 83 F9 20 7F 0B 8B 55 FC 83 C2 02 89 55 FC EB E0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_qsort"
		size = 1255
		refs = "0043 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004c ??_C@_1FO@NDBPJPLL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0053 __CrtDbgReportW 006a __errno 007e ??_C@_1M@INMHODIG@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA?$AA@ 0088 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0110 ??_C@_1BK@HJGMBFLF@?$AAc?$AAo?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01c3 _shortsort 0200 _swap"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 01 00 00 83 7D 08 00 75 12 83 7D 0C 00 74 0C C7 85 E0 FE FF FF 00 00 00 00 EB 0A C7 85 E0 FE FF FF 01 00 00 00 8B 85 E0 FE FF FF 89 85 EC FE FF FF 83 BD EC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD EC FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 4F 04 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 85 E8 FE FF FF 75 1E 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E8 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 EC 03 00 00 33 D2 83 7D 14 00 0F 95 C2 89 95 E4 FE FF FF 83 BD E4 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E4 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 82 03 00 00 83 7D 0C 02 73 05 E9 77 03 00 00 C7 85 78 FF FF FF 00 00 00 00 8B 4D 08 89 4D F8 8B 55 0C 83 EA 01 0F AF 55 10 03 55 08 89 95 F4 FE FF FF 8B 85 F4 FE FF FF 2B 45 F8 33 D2 F7 75 10 83 C0 01 89 85 74 FF FF FF 83 BD 74 FF FF FF 08 77 20 8B 45 14 50 8B 4D 10 51 8B 95 F4 FE FF FF 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 E9 DE 02 00 00 8B 8D 74 FF FF FF D1 E9 0F AF 4D 10 03 4D F8 89 4D FC 8B 55 FC 52 8B 45 F8 50 FF 55 14 83 C4 08 85 C0 7E 14 8B 4D 10 51 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D F4 FE FF FF 51 8B 55 F8 52 FF 55 14 83 C4 08 85 C0 7E 17 8B 45 10 50 8B 8D F4 FE FF FF 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 F4 FE FF FF 50 8B 4D FC 51 FF 55 14 83 C4 08 85 C0 7E 17 8B 55 10 52 8B 85 F4 FE FF FF 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 89 95 7C FF FF FF 8B 85 F4 FE FF FF 89 85 F0 FE FF FF 8B 4D FC 3B 8D 7C FF FF FF 76 2F 8B 95 7C FF FF FF 03 55 10 89 95 7C FF FF FF 8B 85 7C FF FF FF 3B 45 FC 73 15 8B 4D FC 51 8B 95 7C FF FF FF 52 FF 55 14 83 C4 08 85 C0 7E D1 8B 45 FC 3B 85 7C FF FF FF 77 32 8B 8D 7C FF FF FF 03 4D 10 89 8D 7C FF FF FF 8B 95 7C FF FF FF 3B 95 F4 FE FF FF 77 15 8B 45 FC 50 8B 8D 7C FF FF FF 51 FF 55 14 83 C4 08 85 C0 7E CE 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 7F D1 8B 85 F0 FE FF FF 3B 85 7C FF FF FF 73 02 EB 33 8B 4D 10 51 8B 95 F0 FE FF FF 52 8B 85 7C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 3B 8D F0 FE FF FF 75 09 8B 95 7C FF FF FF 89 55 FC E9 17 FF FF FF 8B 85 F0 FE FF FF 03 45 10 89 85 F0 FE FF FF 8B 4D FC 3B 8D F0 FE FF FF 73 2F 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 74 D1 8B 45 FC 3B 85 F0 FE FF FF 72 2F 8B 8D F0 FE FF FF 2B 4D 10 89 8D F0 FE FF FF 8B 95 F0 FE FF FF 3B 55 F8 76 15 8B 45 FC 50 8B 8D F0 FE FF FF 51 FF 55 14 83 C4 08 85 C0 74 D1 8B 95 F0 FE FF FF 2B 55 F8 8B 85 F4 FE FF FF 2B 85 7C FF FF FF 3B D0 7C 58 8B 4D F8 3B 8D F0 FE FF FF 73 2F 8B 95 78 FF FF FF 8B 45 F8 89 84 95 F8 FE FF FF 8B 8D 78 FF FF FF 8B 95 F0 FE FF FF 89 54 8D 80 8B 85 78 FF FF FF 83 C0 01 89 85 78 FF FF FF 8B 8D 7C FF FF FF 3B 8D F4 FE FF FF 73 0E 8B 95 7C FF FF FF 89 55 F8 E9 40 FD FF FF EB 5C 8B 85 7C FF FF FF 3B 85 F4 FE FF FF 73 32 8B 8D 78 FF FF FF 8B 95 7C FF FF FF 89 94 8D F8 FE FF FF 8B 85 78 FF FF FF 8B 8D F4 FE FF FF 89 4C 85 80 8B 95 78 FF FF FF 83 C2 01 89 95 78 FF FF FF 8B 45 F8 3B 85 F0 FE FF FF 73 11 8B 8D F0 FE FF FF 89 8D F4 FE FF FF E9 E2 FC FF FF 8B 95 78 FF FF FF 83 EA 01 89 95 78 FF FF FF 78 25 8B 85 78 FF FF FF 8B 8C 85 F8 FE FF FF 89 4D F8 8B 95 78 FF FF FF 8B 44 95 80 89 85 F4 FE FF FF E9 AC FC FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "_shortsort"
		size = 111
		refs = "0059 _swap"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 3B 45 08 76 5B 8B 4D 08 89 4D F8 8B 55 08 03 55 10 89 55 FC EB 09 8B 45 FC 03 45 10 89 45 FC 8B 4D FC 3B 4D 0C 77 1A 8B 55 F8 52 8B 45 FC 50 FF 55 14 83 C4 08 85 C0 7E 06 8B 4D FC 89 4D F8 EB D5 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 2B 55 10 89 55 0C EB 9D 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "_swap"
		size = 80
		altNames = "_swap_c"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 3B 45 0C 74 3E 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 2E 8B 45 08 8A 08 88 4D FF 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 339
		refs = "0009 __getptd 007b ___FrameUnwindToState 0143 ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 83 B8 0C 02 00 00 00 75 3C 8B 45 08 81 38 63 73 6D E0 74 31 8B 4D 08 81 39 26 00 00 80 74 26 8B 55 18 8B 02 25 FF FF FF 1F 3D 22 05 93 19 72 15 8B 4D 18 8B 51 20 83 E2 01 74 0A B8 01 00 00 00 E9 FD 00 00 00 8B 45 08 8B 48 04 83 E1 66 74 34 8B 55 18 83 7A 04 00 74 1C 83 7D 1C 00 75 16 6A FF 8B 45 18 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 B8 01 00 00 00 E9 C3 00 00 00 E9 B9 00 00 00 8B 45 18 83 78 0C 00 75 24 8B 4D 18 8B 11 81 E2 FF FF FF 1F 81 FA 21 05 93 19 0F 82 99 00 00 00 8B 45 18 83 78 1C 00 0F 84 8C 00 00 00 8B 4D 08 81 39 63 73 6D E0 75 58 8B 55 08 83 7A 10 03 72 4F 8B 45 08 81 78 14 22 05 93 19 76 43 8B 4D 08 8B 51 1C 8B 42 08 89 45 FC 83 7D FC 00 74 31 0F B6 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 FF 55 FC 83 C4 20 89 45 F8 8B 45 F8 EB 30 EB 29 8B 45 20 50 8B 4D 1C 51 0F B6 55 24 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 1175
		refs = "0053 ?_inconsistency@@YAXXZ 00a9 __getptd 00e2 ?_ValidateRead@@YAHPBXI@Z 016e ?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z 0183 ?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z 0198 ___DestructExceptionObject 01a0 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 01a8 ??0bad_exception@std@@QAE@PBD@Z 01ad __TI2?AVbad_exception@std@@ 01b6 __CxxThrowException@8 01bd ?terminate@@YAXXZ 0227 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 02e7 ___TypeMatch 0326 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 03e8 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 040a ___FrameUnwindToState 0419 ?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0470 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 C6 45 FB 00 C6 45 FA 00 8B 45 18 81 78 04 80 00 00 00 7F 14 8B 4D 0C 8B 51 08 81 E2 FF 00 00 00 0F BE C2 89 45 BC EB 09 8B 4D 0C 8B 51 08 89 55 BC 8B 45 BC 89 45 FC 83 7D FC FF 7C 0D 8B 4D 18 8B 55 FC 3B 51 04 7D 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 81 38 63 73 6D E0 0F 85 5B 01 00 00 8B 4D 08 83 79 10 03 0F 85 4E 01 00 00 8B 55 08 81 7A 14 20 05 93 19 74 1C 8B 45 08 81 78 14 21 05 93 19 74 10 8B 4D 08 81 79 14 22 05 93 19 0F 85 26 01 00 00 8B 55 08 83 7A 1C 00 0F 85 19 01 00 00 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 05 E9 D8 03 00 00 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 08 E8 ?? ?? ?? ?? 8B 88 8C 00 00 00 89 4D 10 C6 45 FB 01 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 81 38 63 73 6D E0 75 3B 8B 4D 08 83 79 10 03 75 32 8B 55 08 81 7A 14 20 05 93 19 74 18 8B 45 08 81 78 14 21 05 93 19 74 0C 8B 4D 08 81 79 14 22 05 93 19 75 0E 8B 55 08 83 7A 1C 00 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 74 79 E8 ?? ?? ?? ?? 8B 80 94 00 00 00 89 45 F4 E8 ?? ?? ?? ?? C7 80 94 00 00 00 00 00 00 00 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 43 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 0F B6 D0 85 D2 74 2B 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D C0 51 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 55 08 81 3A 63 73 6D E0 0F 85 6E 02 00 00 8B 45 08 83 78 10 03 0F 85 61 02 00 00 8B 4D 08 81 79 14 20 05 93 19 74 1C 8B 55 08 81 7A 14 21 05 93 19 74 10 8B 45 08 81 78 14 22 05 93 19 0F 85 39 02 00 00 8B 4D 18 83 79 0C 00 0F 86 2B 01 00 00 8D 55 EC 52 8D 45 F0 50 8B 4D FC 51 8B 55 20 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 E8 EB 12 8B 4D F0 83 C1 01 89 4D F0 8B 55 E8 83 C2 14 89 55 E8 8B 45 F0 3B 45 EC 0F 83 EC 00 00 00 8B 4D E8 8B 11 3B 55 FC 7F 0B 8B 45 E8 8B 4D FC 3B 48 04 7E 02 EB CB 8B 55 E8 8B 42 10 89 45 E0 8B 4D E8 8B 51 0C 89 55 E4 EB 12 8B 45 E4 83 E8 01 89 45 E4 8B 4D E0 83 C1 10 89 4D E0 83 7D E4 00 0F 8E A0 00 00 00 8B 55 08 8B 42 1C 8B 48 0C 83 C1 04 89 4D D8 8B 55 08 8B 42 1C 8B 48 0C 8B 11 89 55 DC EB 12 8B 45 DC 83 E8 01 89 45 DC 8B 4D D8 83 C1 04 89 4D D8 83 7D DC 00 7E 64 8B 55 D8 8B 02 89 45 D4 8B 4D 08 8B 51 1C 52 8B 45 D4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 02 EB C3 C6 45 FA 01 0F B6 55 FB 52 8B 45 24 50 8B 4D 20 51 8B 55 E8 52 8B 45 D4 50 8B 4D E0 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 2C EB 09 EB 07 EB 84 E9 44 FF FF FF E9 F6 FE FF FF 0F B6 4D 1C 85 C9 74 0E 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 45 FA 85 C0 0F 85 DD 00 00 00 8B 4D 18 8B 11 81 E2 FF FF FF 1F 81 FA 21 05 93 19 0F 82 C6 00 00 00 8B 45 18 83 78 1C 00 0F 84 B9 00 00 00 8B 4D 18 8B 51 1C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 0F 85 9B 00 00 00 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 89 55 CC E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 45 D0 E8 ?? ?? ?? ?? 8B 4D 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 10 89 90 8C 00 00 00 83 7D 24 00 75 0F 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? EB 0D 8B 55 08 52 8B 45 24 50 E8 ?? ?? ?? ?? 6A FF 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 18 8B 51 1C 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 4D 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 10 89 90 8C 00 00 00 EB 40 8B 45 18 83 78 0C 00 76 37 0F B6 4D 1C 85 C9 75 2A 8B 55 24 52 8B 45 20 50 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 75 02 EB 05 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 385
		refs = "001a __getptd 002f __encoded_null 006e ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 008a ?_inconsistency@@YAXXZ 00a3 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 0170 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 45 08 81 38 03 00 00 80 75 05 E9 63 01 00 00 E8 ?? ?? ?? ?? 83 B8 80 00 00 00 00 74 57 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 39 86 80 00 00 00 74 43 8B 4D 08 81 39 4D 4F 43 E0 74 38 8B 55 08 81 3A 52 43 43 E0 74 2D 8B 45 24 50 8B 4D 20 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 05 E9 FE 00 00 00 8B 4D 18 83 79 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 8D 55 F4 52 8D 45 F8 50 8B 4D 1C 51 8B 55 20 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC EB 12 8B 4D F8 83 C1 01 89 4D F8 8B 55 FC 83 C2 14 89 55 FC 8B 45 F8 3B 45 F4 0F 83 AF 00 00 00 8B 4D FC 8B 55 1C 3B 11 7C 5C 8B 45 FC 8B 4D 1C 3B 48 04 7F 51 8B 55 FC 8B 42 0C 83 E8 01 C1 E0 04 8B 4D FC 8B 51 10 83 7C 02 04 00 74 1E 8B 45 FC 8B 48 0C 83 E9 01 C1 E1 04 8B 55 FC 8B 42 10 8B 4C 08 04 0F BE 51 08 85 D2 75 1A 8B 45 FC 8B 48 0C 83 E9 01 C1 E1 04 8B 55 FC 8B 42 10 8B 0C 08 83 E1 40 74 05 E9 77 FF FF FF 6A 01 8B 55 24 52 8B 45 20 50 8B 4D FC 51 6A 00 8B 55 FC 8B 42 0C 83 E8 01 C1 E0 04 8B 4D FC 03 41 10 50 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 2C E9 33 FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_7_0 {
	meta:
		name = "___TypeMatch"
		size = 172
		refs = "004a _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 78 04 00 74 0E 8B 4D 08 8B 51 04 0F BE 42 08 85 C0 75 0A B8 01 00 00 00 E9 81 00 00 00 8B 4D 08 8B 55 0C 8B 41 04 3B 42 04 74 24 8B 4D 0C 8B 51 04 83 C2 08 52 8B 45 08 8B 48 04 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 04 33 C0 EB 4F 8B 55 0C 8B 02 83 E0 02 74 0A 8B 4D 08 8B 11 83 E2 08 74 31 8B 45 10 8B 08 83 E1 01 74 0A 8B 55 08 8B 02 83 E0 01 74 1D 8B 4D 10 8B 11 83 E2 02 74 0A 8B 45 08 8B 08 83 E1 02 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "___FrameUnwindFilter"
		size = 123
		refs = "0036 __getptd 0045 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 8B 08 89 4D FC 8B 55 FC 8B 02 89 45 F8 81 7D F8 52 43 43 E0 74 28 81 7D F8 4D 4F 43 E0 74 1F 81 7D F8 63 73 6D E0 74 02 EB 40 E8 ?? ?? ?? ?? C7 80 90 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F4 8B 4D F4 8B 11 83 EA 01 8B 45 F4 89 10 33 C0 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_9_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 384
		refs = "0008 __sehtable$___FrameUnwindToState 000d __except_handler4 001f ___security_cookie 0065 __getptd 00a5 ?_inconsistency@@YAXXZ 00f0 __CallSettingFrame@12 0102 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 10 81 78 04 80 00 00 00 7F 14 8B 4D 08 8B 51 08 81 E2 FF 00 00 00 0F BE C2 89 45 DC EB 09 8B 4D 08 8B 51 08 89 55 DC 8B 45 DC 89 45 E4 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D8 8B 4D D8 8B 11 83 C2 01 8B 45 D8 89 10 C7 45 FC 00 00 00 00 8B 4D E4 3B 4D 14 0F 84 8E 00 00 00 83 7D E4 FF 7E 0D 8B 55 10 8B 45 E4 3B 42 04 7D 02 EB 05 E8 ?? ?? ?? ?? 8B 4D 10 8B 51 08 8B 45 E4 8B 0C C2 89 4D E0 C7 45 FC 01 00 00 00 8B 55 10 8B 42 08 8B 4D E4 83 7C C8 04 00 74 25 8B 55 08 8B 45 E0 89 42 08 68 03 01 00 00 8B 4D 08 51 8B 55 10 8B 42 08 8B 4D E4 8B 54 C8 04 52 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 17 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC 00 00 00 00 8B 4D E0 89 4D E4 E9 66 FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 29 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D4 8B 55 D4 8B 02 83 E8 01 8B 4D D4 89 01 C3 8B 55 E4 3B 55 14 75 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 8B 4D E4 89 48 08 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_10_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 185
		refs = "0025 ___BuildCatchObject 003b ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0061 ___FrameUnwindToState 0098 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 00b1 ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 89 45 FC 83 7D 20 00 74 18 8B 4D 20 51 8B 55 1C 52 8B 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D 2C 00 75 0F 8B 55 08 52 8B 45 0C 50 E8 ?? ?? ?? ?? EB 0D 8B 4D 08 51 8B 55 2C 52 E8 ?? ?? ?? ?? 8B 45 24 8B 08 51 8B 55 18 52 8B 45 14 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 24 8B 42 04 83 C0 01 8B 4D 0C 89 41 08 68 00 01 00 00 8B 55 28 52 8B 45 1C 8B 48 0C 51 8B 55 18 52 8B 45 10 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 83 7D F8 00 74 0D 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_11_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 646
		refs = "0008 __sehtable$?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 000d __except_handler4 001f ___security_cookie 0057 __CreateFrameInfo 0062 __getptd 00c3 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 00de ?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z 01ab ___FrameUnwindToState 01e6 __FindAndUnlinkFrame 0255 __IsExceptionObjectToBeDestroyed 0269 ___DestructExceptionObject"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 C0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 18 89 45 D0 C7 45 DC 00 00 00 00 8B 4D 0C 8B 51 FC 89 55 E0 8B 45 08 8B 48 18 51 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 C8 E8 ?? ?? ?? ?? 8B 88 8C 00 00 00 89 4D CC E8 ?? ?? ?? ?? 8B 55 08 89 90 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D 10 89 88 8C 00 00 00 C7 45 FC 00 00 00 00 C7 45 B4 01 00 00 00 C7 45 FC 01 00 00 00 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 D0 C7 45 FC 00 00 00 00 E9 E7 00 00 00 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 80 0C 02 00 00 00 00 00 00 8B 55 14 8B 42 08 89 45 B8 8B 4D 14 81 79 04 80 00 00 00 7F 13 8B 55 0C 8B 42 08 25 FF 00 00 00 0F BE C8 89 4D B0 EB 09 8B 55 0C 8B 42 08 89 45 B0 8B 4D B0 89 4D BC 8B 55 14 8B 42 10 89 45 C0 C7 45 C4 00 00 00 00 EB 09 8B 4D C4 83 C1 01 89 4D C4 8B 55 14 8B 45 C4 3B 42 0C 73 47 8B 4D C4 6B C9 14 8B 55 C0 8B 45 BC 3B 44 0A 04 7E 33 8B 4D C4 6B C9 14 8B 55 C0 8B 45 BC 3B 44 0A 08 7F 21 8B 4D C4 6B C9 14 8B 55 C0 8B 44 0A 04 83 C0 01 89 45 BC 8B 4D BC 8B 55 B8 8B 04 CA 89 45 BC EB 02 EB A5 8B 4D BC 51 8B 55 14 52 6A 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 C7 45 D0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 FC FE FF FF FF C7 45 B4 00 00 00 00 E8 05 00 00 00 E9 99 00 00 00 8B 4D 0C 8B 55 E0 89 51 FC 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 4D C8 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 CC 89 90 8C 00 00 00 8B 45 08 81 38 63 73 6D E0 75 5C 8B 4D 08 83 79 10 03 75 53 8B 55 08 81 7A 14 20 05 93 19 74 18 8B 45 08 81 78 14 21 05 93 19 74 0C 8B 4D 08 81 79 14 22 05 93 19 75 2F 83 7D DC 00 75 29 83 7D D0 00 74 23 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 10 8B 4D B4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 D0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_12_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 109
		refs = "0050 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 4E 8B 45 FC 83 78 10 03 75 45 8B 4D FC 81 79 14 20 05 93 19 74 18 8B 55 FC 81 7A 14 21 05 93 19 74 0C 8B 45 FC 81 78 14 22 05 93 19 75 21 8B 4D FC 83 79 1C 00 75 18 E8 ?? ?? ?? ?? C7 80 0C 02 00 00 01 00 00 00 B8 01 00 00 00 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_13_0 {
	meta:
		name = "___BuildCatchObjectHelper"
		size = 624
		refs = "0008 __sehtable$___BuildCatchObjectHelper 000d __except_handler4 001f ___security_cookie 00af ?_ValidateRead@@YAHPBXI@Z 00c1 ?_ValidateWrite@@YAHPAXI@Z 00e5 ___AdjustPointer 00f4 ?_inconsistency@@YAXXZ 0141 _memmove 0211 ?_ValidateExecute@@YAHP6GHXZ@Z 0250 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 E4 00 00 00 00 8B 45 10 83 78 04 00 74 23 8B 4D 10 8B 51 04 0F BE 42 08 85 C0 74 15 8B 4D 10 83 79 08 00 75 13 8B 55 10 8B 02 25 00 00 00 80 75 07 33 C0 E9 EF 01 00 00 8B 4D 10 8B 11 81 E2 00 00 00 80 74 08 8B 45 0C 89 45 E0 EB 10 8B 4D 10 8B 51 08 8B 45 0C 8D 4C 10 0C 89 4D E0 C7 45 FC 00 00 00 00 8B 55 10 8B 02 83 E0 08 74 58 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 39 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 27 8B 4D E0 8B 55 08 8B 42 18 89 01 8B 4D 14 83 C1 08 51 8B 55 E0 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E0 89 01 EB 05 E8 ?? ?? ?? ?? E9 40 01 00 00 8B 55 14 8B 02 83 E0 01 74 78 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 59 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 47 8B 4D 14 8B 51 14 52 8B 45 08 8B 48 18 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 14 83 78 14 04 75 22 8B 4D E0 83 39 00 74 1A 8B 55 14 83 C2 08 52 8B 45 E0 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E0 89 02 EB 05 E8 ?? ?? ?? ?? E9 BE 00 00 00 8B 45 14 83 78 18 00 75 5A 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 3E 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2C 8B 4D 14 8B 51 14 52 8B 45 14 83 C0 08 50 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C EB 05 E8 ?? ?? ?? ?? EB 5B 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 41 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2F 8B 4D 14 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1C 8B 45 14 8B 08 83 E1 04 74 09 C7 45 E4 02 00 00 00 EB 07 C7 45 E4 01 00 00 00 EB 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 15 B8 01 00 00 00 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_14_0 {
	meta:
		name = "___BuildCatchObject"
		size = 268
		refs = "0008 __sehtable$___BuildCatchObject 000d __except_handler4 001f ___security_cookie 0072 ___BuildCatchObjectHelper 0099 ___AdjustPointer 00ad ?_CallMemberFunction1@@YGXPAX00@Z 00d8 ?_CallMemberFunction2@@YGXPAX00H@Z 00ef ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 10 8B 08 81 E1 00 00 00 80 74 08 8B 55 0C 89 55 E4 EB 10 8B 45 10 8B 48 08 8B 55 0C 8D 44 0A 0C 89 45 E4 C7 45 FC 00 00 00 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 01 74 08 83 7D E0 02 74 2B EB 52 8B 55 14 83 C2 08 52 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 55 14 8B 42 18 50 8B 4D E4 51 E8 ?? ?? ?? ?? EB 29 6A 01 8B 55 14 83 C2 08 52 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 55 14 8B 42 18 50 8B 4D E4 51 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 15 B8 01 00 00 00 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_15_0 {
	meta:
		name = "___DestructExceptionObject"
		size = 175
		refs = "0008 __sehtable$___DestructExceptionObject 000d __except_handler4 001f ___security_cookie 0076 ?_CallMemberFunction0@@YGXPAX0@Z 0092 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 83 7D 08 00 74 0B 8B 45 08 81 38 63 73 6D E0 74 02 EB 55 8B 4D 08 83 79 1C 00 74 4C 8B 55 08 8B 42 1C 83 78 04 00 74 40 C7 45 FC 00 00 00 00 8B 4D 08 8B 51 1C 8B 42 04 50 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 1A 0F B6 45 0C F7 D8 1B C0 F7 D8 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_16_0 {
	meta:
		name = "___AdjustPointer"
		size = 72
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 4D 08 03 08 89 4D FC 8B 55 0C 83 7A 04 00 7C 27 8B 45 0C 8B 48 04 8B 55 08 8B 04 0A 8B 4D 0C 8B 51 08 8B 4D FC 03 0C 10 89 4D FC 8B 55 0C 8B 45 FC 03 42 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_17_0 {
	meta:
		name = "?__uncaught_exception@@YA_NXZ"
		size = 26
		refs = "0006 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 33 C9 83 B8 90 00 00 00 00 0F 95 C1 8A C1 5D C3 }
	condition:
		$1
}

rule file_45_18_0 {
	meta:
		name = "___CxxExceptionFilter"
		size = 499
		refs = "0092 __getptd 01a1 ___TypeMatch 01dd ___BuildCatchObject"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 75 07 33 C0 E9 DA 01 00 00 8B 45 08 8B 08 89 4D F8 83 7D 0C 00 74 0F 8B 55 0C 0F BE 42 08 85 C0 0F 85 98 00 00 00 8B 4D F8 81 39 4D 4F 43 E0 74 13 8B 55 F8 81 3A 52 43 43 E0 74 08 8B 45 10 83 E0 40 75 7A 8B 4D F8 81 39 63 73 6D E0 75 4B 8B 55 F8 83 7A 10 03 75 42 8B 45 F8 81 78 14 20 05 93 19 74 18 8B 4D F8 81 79 14 21 05 93 19 74 0C 8B 55 F8 81 7A 14 22 05 93 19 75 1E 8B 45 F8 83 78 1C 00 75 15 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 07 33 C0 E9 49 01 00 00 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 DC 8B 4D DC 8B 11 83 C2 01 8B 45 DC 89 10 B8 01 00 00 00 E9 25 01 00 00 8B 4D F8 81 39 63 73 6D E0 0F 85 14 01 00 00 8B 55 F8 83 7A 10 03 0F 85 07 01 00 00 8B 45 F8 81 78 14 20 05 93 19 74 1C 8B 4D F8 81 79 14 21 05 93 19 74 10 8B 55 F8 81 7A 14 22 05 93 19 0F 85 DF 00 00 00 8B 45 F8 83 78 1C 00 75 23 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 07 33 C0 E9 C3 00 00 00 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 89 4D F8 8B 55 0C 89 55 E4 8B 45 10 89 45 E0 8B 4D E0 81 C9 00 00 00 80 89 4D E0 8B 55 F8 8B 42 1C 8B 48 0C 83 C1 04 89 4D F4 8B 55 F8 8B 42 1C 8B 48 0C 8B 11 89 55 FC EB 12 8B 45 FC 83 E8 01 89 45 FC 8B 4D F4 83 C1 04 89 4D F4 83 7D FC 00 7E 64 8B 55 F4 8B 02 89 45 F0 8B 4D F8 8B 51 1C 52 8B 45 F0 50 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 3F E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D8 8B 55 D8 8B 02 83 C0 01 8B 4D D8 89 01 83 7D 14 00 74 18 8B 55 F0 52 8D 45 E0 50 8B 4D 14 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 B8 01 00 00 00 EB 04 EB 84 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_19_0 {
	meta:
		name = "___CxxRegisterExceptionObject"
		size = 300
		refs = "0087 __getptd 00a0 __CreateFrameInfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 C7 45 F0 00 00 00 00 8B 45 0C 89 45 FC 8B 4D FC 83 C1 08 89 4D F4 8B 55 F4 83 C2 04 89 55 F8 83 7D 08 00 0F 84 A9 00 00 00 8B 45 08 83 38 00 0F 84 9D 00 00 00 8B 4D 08 8B 11 89 55 F0 8B 45 F0 81 38 63 73 6D E0 75 44 8B 4D F0 83 79 10 03 75 3B 8B 55 F0 81 7A 14 20 05 93 19 74 18 8B 45 F0 81 78 14 21 05 93 19 74 0C 8B 4D F0 81 79 14 22 05 93 19 75 17 8B 55 F0 83 7A 1C 00 75 0E E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 F0 8B 4D F0 8B 51 18 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC E8 ?? ?? ?? ?? 8B 4D F4 8B 90 88 00 00 00 89 11 E8 ?? ?? ?? ?? 8B 4D F8 8B 90 8C 00 00 00 89 11 E8 ?? ?? ?? ?? 8B 4D F0 89 88 88 00 00 00 EB 12 8B 55 F4 C7 02 FF FF FF FF 8B 45 F8 C7 00 FF FF FF FF E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 EC 8B 4D EC 8B 11 83 EA 01 8B 45 EC 89 10 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7D 0F E8 ?? ?? ?? ?? C7 80 90 00 00 00 00 00 00 00 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_20_0 {
	meta:
		name = "___CxxDetectRethrow"
		size = 130
		refs = "005c __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 75 04 33 C0 EB 6C 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 57 8B 45 FC 83 78 10 03 75 4E 8B 4D FC 81 79 14 20 05 93 19 74 18 8B 55 FC 81 7A 14 21 05 93 19 74 0C 8B 45 FC 81 78 14 22 05 93 19 75 2A 8B 4D FC 83 79 1C 00 75 21 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_21_0 {
	meta:
		name = "___CxxUnregisterExceptionObject"
		size = 375
		refs = "0031 __FindAndUnlinkFrame 0043 __getptd 00b2 __IsExceptionObjectToBeDestroyed 00cc ___DestructExceptionObject"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 89 45 FC 8B 4D FC 83 C1 08 89 4D F4 8B 55 F4 83 C2 04 89 55 F8 8B 45 F4 83 38 FF 0F 84 47 01 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 7D 0C 00 0F 85 91 00 00 00 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 3A 63 73 6D E0 75 7E E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 6D E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 79 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 7A 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 31 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 6A 01 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 39 63 73 6D E0 75 6D E8 ?? ?? ?? ?? 8B 90 88 00 00 00 83 7A 10 03 75 5C E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 79 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 7A 14 22 05 93 19 75 20 83 7D 0C 00 74 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F0 8B 45 F0 8B 08 83 E9 01 8B 55 F0 89 0A E8 ?? ?? ?? ?? 8B 4D F4 8B 11 89 90 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D F8 8B 11 89 90 8C 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_23_0 {
	meta:
		name = "___CxxCallUnwindDtor"
		size = 116
		refs = "0008 __sehtable$___CxxCallUnwindDtor 000d __except_handler4 001f ___security_cookie 0050 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 4D 0C FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_24_0 {
	meta:
		name = "___CxxCallUnwindDelDtor"
		size = 120
		refs = "0008 __sehtable$___CxxCallUnwindDelDtor 000d __except_handler4 001f ___security_cookie 0054 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 0C 50 FF 55 08 83 C4 04 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_25_0 {
	meta:
		name = "___CxxCallUnwindStdDelDtor"
		size = 117
		refs = "0008 __sehtable$___CxxCallUnwindStdDelDtor 000d __except_handler4 001f ___security_cookie 0051 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 0C 50 FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_26_0 {
	meta:
		name = "___CxxCallUnwindVecDtor"
		size = 129
		refs = "0008 __sehtable$___CxxCallUnwindVecDtor 000d __except_handler4 001f ___security_cookie 005d ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_27_0 {
	meta:
		name = "?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z"
		size = 180
		refs = "0011 ?_inconsistency@@YAXXZ 001c ?terminate@@YAXXZ 0098 ___TypeMatch"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 83 7D 0C 00 75 05 E8 ?? ?? ?? ?? C6 45 F3 00 C7 45 EC 00 00 00 00 EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D 0C 8B 55 EC 3B 11 7D 6D 8B 45 08 8B 48 1C 8B 51 0C 83 C2 04 89 55 F8 8B 45 08 8B 48 1C 8B 51 0C 8B 02 89 45 FC EB 12 8B 4D FC 83 E9 01 89 4D FC 8B 55 F8 83 C2 04 89 55 F8 83 7D FC 00 7E 34 8B 45 F8 8B 08 89 4D F4 8B 55 08 8B 42 1C 50 8B 4D F4 51 8B 55 EC C1 E2 04 8B 45 0C 03 50 04 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 C6 45 F3 01 EB 02 EB B4 EB 80 8A 45 F3 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_28_0 {
	meta:
		name = "?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 78
		refs = "0008 __ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0018 ___security_cookie 002c __getptd 003c ?_inconsistency@@YAXXZ 0048 ?unexpected@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 75 02 EB 05 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? EB 24 }
	condition:
		$1
}

rule file_45_29_0 {
	meta:
		name = "__catch$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$0"
		size = 66
		refs = "0001 __getptd 0013 __CxxThrowException@8 001f __tryend$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$1 002c ?terminate@@YAXXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 4D 08 89 88 94 00 00 00 6A 00 6A 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_31_0 {
	meta:
		name = "?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z"
		size = 79
		refs = "0023 ??_R0?AVbad_exception@std@@@8 0038 ??8type_info@@QBE_NABV0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 55 FC 3B 11 7D 27 68 ?? ?? ?? ?? 8B 45 FC C1 E0 04 8B 4D 08 8B 51 04 8B 4C 02 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 B0 01 EB 04 EB C6 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_32_0 {
	meta:
		name = "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"
		size = 214
		refs = "0011 ?_inconsistency@@YAXXZ 00b6 ?raw_name@type_info@@QBEPBDXZ 00bc _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 8B 45 0C 8B 08 89 4D F4 83 7D F4 00 74 02 EB 05 E8 ?? ?? ?? ?? 8B 55 F4 81 3A 63 73 6D E0 75 2F 8B 45 F4 83 78 10 03 75 26 8B 4D F4 81 79 14 20 05 93 19 74 18 8B 55 F4 81 7A 14 21 05 93 19 74 0C 8B 45 F4 81 78 14 22 05 93 19 75 02 EB 05 E8 ?? ?? ?? ?? 8B 4D F4 8B 51 1C 8B 42 0C 83 C0 04 89 45 F8 8B 4D F4 8B 51 1C 8B 42 0C 8B 08 89 4D FC EB 12 8B 55 FC 83 EA 01 89 55 FC 8B 45 F8 83 C0 04 89 45 F8 83 7D FC 00 7E 30 8B 4D F8 8B 11 89 55 F0 8B 45 F0 8B 48 04 83 C1 08 51 8B 4D 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 07 B8 01 00 00 00 EB 04 EB B8 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "___clean_type_info_names"
		size = 20
		refs = "0006 ?__type_info_root_node@@3U__type_info_node@@A 000b ___clean_type_info_names_internal"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_71_48_1 {
	meta:
		name = "??__E_Fac_tidy_reg@std@@YAXXZ"
		size = 20
		refs = "0006 ??__F_Fac_tidy_reg@std@@YAXXZ 000b _atexit"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_215_7_0 {
	meta:
		name = "??__Eg_terminationFlagger@details@Concurrency@@YAXXZ"
		size = 20
		refs = "0006 ??__Fg_terminationFlagger@details@Concurrency@@YAXXZ 000b _atexit"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_85_2_1 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 20
		refs = "0006 ??__Finit_atexit@@YAXXZ 000b _atexit"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_82_7_1 {
	meta:
		name = "?_Lockit_ctor@_Lockit@std@@CAXPAV12@@Z"
		size = 20
		refs = "0006 _mtx 000b __Mtxlock"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__wstat64"
		size = 1716
		refs = "000c ___security_cookie 0039 ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0042 ??_C@_1GA@FGGLPCAO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0049 __CrtDbgReportW 0060 ___doserrno 006b __errno 007f ??_C@_1BC@NCDNKELJ@?$AA_?$AAw?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AA?$AA@ 0089 __invalid_parameter 00b1 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0111 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 011a _wcspbrk 018a _towlower 01a0 __getdrive 01bf __imp__FindFirstFileExW@24 01e1 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 020d __wfullpath_helper 022b _wcslen 023f _IsRootUNCName 0253 __imp__GetDriveTypeW@4 026d _free 02e3 ___loctotime64_t 0359 __wsopen_s 03a2 __fstat64 03b7 __close 03f4 __imp__FileTimeToLocalFileTime@8 040c __imp__FileTimeToSystemTime@8 0416 __imp__GetLastError@0 041c __dosmaperr 042c __imp__FindClose@4 0629 ___wdtoxmode 0652 __allmul 06ac @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A0 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 C7 85 EC FD FF FF 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 88 FB FF FF 83 BD 88 FB FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FB FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 0D 06 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 84 FB FF FF 83 BD 84 FB FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 84 FB FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 95 05 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 62 05 00 00 8B 55 08 0F B7 42 02 83 F8 3A 75 50 8B 4D 08 0F B7 11 85 D2 74 29 8B 45 08 0F B7 48 04 85 C9 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 23 05 00 00 8B 55 08 0F B7 02 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 83 E9 60 89 8D 90 FB FF FF EB 0B E8 ?? ?? ?? ?? 89 85 90 FB FF FF 6A 00 6A 00 6A 00 8D 95 98 FB FF FF 52 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 85 94 FB FF FF 83 BD 94 FB FF FF FF 0F 85 46 01 00 00 C7 85 80 FB FF FF 00 00 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 67 8D 95 80 FB FF FF 52 68 04 01 00 00 8B 45 08 50 8D 8D F0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 8C FB FF FF 83 BD 8C FB FF FF 00 74 39 8B 95 8C FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 85 8C FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 8D 8C FB FF FF 51 FF 15 ?? ?? ?? ?? 83 F8 01 77 36 83 BD 80 FB FF FF 00 74 0F 8B 95 80 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 13 04 00 00 83 BD 80 FB FF FF 00 74 0F 8B 85 80 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 C7 85 98 FB FF FF 10 00 00 00 C7 85 B4 FB FF FF 00 00 00 00 C7 85 B8 FB FF FF 00 00 00 00 33 C9 66 89 8D C4 FB FF FF 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 8B 4D 0C 8B 55 0C 8B 42 28 89 41 30 8B 52 2C 89 51 34 E9 01 03 00 00 8B 85 98 FB FF FF 25 00 04 00 00 0F 84 A1 00 00 00 81 BD BC FB FF FF 0C 00 00 A0 0F 85 91 00 00 00 C7 85 78 FB FF FF FF FF FF FF 6A 00 6A 40 6A 00 8B 4D 08 51 8D 95 78 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 7C FB FF FF 83 BD 7C FB FF FF 00 75 09 83 BD 78 FB FF FF FF 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 0F 03 00 00 8B 45 0C 50 8B 8D 78 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 EC FD FF FF 8B 95 78 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 85 EC FD FF FF E9 DC 02 00 00 E9 4F 02 00 00 83 BD AC FB FF FF 00 75 0D 83 BD B0 FB FF FF 00 0F 84 99 00 00 00 8D 85 70 FB FF FF 50 8D 8D AC FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 60 FB FF FF 52 8D 85 70 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 94 FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 6D 02 00 00 6A FF 0F B7 95 6C FB FF FF 52 0F B7 85 6A FB FF FF 50 0F B7 8D 68 FB FF FF 51 0F B7 95 66 FB FF FF 52 0F B7 85 62 FB FF FF 50 0F B7 8D 60 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C EB 11 8B 55 0C C7 42 28 00 00 00 00 C7 42 2C 00 00 00 00 83 BD A4 FB FF FF 00 75 0D 83 BD A8 FB FF FF 00 0F 84 99 00 00 00 8D 85 70 FB FF FF 50 8D 8D A4 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 60 FB FF FF 52 8D 85 70 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 94 FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 AD 01 00 00 6A FF 0F B7 95 6C FB FF FF 52 0F B7 85 6A FB FF FF 50 0F B7 8D 68 FB FF FF 51 0F B7 95 66 FB FF FF 52 0F B7 85 62 FB FF FF 50 0F B7 8D 60 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 89 51 24 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 83 BD 9C FB FF FF 00 75 0D 83 BD A0 FB FF FF 00 0F 84 99 00 00 00 8D 8D 70 FB FF FF 51 8D 95 9C FB FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 85 60 FB FF FF 50 8D 8D 70 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 95 94 FB FF FF 52 FF 15 ?? ?? ?? ?? 83 C8 FF E9 EC 00 00 00 6A FF 0F B7 85 6C FB FF FF 50 0F B7 8D 6A FB FF FF 51 0F B7 95 68 FB FF FF 52 0F B7 85 66 FB FF FF 50 0F B7 8D 62 FB FF FF 51 0F B7 95 60 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 30 89 51 34 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 30 8B 40 2C 89 42 34 8B 8D 94 FB FF FF 51 FF 15 ?? ?? ?? ?? 8B 55 08 52 8B 85 98 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 BA 01 00 00 00 8B 45 0C 66 89 50 08 8B 8D B4 FB FF FF 33 D2 6A 01 6A 00 52 51 E8 ?? ?? ?? ?? 8B 8D B8 FB FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 33 D2 8B 45 0C 66 89 50 04 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 8B 95 90 FB FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 8B 85 EC FD FF FF 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 267
		refs = "000b _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 EA 00 00 00 8B 4D 08 0F B7 11 83 FA 5C 74 0F 8B 45 08 0F B7 08 83 F9 2F 0F 85 D0 00 00 00 8B 55 08 0F B7 42 02 83 F8 5C 74 10 8B 4D 08 0F B7 51 02 83 FA 2F 0F 85 B4 00 00 00 8B 45 08 0F B7 48 04 83 F9 5C 0F 84 A4 00 00 00 8B 55 08 0F B7 42 04 83 F8 2F 0F 84 94 00 00 00 8B 4D 08 83 C1 04 89 4D FC 8B 55 FC 83 C2 02 89 55 FC 8B 45 FC 0F B7 08 85 C9 74 1A 8B 55 FC 0F B7 02 83 F8 5C 74 0B 8B 4D FC 0F B7 11 83 FA 2F 75 02 EB 02 EB D3 8B 45 FC 0F B7 08 85 C9 74 54 8B 55 FC 0F B7 42 02 85 C0 74 49 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 85 C0 74 1A 8B 4D FC 0F B7 11 83 FA 5C 74 0B 8B 45 FC 0F B7 08 83 F9 2F 75 02 EB 02 EB D3 8B 55 FC 0F B7 02 85 C0 74 0B 8B 4D FC 0F B7 51 02 85 D2 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "__wfullpath_helper"
		size = 127
		refs = "0009 __errno 002a __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 F8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 0F E8 ?? ?? ?? ?? 8B 4D F8 89 08 8B 45 FC EB 32 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 24 E8 ?? ?? ?? ?? 8B 55 F8 89 10 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "__fullpath_helper"
		size = 127
		refs = "0009 __errno 002a __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 F8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 0F E8 ?? ?? ?? ?? 8B 4D F8 89 08 8B 45 FC EB 32 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 24 E8 ?? ?? ?? ?? 8B 55 F8 89 10 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__chsize_s"
		size = 666
		refs = "0008 __sehtable$__chsize_s 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0058 __nhandle 007b ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0084 ??_C@_1GA@DBKMEDOF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 008b __CrtDbgReportW 00aa __errno 00be ??_C@_1BE@MAFDNGED@?$AA_?$AAc?$AAh?$AAs?$AAi?$AAz?$AAe?$AA_?$AAs?$AA?$AA@ 00c8 __invalid_parameter 00eb ___pioinfo 0103 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 018c ??_C@_1BI@GALBKMKE@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 01ef ___lock_fhandle 022a __chsize_nolock 023b ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 027d __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 15 E8 ?? ?? ?? ?? C7 00 00 00 00 00 B8 09 00 00 00 E9 3B 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 AF 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 27 01 00 00 83 7D 10 00 7C 11 7F 06 83 7D 0C 00 72 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 9E 00 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 01 74 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 34 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 E4 09 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "__chsize_nolock"
		size = 657
		refs = "0029 __lseeki64_nolock 0065 __errno 00a1 __imp__GetProcessHeap@0 00a8 __imp__HeapAlloc@12 00e4 __setmode_nolock 0141 __write_nolock 0152 ___doserrno 01c2 __imp__HeapFree@12 0205 __get_osfhandle 020f __imp__SetEndOfFile@4 0242 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 56 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 CC 00 00 00 00 6A 01 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 4D D8 23 4D DC 83 F9 FF 74 23 6A 02 6A 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 89 55 D4 8B 45 D0 23 45 D4 83 F8 FF 75 0C E8 ?? ?? ?? ?? 8B 00 E9 1C 02 00 00 8B 4D 0C 2B 4D D0 8B 55 10 1B 55 D4 89 4D E8 89 55 EC 83 7D EC 00 0F 8C 3F 01 00 00 7F 0A 83 7D E8 00 0F 86 33 01 00 00 68 00 10 00 00 6A 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 75 25 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 45 CC 0C 00 00 00 C7 45 F8 FF FF FF FF C7 45 FC FF FF FF FF E9 EC 00 00 00 68 00 80 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 83 7D EC 00 7C 14 7F 09 81 7D E8 00 10 00 00 72 09 C7 45 C4 00 10 00 00 EB 06 8B 4D E8 89 4D C4 8B 55 C4 89 55 F4 83 7D EC 00 7C 14 7F 09 81 7D E8 00 10 00 00 72 09 C7 45 C0 00 10 00 00 EB 06 8B 45 E8 89 45 C0 8B 4D C0 51 8B 55 C8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 FF 75 28 E8 ?? ?? ?? ?? 83 38 05 75 12 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 CC 0D 00 00 00 8B 45 F4 99 89 45 F8 89 55 FC EB 2A 8B 45 F4 99 8B 4D E8 2B C8 8B 45 EC 1B C2 89 4D E8 89 45 EC 83 7D EC 00 0F 8F 57 FF FF FF 7C 0A 83 7D E8 00 0F 87 4B FF FF FF 8B 4D E4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 C8 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? E9 84 00 00 00 83 7D EC 00 7F 7E 7C 06 83 7D E8 00 73 76 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 89 55 FC 8B 4D F8 23 4D FC 83 F9 FF 74 4F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 E8 01 99 89 45 F8 89 55 FC 8B 45 F8 23 45 FC 83 F8 FF 75 21 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 CC 0D 00 00 00 FF 15 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 8B 4D F8 23 4D FC 83 F9 FF 74 27 6A 00 8B 55 DC 52 8B 45 D8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 89 55 BC 8B 55 B8 23 55 BC 83 FA FF 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_2_0 {
	meta:
		name = "__chsize"
		size = 38
		refs = "0011 __chsize_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 99 52 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC F7 D8 1B C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__output_s_l"
		size = 5136
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BI@COFBLHCG@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0107 __fileno 013e ___pioinfo 0150 ___badioinfo 01ea ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0272 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 035c ___lookuptable_s 03de ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 046f $LN174 047e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 048c __isleadbyte_l 04af _write_char 04e0 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 05d0 $LN170 05d7 $LN175 0628 _get_int_arg 06e5 $LN171 06ec $LN176 0820 $LN172 0827 $LN177 085b _get_short_arg 0882 _wctomb_s 08fe ___nullstring 090a _strlen 09c9 ___wnullstring 0a9a __get_printf_count_output 0ad6 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0bf7 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0c08 __malloc_dbg 0c7a __cfltcvt_tab 0c81 __imp__DecodePointer@4 0db3 _get_int64_arg 0f80 __aullrem 0fa2 __aulldiv 10a9 _write_multi_char 10c4 _write_string 1224 __free_dbg 1275 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 1301 @__security_check_cookie@4 130c $NORMAL_STATE$29568 1310 $LN131 1314 $LN130 1318 $LN122 131c $LN118 1320 $LN117 1324 $LN113 1328 $LN97 132c $LN125 1330 $LN124 1334 $LN126 1338 $LN127 133c $LN123 1340 $LN128 1358 $LN107 135c $LN99 1360 $LN110 1364 $LN98 1368 $LN111 139c $LN66 13a0 $LN94 13a4 $LN82 13a8 $LN48 13ac $LN88 13b0 $LN65 13b4 $LN92 13b8 $LN53 13bc $LN71 13c0 $LN43 13c4 $LN49 13c8 $LN80 13cc $LN51 13d0 $LN46 13d4 $LN95"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 1C FD FF FF E9 17 12 00 00 8B 45 08 89 85 98 FD FF FF 8B 8D 98 FD FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FD FF FF 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 8D 94 FD FF FF C1 F9 05 8B 95 94 FD FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 FC FC FF FF EB 0A C7 85 FC FC FF FF ?? ?? ?? ?? 8B 85 FC FC FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 85 94 FD FF FF C1 F8 05 8B 8D 94 FD FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D F8 FC FF FF EB 0A C7 85 F8 FC FF FF ?? ?? ?? ?? 8B 95 F8 FC FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 F4 FC FF FF 00 00 00 00 EB 0A C7 85 F4 FC FF FF 01 00 00 00 8B 95 F4 FC FF FF 89 95 90 FD FF FF 83 BD 90 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 18 FD FF FF E9 A2 10 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 8C FD FF FF 83 BD 8C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 14 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 14 FD FF FF E9 1A 10 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 0C 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 0A 0F 00 00 83 BD B4 FD FF FF 00 0F 8C FD 0E 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D F0 FC FF FF EB 0A C7 85 F0 FC FF FF 00 00 00 00 8B 95 F0 FC FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 6B C0 09 8B 8D A4 FD FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 83 BD A4 FD FF FF 08 0F 85 9F 00 00 00 33 C0 74 0C C7 85 EC FC FF FF 01 00 00 00 EB 0A C7 85 EC FC FF FF 00 00 00 00 8B 8D EC FC FF FF 89 8D 88 FD FF FF 83 BD 88 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 10 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 10 FD FF FF E9 AE 0E 00 00 8B 85 A4 FD FF FF 89 85 E8 FC FF FF 83 BD E8 FC FF FF 07 0F 87 CC 0D 00 00 8B 8D E8 FC FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B4 00 00 00 8D 85 B4 FD FF FF 50 8B 4D 08 51 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D AF FD FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 AF FD FF FF F7 D8 1B C0 F7 D8 89 85 84 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 84 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 0C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 0C FD FF FF E9 AC 0D 00 00 8D 95 B4 FD FF FF 52 8B 45 08 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 C3 0C 00 00 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D8 8B 45 D8 89 45 E8 8B 4D E8 89 4D E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 90 0C 00 00 0F BE 95 AF FD FF FF 89 95 E4 FC FF FF 8B 85 E4 FC FF FF 83 E8 20 89 85 E4 FC FF FF 83 BD E4 FC FF FF 10 77 4B 8B 8D E4 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 83 C8 04 89 45 F0 EB 2C 8B 4D F0 83 C9 01 89 4D F0 EB 21 8B 55 F0 83 CA 02 89 55 F0 EB 16 8B 45 F0 0D 80 00 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 08 89 4D F0 E9 1B 0C 00 00 0F BE 95 AF FD FF FF 83 FA 2A 75 28 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 4D F0 83 C9 04 89 4D F0 8B 55 E8 F7 DA 89 55 E8 EB 14 8B 45 E8 6B C0 0A 0F BE 8D AF FD FF FF 8D 54 08 D0 89 55 E8 E9 CE 0B 00 00 C7 45 D0 00 00 00 00 E9 C2 0B 00 00 0F BE 85 AF FD FF FF 83 F8 2A 75 1E 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 55 D0 6B D2 0A 0F BE 85 AF FD FF FF 8D 4C 02 D0 89 4D D0 E9 7F 0B 00 00 0F BE 95 AF FD FF FF 89 95 E0 FC FF FF 8B 85 E0 FC FF FF 83 E8 49 89 85 E0 FC FF FF 83 BD E0 FC FF FF 2E 0F 87 0D 01 00 00 8B 8D E0 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 0F BE 08 83 F9 6C 75 16 8B 55 0C 83 C2 01 89 55 0C 8B 45 F0 0D 00 10 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 10 89 4D F0 E9 CA 00 00 00 8B 55 0C 0F BE 02 83 F8 36 75 26 8B 4D 0C 0F BE 51 01 83 FA 34 75 1A 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 C9 00 80 00 00 89 4D F0 E9 81 00 00 00 8B 55 0C 0F BE 02 83 F8 33 75 23 8B 4D 0C 0F BE 51 01 83 FA 32 75 17 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 E1 FF 7F FF FF 89 4D F0 EB 53 8B 55 0C 0F BE 02 83 F8 64 74 37 8B 4D 0C 0F BE 11 83 FA 69 74 2C 8B 45 0C 0F BE 08 83 F9 6F 74 21 8B 55 0C 0F BE 02 83 F8 75 74 16 8B 4D 0C 0F BE 11 83 FA 78 74 0B 8B 45 0C 0F BE 08 83 F9 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A2 FC FF FF EB 16 8B 55 F0 83 CA 20 89 55 F0 EB 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 E9 44 0A 00 00 0F BE 8D AF FD FF FF 89 8D DC FC FF FF 8B 95 DC FC FF FF 83 EA 41 89 95 DC FC FF FF 83 BD DC FC FF FF 37 0F 87 15 08 00 00 8B 85 DC FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 81 E2 30 08 00 00 75 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 8B 4D F0 81 E1 10 08 00 00 74 55 C7 85 80 FD FF FF 00 00 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 0F B7 85 A8 FD FF FF 50 68 00 02 00 00 8D 8D B8 FD FF FF 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 80 FD FF FF 83 BD 80 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 7C FD FF FF 8A 8D 7C FD FF FF 88 8D B8 FD FF FF C7 45 DC 01 00 00 00 8D 95 B8 FD FF FF 89 55 FC E9 57 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 78 FD FF FF 83 BD 78 FD FF FF 00 74 0C 8B 8D 78 FD FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 78 FD FF FF 8B 42 04 89 45 FC 8B 8D 78 FD FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 78 FD FF FF 8B 42 04 89 45 FC 8B 8D 78 FD FF FF 0F BF 11 89 55 DC E9 C1 06 00 00 8B 45 F0 25 30 08 00 00 75 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 83 7D D0 FF 75 0C C7 85 D8 FC FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 D8 FC FF FF 8B 85 D8 FC FF FF 89 85 70 FD FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 81 E2 10 08 00 00 74 65 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC C7 45 F4 01 00 00 00 8B 4D FC 89 8D 6C FD FF FF 8B 95 70 FD FF FF 8B 85 70 FD FF FF 83 E8 01 89 85 70 FD FF FF 85 D2 74 1E 8B 8D 6C FD FF FF 0F B7 11 85 D2 74 11 8B 85 6C FD FF FF 83 C0 02 89 85 6C FD FF FF EB C9 8B 8D 6C FD FF FF 2B 4D FC D1 F9 89 4D DC EB 5B 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 89 85 74 FD FF FF 8B 8D 70 FD FF FF 8B 95 70 FD FF FF 83 EA 01 89 95 70 FD FF FF 85 C9 74 1E 8B 85 74 FD FF FF 0F BE 08 85 C9 74 11 8B 95 74 FD FF FF 83 C2 01 89 95 74 FD FF FF EB C9 8B 85 74 FD FF FF 2B 45 FC 89 45 DC E9 A5 05 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 D2 74 0C C7 85 D4 FC FF FF 01 00 00 00 EB 0A C7 85 D4 FC FF FF 00 00 00 00 8B 85 D4 FC FF FF 89 85 64 FD FF FF 83 BD 64 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 64 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 08 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 08 FD FF FF E9 B6 07 00 00 E9 E2 04 00 00 8B 55 F0 83 E2 20 74 12 8B 85 68 FD FF FF 66 8B 8D B4 FD FF FF 66 89 08 EB 0E 8B 95 68 FD FF FF 8B 85 B4 FD FF FF 89 02 C7 45 D8 01 00 00 00 E9 AE 04 00 00 C7 45 D4 01 00 00 00 0F BE 8D AF FD FF FF 83 C1 20 88 8D AF FD FF FF 8B 55 F0 83 CA 40 89 55 F0 8D 85 B8 FD FF FF 89 45 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 8D AF FD FF FF 83 F9 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 42 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 D0 81 C2 5D 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 45 E0 89 45 FC 8B 4D D0 81 C1 5D 01 00 00 89 4D BC EB 07 C7 45 D0 A3 00 00 00 8B 55 14 83 C2 08 89 55 14 8B 45 14 8B 48 F8 8B 50 FC 89 8D 58 FD FF FF 89 95 5C FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 D4 50 8B 4D D0 51 0F BE 95 AF FD FF FF 52 8B 45 BC 50 8B 4D FC 51 8D 95 58 FD FF FF 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 1C 8B 4D F0 81 E1 80 00 00 00 74 24 83 7D D0 00 75 1E 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 0F BE 8D AF FD FF FF 83 F9 67 75 2A 8B 55 F0 81 E2 80 00 00 00 75 1F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 8B 55 FC 0F BE 02 83 F8 2D 75 15 8B 4D F0 81 C9 00 01 00 00 89 4D F0 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 09 03 00 00 8B 4D F0 83 C9 40 89 4D F0 C7 45 F8 0A 00 00 00 EB 6F C7 45 F8 0A 00 00 00 EB 66 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 17 C6 45 EC 30 8B 85 A0 FD FF FF 83 C0 51 88 45 ED C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 48 FD FF FF 89 95 4C FD FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 48 FD FF FF 89 95 4C FD FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 1C 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 1A 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 48 FD FF FF 89 95 4C FD FF FF 8B 45 F0 83 E0 40 74 40 83 BD 4C FD FF FF 00 7F 37 7C 09 83 BD 48 FD FF FF 00 73 2C 8B 8D 48 FD FF FF F7 D9 8B 95 4C FD FF FF 83 D2 00 F7 DA 89 8D 40 FD FF FF 89 95 44 FD FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 48 FD FF FF 89 8D 40 FD FF FF 8B 95 4C FD FF FF 89 95 44 FD FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 40 FD FF FF 8B 85 44 FD FF FF 83 E0 00 89 95 40 FD FF FF 89 85 44 FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 40 FD FF FF 0B 95 44 FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 45 B7 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 40 FD FF FF 0B 85 44 FD FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 44 FD FF FF 51 8B 95 40 FD FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 54 FD FF FF 8B 45 F8 99 52 50 8B 85 44 FD FF FF 50 8B 8D 40 FD FF FF 51 E8 ?? ?? ?? ?? 89 85 40 FD FF FF 89 95 44 FD FF FF 83 BD 54 FD FF FF 39 7E 12 8B 95 54 FD FF FF 03 95 A0 FD FF FF 89 95 54 FD FF FF 8B 45 FC 8A 8D 54 FD FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 45 B7 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 81 E2 00 02 00 }
	condition:
		$1
}

rule file_49_4_0 {
	meta:
		name = "_write_char"
		size = 162
		refs = "0076 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 73 8B 45 0C 8B 48 04 83 E9 01 89 4D FC 8B 55 0C 8B 45 FC 89 42 04 83 7D FC 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D F8 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 14 8B 55 0C 52 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_5_0 {
	meta:
		name = "_write_multi_char"
		size = 56
		refs = "0023 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 21 8B 55 14 52 8B 45 10 50 0F B6 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CF 5D C3 }
	condition:
		$1
}

rule file_49_6_0 {
	meta:
		name = "_write_string"
		size = 184
		refs = "0009 __errno 0066 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 FC 8B 4D 10 8B 51 0C 83 E2 40 74 18 8B 45 10 83 78 08 00 75 0F 8B 4D 14 8B 11 03 55 0C 8B 45 14 89 10 EB 7F E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 0C 8B 55 0C 83 EA 01 89 55 0C 85 C9 7E 50 8B 45 08 8A 08 88 4D FB 8B 55 14 52 8B 45 10 50 0F B6 4D FB 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 83 C2 01 89 55 08 8B 45 14 83 38 FF 75 20 E8 ?? ?? ?? ?? 83 38 2A 75 14 8B 4D 14 51 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB A0 E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_7_0 {
	meta:
		name = "_get_int_arg"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_49_8_0 {
	meta:
		name = "_get_int64_arg"
		size = 31
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_49_9_0 {
	meta:
		name = "_get_short_arg"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__openfile"
		size = 1977
		refs = "0009 __commode 002c ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_1FO@POGAHKND@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003c __CrtDbgReportW 0050 ??_C@_1BK@HGLMNMEC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0074 ??_C@_1BI@MFCLPIBM@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0120 ??_C@_1DK@PKMJBLLN@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAo?$AAp?$AAe?$AAn?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0144 __errno 0158 ??_C@_1BE@DONHJJKE@?$AA_?$AAo?$AAp?$AAe?$AAn?$AAf?$AAi?$AAl?$AAe?$AA?$AA@ 0162 __invalid_parameter 01ba $LN89 01c1 $LN90 03ec ?ccsField@?P@??_openfile@@9@9 03f1 __mbsnbcmp 0536 ?utf8encoding@?P@??_openfile@@9@9 053f __mbsnbicmp 0566 ?utf16encoding@?P@??_openfile@@9@9 0596 ?unicodeencoding@?P@??_openfile@@9@9 0660 ??_C@_1CI@KEDPFCAL@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 06c9 __sopen_s 06da __cflush 0730 $LN54 0734 $LN53 0738 $LN25 073c $LN29 0740 $LN26 0744 $LN35 0748 $LN38 074c $LN32 0750 $LN50 0754 $LN44 0758 $LN41 075c $LN47 0760 $LN24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 89 45 EC C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 46 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 8A 11 88 55 C4 80 7D C4 61 74 38 80 7D C4 72 74 08 80 7D C4 77 74 17 EB 3C C7 45 F4 00 00 00 00 8B 45 EC 83 C8 01 89 45 EC E9 98 00 00 00 C7 45 F4 01 03 00 00 8B 4D EC 83 C9 02 89 4D EC E9 83 00 00 00 C7 45 F4 09 01 00 00 8B 55 EC 83 CA 02 89 55 EC EB 71 33 C0 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B9 05 00 00 C7 45 E0 01 00 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 85 D2 0F 84 37 02 00 00 83 7D E0 00 0F 84 2D 02 00 00 8B 45 0C 0F BE 08 89 4D BC 8B 55 BC 83 EA 20 89 55 BC 83 7D BC 54 0F 87 95 01 00 00 8B 45 BC 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 F6 01 00 00 8B 55 F4 83 E2 02 74 09 C7 45 E0 00 00 00 00 EB 27 8B 45 F4 83 C8 02 89 45 F4 8B 4D F4 83 E1 FE 89 4D F4 8B 55 EC 81 CA 80 00 00 00 89 55 EC 8B 45 EC 83 E0 FC 89 45 EC E9 B9 01 00 00 8B 4D F4 81 E1 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 55 F4 81 CA 00 80 00 00 89 55 F4 E9 94 01 00 00 8B 45 F4 25 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 40 00 00 89 4D F4 E9 70 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 13 C7 45 E4 01 00 00 00 8B 55 EC 81 CA 00 40 00 00 89 55 EC E9 49 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 12 C7 45 E4 01 00 00 00 8B 45 EC 25 FF BF FF FF 89 45 EC E9 23 01 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 4D F4 83 C9 20 89 4D F4 E9 FF 00 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 55 F4 83 CA 10 89 55 F4 E9 DB 00 00 00 8B 45 F4 25 00 10 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 10 00 00 89 4D F4 E9 B7 00 00 00 8B 55 F4 83 E2 40 74 09 C7 45 E0 00 00 00 00 EB 09 8B 45 F4 83 C8 40 89 45 F4 E9 98 00 00 00 8B 4D F4 81 C9 80 00 00 00 89 4D F4 E9 87 00 00 00 C7 45 F0 01 00 00 00 C7 45 E0 00 00 00 00 EB 77 33 D2 74 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 69 03 00 00 E9 B2 FD FF FF 83 7D F0 00 0F 84 68 02 00 00 8B 55 0C 0F BE 02 83 F8 20 75 0B 8B 4D 0C 83 C1 01 89 4D 0C EB EA 6A 03 8B 55 0C 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 77 33 C0 74 09 C7 45 B4 01 00 00 00 EB 07 C7 45 B4 00 00 00 00 8B 4D B4 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B6 02 00 00 8B 45 0C 83 C0 03 89 45 0C 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 83 FA 3D 74 77 33 C0 74 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 4D B0 89 4D D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 15 02 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 6A 05 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 8B 55 0C 83 C2 05 89 55 0C 8B 45 F4 0D 00 00 04 00 89 45 F4 E9 D4 00 00 00 6A 08 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 8B 55 0C 83 C2 08 89 55 0C 8B 45 F4 0D 00 00 02 00 89 45 F4 E9 A4 00 00 00 6A 07 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 16 8B 55 0C 83 C2 07 89 55 0C 8B 45 F4 0D 00 00 01 00 89 45 F4 EB 77 33 C9 74 09 C7 45 AC 01 00 00 00 EB 07 C7 45 AC 00 00 00 00 8B 55 AC 89 55 CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F2 00 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 F7 DA 1B D2 83 C2 01 89 55 C8 75 21 68 ?? ?? ?? ?? 6A 00 68 0B 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 76 68 80 01 00 00 8B 4D 10 51 8B 55 F4 52 8B 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 04 33 C0 EB 51 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 14 89 45 F8 8B 4D F8 8B 55 EC 89 51 0C 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 8B 55 F8 C7 42 08 00 00 00 00 8B 45 F8 C7 40 1C 00 00 00 00 8B 4D F8 8B 55 FC 89 51 10 8B 45 F8 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 01 02 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 03 0C 0C 0C 0C 0C 0C 0C 0C 0C 04 0C 0C 0C 05 06 07 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 08 09 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0A 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_fputc"
		size = 593
		refs = "0008 __sehtable$_fputc 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FO@CJOPDBGD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_1M@OIJMPNCO@?$AAf?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008e __invalid_parameter 00a2 __lock_file 00ca __fileno 00f2 ___pioinfo 00fe ___badioinfo 0171 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0211 __flsbuf 0234 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A2 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 4D D8 C1 F9 05 8B 55 D8 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 45 D0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 45 D8 C1 F8 05 8B 4D D8 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 55 CC 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 55 C8 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 5A 8B 4D 0C 8B 51 04 83 EA 01 89 55 C4 8B 45 0C 8B 4D C4 89 48 04 83 7D C4 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C0 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 55 C0 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "_putc"
		size = 593
		refs = "0008 __sehtable$_putc 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FO@CJOPDBGD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_19LHKMJKNP@?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008e __invalid_parameter 00a2 __lock_file 00ca __fileno 00f2 ___pioinfo 00fe ___badioinfo 0171 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0211 __flsbuf 0234 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 47 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 47 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A2 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 4D D8 C1 F9 05 8B 55 D8 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 45 D0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 45 D8 C1 F8 05 8B 4D D8 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 55 CC 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 55 C8 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 5A 8B 4D 0C 8B 51 04 83 EA 01 89 55 C4 8B 45 0C 8B 4D C4 89 48 04 83 7D C4 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C0 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 55 C0 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "___libm_sse2_pow"
		size = 2680
		refs = "0007 _SIGMASK 0015 _ONEMASK 004c _rcp_t1 0060 _log2_t1 009b _HALFSIG 00c7 _rcp_t2 00db _log2_t2 010d _LHN 0123 _rcp_t3 0135 _log2_t3 021e _clv 028d _exp2_tbl 0295 _cev 0344 _ABSVALMASK 0402 _NEG_ZERO 061e _NEG_INF 06a1 _sNaN 07a1 _INF 09c1 _EMIN"
	strings:
		$1 = { 83 EC 14 66 0F 12 3D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 12 15 ?? ?? ?? ?? 66 0F 13 4C 24 0C 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 BE 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 F9 04 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 28 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E AF 05 00 00 F2 0F 58 E0 F2 0F 2A C0 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 66 0F 59 D7 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 BF 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 83 C4 14 F2 0F 58 C5 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 6B 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A2 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 99 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 43 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9D 02 00 00 0F 87 F1 01 00 00 83 FA 00 0F 87 E8 01 00 00 E9 89 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 79 FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 2B C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 83 C4 14 F2 0F 5E CA C3 C1 E1 0D 23 C1 83 F8 00 0F 85 A9 00 00 00 83 C4 14 66 0F 57 C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 D1 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 9C 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 6F 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 2D 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 8B 01 00 00 83 C4 14 66 0F 57 C0 C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 6A 01 00 00 83 C4 14 66 0F 57 C0 C3 83 C4 14 F2 0F 58 E4 66 0F 28 C4 C3 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 73 FE FF FF 83 C4 14 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 C3 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 7E E0 83 F8 00 75 4C 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 2E 01 00 00 81 FA 00 00 F0 BF 75 2F 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 3D FF 00 00 00 0F 85 D4 00 00 00 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A0 00 00 00 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 AE 00 00 00 83 F8 00 74 55 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 3C 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 0B D0 83 FA 00 75 43 83 C4 14 66 0F 57 C9 66 0F 57 E4 B8 F0 3F 00 00 66 0F C4 C8 03 F2 0F 5E CC 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 57 C0 C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 08 83 C4 14 66 0F 57 C0 C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 F2 0F 58 D2 66 0F 28 C2 C3 83 C4 14 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 F8 00 7E 25 3D 00 00 04 00 0F 83 B9 01 00 00 56 8B D0 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 23 3D 00 02 FC FF 0F 8E 77 01 00 00 56 8B D0 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 2A C0 83 E0 7F 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 BF 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 19 5E 83 C4 14 F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 C3 5E 83 C4 14 F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 C3 66 0F 57 C9 B8 EF FF 00 00 66 0F C4 C8 03 F2 0F 10 C1 83 F9 00 74 0A 66 0F 73 F0 01 66 0F 73 D0 01 83 C4 14 F2 0F 59 C1 C3 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 AB F7 FF FF 3D 00 00 00 80 72 13 83 C4 14 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 47 FF FF FF E9 5F FF FF FF }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__spawnv"
		size = 530
		refs = "001b ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@DELPGPFF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@DKJGKDD@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0148 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01aa ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0207 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A2 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3F 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DB 00 00 00 8B 4D 10 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 78 8B 4D 10 8B 11 0F BE 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__powhlp"
		size = 422
		refs = "0051 __d_inf 00bc __d_ind 0130 __d_inttype 0180 __d_mzero"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C C7 45 FC 00 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 DD 5D F0 81 7D 14 00 00 F0 7F 75 40 83 7D 10 00 75 3A D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 E8 DC 5D F0 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 25 01 00 00 81 7D 14 00 00 F0 FF 75 4B 83 7D 10 00 75 45 D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 09 8B 45 18 D9 EE DD 18 EB 2B D9 E8 DC 5D F0 DF E0 F6 C4 41 75 0D 8B 4D 18 DD 05 ?? ?? ?? ?? DD 19 EB 12 8B 55 18 DD 05 ?? ?? ?? ?? DD 1A C7 45 FC 01 00 00 00 E9 D1 00 00 00 81 7D 0C 00 00 F0 7F 75 40 83 7D 08 00 75 3A D9 EE DC 5D 10 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 EE DC 5D 10 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 88 00 00 00 81 7D 0C 00 00 F0 FF 75 7F 83 7D 08 00 75 79 83 EC 08 DD 45 10 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC D9 EE DC 5D 10 DF E0 F6 C4 05 7A 26 83 7D EC 01 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D DC EB 09 DD 05 ?? ?? ?? ?? DD 5D DC 8B 45 18 DD 45 DC DD 18 EB 33 D9 EE DC 5D 10 DF E0 F6 C4 41 75 20 83 7D EC 01 75 0B DD 05 ?? ?? ?? ?? DD 5D D4 EB 05 D9 EE DD 5D D4 8B 4D 18 DD 45 D4 DD 19 EB 07 8B 55 18 D9 E8 DD 1A 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__d_inttype"
		size = 134
		refs = "0012 __fpclass 002e __frnd 004c __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 25 90 00 00 00 74 04 33 C0 EB 5E 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 DD 45 F8 DD 45 08 DA E9 DF E0 F6 C4 44 7A 39 DD 45 08 DC 35 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 35 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 09 B8 02 00 00 00 EB 0B EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "___libm_sse2_sin"
		size = 440
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 015d _ALL_ONES 0166 _TWO_POW_55 0176 _TWO_POW_M55 019e _sin 01b3 _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 00 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 2C 66 C1 E8 04 66 3D FD 0C 75 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C D8 F2 0F 59 1D ?? ?? ?? ?? C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 23 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 8B 64 24 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 178
		refs = "0008 __sehtable$??_N@YGXPAXIHP6EX0@Z1@Z 000d __except_handler4 001f ___security_cookie 0099 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 10 7D 13 6A 01 8B 4D 08 FF 55 14 8B 55 08 03 55 0C 89 55 08 EB DC C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1C 83 7D E0 00 75 15 8B 45 18 50 8B 4D E4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__wfsopen"
		size = 523
		refs = "0008 __sehtable$__wfsopen 000d __except_handler4 001f ___security_cookie 0053 ??_C@_1BO@CLGIAEOJ@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005c ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0063 __CrtDbgReportW 0077 __errno 008b ??_C@_1BC@PAJNLEOB@?$AA_?$AAw?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 0095 __invalid_parameter 00b6 ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0118 ??_C@_1CI@HBNALCBB@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0169 __getstream 01b4 __local_unwind4 01d1 __wopenfile 01ee __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 E0 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 56 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F3 00 00 00 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 D4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 91 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 74 C7 45 FC 00 00 00 00 8B 4D 08 0F B7 11 85 D2 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D0 00 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 D0 EB 39 8B 4D E4 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__wfopen"
		size = 25
		refs = "0010 __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_804_1_0 {
	meta:
		name = "_fopen"
		size = 25
		refs = "0010 __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__wfopen_s"
		size = 160
		refs = "0019 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BE@JDODBHOJ@?$AA_?$AAw?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 007d __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_804_2_0 {
	meta:
		name = "_fopen_s"
		size = 160
		refs = "0019 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BA@PBGKCCAP@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 007d __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "__CIasin_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 0048 ___fastflag 004f __fast_exit 005a _NAME_ 005f __math_exit 0080 __piby2 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2B D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 3A 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 29 81 E1 00 00 00 80 DD D8 DB 2D ?? ?? ?? ?? 74 C0 D9 E0 EB BC E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "_ungetc"
		size = 233
		refs = "0008 __sehtable$_ungetc 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GA@OAFAANFO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1O@JDPLECOK@?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA?$AA@ 0087 __invalid_parameter 0098 __lock_file 00af __ungetc_nolock 00cc __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 44 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "__ungetc_nolock"
		size = 542
		refs = "0022 __fileno 004a ___pioinfo 0056 ___badioinfo 00c9 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 00d2 ??_C@_1HC@OEJDDIIH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d9 __CrtDbgReportW 00ed __errno 0101 ??_C@_1BO@OLMLKKEA@?$AA_?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 010b __invalid_parameter 0160 __getbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 0C 89 45 F8 8B 4D F8 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FF 74 21 83 7D F4 FE 74 1B 8B 4D F4 C1 F9 05 8B 55 F4 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D F4 FF 74 21 83 7D F4 FE 74 1B 8B 45 F4 C1 F8 05 8B 4D F4 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D E8 EB 07 C7 45 E8 ?? ?? ?? ?? 8B 55 E8 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 55 E4 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 00 01 00 00 8B 4D 0C 89 4D FC 83 7D 08 FF 74 24 8B 55 FC 8B 42 0C 83 E0 01 75 21 8B 4D FC 8B 51 0C 81 E2 80 00 00 00 74 0B 8B 45 FC 8B 48 0C 83 E1 02 74 08 83 C8 FF E9 C8 00 00 00 8B 55 FC 83 7A 08 00 75 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 55 FC 8B 01 3B 42 08 75 1E 8B 4D FC 83 79 04 00 74 08 83 C8 FF E9 95 00 00 00 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 8B 55 FC 8B 42 0C 83 E0 40 74 31 8B 4D FC 8B 11 83 EA 01 8B 45 FC 89 10 8B 4D FC 8B 11 0F BE 02 0F BE 4D 08 3B C1 74 12 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 83 C8 FF EB 4E EB 17 8B 55 FC 8B 02 83 E8 01 8B 4D FC 89 01 8B 55 FC 8B 02 8A 4D 08 88 08 8B 55 FC 8B 42 04 83 C0 01 8B 4D FC 89 41 04 8B 55 FC 8B 42 0C 83 E0 EF 8B 4D FC 89 41 0C 8B 55 FC 8B 42 0C 83 C8 01 8B 4D FC 89 41 0C 8B 45 08 25 FF 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__vswprintf_l"
		size = 496
		refs = "003f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_1GE@KINELFI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0052 __CrtDbgReportW 0066 __errno 007d ??_C@_1BK@EPLNBKAK@?$AA_?$AAv?$AAs?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 0087 __invalid_parameter 00a9 ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0136 __woutput_l 0192 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 C7 45 D8 00 00 00 00 33 C0 89 45 DC 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 89 45 F4 8D 4D D8 89 4D F8 33 D2 83 7D 0C 00 0F 95 C2 89 55 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 56 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EC 00 00 00 8B 45 F8 C7 40 0C 42 00 00 00 8B 4D F8 8B 55 08 89 51 08 8B 45 F8 8B 4D 08 89 08 8B 55 F8 C7 42 04 FF FF FF 7F 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D 08 00 75 08 8B 45 FC E9 9E 00 00 00 8B 4D F8 8B 51 04 83 EA 01 89 55 CC 8B 45 F8 8B 4D CC 89 48 04 83 7D CC 00 7C 22 8B 55 F8 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D C8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 EB 11 8B 55 F8 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 8B 45 F8 8B 48 04 83 E9 01 89 4D C4 8B 55 F8 8B 45 C4 89 42 04 83 7D C4 00 7C 21 8B 4D F8 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 C0 8B 4D F8 8B 11 83 C2 01 8B 45 F8 89 10 EB 11 8B 4D F8 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "__vswprintf"
		size = 29
		refs = "0014 __vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_1_0 {
	meta:
		name = "_vsprintf"
		size = 29
		refs = "0014 __vsprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "___vswprintf_l"
		size = 31
		refs = "0016 __vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_22_16_3 {
	meta:
		name = "??2facet@locale@std@@SAPAXIABU_DebugHeapTag_t@2@PADH@Z"
		size = 31
		refs = "0016 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_13_6_2 {
	meta:
		name = "??_U@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
		size = 31
		refs = "0016 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_6_8_3 {
	meta:
		name = "??_V@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
		size = 31
		refs = "0016 ??3@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "__Stoldx"
		size = 31
		refs = "0016 __Stodx"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_170_4_0 {
	meta:
		name = "__mbstowcs_l"
		size = 31
		refs = "0016 __mbstowcs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_204_5_0 {
	meta:
		name = "__wcstombs_l"
		size = 31
		refs = "0016 __wcstombs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_453_10_0 {
	meta:
		name = "_mbsrtowcs"
		size = 31
		refs = "0016 __mbsrtowcs_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_946_9_0 {
	meta:
		name = "_wcsrtombs"
		size = 31
		refs = "0016 __wcsrtombs_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__vscwprintf_helper"
		size = 218
		refs = "003f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_1GE@KINELFI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0052 __CrtDbgReportW 0066 __errno 007d ??_C@_1CG@IMMIEPNA@?$AA_?$AAv?$AAs?$AAc?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0087 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C C7 45 D8 00 00 00 00 33 C0 89 45 DC 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 89 45 F4 8D 4D D8 89 4D F8 33 D2 83 7D 0C 00 0F 95 C2 89 55 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 43 8B 4D F8 C7 41 04 FF FF FF 7F 8B 55 F8 C7 42 0C 42 00 00 00 8B 45 F8 C7 40 08 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 F8 52 FF 55 08 83 C4 10 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__vscwprintf"
		size = 30
		refs = "0010 __woutput_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_6_0 {
	meta:
		name = "__vprintf_p"
		size = 30
		refs = "0010 __output_p_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_3_0 {
	meta:
		name = "__vscprintf"
		size = 30
		refs = "0010 __output_l 0015 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_5_0 {
	meta:
		name = "__vscprintf_p"
		size = 30
		refs = "0010 __output_p_l 0015 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__vscwprintf_p"
		size = 30
		refs = "0010 __woutput_p_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_6_0 {
	meta:
		name = "__vwprintf_p"
		size = 30
		refs = "0010 __woutput_p_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_4_0 {
	meta:
		name = "_vprintf"
		size = 30
		refs = "0010 __output_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_5_0 {
	meta:
		name = "_vprintf_s"
		size = 30
		refs = "0010 __output_s_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_4_0 {
	meta:
		name = "_vwprintf"
		size = 30
		refs = "0010 __woutput_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_5_0 {
	meta:
		name = "_vwprintf_s"
		size = 30
		refs = "0010 __woutput_s_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__vscwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_1_0 {
	meta:
		name = "__vprintf_l"
		size = 32
		refs = "0012 __output_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_3_0 {
	meta:
		name = "__vprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_962_2_0 {
	meta:
		name = "__vprintf_s_l"
		size = 32
		refs = "0012 __output_s_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_4_0 {
	meta:
		name = "__vscprintf_l"
		size = 32
		refs = "0012 __output_l 0017 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_6_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "__vwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_3_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_152_2_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 32
		refs = "0012 __woutput_s_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "___libm_sse2_logf"
		size = 377
		refs = "0004 _dword_mask 0010 _SIGMASK 001c _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_tbl 00cc _LN2 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 F8 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "_bsearch"
		size = 550
		refs = "0047 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0050 ??_C@_1GC@ICJFPHNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0057 __CrtDbgReportW 006b __errno 007f ??_C@_1BA@CLPIMKHD@?$AAb?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA?$AA@ 0089 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0109 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 0C 89 45 F8 8B 4D 10 83 E9 01 0F AF 4D 14 03 4D 0C 89 4D F0 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 55 DC 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 8B 01 00 00 33 C9 3B 4D 14 1B D2 F7 DA 89 55 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2C 01 00 00 33 C9 83 7D 18 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 C9 00 00 00 8B 45 F8 3B 45 F0 0F 87 BB 00 00 00 8B 4D 10 D1 E9 89 4D F4 0F 84 85 00 00 00 8B 55 10 83 E2 01 74 08 8B 45 F4 89 45 D8 EB 09 8B 4D F4 83 E9 01 89 4D D8 8B 55 D8 0F AF 55 14 03 55 F8 89 55 FC 8B 45 FC 50 8B 4D 08 51 FF 55 18 83 C4 08 89 45 EC 83 7D EC 00 75 07 8B 45 FC EB 6D EB 3F 83 7D EC 00 7D 2A 8B 55 FC 2B 55 14 89 55 F0 8B 45 10 83 E0 01 74 08 8B 4D F4 89 4D D4 EB 09 8B 55 F4 83 EA 01 89 55 D4 8B 45 D4 89 45 10 EB 0F 8B 4D FC 03 4D 14 89 4D F8 8B 55 F4 89 55 10 EB 23 83 7D 10 00 74 1B 8B 45 F8 50 8B 4D 08 51 FF 55 18 83 C4 08 F7 D8 1B C0 F7 D0 23 45 F8 EB 0B EB 02 EB 05 E9 39 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "_mainCRTStartup"
		size = 17
		refs = "0006 ___security_init_cookie 000b ___tmainCRTStartup"
		altNames = "_WinMainCRTStartup _wWinMainCRTStartup _wmainCRTStartup"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 416
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 003e __NoHeapEnableTerminationOnCorruption 004f __imp__HeapSetInformation@16 0054 _check_managed_app 005c __heap_init 0067 _fast_error_exit 006f __mtinit 0084 __CrtSetCheckCount 008c __RTC_Initialize 0098 __ioinit 00a3 __amsg_exit 00ac __imp__GetCommandLineA@0 00b1 __acmdln 00b6 ___crtGetEnvironmentStringsA 00bb __aenvptr 00c0 __setargv 00d3 __setenvp 00e8 __cinit 0106 __environ 010c ___initenv 0118 ___argv 011f ___argc 0125 _main 013a _exit 013f __cexit 015f __XcptFilter 017b __exit 0180 __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 DC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 0E 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 74 0C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 DC 83 7D E0 00 75 09 8B 55 DC 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 45 EC 8B 08 8B 11 89 55 D8 8B 45 EC 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 55 D8 89 55 DC 83 7D E0 00 75 09 8B 45 DC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_665_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 416
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 003e __NoHeapEnableTerminationOnCorruption 004f __imp__HeapSetInformation@16 0054 _check_managed_app 005c __heap_init 0067 _fast_error_exit 006f __mtinit 0084 __CrtSetCheckCount 008c __RTC_Initialize 0098 __ioinit 00a3 __amsg_exit 00ac __imp__GetCommandLineW@0 00b1 __wcmdln 00b6 ___crtGetEnvironmentStringsW 00bb __wenvptr 00c0 __wsetargv 00d3 __wsetenvp 00e8 __cinit 0106 __wenviron 010c ___winitenv 0118 ___wargv 011f ___argc 0125 _wmain 013a _exit 013f __cexit 015f __XcptFilter 017b __exit 0180 __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 DC 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 0E 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 74 0C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 DC 83 7D E0 00 75 09 8B 55 DC 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 45 EC 8B 08 8B 11 89 55 D8 8B 45 EC 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 55 D8 89 55 DC 83 7D E0 00 75 09 8B 45 DC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 46
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0018 __NMSG_WRITE 0025 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "_check_managed_app"
		size = 110
		refs = "000b ___ImageBase"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC ?? ?? ?? ?? 8B 45 FC 0F B7 08 81 F9 4D 5A 00 00 74 04 33 C0 EB 49 8B 55 FC 8B 45 FC 03 42 3C 89 45 F8 8B 4D F8 81 39 50 45 00 00 74 04 33 C0 EB 2E 8B 55 F8 0F B7 42 18 3D 0B 01 00 00 74 04 33 C0 EB 1C 8B 4D F8 83 79 74 0E 77 04 33 C0 EB 0F 8B 55 F8 33 C0 83 BA E8 00 00 00 00 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__output_l"
		size = 4788
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BE@IONLIDNC@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0107 __fileno 013e ___pioinfo 0150 ___badioinfo 01ea ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0272 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 035c ___lookuptable 03c0 $LN165 03cf ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 03dd __isleadbyte_l 0400 _write_char 0431 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0521 $LN161 0528 $LN166 0579 _get_int_arg 0636 $LN162 063d $LN167 0771 $LN163 0778 $LN168 07ac _get_short_arg 07d3 _wctomb_s 084f ___nullstring 085b _strlen 091a ___wnullstring 09eb __get_printf_count_output 0a27 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0b48 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0b59 __malloc_dbg 0bcb __cfltcvt_tab 0bd2 __imp__DecodePointer@4 0d04 _get_int64_arg 0ed1 __aullrem 0ef3 __aulldiv 0ffa _write_multi_char 1015 _write_string 1175 __free_dbg 11a8 @__security_check_cookie@4 11b0 $NORMAL_STATE$29561 11b4 $LN130 11b8 $LN129 11bc $LN121 11c0 $LN117 11c4 $LN116 11c8 $LN112 11cc $LN96 11d0 $LN124 11d4 $LN123 11d8 $LN125 11dc $LN126 11e0 $LN122 11e4 $LN127 11fc $LN106 1200 $LN98 1204 $LN109 1208 $LN97 120c $LN110 1240 $LN65 1244 $LN93 1248 $LN81 124c $LN47 1250 $LN87 1254 $LN64 1258 $LN91 125c $LN52 1260 $LN70 1264 $LN42 1268 $LN48 126c $LN79 1270 $LN50 1274 $LN45 1278 $LN94"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 18 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 28 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 28 FD FF FF E9 BE 10 00 00 8B 45 08 89 85 98 FD FF FF 8B 8D 98 FD FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FD FF FF 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 8D 94 FD FF FF C1 F9 05 8B 95 94 FD FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 10 FD FF FF EB 0A C7 85 10 FD FF FF ?? ?? ?? ?? 8B 85 10 FD FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 85 94 FD FF FF C1 F8 05 8B 8D 94 FD FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D 0C FD FF FF EB 0A C7 85 0C FD FF FF ?? ?? ?? ?? 8B 95 0C FD FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 08 FD FF FF 00 00 00 00 EB 0A C7 85 08 FD FF FF 01 00 00 00 8B 95 08 FD FF FF 89 95 90 FD FF FF 83 BD 90 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 24 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 24 FD FF FF E9 49 0F 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 8C FD FF FF 83 BD 8C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 20 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 20 FD FF FF E9 C1 0E 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 0C 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 5B 0E 00 00 83 BD B4 FD FF FF 00 0F 8C 4E 0E 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 04 FD FF FF EB 0A C7 85 04 FD FF FF 00 00 00 00 8B 95 04 FD FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 8B 8D A4 FD FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 8B 85 A4 FD FF FF 89 85 00 FD FF FF 83 BD 00 FD FF FF 07 0F 87 CC 0D 00 00 8B 8D 00 FD FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B4 00 00 00 8D 85 B4 FD FF FF 50 8B 4D 08 51 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D AF FD FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 AF FD FF FF F7 D8 1B C0 F7 D8 89 85 88 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 1C FD FF FF E9 02 0D 00 00 8D 95 B4 FD FF FF 52 8B 45 08 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 C3 0C 00 00 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D8 8B 45 D8 89 45 E8 8B 4D E8 89 4D E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 90 0C 00 00 0F BE 95 AF FD FF FF 89 95 FC FC FF FF 8B 85 FC FC FF FF 83 E8 20 89 85 FC FC FF FF 83 BD FC FC FF FF 10 77 4B 8B 8D FC FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 83 C8 04 89 45 F0 EB 2C 8B 4D F0 83 C9 01 89 4D F0 EB 21 8B 55 F0 83 CA 02 89 55 F0 EB 16 8B 45 F0 0D 80 00 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 08 89 4D F0 E9 1B 0C 00 00 0F BE 95 AF FD FF FF 83 FA 2A 75 28 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 4D F0 83 C9 04 89 4D F0 8B 55 E8 F7 DA 89 55 E8 EB 14 8B 45 E8 6B C0 0A 0F BE 8D AF FD FF FF 8D 54 08 D0 89 55 E8 E9 CE 0B 00 00 C7 45 D0 00 00 00 00 E9 C2 0B 00 00 0F BE 85 AF FD FF FF 83 F8 2A 75 1E 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 55 D0 6B D2 0A 0F BE 85 AF FD FF FF 8D 4C 02 D0 89 4D D0 E9 7F 0B 00 00 0F BE 95 AF FD FF FF 89 95 F8 FC FF FF 8B 85 F8 FC FF FF 83 E8 49 89 85 F8 FC FF FF 83 BD F8 FC FF FF 2E 0F 87 0D 01 00 00 8B 8D F8 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 0F BE 08 83 F9 6C 75 16 8B 55 0C 83 C2 01 89 55 0C 8B 45 F0 0D 00 10 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 10 89 4D F0 E9 CA 00 00 00 8B 55 0C 0F BE 02 83 F8 36 75 26 8B 4D 0C 0F BE 51 01 83 FA 34 75 1A 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 C9 00 80 00 00 89 4D F0 E9 81 00 00 00 8B 55 0C 0F BE 02 83 F8 33 75 23 8B 4D 0C 0F BE 51 01 83 FA 32 75 17 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 E1 FF 7F FF FF 89 4D F0 EB 53 8B 55 0C 0F BE 02 83 F8 64 74 37 8B 4D 0C 0F BE 11 83 FA 69 74 2C 8B 45 0C 0F BE 08 83 F9 6F 74 21 8B 55 0C 0F BE 02 83 F8 75 74 16 8B 4D 0C 0F BE 11 83 FA 78 74 0B 8B 45 0C 0F BE 08 83 F9 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A2 FC FF FF EB 16 8B 55 F0 83 CA 20 89 55 F0 EB 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 E9 44 0A 00 00 0F BE 8D AF FD FF FF 89 8D F4 FC FF FF 8B 95 F4 FC FF FF 83 EA 41 89 95 F4 FC FF FF 83 BD F4 FC FF FF 37 0F 87 15 08 00 00 8B 85 F4 FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 81 E2 30 08 00 00 75 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 8B 4D F0 81 E1 10 08 00 00 74 55 C7 85 84 FD FF FF 00 00 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 0F B7 85 A8 FD FF FF 50 68 00 02 00 00 8D 8D B8 FD FF FF 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 84 FD FF FF 83 BD 84 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 80 FD FF FF 8A 8D 80 FD FF FF 88 8D B8 FD FF FF C7 45 DC 01 00 00 00 8D 95 B8 FD FF FF 89 55 FC E9 57 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 7C FD FF FF 83 BD 7C FD FF FF 00 74 0C 8B 8D 7C FD FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 7C FD FF FF 8B 42 04 89 45 FC 8B 8D 7C FD FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 7C FD FF FF 8B 42 04 89 45 FC 8B 8D 7C FD FF FF 0F BF 11 89 55 DC E9 C1 06 00 00 8B 45 F0 25 30 08 00 00 75 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 83 7D D0 FF 75 0C C7 85 F0 FC FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 F0 FC FF FF 8B 85 F0 FC FF FF 89 85 74 FD FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 81 E2 10 08 00 00 74 65 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC C7 45 F4 01 00 00 00 8B 4D FC 89 8D 70 FD FF FF 8B 95 74 FD FF FF 8B 85 74 FD FF FF 83 E8 01 89 85 74 FD FF FF 85 D2 74 1E 8B 8D 70 FD FF FF 0F B7 11 85 D2 74 11 8B 85 70 FD FF FF 83 C0 02 89 85 70 FD FF FF EB C9 8B 8D 70 FD FF FF 2B 4D FC D1 F9 89 4D DC EB 5B 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 89 85 78 FD FF FF 8B 8D 74 FD FF FF 8B 95 74 FD FF FF 83 EA 01 89 95 74 FD FF FF 85 C9 74 1E 8B 85 78 FD FF FF 0F BE 08 85 C9 74 11 8B 95 78 FD FF FF 83 C2 01 89 95 78 FD FF FF EB C9 8B 85 78 FD FF FF 2B 45 FC 89 45 DC E9 A5 05 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 D2 74 0C C7 85 EC FC FF FF 01 00 00 00 EB 0A C7 85 EC FC FF FF 00 00 00 00 8B 85 EC FC FF FF 89 85 68 FD FF FF 83 BD 68 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 68 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 18 FD FF FF E9 0C 07 00 00 E9 E2 04 00 00 8B 55 F0 83 E2 20 74 12 8B 85 6C FD FF FF 66 8B 8D B4 FD FF FF 66 89 08 EB 0E 8B 95 6C FD FF FF 8B 85 B4 FD FF FF 89 02 C7 45 D8 01 00 00 00 E9 AE 04 00 00 C7 45 D4 01 00 00 00 0F BE 8D AF FD FF FF 83 C1 20 88 8D AF FD FF FF 8B 55 F0 83 CA 40 89 55 F0 8D 85 B8 FD FF FF 89 45 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 8D AF FD FF FF 83 F9 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 42 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 D0 81 C2 5D 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 45 E0 89 45 FC 8B 4D D0 81 C1 5D 01 00 00 89 4D BC EB 07 C7 45 D0 A3 00 00 00 8B 55 14 83 C2 08 89 55 14 8B 45 14 8B 48 F8 8B 50 FC 89 8D 60 FD FF FF 89 95 64 FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 D4 50 8B 4D D0 51 0F BE 95 AF FD FF FF 52 8B 45 BC 50 8B 4D FC 51 8D 95 60 FD FF FF 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 1C 8B 4D F0 81 E1 80 00 00 00 74 24 83 7D D0 00 75 1E 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 0F BE 8D AF FD FF FF 83 F9 67 75 2A 8B 55 F0 81 E2 80 00 00 00 75 1F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 8B 55 FC 0F BE 02 83 F8 2D 75 15 8B 4D F0 81 C9 00 01 00 00 89 4D F0 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 09 03 00 00 8B 4D F0 83 C9 40 89 4D F0 C7 45 F8 0A 00 00 00 EB 6F C7 45 F8 0A 00 00 00 EB 66 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 17 C6 45 EC 30 8B 85 A0 FD FF FF 83 C0 51 88 45 ED C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1C 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1A 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 50 FD FF FF 89 95 54 FD FF FF 8B 45 F0 83 E0 40 74 40 83 BD 54 FD FF FF 00 7F 37 7C 09 83 BD 50 FD FF FF 00 73 2C 8B 8D 50 FD FF FF F7 D9 8B 95 54 FD FF FF 83 D2 00 F7 DA 89 8D 48 FD FF FF 89 95 4C FD FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 50 FD FF FF 89 8D 48 FD FF FF 8B 95 54 FD FF FF 89 95 4C FD FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 48 FD FF FF 8B 85 4C FD FF FF 83 E0 00 89 95 48 FD FF FF 89 85 4C FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 48 FD FF FF 0B 95 4C FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 45 B7 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 48 FD FF FF 0B 85 4C FD FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 4C FD FF FF 51 8B 95 48 FD FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 5C FD FF FF 8B 45 F8 99 52 50 8B 85 4C FD FF FF 50 8B 8D 48 FD FF FF 51 E8 ?? ?? ?? ?? 89 85 48 FD FF FF 89 95 4C FD FF FF 83 BD 5C FD FF FF 39 7E 12 8B 95 5C FD FF FF 03 95 A0 FD FF FF 89 95 5C FD FF FF 8B 45 FC 8A 8D 5C FD FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 45 B7 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 81 E2 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 45 FC 0F BE 08 83 F9 30 74 18 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 30 8B 4D DC 83 C1 01 89 4D DC 83 7D D8 00 0F 85 E1 01 00 00 8B 55 F0 83 E2 40 74 3F 8B 45 F0 25 00 01 00 00 74 0D C6 45 EC 2D C7 45 E4 01 00 00 00 EB 28 8B 4D F0 83 E1 01 74 0D C6 45 EC 2B C7 45 E4 01 00 00 00 EB 13 8B 55 F0 83 E2 02 74 0B C6 45 EC 20 C7 45 E4 01 00 00 00 8B 45 E8 2B 45 DC 2B 45 E4 89 85 44 FD FF FF 8B 4D F0 83 E1 0C 75 1C 8D 95 B4 FD FF FF 52 8B 45 08 50 8B 8D 44 FD FF FF 51 6A 20 E8 ?? ?? ?? ?? 83 C4 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__filelengthi64"
		size = 654
		refs = "0008 __sehtable$__filelengthi64 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0064 __nhandle 0087 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0090 ??_C@_1GC@GCAOLCHH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0097 __CrtDbgReportW 00ca ??_C@_1BO@FPPOBOJI@?$AA_?$AAf?$AAi?$AAl?$AAe?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AAi?$AA6?$AA4?$AA?$AA@ 00d4 __invalid_parameter 00f8 ___pioinfo 0110 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0174 ___lock_fhandle 01ad __lseeki64_nolock 023e ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 026e __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 21 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF 83 CA FF E9 23 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 96 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 D0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 0D 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 73 6A 01 6A 00 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 75 10 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF EB 3E 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 4D E0 3B 4D D8 75 08 8B 55 E4 3B 55 DC 74 16 6A 00 8B 45 E4 50 8B 4D E0 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 46 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 42 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 55 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__wmakepath"
		size = 37
		refs = "001c __wmakepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "__makepath"
		size = 37
		refs = "001c __makepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__cinit"
		size = 157
		refs = "0008 __FPinit 0015 __IsNonwritableInCurrentImage 002e __initp_misc_cfltcvt_tab 0033 ___xi_z 0038 ___xi_a 003d __initterm_e 0053 __RTC_Terminate 0058 _atexit 0060 ___xc_z 0065 ___xc_a 006a __initterm 0073 ___dyn_tls_init_callback"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 1E 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 47 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 74 1D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C 6A 00 6A 02 6A 00 FF 15 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "_exit"
		size = 23
		refs = "000e _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_2_0 {
	meta:
		name = "__exit"
		size = 23
		refs = "000e _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "__cexit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_4_0 {
	meta:
		name = "__c_exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_5_0 {
	meta:
		name = "__amsg_exit"
		size = 34
		refs = "0006 __FF_MSGBANNER 000f __NMSG_WRITE 001c __exit"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_75_6_0 {
	meta:
		name = "___freeCrtMemory"
		size = 321
		refs = "0007 __wenviron 0030 __free_dbg 0055 __environ 00a5 ___wargv 00b6 ___argv 00c7 ___onexitbegin 00ce __imp__DecodePointer@4 00f0 __encoded_null 00fa ___ptmbcinfo 0101 __imp__InterlockedDecrement@4 010f ___initialmbcinfo 0139 __imp__InterlockedIncrement@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 27 81 3D ?? ?? ?? ?? ?? ?? ?? ?? 74 1B 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_7_0 {
	meta:
		name = "_doexit"
		size = 495
		refs = "0008 __sehtable$_doexit 000d __except_handler4 001f ___security_cookie 0033 __lockexit 0040 __C_Exit_Done 004d __C_Termination_Done 0059 __exitflag 0069 ___onexitbegin 0070 __imp__DecodePointer@4 0083 ___onexitend 00d1 __encoded_null 0151 ___xp_z 0156 ___xp_a 015b __initterm 0163 ___xt_z 0168 ___xt_a 0176 ?fExit@?1??doexit@@9@9 0180 __CrtSetDbgFlag 0197 ___freeCrtMemory 019c __CrtDumpMemoryLeaks 01b5 __unlockexit 01d6 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 01 0F 84 55 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8A 45 10 A2 ?? ?? ?? ?? 83 7D 0C 00 0F 85 FB 00 00 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 0F 84 CF 00 00 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 D8 C7 45 DC 00 00 00 00 8B 45 E4 89 45 D4 8B 4D D8 89 4D E0 BA 01 00 00 00 85 D2 0F 84 9F 00 00 00 C7 45 D0 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 D8 83 E8 04 89 45 D8 8B 4D D8 3B 4D E4 72 0E E8 ?? ?? ?? ?? 8B 55 D8 39 02 75 02 EB E1 8B 45 D8 3B 45 E4 73 02 EB 68 8B 4D D8 8B 11 52 FF 15 ?? ?? ?? ?? 89 45 DC E8 ?? ?? ?? ?? 8B 4D D8 89 01 FF 55 DC 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 D0 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 CC 8B 4D D4 3B 4D D0 75 08 8B 55 E0 3B 55 CC 74 18 8B 45 D0 89 45 D4 8B 4D D4 89 4D E4 8B 55 CC 89 55 E0 8B 45 E0 89 45 D8 E9 54 FF FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 75 23 6A FF E8 ?? ?? ?? ?? 83 C4 04 83 E0 20 74 14 C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0C 83 7D 10 00 74 05 E8 ?? ?? ?? ?? C3 83 7D 10 00 74 02 EB 1B C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_8_0 {
	meta:
		name = "___crtCorExitProcess"
		size = 63
		refs = "0009 ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 000f __imp__GetModuleHandleW@4 001d ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0027 __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 07 8B 4D 08 51 FF 55 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_9_0 {
	meta:
		name = "___crtExitProcess"
		size = 29
		refs = "000a ___crtCorExitProcess 0017 __imp__ExitProcess@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_75_10_0 {
	meta:
		name = "__lockexit"
		size = 17
		refs = "0008 __lock"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_75_11_0 {
	meta:
		name = "__unlockexit"
		size = 17
		refs = "0008 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_75_12_0 {
	meta:
		name = "__init_pointers"
		size = 90
		refs = "0007 __encoded_null 0013 __initp_heap_handler 001f __initp_misc_invarg 002b __initp_misc_purevirt 0037 __initp_misc_rand_s 0043 __initp_misc_winsig 004f __initp_eh_hooks"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_13_0 {
	meta:
		name = "__initterm"
		size = 41
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3B 45 0C 73 1A 8B 4D 08 83 39 00 74 07 8B 55 08 8B 02 FF D0 8B 4D 08 83 C1 04 89 4D 08 EB DE 5D C3 }
	condition:
		$1
}

rule file_75_14_0 {
	meta:
		name = "__initterm_e"
		size = 63
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 3B 45 0C 73 23 83 7D FC 00 75 1D 8B 4D 08 83 39 00 74 0A 8B 55 08 8B 02 FF D0 89 45 FC 8B 4D 08 83 C1 04 89 4D 08 EB D5 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_15_0 {
	meta:
		name = "__get_wpgmptr"
		size = 238
		refs = "001b ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GC@DGCPEDNJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1BK@PNLDCCDP@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0063 __invalid_parameter 0075 __wpgmptr 0087 ??_C@_1CC@CDIPMFPD@?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B5 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B5 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B9 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B9 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_16_0 {
	meta:
		name = "__get_pgmptr"
		size = 238
		refs = "001b ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GC@DGCPEDNJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1BI@COAAPHJK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0063 __invalid_parameter 0075 __pgmptr 0087 ??_C@_1CA@BBNAFCKO@?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D7 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D7 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___libm_sse2_asin"
		size = 1097
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 0089 _T_table 0096 _Tbl_addr 00c2 _cv 00d6 _SIGNMASK 014b _HALFMASK2 01a2 _PI_BY_2 025d _cv2 02c4 _ONE_BY_2"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 BE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 54 15 ?? ?? ?? ?? F2 0F 10 D9 F2 0F 59 C9 66 0F 12 35 ?? ?? ?? ?? 83 C4 0C F2 0F 59 D9 F2 0F 59 F9 F2 0F 59 EB 66 0F 57 E2 F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 66 0F 56 E2 F2 0F 58 C6 F2 0F 58 C4 C3 2D BB 03 00 00 83 F8 43 0F 83 18 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 8B C2 66 0F 54 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 00 00 08 00 C1 E8 04 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 83 C4 0C 66 0F C4 F0 03 F2 0F 58 C5 F2 0F 10 EC 66 0F 70 DB EE F2 0F 5C E3 F2 0F 58 DC F2 0F 5C EB F2 0F 5C C5 F2 0F 5C C4 66 0F 56 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 73 5D 66 0F 14 FF 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 F7 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 83 C4 0C 66 0F 59 FF 66 0F 59 F7 66 0F 59 CF 66 0F 59 FF F2 0F 10 DE F2 0F 59 F6 66 0F 58 CA 66 0F 59 E7 F2 0F 59 F3 66 0F 58 CC 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 C3 2D FE 3B 00 00 83 F8 02 0F 83 BB 00 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 5C D9 F2 0F 59 E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 70 FC 44 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 59 DF 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FD 66 0F 58 D3 F2 0F 59 D7 66 0F 59 D5 F2 0F 58 E4 66 0F 70 EE EE 66 0F 70 DC 44 F2 0F 5C E5 F2 0F 58 EC F2 0F 5C EB 66 0F 59 D3 F2 0F 58 EE 66 0F 57 F6 66 0F 70 C2 EE F2 0F 5C D5 83 C4 0C F2 0F 58 C2 25 00 80 00 00 35 00 80 00 00 66 0F C4 F0 03 F2 0F 58 C4 66 0F 57 C6 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 8A 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 42 83 C4 0C 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 10 F8 83 C4 0C 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__wcsnicoll_l"
		size = 651
		refs = "0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@LDEPDFMO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BK@EONLMOKH@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f4 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 014f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0157 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0217 ??1_LocaleUpdate@@QAE@XZ 0244 ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 83 7D 10 00 75 07 33 C0 E9 72 02 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 0C 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 A6 01 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 40 01 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 0F 85 B9 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 C8 EB 09 8B 45 08 0F B7 08 89 4D C8 66 8B 55 C8 66 89 55 DC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 C4 EB 09 8B 45 0C 0F B7 08 89 4D C4 66 8B 55 C4 66 89 55 D8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 DC 85 C0 74 10 0F B7 4D DC 0F B7 55 D8 3B CA 0F 84 61 FF FF FF 0F B7 45 DC 0F B7 4D D8 2B C1 89 45 D4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 EB 67 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 01 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 EB 14 8B 55 FC 83 EA 02 89 55 CC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_4_0 {
	meta:
		name = "__wcsnicoll"
		size = 526
		refs = "000a ___locale_changed 0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@LDEPDFMO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BG@PCPANGGF@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f4 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0203 __wcsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 3D ?? ?? ?? ?? 00 0F 85 DF 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 8F 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 29 01 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C3 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 08 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E4 EB 09 8B 4D 0C 0F B7 11 89 55 E4 66 8B 45 E4 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 18 0F B7 4D FC 85 C9 74 10 0F B7 55 FC 0F B7 45 F8 3B D0 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 18 EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__mbsrev_l"
		size = 491
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003d ??_C@_1GA@IFCJEOBP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW 0058 __errno 006c ??_C@_1BE@HMKMJMHA@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAe?$AAv?$AA_?$AAl?$AA?$AA@ 0076 __invalid_parameter 0088 ??1_LocaleUpdate@@QAE@XZ 0098 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00aa __strrev 013d ??_C@_1FE@OKOAGNBP@?$AA?$CI?$AA?$CC?$AAB?$AAa?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAo?$AA?5?$AA_?$AAm@ 0163 ??_C@_1BK@NHCDBJID@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$DO?$AAs?$AAt?$AAa?$AAr?$AAt?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 56 8B 45 08 89 45 F8 8B 4D 08 89 4D FC 8B 55 0C 52 8D 4D E4 E8 ?? ?? ?? ?? 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 52 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 1F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 22 01 00 00 8B 4D 08 0F B6 11 85 D2 0F 84 C4 00 00 00 8B 45 08 0F B6 30 8D 4D E4 E8 ?? ?? ?? ?? 8B 48 04 0F B6 54 31 1D 83 E2 04 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 95 00 00 00 8B 4D 08 0F B6 11 85 D2 74 27 8B 45 08 8A 08 88 4D F7 8B 55 08 8B 45 08 8A 48 FF 88 0A 8B 55 08 8A 45 F7 88 42 FF 8B 4D 08 83 C1 01 89 4D 08 EB 64 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 08 3B 4D F8 77 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 E8 01 89 45 08 8B 4D 08 C6 01 00 EB 05 E9 2E FF FF FF 8B 55 08 83 EA 01 89 55 08 8B 45 FC 3B 45 08 73 2E 8B 4D FC 8A 11 88 55 F7 8B 45 FC 8B 4D 08 8A 11 88 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8A 55 F7 88 11 8B 45 08 83 E8 01 89 45 08 EB CA 8B 4D F8 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 45
		refs = "000e ??_C@_1GG@JDHHLGNI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0013 ??_C@_1BG@DCNCEIOF@?$AAn?$AAe?$AAw?$AA_?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0018 __wassert 0022 ?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 14 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 33 C0 5D C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_div"
		size = 38
		altNames = "_ldiv"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 99 F7 7D 0C 89 45 F8 8B 45 08 99 F7 7D 0C 89 55 FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__read"
		size = 656
		refs = "0008 __sehtable$__read 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008d ??_C@_1FM@NGICBHLO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0094 __CrtDbgReportW 00c7 ??_C@_1M@NHJOLLDM@?$AA_?$AAr?$AAe?$AAa?$AAd?$AA?$AA@ 00d1 __invalid_parameter 00f2 ___pioinfo 010a ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0179 ??_C@_1CC@HBLPFNKH@?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$CJ?$AA?$AA@ 01da ___lock_fhandle 0215 __read_nolock 0243 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0273 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 28 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9E 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 18 01 00 00 BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 D8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 61 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "__read_nolock"
		size = 3912
		refs = "001d ___doserrno 0028 __errno 0045 __nhandle 0068 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 0074 ??_C@_1FM@NGICBHLO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 007b __CrtDbgReportW 00b1 ??_C@_1BK@JJBHNDKJ@?$AA_?$AAr?$AAe?$AAa?$AAd?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 00bb __invalid_parameter 00dc ___pioinfo 00f4 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0169 ??_C@_1CC@HBLPFNKH@?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$CJ?$AA?$AA@ 0212 ??_C@_1CG@OHLJHGGK@?$AA?$CI?$AAi?$AAn?$AAp?$AAu?$AAt?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 02c3 ??_C@_1CC@EEOLPHGO@?$AA?$CI?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$CG?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 034c ??_C@_0CO@CEGKNHEH@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0357 __malloc_dbg 0390 __lseeki64_nolock 0628 __imp__ReadFile@20 0640 __imp__GetLastError@0 0689 __dosmaperr 0a05 __lookuptrailbytes 0b68 __imp__MultiByteToWideChar@24 0f25 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 74 56 C7 45 F4 FE FF FF FF 8B 45 10 89 45 FC 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 09 0F 00 00 83 7D 08 00 7C 14 8B 4D 08 3B 0D ?? ?? ?? ?? 73 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 55 98 89 55 BC 83 7D BC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 79 0E 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 01 F7 D9 1B C9 F7 D9 89 4D B8 75 21 68 ?? ?? ?? ?? 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B8 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 ED 0D 00 00 B8 FF FF FF 7F 3B 45 10 1B C9 83 C1 01 89 4D B4 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B4 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 78 0D 00 00 C7 45 CC 00 00 00 00 83 7D 10 00 74 20 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 02 74 07 33 C0 E9 44 0D 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D B0 83 7D B0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 8D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B0 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CF 0C 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 88 45 EB 8A 4D EB 88 4D 94 80 7D 94 01 74 0F 80 7D 94 02 0F 84 0F 01 00 00 E9 88 01 00 00 8B 55 10 83 E2 01 F7 DA 1B D2 83 C2 01 89 55 AC 75 21 68 ?? ?? ?? ?? 6A 00 68 A9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1E 0C 00 00 8B 4D 10 D1 E9 83 F9 04 73 09 C7 45 90 04 00 00 00 EB 08 8B 55 10 D1 EA 89 55 90 8B 45 90 89 45 10 68 AD 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 83 7D D4 00 75 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 BE 0B 00 00 6A 01 6A 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 C1 F9 05 8B 75 08 83 E6 1F C1 E6 06 8B 0C 8D ?? ?? ?? ?? 89 44 31 28 89 54 31 2C E9 84 00 00 00 8B 55 10 83 E2 01 F7 DA 1B D2 83 C2 01 89 55 A8 75 21 68 ?? ?? ?? ?? 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D A8 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 14 0B 00 00 8B 4D 10 83 E1 FE 89 4D 10 8B 55 0C 89 55 D4 8B 45 D4 89 45 C8 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 48 0F 84 96 01 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 05 83 FA 0A 0F 84 72 01 00 00 83 7D 10 00 0F 84 68 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 C8 8A 4C 0A 05 88 08 8B 55 C8 83 C2 01 89 55 C8 8B 45 CC 83 C0 01 89 45 CC 8B 4D 10 83 E9 01 89 4D 10 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? C6 44 01 05 0A 0F BE 55 EB 85 D2 0F 84 07 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 25 83 F8 0A 0F 84 E3 00 00 00 83 7D 10 00 0F 84 D9 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D C8 8A 54 10 25 88 11 8B 45 C8 83 C0 01 89 45 C8 8B 4D CC 83 C1 01 89 4D CC 8B 55 10 83 EA 01 89 55 10 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? C6 44 0A 25 0A 0F BE 45 EB 83 F8 01 75 7B 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 26 83 F9 0A 74 5B 83 7D 10 00 74 55 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 C8 8A 44 01 26 88 02 8B 4D C8 83 C1 01 89 4D C8 8B 55 CC 83 C2 01 89 55 CC 8B 45 10 83 E8 01 89 45 10 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? C6 44 10 26 0A 6A 00 8D 4D EC 51 8B 55 10 52 8B 45 C8 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 0E 83 7D EC 00 7C 08 8B 55 EC 3B 55 10 76 5E FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 05 75 23 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B 4D DC 89 08 C7 45 F4 FF FF FF FF E9 AA 08 00 00 EB 2C 83 7D DC 6D 75 0E C7 45 F4 00 00 00 00 E9 96 08 00 00 EB 18 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF E9 7C 08 00 00 8B 45 CC 03 45 EC 89 45 CC 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 81 E1 80 00 00 00 0F 84 4C 08 00 00 0F BE 55 EB 83 FA 02 0F 84 EC 04 00 00 83 7D EC 00 74 45 8B 45 D4 0F BE 08 83 F9 0A 75 3A 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 CA 04 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 EB 38 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 FB 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 8B 45 D4 89 45 D8 8B 4D D8 89 4D F8 8B 55 D4 03 55 CC 39 55 F8 0F 83 39 02 00 00 8B 45 F8 0F BE 08 83 F9 1A 0F 85 80 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 40 75 3A 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 C8 02 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 04 EB 1C 8B 55 D8 8B 45 F8 8A 08 88 0A 8B 55 D8 83 C2 01 89 55 D8 8B 45 F8 83 C0 01 89 45 F8 E9 AF 01 00 00 E9 A5 01 00 00 8B 4D F8 0F BE 11 83 FA 0D 74 21 8B 45 D8 8B 4D F8 8A 11 88 10 8B 45 D8 83 C0 01 89 45 D8 8B 4D F8 83 C1 01 89 4D F8 E9 79 01 00 00 8B 55 CC 8B 45 D4 8D 4C 10 FF 39 4D F8 73 47 8B 55 F8 0F BE 42 01 83 F8 0A 75 1A 8B 4D F8 83 C1 02 89 4D F8 8B 55 D8 C6 02 0A 8B 45 D8 83 C0 01 89 45 D8 EB 1C 8B 4D D8 8B 55 F8 8A 02 88 01 8B 4D D8 83 C1 01 89 4D D8 8B 55 F8 83 C2 01 89 55 F8 E9 23 01 00 00 8B 45 F8 83 C0 01 89 45 F8 C7 45 DC 00 00 00 00 6A 00 8D 4D EC 51 6A 01 8D 55 F3 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 06 83 7D EC 00 75 14 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 E9 BA 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 48 74 48 0F BE 4D F3 83 F9 0A 75 11 8B 55 D8 C6 02 0A 8B 45 D8 83 C0 01 89 45 D8 EB 2C 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 45 F3 88 44 0A 05 EB 52 8B 4D D8 3B 4D D4 75 1A 0F BE 55 F3 83 FA 0A 75 11 8B 45 D8 C6 00 0A 8B 4D D8 83 C1 01 89 4D D8 EB 30 6A 01 6A FF 6A FF 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 0F BE 45 F3 83 F8 0A 74 0F 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 E9 B8 FD FF FF 8B 45 D8 2B 45 D4 89 45 CC 0F BE 4D EB 83 F9 01 0F 85 FA 01 00 00 83 7D CC 00 0F 84 F0 01 00 00 8B 55 D8 83 EA 01 89 55 D8 8B 45 D8 0F BE 08 81 E1 80 00 00 00 75 0E 8B 55 D8 83 C2 01 89 55 D8 E9 4F 01 00 00 C7 45 A4 01 00 00 00 8B 45 D8 0F B6 08 0F BE 91 ?? ?? ?? ?? 85 D2 75 22 83 7D A4 04 7F 1C 8B 45 D8 3B 45 D4 72 14 8B 4D D8 83 E9 01 89 4D D8 8B 55 A4 83 C2 01 89 55 A4 EB CD 8B 45 D8 0F B6 08 0F BE 91 ?? ?? ?? ?? 89 55 A0 83 7D A0 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F4 FF FF FF FF E9 BC 04 00 00 8B 45 A0 83 C0 01 3B 45 A4 75 0E 8B 4D D8 03 4D A4 89 4D D8 E9 CF 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 48 0F 84 8F 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 D8 8A 00 88 44 0A 05 8B 4D D8 83 C1 01 89 4D D8 83 7D A4 02 7C 28 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 D8 8A 12 88 54 01 25 8B 45 D8 83 C0 01 89 45 D8 83 7D A4 03 75 28 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D D8 8A 09 88 4C 10 26 8B 55 D8 83 C2 01 89 55 D8 8B 45 D8 2B 45 A4 89 45 D8 EB 1C 6A 01 8B 45 A4 F7 D8 99 52 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 8B 55 D8 2B 55 D4 89 55 CC 8B 45 FC D1 E8 50 8B 4D 0C 51 8B 55 CC 52 8B 45 D4 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 45 CC 83 7D CC 00 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF E9 88 03 00 00 8B 4D D8 2B 4D D4 33 D2 39 4D CC 0F 95 C2 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 89 54 08 30 8B 4D CC D1 E1 89 4D CC E9 53 03 00 00 83 7D EC 00 74 45 8B 55 D4 0F B7 02 83 F8 0A 75 3A 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 C9 04 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 EB 38 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 FB 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 04 8B 55 D4 89 55 E0 8B 45 E0 89 45 D0 8B 4D D4 03 4D CC 39 4D D0 0F 83 AC 02 00 00 8B 55 D0 0F B7 02 83 F8 1A 0F 85 82 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 40 75 3A 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 CA 02 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 EB 1E 8B 4D E0 8B 55 D0 66 8B 02 66 89 01 8B 4D E0 83 C1 02 89 4D E0 8B 55 D0 83 C2 02 89 55 D0 E9 20 02 00 00 E9 16 02 00 00 8B 45 D0 0F B7 08 83 F9 0D 74 23 8B 55 E0 8B 45 D0 66 8B 08 66 89 0A 8B 55 E0 83 C2 02 89 55 E0 8B 45 D0 83 C0 02 89 45 D0 E9 E8 01 00 00 8B 4D CC 8B 55 D4 8D 44 0A FE 39 45 D0 73 4E 8B 4D D0 0F B7 51 02 83 FA 0A 75 1F 8B 45 D0 83 C0 04 89 45 D0 B9 0A 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 EB 1E 8B 4D E0 8B 55 D0 66 8B 02 66 89 01 8B 4D E0 83 C1 02 89 4D E0 8B 55 D0 83 C2 02 89 55 D0 E9 8B 01 00 00 8B 45 D0 83 C0 02 89 45 D0 C7 45 DC 00 00 00 00 6A 00 8D 4D EC 51 6A 02 8D 55 E4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 06 83 7D EC 00 75 19 B9 0D 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 E9 1D 01 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 48 0F 84 9D 00 00 00 0F B7 55 E4 83 FA 0A 75 16 B8 0A 00 00 00 8B 4D E0 66 89 01 8B 55 E0 83 C2 02 89 55 E0 EB 7C 8D 45 E4 89 45 9C B9 0D 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D 9C 8A 09 88 4C 10 05 8B 55 9C 83 C2 01 89 55 9C 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 9C 8A 00 88 44 0A 25 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? C6 44 10 26 0A EB 5C 8B 4D E0 3B 4D D4 75 1F 0F B7 55 E4 83 FA 0A 75 16 B8 0A 00 00 00 8B 4D E0 66 89 01 8B 55 E0 83 C2 02 89 55 E0 EB 35 6A 01 6A FF 6A FE 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 0F B7 4D E4 83 F9 0A 74 14 BA 0D 00 00 00 8B 45 E0 66 89 10 8B 4D E0 83 C1 02 89 4D E0 E9 45 FD FF FF 8B 55 E0 2B 55 D4 89 55 CC 8B 45 D4 3B 45 0C 74 0C 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 83 7D F4 FE 75 08 8B 55 CC 89 55 8C EB 06 8B 45 F4 89 45 8C 8B 45 8C 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 168
		refs = "000f ??0UMSBaseObject@details@Concurrency@@QAE@XZ 0018 ??_7TransmogrifiedPrimary@details@Concurrency@@6B@ 0041 ??0?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAE@XZ 005a ?Initialize@TransmogrifiedPrimary@details@Concurrency@@AAEXXZ 0068 __imp__CreateEventW@16 007d __imp__GetLastError@0 0083 _HRESULT_FROM_WIN32 008f ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0094 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 009d __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D EC 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC C7 00 ?? ?? ?? ?? 8B 4D EC C7 41 04 00 00 00 00 8B 55 EC C7 42 0C 00 00 00 00 8B 45 EC C7 40 10 00 00 00 00 8B 4D EC 83 C1 1C E8 ?? ?? ?? ?? 8B 4D EC C7 41 28 00 00 00 00 8B 55 EC C6 42 2C 00 8B 4D EC E8 ?? ?? ?? ?? 6A 00 6A 01 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8B 4D EC 89 41 10 8B 55 EC 83 7A 10 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "_HRESULT_FROM_WIN32"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 7F 08 8B 45 08 89 45 FC EB 18 8B 4D 08 81 E1 FF FF 00 00 81 C9 00 00 07 00 81 C9 00 00 00 80 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_6_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z"
		size = 51
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 48 0C 89 4A 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_45_13_1 {
	meta:
		name = "??0regex_error@tr1@std@@QAE@ABV012@@Z"
		size = 51
		refs = "0011 ??0runtime_error@std@@QAE@ABV01@@Z 001a ??_7regex_error@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 48 0C 89 4A 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_11_0 {
	meta:
		name = "?Initialize@TransmogrifiedPrimary@details@Concurrency@@AAEXXZ"
		size = 175
		refs = "0013 ?CreateUmsCompletionList@UMS@details@Concurrency@@SAHPAPAX@Z 0020 __imp__GetLastError@0 0026 _HRESULT_FROM_WIN32 0032 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0037 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0040 __CxxThrowException@8 004e __imp__CreateEventW@16 0095 ?PrimaryMain@TransmogrifiedPrimary@details@Concurrency@@CGKPAX@Z 009e ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 89 4D DC 8B 45 DC 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 51 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8B 55 DC 89 42 0C 8B 45 DC 83 78 0C 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E0 51 E8 ?? ?? ?? ?? 8B 55 DC 83 C2 14 52 6A 00 8B 45 DC 50 68 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 89 41 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_12_0 {
	meta:
		name = "??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 94
		refs = "000e ??_7TransmogrifiedPrimary@details@Concurrency@@6B@ 001b __imp__CloseHandle@4 0053 ?DeleteUmsCompletionList@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 51 08 52 FF 15 ?? ?? ?? ?? 8B 45 FC 83 78 10 00 74 0D 8B 4D FC 8B 51 10 52 FF 15 ?? ?? ?? ?? 8B 45 FC 83 78 0C 00 74 0D 8B 4D FC 8B 51 0C 52 FF 15 ?? ?? ?? ?? 8B 45 FC 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_13_0 {
	meta:
		name = "?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 123
		refs = "000c ?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPAV123@XZ 0035 ?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0069 ?WaitForCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXXZ 0071 ?Unblock@TransmogrifiedPrimary@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 11 8B 4D FC 83 C1 04 8B 45 FC 8B 50 04 8B 42 18 FF D0 8B 4D 08 51 8B 4D F8 83 C1 1C E8 ?? ?? ?? ?? 83 7D FC 00 74 11 8B 4D FC 83 C1 04 8B 55 FC 8B 42 04 8B 50 1C FF D2 8B 45 F8 83 C0 28 B9 01 00 00 00 F0 0F C1 08 41 83 F9 01 75 10 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_14_0 {
	meta:
		name = "?WaitForCompletion@TransmogrifiedPrimary@details@Concurrency@@QAEXXZ"
		size = 28
		refs = "0014 __imp__WaitForSingleObject@8"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A FF 8B 45 FC 8B 48 10 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_15_0 {
	meta:
		name = "?Unblock@TransmogrifiedPrimary@details@Concurrency@@AAEXXZ"
		size = 26
		refs = "0012 __imp__SetEvent@4"
		altNames = "?ResumeExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 0C 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_16_0 {
	meta:
		name = "?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPAV123@XZ"
		size = 21
		refs = "0006 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 000c ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_965_0_0 {
	meta:
		name = "__fgetchar"
		size = 21
		refs = "0006 ___iob_func 000c _getc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "__fgetwchar"
		size = 21
		refs = "0006 ___iob_func 000c _fgetwc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_88_17_0 {
	meta:
		name = "?PrimaryInvocation@TransmogrifiedPrimary@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z"
		size = 454
		refs = "0010 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 002c ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPAK@Z 0039 __imp__GetLastError@0 003f _HRESULT_FROM_WIN32 004b ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0050 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0059 __CxxThrowException@8 0072 ?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z 00d6 __imp__WaitForSingleObject@8 00f6 ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00fb ??_C@_0BJ@GNPJCMFN@pRoot?9?$DOm_queueCount?5?$DN?$DN?50?$AA@ 0100 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0110 ?BindNewProxy@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ 0119 ?Execute@TransmogrifiedPrimary@details@Concurrency@@AAEXPAVUMSThreadProxy@23@@Z 0128 ??_C@_05LAPONLG@false?$AA@ 013d ?HandleBlocking@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ 0175 ?HandleYielding@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 C7 45 F4 00 00 00 00 E8 ?? ?? ?? ?? 89 45 F8 83 7D 08 00 74 42 6A 00 6A 04 8D 45 F4 50 6A 01 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 E4 52 E8 ?? ?? ?? ?? EB 44 8B 45 10 89 45 F4 6A 04 8D 4D F4 51 6A 01 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D D4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 89 4D D0 83 7D D0 00 74 15 83 7D D0 01 74 7D 83 7D D0 02 0F 84 AB 00 00 00 E9 DE 00 00 00 6A FF 8B 55 F4 8B 42 0C 50 FF 15 ?? ?? ?? ?? 8B 4D F4 0F B6 51 2C 85 D2 74 27 8B 45 F4 83 78 28 00 75 02 EB 17 68 97 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 B4 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 50 8B 4D F4 E8 ?? ?? ?? ?? 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 87 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 02 EB 74 8B 55 FC 52 8B 4D F4 E8 ?? ?? ?? ?? 68 AF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 4F 8B 4D F4 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 02 EB 3C 8B 4D FC 51 8B 4D F4 E8 ?? ?? ?? ?? 68 C0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 17 68 C4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_88_18_0 {
	meta:
		name = "?HandleBlocking@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
		size = 274
		refs = "0022 ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0027 ??_C@_0P@IAMBIGKB@pProxy?5?$CB?$DN?5NULL?$AA@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0048 ?DequeueUmsCompletionListItems@UMS@details@Concurrency@@SAHPAXKPAPAX@Z 0055 __imp__GetLastError@0 005b _HRESULT_FROM_WIN32 0067 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 006c __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0075 __CxxThrowException@8 007e ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z 0095 ?GetNextUmsListItem@UMS@details@Concurrency@@SAPAXPAX@Z 00ad ??_C@_0EK@FHIJPKBG@pCompletedProxy?5?$DN?$DN?5pProxy?5?$CG?$CG?5UMS@ 00bd ?IsTerminated@UMSThreadProxy@details@Concurrency@@QAE_NXZ 0103 ?SearchForWork@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 89 4D D8 8B 45 D8 8B 48 04 89 4D FC 83 7D FC 00 74 02 EB 17 68 CF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C7 45 F4 00 00 00 00 8D 55 F4 52 6A FF 8B 45 D8 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 E4 52 E8 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 4D F8 3B 4D FC 75 12 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 02 EB 17 68 DC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 43 8B 4D FC 89 4D DC 8B 55 DC 89 55 E0 83 7D E0 00 74 14 6A 01 8B 45 E0 8B 10 8B 4D E0 8B 42 04 FF D0 89 45 D4 EB 07 C7 45 D4 00 00 00 00 8B 4D D8 C7 41 04 00 00 00 00 8B 4D D8 E8 ?? ?? ?? ?? EB 05 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_19_0 {
	meta:
		name = "?HandleYielding@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
		size = 131
		refs = "0022 ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0027 ??_C@_0P@IAMBIGKB@pProxy?5?$CB?$DN?5NULL?$AA@ 002c ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 005d __imp__SetEvent@4 0069 ?NotifyBlocked@UMSThreadProxy@details@Concurrency@@QAEX_N@Z 007b ?SearchForWork@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F4 8B 45 F4 8B 48 04 89 4D FC 83 7D FC 00 74 02 EB 17 68 FD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 42 34 89 45 F0 83 7D F0 07 74 02 EB 1F 8B 4D FC 89 4D F8 8B 55 F8 C7 42 34 00 00 00 00 8B 45 F8 8B 48 18 51 FF 15 ?? ?? ?? ?? EB 0A 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B 55 F4 C7 42 04 00 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_20_0 {
	meta:
		name = "?NotifyBlocked@UMSThreadProxy@details@Concurrency@@QAEX_N@Z"
		size = 134
		refs = "001a ??_C@_0DI@FFJFCJFK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001f ??_C@_0BA@FLMGJFBL@m_pRoot?5?$CB?$DN?5NULL?$AA@ 0024 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 004f ??_C@_0HC@HCPEEHKB@?$CIm_UMSDebugBits?5?$CG?5?$CIUMS_DEBUGBIT_@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 78 20 00 74 02 EB 17 68 26 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 8B 91 98 00 00 00 81 E2 00 30 00 00 81 FA 00 10 00 00 74 02 EB 17 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 0F B6 45 08 F7 D8 1B C0 F7 D8 83 C0 01 8B 4D FC 89 41 1C 0F B6 55 08 85 D2 75 0A 33 C0 8B 4D FC 83 C1 20 87 01 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_21_0 {
	meta:
		name = "?Execute@TransmogrifiedPrimary@details@Concurrency@@AAEXPAVUMSThreadProxy@23@@Z"
		size = 122
		refs = "0017 ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001c ??_C@_0P@IAMBIGKB@pProxy?5?$CB?$DN?5NULL?$AA@ 0021 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0035 ?GetUMSContext@UMSThreadProxy@details@Concurrency@@QBEPAXXZ 003b ?ExecuteUmsThread@UMS@details@Concurrency@@SAHPAX@Z 0046 ?IsTerminated@UMSThreadProxy@details@Concurrency@@QAE_NXZ 005e ??_C@_0BI@LKHHPIHJ@?$CBpProxy?9?$DOIsTerminated?$CI?$CJ?$AA@ 006e __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 83 7D 08 00 74 02 EB 17 68 23 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 4D 08 89 48 04 8B 4D 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 2A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 FF 15 ?? ?? ?? ?? EB BD 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_23_0 {
	meta:
		name = "?SearchForWork@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
		size = 166
		refs = "001c ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0021 ??_C@_0BG@DHCJNOBD@m_pBoundProxy?5?$DN?$DN?5NULL?$AA@ 0026 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0049 __imp__SetEvent@4 0065 __imp__WaitForSingleObject@8 008a ??_C@_0BC@OIPDECGH@m_queueCount?5?$DN?$DN?50?$AA@ 009e ?BindNewProxy@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 04 00 75 02 EB 17 68 33 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 83 C1 28 83 CA FF F0 0F C1 11 4A 89 55 FC 75 5A 8B 45 F8 8B 48 10 51 FF 15 ?? ?? ?? ?? 8B 55 F8 8B 02 8B 4D F8 8B 50 04 FF D2 6A FF 8B 45 F8 8B 48 0C 51 FF 15 ?? ?? ?? ?? 8B 55 F8 0F B6 42 2C 85 C0 74 26 8B 4D F8 83 79 28 00 75 02 EB 17 68 40 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 33 C0 EB 08 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_24_0 {
	meta:
		name = "?BindNewProxy@TransmogrifiedPrimary@details@Concurrency@@AAEPAVUMSThreadProxy@23@XZ"
		size = 70
		refs = "0010 ?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 002b ??_C@_0EB@JBDKGKC@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0030 ??_C@_0BG@BMDNPKHH@m_pBoundProxy?5?$CB?$DN?5NULL?$AA@ 0035 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 83 7A 04 00 74 02 EB 17 68 51 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 40 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_25_0 {
	meta:
		name = "?PrimaryMain@TransmogrifiedPrimary@details@Concurrency@@CGKPAX@Z"
		size = 192
		refs = "0021 ?PrimaryInvocation@TransmogrifiedPrimary@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z 0030 ?EnterUmsSchedulingMode@UMS@details@Concurrency@@SAHPAU_UMS_SCHEDULER_STARTUP_INFO@@@Z 003e ??2@YAPAXI@Z 0050 __imp__GetLastError@0 0056 _HRESULT_FROM_WIN32 0062 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0079 __TI3PAVscheduler_resource_allocation_error@Concurrency@@ 0082 __CxxThrowException@8 009e ??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z 00b1 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 08 89 45 FC C7 45 EC 00 01 00 00 8B 4D FC 8B 51 18 89 55 F0 C7 45 F4 ?? ?? ?? ?? 8B 45 08 89 45 F8 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 4B 6A 10 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 74 1D FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 8B 4D E4 E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 55 D8 89 55 E8 68 ?? ?? ?? ?? 8D 45 E8 50 E8 ?? ?? ?? ?? 8B 4D FC 89 4D DC 8B 55 DC 89 55 E0 83 7D E0 00 74 0F 6A 01 8B 4D E0 E8 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 00 00 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_27_0 {
	meta:
		name = "??0CachedTransmogrifiedPrimary@details@Concurrency@@QAE@PAVTransmogrificator@12@@Z"
		size = 44
		refs = "000d ??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0016 ??_7CachedTransmogrifiedPrimary@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 34 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_28_0 {
	meta:
		name = "?CompletedTransmogrification@CachedTransmogrifiedPrimary@details@Concurrency@@MAEXXZ"
		size = 28
		refs = "0014 ?ReturnToCache@Transmogrificator@details@Concurrency@@QAEXPAVCachedTransmogrifiedPrimary@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 50 8B 4D FC 8B 49 34 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_35_0 {
	meta:
		name = "?_Release@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 E1 FE 8B 55 FC 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_40_0 {
	meta:
		name = "?Enqueue@?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 79
		refs = "0017 ??_C@_0DF@POHIPAON@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001c ??_C@_0O@EJCMDNEL@pNode?5?$CB?$DN?5NULL?$AA@ 0021 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 83 7D 08 00 74 02 EB 17 68 26 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C7 40 4C 00 00 00 00 8B 4D FC 8B 51 04 8B 45 08 89 02 8B 4D 08 83 C1 4C 8B 55 FC 89 4A 04 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_41_0 {
	meta:
		name = "?Dequeue@?$SQueue@VUMSThreadProxy@details@Concurrency@@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 75 04 33 C0 EB 29 8B 4D F8 8B 11 89 55 FC 8B 45 F8 8B 08 8B 55 F8 8B 41 4C 89 02 8B 4D F8 83 39 00 75 09 8B 55 F8 8B 45 F8 89 42 04 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__wfreopen_helper"
		size = 683
		refs = "0008 __sehtable$__wfreopen_helper 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GC@MPPLBILI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1CC@MPCNIKHO@?$AA_?$AAw?$AAf?$AAr?$AAe?$AAo?$AAp?$AAe?$AAn?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0087 __invalid_parameter 00b4 ??_C@_1CG@LINPOPAD@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 011a ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0180 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ff __lock_file 0220 __fclose_nolock 025f __wopenfile 027e __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 01 02 00 00 8B 55 08 C7 02 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 21 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 21 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 92 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 22 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 22 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 01 00 00 33 C9 83 7D 14 00 0F 95 C1 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C6 00 00 00 8B 45 0C 0F B7 08 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 A5 00 00 00 8B 55 14 89 55 E4 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D E4 8B 51 0C 81 E2 83 00 00 00 74 0C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 C7 41 08 00 00 00 00 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 C7 40 0C 00 00 00 00 8B 4D E4 C7 41 04 00 00 00 00 8B 55 E4 52 8B 45 18 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 89 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 08 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__wfreopen"
		size = 46
		refs = "0020 __wfreopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 6A 40 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_579_1_0 {
	meta:
		name = "_freopen"
		size = 46
		refs = "0020 __freopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 6A 40 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "__wfreopen_s"
		size = 36
		refs = "001b __wfreopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_579_2_0 {
	meta:
		name = "_freopen_s"
		size = 36
		refs = "001b __freopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "_remove"
		size = 67
		refs = "000c __imp__DeleteFileA@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "__rmdir"
		size = 67
		refs = "000c __imp__RemoveDirectoryA@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_861_0_0 {
	meta:
		name = "__wremove"
		size = 67
		refs = "000c __imp__DeleteFileW@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__wrmdir"
		size = 67
		refs = "000c __imp__RemoveDirectoryW@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__findfirst32"
		size = 693
		refs = "000c ___security_cookie 002e ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0037 ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003e __CrtDbgReportW 0055 __errno 0069 ??_C@_1BK@IAOBEFMC@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA3?$AA2?$AA?$AA@ 0073 __invalid_parameter 0096 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0103 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 016c __imp__FindFirstFileExA@24 017b __imp__GetLastError@0 01b2 $LN15 01b9 $LN16 020d ___timet_from_ft 025f ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 0277 _strcpy_s 0280 __invoke_watson_if_error 0290 @__security_check_cookie@4 0298 $LN3 029c $LN2 02a0 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 33 C0 83 7D 0C 00 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 08 02 00 00 C7 85 AC FE FF FF 01 00 00 00 83 BD AC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 A8 FE FF FF 83 BD A8 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 33 01 00 00 6A 00 6A 00 6A 00 8D 95 B8 FE FF FF 52 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 A0 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 D8 FE FF FF 89 42 10 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 FE FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "__findnext32"
		size = 701
		refs = "000c ___security_cookie 002e ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 003a ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0058 __errno 006f ??_C@_1BI@PAGNIILE@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA3?$AA2?$AA?$AA@ 0079 __invalid_parameter 00a1 ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 010f ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0176 __imp__FindNextFileA@8 0180 __imp__GetLastError@0 01b7 $LN15 01be $LN16 0212 ___timet_from_ft 0267 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 027f _strcpy_s 0288 __invoke_watson_if_error 0297 @__security_check_cookie@4 02a0 $LN3 02a4 $LN2 02a8 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 83 7D 08 FF 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 09 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 AC FE FF FF 83 BD AC FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 96 01 00 00 C7 85 A8 FE FF FF 01 00 00 00 83 BD A8 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 28 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 A2 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 D8 FE FF FF 89 42 10 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 FE FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_91_3_0 {
	meta:
		name = "__findclose"
		size = 39
		refs = "000b __imp__FindClose@4 0014 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "___timet_from_ft"
		size = 135
		refs = "0009 ___security_cookie 0032 __imp__FileTimeToLocalFileTime@8 0044 __imp__FileTimeToSystemTime@8 0072 ___loctotime32_t 007f @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 F4 8B 45 08 83 38 00 75 0E 8B 4D 08 83 79 04 00 75 05 83 C8 FF EB 51 8D 55 F8 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D E4 51 8D 55 F8 52 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 28 6A 00 0F B7 45 F0 50 0F B7 4D EE 51 0F B7 55 EC 52 0F B7 45 EA 50 0F B7 4D E6 51 0F B7 55 E4 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D F4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__loaddll"
		size = 17
		refs = "000b __imp__LoadLibraryA@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_40_2_1 {
	meta:
		name = "?_Mtx_lock@threads@stdext@@YAXPAX@Z"
		size = 17
		refs = "000b __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_69_3_3 {
	meta:
		name = "?_Mtx_unlock@threads@stdext@@YAXPAX@Z"
		size = 17
		refs = "000b __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_72_2_1 {
	meta:
		name = "__Mtxdst"
		size = 17
		refs = "000b __imp__DeleteCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_72_1_1 {
	meta:
		name = "__Mtxinit"
		size = 17
		refs = "000b __imp__InitializeCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_72_3_1 {
	meta:
		name = "__Mtxlock"
		size = 17
		refs = "000b __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_72_4_1 {
	meta:
		name = "__Mtxunlock"
		size = 17
		refs = "000b __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_647_0_0 {
	meta:
		name = "__seterrormode"
		size = 17
		refs = "000b __imp__SetErrorMode@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "__unloaddll"
		size = 31
		refs = "000b __imp__FreeLibrary@4 0015 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__wspawnlp"
		size = 424
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PALEFAON@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@BLAGFGFA@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019d __wspawnvp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 38 01 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D5 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 10 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 14 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__resetstkoflw"
		size = 338
		refs = "0009 ___security_cookie 0018 __alloca_probe 0031 __imp__VirtualQuery@12 004c __imp__GetSystemInfo@4 005e ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0064 __imp__GetModuleHandleW@4 0072 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 007c __imp__GetProcAddress@8 0115 __imp__VirtualAlloc@16 0130 __imp__VirtualProtect@16 014a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 70 A1 ?? ?? ?? ?? 33 C5 89 45 94 B8 04 00 00 00 E8 ?? ?? ?? ?? 89 65 90 8B 45 90 89 45 EC 6A 1C 8D 4D A0 51 8B 55 EC 52 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 01 01 00 00 8B 45 A4 89 45 9C 8D 4D BC 51 FF 15 ?? ?? ?? ?? 8B 55 C0 89 55 E4 C7 45 F0 00 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 39 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 98 83 7D 98 00 74 21 C7 45 E0 00 00 00 00 8D 4D E0 51 FF 55 98 83 C4 04 85 C0 74 0C 83 7D E0 00 76 06 8B 55 E0 89 55 F0 8B 45 E4 8B 4D F0 8D 54 01 FF 8B 45 E4 83 E8 01 F7 D0 23 D0 89 55 F0 74 09 8B 4D F0 03 4D E4 89 4D F0 8B 55 E4 D1 E2 39 55 F0 73 08 8B 45 E4 D1 E0 89 45 F0 8B 4D E4 83 E9 01 F7 D1 23 4D EC 2B 4D F0 89 4D E8 8B 55 9C 03 55 E4 89 55 F8 8B 45 E8 3B 45 F8 73 04 33 C0 EB 3D 6A 04 68 00 10 00 00 8B 4D F0 51 8B 55 E8 52 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8D 45 F4 50 68 04 01 00 00 8B 4D F0 51 8B 55 E8 52 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 05 B8 01 00 00 00 8D 65 90 8B 4D 94 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "_strstr"
		size = 134
		refs = "0075 ___from_strstr_to_strchr"
	strings:
		$1 = { 8B 4C 24 08 57 53 56 8A 11 8B 7C 24 10 84 D2 74 6F 8A 71 01 84 F6 74 55 8B F7 8B 4C 24 14 8A 07 83 C6 01 3A C2 74 17 84 C0 74 0D 8A 06 83 C6 01 3A C2 74 0A 84 C0 75 F3 5E 5B 5F 33 C0 C3 8A 06 83 C6 01 3A C6 75 E9 8D 7E FF 8A 61 02 84 E4 74 28 8A 06 83 C6 02 3A C4 75 BE 8A 41 03 84 C0 74 18 8A 66 FF 83 C1 02 3A C4 74 DF EB AB 33 C0 5E 5B 5F 8A C2 E9 ?? ?? ?? ?? 8D 47 FF 5E 5B 5F C3 8B C7 5E 5B 5F C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__CIlog_pentium4"
		size = 624
		refs = "0039 emask 0041 One 0049 Magic 0051 hi_mask 006f B_Tbl 0077 T_Tbl 00d9 coeff 0105 LOG_2 0111 place_L 0168 Zero 01b7 Infs 01e2 Two52 0233 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 AE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 15 C9 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E8 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 02 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 2F FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 03 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E8 03 00 00 EB A6 8D 64 24 00 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__wexecv"
		size = 526
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1FO@MOEPNDIF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@NHAFPAGO@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAv?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CE@IOFFAHL@?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0148 ??_C@_1CG@DNLPJOJF@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01aa ??_C@_1DA@EPHHLJFN@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0203 __wexecve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9E 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3B 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 8B 4D 0C 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 0C 8B 11 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "?SetContextDebugBits@details@Concurrency@@YAXPAVInternalContextBase@12@K@Z"
		size = 25
		refs = "0013 ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 0C 8B 45 0C 50 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_100_2_0 {
	meta:
		name = "?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 AC 00 00 00 0B 4D 08 8B 55 FC 89 8A AC 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_3_0 {
	meta:
		name = "??0InternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z"
		size = 380
		refs = "000d ??0IExecutionContext@Concurrency@@QAE@XZ 001e ??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0027 ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 0031 ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 6A 00 8B 45 08 50 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 55 FC C7 42 04 ?? ?? ?? ?? 8B 45 FC C7 80 80 00 00 00 00 00 00 00 8B 4D FC C7 81 84 00 00 00 00 00 00 00 8B 55 FC C7 82 88 00 00 00 00 00 00 00 8B 45 FC C7 80 8C 00 00 00 00 00 00 00 8B 4D FC C7 81 90 00 00 00 00 00 00 00 8B 55 FC C6 82 94 00 00 00 00 8B 45 FC C6 80 96 00 00 00 00 8B 4D FC 8A 91 97 00 00 00 80 E2 FE 8B 45 FC 88 90 97 00 00 00 8B 4D FC 8A 91 97 00 00 00 80 E2 FD 8B 45 FC 88 90 97 00 00 00 8B 4D FC 8A 91 97 00 00 00 80 E2 FB 8B 45 FC 88 90 97 00 00 00 8B 4D FC C7 81 98 00 00 00 00 00 00 00 C7 81 9C 00 00 00 00 00 00 00 8B 55 FC C7 82 A0 00 00 00 00 00 00 00 C7 82 A4 00 00 00 00 00 00 00 8B 45 FC C7 80 A8 00 00 00 00 00 00 00 8B 4D FC C7 81 AC 00 00 00 00 00 00 00 8B 55 FC C7 82 B0 00 00 00 00 00 00 00 8B 45 FC C7 80 B4 00 00 00 00 00 00 00 8B 4D FC C7 81 B8 00 00 00 00 00 00 00 8B 55 FC C7 82 BC 00 00 00 00 00 00 00 8B 45 FC C7 80 C0 00 00 00 00 00 00 00 8B 4D FC C7 81 C4 00 00 00 00 00 00 00 8B 55 FC C6 82 CC 00 00 00 01 8B 45 FC C7 40 1C 00 00 00 00 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_4_0 {
	meta:
		name = "?EnterCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 74
		refs = "000c ?CurrentContext@Context@Concurrency@@SAPAV12@XZ 001d ??_C@_0DF@PNOMPJKK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0022 ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@ 0027 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 48 0C 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 89 42 0C 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_5_0 {
	meta:
		name = "?EnterHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 54
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 0C 83 C1 01 8B 55 FC 89 4A 0C 8B 45 FC 8B 48 10 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 89 42 10 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_6_0 {
	meta:
		name = "?ExitCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 108
		refs = "001c ??_C@_0DF@PNOMPJKK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0021 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@ 0026 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 002e ?CurrentContext@Context@Concurrency@@SAPAV12@XZ 0044 ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 0C 00 76 02 EB 17 68 B3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 B4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 8B 51 0C 83 EA 01 89 55 F8 8B 45 FC 8B 4D F8 89 48 0C 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_7_0 {
	meta:
		name = "?ExitHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 122
		refs = "001c ??_C@_0DF@PNOMPJKK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0021 ??_C@_0BP@KFKOBDFI@m_hyperCriticalRegionCount?5?$DO?50?$AA@ 0026 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0043 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 10 00 76 02 EB 17 68 C4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 79 0C 00 76 02 EB 17 68 C5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 42 0C 83 E8 01 8B 4D FC 89 41 0C 8B 55 FC 8B 42 10 83 E8 01 89 45 F8 8B 4D FC 8B 55 F8 89 51 10 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_8_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 47
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 78 10 00 76 07 B8 02 00 00 00 EB 12 8B 4D FC 83 79 0C 00 76 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_9_0 {
	meta:
		name = "?IsSynchronouslyBlocked@InternalContextBase@details@Concurrency@@UBE_NXZ"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 2C 33 C0 83 F9 02 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_10_0 {
	meta:
		name = "?PrepareToRun@InternalContextBase@details@Concurrency@@MAEXPAVVirtualProcessor@23@@Z"
		size = 90
		refs = "0031 __imp__GetCurrentThreadId@0 0046 ?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F 31 8B 4D FC 89 81 A0 00 00 00 89 91 A4 00 00 00 8B 55 FC 8B 82 A8 00 00 00 83 C0 01 8B 4D FC 89 81 A8 00 00 00 FF 15 ?? ?? ?? ?? 8B 55 FC 89 82 B8 00 00 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 33 C9 8B 55 FC 83 C2 2C 87 0A 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_11_0 {
	meta:
		name = "?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@@Z"
		size = 80
		refs = "001c ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ 002d ??_C@_0DN@COCFINJF@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0032 ??_C@_0DJ@FICHJDBF@_m_pVirtualProcessor?5?$DN?$DN?5NULL?5?$HM?$HM?5@ 0037 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 B8 84 00 00 00 00 74 29 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 17 68 D3 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 45 08 89 82 84 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_16_0 {
	meta:
		name = "?Block@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 571
		refs = "000f ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002b ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0039 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003e ??_C@_0CM@MNAAIIAE@this?5?$DN?$DN?5SchedulerBase?3?3FastCurre@ 0043 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0051 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0063 ??_C@_0BM@PCDLOGHO@m_pVirtualProcessor?5?$CB?$DN?5NULL?$AA@ 0092 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 00a4 ?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QAE_NXZ 00e6 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 0122 ??0WorkItem@details@Concurrency@@QAE@XZ 013f ?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 014e ?IsContext@WorkItem@details@Concurrency@@QBE_NXZ 015d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 017c ??_C@_0DB@DDJEDPDL@GetCriticalRegionType?$CI?$CJ?5?$DN?$DN?5Outsi@ 0181 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 018c ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 01a1 ?GetContext@WorkItem@details@Concurrency@@QBEPAVInternalContextBase@23@XZ 01bd ??_C@_0BB@FMFPHIFE@this?5?$CB?$DN?5pContext?$AA@ 01f3 ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 0207 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 021c ?ClearDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D EC 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 E8 04 74 08 8B 4D EC 89 4D E8 EB 07 C7 45 E8 00 00 00 00 E8 ?? ?? ?? ?? 39 45 E8 75 02 EB 14 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 85 C0 74 02 EB 14 6A 46 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 EC 8B 42 08 50 8B 4D EC 8B 51 1C 8B 45 EC 8B 48 1C 8B 12 8B 42 04 FF D0 50 6A 04 6A 03 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 4F 8B 55 EC 83 C2 2C B8 01 00 00 00 F0 0F C1 02 40 83 F8 01 75 28 B9 02 00 00 00 8B 55 EC 83 C2 2C B8 01 00 00 00 F0 0F B1 0A 83 F8 01 75 0F 6A 01 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? EB 0D 6A 02 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? E9 31 01 00 00 8B 45 EC 83 C0 2C B9 01 00 00 00 F0 0F C1 08 41 83 F9 01 0F 85 18 01 00 00 C7 45 F0 00 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8B 55 EC 8B 42 18 50 8D 4D F4 51 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 5E 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 44 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 8B 55 EC 8B 02 8B 50 3C FF D2 85 C0 75 02 EB 14 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F4 E8 ?? ?? ?? ?? 89 45 F0 8B 4D EC E8 ?? ?? ?? ?? EB 0B 8D 4D F4 E8 ?? ?? ?? ?? 89 45 F0 8B 45 EC 83 E8 04 3B 45 F0 74 02 EB 14 6A 7F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C B9 02 00 00 00 8B 55 EC 83 C2 2C B8 01 00 00 00 F0 0F B1 0A 83 F8 01 75 2B 83 7D F0 00 75 12 6A 00 6A 00 8B 45 EC 8B 48 18 E8 ?? ?? ?? ?? 89 45 F0 6A 01 8B 4D F0 51 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? EB 22 83 7D F0 00 74 1C 68 00 80 00 00 8B 4D F0 E8 ?? ?? ?? ?? 6A 00 8B 55 F0 8B 02 8B 4D F0 8B 50 18 FF D2 8B 4D EC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_17_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@XZ"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 08 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_18_0 {
	meta:
		name = "?IsContext@WorkItem@details@Concurrency@@QBE_NXZ"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 33 C9 83 38 01 0F 94 C1 8A C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_19_0 {
	meta:
		name = "?GetContext@WorkItem@details@Concurrency@@QBEPAVInternalContextBase@23@XZ"
		size = 49
		refs = "0016 ??_C@_0DK@KNEOOAPM@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001b ??_C@_0BO@OIIBNGJB@m_type?5?$DN?$DN?5WorkItemTypeContext?$AA@ 0020 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 38 01 75 02 EB 14 6A 79 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 8B 41 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_20_0 {
	meta:
		name = "?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 79 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_21_0 {
	meta:
		name = "?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z"
		size = 36
		refs = "001a ?Search@WorkSearchContext@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 07 8B 45 0C 50 8B 4D 08 51 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_100_22_0 {
	meta:
		name = "?Search@WorkSearchContext@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 FC 8B 4D FC 8B 50 18 FF D2 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_100_23_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
		size = 66
		refs = "000c ?g_TraceOn@details@Concurrency@@3_NA 001b ?g_EnableLevel@details@Concurrency@@3EA 0035 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 05 ?? ?? ?? ?? 85 C0 74 28 0F B6 4D 0C 0F B6 15 ?? ?? ?? ?? 3B CA 7F 19 8B 45 14 50 8B 4D 10 51 0F B6 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_581_16_0 {
	meta:
		name = "?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
		size = 66
		refs = "000c ?g_TraceOn@details@Concurrency@@3_NA 001b ?g_EnableLevel@details@Concurrency@@3EA 0035 ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 0F B6 05 ?? ?? ?? ?? 85 C0 74 28 0F B6 4D 0C 0F B6 15 ?? ?? ?? ?? 3B CA 7F 19 8B 45 14 50 8B 4D 10 51 0F B6 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_100_24_0 {
	meta:
		name = "?ClearDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 F7 D0 8B 4D FC 23 81 AC 00 00 00 8B 55 FC 89 82 AC 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_26_0 {
	meta:
		name = "?Unblock@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 254
		refs = "0023 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 006d ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0088 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 00bb ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00c0 ??_C@_0O@DGMMIGAG@newValue?5?$DM?5?91?$AA@ 00c5 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 00d0 ??0context_unblock_unbalanced@Concurrency@@QAE@XZ 00d5 __TI2?AVcontext_unblock_unbalanced@Concurrency@@ 00de __CxxThrowException@8 00e8 ??0context_self_unblock@Concurrency@@QAE@XZ 00ed __TI2?AVcontext_self_unblock@Concurrency@@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 89 4D E0 8B 45 E0 83 E8 04 74 08 8B 4D E0 89 4D DC EB 07 C7 45 DC 00 00 00 00 E8 ?? ?? ?? ?? 39 45 DC 0F 84 B4 00 00 00 C7 45 FC 00 00 00 00 8B 55 E0 83 C2 2C 83 C8 FF F0 0F C1 02 48 89 45 FC 8B 4D E0 8B 51 08 52 8B 45 E0 8B 48 1C 8B 55 E0 8B 42 1C 8B 11 8B C8 8B 42 04 FF D0 50 6A 04 6A 04 8B 4D E0 E8 ?? ?? ?? ?? 83 7D FC 01 75 2A 8B 4D E0 C7 41 2C 00 00 00 00 8B 4D E0 83 E9 04 E8 ?? ?? ?? ?? 6A 00 8B 4D E0 83 E9 04 8B 55 E0 8B 42 FC 8B 50 18 FF D2 EB 41 83 7D FC FF 7C 06 83 7D FC 00 7E 35 83 7D FC FF 7D 02 EB 17 68 E5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? EB 16 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E4 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_33_0 {
	meta:
		name = "?Yield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 457
		refs = "0013 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002f ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0040 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0045 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 004a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0058 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 006d ??_C@_0BM@PCDLOGHO@m_pVirtualProcessor?5?$CB?$DN?5NULL?$AA@ 009c ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 00ae ?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QAE_NXZ 00c2 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 00cf ??0WorkItem@details@Concurrency@@QAE@XZ 00ec ?SearchForWorkInYield@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 00ff ?IsContext@WorkItem@details@Concurrency@@QBE_NXZ 010e ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0130 ??_C@_0DB@DDJEDPDL@GetCriticalRegionType?$CI?$CJ?5?$DN?$DN?5Outsi@ 0135 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0140 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0150 ?GetContext@WorkItem@details@Concurrency@@QBEPAVInternalContextBase@23@XZ 0177 ??_C@_0DH@KNPOABKO@work?4GetContext?$CI?$CJ?5?$CB?$DN?5NULL?5?$CG?$CG?5wor@ 0195 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 89 4D EC C6 45 FF 00 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 E8 04 74 08 8B 4D EC 89 4D E8 EB 07 C7 45 E8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E8 75 02 EB 17 68 02 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 85 C0 74 02 EB 17 68 03 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 EC 8B 42 08 50 8B 4D EC 8B 51 1C 8B 45 EC 8B 48 1C 8B 12 8B 42 04 FF D0 50 6A 04 6A 05 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 12 6A 02 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? E9 D4 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 EC 8B 42 18 50 8D 4D F0 51 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 84 A0 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 42 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 8B 55 EC 8B 02 8B 50 3C FF D2 85 C0 75 02 EB 17 68 19 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D EC 83 E9 04 3B C1 74 02 EB 17 68 21 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 02 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? EB 04 C6 45 FF 01 8B 4D EC E8 ?? ?? ?? ?? 0F B6 55 FF 85 D2 74 16 8B 45 EC 8B 48 7C 89 4D E4 8B 55 E4 8B 02 8B 4D E4 8B 50 0C FF D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_34_0 {
	meta:
		name = "?SearchForWorkInYield@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z"
		size = 36
		refs = "001a ?YieldingSearch@WorkSearchContext@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 03 8B 45 0C 50 8B 4D 08 51 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_100_35_0 {
	meta:
		name = "?YieldingSearch@WorkSearchContext@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 FC 8B 4D FC 8B 50 1C FF D2 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_100_36_0 {
	meta:
		name = "?SpinYield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 374
		refs = "0013 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002f ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0040 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0045 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 004a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0058 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 006d ??_C@_0BM@PCDLOGHO@m_pVirtualProcessor?5?$CB?$DN?5NULL?$AA@ 009c ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 00ae ?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QAE_NXZ 00c2 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 00cf ??0WorkItem@details@Concurrency@@QAE@XZ 00ee ?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@W4WorkItemType@423@@Z 00fd ?GetContext@WorkItem@details@Concurrency@@QBEPAVInternalContextBase@23@XZ 0124 ??_C@_0DH@KNPOABKO@work?4GetContext?$CI?$CJ?5?$CB?$DN?5NULL?5?$CG?$CG?5wor@ 0142 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0150 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 89 4D EC C6 45 FF 00 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 E8 04 74 08 8B 4D EC 89 4D E8 EB 07 C7 45 E8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E8 75 02 EB 17 68 42 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 85 C0 74 02 EB 17 68 43 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 EC 8B 42 08 50 8B 4D EC 8B 51 1C 8B 45 EC 8B 48 1C 8B 12 8B 42 04 FF D0 50 6A 04 6A 05 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 12 6A 02 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? E9 81 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 6A 01 8B 55 EC 8B 42 18 50 8D 4D F0 51 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 4F 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D EC 83 E9 04 3B C1 74 02 EB 17 68 55 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 02 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 4D EC 83 E9 04 E8 ?? ?? ?? ?? EB 04 C6 45 FF 01 8B 4D EC E8 ?? ?? ?? ?? 0F B6 55 FF 85 D2 74 16 8B 45 EC 8B 48 7C 89 4D E4 8B 55 E4 8B 02 8B 4D E4 8B 50 0C FF D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_37_0 {
	meta:
		name = "?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@W4WorkItemType@423@@Z"
		size = 38
		refs = "001c ?Search@WorkSearchContext@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_100_38_0 {
	meta:
		name = "?Oversubscribe@InternalContextBase@details@Concurrency@@UAEX_N@Z"
		size = 372
		refs = "0023 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0034 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0039 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 003e ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0067 ??_C@_0BK@NCFPGCDG@m_oversubscribeCount?5?$DO?$DN?50?$AA@ 00a7 ??_C@_0BP@KLPPCGKN@m_pOversubscribedVProc?5?$DN?$DN?5NULL?$AA@ 00b7 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00c2 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 00da ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00f0 ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 00f5 __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 00fe __CxxThrowException@8 0134 ?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z 0154 ??_C@_0CL@IBLIMFGD@pVProc?5?$DN?$DN?5NULL?5?$HM?$HM?5pVProc?5?$DN?$DN?5pExp@ 016a ?MarkForRetirement@VirtualProcessor@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 89 4D E8 8B 45 E8 83 E8 04 74 08 8B 4D E8 89 4D E4 EB 07 C7 45 E4 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E4 75 02 EB 17 68 71 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 0F B6 55 08 85 D2 0F 84 92 00 00 00 8B 45 E8 83 78 14 00 72 02 EB 17 68 76 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E8 8B 51 14 83 C2 01 89 55 E0 8B 45 E8 8B 4D E0 89 48 14 83 7D E0 01 75 50 8B 55 E8 83 BA 84 00 00 00 00 75 02 EB 17 68 7A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D E8 83 E9 04 E8 ?? ?? ?? ?? 89 45 DC 8B 45 DC 8B 10 8B 4D DC 8B 42 20 FF D0 8B 4D E8 E8 ?? ?? ?? ?? E9 8B 00 00 00 8B 4D E8 83 79 14 00 75 16 8D 4D EC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 EC 52 E8 ?? ?? ?? ?? 8B 45 E8 8B 48 14 83 E9 01 89 4D D8 8B 55 E8 8B 45 D8 89 42 14 83 7D D8 00 75 51 8B 4D E8 8B 91 84 00 00 00 89 55 F8 8B 45 F8 50 8B 4D E8 83 E9 04 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 8B 4D FC 3B 4D F8 74 17 68 96 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_42_0 {
	meta:
		name = "?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z"
		size = 76
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 C7 45 FC 00 00 00 00 83 7D 08 00 74 2B 8B 45 F8 8B 88 88 00 00 00 39 4D 08 75 1D 8B 45 08 33 D2 8B 4D F8 81 C1 88 00 00 00 F0 0F B1 11 3B 45 08 75 06 8B 55 08 89 55 FC 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_43_0 {
	meta:
		name = "?GetVirtualProcessorId@InternalContextBase@details@Concurrency@@UBEIXZ"
		size = 85
		refs = "000f ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001a ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0030 ?GetId@VirtualProcessor@details@Concurrency@@QBEIXZ 004a ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 83 E9 04 E8 ?? ?? ?? ?? 85 C0 74 17 8B 4D F8 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 89 45 FC 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_44_0 {
	meta:
		name = "?GetId@VirtualProcessor@details@Concurrency@@QBEIXZ"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 74 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_45_0 {
	meta:
		name = "?AddToRunnables@InternalContextBase@details@Concurrency@@MAEXPAVVirtualProcessor@23@@Z"
		size = 469
		refs = "001c ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0021 ??_C@_0BB@INOLNPNI@m_pGroup?5?$CB?$DN?5NULL?$AA@ 0026 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0046 ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 0053 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0068 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 007b ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 00b0 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00bb ?IsFairScheduleGroup@ScheduleGroupBase@details@Concurrency@@IBE_NXZ 00ce ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 00d8 ?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ 0102 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 0111 ?CrossGroupRunnable@InternalContextBase@details@Concurrency@@QAEXJ@Z 011b ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z 014d ?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 017c ?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAVVirtualProcessor@23@@Z 01a1 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 01cb ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D EC 8B 45 EC 83 78 1C 00 74 02 EB 17 68 CF 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 B9 80 00 00 00 00 74 02 EB 17 68 D0 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 4E 01 00 00 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 85 3B 01 00 00 8B 4D FC E8 ?? ?? ?? ?? 8B 4D EC 39 41 20 0F 85 27 01 00 00 83 7D FC 00 74 0B 8B 55 FC 83 EA 04 89 55 E8 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 F4 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? 8B 4D EC 8B 49 1C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 85 DD 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 83 C0 08 8B C8 E8 ?? ?? ?? ?? 89 45 F8 8B 45 EC 8B 48 20 0F B7 51 10 39 55 F8 0F 8D B5 00 00 00 8B 45 EC 8B 48 1C 89 4D F0 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? 3B 45 F0 74 0A 6A 01 8B 4D EC E8 ?? ?? ?? ?? 6A 04 8B 4D EC E8 ?? ?? ?? ?? 8B 55 EC 8B 42 20 83 B8 FC 00 00 00 00 7E 0D 68 00 10 00 00 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 51 8B 4D F4 E8 ?? ?? ?? ?? 83 C0 08 8B C8 E8 ?? ?? ?? ?? 8B 55 EC 8B 42 20 83 B8 FC 00 00 00 00 7E 20 68 00 20 00 00 8B 4D F4 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 55 F0 52 8B 45 EC 8B 48 20 E8 ?? ?? ?? ?? 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? 3B 45 F0 74 0A 6A 00 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? EB 28 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? 6A 01 8B 4D EC E8 ?? ?? ?? ?? 8B 4D 08 51 8B 55 EC 52 8B 45 EC 8B 48 1C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_48_0 {
	meta:
		name = "?IsFairScheduleGroup@ScheduleGroupBase@details@Concurrency@@IBE_NXZ"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 40 74 83 E0 02 F7 D8 1B C0 F7 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_49_0 {
	meta:
		name = "?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 174
		refs = "0024 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0035 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003a ??_C@_0CM@GONLGPFG@SchedulerBase?3?3FastCurrentContex@ 003f ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 004d ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 0059 ?_Sleep0@details@Concurrency@@YAXXZ 0061 ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0069 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 009e ??_C@_0M@CIBACOAC@IsBlocked?$CI?$CJ?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D EC 83 7D EC 00 74 0B 8B 45 EC 83 C0 04 89 45 E8 EB 07 C7 45 E8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E8 74 02 EB 17 68 35 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 27 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 E6 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 41 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_50_0 {
	meta:
		name = "?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 28 33 C0 85 C9 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_51_0 {
	meta:
		name = "?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
		size = 213
		refs = "0022 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0027 ??_C@_0BC@CCPAMIKP@pNewGroup?5?$DN?$DN?5NULL?$AA@ 002c ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0051 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0067 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 008c ??_C@_0CM@PBCHKKJJ@?$CIpNewGroup?5?$CB?$DN?5NULL?$CJ?5?$HM?$HM?5?$CI?$CBreferen@ 00a4 ?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z 00b2 ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ 00c2 ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 1C 00 75 24 83 7D 08 00 75 02 EB 17 68 54 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 97 00 00 00 83 7D FC 00 74 0B 8B 4D FC 83 C1 04 89 4D F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 17 68 59 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 75 1F 0F B6 55 0C 85 D2 74 17 68 5A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 45 FC 05 C4 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 8B 49 1C E8 ?? ?? ?? ?? 0F B6 55 0C 85 D2 74 08 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 FC 8B 4D 08 89 48 1C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_100_52_0 {
	meta:
		name = "?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z"
		size = 53
		refs = "0013 ?_Sleep0@details@Concurrency@@YAXXZ 001b ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0023 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 8B 08 3B 4D 0C 74 1F 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 08 8B 02 3B 45 0C 75 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_55_0 {
	meta:
		name = "?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
		size = 612
		refs = "0028 $LN33 0040 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0045 ??_C@_0BL@MDNLNDEM@m_pAssociatedChore?5?$DN?$DN?5NULL?$AA@ 004a ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0077 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0086 ?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 00a6 ??_C@_0CH@LEMIAEON@switchState?5?$DN?$DN?5?3?3Concurrency?3?3Bl@ 00bf ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z 00f4 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00fc ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0109 ?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@@Z 0114 ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 012c ??_C@_0N@DCFJDMJP@?$CBIsBlocked?$CI?$CJ?$AA@ 013e ?ClearDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z 0151 ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z 016e ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 01c1 ??_C@_0DN@BHFLPHJM@pNextContext?5?$DN?$DN?5NULL?5?$HM?$HM?5pNextCon@ 021b ??_C@_0BF@FCAPFGBC@pDestination?5?$CB?$DN?5NULL?$AA@ 0249 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0254 $LN12 0258 $LN7 025c $LN9 0260 $LN5"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D EC C7 45 F8 01 00 00 00 8B 45 0C 89 45 E8 83 7D E8 03 0F 87 CB 00 00 00 8B 4D E8 FF 24 8D ?? ?? ?? ?? 8B 55 EC 83 BA 8C 00 00 00 00 75 02 EB 17 68 8D 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC 8B 48 0C 51 8B 55 EC 8B 42 20 8B 4D EC 8B 49 20 8B 10 8B 42 04 FF D0 50 6A 04 6A 06 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D EC 51 8B 55 EC 8B 4A 1C E8 ?? ?? ?? ?? C7 45 F8 00 00 00 00 EB 5A 83 7D F8 01 75 02 EB 17 68 BD 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 45 EC 50 8B 4D EC 8B 49 1C E8 ?? ?? ?? ?? EB 28 83 7D F8 01 75 02 EB 17 68 C9 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 07 C7 45 F8 02 00 00 00 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 89 45 F0 6A 00 8B 4D EC E8 ?? ?? ?? ?? 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 E4 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 40 8B 4D EC E8 ?? ?? ?? ?? 83 7D 0C 00 74 0D 68 80 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 B8 80 00 00 00 00 74 02 EB 17 68 ED 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 8B 91 80 00 00 00 89 55 F4 B8 01 00 00 00 8B 4D EC 83 C1 2C 87 01 8B 55 08 52 8B 45 F0 8B 10 8B 4D F0 8B 42 10 FF D0 83 7D 08 00 74 23 8B 4D 08 83 B9 80 00 00 00 00 75 17 68 03 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 74 19 8B 55 08 83 BA 8C 00 00 00 00 74 0D 68 00 00 02 00 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 89 45 FC 83 7D FC 00 75 2F 8B 4D F0 8B 11 8B 4D F0 8B 42 04 FF D0 89 45 FC 83 7D FC 00 74 02 EB 17 68 0E 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 51 8B 55 FC 52 8B 45 F4 8B 10 8B 4D F4 8B 42 04 FF D0 83 7D 0C 00 74 0B 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_56_0 {
	meta:
		name = "?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z"
		size = 753
		refs = "001f ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 002f ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ 003e ?IsAvailable@VirtualProcessor@details@Concurrency@@QAE_NXZ 0051 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0056 ??_C@_0CE@OFIOPOKH@?$CBm_pVirtualProcessor?9?$DOIsAvailabl@ 005b ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0069 ?InFinalizationSweep@SchedulerBase@details@Concurrency@@QAE_NXZ 007b ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0093 ??_C@_0EO@OFNKDEA@?$CBm_pScheduler?9?$DOInFinalizationSwe@ 00a6 ?SetShutdownValidations@ContextBase@details@Concurrency@@QAEXXZ 00c2 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00e4 ?_PutVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@@Z 0105 ??_C@_0CJ@CGMBFJFD@reason?5?$DN?$DN?5Blocking?5?$HM?$HM?5reason?5?$DN?$DN?5@ 010a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0118 ?ClearShutdownValidations@ContextBase@details@Concurrency@@QAEXXZ 0123 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 012e ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 0146 ??_C@_0N@DCFJDMJP@?$CBIsBlocked?$CI?$CJ?$AA@ 0187 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0196 ?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 01a5 ?TriggerCommitSafePoints@SchedulerBase@details@Concurrency@@QAEXPAVSafePointMarker@23@@Z 01b2 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 01e7 ??_C@_0FA@DLLAIOND@?$CBm_fCanceled?5?$HM?$HM?5?$CIm_pScheduler?9?$DOH@ 0252 ??_C@_0BC@NDNCEKPP@reason?5?$DN?$DN?5Nesting?$AA@ 027d ??_C@_0M@CIBACOAC@IsBlocked?$CI?$CJ?$AA@ 02aa ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z 02dc ??_C@_0BE@EANKFJDF@reason?5?$DN?$DN?5GoingIdle?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D F0 8B 45 F0 8B 88 80 00 00 00 89 4D F8 C6 45 FF 00 8B 4D F0 E8 ?? ?? ?? ?? 85 C0 0F 84 14 02 00 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 35 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F0 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 14 8B 55 F0 8B 4A 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 3A 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 8B 88 90 00 00 00 89 4D F4 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 E8 ?? ?? ?? ?? 89 45 EC 8B 55 EC 8B 02 8B 4D EC 8B 50 0C FF D2 6A 00 8B 4D F0 E8 ?? ?? ?? ?? 83 7D 08 00 74 73 83 7D 08 01 74 1D 83 7D 08 02 74 17 68 4C 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 63 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C B9 01 00 00 00 8B 55 F0 83 C2 2C 87 0A EB 39 8B 45 F0 8B 48 0C 51 8B 55 F0 8B 42 20 8B 4D F0 8B 49 20 8B 10 8B 42 04 FF D0 50 6A 04 6A 06 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F0 51 8B 55 F0 8B 4A 1C E8 ?? ?? ?? ?? 8D 45 F4 50 8B 4D F0 8B 49 20 E8 ?? ?? ?? ?? 6A 00 8B 55 F0 8B 4A 20 E8 ?? ?? ?? ?? 8B 45 F0 0F B6 88 94 00 00 00 85 C9 74 2F 8B 55 F0 8B 4A 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 06 83 7D 08 00 74 17 68 A1 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 8A 91 94 00 00 00 88 55 FF 83 7D 08 00 75 38 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 AC 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C B9 01 00 00 00 8B 55 F0 83 C2 2C 87 0A EB 4A 83 7D 08 03 75 02 EB 17 68 B3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 B4 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 4D E8 83 7D E8 02 7C 19 83 7D E8 03 7E 02 EB 11 6A 00 8B 55 F0 52 8B 45 F0 8B 48 1C E8 ?? ?? ?? ?? 83 7D 08 00 74 0D 8B 4D F8 8B 11 8B 4D F8 8B 42 08 FF D0 0F B6 4D FF 85 C9 74 1F 83 7D 08 00 75 02 EB 17 68 D4 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8A 45 FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_57_0 {
	meta:
		name = "?IsAvailable@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 27
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 04 33 C0 83 F9 01 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_58_0 {
	meta:
		name = "?SetShutdownValidations@ContextBase@details@Concurrency@@QAEXXZ"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C6 40 42 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_59_0 {
	meta:
		name = "?ClearShutdownValidations@ContextBase@details@Concurrency@@QAEXXZ"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C6 40 42 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_60_0 {
	meta:
		name = "?LeaveScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 380
		refs = "0012 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0021 ??0WorkItem@details@Concurrency@@QAE@XZ 0034 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 003b ?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 004d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0055 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 007f ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 00a1 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00a6 ??_C@_0BB@FMFPHIFE@this?5?$CB?$DN?5pContext?$AA@ 00ab ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 00bc ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 00d9 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 00ef ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 0114 ??_C@_0BM@NJCPMCBK@m_pVirtualProcessor?5?$DN?$DN?5NULL?$AA@ 0136 ??_C@_0BB@INOLNPNI@m_pGroup?5?$CB?$DN?5NULL?$AA@ 0149 ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 0161 ??_C@_0M@CIBACOAC@IsBlocked?$CI?$CJ?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 89 4D EC 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? C7 45 F0 00 00 00 00 8D 4D F4 E8 ?? ?? ?? ?? 8B 45 EC 8B 48 1C 51 8D 55 F4 52 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 23 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 89 45 F0 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? EB 28 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 4D EC 8B 49 1C E8 ?? ?? ?? ?? 89 45 F0 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8B 55 EC 3B 55 F0 74 02 EB 17 68 F6 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 03 8B 45 F0 50 8B 4D EC E8 ?? ?? ?? ?? 83 7D EC 00 74 0B 8B 4D EC 83 C1 04 89 4D E8 EB 07 C7 45 E8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E8 75 02 EB 17 68 FA 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC E8 ?? ?? ?? ?? 85 C0 75 02 EB 17 68 FB 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 EC 83 7A 1C 00 74 02 EB 17 68 FC 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 FD 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_61_0 {
	meta:
		name = "?RejoinScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 220
		refs = "0012 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002f ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0040 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0045 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 004a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0055 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 006a ??_C@_0BM@NJCPMCBK@m_pVirtualProcessor?5?$DN?$DN?5NULL?$AA@ 008c ??_C@_0BB@INOLNPNI@m_pGroup?5?$CB?$DN?5NULL?$AA@ 009f ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 00b7 ??_C@_0M@CIBACOAC@IsBlocked?$CI?$CJ?$AA@ 00c9 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 00d4 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 83 7D FC 00 74 0B 8B 45 FC 83 C0 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 17 68 0A 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 02 EB 17 68 0B 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 79 1C 00 74 02 EB 17 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 02 EB 17 68 0D 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 03 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_62_0 {
	meta:
		name = "?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 905
		refs = "0065 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 006a ??_C@_0BO@MJNOJINI@?$CBm_fIsVisibleVirtualProcessor?$AA@ 006f ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0092 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0099 ?IsAvailable@VirtualProcessor@details@Concurrency@@QAE_NXZ 00b1 ??_C@_0CE@OFIOPOKH@?$CBm_pVirtualProcessor?9?$DOIsAvailabl@ 00d2 ?MakeAvailable@VirtualProcessor@details@Concurrency@@QAEXXZ 00e5 ?EnsureAllTasksVisible@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z 0104 ??_C@_0BB@EGOIAIAM@m_fCanceled?5?$DN?$DN?50?$AA@ 0131 ??_C@_0CB@FLPMDFHM@m_searchCount?5?$DN?$DN?5numSearches?5?$CL?51@ 0158 ??_C@_0BN@BPDGPIEH@m_fIsVisibleVirtualProcessor?$AA@ 01b5 ?VirtualProcessorIdle@SchedulerBase@details@Concurrency@@QAEX_N@Z 01ce ?InFinalizationSweep@SchedulerBase@details@Concurrency@@QAE_NXZ 01e0 ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 01f6 ??_C@_0FM@CGGKAMIF@?$CBm_fCanceled?5?$HM?$HM?5m_pScheduler?9?$DOIn@ 020d ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 0225 ??_C@_0N@DCFJDMJP@?$CBIsBlocked?$CI?$CJ?$AA@ 0240 ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z 026f ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z 034c ?GetExecutingContext@VirtualProcessor@details@Concurrency@@QAEPAUIExecutionContext@3@XZ 0362 ??_C@_0DD@NNBNBLMD@m_pVirtualProcessor?9?$DOGetExecutin@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 89 4D F4 C7 45 FC 00 01 00 00 8B 45 F4 8B 88 90 00 00 00 83 C1 01 8B 55 F4 89 8A 90 00 00 00 8B 45 F4 81 B8 90 00 00 00 00 01 00 00 73 45 8B 4D F4 8B 91 80 00 00 00 89 55 F0 8B 45 F0 8B 10 8B 4D F0 8B 42 0C FF D0 8B 4D F4 0F B6 91 96 00 00 00 85 D2 75 02 EB 17 68 37 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 0A 03 00 00 8B 45 F4 81 B8 90 00 00 00 00 01 00 00 0F 85 87 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 02 EB 17 68 3E 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F4 C6 82 96 00 00 00 01 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 F4 50 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D F4 0F B6 91 94 00 00 00 85 D2 75 02 EB 17 68 4F 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 70 02 00 00 8B 45 F4 81 B8 90 00 00 00 01 01 00 00 75 02 EB 17 68 53 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 0F B6 91 96 00 00 00 85 D2 74 02 EB 17 68 54 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 8A 88 97 00 00 00 D0 E9 80 E1 01 0F B6 D1 85 D2 74 33 8B 45 F4 8B 88 90 00 00 00 83 E9 01 8B 55 F4 89 8A 90 00 00 00 8B 45 F4 8B 88 80 00 00 00 89 4D EC 8B 55 EC 8B 02 8B 4D EC 8B 50 0C FF D2 E9 D9 01 00 00 6A 01 8B 45 F4 8B 48 20 E8 ?? ?? ?? ?? 8B 4D F4 0F B6 91 94 00 00 00 85 D2 74 3B 8B 45 F4 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 29 8B 55 F4 8B 4A 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 17 68 6E 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C6 45 FB 00 8B 4D F4 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 02 EB 17 68 7A 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F4 52 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 13 C6 45 FB 01 8B 4D F4 8B 11 8B 4D F4 8B 42 24 FF D0 EB D3 0F B6 4D FB 85 C9 74 0D 68 00 40 00 00 8B 4D F4 E8 ?? ?? ?? ?? 8B 55 F4 0F B6 82 94 00 00 00 85 C0 74 3B 8B 4D F4 8B 49 20 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 29 8B 45 F4 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 17 68 98 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 55 F4 8B 4A 20 E8 ?? ?? ?? ?? 8B 45 F4 0F B6 88 94 00 00 00 85 C9 74 3B 8B 55 F4 8B 4A 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 29 8B 4D F4 8B 49 20 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 17 68 AA 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 AC 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 3B 45 F4 75 02 EB 17 68 AD 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F4 C6 81 96 00 00 00 00 8B 55 F4 C7 82 90 00 00 00 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_63_0 {
	meta:
		name = "?GetExecutingContext@VirtualProcessor@details@Concurrency@@QAEPAUIExecutionContext@3@XZ"
		size = 19
		altNames = "?GetId@UMSFreeVirtualProcessorRoot@details@Concurrency@@UBEIXZ ?GetIndirectAlias@ContextBase@details@Concurrency@@QBEPAV_TaskCollection@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 6C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_64_0 {
	meta:
		name = "?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 178
		refs = "0040 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 005c ?_Invoke@_UnrealizedChore@details@Concurrency@@QAEXXZ 0072 ?Invoke@RealizedChore@details@Concurrency@@QAEXXZ 0081 ?ReleaseRealizedChore@SchedulerBase@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 008c ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00a4 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 B8 8C 00 00 00 00 0F 84 91 00 00 00 0F 31 8B 4D F8 89 81 98 00 00 00 89 91 9C 00 00 00 8B 55 F8 C7 82 A8 00 00 00 00 00 00 00 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? 8B 45 F8 0F B6 88 95 00 00 00 85 C9 74 10 8B 55 F8 8B 8A 8C 00 00 00 E8 ?? ?? ?? ?? EB 23 8B 45 F8 8B 88 8C 00 00 00 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 55 FC 52 8B 45 F8 8B 48 20 E8 ?? ?? ?? ?? 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F8 C7 81 8C 00 00 00 00 00 00 00 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? B0 01 EB 02 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_65_0 {
	meta:
		name = "?_Invoke@_UnrealizedChore@details@Concurrency@@QAEXXZ"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 50 8B 4D FC 8B 51 0C FF D2 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_66_0 {
	meta:
		name = "?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 154
		refs = "0024 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0035 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003a ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 003f ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0061 ??_C@_0M@MEHAMLOG@m_fCanceled?$AA@ 0074 ?SetShutdownValidations@ContextBase@details@Concurrency@@QAEXXZ 007f ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0087 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 0092 ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 83 7D FC 00 74 0B 8B 45 FC 83 C0 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 17 68 E0 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 0F B6 91 94 00 00 00 85 D2 74 02 EB 17 68 E1 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 20 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_67_0 {
	meta:
		name = "?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 145
		refs = "0024 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0035 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003a ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 003f ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0058 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 005f ?IsMarkedForRetirement@VirtualProcessor@details@Concurrency@@QAE_NXZ 0070 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 0083 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F8 83 7D F8 00 74 0B 8B 45 F8 83 C0 04 89 45 F4 EB 07 C7 45 F4 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F4 75 02 EB 17 68 03 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 0F B6 91 96 00 00 00 85 D2 75 37 8B 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 21 6A 00 8B 4D F8 E8 ?? ?? ?? ?? 88 45 FF 0F B6 4D FF 85 C9 74 08 8B 4D F8 E8 ?? ?? ?? ?? B0 01 EB 02 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_68_0 {
	meta:
		name = "?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z"
		size = 75
		refs = "0018 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 001f ?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 002e ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C 51 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 19 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 81 90 00 00 00 00 00 00 00 B0 01 EB 02 32 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_69_0 {
	meta:
		name = "?SwitchToRunnableContext@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 110
		refs = "000f ?IsContext@WorkItem@details@Concurrency@@QBE_NXZ 0022 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0027 ??_C@_0BD@DIJGMOHB@pWork?9?$DOIsContext?$CI?$CJ?$AA@ 002c ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0037 ?GetContext@WorkItem@details@Concurrency@@QBEPAVInternalContextBase@23@XZ 0042 ?GetDebugBits@InternalContextBase@details@Concurrency@@QBEKXZ 0056 ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z 0064 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 37 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 E8 ?? ?? ?? ?? 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? 25 00 01 00 00 74 0D 68 00 00 40 00 8B 4D FC E8 ?? ?? ?? ?? 6A 00 8B 4D FC 51 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_70_0 {
	meta:
		name = "?GetDebugBits@InternalContextBase@details@Concurrency@@QBEKXZ"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 AC 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_71_0 {
	meta:
		name = "?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 192
		refs = "000d ?IsContext@WorkItem@details@Concurrency@@QBE_NXZ 0020 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0025 ??_C@_0BE@JCNAPHNO@?$CBpWork?9?$DOIsContext?$CI?$CJ?$AA@ 002a ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0057 ?TransferReferences@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 005f ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 006a ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0090 ??_C@_0DB@DDJEDPDL@GetCriticalRegionType?$CI?$CJ?5?$DN?$DN?5Outsi@ 0095 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 00a0 ?Invoke@WorkItem@details@Concurrency@@QAEXXZ 00ab ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00b6 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 57 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 0F 31 8B 4D FC 89 81 98 00 00 00 89 91 9C 00 00 00 8B 55 FC C7 82 A8 00 00 00 00 00 00 00 8B 45 FC 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 8B 55 FC 8B 42 04 8B 50 3C FF D2 85 C0 75 02 EB 17 68 67 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_72_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 72
		refs = "0012 ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ 0023 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z 002d ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C 6A 01 8B 4D FC E8 ?? ?? ?? ?? EB 1B 8B 4D FC E8 ?? ?? ?? ?? 83 C0 60 89 45 F8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_74_0 {
	meta:
		name = "?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z"
		size = 694
		refs = "000d __imp__GetCurrentThreadId@0 002d ?SetAsCurrentTls@ContextBase@details@Concurrency@@IAEXXZ 0038 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0050 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0055 ??_C@_0BH@MFNLHCGI@m_pThreadProxy?5?$CB?$DN?5NULL?$AA@ 005a ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0068 ?IsBlocked@ContextBase@details@Concurrency@@QBE_NXZ 0080 ??_C@_0N@DCFJDMJP@?$CBIsBlocked?$CI?$CJ?$AA@ 00a7 ??_C@_0BO@MJNOJINI@?$CBm_fIsVisibleVirtualProcessor?$AA@ 00ce ??_C@_0N@NODJNJHL@?$CBm_fCanceled?$AA@ 00ef ?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ 00fe ?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ 0115 ??0WorkItem@details@Concurrency@@QAE@XZ 0131 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0156 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0167 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 017f ??_C@_0GD@LAENOMPF@?$CISchedulerBase?3?3FastCurrentConte@ 0192 ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ 01aa ??_C@_0BJ@MDEHBLFD@IsInsideCriticalRegion?$CI?$CJ?$AA@ 01bd ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 01c5 ??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ 01ca __TI2?AVnested_scheduler_missing_detach@Concurrency@@ 01d3 __CxxThrowException@8 01f0 ?SafePoint@VirtualProcessor@details@Concurrency@@QAE_NXZ 020d ?CommitSafePoints@SchedulerBase@details@Concurrency@@QAEXXZ 0224 ?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z 0233 ?IsContext@WorkItem@details@Concurrency@@QBE_NXZ 0246 ?SwitchToRunnableContext@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z 0258 ?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z 0282 ?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ 0298 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ 02ac ?ClearContextTls@ContextBase@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 89 4D E0 FF 15 ?? ?? ?? ?? 8B 4D E0 89 41 3C 8B 55 E0 8B 45 E0 8B 48 3C 89 8A B0 00 00 00 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8B 55 E0 83 BA 80 00 00 00 00 74 02 EB 17 68 83 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 84 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E0 0F B6 91 96 00 00 00 85 D2 75 02 EB 17 68 85 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 E0 0F B6 88 94 00 00 00 85 C9 75 02 EB 17 68 86 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E0 C7 82 90 00 00 00 00 00 00 00 C6 45 FF 00 8B 4D E0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0B 8B 4D E0 E8 ?? ?? ?? ?? 88 45 FF 0F B6 4D FF 85 C9 0F 85 94 01 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 E0 8A 82 97 00 00 00 24 FD 8B 4D E0 88 81 97 00 00 00 8B 4D E0 E8 ?? ?? ?? ?? 85 C0 0F 85 9A 00 00 00 83 7D E0 00 74 0B 8B 55 E0 83 C2 04 89 55 DC EB 07 C7 45 DC 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 DC 74 15 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 A2 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 17 68 A3 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 E4 52 E8 ?? ?? ?? ?? 8B 45 E0 0F B6 88 96 00 00 00 85 C9 75 37 8B 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 21 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8B 45 E0 8B 48 20 E8 ?? ?? ?? ?? 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8D 4D F0 51 8B 4D E0 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 3A 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 12 8D 4D F0 51 8B 4D E0 E8 ?? ?? ?? ?? C6 45 FF 01 EB 17 8D 55 F0 52 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 E8 ?? ?? ?? ?? 88 45 FF EB 37 8B 4D E0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 06 C6 45 FF 01 EB 22 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 0F B6 91 94 00 00 00 85 D2 74 0C 8B 4D E0 E8 ?? ?? ?? ?? C6 45 FF 01 E9 60 FE FF FF 8B 4D E0 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_78_0 {
	meta:
		name = "?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 290
		refs = "001f ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0026 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 003c ?GetExecutingContext@VirtualProcessor@details@Concurrency@@QAEPAUIExecutionContext@3@XZ 004d ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0052 ??_C@_0DD@NNBNBLMD@m_pVirtualProcessor?9?$DOGetExecutin@ 0057 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 006d ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z 0092 ?IsAvailable@VirtualProcessor@details@Concurrency@@QAE_NXZ 00aa ??_C@_0CE@OFIOPOKH@?$CBm_pVirtualProcessor?9?$DOIsAvailabl@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 88 96 00 00 00 85 C9 0F 84 A7 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 56 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 F3 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 0F 8B 55 FC 8B 02 8B 4D FC 8B 50 24 FF D2 EB D7 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 17 68 FC 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC C6 81 96 00 00 00 00 EB 5C 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 02 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 03 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_79_0 {
	meta:
		name = "?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 36
		refs = "0010 ?Cleanup@ContextBase@details@Concurrency@@QAEXXZ 001c ?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_80_0 {
	meta:
		name = "?Cancel@InternalContextBase@details@Concurrency@@MAEXXZ"
		size = 370
		refs = "0021 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0026 ??_C@_0N@NODJNJHL@?$CBm_fCanceled?$AA@ 002b ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0039 ?InFinalizationSweep@SchedulerBase@details@Concurrency@@QAE_NXZ 0051 ??_C@_0CE@MFMLGIGD@m_pScheduler?9?$DOInFinalizationSwee@ 0061 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0082 ?GetExecutingContext@VirtualProcessor@details@Concurrency@@QAEPAUIExecutionContext@3@XZ 0098 ??_C@_0DD@NNBNBLMD@m_pVirtualProcessor?9?$DOGetExecutin@ 00bf ??_C@_0BN@BPDGPIEH@m_fIsVisibleVirtualProcessor?$AA@ 00d6 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 00f0 ?Activate@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z 013e ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0157 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 015f ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 016a ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 0F B6 88 94 00 00 00 85 C9 75 02 EB 17 68 17 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 4A 20 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 18 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 85 C0 0F 84 B8 00 00 00 8B 4D FC C6 81 94 00 00 00 01 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 3B 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 0F B6 82 96 00 00 00 85 C0 74 02 EB 17 68 48 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 15 8B 55 FC 52 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 2D 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 52 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 49 83 7D FC 00 74 0B 8B 45 FC 83 C0 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 0C 8B 4D FC C6 81 94 00 00 00 01 EB 1B 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 55 FC 8B 4A 20 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_81_0 {
	meta:
		name = "??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 107
		refs = "0008 __ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ 0015 ___security_cookie 002d ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 0037 ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@ 0046 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 0058 ??1ContextBase@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 C7 41 04 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 83 C1 04 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_84_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "0010 ??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_85_0 {
	meta:
		name = "?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAU_Chore@23@_N@Z"
		size = 278
		refs = "001a ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 001f ??_C@_0BB@KGPPPLLM@m_pGroup?5?$DN?$DN?5NULL?$AA@ 0024 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0044 ??_C@_0BL@MDNLNDEM@m_pAssociatedChore?5?$DN?$DN?5NULL?$AA@ 0066 ??_C@_0BF@NJOPJGNF@m_pWorkQueue?5?$DN?$DN?5NULL?$AA@ 0088 ??_C@_0BJ@LOCPBGOL@m_pParentContext?5?$DN?$DN?5NULL?$AA@ 00af ??_C@_07GCODBHCP@m_fIdle?$AA@ 00d8 ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 78 1C 00 75 02 EB 17 68 82 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 B9 8C 00 00 00 00 75 02 EB 17 68 83 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 83 7A 24 00 75 02 EB 17 68 84 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 83 78 28 00 75 02 EB 17 68 85 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 0F B6 91 CC 00 00 00 85 D2 74 02 EB 17 68 88 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC C6 80 CC 00 00 00 00 8B 4D FC 8B 55 08 89 51 1C 83 7D 0C 00 75 0A 8B 4D 08 E8 ?? ?? ?? ?? EB 32 0F B6 45 10 85 C0 74 14 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC C6 81 95 00 00 00 01 EB 0A 8B 55 FC C6 82 95 00 00 00 00 8B 45 FC 8B 4D 0C 89 88 8C 00 00 00 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_100_86_0 {
	meta:
		name = "?RemoveFromUse@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 258
		refs = "0010 ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ 0023 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0028 ??_C@_0BJ@MDEHBLFD@IsInsideCriticalRegion?$CI?$CJ?$AA@ 002d ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0044 ?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ 0059 ??_C@_0CP@OCJAGJJA@m_pGroup?5?$CB?$DN?5NULL?5?$CG?$CG?5ScheduleGrou@ 005e ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 007e ??_C@_0BL@MDNLNDEM@m_pAssociatedChore?5?$DN?$DN?5NULL?$AA@ 0091 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 00ab ??_C@_0BJ@LOCPBGOL@m_pParentContext?5?$DN?$DN?5NULL?$AA@ 00bf ?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z 00de ??_C@_08HEECEKAI@?$CBm_fIdle?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 02 EB 17 68 AC 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 79 1C 00 74 11 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 85 C0 76 02 EB 17 68 B4 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 83 BA 8C 00 00 00 00 75 02 EB 17 68 B5 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 45 FC 83 78 28 00 75 02 EB 17 68 B9 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 0F B6 91 CC 00 00 00 85 D2 75 02 EB 17 68 BF 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC C6 80 CC 00 00 00 01 8B 4D FC C7 41 3C 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_87_0 {
	meta:
		name = "?GetId@InternalContextBase@details@Concurrency@@UBEIXZ"
		size = 19
		altNames = "?GetResourceManager@SchedulerProxy@details@Concurrency@@QBEPAVResourceManager@23@XZ ?GetSchedulingProtocol@SchedulerBase@details@Concurrency@@QAE?AW4SchedulingProtocolType@3@XZ ?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ ?rdstate@ios_base@std@@QBEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_88_0 {
	meta:
		name = "?GetScheduler@InternalContextBase@details@Concurrency@@UAEPAUIScheduler@3@XZ"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 20 8B 81 F0 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_89_0 {
	meta:
		name = "?GetProxy@InternalContextBase@details@Concurrency@@UAEPAUIThreadProxy@3@XZ"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 80 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_90_0 {
	meta:
		name = "?GetThreadId@InternalContextBase@details@Concurrency@@UBEKXZ"
		size = 49
		refs = "0010 ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ 0029 ?GetThreadId@ThreadProxy@details@Concurrency@@QBEKXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 07 83 C8 FF EB 0D EB 0B 8B 55 FC 8B 4A 7C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_91_0 {
	meta:
		name = "?GetThreadId@ThreadProxy@details@Concurrency@@QBEKXZ"
		size = 19
		altNames = "?GetExecutionResourceId@ExecutionResource@details@Concurrency@@UBEIXZ ?GetPriority@UMSThreadProxy@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 2C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_92_0 {
	meta:
		name = "?SetProxy@InternalContextBase@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 98
		refs = "0012 ??_C@_0N@FACDCNDA@pThreadProxy?$AA@ 001a ??0invalid_argument@std@@QAE@PBD@Z 001f __TI3?AVinvalid_argument@std@@ 0028 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F0 83 7D 08 00 75 1B 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 4D F0 8B 55 08 89 91 80 00 00 00 8B 45 F0 8B 4D F0 8B 91 BC 00 00 00 89 90 C0 00 00 00 8B 45 F0 8B 88 80 00 00 00 8B 55 F0 89 8A BC 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_101_0 {
	meta:
		name = "?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 251
		refs = "0008 __ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___security_cookie 0049 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 005a ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 005f ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 0064 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 008a ??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z 009c ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 00a3 ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 00bd ??_C@_0BD@BEKCNOGK@pAllocator?5?$CB?$DN?5NULL?$AA@ 00d1 ?Alloc@SubAllocator@details@Concurrency@@QAEPAXI@Z 00e3 ??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E4 C7 45 F0 00 00 00 00 8B 45 E4 83 E8 04 74 08 8B 4D E4 89 4D E0 EB 07 C7 45 E0 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 E0 75 02 EB 17 68 18 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E4 83 EA 04 74 08 8B 45 E4 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 4D DC 51 8D 4D E8 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E4 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 74 02 EB 17 68 20 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 52 8B 4D EC E8 ?? ?? ?? ?? 89 45 F0 C7 45 FC FF FF FF FF 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_103_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_41_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_496_2_6 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_65_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_20_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_118_0 {
	meta:
		name = "__ehhandler$?CloneAndReset@GlobalNode@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CloneAndReset@GlobalNode@details@Concurrency@@QAEXPAUSchedulerNode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_706_23_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_171_0 {
	meta:
		name = "__ehhandler$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_597_129_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_616_3 {
	meta:
		name = "__ehhandler$?_Dequeue@?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAEPAV?$message@I@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Dequeue@?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAEPAV?$message@I@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_579_1 {
	meta:
		name = "__ehhandler$?_Dequeue@?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEPAV?$message@W4agent_status@Concurrency@@@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Dequeue@?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEPAV?$message@W4agent_status@Concurrency@@@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_385_1 {
	meta:
		name = "__ehhandler$?_Enqueue@?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE_NPAV?$message@I@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Enqueue@?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE_NPAV?$message@I@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_330_3 {
	meta:
		name = "__ehhandler$?_Enqueue@?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE_NPAV?$message@W4agent_status@Concurrency@@@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Enqueue@?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE_NPAV?$message@W4agent_status@Concurrency@@@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_283_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_930_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_683_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_381_2 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_326_1 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_420_2 {
	meta:
		name = "__ehhandler$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?count@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_4_3 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_106_0 {
	meta:
		name = "?Free@InternalContextBase@details@Concurrency@@UAEXPAX@Z"
		size = 186
		refs = "0023 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0034 ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0039 ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 003e ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0058 ??_C@_0BE@MJCKCMCL@pAllocation?5?$CB?$DN?5NULL?$AA@ 0068 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0073 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 007a ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0094 ??_C@_0BD@BEKCNOGK@pAllocator?5?$CB?$DN?5NULL?$AA@ 00a8 ?Free@SubAllocator@details@Concurrency@@QAEXPAX@Z 00b0 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 83 E8 04 74 08 8B 4D F8 89 4D F4 EB 07 C7 45 F4 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F4 75 02 EB 17 68 30 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 74 02 EB 17 68 31 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 83 E9 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 02 EB 17 68 36 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_107_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 160
		refs = "0012 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001a ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 002a ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 002f ??_C@_0BM@PCDLOGHO@m_pVirtualProcessor?5?$CB?$DN?5NULL?$AA@ 0034 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0054 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 006a ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 0098 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 02 EB 17 68 44 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 0B 8B 45 FC 83 C0 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 17 68 45 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 83 C0 5C 89 45 F4 8B 4D F4 8B 11 83 C2 01 8B 45 F4 89 10 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_108_0 {
	meta:
		name = "?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z"
		size = 162
		refs = "0012 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001a ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 002a ??_C@_0DP@DDPADJEA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 002f ??_C@_0BM@PCDLOGHO@m_pVirtualProcessor?5?$CB?$DN?5NULL?$AA@ 0034 ?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z 0054 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 006a ??_C@_0CM@EFMPELDC@SchedulerBase?3?3FastCurrentContex@ 0098 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 02 EB 17 68 53 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 0B 8B 45 FC 83 C0 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 E8 ?? ?? ?? ?? 3B 45 F8 75 02 EB 17 68 54 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC E8 ?? ?? ?? ?? 83 C0 60 89 45 F4 8B 4D F4 8B 11 03 55 08 8B 45 F4 89 10 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_111_0 {
	meta:
		name = "?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ"
		size = 26
		altNames = "?Count@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 8B 4D FC 8B 11 2B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_112_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 89
		refs = "004f ?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 04 89 4D FC 8B 55 F8 8B 02 8B 4D F8 03 41 08 39 45 FC 7D 23 8B 55 F8 8B 45 FC 23 42 08 8B 4D F8 8B 51 0C 8B 4D 08 89 0C 82 8B 55 FC 83 C2 01 8B 45 F8 89 50 04 EB 0C 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_671_87_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 89
		refs = "004f ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 04 89 4D FC 8B 55 F8 8B 02 8B 4D F8 03 41 08 39 45 FC 7D 23 8B 55 F8 8B 45 FC 23 42 08 8B 4D F8 8B 51 0C 8B 4D 08 89 0C 82 8B 55 FC 83 C2 01 8B 45 F8 89 50 04 EB 0C 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_113_0 {
	meta:
		name = "??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
		size = 36
		refs = "000d ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 0019 ?Free@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_321_0 {
	meta:
		name = "??1?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 36
		refs = "000d ?Wipe@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ 0019 ?Free@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_118_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z"
		size = 360
		refs = "0008 __ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z 0018 ___security_cookie 004d ??_U@YAPAXI@Z 0071 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0091 ?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ 00e9 _memset 0140 ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ 014f ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D C8 8B 45 C8 8B 48 08 8D 54 09 02 89 55 EC 33 C9 8B 45 EC BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 8B 45 D0 89 45 F0 8B 4D C8 8B 51 0C 89 55 E8 8B 45 C8 8B 48 10 51 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 55 C8 8B 42 04 89 45 D8 8B 4D C8 8B 11 89 55 E0 8B 4D C8 E8 ?? ?? ?? ?? 89 45 E4 C7 45 D4 00 00 00 00 EB 09 8B 45 D4 83 C0 01 89 45 D4 8B 4D D4 3B 4D E4 7D 20 8B 55 D4 03 55 E0 8B 45 C8 23 50 08 8B 4D C8 8B 41 0C 8B 4D D4 8B 75 F0 8B 14 90 89 14 8E EB CF 8B 45 EC 2B 45 E4 C1 E0 02 50 6A 00 8B 4D E4 8B 55 F0 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D C8 8B 55 F0 89 51 0C 8B 45 C8 C7 00 00 00 00 00 8B 4D E4 89 4D D8 8B 55 EC 83 EA 01 8B 45 C8 89 50 08 8B 4D C8 8B 55 D8 23 51 08 8B 45 C8 8B 48 0C 8B 45 08 89 04 91 8B 4D D8 83 C1 01 8B 55 C8 89 4A 04 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 E8 89 45 CC 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_671_134_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z"
		size = 360
		refs = "0008 __ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z 0018 ___security_cookie 004d ??_U@YAPAXI@Z 0071 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0091 ?Count@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBEHXZ 00e9 _memset 0140 ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ 014f ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D C8 8B 45 C8 8B 48 08 8D 54 09 02 89 55 EC 33 C9 8B 45 EC BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 8B 45 D0 89 45 F0 8B 4D C8 8B 51 0C 89 55 E8 8B 45 C8 8B 48 10 51 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 55 C8 8B 42 04 89 45 D8 8B 4D C8 8B 11 89 55 E0 8B 4D C8 E8 ?? ?? ?? ?? 89 45 E4 C7 45 D4 00 00 00 00 EB 09 8B 45 D4 83 C0 01 89 45 D4 8B 4D D4 3B 4D E4 7D 20 8B 55 D4 03 55 E0 8B 45 C8 23 50 08 8B 4D C8 8B 41 0C 8B 4D D4 8B 75 F0 8B 14 90 89 14 8E EB CF 8B 45 EC 2B 45 E4 C1 E0 02 50 6A 00 8B 4D E4 8B 55 F0 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D C8 8B 55 F0 89 51 0C 8B 45 C8 C7 00 00 00 00 00 8B 4D E4 89 4D D8 8B 55 EC 83 EA 01 8B 45 C8 89 50 08 8B 4D C8 8B 55 D8 23 51 08 8B 45 C8 8B 48 0C 8B 45 08 89 04 91 8B 4D D8 83 C1 01 8B 55 C8 89 4A 04 C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 45 E8 89 45 CC 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_123_0 {
	meta:
		name = "?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
		size = 139
		refs = "0052 ?FreeNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAUListNode@123@@Z 0080 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F0 8B 45 F0 83 78 04 00 7E 73 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 8B 45 FC 3B 02 7D 33 8B 4D F0 8B 51 08 8B 45 FC 8B 0C 82 89 4D F8 83 7D F8 00 74 1C 8B 55 F8 8B 02 89 45 F4 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 89 55 F8 EB DE EB BA 8B 45 F0 C7 40 04 00 00 00 00 8B 4D F0 8B 11 C1 E2 02 52 6A 00 8B 45 F0 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_303_336_0 {
	meta:
		name = "?Wipe@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 139
		refs = "0052 ?FreeNode@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXPAUListNode@123@@Z 0080 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 89 4D F0 8B 45 F0 83 78 04 00 7E 73 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 8B 45 FC 3B 02 7D 33 8B 4D F0 8B 51 08 8B 45 FC 8B 0C 82 89 4D F8 83 7D F8 00 74 1C 8B 55 F8 8B 02 89 45 F4 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F4 89 55 F8 EB DE EB BA 8B 45 F0 C7 40 04 00 00 00 00 8B 4D F0 8B 11 C1 E2 02 52 6A 00 8B 45 F0 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_126_0 {
	meta:
		name = "?FreeNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAUListNode@123@@Z"
		size = 49
		refs = "000d ?DeleteKey@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXAAPAV_TaskCollection@23@@Z 001c ?DeleteValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXAAPAV_TaskCollection@23@@Z 0028 ?Free@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_303_341_0 {
	meta:
		name = "?FreeNode@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXPAUListNode@123@@Z"
		size = 49
		refs = "000d ?DeleteKey@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXAAPAX@Z 001c ?DeleteValue@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXAAPAVExternalContextBase@23@@Z 0028 ?Free@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@CAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__mbslen_l"
		size = 173
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002a _strlen 0038 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 1C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E8 EB 68 C7 45 FC 00 00 00 00 EB 12 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 0F B6 02 85 C0 74 32 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 8B 55 08 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 08 83 C2 01 89 55 08 8B 45 08 0F B6 08 85 C9 75 02 EB 02 EB B2 8B 55 FC 89 55 E4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 169
		refs = "000a __imp__GetEnvironmentStringsW@0 005b ??_C@_0CP@EFGFBBJB@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0066 __malloc_dbg 007c __imp__FreeEnvironmentStringsW@4 0091 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 87 00 00 00 8B 45 FC 89 45 F8 8B 4D F8 0F B7 11 85 D2 74 1E 8B 45 F8 83 C0 02 89 45 F8 8B 4D F8 0F B7 11 85 D2 75 09 8B 45 F8 83 C0 02 89 45 F8 EB D8 8B 4D F8 2B 4D FC 83 C1 02 89 4D F4 6A 3B 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 75 0E 8B 45 FC 50 FF 15 ?? ?? ?? ?? 33 C0 EB 21 8B 4D F4 51 8B 55 FC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 51 FF 15 ?? ?? ?? ?? 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_memcmp"
		size = 440
		refs = "002a $LN22 0037 _cmpBYTE 0198 _unaligned_memcmp 01a4 $LN1 01a8 $LN2 01ac $LN3 01b0 $LN4 01b4 $LN5"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 10 89 55 F0 83 7D F0 04 0F 87 67 01 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 EC EB 73 8B 4D F8 83 C1 01 51 8B 55 FC 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E8 EB 46 8B 4D F8 83 C1 02 51 8B 55 FC 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E4 EB 19 8B 4D F8 83 C1 03 51 8B 55 FC 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 45 E4 89 45 E8 8B 4D E8 89 4D EC 8B 45 EC E9 D5 00 00 00 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D E0 EB 46 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D DC EB 19 8B 55 F8 83 C2 02 52 8B 45 FC 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8B 4D DC 89 4D E0 8B 45 E0 EB 69 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D D8 EB 19 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 8B 45 D8 EB 2A 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 18 33 C0 EB 14 8B 45 10 50 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "_cmpBYTE"
		size = 47
		refs = "0024 _cmpResult"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 2B C2 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "_cmpResult"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 10 33 C0 83 7D 08 00 0F 9F C0 8D 44 00 FF 89 45 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 1800
		refs = "001b _cmpDWORD 018c $LN79 03c8 _cmpBYTE 04f4 _cmpWORD 0688 $LN46 068c $LN31 0690 $LN16 0694 $LN1 0698 $LN48 069c $LN33 06a0 $LN18 06a4 $LN3 06a8 $LN50 06ac $LN35 06b0 $LN20 06b4 $LN5 06b8 $LN52 06bc $LN37 06c0 $LN22 06c4 $LN7 06c8 $LN54 06cc $LN39 06d0 $LN24 06d4 $LN9 06d8 $LN56 06dc $LN41 06e0 $LN26 06e4 $LN11 06e8 $LN58 06ec $LN43 06f0 $LN28 06f4 $LN13 06f8 $LN60 06fc $LN45 0700 $LN30 0704 $LN15"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 20 0F 82 52 01 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 4F 06 00 00 8B 55 0C 83 C2 04 52 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 28 06 00 00 8B 4D 0C 83 C1 08 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 01 06 00 00 8B 45 0C 83 C0 0C 50 8B 4D 08 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 DA 05 00 00 8B 55 0C 83 C2 10 52 8B 45 08 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 05 00 00 8B 4D 0C 83 C1 14 51 8B 55 08 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 05 00 00 8B 45 0C 83 C0 18 50 8B 4D 08 83 C1 18 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 05 00 00 8B 55 0C 83 C2 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 05 00 00 8B 4D 08 83 C1 20 89 4D 08 8B 55 0C 83 C2 20 89 55 0C 8B 45 10 83 E8 20 89 45 10 E9 A4 FE FF FF 8B 4D 08 03 4D 10 89 4D 08 8B 55 0C 03 55 10 89 55 0C 8B 45 10 89 45 F8 83 7D F8 1F 0F 87 FA 04 00 00 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 83 EA 1C 52 8B 45 08 83 E8 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 CB 04 00 00 8B 4D 0C 83 E9 18 51 8B 55 08 83 EA 18 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 A4 04 00 00 8B 45 0C 83 E8 14 50 8B 4D 08 83 E9 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 7D 04 00 00 8B 55 0C 83 EA 10 52 8B 45 08 83 E8 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 56 04 00 00 8B 4D 0C 83 E9 0C 51 8B 55 08 83 EA 0C 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 2F 04 00 00 8B 45 0C 83 E8 08 50 8B 4D 08 83 E9 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 08 04 00 00 8B 55 0C 83 EA 04 52 8B 45 08 83 E8 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E1 03 00 00 33 C0 E9 DA 03 00 00 8B 4D 0C 83 E9 1D 51 8B 55 08 83 EA 1D 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 03 00 00 8B 45 0C 83 E8 19 50 8B 4D 08 83 E9 19 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 03 00 00 8B 55 0C 83 EA 15 52 8B 45 08 83 E8 15 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 03 00 00 8B 4D 0C 83 E9 11 51 8B 55 08 83 EA 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 03 00 00 8B 45 0C 83 E8 0D 50 8B 4D 08 83 E9 0D 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 17 03 00 00 8B 55 0C 83 EA 09 52 8B 45 08 83 E8 09 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 F0 02 00 00 8B 4D 0C 83 E9 05 51 8B 55 08 83 EA 05 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C9 02 00 00 8B 45 0C 83 E8 01 50 8B 4D 08 83 E9 01 51 E8 ?? ?? ?? ?? 83 C4 08 E9 AE 02 00 00 8B 55 0C 83 EA 1E 52 8B 45 08 83 E8 1E 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 87 02 00 00 8B 4D 0C 83 E9 1A 51 8B 55 08 83 EA 1A 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 60 02 00 00 8B 45 0C 83 E8 16 50 8B 4D 08 83 E9 16 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 39 02 00 00 8B 55 0C 83 EA 12 52 8B 45 08 83 E8 12 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 12 02 00 00 8B 4D 0C 83 E9 0E 51 8B 55 08 83 EA 0E 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 EB 01 00 00 8B 45 0C 83 E8 0A 50 8B 4D 08 83 E9 0A 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C4 01 00 00 8B 55 0C 83 EA 06 52 8B 45 08 83 E8 06 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 9D 01 00 00 8B 4D 0C 83 E9 02 51 8B 55 08 83 EA 02 52 E8 ?? ?? ?? ?? 83 C4 08 E9 82 01 00 00 8B 45 0C 83 E8 1F 50 8B 4D 08 83 E9 1F 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 5B 01 00 00 8B 55 0C 83 EA 1B 52 8B 45 08 83 E8 1B 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 34 01 00 00 8B 4D 0C 83 E9 17 51 8B 55 08 83 EA 17 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 0D 01 00 00 8B 45 0C 83 E8 13 50 8B 4D 08 83 E9 13 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E6 00 00 00 8B 55 0C 83 EA 0F 52 8B 45 08 83 E8 0F 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 BF 00 00 00 8B 4D 0C 83 E9 0B 51 8B 55 08 83 EA 0B 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 98 00 00 00 8B 45 0C 83 E8 07 50 8B 4D 08 83 E9 07 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 74 8B 55 0C 83 EA 03 52 8B 45 08 83 E8 03 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F4 EB 46 8B 55 0C 83 EA 02 52 8B 45 08 83 E8 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F0 EB 19 8B 55 0C 83 EA 01 52 8B 45 08 83 E8 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 8B 4D F0 89 4D F4 8B 45 F4 EB 02 33 C0 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "_cmpWORD"
		size = 117
		refs = "0039 _cmpBYTE"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B7 02 8B 4D F8 0F B7 11 3B C2 74 4B 8B 45 0C 89 45 F0 8B 4D 08 89 4D F4 8B 55 F0 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 4D EC 89 4D E8 EB 19 8B 55 F0 83 C2 01 52 8B 45 F4 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "_cmpDWORD"
		size = 207
		refs = "0039 _cmpBYTE"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 0C 89 45 FC 8B 4D 08 89 4D F8 8B 55 F8 8B 45 FC 8B 0A 3B 08 0F 84 A5 00 00 00 8B 55 0C 89 55 F0 8B 45 08 89 45 F4 8B 4D F0 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E8 EB 73 8B 4D F0 83 C1 01 51 8B 55 F4 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E4 EB 46 8B 4D F0 83 C1 02 51 8B 55 F4 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E0 EB 19 8B 4D F0 83 C1 03 51 8B 55 F4 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 8B 45 E0 89 45 E4 8B 4D E4 89 4D E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "__crt_debugger_hook"
		size = 17
		refs = "0007 __debugger_hook_dummy"
	strings:
		$1 = { 8B FF 55 8B EC C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__cwprintf_l"
		size = 36
		refs = "0019 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__cprintf_l"
		size = 36
		refs = "0019 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__cprintf_p_l"
		size = 36
		refs = "0019 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "__cprintf_s_l"
		size = 36
		refs = "0019 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_726_1_0 {
	meta:
		name = "__cscanf_l"
		size = 36
		refs = "0019 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_762_1_0 {
	meta:
		name = "__cscanf_s_l"
		size = 36
		refs = "0019 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 36
		refs = "0019 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_632_0_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 36
		refs = "0019 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_1_0 {
	meta:
		name = "__cwscanf_l"
		size = 36
		refs = "0019 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_696_1_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 36
		refs = "0019 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_463_1_0 {
	meta:
		name = "__printf_l"
		size = 36
		refs = "0019 __vprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_463_4_0 {
	meta:
		name = "__printf_p_l"
		size = 36
		refs = "0019 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_463_2_0 {
	meta:
		name = "__printf_s_l"
		size = 36
		refs = "0019 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_358_10_0 {
	meta:
		name = "__scprintf_l"
		size = 36
		refs = "0019 __vscprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_358_11_0 {
	meta:
		name = "__scprintf_p_l"
		size = 36
		refs = "0019 __vscprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_360_10_0 {
	meta:
		name = "__scwprintf_l"
		size = 36
		refs = "0019 __vscwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_360_11_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 36
		refs = "0019 __vscwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "__wprintf_l"
		size = 36
		refs = "0019 __vwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_4_0 {
	meta:
		name = "__wprintf_p_l"
		size = 36
		refs = "0019 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "__wprintf_s_l"
		size = 36
		refs = "0019 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__cwprintf"
		size = 34
		refs = "0017 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "__cprintf"
		size = 34
		refs = "0017 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "__cprintf_p"
		size = 34
		refs = "0017 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_493_1_0 {
	meta:
		name = "__cprintf_s"
		size = 34
		refs = "0017 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "__cscanf"
		size = 34
		refs = "0017 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_762_0_0 {
	meta:
		name = "__cscanf_s"
		size = 34
		refs = "0017 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__cwprintf_p"
		size = 34
		refs = "0017 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_632_1_0 {
	meta:
		name = "__cwprintf_s"
		size = 34
		refs = "0017 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "__cwscanf"
		size = 34
		refs = "0017 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_696_0_0 {
	meta:
		name = "__cwscanf_s"
		size = 34
		refs = "0017 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_463_5_0 {
	meta:
		name = "__printf_p"
		size = 34
		refs = "0017 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_5_0 {
	meta:
		name = "__wprintf_p"
		size = 34
		refs = "0017 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_463_3_0 {
	meta:
		name = "_printf_s"
		size = 34
		refs = "0017 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_3_0 {
	meta:
		name = "_wprintf_s"
		size = 34
		refs = "0017 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_2_0 {
	meta:
		name = "__vcwprintf"
		size = 25
		refs = "0010 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "__vcprintf"
		size = 25
		refs = "0010 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_188_2_0 {
	meta:
		name = "__vcprintf_p"
		size = 25
		refs = "0010 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_493_2_0 {
	meta:
		name = "__vcprintf_s"
		size = 25
		refs = "0010 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_280_2_0 {
	meta:
		name = "__vcwprintf_p"
		size = 25
		refs = "0010 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_632_2_0 {
	meta:
		name = "__vcwprintf_s"
		size = 25
		refs = "0010 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_106_3_0 {
	meta:
		name = "__vcwprintf_l"
		size = 4084
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BK@OGEKFAEL@?$AA_?$AAv?$AAc?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0161 ___lookuptable 01c5 $LN152 01e0 _write_char 024d $LN148 0254 $LN153 02a6 _get_int_arg 0363 $LN149 036a $LN154 049e $LN150 04a5 $LN155 04fd ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0522 __mbtowc_l 0582 ___nullstring 058e _strlen 0699 __isleadbyte_l 06ce ___wnullstring 0742 __get_printf_count_output 077e ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 08a0 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 08b1 __malloc_dbg 0923 __cfltcvt_tab 092a __imp__DecodePointer@4 0a60 _get_int64_arg 0c30 __aullrem 0c52 __aulldiv 0d67 _write_multi_char 0d7e _write_string 0eb4 __free_dbg 0ee7 @__security_check_cookie@4 0ef0 $NORMAL_STATE$30079 0ef4 $LN131 0ef8 $LN130 0efc $LN122 0f00 $LN118 0f04 $LN117 0f08 $LN113 0f0c $LN97 0f10 $LN125 0f14 $LN124 0f18 $LN126 0f1c $LN127 0f20 $LN123 0f24 $LN128 0f3c $LN107 0f40 $LN99 0f44 $LN110 0f48 $LN98 0f4c $LN111 0f80 $LN64 0f84 $LN94 0f88 $LN82 0f8c $LN46 0f90 $LN88 0f94 $LN63 0f98 $LN92 0f9c $LN51 0fa0 $LN69 0fa4 $LN41 0fa8 $LN47 0fac $LN80 0fb0 $LN49 0fb4 $LN44 0fb8 $LN95"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D8 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FB FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 0C 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FB FF FF 83 BD 9C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 4C FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 4C FB FF FF E9 FD 0D 00 00 C7 85 B4 FB FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FB FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 08 66 8B 08 66 89 8D AC FB FF FF 0F B7 95 AC FB FF FF 8B 45 08 83 C0 02 89 45 08 85 D2 0F 84 95 0D 00 00 83 BD B4 FB FF FF 00 0F 8C 88 0D 00 00 0F B7 8D AC FB FF FF 83 F9 20 7C 25 0F B7 95 AC FB FF FF 83 FA 78 7F 19 0F B7 85 AC FB FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 40 FB FF FF EB 0A C7 85 40 FB FF FF 00 00 00 00 8B 95 40 FB FF FF 89 95 B0 FB FF FF 8B 85 B0 FB FF FF 8B 8D A4 FB FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 A4 FB FF FF 8B 85 A4 FB FF FF 89 85 3C FB FF FF 83 BD 3C FB FF FF 07 0F 87 06 0D 00 00 8B 8D 3C FB FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 01 00 00 00 8D 95 B4 FB FF FF 52 0F B7 85 AC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 E9 D6 0C 00 00 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D8 8B 55 D8 89 55 E8 8B 45 E8 89 45 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 A3 0C 00 00 0F B7 8D AC FB FF FF 89 8D 38 FB FF FF 8B 95 38 FB FF FF 83 EA 20 89 95 38 FB FF FF 83 BD 38 FB FF FF 10 77 4C 8B 85 38 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 83 CA 04 89 55 F0 EB 2D 8B 45 F0 83 C8 01 89 45 F0 EB 22 8B 4D F0 83 C9 02 89 4D F0 EB 17 8B 55 F0 81 CA 80 00 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 08 89 45 F0 E9 2D 0C 00 00 0F B7 8D AC FB FF FF 83 F9 2A 75 28 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 45 F0 83 C8 04 89 45 F0 8B 4D E8 F7 D9 89 4D E8 EB 14 8B 55 E8 6B D2 0A 0F B7 85 AC FB FF FF 8D 4C 02 D0 89 4D E8 E9 E0 0B 00 00 C7 45 D0 00 00 00 00 E9 D4 0B 00 00 0F B7 95 AC FB FF FF 83 FA 2A 75 1E 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 4D D0 6B C9 0A 0F B7 95 AC FB FF FF 8D 44 11 D0 89 45 D0 E9 91 0B 00 00 0F B7 8D AC FB FF FF 89 8D 34 FB FF FF 8B 95 34 FB FF FF 83 EA 49 89 95 34 FB FF FF 83 BD 34 FB FF FF 2E 0F 87 0D 01 00 00 8B 85 34 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 08 0F B7 02 83 F8 6C 75 17 8B 4D 08 83 C1 02 89 4D 08 8B 55 F0 81 CA 00 10 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 10 89 45 F0 E9 C9 00 00 00 8B 4D 08 0F B7 11 83 FA 36 75 25 8B 45 08 0F B7 48 02 83 F9 34 75 19 8B 55 08 83 C2 04 89 55 08 8B 45 F0 0D 00 80 00 00 89 45 F0 E9 80 00 00 00 8B 4D 08 0F B7 11 83 FA 33 75 22 8B 45 08 0F B7 48 02 83 F9 32 75 16 8B 55 08 83 C2 04 89 55 08 8B 45 F0 25 FF 7F FF FF 89 45 F0 EB 53 8B 4D 08 0F B7 11 83 FA 64 74 37 8B 45 08 0F B7 08 83 F9 69 74 2C 8B 55 08 0F B7 02 83 F8 6F 74 21 8B 4D 08 0F B7 11 83 FA 75 74 16 8B 45 08 0F B7 08 83 F9 78 74 0B 8B 55 08 0F B7 02 83 F8 58 75 02 EB 0F C7 85 A4 FB FF FF 00 00 00 00 E9 7B FD FF FF EB 17 8B 4D F0 83 C9 20 89 4D F0 EB 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 E9 56 0A 00 00 0F B7 85 AC FB FF FF 89 85 30 FB FF FF 8B 8D 30 FB FF FF 83 E9 41 89 8D 30 FB FF FF 83 BD 30 FB FF FF 37 0F 87 4A 08 00 00 8B 95 30 FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 81 E1 30 08 00 00 75 09 8B 55 F0 83 CA 20 89 55 F0 C7 45 F4 01 00 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FB FF FF 8B 4D F0 83 E1 20 74 57 0F B7 95 A8 FB FF FF 81 E2 FF 00 00 00 88 95 98 FB FF FF C6 85 99 FB FF FF 00 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8D 95 98 FB FF FF 52 8D 85 B8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 07 C7 45 D8 01 00 00 00 EB 0E 66 8B 8D A8 FB FF FF 66 89 8D B8 FB FF FF 8D 95 B8 FB FF FF 89 55 FC C7 45 DC 01 00 00 00 E9 86 07 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FB FF FF 83 BD 94 FB FF FF 00 74 0C 8B 8D 94 FB FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 94 FB FF FF 8B 42 04 89 45 FC 8B 8D 94 FB FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 94 FB FF FF 8B 42 04 89 45 FC 8B 8D 94 FB FF FF 0F BF 11 89 55 DC E9 F0 06 00 00 8B 45 F0 25 30 08 00 00 75 09 8B 4D F0 83 C9 20 89 4D F0 83 7D D0 FF 75 0C C7 85 2C FB FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 2C FB FF FF 8B 85 2C FB FF FF 89 85 8C FB FF FF 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 83 E2 20 0F 84 82 00 00 00 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 89 8D 90 FB FF FF C7 45 DC 00 00 00 00 EB 09 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC 3B 85 8C FB FF FF 7D 4C 8B 8D 90 FB FF FF 0F BE 11 85 D2 74 3F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 85 90 FB FF FF 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 95 90 FB FF FF 83 C2 01 89 95 90 FB FF FF 8B 85 90 FB FF FF 83 C0 01 89 85 90 FB FF FF EB A0 EB 64 83 7D FC 00 75 09 8B 0D ?? ?? ?? ?? 89 4D FC C7 45 F4 01 00 00 00 8B 55 FC 89 95 88 FB FF FF 8B 85 8C FB FF FF 8B 8D 8C FB FF FF 83 E9 01 89 8D 8C FB FF FF 85 C0 74 1E 8B 95 88 FB FF FF 0F B7 02 85 C0 74 11 8B 8D 88 FB FF FF 83 C1 02 89 8D 88 FB FF FF EB C9 8B 95 88 FB FF FF 2B 55 FC D1 FA 89 55 DC E9 B0 05 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 84 FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C9 74 0C C7 85 28 FB FF FF 01 00 00 00 EB 0A C7 85 28 FB FF FF 00 00 00 00 8B 95 28 FB FF FF 89 95 80 FB FF FF 83 BD 80 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 80 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 48 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 48 FB FF FF E9 F4 06 00 00 E9 ED 04 00 00 8B 4D F0 83 E1 20 74 12 8B 95 84 FB FF FF 66 8B 85 B4 FB FF FF 66 89 02 EB 0E 8B 8D 84 FB FF FF 8B 95 B4 FB FF FF 89 11 C7 45 D8 01 00 00 00 E9 B9 04 00 00 C7 45 D4 01 00 00 00 0F B7 85 AC FB FF FF 83 C0 20 66 89 85 AC FB FF FF 8B 4D F0 83 C9 40 89 4D F0 8D 95 B8 FB FF FF 89 55 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F B7 85 AC FB FF FF 83 F8 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D D0 81 C1 5D 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 13 8B 55 E0 89 55 FC 8B 45 D0 05 5D 01 00 00 89 45 BC EB 07 C7 45 D0 A3 00 00 00 8B 4D 10 83 C1 08 89 4D 10 8B 55 10 8B 42 F8 8B 4A FC 89 85 78 FB FF FF 89 8D 7C FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 D4 52 8B 45 D0 50 0F BE 8D AC FB FF FF 51 8B 55 BC 52 8B 45 FC 50 8D 8D 78 FB FF FF 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? FF D0 83 C4 1C 8B 45 F0 25 80 00 00 00 74 25 83 7D D0 00 75 1F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 0F B7 85 AC FB FF FF 83 F8 67 75 29 8B 4D F0 81 E1 80 00 00 00 75 1E 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 8B 4D FC 0F BE 11 83 FA 2D 75 14 8B 45 F0 0D 00 01 00 00 89 45 F0 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 15 03 00 00 8B 45 F0 83 C8 40 89 45 F0 C7 45 F8 0A 00 00 00 EB 75 C7 45 F8 0A 00 00 00 EB 6C C7 45 D0 08 00 00 00 C7 85 A0 FB FF FF 07 00 00 00 EB 0A C7 85 A0 FB FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 1D BA 30 00 00 00 66 89 55 EC 8B 85 A0 FB FF FF 83 C0 51 66 89 45 EE C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FB FF FF 89 95 6C FB FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FB FF FF 89 95 6C FB FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 1C 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 1A 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 68 FB FF FF 89 95 6C FB FF FF 8B 45 F0 83 E0 40 74 40 83 BD 6C FB FF FF 00 7F 37 7C 09 83 BD 68 FB FF FF 00 73 2C 8B 8D 68 FB FF FF F7 D9 8B 95 6C FB FF FF 83 D2 00 F7 DA 89 8D 60 FB FF FF 89 95 64 FB FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 68 FB FF FF 89 8D 60 FB FF FF 8B 95 6C FB FF FF 89 95 64 FB FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 60 FB FF FF 8B 85 64 FB FF FF 83 E0 00 89 95 60 FB FF FF 89 85 64 FB FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 60 FB FF FF 0B 95 64 FB FF FF 75 07 C7 45 E4 00 00 00 00 8D 85 B7 FD FF FF 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 60 FB FF FF 0B 85 64 FB FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 64 FB FF FF 51 8B 95 60 FB FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 74 FB FF FF 8B 45 F8 99 52 50 8B 85 64 FB FF FF 50 8B 8D 60 FB FF FF 51 E8 ?? ?? ?? ?? 89 85 60 FB FF FF 89 95 64 FB FF FF 83 BD 74 FB FF FF 39 7E 12 8B 95 74 FB FF FF 03 95 A0 FB FF FF 89 95 74 FB FF FF 8B 45 FC 8A 8D 74 FB FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 85 B7 FD FF FF 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 81 E2 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 45 FC 0F BE 08 83 F9 30 74 18 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 30 8B 4D DC 83 C1 01 89 4D DC 83 7D D8 00 0F 85 BE 01 00 00 8B 55 F0 83 E2 40 74 4E 8B 45 F0 25 00 01 00 00 74 12 B9 2D 00 00 00 66 89 4D EC C7 45 E4 01 00 00 00 EB 32 8B 55 F0 83 E2 01 74 12 B8 2B 00 00 00 66 89 45 EC C7 45 E4 01 00 00 00 EB 18 8B 4D F0 83 E1 02 74 10 BA 20 00 00 00 66 89 55 EC C7 45 E4 01 00 00 00 8B 45 E8 2B 45 DC 2B 45 E4 89 85 5C FB FF FF 8B 4D F0 83 E1 0C 75 18 8D 95 B4 FB FF FF 52 8B 85 5C FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 8D 8D B4 FB FF FF 51 8B 55 E4 52 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 E1 08 74 20 8B 55 F0 83 E2 04 75 18 8D 85 B4 FB FF FF 50 8B 8D 5C FB FF FF 51 6A 30 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 00 0F 85 B0 00 00 00 83 7D DC 00 0F 8E A6 00 00 00 8B 55 FC 89 95 58 FB FF FF 8B 45 DC 89 85 54 FB FF FF 8B 8D 54 FB FF FF 8B 95 54 FB FF FF 83 EA 01 89 95 54 FB FF FF 85 C9 7E 79 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8B 95 58 FB FF FF 52 8D 85 A8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 50 FB FF FF 83 BD 50 FB FF FF 00 7F 0C C7 85 B4 FB FF FF FF FF FF FF EB 2E 8D 8D B4 FB FF FF 51 0F B7 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 58 FB FF FF 03 85 50 FB FF FF 89 85 58 FB FF FF E9 6E FF FF FF EB 17 8D 8D B4 FB FF FF 51 8B 55 DC 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 BD B4 FB FF FF 00 7C 20 8B 4D F0 83 E1 04 74 18 8D 95 B4 FB FF FF 52 8B 85 5C FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E0 00 74 15 6A 02 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E0 00 00 00 00 E9 46 F2 FF FF 8B 95 B4 FB FF FF 89 95 44 FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 44 FB FF FF 8B 4D B8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 02 04 04 04 04 04 04 04 04 04 04 03 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0E 01 0E 00 0E 00 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 02 0E 0E 0E 0E 03 0E 04 0E 0E 0E 0E 0E 0E 05 0E 06 07 05 05 05 0E 07 0E 0E 0E 0E 08 09 0A 0E 0E 0B 0E 0C 0E 0E 0D }
	condition:
		$1
}

rule file_106_7_0 {
	meta:
		name = "_write_char"
		size = 55
		refs = "000b __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 81 F9 FF FF 00 00 75 0B 8B 55 0C C7 02 FF FF FF FF EB 0D 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A 5D C3 }
	condition:
		$1
}

rule file_106_8_0 {
	meta:
		name = "_write_multi_char"
		size = 52
		refs = "001f _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 1D 8B 55 10 52 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 83 39 FF 75 02 EB 02 EB D3 5D C3 }
	condition:
		$1
}

rule file_106_9_0 {
	meta:
		name = "_write_string"
		size = 143
		refs = "0009 __errno 0041 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 FC E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 0C 8B 55 0C 83 EA 01 89 55 0C 85 C9 7E 4A 8B 45 08 66 8B 08 66 89 4D FA 8B 55 10 52 0F B7 45 FA 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 83 C1 02 89 4D 08 8B 55 10 83 3A FF 75 1C E8 ?? ?? ?? ?? 83 38 2A 75 10 8B 45 10 50 6A 3F E8 ?? ?? ?? ?? 83 C4 08 EB 02 EB 02 EB A6 E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 438
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 0042 __imp__GetStartupInfoW@4 0048 __NoHeapEnableTerminationOnCorruption 0059 __imp__HeapSetInformation@16 005e _check_managed_app 0066 __heap_init 0071 _fast_error_exit 0079 __mtinit 008e __CrtSetCheckCount 0096 __RTC_Initialize 00a2 __ioinit 00ad __amsg_exit 00b6 __imp__GetCommandLineW@0 00bb __wcmdln 00c0 ___crtGetEnvironmentStringsW 00c5 __wenvptr 00ca __wsetargv 00dd __wsetenvp 00f2 __cinit 010f __wwincmdln 0139 ___ImageBase 013e _wWinMain@16 0150 _exit 0155 __cexit 0175 __XcptFilter 0191 __exit 0196 __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 98 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 90 00 00 00 00 8D 45 A0 50 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0E 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 94 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 9C 83 7D 9C 00 74 0C 8B 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 98 8B 55 CC 83 E2 01 74 09 0F B7 45 D0 89 45 88 EB 07 C7 45 88 0A 00 00 00 8B 4D 88 51 8B 55 98 52 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 90 83 7D 94 00 75 09 8B 45 90 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 4D EC 8B 11 8B 02 89 45 8C 8B 4D EC 51 8B 55 8C 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 8C 89 45 90 83 7D 94 00 75 09 8B 4D 90 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 90 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_899_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 438
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 0042 __imp__GetStartupInfoW@4 0048 __NoHeapEnableTerminationOnCorruption 0059 __imp__HeapSetInformation@16 005e _check_managed_app 0066 __heap_init 0071 _fast_error_exit 0079 __mtinit 008e __CrtSetCheckCount 0096 __RTC_Initialize 00a2 __ioinit 00ad __amsg_exit 00b6 __imp__GetCommandLineA@0 00bb __acmdln 00c0 ___crtGetEnvironmentStringsA 00c5 __aenvptr 00ca __setargv 00dd __setenvp 00f2 __cinit 010f __wincmdln 0139 ___ImageBase 013e _WinMain@16 0150 _exit 0155 __cexit 0175 __XcptFilter 0191 __exit 0196 __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 98 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 90 00 00 00 00 8D 45 A0 50 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0E 6A 00 6A 00 6A 01 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 94 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 9C 83 7D 9C 00 74 0C 8B 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 98 8B 55 CC 83 E2 01 74 09 0F B7 45 D0 89 45 88 EB 07 C7 45 88 0A 00 00 00 8B 4D 88 51 8B 55 98 52 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 90 83 7D 94 00 75 09 8B 45 90 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 4D EC 8B 11 8B 02 89 45 8C 8B 4D EC 51 8B 55 8C 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 8C 89 45 90 83 7D 94 00 75 09 8B 4D 90 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 90 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 46
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0018 __NMSG_WRITE 0025 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__fsqrt"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 D9 FA DD 5D F8 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__wfullpath"
		size = 33
		refs = "0018 __wfullpath_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_705_5_0 {
	meta:
		name = "__dupenv_s"
		size = 33
		refs = "0018 __dupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__fullpath"
		size = 33
		refs = "0018 __fullpath_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_470_4_0 {
	meta:
		name = "__getdcwd_nolock"
		size = 33
		refs = "0018 __getdcwd_lk_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_603_5_0 {
	meta:
		name = "__wdupenv_s"
		size = 33
		refs = "0018 __wdupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_501_4_0 {
	meta:
		name = "__wgetdcwd_nolock"
		size = 33
		refs = "0018 __wgetdcwd_lk_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "__wfullpath_dbg"
		size = 434
		refs = "0021 __wgetcwd 0043 __imp__GetFullPathNameW@16 0052 __imp__GetLastError@0 0058 __dosmaperr 008c __errno 00b0 __calloc_dbg 00e3 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00ef ??_C@_1GE@EJNCNJPK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f6 __CrtDbgReportW 0121 ??_C@_1BO@ECCJIFJJ@?$AA_?$AAw?$AAf?$AAu?$AAl?$AAl?$AAp?$AAa?$AAt?$AAh?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 012b __invalid_parameter 0168 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 0C 00 74 0A 8B 45 0C 0F B7 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 81 01 00 00 83 7D 08 00 0F 85 9D 00 00 00 6A 00 6A 00 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 48 01 00 00 8B 55 10 3B 55 FC 76 08 8B 45 10 89 45 EC EB 06 8B 4D FC 89 4D EC 8B 55 EC 89 55 10 81 7D 10 FF FF FF 7F 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 11 01 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 6A 02 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 DC 00 00 00 EB 68 33 C9 3B 4D 10 1B D2 F7 DA 89 55 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 78 8B 4D 08 89 4D F4 8D 55 F8 52 8B 45 F4 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 3B 45 10 72 23 83 7D 08 00 75 0C 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 30 EB 2B 83 7D FC 00 75 25 83 7D 08 00 75 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "_realloc"
		size = 38
		refs = "0015 __realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_264_13_0 {
	meta:
		name = "__expand"
		size = 38
		refs = "0015 __expand_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_865_0_0 {
	meta:
		name = "_calloc"
		size = 38
		refs = "0015 __calloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_strchr"
		size = 190
	strings:
		$1 = { 33 C0 8A 44 24 08 53 8B D8 C1 E0 08 8B 54 24 08 F7 C2 03 00 00 00 74 15 8A 0A 83 C2 01 3A CB 74 CF 84 C9 74 51 F7 C2 03 00 00 00 75 EB 0B D8 57 8B C3 C1 E3 10 56 0B D8 8B 0A BF FF FE FE 7E 8B C1 8B F7 33 CB 03 F0 03 F9 83 F1 FF 83 F0 FF 33 CF 33 C6 83 C2 04 81 E1 00 01 01 81 75 1C 25 00 01 01 81 74 D3 25 00 01 01 01 75 08 81 E6 00 00 00 80 75 C4 5E 5F 5B 33 C0 C3 8B 42 FC 3A C3 74 36 84 C0 74 EF 3A E3 74 27 84 E4 74 E7 C1 E8 10 3A C3 74 15 84 C0 74 DC 3A E3 74 06 84 E4 74 D4 EB 96 5E 5F 8D 42 FF 5B C3 8D 42 FE 5E 5F 5B C3 8D 42 FD 5E 5F 5B C3 8D 42 FC 5E 5F 5B C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__wcsnset"
		size = 66
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 1F 8B 45 08 0F B7 08 85 C9 74 15 8B 55 08 66 8B 45 0C 66 89 02 8B 4D 08 83 C1 02 89 4D 08 EB D1 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__mbsspn_l"
		size = 554
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002e _strspn 003c ??1_LocaleUpdate@@QAE@XZ 005b ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0064 ??_C@_1GA@HAFFGCEC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006b __CrtDbgReportW 007f __errno 0093 ??_C@_1BE@IJNALACN@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAp?$AAn?$AA_?$AAl?$AA?$AA@ 009d __invalid_parameter 00ce ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 DE 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 6B 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 F8 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 FC 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 3A 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 12 8B 45 FC 0F B6 48 01 8B 55 F8 0F B6 42 01 3B C8 74 0B 8B 4D FC 0F B6 51 01 85 D2 75 02 EB 1F 8B 45 FC 83 C0 01 89 45 FC EB 12 8B 4D FC 0F B6 11 8B 45 F8 0F B6 08 3B D1 75 02 EB 02 EB 84 8B 55 FC 0F B6 02 85 C0 75 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 75 02 EB 05 E9 24 FF FF FF 8B 55 F8 2B 55 08 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_frexp"
		size = 353
		refs = "001b ??_C@_1BO@KGGHBFPG@?$AAe?$AAx?$AAp?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1HC@HDCMDJF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1M@KFLMCEDC@?$AAf?$AAr?$AAe?$AAx?$AAp?$AA?$AA@ 005d __invalid_parameter 0076 __ctrlfp 00a9 __sptype 00d0 __d_ind 00e5 __except1 00fe __handle_qnan1 0110 __real@3ff0000000000000 013f __decomp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 33 C0 83 7D 10 00 0F 95 C0 89 45 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 D9 EE E9 F2 00 00 00 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 0F B7 55 0E 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 85 9B 00 00 00 8B 45 10 C7 00 FF FF FF FF 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 7E 4E 83 7D E8 02 7E 08 83 7D E8 03 74 29 EB 40 8B 4D FC 51 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 6F 8B 55 FC 52 83 EC 08 DD 45 08 DD 1C 24 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 56 8B 45 FC 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 2C 8B 4D 10 51 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 68 FF FF 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__mbclen_l"
		size = 63
		refs = "0012 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 14 8B 45 08 0F B6 48 01 85 C9 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_1_0 {
	meta:
		name = "__mbclen"
		size = 59
		refs = "000e __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 14 8B 55 08 0F B6 42 01 85 C0 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__snwprintf"
		size = 544
		refs = "003f ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_1GE@DKGHLBLP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0052 __CrtDbgReportW 0066 __errno 007d ??_C@_1BG@BAJEGOIL@?$AA_?$AAs?$AAn?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0087 __invalid_parameter 00bf ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 0166 __woutput_l 01c1 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 C7 45 D4 00 00 00 00 33 C0 89 45 D8 89 45 DC 89 45 E0 89 45 E4 89 45 E8 89 45 EC 89 45 F0 8D 4D D4 89 4D F4 33 D2 83 7D 10 00 0F 95 C2 89 55 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 80 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 86 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 4D C8 89 4D CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 06 01 00 00 8D 45 14 89 45 FC 8B 4D F4 C7 41 0C 42 00 00 00 8B 55 F4 8B 45 08 89 42 08 8B 4D F4 8B 55 08 89 11 81 7D 0C FF FF FF 3F 76 0C 8B 45 F4 C7 40 04 FF FF FF 7F EB 0B 8B 4D 0C D1 E1 8B 55 F4 89 4A 04 8B 45 FC 50 6A 00 8B 4D 10 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 08 8B 45 F8 E9 9E 00 00 00 8B 45 F4 8B 48 04 83 E9 01 89 4D C4 8B 55 F4 8B 45 C4 89 42 04 83 7D C4 00 7C 21 8B 4D F4 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 C0 8B 4D F4 8B 11 83 C2 01 8B 45 F4 89 10 EB 11 8B 4D F4 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 55 F4 8B 42 04 83 E8 01 89 45 BC 8B 4D F4 8B 55 BC 89 51 04 83 7D BC 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 B8 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 B8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__dup"
		size = 544
		refs = "0008 __sehtable$__dup 000d __except_handler4 001f ___security_cookie 0040 ___doserrno 004b __errno 0068 __nhandle 008b ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 0094 ??_C@_1FK@JHPGOADJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 009b __CrtDbgReportW 00ce ??_C@_19DABLNIOD@?$AA_?$AAd?$AAu?$AAp?$AA?$AA@ 00d8 __invalid_parameter 00f9 ___pioinfo 0111 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0172 ___lock_fhandle 01a5 __dup_nolock 01d3 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0203 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 FF FF FF FF 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B1 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 27 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 11 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "__dup_nolock"
		size = 635
		refs = "0008 __sehtable$__dup_nolock 000d __except_handler4 001f ___security_cookie 004b ___pioinfo 007f __alloc_osfhnd 008d __errno 0098 ___doserrno 00bd __imp__GetCurrentProcess@0 00c7 __get_osfhandle 00d8 __imp__DuplicateHandle@28 00e2 __imp__GetLastError@0 00f4 __set_osfhnd 010d __dosmaperr 0249 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 04 88 45 DB 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 01 75 08 83 C8 FF E9 EB 01 00 00 E8 ?? ?? ?? ?? 89 45 D4 83 7D D4 FF 75 1E E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF E9 BF 01 00 00 C7 45 FC 00 00 00 00 6A 02 6A 01 6A 00 8D 55 E4 52 FF 15 ?? ?? ?? ?? 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 DC EB 17 8B 4D E4 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 DC 00 00 00 00 83 7D DC 00 74 11 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 E9 DF 00 00 00 0F BE 4D DB 83 E1 EF 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 8B 4D D4 C1 F9 05 8B 55 D4 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 24 7F 8A 54 11 24 80 E2 80 0A D0 8B 45 D4 C1 F8 05 8B 4D D4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 24 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8A 4C 10 24 C0 E1 00 C0 F9 07 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 80 E1 01 C0 E1 07 8A 44 02 24 24 7F 0A C1 8B 4D D4 C1 F9 05 8B 55 D4 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 24 C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 4B 83 7D E0 00 75 38 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 FE 8B 45 D4 C1 F8 05 8B 4D D4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D E0 00 74 08 8B 55 D4 89 55 D0 EB 07 C7 45 D0 FF FF FF FF 8B 45 D0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "___init_time"
		size = 240
		refs = "0012 ??_C@_0DC@KICHHNFK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0020 __calloc_dbg 0043 __get_lc_time 0053 ___free_lc_time 0061 __free_dbg 0081 ___lc_time_c 00a6 __imp__InterlockedDecrement@4 00c1 ??_C@_1EE@FDHCFDHN@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AA_?$AAt?$AAi?$AAm?$AAe?$AA_?$AAc?$AAu?$AAr?$AAr?$AA?9?$AA?$DO?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5@ 00ca ??_C@_1GE@GJCMHHMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d1 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 78 20 00 74 6F 6A 3F 68 ?? ?? ?? ?? 6A 02 68 64 01 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0A B8 01 00 00 00 E9 B2 00 00 00 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 EB 7D 8B 55 FC C7 82 B4 00 00 00 01 00 00 00 EB 07 C7 45 FC ?? ?? ?? ?? 8B 45 08 81 B8 D4 00 00 00 ?? ?? ?? ?? 74 4A 8B 4D 08 8B 91 D4 00 00 00 81 C2 B4 00 00 00 52 FF 15 ?? ?? ?? ?? 85 C0 75 30 8B 45 08 8B 88 D4 00 00 00 83 B9 B4 00 00 00 00 7F 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 8B 4D FC 89 88 D4 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "__get_lc_time"
		size = 3123
		refs = "0052 ___getlocaleinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 C7 45 EC 00 00 00 00 8B 45 0C 0F B7 48 42 89 4D F0 8B 55 0C 0F B7 42 44 89 45 FC 83 7D 08 00 75 08 83 C8 FF E9 FE 0B 00 00 8B 4D 0C 89 4D F4 C7 45 F8 00 00 00 00 8B 55 08 83 C2 04 52 6A 31 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 08 52 6A 32 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 0C 52 6A 33 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 10 52 6A 34 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 14 52 6A 35 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 18 52 6A 36 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 52 6A 37 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 20 52 6A 2A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 24 52 6A 2B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 28 52 6A 2C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 2C 52 6A 2D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 30 52 6A 2E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 34 52 6A 2F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 1C 52 6A 30 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 38 52 6A 44 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 3C 52 6A 45 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 40 52 6A 46 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 44 52 6A 47 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 48 52 6A 48 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 4C 52 6A 49 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 50 52 6A 4A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 54 52 6A 4B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 58 52 6A 4C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 5C 52 6A 4D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 60 52 6A 4E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 64 52 6A 4F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 68 52 6A 38 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 6C 52 6A 39 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 70 52 6A 3A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 74 52 6A 3B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 78 52 6A 3C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 7C 52 6A 3D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 80 00 00 00 52 6A 3E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 84 00 00 00 52 6A 3F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 88 00 00 00 52 6A 40 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 8C 00 00 00 52 6A 41 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 90 00 00 00 52 6A 42 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 94 00 00 00 52 6A 43 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 98 00 00 00 52 6A 28 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 9C 00 00 00 52 6A 29 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A0 00 00 00 52 6A 1F 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A4 00 00 00 52 6A 20 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A8 00 00 00 52 68 03 10 00 00 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 B0 00 00 00 52 68 09 10 00 00 8B 45 FC 50 6A 00 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 8B 45 FC 89 82 AC 00 00 00 8B 4D 08 81 C1 BC 00 00 00 51 6A 31 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 C0 00 00 00 51 6A 32 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 C4 00 00 00 51 6A 33 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 C8 00 00 00 51 6A 34 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 CC 00 00 00 51 6A 35 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 D0 00 00 00 51 6A 36 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 B8 00 00 00 51 6A 37 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 D8 00 00 00 51 6A 2A 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 DC 00 00 00 51 6A 2B 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 E0 00 00 00 51 6A 2C 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 E4 00 00 00 51 6A 2D 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 E8 00 00 00 51 6A 2E 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 EC 00 00 00 51 6A 2F 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 D4 00 00 00 51 6A 30 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 F0 00 00 00 51 6A 44 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 F4 00 00 00 51 6A 45 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 F8 00 00 00 51 6A 46 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 FC 00 00 00 51 6A 47 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 00 01 00 00 51 6A 48 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 04 01 00 00 51 6A 49 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 08 01 00 00 51 6A 4A 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 0C 01 00 00 51 6A 4B 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 10 01 00 00 51 6A 4C 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 14 01 00 00 51 6A 4D 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 18 01 00 00 51 6A 4E 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 1C 01 00 00 51 6A 4F 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 20 01 00 00 51 6A 38 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 24 01 00 00 51 6A 39 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 28 01 00 00 51 6A 3A 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 2C 01 00 00 51 6A 3B 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 30 01 00 00 51 6A 3C 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 34 01 00 00 51 6A 3D 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 38 01 00 00 51 6A 3E 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 3C 01 00 00 51 6A 3F 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 40 01 00 00 51 6A 40 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 44 01 00 00 51 6A 41 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 48 01 00 00 51 6A 42 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 4D 08 81 C1 4C 01 00 00 51 6A 43 8B 55 F0 52 6A 02 8D 45 F4 50 E8 ?? ?? 