private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_10_0 {
	meta:
		name = "InitThreadTLS"
		size = 79
		refs = "0002 TlsLast 000c TlsIndex 0019 @RunError 0025 LocalAlloc 0043 TlsSetValue 0049 TlsBuffer"
	strings:
		$1 = { 53 B8 ?? ?? ?? ?? 85 C0 74 43 83 3D ?? ?? ?? ?? 00 7D 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 40 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0C B8 E2 00 00 00 E8 ?? ?? ?? ?? EB 0C 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "InitProcessTLS"
		size = 39
		refs = "0001 TlsLast 000a TlsAlloc 000f TlsIndex 001d @RunError 0022 InitThreadTLS"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1D E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 7D 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "ExitThreadTLS"
		size = 40
		refs = "0001 TlsLast 000b TlsIndex 0019 TlsGetValue 0023 LocalFree"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1E 83 3D ?? ?? ?? ?? 00 7C 15 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13_0 {
	meta:
		name = "ExitProcessTLS"
		size = 35
		refs = "0001 TlsLast 000a ExitThreadTLS 0010 TlsIndex 001e TlsFree"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 19 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7C 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "@GetTls"
		size = 67
		refs = "0002 ModuleIsLib 0008 TlsIndex 001c InitThreadTLS 0028 TlsGetValue 0033 TlsBuffer"
	strings:
		$1 = { 8A 0D ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 84 C9 75 28 64 8B 15 2C 00 00 00 8B 04 82 C3 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 01 C3 8B 05 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? 85 C0 74 D9 C3 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "InitializeModule"
		size = 75
		refs = "0012 HInstance 0018 GetModuleFileName 001f LoadResourceModule 0027 Module 003f RegisterModule"
	strings:
		$1 = { 53 81 C4 F8 FE FF FF 68 05 01 00 00 8D 44 24 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C4 E8 ?? ?? ?? ?? 8B D8 89 1D ?? ?? ?? ?? 85 DB 75 0A A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 C4 08 01 00 00 5B C3 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "UninitializeModule"
		size = 30
		refs = "0001 Module 0006 UnregisterModule 0019 FreeLibrary"
	strings:
		$1 = { B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "VclInit"
		size = 155
		refs = "0011 ModuleIsLib 0018 ModuleIsPackage 0021 IsLibrary 0035 HInstance 003a Module 004e ModuleIsCpp 0054 InitializeModule 0062 VclInit 0067 FindHInstance 0071 DataMark 0080 GetCommandLine 0086 CmdLine 0093 IsConsole"
	strings:
		$1 = { 55 8B EC 8B 45 10 8B 55 08 80 7D 0C 00 74 10 C6 05 ?? ?? ?? ?? 01 C6 05 ?? ?? ?? ?? 01 EB 15 8B 0D ?? ?? ?? ?? 88 11 88 15 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 8A 45 14 34 01 8B 15 ?? ?? ?? ?? 88 02 5D C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "VclExit"
		size = 47
		refs = "0004 ExitProc 000a ModuleIsLib 0028 UninitializeModule"
	strings:
		$1 = { 53 56 8B 1D ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 16 83 3B 00 74 11 8B 13 89 D0 33 D2 89 13 8B F0 FF D6 83 3B 00 75 EF E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "@InitPkg"
		size = 99
		refs = "000d ModuleIsLib 0014 ModuleIsPackage 001a Module 002f HInstance 0034 TlsLast 003f TlsProc 004b InitializeModule 0056 UninitializeModule"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 0C 8B 45 08 C6 05 ?? ?? ?? ?? 01 C6 05 ?? ?? ?? ?? 01 A3 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 74 09 8B 34 9D ?? ?? ?? ?? FF D6 83 FB 01 75 07 E8 ?? ?? ?? ?? EB 09 85 DB 75 05 E8 ?? ?? ?? ?? 83 C8 FF 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "@InitLib"
		size = 70
		refs = "0001 Module 000f ModuleIsLib 0019 HInstance 002f InitializeModule 0037 DllProc 003c TlsProc 0041 @StartLib"
	strings:
		$1 = { BA ?? ?? ?? ?? 83 7D 0C 01 75 2A 50 52 C6 05 ?? ?? ?? ?? 01 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 E8 ?? ?? ?? ?? 5A 58 FF 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "@InitExe"
		size = 50
		refs = "0004 GetModuleHandle 0009 Module 0010 HInstance 0026 InitializeModule 002d @StartExe"
	strings:
		$1 = { 50 6A 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _DV_1 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "_NF__124"
		size = 78
		refs = "0007 TInterfacedObject.QueryInterface 0011 TInterfacedObject._AddRef 001b TInterfacedObject._Release 0022 _NF__124"
	strings:
		$1 = { CC 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? 83 44 24 04 F8 E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 08 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "GetCmdShow"
		size = 34
		refs = "000b GetStartupInfo"
	strings:
		$1 = { 53 83 C4 BC BB 0A 00 00 00 54 E8 ?? ?? ?? ?? F6 44 24 2C 01 74 05 0F B7 5C 24 30 8B C3 83 C4 44 5B C3 }
	condition:
		$1
}

rule function_100_0 {
	meta:
		name = "GetBlockDesc"
		size = 79
		refs = "0003 blockDescFreeList 0014 LocalAlloc 0024 blockDescBlockList"
	strings:
		$1 = { 53 56 BE ?? ?? ?? ?? 83 3E 00 75 3A 68 44 06 00 00 6A 00 E8 ?? ?? ?? ?? 8B C8 85 C9 75 05 33 C0 5E 5B C3 A1 ?? ?? ?? ?? 89 01 89 0D ?? ?? ?? ?? 33 D2 8B C2 03 C0 8D 44 C1 04 8B 1E 89 18 89 06 42 83 FA 64 75 EC 8B 06 8B 10 89 16 5E 5B C3 }
	condition:
		$1
}

rule function_101_0 {
	meta:
		name = "MakeEmpty"
		size = 6
	strings:
		$1 = { 89 00 89 40 04 C3 }
	condition:
		$1
}

rule function_102_0 {
	meta:
		name = "AddBlockAfter"
		size = 48
		refs = "0007 GetBlockDesc"
	strings:
		$1 = { 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? 85 C0 75 05 33 C0 5E 5B C3 8B 16 89 50 08 8B 56 04 89 50 0C 8B 13 89 10 89 58 04 89 42 04 89 03 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_103_0 {
	meta:
		name = "DeleteBlock"
		size = 24
		refs = "000c blockDescFreeList"
	strings:
		$1 = { 8B 50 04 8B 08 89 0A 89 51 04 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_104_0 {
	meta:
		name = "MergeBlockAfter"
		size = 113
		refs = "002d DeleteBlock 005f AddBlockAfter"
	strings:
		$1 = { 53 56 57 55 51 8B F1 89 14 24 8B E8 8B 5D 00 8B 04 24 8B 10 89 16 8B 50 04 89 56 04 8B 3B 8B 43 08 8B D0 03 53 0C 3B 16 75 14 8B C3 E8 ?? ?? ?? ?? 8B 43 08 89 06 8B 43 0C 01 46 04 EB 16 8B 16 03 56 04 3B C2 75 0D 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 01 46 04 8B DF 3B EB 75 C2 8B D6 8B C5 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 89 06 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_105_0 {
	meta:
		name = "RemoveBlock"
		size = 143
		refs = "003b DeleteBlock 0070 AddBlockAfter"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B D8 8B FB 8B 32 8B 43 08 3B F0 72 6C 8B CE 03 4A 04 8B E8 03 6B 0C 3B CD 77 5E 3B F0 75 1B 8B 42 04 01 43 08 8B 42 04 29 43 0C 83 7B 0C 00 75 44 8B C3 E8 ?? ?? ?? ?? EB 3B 8B 0A 8B 72 04 03 CE 8B F8 03 7B 0C 3B CF 75 05 29 73 0C EB 26 8B 0A 03 4A 04 89 0C 24 2B F9 89 7C 24 04 8B 12 2B D0 89 53 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 0C B0 01 EB 08 8B 1B 3B FB 75 85 33 C0 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_106_0 {
	meta:
		name = "GetSpace"
		size = 99
		refs = "0030 VirtualAlloc 003f spaceRoot 0044 AddBlockAfter 0057 VirtualFree"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 81 FE 00 00 10 00 7D 07 BE 00 00 10 00 EB 0C 81 C6 FF FF 00 00 81 E6 00 00 FF FF 89 73 04 6A 01 68 00 20 00 00 56 6A 00 E8 ?? ?? ?? ?? 8B F8 89 3B 85 FF 74 23 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 13 68 00 80 00 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 33 C0 89 03 5F 5E 5B C3 }
	condition:
		$1
}

rule function_107_0 {
	meta:
		name = "GetSpaceAt"
		size = 119
		refs = "001f VirtualAlloc 0052 spaceRoot 0057 AddBlockAfter 006a VirtualFree"
	strings:
		$1 = { 53 56 57 55 8B D9 8B F2 8B E8 C7 43 04 00 00 10 00 6A 04 68 00 20 00 00 68 00 00 10 00 55 E8 ?? ?? ?? ?? 8B F8 89 3B 85 FF 75 1F 81 C6 FF FF 00 00 81 E6 00 00 FF FF 89 73 04 6A 04 68 00 20 00 00 56 55 E8 ?? ?? ?? ?? 89 03 83 3B 00 74 23 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 13 68 00 80 00 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 33 C0 89 03 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_108_0 {
	meta:
		name = "FreeSpace"
		size = 184
		refs = "0029 spaceRoot 0065 VirtualFree 006f heapErrorCode 007a DeleteBlock"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 4C 24 04 89 14 24 C7 44 24 08 FF FF FF FF 33 D2 89 54 24 0C 8B E8 8B 04 24 03 C5 89 44 24 10 8B 1D ?? ?? ?? ?? EB 51 8B 3B 8B 73 08 3B EE 77 46 8B C6 03 43 0C 3B 44 24 10 77 3B 3B 74 24 08 73 04 89 74 24 08 8B C6 03 43 0C 3B 44 24 0C 76 04 89 44 24 0C 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B DF 81 FB ?? ?? ?? ?? 75 A7 8B 44 24 04 33 D2 89 10 83 7C 24 0C 00 74 19 8B 44 24 04 8B 54 24 08 89 10 8B 44 24 0C 2B 44 24 08 8B 54 24 04 89 42 04 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_109_0 {
	meta:
		name = "Commit"
		size = 146
		refs = "0040 spaceRoot 006e VirtualAlloc"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 4C 24 04 89 14 24 8B D0 8B EA 81 E5 00 F0 FF FF 03 14 24 81 C2 FF 0F 00 00 81 E2 00 F0 FF FF 89 54 24 08 8B 44 24 04 89 28 8B 44 24 08 2B C5 8B 54 24 04 89 42 04 8B 35 ?? ?? ?? ?? EB 3C 8B 5E 08 8B 7E 0C 03 FB 3B EB 76 02 8B DD 3B 7C 24 08 76 04 8B 7C 24 08 3B FB 76 1E 6A 04 68 00 10 00 00 2B FB 57 53 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 44 24 04 33 D2 89 10 EB 0A 8B 36 81 FE ?? ?? ?? ?? 75 BC 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_110_0 {
	meta:
		name = "Decommit"
		size = 125
		refs = "0031 spaceRoot 005b VirtualFree 0065 heapErrorCode"
	strings:
		$1 = { 53 56 57 55 51 8B D8 8B F3 81 C6 FF 0F 00 00 81 E6 00 F0 FF FF 89 34 24 8B EB 03 EA 81 E5 00 F0 FF FF 8B 04 24 89 01 8B C5 2B 04 24 89 41 04 8B 35 ?? ?? ?? ?? EB 38 8B 5E 08 8B 7E 0C 03 FB 3B 1C 24 73 03 8B 1C 24 3B EF 73 02 8B FD 3B FB 76 1C 68 00 40 00 00 2B FB 57 53 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 8B 36 81 FE ?? ?? ?? ?? 75 C0 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_111_0 {
	meta:
		name = "GetCommitted"
		size = 142
		refs = "000c decommittedRoot 002e Commit 004c DeleteBlock 005d GetSpace 006d MergeBlockAfter 007f FreeSpace"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B F8 BD ?? ?? ?? ?? 81 C7 FF 3F 00 00 81 E7 00 C0 FF FF 8B 5D 00 EB 33 3B 7B 0C 7F 2C 8B CE 8B D7 8B 43 08 E8 ?? ?? ?? ?? 83 3E 00 74 50 8B 46 04 01 43 08 8B 46 04 29 43 0C 83 7B 0C 00 75 3E 8B C3 E8 ?? ?? ?? ?? EB 35 8B 1B 3B DD 75 C9 8B D6 8B C7 E8 ?? ?? ?? ?? 83 3E 00 74 21 8B CC 8B D6 8B C5 E8 ?? ?? ?? ?? 83 3C 24 00 75 A5 8B CC 8B 56 04 8B 06 E8 ?? ?? ?? ?? 33 C0 89 06 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_112_0 {
	meta:
		name = "GetCommittedAt"
		size = 291
		refs = "000f decommittedRoot 004d GetSpaceAt 0063 MergeBlockAfter 007b FreeSpace 00e7 Commit 010e DeleteBlock"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 0C 24 8B FA 8B F0 BD ?? ?? ?? ?? 81 C7 FF 3F 00 00 81 E7 00 C0 FF FF 8B 5D 00 EB 02 8B 1B 3B DD 74 05 3B 73 08 75 F5 3B 73 08 75 57 3B 7B 0C 0F 8E 96 00 00 00 8D 4C 24 04 8B D7 2B 53 0C 8B 43 08 03 43 0C E8 ?? ?? ?? ?? 83 7C 24 04 00 74 33 8D 4C 24 0C 8D 54 24 04 8B C5 E8 ?? ?? ?? ?? 83 7C 24 0C 00 75 B1 8D 4C 24 0C 8B 54 24 08 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 33 D2 89 10 E9 90 00 00 00 8D 4C 24 04 8B D7 8B C6 E8 ?? ?? ?? ?? 83 7C 24 04 00 74 34 8D 4C 24 0C 8D 54 24 04 8B C5 E8 ?? ?? ?? ?? 83 7C 24 0C 00 0F 85 66 FF FF FF 8D 4C 24 0C 8B 54 24 08 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 33 D2 89 10 EB 48 8B 6B 08 3B F5 75 3A 3B 7B 0C 7F 35 8B 0C 24 8B D7 8B C5 E8 ?? ?? ?? ?? 8B 04 24 83 38 00 74 28 8B 04 24 8B 40 04 01 43 08 8B 04 24 8B 40 04 29 43 0C 83 7B 0C 00 75 10 8B C3 E8 ?? ?? ?? ?? EB 07 8B 04 24 33 D2 89 10 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_113_0 {
	meta:
		name = "FreeCommitted"
		size = 140
		refs = "002f Decommit 003a decommittedRoot 003f MergeBlockAfter 0056 FreeSpace 007b RemoveBlock"
	strings:
		$1 = { 53 56 57 83 C4 EC 8B F9 89 14 24 8D 98 FF 3F 00 00 81 E3 00 C0 FF FF 8B 34 24 03 F0 81 E6 00 C0 FF FF 3B DE 73 5B 8B CF 8B D6 2B D3 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 04 8B D7 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 04 85 DB 74 1F 8D 4C 24 0C 8B 54 24 08 8B C3 E8 ?? ?? ?? ?? 8B 44 24 0C 89 44 24 04 8B 44 24 10 89 44 24 08 83 7C 24 04 00 74 14 8D 54 24 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 33 C0 89 07 83 C4 14 5F 5E 5B C3 }
	condition:
		$1
}

rule function_114_0 {
	meta:
		name = "InitAllocator"
		size = 196
		refs = "0007 InitAllocator 0012 heapLock 0017 InitializeCriticalSection 001d IsMultiThread 002a EnterCriticalSection 002f spaceRoot 0034 MakeEmpty 0039 decommittedRoot 0043 committedRoot 0054 LocalAlloc 0059 smallTab 0080 avail 008a rover 0090 initialized 00b1 LeaveCriticalSection 00b7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 F8 0F 00 00 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 2F B8 03 00 00 00 8B 15 ?? ?? ?? ?? 33 C9 89 4C 82 F4 40 3D 01 04 00 00 75 EC B8 ?? ?? ?? ?? 89 40 04 89 00 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 A0 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_115_0 {
	meta:
		name = "UninitAllocator"
		size = 224
		refs = "0006 initialized 0015 UninitAllocator 0021 IsMultiThread 0029 heapLock 002e EnterCriticalSection 003a smallTab 0040 LocalFree 004d spaceRoot 005f VirtualFree 0073 MakeEmpty 0078 decommittedRoot 0082 committedRoot 008c blockDescBlockList 00c7 LeaveCriticalSection 00d1 DeleteCriticalSection 00d7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 80 3D ?? ?? ?? ?? 00 0F 84 CC 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB 12 68 00 80 00 00 6A 00 8B 43 08 50 E8 ?? ?? ?? ?? 8B 1B 81 FB ?? ?? ?? ?? 75 E6 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 17 8B 10 89 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 E9 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5B 5D C3 }
	condition:
		$1
}

rule function_116_0 {
	meta:
		name = "DeleteFree"
		size = 97
		refs = "0003 rover 002f smallTab"
	strings:
		$1 = { 53 3B 05 ?? ?? ?? ?? 75 09 8B 50 04 89 15 ?? ?? ?? ?? 8B 50 04 8B 48 08 81 F9 00 10 00 00 7F 38 3B C2 75 17 85 C9 79 03 83 C1 03 C1 F9 02 A1 ?? ?? ?? ?? 33 D2 89 54 88 F4 EB 24 85 C9 79 03 83 C1 03 C1 F9 02 8B 1D ?? ?? ?? ?? 89 54 8B F4 8B 00 89 02 89 50 04 5B C3 8B 00 89 02 89 50 04 5B C3 }
	condition:
		$1
}

rule function_117_0 {
	meta:
		name = "FindCommitted"
		size = 47
		refs = "0002 committedRoot 0022 heapErrorCode"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? EB 10 8B 4A 08 3B C1 72 07 03 4A 0C 3B C1 72 16 8B 12 81 FA ?? ?? ?? ?? 75 E8 C7 05 ?? ?? ?? ?? 03 00 00 00 33 D2 8B C2 C3 }
	condition:
		$1
}

rule function_118_0 {
	meta:
		name = "FillBeforeGap"
		size = 48
		refs = "0017 InsertFree"
	strings:
		$1 = { 53 8B CA 83 E9 04 8D 1C 01 83 FA 10 7C 0F C7 03 07 00 00 80 8B D1 E8 ?? ?? ?? ?? 5B C3 83 FA 04 7C 0C 8B CA 81 C9 02 00 00 80 89 08 89 0B 5B C3 }
	condition:
		$1
}

rule function_119_0 {
	meta:
		name = "InternalFreeMem"
		size = 34
		refs = "0002 AllocMemCount 0018 AllocMemSize 001d SysFreeMem"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 8B D0 83 EA 04 8B 12 81 E2 FC FF FF 7F 83 EA 04 01 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_120_0 {
	meta:
		name = "FillAfterGap"
		size = 40
		refs = "000e InternalFreeMem"
	strings:
		$1 = { 83 FA 0C 7C 0E 83 CA 02 89 10 83 C0 04 E8 ?? ?? ?? ?? C3 83 FA 04 7C 0A 8B CA 81 C9 02 00 00 80 89 08 03 C2 83 20 FE C3 }
	condition:
		$1
}

rule function_121_0 {
	meta:
		name = "FillerSizeBeforeGap"
		size = 109
		refs = "001b heapErrorCode 0062 DeleteFree"
	strings:
		$1 = { 53 56 8B D0 83 EA 04 8B 12 8B CA 81 E1 02 00 00 80 81 F9 02 00 00 80 74 0A C7 05 ?? ?? ?? ?? 04 00 00 00 8B DA 81 E3 FC FF FF 7F 2B C3 8B C8 33 11 F7 C2 FE FF FF FF 74 0A C7 05 ?? ?? ?? ?? 05 00 00 00 F6 01 01 74 20 8B D0 83 EA 0C 8B 72 08 2B C6 3B 70 08 74 0A C7 05 ?? ?? ?? ?? 06 00 00 00 E8 ?? ?? ?? ?? 03 DE 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_122_0 {
	meta:
		name = "FillerSizeAfterGap"
		size = 56
		refs = "0024 DeleteFree"
	strings:
		$1 = { 53 56 57 8B D8 33 FF 8B 03 A9 00 00 00 80 74 0B 25 FC FF FF 7F 03 F8 03 D8 8B 03 A8 02 75 13 8B F3 8B C6 E8 ?? ?? ?? ?? 8B 46 08 03 F8 03 D8 83 23 FE 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_123_0 {
	meta:
		name = "DecommitFree"
		size = 152
		refs = "000e FindCommitted 0041 FreeCommitted 0068 FillBeforeGap 0082 FillAfterGap 008b RemoveBlock"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 6B 08 8B C5 03 43 0C 8B D0 8D 0C 37 2B D1 83 FA 0C 7F 04 8B F8 2B FE 8B C6 2B C5 83 F8 0C 7D 12 8B CC 8B D6 2B 53 08 03 D7 8B C5 E8 ?? ?? ?? ?? EB 0F 8B CC 8B D7 83 EA 04 8D 46 04 E8 ?? ?? ?? ?? 8B 2C 24 85 ED 75 04 33 C0 EB 30 8B D5 2B D6 8B C6 E8 ?? ?? ?? ?? 8B C5 03 44 24 04 8B 53 08 03 53 0C 3B C2 73 0A 8D 14 37 2B D0 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? B0 01 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_124_0 {
	meta:
		name = "InsertFree"
		size = 133
		refs = "002b smallTab 0062 DecommitFree 006b rover"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B DF 89 73 08 8B C3 03 C6 83 E8 0C 89 70 08 81 FE 00 10 00 00 7F 37 8B D6 85 D2 79 03 83 C2 03 C1 FA 02 A1 ?? ?? ?? ?? 8B 44 90 F4 85 C0 75 10 A1 ?? ?? ?? ?? 89 5C 90 F4 89 5B 04 89 1B EB 3A 8B 10 89 43 04 89 13 89 18 89 5A 04 EB 2C 81 FE 00 3C 00 00 7C 0D 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 17 A1 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 8B 10 89 43 04 89 13 89 18 89 5A 04 5F 5E 5B C3 }
	condition:
		$1
}

rule function_125_0 {
	meta:
		name = "FreeCurAlloc"
		size = 74
		refs = "0002 remBytes 0014 heapErrorCode 0028 curAlloc 0037 InternalFreeMem"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 7E 40 83 3D ?? ?? ?? ?? 0C 7D 0C C7 05 ?? ?? ?? ?? 07 00 00 00 EB 2B A1 ?? ?? ?? ?? 83 C8 02 8B 15 ?? ?? ?? ?? 89 02 A1 ?? ?? ?? ?? 83 C0 04 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_126_0 {
	meta:
		name = "MergeCommit"
		size = 137
		refs = "0010 FreeCurAlloc 001b committedRoot 0020 MergeBlockAfter 0037 FillerSizeBeforeGap 0050 FillerSizeAfterGap 0069 FillBeforeGap 0074 curAlloc 007c remBytes"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8D 3C 24 A5 A5 8B FC E8 ?? ?? ?? ?? 8D 4C 24 08 8B D7 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 08 85 DB 75 04 33 C0 EB 52 8B 07 3B D8 73 0A E8 ?? ?? ?? ?? 29 07 01 47 04 8B 07 03 47 04 8B F3 03 74 24 0C 3B C6 73 08 E8 ?? ?? ?? ?? 01 47 04 8B 07 03 47 04 3B F0 75 11 83 E8 04 BA 04 00 00 00 E8 ?? ?? ?? ?? 83 6F 04 04 8B 07 A3 ?? ?? ?? ?? 8B 47 04 A3 ?? ?? ?? ?? B0 01 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_127_0 {
	meta:
		name = "NewCommit"
		size = 43
		refs = "000c GetCommitted 0019 MergeCommit"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B D4 8D 43 04 E8 ?? ?? ?? ?? 83 3C 24 00 74 0B 8B C4 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 59 5A 5B C3 }
	condition:
		$1
}

rule function_128_0 {
	meta:
		name = "NewCommitAt"
		size = 49
		refs = "0011 GetCommittedAt 001e MergeCommit"
	strings:
		$1 = { 53 56 83 C4 F8 8B F2 8B D8 8B CC 8D 56 04 8B C3 E8 ?? ?? ?? ?? 83 3C 24 00 74 0B 8B C4 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_129_0 {
	meta:
		name = "SearchSmallBlocks"
		size = 44
		refs = "0015 smallTab"
	strings:
		$1 = { 33 D2 85 C0 79 03 83 C0 03 C1 F8 02 3D 00 04 00 00 7F 16 8B 15 ?? ?? ?? ?? 8B 54 82 F4 85 D2 75 08 40 3D 01 04 00 00 75 EA 8B C2 C3 }
	condition:
		$1
}

rule function_130_0 {
	meta:
		name = "TryHarder"
		size = 244
		refs = "0007 rover 000c remBytes 0012 avail 004b SearchSmallBlocks 0058 NewCommit 007e curAlloc 0094 AllocMemCount 009d AllocMemSize 00a6 DeleteFree 00bc InsertFree"
	strings:
		$1 = { 53 56 57 55 8B F0 BF ?? ?? ?? ?? BD ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 3B 73 08 0F 8E 84 00 00 00 8B 1F 8B 43 08 3B F0 7E 7B 89 73 08 8B 5B 04 3B 73 08 7F F8 8B 17 89 42 08 3B 1F 74 04 89 1F EB 63 81 FE 00 10 00 00 7F 0D 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 4E 8B C6 E8 ?? ?? ?? ?? 84 C0 75 07 33 C0 E9 88 00 00 00 3B 75 00 7F A4 29 75 00 83 7D 00 0C 7D 08 03 75 00 33 C0 89 45 00 A1 ?? ?? ?? ?? 01 35 ?? ?? ?? ?? 8B D6 83 CA 02 89 10 83 C0 04 FF 05 ?? ?? ?? ?? 83 EE 04 01 35 ?? ?? ?? ?? EB 4C 8B C3 E8 ?? ?? ?? ?? 8B 53 08 8B C2 2B C6 83 F8 0C 7C 0C 8B D3 03 D6 92 E8 ?? ?? ?? ?? EB 12 8B F2 3B 1F 75 05 8B 43 04 89 07 8B C3 03 C6 83 20 FE 8B C3 8B D6 83 CA 02 89 10 83 C0 04 FF 05 ?? ?? ?? ?? 83 EE 04 01 35 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_131_0 {
	meta:
		name = "SysGetMem"
		size = 389
		refs = "000d initialized 0015 InitAllocator 002b SysGetMem 0037 IsMultiThread 003f heapLock 0044 EnterCriticalSection 0072 smallTab 00e0 AllocMemCount 00e9 AllocMemSize 00ee @TryFinallyExit 00f9 remBytes 011c curAlloc 014c TryHarder 016f LeaveCriticalSection 0175 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B D8 80 3D ?? ?? ?? ?? 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 33 C0 89 45 FC E9 54 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C3 07 83 E3 FC 83 FB 0C 7D 05 BB 0C 00 00 00 81 FB 00 10 00 00 0F 8F 93 00 00 00 8B C3 85 C0 79 03 83 C0 03 C1 F8 02 8B 15 ?? ?? ?? ?? 8B 54 82 F4 85 D2 74 79 8B F2 8B C6 03 C3 83 20 FE 8B 42 04 3B D0 75 1A 8B C3 85 C0 79 03 83 C0 03 C1 F8 02 8B 0D ?? ?? ?? ?? 33 FF 89 7C 81 F4 EB 26 8B CB 85 C9 79 03 83 C1 03 C1 F9 02 8B 3D ?? ?? ?? ?? 89 44 8F F4 8B 0A 89 4D F8 8B 4D F8 89 41 04 8B 4D F8 89 08 8B C6 8B 52 08 83 CA 02 89 10 83 C0 04 89 45 FC FF 05 ?? ?? ?? ?? 83 EB 04 01 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 84 00 00 00 3B 1D ?? ?? ?? ?? 7F 4A 29 1D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 7D 0D 03 1D ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 01 1D ?? ?? ?? ?? 8B D3 83 CA 02 89 10 83 C0 04 89 45 FC FF 05 ?? ?? ?? ?? 83 EB 04 01 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 32 8B C3 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_132_0 {
	meta:
		name = "SysFreeMem"
		size = 418
		refs = "000c heapErrorCode 0012 initialized 001a InitAllocator 003c SysFreeMem 0048 IsMultiThread 0050 heapLock 0055 EnterCriticalSection 0076 AllocMemCount 0086 AllocMemSize 00d0 DeleteFree 00e2 curAlloc 00f0 remBytes 0101 FreeCurAlloc 010b @TryFinallyExit 0165 InsertFree 018d LeaveCriticalSection 0193 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B D8 33 C0 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 1F E8 ?? ?? ?? ?? 84 C0 75 16 C7 05 ?? ?? ?? ?? 08 00 00 00 C7 45 FC 08 00 00 00 E9 61 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F3 83 EE 04 8B 1E F6 C3 02 75 0F C7 05 ?? ?? ?? ?? 09 00 00 00 E9 F5 00 00 00 FF 0D ?? ?? ?? ?? 8B C3 25 FC FF FF 7F 83 E8 04 29 05 ?? ?? ?? ?? F6 C3 01 74 45 8B C6 83 E8 0C 8B 50 08 83 FA 0C 7C 08 F7 C2 03 00 00 80 74 0F C7 05 ?? ?? ?? ?? 0A 00 00 00 E9 B6 00 00 00 8B C6 2B C2 3B 50 08 74 0F C7 05 ?? ?? ?? ?? 0A 00 00 00 E9 9E 00 00 00 03 DA 8B F0 E8 ?? ?? ?? ?? 81 E3 FC FF FF 7F 8B C6 03 C3 8B F8 3B 3D ?? ?? ?? ?? 75 2C 29 1D ?? ?? ?? ?? 01 1D ?? ?? ?? ?? 81 3D ?? ?? ?? ?? 00 3C 00 00 7E 05 E8 ?? ?? ?? ?? 33 C0 89 45 FC E8 ?? ?? ?? ?? E9 85 00 00 00 8B 10 F6 C2 02 74 1C 81 E2 FC FF FF 7F 83 FA 04 7D 0C C7 05 ?? ?? ?? ?? 0B 00 00 00 EB 37 83 08 01 EB 29 8B C7 83 78 04 00 74 0B 83 38 00 74 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0B 00 00 00 EB 13 8B 50 08 03 DA E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_133_0 {
	meta:
		name = "ResizeInPlace"
		size = 463
		refs = "003e curAlloc 0052 remBytes 008c DeleteFree 00a8 InternalFreeMem 010e AllocMemSize 0127 FreeCurAlloc 016f InsertFree 019a NewCommitAt"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 83 C6 07 83 E6 FC 83 FE 0C 7D 05 BE 0C 00 00 00 8B E8 83 ED 04 8B 7D 00 81 E7 FC FF FF 7F 8B C5 03 C7 8B D8 3B FE 0F 8C 83 00 00 00 8B D7 2B D6 89 14 24 3B 1D ?? ?? ?? ?? 75 38 8B 04 24 29 05 ?? ?? ?? ?? 8B 04 24 01 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 0F 8D 4C 01 00 00 8B 04 24 01 05 ?? ?? ?? ?? 8B 04 24 29 05 ?? ?? ?? ?? 8B F7 E9 33 01 00 00 8B D8 F6 03 02 75 0D 8B C3 8B 50 08 01 14 24 E8 ?? ?? ?? ?? 83 3C 24 0C 7C 1B 8B DD 03 DE 8B 04 24 83 C8 02 89 03 8B C3 83 C0 04 E8 ?? ?? ?? ?? E9 FE 00 00 00 8B F7 E9 F7 00 00 00 8B C6 2B C7 89 44 24 04 3B 1D ?? ?? ?? ?? 75 67 A1 ?? ?? ?? ?? 3B 44 24 04 7C 53 8B 44 24 04 29 05 ?? ?? ?? ?? 8B 44 24 04 01 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 7D 18 A1 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 03 35 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B C6 2B C7 01 05 ?? ?? ?? ?? 8B 45 00 25 03 00 00 80 0B F0 89 75 00 B0 01 E9 A2 00 00 00 E8 ?? ?? ?? ?? 8B DD 03 DF F6 03 02 75 4D 8B D3 8B C2 8B 48 08 89 0C 24 8B 0C 24 3B 4C 24 04 7D 0E 03 14 24 8B DA 8B 04 24 29 44 24 04 EB 2C E8 ?? ?? ?? ?? 8B 44 24 04 29 04 24 83 3C 24 0C 7C 0E 8B C5 03 C6 8B 14 24 E8 ?? ?? ?? ?? EB 3A 03 34 24 8B DD 03 DE 83 23 FE EB 2E 8B 03 A9 00 00 00 80 74 21 25 FC FF FF 7F 03 C3 8B D8 8B 54 24 04 8B C3 E8 ?? ?? ?? ?? 84 C0 74 09 8B DD 03 DF E9 0D FF FF FF 33 C0 EB 19 8B C6 2B C7 01 05 ?? ?? ?? ?? 8B 45 00 25 03 00 00 80 0B F0 89 75 00 B0 01 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_134_0 {
	meta:
		name = "SysReallocMem"
		size = 193
		refs = "000d initialized 0015 InitAllocator 002b SysReallocMem 0037 IsMultiThread 003f heapLock 0044 EnterCriticalSection 004d ResizeInPlace 005d SysGetMem 0082 Move 0089 SysFreeMem 00ac LeaveCriticalSection 00b2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 8B D8 80 3D ?? ?? ?? ?? 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 33 C0 89 45 FC E9 91 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 05 89 5D FC EB 36 8B C6 E8 ?? ?? ?? ?? 8B F8 8B C3 83 E8 04 8B 00 25 FC FF FF 7F 83 E8 04 3B F0 7D 02 8B C6 85 FF 74 11 8B D7 8B CB 91 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 89 7D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_135_0 {
	meta:
		name = "BlockSum"
		size = 20
	strings:
		$1 = { 33 C9 8B 10 3B C2 74 09 03 4A 0C 8B 12 3B C2 75 F7 8B C1 C3 }
	condition:
		$1
}

rule function_136_0 {
	meta:
		name = "GetHeapStatus"
		size = 652
		refs = "000d heapErrorCode 0044 initialized 0053 GetHeapStatus 005f IsMultiThread 0067 heapLock 006c EnterCriticalSection 0071 spaceRoot 0076 BlockSum 007d decommittedRoot 008a committedRoot 009e smallTab 00eb avail 0122 remBytes 016e curAlloc 027a LeaveCriticalSection 0280 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B F0 33 C0 A3 ?? ?? ?? ?? 33 C0 89 06 33 C0 89 46 04 33 C0 89 46 08 33 C0 89 46 0C 33 C0 89 46 10 33 C0 89 46 14 33 C0 89 46 18 33 C0 89 46 1C 33 C0 89 46 20 33 C0 89 46 24 80 3D ?? ?? ?? ?? 00 0F 84 37 02 00 00 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 06 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 33 C9 BA 03 00 00 00 A1 ?? ?? ?? ?? 8B 44 90 F4 85 C0 74 32 03 48 08 8B 18 3B 43 04 75 0D 8B 58 04 3B 03 75 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0F 8B 40 04 8B 1D ?? ?? ?? ?? 3B 44 93 F4 75 CE 42 81 FA 01 04 00 00 75 B8 89 4E 14 33 C9 A1 ?? ?? ?? ?? EB 26 8B 10 3B 42 04 75 0D 8B 50 04 3B 02 75 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0D 03 48 08 8B 40 04 3D ?? ?? ?? ?? 75 D3 89 4E 18 A1 ?? ?? ?? ?? 89 46 1C 8B 56 14 03 56 18 03 D0 89 56 10 33 C0 89 45 FC 33 C0 89 45 F8 33 C0 89 46 20 A1 ?? ?? ?? ?? 89 45 F0 33 C0 E9 DE 00 00 00 8B 55 F0 8B 52 08 8B 4D F0 8B 49 0C 03 CA 89 4D F4 3B 55 F4 0F 83 BC 00 00 00 3B 15 ?? ?? ?? ?? 75 27 83 3D ?? ?? ?? ?? 00 7E 1E 8B 0D ?? ?? ?? ?? 01 4D FC 84 C0 74 0A C7 05 ?? ?? ?? ?? 07 00 00 00 33 C0 E9 82 00 00 00 8B CA F6 01 01 0F 95 C3 3A C3 74 0A C7 05 ?? ?? ?? ?? 0B 00 00 00 8B 01 A8 02 75 2A 8B C1 8B 08 3B 41 04 75 0D 8B 48 04 3B 01 75 06 83 78 08 0C 7D 0A C7 05 ?? ?? ?? ?? 0D 00 00 00 8B 48 08 01 4D FC B0 01 EB 3C 8B C8 81 E1 FC FF FF 7F A9 00 00 00 80 74 1F 01 4E 20 8B 45 F0 3B 50 08 76 20 8D 04 11 3B 45 F4 73 18 C7 05 ?? ?? ?? ?? 09 00 00 00 EB 0C 8B C1 83 E8 04 01 45 F8 83 46 20 04 33 C0 03 D1 3B 55 F4 0F 82 44 FF FF FF 8B 55 F0 8B 12 89 55 F0 BA ?? ?? ?? ?? 3B 55 F0 0F 85 14 FF FF FF 8B 46 10 3B 45 FC 74 0A C7 05 ?? ?? ?? ?? 0E 00 00 00 8B 45 F8 89 46 0C A1 ?? ?? ?? ?? 89 46 24 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_137_0 {
	meta:
		name = "@GetMem"
		size = 23
		refs = "0006 MemoryManager 0012 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 09 C0 74 01 C3 B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_138_0 {
	meta:
		name = "@FreeMem"
		size = 23
		refs = "0006 MemoryManager 0012 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 09 C0 75 01 C3 B0 02 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_139_0 {
	meta:
		name = "@ReallocMem"
		size = 77
		refs = "000f MemoryManager 001e Error"
	strings:
		$1 = { 8B 08 85 C9 74 32 85 D2 74 18 50 89 C8 FF 15 ?? ?? ?? ?? 59 09 C0 74 19 89 01 C3 B0 02 E9 ?? ?? ?? ?? 89 10 89 C8 FF 15 ?? ?? ?? ?? 09 C0 75 EB C3 B0 01 E9 ?? ?? ?? ?? 85 D2 74 10 50 89 D0 FF 15 ?? ?? ?? ?? 59 09 C0 74 E7 89 01 C3 }
	condition:
		$1
}

rule function_140_0 {
	meta:
		name = "GetMemoryManager"
		size = 27
		refs = "0002 MemoryManager"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 8B 15 ?? ?? ?? ?? 89 50 04 8B 15 ?? ?? ?? ?? 89 50 08 C3 }
	condition:
		$1
}

rule function_141_0 {
	meta:
		name = "SetMemoryManager"
		size = 27
		refs = "0004 MemoryManager"
	strings:
		$1 = { 8B 10 89 15 ?? ?? ?? ?? 8B 50 04 89 15 ?? ?? ?? ?? 8B 50 08 89 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_142_0 {
	meta:
		name = "IsMemoryManagerSet"
		size = 45
		refs = "0001 SysGetMem 0007 MemoryManager 000e SysFreeMem 001b SysReallocMem"
	strings:
		$1 = { B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 1D B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 10 B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_143_0 {
	meta:
		name = "RaiseList"
		size = 12
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "SetRaiseList"
		size = 22
		refs = "0003 @GetTls 0009 RaiseListPtr"
	strings:
		$1 = { 89 C1 E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 89 88 ?? ?? ?? ?? 89 D0 C3 }
	condition:
		$1
}

rule function_145_0 {
	meta:
		name = "Error"
		size = 66
		refs = "0005 ErrorProc 0013 Error 001a @GetTls 0020 InOutRes 0025 @RunError"
	strings:
		$1 = { 83 E0 7F 8B 0D ?? ?? ?? ?? 85 C9 74 03 5A FF D1 48 8A 80 ?? ?? ?? ?? 79 0B E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 ?? ?? ?? ?? CB CC C8 C9 D7 CF C8 CD CE DB D8 CA D9 DA DC DD DE DF E0 E1 E3 00 E4 E5 C3 }
	condition:
		$1
}

rule function_146_0 {
	meta:
		name = "@_IOTest"
		size = 29
		refs = "0004 @GetTls 000a InOutRes 0018 Error"
	strings:
		$1 = { 50 52 51 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 59 5A 58 75 01 C3 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_147_0 {
	meta:
		name = "SetInOutRes"
		size = 13
		refs = "0002 @GetTls 0008 InOutRes"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 8F 80 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_149_0 {
	meta:
		name = "@ChDir"
		size = 28
		refs = "0006 @LStrToPChar 000c SetCurrentDirectory 0016 InOutError"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_165_0 {
	meta:
		name = "@RmDir"
		size = 28
		refs = "0006 @LStrToPChar 000c RemoveDirectory 0016 InOutError"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_150_0 {
	meta:
		name = "@Copy"
		size = 65
	strings:
		$1 = { 56 57 89 C6 8B 7C 24 0C 31 C0 0A 06 74 2B 85 D2 7E 18 39 C2 7F 1B 29 D0 40 85 C9 7C 14 39 C1 7F 14 01 D6 88 0F 47 F3 A4 EB 11 BA 01 00 00 00 EB E5 31 C9 EB EC 89 C1 EB E8 88 07 5F 5E C2 04 00 C3 }
	condition:
		$1
}

rule function_151_0 {
	meta:
		name = "@Delete"
		size = 45
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 85 D2 7E 1E 39 C2 7F 1A 85 C9 7E 16 29 D0 40 39 C1 7E 02 89 C1 28 0F 01 D7 8D 34 0F 29 C8 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_152_0 {
	meta:
		name = "@LGetDir"
		size = 118
		refs = "0033 GetCurrentDirectory 0039 SetCurrentDirectory 0069 @LStrFromArray"
	strings:
		$1 = { 53 56 81 C4 F4 FD FF FF 8B F2 8B D8 84 DB 74 2D 33 C0 8A C3 83 C0 41 48 88 04 24 C6 44 24 01 3A C6 44 24 02 00 8D 84 24 08 01 00 00 50 68 04 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 04 50 68 04 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 08 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 04 B9 04 01 00 00 E8 ?? ?? ?? ?? 81 C4 0C 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_153_0 {
	meta:
		name = "@SGetDir"
		size = 116
		refs = "0018 @SGetDir 002b @LGetDir 003e @LStrToString 004d @PStrNCpy 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 DB 89 5D FC 8B F1 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC 25 FF 00 00 00 E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_154_0 {
	meta:
		name = "@Insert"
		size = 102
	strings:
		$1 = { 53 56 57 51 8B 4C 24 14 81 EC 00 02 00 00 89 D3 89 D6 31 D2 8A 16 46 42 85 C9 7E 32 39 D1 7F 35 4A 89 E7 49 29 CA F3 A4 96 8A 0E 46 F3 A4 89 C6 89 D1 F3 A4 29 E7 8B 8C 24 00 02 00 00 39 F9 72 02 89 F9 89 DF 89 E6 88 0F 47 F3 A4 EB 0B B9 01 00 00 00 EB CB 89 D1 EB C7 81 C4 04 02 00 00 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_155_0 {
	meta:
		name = "IOResult"
		size = 22
		refs = "0001 @GetTls 0009 InOutRes"
	strings:
		$1 = { E8 ?? ?? ?? ?? 31 D2 8B 88 ?? ?? ?? ?? 89 90 ?? ?? ?? ?? 89 C8 C3 }
	condition:
		$1
}

rule function_156_0 {
	meta:
		name = "@MkDir"
		size = 30
		refs = "0008 @LStrToPChar 000e CreateDirectory 0018 InOutError"
	strings:
		$1 = { 53 8B D8 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_157_0 {
	meta:
		name = "Move"
		size = 64
	strings:
		$1 = { 56 57 89 C6 89 D7 89 C8 39 F7 77 13 74 2F C1 F9 02 78 2A F3 A5 89 C1 83 E1 03 F3 A4 5F 5E C3 8D 74 0E FC 8D 7C 0F FC C1 F9 02 78 11 FD F3 A5 89 C1 83 E1 03 83 C6 03 83 C7 03 F3 A4 FC 5F 5E C3 }
	condition:
		$1
}

rule function_158_0 {
	meta:
		name = "GetParamStr"
		size = 118
		refs = "0067 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 81 C4 04 F0 FF FF 50 8B F2 8B D8 EB 01 43 8A 03 84 C0 74 04 3C 20 76 F5 80 3B 22 75 0B 80 7B 01 22 75 05 83 C3 02 EB E6 33 C0 EB 25 80 FA 22 75 1B 43 EB 05 88 14 04 40 43 8A 13 84 D2 74 05 80 FA 22 75 F0 80 3B 00 74 08 43 EB 05 88 14 04 40 43 8A 13 80 FA 20 76 07 3D 00 10 00 00 7C CD 8B D4 8B CE 91 E8 ?? ?? ?? ?? 8B C3 81 C4 00 10 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_159_0 {
	meta:
		name = "ParamCount"
		size = 95
		refs = "000b ParamCount 0016 GetCommandLine 001e GetParamStr 004c @LStrClr 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B D8 33 F6 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 03 46 EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_160_0 {
	meta:
		name = "ParamStr"
		size = 87
		refs = "001e GetModuleFileName 0029 @LStrFromPCharLen 0030 GetCommandLine 003b GetParamStr"
	strings:
		$1 = { 53 56 57 81 C4 F8 FE FF FF 8B F2 8B D8 85 DB 75 1E 68 05 01 00 00 8D 44 24 04 50 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 1E E8 ?? ?? ?? ?? 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F8 85 DB 74 08 83 3E 00 74 03 4B EB E9 81 C4 08 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_161_0 {
	meta:
		name = "@Pos"
		size = 62
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C9 8A 0F 47 57 31 D2 8A 16 46 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 09 89 D9 EB EC 5A 31 C0 EB 05 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_163_0 {
	meta:
		name = "@SetString"
		size = 14
		refs = "0009 Move"
	strings:
		$1 = { 88 08 85 D2 74 07 92 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_164_0 {
	meta:
		name = "Randomize"
		size = 59
		refs = "000b GetSystemTime 0033 RandSeed"
	strings:
		$1 = { 55 8B EC 83 C4 E8 8D 45 E8 50 E8 ?? ?? ?? ?? 0F B7 45 F0 6B C0 3C 66 03 45 F2 6B C0 3C 31 D2 66 8B 55 F4 01 D0 69 C0 E8 03 00 00 66 8B 55 F6 01 D0 89 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_166_0 {
	meta:
		name = "UpCase"
		size = 14
	strings:
		$1 = { 80 F8 61 72 08 80 F8 7A 77 03 80 E8 20 C3 }
	condition:
		$1
}

rule function_167_0 {
	meta:
		name = "Set8087CW"
		size = 16
		refs = "0003 Default8087CW"
	strings:
		$1 = { 66 89 05 ?? ?? ?? ?? DB E2 D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_168_0 {
	meta:
		name = "@COS"
		size = 13
	strings:
		$1 = { D9 FF DF E0 9E 7A 01 C3 DD D8 D9 EE C3 }
	condition:
		$1
}

rule function_169_0 {
	meta:
		name = "@EXP"
		size = 23
	strings:
		$1 = { D9 EA DE C9 D9 C0 D9 FC DC E9 D9 C9 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule function_170_0 {
	meta:
		name = "@INT"
		size = 24
		refs = "000a cwChop"
	strings:
		$1 = { 83 EC 04 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? D9 FC 9B D9 2C 24 83 C4 04 C3 }
	condition:
		$1
}

rule function_171_0 {
	meta:
		name = "@SIN"
		size = 13
	strings:
		$1 = { D9 FE DF E0 9E 7A 01 C3 DD D8 D9 EE C3 }
	condition:
		$1
}

rule function_172_0 {
	meta:
		name = "@FRAC"
		size = 28
		refs = "000c cwChop"
	strings:
		$1 = { D9 C0 83 EC 04 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? D9 FC 9B D9 2C 24 83 C4 04 DE E9 C3 }
	condition:
		$1
}

rule function_173_0 {
	meta:
		name = "@ROUND"
		size = 10
	strings:
		$1 = { 83 EC 08 DF 3C 24 9B 58 5A C3 }
	condition:
		$1
}

rule function_174_0 {
	meta:
		name = "@TRUNC"
		size = 26
		refs = "000a cwChop"
	strings:
		$1 = { 83 EC 0C 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? DF 7C 24 04 9B D9 2C 24 59 58 5A C3 }
	condition:
		$1
}

rule function_175_0 {
	meta:
		name = "@AbstractError"
		size = 26
		refs = "0002 AbstractErrorProc 0015 @RunError"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? B8 D2 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_176_0 {
	meta:
		name = "@PStrCat"
		size = 40
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 C9 8A 0E 46 88 C2 00 CA 72 0A 88 17 47 01 C7 F3 A4 5F 5E C3 FE C2 28 D1 B2 FF EB EE C3 }
	condition:
		$1
}

rule function_177_0 {
	meta:
		name = "@PStrNCat"
		size = 48
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 D2 8A 16 46 00 D0 72 12 38 C8 77 0E 89 D1 8A 17 88 07 47 01 D7 F3 A4 5F 5E C3 88 C8 2A 0F 76 F7 88 CA EB E8 C3 }
	condition:
		$1
}

rule function_178_0 {
	meta:
		name = "@PStrCpy"
		size = 28
	strings:
		$1 = { 31 C9 56 57 8A 0A 89 C7 41 89 D6 89 C8 C1 E9 02 83 E0 03 F3 A5 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_179_0 {
	meta:
		name = "@PStrNCpy"
		size = 47
	strings:
		$1 = { 56 57 89 C7 31 C0 89 D6 8A 02 38 C8 77 12 40 89 C1 83 E0 03 C1 E9 02 F3 A5 89 C1 F3 A4 5F 5E C3 88 0F 46 47 81 E1 FF 00 00 00 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_180_0 {
	meta:
		name = "@PStrCmp"
		size = 130
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C0 31 D2 8A 06 8A 17 46 47 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 44 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 37 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 1C 8A 0E 3A 0F 75 2F 4A 74 13 8A 4E 01 3A 4F 01 75 24 4A 74 08 8A 4E 02 3A 4F 02 75 19 01 C0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_181_0 {
	meta:
		name = "@AStrCmp"
		size = 111
	strings:
		$1 = { 53 56 51 89 CE C1 EE 02 74 26 8B 08 8B 1A 39 D9 75 45 4E 74 15 8B 48 04 8B 5A 04 39 D9 75 38 83 C0 08 83 C2 08 4E 75 E2 EB 06 83 C0 04 83 C2 04 5E 83 E6 03 74 36 8A 08 3A 0A 75 30 4E 74 13 8A 48 01 3A 4A 01 75 25 4E 74 08 8A 48 02 3A 4A 02 75 1A 31 C0 5E 5B C3 5E 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5E 5B C3 }
	condition:
		$1
}

rule function_182_0 {
	meta:
		name = "@FillChar"
		size = 31
	strings:
		$1 = { 57 89 C7 88 CD 89 C8 C1 E0 10 66 89 C8 89 D1 C1 F9 02 78 09 F3 AB 89 D1 83 E1 03 F3 AA 5F C3 }
	condition:
		$1
}

rule function_183_0 {
	meta:
		name = "@Mark"
		size = 8
		refs = "0003 Error"
		altNames = "@Release"
	strings:
		$1 = { B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_184_0 {
	meta:
		name = "@RandInt"
		size = 22
		refs = "0002 RandSeed"
	strings:
		$1 = { 69 15 ?? ?? ?? ?? 05 84 08 08 42 89 15 ?? ?? ?? ?? F7 E2 89 D0 C3 }
	condition:
		$1
}

rule function_185_0 {
	meta:
		name = "@RandExt"
		size = 35
		refs = "0002 RandSeed 0013 two2neg32"
	strings:
		$1 = { 69 15 ?? ?? ?? ?? 05 84 08 08 42 89 15 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 6A 00 52 DF 2C 24 83 C4 08 DE C9 C3 }
	condition:
		$1
}

rule function_187_0 {
	meta:
		name = "@StrLong"
		size = 95
	strings:
		$1 = { 53 56 57 52 83 EC 14 89 CF 89 C6 99 31 D0 29 D0 B9 0A 00 00 00 31 DB 31 D2 F7 F1 83 C2 30 88 14 1C 43 85 C0 75 F1 85 F6 7D 05 C6 04 1C 2D 43 88 1F 47 8B 4C 24 14 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 29 D9 7E 07 00 4F FF B0 20 F3 AA 8A 44 1C FF 88 07 47 4B 75 F6 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_188_0 {
	meta:
		name = "@Str0Long"
		size = 10
		refs = "0005 @StrLong"
	strings:
		$1 = { 89 D1 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_189_0 {
	meta:
		name = "@ValLong"
		size = 204
	strings:
		$1 = { 53 56 57 89 C6 50 85 C0 74 73 31 C0 31 DB BF CC CC CC 0C 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 69 80 FB 2B 74 66 80 FB 24 74 66 80 FB 78 74 61 80 FB 58 74 5C 80 FB 30 75 13 8A 1E 46 80 FB 78 74 4F 80 FB 58 74 4A 84 DB 74 20 EB 04 84 DB 74 34 80 EB 30 80 FB 09 77 2C 39 F8 77 28 8D 04 80 01 C0 01 D8 8A 1E 46 84 DB 75 E6 FE CD 74 10 85 C0 7C 12 59 31 F6 89 32 5F 5E 5B C3 46 EB 06 F7 D8 7E F0 78 EE 5B 29 DE EB EC FE C5 8A 1E 46 EB BC BF FF FF FF 0F 8A 1E 46 84 DB 74 DF 80 FB 61 72 03 80 EB 20 80 EB 30 80 FB 09 76 0B 80 EB 11 80 FB 05 77 D0 80 C3 0A 39 F8 77 C9 C1 E0 04 01 D8 8A 1E 46 84 DB 75 D5 EB A9 C3 }
	condition:
		$1
}

rule function_190_0 {
	meta:
		name = "@WriteBool"
		size = 36
		refs = "0005 @WriteBool 000a @WriteString"
	strings:
		$1 = { 84 D2 74 0A BA ?? ?? ?? ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? E9 ?? ?? ?? ?? 04 54 52 55 45 05 46 41 4C 53 45 C3 }
	condition:
		$1
}

rule function_191_0 {
	meta:
		name = "@Write0Bool"
		size = 8
		refs = "0003 @WriteBool"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "@Write0LString"
		size = 8
		refs = "0003 @WriteLString"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_193_0 {
	meta:
		name = "@Write0Long"
		size = 8
		refs = "0003 @WriteLong"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_192_0 {
	meta:
		name = "@WriteLong"
		size = 38
		refs = "0015 @StrLong 001e @WriteString"
	strings:
		$1 = { 83 EC 20 50 51 89 D0 31 D2 83 F9 1F 7F 02 89 CA 8D 4C 24 08 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C3 }
	condition:
		$1
}

rule function_194_0 {
	meta:
		name = "@Write2Ext"
		size = 50
		refs = "001b @Str2Ext 0024 @WriteString"
	strings:
		$1 = { DB 6C 24 04 81 EC 00 01 00 00 50 52 83 EC 0C DB 3C 24 89 D0 89 CA 8D 4C 24 14 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 C2 0C 00 C3 }
	condition:
		$1
}

rule function_195_0 {
	meta:
		name = "@Write1Ext"
		size = 9
		refs = "0004 @Write2Ext"
	strings:
		$1 = { 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_196_0 {
	meta:
		name = "@Write0Ext"
		size = 14
		refs = "0009 @Write2Ext"
	strings:
		$1 = { BA 17 00 00 00 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_197_0 {
	meta:
		name = "@_CToPasStr"
		size = 23
	strings:
		$1 = { 50 B1 FF 8A 2A 42 84 ED 74 07 40 88 28 FE C9 75 F2 5A 29 D0 88 02 C3 }
	condition:
		$1
}

rule function_198_0 {
	meta:
		name = "@_CLenToPasStr"
		size = 35
	strings:
		$1 = { 53 50 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 8A 1A 42 84 DB 74 06 40 88 18 49 75 F3 5A 29 D0 88 02 5B C3 }
	condition:
		$1
}

rule function_199_0 {
	meta:
		name = "@_ArrayToPasStr"
		size = 23
		refs = "0012 Move"
	strings:
		$1 = { 92 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 88 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "@_PasToCStr"
		size = 18
	strings:
		$1 = { 56 57 89 C6 89 D7 31 C9 8A 0E 46 F3 A4 88 0F 5F 5E C3 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "@SetElem"
		size = 34
	strings:
		$1 = { 53 57 89 C7 31 DB 88 CB 89 D9 31 C0 F3 AA 29 DF 40 88 D1 D2 C0 C1 E9 03 39 D9 73 03 08 04 0F 5F 5B C3 }
	condition:
		$1
}

rule function_202_0 {
	meta:
		name = "@SetRange"
		size = 86
	strings:
		$1 = { 53 56 57 31 DB 88 E3 0F B6 F0 0F B6 D2 89 CF 89 D9 31 C0 F3 AA 29 DF C1 E3 03 39 DA 72 03 8D 53 FF 39 D6 77 2D 48 89 F1 80 E1 07 D2 E0 C1 EE 03 88 D1 F6 D1 80 E1 07 D2 EC C1 EA 03 01 F7 89 D1 29 F1 75 06 20 E0 88 07 EB 08 AA 49 B0 FF F3 AA 88 27 5F 5E 5B C3 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "@SetEq"
		size = 17
	strings:
		$1 = { 56 57 89 C6 89 D7 81 E1 FF 00 00 00 F3 A6 5F 5E C3 }
	condition:
		$1
}

rule function_204_0 {
	meta:
		name = "@SetLe"
		size = 15
	strings:
		$1 = { 8A 2A F6 D5 22 28 75 06 42 40 FE C9 75 F2 C3 }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "@SetIntersect"
		size = 11
	strings:
		$1 = { 8A 2A 42 20 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_206_0 {
	meta:
		name = "@SetIntersect3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 0A FF 22 5C 0E FF 88 5C 08 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_207_0 {
	meta:
		name = "@SetUnion"
		size = 11
	strings:
		$1 = { 8A 2A 42 08 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_208_0 {
	meta:
		name = "@SetUnion3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 0A FF 0A 5C 0E FF 88 5C 08 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "@SetSub"
		size = 13
	strings:
		$1 = { 8A 2A F6 D5 42 20 28 40 FE C9 75 F4 C3 }
	condition:
		$1
}

rule function_210_0 {
	meta:
		name = "@SetSub3"
		size = 26
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 0E FF F6 D3 22 5C 0A FF 88 5C 08 FF 49 75 EF 5E 5B C3 }
	condition:
		$1
}

rule function_211_0 {
	meta:
		name = "@SetExpand"
		size = 31
	strings:
		$1 = { 56 57 89 C6 89 D7 89 CA 31 C9 31 C0 88 D1 F3 AA 88 F1 28 D1 F3 A4 B1 20 28 F1 F3 AA 5F 5E C3 }
	condition:
		$1
}

rule function_212_0 {
	meta:
		name = "@ObjSetup"
		size = 95
		refs = "0015 MemoryManager"
	strings:
		$1 = { 83 FA 01 73 01 C3 51 85 C0 75 44 8B 42 F8 85 C0 74 36 52 FF 15 ?? ?? ?? ?? 5A 85 C0 74 26 57 8B 4A F8 89 C7 50 31 C0 C1 E9 02 F3 AB 8B 4A F8 83 E1 03 F3 AA 58 5F 8B 4A FC 85 C9 7C 03 89 14 08 85 C0 59 C3 31 D2 59 C3 31 D2 83 F8 01 59 C3 8B 4A FC 85 C9 7C 03 89 14 08 31 D2 85 C0 59 C3 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "@ObjCopy"
		size = 35
	strings:
		$1 = { 53 56 57 89 D6 89 C7 8D 04 0F 8B 10 8B 5A F8 89 D9 C1 E9 02 F3 A5 89 D9 83 E1 03 F3 A4 89 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "@Fail"
		size = 12
		refs = "0005 @FreeMem"
	strings:
		$1 = { 85 D2 74 05 E8 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "@isNECWindows"
		size = 47
		refs = "0006 GetKeyboardType"
	strings:
		$1 = { 53 33 DB 6A 00 E8 ?? ?? ?? ?? 83 F8 07 75 1C 6A 01 E8 ?? ?? ?? ?? 25 00 FF 00 00 3D 00 0D 00 00 74 07 3D 00 04 00 00 75 02 B3 01 8B C3 5B C3 }
	condition:
		$1
}

rule function_217_0 {
	meta:
		name = "@FpuMaskInit"
		size = 196
		refs = "0009 Default8087CW 0019 @FpuMaskInit 0023 RegOpenKeyEx 0056 RegQueryValueEx 006c RegCloseKey 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 0F B7 05 ?? ?? ?? ?? 89 45 F8 8D 45 FC 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 4D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 F4 04 00 00 00 8D 45 F4 50 8D 45 F8 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 66 A1 ?? ?? ?? ?? 66 25 C0 FF 66 8B 55 F8 66 83 E2 3F 66 0B C2 66 A3 ?? ?? ?? ?? 8B E5 5D C3 00 53 4F 46 54 57 41 52 45 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 52 54 4C 00 46 50 55 4D 61 73 6B 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "@FpuInit"
		size = 10
		refs = "0005 Default8087CW"
	strings:
		$1 = { DB E3 9B D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_219_0 {
	meta:
		name = "@BoundErr"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_220_0 {
	meta:
		name = "@IntOver"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_222_0 {
	meta:
		name = "TObject.ClassName"
		size = 17
	strings:
		$1 = { 56 57 89 D7 8B 70 D4 31 C9 8A 0E 41 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_223_0 {
	meta:
		name = "TObject.ClassNameIs"
		size = 39
	strings:
		$1 = { 53 31 DB 09 D2 74 1C 8B 40 D4 31 C9 8A 08 3B 4A FC 75 10 4A 8A 3C 08 32 3C 0A 80 E7 DF 75 04 49 75 F2 43 88 D8 5B C3 }
	condition:
		$1
}

rule function_224_0 {
	meta:
		name = "TObject.ClassParent"
		size = 10
	strings:
		$1 = { 8B 40 DC 85 C0 74 02 8B 00 C3 }
	condition:
		$1
}

rule function_225_0 {
	meta:
		name = "TObject.NewInstance"
		size = 18
		refs = "0005 @GetMem 000d TObject.InitInstance"
	strings:
		$1 = { 50 8B 40 D8 E8 ?? ?? ?? ?? 89 C2 58 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_226_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 37
		refs = "0013 @FinalizeRecord 001e @FreeMem"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 C0 8B 76 DC 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_227_0 {
	meta:
		name = "TObject.InstanceSize"
		size = 4
	strings:
		$1 = { 8B 40 D8 C3 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "TObject.Create"
		size = 32
		refs = "0008 @ClassCreate 0011 @AfterConstruction"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "TObject.Destroy"
		size = 15
		refs = "0001 @BeforeDestruction 000a @ClassDestroy"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 D2 7E 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "TObject.Free"
		size = 12
	strings:
		$1 = { 85 C0 74 07 8B 08 B2 01 FF 51 FC C3 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "TObject.InitInstance"
		size = 86
	strings:
		$1 = { 53 56 57 89 C3 89 D7 AB 8B 4B D8 31 C0 51 C1 E9 02 49 F3 AB 59 83 E1 03 F3 AA 89 D0 89 E2 8B 4B B8 85 C9 74 01 51 8B 5B DC 85 DB 74 04 8B 1B EB ED 39 D4 74 1D 5B 8B 0B 83 C3 04 8B 73 10 85 F6 74 06 8B 7B 14 89 34 38 83 C3 1C 49 75 ED 39 D4 75 E3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "TObject.CleanupInstance"
		size = 32
		refs = "0013 @FinalizeRecord"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 C0 8B 76 DC 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 5E 5B C3 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "InvokeImplGetter"
		size = 45
		refs = "0028 @IntfCopy"
	strings:
		$1 = { 87 CA 81 F9 00 00 00 FF 73 11 81 F9 00 00 00 FE 72 07 0F BF C9 03 08 FF 21 FF E1 81 E1 FF FF FF 00 01 C1 89 D0 8B 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "TObject.GetInterface"
		size = 158
		refs = "0019 TObject.GetInterface 0029 TObject.GetInterfaceEntry 0049 InvokeImplGetter 0053 @IntfCopy 0089 @IntfClear 008f @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B F9 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 55 FC 8B 06 E8 ?? ?? ?? ?? 8B D8 85 DB 74 3F 8B 43 14 85 C0 74 06 03 F0 89 37 EB 17 8D 4D F8 8B 53 18 8B C6 E8 ?? ?? ?? ?? 8B 55 F8 8B C7 E8 ?? ?? ?? ?? 83 3F 00 74 12 83 7B 14 00 74 08 8B 07 50 8B 00 FF 50 04 B3 01 EB 0A 33 DB EB 06 33 C0 89 07 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "TObject.GetInterfaceEntry"
		size = 68
	strings:
		$1 = { 53 56 89 C3 8B 43 B8 85 C0 74 29 8B 08 83 C0 04 8B 32 3B 30 75 18 8B 72 04 3B 70 04 75 10 8B 72 08 3B 70 08 75 08 8B 72 0C 3B 70 0C 74 13 83 C0 1C 49 75 DC 8B 5B DC 85 DB 74 04 8B 1B EB C5 31 C0 5E 5B C3 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "TObject.GetInterfaceTable"
		size = 4
	strings:
		$1 = { 8B 40 B8 C3 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "@IsClass"
		size = 21
	strings:
		$1 = { 85 C0 74 10 8B 00 39 D0 74 08 8B 40 DC 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "@AsClass"
		size = 27
		refs = "0016 Error"
	strings:
		$1 = { 85 C0 74 16 89 C1 8B 09 39 D1 74 0E 8B 49 DC 85 C9 75 F3 B0 0A E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "GetDynaMethod"
		size = 46
	strings:
		$1 = { 57 93 EB 02 8B 1B 8B 7B D0 85 FF 74 0D 0F B7 0F 51 83 C7 02 66 F2 AF 74 0A 59 8B 5B DC 85 DB 75 E3 5F C3 58 01 C0 29 C8 8B 5C 47 FC 5F C3 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "@CallDynaInst"
		size = 22
		refs = "0005 GetDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 50 51 8B 00 E8 ?? ?? ?? ?? 59 58 74 02 FF E3 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "@CallDynaClass"
		size = 20
		refs = "0003 GetDynaMethod 000f @AbstractError"
	strings:
		$1 = { 50 51 E8 ?? ?? ?? ?? 59 58 74 02 FF E3 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "@FindDynaInst"
		size = 22
		refs = "0006 GetDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 53 89 D3 8B 00 E8 ?? ?? ?? ?? 89 D8 5B 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "@FindDynaClass"
		size = 20
		refs = "0004 GetDynaMethod 000f @AbstractError"
	strings:
		$1 = { 53 89 D3 E8 ?? ?? ?? ?? 89 D8 5B 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "TObject.InheritsFrom"
		size = 19
	strings:
		$1 = { EB 02 8B 00 39 D0 74 08 8B 40 DC 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_245_0 {
	meta:
		name = "TObject.ClassInfo"
		size = 4
	strings:
		$1 = { 8B 40 C4 C3 }
	condition:
		$1
}

rule function_246_0 {
	meta:
		name = "TObject.SafeCallException"
		size = 6
	strings:
		$1 = { B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "TObject.Dispatch"
		size = 39
		refs = "0014 GetDynaMethod"
	strings:
		$1 = { 53 66 8B 1A 66 09 DB 74 17 66 81 FB 00 C0 73 10 50 8B 00 E8 ?? ?? ?? ?? 58 74 05 89 D9 5B FF E1 5B 8B 08 FF 61 F0 C3 }
	condition:
		$1
}

rule function_251_0 {
	meta:
		name = "TObject.MethodAddress"
		size = 78
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A EB 02 8B 00 8B 70 CC 85 F6 74 15 66 8B 3E 83 C6 02 8A 4E 06 38 D9 74 15 66 8B 0E 01 CE 4F 75 F1 8B 40 DC 85 C0 75 DB EB 18 8A 1A EB EB B5 00 8A 5C 0E 06 32 1C 0A 80 E3 DF 75 EE 49 75 F1 8B 46 02 5F 5E 5B C3 }
	condition:
		$1
}

rule function_252_0 {
	meta:
		name = "TObject.MethodName"
		size = 64
	strings:
		$1 = { 53 56 57 89 CF 31 DB 31 C9 EB 02 8B 00 8B 70 CC 85 F6 74 13 66 8B 0E 83 C6 02 3B 56 02 74 13 66 8B 1E 01 DE 49 75 F3 8B 40 DC 85 C0 75 DD 88 07 EB 0A 83 C6 06 31 C9 8A 0E 41 F3 A4 5F 5E 5B C3 }
	condition:
		$1
}

rule function_253_0 {
	meta:
		name = "TObject.FieldAddress"
		size = 80
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A 50 8B 00 8B 70 C8 85 F6 74 14 66 8B 3E 83 C6 06 8A 4E 06 38 D9 74 18 8D 74 0E 07 4F 75 F2 8B 40 DC 85 C0 75 DC 5A EB 1B 8A 1A 8A 4E 06 EB E8 8A 5C 0E 06 32 1C 0A 80 E3 DF 75 ED 49 75 F1 8B 06 5A 01 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "@ClassCreate"
		size = 77
		refs = "001b @ClassCreate 002a @HandleAnyException 0043 @ClassDestroy 0048 @RaiseAgain"
	strings:
		$1 = { 52 51 53 84 D2 7C 03 FF 50 F4 31 D2 8D 4C 24 10 64 8B 1A 89 19 89 69 08 C7 41 04 ?? ?? ?? ?? 89 41 0C 64 89 0A 5B 59 5A C3 E9 ?? ?? ?? ?? 8B 44 24 2C 8B 40 0C 85 C0 74 0E 8B 08 B2 81 50 FF 51 FC 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "@ClassDestroy"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 F8 C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "@AfterConstruction"
		size = 8
	strings:
		$1 = { 50 8B 10 FF 52 E4 58 C3 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "@BeforeDestruction"
		size = 15
	strings:
		$1 = { 84 D2 7F 01 C3 50 52 8B 10 FF 52 E8 5A 58 C3 }
	condition:
		$1
}

rule function_258_0 {
	meta:
		name = "NotifyReRaise"
		size = 26
		refs = "0002 DebugHook 0015 RaiseException"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 10 6A 00 6A 00 6A 00 68 DF FA ED 0E E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_259_0 {
	meta:
		name = "NotifyNonDelphiException"
		size = 32
		refs = "0002 DebugHook 0017 RaiseException"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 16 50 50 52 54 6A 02 6A 00 68 E4 FA ED 0E E8 ?? ?? ?? ?? 83 C4 08 58 C3 }
	condition:
		$1
}

rule function_260_0 {
	meta:
		name = "NotifyExcept"
		size = 20
		refs = "000b RaiseException"
	strings:
		$1 = { 54 6A 01 6A 00 68 E0 FA ED 0E E8 ?? ?? ?? ?? 83 C4 04 58 C3 }
	condition:
		$1
}

rule function_261_0 {
	meta:
		name = "NotifyOnExcept"
		size = 19
		refs = "0002 DebugHook 000e NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 09 50 FF 73 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_262_0 {
	meta:
		name = "NotifyAnyExcept"
		size = 17
		refs = "0002 DebugHook 000c NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 07 50 53 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_263_0 {
	meta:
		name = "CheckJmp"
		size = 30
	strings:
		$1 = { 85 C9 74 19 8B 41 01 80 39 E9 74 0C 80 39 EB 75 0C 0F BE C0 41 41 EB 03 83 C1 05 01 C1 C3 }
	condition:
		$1
}

rule function_264_0 {
	meta:
		name = "NotifyExceptFinally"
		size = 38
		refs = "0002 DebugHook 000d CheckJmp 001d RaiseException"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 1C 50 52 51 E8 ?? ?? ?? ?? 51 54 6A 01 6A 00 68 E1 FA ED 0E E8 ?? ?? ?? ?? 59 59 5A 58 C3 }
	condition:
		$1
}

rule function_265_0 {
	meta:
		name = "NotifyTerminate"
		size = 27
		refs = "0002 DebugHook 0015 RaiseException"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 11 52 54 6A 01 6A 00 68 E2 FA ED 0E E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_266_0 {
	meta:
		name = "NotifyUnhandled"
		size = 29
		refs = "0004 DebugHook 0016 RaiseException"
	strings:
		$1 = { 50 52 80 3D ?? ?? ?? ?? 01 76 0F 54 6A 02 6A 00 68 E3 FA ED 0E E8 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_267_0 {
	meta:
		name = "@HandleAnyException"
		size = 297
		refs = "0021 @FpuInit 0027 ExceptObjProc 004e NotifyNonDelphiException 0054 JITEnable 005d DebugHook 006b UnhandledExceptionFilter 00cd @HandleAnyException 00d3 RtlUnwind 00dc @GetTls 00e2 RaiseListPtr 00fd NotifyAnyExcept 0104 @HandleFinally 011f TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 12 01 00 00 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 6E FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 F0 00 00 00 FF D2 85 C0 0F 84 E6 00 00 00 8B 54 24 0C 8B 4C 24 04 81 39 CE FA EF 0E 74 37 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 29 80 3D ?? ?? ?? ?? 00 77 20 8D 4C 24 04 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 AA 00 00 00 89 C2 8B 44 24 04 8B 48 0C EB 30 89 C2 8B 44 24 04 8B 48 0C 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 08 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 6F 83 48 04 02 53 31 DB 56 57 55 64 8B 1B 53 50 52 51 8B 54 24 28 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 8B 5F 04 C7 47 04 ?? ?? ?? ?? 83 C3 05 E8 ?? ?? ?? ?? FF E3 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_268_0 {
	meta:
		name = "@HandleOnException"
		size = 389
		refs = "001b @FpuInit 0021 ExceptClsProc 007b @AStrCmp 00ad ExceptObjProc 00b6 NotifyNonDelphiException 00bc JITEnable 00c5 DebugHook 00d3 UnhandledExceptionFilter 0129 @HandleOnException 012f RtlUnwind 0139 @GetTls 013f RaiseListPtr 0158 NotifyOnExcept 0160 @HandleFinally 017b TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 6E 01 00 00 81 38 DE FA ED 0E 74 1F FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 52 01 00 00 FF D2 85 C0 75 0A E9 47 01 00 00 8B 40 18 8B 00 8B 54 24 08 53 56 57 55 8B 4A 04 8B 59 05 8D 71 09 89 C5 8B 06 85 C0 74 43 89 EF EB 02 8B 3F 8B 00 39 F8 74 37 8B 48 D8 3B 4F D8 75 17 8B 40 D4 8B 57 D4 31 C9 8A 08 3A 0A 75 09 40 42 E8 ?? ?? ?? ?? 74 18 8B 7F DC 8B 06 85 FF 75 D0 83 C6 08 4B 75 C0 5D 5F 5E 5B E9 E6 00 00 00 8B 44 24 14 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 41 FF 15 ?? ?? ?? ?? 8B 54 24 1C E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 4C 24 04 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 9E 00 00 00 89 C2 8B 44 24 14 8B 48 0C EB 27 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 08 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 6C 31 DB 64 8B 1B 53 50 52 51 8B 54 24 28 83 48 04 02 56 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 5B 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 C7 47 04 ?? ?? ?? ?? 8B 44 24 08 E8 ?? ?? ?? ?? FF 63 04 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_269_0 {
	meta:
		name = "@HandleFinally"
		size = 54
		refs = "0017 @HandleFinally 0026 NotifyExceptFinally"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 F7 40 04 06 00 00 00 74 1F 8B 4A 04 C7 42 04 ?? ?? ?? ?? 53 56 57 55 8B 6A 08 83 C1 05 E8 ?? ?? ?? ?? FF D1 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_270_0 {
	meta:
		name = "@HandleAutoException"
		size = 189
		refs = "0019 @FpuInit 0021 JITEnable 002a DebugHook 0037 UnhandledExceptionFilter 0067 @HandleAutoException 006d RtlUnwind 00a1 TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 A6 00 00 00 81 38 DE FA ED 0E FC E8 ?? ?? ?? ?? 74 27 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 77 8B 44 24 04 EB 12 80 3D ?? ?? ?? ?? 01 76 09 80 3D ?? ?? ?? ?? 00 76 D9 83 48 04 02 56 57 55 8B 54 24 14 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 5D 5F 5E 8B 44 24 04 BB FF FF 00 80 81 38 DE FA ED 0E 75 20 8B 50 18 8B 48 14 8B 44 24 08 8B 40 0C 8B 18 FF 53 E0 89 C3 8B 44 24 04 8B 40 18 E8 ?? ?? ?? ?? 31 C0 8B 64 24 08 59 64 89 08 5A 5D 8D 52 05 59 FF E2 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_271_0 {
	meta:
		name = "@RaiseExcept"
		size = 25
		refs = "0014 RaiseException"
	strings:
		$1 = { 5A 54 55 57 56 53 50 52 54 6A 07 6A 01 68 DE FA ED 0E 52 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "@RaiseAgain"
		size = 81
		refs = "0007 @RaiseAgain 000c @GetTls 0012 RaiseListPtr 0031 TObject.Free 0036 NotifyReRaise"
	strings:
		$1 = { 8B 44 24 30 C7 40 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 0C 83 60 04 FD 81 38 DE FA ED 0E 74 0D 8B 42 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 C0 83 C4 14 64 8B 10 59 8B 12 89 11 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "@DoneExcept"
		size = 48
		refs = "0001 @GetTls 0007 RaiseListPtr 0017 TObject.Free 0029 NotifyTerminate"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 08 E8 ?? ?? ?? ?? 5A 8B 64 24 2C 31 C0 59 64 89 08 58 5D E8 ?? ?? ?? ?? FF E2 C3 }
	condition:
		$1
}

rule function_274_0 {
	meta:
		name = "@TryFinallyExit"
		size = 22
	strings:
		$1 = { 31 D2 8B 4C 24 08 8B 44 24 04 83 C1 05 64 89 02 FF D1 C2 0C 00 C3 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "RunErrorAt"
		size = 9
		refs = "0004 @RunError"
	strings:
		$1 = { 89 14 24 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "MapToRunError"
		size = 160
		refs = "0098 RunErrorAt"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 3D 92 00 00 C0 7F 2C 74 5C 3D 8E 00 00 C0 7F 15 74 57 2D 05 00 00 C0 74 5C 2D 87 00 00 00 74 3D 48 74 4E EB 60 05 71 FF FF 3F 83 E8 02 72 36 74 30 EB 52 3D 96 00 00 C0 7F 11 74 3D 2D 93 00 00 C0 74 2E 48 74 13 48 74 24 EB 3A 2D FD 00 00 C0 74 2F 83 E8 3D 74 26 EB 2C B0 C8 EB 2A B0 C9 EB 26 B0 CD EB 22 B0 CF EB 1E B0 C8 EB 1A B0 D7 EB 16 B0 CE EB 12 B0 D8 EB 0E B0 DA EB 0A B0 D9 EB 06 B0 CA EB 02 B0 FF 25 FF 00 00 00 8B 52 0C E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "@ExceptionHandler"
		size = 156
		refs = "0013 DebugHook 0020 UnhandledExceptionFilter 002f @FpuInit 003b @ExceptionHandler 0041 RtlUnwind 0059 ExceptObjProc 0061 MapToRunError 0075 NotifyUnhandled 007b ExceptProc 0095 @RunError"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 88 00 00 00 80 3D ?? ?? ?? ?? 00 77 0F 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 70 8B 44 24 04 FC E8 ?? ?? ?? ?? 8B 54 24 08 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 5C 24 04 81 3B DE FA ED 0E 8B 53 14 8B 43 18 74 1D 8B 15 ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 89 D8 FF D2 85 C0 0F 84 ?? ?? ?? ?? 8B 53 0C E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 02 FF D1 8B 4C 24 04 B8 D9 00 00 00 8B 51 14 89 14 24 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "SetExceptionHandler"
		size = 30
		refs = "0010 @ExceptionHandler 0019 InitContext"
	strings:
		$1 = { 31 D2 8D 45 F4 64 8B 0A 64 89 02 89 08 C7 40 04 ?? ?? ?? ?? 89 68 08 89 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "UnsetExceptionHandler"
		size = 37
		refs = "0004 InitContext"
	strings:
		$1 = { 31 D2 8B 05 ?? ?? ?? ?? 64 8B 0A 39 C8 75 08 8B 00 64 89 02 C3 8B 09 83 F9 FF 74 08 39 01 75 F5 8B 00 89 01 C3 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "FInitUnits"
		size = 95
		refs = "0007 InitContext 001c FInitUnits 0047 @HandleAnyException 0051 @RaiseAgain 0056 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 BF ?? ?? ?? ?? 8B 47 08 85 C0 74 48 8B 5F 0C 8B 70 04 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 85 DB 7E 12 4B 89 5F 0C 8B 44 DE 04 85 C0 74 02 FF D0 85 DB 7F EE 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "InitUnits"
		size = 95
		refs = "0007 InitContext 001a InitUnits 0047 @HandleAnyException 004c FInitUnits 0051 @RaiseAgain 0056 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 4B 8B 30 33 DB 8B 78 04 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 3B F3 7E 14 8B 04 DF 43 89 1D ?? ?? ?? ?? 85 C0 74 02 FF D0 3B F3 7F EC 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "@PackageLoad"
		size = 111
		refs = "0009 InitContext 0036 @PackageLoad 0041 InitUnits 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "@PackageUnload"
		size = 111
		refs = "0009 InitContext 0036 @PackageUnload 0041 FInitUnits 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "@StartExe"
		size = 47
		refs = "0002 InitContext 0019 MainInstance 001e SetExceptionHandler 0024 IsLibrary 002a InitUnits"
	strings:
		$1 = { 89 05 ?? ?? ?? ?? 31 C0 89 05 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8B 42 04 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "@StartLib"
		size = 162
		refs = "0004 InitContext 0050 SetExceptionHandler 007b MainInstance 0084 IsLibrary 008b Default8087CW 0095 @Halt0 009a InitUnits"
	strings:
		$1 = { 51 56 57 BE ?? ?? ?? ?? 8D 7D C4 B9 0B 00 00 00 F3 A5 8F 05 ?? ?? ?? ?? 8F 05 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 4D C4 89 0D ?? ?? ?? ?? 31 C9 83 7D 0C 00 75 02 8B 08 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 40 A2 ?? ?? ?? ?? 48 59 8B 11 89 15 ?? ?? ?? ?? 74 03 FF 14 81 8B 54 24 04 85 D2 74 05 8B 45 0C FF D2 83 3D ?? ?? ?? ?? 00 75 0D C6 05 ?? ?? ?? ?? 01 D9 3D ?? ?? ?? ?? 8B 45 0C 48 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "@InitResStrings"
		size = 26
		refs = "000d LoadResString"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 E8 ?? ?? ?? ?? 83 C6 08 4B 75 F0 5E 5B C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "@InitResStringImports"
		size = 28
		refs = "000f LoadResString"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 8B 00 E8 ?? ?? ?? ?? 83 C6 08 4B 75 EE 5E 5B C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "@InitImports"
		size = 30
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 8B 4E 08 8B 00 01 C8 89 02 83 C6 0C 4B 75 EC 5E 5B C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "@InitWideStrings"
		size = 26
		refs = "000d @WStrAsg"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 56 04 8B 06 E8 ?? ?? ?? ?? 83 C6 08 4B 75 F0 5E 5B C3 }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "MakeErrorMessage"
		size = 77
		refs = "0003 ExitCode 0008 runErrMsg 0021 ErrorAddr 0026 FindHInstance 003f dig"
	strings:
		$1 = { 53 8B 05 ?? ?? ?? ?? BB ?? ?? ?? ?? B9 0A 00 00 00 31 D2 F7 F1 80 C2 30 88 13 4B 85 C0 75 F2 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 92 29 D0 BB ?? ?? ?? ?? 89 C2 83 E2 0F 8A 92 ?? ?? ?? ?? 88 13 4B C1 E8 04 75 ED 5B C3 }
	condition:
		$1
}

rule function_291_0 {
	meta:
		name = "ExitDll"
		size = 52
		refs = "0001 InitContext 0026 ExitCode"
	strings:
		$1 = { BF ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? FF 77 1C FF 77 20 8B 37 B9 0B 00 00 00 F3 A5 5F 5E 31 C0 87 05 ?? ?? ?? ?? F7 D8 19 C0 40 C9 C2 0C 00 C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "@Halt0"
		size = 287
		refs = "0005 InitContext 000a ExitCode 000f ExitProc 0031 ErrorAddr 0039 MakeErrorMessage 003f IsConsole 0047 runErrMsg 004c Output 0051 @Write0CString 0056 @WriteLn 005e NoErrMsg 0068 errCaption 0074 MessageBox 0090 FInitUnits 00a7 UnregisterModule 00b8 FreeLibrary 00bd UnsetExceptionHandler 00d1 ExitDll 00de ExitProcess"
	strings:
		$1 = { 53 56 57 55 BB ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 80 7B 24 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D ?? ?? ?? ?? 00 74 47 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 16 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 1C 80 3D ?? ?? ?? ?? 00 75 13 6A 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 7B 24 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C E8 ?? ?? ?? ?? 80 7B 24 01 76 05 83 3E 00 74 1D 8B 43 10 85 C0 74 16 E8 ?? ?? ?? ?? 8B 43 10 8B 50 10 3B 50 04 74 06 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7B 24 01 75 03 FF 53 28 80 7B 24 00 74 05 E8 ?? ?? ?? ?? 83 3B 00 75 08 8B 06 50 E8 ?? ?? ?? ?? 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E EB 8C 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 39 20 42 6F 72 6C 61 6E 64 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "@Halt"
		size = 12
		refs = "0002 ExitCode 0007 @Halt0"
	strings:
		$1 = { 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_294_0 {
	meta:
		name = "@Run0Error"
		size = 8
		refs = "0003 @RunError"
	strings:
		$1 = { 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "@RunError"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 8F 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "@Assert"
		size = 27
		refs = "0002 AssertErrorProc 0016 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 0A FF 34 24 FF 15 ?? ?? ?? ?? C3 B0 15 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "ThreadWrapper"
		size = 54
		refs = "0004 @FpuInit 000c @ExceptionHandler 0022 @FreeMem"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 31 C9 55 68 ?? ?? ?? ?? 64 8B 11 52 8B 45 08 64 89 21 8B 48 04 8B 10 51 52 E8 ?? ?? ?? ?? 5A 58 FF D2 31 D2 59 64 89 0A 59 5D 5D C2 04 00 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "BeginThread"
		size = 66
		refs = "0012 @GetMem 0020 IsMultiThread 002f ThreadWrapper 0037 CreateThread"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 89 38 8B 55 10 89 50 04 C6 05 ?? ?? ?? ?? 01 8B 55 08 52 8B 55 0C 52 50 B8 ?? ?? ?? ?? 50 56 53 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "@LStrClr"
		size = 35
		refs = "001d @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 1C C7 00 00 00 00 00 8B 4A F8 49 7C 10 F0 FF 4A F8 75 0A 50 8D 42 F8 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "@LStrArrayClr"
		size = 47
		refs = "0022 @FreeMem"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 13 85 D2 74 1A C7 03 00 00 00 00 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? 83 C3 04 4E 75 DA 5E 5B C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "@LStrAsg"
		size = 67
		refs = "0010 @NewAnsiString 001c Move 003e @FreeMem"
	strings:
		$1 = { 85 D2 74 24 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 48 FC E8 ?? ?? ?? ?? 5A 58 EB 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "@LStrLAsg"
		size = 41
		refs = "0024 @FreeMem"
	strings:
		$1 = { 85 D2 74 0A 8B 4A F8 41 7E 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "@NewAnsiString"
		size = 35
		refs = "0009 @GetMem"
	strings:
		$1 = { 85 C0 7E 1C 50 83 C0 09 E8 ?? ?? ?? ?? 83 C0 08 5A 89 50 FC C7 40 F8 01 00 00 00 C6 04 10 00 C3 31 C0 C3 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "@LStrFromPCharLen"
		size = 46
		refs = "000c @NewAnsiString 001d Move 0024 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 F8 E8 ?? ?? ?? ?? 89 F9 89 C7 85 F6 74 09 89 C2 89 F0 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "@LStrFromPWCharLen"
		size = 143
		refs = "0017 @LStrClr 003a WideCharToMultiByte 004b @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D9 8B EA 8B F8 85 DB 7F 09 8B C7 E8 ?? ?? ?? ?? EB 67 81 FB 00 04 00 00 7D 2C 6A 00 6A 00 68 00 08 00 00 8D 44 24 0C 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 0D 8B D4 8B C7 8B CE E8 ?? ?? ?? ?? EB 33 6A 00 6A 00 6A 00 6A 00 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 8B C7 8B CE 33 D2 E8 ?? ?? ?? ?? 6A 00 6A 00 56 8B 07 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "@LStrFromChar"
		size = 15
		refs = "0009 @LStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "@LStrFromWChar"
		size = 15
		refs = "0009 @LStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "@WStrFromChar"
		size = 15
		refs = "0009 @WStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "@WStrFromWChar"
		size = 15
		refs = "0009 @WStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "@LStrFromPChar"
		size = 45
		refs = "0028 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "@WStrFromPChar"
		size = 45
		refs = "0028 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "@LStrFromPWChar"
		size = 57
		refs = "0034 @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "@WStrFromPWChar"
		size = 57
		refs = "0034 @WStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "@LStrFromString"
		size = 11
		refs = "0006 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "@WStrFromString"
		size = 11
		refs = "0006 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "@LStrFromArray"
		size = 24
		refs = "0013 @LStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "@WStrFromArray"
		size = 24
		refs = "0013 @WStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "@LStrFromWArray"
		size = 25
		refs = "0014 @LStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 66 F2 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "@WStrFromWArray"
		size = 25
		refs = "0014 @WStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 66 F2 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "@LStrFromWStr"
		size = 17
		refs = "000c @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 05 8B 4A FC D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "@LStrToString"
		size = 34
		refs = "0017 Move"
	strings:
		$1 = { 53 85 D2 74 18 8B 5A FC 85 DB 74 11 39 D9 7C 02 89 D9 88 08 40 92 E8 ?? ?? ?? ?? 5B C3 C6 00 00 5B C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "@DynArrayLength"
		size = 8
		altNames = "@LStrLen DynArraySize"
	strings:
		$1 = { 85 C0 74 03 8B 40 FC C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "@LStrCat"
		size = 68
		refs = "000a @LStrAsg 0022 @LStrSetLength 0030 Move"
	strings:
		$1 = { 85 D2 74 3F 8B 08 85 C9 0F 84 ?? ?? ?? ?? 53 56 57 89 C3 89 D6 8B 79 FC 8B 56 FC 01 FA 39 CE 74 17 E8 ?? ?? ?? ?? 89 F0 8B 4E FC 8B 13 01 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 E8 ?? ?? ?? ?? 8B 03 89 F9 EB E8 C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "@LStrCat3"
		size = 116
		refs = "0008 @LStrAsg 001e @LStrCat 0031 @NewAnsiString 003f Move"
	strings:
		$1 = { 85 D2 74 61 85 C9 0F 84 ?? ?? ?? ?? 3B 10 74 5C 3B 08 74 0E 50 51 E8 ?? ?? ?? ?? 5A 58 E9 ?? ?? ?? ?? 53 56 57 89 D3 89 CE 50 8B 43 FC 03 46 FC E8 ?? ?? ?? ?? 89 C7 89 C2 89 D8 8B 4B FC E8 ?? ?? ?? ?? 89 FA 89 F0 8B 4E FC 03 53 FC E8 ?? ?? ?? ?? 58 89 FA 85 FF 74 03 FF 4F F8 E8 ?? ?? ?? ?? 5F 5E 5B C3 89 CA E9 ?? ?? ?? ?? 89 CA E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "@LStrCatN"
		size = 77
		refs = "0017 @NewAnsiString 002e Move 003f @LStrAsg"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 85 D2 74 03 FF 4A F8 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "@LStrCmp"
		size = 162
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 0F 84 8F 00 00 00 85 F6 74 68 85 FF 74 6B 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 58 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 4B 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 22 8B 0E 8B 1F 38 D9 75 41 4A 74 17 38 FD 75 3A 4A 74 10 81 E3 00 00 FF 00 81 E1 00 00 FF 00 39 D9 75 27 01 C0 EB 23 8B 57 FC 29 D0 EB 1C 8B 46 FC 29 D0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "@LStrAddRef"
		size = 15
	strings:
		$1 = { 85 C0 74 0A 8B 50 F8 42 7E 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "@LStrToPChar"
		size = 12
		refs = "0007 @LStrToPChar"
	strings:
		$1 = { 85 C0 74 02 C3 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "UniqueString"
		size = 53
		refs = "0013 @NewAnsiString 002b Move"
	strings:
		$1 = { 8B 10 85 D2 74 2C 8B 4A F8 49 74 26 53 89 C3 8B 42 FC E8 ?? ?? ?? ?? 89 C2 8B 03 89 13 8B 48 F8 49 7C 04 F0 FF 48 F8 8B 48 FC E8 ?? ?? ?? ?? 8B 13 5B 89 D0 C3 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "@LStrCopy"
		size = 64
		refs = "0024 @LStrFromPCharLen 0037 @LStrClr"
	strings:
		$1 = { 53 85 C0 74 2D 8B 58 FC 85 DB 74 26 4A 7C 1B 39 DA 7D 1F 29 D3 85 C9 7C 19 39 D9 7F 11 01 C2 8B 44 24 08 E8 ?? ?? ?? ?? EB 11 31 D2 EB E5 89 D9 EB EB 8B 44 24 08 E8 ?? ?? ?? ?? 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "@LStrDelete"
		size = 72
		refs = "000a UniqueString 0032 Move 0040 @LStrSetLength"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF E8 ?? ?? ?? ?? 8B 13 85 D2 74 30 8B 4A FC 4E 7C 2A 39 CE 7D 26 85 FF 7E 22 29 F1 39 CF 7E 02 89 CF 29 F9 01 F2 8D 04 3A E8 ?? ?? ?? ?? 8B 13 89 D8 8B 52 FC 29 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "@LStrInsert"
		size = 91
		refs = "002b @LStrSetLength 0045 Move"
	strings:
		$1 = { 85 C0 74 56 53 56 57 55 89 C3 89 D6 89 CF 8B 12 52 85 D2 74 03 8B 52 FC 4F 7D 02 31 FF 39 D7 7E 02 89 D7 8B 6B FC 89 F0 01 EA E8 ?? ?? ?? ?? 58 39 D8 75 02 8B 1E 8B 06 8D 14 2F 8B 48 FC 29 D1 01 C2 01 F8 E8 ?? ?? ?? ?? 89 D8 8B 16 89 E9 01 FA E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "@LStrPos"
		size = 69
	strings:
		$1 = { 85 C0 74 40 85 D2 74 31 53 56 57 89 C6 89 D7 8B 4F FC 57 8B 56 FC 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 0C 89 D9 EB EC 5A 31 C0 EB 08 31 C0 C3 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "@LStrSetLength"
		size = 98
		refs = "0023 @ReallocMem 0039 @NewAnsiString 0051 Move 0058 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 31 FF 85 D2 74 48 8B 03 85 C0 74 23 83 78 F8 01 75 1D 83 E8 08 83 C2 09 50 89 E0 E8 ?? ?? ?? ?? 58 83 C0 08 89 03 89 70 FC C6 04 30 00 EB 28 89 D0 E8 ?? ?? ?? ?? 89 C7 8B 03 85 C0 74 10 89 FA 8B 48 FC 39 F1 7C 02 89 F1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_329_0 {
	meta:
		name = "@LStrOfChar"
		size = 42
		refs = "000c @LStrClr 0017 @NewAnsiString 0022 @FillChar"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 C8 E8 ?? ?? ?? ?? 85 F6 7E 12 89 F0 E8 ?? ?? ?? ?? 89 07 89 F2 88 D9 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_331_0 {
	meta:
		name = "@WriteLString"
		size = 32
		refs = "0012 @WriteSpaces 001b @WriteBytes"
	strings:
		$1 = { 53 89 D3 89 CA 31 C9 85 DB 74 05 8B 4B FC 29 CA 51 E8 ?? ?? ?? ?? 59 89 DA 5B E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "@ReadLString"
		size = 106
		refs = "0009 @LStrClr 001d @ReadString 0026 @LStrFromString 004f @LStrCat"
	strings:
		$1 = { 53 56 89 C3 89 D6 89 D0 E8 ?? ?? ?? ?? 81 EC 00 01 00 00 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 F0 89 E2 E8 ?? ?? ?? ?? 80 3C 24 FF 75 31 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 E2 6A 00 89 E0 E8 ?? ?? ?? ?? 89 F0 8B 14 24 E8 ?? ?? ?? ?? 89 E0 E8 ?? ?? ?? ?? 58 80 3C 24 FF 74 CF 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_333_0 {
	meta:
		name = "WStrError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "WStrSet"
		size = 15
		refs = "000a SysFreeString"
	strings:
		$1 = { 8B 08 89 10 85 C9 74 06 51 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_335_0 {
	meta:
		name = "@WStrClr"
		size = 21
		refs = "000f SysFreeString"
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "@WStrArrayClr"
		size = 33
		refs = "0014 SysFreeString"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 03 85 C0 74 0C C7 03 00 00 00 00 50 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E8 5E 5B C3 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "@WStrAsg"
		size = 36
		refs = "0004 @WStrClr 0017 SysReAllocStringLen 001f WStrError"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 8B 4A FC D1 E9 0F 84 ?? ?? ?? ?? 51 52 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "@WStrFromPCharLen"
		size = 131
		refs = "0017 @WStrClr 0036 MultiByteToWideChar 0047 @WStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D9 8B EA 8B F8 85 DB 7F 09 8B C7 E8 ?? ?? ?? ?? EB 5B 81 FB 00 04 00 00 7D 28 68 00 04 00 00 8D 44 24 04 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 0D 8B D4 8B C7 8B CE E8 ?? ?? ?? ?? EB 2B 6A 00 6A 00 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 8B C7 8B CE 33 D2 E8 ?? ?? ?? ?? 56 8B 07 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "@WStrFromPWCharLen"
		size = 35
		refs = "0004 @WStrClr 000c SysAllocStringLen 0014 WStrError 001e SysFreeString"
	strings:
		$1 = { 85 C9 0F 84 ?? ?? ?? ?? 50 51 52 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 5A FF 32 89 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_347_0 {
	meta:
		name = "@WStrFromLStr"
		size = 15
		refs = "000a @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 03 8B 4A FC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "@WStrToString"
		size = 100
		refs = "0012 @WStrLen 003f WideCharToMultiByte 0056 Move"
	strings:
		$1 = { 53 56 57 81 C4 00 FE FF FF 8B F9 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 3D FF 00 00 00 7C 05 B8 FF 00 00 00 85 C0 75 04 33 C0 EB 1F 6A 00 6A 00 68 00 02 00 00 8D 54 24 0C 52 50 56 6A 00 6A 00 E8 ?? ?? ?? ?? 3B F8 7D 02 8B C7 88 03 85 C0 7E 0B 8D 53 01 8B CC 91 E8 ?? ?? ?? ?? 81 C4 00 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "@WStrToPWChar"
		size = 14
		refs = "0009 @WStrToPWChar"
	strings:
		$1 = { 85 C0 74 04 C3 90 00 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_350_0 {
	meta:
		name = "@WStrLen"
		size = 10
	strings:
		$1 = { 85 C0 74 05 8B 40 FC D1 E8 C3 }
	condition:
		$1
}

rule function_351_0 {
	meta:
		name = "@WStrCat"
		size = 95
		refs = "000d @WStrLen 0027 @NewWideString 003d Move 0055 WStrSet"
	strings:
		$1 = { 53 56 57 55 51 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 85 DB 74 42 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B F0 8D 04 33 E8 ?? ?? ?? ?? 8B F8 85 F6 7E 10 8B CE 03 C9 8B D7 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B CB 03 C9 8D 14 77 8B C5 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "@WStrCat3"
		size = 100
		refs = "0013 @WStrLen 0030 @NewWideString 003f Move 0059 WStrSet"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 8B 44 24 04 E8 ?? ?? ?? ?? 8B F0 85 DB 75 04 85 F6 74 31 8D 04 1E E8 ?? ?? ?? ?? 8B F8 8B CB 03 C9 8B D7 8B C5 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 14 5F 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_353_0 {
	meta:
		name = "@WStrCatN"
		size = 72
		refs = "0019 @NewWideString 0030 Move 003a WStrSet"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 D1 E8 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "@WStrCmp"
		size = 129
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 74 72 85 F6 74 51 85 FF 74 54 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 41 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 34 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 02 74 0B 66 8B 0E 66 8B 1F 66 39 D9 75 21 01 C0 EB 1D 8B 57 FC 29 D0 EB 16 8B 46 FC 29 D0 EB 0F 5A 66 39 D9 75 09 C1 E9 10 C1 EB 10 66 39 D9 5F 5E 5B C3 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "@NewWideString"
		size = 21
		refs = "0008 SysAllocStringLen 0010 WStrError"
	strings:
		$1 = { 85 C0 74 10 50 6A 00 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "@WStrCopy"
		size = 73
		refs = "000f @WStrLen 003e @WStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 83 FB 01 7D 04 33 DB EB 07 4B 3B C3 7D 02 8B D8 85 FF 7D 04 33 C0 EB 08 2B C3 3B F8 7D 02 8B C7 8B D3 03 D2 03 D6 8B 4D 08 91 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_357_0 {
	meta:
		name = "@WStrDelete"
		size = 141
		refs = "000f @WStrLen 0048 @NewWideString 005e Move 0083 WStrSet"
	strings:
		$1 = { 53 56 57 55 51 8B F9 8B DA 8B E8 8B 45 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 6E 83 FB 01 7C 69 3B F3 7C 65 85 FF 7E 61 4B 8B C6 2B C3 2B C7 8B F8 85 FF 7D 02 33 FF 85 DB 75 0B 85 FF 75 07 33 C0 89 04 24 EB 39 8D 04 1F E8 ?? ?? ?? ?? 89 04 24 85 DB 7E 0F 8B CB 03 C9 8B 14 24 8B 45 00 E8 ?? ?? ?? ?? 85 FF 7E 17 2B F7 8B 45 00 8D 04 70 8B CF 03 C9 8B 14 24 8D 14 5A E8 ?? ?? ?? ?? 8B C5 8B 14 24 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_358_0 {
	meta:
		name = "@WStrInsert"
		size = 154
		refs = "0014 @WStrLen 003f @NewWideString 0056 Move 008f WStrSet"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B D9 89 54 24 04 89 04 24 8B 04 24 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 75 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B F8 83 FB 01 7D 04 33 DB EB 07 4B 3B FB 7D 02 8B DF 8D 04 3E E8 ?? ?? ?? ?? 8B E8 85 DB 7E 11 8B CB 03 C9 8B D5 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 54 5D 00 8B 04 24 E8 ?? ?? ?? ?? 3B FB 7E 1A 03 F3 8D 54 75 00 2B FB 8B CF 03 C9 8B 44 24 04 8B 00 8D 04 58 E8 ?? ?? ?? ?? 8B 44 24 04 8B D5 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "@WStrPos"
		size = 80
	strings:
		$1 = { 85 C0 74 4B 85 D2 74 3A 53 56 57 89 C6 89 D7 8B 4F FC D1 E9 57 8B 56 FC D1 EA 4A 78 20 66 8B 06 83 C6 02 29 D1 7E 16 66 F2 AF 75 11 89 CB 56 57 89 D1 66 F3 A7 5F 5E 74 0C 89 D9 EB EA 5A 31 C0 EB 0A 31 C0 C3 5A 89 F8 29 D0 D1 E8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_360_0 {
	meta:
		name = "@WStrSetLength"
		size = 65
		refs = "0010 @NewWideString 0019 @WStrLen 0030 Move 0039 WStrSet"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 85 F6 7E 27 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 07 E8 ?? ?? ?? ?? 85 C0 7E 13 3B F0 7D 02 8B C6 8B C8 03 C9 8B D3 8B 07 E8 ?? ?? ?? ?? 8B C7 8B D3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "@WStrOfWChar"
		size = 39
		refs = "0010 @WStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C7 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 07 85 DB 7E 09 4B 66 89 34 58 85 DB 7F F7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "@WStrAddRef"
		size = 31
		refs = "000f SysAllocStringLen 0018 WStrError"
	strings:
		$1 = { 8B 10 85 D2 74 18 50 8B 4A FC D1 E9 51 52 E8 ?? ?? ?? ?? 5A 85 C0 0F 84 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "@InitializeRecord"
		size = 42
		refs = "001c @Initialize"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "@AddRefRecord"
		size = 42
		refs = "001c @AddRef"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "@InitializeArray"
		size = 146
		refs = "003b Error 0070 @InitializeArray 0086 @InitializeRecord"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 31 C9 80 F8 0A 74 28 80 F8 0B 74 23 80 F8 0C 74 28 80 F8 0D 74 36 80 F8 0E 74 4F 80 F8 0F 74 0F 80 F8 11 74 0A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 89 0B 83 C3 04 4F 7F F8 EB 45 89 0B 89 4B 04 89 4B 08 89 4B 0C 83 C3 10 4F 7F EF EB 32 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 14 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "@Initialize"
		size = 11
		refs = "0006 @InitializeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "@AddRef"
		size = 11
		refs = "0006 @AddRefArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "@Finalize"
		size = 11
		refs = "0006 @FinalizeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "@VarSub"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "@FinalizeRecord"
		size = 44
		refs = "001c @Finalize"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 89 D8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "@FinalizeArray"
		size = 231
		refs = "004c Error 0058 @LStrClr 0064 @LStrArrayClr 0072 @WStrClr 007b @WStrArrayClr 0087 @VarClr 00a4 @FinalizeArray 00ba @FinalizeRecord 00ca @IntfClear 00db @DynArrayClear"
	strings:
		$1 = { 83 F9 00 0F 84 DD 00 00 00 50 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 80 F8 0A 74 31 80 F8 0B 74 46 80 F8 0C 74 58 80 F8 0D 74 62 80 F8 0E 74 7B 80 F8 0F 0F 84 88 00 00 00 80 F8 11 0F 84 8E 00 00 00 5F 5E 5B 58 B0 02 E9 ?? ?? ?? ?? 83 F9 01 89 D8 7F 0A E8 ?? ?? ?? ?? E9 81 00 00 00 89 CA E8 ?? ?? ?? ?? EB 78 83 F9 01 89 D8 7F 07 E8 ?? ?? ?? ?? EB 6A 89 CA E8 ?? ?? ?? ?? EB 61 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 52 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 34 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 1E 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 0F 89 D8 89 F2 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F1 5F 5E 5B 58 C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "@AddRefArray"
		size = 190
		refs = "0039 Error 0043 @LStrAddRef 0052 @WStrAddRef 0061 @VarAddRef 007e @AddRefArray 0094 @AddRefRecord 00a4 @IntfAddRef 00b3 @DynArrayAddRef"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 80 F8 0A 74 28 80 F8 0B 74 32 80 F8 0C 74 3C 80 F8 0D 74 46 80 F8 0E 74 5F 80 F8 0F 74 70 80 F8 11 74 7A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 6E 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 50 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 32 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 1C 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 0D 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "@CopyRecord"
		size = 282
		refs = "0028 Move 0067 Error 0071 @LStrAsg 0082 @WStrAsg 0093 @VarCopy 00b7 @CopyArray 00d0 @CopyRecord 00dd @IntfCopy 00f0 @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 31 C0 8A 41 01 8D 7C 01 0A 8B 6F FC 31 C0 8B 4F F8 51 8B 4F 04 29 C1 7E 0B 89 C2 01 F0 01 DA E8 ?? ?? ?? ?? 8B 47 04 8B 17 8B 12 8A 0A 80 F9 0A 74 31 80 F9 0B 74 3D 80 F9 0C 74 49 80 F9 0D 74 55 80 F9 0E 74 70 80 F9 0F 0F 84 80 00 00 00 80 F9 11 0F 84 88 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 7D 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 6C 8D 14 06 01 D8 E8 ?? ?? ?? ?? B8 10 00 00 00 EB 5B 31 C9 8A 4A 01 FF 74 0A 02 FF 74 0A 06 8B 4C 0A 0A 8B 09 8D 14 06 01 D8 E8 ?? ?? ?? ?? 58 EB 3B 31 C9 8A 4A 01 8B 4C 0A 02 51 89 D1 8D 14 06 01 D8 E8 ?? ?? ?? ?? 58 EB 22 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 11 89 D1 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 03 47 04 83 C7 08 4D 0F 85 14 FF FF FF 59 29 C1 7E 0A 8D 14 03 01 F0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "@CopyObject"
		size = 21
		refs = "000a @CopyRecord"
	strings:
		$1 = { 01 C1 FF 31 51 8B 4C 24 0C E8 ?? ?? ?? ?? 59 8F 01 C2 04 00 C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "@CopyArray"
		size = 243
		refs = "0042 Error 004b @LStrAsg 0062 @WStrAsg 0076 @VarCopy 0099 @CopyArray 00ad @CopyRecord 00c8 @IntfCopy 00de @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 89 CF 8B 6C 24 14 8A 0F 80 F9 0A 74 31 80 F9 0B 74 43 80 F9 0C 74 52 80 F9 0D 74 61 80 F9 0E 74 7D 80 F9 0F 0F 84 91 00 00 00 80 F9 11 0F 84 9C 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE E9 8E 00 00 00 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 7A 89 D8 89 F2 E8 ?? ?? ?? ?? 83 C3 10 83 C6 10 4D 75 EE EB 66 31 C9 8A 4F 01 8D 7C 0F 02 89 D8 89 F2 8B 4F 08 FF 77 04 E8 ?? ?? ?? ?? 03 1F 03 37 4D 75 EA EB 45 89 D8 89 F2 89 F9 E8 ?? ?? ?? ?? 31 C0 8A 47 01 03 5C 07 02 03 74 07 02 4D 75 E5 EB 28 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 14 89 D8 8B 16 89 F9 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EC 5D 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "@New"
		size = 19
		refs = "0002 @GetMem 000d @Initialize"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A 85 C0 74 07 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "@Dispose"
		size = 13
		refs = "0002 @Finalize 0008 @FreeMem"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "WideCharToStrVar"
		size = 20
		refs = "000f WideCharLenToStrVar"
	strings:
		$1 = { 33 C9 EB 01 41 66 83 3C 48 00 75 F8 87 D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "WideCharLenToStrVar"
		size = 137
		refs = "0017 @LStrClr 003a WideCharToMultiByte 0045 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B F1 8B DA 8B F8 85 DB 75 09 8B C6 E8 ?? ?? ?? ?? EB 61 81 FB 00 04 00 00 7D 26 6A 00 6A 00 68 00 08 00 00 8D 44 24 0C 50 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 33 6A 00 6A 00 6A 00 6A 00 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 8B E8 8B C6 8B CD 33 D2 E8 ?? ?? ?? ?? 6A 00 6A 00 55 8B 06 50 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "StringToWideChar"
		size = 49
		refs = "000f @LStrLen 0017 @LStrToPChar 0021 MultiByteToWideChar"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 4F 57 53 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? 66 C7 04 43 00 00 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "OleStrToStrVar"
		size = 35
		refs = "0010 SysStringLen 001b WideCharLenToStrVar"
	strings:
		$1 = { 53 56 6A 00 8B F2 8B D8 89 1C 24 8B 04 24 50 E8 ?? ?? ?? ?? 8B D0 8B CE 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "StringToOleStr"
		size = 131
		refs = "000f @LStrLen 0031 @LStrToPChar 003b MultiByteToWideChar 0046 SysAllocStringLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3D 00 04 00 00 7D 2B 68 00 04 00 00 8D 44 24 04 50 56 8B C3 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? 50 8D 44 24 04 50 E8 ?? ?? ?? ?? 8B F8 EB 28 6A 00 6A 00 56 53 6A 00 6A 00 E8 ?? ?? ?? ?? 8B E8 55 6A 00 E8 ?? ?? ?? ?? 8B F8 55 57 56 53 6A 00 6A 00 E8 ?? ?? ?? ?? 8B C7 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "@DispInvokeError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "VarCastError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 0F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "VarInvalidOp"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 10 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "@VarClear"
		size = 66
		refs = "0024 ClearAnyProc 0031 @LStrClr 003d VariantClear"
	strings:
		$1 = { 31 D2 66 8B 10 F7 C2 00 40 00 00 75 28 83 FA 08 72 23 81 FA 00 01 00 00 74 0E 81 FA 01 01 00 00 75 19 FF 25 ?? ?? ?? ?? 66 C7 00 00 00 83 C0 08 E9 ?? ?? ?? ?? 66 C7 00 00 00 C3 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "@VarCopy"
		size = 153
		refs = "0020 VariantClear 0028 ClearAnyProc 0032 @LStrClr 005f @VarCopy 0066 RefAnyProc 008c VariantCopyInd 0094 VarInvalidOp"
	strings:
		$1 = { 39 D0 0F 84 90 00 00 00 66 83 38 08 72 2A 50 52 66 81 38 00 01 74 17 66 81 38 01 01 74 08 50 E8 ?? ?? ?? ?? EB 10 FF 15 ?? ?? ?? ?? EB 08 83 C0 08 E8 ?? ?? ?? ?? 5A 58 66 83 3A 08 73 11 8B 0A 89 08 8B 4A 08 89 48 08 8B 4A 0C 89 48 0C C3 66 81 3A 00 01 74 14 66 81 3A 01 01 75 27 50 E8 ?? ?? ?? ?? 58 FF 25 ?? ?? ?? ?? 8B 52 08 09 D2 74 0A 8B 4A F8 41 7E 04 F0 FF 42 F8 66 C7 00 00 01 89 50 08 C3 66 C7 00 00 00 52 50 E8 ?? ?? ?? ?? 09 C0 0F 85 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "VarCopyNoInd"
		size = 143
		refs = "0020 VariantClear 0028 ClearAnyProc 0032 @LStrClr 005e VarCopyNoInd 0064 RefAnyProc 008a VariantCopy"
	strings:
		$1 = { 39 D0 0F 84 86 00 00 00 66 83 38 08 72 2A 50 52 66 81 38 00 01 74 17 66 81 38 01 01 74 08 50 E8 ?? ?? ?? ?? EB 10 FF 15 ?? ?? ?? ?? EB 08 83 C0 08 E8 ?? ?? ?? ?? 5A 58 66 83 3A 08 73 11 8B 0A 89 08 8B 4A 08 89 48 08 8B 4A 0C 89 48 0C C3 66 81 3A 00 01 75 12 66 81 3A 01 01 75 25 E8 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? 8B 52 08 09 D2 74 0A 8B 4A F8 41 7E 04 F0 FF 42 F8 66 C7 00 00 01 89 50 08 C3 66 C7 00 00 00 52 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "AnyChangeType"
		size = 106
		refs = "001f @VarAddRef 0027 AnyChangeType 0036 ChangeAnyProc 0042 VarChangeType 0057 @VarClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F2 8D 7D F0 51 B9 04 00 00 00 F3 A5 59 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 FF 15 ?? ?? ?? ?? 8D 55 F0 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "ChangeSourceAny"
		size = 21
		refs = "000b AnyChangeType"
	strings:
		$1 = { 53 33 DB 66 81 3A 01 01 75 07 E8 ?? ?? ?? ?? B3 01 8B C3 5B C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "VarChangeType"
		size = 164
		refs = "0026 ChangeSourceAny 0042 VariantChangeTypeEx 004b VarCastError 0052 @VarClear 0070 AnyChangeType"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 8B F2 8B D8 66 8B 03 66 2D 00 01 74 07 66 FF C8 74 4C EB 57 8B D6 8B C3 8B CF E8 ?? ?? ?? ?? 84 C0 75 6F 66 C7 45 F0 00 00 57 6A 00 68 00 04 00 00 56 8D 45 F0 50 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 89 03 8B 45 F8 89 43 08 8B 45 FC 89 43 0C EB 34 8B D6 8B C3 8B CF E8 ?? ?? ?? ?? EB 27 8B D6 8B C3 8B CF E8 ?? ?? ?? ?? 84 C0 75 18 57 6A 00 68 00 04 00 00 56 53 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "VarOleStrToString"
		size = 45
		refs = "0013 OleStrToStrVar 001a @VarClear"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 33 C0 89 45 FC 8B 42 08 8D 55 FC E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 66 C7 03 00 01 8B 45 FC 89 43 08 5B 59 5D C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "VarStringToOleStr"
		size = 32
		refs = "0008 StringToOleStr 0011 @VarClear"
	strings:
		$1 = { 53 56 8B D8 8B 42 08 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 66 C7 03 08 00 89 73 08 5E 5B C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "@VarCast"
		size = 244
		refs = "0018 @VarCopy 0031 VarStringToOleStr 004c @VarCast 005f VarChangeType 0074 @VarClear 007a @HandleFinally 0097 VarOleStrToString"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 89 45 EC 66 8B 02 8B D9 66 3B D8 75 0D 8B 45 EC E8 ?? ?? ?? ?? E9 CE 00 00 00 66 3D 00 01 75 59 66 83 FB 08 75 0D 8B 45 EC E8 ?? ?? ?? ?? E9 B5 00 00 00 66 C7 45 F0 00 00 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 EC 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 66 81 FB 00 01 75 5E 66 3D 01 01 74 58 66 83 F8 08 75 0A 8B 45 EC E8 ?? ?? ?? ?? EB 52 66 C7 45 F0 00 00 8D 45 F0 66 B9 08 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 EC 8B CB E8 ?? ?? ?? ?? 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "@VarCastOle"
		size = 28
		refs = "0011 VarCastError 0017 @VarCast"
	strings:
		$1 = { 81 F9 00 01 00 00 74 08 81 F9 01 01 00 00 75 06 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "@VarToInt"
		size = 106
		refs = "0036 @VarCast 0055 C10000"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 03 74 38 83 FA 02 74 37 83 FA 11 74 37 83 FA 05 74 47 83 FA 04 74 3D 83 FA 06 74 2D 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 08 83 C4 10 C3 8B 40 08 C3 0F BF 40 08 C3 0F B6 40 08 C3 DF 68 08 D8 35 ?? ?? ?? ?? EB 08 D9 40 08 EB 03 DD 40 08 50 DB 1C 24 9B 58 C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "@VarToBool"
		size = 51
		refs = "0019 @VarCast"
	strings:
		$1 = { 66 83 38 0B 74 21 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 0B 00 00 00 E8 ?? ?? ?? ?? 66 8B 44 24 08 83 C4 10 EB 04 66 8B 40 08 66 F7 D8 19 C0 F7 D8 C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "@VarToReal"
		size = 92
		refs = "0036 @VarCast 004f C10000"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 05 74 38 83 FA 04 74 37 83 FA 06 74 36 83 FA 03 74 3B 83 FA 02 74 3A 83 FA 07 74 1F 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 05 00 00 00 E8 ?? ?? ?? ?? DD 44 24 08 83 C4 10 C3 DD 40 08 C3 D9 40 08 C3 DF 68 08 D8 35 ?? ?? ?? ?? C3 DB 40 08 C3 DF 40 08 C3 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "@VarToCurr"
		size = 90
		refs = "0031 @VarCast 0055 C10000"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 06 74 33 83 FA 05 74 32 83 FA 04 74 32 83 FA 03 74 32 83 FA 02 74 32 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 06 00 00 00 E8 ?? ?? ?? ?? DF 6C 24 08 83 C4 10 C3 DF 68 08 C3 DD 40 08 EB 0D D9 40 08 EB 08 DB 40 08 EB 03 DF 40 08 D8 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "@VarToPStr"
		size = 78
		refs = "000c @VarToPStr 001a @VarToLStr 0029 @LStrToString 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C3 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "@VarToLStr"
		size = 57
		refs = "000b @LStrAsg 0023 @VarCast 002a @LStrClr"
	strings:
		$1 = { 66 81 3A 00 01 75 08 8B 52 08 E9 ?? ?? ?? ?? 53 89 C3 83 EC 10 66 C7 04 24 00 00 89 E0 B9 00 01 00 00 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 8B 44 24 08 89 03 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "@VarToWStr"
		size = 54
		refs = "000a @WStrAsg 0022 @VarCast 002d WStrSet"
	strings:
		$1 = { 66 83 3A 08 75 08 8B 52 08 E9 ?? ?? ?? ?? 53 89 C3 83 EC 10 66 C7 04 24 00 00 89 E0 B9 08 00 00 00 E8 ?? ?? ?? ?? 89 D8 8B 54 24 08 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "AnyToIntf"
		size = 112
		refs = "001b @VarAddRef 0023 AnyToIntf 0032 ChangeAnyProc 003e VarCastError 0048 @IntfCopy 005d @VarClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F2 8D 7D F0 B9 04 00 00 00 F3 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 FF 15 ?? ?? ?? ?? 66 83 7D F0 0D 74 05 E8 ?? ?? ?? ?? 8B C3 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "@VarToIntf"
		size = 84
		refs = "0006 @IntfClear 002b VarCastError 0030 AnyToIntf 0035 @VarClear 0047 @IntfCopy"
	strings:
		$1 = { 66 83 3A 00 0F 84 ?? ?? ?? ?? 66 83 3A 0D 74 3B 66 83 3A 09 74 35 66 81 3A 0D 40 74 24 66 81 3A 09 40 74 1D 66 81 3A 01 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 E9 ?? ?? ?? ?? 8B 52 08 8B 12 E9 ?? ?? ?? ?? 8B 52 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "@VarToDisp"
		size = 46
		refs = "0006 @IntfClear 0017 VarCastError 0021 @IntfCopy"
	strings:
		$1 = { 66 83 3A 00 0F 84 ?? ?? ?? ?? 66 83 3A 09 74 15 66 81 3A 09 40 0F 85 ?? ?? ?? ?? 8B 52 08 8B 12 E9 ?? ?? ?? ?? 8B 52 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "@VarToDynArray"
		size = 15
		refs = "0001 DynArrayFromVariant 000a VarCastError"
	strings:
		$1 = { E8 ?? ?? ?? ?? 09 C0 75 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "@VarFromInt"
		size = 24
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 03 00 89 50 08 C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "@VarFromBool"
		size = 29
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 0B 00 F6 DA 19 D2 66 89 50 08 C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "@VarFromReal"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 05 00 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "@VarFromTDateTime"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 07 00 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "@VarFromCurr"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 06 00 DF 78 08 9B C3 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "@VarFromPStr"
		size = 79
		refs = "000f @VarFromPStr 001f @LStrFromString 0029 @VarFromLStr 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "@OleVarFromPStr"
		size = 79
		refs = "000f @OleVarFromPStr 001f @LStrFromString 0029 @OleVarFromLStr 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "@VarFromLStr"
		size = 64
		refs = "0009 @VarClear 0025 @NewAnsiString 0031 Move"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 85 D2 74 24 8B 4A F8 41 7E 06 F0 FF 42 F8 EB 18 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 4A FC E8 ?? ?? ?? ?? 5A 58 66 C7 00 00 01 89 50 08 C3 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "@VarFromWStr"
		size = 52
		refs = "0009 @VarClear 001e SysAllocStringLen 0026 WStrError"
	strings:
		$1 = { 50 66 83 38 08 72 07 52 E8 ?? ?? ?? ?? 5A 31 C0 85 D2 74 16 8B 42 FC D1 E8 74 0F 50 52 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 5A 66 C7 02 08 00 89 42 08 C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "@VarFromIntf"
		size = 34
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 0D 00 89 50 08 85 D2 74 06 52 8B 02 FF 50 04 C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "@VarFromDisp"
		size = 34
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 09 00 89 50 08 85 D2 74 06 52 8B 02 FF 50 04 C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "@VarFromDynArray"
		size = 19
		refs = "0002 DynArrayToVariant 000e VarCastError"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 66 83 38 00 75 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "@OleVarFromLStr"
		size = 33
		refs = "0009 @VarClear 001c @WStrFromLStr"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 08 00 83 C0 08 31 C9 89 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "OleVarFromAny"
		size = 100
		refs = "001b @VarAddRef 0023 OleVarFromAny 0032 ChangeAnyProc 003c @OleVarFromVar 0051 @VarClr 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F2 8D 7D F0 B9 04 00 00 00 F3 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 FF 15 ?? ?? ?? ?? 8B C3 8D 55 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "@OleVarFromVar"
		size = 60
		refs = "0007 OleVarFromAny 0012 @VarCopy 001f @VarClear 0037 @WStrFromLStr"
	strings:
		$1 = { 66 81 3A 01 01 0F 84 ?? ?? ?? ?? 66 81 3A 00 01 0F 85 ?? ?? ?? ?? 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 08 00 83 C0 08 83 C2 08 31 C9 8B 12 89 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "VarStrCat"
		size = 177
		refs = "0013 VarStrCat 002a @VarToLStr 0041 @LStrCat 004b @VarFromLStr 0057 @VarToWStr 006e @WStrCat 0078 @VarFromWStr 0092 @WStrArrayClr 009f @LStrArrayClr 00a5 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 81 3B 00 01 75 2D 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8D 45 FC 50 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? EB 2B 8D 45 F4 8B D3 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 45 F0 8B D6 E8 ?? ?? ?? ?? 8B 55 F0 58 E8 ?? ?? ?? ?? 8B 55 F4 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DE 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "AnyOp"
		size = 129
		refs = "001f @VarAddRef 0027 AnyOp 003c ChangeAnyProc 0059 VarOp 006e @VarClr 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F2 8D 7D F0 51 B9 04 00 00 00 F3 A5 59 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 81 3B 01 01 75 08 8B C3 FF 15 ?? ?? ?? ?? 66 81 7D F0 01 01 75 09 8D 45 F0 FF 15 ?? ?? ?? ?? 8D 55 F0 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "VarOp"
		size = 605
		refs = "003d BaseTypeMap 004b OpTypeMap 0052 VarOp 0067 AnyOp 0090 VarInvalidOp 0097 @VarClear 00ad @VarToInt 00c6 @VarFromInt 0135 @VarToReal 0156 @VarFromReal 016b @VarToCurr 018c @VarFromCurr 01cc C10000 020d VarStrCat 021d @VarToBool 0236 @VarFromBool"
	strings:
		$1 = { 53 56 57 89 C7 89 D6 89 CB 8B 07 8B 16 25 FF 0F 00 00 81 E2 FF 0F 00 00 83 F8 11 76 0C 3D 00 01 00 00 75 38 B8 08 00 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 24 BA 08 00 00 00 8A 80 ?? ?? ?? ?? 8A 92 ?? ?? ?? ?? 0F B6 8C C2 ?? ?? ?? ?? FF 14 8D ?? ?? ?? ?? 5F 5E 5B C3 89 D0 3D 01 01 00 00 75 29 5F 5E 5B E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 58 5F 5E 5B E9 ?? ?? ?? ?? 89 F8 E8 ?? ?? ?? ?? 66 C7 07 01 00 C3 80 FB 03 0F 84 88 00 00 00 89 F0 E8 ?? ?? ?? ?? 50 89 F8 E8 ?? ?? ?? ?? 5A FF 14 9D ?? ?? ?? ?? 89 C2 89 F8 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 D0 70 2C C3 29 D0 70 27 C3 F7 EA 70 22 C3 89 D1 99 F7 F9 C3 89 D1 99 F7 F9 89 D0 C3 89 D1 D3 E0 C3 89 D1 D3 E8 C3 21 D0 C3 09 D0 C3 31 D0 C3 58 EB 09 80 FB 04 0F 83 78 FF FF FF 89 F0 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F8 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C FF 14 9D ?? ?? ?? ?? 89 F8 E9 ?? ?? ?? ?? 80 FB 04 0F 83 47 FF FF FF 80 FB 02 73 28 89 F0 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F8 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C FF 14 9D ?? ?? ?? ?? 89 F8 E9 ?? ?? ?? ?? 80 FA 04 74 15 89 F0 E8 ?? ?? ?? ?? DF 6F 08 D9 C9 FF 14 9D ?? ?? ?? ?? EB DF 80 FB 03 74 23 80 F8 04 74 0E 89 F8 E8 ?? ?? ?? ?? DF 6E 08 DE C9 EB C7 DF 6F 08 DF 6E 08 DE C9 D8 35 ?? ?? ?? ?? EB B7 89 F8 E8 ?? ?? ?? ?? DF 6E 08 DE F9 E9 70 FF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DE C1 C3 DE E9 C3 DE C9 C3 DE F9 C3 80 FB 00 0F 85 21 FF FF FF 89 F8 89 F2 E9 ?? ?? ?? ?? 80 FB 08 0F 82 0F FF FF FF 89 F0 E8 ?? ?? ?? ?? 50 89 F8 E8 ?? ?? ?? ?? 5A FF 14 9D ?? ?? ?? ?? 89 C2 89 F8 E9 ?? ?? ?? ?? 80 FB 01 0F 87 E6 FE FF FF 72 0C 88 D4 66 3D 07 07 0F 84 E1 FE FF FF E8 ?? ?? ?? ?? 66 C7 07 07 00 C3 C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "@VarMul"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 02 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "@VarDiv"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 04 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "@VarMod"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 05 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "@VarAnd"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 08 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "@VarOr"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 09 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "@VarXor"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 0A 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "@VarShl"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 06 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "@VarShr"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 07 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "@VarRDiv"
		size = 11
		refs = "0006 VarOp"
	strings:
		$1 = { B9 03 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "VarCompareString"
		size = 47
	strings:
		$1 = { 56 57 89 C6 89 D7 09 C0 74 03 8B 40 FC 09 D2 74 03 8B 52 FC 89 C1 39 D1 76 02 89 D1 39 C9 F3 A6 74 08 0F B6 46 FF 0F B6 57 FF 29 D0 5F 5E C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "VarCmpStr"
		size = 104
		refs = "0011 VarCmpStr 0021 @VarToLStr 0038 VarCompareString 0054 @LStrArrayClr 005a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "AnyCmp"
		size = 153
		refs = "0022 AnyCmp 0041 ChangeAnyProc 0052 @VarCopy 006a @VarCmp 0085 @VarClr 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 33 C9 89 4D E0 89 4D E4 89 4D E8 89 4D EC 8B DA 89 45 FC 8D 75 F4 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC 89 5D F8 8B 45 FC 66 81 38 01 01 75 09 8B 45 FC FF 15 ?? ?? ?? ?? 66 81 3B 01 01 75 19 8D 45 E0 8B D3 E8 ?? ?? ?? ?? 8D 45 E0 FF 15 ?? ?? ?? ?? 8D 45 E0 89 45 F8 8B 55 F8 58 E8 ?? ?? ?? ?? 66 9C 58 89 45 F4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 06 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "@VarCmp"
		size = 272
		refs = "003a BaseTypeMap 0048 OpTypeMap 004f @VarCmp 005f AnyCmp 008a VarInvalidOp 0096 @VarToInt 00a8 @VarToReal 00d4 @VarToCurr 00f2 VarCmpStr 00ff @VarToBool"
	strings:
		$1 = { 56 57 89 C7 89 D6 8B 07 8B 16 25 FF 0F 00 00 81 E2 FF 0F 00 00 83 F8 11 76 0C 3D 00 01 00 00 75 34 B8 08 00 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 20 BA 08 00 00 00 8A 80 ?? ?? ?? ?? 8A 92 ?? ?? ?? ?? 0F B6 8C C2 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 89 D0 3D 01 01 00 00 75 2B 5F 5E E8 ?? ?? ?? ?? 50 66 9D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5F 5E E9 ?? ?? ?? ?? 38 D0 5F 5E C3 89 F0 E8 ?? ?? ?? ?? 97 E8 ?? ?? ?? ?? 39 F8 5F 5E C3 89 F8 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F0 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C DE D9 DF E0 88 E0 66 25 01 40 D0 C8 08 C4 9E 5F 5E C3 89 F8 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F0 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C EB D2 89 F8 89 F2 E8 ?? ?? ?? ?? 83 F8 00 5F 5E C3 89 F0 E8 ?? ?? ?? ?? 97 E8 ?? ?? ?? ?? 89 FA 38 D0 5F 5E C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "@VarNeg"
		size = 147
		refs = "001c BaseTypeMap 0023 @VarNeg 0031 ChangeAnyProc 005c VarInvalidOp 0063 @VarToInt 006d @VarFromInt 0073 @VarToReal 007b @VarFromReal"
	strings:
		$1 = { 8B 10 81 E2 FF 0F 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 46 BA 08 00 00 00 8A 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 3D 01 01 00 00 75 2D 50 FF 15 ?? ?? ?? ?? 58 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? F7 D8 89 C2 58 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? D9 E0 58 E9 ?? ?? ?? ?? DF 68 08 D9 E0 DF 78 08 9B C3 DD 40 08 D9 E0 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "@VarNot"
		size = 90
		refs = "002b ChangeAnyProc 0031 @VarNot 0037 @VarToInt 0041 @VarFromInt 0046 VarInvalidOp"
	strings:
		$1 = { 8B 10 81 E2 FF 0F 00 00 74 3B 83 FA 0B 74 3B 83 FA 01 74 45 83 FA 11 76 1C 81 FA 00 01 00 00 74 14 3D 01 01 00 00 75 1D 50 FF 15 ?? ?? ?? ?? 58 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? F7 D0 89 C2 58 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 66 8B 50 08 66 F7 DA 19 D2 F7 D2 66 89 50 08 C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "@VarClr"
		size = 8
		refs = "0002 @VarClear"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "@VarAddRef"
		size = 33
		refs = "0019 @VarCopy"
	strings:
		$1 = { 66 83 38 08 72 1A FF 70 0C FF 70 08 FF 70 04 FF 30 66 C7 00 00 00 89 E2 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "VarType"
		size = 4
	strings:
		$1 = { 0F B7 00 C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "VarAsType"
		size = 9
		refs = "0004 @VarCast"
	strings:
		$1 = { 91 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "VarIsEmpty"
		size = 33
	strings:
		$1 = { 66 83 38 00 74 18 66 8B 10 66 83 FA 09 74 06 66 83 FA 0D 75 06 83 78 08 00 74 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "VarIsNull"
		size = 8
	strings:
		$1 = { 66 83 38 01 0F 94 C0 C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "VarToStr"
		size = 34
		refs = "0011 @VarToLStr 001b @LStrClr"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 3B 01 74 0C 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "VarFromDateTime"
		size = 35
		refs = "0009 @VarClear"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 66 C7 03 07 00 8B 45 08 89 43 08 8B 45 0C 89 43 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "VarToDateTime"
		size = 46
		refs = "0017 @VarCast"
	strings:
		$1 = { 55 8B EC 83 C4 E8 66 C7 45 F0 00 00 8B D0 8D 45 F0 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 89 45 E8 8B 45 FC 89 45 EC DD 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "@WriteVariant"
		size = 98
		refs = "0012 @WriteVariant 0028 @VarToLStr 0034 @WriteLString 0039 @Flush 004e @LStrClr 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 3E 02 72 0A 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B C3 8B CF 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "VarArrayCreate"
		size = 157
		refs = "001f Error 0068 SafeArrayCreate 007d @VarClear"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FD FF FF 53 56 89 4D FC 8B DA 8B F0 F6 C3 01 74 05 83 FB 7F 7E 07 B0 12 E8 ?? ?? ?? ?? 43 D1 FB 79 03 83 D3 00 89 5D F8 8B 5D F8 4B 85 DB 7C 22 43 8D 95 F8 FD FF FF 8B C6 8B CA 8B 30 89 71 04 8B 70 04 2B 71 04 46 89 31 83 C0 08 83 C2 08 4B 75 E7 8D 85 F8 FD FF FF 50 8B 45 F8 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 07 B0 12 E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 66 8B 45 FC 66 0D 00 20 8B 55 08 66 89 02 8B 45 08 89 58 08 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "VarArrayOf"
		size = 84
		refs = "0028 VarArrayCreate 003e @VarArrayPut"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B E9 8B DA 89 04 24 55 33 C0 89 44 24 08 89 5C 24 0C 8D 44 24 08 B9 0C 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B F3 85 F6 7C 1A 46 33 FF 8B 1C 24 57 6A 01 53 55 E8 ?? ?? ?? ?? 83 C4 10 47 83 C3 10 4E 75 EC 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "@VarArrayRedim"
		size = 76
		refs = "001a Error 0037 SafeArrayRedim"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B FA 8B D8 66 8B 03 66 25 00 60 66 3D 00 20 74 07 B0 13 E8 ?? ?? ?? ?? 8B 73 08 8B C6 0F B7 10 8B 54 D0 0C 89 54 24 04 2B FA 47 89 3C 24 54 56 E8 ?? ?? ?? ?? 85 C0 74 07 B0 12 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "GetVarArray"
		size = 34
		refs = "000c Error"
	strings:
		$1 = { 53 8B D8 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? F6 43 01 40 74 07 8B 43 08 8B 00 5B C3 8B 43 08 5B C3 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "VarArrayDimCount"
		size = 25
		refs = "000c GetVarArray"
	strings:
		$1 = { 53 8B D8 F6 43 01 20 74 0C 8B C3 E8 ?? ?? ?? ?? 0F B7 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "VarArrayLowBound"
		size = 40
		refs = "000c GetVarArray 0012 SafeArrayGetLBound 001d Error"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 54 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "VarArrayHighBound"
		size = 40
		refs = "000c GetVarArray 0012 SafeArrayGetUBound 001d Error"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 54 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "VarArrayLock"
		size = 35
		refs = "0008 GetVarArray 000e SafeArrayAccessData 0019 Error"
	strings:
		$1 = { 53 51 8B D8 54 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 13 E8 ?? ?? ?? ?? 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "VarArrayUnlock"
		size = 29
		refs = "0006 GetVarArray 000c SafeArrayUnaccessData 0017 Error"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 13 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "VarArrayRef"
		size = 60
		refs = "000f Error 0016 @VarClear"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 66 8B 03 66 0D 00 40 66 89 06 F6 43 01 40 74 09 8B 43 08 89 46 08 5E 5B C3 8D 43 08 89 46 08 5E 5B C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "VarIsArray"
		size = 8
	strings:
		$1 = { F6 40 01 20 0F 95 C0 C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "@VarArrayGet"
		size = 145
		refs = "0016 Error 001d GetVarArray 0041 @VarClear 0054 SafeArrayPtrOfIndex 0069 @VarCopy 0079 SafeArrayGetElement"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 08 8B 75 0C F6 46 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D8 0F B7 03 3B 45 10 74 07 B0 14 E8 ?? ?? ?? ?? 66 8B 06 66 25 FF 0F 0F B7 C0 8B F0 8B C7 E8 ?? ?? ?? ?? 83 FE 0C 75 25 8D 45 FC 50 8D 45 14 50 53 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B C7 8B 55 FC E8 ?? ?? ?? ?? EB 1C 8D 47 08 50 8D 45 14 50 53 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 66 89 37 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "@VarArrayPut"
		size = 259
		refs = "0018 Error 001f GetVarArray 0056 SafeArrayPtrOfIndex 006b @VarCopy 007e @VarArrayPut 0093 VarStringToOleStr 00a7 @VarCast 00d0 SafeArrayPutElement 00f0 @VarClear 00f6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 8B 7D 0C 8B 5D 08 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 0F B7 06 3B 45 10 74 07 B0 14 E8 ?? ?? ?? ?? 66 8B 03 66 25 FF 0F 0F B7 C0 8B D8 83 FB 0C 75 2F 66 81 3F 00 01 74 28 8D 45 EC 50 8D 45 14 50 56 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B 45 EC 8B D7 E8 ?? ?? ?? ?? E9 88 00 00 00 66 C7 45 F0 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 FB 0C 75 12 8B D7 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F0 89 45 EC EB 27 8B D7 8D 45 F0 8B CB E8 ?? ?? ?? ?? 83 C3 F8 83 EB 02 72 05 83 EB 03 75 08 8B 45 F8 89 45 EC EB 06 8D 45 F8 89 45 EC 8B 45 EC 50 8D 45 14 50 56 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "VarArrayGet"
		size = 35
		refs = "0016 @VarArrayGet"
	strings:
		$1 = { 55 8B EC 53 89 CB 43 7E 06 FF 34 8A 49 79 FA 53 50 8B 45 08 50 E8 ?? ?? ?? ?? 8D 64 9C 0C 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "VarArrayPut"
		size = 38
		refs = "0019 @VarArrayPut"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 85 DB 78 06 FF 34 99 4B 79 FA 8B 5D 08 43 53 52 50 E8 ?? ?? ?? ?? 8D 64 9C 0C 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "@StrInt64"
		size = 189
		refs = "002f @_llmod 0054 @_lldiv 00b0 @SetLength"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 8B F2 8B F8 33 DB 83 7D 0C 00 75 09 83 7D 08 00 0F 92 C0 EB 03 0F 9C C0 88 45 FF 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 85 D2 7D 07 F7 D8 83 D2 00 F7 DA 83 C0 30 83 D2 00 88 44 1D DF 43 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D 0C 00 75 C0 83 7D 08 00 75 BA 80 7D FF 00 74 06 C6 44 1D DF 2D 43 81 FF FF 00 00 00 7E 05 BF FF 00 00 00 B8 01 00 00 00 8B D7 2B D3 3B D0 7C 09 C6 04 06 20 40 3B D0 7D F7 85 DB 7E 0D 4B 8A 54 1D DF 88 14 06 40 85 DB 7F F3 8B D0 4A 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "@Str0Int64"
		size = 26
		refs = "0011 @StrInt64"
	strings:
		$1 = { 55 8B EC 53 8B D8 FF 75 0C FF 75 08 8B D3 33 C0 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "@WriteInt64"
		size = 40
		refs = "0014 @StrInt64 001d @WriteString"
	strings:
		$1 = { 83 EC 20 50 52 FF 74 24 30 FF 74 24 30 31 C0 8D 54 24 10 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C2 08 00 C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "@Write0Int64"
		size = 8
		refs = "0003 @WriteInt64"
	strings:
		$1 = { 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "@ValInt64"
		size = 546
		refs = "006b UpCase 0191 @_llmul"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 14 24 8B F0 BD 01 00 00 00 33 FF C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 85 F6 75 0B 8B 04 24 89 28 E9 E1 01 00 00 45 80 7C 2E FF 20 74 F8 C6 44 24 10 00 8A 44 2E FF 3C 2D 75 08 C6 44 24 10 01 45 EB 05 3C 2B 75 01 45 B3 01 80 7C 2E FF 24 74 1B 80 7C 2E FF 30 0F 85 DA 00 00 00 8A 04 2E E8 ?? ?? ?? ?? 3C 58 0F 85 CA 00 00 00 80 7C 2E FF 30 75 01 45 45 8A 44 2E FF 8B D0 80 C2 D0 80 EA 0A 72 12 80 C2 F9 80 EA 06 72 17 80 C2 E6 80 EA 06 72 1C EB 7A 8B F8 81 E7 FF 00 00 00 83 EF 30 EB 18 8B F8 81 E7 FF 00 00 00 83 EF 37 EB 0B 8B F8 81 E7 FF 00 00 00 83 EF 57 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 47 EB 02 7C 43 81 7C 24 0C FF FF FF 0F 75 09 83 7C 24 08 FF 76 04 EB 30 7F 2E 8B C7 99 52 50 8B 44 24 10 8B 54 24 14 0F A4 C2 04 C1 E0 04 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB E9 66 FF FF FF 80 7C 24 10 00 0F 84 D3 00 00 00 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C E9 B7 00 00 00 8A 44 2E FF 8B D0 80 C2 D0 80 EA 0A 73 62 8B F8 81 E7 FF 00 00 00 83 EF 30 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 49 EB 02 7C 45 81 7C 24 0C CC CC CC 0C 75 0C 81 7C 24 08 CC CC CC CC 76 04 EB 2F 7F 2D 6A 00 6A 0A 8B 44 24 10 8B 54 24 14 E8 ?? ?? ?? ?? 52 50 8B C7 99 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB EB 90 80 7C 24 10 00 74 17 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C 83 7C 24 0C 00 75 05 83 7C 24 08 00 74 1B 83 7C 24 0C 00 75 0A 83 7C 24 08 00 0F 92 C0 EB 03 0F 9C C0 3A 44 24 10 74 01 4D 80 7C 2E FF 00 0F 95 C0 0A D8 74 07 8B 04 24 89 28 EB 07 8B 04 24 33 D2 89 10 8B 44 24 08 8B 54 24 0C 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "CopyArray"
		size = 15
		refs = "0007 @CopyArray"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "DynArraySetLength"
		size = 394
		refs = "0026 Error 0030 DynArrayClear 00af FinalizeArray 00ba @ReallocMem 00c9 @GetMem 00f0 @FillChar 0105 CopyArray 011d Move 0172 DynArraySetLength"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 4D F8 8B F2 89 45 FC 8B 5D FC 8B 1B 8B 45 08 8B 38 85 FF 7F 1A 85 FF 7D 07 B0 04 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? E9 48 01 00 00 33 C0 89 45 F0 85 DB 74 0B 83 EB 04 8B 03 89 45 F0 83 EB 04 33 C0 8A 46 01 01 C6 8B 46 02 89 45 E8 8B 46 06 85 C0 74 04 8B 30 EB 02 33 F6 8B C7 F7 6D E8 89 45 E4 8B 45 E4 99 F7 FF 3B 45 E8 74 07 B0 04 E8 ?? ?? ?? ?? 83 45 E4 08 85 DB 74 05 83 3B 01 75 35 89 5D E0 3B 7D F0 7D 1D 85 F6 74 19 8B C3 83 C0 08 8B D7 0F AF 55 E8 03 C2 8B 4D F0 2B CF 8B D6 E8 ?? ?? ?? ?? 8D 45 E0 8B 55 E4 E8 ?? ?? ?? ?? 8B 5D E0 EB 5E FF 0B 8B 45 E4 E8 ?? ?? ?? ?? 8B D8 8B 45 F0 89 45 EC 3B 7D EC 7D 03 89 7D EC 85 F6 74 2A 8B 55 EC 0F AF 55 E8 8B C3 83 C0 08 33 C9 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 55 FC 8B 12 8B C3 83 C0 08 8B CE E8 ?? ?? ?? ?? EB 16 8B 4D EC 0F AF 4D E8 8B D3 83 C2 08 8B 45 FC 8B 00 E8 ?? ?? ?? ?? C7 03 01 00 00 00 83 C3 04 89 3B 83 C3 04 8B D7 2B 55 F0 0F AF 55 E8 8B 45 E8 0F AF 45 F0 03 C3 33 C9 E8 ?? ?? ?? ?? 83 7D F8 01 7E 2E 83 45 08 04 FF 4D F8 4F 85 FF 7C 22 47 C7 45 F4 00 00 00 00 8B 45 08 50 8B 45 F4 8D 04 83 8B 4D F8 8B D6 E8 ?? ?? ?? ?? FF 45 F4 4F 75 E6 8B 45 FC 89 18 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "@DynArraySetLength"
		size = 11
		refs = "0006 DynArraySetLength"
	strings:
		$1 = { 54 83 04 24 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "@DynArrayCopy"
		size = 23
		refs = "0011 @DynArrayCopyRange"
	strings:
		$1 = { 53 85 C0 74 10 8B D8 83 EB 04 8B 1B 53 51 33 C9 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "@DynArrayCopyRange"
		size = 243
		refs = "0086 @GetMem 00b6 @FillChar 00c4 CopyArray 00d6 Move 00e1 DynArrayClear"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 89 55 F8 89 45 FC 8B 75 0C 33 DB 83 7D FC 00 0F 84 BA 00 00 00 8B 45 F8 89 45 F0 85 FF 7D 04 03 F7 33 FF 8B 45 FC 83 E8 04 8B 00 3B C7 7D 02 8B F8 8B D0 2B D7 3B F2 7E 02 8B F2 85 F6 7D 02 33 F6 85 F6 0F 8E 86 00 00 00 8B 45 F0 0F B6 40 01 01 45 F0 8B 45 F0 8B 40 02 89 45 F4 8B 45 F0 8B 40 06 85 C0 74 07 8B 00 89 45 F0 EB 05 33 C0 89 45 F0 8B C6 F7 6D F4 83 C0 08 E8 ?? ?? ?? ?? 8B D8 C7 03 01 00 00 00 83 C3 04 89 33 83 C3 04 0F AF 7D F4 01 7D FC 85 F6 7E 35 83 7D F0 00 74 1F 8B D6 0F AF 55 F4 8B C3 33 C9 E8 ?? ?? ?? ?? 56 8B 4D F0 8B 55 FC 8B C3 E8 ?? ?? ?? ?? EB 10 8B CE 0F AF 4D F4 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 89 18 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "@DynArrayClear"
		size = 58
		refs = "002c @FinalizeArray 0034 @FreeMem"
	strings:
		$1 = { 8B 08 85 C9 74 33 C7 00 00 00 00 00 F0 FF 49 F8 75 27 50 89 C8 31 C9 8A 4A 01 8B 54 0A 06 85 D2 74 0E 8B 48 FC 85 C9 74 07 8B 12 E8 ?? ?? ?? ?? 83 E8 08 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "@DynArrayAsg"
		size = 39
		refs = "001d @DynArrayClear"
	strings:
		$1 = { 53 8B 18 85 D2 74 04 F0 FF 42 F8 85 DB 74 14 F0 FF 4B F8 75 0E 50 52 89 CA FF 43 F8 E8 ?? ?? ?? ?? 5A 58 89 10 5B C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "@DynArrayAddRef"
		size = 9
	strings:
		$1 = { 85 C0 74 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "DynArrayIndex"
		size = 62
	strings:
		$1 = { 55 8B EC 53 56 57 55 89 D6 8B 7D 08 89 C5 31 DB 85 C9 7D 03 8B 6D 00 31 C0 8A 47 01 01 C7 8B 04 9E F7 67 02 8B 7F 06 85 FF 74 02 8B 3F 01 C5 43 39 CB 7E E0 89 E8 5D 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "DynArrayElTypeInfo"
		size = 25
	strings:
		$1 = { 33 D2 85 C0 74 10 33 C9 8A 48 01 01 C8 8B 48 06 85 C9 74 02 8B 11 8B C2 C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "DynArrayDim"
		size = 24
		refs = "0007 DynArrayElTypeInfo"
	strings:
		$1 = { 53 33 DB EB 06 43 E8 ?? ?? ?? ?? 85 C0 74 05 80 38 11 74 F1 8B C3 5B C3 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "IsDynArrayRectangular"
		size = 101
		refs = "0010 DynArrayDim 0024 DynArraySize"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 C6 04 24 01 8B D8 8B C2 E8 ?? ?? ?? ?? 48 85 C0 7E 42 89 44 24 04 85 DB 74 34 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 03 E8 ?? ?? ?? ?? 8B E8 4E 85 F6 7E 1B BF 01 00 00 00 8B 04 BB E8 ?? ?? ?? ?? 3B E8 74 06 C6 04 24 00 EB 0C 47 4E 75 EA 8B 1B FF 4C 24 04 75 C2 8A 04 24 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "DynArrayVariantBounds"
		size = 88
		refs = "000b DynArrayDim 001f TBoundArray 0024 @DynArraySetLength 003e DynArraySize"
	strings:
		$1 = { 53 56 57 55 8B F9 8B F0 8B C2 E8 ?? ?? ?? ?? 8B E8 8B C5 03 C0 50 8B C7 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 DB EB 1C 8B 07 33 D2 89 14 98 43 85 F6 74 0F 8B C6 E8 ?? ?? ?? ?? 48 8B 17 89 04 9A 8B 36 43 8B C5 03 C0 3B D8 7C DC 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "DynArrayBounds"
		size = 82
		refs = "0010 DynArrayDim 0020 TBoundArray 0025 @DynArraySetLength 003b DynArraySize"
	strings:
		$1 = { 53 56 57 55 51 8B E9 89 14 24 8B D8 8B 04 24 E8 ?? ?? ?? ?? 8B F0 56 8B C5 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 4E 85 F6 7C 1B 46 33 FF 85 DB 74 10 8B C3 E8 ?? ?? ?? ?? 48 8B 55 00 89 04 BA 8B 1B 47 4E 75 E8 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "DynArrayVarType"
		size = 37
	strings:
		$1 = { BA 01 00 00 00 85 C0 74 0F 80 38 11 75 0A 33 D2 8A 50 01 01 D0 8B 50 0A 83 FA 48 75 05 BA 00 01 00 00 8B C2 C3 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "DecIndices"
		size = 108
		refs = "000c @DynArrayHigh"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 8B 07 E8 ?? ?? ?? ?? 8B D0 85 D2 7C 13 42 33 C0 8B 0F 83 3C 81 00 74 04 B3 01 EB 04 40 4A 75 F0 84 DB 74 39 8B 07 E8 ?? ?? ?? ?? 83 F8 00 7C 2D 8B 17 83 3C 82 00 74 10 8B 17 FF 0C 82 EB 1E 8B 14 86 8B 0F 89 14 81 48 8B 17 83 3C 82 00 74 EF 8B 17 FF 0C 82 EB 06 48 83 F8 FF 75 D3 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "DynArrayToVariant"
		size = 703
		refs = "0023 DynArrayToVariant 0032 TBoundArray 0037 @DynArrayClear 004d @VarClear 0054 DynArrayVarType 0084 DynArrayDim 0091 IsDynArrayRectangular 00a6 DynArrayVariantBounds 00b3 DynArrayBounds 00c4 @DynArrayCopy 00d0 @DynArrayHigh 00dc VarArrayCreate 00e7 @VarCopy 00fd DynArrayIndex 0193 @VarFromInt 01b1 @VarFromReal 01cf @VarFromCurr 01e7 @VarFromWStr 01f3 @VarFromDisp 0213 @VarFromBool 022b @VarFromIntf 0245 @VarFromLStr 0266 VarArrayPut 0271 DecIndices 028f Variant 0299 @FinalizeArray 02b2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B F9 89 55 F8 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B D8 83 FB 01 7E 05 83 FB 11 7E 0C 81 FB 00 01 00 00 0F 85 0D 02 00 00 81 FB 00 01 00 00 75 07 BE 08 00 00 00 EB 02 8B F3 8B C7 E8 ?? ?? ?? ?? 48 7E 12 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 84 C0 0F 84 E0 01 00 00 8D 4D F4 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 8D 4D F0 8B D7 8B 45 F8 E8 ?? ?? ?? ?? 8D 4D EC 8B 15 ?? ?? ?? ?? 8B 45 F0 E8 ?? ?? ?? ?? 8D 45 C8 50 8B 45 F4 E8 ?? ?? ?? ?? 8B D0 8B CE 8B 45 F4 E8 ?? ?? ?? ?? 8D 55 C8 8B 45 FC E8 ?? ?? ?? ?? 57 8B 45 EC E8 ?? ?? ?? ?? 8B C8 8B 55 EC 8B 45 F8 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 5F 01 00 00 8B C3 83 F8 09 7F 3A 0F 84 D5 00 00 00 83 F8 08 0F 87 2A 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F8 0D 7F 22 0F 84 CE 00 00 00 83 E8 0A 0F 84 99 00 00 00 48 0F 84 9E 00 00 00 48 0F 84 AB 00 00 00 E9 D8 00 00 00 83 E8 11 0F 84 B5 00 00 00 2D EF 00 00 00 0F 84 B8 00 00 00 E9 BF 00 00 00 8D 45 D8 0F BF 16 E8 ?? ?? ?? ?? E9 B7 00 00 00 8D 45 D8 8B 16 E8 ?? ?? ?? ?? E9 A8 00 00 00 D9 06 8D 45 D8 E8 ?? ?? ?? ?? E9 99 00 00 00 DD 06 8D 45 D8 E8 ?? ?? ?? ?? E9 8A 00 00 00 DF 2E 8D 45 D8 E8 ?? ?? ?? ?? EB 7E DD 06 8D 45 D8 E8 ?? ?? ?? ?? EB 72 8D 45 D8 8B 16 E8 ?? ?? ?? ?? EB 66 8D 45 D8 8B 16 E8 ?? ?? ?? ?? EB 5A 8D 45 D8 8B 16 E8 ?? ?? ?? ?? EB 4E 8D 45 D8 66 8B 16 66 F7 DA 1B D2 F7 DA E8 ?? ?? ?? ?? EB 3A 8D 45 D8 8B D6 E8 ?? ?? ?? ?? EB 2E 8D 45 D8 8B 16 E8 ?? ?? ?? ?? EB 22 8D 45 D8 33 D2 8A 16 E8 ?? ?? ?? ?? EB 14 8D 45 D8 8B 16 E8 ?? ?? ?? ?? EB 08 8D 45 D8 E8 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 D8 8B 45 FC 8B 4D EC E8 ?? ?? ?? ?? 8D 45 EC 8B 55 F0 E8 ?? ?? ?? ?? 84 C0 0F 85 6E FE FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 EC 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D2 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "DynArrayFromVariant"
		size = 629
		refs = "0023 DynArrayFromVariant 0030 VarArrayDimCount 003e @GetMem 0056 VarArrayHighBound 0061 VarArrayLowBound 0083 DynArraySetLength 008a DynArrayDim 0091 DynArrayVarType 00a3 DynArrayBounds 00ac TBoundArray 00b4 @DynArrayCopy 00c0 @DynArrayHigh 00cc VarArrayGet 00e7 DynArrayIndex 0172 @VarToInt 0191 @VarToReal 01ae @VarToCurr 01ca @VarToWStr 01d6 @VarToDisp 01ec @VarToBool 01fb @VarCopy 0207 @VarToIntf 021f @VarToLStr 022a DecIndices 023a @FreeMem 024f @VarClr 0262 @FinalizeArray 0268 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 89 4D F8 8B F2 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F4 C1 E0 02 E8 ?? ?? ?? ?? 89 45 F0 8B 7D F4 4F 85 FF 7C 26 47 33 DB 8D 53 01 8B C6 E8 ?? ?? ?? ?? 50 8D 53 01 8B C6 E8 ?? ?? ?? ?? 5A 2B D0 42 8B 45 F0 89 14 98 43 4F 75 DD 8B 45 F0 50 8B 45 FC 8B 4D F4 8B 5D F8 8B D3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D8 8D 4D EC 8B 45 FC 8B 00 8B 55 F8 E8 ?? ?? ?? ?? 8D 4D E8 8B 15 ?? ?? ?? ?? 8B 45 EC E8 ?? ?? ?? ?? 8D 45 D8 50 8B 45 E8 E8 ?? ?? ?? ?? 8B C8 8B C6 8B 55 E8 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 45 E8 E8 ?? ?? ?? ?? 8B C8 8B 45 FC 8B 00 8B 55 E8 E8 ?? ?? ?? ?? 8B F8 8B C3 83 F8 09 7F 3A 0F 84 D6 00 00 00 83 F8 08 0F 87 20 01 00 00 FF 24 85 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F8 0D 7F 22 0F 84 C8 00 00 00 83 E8 0A 0F 84 9A 00 00 00 48 0F 84 9F 00 00 00 48 0F 84 A5 00 00 00 E9 CE 00 00 00 83 E8 11 0F 84 AF 00 00 00 2D EF 00 00 00 0F 84 B0 00 00 00 E9 B5 00 00 00 8D 45 D8 E8 ?? ?? ?? ?? 66 89 07 E9 A5 00 00 00 8D 45 D8 E8 ?? ?? ?? ?? 89 07 E9 96 00 00 00 8D 45 D8 E8 ?? ?? ?? ?? D9 1F 9B E9 86 00 00 00 8D 45 D8 E8 ?? ?? ?? ?? DD 1F 9B EB 79 8D 45 D8 E8 ?? ?? ?? ?? DF 3F 9B EB 6C 8D 45 D8 E8 ?? ?? ?? ?? DD 1F 9B EB 5F 8B C7 8D 55 D8 E8 ?? ?? ?? ?? EB 53 8B C7 8D 55 D8 E8 ?? ?? ?? ?? EB 47 8D 45 D8 E8 ?? ?? ?? ?? 89 07 EB 3B 8D 45 D8 E8 ?? ?? ?? ?? 66 89 07 EB 2E 8B C7 8D 55 D8 E8 ?? ?? ?? ?? EB 22 8B C7 8D 55 D8 E8 ?? ?? ?? ?? EB 16 8D 45 D8 E8 ?? ?? ?? ?? 88 07 EB 0A 8B C7 8D 55 D8 E8 ?? ?? ?? ?? 8D 45 E8 8B 55 EC E8 ?? ?? ?? ?? 84 C0 0F 85 82 FE FF FF 8B 45 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "FindHInstance"
		size = 38
		refs = "000c VirtualQuery"
	strings:
		$1 = { 83 C4 E4 6A 1C 8D 54 24 04 52 50 E8 ?? ?? ?? ?? 81 7C 24 10 00 10 00 00 75 06 8B 44 24 04 EB 02 33 C0 83 C4 1C C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "FindResourceHInstance"
		size = 36
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 85 D2 74 19 3B 42 04 74 0A 3B 42 08 74 05 3B 42 0C 75 04 8B 42 10 C3 8B 12 85 D2 75 E7 C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "FindBS"
		size = 20
		refs = "0004 CharNext"
	strings:
		$1 = { EB 06 50 E8 ?? ?? ?? ?? 8A 10 84 D2 74 05 80 FA 5C 75 EF C3 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "ToLongPath"
		size = 424
		refs = "0016 ToLongPath 001b GetModuleHandle 002c GetProcAddress 005c lstrcpy 0081 FindBS 00c0 lstrcpyn 0108 FindFirstFile 0115 FindClose 0121 lstrlen"
	strings:
		$1 = { 55 8B EC 81 C4 B0 FD FF FF 53 56 57 89 45 FC 8B 45 FC 89 45 F8 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 74 40 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 2C 68 05 01 00 00 8D 85 B1 FD FF FF 50 8B 45 FC 50 FF 55 F4 85 C0 74 15 8D 85 B1 FD FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? E9 15 01 00 00 8B 45 FC 80 38 5C 75 38 8B 45 FC 80 78 01 5C 0F 85 00 01 00 00 8B 45 FC 83 C0 02 E8 ?? ?? ?? ?? 8B D8 80 3B 00 0F 84 EA 00 00 00 8D 43 01 E8 ?? ?? ?? ?? 8B D8 80 3B 00 0F 84 D7 00 00 00 EB 06 8B 5D FC 83 C3 02 8B F3 2B 75 FC 8D 46 01 50 8B 45 FC 50 8D 85 B1 FD FF FF 50 E8 ?? ?? ?? ?? E9 98 00 00 00 8D 43 01 E8 ?? ?? ?? ?? 8B F8 8B C7 2B C3 8B D0 03 D6 42 81 FA 05 01 00 00 0F 8F 92 00 00 00 40 50 53 8D 85 B1 FD FF FF 03 C6 50 E8 ?? ?? ?? ?? 8D 85 B6 FE FF FF 50 8D 85 B1 FD FF FF 50 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 67 53 E8 ?? ?? ?? ?? 8D 85 E2 FE FF FF 50 E8 ?? ?? ?? ?? 8D 56 01 03 C2 40 3D 05 01 00 00 7F 48 C6 84 35 B1 FD FF FF 5C 8D 85 E2 FE FF FF 50 8D 85 B1 FD FF FF 03 C6 40 50 E8 ?? ?? ?? ?? 8D 85 E2 FE FF FF 50 E8 ?? ?? ?? ?? 40 03 F0 8B DF 80 3B 00 0F 85 5F FF FF FF 8D 85 B1 FD FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 45 F8 5F 5E 5B 8B E5 5D C3 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 4C 6F 6E 67 50 61 74 68 4E 61 6D 65 41 00 00 00 00 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "LoadResourceModule"
		size = 508
		refs = "001d GetModuleFileName 0031 LoadResourceModule 003b RegOpenKeyEx 0089 ToLongPath 0093 RegQueryValueEx 00c7 RegCloseKey 00cd @HandleFinally 00df lstrcpy 00ec GetThreadLocale 00f2 GetLocaleInfo 011d lstrlen 0164 LoadLibraryEx"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 56 89 45 FC 68 05 01 00 00 8D 85 E3 FE FF FF 50 6A 00 E8 ?? ?? ?? ?? C6 45 EE 00 8D 45 F8 50 68 3F 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 1E 8D 45 F8 50 68 3F 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 72 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E8 05 00 00 00 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 8D 85 E3 FE FF FF E8 ?? ?? ?? ?? 50 8B 45 F8 50 E8 ?? ?? ?? ?? 85 C0 74 1A 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 8B 45 FC 50 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 6A 05 8D 45 F3 50 6A 03 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 F6 80 BD E3 FE FF FF 00 0F 84 AF 00 00 00 80 7D F3 00 75 0A 80 7D EE 00 0F 84 9F 00 00 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B D8 8D 85 E3 FE FF FF 03 D8 EB 01 4B 80 3B 2E 74 0A 8D 85 E3 FE FF FF 3B D8 75 F0 8D 85 E3 FE FF FF 3B D8 74 6D 43 80 7D EE 00 74 1C 8D 45 EE 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 46 80 7D F3 00 74 40 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 20 C6 45 F5 00 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 8B C6 5E 5B 8B E5 5D C3 53 6F 66 74 77 61 72 65 5C 42 6F 72 6C 61 6E 64 5C 4C 6F 63 61 6C 65 73 00 00 00 00 53 6F 66 74 77 61 72 65 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 4C 6F 63 61 6C 65 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "EnumModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 04 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "EnumResourceModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 10 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "AddModuleUnloadProc"
		size = 31
		refs = "0009 @GetMem 000f ModuleUnloadList"
	strings:
		$1 = { 53 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 89 58 04 A3 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "RemoveModuleUnloadProc"
		size = 94
		refs = "0004 ModuleUnloadList 0027 @FreeMem"
	strings:
		$1 = { 53 56 8B 35 ?? ?? ?? ?? 85 F6 74 22 8B 56 04 3B D0 75 1B A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? BA 08 00 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 85 D2 74 27 8B 0A 85 C9 74 1B 8B 59 04 3B D8 75 14 8B F1 8B 01 89 02 BA 08 00 00 00 8B C6 E8 ?? ?? ?? ?? EB 06 8B 12 85 D2 75 D9 5E 5B C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "NotifyModuleUnload"
		size = 90
		refs = "000d ModuleUnloadList 001e NotifyModuleUnload 003c @HandleAnyException 0041 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC A1 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 39 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D F8 8B 45 FC FF 53 04 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 00 89 45 F8 83 7D F8 00 75 C7 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "RegisterModule"
		size = 14
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "UnregisterModule"
		size = 110
		refs = "000b UnregisterModule 001c NotifyModuleUnload 0032 LibModuleList 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 75 0C 8B 45 FC 8B 00 A3 ?? ?? ?? ?? EB 1F A1 ?? ?? ?? ?? 85 C0 74 16 8B 10 3B 55 FC 75 09 8B 55 FC 8B 12 89 10 EB 06 8B 00 85 C0 75 EA C3 E9 ?? ?? ?? ?? EB C2 59 5D C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "LoadResString"
		size = 86
		refs = "002c FindResourceHInstance 0032 LoadString 003d @LStrFromPCharLen 0049 @LStrFromPChar"
	strings:
		$1 = { 53 56 81 C4 00 FC FF FF 8B F2 8B D8 85 DB 74 3D 81 7B 04 00 00 01 00 7D 2A 68 00 04 00 00 8D 44 24 04 50 8B 43 04 50 8B 03 8B 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 0A 8B C6 8B 53 04 E8 ?? ?? ?? ?? 81 C4 00 04 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "@IntfClear"
		size = 21
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 8B 02 FF 50 08 58 C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "@IntfCopy"
		size = 27
	strings:
		$1 = { 8B 08 89 10 85 D2 74 08 51 52 8B 02 FF 50 04 59 85 C9 74 06 51 8B 01 FF 50 08 C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "@IntfCast"
		size = 42
		refs = "0004 @IntfClear 0025 Error"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 50 51 52 8B 08 85 C9 74 09 51 8B 01 FF 50 08 8B 14 24 8B 02 FF 10 85 C0 74 07 B0 17 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "@IntfAddRef"
		size = 11
	strings:
		$1 = { 85 C0 74 06 50 8B 00 FF 50 04 C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TInterfacedObject.AfterConstruction"
		size = 10
		refs = "0005 InterlockedDecrement"
	strings:
		$1 = { 83 C0 04 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TInterfacedObject.BeforeDestruction"
		size = 14
		refs = "0009 Error"
	strings:
		$1 = { 83 78 04 00 74 07 B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TInterfacedObject.NewInstance"
		size = 13
		refs = "0001 TObject.NewInstance"
	strings:
		$1 = { E8 ?? ?? ?? ?? C7 40 04 01 00 00 00 C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TInterfacedObject.QueryInterface"
		size = 38
		refs = "0010 TObject.GetInterface"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 4D 10 8B 55 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 05 B8 02 40 00 80 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TInterfacedObject._AddRef"
		size = 19
		refs = "000b InterlockedIncrement"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TInterfacedObject._Release"
		size = 40
		refs = "000d InterlockedDecrement"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8D 43 04 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 09 B2 01 8B C3 8B 08 FF 51 FC 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "@CheckAutoResult"
		size = 27
		refs = "0006 SafeCallErrorProc 0016 Error"
	strings:
		$1 = { 85 C0 79 16 8B 0D ?? ?? ?? ?? 85 C9 74 05 8B 14 24 FF D1 B0 18 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "CompToDouble"
		size = 20
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 DD 5D F8 9B DD 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "DoubleToComp"
		size = 14
	strings:
		$1 = { 55 8B EC DD 45 08 8B 45 10 DF 38 9B 5D C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "CompToCurrency"
		size = 32
		refs = "000b CompToCurrency"
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 D8 0D ?? ?? ?? ?? DF 7D F8 9B DF 6D F8 59 59 5D C3 00 00 00 40 1C 46 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "CurrencyToComp"
		size = 24
		refs = "0008 CurrencyToComp"
	strings:
		$1 = { 55 8B EC DF 6D 08 D8 35 ?? ?? ?? ?? 8B 45 10 DF 38 9B 5D C3 00 40 1C 46 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "GetMemory"
		size = 13
		refs = "0007 SysGetMem"
	strings:
		$1 = { 55 8B EC 8B 45 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "FreeMemory"
		size = 21
		refs = "000f SysFreeMem"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 04 33 C0 5D C3 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "ReallocMemory"
		size = 16
		refs = "000a SysReallocMem"
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 45 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "_DF_"
		size = 514
		refs = "0016 ReadFile 0022 GetLastError 0049 WriteFile 0066 CloseHandle 00a6 _DF_ 00fc CreateFileA 0120 GetFileSize 013c SetFilePointer 0190 SetEndOfFile 01b0 GetStdHandle 01c7 GetFileType"
	strings:
		$1 = { 33 D2 89 50 10 89 50 0C 52 8D 50 10 52 FF 70 08 FF 70 14 FF 30 E8 ?? ?? ?? ?? 85 C0 74 03 33 C0 C3 E8 ?? ?? ?? ?? 83 F8 6D 74 F3 C3 33 C0 C3 51 8B 50 0C 85 D2 7E 1A 33 C9 89 48 0C 51 8D 4C 24 04 51 52 FF 70 14 FF 30 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 59 C3 E8 ?? ?? ?? ?? EB F7 FF 30 C7 40 04 B0 D7 00 00 E8 ?? ?? ?? ?? 48 75 01 C3 E8 ?? ?? ?? ?? C3 56 8B F0 33 C0 89 46 0C 89 46 10 8B 46 04 2D B1 D7 00 00 74 0B 48 74 20 48 74 2E E9 49 01 00 00 B8 00 00 00 80 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? EB 27 B8 00 00 00 40 BA 01 00 00 00 B9 02 00 00 00 EB 0F B8 00 00 00 C0 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? C7 46 24 ?? ?? ?? ?? C7 46 20 ?? ?? ?? ?? 80 7E 48 00 0F 84 AE 00 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 46 48 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 EB 00 00 00 89 06 81 7E 04 B3 D7 00 00 0F 85 A3 00 00 00 FF 4E 04 6A 00 FF 36 E8 ?? ?? ?? ?? 40 0F 84 C9 00 00 00 2D 81 00 00 00 73 02 33 C0 6A 00 6A 00 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 AD 00 00 00 6A 00 8B D4 6A 00 52 68 80 00 00 00 8D 96 4C 01 00 00 52 FF 36 E8 ?? ?? ?? ?? 5A 48 0F 85 8B 00 00 00 33 C0 3B C2 73 4C 80 BC 06 4C 01 00 00 1A 74 03 40 EB EF 6A 02 6A 00 2B C2 50 FF 36 E8 ?? ?? ?? ?? 40 74 67 FF 36 E8 ?? ?? ?? ?? 48 75 5D EB 22 C7 46 24 ?? ?? ?? ?? 81 7E 04 B2 D7 00 00 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? 83 F8 FF 74 3B 89 06 81 7E 04 B1 D7 00 00 74 17 FF 36 E8 ?? ?? ?? ?? 85 C0 74 10 83 F8 02 75 07 C7 46 20 ?? ?? ?? ?? 33 C0 5E C3 FF 36 E8 ?? ?? ?? ?? C7 46 04 B0 D7 00 00 B8 69 00 00 00 EB E9 C7 46 04 B0 D7 00 00 E8 ?? ?? ?? ?? EB DB }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "@Assign"
		size = 86
		refs = "0024 _DF_"
	strings:
		$1 = { 8D 88 4C 01 00 00 89 48 14 33 C9 89 08 C7 40 04 B0 D7 00 00 C7 40 08 80 00 00 00 89 48 0C 89 48 10 C7 40 18 ?? ?? ?? ?? 89 48 1C 89 48 20 89 48 24 8D 40 48 85 D2 74 1B B5 82 8A 0A 42 88 08 40 84 C9 74 11 8A 0A 42 88 08 40 84 C9 74 07 FE CD 75 E8 48 88 28 C3 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "@_Flush"
		size = 37
		refs = "0021 SetInOutRes"
	strings:
		$1 = { 8B 50 04 81 FA B2 D7 00 00 75 08 FF 50 1C 85 C0 75 0E C3 81 FA B1 D7 00 00 74 F7 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "@Flush"
		size = 37
		refs = "0021 SetInOutRes"
	strings:
		$1 = { 8B 50 04 81 FA B2 D7 00 00 75 08 FF 50 20 85 C0 75 0E C3 81 FA B1 D7 00 00 74 F7 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "@BlockRead"
		size = 99
		refs = "0026 ReadFile 004f GetLastError 0054 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 8B F2 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 48 51 6A 00 8B C4 6A 00 50 8B 43 08 F7 E1 50 56 FF 33 E8 ?? ?? ?? ?? 48 58 59 75 1F 33 D2 F7 73 08 8B 54 24 0C 85 D2 74 07 89 02 5E 5B C2 04 00 3B C1 74 F7 B8 64 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB E2 B8 67 00 00 00 EB F0 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "@BlockWrite"
		size = 98
		refs = "0025 WriteFile 004e GetLastError 0053 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 8B F2 8B 40 04 2D B2 D7 00 00 83 F8 01 77 48 51 6A 00 8B C4 6A 00 50 8B 43 08 F7 E1 50 56 FF 33 E8 ?? ?? ?? ?? 48 58 59 75 1F 33 D2 F7 73 08 8B 54 24 0C 85 D2 74 07 89 02 5E 5B C2 04 00 3B C1 74 F7 B8 65 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB E2 B8 67 00 00 00 EB F0 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "@Close"
		size = 58
		refs = "0026 SetInOutRes 002d Input"
	strings:
		$1 = { 53 8B D8 8B 50 04 81 EA B1 D7 00 00 74 0E 83 FA 02 77 19 FF 50 1C 85 C0 75 0B 8B C3 FF 53 24 85 C0 75 02 5B C3 E8 ?? ?? ?? ?? EB F7 3D ?? ?? ?? ?? 74 F0 B8 67 00 00 00 EB EB }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "@EofFile"
		size = 81
		refs = "0016 GetFileSize 0029 SetFilePointer 003b InOutError 0049 SetInOutRes"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 32 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 1B 50 6A 01 6A 00 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 08 5A 3B C2 0F 93 C0 5B C3 E8 ?? ?? ?? ?? B0 01 EB F5 B8 67 00 00 00 E8 ?? ?? ?? ?? B0 FF EB E7 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "@EofText"
		size = 50
		refs = "0023 @ReadChar"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 18 8B 50 0C 3B 50 10 73 10 03 50 14 B0 00 8A 0A 80 F9 1A 74 01 C3 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 3C 1A 74 F2 FF 4A 0C B0 00 C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "@Eoln"
		size = 59
		refs = "0028 @ReadChar"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 1D 8B 50 0C 3B 50 10 73 15 03 50 14 B0 00 8A 0A 80 F9 0D 74 06 80 F9 1A 74 01 C3 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 3C 1A 74 F2 FF 4A 0C 3C 0D 74 EB B0 00 C3 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "@Erase"
		size = 46
		refs = "0013 DeleteFileA 001c GetLastError 0021 SetInOutRes"
	strings:
		$1 = { 8B 50 04 81 EA B0 D7 00 00 83 FA 03 77 19 8D 40 48 50 E8 ?? ?? ?? ?? 48 75 01 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F3 B8 66 00 00 00 EB F2 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "_DF_"
		size = 120
		refs = "0036 TestFDIV 0044 _DF_"
	strings:
		$1 = { 00 01 00 00 04 00 00 07 00 00 0A 00 00 0D 00 00 00 00 70 3F 00 00 88 3F 00 00 00 5F 00 00 00 C0 7E 01 50 41 00 00 00 80 FF FF 47 41 00 00 00 00 00 00 F0 3F C6 05 ?? ?? ?? ?? 01 50 83 EC 0C DB 3C 24 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? DC 1D ?? ?? ?? ?? 9B DF E0 C1 E8 07 83 E0 02 48 A2 ?? ?? ?? ?? DB 2C 24 83 C4 0C 58 EB 02 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "@FSafeDivide"
		size = 230
		refs = "0002 TestFDIV 0040 _DF_"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 7E 03 DE F9 C3 74 AC 50 83 EC 18 DB 7C 24 0C DB 3C 24 DB 2C 24 DB 6C 24 0C 8B 44 24 10 03 C0 73 63 35 00 00 00 0E A9 00 00 00 0E 74 07 DE F9 83 C4 18 58 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 74 ED 8B 44 24 14 25 FF 7F 00 00 74 E2 3D FF 7F 00 00 74 DB 8B 44 24 08 25 FF 7F 00 00 83 F8 01 74 12 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB BB D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB A9 8B 44 24 0C 0B 44 24 10 74 9F 8B 44 24 14 25 FF 7F 00 00 75 94 8B 44 24 08 25 FF 7F 00 00 74 15 3D FF 7F 00 00 74 82 8B 44 24 04 03 C0 0F 83 76 FF FF FF EB 0C 8B 44 24 04 03 C0 0F 82 68 FF FF FF D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 0C DB 2C 24 D9 C9 E9 3A FF FF FF }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "@FilePos"
		size = 67
		refs = "001a SetFilePointer 002b InOutError 003a SetInOutRes"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 23 6A 01 6A 00 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 07 33 D2 F7 73 08 5B C3 E8 ?? ?? ?? ?? 83 C8 FF EB F4 B8 67 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB E5 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "@FileSize"
		size = 63
		refs = "0016 GetFileSize 0027 InOutError 0036 SetInOutRes"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 1F 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 07 33 D2 F7 73 08 5B C3 E8 ?? ?? ?? ?? 83 C8 FF EB F4 B8 67 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB E5 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "@ReadRec"
		size = 74
		refs = "0021 ReadFile 0031 GetLastError 0036 SetInOutRes"
	strings:
		$1 = { 53 8B D8 8B 4B 04 81 E9 B1 D7 00 00 74 05 83 E9 02 75 29 6A 00 8B C4 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 07 3B 53 08 75 15 5B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F2 B8 67 00 00 00 EB F2 B8 64 00 00 00 EB EB }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "@ReadChar"
		size = 115
		refs = "0024 Input 0030 SetInOutRes 0038 @ResetText"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 1A 8B 50 0C 3B 50 10 73 3B 8B 48 14 8A 0C 11 80 F9 1A 74 04 42 89 50 0C 8A C1 C3 3D ?? ?? ?? ?? 74 0D B8 68 00 00 00 E8 ?? ?? ?? ?? B0 1A C3 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 81 78 04 B1 D7 00 00 74 BF EB DE 50 FF 50 1C 85 C0 75 16 58 8B 50 0C 3B 50 10 72 B4 8B 48 14 C6 04 11 1A FF 40 10 B0 1A C3 E8 ?? ?? ?? ?? 58 B0 1A C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "@ReadLong"
		size = 85
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValLong 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 8B F0 E8 ?? ?? ?? ?? FE C8 74 40 8B FC B3 20 8B C6 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 8B C4 52 8B D4 E8 ?? ?? ?? ?? 5A 85 D2 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 24 5F 5E 5B C3 3C 1A 74 D9 FF 4E 0C EB D4 33 C0 EB EC }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "@ReadString"
		size = 11
	strings:
		$1 = { 52 42 E8 10 00 00 00 5A 88 0A C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "@ReadCString"
		size = 138
		refs = "0056 @ReadChar 0068 Input 0074 SetInOutRes 007b @ResetText"
	strings:
		$1 = { 52 E8 06 00 00 00 5A C6 04 0A 00 C3 53 56 57 51 8B D8 8B F1 8B FA 81 7B 04 B1 D7 00 00 75 48 85 F6 7E 26 8B 53 0C 8B 4B 10 2B CA 03 53 14 49 7C 1F 8A 02 42 3C 1A 74 11 3C 0D 74 06 AA 4E 7F EE EB 01 4A 2B 53 14 89 53 0C 59 2B CE 5F 5E 5B C3 89 53 0C 8B C3 E8 ?? ?? ?? ?? 8B 53 0C 8B 4B 10 2B CA 03 53 14 EB CD 3D ?? ?? ?? ?? 74 0C B8 68 00 00 00 E8 ?? ?? ?? ?? EB CF E8 ?? ?? ?? ?? 81 7B 04 B1 D7 00 00 74 97 EB E4 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "@ReadExt"
		size = 85
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValExt 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 44 8B F0 E8 ?? ?? ?? ?? FE C8 74 40 8B FC B3 40 8B C6 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 8B C4 52 8B D4 E8 ?? ?? ?? ?? 5A 85 D2 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 44 5F 5E 5B C3 3C 1A 74 D9 FF 4E 0C EB D4 D9 EE EB EC }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "@ReadLn"
		size = 40
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 1A 74 18 3C 0D 75 F1 8B C3 E8 ?? ?? ?? ?? 3C 0A 74 07 3C 1A 74 05 FF 4B 0C 5B C3 5B C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "@Rename"
		size = 82
		refs = "000e @Rename 001a MoveFileA 0041 GetLastError 0046 SetInOutRes"
	strings:
		$1 = { 81 78 04 B0 D7 00 00 75 41 85 D2 75 05 BA ?? ?? ?? ?? 8D 40 48 52 50 52 50 E8 ?? ?? ?? ?? 48 58 5A 75 1D B5 82 8A 0A 42 88 08 40 84 C9 74 10 8A 0A 42 88 08 40 84 C9 74 06 FE CD 75 E8 88 28 C3 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? B8 66 00 00 00 EB F4 00 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "_DF_"
		size = 59
		refs = "0017 @Close 0028 SetInOutRes"
	strings:
		$1 = { 53 56 8B F0 8B DA 8B 56 04 81 EA B0 D7 00 00 74 0A 83 FA 03 77 19 E8 ?? ?? ?? ?? 8B C6 89 5E 04 FF 56 18 85 C0 74 05 E8 ?? ?? ?? ?? 5E 5B C3 B8 66 00 00 00 E8 ?? ?? ?? ?? EB F1 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "@ResetText"
		size = 7
	strings:
		$1 = { BA B1 D7 00 00 EB BE }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "@RewritText"
		size = 7
	strings:
		$1 = { BA B2 D7 00 00 EB B7 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "@Append"
		size = 7
	strings:
		$1 = { BA B3 D7 00 00 EB B0 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "_DF_"
		size = 257
		refs = "0025 SetInOutRes 0036 _DF_ 004e FileMode 009c CreateFileA 00c1 GetStdHandle 00d6 GetLastError"
	strings:
		$1 = { 53 56 57 8B D8 8B F2 8B F9 8B 53 04 81 EA B0 D7 00 00 74 15 83 FA 03 0F 87 AA 00 00 00 FF 53 24 85 C0 74 05 E8 ?? ?? ?? ?? C7 43 04 B3 D7 00 00 89 73 08 C7 43 24 ?? ?? ?? ?? C7 43 1C ?? ?? ?? ?? 80 7B 48 00 74 67 B8 00 00 00 C0 8A 15 ?? ?? ?? ?? 83 E2 70 C1 EA 02 8B 92 ?? ?? ?? ?? B9 02 00 00 00 83 EF 03 74 23 B9 03 00 00 00 47 74 1B B8 00 00 00 40 47 C7 43 04 B2 D7 00 00 74 0C B8 00 00 00 80 C7 43 04 B1 D7 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 43 48 50 E8 ?? ?? ?? ?? 83 F8 FF 74 29 89 03 5F 5E 5B C3 33 C0 C3 C7 43 24 ?? ?? ?? ?? 83 FF 03 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? EB D9 B8 66 00 00 00 EB 0C C7 43 04 B0 D7 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB C6 03 00 00 00 00 00 00 00 01 00 00 00 02 00 00 00 03 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "@ResetFile"
		size = 23
		refs = "0004 FileMode"
	strings:
		$1 = { 33 C9 8A 0D ?? ?? ?? ?? 80 E1 03 80 F9 02 76 02 B1 02 E9 E8 FE FF FF }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "@RewritFile"
		size = 32
		refs = "0014 CloseHandle 001b InOutError"
	strings:
		$1 = { B9 03 00 00 00 E9 DE FE FF FF FF 30 C7 40 04 B0 D7 00 00 E8 ?? ?? ?? ?? 48 0F 85 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "@Seek"
		size = 50
		refs = "001c SetFilePointer 0023 InOutError 002e SetInOutRes"
	strings:
		$1 = { 8B C8 8B 41 04 2D B1 D7 00 00 83 F8 02 77 19 6A 00 8B 41 08 F7 E2 6A 00 50 FF 31 E8 ?? ?? ?? ?? 40 0F 84 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "@SeekEof"
		size = 31
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 20 77 06 3C 1A 74 09 EB EF FF 4B 0C 5B B0 00 C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "@SeekEoln"
		size = 37
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 20 77 0C 3C 1A 74 0F 3C 0D 75 ED B0 01 EB 02 B0 00 FF 4B 0C 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "@SetTextBuf"
		size = 15
	strings:
		$1 = { 89 50 14 33 D2 89 48 08 89 50 0C 89 50 10 C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "@Truncate"
		size = 39
		refs = "0011 SetEndOfFile 0018 InOutError 0023 SetInOutRes"
	strings:
		$1 = { 8B 50 04 81 EA B1 D7 00 00 83 FA 02 77 0F FF 30 E8 ?? ?? ?? ?? 48 0F 85 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "@WriteRec"
		size = 73
		refs = "001e WriteFile 0030 GetLastError 0035 SetInOutRes"
	strings:
		$1 = { 53 8B D8 8B 40 04 2D B2 D7 00 00 83 F8 01 77 2B 6A 00 8B C4 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 09 3B 53 08 75 17 8B C3 5B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F0 B8 05 00 00 00 EB F2 B8 65 00 00 00 EB EB }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "@WriteBytes"
		size = 107
		refs = "003c Output 0046 @RewritText 005c SetInOutRes"
	strings:
		$1 = { 56 57 8B F2 81 78 04 B2 D7 00 00 75 2E 8B 78 14 03 78 0C 8B 50 08 2B 50 0C 3B D1 7F 16 01 50 0C 2B CA 50 51 8B CA F3 A4 FF 50 1C 85 C0 75 33 59 58 EB DA 01 48 0C F3 A4 5F 5E C3 3D ?? ?? ?? ?? 75 14 51 52 50 E8 ?? ?? ?? ?? 58 5A 59 81 78 04 B2 D7 00 00 74 B7 B8 69 00 00 00 E8 ?? ?? ?? ?? EB D6 E8 ?? ?? ?? ?? 59 58 EB CD }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "@WriteSpaces"
		size = 57
		refs = "0003 _DV_ 001c @GetTls 0022 InOutRes"
	strings:
		$1 = { 8B CA BA ?? ?? ?? ?? 83 F9 40 7E 21 83 E9 40 50 51 B9 40 00 00 00 E8 7A FF FF FF E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 0D 59 58 EB D5 85 C9 0F 8F 60 FF FF FF C3 59 58 C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "@Write0String"
		size = 10
	strings:
		$1 = { 33 C9 8A 0A 42 E9 52 FF FF FF }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "@WriteString"
		size = 29
	strings:
		$1 = { 53 33 DB 8A 1A 2B CB 7E 0B 50 52 8B D1 E8 AB FF FF FF 5A 58 8B CB 5B 42 E9 35 FF FF FF }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "@WriteLn"
		size = 20
		refs = "0001 _DV_ 0010 @Flush"
	strings:
		$1 = { BA ?? ?? ?? ?? B9 02 00 00 00 E8 26 FF FF FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "@Write0Char"
		size = 82
		refs = "0028 Output 0031 @RewritText 0046 SetInOutRes"
	strings:
		$1 = { 81 78 04 B2 D7 00 00 75 1E 8B 48 0C 3B 48 08 7D 09 03 48 14 88 11 FF 40 0C C3 50 52 FF 50 1C 85 C0 75 27 5A 58 EB E2 3D ?? ?? ?? ?? 75 12 52 50 E8 ?? ?? ?? ?? 58 5A 81 78 04 B2 D7 00 00 74 C9 B8 69 00 00 00 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "@WriteChar"
		size = 23
	strings:
		$1 = { 52 8D 51 FF E8 31 FF FF FF 8B D4 B9 01 00 00 00 E8 BA FE FF FF 5A C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "@Write0CString"
		size = 4
	strings:
		$1 = { 33 C9 EB 00 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "@WriteCString"
		size = 42
	strings:
		$1 = { 56 57 8B F0 51 8B FA 83 C9 FF B0 00 F2 AE F7 D1 49 8B FA 5A 2B D1 8B C6 51 E8 01 FF FF FF 59 8B C6 8B D7 5F 5E E9 8A FE FF FF }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "_DF_"
		size = 32
	strings:
		$1 = { 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 24 40 00 A0 D8 85 57 34 76 43 00 C8 4E 67 6D C1 AB 43 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "@Str0Ext"
		size = 12
	strings:
		$1 = { 8B C8 B8 17 00 00 00 83 CA FF EB 07 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "@Str1Ext"
		size = 7
	strings:
		$1 = { 8B CA 83 CA FF EB 00 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "@Str2Ext"
		size = 625
		refs = "00f8 _DF_ 0255 @Pow10"
	strings:
		$1 = { DB 6C 24 04 53 56 57 8B D8 8B F2 51 81 EC 00 01 00 00 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 D9 C0 DB 3C 24 33 C0 66 8B 44 24 08 8B F8 C1 EF 0F 66 25 FF 7F 66 3D FF 7F 0F 84 3E 01 00 00 D9 E1 85 F6 0F 8D A1 00 00 00 E8 DE 01 00 00 8B F3 83 EE 08 83 FE 02 7D 07 BE 02 00 00 00 EB 0A 83 FE 12 7E 05 BE 12 00 00 00 8B D4 50 8B C6 E8 4F 01 00 00 8B D7 8B BC 24 04 01 00 00 88 1F 47 B0 20 8B CB 2B CE 83 E9 08 7E 02 F3 AA 28 4F FF 84 D2 74 02 B0 2D AA 58 8B CE 8B F4 80 3E 30 74 02 40 4E 46 A4 C6 07 2E 47 49 F3 A4 C6 07 45 B1 2B 85 C0 7D 04 B1 2D F7 D8 88 4F 01 33 D2 66 B9 0A 00 66 F7 F1 80 C2 30 88 57 05 33 D2 66 F7 F1 80 C2 30 88 57 04 33 D2 66 F7 F1 80 C2 30 88 57 03 04 30 88 47 02 E9 86 00 00 00 81 FE D8 00 00 00 7E 05 BE D8 00 00 00 DC 15 ?? ?? ?? ?? 9B DF E0 9E B8 00 00 00 00 72 0E E8 1F 01 00 00 83 F8 23 0F 8F 38 FF FF FF 40 8B D4 50 03 C6 E8 A1 00 00 00 58 8B D6 8B F4 80 3E 30 74 02 40 4E 46 8B C8 03 CF 85 D2 74 09 41 03 CA 3B D9 7F 02 8B D9 50 57 8B BC 24 08 01 00 00 88 1F 47 2B D9 8B CB 7E 04 B0 20 F3 AA 28 4F FF 58 59 85 C0 74 04 C6 07 2D 47 F3 A4 85 D2 74 08 C6 07 2E 47 8B CA F3 A4 81 C4 00 01 00 00 59 5F 5E 5B C2 0C 00 DD D8 81 7C 24 04 00 00 00 80 BE ?? ?? ?? ?? 75 0D 4F BE ?? ?? ?? ?? 75 05 BE ?? ?? ?? ?? 8B F9 8B CB 88 0F 47 2A 0E 76 04 B0 20 F3 AA 28 4F FF 8A 0E 46 F3 A4 EB BC 03 4E 61 6E 04 2B 49 6E 66 04 2D 49 6E 66 57 8B FA 8B C8 83 EC 0A C6 07 30 DC 0D ?? ?? ?? ?? D9 FC DC 15 ?? ?? ?? ?? 9B DF E0 9E 72 09 DC 25 ?? ?? ?? ?? C6 07 31 DF 34 24 BA 08 00 00 00 47 9B 8A 04 14 8A E0 C0 E8 04 80 E4 0F 66 05 30 30 66 AB 4A 79 EB 83 E9 12 7C 06 B0 30 F3 AA EB 14 03 F9 80 3F 35 7C 0D 4F FE 07 80 3F 39 7E 05 C6 07 30 EB F3 83 C4 0A 5F C3 53 83 EC 0C 33 DB D9 C0 DB 3C 24 66 8B 44 24 08 66 85 C0 74 22 66 2D FF 3F 66 BA 10 4D 66 F7 EA 0F BF C2 F7 D8 74 09 2B D8 E8 ?? ?? ?? ?? EB D6 83 C4 0C 8B C3 5B C3 83 7C 24 04 00 75 D7 83 3C 24 00 75 D1 EB EA }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "@ValExt"
		size = 257
		refs = "0044 @ValExt 00d9 @Pow10"
	strings:
		$1 = { 53 56 57 8B F0 50 D9 EE 33 C0 33 DB 33 FF 53 85 F6 0F 84 DB 00 00 00 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C5 8A 1E 46 84 DB 0F 84 B9 00 00 00 80 EB 30 80 FB 09 77 18 DC 0D ?? ?? ?? ?? 89 1C 24 DA 04 24 8A 1E 46 84 DB 75 E5 EB 7D 90 90 90 80 FB FE 75 25 8A 1E 46 84 DB 74 6E 80 EB 30 80 FB 09 77 16 DC 0D ?? ?? ?? ?? 89 1C 24 DA 04 24 48 8A 1E 46 84 DB 75 E4 EB 50 80 FB 15 74 05 80 FB 35 75 65 8A 1E 46 B4 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C4 8A 1E 46 80 EB 30 80 FB 09 77 47 8B FB 8A 1E 46 84 DB 74 16 80 EB 30 80 FB 09 77 36 8D 3C BF 03 FF 03 FB 8A 1E 46 84 DB 75 EA FE CC 75 02 F7 DF 0F BE C0 03 C7 52 51 E8 ?? ?? ?? ?? 59 5A FE CD 74 0B 83 C4 08 33 F6 89 32 5F 5E 5B C3 D9 E0 EB F1 46 58 5B 2B F3 EB EF 00 00 00 00 00 00 24 40 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "FPower10"
		size = 724
		refs = "001c @Pow10"
	strings:
		$1 = { 85 C0 7C 48 74 45 3D 00 14 00 00 0F 8D 7F 00 00 00 8B D0 83 E2 1F 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE C9 C1 E8 05 74 24 8B D0 83 E2 0F 74 0C 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE C9 C1 E8 04 74 0C 8D 04 80 DB 2C 45 ?? ?? ?? ?? DE C9 C3 F7 D8 3D 00 14 00 00 7D 42 8B D0 83 E2 1F 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE F9 C1 E8 05 74 E0 8B D0 83 E2 0F 74 0C 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE F9 C1 E8 04 74 C8 8D 04 80 DB 2C 45 ?? ?? ?? ?? DE F9 C3 DB 2D ?? ?? ?? ?? C3 D9 EE C3 00 00 00 00 00 00 00 80 FF 7F 00 00 00 00 00 00 00 80 FF 3F 00 00 00 00 00 00 00 A0 02 40 00 00 00 00 00 00 00 C8 05 40 00 00 00 00 00 00 00 FA 08 40 00 00 00 00 00 00 40 9C 0C 40 00 00 00 00 00 00 50 C3 0F 40 00 00 00 00 00 00 24 F4 12 40 00 00 00 00 00 80 96 98 16 40 00 00 00 00 00 20 BC BE 19 40 00 00 00 00 00 28 6B EE 1C 40 00 00 00 00 00 F9 02 95 20 40 00 00 00 00 40 B7 43 BA 23 40 00 00 00 00 10 A5 D4 E8 26 40 00 00 00 00 2A E7 84 91 2A 40 00 00 00 80 F4 20 E6 B5 2D 40 00 00 00 A0 31 A9 5F E3 30 40 00 00 00 04 BF C9 1B 8E 34 40 00 00 00 C5 2E BC A2 B1 37 40 00 00 40 76 3A 6B 0B DE 3A 40 00 00 E8 89 04 23 C7 8A 3E 40 00 00 62 AC C5 EB 78 AD 41 40 00 80 7A 17 B7 26 D7 D8 44 40 00 90 AC 6E 32 78 86 87 48 40 00 B4 57 0A 3F 16 68 A9 4B 40 00 A1 ED CC CE 1B C2 D3 4E 40 A0 84 14 40 61 51 59 84 52 40 C8 A5 19 90 B9 A5 6F A5 55 40 3A 0F 20 F4 27 8F CB CE 58 40 84 09 94 F8 78 39 3F 81 5C 40 E5 0B B9 36 D7 07 8F A1 5F 40 DF 4E 67 04 CD C9 F2 C9 62 40 96 22 81 45 40 7C 6F FC 65 40 9E B5 70 2B A8 AD C5 9D 69 40 D5 A6 CF FF 49 1F 78 C2 D3 40 A3 14 9B C5 16 AB B3 EF 3D 41 E0 8C E9 80 C9 47 BA 93 A8 41 AA 17 E6 7F 2B A1 16 B6 12 42 6B 55 27 39 8D F7 70 E0 7C 42 30 C9 3C E3 FF 96 52 8A E7 42 8E DE F9 9D FB EB 7E AA 51 43 8C 2F 6A 5C 19 FC 26 D2 BB 43 76 E3 CC F2 29 2F 84 81 26 44 D2 0A 90 DB 00 27 A4 9F 90 44 17 AA F8 AE 10 E3 C5 C4 FA 44 59 9C B0 E9 07 9C 8A F2 64 45 D4 F3 F7 EB E1 4A 7A 95 CF 45 62 A2 95 07 DC D8 3E B8 39 46 C7 91 0E A6 AE A0 19 E3 A3 46 17 0C 75 81 86 75 76 C9 48 4D E4 A7 93 39 3B 35 B8 B2 ED 53 E5 5D 3D C5 5D 3B 8B 9E 92 5A A6 F0 A1 20 C0 54 A5 8C 37 61 8B 5A 8B D8 25 5D 89 F9 DB 67 F8 F3 27 BF A2 C8 5D DD 80 6E 9B 97 20 8A 02 52 60 C4 25 75 F0 59 D5 6E 62 11 35 AE CA 7B }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "@Real2Ext"
		size = 45
	strings:
		$1 = { 8A 70 05 80 E6 80 8A 10 84 D2 74 1E 66 81 C2 7E 3F 52 8B 50 02 81 CA 00 00 00 80 52 8A 50 01 C1 E2 18 52 DB 2C 24 83 C4 0C C3 D9 EE C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "@Ext2Real"
		size = 74
		refs = "0046 Error"
	strings:
		$1 = { 53 83 EC 0C DB 3C 24 5B 5A 59 C1 EB 18 80 D3 00 83 D2 00 66 83 D1 00 70 29 03 D2 66 03 C9 D1 DA 66 D1 E9 66 81 E9 7E 3F 7E 0E 84 ED 7F 14 88 08 88 58 01 89 50 02 5B C3 33 C9 89 08 66 89 48 04 5B C3 5B B0 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "@_llmul"
		size = 35
		altNames = "@_llmulo"
	strings:
		$1 = { 52 50 8B 44 24 10 F7 24 24 8B C8 8B 44 24 04 F7 64 24 0C 03 C8 8B 04 24 F7 64 24 0C 03 D1 59 59 C2 08 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "@_lldiv"
		size = 120
	strings:
		$1 = { 55 53 56 57 33 FF 8B 5C 24 14 8B 4C 24 18 0B C9 75 08 0B D2 74 5C 0B DB 74 58 0B D2 79 0A F7 DA F7 D8 83 DA 00 83 CF 01 0B C9 79 0A F7 D9 F7 DB 83 D9 00 83 F7 01 8B E9 B9 40 00 00 00 57 33 FF 33 F6 D1 E0 D1 D2 D1 D6 D1 D7 3B FD 72 0B 77 04 3B F3 72 05 2B F3 1B FD 40 E2 E7 5B F7 C3 01 00 00 00 74 07 F7 DA F7 D8 83 DA 00 5F 5E 5B 5D C2 08 00 F7 F3 33 D2 EB F3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "@_lldivo"
		size = 50
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 83 FE FF 75 11 8B F0 0B F2 81 FE 00 00 00 80 75 05 8B C6 5E 48 C3 5E FF 74 24 08 FF 74 24 08 E8 5B FF FF FF 23 C0 C2 08 00 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "@_lludiv"
		size = 73
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 0B C9 75 08 0B D2 74 2F 0B DB 74 2B 8B E9 B9 40 00 00 00 33 FF 33 F6 D1 E0 D1 D2 D1 D6 D1 D7 3B FD 72 0B 77 04 3B F3 72 05 2B F3 1B FD 40 E2 E7 5F 5E 5B 5D C2 08 00 F7 F3 33 D2 EB F3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "@_llmod"
		size = 122
	strings:
		$1 = { 55 53 56 57 33 FF 8B 5C 24 14 8B 4C 24 18 0B C9 75 08 0B D2 74 5D 0B DB 74 59 0B D2 79 0A F7 DA F7 D8 83 DA 00 83 CF 01 0B C9 79 07 F7 D9 F7 DB 83 D9 00 8B E9 B9 40 00 00 00 57 33 FF 33 F6 D1 E0 D1 D2 D1 D6 D1 D7 3B FD 72 0B 77 04 3B F3 72 05 2B F3 1B FD 40 E2 E7 8B C6 8B D7 5B F7 C3 01 00 00 00 74 07 F7 DA F7 D8 83 DA 00 5F 5E 5B 5D C2 08 00 F7 F3 92 33 D2 EB F2 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "@_llmodo"
		size = 50
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 83 FE FF 75 11 8B F0 0B F2 81 FE 00 00 00 80 75 05 8B C6 5E 48 C3 5E FF 74 24 08 FF 74 24 08 E8 59 FF FF FF 23 C0 C2 08 00 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "@_llumod"
		size = 78
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 0B C9 75 08 0B D2 74 33 0B DB 74 2F 8B E9 B9 40 00 00 00 33 FF 33 F6 D1 E0 D1 D2 D1 D6 D1 D7 3B FD 72 0B 77 04 3B F3 72 05 2B F3 1B FD 40 E2 E7 8B C6 8B D7 5F 5E 5B 5D C2 08 00 F7 F3 92 33 D2 EB F2 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "@_llshl"
		size = 56
	strings:
		$1 = { 80 F9 20 7C 11 80 F9 40 7C 05 33 D2 33 C0 C3 8B D0 D3 E2 33 C0 C3 0F A5 C2 D3 E0 C3 80 F9 20 7C 11 80 F9 40 7C 06 C1 FA 1F 8B C2 C3 8B C2 99 D3 F8 C3 0F AD D0 D3 FA C3 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "@_llushr"
		size = 28
	strings:
		$1 = { 80 F9 20 7C 11 80 F9 40 7C 05 33 D2 33 C0 C3 8B C2 33 D2 D3 E8 C3 0F AD D0 D3 EA C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "@ReadInt64"
		size = 85
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValInt64 003d SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 8B F0 E8 ?? ?? ?? ?? FE C8 74 40 8B FC B3 20 8B C6 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 8B C4 52 8B D4 E8 ?? ?? ?? ?? 59 85 C9 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 24 5F 5E 5B C3 3C 1A 74 D9 FF 4E 0C EB D4 33 C0 EB EC }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "Finalization"
		size = 103
		refs = "0007 Finalization 0013 _DV_3 001a Input 001f @Close 0024 Output 002e UninitAllocator 0033 EmptyParam 0038 @VarClr 003d Null 0047 Unassigned 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 37 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "System"
		size = 248
		refs = "0007 System 0013 _DV_3 0021 ExitCode 0028 ErrorAddr 002f RandSeed 0035 FileMode 003c Test8086 0043 Test8087 004b Unassigned 0054 Null 005d EmptyParam 006f ClearAnyProc 0073 VarInvalidOp 0079 ChangeAnyProc 007d VarCastError 0083 RefAnyProc 008c @isNECWindows 0095 @FpuMaskInit 009a @FpuInit 009f Input 00a9 @Assign 00ae Output 00bd GetCommandLine 00c2 CmdLine 00c7 GetCmdShow 00cc CmdShow 00d1 GetCurrentThreadId 00d6 MainThreadID 00e9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 0F 83 BC 00 00 00 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 C6 05 ?? ?? ?? ?? 02 C6 05 ?? ?? ?? ?? 03 66 C7 05 ?? ?? ?? ?? 00 00 66 C7 05 ?? ?? ?? ?? 01 00 66 C7 05 ?? ?? ?? ?? 0A 00 C7 05 ?? ?? ?? ?? 04 00 02 80 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}
